#
# Module for ESET Software NOD32 Client/Server mode
#
# Be careful, if daemon crash every mail will be quarantined!!! You
# can prevent that by changing ($errval != 0) to ($errval > 1) on line
# 64 in this file.
#

package AMAVIS::AV::NOD32cli;
use strict;

use vars qw($VERSION);
$VERSION='0.1';

use AMAVIS;
use AMAVIS::Logging;

use vars qw(
	    $cfg_nod32cli_binary
	    $cfg_chroot
	   );

sub init {
  my $self = shift;
  my $args = shift;
  push @{$$args{'virus_scanners'}}, 'NOD32 Client/Server Antivirus System';
  $cfg_nod32cli_binary = $AMAVIS::cfg->val('NOD32cli', 'nod32cli');
  $cfg_chroot = $AMAVIS::cfg->val('security','chroot') || "";
  if ($cfg_nod32cli_binary eq '') {
    writelog($args,LOG_CRIT, "Path to NOD32cli not specified");
    return 0;
  }
  if (! -x $cfg_chroot.$cfg_nod32cli_binary) {
    writelog($args,LOG_CRIT, "NOD32cli not executable");
    return 0;
  }
  writelog($args,LOG_DEBUG,__PACKAGE__." initialized.");
  # Return successfully
  return 1;
}

sub scan ( $ ) {
  my $self = shift;
  my $args = shift;

  my @output;

  my @nod32cli_args = ('-a','-r');

  my $output_handle = cmd_pipe($args, $cfg_nod32cli_binary, @nod32cli_args, 
			       "$$args{directory}/parts");

  writelog($args,LOG_DEBUG, "Begin output from $cfg_nod32cli_binary ".join(' ',@nod32cli_args)." $$args{directory}/parts");
  while( <$output_handle> ) {
    chomp;
    s/[\000-\037]*//g;
    writelog($args,LOG_DEBUG, $_);
    push @output, $_;
  }
  writelog($args,LOG_DEBUG, "End output from $cfg_nod32cli_binary\n");
  wait;

  my $errval = ($? >> 8);
  writelog($args,LOG_DEBUG,"Return code $errval");
  if ($errval != 0) {
    if ( ($errval == 10) || ($errval == 11) ) {
      my %uniq;
      foreach my $output (@output) {
        my $temp_dir = $$args{directory};
        if( $output =~ / infected: (.+)/g ) {
	  unless($uniq{$1}++) {
	    push @{$$args{'found_viruses'}{'NOD32 Client/Server Antivirus System'}}, $1;
	  }
	}
      }
    } else {
      if( $errval == 1 ) {
        writelog($args,LOG_ERR,"Virus scanner failure: $cfg_nod32cli_binary (No daemon running)");
      } elsif( $errval == 2 ) {
        writelog($args,LOG_ERR,"Virus scanner failure: $cfg_nod32cli_binary (Other execute problem)");
      } elsif( $errval == 12 ) {
        writelog($args,LOG_ERR,"Virus scanner failure: $cfg_nod32cli_binary (Error while scanning file)");
      } else {
        writelog($args,LOG_ERR,"Virus scanner failure: $cfg_nod32cli_binary (Unknown error code: $errval)");
      }
      # return ERROR
      return 0;
    }
  }

  # Return successfully
  return 1;
}

1;
