# $Id: FPROT.pm,v 1.3 2002/07/02 12:59:21 bengen Exp $

#
# Module for F-PROT Antivirus/Linux
#

package AMAVIS::AV::FPROT;
use strict;

use vars qw($VERSION);
$VERSION='0.1';

use AMAVIS;
use AMAVIS::Logging;

use vars qw(
	    $cfg_fprot_binary
	    $cfg_chroot
	   );

sub init {
  my $self = shift;
  my $args = shift;
  push @{$$args{'virus_scanners'}}, 'F-PROT Antivirus';
  $cfg_fprot_binary = $AMAVIS::cfg->val('FPROT', 'fprot');
  $cfg_chroot = $AMAVIS::cfg->val('security','chroot') || "";
  if ($cfg_fprot_binary eq '') {
    writelog($args,LOG_CRIT, "Path to FPROT not specified");
    return 0;
  }
  if (! -x $cfg_chroot.$cfg_fprot_binary) {
    writelog($args,LOG_CRIT, "FPROT ($cfg_fprot_binary) not executable");
    return 0;
  }
  writelog($args,LOG_DEBUG,__PACKAGE__." initialized.");
  # Return successfully
  return 1;
}

sub scan {
  my $self = shift;
  my $args = shift;

  my @output;

  writelog($args,LOG_DEBUG,"Scanning with FPROT");
  writelog($args,LOG_DEBUG,
	   "Output from $cfg_fprot_binary -dumb $$args{directory}/parts");
  my $output_handle = cmd_pipe($args,$cfg_fprot_binary, 
			       '-dumb', 
			       "$$args{directory}/parts");
  while(<$output_handle>) {
    chomp;
    s/[\000-\037]*//g;
    writelog($args,LOG_DEBUG,$_);
    push @output, $_;
  }
  writelog($args,LOG_DEBUG, "End output from $cfg_fprot_binary\n");
  wait;
  my $errval = ($? >> 8);
  writelog($args,LOG_DEBUG,"Return code $errval");
  if ($errval != 0) {
    if ($errval == 3 || $errval == 8) {
      my %uniq;
      foreach my $output (@output) {
	if ( $output =~ /Infection: (.+)/g ) {
	  unless($uniq{$1}++) {
	    push @{$$args{'found_viruses'}{'F-PROT Antivirus'}}, $1;
	  }
	}
      }
    } else {
      writelog($args,LOG_ERR,"Virus scanner failure: $cfg_fprot_binary (error code: $errval)");
      # return ERROR
      return 0;
    }
  }
  # Return successfully
  return 1;
}

1;
