# $Id: Panda.pm,v 1.5 2004/07/28 13:46:40 braeucup Exp $

#
# Support module for Panda Antivirus
#

package AMAVIS::AV::Panda;
use strict;

use vars qw($VERSION);
$VERSION='0.1';

use AMAVIS;
use AMAVIS::Logging;
use IO::Handle;

use vars qw(
	    $cfg_panda_binary
	    $cfg_chroot
	   );

sub init {
  my $self = shift;
  my $args = shift;
  push @{$$args{'virus_scanners'}}, 'Panda Software Antivirus';

  $cfg_panda_binary = $AMAVIS::cfg->val('Panda', 'panda');
  $cfg_chroot = $AMAVIS::cfg->val('security','chroot') || "";
  if ($cfg_panda_binary eq '') {
    writelog($args, LOG_CRIT, "Path to Panda not specified");
    return 0;
  }
  if (! -x $cfg_chroot.$cfg_panda_binary) {
    writelog($args, LOG_CRIT, "Panda not executable");
    return 0;
  }

  writelog($args, LOG_DEBUG,__PACKAGE__." initialized.\n");
  # Return successfully
  return 1;
}

# Called from AMAVIS.pm. Scanning takes place here.
sub scan {
  my $self = shift;
  my $args = shift;

  my @output;

  writelog($args, LOG_DEBUG,"Scanning with Panda");
  writelog($args, LOG_DEBUG,
	   "Output from ".join(' ',
			       $cfg_panda_binary, 
			       "$$args{directory}/parts", 
			       '-aut', '-eng', '-heu', '-nso',
			       '-aex', '-nor'));
  my $output_handle = cmd_pipe($args, $cfg_panda_binary, 
			       "$$args{directory}/parts", 
			       '-aut', '-eng', '-heu', '-nso',
			       '-aex', '-nor');
  my $numvirus=0;

  while(<$output_handle>) {
    chomp;
    s/^\s*(.*)\s*$/\1/g;
    push @output, $_;
    writelog($args, LOG_DEBUG, $_);
    if (/Number of files infected\.+:\s*(\d+)/) {
      $numvirus = $1;
      writelog($args, LOG_DEBUG, "GOT NUMBER: $numvirus");
    }
  }
  writelog($args, LOG_DEBUG, "End output from $cfg_panda_binary\n");
  wait;
  my $errval = ($? >> 8);
  writelog($args, LOG_DEBUG,"Return code $errval");
  if ($errval == 0) {
    if($numvirus > 0) {
      writelog($args, LOG_DEBUG, "Number of viruses found: $numvirus");
      my %uniq;
      foreach my $output (@output) {
	if ( $output =~ /Found virus\s+:\s*(.+)/ ) {
	  unless($uniq{$1}++) {
	    push @{$$args{'found_viruses'}{'Panda Software Antivirus'}}, $1;
	  }
	}
      }
    }
    else {
      return 1;
    }
  }
  else {
    writelog($args,LOG_ERR,
	     "Virus scanner failure: FIXME Some reason.");
    return 0;
  }
  return 1;
}

1;
