
var aios_mode, aios_prefstring, aios_sidebarItem, aios_boxElem, aios_managerWindow, aios_posElem, aios_checkInterval;

var aios_inSidebar = (top.document.getElementById('sidebar-box')) ? true : false;


function aios_init() {
	var loc = window.location.href;
    var enable_sidebar, enable_slim, enable_colors, enable_count, enable_sort, enable_layout, enable_layoutall, enable_tools;

	if(loc.indexOf('downloads.xul') > 0) {
		aios_mode = "downloads";
		aios_prefstring = "dm";
		aios_sidebarItem = "viewDownloadsSidebar";

        aios_boxElem = document.getElementById("downloadView");
		aios_managerWindow = document.getElementById("downloadManager");
		aios_posElem = document.getElementById("downloadView");
	}
	else if(loc.indexOf('extensions.xul') > 0) {
		aios_mode = "addons";
		aios_prefstring = "em";
		aios_sidebarItem = "viewAddonsSidebar";

		aios_boxElem = document.getElementById("extensionsView");
        aios_managerWindow = document.getElementById("extensionsManager");
		aios_posElem = document.getElementById("addonsMsg");

		// Ansicht falls ntig zum Installationspanel wechseln
        aios_checkInstall();
        aios_checkInterval = window.setInterval("aios_checkInstall()", 1000); 
        
        if(document.getElementById('restartAppButton')) document.getElementById('restartAppButton').hidden = true;
	}

	try {
		enable_sidebar = aios_gPrefBranch.getBoolPref(aios_prefstring + ".sidebar");
		enable_slim = aios_gPrefBranch.getBoolPref(aios_prefstring + ".slim");
		enable_colors = aios_gPrefBranch.getBoolPref(aios_prefstring + ".colors");
		enable_count = aios_gPrefBranch.getBoolPref(aios_prefstring + ".count");
		if(aios_mode != "addons") enable_sort = aios_gPrefBranch.getBoolPref(aios_prefstring + ".sort");
		enable_layout = aios_gPrefBranch.getBoolPref(aios_prefstring + ".layout");
		enable_layoutall = aios_gPrefBranch.getBoolPref(aios_prefstring + ".layoutall");
		enable_tools = aios_gPrefBranch.getBoolPref(aios_prefstring + ".tools");
	}
	catch(e) { return false; }

	// Fenster schlieen, wenn der Manager nur in der Sidebar geffnet werden soll
	// 	=> !top.document.getElementById('sidebar') => ich bin keine Sidebar
	// 	=> top.toString() != "[object Window]" => ich bin kein Tab
	if(!top.document.getElementById('sidebar') && top.toString() != "[object Window]") {
		// enable_sidebar => Manager soll in der Sidebar geffnet werden
		// !opener (!aios_WIN.aiosIsWindow) => nicht explizit im Fenster (z.B. durch Shift+Linksklick auf Toolbarbutton)
		// !aios_WIN.aiosIsWindow weil sonst das Fenster nicht geschlossen wrde,
		// wenn es durch Klick auf das "Downloads-Fertig-Popup" geffnet wurde

  	//if(enable_sidebar && !opener) {
		if(enable_sidebar && !aios_WIN.aiosIsWindow) {
			// wenn die Sidebar nicht schon geffnet ist (z.B. Aufruf durch MR Tech Local Install)
			// ohne diese Abfrage werden Erweiterungen u.U. doppelt installiert
			if(!aios_WIN.aios_getBoolean(aios_sidebarItem, 'checked')) aios_WIN.toggleSidebar(aios_sidebarItem, true);
			window.close();
		}
	}

	// Sidebar-Layout
	if((enable_layout && aios_inSidebar) || enable_layoutall) aios_sidebarLayout();
	
	// kompakte Ansicht
	if(enable_slim) aios_addCSS("chrome://aios/skin/_slimlist.css");

	// Titel setzen
	if(aios_mode == "addons") aios_setTitle();
	
	// Elemente zaehlen und anzeigen
	if(enable_count) aios_countList();

	// sortieren
	if(enable_sort && aios_mode != "addons") aios_sortExtensions();

	// farbige Eintrge
	if(enable_colors) aios_addCSS("chrome://aios/skin/_coloredlist.css");

	// Tools-Button anzeigen?
	if(document.getElementById('aios-toolsButton')) document.getElementById('aios-toolsButton').hidden = !enable_tools;
	if(document.getElementById('aios-toolsSpacer')) document.getElementById('aios-toolsSpacer').hidden = !enable_tools;

	
	if(aios_mode == "addons") {
        
        // Fix fr MR Tech Local Install
		if(typeof Local_Install == "object") {
			// Install-Button tauschen
			if(document.getElementById('installNewTheme')) {
				var commandBar = document.getElementById('commandBar');
				var aiosInstall = document.getElementById('aios-installButton');
				var mrtechInstall = document.getElementById('installNewTheme');
				commandBar.replaceChild(mrtechInstall, aiosInstall);
			}
			// Padding des Managers abschalten
			if((enable_layout && aios_inSidebar) || enable_layoutall)
				try { aios_gPref.setCharPref("local_install.viewPadding", ""); } catch(e) { }
		}
		
		// Homepages in neuen Tabs statt in neuen Fenstern ffnen
		var cmd = gExtensionsViewController.commands.cmd_homepage.toString();
		var newCmd = cmd.replace(/openURL\(uri\.spec\)/, 'aios_addTab(uri.spec)');
		eval('gExtensionsViewController.commands.cmd_homepage = ' + newCmd + ';');
	}
	
	// Icons im Kontextmen aktivieren
	var cmenu;
	if(aios_mode == "addons") cmenu = "addonContextMenu";
	else if(aios_mode == "downloads") cmenu = "downloadContextMenu";
	else cmenu = "extensionContextMenu";

	if(document.getElementById(cmenu)) {
		document.getElementById(cmenu).addEventListener("popupshowing", function(e) {

			var childs = document.getElementById(cmenu).childNodes;
			for(var i = 0; i < childs.length; i++) {
				if(childs[i].tagName == "menuitem") aios_appendClass(childs[i], 'menuitem-iconic');
			}

		}, false);
	}

	return true;
}


// Ansicht falls ntig zum Installationspanel wechseln
function aios_checkInstall() {
  if(aios_WIN) {
    if(aios_WIN.aiosSetAddOnsView) {
      if(aios_WIN.aiosSetAddOnsView == "installs") {
        window.clearInterval(aios_checkInterval);
        aios_WIN.aiosSetAddOnsView = null;
        showView('installs');
      }
    }
    else {
      aios_WIN.aiosSetAddOnsView = null;
    }
  }
}


function aios_setTitle(which) {
	if(typeof Local_Install == "object") return false;
	
	if(document.getElementById("restartAppButton")) {
	  var restartButton = document.getElementById("restartAppButton");
	  restartButton.hidden = true;
	  if(document.getElementById("installs-view").selected) restartButton.hidden = false;
	}
  
	if(!aios_WIN.document) return false;
	
	var newTitle;
	var origTitle = aios_WIN.document.getElementById(aios_sidebarItem).getAttribute('label');
	
	var viewTitle;
	
	// Label des zuknftigen Panels (ausgelst nur durch Klick auf Radio-Button)
	if(typeof which == "object") viewTitle = which.getAttribute('label');
	// Label des selektierten Radio-Buttons
	else if(document.getElementById("viewGroup").selectedItem) viewTitle = document.getElementById("viewGroup").selectedItem.getAttribute('label');

	newTitle = origTitle + " - " + viewTitle;
	
	// Titel und Label setzen
	document.title = newTitle;

	if(!top.document.getElementById('sidebar-title')) return false;
	top.document.getElementById('sidebar-title').setAttribute("value", newTitle);

	return true;
}


function aios_sidebarLayout() {
	// CSS fr Sidebar-Optimierungen aktivieren
	if(aios_mode == "addons") aios_addCSS("chrome://aios/skin/addons_layout.css");
	else if(aios_mode == "downloads") aios_addCSS("chrome://aios/skin/downloads_layout.css");
	
	
	// Toolbar nach oben versetzen
	if(aios_mode == "addons" || (aios_mode == "downloads" && aios_appVersion.indexOf('3.0') != 0)) {
  	var moveBar;
  	if(document.getElementById("commandBar")) moveBar = document.getElementById("commandBar");
  	if(document.getElementById("commandBarBottom")) moveBar = document.getElementById("commandBarBottom");
  	if(document.getElementById("search")) moveBar = document.getElementById("search");
	
  	moveBar = moveBar.parentNode;
  	aios_managerWindow.insertBefore(moveBar, aios_posElem);
	}
	
	
	if(aios_mode == "addons") {
	  // Radio-Buttons mit Tooltip
	  if(document.getElementById("viewGroup")) {
  		var radioChilds = document.getElementById("viewGroup").childNodes;
  		for(var i = 0; i < radioChilds.length; i++) {
  			if(radioChilds[i].tagName == "radio") radioChilds[i].setAttribute('tooltiptext', radioChilds[i].getAttribute('label'));
  		}
  	}
	  
		// Spacer lschen
		var cmdChilds = document.getElementById("commandBarBottom").childNodes;
		for(var i = 0; i < cmdChilds.length; i++) {
		    if(cmdChilds[i].tagName == "spacer" && cmdChilds[i].id != "aios-toolsSpacer") {
		        cmdChilds[i].parentNode.removeChild(cmdChilds[i]);
		    }
		}
		
		// Themes in der Sidebar
		if(parent.document.getElementById("sidebar-box")) {
		  // themePreviewArea scrollbar machen (FF <= 1.5)
			//aios_boxElem.setAttribute('flex', '1');
			//document.getElementById("themePreviewArea").setAttribute('flex', '1');
			
			document.getElementById("themePreviewArea").setAttribute('class', 'sidebar');
		}
	}
	else if(aios_mode == "downloads") {
		// Downloads in der Sidebar
		if(parent.document.getElementById("sidebar-box")) {
			if(document.getElementById("autodownloadInfo")) document.getElementById("autodownloadInfo").childNodes[1].hidden = true;
			if(document.getElementById("downloadFolder")) document.getElementById("downloadFolder").hidden = false;
			if(document.getElementById("saveToFolder")) document.getElementById("saveToFolder").removeAttribute('flex');
		}
	}
}


/*
	zhlt und zeigt die aktivierten und deaktivierten Extensions im Sidebartitel an
		=> Aufruf durch aios_init()
*/
function aios_countList() {

	if(!aios_WIN.document) return false;
	
	// Fix fuer MR Tech Local Install
	var li_count = false;
	
	if(typeof Local_Install == "object") {	
		var li_gPrefBranch = aios_gPref.getBranch("local_install.");
		li_count = li_gPrefBranch.getBoolPref("showManagerTotals");
		if(li_count) return false;
		else Local_Install.setWindowTitle = function(){};
	}
	
	// bisherigen Titel feststellen
	var newTitle;
	var origTitle = aios_WIN.document.getElementById(aios_sidebarItem).getAttribute('label');
	
	if(document.getElementById("viewGroup")) {
		var viewTitle = document.getElementById("viewGroup").selectedItem.getAttribute('label');
		origTitle = origTitle + " - " + viewTitle;
	}
	
	// Elemente zaehlen
	var whichNode;
    if(aios_mode == "downloads") whichNode = "download";
    if(aios_mode == "addons" || aios_appVersion.indexOf('3.0') == 0) whichNode = "richlistitem";
    
	var exts = aios_filter(aios_boxElem.childNodes, function(c){ return c.nodeName == whichNode });

	var str_count = "";

	// DOWNLOADS
	if(aios_mode == "downloads") {
		var list_downloading = 0;
		var list_done = 0;
		var list_failed = 0;

		for(var i = 0; i < exts.length; i++) {
			var state = exts[i].getAttribute('state');

			// downloading => starting + downloading + paused + downloading
			if(state == "-1" || state == "0" || state == "4" || state == "5") list_downloading++;

			// done => done
			if(state == "1") list_done++;

			// failed => failed + canceled
			if(state == "2" || state == "3") list_failed++;
		}

		str_count = list_done;
		if(list_downloading > 0 || list_failed > 0) str_count = str_count + "/" + list_downloading;
		if(list_failed > 0) str_count = str_count + "/" + list_failed;
	}
	// ADD-ONS
	else {
		var list_enabled = 0;
		var list_disabled = 0;
		
		for(i = 0; i < exts.length; i++) {
			if(exts[i].getAttribute('hidden') != "true") {
				if(exts[i].getAttribute('isDisabled') == "true") list_disabled++;
				else  list_enabled++;
			}
		}
		
		str_count = list_enabled;
		if(list_disabled > 0) str_count = str_count + "/" + list_disabled;
	}
	
	//return str_count;
	
	newTitle = origTitle + " [" + str_count + "]";
	window.setTimeout("aios_countList()", 100);
    
	// Titel und Label setzen
	document.title = newTitle;

	if(!top.document.getElementById('sidebar-title')) return false;
	top.document.getElementById('sidebar-title').setAttribute("value", newTitle);

	return true;
}


/*
	Original-Code by Caio Chassot
		Slim_Extension_List_0.1
		http://v2studio.com/k/moz/

		=> Aufruf durch aios_initExtThemesDwnl()/
*/
function aios_sortExtensions() {
	var whichNode = "extension";
	var sortBy = "name";

	if(aios_mode == "downloads") {
		whichNode = "download";
		sortBy = "target";
	}
	
	var exts = aios_filter(aios_boxElem.childNodes, function(c){ return c.nodeName == whichNode });

	exts.sort(function(a, b){
		var an = a.getAttribute(sortBy).toLowerCase();
		var bn = b.getAttribute(sortBy).toLowerCase();
		return an < bn ? -1 : an > bn ? 1 : 0;
	});

	aios_map(exts, function(e) { aios_boxElem.appendChild(e) });

	//window.setTimeout("aios_sortExtensions()", 500);
}


function aios_map(l,f) {
	var r = [];
	if(!f) f = function(v){return v};
	for(var i=0; i<l.length; i++) r.push(f(l[i]));
	return r;
}


function aios_filter(l,f) {
	var r = [];
	if (!f) f = function(v){return v};
	for (var i=0; i<l.length; i++) if (f(l[i])) r.push(l[i]);
	return r;
}



/*
	zeigt/versteckt Links im Extras-Men der Add-ons je nach Konfiguration
		=> Aufruf durch <menupopup> bei onpopupshowing
*/
var theLinks;	// wird auch fr <alle herunterladen> gebraucht
function aios_enableLinks(aPopup) {
    if(document.getElementById("restartAppButton")) {
    	var mitem_restart = document.getElementById("menuitem_restart");
    	mitem_restart.label = document.getElementById("restartAppButton").label;
    	mitem_restart.tooltiptext = document.getElementById("restartAppButton").tooltiptext;
    }
    
	// berhaupt Links anzeigen?
	try {
		var enable_links = aios_gPrefBranch.getBoolPref(aios_prefstring + ".link");
		var custom_links = aios_gPrefBranch.getCharPref(aios_prefstring + ".custom");
	}
    catch(e) { return false; }

	// vorkonfigurierte Links
	var defLinks;
	var strings = document.getElementById("aiosLibProp");
	defLinks = strings.getString("addons.def.links");

	// vorkonfigurierte oder benutzerdefinierte Links verwenden
	var tmpLinks = (!custom_links || defLinks == custom_links) ? defLinks : custom_links;
	theLinks = tmpLinks.split(",");

	for(var x = 0; x < theLinks.length; x++) {
		theLinks[x] = theLinks[x].replace(/\s*/, "");
	}

	// Links anzeigen
	//for(var i = 0; i < links.length; i++) {
    for(var i = 0; i < aPopup.childNodes.length; i++) {
		var mitemID = aPopup.childNodes[i].id;
        
        if(mitemID) {
    		// Aktivieren/Deaktivieren je nach Status verstecken/zeigen
    		var act = gExtensionsViewController.isCommandEnabled("cmd_reallyEnable");
    		if(mitemID == "menuitem_enable") aPopup.childNodes[i].setAttribute('hidden', !act);
    		if(mitemID == "menuitem_disable") aPopup.childNodes[i].setAttribute('hidden', act);
    
    		// Download-Links aktivieren
    		mitemID = mitemID.replace(/-mitem/, "");
    		
      	    if(aios_getBoolean(aPopup.childNodes[i], 'link')) {
      		    aPopup.childNodes[i].setAttribute('hidden', true);
      		    if(theLinks.indexOf(mitemID) >= 0 && enable_links) aPopup.childNodes[i].setAttribute('hidden', false);
      	    }
      	}
	}

	// wenn keine Links angezeigt werden, oberster Menpunkt (ffnet alle Links) und Separator verstecken
	document.getElementById("links-mitem").setAttribute('hidden', !enable_links);
	document.getElementById("link-separator").setAttribute('hidden', !enable_links);

	return true;
}


/*
	ffnet alle Links im Extras-Men der Add-ons
		=> Aufruf durch <menuitem> bei oncommand
		=> bentigt var theLinks => erzeugt in aios_enableLinks()
*/
function aios_openLinks(aMode) {
	// command ausfhren, wenn item nicht versteckt ist
	for(var i = 0; i < theLinks.length; i++) {
		var elem = document.getElementById(theLinks[i] + "-mitem");
		if(!elem.hidden) eval(elem.getAttribute('oncommand'));
	}
}


/*
	aktiviert/deaktiviert die Eintrge im Tools-Menu des Download-Managers
		=> Aufruf durch das <menupopup> bei onpopupshowing
*/
function aios_checkToolsMenu(aPopup) {

	var dis = (gDownloadsView.selectedItem == null || gDownloadsView.selectedItem.getAttribute("state") == "") ? true : false;

	if(typeof gDownloadsView.selectedItem != "object") {
		dis = (gDownloadsView.selected == null || gDownloadsView.selected.getAttribute("state") == "") ? true : false;
	}

	var folderLabel = document.getElementById('saveToFolder').getAttribute('label');
	var folderImage = document.getElementById('saveToFolder').image;

	for(var i = 0; i < aPopup.childNodes.length; i++) {
		var mitemID = aPopup.childNodes[i].id;

		if(mitemID == 'menuitem_open') aPopup.childNodes[i].setAttribute('disabled', dis);
		if(mitemID == 'menuitem_retry') aPopup.childNodes[i].setAttribute('disabled', dis);
		if(mitemID == 'menuitem_show') aPopup.childNodes[i].setAttribute('disabled', dis);
		if(mitemID == 'menuitem_remove') aPopup.childNodes[i].setAttribute('disabled', dis);
		if(mitemID == 'menuitem_properties') aPopup.childNodes[i].setAttribute('disabled', dis);

		if(mitemID == 'menuitem_Folder') {
			aPopup.childNodes[i].setAttribute('label', folderLabel);
			aPopup.childNodes[i].setAttribute('image', folderImage);

			// Menuitem fr "Default Download Folder" berhaupt sichtbar?
			aPopup.childNodes[i].setAttribute('hidden', folderImage == "");
		}
	}
}