# This module disables displaying of messages if sender's UIN is not in
# conact list and messages contains 'spam' words.
#
# Author: Ihar Viarheichyk

namespace eval meta {
	set author "Ihar Viarheichyk <iverg@mail.ru>"
	set name "Anti-Spam"
	set description "Block spam messages from UINs not in contact list"
	array set words {
	    type text save change
	    default {sex porn fuck teen hot {\$[0-9]+} XXX hardcore}
	    description "Words and regular expression which can indicate spam messages"
	}
	array set reply {
		type text save change
	        default "You are not in my contact list and sent me message which was considered as spam and rejected."
	        description "Reply which is sent to sender of 'spam' message"
	}
	array set log {}
}

handler Incoming BlockSpam {type uid time message args} {
	variable words
	variable reply
	variable log
	if {[info exists [ref $uid]]} return
	foreach word $words {
		if {[regexp -nocase $word $message]} {
			Event Send text $uid $reply
			if {![info exists log]} {
				set f [open $log a+]
				puts $f "From $uid at [clock format $time -format {%x %X}]\n$message\n---------------------"
				close $f
			}
			Event Log 8 "Spam blocked from $uid: $message"
			return -code break
		}
	}
} .1

