#include <stdio.h>
#include <time.h>
#include "ap.h"
// disable some irrelevant warnings
#if (AE_COMPILER==AE_MSVC)
#pragma warning(disable:4100)
#pragma warning(disable:4127)
#pragma warning(disable:4702)
#pragma warning(disable:4996)
#endif
#include "alglibinternal.h"
#include "alglibmisc.h"
#include "linalg.h"
#include "statistics.h"
#include "dataanalysis.h"
#include "specialfunctions.h"
#include "solvers.h"
#include "optimization.h"
#include "diffequations.h"
#include "fasttransforms.h"
#include "integration.h"
#include "interpolation.h"

using namespace alglib_impl;






ae_bool testhqrnd(ae_bool silent, ae_state *_state);
ae_bool _pexec_testhqrnd(ae_bool silent, ae_state *_state);


/*************************************************************************
Function for test HQRNDContinuous function
*************************************************************************/
ae_bool hqrndcontinuoustest(ae_bool silent, ae_state *_state);


/*************************************************************************
Function for test HQRNDContinuous function
*************************************************************************/
ae_bool hqrnddiscretetest(ae_bool silent, ae_state *_state);








/*************************************************************************
Testing tag sort
*************************************************************************/
ae_bool testtsort(ae_bool silent, ae_state *_state);
ae_bool _pexec_testtsort(ae_bool silent, ae_state *_state);








/*************************************************************************
Testing Nearest Neighbor Search
*************************************************************************/
ae_bool testnearestneighbor(ae_bool silent, ae_state *_state);
ae_bool _pexec_testnearestneighbor(ae_bool silent, ae_state *_state);








ae_bool testablas(ae_bool silent, ae_state *_state);
ae_bool _pexec_testablas(ae_bool silent, ae_state *_state);








ae_bool testbasestat(ae_bool silent, ae_state *_state);
ae_bool _pexec_testbasestat(ae_bool silent, ae_state *_state);








/*************************************************************************
Testing BDSS operations
*************************************************************************/
ae_bool testbdss(ae_bool silent, ae_state *_state);
ae_bool _pexec_testbdss(ae_bool silent, ae_state *_state);








ae_bool testblas(ae_bool silent, ae_state *_state);
ae_bool _pexec_testblas(ae_bool silent, ae_state *_state);








/*************************************************************************
Testing clustering
*************************************************************************/
ae_bool testclustering(ae_bool silent, ae_state *_state);
ae_bool _pexec_testclustering(ae_bool silent, ae_state *_state);








ae_bool testdforest(ae_bool silent, ae_state *_state);
ae_bool _pexec_testdforest(ae_bool silent, ae_state *_state);








ae_bool testgammafunc(ae_bool silent, ae_state *_state);
ae_bool _pexec_testgammafunc(ae_bool silent, ae_state *_state);








ae_bool testhblas(ae_bool silent, ae_state *_state);
ae_bool _pexec_testhblas(ae_bool silent, ae_state *_state);








ae_bool testreflections(ae_bool silent, ae_state *_state);
ae_bool _pexec_testreflections(ae_bool silent, ae_state *_state);








ae_bool testcreflections(ae_bool silent, ae_state *_state);
ae_bool _pexec_testcreflections(ae_bool silent, ae_state *_state);








ae_bool testsblas(ae_bool silent, ae_state *_state);
ae_bool _pexec_testsblas(ae_bool silent, ae_state *_state);








/*************************************************************************
Main unittest subroutine
*************************************************************************/
ae_bool testortfac(ae_bool silent, ae_state *_state);
ae_bool _pexec_testortfac(ae_bool silent, ae_state *_state);








/*************************************************************************
Testing bidiagonal SVD decomposition subroutine
*************************************************************************/
ae_bool testbdsvd(ae_bool silent, ae_state *_state);
ae_bool _pexec_testbdsvd(ae_bool silent, ae_state *_state);








/*************************************************************************
Testing SVD decomposition subroutine
*************************************************************************/
ae_bool testsvd(ae_bool silent, ae_state *_state);
ae_bool _pexec_testsvd(ae_bool silent, ae_state *_state);








ae_bool testlinreg(ae_bool silent, ae_state *_state);
ae_bool _pexec_testlinreg(ae_bool silent, ae_state *_state);








ae_bool testfilters(ae_bool silent, ae_state *_state);
ae_bool _pexec_testfilters(ae_bool silent, ae_state *_state);


/*************************************************************************
This function tests SMA(k) filter. It returns True on error.

Additional IsSilent parameter controls detailed error reporting.
*************************************************************************/
ae_bool testsma(ae_bool issilent, ae_state *_state);


/*************************************************************************
This function tests EMA(alpha) filter. It returns True on error.

Additional IsSilent parameter controls detailed error reporting.
*************************************************************************/
ae_bool testema(ae_bool issilent, ae_state *_state);


/*************************************************************************
This function tests LRMA(k) filter. It returns True on error.

Additional IsSilent parameter controls detailed error reporting.
*************************************************************************/
ae_bool testlrma(ae_bool issilent, ae_state *_state);








/*************************************************************************
Testing symmetric EVD subroutine
*************************************************************************/
ae_bool testevd(ae_bool silent, ae_state *_state);
ae_bool _pexec_testevd(ae_bool silent, ae_state *_state);








ae_bool testmatgen(ae_bool silent, ae_state *_state);
ae_bool _pexec_testmatgen(ae_bool silent, ae_state *_state);





typedef struct
{
    ae_int_t n;
    ae_int_t m;
    ae_int_t matkind;
    ae_int_t triangle;
    ae_matrix bufa;
    hqrndstate rs;
    rcommstate rcs;
} sparsegenerator;





ae_bool testsparse(ae_bool silent, ae_state *_state);
ae_bool _pexec_testsparse(ae_bool silent, ae_state *_state);


/*************************************************************************
Function for testing basic SKS functional.
Returns True on errors, False on success.

  -- ALGLIB PROJECT --
     Copyright 16.01.1014 by Bochkanov Sergey
*************************************************************************/
ae_bool skstest(ae_state *_state);


/*************************************************************************
Function for testing basic functional

  -- ALGLIB PROJECT --
     Copyright 14.10.2011 by Bochkanov Sergey
*************************************************************************/
ae_bool basicfunctest(ae_state *_state);


/*************************************************************************
Function for testing Level 2 unsymmetric linear algebra functions.
Additionally it tests SparseGet() for several matrix formats.
Returns True on failure.

  -- ALGLIB PROJECT --
     Copyright 20.01.2014 by Bochkanov Sergey
*************************************************************************/
ae_bool testlevel2unsymmetric(ae_state *_state);


/*************************************************************************
Function for testing Level 3 unsymmetric linear algebra functions.
Additionally it tests SparseGet() for several matrix formats.
Returns True on failure.

  -- ALGLIB PROJECT --
     Copyright 20.01.2014 by Bochkanov Sergey
*************************************************************************/
ae_bool testlevel3unsymmetric(ae_state *_state);


/*************************************************************************
Function for testing Level 2 symmetric linear algebra functions.
Additionally it tests SparseGet() for several matrix formats.
Returns True on failure.

  -- ALGLIB PROJECT --
     Copyright 20.01.2014 by Bochkanov Sergey
*************************************************************************/
ae_bool testlevel2symmetric(ae_state *_state);


/*************************************************************************
Function for testing Level 2 symmetric linear algebra functions.
Additionally it tests SparseGet() for several matrix formats.
Returns True on failure.

  -- ALGLIB PROJECT --
     Copyright 14.10.2011 by Bochkanov Sergey
*************************************************************************/
ae_bool testlevel3symmetric(ae_state *_state);


/*************************************************************************
Function for testing Level 2 triangular linear algebra functions.
Returns True on failure.

  -- ALGLIB PROJECT --
     Copyright 20.01.2014 by Bochkanov Sergey
*************************************************************************/
ae_bool testlevel2triangular(ae_state *_state);


/*************************************************************************
Function for testing basic functional

  -- ALGLIB PROJECT --
     Copyright 14.10.2011 by Bochkanov Sergey
*************************************************************************/
ae_bool basicfuncrandomtest(ae_state *_state);


/*************************************************************************
Function for testing multyplication matrix with vector

  -- ALGLIB PROJECT --
     Copyright 14.10.2011 by Bochkanov Sergey
*************************************************************************/
ae_bool linearfunctionstest(ae_state *_state);


/*************************************************************************
Function for testing multyplication for simmetric matrix with vector

  -- ALGLIB PROJECT --
     Copyright 14.10.2011 by Bochkanov Sergey
*************************************************************************/
ae_bool linearfunctionsstest(ae_state *_state);


/*************************************************************************
Function for testing multyplication sparse matrix with nerrow dense matrix

  -- ALGLIB PROJECT --
     Copyright 14.10.2011 by Bochkanov Sergey
*************************************************************************/
ae_bool linearfunctionsmmtest(ae_state *_state);


/*************************************************************************
Function for testing multyplication for simmetric sparse matrix with narrow
dense matrix

  -- ALGLIB PROJECT --
     Copyright 14.10.2011 by Bochkanov Sergey
*************************************************************************/
ae_bool linearfunctionssmmtest(ae_state *_state);


/*************************************************************************
Function for basic test SparseCopy

  -- ALGLIB PROJECT --
     Copyright 14.10.2011 by Bochkanov Sergey
*************************************************************************/
ae_bool basiccopyfunctest(ae_bool silent, ae_state *_state);


/*************************************************************************
Function for testing SparseCopy

  -- ALGLIB PROJECT --
     Copyright 14.10.2011 by Bochkanov Sergey
*************************************************************************/
ae_bool copyfunctest(ae_bool silent, ae_state *_state);
void _sparsegenerator_init(void* _p, ae_state *_state);
void _sparsegenerator_init_copy(void* _dst, void* _src, ae_state *_state);
void _sparsegenerator_clear(void* _p);
void _sparsegenerator_destroy(void* _p);








ae_bool testtrfac(ae_bool silent, ae_state *_state);
ae_bool _pexec_testtrfac(ae_bool silent, ae_state *_state);


/*************************************************************************
Function for testing sparse real Cholesky.
Returns True on errors, False on success.

  -- ALGLIB PROJECT --
     Copyright 16.01.1014 by Bochkanov Sergey
*************************************************************************/
ae_bool sparserealcholeskytest(ae_state *_state);








/*************************************************************************
Main unittest subroutine
*************************************************************************/
ae_bool testtrlinsolve(ae_bool silent, ae_state *_state);
ae_bool _pexec_testtrlinsolve(ae_bool silent, ae_state *_state);








/*************************************************************************
Main unittest subroutine
*************************************************************************/
ae_bool testsafesolve(ae_bool silent, ae_state *_state);
ae_bool _pexec_testsafesolve(ae_bool silent, ae_state *_state);








ae_bool testrcond(ae_bool silent, ae_state *_state);
ae_bool _pexec_testrcond(ae_bool silent, ae_state *_state);








/*************************************************************************
Test
*************************************************************************/
ae_bool testmatinv(ae_bool silent, ae_state *_state);
ae_bool _pexec_testmatinv(ae_bool silent, ae_state *_state);








ae_bool testlda(ae_bool silent, ae_state *_state);
ae_bool _pexec_testlda(ae_bool silent, ae_state *_state);








ae_bool testmlpbase(ae_bool silent, ae_state *_state);
ae_bool _pexec_testmlpbase(ae_bool silent, ae_state *_state);








ae_bool testxblas(ae_bool silent, ae_state *_state);
ae_bool _pexec_testxblas(ae_bool silent, ae_state *_state);








/*************************************************************************
Test
*************************************************************************/
ae_bool testdensesolver(ae_bool silent, ae_state *_state);
ae_bool _pexec_testdensesolver(ae_bool silent, ae_state *_state);








ae_bool testoptserv(ae_bool silent, ae_state *_state);
ae_bool _pexec_testoptserv(ae_bool silent, ae_state *_state);








/*************************************************************************
Testing
*************************************************************************/
ae_bool testfbls(ae_bool silent, ae_state *_state);
ae_bool _pexec_testfbls(ae_bool silent, ae_state *_state);








ae_bool testcqmodels(ae_bool silent, ae_state *_state);
ae_bool _pexec_testcqmodels(ae_bool silent, ae_state *_state);








ae_bool testsnnls(ae_bool silent, ae_state *_state);
ae_bool _pexec_testsnnls(ae_bool silent, ae_state *_state);








ae_bool testsactivesets(ae_bool silent, ae_state *_state);
ae_bool _pexec_testsactivesets(ae_bool silent, ae_state *_state);








ae_bool testlinmin(ae_bool silent, ae_state *_state);
ae_bool _pexec_testlinmin(ae_bool silent, ae_state *_state);








ae_bool testmincg(ae_bool silent, ae_state *_state);
ae_bool _pexec_testmincg(ae_bool silent, ae_state *_state);


/*************************************************************************
Other properties
*************************************************************************/
void testother(ae_bool* err, ae_state *_state);








ae_bool testminbleic(ae_bool silent, ae_state *_state);
ae_bool _pexec_testminbleic(ae_bool silent, ae_state *_state);








ae_bool testmcpd(ae_bool silent, ae_state *_state);
ae_bool _pexec_testmcpd(ae_bool silent, ae_state *_state);








ae_bool testmlpe(ae_bool silent, ae_state *_state);
ae_bool _pexec_testmlpe(ae_bool silent, ae_state *_state);








ae_bool testminlbfgs(ae_bool silent, ae_state *_state);
ae_bool _pexec_testminlbfgs(ae_bool silent, ae_state *_state);








ae_bool testmlptrain(ae_bool silent, ae_state *_state);
ae_bool _pexec_testmlptrain(ae_bool silent, ae_state *_state);








ae_bool testpca(ae_bool silent, ae_state *_state);
ae_bool _pexec_testpca(ae_bool silent, ae_state *_state);








/*************************************************************************
Test
*************************************************************************/
ae_bool testodesolver(ae_bool silent, ae_state *_state);
ae_bool _pexec_testodesolver(ae_bool silent, ae_state *_state);








/*************************************************************************
Test
*************************************************************************/
ae_bool testfft(ae_bool silent, ae_state *_state);
ae_bool _pexec_testfft(ae_bool silent, ae_state *_state);








/*************************************************************************
Test
*************************************************************************/
ae_bool testconv(ae_bool silent, ae_state *_state);
ae_bool _pexec_testconv(ae_bool silent, ae_state *_state);








/*************************************************************************
Test
*************************************************************************/
ae_bool testcorr(ae_bool silent, ae_state *_state);
ae_bool _pexec_testcorr(ae_bool silent, ae_state *_state);








/*************************************************************************
Test
*************************************************************************/
ae_bool testfht(ae_bool silent, ae_state *_state);
ae_bool _pexec_testfht(ae_bool silent, ae_state *_state);








/*************************************************************************
Test
*************************************************************************/
ae_bool testgq(ae_bool silent, ae_state *_state);
ae_bool _pexec_testgq(ae_bool silent, ae_state *_state);








/*************************************************************************
Test
*************************************************************************/
ae_bool testgkq(ae_bool silent, ae_state *_state);
ae_bool _pexec_testgkq(ae_bool silent, ae_state *_state);








/*************************************************************************
Test
*************************************************************************/
ae_bool testautogk(ae_bool silent, ae_state *_state);
ae_bool _pexec_testautogk(ae_bool silent, ae_state *_state);








/*************************************************************************
Testing IDW interpolation
*************************************************************************/
ae_bool testidwint(ae_bool silent, ae_state *_state);
ae_bool _pexec_testidwint(ae_bool silent, ae_state *_state);








ae_bool testratint(ae_bool silent, ae_state *_state);
ae_bool _pexec_testratint(ae_bool silent, ae_state *_state);








/*************************************************************************
Unit test
*************************************************************************/
ae_bool testpolint(ae_bool silent, ae_state *_state);
ae_bool _pexec_testpolint(ae_bool silent, ae_state *_state);








ae_bool testspline1d(ae_bool silent, ae_state *_state);
ae_bool _pexec_testspline1d(ae_bool silent, ae_state *_state);








ae_bool testnormestimator(ae_bool silent, ae_state *_state);
ae_bool _pexec_testnormestimator(ae_bool silent, ae_state *_state);








ae_bool testminqp(ae_bool silent, ae_state *_state);
ae_bool _pexec_testminqp(ae_bool silent, ae_state *_state);


/*************************************************************************
Function to test: 'MinQPCreate', 'MinQPSetQuadraticTerm', 'MinQPSetBC', 
'MinQPSetOrigin', 'MinQPSetStartingPoint', 'MinQPOptimize', 'MinQPResults'.

Test problem:
    A = diag(aii), aii>0 (random)
    b = 0
    random bounds (either no bounds, one bound, two bounds a<b, two bounds a=b)
    random start point
    dimension - from 1 to 5.
    
Returns True on success, False on failure.
*************************************************************************/
ae_bool simpletest(ae_state *_state);


/*************************************************************************
Function to test: 'MinQPCreate', 'MinQPSetLinearTerm', 'MinQPSetQuadraticTerm',
'MinQPSetOrigin', 'MinQPSetStartingPoint', 'MinQPOptimize', 'MinQPResults'.

Test problem:
    A = positive-definite matrix, obtained by 'SPDMatrixRndCond' function
    b <> 0
    without bounds
    random start point
    dimension - from 1 to 5.
*************************************************************************/
ae_bool functest1(ae_state *_state);


/*************************************************************************
Function to test: 'MinQPCreate', 'MinQPSetLinearTerm', 'MinQPSetQuadraticTerm',
'MinQPSetBC', 'MinQPSetOrigin', 'MinQPSetStartingPoint', 'MinQPOptimize', 
'MinQPResults'.

Test problem:
    A = positive-definite matrix, obtained by 'SPDMatrixRndCond' function
    b <> 0
    boundary constraints
    random start point
    dimension - from 1 to 5.
*************************************************************************/
ae_bool functest2(ae_state *_state);


/*************************************************************************
ConsoleTest.
*************************************************************************/
ae_bool consoletest(ae_state *_state);


/*************************************************************************
This function performs tests specific for Cholesky solver
    
Returns True on success, False on failure.
*************************************************************************/
ae_bool choleskytests(ae_state *_state);


/*************************************************************************
This function performs tests specific for QuickQP solver
    
Returns True on failure.
*************************************************************************/
ae_bool quickqptests(ae_state *_state);


/*************************************************************************
This function performs tests specific for BLEIC solver
    
Returns True on error, False on success.
*************************************************************************/
ae_bool bleictests(ae_state *_state);








ae_bool testminlm(ae_bool silent, ae_state *_state);
ae_bool _pexec_testminlm(ae_bool silent, ae_state *_state);








ae_bool testlsfit(ae_bool silent, ae_state *_state);
ae_bool _pexec_testlsfit(ae_bool silent, ae_state *_state);








ae_bool testparametric(ae_bool silent, ae_state *_state);
ae_bool _pexec_testparametric(ae_bool silent, ae_state *_state);








ae_bool testlinlsqr(ae_bool silent, ae_state *_state);
ae_bool _pexec_testlinlsqr(ae_bool silent, ae_state *_state);








ae_bool testrbf(ae_bool silent, ae_state *_state);
ae_bool _pexec_testrbf(ae_bool silent, ae_state *_state);


/*************************************************************************
The test  has  to  check, that  algorithm can solve problems of matrix are
degenerate.
    * used model with linear term;
    * points locate in a subspace of dimension less than an original space.

  -- ALGLIB --
     Copyright 13.12.2011 by Bochkanov Sergey
*************************************************************************/
ae_bool sqrdegmatrixrbftest(ae_bool silent, ae_state *_state);


/*************************************************************************
Function for testing basic functionality of RBF module on regular grids with
multi-layer algorithm in 1D.

  -- ALGLIB --
     Copyright 2.03.2012 by Bochkanov Sergey
*************************************************************************/
ae_bool basicmultilayerrbf1dtest(ae_state *_state);








ae_bool testspline2d(ae_bool silent, ae_state *_state);
ae_bool _pexec_testspline2d(ae_bool silent, ae_state *_state);








ae_bool testspline3d(ae_bool silence, ae_state *_state);
ae_bool _pexec_testspline3d(ae_bool silence, ae_state *_state);








/*************************************************************************
Testing bidiagonal SVD decomposition subroutine
*************************************************************************/
ae_bool testspdgevd(ae_bool silent, ae_state *_state);
ae_bool _pexec_testspdgevd(ae_bool silent, ae_state *_state);








ae_bool testinverseupdate(ae_bool silent, ae_state *_state);
ae_bool _pexec_testinverseupdate(ae_bool silent, ae_state *_state);








/*************************************************************************
Testing Schur decomposition subroutine
*************************************************************************/
ae_bool testschur(ae_bool silent, ae_state *_state);
ae_bool _pexec_testschur(ae_bool silent, ae_state *_state);








ae_bool testminnlc(ae_bool silent, ae_state *_state);
ae_bool _pexec_testminnlc(ae_bool silent, ae_state *_state);








ae_bool testlincg(ae_bool silent, ae_state *_state);
ae_bool _pexec_testlincg(ae_bool silent, ae_state *_state);








ae_bool testnleq(ae_bool silent, ae_state *_state);
ae_bool _pexec_testnleq(ae_bool silent, ae_state *_state);








/*************************************************************************
Test
*************************************************************************/
ae_bool testpolynomialsolver(ae_bool silent, ae_state *_state);
ae_bool _pexec_testpolynomialsolver(ae_bool silent, ae_state *_state);








ae_bool testchebyshev(ae_bool silent, ae_state *_state);
ae_bool _pexec_testchebyshev(ae_bool silent, ae_state *_state);








ae_bool testhermite(ae_bool silent, ae_state *_state);
ae_bool _pexec_testhermite(ae_bool silent, ae_state *_state);








ae_bool testlaguerre(ae_bool silent, ae_state *_state);
ae_bool _pexec_testlaguerre(ae_bool silent, ae_state *_state);








ae_bool testlegendre(ae_bool silent, ae_state *_state);
ae_bool _pexec_testlegendre(ae_bool silent, ae_state *_state);








ae_bool teststest(ae_bool silent, ae_state *_state);
ae_bool _pexec_teststest(ae_bool silent, ae_state *_state);








ae_bool teststudentttests(ae_bool silent, ae_state *_state);
ae_bool _pexec_teststudentttests(ae_bool silent, ae_state *_state);





typedef struct
{
    ae_bool bfield;
    double rfield;
    ae_int_t ifield;
    ae_complex cfield;
    ae_vector b1field;
    ae_vector r1field;
    ae_vector i1field;
    ae_vector c1field;
    ae_matrix b2field;
    ae_matrix r2field;
    ae_matrix i2field;
    ae_matrix c2field;
} rec1;


typedef struct
{
    ae_vector b;
    ae_vector i;
    ae_vector r;
} rec4serialization;


typedef struct
{
    ae_complex cval;
    double rval;
    ae_int_t ival;
    ae_bool bval;
    ae_vector i1val;
} poolrec1;


typedef struct
{
    ae_bool bval;
    poolrec1 recval;
    ae_shared_pool pool;
} poolrec2;


typedef struct
{
    ae_int_t val;
} poolsummand;





void rec4serializationalloc(ae_serializer* s,
     rec4serialization* v,
     ae_state *_state);


void rec4serializationserialize(ae_serializer* s,
     rec4serialization* v,
     ae_state *_state);


void rec4serializationunserialize(ae_serializer* s,
     rec4serialization* v,
     ae_state *_state);


ae_bool testalglibbasics(ae_bool silent, ae_state *_state);
ae_bool _pexec_testalglibbasics(ae_bool silent, ae_state *_state);
void _rec1_init(void* _p, ae_state *_state);
void _rec1_init_copy(void* _dst, void* _src, ae_state *_state);
void _rec1_clear(void* _p);
void _rec1_destroy(void* _p);
void _rec4serialization_init(void* _p, ae_state *_state);
void _rec4serialization_init_copy(void* _dst, void* _src, ae_state *_state);
void _rec4serialization_clear(void* _p);
void _rec4serialization_destroy(void* _p);
void _poolrec1_init(void* _p, ae_state *_state);
void _poolrec1_init_copy(void* _dst, void* _src, ae_state *_state);
void _poolrec1_clear(void* _p);
void _poolrec1_destroy(void* _p);
void _poolrec2_init(void* _p, ae_state *_state);
void _poolrec2_init_copy(void* _dst, void* _src, ae_state *_state);
void _poolrec2_clear(void* _p);
void _poolrec2_destroy(void* _p);
void _poolsummand_init(void* _p, ae_state *_state);
void _poolsummand_init_copy(void* _dst, void* _src, ae_state *_state);
void _poolsummand_clear(void* _p);
void _poolsummand_destroy(void* _p);




static void testhqrndunit_calculatemv(/* Real    */ ae_vector* x,
     ae_int_t n,
     double* mean,
     double* means,
     double* stddev,
     double* stddevs,
     ae_state *_state);
static void testhqrndunit_unsetstate(hqrndstate* state, ae_state *_state);





ae_bool testhqrnd(ae_bool silent, ae_state *_state)
{
    ae_frame _frame_block;
    ae_bool waserrors;
    ae_int_t samplesize;
    double sigmathreshold;
    ae_int_t passcount;
    ae_int_t n;
    ae_int_t i;
    ae_int_t k;
    ae_int_t pass;
    ae_int_t s1;
    ae_int_t s2;
    ae_int_t i1;
    ae_int_t i2;
    double r1;
    double r2;
    ae_vector x;
    ae_vector bins;
    double mean;
    double means;
    double stddev;
    double stddevs;
    double lambdav;
    ae_bool seederrors;
    ae_bool urerrors;
    double ursigmaerr;
    ae_bool uierrors;
    double uisigmaerr;
    ae_bool normerrors;
    double normsigmaerr;
    ae_bool unit2errors;
    ae_bool experrors;
    double expsigmaerr;
    ae_bool discreteerr;
    ae_bool continuouserr;
    hqrndstate state;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    ae_vector_init(&x, 0, DT_REAL, _state);
    ae_vector_init(&bins, 0, DT_INT, _state);
    _hqrndstate_init(&state, _state);

    waserrors = ae_false;
    sigmathreshold = (double)(7);
    samplesize = 100000;
    passcount = 50;
    seederrors = ae_false;
    urerrors = ae_false;
    uierrors = ae_false;
    normerrors = ae_false;
    experrors = ae_false;
    unit2errors = ae_false;
    ae_vector_set_length(&x, samplesize-1+1, _state);
    
    /*
     * Test seed errors
     */
    for(pass=1; pass<=passcount; pass++)
    {
        s1 = 1+ae_randominteger(32000, _state);
        s2 = 1+ae_randominteger(32000, _state);
        testhqrndunit_unsetstate(&state, _state);
        hqrndseed(s1, s2, &state, _state);
        i1 = hqrnduniformi(&state, 100, _state);
        testhqrndunit_unsetstate(&state, _state);
        hqrndseed(s1, s2, &state, _state);
        i2 = hqrnduniformi(&state, 100, _state);
        seederrors = seederrors||i1!=i2;
        testhqrndunit_unsetstate(&state, _state);
        hqrndseed(s1, s2, &state, _state);
        r1 = hqrnduniformr(&state, _state);
        testhqrndunit_unsetstate(&state, _state);
        hqrndseed(s1, s2, &state, _state);
        r2 = hqrnduniformr(&state, _state);
        seederrors = seederrors||ae_fp_neq(r1,r2);
    }
    
    /*
     * Test HQRNDRandomize() and real uniform generator
     */
    testhqrndunit_unsetstate(&state, _state);
    hqrndrandomize(&state, _state);
    ursigmaerr = (double)(0);
    for(i=0; i<=samplesize-1; i++)
    {
        x.ptr.p_double[i] = hqrnduniformr(&state, _state);
    }
    for(i=0; i<=samplesize-1; i++)
    {
        urerrors = (urerrors||ae_fp_less_eq(x.ptr.p_double[i],(double)(0)))||ae_fp_greater_eq(x.ptr.p_double[i],(double)(1));
    }
    testhqrndunit_calculatemv(&x, samplesize, &mean, &means, &stddev, &stddevs, _state);
    if( ae_fp_neq(means,(double)(0)) )
    {
        ursigmaerr = ae_maxreal(ursigmaerr, ae_fabs((mean-0.5)/means, _state), _state);
    }
    else
    {
        urerrors = ae_true;
    }
    if( ae_fp_neq(stddevs,(double)(0)) )
    {
        ursigmaerr = ae_maxreal(ursigmaerr, ae_fabs((stddev-ae_sqrt((double)1/(double)12, _state))/stddevs, _state), _state);
    }
    else
    {
        urerrors = ae_true;
    }
    urerrors = urerrors||ae_fp_greater(ursigmaerr,sigmathreshold);
    
    /*
     * Test HQRNDRandomize() and integer uniform
     */
    testhqrndunit_unsetstate(&state, _state);
    hqrndrandomize(&state, _state);
    uisigmaerr = (double)(0);
    for(n=2; n<=10; n++)
    {
        for(i=0; i<=samplesize-1; i++)
        {
            x.ptr.p_double[i] = (double)(hqrnduniformi(&state, n, _state));
        }
        for(i=0; i<=samplesize-1; i++)
        {
            uierrors = (uierrors||ae_fp_less(x.ptr.p_double[i],(double)(0)))||ae_fp_greater_eq(x.ptr.p_double[i],(double)(n));
        }
        testhqrndunit_calculatemv(&x, samplesize, &mean, &means, &stddev, &stddevs, _state);
        if( ae_fp_neq(means,(double)(0)) )
        {
            uisigmaerr = ae_maxreal(uisigmaerr, ae_fabs((mean-0.5*(n-1))/means, _state), _state);
        }
        else
        {
            uierrors = ae_true;
        }
        if( ae_fp_neq(stddevs,(double)(0)) )
        {
            uisigmaerr = ae_maxreal(uisigmaerr, ae_fabs((stddev-ae_sqrt((ae_sqr((double)(n), _state)-1)/12, _state))/stddevs, _state), _state);
        }
        else
        {
            uierrors = ae_true;
        }
    }
    uierrors = uierrors||ae_fp_greater(uisigmaerr,sigmathreshold);
    
    /*
     * Special 'close-to-limit' test on uniformity of integers
     * (straightforward implementation like 'RND mod N' will return
     *  non-uniform numbers for N=2/3*LIMIT)
     */
    testhqrndunit_unsetstate(&state, _state);
    hqrndrandomize(&state, _state);
    uisigmaerr = (double)(0);
    n = 1431655708;
    for(i=0; i<=samplesize-1; i++)
    {
        x.ptr.p_double[i] = (double)(hqrnduniformi(&state, n, _state));
    }
    for(i=0; i<=samplesize-1; i++)
    {
        uierrors = (uierrors||ae_fp_less(x.ptr.p_double[i],(double)(0)))||ae_fp_greater_eq(x.ptr.p_double[i],(double)(n));
    }
    testhqrndunit_calculatemv(&x, samplesize, &mean, &means, &stddev, &stddevs, _state);
    if( ae_fp_neq(means,(double)(0)) )
    {
        uisigmaerr = ae_maxreal(uisigmaerr, ae_fabs((mean-0.5*(n-1))/means, _state), _state);
    }
    else
    {
        uierrors = ae_true;
    }
    if( ae_fp_neq(stddevs,(double)(0)) )
    {
        uisigmaerr = ae_maxreal(uisigmaerr, ae_fabs((stddev-ae_sqrt((ae_sqr((double)(n), _state)-1)/12, _state))/stddevs, _state), _state);
    }
    else
    {
        uierrors = ae_true;
    }
    uierrors = uierrors||ae_fp_greater(uisigmaerr,sigmathreshold);
    
    /*
     * Test normal
     */
    testhqrndunit_unsetstate(&state, _state);
    hqrndrandomize(&state, _state);
    normsigmaerr = (double)(0);
    i = 0;
    while(i<samplesize)
    {
        hqrndnormal2(&state, &r1, &r2, _state);
        x.ptr.p_double[i] = r1;
        if( i+1<samplesize )
        {
            x.ptr.p_double[i+1] = r2;
        }
        i = i+2;
    }
    testhqrndunit_calculatemv(&x, samplesize, &mean, &means, &stddev, &stddevs, _state);
    if( ae_fp_neq(means,(double)(0)) )
    {
        normsigmaerr = ae_maxreal(normsigmaerr, ae_fabs((mean-0)/means, _state), _state);
    }
    else
    {
        normerrors = ae_true;
    }
    if( ae_fp_neq(stddevs,(double)(0)) )
    {
        normsigmaerr = ae_maxreal(normsigmaerr, ae_fabs((stddev-1)/stddevs, _state), _state);
    }
    else
    {
        normerrors = ae_true;
    }
    normerrors = normerrors||ae_fp_greater(normsigmaerr,sigmathreshold);
    
    /*
     * Test unit2
     */
    testhqrndunit_unsetstate(&state, _state);
    hqrndrandomize(&state, _state);
    n = 1000000;
    ae_vector_set_length(&bins, 10, _state);
    for(i=0; i<=bins.cnt-1; i++)
    {
        bins.ptr.p_int[i] = 0;
    }
    for(pass=0; pass<=n-1; pass++)
    {
        hqrndunit2(&state, &r1, &r2, _state);
        seterrorflag(&unit2errors, ae_fp_greater(ae_fabs(r1*r1+r2*r2-1, _state),100*ae_machineepsilon), _state);
        k = ae_ifloor((ae_atan2(r1, r2, _state)+ae_pi)/(2*ae_pi)*bins.cnt, _state);
        if( k<0 )
        {
            k = 0;
        }
        if( k>=bins.cnt )
        {
            k = bins.cnt-1;
        }
        bins.ptr.p_int[k] = bins.ptr.p_int[k]+1;
    }
    for(i=0; i<=bins.cnt-1; i++)
    {
        seterrorflag(&unit2errors, ae_fp_less((double)(bins.ptr.p_int[i]),0.9*n/bins.cnt)||ae_fp_greater((double)(bins.ptr.p_int[i]),1.1*n/bins.cnt), _state);
    }
    
    /*
     * Test exponential
     */
    testhqrndunit_unsetstate(&state, _state);
    hqrndrandomize(&state, _state);
    expsigmaerr = (double)(0);
    lambdav = 2+5*ae_randomreal(_state);
    for(i=0; i<=samplesize-1; i++)
    {
        x.ptr.p_double[i] = hqrndexponential(&state, lambdav, _state);
    }
    for(i=0; i<=samplesize-1; i++)
    {
        uierrors = uierrors||ae_fp_less(x.ptr.p_double[i],(double)(0));
    }
    testhqrndunit_calculatemv(&x, samplesize, &mean, &means, &stddev, &stddevs, _state);
    if( ae_fp_neq(means,(double)(0)) )
    {
        expsigmaerr = ae_maxreal(expsigmaerr, ae_fabs((mean-1.0/lambdav)/means, _state), _state);
    }
    else
    {
        experrors = ae_true;
    }
    if( ae_fp_neq(stddevs,(double)(0)) )
    {
        expsigmaerr = ae_maxreal(expsigmaerr, ae_fabs((stddev-1.0/lambdav)/stddevs, _state), _state);
    }
    else
    {
        experrors = ae_true;
    }
    experrors = experrors||ae_fp_greater(expsigmaerr,sigmathreshold);
    
    /*
     *Discrete/Continuous tests
     */
    discreteerr = hqrnddiscretetest(ae_true, _state);
    continuouserr = hqrndcontinuoustest(ae_true, _state);
    
    /*
     * Final report
     */
    waserrors = ((((((seederrors||urerrors)||uierrors)||normerrors)||unit2errors)||experrors)||discreteerr)||continuouserr;
    if( !silent )
    {
        printf("RNG TEST\n");
        printf("SEED TEST:                               ");
        if( !seederrors )
        {
            printf("OK\n");
        }
        else
        {
            printf("FAILED\n");
        }
        printf("UNIFORM CONTINUOUS:                      ");
        if( !urerrors )
        {
            printf("OK\n");
        }
        else
        {
            printf("FAILED\n");
        }
        printf("UNIFORM INTEGER:                         ");
        if( !uierrors )
        {
            printf("OK\n");
        }
        else
        {
            printf("FAILED\n");
        }
        printf("NORMAL:                                  ");
        if( !normerrors )
        {
            printf("OK\n");
        }
        else
        {
            printf("FAILED\n");
        }
        printf("UNIT2:                                   ");
        if( !unit2errors )
        {
            printf("OK\n");
        }
        else
        {
            printf("FAILED\n");
        }
        printf("EXPONENTIAL:                             ");
        if( !experrors )
        {
            printf("OK\n");
        }
        else
        {
            printf("FAILED\n");
        }
        printf("DISCRETE:                                ");
        if( !discreteerr )
        {
            printf("OK\n");
        }
        else
        {
            printf("FAILED\n");
        }
        printf("CONTINUOUS:                              ");
        if( !continuouserr )
        {
            printf("OK\n");
        }
        else
        {
            printf("FAILED\n");
        }
        if( waserrors )
        {
            printf("TEST SUMMARY: FAILED\n");
        }
        else
        {
            printf("TEST SUMMARY: PASSED\n");
        }
        printf("\n\n");
    }
    result = !waserrors;
    ae_frame_leave(_state);
    return result;
}


/*************************************************************************
Single-threaded stub. HPC ALGLIB replaces it by multithreaded code.
*************************************************************************/
ae_bool _pexec_testhqrnd(ae_bool silent, ae_state *_state)
{
    return testhqrnd(silent, _state);
}


/*************************************************************************
Function for test HQRNDContinuous function
*************************************************************************/
ae_bool hqrndcontinuoustest(ae_bool silent, ae_state *_state)
{
    ae_frame _frame_block;
    ae_vector sample;
    ae_vector bins;
    ae_vector binbounds;
    ae_int_t nb;
    ae_int_t samplesize;
    hqrndstate state;
    ae_int_t xp;
    ae_int_t i;
    ae_int_t j;
    double v;
    double sigma;
    double sigmamax;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    ae_vector_init(&sample, 0, DT_REAL, _state);
    ae_vector_init(&bins, 0, DT_INT, _state);
    ae_vector_init(&binbounds, 0, DT_REAL, _state);
    _hqrndstate_init(&state, _state);

    result = ae_false;
    
    /*
     * Test for sample size equal to 1
     */
    ae_vector_set_length(&sample, 1, _state);
    sample.ptr.p_double[0] = ae_randomreal(_state);
    hqrndrandomize(&state, _state);
    result = result||ae_fp_neq(hqrndcontinuous(&state, &sample, 1, _state),sample.ptr.p_double[0]);
    
    /*
     * Test for larger samples
     */
    xp = 100000;
    sigmamax = 10.0;
    for(samplesize=2; samplesize<=5; samplesize++)
    {
        
        /*
         * 1. Generate random sample with SampleSize points
         * 2. Generate NB=3*(SampleSize-1) bins, with bounds as prescribed by (BinBounds[I],BinBounds[I+1]).
         *    Bin bounds are generated in such a way that value can fall into any bin with same probability
         * 3. Generate many random values
         * 4. Calculate number of values which fall into each bin
         * 5. Bins[I] should have binomial distribution with mean XP/NB and 
         *    variance XP*(1/NB)*(1-1/NB)
         */
        nb = 3*(samplesize-1);
        sigma = ae_sqrt(xp*((double)1/(double)nb)*(1-(double)1/(double)nb), _state);
        ae_vector_set_length(&sample, samplesize, _state);
        sample.ptr.p_double[0] = 2*ae_randomreal(_state)-1;
        for(i=0; i<=samplesize-2; i++)
        {
            sample.ptr.p_double[i+1] = sample.ptr.p_double[i]+0.1+ae_randomreal(_state);
        }
        ae_vector_set_length(&bins, nb, _state);
        ae_vector_set_length(&binbounds, nb+1, _state);
        for(i=0; i<=samplesize-2; i++)
        {
            bins.ptr.p_int[3*i+0] = 0;
            bins.ptr.p_int[3*i+1] = 0;
            bins.ptr.p_int[3*i+2] = 0;
            binbounds.ptr.p_double[3*i+0] = sample.ptr.p_double[i];
            binbounds.ptr.p_double[3*i+1] = sample.ptr.p_double[i]+(sample.ptr.p_double[i+1]-sample.ptr.p_double[i])/3;
            binbounds.ptr.p_double[3*i+2] = sample.ptr.p_double[i]+(sample.ptr.p_double[i+1]-sample.ptr.p_double[i])*2/3;
        }
        binbounds.ptr.p_double[nb] = sample.ptr.p_double[samplesize-1];
        hqrndrandomize(&state, _state);
        for(i=0; i<=xp-1; i++)
        {
            v = hqrndcontinuous(&state, &sample, samplesize, _state);
            for(j=0; j<=nb-1; j++)
            {
                if( ae_fp_greater(v,binbounds.ptr.p_double[j])&&ae_fp_less(v,binbounds.ptr.p_double[j+1]) )
                {
                    bins.ptr.p_int[j] = bins.ptr.p_int[j]+1;
                    break;
                }
            }
        }
        for(i=0; i<=nb-1; i++)
        {
            result = result||ae_fp_greater(ae_fabs(bins.ptr.p_int[i]-(double)xp/(double)nb, _state),sigma*sigmamax);
        }
    }
    ae_frame_leave(_state);
    return result;
}


/*************************************************************************
Function for test HQRNDContinuous function
*************************************************************************/
ae_bool hqrnddiscretetest(ae_bool silent, ae_state *_state)
{
    ae_frame _frame_block;
    ae_vector sample;
    double sigma;
    double sigmathreshold;
    double tsample;
    double max;
    double min;
    ae_int_t i;
    ae_int_t j;
    ae_int_t s1;
    ae_int_t s2;
    ae_int_t binscount;
    ae_int_t xp;
    ae_vector nn;
    hqrndstate state;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    ae_vector_init(&sample, 0, DT_REAL, _state);
    ae_vector_init(&nn, 0, DT_INT, _state);
    _hqrndstate_init(&state, _state);

    
    /*
     * We test that all values from discrete sample are generated with same probability.
     * To do this, we generate random values many times, then we calculate actual probabilities
     * and compare them with theoretical ones.
     */
    max = (double)(100);
    min = (double)(-100);
    xp = 100000;
    sigmathreshold = 10.0;
    for(binscount=1; binscount<=5; binscount++)
    {
        sigma = ae_sqrt(xp*((double)1/(double)binscount)*(1-(double)1/(double)binscount), _state);
        ae_vector_set_length(&nn, binscount, _state);
        for(i=0; i<=binscount-1; i++)
        {
            nn.ptr.p_int[i] = 0;
        }
        ae_vector_set_length(&sample, binscount, _state);
        sample.ptr.p_double[0] = (max-min)*ae_randomreal(_state)+min;
        for(i=1; i<=binscount-1; i++)
        {
            sample.ptr.p_double[i] = sample.ptr.p_double[i-1]+max*ae_randomreal(_state)+0.001;
        }
        s1 = 1+ae_randominteger(32000, _state);
        s2 = 1+ae_randominteger(32000, _state);
        hqrndseed(s1, s2, &state, _state);
        for(i=0; i<=xp-1; i++)
        {
            tsample = hqrnddiscrete(&state, &sample, binscount, _state);
            for(j=0; j<=binscount-1; j++)
            {
                if( ae_fp_eq(tsample,sample.ptr.p_double[j]) )
                {
                    nn.ptr.p_int[j] = nn.ptr.p_int[j]+1;
                    break;
                }
            }
        }
        for(i=0; i<=binscount-1; i++)
        {
            if( ae_fp_less((double)(nn.ptr.p_int[i]),(double)xp/(double)binscount-sigmathreshold*sigma)||ae_fp_greater((double)(nn.ptr.p_int[i]),(double)xp/(double)binscount+sigmathreshold*sigma) )
            {
                if( !silent )
                {
                    printf("HQRNDDiscreteTest::ErrorReport::\n");
                    printf("nn[%0d]=%0d;\n   xp/BinsCount=%0.5f;\n   C*sigma=%0.5f\n",
                        (int)(i),
                        (int)(nn.ptr.p_int[i]),
                        (double)((double)xp/(double)binscount),
                        (double)(sigmathreshold*sigma));
                    printf("HQRNDDiscreteTest: test is FAILED!\n");
                }
                result = ae_true;
                ae_frame_leave(_state);
                return result;
            }
        }
        if( !silent )
        {
            printf("HQRNDDiscreteTest: test is OK.\n");
        }
    }
    result = ae_false;
    ae_frame_leave(_state);
    return result;
}


static void testhqrndunit_calculatemv(/* Real    */ ae_vector* x,
     ae_int_t n,
     double* mean,
     double* means,
     double* stddev,
     double* stddevs,
     ae_state *_state)
{
    ae_int_t i;
    double v1;
    double v2;
    double variance;

    *mean = 0;
    *means = 0;
    *stddev = 0;
    *stddevs = 0;

    *mean = (double)(0);
    *means = (double)(1);
    *stddev = (double)(0);
    *stddevs = (double)(1);
    variance = (double)(0);
    if( n<=1 )
    {
        return;
    }
    
    /*
     * Mean
     */
    for(i=0; i<=n-1; i++)
    {
        *mean = *mean+x->ptr.p_double[i];
    }
    *mean = *mean/n;
    
    /*
     * Variance (using corrected two-pass algorithm)
     */
    if( n!=1 )
    {
        v1 = (double)(0);
        for(i=0; i<=n-1; i++)
        {
            v1 = v1+ae_sqr(x->ptr.p_double[i]-(*mean), _state);
        }
        v2 = (double)(0);
        for(i=0; i<=n-1; i++)
        {
            v2 = v2+(x->ptr.p_double[i]-(*mean));
        }
        v2 = ae_sqr(v2, _state)/n;
        variance = (v1-v2)/(n-1);
        if( ae_fp_less(variance,(double)(0)) )
        {
            variance = (double)(0);
        }
        *stddev = ae_sqrt(variance, _state);
    }
    
    /*
     * Errors
     */
    *means = *stddev/ae_sqrt((double)(n), _state);
    *stddevs = *stddev*ae_sqrt((double)(2), _state)/ae_sqrt((double)(n-1), _state);
}


/*************************************************************************
Unsets HQRNDState structure
*************************************************************************/
static void testhqrndunit_unsetstate(hqrndstate* state, ae_state *_state)
{


    state->s1 = 0;
    state->s2 = 0;
    state->magicv = 0;
}



static void testtsortunit_unset2d(/* Complex */ ae_matrix* a,
     ae_state *_state);
static void testtsortunit_unset1d(/* Real    */ ae_vector* a,
     ae_state *_state);
static void testtsortunit_unset1di(/* Integer */ ae_vector* a,
     ae_state *_state);
static void testtsortunit_testsortresults(/* Real    */ ae_vector* asorted,
     /* Integer */ ae_vector* p1,
     /* Integer */ ae_vector* p2,
     /* Real    */ ae_vector* aoriginal,
     ae_int_t n,
     ae_bool* waserrors,
     ae_state *_state);





/*************************************************************************
Testing tag sort
*************************************************************************/
ae_bool testtsort(ae_bool silent, ae_state *_state)
{
    ae_frame _frame_block;
    ae_bool waserrors;
    ae_int_t n;
    ae_int_t i;
    ae_int_t m;
    ae_int_t offs;
    ae_int_t pass;
    ae_int_t passcount;
    ae_int_t maxn;
    ae_vector a;
    ae_vector a0;
    ae_vector a1;
    ae_vector a2;
    ae_vector a3;
    ae_vector i1;
    ae_vector i2;
    ae_vector i3;
    ae_vector a4;
    ae_vector pa4;
    ae_vector ar;
    ae_vector ar2;
    ae_vector ai;
    ae_vector p1;
    ae_vector p2;
    ae_vector bufr1;
    ae_vector bufr2;
    ae_vector bufi1;
    ae_bool distinctvals;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    ae_vector_init(&a, 0, DT_REAL, _state);
    ae_vector_init(&a0, 0, DT_REAL, _state);
    ae_vector_init(&a1, 0, DT_REAL, _state);
    ae_vector_init(&a2, 0, DT_REAL, _state);
    ae_vector_init(&a3, 0, DT_REAL, _state);
    ae_vector_init(&i1, 0, DT_INT, _state);
    ae_vector_init(&i2, 0, DT_INT, _state);
    ae_vector_init(&i3, 0, DT_INT, _state);
    ae_vector_init(&a4, 0, DT_INT, _state);
    ae_vector_init(&pa4, 0, DT_INT, _state);
    ae_vector_init(&ar, 0, DT_REAL, _state);
    ae_vector_init(&ar2, 0, DT_REAL, _state);
    ae_vector_init(&ai, 0, DT_INT, _state);
    ae_vector_init(&p1, 0, DT_INT, _state);
    ae_vector_init(&p2, 0, DT_INT, _state);
    ae_vector_init(&bufr1, 0, DT_REAL, _state);
    ae_vector_init(&bufr2, 0, DT_REAL, _state);
    ae_vector_init(&bufi1, 0, DT_INT, _state);

    waserrors = ae_false;
    maxn = 100;
    passcount = 10;
    
    /*
     * Test tagsort
     */
    for(n=1; n<=maxn; n++)
    {
        for(pass=1; pass<=passcount; pass++)
        {
            
            /*
             * Pprobably distinct sort:
             * * generate array of integer random numbers.
             *   Because of birthday paradox, random numbers have to be VERY large
             *   in order to avoid situation when we have distinct values.
             * * sort A0 using TagSort and test sort results
             * * now we can use A0 as reference point and test other functions
             */
            testtsortunit_unset1di(&p1, _state);
            testtsortunit_unset1di(&p2, _state);
            ae_vector_set_length(&a, n, _state);
            ae_vector_set_length(&a0, n, _state);
            ae_vector_set_length(&a1, n, _state);
            ae_vector_set_length(&a2, n, _state);
            ae_vector_set_length(&a3, n, _state);
            ae_vector_set_length(&a4, n, _state);
            ae_vector_set_length(&ar, n, _state);
            ae_vector_set_length(&ar2, n, _state);
            ae_vector_set_length(&ai, n, _state);
            for(i=0; i<=n-1; i++)
            {
                a.ptr.p_double[i] = (double)(ae_randominteger(100000000, _state));
                a0.ptr.p_double[i] = a.ptr.p_double[i];
                a1.ptr.p_double[i] = a.ptr.p_double[i];
                a2.ptr.p_double[i] = a.ptr.p_double[i];
                a3.ptr.p_double[i] = a.ptr.p_double[i];
                a4.ptr.p_int[i] = ae_round(a.ptr.p_double[i], _state);
                ar.ptr.p_double[i] = (double)(i);
                ar2.ptr.p_double[i] = (double)(i);
                ai.ptr.p_int[i] = i;
            }
            tagsort(&a0, n, &p1, &p2, _state);
            testtsortunit_testsortresults(&a0, &p1, &p2, &a, n, &waserrors, _state);
            distinctvals = ae_true;
            for(i=1; i<=n-1; i++)
            {
                distinctvals = distinctvals&&ae_fp_neq(a0.ptr.p_double[i],a0.ptr.p_double[i-1]);
            }
            if( distinctvals )
            {
                tagsortfasti(&a1, &ai, &bufr1, &bufi1, n, _state);
                for(i=0; i<=n-1; i++)
                {
                    waserrors = (waserrors||ae_fp_neq(a1.ptr.p_double[i],a0.ptr.p_double[i]))||ai.ptr.p_int[i]!=p1.ptr.p_int[i];
                }
                tagsortfastr(&a2, &ar, &bufr1, &bufr2, n, _state);
                for(i=0; i<=n-1; i++)
                {
                    waserrors = (waserrors||ae_fp_neq(a2.ptr.p_double[i],a0.ptr.p_double[i]))||ae_fp_neq(ar.ptr.p_double[i],(double)(p1.ptr.p_int[i]));
                }
                tagsortfast(&a3, &bufr1, n, _state);
                for(i=0; i<=n-1; i++)
                {
                    waserrors = waserrors||ae_fp_neq(a3.ptr.p_double[i],a0.ptr.p_double[i]);
                }
                tagsortmiddleir(&a4, &ar2, 0, n, _state);
                for(i=0; i<=n-1; i++)
                {
                    waserrors = (waserrors||ae_fp_neq((double)(a4.ptr.p_int[i]),a0.ptr.p_double[i]))||ae_fp_neq(ar2.ptr.p_double[i],(double)(p1.ptr.p_int[i]));
                }
            }
            
            /*
             * Non-distinct sort.
             * We test that keys are correctly reordered, but do NOT test order of values.
             */
            testtsortunit_unset1di(&p1, _state);
            testtsortunit_unset1di(&p2, _state);
            ae_vector_set_length(&a, n, _state);
            ae_vector_set_length(&a0, n, _state);
            ae_vector_set_length(&a1, n, _state);
            ae_vector_set_length(&a2, n, _state);
            ae_vector_set_length(&a3, n, _state);
            ae_vector_set_length(&a4, n, _state);
            ae_vector_set_length(&ar, n, _state);
            ae_vector_set_length(&ar2, n, _state);
            ae_vector_set_length(&ai, n, _state);
            for(i=0; i<=n-1; i++)
            {
                a.ptr.p_double[i] = (double)((n-i)/2);
                a0.ptr.p_double[i] = a.ptr.p_double[i];
                a1.ptr.p_double[i] = a.ptr.p_double[i];
                a2.ptr.p_double[i] = a.ptr.p_double[i];
                a3.ptr.p_double[i] = a.ptr.p_double[i];
                a4.ptr.p_int[i] = ae_round(a.ptr.p_double[i], _state);
                ar.ptr.p_double[i] = (double)(i);
                ar2.ptr.p_double[i] = (double)(i);
                ai.ptr.p_int[i] = i;
            }
            tagsort(&a0, n, &p1, &p2, _state);
            testtsortunit_testsortresults(&a0, &p1, &p2, &a, n, &waserrors, _state);
            tagsortfasti(&a1, &ai, &bufr1, &bufi1, n, _state);
            for(i=0; i<=n-1; i++)
            {
                waserrors = waserrors||ae_fp_neq(a1.ptr.p_double[i],a0.ptr.p_double[i]);
            }
            tagsortfastr(&a2, &ar, &bufr1, &bufr2, n, _state);
            for(i=0; i<=n-1; i++)
            {
                waserrors = waserrors||ae_fp_neq(a2.ptr.p_double[i],a0.ptr.p_double[i]);
            }
            tagsortfast(&a3, &bufr1, n, _state);
            for(i=0; i<=n-1; i++)
            {
                waserrors = waserrors||ae_fp_neq(a3.ptr.p_double[i],a0.ptr.p_double[i]);
            }
            tagsortmiddleir(&a4, &ar2, 0, n, _state);
            for(i=0; i<=n-1; i++)
            {
                waserrors = waserrors||ae_fp_neq((double)(a4.ptr.p_int[i]),a0.ptr.p_double[i]);
            }
            
            /*
             * 'All same' sort
             * We test that keys are correctly reordered, but do NOT test order of values.
             */
            testtsortunit_unset1di(&p1, _state);
            testtsortunit_unset1di(&p2, _state);
            ae_vector_set_length(&a, n, _state);
            ae_vector_set_length(&a0, n, _state);
            ae_vector_set_length(&a1, n, _state);
            ae_vector_set_length(&a2, n, _state);
            ae_vector_set_length(&a3, n, _state);
            ae_vector_set_length(&a4, n, _state);
            ae_vector_set_length(&ar, n, _state);
            ae_vector_set_length(&ar2, n, _state);
            ae_vector_set_length(&ai, n, _state);
            for(i=0; i<=n-1; i++)
            {
                a.ptr.p_double[i] = (double)(0);
                a0.ptr.p_double[i] = a.ptr.p_double[i];
                a1.ptr.p_double[i] = a.ptr.p_double[i];
                a2.ptr.p_double[i] = a.ptr.p_double[i];
                a3.ptr.p_double[i] = a.ptr.p_double[i];
                a4.ptr.p_int[i] = ae_round(a.ptr.p_double[i], _state);
                ar.ptr.p_double[i] = (double)(i);
                ar2.ptr.p_double[i] = (double)(i);
                ai.ptr.p_int[i] = i;
            }
            tagsort(&a0, n, &p1, &p2, _state);
            testtsortunit_testsortresults(&a0, &p1, &p2, &a, n, &waserrors, _state);
            tagsortfasti(&a1, &ai, &bufr1, &bufi1, n, _state);
            for(i=0; i<=n-1; i++)
            {
                waserrors = waserrors||ae_fp_neq(a1.ptr.p_double[i],a0.ptr.p_double[i]);
            }
            tagsortfastr(&a2, &ar, &bufr1, &bufr2, n, _state);
            for(i=0; i<=n-1; i++)
            {
                waserrors = waserrors||ae_fp_neq(a2.ptr.p_double[i],a0.ptr.p_double[i]);
            }
            tagsortfast(&a3, &bufr1, n, _state);
            for(i=0; i<=n-1; i++)
            {
                waserrors = waserrors||ae_fp_neq(a3.ptr.p_double[i],a0.ptr.p_double[i]);
            }
            tagsortmiddleir(&a4, &ar2, 0, n, _state);
            for(i=0; i<=n-1; i++)
            {
                waserrors = waserrors||ae_fp_neq((double)(a4.ptr.p_int[i]),a0.ptr.p_double[i]);
            }
            
            /*
             * 0-1 sort
             * We test that keys are correctly reordered, but do NOT test order of values.
             */
            testtsortunit_unset1di(&p1, _state);
            testtsortunit_unset1di(&p2, _state);
            ae_vector_set_length(&a, n, _state);
            ae_vector_set_length(&a0, n, _state);
            ae_vector_set_length(&a1, n, _state);
            ae_vector_set_length(&a2, n, _state);
            ae_vector_set_length(&a3, n, _state);
            ae_vector_set_length(&a4, n, _state);
            ae_vector_set_length(&ar, n, _state);
            ae_vector_set_length(&ar2, n, _state);
            ae_vector_set_length(&ai, n, _state);
            for(i=0; i<=n-1; i++)
            {
                a.ptr.p_double[i] = (double)(ae_randominteger(2, _state));
                a0.ptr.p_double[i] = a.ptr.p_double[i];
                a1.ptr.p_double[i] = a.ptr.p_double[i];
                a2.ptr.p_double[i] = a.ptr.p_double[i];
                a3.ptr.p_double[i] = a.ptr.p_double[i];
                a4.ptr.p_int[i] = ae_round(a.ptr.p_double[i], _state);
                ar.ptr.p_double[i] = (double)(i);
                ar2.ptr.p_double[i] = (double)(i);
                ai.ptr.p_int[i] = i;
            }
            tagsort(&a0, n, &p1, &p2, _state);
            testtsortunit_testsortresults(&a0, &p1, &p2, &a, n, &waserrors, _state);
            tagsortfasti(&a1, &ai, &bufr1, &bufi1, n, _state);
            for(i=0; i<=n-1; i++)
            {
                waserrors = waserrors||ae_fp_neq(a1.ptr.p_double[i],a0.ptr.p_double[i]);
            }
            tagsortfastr(&a2, &ar, &bufr1, &bufr2, n, _state);
            for(i=0; i<=n-1; i++)
            {
                waserrors = waserrors||ae_fp_neq(a2.ptr.p_double[i],a0.ptr.p_double[i]);
            }
            tagsortfast(&a3, &bufr1, n, _state);
            for(i=0; i<=n-1; i++)
            {
                waserrors = waserrors||ae_fp_neq(a3.ptr.p_double[i],a0.ptr.p_double[i]);
            }
            tagsortmiddleir(&a4, &ar2, 0, n, _state);
            for(i=0; i<=n-1; i++)
            {
                waserrors = waserrors||ae_fp_neq((double)(a4.ptr.p_int[i]),a0.ptr.p_double[i]);
            }
            
            /*
             * Special test for TagSortMiddleIR: sorting in the middle gives same results
             * as sorting in the beginning of the array
             */
            m = 3*n;
            offs = ae_randominteger(n, _state);
            ae_vector_set_length(&i1, m, _state);
            ae_vector_set_length(&i2, m, _state);
            ae_vector_set_length(&i3, m, _state);
            ae_vector_set_length(&ar, m, _state);
            ae_vector_set_length(&ar2, m, _state);
            for(i=0; i<=m-1; i++)
            {
                i1.ptr.p_int[i] = ae_randominteger(100000000, _state);
                i2.ptr.p_int[i] = i1.ptr.p_int[i];
                i3.ptr.p_int[i] = i1.ptr.p_int[i];
                ar.ptr.p_double[i] = (double)(i);
                ar2.ptr.p_double[i] = (double)(i);
            }
            for(i=0; i<=n-1; i++)
            {
                i1.ptr.p_int[i] = i1.ptr.p_int[offs+i];
                ar.ptr.p_double[i] = ar.ptr.p_double[offs+i];
            }
            tagsortmiddleir(&i1, &ar, 0, n, _state);
            for(i=1; i<=n-1; i++)
            {
                distinctvals = distinctvals&&i1.ptr.p_int[i]!=i1.ptr.p_int[i-1];
            }
            if( distinctvals )
            {
                tagsortmiddleir(&i2, &ar2, offs, n, _state);
                for(i=0; i<=n-1; i++)
                {
                    waserrors = (waserrors||i2.ptr.p_int[offs+i]!=i1.ptr.p_int[i])||ae_fp_neq(ar2.ptr.p_double[offs+i],ar.ptr.p_double[i]);
                }
            }
        }
    }
    
    /*
     * report
     */
    if( !silent )
    {
        printf("TESTING TAGSORT\n");
        if( waserrors )
        {
            printf("TEST FAILED\n");
        }
        else
        {
            printf("TEST PASSED\n");
        }
        printf("\n\n");
    }
    result = !waserrors;
    ae_frame_leave(_state);
    return result;
}


/*************************************************************************
Single-threaded stub. HPC ALGLIB replaces it by multithreaded code.
*************************************************************************/
ae_bool _pexec_testtsort(ae_bool silent, ae_state *_state)
{
    return testtsort(silent, _state);
}


/*************************************************************************
Unsets 2D array.
*************************************************************************/
static void testtsortunit_unset2d(/* Complex */ ae_matrix* a,
     ae_state *_state)
{


    ae_matrix_set_length(a, 0+1, 0+1, _state);
    a->ptr.pp_complex[0][0] = ae_complex_from_d(2*ae_randomreal(_state)-1);
}


/*************************************************************************
Unsets 1D array.
*************************************************************************/
static void testtsortunit_unset1d(/* Real    */ ae_vector* a,
     ae_state *_state)
{


    ae_vector_set_length(a, 0+1, _state);
    a->ptr.p_double[0] = 2*ae_randomreal(_state)-1;
}


/*************************************************************************
Unsets 1D array.
*************************************************************************/
static void testtsortunit_unset1di(/* Integer */ ae_vector* a,
     ae_state *_state)
{


    ae_vector_set_length(a, 0+1, _state);
    a->ptr.p_int[0] = ae_randominteger(3, _state)-1;
}


static void testtsortunit_testsortresults(/* Real    */ ae_vector* asorted,
     /* Integer */ ae_vector* p1,
     /* Integer */ ae_vector* p2,
     /* Real    */ ae_vector* aoriginal,
     ae_int_t n,
     ae_bool* waserrors,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_int_t i;
    ae_vector a2;
    double t;
    ae_vector f;

    ae_frame_make(_state, &_frame_block);
    ae_vector_init(&a2, 0, DT_REAL, _state);
    ae_vector_init(&f, 0, DT_INT, _state);

    ae_vector_set_length(&a2, n-1+1, _state);
    ae_vector_set_length(&f, n-1+1, _state);
    
    /*
     * is set ordered?
     */
    for(i=0; i<=n-2; i++)
    {
        *waserrors = *waserrors||ae_fp_greater(asorted->ptr.p_double[i],asorted->ptr.p_double[i+1]);
    }
    
    /*
     * P1 correctness
     */
    for(i=0; i<=n-1; i++)
    {
        *waserrors = *waserrors||ae_fp_neq(asorted->ptr.p_double[i],aoriginal->ptr.p_double[p1->ptr.p_int[i]]);
    }
    for(i=0; i<=n-1; i++)
    {
        f.ptr.p_int[i] = 0;
    }
    for(i=0; i<=n-1; i++)
    {
        f.ptr.p_int[p1->ptr.p_int[i]] = f.ptr.p_int[p1->ptr.p_int[i]]+1;
    }
    for(i=0; i<=n-1; i++)
    {
        *waserrors = *waserrors||f.ptr.p_int[i]!=1;
    }
    
    /*
     * P2 correctness
     */
    for(i=0; i<=n-1; i++)
    {
        a2.ptr.p_double[i] = aoriginal->ptr.p_double[i];
    }
    for(i=0; i<=n-1; i++)
    {
        if( p2->ptr.p_int[i]!=i )
        {
            t = a2.ptr.p_double[i];
            a2.ptr.p_double[i] = a2.ptr.p_double[p2->ptr.p_int[i]];
            a2.ptr.p_double[p2->ptr.p_int[i]] = t;
        }
    }
    for(i=0; i<=n-1; i++)
    {
        *waserrors = *waserrors||ae_fp_neq(asorted->ptr.p_double[i],a2.ptr.p_double[i]);
    }
    ae_frame_leave(_state);
}



static void testnearestneighborunit_unset2d(/* Complex */ ae_matrix* a,
     ae_state *_state);
static void testnearestneighborunit_unset1d(/* Real    */ ae_vector* a,
     ae_state *_state);
static ae_bool testnearestneighborunit_kdtresultsdifferent(/* Real    */ ae_matrix* refxy,
     ae_int_t ntotal,
     /* Real    */ ae_matrix* qx,
     /* Real    */ ae_matrix* qxy,
     /* Integer */ ae_vector* qt,
     ae_int_t n,
     ae_int_t nx,
     ae_int_t ny,
     ae_state *_state);
static double testnearestneighborunit_vnorm(/* Real    */ ae_vector* x,
     ae_int_t n,
     ae_int_t normtype,
     ae_state *_state);
static void testnearestneighborunit_testkdtuniform(/* Real    */ ae_matrix* xy,
     ae_int_t n,
     ae_int_t nx,
     ae_int_t ny,
     ae_int_t normtype,
     ae_bool* kdterrors,
     ae_state *_state);
static void testnearestneighborunit_testkdtreeserialization(ae_bool* err,
     ae_state *_state);
static ae_bool testnearestneighborunit_testspecialcases(ae_state *_state);





/*************************************************************************
Testing Nearest Neighbor Search
*************************************************************************/
ae_bool testnearestneighbor(ae_bool silent, ae_state *_state)
{
    ae_frame _frame_block;
    ae_matrix xy;
    ae_int_t i;
    ae_int_t j;
    double v;
    ae_int_t normtype;
    ae_int_t nx;
    ae_int_t ny;
    ae_int_t n;
    ae_int_t smalln;
    ae_int_t largen;
    ae_int_t passcount;
    ae_int_t pass;
    ae_bool waserrors;
    ae_bool kdterrors;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    ae_matrix_init(&xy, 0, 0, DT_REAL, _state);

    kdterrors = ae_false;
    passcount = 2;
    smalln = 256;
    largen = 2048;
    ny = 3;
    
    /*
     *
     */
    testnearestneighborunit_testkdtreeserialization(&kdterrors, _state);
    for(pass=1; pass<=passcount; pass++)
    {
        for(normtype=0; normtype<=2; normtype++)
        {
            for(nx=1; nx<=3; nx++)
            {
                
                /*
                 * Test in hypercube
                 */
                ae_matrix_set_length(&xy, largen, nx+ny, _state);
                for(i=0; i<=largen-1; i++)
                {
                    for(j=0; j<=nx+ny-1; j++)
                    {
                        xy.ptr.pp_double[i][j] = 10*ae_randomreal(_state)-5;
                    }
                }
                for(n=1; n<=10; n++)
                {
                    testnearestneighborunit_testkdtuniform(&xy, n, nx, ae_randominteger(ny+1, _state), normtype, &kdterrors, _state);
                }
                testnearestneighborunit_testkdtuniform(&xy, largen, nx, ae_randominteger(ny+1, _state), normtype, &kdterrors, _state);
                
                /*
                 * Test clustered (2*N points, pairs of equal points)
                 */
                ae_matrix_set_length(&xy, 2*smalln, nx+ny, _state);
                for(i=0; i<=smalln-1; i++)
                {
                    for(j=0; j<=nx+ny-1; j++)
                    {
                        xy.ptr.pp_double[2*i+0][j] = 10*ae_randomreal(_state)-5;
                        xy.ptr.pp_double[2*i+1][j] = xy.ptr.pp_double[2*i+0][j];
                    }
                }
                testnearestneighborunit_testkdtuniform(&xy, 2*smalln, nx, ae_randominteger(ny+1, _state), normtype, &kdterrors, _state);
                
                /*
                 * Test degenerate case: all points are same except for one
                 */
                ae_matrix_set_length(&xy, smalln, nx+ny, _state);
                v = ae_randomreal(_state);
                for(i=0; i<=smalln-2; i++)
                {
                    for(j=0; j<=nx+ny-1; j++)
                    {
                        xy.ptr.pp_double[i][j] = v;
                    }
                }
                for(j=0; j<=nx+ny-1; j++)
                {
                    xy.ptr.pp_double[smalln-1][j] = 10*ae_randomreal(_state)-5;
                }
                testnearestneighborunit_testkdtuniform(&xy, smalln, nx, ae_randominteger(ny+1, _state), normtype, &kdterrors, _state);
            }
        }
    }
    kdterrors = kdterrors||testnearestneighborunit_testspecialcases(_state);
    
    /*
     * report
     */
    waserrors = kdterrors;
    if( !silent )
    {
        printf("TESTING NEAREST NEIGHBOR SEARCH\n");
        printf("* KD TREES:                              ");
        if( !kdterrors )
        {
            printf("OK\n");
        }
        else
        {
            printf("FAILED\n");
        }
        if( waserrors )
        {
            printf("TEST FAILED\n");
        }
        else
        {
            printf("TEST PASSED\n");
        }
        printf("\n\n");
    }
    result = !waserrors;
    ae_frame_leave(_state);
    return result;
}


/*************************************************************************
Single-threaded stub. HPC ALGLIB replaces it by multithreaded code.
*************************************************************************/
ae_bool _pexec_testnearestneighbor(ae_bool silent, ae_state *_state)
{
    return testnearestneighbor(silent, _state);
}


/*************************************************************************
Unsets 2D array.
*************************************************************************/
static void testnearestneighborunit_unset2d(/* Complex */ ae_matrix* a,
     ae_state *_state)
{


    ae_matrix_set_length(a, 0+1, 0+1, _state);
    a->ptr.pp_complex[0][0] = ae_complex_from_d(2*ae_randomreal(_state)-1);
}


/*************************************************************************
Unsets 1D array.
*************************************************************************/
static void testnearestneighborunit_unset1d(/* Real    */ ae_vector* a,
     ae_state *_state)
{


    ae_vector_set_length(a, 0+1, _state);
    a->ptr.p_double[0] = 2*ae_randomreal(_state)-1;
}


/*************************************************************************
Compare results from different queries:
* X     just X-values
* XY    X-values and Y-values
* XT    X-values and tag values
*************************************************************************/
static ae_bool testnearestneighborunit_kdtresultsdifferent(/* Real    */ ae_matrix* refxy,
     ae_int_t ntotal,
     /* Real    */ ae_matrix* qx,
     /* Real    */ ae_matrix* qxy,
     /* Integer */ ae_vector* qt,
     ae_int_t n,
     ae_int_t nx,
     ae_int_t ny,
     ae_state *_state)
{
    ae_int_t i;
    ae_int_t j;
    ae_bool result;


    result = ae_false;
    for(i=0; i<=n-1; i++)
    {
        if( qt->ptr.p_int[i]<0||qt->ptr.p_int[i]>=ntotal )
        {
            result = ae_true;
            return result;
        }
        for(j=0; j<=nx-1; j++)
        {
            result = result||ae_fp_neq(qx->ptr.pp_double[i][j],refxy->ptr.pp_double[qt->ptr.p_int[i]][j]);
            result = result||ae_fp_neq(qxy->ptr.pp_double[i][j],refxy->ptr.pp_double[qt->ptr.p_int[i]][j]);
        }
        for(j=0; j<=ny-1; j++)
        {
            result = result||ae_fp_neq(qxy->ptr.pp_double[i][nx+j],refxy->ptr.pp_double[qt->ptr.p_int[i]][nx+j]);
        }
    }
    return result;
}


/*************************************************************************
Returns norm
*************************************************************************/
static double testnearestneighborunit_vnorm(/* Real    */ ae_vector* x,
     ae_int_t n,
     ae_int_t normtype,
     ae_state *_state)
{
    ae_int_t i;
    double result;


    result = ae_randomreal(_state);
    if( normtype==0 )
    {
        result = (double)(0);
        for(i=0; i<=n-1; i++)
        {
            result = ae_maxreal(result, ae_fabs(x->ptr.p_double[i], _state), _state);
        }
        return result;
    }
    if( normtype==1 )
    {
        result = (double)(0);
        for(i=0; i<=n-1; i++)
        {
            result = result+ae_fabs(x->ptr.p_double[i], _state);
        }
        return result;
    }
    if( normtype==2 )
    {
        result = (double)(0);
        for(i=0; i<=n-1; i++)
        {
            result = result+ae_sqr(x->ptr.p_double[i], _state);
        }
        result = ae_sqrt(result, _state);
        return result;
    }
    return result;
}


/*************************************************************************
Testing Nearest Neighbor Search on uniformly distributed hypercube

NormType: 0, 1, 2
D: space dimension
N: points count
*************************************************************************/
static void testnearestneighborunit_testkdtuniform(/* Real    */ ae_matrix* xy,
     ae_int_t n,
     ae_int_t nx,
     ae_int_t ny,
     ae_int_t normtype,
     ae_bool* kdterrors,
     ae_state *_state)
{
    ae_frame _frame_block;
    double errtol;
    ae_vector tags;
    ae_vector ptx;
    ae_vector tmpx;
    ae_vector tmpb;
    kdtree treex;
    kdtree treexy;
    kdtree treext;
    ae_matrix qx;
    ae_matrix qxy;
    ae_vector qtags;
    ae_vector qr;
    ae_int_t kx;
    ae_int_t kxy;
    ae_int_t kt;
    double eps;
    ae_int_t i;
    ae_int_t j;
    ae_int_t k;
    ae_int_t task;
    ae_bool isequal;
    double r;
    ae_int_t q;
    ae_int_t qcount;

    ae_frame_make(_state, &_frame_block);
    ae_vector_init(&tags, 0, DT_INT, _state);
    ae_vector_init(&ptx, 0, DT_REAL, _state);
    ae_vector_init(&tmpx, 0, DT_REAL, _state);
    ae_vector_init(&tmpb, 0, DT_BOOL, _state);
    _kdtree_init(&treex, _state);
    _kdtree_init(&treexy, _state);
    _kdtree_init(&treext, _state);
    ae_matrix_init(&qx, 0, 0, DT_REAL, _state);
    ae_matrix_init(&qxy, 0, 0, DT_REAL, _state);
    ae_vector_init(&qtags, 0, DT_INT, _state);
    ae_vector_init(&qr, 0, DT_REAL, _state);

    qcount = 10;
    
    /*
     * Tol - roundoff error tolerance (for '>=' comparisons)
     */
    errtol = 100000*ae_machineepsilon;
    
    /*
     * fill tags
     */
    ae_vector_set_length(&tags, n, _state);
    for(i=0; i<=n-1; i++)
    {
        tags.ptr.p_int[i] = i;
    }
    
    /*
     * build trees
     */
    kdtreebuild(xy, n, nx, 0, normtype, &treex, _state);
    kdtreebuild(xy, n, nx, ny, normtype, &treexy, _state);
    kdtreebuildtagged(xy, &tags, n, nx, 0, normtype, &treext, _state);
    
    /*
     * allocate arrays
     */
    ae_vector_set_length(&tmpx, nx, _state);
    ae_vector_set_length(&tmpb, n, _state);
    ae_matrix_set_length(&qx, n, nx, _state);
    ae_matrix_set_length(&qxy, n, nx+ny, _state);
    ae_vector_set_length(&qtags, n, _state);
    ae_vector_set_length(&qr, n, _state);
    ae_vector_set_length(&ptx, nx, _state);
    
    /*
     * test general K-NN queries (with self-matches):
     * * compare results from different trees (must be equal) and
     *   check that correct (value,tag) pairs are returned
     * * test results from XT tree - let R be radius of query result.
     *   then all points not in result must be not closer than R.
     */
    for(q=1; q<=qcount; q++)
    {
        
        /*
         * Select K: 1..N
         */
        if( ae_fp_greater(ae_randomreal(_state),0.5) )
        {
            k = 1+ae_randominteger(n, _state);
        }
        else
        {
            k = 1;
        }
        
        /*
         * Select point (either one of the points, or random)
         */
        if( ae_fp_greater(ae_randomreal(_state),0.5) )
        {
            i = ae_randominteger(n, _state);
            ae_v_move(&ptx.ptr.p_double[0], 1, &xy->ptr.pp_double[i][0], 1, ae_v_len(0,nx-1));
        }
        else
        {
            for(i=0; i<=nx-1; i++)
            {
                ptx.ptr.p_double[i] = 2*ae_randomreal(_state)-1;
            }
        }
        
        /*
         * Test:
         * * consistency of results from different queries
         * * points in query are IN the R-sphere (or at the boundary),
         *   and points not in query are outside of the R-sphere (or at the boundary)
         * * distances are correct and are ordered
         */
        kx = kdtreequeryknn(&treex, &ptx, k, ae_true, _state);
        kxy = kdtreequeryknn(&treexy, &ptx, k, ae_true, _state);
        kt = kdtreequeryknn(&treext, &ptx, k, ae_true, _state);
        if( (kx!=k||kxy!=k)||kt!=k )
        {
            *kdterrors = ae_true;
            ae_frame_leave(_state);
            return;
        }
        kdtreequeryresultsxi(&treex, &qx, _state);
        kdtreequeryresultsxyi(&treexy, &qxy, _state);
        kdtreequeryresultstagsi(&treext, &qtags, _state);
        kdtreequeryresultsdistancesi(&treext, &qr, _state);
        *kdterrors = *kdterrors||testnearestneighborunit_kdtresultsdifferent(xy, n, &qx, &qxy, &qtags, k, nx, ny, _state);
        kdtreequeryresultsx(&treex, &qx, _state);
        kdtreequeryresultsxy(&treexy, &qxy, _state);
        kdtreequeryresultstags(&treext, &qtags, _state);
        kdtreequeryresultsdistances(&treext, &qr, _state);
        *kdterrors = *kdterrors||testnearestneighborunit_kdtresultsdifferent(xy, n, &qx, &qxy, &qtags, k, nx, ny, _state);
        for(i=0; i<=n-1; i++)
        {
            tmpb.ptr.p_bool[i] = ae_true;
        }
        r = (double)(0);
        for(i=0; i<=k-1; i++)
        {
            tmpb.ptr.p_bool[qtags.ptr.p_int[i]] = ae_false;
            ae_v_move(&tmpx.ptr.p_double[0], 1, &ptx.ptr.p_double[0], 1, ae_v_len(0,nx-1));
            ae_v_sub(&tmpx.ptr.p_double[0], 1, &qx.ptr.pp_double[i][0], 1, ae_v_len(0,nx-1));
            r = ae_maxreal(r, testnearestneighborunit_vnorm(&tmpx, nx, normtype, _state), _state);
        }
        for(i=0; i<=n-1; i++)
        {
            if( tmpb.ptr.p_bool[i] )
            {
                ae_v_move(&tmpx.ptr.p_double[0], 1, &ptx.ptr.p_double[0], 1, ae_v_len(0,nx-1));
                ae_v_sub(&tmpx.ptr.p_double[0], 1, &xy->ptr.pp_double[i][0], 1, ae_v_len(0,nx-1));
                *kdterrors = *kdterrors||ae_fp_less(testnearestneighborunit_vnorm(&tmpx, nx, normtype, _state),r*(1-errtol));
            }
        }
        for(i=0; i<=k-2; i++)
        {
            *kdterrors = *kdterrors||ae_fp_greater(qr.ptr.p_double[i],qr.ptr.p_double[i+1]);
        }
        for(i=0; i<=k-1; i++)
        {
            ae_v_move(&tmpx.ptr.p_double[0], 1, &ptx.ptr.p_double[0], 1, ae_v_len(0,nx-1));
            ae_v_sub(&tmpx.ptr.p_double[0], 1, &xy->ptr.pp_double[qtags.ptr.p_int[i]][0], 1, ae_v_len(0,nx-1));
            *kdterrors = *kdterrors||ae_fp_greater(ae_fabs(testnearestneighborunit_vnorm(&tmpx, nx, normtype, _state)-qr.ptr.p_double[i], _state),errtol);
        }
        
        /*
         * Test reallocation properties: buffered functions must automatically
         * resize array which is too small, but leave unchanged array which is
         * too large.
         */
        if( n>=2 )
        {
            
            /*
             * First step: array is too small, two elements are required
             */
            k = 2;
            kx = kdtreequeryknn(&treex, &ptx, k, ae_true, _state);
            kxy = kdtreequeryknn(&treexy, &ptx, k, ae_true, _state);
            kt = kdtreequeryknn(&treext, &ptx, k, ae_true, _state);
            if( (kx!=k||kxy!=k)||kt!=k )
            {
                *kdterrors = ae_true;
                ae_frame_leave(_state);
                return;
            }
            ae_matrix_set_length(&qx, 1, 1, _state);
            ae_matrix_set_length(&qxy, 1, 1, _state);
            ae_vector_set_length(&qtags, 1, _state);
            ae_vector_set_length(&qr, 1, _state);
            kdtreequeryresultsx(&treex, &qx, _state);
            kdtreequeryresultsxy(&treexy, &qxy, _state);
            kdtreequeryresultstags(&treext, &qtags, _state);
            kdtreequeryresultsdistances(&treext, &qr, _state);
            *kdterrors = *kdterrors||testnearestneighborunit_kdtresultsdifferent(xy, n, &qx, &qxy, &qtags, k, nx, ny, _state);
            
            /*
             * Second step: array is one row larger than needed, so only first
             * row is overwritten. Test it.
             */
            k = 1;
            kx = kdtreequeryknn(&treex, &ptx, k, ae_true, _state);
            kxy = kdtreequeryknn(&treexy, &ptx, k, ae_true, _state);
            kt = kdtreequeryknn(&treext, &ptx, k, ae_true, _state);
            if( (kx!=k||kxy!=k)||kt!=k )
            {
                *kdterrors = ae_true;
                ae_frame_leave(_state);
                return;
            }
            for(i=0; i<=nx-1; i++)
            {
                qx.ptr.pp_double[1][i] = _state->v_nan;
            }
            for(i=0; i<=nx+ny-1; i++)
            {
                qxy.ptr.pp_double[1][i] = _state->v_nan;
            }
            qtags.ptr.p_int[1] = 999;
            qr.ptr.p_double[1] = _state->v_nan;
            kdtreequeryresultsx(&treex, &qx, _state);
            kdtreequeryresultsxy(&treexy, &qxy, _state);
            kdtreequeryresultstags(&treext, &qtags, _state);
            kdtreequeryresultsdistances(&treext, &qr, _state);
            *kdterrors = *kdterrors||testnearestneighborunit_kdtresultsdifferent(xy, n, &qx, &qxy, &qtags, k, nx, ny, _state);
            for(i=0; i<=nx-1; i++)
            {
                *kdterrors = *kdterrors||!ae_isnan(qx.ptr.pp_double[1][i], _state);
            }
            for(i=0; i<=nx+ny-1; i++)
            {
                *kdterrors = *kdterrors||!ae_isnan(qxy.ptr.pp_double[1][i], _state);
            }
            *kdterrors = *kdterrors||!(qtags.ptr.p_int[1]==999);
            *kdterrors = *kdterrors||!ae_isnan(qr.ptr.p_double[1], _state);
        }
        
        /*
         * Test reallocation properties: 'interactive' functions must allocate
         * new array on each call.
         */
        if( n>=2 )
        {
            
            /*
             * On input array is either too small or too large
             */
            for(k=1; k<=2; k++)
            {
                ae_assert(k==1||k==2, "KNN: internal error (unexpected K)!", _state);
                kx = kdtreequeryknn(&treex, &ptx, k, ae_true, _state);
                kxy = kdtreequeryknn(&treexy, &ptx, k, ae_true, _state);
                kt = kdtreequeryknn(&treext, &ptx, k, ae_true, _state);
                if( (kx!=k||kxy!=k)||kt!=k )
                {
                    *kdterrors = ae_true;
                    ae_frame_leave(_state);
                    return;
                }
                ae_matrix_set_length(&qx, 3-k, 3-k, _state);
                ae_matrix_set_length(&qxy, 3-k, 3-k, _state);
                ae_vector_set_length(&qtags, 3-k, _state);
                ae_vector_set_length(&qr, 3-k, _state);
                kdtreequeryresultsxi(&treex, &qx, _state);
                kdtreequeryresultsxyi(&treexy, &qxy, _state);
                kdtreequeryresultstagsi(&treext, &qtags, _state);
                kdtreequeryresultsdistancesi(&treext, &qr, _state);
                *kdterrors = *kdterrors||testnearestneighborunit_kdtresultsdifferent(xy, n, &qx, &qxy, &qtags, k, nx, ny, _state);
                *kdterrors = (*kdterrors||qx.rows!=k)||qx.cols!=nx;
                *kdterrors = (*kdterrors||qxy.rows!=k)||qxy.cols!=nx+ny;
                *kdterrors = *kdterrors||qtags.cnt!=k;
                *kdterrors = *kdterrors||qr.cnt!=k;
            }
        }
    }
    
    /*
     * test general approximate K-NN queries (with self-matches):
     * * compare results from different trees (must be equal) and
     *   check that correct (value,tag) pairs are returned
     * * test results from XT tree - let R be radius of query result.
     *   then all points not in result must be not closer than R/(1+Eps).
     */
    for(q=1; q<=qcount; q++)
    {
        
        /*
         * Select K: 1..N
         */
        if( ae_fp_greater(ae_randomreal(_state),0.5) )
        {
            k = 1+ae_randominteger(n, _state);
        }
        else
        {
            k = 1;
        }
        
        /*
         * Select Eps
         */
        eps = 0.5+ae_randomreal(_state);
        
        /*
         * Select point (either one of the points, or random)
         */
        if( ae_fp_greater(ae_randomreal(_state),0.5) )
        {
            i = ae_randominteger(n, _state);
            ae_v_move(&ptx.ptr.p_double[0], 1, &xy->ptr.pp_double[i][0], 1, ae_v_len(0,nx-1));
        }
        else
        {
            for(i=0; i<=nx-1; i++)
            {
                ptx.ptr.p_double[i] = 2*ae_randomreal(_state)-1;
            }
        }
        
        /*
         * Test:
         * * consistency of results from different queries
         * * points in query are IN the R-sphere (or at the boundary),
         *   and points not in query are outside of the R-sphere (or at the boundary)
         * * distances are correct and are ordered
         */
        kx = kdtreequeryaknn(&treex, &ptx, k, ae_true, eps, _state);
        kxy = kdtreequeryaknn(&treexy, &ptx, k, ae_true, eps, _state);
        kt = kdtreequeryaknn(&treext, &ptx, k, ae_true, eps, _state);
        if( (kx!=k||kxy!=k)||kt!=k )
        {
            *kdterrors = ae_true;
            ae_frame_leave(_state);
            return;
        }
        kdtreequeryresultsxi(&treex, &qx, _state);
        kdtreequeryresultsxyi(&treexy, &qxy, _state);
        kdtreequeryresultstagsi(&treext, &qtags, _state);
        kdtreequeryresultsdistancesi(&treext, &qr, _state);
        *kdterrors = *kdterrors||testnearestneighborunit_kdtresultsdifferent(xy, n, &qx, &qxy, &qtags, k, nx, ny, _state);
        kdtreequeryresultsx(&treex, &qx, _state);
        kdtreequeryresultsxy(&treexy, &qxy, _state);
        kdtreequeryresultstags(&treext, &qtags, _state);
        kdtreequeryresultsdistances(&treext, &qr, _state);
        *kdterrors = *kdterrors||testnearestneighborunit_kdtresultsdifferent(xy, n, &qx, &qxy, &qtags, k, nx, ny, _state);
        for(i=0; i<=n-1; i++)
        {
            tmpb.ptr.p_bool[i] = ae_true;
        }
        r = (double)(0);
        for(i=0; i<=k-1; i++)
        {
            tmpb.ptr.p_bool[qtags.ptr.p_int[i]] = ae_false;
            ae_v_move(&tmpx.ptr.p_double[0], 1, &ptx.ptr.p_double[0], 1, ae_v_len(0,nx-1));
            ae_v_sub(&tmpx.ptr.p_double[0], 1, &qx.ptr.pp_double[i][0], 1, ae_v_len(0,nx-1));
            r = ae_maxreal(r, testnearestneighborunit_vnorm(&tmpx, nx, normtype, _state), _state);
        }
        for(i=0; i<=n-1; i++)
        {
            if( tmpb.ptr.p_bool[i] )
            {
                ae_v_move(&tmpx.ptr.p_double[0], 1, &ptx.ptr.p_double[0], 1, ae_v_len(0,nx-1));
                ae_v_sub(&tmpx.ptr.p_double[0], 1, &xy->ptr.pp_double[i][0], 1, ae_v_len(0,nx-1));
                *kdterrors = *kdterrors||ae_fp_less(testnearestneighborunit_vnorm(&tmpx, nx, normtype, _state),r*(1-errtol)/(1+eps));
            }
        }
        for(i=0; i<=k-2; i++)
        {
            *kdterrors = *kdterrors||ae_fp_greater(qr.ptr.p_double[i],qr.ptr.p_double[i+1]);
        }
        for(i=0; i<=k-1; i++)
        {
            ae_v_move(&tmpx.ptr.p_double[0], 1, &ptx.ptr.p_double[0], 1, ae_v_len(0,nx-1));
            ae_v_sub(&tmpx.ptr.p_double[0], 1, &xy->ptr.pp_double[qtags.ptr.p_int[i]][0], 1, ae_v_len(0,nx-1));
            *kdterrors = *kdterrors||ae_fp_greater(ae_fabs(testnearestneighborunit_vnorm(&tmpx, nx, normtype, _state)-qr.ptr.p_double[i], _state),errtol);
        }
    }
    
    /*
     * test general R-NN queries  (with self-matches):
     * * compare results from different trees (must be equal) and
     *   check that correct (value,tag) pairs are returned
     * * test results from XT tree - let R be radius of query result.
     *   then all points not in result must be not closer than R.
     */
    for(q=1; q<=qcount; q++)
    {
        
        /*
         * Select R
         */
        if( ae_fp_greater(ae_randomreal(_state),0.3) )
        {
            r = ae_maxreal(ae_randomreal(_state), ae_machineepsilon, _state);
        }
        else
        {
            r = ae_machineepsilon;
        }
        
        /*
         * Select point (either one of the points, or random)
         */
        if( ae_fp_greater(ae_randomreal(_state),0.5) )
        {
            i = ae_randominteger(n, _state);
            ae_v_move(&ptx.ptr.p_double[0], 1, &xy->ptr.pp_double[i][0], 1, ae_v_len(0,nx-1));
        }
        else
        {
            for(i=0; i<=nx-1; i++)
            {
                ptx.ptr.p_double[i] = 2*ae_randomreal(_state)-1;
            }
        }
        
        /*
         * Test:
         * * consistency of results from different queries
         * * points in query are IN the R-sphere (or at the boundary),
         *   and points not in query are outside of the R-sphere (or at the boundary)
         * * distances are correct and are ordered
         */
        kx = kdtreequeryrnn(&treex, &ptx, r, ae_true, _state);
        kxy = kdtreequeryrnn(&treexy, &ptx, r, ae_true, _state);
        kt = kdtreequeryrnn(&treext, &ptx, r, ae_true, _state);
        if( kxy!=kx||kt!=kx )
        {
            *kdterrors = ae_true;
            ae_frame_leave(_state);
            return;
        }
        kdtreequeryresultsxi(&treex, &qx, _state);
        kdtreequeryresultsxyi(&treexy, &qxy, _state);
        kdtreequeryresultstagsi(&treext, &qtags, _state);
        kdtreequeryresultsdistancesi(&treext, &qr, _state);
        *kdterrors = *kdterrors||testnearestneighborunit_kdtresultsdifferent(xy, n, &qx, &qxy, &qtags, kx, nx, ny, _state);
        kdtreequeryresultsx(&treex, &qx, _state);
        kdtreequeryresultsxy(&treexy, &qxy, _state);
        kdtreequeryresultstags(&treext, &qtags, _state);
        kdtreequeryresultsdistances(&treext, &qr, _state);
        *kdterrors = *kdterrors||testnearestneighborunit_kdtresultsdifferent(xy, n, &qx, &qxy, &qtags, kx, nx, ny, _state);
        for(i=0; i<=n-1; i++)
        {
            tmpb.ptr.p_bool[i] = ae_true;
        }
        for(i=0; i<=kx-1; i++)
        {
            tmpb.ptr.p_bool[qtags.ptr.p_int[i]] = ae_false;
        }
        for(i=0; i<=n-1; i++)
        {
            ae_v_move(&tmpx.ptr.p_double[0], 1, &ptx.ptr.p_double[0], 1, ae_v_len(0,nx-1));
            ae_v_sub(&tmpx.ptr.p_double[0], 1, &xy->ptr.pp_double[i][0], 1, ae_v_len(0,nx-1));
            if( tmpb.ptr.p_bool[i] )
            {
                *kdterrors = *kdterrors||ae_fp_less(testnearestneighborunit_vnorm(&tmpx, nx, normtype, _state),r*(1-errtol));
            }
            else
            {
                *kdterrors = *kdterrors||ae_fp_greater(testnearestneighborunit_vnorm(&tmpx, nx, normtype, _state),r*(1+errtol));
            }
        }
        for(i=0; i<=kx-2; i++)
        {
            *kdterrors = *kdterrors||ae_fp_greater(qr.ptr.p_double[i],qr.ptr.p_double[i+1]);
        }
    }
    
    /*
     * Test self-matching:
     * * self-match - nearest neighbor of each point in XY is the point itself
     * * no self-match - nearest neighbor is NOT the point itself
     */
    if( n>1 )
    {
        
        /*
         * test for N=1 have non-general form, but it is not really needed
         */
        for(task=0; task<=1; task++)
        {
            for(i=0; i<=n-1; i++)
            {
                ae_v_move(&ptx.ptr.p_double[0], 1, &xy->ptr.pp_double[i][0], 1, ae_v_len(0,nx-1));
                kx = kdtreequeryknn(&treex, &ptx, 1, task==0, _state);
                kdtreequeryresultsxi(&treex, &qx, _state);
                if( kx!=1 )
                {
                    *kdterrors = ae_true;
                    ae_frame_leave(_state);
                    return;
                }
                isequal = ae_true;
                for(j=0; j<=nx-1; j++)
                {
                    isequal = isequal&&ae_fp_eq(qx.ptr.pp_double[0][j],ptx.ptr.p_double[j]);
                }
                if( task==0 )
                {
                    *kdterrors = *kdterrors||!isequal;
                }
                else
                {
                    *kdterrors = *kdterrors||isequal;
                }
            }
        }
    }
    ae_frame_leave(_state);
}


/*************************************************************************
Testing serialization of KD trees

This function sets Err to True on errors, but leaves it unchanged on success
*************************************************************************/
static void testnearestneighborunit_testkdtreeserialization(ae_bool* err,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_int_t n;
    ae_int_t nx;
    ae_int_t ny;
    ae_int_t normtype;
    ae_int_t i;
    ae_int_t j;
    ae_int_t k;
    ae_int_t q;
    ae_matrix xy;
    ae_vector x;
    ae_vector tags;
    ae_vector qsizes;
    double threshold;
    kdtree tree0;
    kdtree tree1;
    ae_int_t k0;
    ae_int_t k1;
    ae_matrix xy0;
    ae_matrix xy1;
    ae_vector tags0;
    ae_vector tags1;

    ae_frame_make(_state, &_frame_block);
    ae_matrix_init(&xy, 0, 0, DT_REAL, _state);
    ae_vector_init(&x, 0, DT_REAL, _state);
    ae_vector_init(&tags, 0, DT_INT, _state);
    ae_vector_init(&qsizes, 0, DT_INT, _state);
    _kdtree_init(&tree0, _state);
    _kdtree_init(&tree1, _state);
    ae_matrix_init(&xy0, 0, 0, DT_REAL, _state);
    ae_matrix_init(&xy1, 0, 0, DT_REAL, _state);
    ae_vector_init(&tags0, 0, DT_INT, _state);
    ae_vector_init(&tags1, 0, DT_INT, _state);

    threshold = 100*ae_machineepsilon;
    
    /*
     * different N, NX, NY, NormType
     */
    n = 1;
    while(n<=51)
    {
        
        /*
         * prepare array with query sizes
         */
        ae_vector_set_length(&qsizes, 4, _state);
        qsizes.ptr.p_int[0] = 1;
        qsizes.ptr.p_int[1] = ae_minint(2, n, _state);
        qsizes.ptr.p_int[2] = ae_minint(4, n, _state);
        qsizes.ptr.p_int[3] = n;
        
        /*
         * different NX/NY/NormType
         */
        for(nx=1; nx<=2; nx++)
        {
            for(ny=0; ny<=2; ny++)
            {
                for(normtype=0; normtype<=2; normtype++)
                {
                    
                    /*
                     * Prepare data
                     */
                    ae_matrix_set_length(&xy, n, nx+ny, _state);
                    ae_vector_set_length(&tags, n, _state);
                    for(i=0; i<=n-1; i++)
                    {
                        for(j=0; j<=nx+ny-1; j++)
                        {
                            xy.ptr.pp_double[i][j] = ae_randomreal(_state);
                        }
                        tags.ptr.p_int[i] = ae_randominteger(100, _state);
                    }
                    
                    /*
                     * Build tree, pass it through serializer
                     */
                    kdtreebuildtagged(&xy, &tags, n, nx, ny, normtype, &tree0, _state);
                    {
                        /*
                         * This code passes data structure through serializers
                         * (serializes it to string and loads back)
                         */
                        ae_serializer _local_serializer;
                        ae_int_t _local_ssize;
                        ae_frame _local_frame_block;
                        ae_dyn_block _local_dynamic_block;
                        
                        ae_frame_make(_state, &_local_frame_block);
                        
                        ae_serializer_init(&_local_serializer);
                        ae_serializer_alloc_start(&_local_serializer);
                        kdtreealloc(&_local_serializer, &tree0, _state);
                        _local_ssize = ae_serializer_get_alloc_size(&_local_serializer);
                        ae_db_malloc(&_local_dynamic_block, _local_ssize+1, _state, ae_true);
                        ae_serializer_sstart_str(&_local_serializer, (char*)_local_dynamic_block.ptr);
                        kdtreeserialize(&_local_serializer, &tree0, _state);
                        ae_serializer_stop(&_local_serializer);
                        ae_serializer_clear(&_local_serializer);
                        
                        ae_serializer_init(&_local_serializer);
                        ae_serializer_ustart_str(&_local_serializer, (char*)_local_dynamic_block.ptr);
                        kdtreeunserialize(&_local_serializer, &tree1, _state);
                        ae_serializer_stop(&_local_serializer);
                        ae_serializer_clear(&_local_serializer);
                        
                        ae_frame_leave(_state);
                    }
                    
                    /*
                     * For each point of XY we make queries with different sizes
                     */
                    ae_vector_set_length(&x, nx, _state);
                    for(k=0; k<=n-1; k++)
                    {
                        for(q=0; q<=qsizes.cnt-1; q++)
                        {
                            ae_v_move(&x.ptr.p_double[0], 1, &xy.ptr.pp_double[k][0], 1, ae_v_len(0,nx-1));
                            k0 = kdtreequeryknn(&tree0, &x, qsizes.ptr.p_int[q], ae_true, _state);
                            k1 = kdtreequeryknn(&tree1, &x, qsizes.ptr.p_int[q], ae_true, _state);
                            if( k0!=k1 )
                            {
                                *err = ae_true;
                                ae_frame_leave(_state);
                                return;
                            }
                            kdtreequeryresultsxy(&tree0, &xy0, _state);
                            kdtreequeryresultsxy(&tree1, &xy1, _state);
                            for(i=0; i<=k0-1; i++)
                            {
                                for(j=0; j<=nx+ny-1; j++)
                                {
                                    if( ae_fp_greater(ae_fabs(xy0.ptr.pp_double[i][j]-xy1.ptr.pp_double[i][j], _state),threshold) )
                                    {
                                        *err = ae_true;
                                        ae_frame_leave(_state);
                                        return;
                                    }
                                }
                            }
                            kdtreequeryresultstags(&tree0, &tags0, _state);
                            kdtreequeryresultstags(&tree1, &tags1, _state);
                            for(i=0; i<=k0-1; i++)
                            {
                                if( tags0.ptr.p_int[i]!=tags1.ptr.p_int[i] )
                                {
                                    *err = ae_true;
                                    ae_frame_leave(_state);
                                    return;
                                }
                            }
                        }
                    }
                }
            }
        }
        
        /*
         * Next N
         */
        n = n+25;
    }
    ae_frame_leave(_state);
}


/*************************************************************************
This function tests different special cases:
* Kd-tree for a zero number of points
* Kd-tree for array with a lot of duplicates (early versions of ALGLIB
  raised stack overflow on such datasets)

It returns True on errors, False on success.
*************************************************************************/
static ae_bool testnearestneighborunit_testspecialcases(ae_state *_state)
{
    ae_frame _frame_block;
    kdtree kdt;
    ae_matrix xy;
    ae_vector tags;
    ae_vector x;
    ae_int_t n;
    ae_int_t nk;
    ae_int_t nx;
    ae_int_t ny;
    ae_int_t normtype;
    ae_int_t i;
    ae_int_t j;
    double v;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    _kdtree_init(&kdt, _state);
    ae_matrix_init(&xy, 0, 0, DT_REAL, _state);
    ae_vector_init(&tags, 0, DT_INT, _state);
    ae_vector_init(&x, 0, DT_REAL, _state);

    result = ae_false;
    for(nx=1; nx<=3; nx++)
    {
        for(ny=0; ny<=3; ny++)
        {
            for(normtype=0; normtype<=2; normtype++)
            {
                
                /*
                 * Build tree
                 */
                if( ae_fp_greater(ae_randomreal(_state),0.5) )
                {
                    kdtreebuildtagged(&xy, &tags, 0, nx, ny, normtype, &kdt, _state);
                }
                else
                {
                    kdtreebuild(&xy, 0, nx, ny, normtype, &kdt, _state);
                }
                
                /*
                 * Test different queries
                 */
                ae_vector_set_length(&x, nx, _state);
                for(i=0; i<=nx-1; i++)
                {
                    x.ptr.p_double[i] = ae_randomreal(_state);
                }
                result = result||kdtreequeryknn(&kdt, &x, 1, ae_true, _state)>0;
                result = result||kdtreequeryrnn(&kdt, &x, 1.0E6, ae_true, _state)>0;
                result = result||kdtreequeryaknn(&kdt, &x, 1, ae_true, 2.0, _state)>0;
            }
        }
    }
    
    /*
     * Ability to handle array with a lot of duplicates without causing
     * stack overflow.
     *
     * Two situations are handled:
     * * array where ALL N elements are duplicates
     * * array where there are NK distinct elements and N-NK duplicates
     */
    nx = 2;
    ny = 1;
    n = 100000;
    nk = 100;
    v = ae_randomreal(_state);
    ae_matrix_set_length(&xy, n, nx+ny, _state);
    ae_vector_set_length(&x, nx, _state);
    for(i=0; i<=n-1; i++)
    {
        for(j=0; j<=nx+ny-1; j++)
        {
            xy.ptr.pp_double[i][j] = v;
        }
    }
    kdtreebuild(&xy, n, nx, ny, 2, &kdt, _state);
    for(j=0; j<=nx-1; j++)
    {
        x.ptr.p_double[j] = v;
    }
    result = result||kdtreequeryrnn(&kdt, &x, 0.0001, ae_true, _state)!=n;
    for(i=0; i<=nk-1; i++)
    {
        for(j=0; j<=nx+ny-1; j++)
        {
            xy.ptr.pp_double[i][j] = ae_randomreal(_state);
        }
    }
    kdtreebuild(&xy, n, nx, ny, 2, &kdt, _state);
    result = result||kdtreequeryrnn(&kdt, &x, 0.0001, ae_true, _state)<n-nk;
    ae_frame_leave(_state);
    return result;
}



static void testablasunit_naivematrixmatrixmultiply(/* Real    */ ae_matrix* a,
     ae_int_t ai1,
     ae_int_t ai2,
     ae_int_t aj1,
     ae_int_t aj2,
     ae_bool transa,
     /* Real    */ ae_matrix* b,
     ae_int_t bi1,
     ae_int_t bi2,
     ae_int_t bj1,
     ae_int_t bj2,
     ae_bool transb,
     double alpha,
     /* Real    */ ae_matrix* c,
     ae_int_t ci1,
     ae_int_t ci2,
     ae_int_t cj1,
     ae_int_t cj2,
     double beta,
     ae_state *_state);
static ae_bool testablasunit_testtrsm(ae_int_t minn,
     ae_int_t maxn,
     ae_state *_state);
static ae_bool testablasunit_testsyrk(ae_int_t minn,
     ae_int_t maxn,
     ae_state *_state);
static ae_bool testablasunit_testgemm(ae_int_t minn,
     ae_int_t maxn,
     ae_state *_state);
static ae_bool testablasunit_testtrans(ae_int_t minn,
     ae_int_t maxn,
     ae_state *_state);
static ae_bool testablasunit_testrank1(ae_int_t minn,
     ae_int_t maxn,
     ae_state *_state);
static ae_bool testablasunit_testmv(ae_int_t minn,
     ae_int_t maxn,
     ae_state *_state);
static ae_bool testablasunit_testcopy(ae_int_t minn,
     ae_int_t maxn,
     ae_state *_state);
static void testablasunit_refcmatrixrighttrsm(ae_int_t m,
     ae_int_t n,
     /* Complex */ ae_matrix* a,
     ae_int_t i1,
     ae_int_t j1,
     ae_bool isupper,
     ae_bool isunit,
     ae_int_t optype,
     /* Complex */ ae_matrix* x,
     ae_int_t i2,
     ae_int_t j2,
     ae_state *_state);
static void testablasunit_refcmatrixlefttrsm(ae_int_t m,
     ae_int_t n,
     /* Complex */ ae_matrix* a,
     ae_int_t i1,
     ae_int_t j1,
     ae_bool isupper,
     ae_bool isunit,
     ae_int_t optype,
     /* Complex */ ae_matrix* x,
     ae_int_t i2,
     ae_int_t j2,
     ae_state *_state);
static void testablasunit_refrmatrixrighttrsm(ae_int_t m,
     ae_int_t n,
     /* Real    */ ae_matrix* a,
     ae_int_t i1,
     ae_int_t j1,
     ae_bool isupper,
     ae_bool isunit,
     ae_int_t optype,
     /* Real    */ ae_matrix* x,
     ae_int_t i2,
     ae_int_t j2,
     ae_state *_state);
static void testablasunit_refrmatrixlefttrsm(ae_int_t m,
     ae_int_t n,
     /* Real    */ ae_matrix* a,
     ae_int_t i1,
     ae_int_t j1,
     ae_bool isupper,
     ae_bool isunit,
     ae_int_t optype,
     /* Real    */ ae_matrix* x,
     ae_int_t i2,
     ae_int_t j2,
     ae_state *_state);
static ae_bool testablasunit_internalcmatrixtrinverse(/* Complex */ ae_matrix* a,
     ae_int_t n,
     ae_bool isupper,
     ae_bool isunittriangular,
     ae_state *_state);
static ae_bool testablasunit_internalrmatrixtrinverse(/* Real    */ ae_matrix* a,
     ae_int_t n,
     ae_bool isupper,
     ae_bool isunittriangular,
     ae_state *_state);
static void testablasunit_refcmatrixherk(ae_int_t n,
     ae_int_t k,
     double alpha,
     /* Complex */ ae_matrix* a,
     ae_int_t ia,
     ae_int_t ja,
     ae_int_t optypea,
     double beta,
     /* Complex */ ae_matrix* c,
     ae_int_t ic,
     ae_int_t jc,
     ae_bool isupper,
     ae_state *_state);
static void testablasunit_refrmatrixsyrk(ae_int_t n,
     ae_int_t k,
     double alpha,
     /* Real    */ ae_matrix* a,
     ae_int_t ia,
     ae_int_t ja,
     ae_int_t optypea,
     double beta,
     /* Real    */ ae_matrix* c,
     ae_int_t ic,
     ae_int_t jc,
     ae_bool isupper,
     ae_state *_state);
static void testablasunit_refcmatrixgemm(ae_int_t m,
     ae_int_t n,
     ae_int_t k,
     ae_complex alpha,
     /* Complex */ ae_matrix* a,
     ae_int_t ia,
     ae_int_t ja,
     ae_int_t optypea,
     /* Complex */ ae_matrix* b,
     ae_int_t ib,
     ae_int_t jb,
     ae_int_t optypeb,
     ae_complex beta,
     /* Complex */ ae_matrix* c,
     ae_int_t ic,
     ae_int_t jc,
     ae_state *_state);
static void testablasunit_refrmatrixgemm(ae_int_t m,
     ae_int_t n,
     ae_int_t k,
     double alpha,
     /* Real    */ ae_matrix* a,
     ae_int_t ia,
     ae_int_t ja,
     ae_int_t optypea,
     /* Real    */ ae_matrix* b,
     ae_int_t ib,
     ae_int_t jb,
     ae_int_t optypeb,
     double beta,
     /* Real    */ ae_matrix* c,
     ae_int_t ic,
     ae_int_t jc,
     ae_state *_state);





ae_bool testablas(ae_bool silent, ae_state *_state)
{
    ae_frame _frame_block;
    double threshold;
    ae_bool trsmerrors;
    ae_bool syrkerrors;
    ae_bool gemmerrors;
    ae_bool transerrors;
    ae_bool rank1errors;
    ae_bool mverrors;
    ae_bool copyerrors;
    ae_bool waserrors;
    ae_matrix ra;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    ae_matrix_init(&ra, 0, 0, DT_REAL, _state);

    trsmerrors = ae_false;
    syrkerrors = ae_false;
    gemmerrors = ae_false;
    transerrors = ae_false;
    rank1errors = ae_false;
    mverrors = ae_false;
    copyerrors = ae_false;
    waserrors = ae_false;
    threshold = 10000*ae_machineepsilon;
    trsmerrors = trsmerrors||testablasunit_testtrsm(1, 3*ablasblocksize(&ra, _state)+1, _state);
    syrkerrors = syrkerrors||testablasunit_testsyrk(1, 3*ablasblocksize(&ra, _state)+1, _state);
    gemmerrors = gemmerrors||testablasunit_testgemm(1, 3*ablasblocksize(&ra, _state)+1, _state);
    transerrors = transerrors||testablasunit_testtrans(1, 3*ablasblocksize(&ra, _state)+1, _state);
    rank1errors = rank1errors||testablasunit_testrank1(1, 3*ablasblocksize(&ra, _state)+1, _state);
    mverrors = mverrors||testablasunit_testmv(1, 3*ablasblocksize(&ra, _state)+1, _state);
    copyerrors = copyerrors||testablasunit_testcopy(1, 3*ablasblocksize(&ra, _state)+1, _state);
    gemmerrors = gemmerrors||testablasunit_testgemm(8*ablasblocksize(&ra, _state)-1, 8*ablasblocksize(&ra, _state)+1, _state);
    
    /*
     * report
     */
    waserrors = (((((trsmerrors||syrkerrors)||gemmerrors)||transerrors)||rank1errors)||mverrors)||copyerrors;
    if( !silent )
    {
        printf("TESTING ABLAS\n");
        printf("* TRSM:                                  ");
        if( trsmerrors )
        {
            printf("FAILED\n");
        }
        else
        {
            printf("OK\n");
        }
        printf("* SYRK:                                  ");
        if( syrkerrors )
        {
            printf("FAILED\n");
        }
        else
        {
            printf("OK\n");
        }
        printf("* GEMM:                                  ");
        if( gemmerrors )
        {
            printf("FAILED\n");
        }
        else
        {
            printf("OK\n");
        }
        printf("* TRANS:                                 ");
        if( transerrors )
        {
            printf("FAILED\n");
        }
        else
        {
            printf("OK\n");
        }
        printf("* RANK1:                                 ");
        if( rank1errors )
        {
            printf("FAILED\n");
        }
        else
        {
            printf("OK\n");
        }
        printf("* MV:                                    ");
        if( mverrors )
        {
            printf("FAILED\n");
        }
        else
        {
            printf("OK\n");
        }
        printf("* COPY:                                  ");
        if( copyerrors )
        {
            printf("FAILED\n");
        }
        else
        {
            printf("OK\n");
        }
        if( waserrors )
        {
            printf("TEST FAILED\n");
        }
        else
        {
            printf("TEST PASSED\n");
        }
        printf("\n\n");
    }
    result = !waserrors;
    ae_frame_leave(_state);
    return result;
}


/*************************************************************************
Single-threaded stub. HPC ALGLIB replaces it by multithreaded code.
*************************************************************************/
ae_bool _pexec_testablas(ae_bool silent, ae_state *_state)
{
    return testablas(silent, _state);
}


static void testablasunit_naivematrixmatrixmultiply(/* Real    */ ae_matrix* a,
     ae_int_t ai1,
     ae_int_t ai2,
     ae_int_t aj1,
     ae_int_t aj2,
     ae_bool transa,
     /* Real    */ ae_matrix* b,
     ae_int_t bi1,
     ae_int_t bi2,
     ae_int_t bj1,
     ae_int_t bj2,
     ae_bool transb,
     double alpha,
     /* Real    */ ae_matrix* c,
     ae_int_t ci1,
     ae_int_t ci2,
     ae_int_t cj1,
     ae_int_t cj2,
     double beta,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_int_t arows;
    ae_int_t acols;
    ae_int_t brows;
    ae_int_t bcols;
    ae_int_t i;
    ae_int_t j;
    ae_int_t k;
    ae_int_t l;
    ae_int_t r;
    double v;
    ae_vector x1;
    ae_vector x2;

    ae_frame_make(_state, &_frame_block);
    ae_vector_init(&x1, 0, DT_REAL, _state);
    ae_vector_init(&x2, 0, DT_REAL, _state);

    
    /*
     * Setup
     */
    if( !transa )
    {
        arows = ai2-ai1+1;
        acols = aj2-aj1+1;
    }
    else
    {
        arows = aj2-aj1+1;
        acols = ai2-ai1+1;
    }
    if( !transb )
    {
        brows = bi2-bi1+1;
        bcols = bj2-bj1+1;
    }
    else
    {
        brows = bj2-bj1+1;
        bcols = bi2-bi1+1;
    }
    ae_assert(acols==brows, "NaiveMatrixMatrixMultiply: incorrect matrix sizes!", _state);
    if( ((arows<=0||acols<=0)||brows<=0)||bcols<=0 )
    {
        ae_frame_leave(_state);
        return;
    }
    l = arows;
    r = bcols;
    k = acols;
    ae_vector_set_length(&x1, k+1, _state);
    ae_vector_set_length(&x2, k+1, _state);
    for(i=1; i<=l; i++)
    {
        for(j=1; j<=r; j++)
        {
            if( !transa )
            {
                if( !transb )
                {
                    v = ae_v_dotproduct(&b->ptr.pp_double[bi1][bj1+j-1], b->stride, &a->ptr.pp_double[ai1+i-1][aj1], 1, ae_v_len(bi1,bi2));
                }
                else
                {
                    v = ae_v_dotproduct(&b->ptr.pp_double[bi1+j-1][bj1], 1, &a->ptr.pp_double[ai1+i-1][aj1], 1, ae_v_len(bj1,bj2));
                }
            }
            else
            {
                if( !transb )
                {
                    v = ae_v_dotproduct(&b->ptr.pp_double[bi1][bj1+j-1], b->stride, &a->ptr.pp_double[ai1][aj1+i-1], a->stride, ae_v_len(bi1,bi2));
                }
                else
                {
                    v = ae_v_dotproduct(&b->ptr.pp_double[bi1+j-1][bj1], 1, &a->ptr.pp_double[ai1][aj1+i-1], a->stride, ae_v_len(bj1,bj2));
                }
            }
            if( ae_fp_eq(beta,(double)(0)) )
            {
                c->ptr.pp_double[ci1+i-1][cj1+j-1] = alpha*v;
            }
            else
            {
                c->ptr.pp_double[ci1+i-1][cj1+j-1] = beta*c->ptr.pp_double[ci1+i-1][cj1+j-1]+alpha*v;
            }
        }
    }
    ae_frame_leave(_state);
}


/*************************************************************************
?Matrix????TRSM tests

Returns False for passed test, True - for failed
*************************************************************************/
static ae_bool testablasunit_testtrsm(ae_int_t minn,
     ae_int_t maxn,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_int_t n;
    ae_int_t m;
    ae_int_t mx;
    ae_int_t i;
    ae_int_t j;
    ae_int_t optype;
    ae_int_t uppertype;
    ae_int_t unittype;
    ae_int_t xoffsi;
    ae_int_t xoffsj;
    ae_int_t aoffsitype;
    ae_int_t aoffsjtype;
    ae_int_t aoffsi;
    ae_int_t aoffsj;
    ae_matrix refra;
    ae_matrix refrxl;
    ae_matrix refrxr;
    ae_matrix refca;
    ae_matrix refcxl;
    ae_matrix refcxr;
    ae_matrix ra;
    ae_matrix ca;
    ae_matrix rxr1;
    ae_matrix rxl1;
    ae_matrix cxr1;
    ae_matrix cxl1;
    ae_matrix rxr2;
    ae_matrix rxl2;
    ae_matrix cxr2;
    ae_matrix cxl2;
    double threshold;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    ae_matrix_init(&refra, 0, 0, DT_REAL, _state);
    ae_matrix_init(&refrxl, 0, 0, DT_REAL, _state);
    ae_matrix_init(&refrxr, 0, 0, DT_REAL, _state);
    ae_matrix_init(&refca, 0, 0, DT_COMPLEX, _state);
    ae_matrix_init(&refcxl, 0, 0, DT_COMPLEX, _state);
    ae_matrix_init(&refcxr, 0, 0, DT_COMPLEX, _state);
    ae_matrix_init(&ra, 0, 0, DT_REAL, _state);
    ae_matrix_init(&ca, 0, 0, DT_COMPLEX, _state);
    ae_matrix_init(&rxr1, 0, 0, DT_REAL, _state);
    ae_matrix_init(&rxl1, 0, 0, DT_REAL, _state);
    ae_matrix_init(&cxr1, 0, 0, DT_COMPLEX, _state);
    ae_matrix_init(&cxl1, 0, 0, DT_COMPLEX, _state);
    ae_matrix_init(&rxr2, 0, 0, DT_REAL, _state);
    ae_matrix_init(&rxl2, 0, 0, DT_REAL, _state);
    ae_matrix_init(&cxr2, 0, 0, DT_COMPLEX, _state);
    ae_matrix_init(&cxl2, 0, 0, DT_COMPLEX, _state);

    threshold = ae_sqr((double)(maxn), _state)*100*ae_machineepsilon;
    result = ae_false;
    for(mx=minn; mx<=maxn; mx++)
    {
        
        /*
         * Select random M/N in [1,MX] such that max(M,N)=MX
         */
        m = 1+ae_randominteger(mx, _state);
        n = 1+ae_randominteger(mx, _state);
        if( ae_fp_greater(ae_randomreal(_state),0.5) )
        {
            m = mx;
        }
        else
        {
            n = mx;
        }
        
        /*
         * Initialize RefRA/RefCA by random matrices whose upper
         * and lower triangle submatrices are non-degenerate
         * well-conditioned matrices.
         *
         * Matrix size is 2Mx2M (four copies of same MxM matrix
         * to test different offsets)
         */
        ae_matrix_set_length(&refra, 2*m, 2*m, _state);
        for(i=0; i<=m-1; i++)
        {
            for(j=0; j<=m-1; j++)
            {
                refra.ptr.pp_double[i][j] = 0.2*ae_randomreal(_state)-0.1;
            }
        }
        for(i=0; i<=m-1; i++)
        {
            refra.ptr.pp_double[i][i] = (2*ae_randominteger(1, _state)-1)*(2*m+ae_randomreal(_state));
        }
        for(i=0; i<=m-1; i++)
        {
            for(j=0; j<=m-1; j++)
            {
                refra.ptr.pp_double[i+m][j] = refra.ptr.pp_double[i][j];
                refra.ptr.pp_double[i][j+m] = refra.ptr.pp_double[i][j];
                refra.ptr.pp_double[i+m][j+m] = refra.ptr.pp_double[i][j];
            }
        }
        ae_matrix_set_length(&refca, 2*m, 2*m, _state);
        for(i=0; i<=m-1; i++)
        {
            for(j=0; j<=m-1; j++)
            {
                refca.ptr.pp_complex[i][j].x = 0.2*ae_randomreal(_state)-0.1;
                refca.ptr.pp_complex[i][j].y = 0.2*ae_randomreal(_state)-0.1;
            }
        }
        for(i=0; i<=m-1; i++)
        {
            refca.ptr.pp_complex[i][i].x = (2*ae_randominteger(2, _state)-1)*(2*m+ae_randomreal(_state));
            refca.ptr.pp_complex[i][i].y = (2*ae_randominteger(2, _state)-1)*(2*m+ae_randomreal(_state));
        }
        for(i=0; i<=m-1; i++)
        {
            for(j=0; j<=m-1; j++)
            {
                refca.ptr.pp_complex[i+m][j] = refca.ptr.pp_complex[i][j];
                refca.ptr.pp_complex[i][j+m] = refca.ptr.pp_complex[i][j];
                refca.ptr.pp_complex[i+m][j+m] = refca.ptr.pp_complex[i][j];
            }
        }
        
        /*
         * Generate random XL/XR.
         *
         * XR is NxM matrix (matrix for 'Right' subroutines)
         * XL is MxN matrix (matrix for 'Left' subroutines)
         */
        ae_matrix_set_length(&refrxr, n, m, _state);
        for(i=0; i<=n-1; i++)
        {
            for(j=0; j<=m-1; j++)
            {
                refrxr.ptr.pp_double[i][j] = 2*ae_randomreal(_state)-1;
            }
        }
        ae_matrix_set_length(&refrxl, m, n, _state);
        for(i=0; i<=m-1; i++)
        {
            for(j=0; j<=n-1; j++)
            {
                refrxl.ptr.pp_double[i][j] = 2*ae_randomreal(_state)-1;
            }
        }
        ae_matrix_set_length(&refcxr, n, m, _state);
        for(i=0; i<=n-1; i++)
        {
            for(j=0; j<=m-1; j++)
            {
                refcxr.ptr.pp_complex[i][j].x = 2*ae_randomreal(_state)-1;
                refcxr.ptr.pp_complex[i][j].y = 2*ae_randomreal(_state)-1;
            }
        }
        ae_matrix_set_length(&refcxl, m, n, _state);
        for(i=0; i<=m-1; i++)
        {
            for(j=0; j<=n-1; j++)
            {
                refcxl.ptr.pp_complex[i][j].x = 2*ae_randomreal(_state)-1;
                refcxl.ptr.pp_complex[i][j].y = 2*ae_randomreal(_state)-1;
            }
        }
        
        /*
         * test different types of operations, offsets, and so on...
         *
         * to avoid unnecessary slowdown we don't test ALL possible
         * combinations of operation types. We just generate one random
         * set of parameters and test it.
         */
        ae_matrix_set_length(&ra, 2*m, 2*m, _state);
        ae_matrix_set_length(&rxr1, n, m, _state);
        ae_matrix_set_length(&rxr2, n, m, _state);
        ae_matrix_set_length(&rxl1, m, n, _state);
        ae_matrix_set_length(&rxl2, m, n, _state);
        ae_matrix_set_length(&ca, 2*m, 2*m, _state);
        ae_matrix_set_length(&cxr1, n, m, _state);
        ae_matrix_set_length(&cxr2, n, m, _state);
        ae_matrix_set_length(&cxl1, m, n, _state);
        ae_matrix_set_length(&cxl2, m, n, _state);
        optype = ae_randominteger(3, _state);
        uppertype = ae_randominteger(2, _state);
        unittype = ae_randominteger(2, _state);
        xoffsi = ae_randominteger(2, _state);
        xoffsj = ae_randominteger(2, _state);
        aoffsitype = ae_randominteger(2, _state);
        aoffsjtype = ae_randominteger(2, _state);
        aoffsi = m*aoffsitype;
        aoffsj = m*aoffsjtype;
        
        /*
         * copy A, XR, XL (fill unused parts with random garbage)
         */
        for(i=0; i<=2*m-1; i++)
        {
            for(j=0; j<=2*m-1; j++)
            {
                if( ((i>=aoffsi&&i<aoffsi+m)&&j>=aoffsj)&&j<aoffsj+m )
                {
                    ca.ptr.pp_complex[i][j] = refca.ptr.pp_complex[i][j];
                    ra.ptr.pp_double[i][j] = refra.ptr.pp_double[i][j];
                }
                else
                {
                    ca.ptr.pp_complex[i][j] = ae_complex_from_d(ae_randomreal(_state));
                    ra.ptr.pp_double[i][j] = ae_randomreal(_state);
                }
            }
        }
        for(i=0; i<=n-1; i++)
        {
            for(j=0; j<=m-1; j++)
            {
                if( i>=xoffsi&&j>=xoffsj )
                {
                    cxr1.ptr.pp_complex[i][j] = refcxr.ptr.pp_complex[i][j];
                    cxr2.ptr.pp_complex[i][j] = refcxr.ptr.pp_complex[i][j];
                    rxr1.ptr.pp_double[i][j] = refrxr.ptr.pp_double[i][j];
                    rxr2.ptr.pp_double[i][j] = refrxr.ptr.pp_double[i][j];
                }
                else
                {
                    cxr1.ptr.pp_complex[i][j] = ae_complex_from_d(ae_randomreal(_state));
                    cxr2.ptr.pp_complex[i][j] = cxr1.ptr.pp_complex[i][j];
                    rxr1.ptr.pp_double[i][j] = ae_randomreal(_state);
                    rxr2.ptr.pp_double[i][j] = rxr1.ptr.pp_double[i][j];
                }
            }
        }
        for(i=0; i<=m-1; i++)
        {
            for(j=0; j<=n-1; j++)
            {
                if( i>=xoffsi&&j>=xoffsj )
                {
                    cxl1.ptr.pp_complex[i][j] = refcxl.ptr.pp_complex[i][j];
                    cxl2.ptr.pp_complex[i][j] = refcxl.ptr.pp_complex[i][j];
                    rxl1.ptr.pp_double[i][j] = refrxl.ptr.pp_double[i][j];
                    rxl2.ptr.pp_double[i][j] = refrxl.ptr.pp_double[i][j];
                }
                else
                {
                    cxl1.ptr.pp_complex[i][j] = ae_complex_from_d(ae_randomreal(_state));
                    cxl2.ptr.pp_complex[i][j] = cxl1.ptr.pp_complex[i][j];
                    rxl1.ptr.pp_double[i][j] = ae_randomreal(_state);
                    rxl2.ptr.pp_double[i][j] = rxl1.ptr.pp_double[i][j];
                }
            }
        }
        
        /*
         * Test CXR
         */
        cmatrixrighttrsm(n-xoffsi, m-xoffsj, &ca, aoffsi, aoffsj, uppertype==0, unittype==0, optype, &cxr1, xoffsi, xoffsj, _state);
        testablasunit_refcmatrixrighttrsm(n-xoffsi, m-xoffsj, &ca, aoffsi, aoffsj, uppertype==0, unittype==0, optype, &cxr2, xoffsi, xoffsj, _state);
        for(i=0; i<=n-1; i++)
        {
            for(j=0; j<=m-1; j++)
            {
                result = result||ae_fp_greater(ae_c_abs(ae_c_sub(cxr1.ptr.pp_complex[i][j],cxr2.ptr.pp_complex[i][j]), _state),threshold);
            }
        }
        
        /*
         * Test CXL
         */
        cmatrixlefttrsm(m-xoffsi, n-xoffsj, &ca, aoffsi, aoffsj, uppertype==0, unittype==0, optype, &cxl1, xoffsi, xoffsj, _state);
        testablasunit_refcmatrixlefttrsm(m-xoffsi, n-xoffsj, &ca, aoffsi, aoffsj, uppertype==0, unittype==0, optype, &cxl2, xoffsi, xoffsj, _state);
        for(i=0; i<=m-1; i++)
        {
            for(j=0; j<=n-1; j++)
            {
                result = result||ae_fp_greater(ae_c_abs(ae_c_sub(cxl1.ptr.pp_complex[i][j],cxl2.ptr.pp_complex[i][j]), _state),threshold);
            }
        }
        if( optype<2 )
        {
            
            /*
             * Test RXR
             */
            rmatrixrighttrsm(n-xoffsi, m-xoffsj, &ra, aoffsi, aoffsj, uppertype==0, unittype==0, optype, &rxr1, xoffsi, xoffsj, _state);
            testablasunit_refrmatrixrighttrsm(n-xoffsi, m-xoffsj, &ra, aoffsi, aoffsj, uppertype==0, unittype==0, optype, &rxr2, xoffsi, xoffsj, _state);
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=m-1; j++)
                {
                    result = result||ae_fp_greater(ae_fabs(rxr1.ptr.pp_double[i][j]-rxr2.ptr.pp_double[i][j], _state),threshold);
                }
            }
            
            /*
             * Test RXL
             */
            rmatrixlefttrsm(m-xoffsi, n-xoffsj, &ra, aoffsi, aoffsj, uppertype==0, unittype==0, optype, &rxl1, xoffsi, xoffsj, _state);
            testablasunit_refrmatrixlefttrsm(m-xoffsi, n-xoffsj, &ra, aoffsi, aoffsj, uppertype==0, unittype==0, optype, &rxl2, xoffsi, xoffsj, _state);
            for(i=0; i<=m-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    result = result||ae_fp_greater(ae_fabs(rxl1.ptr.pp_double[i][j]-rxl2.ptr.pp_double[i][j], _state),threshold);
                }
            }
        }
    }
    ae_frame_leave(_state);
    return result;
}


/*************************************************************************
SYRK tests

Returns False for passed test, True - for failed
*************************************************************************/
static ae_bool testablasunit_testsyrk(ae_int_t minn,
     ae_int_t maxn,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_int_t n;
    ae_int_t k;
    ae_int_t mx;
    ae_int_t i;
    ae_int_t j;
    ae_int_t uppertype;
    ae_int_t xoffsi;
    ae_int_t xoffsj;
    ae_int_t aoffsitype;
    ae_int_t aoffsjtype;
    ae_int_t aoffsi;
    ae_int_t aoffsj;
    ae_int_t alphatype;
    ae_int_t betatype;
    ae_matrix refra;
    ae_matrix refrc;
    ae_matrix refca;
    ae_matrix refcc;
    double alpha;
    double beta;
    ae_matrix ra1;
    ae_matrix ra2;
    ae_matrix ca1;
    ae_matrix ca2;
    ae_matrix rc;
    ae_matrix rct;
    ae_matrix cc;
    ae_matrix cct;
    double threshold;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    ae_matrix_init(&refra, 0, 0, DT_REAL, _state);
    ae_matrix_init(&refrc, 0, 0, DT_REAL, _state);
    ae_matrix_init(&refca, 0, 0, DT_COMPLEX, _state);
    ae_matrix_init(&refcc, 0, 0, DT_COMPLEX, _state);
    ae_matrix_init(&ra1, 0, 0, DT_REAL, _state);
    ae_matrix_init(&ra2, 0, 0, DT_REAL, _state);
    ae_matrix_init(&ca1, 0, 0, DT_COMPLEX, _state);
    ae_matrix_init(&ca2, 0, 0, DT_COMPLEX, _state);
    ae_matrix_init(&rc, 0, 0, DT_REAL, _state);
    ae_matrix_init(&rct, 0, 0, DT_REAL, _state);
    ae_matrix_init(&cc, 0, 0, DT_COMPLEX, _state);
    ae_matrix_init(&cct, 0, 0, DT_COMPLEX, _state);

    threshold = maxn*100*ae_machineepsilon;
    result = ae_false;
    for(mx=minn; mx<=maxn; mx++)
    {
        
        /*
         * Select random M/N in [1,MX] such that max(M,N)=MX
         */
        k = 1+ae_randominteger(mx, _state);
        n = 1+ae_randominteger(mx, _state);
        if( ae_fp_greater(ae_randomreal(_state),0.5) )
        {
            k = mx;
        }
        else
        {
            n = mx;
        }
        
        /*
         * Initialize RefRA/RefCA by random Hermitian matrices,
         * RefRC/RefCC by random matrices
         *
         * RA/CA size is 2Nx2N (four copies of same NxN matrix
         * to test different offsets)
         */
        ae_matrix_set_length(&refra, 2*n, 2*n, _state);
        ae_matrix_set_length(&refca, 2*n, 2*n, _state);
        for(i=0; i<=n-1; i++)
        {
            refra.ptr.pp_double[i][i] = 2*ae_randomreal(_state)-1;
            refca.ptr.pp_complex[i][i] = ae_complex_from_d(2*ae_randomreal(_state)-1);
            for(j=i+1; j<=n-1; j++)
            {
                refra.ptr.pp_double[i][j] = 2*ae_randomreal(_state)-1;
                refca.ptr.pp_complex[i][j].x = 2*ae_randomreal(_state)-1;
                refca.ptr.pp_complex[i][j].y = 2*ae_randomreal(_state)-1;
                refra.ptr.pp_double[j][i] = refra.ptr.pp_double[i][j];
                refca.ptr.pp_complex[j][i] = ae_c_conj(refca.ptr.pp_complex[i][j], _state);
            }
        }
        for(i=0; i<=n-1; i++)
        {
            for(j=0; j<=n-1; j++)
            {
                refra.ptr.pp_double[i+n][j] = refra.ptr.pp_double[i][j];
                refra.ptr.pp_double[i][j+n] = refra.ptr.pp_double[i][j];
                refra.ptr.pp_double[i+n][j+n] = refra.ptr.pp_double[i][j];
                refca.ptr.pp_complex[i+n][j] = refca.ptr.pp_complex[i][j];
                refca.ptr.pp_complex[i][j+n] = refca.ptr.pp_complex[i][j];
                refca.ptr.pp_complex[i+n][j+n] = refca.ptr.pp_complex[i][j];
            }
        }
        ae_matrix_set_length(&refrc, n, k, _state);
        ae_matrix_set_length(&refcc, n, k, _state);
        for(i=0; i<=n-1; i++)
        {
            for(j=0; j<=k-1; j++)
            {
                refrc.ptr.pp_double[i][j] = 2*ae_randomreal(_state)-1;
                refcc.ptr.pp_complex[i][j].x = 2*ae_randomreal(_state)-1;
                refcc.ptr.pp_complex[i][j].y = 2*ae_randomreal(_state)-1;
            }
        }
        
        /*
         * test different types of operations, offsets, and so on...
         *
         * to avoid unnecessary slowdown we don't test ALL possible
         * combinations of operation types. We just generate one random
         * set of parameters and test it.
         */
        ae_matrix_set_length(&ra1, 2*n, 2*n, _state);
        ae_matrix_set_length(&ra2, 2*n, 2*n, _state);
        ae_matrix_set_length(&ca1, 2*n, 2*n, _state);
        ae_matrix_set_length(&ca2, 2*n, 2*n, _state);
        ae_matrix_set_length(&rc, n, k, _state);
        ae_matrix_set_length(&rct, k, n, _state);
        ae_matrix_set_length(&cc, n, k, _state);
        ae_matrix_set_length(&cct, k, n, _state);
        uppertype = ae_randominteger(2, _state);
        xoffsi = ae_randominteger(2, _state);
        xoffsj = ae_randominteger(2, _state);
        aoffsitype = ae_randominteger(2, _state);
        aoffsjtype = ae_randominteger(2, _state);
        alphatype = ae_randominteger(2, _state);
        betatype = ae_randominteger(2, _state);
        aoffsi = n*aoffsitype;
        aoffsj = n*aoffsjtype;
        alpha = alphatype*(2*ae_randomreal(_state)-1);
        beta = betatype*(2*ae_randomreal(_state)-1);
        
        /*
         * copy A, C (fill unused parts with random garbage)
         */
        for(i=0; i<=2*n-1; i++)
        {
            for(j=0; j<=2*n-1; j++)
            {
                if( ((i>=aoffsi&&i<aoffsi+n)&&j>=aoffsj)&&j<aoffsj+n )
                {
                    ca1.ptr.pp_complex[i][j] = refca.ptr.pp_complex[i][j];
                    ca2.ptr.pp_complex[i][j] = refca.ptr.pp_complex[i][j];
                    ra1.ptr.pp_double[i][j] = refra.ptr.pp_double[i][j];
                    ra2.ptr.pp_double[i][j] = refra.ptr.pp_double[i][j];
                }
                else
                {
                    ca1.ptr.pp_complex[i][j] = ae_complex_from_d(ae_randomreal(_state));
                    ca2.ptr.pp_complex[i][j] = ca1.ptr.pp_complex[i][j];
                    ra1.ptr.pp_double[i][j] = ae_randomreal(_state);
                    ra2.ptr.pp_double[i][j] = ra1.ptr.pp_double[i][j];
                }
            }
        }
        for(i=0; i<=n-1; i++)
        {
            for(j=0; j<=k-1; j++)
            {
                if( i>=xoffsi&&j>=xoffsj )
                {
                    rc.ptr.pp_double[i][j] = refrc.ptr.pp_double[i][j];
                    rct.ptr.pp_double[j][i] = refrc.ptr.pp_double[i][j];
                    cc.ptr.pp_complex[i][j] = refcc.ptr.pp_complex[i][j];
                    cct.ptr.pp_complex[j][i] = refcc.ptr.pp_complex[i][j];
                }
                else
                {
                    rc.ptr.pp_double[i][j] = ae_randomreal(_state);
                    rct.ptr.pp_double[j][i] = rc.ptr.pp_double[i][j];
                    cc.ptr.pp_complex[i][j] = ae_complex_from_d(ae_randomreal(_state));
                    cct.ptr.pp_complex[j][i] = cct.ptr.pp_complex[j][i];
                }
            }
        }
        
        /*
         * Test complex
         * Only one of transform types is selected and tested
         */
        if( ae_fp_greater(ae_randomreal(_state),0.5) )
        {
            cmatrixherk(n-xoffsi, k-xoffsj, alpha, &cc, xoffsi, xoffsj, 0, beta, &ca1, aoffsi, aoffsj, uppertype==0, _state);
            testablasunit_refcmatrixherk(n-xoffsi, k-xoffsj, alpha, &cc, xoffsi, xoffsj, 0, beta, &ca2, aoffsi, aoffsj, uppertype==0, _state);
        }
        else
        {
            cmatrixherk(n-xoffsi, k-xoffsj, alpha, &cct, xoffsj, xoffsi, 2, beta, &ca1, aoffsi, aoffsj, uppertype==0, _state);
            testablasunit_refcmatrixherk(n-xoffsi, k-xoffsj, alpha, &cct, xoffsj, xoffsi, 2, beta, &ca2, aoffsi, aoffsj, uppertype==0, _state);
        }
        for(i=0; i<=n-1; i++)
        {
            for(j=0; j<=n-1; j++)
            {
                result = result||ae_fp_greater(ae_c_abs(ae_c_sub(ca1.ptr.pp_complex[i][j],ca2.ptr.pp_complex[i][j]), _state),threshold);
            }
        }
        
        /*
         * Test old version of HERK (named SYRK)
         * Only one of transform types is selected and tested
         */
        if( ae_fp_greater(ae_randomreal(_state),0.5) )
        {
            cmatrixsyrk(n-xoffsi, k-xoffsj, alpha, &cc, xoffsi, xoffsj, 0, beta, &ca1, aoffsi, aoffsj, uppertype==0, _state);
            testablasunit_refcmatrixherk(n-xoffsi, k-xoffsj, alpha, &cc, xoffsi, xoffsj, 0, beta, &ca2, aoffsi, aoffsj, uppertype==0, _state);
        }
        else
        {
            cmatrixsyrk(n-xoffsi, k-xoffsj, alpha, &cct, xoffsj, xoffsi, 2, beta, &ca1, aoffsi, aoffsj, uppertype==0, _state);
            testablasunit_refcmatrixherk(n-xoffsi, k-xoffsj, alpha, &cct, xoffsj, xoffsi, 2, beta, &ca2, aoffsi, aoffsj, uppertype==0, _state);
        }
        for(i=0; i<=n-1; i++)
        {
            for(j=0; j<=n-1; j++)
            {
                result = result||ae_fp_greater(ae_c_abs(ae_c_sub(ca1.ptr.pp_complex[i][j],ca2.ptr.pp_complex[i][j]), _state),threshold);
            }
        }
        
        /*
         * Test real
         * Only one of transform types is selected and tested
         */
        if( ae_fp_greater(ae_randomreal(_state),0.5) )
        {
            rmatrixsyrk(n-xoffsi, k-xoffsj, alpha, &rc, xoffsi, xoffsj, 0, beta, &ra1, aoffsi, aoffsj, uppertype==0, _state);
            testablasunit_refrmatrixsyrk(n-xoffsi, k-xoffsj, alpha, &rc, xoffsi, xoffsj, 0, beta, &ra2, aoffsi, aoffsj, uppertype==0, _state);
        }
        else
        {
            rmatrixsyrk(n-xoffsi, k-xoffsj, alpha, &rct, xoffsj, xoffsi, 1, beta, &ra1, aoffsi, aoffsj, uppertype==0, _state);
            testablasunit_refrmatrixsyrk(n-xoffsi, k-xoffsj, alpha, &rct, xoffsj, xoffsi, 1, beta, &ra2, aoffsi, aoffsj, uppertype==0, _state);
        }
        for(i=0; i<=n-1; i++)
        {
            for(j=0; j<=n-1; j++)
            {
                result = result||ae_fp_greater(ae_fabs(ra1.ptr.pp_double[i][j]-ra2.ptr.pp_double[i][j], _state),threshold);
            }
        }
    }
    ae_frame_leave(_state);
    return result;
}


/*************************************************************************
GEMM tests

Returns False for passed test, True - for failed
*************************************************************************/
static ae_bool testablasunit_testgemm(ae_int_t minn,
     ae_int_t maxn,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_int_t m;
    ae_int_t n;
    ae_int_t k;
    ae_int_t mx;
    ae_int_t i;
    ae_int_t j;
    ae_int_t aoffsi;
    ae_int_t aoffsj;
    ae_int_t aoptype;
    ae_int_t aoptyper;
    ae_int_t boffsi;
    ae_int_t boffsj;
    ae_int_t boptype;
    ae_int_t boptyper;
    ae_int_t coffsi;
    ae_int_t coffsj;
    ae_matrix refra;
    ae_matrix refrb;
    ae_matrix refrc;
    ae_matrix refca;
    ae_matrix refcb;
    ae_matrix refcc;
    double alphar;
    double betar;
    ae_complex alphac;
    ae_complex betac;
    ae_matrix rc1;
    ae_matrix rc2;
    ae_matrix cc1;
    ae_matrix cc2;
    double threshold;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    ae_matrix_init(&refra, 0, 0, DT_REAL, _state);
    ae_matrix_init(&refrb, 0, 0, DT_REAL, _state);
    ae_matrix_init(&refrc, 0, 0, DT_REAL, _state);
    ae_matrix_init(&refca, 0, 0, DT_COMPLEX, _state);
    ae_matrix_init(&refcb, 0, 0, DT_COMPLEX, _state);
    ae_matrix_init(&refcc, 0, 0, DT_COMPLEX, _state);
    ae_matrix_init(&rc1, 0, 0, DT_REAL, _state);
    ae_matrix_init(&rc2, 0, 0, DT_REAL, _state);
    ae_matrix_init(&cc1, 0, 0, DT_COMPLEX, _state);
    ae_matrix_init(&cc2, 0, 0, DT_COMPLEX, _state);

    threshold = maxn*100*ae_machineepsilon;
    result = ae_false;
    for(mx=minn; mx<=maxn; mx++)
    {
        
        /*
         * Select random M/N/K in [1,MX] such that max(M,N,K)=MX
         */
        m = 1+ae_randominteger(mx, _state);
        n = 1+ae_randominteger(mx, _state);
        k = 1+ae_randominteger(mx, _state);
        i = ae_randominteger(3, _state);
        if( i==0 )
        {
            m = mx;
        }
        if( i==1 )
        {
            n = mx;
        }
        if( i==2 )
        {
            k = mx;
        }
        
        /*
         * Initialize A/B/C by random matrices with size (MaxN+1)*(MaxN+1)
         */
        ae_matrix_set_length(&refra, maxn+1, maxn+1, _state);
        ae_matrix_set_length(&refrb, maxn+1, maxn+1, _state);
        ae_matrix_set_length(&refrc, maxn+1, maxn+1, _state);
        ae_matrix_set_length(&refca, maxn+1, maxn+1, _state);
        ae_matrix_set_length(&refcb, maxn+1, maxn+1, _state);
        ae_matrix_set_length(&refcc, maxn+1, maxn+1, _state);
        for(i=0; i<=maxn; i++)
        {
            for(j=0; j<=maxn; j++)
            {
                refra.ptr.pp_double[i][j] = 2*ae_randomreal(_state)-1;
                refrb.ptr.pp_double[i][j] = 2*ae_randomreal(_state)-1;
                refrc.ptr.pp_double[i][j] = 2*ae_randomreal(_state)-1;
                refca.ptr.pp_complex[i][j].x = 2*ae_randomreal(_state)-1;
                refca.ptr.pp_complex[i][j].y = 2*ae_randomreal(_state)-1;
                refcb.ptr.pp_complex[i][j].x = 2*ae_randomreal(_state)-1;
                refcb.ptr.pp_complex[i][j].y = 2*ae_randomreal(_state)-1;
                refcc.ptr.pp_complex[i][j].x = 2*ae_randomreal(_state)-1;
                refcc.ptr.pp_complex[i][j].y = 2*ae_randomreal(_state)-1;
            }
        }
        
        /*
         * test different types of operations, offsets, and so on...
         *
         * to avoid unnecessary slowdown we don't test ALL possible
         * combinations of operation types. We just generate one random
         * set of parameters and test it.
         */
        ae_matrix_set_length(&rc1, maxn+1, maxn+1, _state);
        ae_matrix_set_length(&rc2, maxn+1, maxn+1, _state);
        ae_matrix_set_length(&cc1, maxn+1, maxn+1, _state);
        ae_matrix_set_length(&cc2, maxn+1, maxn+1, _state);
        aoffsi = ae_randominteger(2, _state);
        aoffsj = ae_randominteger(2, _state);
        aoptype = ae_randominteger(3, _state);
        aoptyper = ae_randominteger(2, _state);
        boffsi = ae_randominteger(2, _state);
        boffsj = ae_randominteger(2, _state);
        boptype = ae_randominteger(3, _state);
        boptyper = ae_randominteger(2, _state);
        coffsi = ae_randominteger(2, _state);
        coffsj = ae_randominteger(2, _state);
        alphar = ae_randominteger(2, _state)*(2*ae_randomreal(_state)-1);
        betar = ae_randominteger(2, _state)*(2*ae_randomreal(_state)-1);
        if( ae_fp_greater(ae_randomreal(_state),0.5) )
        {
            alphac.x = 2*ae_randomreal(_state)-1;
            alphac.y = 2*ae_randomreal(_state)-1;
        }
        else
        {
            alphac = ae_complex_from_i(0);
        }
        if( ae_fp_greater(ae_randomreal(_state),0.5) )
        {
            betac.x = 2*ae_randomreal(_state)-1;
            betac.y = 2*ae_randomreal(_state)-1;
        }
        else
        {
            betac = ae_complex_from_i(0);
        }
        
        /*
         * copy C
         */
        for(i=0; i<=maxn; i++)
        {
            for(j=0; j<=maxn; j++)
            {
                rc1.ptr.pp_double[i][j] = refrc.ptr.pp_double[i][j];
                rc2.ptr.pp_double[i][j] = refrc.ptr.pp_double[i][j];
                cc1.ptr.pp_complex[i][j] = refcc.ptr.pp_complex[i][j];
                cc2.ptr.pp_complex[i][j] = refcc.ptr.pp_complex[i][j];
            }
        }
        
        /*
         * Test complex
         */
        cmatrixgemm(m, n, k, alphac, &refca, aoffsi, aoffsj, aoptype, &refcb, boffsi, boffsj, boptype, betac, &cc1, coffsi, coffsj, _state);
        testablasunit_refcmatrixgemm(m, n, k, alphac, &refca, aoffsi, aoffsj, aoptype, &refcb, boffsi, boffsj, boptype, betac, &cc2, coffsi, coffsj, _state);
        for(i=0; i<=maxn; i++)
        {
            for(j=0; j<=maxn; j++)
            {
                result = result||ae_fp_greater(ae_c_abs(ae_c_sub(cc1.ptr.pp_complex[i][j],cc2.ptr.pp_complex[i][j]), _state),threshold);
            }
        }
        
        /*
         * Test real
         */
        rmatrixgemm(m, n, k, alphar, &refra, aoffsi, aoffsj, aoptyper, &refrb, boffsi, boffsj, boptyper, betar, &rc1, coffsi, coffsj, _state);
        testablasunit_refrmatrixgemm(m, n, k, alphar, &refra, aoffsi, aoffsj, aoptyper, &refrb, boffsi, boffsj, boptyper, betar, &rc2, coffsi, coffsj, _state);
        for(i=0; i<=maxn; i++)
        {
            for(j=0; j<=maxn; j++)
            {
                result = result||ae_fp_greater(ae_fabs(rc1.ptr.pp_double[i][j]-rc2.ptr.pp_double[i][j], _state),threshold);
            }
        }
    }
    ae_frame_leave(_state);
    return result;
}


/*************************************************************************
transpose tests

Returns False for passed test, True - for failed
*************************************************************************/
static ae_bool testablasunit_testtrans(ae_int_t minn,
     ae_int_t maxn,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_int_t m;
    ae_int_t n;
    ae_int_t mx;
    ae_int_t i;
    ae_int_t j;
    ae_int_t aoffsi;
    ae_int_t aoffsj;
    ae_int_t boffsi;
    ae_int_t boffsj;
    double v1;
    double v2;
    double threshold;
    ae_matrix refra;
    ae_matrix refrb;
    ae_matrix refca;
    ae_matrix refcb;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    ae_matrix_init(&refra, 0, 0, DT_REAL, _state);
    ae_matrix_init(&refrb, 0, 0, DT_REAL, _state);
    ae_matrix_init(&refca, 0, 0, DT_COMPLEX, _state);
    ae_matrix_init(&refcb, 0, 0, DT_COMPLEX, _state);

    result = ae_false;
    threshold = 1000*ae_machineepsilon;
    for(mx=minn; mx<=maxn; mx++)
    {
        
        /*
         * Select random M/N in [1,MX] such that max(M,N)=MX
         * Generate random V1 and V2 which are used to fill
         * RefRB/RefCB with control values.
         */
        m = 1+ae_randominteger(mx, _state);
        n = 1+ae_randominteger(mx, _state);
        if( ae_randominteger(2, _state)==0 )
        {
            m = mx;
        }
        else
        {
            n = mx;
        }
        v1 = ae_randomreal(_state);
        v2 = ae_randomreal(_state);
        
        /*
         * Initialize A by random matrix with size (MaxN+1)*(MaxN+1)
         * Fill B with control values
         */
        ae_matrix_set_length(&refra, maxn+1, maxn+1, _state);
        ae_matrix_set_length(&refrb, maxn+1, maxn+1, _state);
        ae_matrix_set_length(&refca, maxn+1, maxn+1, _state);
        ae_matrix_set_length(&refcb, maxn+1, maxn+1, _state);
        for(i=0; i<=maxn; i++)
        {
            for(j=0; j<=maxn; j++)
            {
                refra.ptr.pp_double[i][j] = 2*ae_randomreal(_state)-1;
                refca.ptr.pp_complex[i][j].x = 2*ae_randomreal(_state)-1;
                refca.ptr.pp_complex[i][j].y = 2*ae_randomreal(_state)-1;
                refrb.ptr.pp_double[i][j] = i*v1+j*v2;
                refcb.ptr.pp_complex[i][j] = ae_complex_from_d(i*v1+j*v2);
            }
        }
        
        /*
         * test different offsets (zero or one)
         *
         * to avoid unnecessary slowdown we don't test ALL possible
         * combinations of operation types. We just generate one random
         * set of parameters and test it.
         */
        aoffsi = ae_randominteger(2, _state);
        aoffsj = ae_randominteger(2, _state);
        boffsi = ae_randominteger(2, _state);
        boffsj = ae_randominteger(2, _state);
        rmatrixtranspose(m, n, &refra, aoffsi, aoffsj, &refrb, boffsi, boffsj, _state);
        for(i=0; i<=maxn; i++)
        {
            for(j=0; j<=maxn; j++)
            {
                if( ((i<boffsi||i>=boffsi+n)||j<boffsj)||j>=boffsj+m )
                {
                    result = result||ae_fp_greater(ae_fabs(refrb.ptr.pp_double[i][j]-(v1*i+v2*j), _state),threshold);
                }
                else
                {
                    result = result||ae_fp_greater(ae_fabs(refrb.ptr.pp_double[i][j]-refra.ptr.pp_double[aoffsi+j-boffsj][aoffsj+i-boffsi], _state),threshold);
                }
            }
        }
        cmatrixtranspose(m, n, &refca, aoffsi, aoffsj, &refcb, boffsi, boffsj, _state);
        for(i=0; i<=maxn; i++)
        {
            for(j=0; j<=maxn; j++)
            {
                if( ((i<boffsi||i>=boffsi+n)||j<boffsj)||j>=boffsj+m )
                {
                    result = result||ae_fp_greater(ae_c_abs(ae_c_sub_d(refcb.ptr.pp_complex[i][j],v1*i+v2*j), _state),threshold);
                }
                else
                {
                    result = result||ae_fp_greater(ae_c_abs(ae_c_sub(refcb.ptr.pp_complex[i][j],refca.ptr.pp_complex[aoffsi+j-boffsj][aoffsj+i-boffsi]), _state),threshold);
                }
            }
        }
    }
    ae_frame_leave(_state);
    return result;
}


/*************************************************************************
rank-1tests

Returns False for passed test, True - for failed
*************************************************************************/
static ae_bool testablasunit_testrank1(ae_int_t minn,
     ae_int_t maxn,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_int_t m;
    ae_int_t n;
    ae_int_t mx;
    ae_int_t i;
    ae_int_t j;
    ae_int_t aoffsi;
    ae_int_t aoffsj;
    ae_int_t uoffs;
    ae_int_t voffs;
    double threshold;
    ae_matrix refra;
    ae_matrix refrb;
    ae_matrix refca;
    ae_matrix refcb;
    ae_vector ru;
    ae_vector rv;
    ae_vector cu;
    ae_vector cv;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    ae_matrix_init(&refra, 0, 0, DT_REAL, _state);
    ae_matrix_init(&refrb, 0, 0, DT_REAL, _state);
    ae_matrix_init(&refca, 0, 0, DT_COMPLEX, _state);
    ae_matrix_init(&refcb, 0, 0, DT_COMPLEX, _state);
    ae_vector_init(&ru, 0, DT_REAL, _state);
    ae_vector_init(&rv, 0, DT_REAL, _state);
    ae_vector_init(&cu, 0, DT_COMPLEX, _state);
    ae_vector_init(&cv, 0, DT_COMPLEX, _state);

    result = ae_false;
    threshold = 1000*ae_machineepsilon;
    for(mx=minn; mx<=maxn; mx++)
    {
        
        /*
         * Select random M/N in [1,MX] such that max(M,N)=MX
         */
        m = 1+ae_randominteger(mx, _state);
        n = 1+ae_randominteger(mx, _state);
        if( ae_randominteger(2, _state)==0 )
        {
            m = mx;
        }
        else
        {
            n = mx;
        }
        
        /*
         * Initialize A by random matrix with size (MaxN+1)*(MaxN+1)
         * Fill B with control values
         */
        ae_matrix_set_length(&refra, maxn+maxn, maxn+maxn, _state);
        ae_matrix_set_length(&refrb, maxn+maxn, maxn+maxn, _state);
        ae_matrix_set_length(&refca, maxn+maxn, maxn+maxn, _state);
        ae_matrix_set_length(&refcb, maxn+maxn, maxn+maxn, _state);
        for(i=0; i<=2*maxn-1; i++)
        {
            for(j=0; j<=2*maxn-1; j++)
            {
                refra.ptr.pp_double[i][j] = 2*ae_randomreal(_state)-1;
                refca.ptr.pp_complex[i][j].x = 2*ae_randomreal(_state)-1;
                refca.ptr.pp_complex[i][j].y = 2*ae_randomreal(_state)-1;
                refrb.ptr.pp_double[i][j] = refra.ptr.pp_double[i][j];
                refcb.ptr.pp_complex[i][j] = refca.ptr.pp_complex[i][j];
            }
        }
        ae_vector_set_length(&ru, 2*m, _state);
        ae_vector_set_length(&cu, 2*m, _state);
        for(i=0; i<=2*m-1; i++)
        {
            ru.ptr.p_double[i] = 2*ae_randomreal(_state)-1;
            cu.ptr.p_complex[i].x = 2*ae_randomreal(_state)-1;
            cu.ptr.p_complex[i].y = 2*ae_randomreal(_state)-1;
        }
        ae_vector_set_length(&rv, 2*n, _state);
        ae_vector_set_length(&cv, 2*n, _state);
        for(i=0; i<=2*n-1; i++)
        {
            rv.ptr.p_double[i] = 2*ae_randomreal(_state)-1;
            cv.ptr.p_complex[i].x = 2*ae_randomreal(_state)-1;
            cv.ptr.p_complex[i].y = 2*ae_randomreal(_state)-1;
        }
        
        /*
         * test different offsets (zero or one)
         *
         * to avoid unnecessary slowdown we don't test ALL possible
         * combinations of operation types. We just generate one random
         * set of parameters and test it.
         */
        aoffsi = ae_randominteger(maxn, _state);
        aoffsj = ae_randominteger(maxn, _state);
        uoffs = ae_randominteger(m, _state);
        voffs = ae_randominteger(n, _state);
        cmatrixrank1(m, n, &refca, aoffsi, aoffsj, &cu, uoffs, &cv, voffs, _state);
        for(i=0; i<=2*maxn-1; i++)
        {
            for(j=0; j<=2*maxn-1; j++)
            {
                if( ((i<aoffsi||i>=aoffsi+m)||j<aoffsj)||j>=aoffsj+n )
                {
                    result = result||ae_fp_greater(ae_c_abs(ae_c_sub(refca.ptr.pp_complex[i][j],refcb.ptr.pp_complex[i][j]), _state),threshold);
                }
                else
                {
                    result = result||ae_fp_greater(ae_c_abs(ae_c_sub(refca.ptr.pp_complex[i][j],ae_c_add(refcb.ptr.pp_complex[i][j],ae_c_mul(cu.ptr.p_complex[i-aoffsi+uoffs],cv.ptr.p_complex[j-aoffsj+voffs]))), _state),threshold);
                }
            }
        }
        rmatrixrank1(m, n, &refra, aoffsi, aoffsj, &ru, uoffs, &rv, voffs, _state);
        for(i=0; i<=2*maxn-1; i++)
        {
            for(j=0; j<=2*maxn-1; j++)
            {
                if( ((i<aoffsi||i>=aoffsi+m)||j<aoffsj)||j>=aoffsj+n )
                {
                    result = result||ae_fp_greater(ae_fabs(refra.ptr.pp_double[i][j]-refrb.ptr.pp_double[i][j], _state),threshold);
                }
                else
                {
                    result = result||ae_fp_greater(ae_fabs(refra.ptr.pp_double[i][j]-(refrb.ptr.pp_double[i][j]+ru.ptr.p_double[i-aoffsi+uoffs]*rv.ptr.p_double[j-aoffsj+voffs]), _state),threshold);
                }
            }
        }
    }
    ae_frame_leave(_state);
    return result;
}


/*************************************************************************
MV tests

Returns False for passed test, True - for failed
*************************************************************************/
static ae_bool testablasunit_testmv(ae_int_t minn,
     ae_int_t maxn,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_int_t m;
    ae_int_t n;
    ae_int_t mx;
    ae_int_t i;
    ae_int_t j;
    ae_int_t aoffsi;
    ae_int_t aoffsj;
    ae_int_t xoffs;
    ae_int_t yoffs;
    ae_int_t opca;
    ae_int_t opra;
    double threshold;
    double rv1;
    double rv2;
    ae_complex cv1;
    ae_complex cv2;
    ae_matrix refra;
    ae_matrix refca;
    ae_vector rx;
    ae_vector ry;
    ae_vector cx;
    ae_vector cy;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    ae_matrix_init(&refra, 0, 0, DT_REAL, _state);
    ae_matrix_init(&refca, 0, 0, DT_COMPLEX, _state);
    ae_vector_init(&rx, 0, DT_REAL, _state);
    ae_vector_init(&ry, 0, DT_REAL, _state);
    ae_vector_init(&cx, 0, DT_COMPLEX, _state);
    ae_vector_init(&cy, 0, DT_COMPLEX, _state);

    result = ae_false;
    threshold = 1000*ae_machineepsilon;
    for(mx=minn; mx<=maxn; mx++)
    {
        
        /*
         * Select random M/N in [1,MX] such that max(M,N)=MX
         */
        m = 1+ae_randominteger(mx, _state);
        n = 1+ae_randominteger(mx, _state);
        if( ae_randominteger(2, _state)==0 )
        {
            m = mx;
        }
        else
        {
            n = mx;
        }
        
        /*
         * Initialize A by random matrix with size (MaxN+MaxN)*(MaxN+MaxN)
         * Initialize X by random vector with size (MaxN+MaxN)
         * Fill Y by control values
         */
        ae_matrix_set_length(&refra, maxn+maxn, maxn+maxn, _state);
        ae_matrix_set_length(&refca, maxn+maxn, maxn+maxn, _state);
        for(i=0; i<=2*maxn-1; i++)
        {
            for(j=0; j<=2*maxn-1; j++)
            {
                refra.ptr.pp_double[i][j] = 2*ae_randomreal(_state)-1;
                refca.ptr.pp_complex[i][j].x = 2*ae_randomreal(_state)-1;
                refca.ptr.pp_complex[i][j].y = 2*ae_randomreal(_state)-1;
            }
        }
        ae_vector_set_length(&rx, 2*maxn, _state);
        ae_vector_set_length(&cx, 2*maxn, _state);
        ae_vector_set_length(&ry, 2*maxn, _state);
        ae_vector_set_length(&cy, 2*maxn, _state);
        for(i=0; i<=2*maxn-1; i++)
        {
            rx.ptr.p_double[i] = 2*ae_randomreal(_state)-1;
            cx.ptr.p_complex[i].x = 2*ae_randomreal(_state)-1;
            cx.ptr.p_complex[i].y = 2*ae_randomreal(_state)-1;
            ry.ptr.p_double[i] = (double)(i);
            cy.ptr.p_complex[i] = ae_complex_from_i(i);
        }
        
        /*
         * test different offsets (zero or one)
         *
         * to avoid unnecessary slowdown we don't test ALL possible
         * combinations of operation types. We just generate one random
         * set of parameters and test it.
         */
        aoffsi = ae_randominteger(maxn, _state);
        aoffsj = ae_randominteger(maxn, _state);
        xoffs = ae_randominteger(maxn, _state);
        yoffs = ae_randominteger(maxn, _state);
        opca = ae_randominteger(3, _state);
        opra = ae_randominteger(2, _state);
        cmatrixmv(m, n, &refca, aoffsi, aoffsj, opca, &cx, xoffs, &cy, yoffs, _state);
        for(i=0; i<=2*maxn-1; i++)
        {
            if( i<yoffs||i>=yoffs+m )
            {
                result = result||ae_c_neq_d(cy.ptr.p_complex[i],(double)(i));
            }
            else
            {
                cv1 = cy.ptr.p_complex[i];
                cv2 = ae_complex_from_d(0.0);
                if( opca==0 )
                {
                    cv2 = ae_v_cdotproduct(&refca.ptr.pp_complex[aoffsi+i-yoffs][aoffsj], 1, "N", &cx.ptr.p_complex[xoffs], 1, "N", ae_v_len(aoffsj,aoffsj+n-1));
                }
                if( opca==1 )
                {
                    cv2 = ae_v_cdotproduct(&refca.ptr.pp_complex[aoffsi][aoffsj+i-yoffs], refca.stride, "N", &cx.ptr.p_complex[xoffs], 1, "N", ae_v_len(aoffsi,aoffsi+n-1));
                }
                if( opca==2 )
                {
                    cv2 = ae_v_cdotproduct(&refca.ptr.pp_complex[aoffsi][aoffsj+i-yoffs], refca.stride, "Conj", &cx.ptr.p_complex[xoffs], 1, "N", ae_v_len(aoffsi,aoffsi+n-1));
                }
                result = result||ae_fp_greater(ae_c_abs(ae_c_sub(cv1,cv2), _state),threshold);
            }
        }
        rmatrixmv(m, n, &refra, aoffsi, aoffsj, opra, &rx, xoffs, &ry, yoffs, _state);
        for(i=0; i<=2*maxn-1; i++)
        {
            if( i<yoffs||i>=yoffs+m )
            {
                result = result||ae_fp_neq(ry.ptr.p_double[i],(double)(i));
            }
            else
            {
                rv1 = ry.ptr.p_double[i];
                rv2 = (double)(0);
                if( opra==0 )
                {
                    rv2 = ae_v_dotproduct(&refra.ptr.pp_double[aoffsi+i-yoffs][aoffsj], 1, &rx.ptr.p_double[xoffs], 1, ae_v_len(aoffsj,aoffsj+n-1));
                }
                if( opra==1 )
                {
                    rv2 = ae_v_dotproduct(&refra.ptr.pp_double[aoffsi][aoffsj+i-yoffs], refra.stride, &rx.ptr.p_double[xoffs], 1, ae_v_len(aoffsi,aoffsi+n-1));
                }
                result = result||ae_fp_greater(ae_fabs(rv1-rv2, _state),threshold);
            }
        }
    }
    ae_frame_leave(_state);
    return result;
}


/*************************************************************************
COPY tests

Returns False for passed test, True - for failed
*************************************************************************/
static ae_bool testablasunit_testcopy(ae_int_t minn,
     ae_int_t maxn,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_int_t m;
    ae_int_t n;
    ae_int_t mx;
    ae_int_t i;
    ae_int_t j;
    ae_int_t aoffsi;
    ae_int_t aoffsj;
    ae_int_t boffsi;
    ae_int_t boffsj;
    double threshold;
    ae_matrix ra;
    ae_matrix rb;
    ae_matrix ca;
    ae_matrix cb;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    ae_matrix_init(&ra, 0, 0, DT_REAL, _state);
    ae_matrix_init(&rb, 0, 0, DT_REAL, _state);
    ae_matrix_init(&ca, 0, 0, DT_COMPLEX, _state);
    ae_matrix_init(&cb, 0, 0, DT_COMPLEX, _state);

    result = ae_false;
    threshold = 1000*ae_machineepsilon;
    for(mx=minn; mx<=maxn; mx++)
    {
        
        /*
         * Select random M/N in [1,MX] such that max(M,N)=MX
         */
        m = 1+ae_randominteger(mx, _state);
        n = 1+ae_randominteger(mx, _state);
        if( ae_randominteger(2, _state)==0 )
        {
            m = mx;
        }
        else
        {
            n = mx;
        }
        
        /*
         * Initialize A by random matrix with size (MaxN+MaxN)*(MaxN+MaxN)
         * Initialize X by random vector with size (MaxN+MaxN)
         * Fill Y by control values
         */
        ae_matrix_set_length(&ra, maxn+maxn, maxn+maxn, _state);
        ae_matrix_set_length(&ca, maxn+maxn, maxn+maxn, _state);
        ae_matrix_set_length(&rb, maxn+maxn, maxn+maxn, _state);
        ae_matrix_set_length(&cb, maxn+maxn, maxn+maxn, _state);
        for(i=0; i<=2*maxn-1; i++)
        {
            for(j=0; j<=2*maxn-1; j++)
            {
                ra.ptr.pp_double[i][j] = 2*ae_randomreal(_state)-1;
                ca.ptr.pp_complex[i][j].x = 2*ae_randomreal(_state)-1;
                ca.ptr.pp_complex[i][j].y = 2*ae_randomreal(_state)-1;
                rb.ptr.pp_double[i][j] = (double)(1+2*i+3*j);
                cb.ptr.pp_complex[i][j] = ae_complex_from_i(1+2*i+3*j);
            }
        }
        
        /*
         * test different offsets (zero or one)
         *
         * to avoid unnecessary slowdown we don't test ALL possible
         * combinations of operation types. We just generate one random
         * set of parameters and test it.
         */
        aoffsi = ae_randominteger(maxn, _state);
        aoffsj = ae_randominteger(maxn, _state);
        boffsi = ae_randominteger(maxn, _state);
        boffsj = ae_randominteger(maxn, _state);
        cmatrixcopy(m, n, &ca, aoffsi, aoffsj, &cb, boffsi, boffsj, _state);
        for(i=0; i<=2*maxn-1; i++)
        {
            for(j=0; j<=2*maxn-1; j++)
            {
                if( ((i<boffsi||i>=boffsi+m)||j<boffsj)||j>=boffsj+n )
                {
                    result = result||ae_c_neq_d(cb.ptr.pp_complex[i][j],(double)(1+2*i+3*j));
                }
                else
                {
                    result = result||ae_fp_greater(ae_c_abs(ae_c_sub(ca.ptr.pp_complex[aoffsi+i-boffsi][aoffsj+j-boffsj],cb.ptr.pp_complex[i][j]), _state),threshold);
                }
            }
        }
        rmatrixcopy(m, n, &ra, aoffsi, aoffsj, &rb, boffsi, boffsj, _state);
        for(i=0; i<=2*maxn-1; i++)
        {
            for(j=0; j<=2*maxn-1; j++)
            {
                if( ((i<boffsi||i>=boffsi+m)||j<boffsj)||j>=boffsj+n )
                {
                    result = result||ae_fp_neq(rb.ptr.pp_double[i][j],(double)(1+2*i+3*j));
                }
                else
                {
                    result = result||ae_fp_greater(ae_fabs(ra.ptr.pp_double[aoffsi+i-boffsi][aoffsj+j-boffsj]-rb.ptr.pp_double[i][j], _state),threshold);
                }
            }
        }
    }
    ae_frame_leave(_state);
    return result;
}


/*************************************************************************
Reference implementation

  -- ALGLIB routine --
     15.12.2009
     Bochkanov Sergey
*************************************************************************/
static void testablasunit_refcmatrixrighttrsm(ae_int_t m,
     ae_int_t n,
     /* Complex */ ae_matrix* a,
     ae_int_t i1,
     ae_int_t j1,
     ae_bool isupper,
     ae_bool isunit,
     ae_int_t optype,
     /* Complex */ ae_matrix* x,
     ae_int_t i2,
     ae_int_t j2,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_matrix a1;
    ae_matrix a2;
    ae_vector tx;
    ae_int_t i;
    ae_int_t j;
    ae_complex vc;
    ae_bool rupper;

    ae_frame_make(_state, &_frame_block);
    ae_matrix_init(&a1, 0, 0, DT_COMPLEX, _state);
    ae_matrix_init(&a2, 0, 0, DT_COMPLEX, _state);
    ae_vector_init(&tx, 0, DT_COMPLEX, _state);

    if( n*m==0 )
    {
        ae_frame_leave(_state);
        return;
    }
    ae_matrix_set_length(&a1, n, n, _state);
    for(i=0; i<=n-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            a1.ptr.pp_complex[i][j] = ae_complex_from_i(0);
        }
    }
    if( isupper )
    {
        for(i=0; i<=n-1; i++)
        {
            for(j=i; j<=n-1; j++)
            {
                a1.ptr.pp_complex[i][j] = a->ptr.pp_complex[i1+i][j1+j];
            }
        }
    }
    else
    {
        for(i=0; i<=n-1; i++)
        {
            for(j=0; j<=i; j++)
            {
                a1.ptr.pp_complex[i][j] = a->ptr.pp_complex[i1+i][j1+j];
            }
        }
    }
    rupper = isupper;
    if( isunit )
    {
        for(i=0; i<=n-1; i++)
        {
            a1.ptr.pp_complex[i][i] = ae_complex_from_i(1);
        }
    }
    ae_matrix_set_length(&a2, n, n, _state);
    if( optype==0 )
    {
        for(i=0; i<=n-1; i++)
        {
            for(j=0; j<=n-1; j++)
            {
                a2.ptr.pp_complex[i][j] = a1.ptr.pp_complex[i][j];
            }
        }
    }
    if( optype==1 )
    {
        for(i=0; i<=n-1; i++)
        {
            for(j=0; j<=n-1; j++)
            {
                a2.ptr.pp_complex[i][j] = a1.ptr.pp_complex[j][i];
            }
        }
        rupper = !rupper;
    }
    if( optype==2 )
    {
        for(i=0; i<=n-1; i++)
        {
            for(j=0; j<=n-1; j++)
            {
                a2.ptr.pp_complex[i][j] = ae_c_conj(a1.ptr.pp_complex[j][i], _state);
            }
        }
        rupper = !rupper;
    }
    testablasunit_internalcmatrixtrinverse(&a2, n, rupper, ae_false, _state);
    ae_vector_set_length(&tx, n, _state);
    for(i=0; i<=m-1; i++)
    {
        ae_v_cmove(&tx.ptr.p_complex[0], 1, &x->ptr.pp_complex[i2+i][j2], 1, "N", ae_v_len(0,n-1));
        for(j=0; j<=n-1; j++)
        {
            vc = ae_v_cdotproduct(&tx.ptr.p_complex[0], 1, "N", &a2.ptr.pp_complex[0][j], a2.stride, "N", ae_v_len(0,n-1));
            x->ptr.pp_complex[i2+i][j2+j] = vc;
        }
    }
    ae_frame_leave(_state);
}


/*************************************************************************
Reference implementation

  -- ALGLIB routine --
     15.12.2009
     Bochkanov Sergey
*************************************************************************/
static void testablasunit_refcmatrixlefttrsm(ae_int_t m,
     ae_int_t n,
     /* Complex */ ae_matrix* a,
     ae_int_t i1,
     ae_int_t j1,
     ae_bool isupper,
     ae_bool isunit,
     ae_int_t optype,
     /* Complex */ ae_matrix* x,
     ae_int_t i2,
     ae_int_t j2,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_matrix a1;
    ae_matrix a2;
    ae_vector tx;
    ae_int_t i;
    ae_int_t j;
    ae_complex vc;
    ae_bool rupper;

    ae_frame_make(_state, &_frame_block);
    ae_matrix_init(&a1, 0, 0, DT_COMPLEX, _state);
    ae_matrix_init(&a2, 0, 0, DT_COMPLEX, _state);
    ae_vector_init(&tx, 0, DT_COMPLEX, _state);

    if( n*m==0 )
    {
        ae_frame_leave(_state);
        return;
    }
    ae_matrix_set_length(&a1, m, m, _state);
    for(i=0; i<=m-1; i++)
    {
        for(j=0; j<=m-1; j++)
        {
            a1.ptr.pp_complex[i][j] = ae_complex_from_i(0);
        }
    }
    if( isupper )
    {
        for(i=0; i<=m-1; i++)
        {
            for(j=i; j<=m-1; j++)
            {
                a1.ptr.pp_complex[i][j] = a->ptr.pp_complex[i1+i][j1+j];
            }
        }
    }
    else
    {
        for(i=0; i<=m-1; i++)
        {
            for(j=0; j<=i; j++)
            {
                a1.ptr.pp_complex[i][j] = a->ptr.pp_complex[i1+i][j1+j];
            }
        }
    }
    rupper = isupper;
    if( isunit )
    {
        for(i=0; i<=m-1; i++)
        {
            a1.ptr.pp_complex[i][i] = ae_complex_from_i(1);
        }
    }
    ae_matrix_set_length(&a2, m, m, _state);
    if( optype==0 )
    {
        for(i=0; i<=m-1; i++)
        {
            for(j=0; j<=m-1; j++)
            {
                a2.ptr.pp_complex[i][j] = a1.ptr.pp_complex[i][j];
            }
        }
    }
    if( optype==1 )
    {
        for(i=0; i<=m-1; i++)
        {
            for(j=0; j<=m-1; j++)
            {
                a2.ptr.pp_complex[i][j] = a1.ptr.pp_complex[j][i];
            }
        }
        rupper = !rupper;
    }
    if( optype==2 )
    {
        for(i=0; i<=m-1; i++)
        {
            for(j=0; j<=m-1; j++)
            {
                a2.ptr.pp_complex[i][j] = ae_c_conj(a1.ptr.pp_complex[j][i], _state);
            }
        }
        rupper = !rupper;
    }
    testablasunit_internalcmatrixtrinverse(&a2, m, rupper, ae_false, _state);
    ae_vector_set_length(&tx, m, _state);
    for(j=0; j<=n-1; j++)
    {
        ae_v_cmove(&tx.ptr.p_complex[0], 1, &x->ptr.pp_complex[i2][j2+j], x->stride, "N", ae_v_len(0,m-1));
        for(i=0; i<=m-1; i++)
        {
            vc = ae_v_cdotproduct(&a2.ptr.pp_complex[i][0], 1, "N", &tx.ptr.p_complex[0], 1, "N", ae_v_len(0,m-1));
            x->ptr.pp_complex[i2+i][j2+j] = vc;
        }
    }
    ae_frame_leave(_state);
}


/*************************************************************************
Reference implementation

  -- ALGLIB routine --
     15.12.2009
     Bochkanov Sergey
*************************************************************************/
static void testablasunit_refrmatrixrighttrsm(ae_int_t m,
     ae_int_t n,
     /* Real    */ ae_matrix* a,
     ae_int_t i1,
     ae_int_t j1,
     ae_bool isupper,
     ae_bool isunit,
     ae_int_t optype,
     /* Real    */ ae_matrix* x,
     ae_int_t i2,
     ae_int_t j2,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_matrix a1;
    ae_matrix a2;
    ae_vector tx;
    ae_int_t i;
    ae_int_t j;
    double vr;
    ae_bool rupper;

    ae_frame_make(_state, &_frame_block);
    ae_matrix_init(&a1, 0, 0, DT_REAL, _state);
    ae_matrix_init(&a2, 0, 0, DT_REAL, _state);
    ae_vector_init(&tx, 0, DT_REAL, _state);

    if( n*m==0 )
    {
        ae_frame_leave(_state);
        return;
    }
    ae_matrix_set_length(&a1, n, n, _state);
    for(i=0; i<=n-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            a1.ptr.pp_double[i][j] = (double)(0);
        }
    }
    if( isupper )
    {
        for(i=0; i<=n-1; i++)
        {
            for(j=i; j<=n-1; j++)
            {
                a1.ptr.pp_double[i][j] = a->ptr.pp_double[i1+i][j1+j];
            }
        }
    }
    else
    {
        for(i=0; i<=n-1; i++)
        {
            for(j=0; j<=i; j++)
            {
                a1.ptr.pp_double[i][j] = a->ptr.pp_double[i1+i][j1+j];
            }
        }
    }
    rupper = isupper;
    if( isunit )
    {
        for(i=0; i<=n-1; i++)
        {
            a1.ptr.pp_double[i][i] = (double)(1);
        }
    }
    ae_matrix_set_length(&a2, n, n, _state);
    if( optype==0 )
    {
        for(i=0; i<=n-1; i++)
        {
            for(j=0; j<=n-1; j++)
            {
                a2.ptr.pp_double[i][j] = a1.ptr.pp_double[i][j];
            }
        }
    }
    if( optype==1 )
    {
        for(i=0; i<=n-1; i++)
        {
            for(j=0; j<=n-1; j++)
            {
                a2.ptr.pp_double[i][j] = a1.ptr.pp_double[j][i];
            }
        }
        rupper = !rupper;
    }
    testablasunit_internalrmatrixtrinverse(&a2, n, rupper, ae_false, _state);
    ae_vector_set_length(&tx, n, _state);
    for(i=0; i<=m-1; i++)
    {
        ae_v_move(&tx.ptr.p_double[0], 1, &x->ptr.pp_double[i2+i][j2], 1, ae_v_len(0,n-1));
        for(j=0; j<=n-1; j++)
        {
            vr = ae_v_dotproduct(&tx.ptr.p_double[0], 1, &a2.ptr.pp_double[0][j], a2.stride, ae_v_len(0,n-1));
            x->ptr.pp_double[i2+i][j2+j] = vr;
        }
    }
    ae_frame_leave(_state);
}


/*************************************************************************
Reference implementation

  -- ALGLIB routine --
     15.12.2009
     Bochkanov Sergey
*************************************************************************/
static void testablasunit_refrmatrixlefttrsm(ae_int_t m,
     ae_int_t n,
     /* Real    */ ae_matrix* a,
     ae_int_t i1,
     ae_int_t j1,
     ae_bool isupper,
     ae_bool isunit,
     ae_int_t optype,
     /* Real    */ ae_matrix* x,
     ae_int_t i2,
     ae_int_t j2,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_matrix a1;
    ae_matrix a2;
    ae_vector tx;
    ae_int_t i;
    ae_int_t j;
    double vr;
    ae_bool rupper;

    ae_frame_make(_state, &_frame_block);
    ae_matrix_init(&a1, 0, 0, DT_REAL, _state);
    ae_matrix_init(&a2, 0, 0, DT_REAL, _state);
    ae_vector_init(&tx, 0, DT_REAL, _state);

    if( n*m==0 )
    {
        ae_frame_leave(_state);
        return;
    }
    ae_matrix_set_length(&a1, m, m, _state);
    for(i=0; i<=m-1; i++)
    {
        for(j=0; j<=m-1; j++)
        {
            a1.ptr.pp_double[i][j] = (double)(0);
        }
    }
    if( isupper )
    {
        for(i=0; i<=m-1; i++)
        {
            for(j=i; j<=m-1; j++)
            {
                a1.ptr.pp_double[i][j] = a->ptr.pp_double[i1+i][j1+j];
            }
        }
    }
    else
    {
        for(i=0; i<=m-1; i++)
        {
            for(j=0; j<=i; j++)
            {
                a1.ptr.pp_double[i][j] = a->ptr.pp_double[i1+i][j1+j];
            }
        }
    }
    rupper = isupper;
    if( isunit )
    {
        for(i=0; i<=m-1; i++)
        {
            a1.ptr.pp_double[i][i] = (double)(1);
        }
    }
    ae_matrix_set_length(&a2, m, m, _state);
    if( optype==0 )
    {
        for(i=0; i<=m-1; i++)
        {
            for(j=0; j<=m-1; j++)
            {
                a2.ptr.pp_double[i][j] = a1.ptr.pp_double[i][j];
            }
        }
    }
    if( optype==1 )
    {
        for(i=0; i<=m-1; i++)
        {
            for(j=0; j<=m-1; j++)
            {
                a2.ptr.pp_double[i][j] = a1.ptr.pp_double[j][i];
            }
        }
        rupper = !rupper;
    }
    testablasunit_internalrmatrixtrinverse(&a2, m, rupper, ae_false, _state);
    ae_vector_set_length(&tx, m, _state);
    for(j=0; j<=n-1; j++)
    {
        ae_v_move(&tx.ptr.p_double[0], 1, &x->ptr.pp_double[i2][j2+j], x->stride, ae_v_len(0,m-1));
        for(i=0; i<=m-1; i++)
        {
            vr = ae_v_dotproduct(&a2.ptr.pp_double[i][0], 1, &tx.ptr.p_double[0], 1, ae_v_len(0,m-1));
            x->ptr.pp_double[i2+i][j2+j] = vr;
        }
    }
    ae_frame_leave(_state);
}


/*************************************************************************
Internal subroutine.
Triangular matrix inversion

  -- LAPACK routine (version 3.0) --
     Univ. of Tennessee, Univ. of California Berkeley, NAG Ltd.,
     Courant Institute, Argonne National Lab, and Rice University
     February 29, 1992
*************************************************************************/
static ae_bool testablasunit_internalcmatrixtrinverse(/* Complex */ ae_matrix* a,
     ae_int_t n,
     ae_bool isupper,
     ae_bool isunittriangular,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_bool nounit;
    ae_int_t i;
    ae_int_t j;
    ae_complex v;
    ae_complex ajj;
    ae_vector t;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    ae_vector_init(&t, 0, DT_COMPLEX, _state);

    result = ae_true;
    ae_vector_set_length(&t, n-1+1, _state);
    
    /*
     * Test the input parameters.
     */
    nounit = !isunittriangular;
    if( isupper )
    {
        
        /*
         * Compute inverse of upper triangular matrix.
         */
        for(j=0; j<=n-1; j++)
        {
            if( nounit )
            {
                if( ae_c_eq_d(a->ptr.pp_complex[j][j],(double)(0)) )
                {
                    result = ae_false;
                    ae_frame_leave(_state);
                    return result;
                }
                a->ptr.pp_complex[j][j] = ae_c_d_div(1,a->ptr.pp_complex[j][j]);
                ajj = ae_c_neg(a->ptr.pp_complex[j][j]);
            }
            else
            {
                ajj = ae_complex_from_i(-1);
            }
            
            /*
             * Compute elements 1:j-1 of j-th column.
             */
            if( j>0 )
            {
                ae_v_cmove(&t.ptr.p_complex[0], 1, &a->ptr.pp_complex[0][j], a->stride, "N", ae_v_len(0,j-1));
                for(i=0; i<=j-1; i++)
                {
                    if( i+1<j )
                    {
                        v = ae_v_cdotproduct(&a->ptr.pp_complex[i][i+1], 1, "N", &t.ptr.p_complex[i+1], 1, "N", ae_v_len(i+1,j-1));
                    }
                    else
                    {
                        v = ae_complex_from_i(0);
                    }
                    if( nounit )
                    {
                        a->ptr.pp_complex[i][j] = ae_c_add(v,ae_c_mul(a->ptr.pp_complex[i][i],t.ptr.p_complex[i]));
                    }
                    else
                    {
                        a->ptr.pp_complex[i][j] = ae_c_add(v,t.ptr.p_complex[i]);
                    }
                }
                ae_v_cmulc(&a->ptr.pp_complex[0][j], a->stride, ae_v_len(0,j-1), ajj);
            }
        }
    }
    else
    {
        
        /*
         * Compute inverse of lower triangular matrix.
         */
        for(j=n-1; j>=0; j--)
        {
            if( nounit )
            {
                if( ae_c_eq_d(a->ptr.pp_complex[j][j],(double)(0)) )
                {
                    result = ae_false;
                    ae_frame_leave(_state);
                    return result;
                }
                a->ptr.pp_complex[j][j] = ae_c_d_div(1,a->ptr.pp_complex[j][j]);
                ajj = ae_c_neg(a->ptr.pp_complex[j][j]);
            }
            else
            {
                ajj = ae_complex_from_i(-1);
            }
            if( j+1<n )
            {
                
                /*
                 * Compute elements j+1:n of j-th column.
                 */
                ae_v_cmove(&t.ptr.p_complex[j+1], 1, &a->ptr.pp_complex[j+1][j], a->stride, "N", ae_v_len(j+1,n-1));
                for(i=j+1; i<=n-1; i++)
                {
                    if( i>j+1 )
                    {
                        v = ae_v_cdotproduct(&a->ptr.pp_complex[i][j+1], 1, "N", &t.ptr.p_complex[j+1], 1, "N", ae_v_len(j+1,i-1));
                    }
                    else
                    {
                        v = ae_complex_from_i(0);
                    }
                    if( nounit )
                    {
                        a->ptr.pp_complex[i][j] = ae_c_add(v,ae_c_mul(a->ptr.pp_complex[i][i],t.ptr.p_complex[i]));
                    }
                    else
                    {
                        a->ptr.pp_complex[i][j] = ae_c_add(v,t.ptr.p_complex[i]);
                    }
                }
                ae_v_cmulc(&a->ptr.pp_complex[j+1][j], a->stride, ae_v_len(j+1,n-1), ajj);
            }
        }
    }
    ae_frame_leave(_state);
    return result;
}


/*************************************************************************
Internal subroutine.
Triangular matrix inversion

  -- LAPACK routine (version 3.0) --
     Univ. of Tennessee, Univ. of California Berkeley, NAG Ltd.,
     Courant Institute, Argonne National Lab, and Rice University
     February 29, 1992
*************************************************************************/
static ae_bool testablasunit_internalrmatrixtrinverse(/* Real    */ ae_matrix* a,
     ae_int_t n,
     ae_bool isupper,
     ae_bool isunittriangular,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_bool nounit;
    ae_int_t i;
    ae_int_t j;
    double v;
    double ajj;
    ae_vector t;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    ae_vector_init(&t, 0, DT_REAL, _state);

    result = ae_true;
    ae_vector_set_length(&t, n-1+1, _state);
    
    /*
     * Test the input parameters.
     */
    nounit = !isunittriangular;
    if( isupper )
    {
        
        /*
         * Compute inverse of upper triangular matrix.
         */
        for(j=0; j<=n-1; j++)
        {
            if( nounit )
            {
                if( ae_fp_eq(a->ptr.pp_double[j][j],(double)(0)) )
                {
                    result = ae_false;
                    ae_frame_leave(_state);
                    return result;
                }
                a->ptr.pp_double[j][j] = 1/a->ptr.pp_double[j][j];
                ajj = -a->ptr.pp_double[j][j];
            }
            else
            {
                ajj = (double)(-1);
            }
            
            /*
             * Compute elements 1:j-1 of j-th column.
             */
            if( j>0 )
            {
                ae_v_move(&t.ptr.p_double[0], 1, &a->ptr.pp_double[0][j], a->stride, ae_v_len(0,j-1));
                for(i=0; i<=j-1; i++)
                {
                    if( i<j-1 )
                    {
                        v = ae_v_dotproduct(&a->ptr.pp_double[i][i+1], 1, &t.ptr.p_double[i+1], 1, ae_v_len(i+1,j-1));
                    }
                    else
                    {
                        v = (double)(0);
                    }
                    if( nounit )
                    {
                        a->ptr.pp_double[i][j] = v+a->ptr.pp_double[i][i]*t.ptr.p_double[i];
                    }
                    else
                    {
                        a->ptr.pp_double[i][j] = v+t.ptr.p_double[i];
                    }
                }
                ae_v_muld(&a->ptr.pp_double[0][j], a->stride, ae_v_len(0,j-1), ajj);
            }
        }
    }
    else
    {
        
        /*
         * Compute inverse of lower triangular matrix.
         */
        for(j=n-1; j>=0; j--)
        {
            if( nounit )
            {
                if( ae_fp_eq(a->ptr.pp_double[j][j],(double)(0)) )
                {
                    result = ae_false;
                    ae_frame_leave(_state);
                    return result;
                }
                a->ptr.pp_double[j][j] = 1/a->ptr.pp_double[j][j];
                ajj = -a->ptr.pp_double[j][j];
            }
            else
            {
                ajj = (double)(-1);
            }
            if( j<n-1 )
            {
                
                /*
                 * Compute elements j+1:n of j-th column.
                 */
                ae_v_move(&t.ptr.p_double[j+1], 1, &a->ptr.pp_double[j+1][j], a->stride, ae_v_len(j+1,n-1));
                for(i=j+1; i<=n-1; i++)
                {
                    if( i>j+1 )
                    {
                        v = ae_v_dotproduct(&a->ptr.pp_double[i][j+1], 1, &t.ptr.p_double[j+1], 1, ae_v_len(j+1,i-1));
                    }
                    else
                    {
                        v = (double)(0);
                    }
                    if( nounit )
                    {
                        a->ptr.pp_double[i][j] = v+a->ptr.pp_double[i][i]*t.ptr.p_double[i];
                    }
                    else
                    {
                        a->ptr.pp_double[i][j] = v+t.ptr.p_double[i];
                    }
                }
                ae_v_muld(&a->ptr.pp_double[j+1][j], a->stride, ae_v_len(j+1,n-1), ajj);
            }
        }
    }
    ae_frame_leave(_state);
    return result;
}


/*************************************************************************
Reference SYRK subroutine.

  -- ALGLIB routine --
     16.12.2009
     Bochkanov Sergey
*************************************************************************/
static void testablasunit_refcmatrixherk(ae_int_t n,
     ae_int_t k,
     double alpha,
     /* Complex */ ae_matrix* a,
     ae_int_t ia,
     ae_int_t ja,
     ae_int_t optypea,
     double beta,
     /* Complex */ ae_matrix* c,
     ae_int_t ic,
     ae_int_t jc,
     ae_bool isupper,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_matrix ae;
    ae_int_t i;
    ae_int_t j;
    ae_complex vc;

    ae_frame_make(_state, &_frame_block);
    ae_matrix_init(&ae, 0, 0, DT_COMPLEX, _state);

    for(i=0; i<=n-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            if( (isupper&&j>=i)||(!isupper&&j<=i) )
            {
                if( ae_fp_eq(beta,(double)(0)) )
                {
                    c->ptr.pp_complex[i+ic][j+jc] = ae_complex_from_i(0);
                }
                else
                {
                    c->ptr.pp_complex[i+ic][j+jc] = ae_c_mul_d(c->ptr.pp_complex[i+ic][j+jc],beta);
                }
            }
        }
    }
    if( ae_fp_eq(alpha,(double)(0)) )
    {
        ae_frame_leave(_state);
        return;
    }
    if( n*k>0 )
    {
        ae_matrix_set_length(&ae, n, k, _state);
    }
    for(i=0; i<=n-1; i++)
    {
        for(j=0; j<=k-1; j++)
        {
            if( optypea==0 )
            {
                ae.ptr.pp_complex[i][j] = a->ptr.pp_complex[ia+i][ja+j];
            }
            if( optypea==2 )
            {
                ae.ptr.pp_complex[i][j] = ae_c_conj(a->ptr.pp_complex[ia+j][ja+i], _state);
            }
        }
    }
    for(i=0; i<=n-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            vc = ae_complex_from_i(0);
            if( k>0 )
            {
                vc = ae_v_cdotproduct(&ae.ptr.pp_complex[i][0], 1, "N", &ae.ptr.pp_complex[j][0], 1, "Conj", ae_v_len(0,k-1));
            }
            vc = ae_c_mul_d(vc,alpha);
            if( isupper&&j>=i )
            {
                c->ptr.pp_complex[ic+i][jc+j] = ae_c_add(vc,c->ptr.pp_complex[ic+i][jc+j]);
            }
            if( !isupper&&j<=i )
            {
                c->ptr.pp_complex[ic+i][jc+j] = ae_c_add(vc,c->ptr.pp_complex[ic+i][jc+j]);
            }
        }
    }
    ae_frame_leave(_state);
}


/*************************************************************************
Reference SYRK subroutine.

  -- ALGLIB routine --
     16.12.2009
     Bochkanov Sergey
*************************************************************************/
static void testablasunit_refrmatrixsyrk(ae_int_t n,
     ae_int_t k,
     double alpha,
     /* Real    */ ae_matrix* a,
     ae_int_t ia,
     ae_int_t ja,
     ae_int_t optypea,
     double beta,
     /* Real    */ ae_matrix* c,
     ae_int_t ic,
     ae_int_t jc,
     ae_bool isupper,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_matrix ae;
    ae_int_t i;
    ae_int_t j;
    double vr;

    ae_frame_make(_state, &_frame_block);
    ae_matrix_init(&ae, 0, 0, DT_REAL, _state);

    for(i=0; i<=n-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            if( (isupper&&j>=i)||(!isupper&&j<=i) )
            {
                if( ae_fp_eq(beta,(double)(0)) )
                {
                    c->ptr.pp_double[i+ic][j+jc] = (double)(0);
                }
                else
                {
                    c->ptr.pp_double[i+ic][j+jc] = c->ptr.pp_double[i+ic][j+jc]*beta;
                }
            }
        }
    }
    if( ae_fp_eq(alpha,(double)(0)) )
    {
        ae_frame_leave(_state);
        return;
    }
    if( n*k>0 )
    {
        ae_matrix_set_length(&ae, n, k, _state);
    }
    for(i=0; i<=n-1; i++)
    {
        for(j=0; j<=k-1; j++)
        {
            if( optypea==0 )
            {
                ae.ptr.pp_double[i][j] = a->ptr.pp_double[ia+i][ja+j];
            }
            if( optypea==1 )
            {
                ae.ptr.pp_double[i][j] = a->ptr.pp_double[ia+j][ja+i];
            }
        }
    }
    for(i=0; i<=n-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            vr = (double)(0);
            if( k>0 )
            {
                vr = ae_v_dotproduct(&ae.ptr.pp_double[i][0], 1, &ae.ptr.pp_double[j][0], 1, ae_v_len(0,k-1));
            }
            vr = alpha*vr;
            if( isupper&&j>=i )
            {
                c->ptr.pp_double[ic+i][jc+j] = vr+c->ptr.pp_double[ic+i][jc+j];
            }
            if( !isupper&&j<=i )
            {
                c->ptr.pp_double[ic+i][jc+j] = vr+c->ptr.pp_double[ic+i][jc+j];
            }
        }
    }
    ae_frame_leave(_state);
}


/*************************************************************************
Reference GEMM,
ALGLIB subroutine
*************************************************************************/
static void testablasunit_refcmatrixgemm(ae_int_t m,
     ae_int_t n,
     ae_int_t k,
     ae_complex alpha,
     /* Complex */ ae_matrix* a,
     ae_int_t ia,
     ae_int_t ja,
     ae_int_t optypea,
     /* Complex */ ae_matrix* b,
     ae_int_t ib,
     ae_int_t jb,
     ae_int_t optypeb,
     ae_complex beta,
     /* Complex */ ae_matrix* c,
     ae_int_t ic,
     ae_int_t jc,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_matrix ae;
    ae_matrix be;
    ae_int_t i;
    ae_int_t j;
    ae_complex vc;

    ae_frame_make(_state, &_frame_block);
    ae_matrix_init(&ae, 0, 0, DT_COMPLEX, _state);
    ae_matrix_init(&be, 0, 0, DT_COMPLEX, _state);

    ae_matrix_set_length(&ae, m, k, _state);
    for(i=0; i<=m-1; i++)
    {
        for(j=0; j<=k-1; j++)
        {
            if( optypea==0 )
            {
                ae.ptr.pp_complex[i][j] = a->ptr.pp_complex[ia+i][ja+j];
            }
            if( optypea==1 )
            {
                ae.ptr.pp_complex[i][j] = a->ptr.pp_complex[ia+j][ja+i];
            }
            if( optypea==2 )
            {
                ae.ptr.pp_complex[i][j] = ae_c_conj(a->ptr.pp_complex[ia+j][ja+i], _state);
            }
        }
    }
    ae_matrix_set_length(&be, k, n, _state);
    for(i=0; i<=k-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            if( optypeb==0 )
            {
                be.ptr.pp_complex[i][j] = b->ptr.pp_complex[ib+i][jb+j];
            }
            if( optypeb==1 )
            {
                be.ptr.pp_complex[i][j] = b->ptr.pp_complex[ib+j][jb+i];
            }
            if( optypeb==2 )
            {
                be.ptr.pp_complex[i][j] = ae_c_conj(b->ptr.pp_complex[ib+j][jb+i], _state);
            }
        }
    }
    for(i=0; i<=m-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            vc = ae_v_cdotproduct(&ae.ptr.pp_complex[i][0], 1, "N", &be.ptr.pp_complex[0][j], be.stride, "N", ae_v_len(0,k-1));
            vc = ae_c_mul(alpha,vc);
            if( ae_c_neq_d(beta,(double)(0)) )
            {
                vc = ae_c_add(vc,ae_c_mul(beta,c->ptr.pp_complex[ic+i][jc+j]));
            }
            c->ptr.pp_complex[ic+i][jc+j] = vc;
        }
    }
    ae_frame_leave(_state);
}


/*************************************************************************
Reference GEMM,
ALGLIB subroutine
*************************************************************************/
static void testablasunit_refrmatrixgemm(ae_int_t m,
     ae_int_t n,
     ae_int_t k,
     double alpha,
     /* Real    */ ae_matrix* a,
     ae_int_t ia,
     ae_int_t ja,
     ae_int_t optypea,
     /* Real    */ ae_matrix* b,
     ae_int_t ib,
     ae_int_t jb,
     ae_int_t optypeb,
     double beta,
     /* Real    */ ae_matrix* c,
     ae_int_t ic,
     ae_int_t jc,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_matrix ae;
    ae_matrix be;
    ae_int_t i;
    ae_int_t j;
    double vc;

    ae_frame_make(_state, &_frame_block);
    ae_matrix_init(&ae, 0, 0, DT_REAL, _state);
    ae_matrix_init(&be, 0, 0, DT_REAL, _state);

    ae_matrix_set_length(&ae, m, k, _state);
    for(i=0; i<=m-1; i++)
    {
        for(j=0; j<=k-1; j++)
        {
            if( optypea==0 )
            {
                ae.ptr.pp_double[i][j] = a->ptr.pp_double[ia+i][ja+j];
            }
            if( optypea==1 )
            {
                ae.ptr.pp_double[i][j] = a->ptr.pp_double[ia+j][ja+i];
            }
        }
    }
    ae_matrix_set_length(&be, k, n, _state);
    for(i=0; i<=k-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            if( optypeb==0 )
            {
                be.ptr.pp_double[i][j] = b->ptr.pp_double[ib+i][jb+j];
            }
            if( optypeb==1 )
            {
                be.ptr.pp_double[i][j] = b->ptr.pp_double[ib+j][jb+i];
            }
        }
    }
    for(i=0; i<=m-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            vc = ae_v_dotproduct(&ae.ptr.pp_double[i][0], 1, &be.ptr.pp_double[0][j], be.stride, ae_v_len(0,k-1));
            vc = alpha*vc;
            if( ae_fp_neq(beta,(double)(0)) )
            {
                vc = vc+beta*c->ptr.pp_double[ic+i][jc+j];
            }
            c->ptr.pp_double[ic+i][jc+j] = vc;
        }
    }
    ae_frame_leave(_state);
}



static void testbasestatunit_testranking(ae_bool* err, ae_state *_state);





ae_bool testbasestat(ae_bool silent, ae_state *_state)
{
    ae_frame _frame_block;
    ae_bool waserrors;
    ae_bool s1errors;
    ae_bool covcorrerrors;
    ae_bool rankerrors;
    double threshold;
    ae_int_t i;
    ae_int_t j;
    ae_int_t n;
    ae_int_t kx;
    ae_int_t ky;
    ae_int_t ctype;
    ae_int_t cidxx;
    ae_int_t cidxy;
    ae_vector x;
    ae_vector y;
    ae_matrix mx;
    ae_matrix my;
    ae_matrix cc;
    ae_matrix cp;
    ae_matrix cs;
    double mean;
    double variance;
    double skewness;
    double kurtosis;
    double adev;
    double median;
    double pv;
    double v;
    double tmean;
    double tvariance;
    double tskewness;
    double tkurtosis;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    ae_vector_init(&x, 0, DT_REAL, _state);
    ae_vector_init(&y, 0, DT_REAL, _state);
    ae_matrix_init(&mx, 0, 0, DT_REAL, _state);
    ae_matrix_init(&my, 0, 0, DT_REAL, _state);
    ae_matrix_init(&cc, 0, 0, DT_REAL, _state);
    ae_matrix_init(&cp, 0, 0, DT_REAL, _state);
    ae_matrix_init(&cs, 0, 0, DT_REAL, _state);

    
    /*
     * Primary settings
     */
    waserrors = ae_false;
    s1errors = ae_false;
    covcorrerrors = ae_false;
    rankerrors = ae_false;
    threshold = 1000*ae_machineepsilon;
    
    /*
     * Ranking
     */
    testbasestatunit_testranking(&rankerrors, _state);
    
    /*
     * * prepare X and Y - two test samples
     * * test 1-sample coefficients
     * * test for SampleMean, SampleVariance,
     *   SampleSkewness, SampleKurtosis.
     */
    n = 10;
    ae_vector_set_length(&x, n, _state);
    for(i=0; i<=n-1; i++)
    {
        x.ptr.p_double[i] = ae_sqr((double)(i), _state);
    }
    samplemoments(&x, n, &mean, &variance, &skewness, &kurtosis, _state);
    s1errors = s1errors||ae_fp_greater(ae_fabs(mean-28.5, _state),0.001);
    s1errors = s1errors||ae_fp_greater(ae_fabs(variance-801.1667, _state),0.001);
    s1errors = s1errors||ae_fp_greater(ae_fabs(skewness-0.5751, _state),0.001);
    s1errors = s1errors||ae_fp_greater(ae_fabs(kurtosis+1.2666, _state),0.001);
    tmean = samplemean(&x, n, _state);
    tvariance = samplevariance(&x, n, _state);
    tskewness = sampleskewness(&x, n, _state);
    tkurtosis = samplekurtosis(&x, n, _state);
    s1errors = s1errors||ae_fp_neq(mean-tmean,(double)(0));
    s1errors = s1errors||ae_fp_neq(variance-tvariance,(double)(0));
    s1errors = s1errors||ae_fp_neq(skewness-tskewness,(double)(0));
    s1errors = s1errors||ae_fp_neq(kurtosis-tkurtosis,(double)(0));
    sampleadev(&x, n, &adev, _state);
    s1errors = s1errors||ae_fp_greater(ae_fabs(adev-23.2000, _state),0.001);
    samplemedian(&x, n, &median, _state);
    s1errors = s1errors||ae_fp_greater(ae_fabs(median-0.5*(16+25), _state),0.001);
    for(i=0; i<=n-1; i++)
    {
        samplepercentile(&x, n, (double)i/(double)(n-1), &pv, _state);
        s1errors = s1errors||ae_fp_greater(ae_fabs(pv-x.ptr.p_double[i], _state),0.001);
    }
    samplepercentile(&x, n, 0.5, &pv, _state);
    s1errors = s1errors||ae_fp_greater(ae_fabs(pv-0.5*(16+25), _state),0.001);
    
    /*
     * test covariance/correlation:
     * * 2-sample coefficients
     *
     * We generate random matrices MX and MY
     */
    n = 10;
    ae_vector_set_length(&x, n, _state);
    ae_vector_set_length(&y, n, _state);
    for(i=0; i<=n-1; i++)
    {
        x.ptr.p_double[i] = ae_sqr((double)(i), _state);
        y.ptr.p_double[i] = (double)(i);
    }
    covcorrerrors = covcorrerrors||ae_fp_greater(ae_fabs(pearsoncorr2(&x, &y, n, _state)-0.9627, _state),0.0001);
    covcorrerrors = covcorrerrors||ae_fp_greater(ae_fabs(spearmancorr2(&x, &y, n, _state)-1.0000, _state),0.0001);
    covcorrerrors = covcorrerrors||ae_fp_greater(ae_fabs(cov2(&x, &y, n, _state)-82.5000, _state),0.0001);
    for(i=0; i<=n-1; i++)
    {
        x.ptr.p_double[i] = ae_sqr(i-0.5*n, _state);
        y.ptr.p_double[i] = (double)(i);
    }
    covcorrerrors = covcorrerrors||ae_fp_greater(ae_fabs(pearsoncorr2(&x, &y, n, _state)+0.3676, _state),0.0001);
    covcorrerrors = covcorrerrors||ae_fp_greater(ae_fabs(spearmancorr2(&x, &y, n, _state)+0.2761, _state),0.0001);
    covcorrerrors = covcorrerrors||ae_fp_greater(ae_fabs(cov2(&x, &y, n, _state)+9.1667, _state),0.0001);
    
    /*
     * test covariance/correlation:
     * * matrix covariance/correlation
     * * matrix cross-covariance/cross-correlation
     *
     * We generate random matrices MX and MY which contain KX (KY)
     * columns, all except one are random, one of them is constant.
     * We test that function (a) do not crash on constant column,
     * and (b) return variances/correlations that are exactly zero
     * for this column.
     *
     * CType control variable controls type of constant: 0 - no constant
     * column, 1 - zero column, 2 - nonzero column with value whose
     * binary representation contains many non-zero bits. Using such
     * type of constant column we are able to ensure than even in the
     * presense of roundoff error functions correctly detect constant
     * columns.
     */
    for(n=0; n<=10; n++)
    {
        if( n>0 )
        {
            ae_vector_set_length(&x, n, _state);
            ae_vector_set_length(&y, n, _state);
        }
        for(ctype=0; ctype<=2; ctype++)
        {
            for(kx=1; kx<=10; kx++)
            {
                for(ky=1; ky<=10; ky++)
                {
                    
                    /*
                     * Fill matrices, add constant column (when CType=1 or =2)
                     */
                    cidxx = -1;
                    cidxy = -1;
                    if( n>0 )
                    {
                        ae_matrix_set_length(&mx, n, kx, _state);
                        ae_matrix_set_length(&my, n, ky, _state);
                        for(i=0; i<=n-1; i++)
                        {
                            for(j=0; j<=kx-1; j++)
                            {
                                mx.ptr.pp_double[i][j] = 2*ae_randomreal(_state)-1;
                            }
                            for(j=0; j<=ky-1; j++)
                            {
                                my.ptr.pp_double[i][j] = 2*ae_randomreal(_state)-1;
                            }
                        }
                        if( ctype==1 )
                        {
                            cidxx = ae_randominteger(kx, _state);
                            cidxy = ae_randominteger(ky, _state);
                            for(i=0; i<=n-1; i++)
                            {
                                mx.ptr.pp_double[i][cidxx] = 0.0;
                                my.ptr.pp_double[i][cidxy] = 0.0;
                            }
                        }
                        if( ctype==2 )
                        {
                            cidxx = ae_randominteger(kx, _state);
                            cidxy = ae_randominteger(ky, _state);
                            v = ae_sqrt((double)(ae_randominteger(kx, _state)+1)/(double)kx, _state);
                            for(i=0; i<=n-1; i++)
                            {
                                mx.ptr.pp_double[i][cidxx] = v;
                                my.ptr.pp_double[i][cidxy] = v;
                            }
                        }
                    }
                    
                    /*
                     * test covariance/correlation matrix using
                     * 2-sample functions as reference point.
                     *
                     * We also test that coefficients for constant variables
                     * are exactly zero.
                     */
                    covm(&mx, n, kx, &cc, _state);
                    pearsoncorrm(&mx, n, kx, &cp, _state);
                    spearmancorrm(&mx, n, kx, &cs, _state);
                    for(i=0; i<=kx-1; i++)
                    {
                        for(j=0; j<=kx-1; j++)
                        {
                            if( n>0 )
                            {
                                ae_v_move(&x.ptr.p_double[0], 1, &mx.ptr.pp_double[0][i], mx.stride, ae_v_len(0,n-1));
                                ae_v_move(&y.ptr.p_double[0], 1, &mx.ptr.pp_double[0][j], mx.stride, ae_v_len(0,n-1));
                            }
                            covcorrerrors = covcorrerrors||ae_fp_greater(ae_fabs(cov2(&x, &y, n, _state)-cc.ptr.pp_double[i][j], _state),threshold);
                            covcorrerrors = covcorrerrors||ae_fp_greater(ae_fabs(pearsoncorr2(&x, &y, n, _state)-cp.ptr.pp_double[i][j], _state),threshold);
                            covcorrerrors = covcorrerrors||ae_fp_greater(ae_fabs(spearmancorr2(&x, &y, n, _state)-cs.ptr.pp_double[i][j], _state),threshold);
                        }
                    }
                    if( ctype!=0&&n>0 )
                    {
                        for(i=0; i<=kx-1; i++)
                        {
                            covcorrerrors = covcorrerrors||ae_fp_neq(cc.ptr.pp_double[i][cidxx],(double)(0));
                            covcorrerrors = covcorrerrors||ae_fp_neq(cc.ptr.pp_double[cidxx][i],(double)(0));
                            covcorrerrors = covcorrerrors||ae_fp_neq(cp.ptr.pp_double[i][cidxx],(double)(0));
                            covcorrerrors = covcorrerrors||ae_fp_neq(cp.ptr.pp_double[cidxx][i],(double)(0));
                            covcorrerrors = covcorrerrors||ae_fp_neq(cs.ptr.pp_double[i][cidxx],(double)(0));
                            covcorrerrors = covcorrerrors||ae_fp_neq(cs.ptr.pp_double[cidxx][i],(double)(0));
                        }
                    }
                    
                    /*
                     * test cross-covariance/cross-correlation matrix using
                     * 2-sample functions as reference point.
                     *
                     * We also test that coefficients for constant variables
                     * are exactly zero.
                     */
                    covm2(&mx, &my, n, kx, ky, &cc, _state);
                    pearsoncorrm2(&mx, &my, n, kx, ky, &cp, _state);
                    spearmancorrm2(&mx, &my, n, kx, ky, &cs, _state);
                    for(i=0; i<=kx-1; i++)
                    {
                        for(j=0; j<=ky-1; j++)
                        {
                            if( n>0 )
                            {
                                ae_v_move(&x.ptr.p_double[0], 1, &mx.ptr.pp_double[0][i], mx.stride, ae_v_len(0,n-1));
                                ae_v_move(&y.ptr.p_double[0], 1, &my.ptr.pp_double[0][j], my.stride, ae_v_len(0,n-1));
                            }
                            covcorrerrors = covcorrerrors||ae_fp_greater(ae_fabs(cov2(&x, &y, n, _state)-cc.ptr.pp_double[i][j], _state),threshold);
                            covcorrerrors = covcorrerrors||ae_fp_greater(ae_fabs(pearsoncorr2(&x, &y, n, _state)-cp.ptr.pp_double[i][j], _state),threshold);
                            covcorrerrors = covcorrerrors||ae_fp_greater(ae_fabs(spearmancorr2(&x, &y, n, _state)-cs.ptr.pp_double[i][j], _state),threshold);
                        }
                    }
                    if( ctype!=0&&n>0 )
                    {
                        for(i=0; i<=kx-1; i++)
                        {
                            covcorrerrors = covcorrerrors||ae_fp_neq(cc.ptr.pp_double[i][cidxy],(double)(0));
                            covcorrerrors = covcorrerrors||ae_fp_neq(cp.ptr.pp_double[i][cidxy],(double)(0));
                            covcorrerrors = covcorrerrors||ae_fp_neq(cs.ptr.pp_double[i][cidxy],(double)(0));
                        }
                        for(j=0; j<=ky-1; j++)
                        {
                            covcorrerrors = covcorrerrors||ae_fp_neq(cc.ptr.pp_double[cidxx][j],(double)(0));
                            covcorrerrors = covcorrerrors||ae_fp_neq(cp.ptr.pp_double[cidxx][j],(double)(0));
                            covcorrerrors = covcorrerrors||ae_fp_neq(cs.ptr.pp_double[cidxx][j],(double)(0));
                        }
                    }
                }
            }
        }
    }
    
    /*
     * Final report
     */
    waserrors = (s1errors||covcorrerrors)||rankerrors;
    if( !silent )
    {
        printf("DESC.STAT TEST\n");
        printf("TOTAL RESULTS:                           ");
        if( !waserrors )
        {
            printf("OK\n");
        }
        else
        {
            printf("FAILED\n");
        }
        printf("* 1-SAMPLE FUNCTIONALITY:                ");
        if( !s1errors )
        {
            printf("OK\n");
        }
        else
        {
            printf("FAILED\n");
        }
        printf("* CORRELATION/COVARIATION:               ");
        if( !covcorrerrors )
        {
            printf("OK\n");
        }
        else
        {
            printf("FAILED\n");
        }
        printf("* RANKING:                               ");
        if( !rankerrors )
        {
            printf("OK\n");
        }
        else
        {
            printf("FAILED\n");
        }
        if( waserrors )
        {
            printf("TEST SUMMARY: FAILED\n");
        }
        else
        {
            printf("TEST SUMMARY: PASSED\n");
        }
        printf("\n\n");
    }
    result = !waserrors;
    ae_frame_leave(_state);
    return result;
}


/*************************************************************************
Single-threaded stub. HPC ALGLIB replaces it by multithreaded code.
*************************************************************************/
ae_bool _pexec_testbasestat(ae_bool silent, ae_state *_state)
{
    return testbasestat(silent, _state);
}


/*************************************************************************
This function tests ranking functionality. In case  of  failure  it  sets
Err parameter to True; this parameter is left unchanged otherwise.
*************************************************************************/
static void testbasestatunit_testranking(ae_bool* err, ae_state *_state)
{
    ae_frame _frame_block;
    ae_int_t testk;
    ae_int_t npoints;
    ae_int_t nfeatures;
    ae_int_t i;
    ae_int_t j;
    ae_int_t k;
    ae_matrix xy0;
    ae_matrix xy1;
    ae_matrix xy2;
    double v;

    ae_frame_make(_state, &_frame_block);
    ae_matrix_init(&xy0, 0, 0, DT_REAL, _state);
    ae_matrix_init(&xy1, 0, 0, DT_REAL, _state);
    ae_matrix_init(&xy2, 0, 0, DT_REAL, _state);

    
    /*
     * Test 1 - large array, unique ranks, each row is obtained as follows:
     * * we generate X[i=0..N-1] = I
     * * we add random noise: X[i] := X[i] + 0.2*randomreal()-0.1
     * * we perform random permutation
     *
     * Such dataset has following properties:
     * * all data are unique within their rows
     * * rank(X[i]) = round(X[i])
     *
     * We perform several tests with different NPoints/NFeatures.
     */
    for(testk=0; testk<=1; testk++)
    {
        
        /*
         * Select problem size
         */
        if( testk==0 )
        {
            npoints = 200;
            nfeatures = 1000;
        }
        else
        {
            npoints = 1000;
            nfeatures = 200;
        }
        
        /*
         * Generate XY0, XY1, XY2
         */
        ae_matrix_set_length(&xy0, npoints, nfeatures, _state);
        ae_matrix_set_length(&xy1, npoints, nfeatures, _state);
        ae_matrix_set_length(&xy2, npoints, nfeatures, _state);
        for(i=0; i<=npoints-1; i++)
        {
            for(j=0; j<=nfeatures-1; j++)
            {
                xy0.ptr.pp_double[i][j] = j+0.2*ae_randomreal(_state)-0.1;
            }
            for(j=0; j<=nfeatures-2; j++)
            {
                k = ae_randominteger(nfeatures-j, _state);
                if( k!=0 )
                {
                    v = xy0.ptr.pp_double[i][j];
                    xy0.ptr.pp_double[i][j] = xy0.ptr.pp_double[i][j+k];
                    xy0.ptr.pp_double[i][j+k] = v;
                }
            }
            for(j=0; j<=nfeatures-1; j++)
            {
                xy1.ptr.pp_double[i][j] = xy0.ptr.pp_double[i][j];
                xy2.ptr.pp_double[i][j] = xy0.ptr.pp_double[i][j];
            }
        }
        
        /*
         * Test uncentered ranks
         */
        rankdata(&xy0, npoints, nfeatures, _state);
        for(i=0; i<=npoints-1; i++)
        {
            for(j=0; j<=nfeatures-1; j++)
            {
                if( ae_fp_neq(xy0.ptr.pp_double[i][j],(double)(ae_round(xy2.ptr.pp_double[i][j], _state))) )
                {
                    *err = ae_true;
                }
            }
        }
        
        /*
         * Test centered ranks:
         * they must be equal to uncentered ranks minus (NFeatures-1)/2
         */
        rankdatacentered(&xy1, npoints, nfeatures, _state);
        for(i=0; i<=npoints-1; i++)
        {
            for(j=0; j<=nfeatures-1; j++)
            {
                if( ae_fp_neq(xy1.ptr.pp_double[i][j],ae_round(xy2.ptr.pp_double[i][j], _state)-(double)(nfeatures-1)/(double)2) )
                {
                    *err = ae_true;
                }
            }
        }
    }
    
    /*
     * Test correct handling of tied ranks
     */
    npoints = 3;
    nfeatures = 4;
    ae_matrix_set_length(&xy0, npoints, nfeatures, _state);
    ae_matrix_set_length(&xy1, npoints, nfeatures, _state);
    xy0.ptr.pp_double[0][0] = 2.25;
    xy0.ptr.pp_double[0][1] = 3.75;
    xy0.ptr.pp_double[0][2] = 3.25;
    xy0.ptr.pp_double[0][3] = 2.25;
    xy0.ptr.pp_double[1][0] = (double)(2);
    xy0.ptr.pp_double[1][1] = (double)(2);
    xy0.ptr.pp_double[1][2] = (double)(2);
    xy0.ptr.pp_double[1][3] = (double)(7);
    xy0.ptr.pp_double[2][0] = (double)(9);
    xy0.ptr.pp_double[2][1] = (double)(9);
    xy0.ptr.pp_double[2][2] = (double)(9);
    xy0.ptr.pp_double[2][3] = (double)(9);
    for(i=0; i<=npoints-1; i++)
    {
        for(j=0; j<=nfeatures-1; j++)
        {
            xy1.ptr.pp_double[i][j] = xy0.ptr.pp_double[i][j];
        }
    }
    rankdata(&xy0, npoints, nfeatures, _state);
    if( ae_fp_greater(ae_fabs(xy0.ptr.pp_double[0][0]-0.5, _state),10*ae_machineepsilon) )
    {
        *err = ae_true;
    }
    if( ae_fp_greater(ae_fabs(xy0.ptr.pp_double[0][1]-3.0, _state),10*ae_machineepsilon) )
    {
        *err = ae_true;
    }
    if( ae_fp_greater(ae_fabs(xy0.ptr.pp_double[0][2]-2.0, _state),10*ae_machineepsilon) )
    {
        *err = ae_true;
    }
    if( ae_fp_greater(ae_fabs(xy0.ptr.pp_double[0][3]-0.5, _state),10*ae_machineepsilon) )
    {
        *err = ae_true;
    }
    if( ae_fp_greater(ae_fabs(xy0.ptr.pp_double[1][0]-1.0, _state),10*ae_machineepsilon) )
    {
        *err = ae_true;
    }
    if( ae_fp_greater(ae_fabs(xy0.ptr.pp_double[1][1]-1.0, _state),10*ae_machineepsilon) )
    {
        *err = ae_true;
    }
    if( ae_fp_greater(ae_fabs(xy0.ptr.pp_double[1][2]-1.0, _state),10*ae_machineepsilon) )
    {
        *err = ae_true;
    }
    if( ae_fp_greater(ae_fabs(xy0.ptr.pp_double[1][3]-3.0, _state),10*ae_machineepsilon) )
    {
        *err = ae_true;
    }
    if( ae_fp_greater(ae_fabs(xy0.ptr.pp_double[2][0]-1.5, _state),10*ae_machineepsilon) )
    {
        *err = ae_true;
    }
    if( ae_fp_greater(ae_fabs(xy0.ptr.pp_double[2][1]-1.5, _state),10*ae_machineepsilon) )
    {
        *err = ae_true;
    }
    if( ae_fp_greater(ae_fabs(xy0.ptr.pp_double[2][2]-1.5, _state),10*ae_machineepsilon) )
    {
        *err = ae_true;
    }
    if( ae_fp_greater(ae_fabs(xy0.ptr.pp_double[2][3]-1.5, _state),10*ae_machineepsilon) )
    {
        *err = ae_true;
    }
    rankdatacentered(&xy1, npoints, nfeatures, _state);
    if( ae_fp_greater(ae_fabs(xy1.ptr.pp_double[0][0]+1.0, _state),10*ae_machineepsilon) )
    {
        *err = ae_true;
    }
    if( ae_fp_greater(ae_fabs(xy1.ptr.pp_double[0][1]-1.5, _state),10*ae_machineepsilon) )
    {
        *err = ae_true;
    }
    if( ae_fp_greater(ae_fabs(xy1.ptr.pp_double[0][2]-0.5, _state),10*ae_machineepsilon) )
    {
        *err = ae_true;
    }
    if( ae_fp_greater(ae_fabs(xy1.ptr.pp_double[0][3]+1.0, _state),10*ae_machineepsilon) )
    {
        *err = ae_true;
    }
    if( ae_fp_greater(ae_fabs(xy1.ptr.pp_double[1][0]+0.5, _state),10*ae_machineepsilon) )
    {
        *err = ae_true;
    }
    if( ae_fp_greater(ae_fabs(xy1.ptr.pp_double[1][1]+0.5, _state),10*ae_machineepsilon) )
    {
        *err = ae_true;
    }
    if( ae_fp_greater(ae_fabs(xy1.ptr.pp_double[1][2]+0.5, _state),10*ae_machineepsilon) )
    {
        *err = ae_true;
    }
    if( ae_fp_greater(ae_fabs(xy1.ptr.pp_double[1][3]-1.5, _state),10*ae_machineepsilon) )
    {
        *err = ae_true;
    }
    if( ae_fp_neq(xy1.ptr.pp_double[2][0],(double)(0)) )
    {
        *err = ae_true;
    }
    if( ae_fp_neq(xy1.ptr.pp_double[2][1],(double)(0)) )
    {
        *err = ae_true;
    }
    if( ae_fp_neq(xy1.ptr.pp_double[2][2],(double)(0)) )
    {
        *err = ae_true;
    }
    if( ae_fp_neq(xy1.ptr.pp_double[2][3],(double)(0)) )
    {
        *err = ae_true;
    }
    ae_frame_leave(_state);
}



static void testbdssunit_unset2d(/* Complex */ ae_matrix* a,
     ae_state *_state);
static void testbdssunit_unset1d(/* Real    */ ae_vector* a,
     ae_state *_state);
static void testbdssunit_unset1di(/* Integer */ ae_vector* a,
     ae_state *_state);
static void testbdssunit_testsortresults(/* Real    */ ae_vector* asorted,
     /* Integer */ ae_vector* p1,
     /* Integer */ ae_vector* p2,
     /* Real    */ ae_vector* aoriginal,
     ae_int_t n,
     ae_bool* waserrors,
     ae_state *_state);





/*************************************************************************
Testing BDSS operations
*************************************************************************/
ae_bool testbdss(ae_bool silent, ae_state *_state)
{
    ae_frame _frame_block;
    ae_int_t n;
    ae_int_t i;
    ae_int_t j;
    ae_int_t pass;
    ae_int_t passcount;
    ae_int_t maxn;
    ae_int_t maxnq;
    ae_vector a;
    ae_vector a0;
    ae_vector at;
    ae_matrix p;
    ae_vector thresholds;
    ae_int_t ni;
    ae_vector c;
    ae_vector p1;
    ae_vector p2;
    ae_vector ties;
    ae_vector pt1;
    ae_vector pt2;
    ae_int_t tiecount;
    ae_int_t c1;
    ae_int_t c0;
    ae_int_t nc;
    ae_vector tmp;
    ae_vector sortrbuf;
    ae_vector sortrbuf2;
    ae_vector sortibuf;
    double pal;
    double pbl;
    double par;
    double pbr;
    double cve;
    double cvr;
    ae_int_t info;
    double threshold;
    ae_vector tiebuf;
    ae_vector cntbuf;
    double rms;
    double cvrms;
    ae_bool waserrors;
    ae_bool tieserrors;
    ae_bool split2errors;
    ae_bool optimalsplitkerrors;
    ae_bool splitkerrors;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    ae_vector_init(&a, 0, DT_REAL, _state);
    ae_vector_init(&a0, 0, DT_REAL, _state);
    ae_vector_init(&at, 0, DT_REAL, _state);
    ae_matrix_init(&p, 0, 0, DT_REAL, _state);
    ae_vector_init(&thresholds, 0, DT_REAL, _state);
    ae_vector_init(&c, 0, DT_INT, _state);
    ae_vector_init(&p1, 0, DT_INT, _state);
    ae_vector_init(&p2, 0, DT_INT, _state);
    ae_vector_init(&ties, 0, DT_INT, _state);
    ae_vector_init(&pt1, 0, DT_INT, _state);
    ae_vector_init(&pt2, 0, DT_INT, _state);
    ae_vector_init(&tmp, 0, DT_REAL, _state);
    ae_vector_init(&sortrbuf, 0, DT_REAL, _state);
    ae_vector_init(&sortrbuf2, 0, DT_REAL, _state);
    ae_vector_init(&sortibuf, 0, DT_INT, _state);
    ae_vector_init(&tiebuf, 0, DT_INT, _state);
    ae_vector_init(&cntbuf, 0, DT_INT, _state);

    waserrors = ae_false;
    tieserrors = ae_false;
    split2errors = ae_false;
    splitkerrors = ae_false;
    optimalsplitkerrors = ae_false;
    maxn = 100;
    maxnq = 49;
    passcount = 10;
    
    /*
     * Test ties
     */
    for(n=1; n<=maxn; n++)
    {
        for(pass=1; pass<=passcount; pass++)
        {
            
            /*
             * untied data, test DSTie
             */
            testbdssunit_unset1di(&p1, _state);
            testbdssunit_unset1di(&p2, _state);
            testbdssunit_unset1di(&pt1, _state);
            testbdssunit_unset1di(&pt2, _state);
            ae_vector_set_length(&a, n-1+1, _state);
            ae_vector_set_length(&a0, n-1+1, _state);
            ae_vector_set_length(&at, n-1+1, _state);
            ae_vector_set_length(&tmp, n-1+1, _state);
            a.ptr.p_double[0] = 2*ae_randomreal(_state)-1;
            tmp.ptr.p_double[0] = ae_randomreal(_state);
            for(i=1; i<=n-1; i++)
            {
                
                /*
                 * A is randomly permuted
                 */
                a.ptr.p_double[i] = a.ptr.p_double[i-1]+0.1*ae_randomreal(_state)+0.1;
                tmp.ptr.p_double[i] = ae_randomreal(_state);
            }
            tagsortfastr(&tmp, &a, &sortrbuf, &sortrbuf2, n, _state);
            for(i=0; i<=n-1; i++)
            {
                a0.ptr.p_double[i] = a.ptr.p_double[i];
                at.ptr.p_double[i] = a.ptr.p_double[i];
            }
            dstie(&a0, n, &ties, &tiecount, &p1, &p2, _state);
            tagsort(&at, n, &pt1, &pt2, _state);
            for(i=0; i<=n-1; i++)
            {
                tieserrors = tieserrors||p1.ptr.p_int[i]!=pt1.ptr.p_int[i];
                tieserrors = tieserrors||p2.ptr.p_int[i]!=pt2.ptr.p_int[i];
            }
            tieserrors = tieserrors||tiecount!=n;
            if( tiecount==n )
            {
                for(i=0; i<=n; i++)
                {
                    tieserrors = tieserrors||ties.ptr.p_int[i]!=i;
                }
            }
            
            /*
             * tied data, test DSTie
             */
            testbdssunit_unset1di(&p1, _state);
            testbdssunit_unset1di(&p2, _state);
            testbdssunit_unset1di(&pt1, _state);
            testbdssunit_unset1di(&pt2, _state);
            ae_vector_set_length(&a, n-1+1, _state);
            ae_vector_set_length(&a0, n-1+1, _state);
            ae_vector_set_length(&at, n-1+1, _state);
            c1 = 0;
            c0 = 0;
            for(i=0; i<=n-1; i++)
            {
                a.ptr.p_double[i] = (double)(ae_randominteger(2, _state));
                if( ae_fp_eq(a.ptr.p_double[i],(double)(0)) )
                {
                    c0 = c0+1;
                }
                else
                {
                    c1 = c1+1;
                }
                a0.ptr.p_double[i] = a.ptr.p_double[i];
                at.ptr.p_double[i] = a.ptr.p_double[i];
            }
            dstie(&a0, n, &ties, &tiecount, &p1, &p2, _state);
            tagsort(&at, n, &pt1, &pt2, _state);
            for(i=0; i<=n-1; i++)
            {
                tieserrors = tieserrors||p1.ptr.p_int[i]!=pt1.ptr.p_int[i];
                tieserrors = tieserrors||p2.ptr.p_int[i]!=pt2.ptr.p_int[i];
            }
            if( c0==0||c1==0 )
            {
                tieserrors = tieserrors||tiecount!=1;
                if( tiecount==1 )
                {
                    tieserrors = tieserrors||ties.ptr.p_int[0]!=0;
                    tieserrors = tieserrors||ties.ptr.p_int[1]!=n;
                }
            }
            else
            {
                tieserrors = tieserrors||tiecount!=2;
                if( tiecount==2 )
                {
                    tieserrors = tieserrors||ties.ptr.p_int[0]!=0;
                    tieserrors = tieserrors||ties.ptr.p_int[1]!=c0;
                    tieserrors = tieserrors||ties.ptr.p_int[2]!=n;
                }
            }
        }
    }
    
    /*
     * split-2
     */
    
    /*
     * General tests for different N's
     */
    for(n=1; n<=maxn; n++)
    {
        ae_vector_set_length(&a, n-1+1, _state);
        ae_vector_set_length(&c, n-1+1, _state);
        
        /*
         * one-tie test
         */
        if( n%2==0 )
        {
            for(i=0; i<=n-1; i++)
            {
                a.ptr.p_double[i] = (double)(n);
                c.ptr.p_int[i] = i%2;
            }
            dsoptimalsplit2(&a, &c, n, &info, &threshold, &pal, &pbl, &par, &pbr, &cve, _state);
            if( info!=-3 )
            {
                split2errors = ae_true;
                continue;
            }
        }
        
        /*
         * two-tie test
         */
        
        /*
         * test #1
         */
        if( n>1 )
        {
            for(i=0; i<=n-1; i++)
            {
                a.ptr.p_double[i] = (double)(i/((n+1)/2));
                c.ptr.p_int[i] = i/((n+1)/2);
            }
            dsoptimalsplit2(&a, &c, n, &info, &threshold, &pal, &pbl, &par, &pbr, &cve, _state);
            if( info!=1 )
            {
                split2errors = ae_true;
                continue;
            }
            split2errors = split2errors||ae_fp_greater(ae_fabs(threshold-0.5, _state),100*ae_machineepsilon);
            split2errors = split2errors||ae_fp_greater(ae_fabs(pal-1, _state),100*ae_machineepsilon);
            split2errors = split2errors||ae_fp_greater(ae_fabs(pbl-0, _state),100*ae_machineepsilon);
            split2errors = split2errors||ae_fp_greater(ae_fabs(par-0, _state),100*ae_machineepsilon);
            split2errors = split2errors||ae_fp_greater(ae_fabs(pbr-1, _state),100*ae_machineepsilon);
        }
    }
    
    /*
     * Special "CREDIT"-test (transparency coefficient)
     */
    n = 110;
    ae_vector_set_length(&a, n-1+1, _state);
    ae_vector_set_length(&c, n-1+1, _state);
    a.ptr.p_double[0] = 0.000;
    c.ptr.p_int[0] = 0;
    a.ptr.p_double[1] = 0.000;
    c.ptr.p_int[1] = 0;
    a.ptr.p_double[2] = 0.000;
    c.ptr.p_int[2] = 0;
    a.ptr.p_double[3] = 0.000;
    c.ptr.p_int[3] = 0;
    a.ptr.p_double[4] = 0.000;
    c.ptr.p_int[4] = 0;
    a.ptr.p_double[5] = 0.000;
    c.ptr.p_int[5] = 0;
    a.ptr.p_double[6] = 0.000;
    c.ptr.p_int[6] = 0;
    a.ptr.p_double[7] = 0.000;
    c.ptr.p_int[7] = 1;
    a.ptr.p_double[8] = 0.000;
    c.ptr.p_int[8] = 0;
    a.ptr.p_double[9] = 0.000;
    c.ptr.p_int[9] = 1;
    a.ptr.p_double[10] = 0.000;
    c.ptr.p_int[10] = 0;
    a.ptr.p_double[11] = 0.000;
    c.ptr.p_int[11] = 0;
    a.ptr.p_double[12] = 0.000;
    c.ptr.p_int[12] = 0;
    a.ptr.p_double[13] = 0.000;
    c.ptr.p_int[13] = 0;
    a.ptr.p_double[14] = 0.000;
    c.ptr.p_int[14] = 0;
    a.ptr.p_double[15] = 0.000;
    c.ptr.p_int[15] = 0;
    a.ptr.p_double[16] = 0.000;
    c.ptr.p_int[16] = 0;
    a.ptr.p_double[17] = 0.000;
    c.ptr.p_int[17] = 0;
    a.ptr.p_double[18] = 0.000;
    c.ptr.p_int[18] = 0;
    a.ptr.p_double[19] = 0.000;
    c.ptr.p_int[19] = 0;
    a.ptr.p_double[20] = 0.000;
    c.ptr.p_int[20] = 0;
    a.ptr.p_double[21] = 0.000;
    c.ptr.p_int[21] = 0;
    a.ptr.p_double[22] = 0.000;
    c.ptr.p_int[22] = 1;
    a.ptr.p_double[23] = 0.000;
    c.ptr.p_int[23] = 0;
    a.ptr.p_double[24] = 0.000;
    c.ptr.p_int[24] = 0;
    a.ptr.p_double[25] = 0.000;
    c.ptr.p_int[25] = 0;
    a.ptr.p_double[26] = 0.000;
    c.ptr.p_int[26] = 0;
    a.ptr.p_double[27] = 0.000;
    c.ptr.p_int[27] = 1;
    a.ptr.p_double[28] = 0.000;
    c.ptr.p_int[28] = 0;
    a.ptr.p_double[29] = 0.000;
    c.ptr.p_int[29] = 1;
    a.ptr.p_double[30] = 0.000;
    c.ptr.p_int[30] = 0;
    a.ptr.p_double[31] = 0.000;
    c.ptr.p_int[31] = 1;
    a.ptr.p_double[32] = 0.000;
    c.ptr.p_int[32] = 0;
    a.ptr.p_double[33] = 0.000;
    c.ptr.p_int[33] = 1;
    a.ptr.p_double[34] = 0.000;
    c.ptr.p_int[34] = 0;
    a.ptr.p_double[35] = 0.030;
    c.ptr.p_int[35] = 0;
    a.ptr.p_double[36] = 0.030;
    c.ptr.p_int[36] = 0;
    a.ptr.p_double[37] = 0.050;
    c.ptr.p_int[37] = 0;
    a.ptr.p_double[38] = 0.070;
    c.ptr.p_int[38] = 1;
    a.ptr.p_double[39] = 0.110;
    c.ptr.p_int[39] = 0;
    a.ptr.p_double[40] = 0.110;
    c.ptr.p_int[40] = 1;
    a.ptr.p_double[41] = 0.120;
    c.ptr.p_int[41] = 0;
    a.ptr.p_double[42] = 0.130;
    c.ptr.p_int[42] = 0;
    a.ptr.p_double[43] = 0.140;
    c.ptr.p_int[43] = 0;
    a.ptr.p_double[44] = 0.140;
    c.ptr.p_int[44] = 0;
    a.ptr.p_double[45] = 0.140;
    c.ptr.p_int[45] = 0;
    a.ptr.p_double[46] = 0.150;
    c.ptr.p_int[46] = 0;
    a.ptr.p_double[47] = 0.150;
    c.ptr.p_int[47] = 0;
    a.ptr.p_double[48] = 0.170;
    c.ptr.p_int[48] = 0;
    a.ptr.p_double[49] = 0.190;
    c.ptr.p_int[49] = 1;
    a.ptr.p_double[50] = 0.200;
    c.ptr.p_int[50] = 0;
    a.ptr.p_double[51] = 0.200;
    c.ptr.p_int[51] = 0;
    a.ptr.p_double[52] = 0.250;
    c.ptr.p_int[52] = 0;
    a.ptr.p_double[53] = 0.250;
    c.ptr.p_int[53] = 0;
    a.ptr.p_double[54] = 0.260;
    c.ptr.p_int[54] = 0;
    a.ptr.p_double[55] = 0.270;
    c.ptr.p_int[55] = 0;
    a.ptr.p_double[56] = 0.280;
    c.ptr.p_int[56] = 0;
    a.ptr.p_double[57] = 0.310;
    c.ptr.p_int[57] = 0;
    a.ptr.p_double[58] = 0.310;
    c.ptr.p_int[58] = 0;
    a.ptr.p_double[59] = 0.330;
    c.ptr.p_int[59] = 0;
    a.ptr.p_double[60] = 0.330;
    c.ptr.p_int[60] = 0;
    a.ptr.p_double[61] = 0.340;
    c.ptr.p_int[61] = 0;
    a.ptr.p_double[62] = 0.340;
    c.ptr.p_int[62] = 0;
    a.ptr.p_double[63] = 0.370;
    c.ptr.p_int[63] = 0;
    a.ptr.p_double[64] = 0.380;
    c.ptr.p_int[64] = 1;
    a.ptr.p_double[65] = 0.380;
    c.ptr.p_int[65] = 0;
    a.ptr.p_double[66] = 0.410;
    c.ptr.p_int[66] = 0;
    a.ptr.p_double[67] = 0.460;
    c.ptr.p_int[67] = 0;
    a.ptr.p_double[68] = 0.520;
    c.ptr.p_int[68] = 0;
    a.ptr.p_double[69] = 0.530;
    c.ptr.p_int[69] = 0;
    a.ptr.p_double[70] = 0.540;
    c.ptr.p_int[70] = 0;
    a.ptr.p_double[71] = 0.560;
    c.ptr.p_int[71] = 0;
    a.ptr.p_double[72] = 0.560;
    c.ptr.p_int[72] = 0;
    a.ptr.p_double[73] = 0.570;
    c.ptr.p_int[73] = 0;
    a.ptr.p_double[74] = 0.600;
    c.ptr.p_int[74] = 0;
    a.ptr.p_double[75] = 0.600;
    c.ptr.p_int[75] = 0;
    a.ptr.p_double[76] = 0.620;
    c.ptr.p_int[76] = 0;
    a.ptr.p_double[77] = 0.650;
    c.ptr.p_int[77] = 0;
    a.ptr.p_double[78] = 0.660;
    c.ptr.p_int[78] = 0;
    a.ptr.p_double[79] = 0.680;
    c.ptr.p_int[79] = 0;
    a.ptr.p_double[80] = 0.700;
    c.ptr.p_int[80] = 0;
    a.ptr.p_double[81] = 0.750;
    c.ptr.p_int[81] = 0;
    a.ptr.p_double[82] = 0.770;
    c.ptr.p_int[82] = 0;
    a.ptr.p_double[83] = 0.770;
    c.ptr.p_int[83] = 0;
    a.ptr.p_double[84] = 0.770;
    c.ptr.p_int[84] = 0;
    a.ptr.p_double[85] = 0.790;
    c.ptr.p_int[85] = 0;
    a.ptr.p_double[86] = 0.810;
    c.ptr.p_int[86] = 0;
    a.ptr.p_double[87] = 0.840;
    c.ptr.p_int[87] = 0;
    a.ptr.p_double[88] = 0.860;
    c.ptr.p_int[88] = 0;
    a.ptr.p_double[89] = 0.870;
    c.ptr.p_int[89] = 0;
    a.ptr.p_double[90] = 0.890;
    c.ptr.p_int[90] = 0;
    a.ptr.p_double[91] = 0.900;
    c.ptr.p_int[91] = 1;
    a.ptr.p_double[92] = 0.900;
    c.ptr.p_int[92] = 0;
    a.ptr.p_double[93] = 0.910;
    c.ptr.p_int[93] = 0;
    a.ptr.p_double[94] = 0.940;
    c.ptr.p_int[94] = 0;
    a.ptr.p_double[95] = 0.950;
    c.ptr.p_int[95] = 0;
    a.ptr.p_double[96] = 0.952;
    c.ptr.p_int[96] = 0;
    a.ptr.p_double[97] = 0.970;
    c.ptr.p_int[97] = 0;
    a.ptr.p_double[98] = 0.970;
    c.ptr.p_int[98] = 0;
    a.ptr.p_double[99] = 0.980;
    c.ptr.p_int[99] = 0;
    a.ptr.p_double[100] = 1.000;
    c.ptr.p_int[100] = 0;
    a.ptr.p_double[101] = 1.000;
    c.ptr.p_int[101] = 0;
    a.ptr.p_double[102] = 1.000;
    c.ptr.p_int[102] = 0;
    a.ptr.p_double[103] = 1.000;
    c.ptr.p_int[103] = 0;
    a.ptr.p_double[104] = 1.000;
    c.ptr.p_int[104] = 0;
    a.ptr.p_double[105] = 1.020;
    c.ptr.p_int[105] = 0;
    a.ptr.p_double[106] = 1.090;
    c.ptr.p_int[106] = 0;
    a.ptr.p_double[107] = 1.130;
    c.ptr.p_int[107] = 0;
    a.ptr.p_double[108] = 1.840;
    c.ptr.p_int[108] = 0;
    a.ptr.p_double[109] = 2.470;
    c.ptr.p_int[109] = 0;
    dsoptimalsplit2(&a, &c, n, &info, &threshold, &pal, &pbl, &par, &pbr, &cve, _state);
    if( info!=1 )
    {
        split2errors = ae_true;
    }
    else
    {
        split2errors = split2errors||ae_fp_greater(ae_fabs(threshold-0.195, _state),100*ae_machineepsilon);
        split2errors = split2errors||ae_fp_greater(ae_fabs(pal-0.80, _state),0.02);
        split2errors = split2errors||ae_fp_greater(ae_fabs(pbl-0.20, _state),0.02);
        split2errors = split2errors||ae_fp_greater(ae_fabs(par-0.97, _state),0.02);
        split2errors = split2errors||ae_fp_greater(ae_fabs(pbr-0.03, _state),0.02);
    }
    
    /*
     * split-2 fast
     */
    
    /*
     * General tests for different N's
     */
    for(n=1; n<=maxn; n++)
    {
        ae_vector_set_length(&a, n-1+1, _state);
        ae_vector_set_length(&c, n-1+1, _state);
        ae_vector_set_length(&tiebuf, n+1, _state);
        ae_vector_set_length(&cntbuf, 3+1, _state);
        
        /*
         * one-tie test
         */
        if( n%2==0 )
        {
            for(i=0; i<=n-1; i++)
            {
                a.ptr.p_double[i] = (double)(n);
                c.ptr.p_int[i] = i%2;
            }
            dsoptimalsplit2fast(&a, &c, &tiebuf, &cntbuf, &sortrbuf, &sortibuf, n, 2, 0.00, &info, &threshold, &rms, &cvrms, _state);
            if( info!=-3 )
            {
                split2errors = ae_true;
                continue;
            }
        }
        
        /*
         * two-tie test
         */
        
        /*
         * test #1
         */
        if( n>1 )
        {
            for(i=0; i<=n-1; i++)
            {
                a.ptr.p_double[i] = (double)(i/((n+1)/2));
                c.ptr.p_int[i] = i/((n+1)/2);
            }
            dsoptimalsplit2fast(&a, &c, &tiebuf, &cntbuf, &sortrbuf, &sortibuf, n, 2, 0.00, &info, &threshold, &rms, &cvrms, _state);
            if( info!=1 )
            {
                split2errors = ae_true;
                continue;
            }
            split2errors = split2errors||ae_fp_greater(ae_fabs(threshold-0.5, _state),100*ae_machineepsilon);
            split2errors = split2errors||ae_fp_greater(ae_fabs(rms-0, _state),100*ae_machineepsilon);
            if( n==2 )
            {
                split2errors = split2errors||ae_fp_greater(ae_fabs(cvrms-0.5, _state),100*ae_machineepsilon);
            }
            else
            {
                if( n==3 )
                {
                    split2errors = split2errors||ae_fp_greater(ae_fabs(cvrms-ae_sqrt((2*0+2*0+2*0.25)/6, _state), _state),100*ae_machineepsilon);
                }
                else
                {
                    split2errors = split2errors||ae_fp_greater(ae_fabs(cvrms, _state),100*ae_machineepsilon);
                }
            }
        }
    }
    
    /*
     * special tests
     */
    n = 10;
    ae_vector_set_length(&a, n-1+1, _state);
    ae_vector_set_length(&c, n-1+1, _state);
    ae_vector_set_length(&tiebuf, n+1, _state);
    ae_vector_set_length(&cntbuf, 2*3-1+1, _state);
    for(i=0; i<=n-1; i++)
    {
        a.ptr.p_double[i] = (double)(i);
        if( i<=n-3 )
        {
            c.ptr.p_int[i] = 0;
        }
        else
        {
            c.ptr.p_int[i] = i-(n-3);
        }
    }
    dsoptimalsplit2fast(&a, &c, &tiebuf, &cntbuf, &sortrbuf, &sortibuf, n, 3, 0.00, &info, &threshold, &rms, &cvrms, _state);
    if( info!=1 )
    {
        split2errors = ae_true;
    }
    else
    {
        split2errors = split2errors||ae_fp_greater(ae_fabs(threshold-(n-2.5), _state),100*ae_machineepsilon);
        split2errors = split2errors||ae_fp_greater(ae_fabs(rms-ae_sqrt((0.25+0.25+0.25+0.25)/(3*n), _state), _state),100*ae_machineepsilon);
        split2errors = split2errors||ae_fp_greater(ae_fabs(cvrms-ae_sqrt((double)(1+1+1+1)/(double)(3*n), _state), _state),100*ae_machineepsilon);
    }
    
    /*
     * Optimal split-K
     */
    
    /*
     * General tests for different N's
     */
    for(n=1; n<=maxnq; n++)
    {
        ae_vector_set_length(&a, n-1+1, _state);
        ae_vector_set_length(&c, n-1+1, _state);
        
        /*
         * one-tie test
         */
        if( n%2==0 )
        {
            for(i=0; i<=n-1; i++)
            {
                a.ptr.p_double[i] = (double)(n);
                c.ptr.p_int[i] = i%2;
            }
            dsoptimalsplitk(&a, &c, n, 2, 2+ae_randominteger(5, _state), &info, &thresholds, &ni, &cve, _state);
            if( info!=-3 )
            {
                optimalsplitkerrors = ae_true;
                continue;
            }
        }
        
        /*
         * two-tie test
         */
        
        /*
         * test #1
         */
        if( n>1 )
        {
            c0 = 0;
            c1 = 0;
            for(i=0; i<=n-1; i++)
            {
                a.ptr.p_double[i] = (double)(i/((n+1)/2));
                c.ptr.p_int[i] = i/((n+1)/2);
                if( c.ptr.p_int[i]==0 )
                {
                    c0 = c0+1;
                }
                if( c.ptr.p_int[i]==1 )
                {
                    c1 = c1+1;
                }
            }
            dsoptimalsplitk(&a, &c, n, 2, 2+ae_randominteger(5, _state), &info, &thresholds, &ni, &cve, _state);
            if( info!=1 )
            {
                optimalsplitkerrors = ae_true;
                continue;
            }
            optimalsplitkerrors = optimalsplitkerrors||ni!=2;
            optimalsplitkerrors = optimalsplitkerrors||ae_fp_greater(ae_fabs(thresholds.ptr.p_double[0]-0.5, _state),100*ae_machineepsilon);
            optimalsplitkerrors = optimalsplitkerrors||ae_fp_greater(ae_fabs(cve-(-c0*ae_log((double)c0/(double)(c0+1), _state)-c1*ae_log((double)c1/(double)(c1+1), _state)), _state),100*ae_machineepsilon);
        }
        
        /*
         * test #2
         */
        if( n>2 )
        {
            c0 = 1+ae_randominteger(n-1, _state);
            c1 = n-c0;
            for(i=0; i<=n-1; i++)
            {
                if( i<c0 )
                {
                    a.ptr.p_double[i] = (double)(0);
                    c.ptr.p_int[i] = 0;
                }
                else
                {
                    a.ptr.p_double[i] = (double)(1);
                    c.ptr.p_int[i] = 1;
                }
            }
            dsoptimalsplitk(&a, &c, n, 2, 2+ae_randominteger(5, _state), &info, &thresholds, &ni, &cve, _state);
            if( info!=1 )
            {
                optimalsplitkerrors = ae_true;
                continue;
            }
            optimalsplitkerrors = optimalsplitkerrors||ni!=2;
            optimalsplitkerrors = optimalsplitkerrors||ae_fp_greater(ae_fabs(thresholds.ptr.p_double[0]-0.5, _state),100*ae_machineepsilon);
            optimalsplitkerrors = optimalsplitkerrors||ae_fp_greater(ae_fabs(cve-(-c0*ae_log((double)c0/(double)(c0+1), _state)-c1*ae_log((double)c1/(double)(c1+1), _state)), _state),100*ae_machineepsilon);
        }
        
        /*
         * multi-tie test
         */
        if( n>=16 )
        {
            
            /*
             * Multi-tie test.
             *
             * First NC-1 ties have C0 entries, remaining NC-th tie
             * have C1 entries.
             */
            nc = ae_round(ae_sqrt((double)(n), _state), _state);
            c0 = n/nc;
            c1 = n-c0*(nc-1);
            for(i=0; i<=nc-2; i++)
            {
                for(j=c0*i; j<=c0*(i+1)-1; j++)
                {
                    a.ptr.p_double[j] = (double)(j);
                    c.ptr.p_int[j] = i;
                }
            }
            for(j=c0*(nc-1); j<=n-1; j++)
            {
                a.ptr.p_double[j] = (double)(j);
                c.ptr.p_int[j] = nc-1;
            }
            dsoptimalsplitk(&a, &c, n, nc, nc+ae_randominteger(nc, _state), &info, &thresholds, &ni, &cve, _state);
            if( info!=1 )
            {
                optimalsplitkerrors = ae_true;
                continue;
            }
            optimalsplitkerrors = optimalsplitkerrors||ni!=nc;
            if( ni==nc )
            {
                for(i=0; i<=nc-2; i++)
                {
                    optimalsplitkerrors = optimalsplitkerrors||ae_fp_greater(ae_fabs(thresholds.ptr.p_double[i]-(c0*(i+1)-1+0.5), _state),100*ae_machineepsilon);
                }
                cvr = -((nc-1)*c0*ae_log((double)c0/(double)(c0+nc-1), _state)+c1*ae_log((double)c1/(double)(c1+nc-1), _state));
                optimalsplitkerrors = optimalsplitkerrors||ae_fp_greater(ae_fabs(cve-cvr, _state),100*ae_machineepsilon);
            }
        }
    }
    
    /*
     * Non-optimal split-K
     */
    
    /*
     * General tests for different N's
     */
    for(n=1; n<=maxnq; n++)
    {
        ae_vector_set_length(&a, n-1+1, _state);
        ae_vector_set_length(&c, n-1+1, _state);
        
        /*
         * one-tie test
         */
        if( n%2==0 )
        {
            for(i=0; i<=n-1; i++)
            {
                a.ptr.p_double[i] = (double)(99);
                c.ptr.p_int[i] = i%2;
            }
            dssplitk(&a, &c, n, 2, 2+ae_randominteger(5, _state), &info, &thresholds, &ni, &cve, _state);
            if( info!=-3 )
            {
                splitkerrors = ae_true;
                continue;
            }
        }
        
        /*
         * two-tie test
         */
        
        /*
         * test #1
         */
        if( n>1 )
        {
            c0 = 0;
            c1 = 0;
            for(i=0; i<=n-1; i++)
            {
                a.ptr.p_double[i] = (double)(i/((n+1)/2));
                c.ptr.p_int[i] = i/((n+1)/2);
                if( c.ptr.p_int[i]==0 )
                {
                    c0 = c0+1;
                }
                if( c.ptr.p_int[i]==1 )
                {
                    c1 = c1+1;
                }
            }
            dssplitk(&a, &c, n, 2, 2+ae_randominteger(5, _state), &info, &thresholds, &ni, &cve, _state);
            if( info!=1 )
            {
                splitkerrors = ae_true;
                continue;
            }
            splitkerrors = splitkerrors||ni!=2;
            if( ni==2 )
            {
                splitkerrors = splitkerrors||ae_fp_greater(ae_fabs(thresholds.ptr.p_double[0]-0.5, _state),100*ae_machineepsilon);
                splitkerrors = splitkerrors||ae_fp_greater(ae_fabs(cve-(-c0*ae_log((double)c0/(double)(c0+1), _state)-c1*ae_log((double)c1/(double)(c1+1), _state)), _state),100*ae_machineepsilon);
            }
        }
        
        /*
         * test #2
         */
        if( n>2 )
        {
            c0 = 1+ae_randominteger(n-1, _state);
            c1 = n-c0;
            for(i=0; i<=n-1; i++)
            {
                if( i<c0 )
                {
                    a.ptr.p_double[i] = (double)(0);
                    c.ptr.p_int[i] = 0;
                }
                else
                {
                    a.ptr.p_double[i] = (double)(1);
                    c.ptr.p_int[i] = 1;
                }
            }
            dssplitk(&a, &c, n, 2, 2+ae_randominteger(5, _state), &info, &thresholds, &ni, &cve, _state);
            if( info!=1 )
            {
                splitkerrors = ae_true;
                continue;
            }
            splitkerrors = splitkerrors||ni!=2;
            if( ni==2 )
            {
                splitkerrors = splitkerrors||ae_fp_greater(ae_fabs(thresholds.ptr.p_double[0]-0.5, _state),100*ae_machineepsilon);
                splitkerrors = splitkerrors||ae_fp_greater(ae_fabs(cve-(-c0*ae_log((double)c0/(double)(c0+1), _state)-c1*ae_log((double)c1/(double)(c1+1), _state)), _state),100*ae_machineepsilon);
            }
        }
        
        /*
         * multi-tie test
         */
        for(c0=4; c0<=n; c0++)
        {
            if( (n%c0==0&&n/c0<=c0)&&n/c0>1 )
            {
                nc = n/c0;
                for(i=0; i<=nc-1; i++)
                {
                    for(j=c0*i; j<=c0*(i+1)-1; j++)
                    {
                        a.ptr.p_double[j] = (double)(j);
                        c.ptr.p_int[j] = i;
                    }
                }
                dssplitk(&a, &c, n, nc, nc+ae_randominteger(nc, _state), &info, &thresholds, &ni, &cve, _state);
                if( info!=1 )
                {
                    splitkerrors = ae_true;
                    continue;
                }
                splitkerrors = splitkerrors||ni!=nc;
                if( ni==nc )
                {
                    for(i=0; i<=nc-2; i++)
                    {
                        splitkerrors = splitkerrors||ae_fp_greater(ae_fabs(thresholds.ptr.p_double[i]-(c0*(i+1)-1+0.5), _state),100*ae_machineepsilon);
                    }
                    cvr = -nc*c0*ae_log((double)c0/(double)(c0+nc-1), _state);
                    splitkerrors = splitkerrors||ae_fp_greater(ae_fabs(cve-cvr, _state),100*ae_machineepsilon);
                }
            }
        }
    }
    
    /*
     * report
     */
    waserrors = ((tieserrors||split2errors)||optimalsplitkerrors)||splitkerrors;
    if( !silent )
    {
        printf("TESTING BASIC DATASET SUBROUTINES\n");
        printf("TIES:                               ");
        if( !tieserrors )
        {
            printf("OK\n");
        }
        else
        {
            printf("FAILED\n");
        }
        printf("SPLIT-2:                            ");
        if( !split2errors )
        {
            printf("OK\n");
        }
        else
        {
            printf("FAILED\n");
        }
        printf("OPTIMAL SPLIT-K:                    ");
        if( !optimalsplitkerrors )
        {
            printf("OK\n");
        }
        else
        {
            printf("FAILED\n");
        }
        printf("SPLIT-K:                            ");
        if( !splitkerrors )
        {
            printf("OK\n");
        }
        else
        {
            printf("FAILED\n");
        }
        if( waserrors )
        {
            printf("TEST FAILED\n");
        }
        else
        {
            printf("TEST PASSED\n");
        }
        printf("\n\n");
    }
    result = !waserrors;
    ae_frame_leave(_state);
    return result;
}


/*************************************************************************
Single-threaded stub. HPC ALGLIB replaces it by multithreaded code.
*************************************************************************/
ae_bool _pexec_testbdss(ae_bool silent, ae_state *_state)
{
    return testbdss(silent, _state);
}


/*************************************************************************
Unsets 2D array.
*************************************************************************/
static void testbdssunit_unset2d(/* Complex */ ae_matrix* a,
     ae_state *_state)
{


    ae_matrix_set_length(a, 0+1, 0+1, _state);
    a->ptr.pp_complex[0][0] = ae_complex_from_d(2*ae_randomreal(_state)-1);
}


/*************************************************************************
Unsets 1D array.
*************************************************************************/
static void testbdssunit_unset1d(/* Real    */ ae_vector* a,
     ae_state *_state)
{


    ae_vector_set_length(a, 0+1, _state);
    a->ptr.p_double[0] = 2*ae_randomreal(_state)-1;
}


/*************************************************************************
Unsets 1D array.
*************************************************************************/
static void testbdssunit_unset1di(/* Integer */ ae_vector* a,
     ae_state *_state)
{


    ae_vector_set_length(a, 0+1, _state);
    a->ptr.p_int[0] = ae_randominteger(3, _state)-1;
}


static void testbdssunit_testsortresults(/* Real    */ ae_vector* asorted,
     /* Integer */ ae_vector* p1,
     /* Integer */ ae_vector* p2,
     /* Real    */ ae_vector* aoriginal,
     ae_int_t n,
     ae_bool* waserrors,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_int_t i;
    ae_vector a2;
    double t;
    ae_vector f;

    ae_frame_make(_state, &_frame_block);
    ae_vector_init(&a2, 0, DT_REAL, _state);
    ae_vector_init(&f, 0, DT_INT, _state);

    ae_vector_set_length(&a2, n-1+1, _state);
    ae_vector_set_length(&f, n-1+1, _state);
    
    /*
     * is set ordered?
     */
    for(i=0; i<=n-2; i++)
    {
        *waserrors = *waserrors||ae_fp_greater(asorted->ptr.p_double[i],asorted->ptr.p_double[i+1]);
    }
    
    /*
     * P1 correctness
     */
    for(i=0; i<=n-1; i++)
    {
        *waserrors = *waserrors||ae_fp_neq(asorted->ptr.p_double[i],aoriginal->ptr.p_double[p1->ptr.p_int[i]]);
    }
    for(i=0; i<=n-1; i++)
    {
        f.ptr.p_int[i] = 0;
    }
    for(i=0; i<=n-1; i++)
    {
        f.ptr.p_int[p1->ptr.p_int[i]] = f.ptr.p_int[p1->ptr.p_int[i]]+1;
    }
    for(i=0; i<=n-1; i++)
    {
        *waserrors = *waserrors||f.ptr.p_int[i]!=1;
    }
    
    /*
     * P2 correctness
     */
    for(i=0; i<=n-1; i++)
    {
        a2.ptr.p_double[i] = aoriginal->ptr.p_double[i];
    }
    for(i=0; i<=n-1; i++)
    {
        if( p2->ptr.p_int[i]!=i )
        {
            t = a2.ptr.p_double[i];
            a2.ptr.p_double[i] = a2.ptr.p_double[p2->ptr.p_int[i]];
            a2.ptr.p_double[p2->ptr.p_int[i]] = t;
        }
    }
    for(i=0; i<=n-1; i++)
    {
        *waserrors = *waserrors||ae_fp_neq(asorted->ptr.p_double[i],a2.ptr.p_double[i]);
    }
    ae_frame_leave(_state);
}



static void testblasunit_naivematrixmatrixmultiply(/* Real    */ ae_matrix* a,
     ae_int_t ai1,
     ae_int_t ai2,
     ae_int_t aj1,
     ae_int_t aj2,
     ae_bool transa,
     /* Real    */ ae_matrix* b,
     ae_int_t bi1,
     ae_int_t bi2,
     ae_int_t bj1,
     ae_int_t bj2,
     ae_bool transb,
     double alpha,
     /* Real    */ ae_matrix* c,
     ae_int_t ci1,
     ae_int_t ci2,
     ae_int_t cj1,
     ae_int_t cj2,
     double beta,
     ae_state *_state);





ae_bool testblas(ae_bool silent, ae_state *_state)
{
    ae_frame _frame_block;
    ae_int_t pass;
    ae_int_t passcount;
    ae_int_t n;
    ae_int_t i;
    ae_int_t i1;
    ae_int_t i2;
    ae_int_t j;
    ae_int_t j1;
    ae_int_t j2;
    ae_int_t l;
    ae_int_t k;
    ae_int_t r;
    ae_int_t i3;
    ae_int_t j3;
    ae_int_t col1;
    ae_int_t col2;
    ae_int_t row1;
    ae_int_t row2;
    ae_vector x1;
    ae_vector x2;
    ae_matrix a;
    ae_matrix b;
    ae_matrix c1;
    ae_matrix c2;
    double err;
    double e1;
    double e2;
    double e3;
    double v;
    double scl1;
    double scl2;
    double scl3;
    ae_bool was1;
    ae_bool was2;
    ae_bool trans1;
    ae_bool trans2;
    double threshold;
    ae_bool n2errors;
    ae_bool hsnerrors;
    ae_bool amaxerrors;
    ae_bool mverrors;
    ae_bool iterrors;
    ae_bool cterrors;
    ae_bool mmerrors;
    ae_bool waserrors;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    ae_vector_init(&x1, 0, DT_REAL, _state);
    ae_vector_init(&x2, 0, DT_REAL, _state);
    ae_matrix_init(&a, 0, 0, DT_REAL, _state);
    ae_matrix_init(&b, 0, 0, DT_REAL, _state);
    ae_matrix_init(&c1, 0, 0, DT_REAL, _state);
    ae_matrix_init(&c2, 0, 0, DT_REAL, _state);

    n2errors = ae_false;
    amaxerrors = ae_false;
    hsnerrors = ae_false;
    mverrors = ae_false;
    iterrors = ae_false;
    cterrors = ae_false;
    mmerrors = ae_false;
    waserrors = ae_false;
    threshold = 10000*ae_machineepsilon;
    
    /*
     * Test Norm2
     */
    passcount = 1000;
    e1 = (double)(0);
    e2 = (double)(0);
    e3 = (double)(0);
    scl2 = 0.5*ae_maxrealnumber;
    scl3 = 2*ae_minrealnumber;
    for(pass=1; pass<=passcount; pass++)
    {
        n = 1+ae_randominteger(1000, _state);
        i1 = ae_randominteger(10, _state);
        i2 = n+i1-1;
        ae_vector_set_length(&x1, i2+1, _state);
        ae_vector_set_length(&x2, i2+1, _state);
        for(i=i1; i<=i2; i++)
        {
            x1.ptr.p_double[i] = 2*ae_randomreal(_state)-1;
        }
        v = (double)(0);
        for(i=i1; i<=i2; i++)
        {
            v = v+ae_sqr(x1.ptr.p_double[i], _state);
        }
        v = ae_sqrt(v, _state);
        e1 = ae_maxreal(e1, ae_fabs(v-vectornorm2(&x1, i1, i2, _state), _state), _state);
        for(i=i1; i<=i2; i++)
        {
            x2.ptr.p_double[i] = scl2*x1.ptr.p_double[i];
        }
        e2 = ae_maxreal(e2, ae_fabs(v*scl2-vectornorm2(&x2, i1, i2, _state), _state), _state);
        for(i=i1; i<=i2; i++)
        {
            x2.ptr.p_double[i] = scl3*x1.ptr.p_double[i];
        }
        e3 = ae_maxreal(e3, ae_fabs(v*scl3-vectornorm2(&x2, i1, i2, _state), _state), _state);
    }
    e2 = e2/scl2;
    e3 = e3/scl3;
    n2errors = (ae_fp_greater_eq(e1,threshold)||ae_fp_greater_eq(e2,threshold))||ae_fp_greater_eq(e3,threshold);
    
    /*
     * Testing VectorAbsMax, Column/Row AbsMax
     */
    ae_vector_set_length(&x1, 5+1, _state);
    x1.ptr.p_double[1] = 2.0;
    x1.ptr.p_double[2] = 0.2;
    x1.ptr.p_double[3] = -1.3;
    x1.ptr.p_double[4] = 0.7;
    x1.ptr.p_double[5] = -3.0;
    amaxerrors = (vectoridxabsmax(&x1, 1, 5, _state)!=5||vectoridxabsmax(&x1, 1, 4, _state)!=1)||vectoridxabsmax(&x1, 2, 4, _state)!=3;
    n = 30;
    ae_vector_set_length(&x1, n+1, _state);
    ae_matrix_set_length(&a, n+1, n+1, _state);
    for(i=1; i<=n; i++)
    {
        for(j=1; j<=n; j++)
        {
            a.ptr.pp_double[i][j] = 2*ae_randomreal(_state)-1;
        }
    }
    was1 = ae_false;
    was2 = ae_false;
    for(pass=1; pass<=1000; pass++)
    {
        j = 1+ae_randominteger(n, _state);
        i1 = 1+ae_randominteger(n, _state);
        i2 = i1+ae_randominteger(n+1-i1, _state);
        ae_v_move(&x1.ptr.p_double[i1], 1, &a.ptr.pp_double[i1][j], a.stride, ae_v_len(i1,i2));
        if( vectoridxabsmax(&x1, i1, i2, _state)!=columnidxabsmax(&a, i1, i2, j, _state) )
        {
            was1 = ae_true;
        }
        i = 1+ae_randominteger(n, _state);
        j1 = 1+ae_randominteger(n, _state);
        j2 = j1+ae_randominteger(n+1-j1, _state);
        ae_v_move(&x1.ptr.p_double[j1], 1, &a.ptr.pp_double[i][j1], 1, ae_v_len(j1,j2));
        if( vectoridxabsmax(&x1, j1, j2, _state)!=rowidxabsmax(&a, j1, j2, i, _state) )
        {
            was2 = ae_true;
        }
    }
    amaxerrors = (amaxerrors||was1)||was2;
    
    /*
     * Testing upper Hessenberg 1-norm
     */
    ae_matrix_set_length(&a, 3+1, 3+1, _state);
    ae_vector_set_length(&x1, 3+1, _state);
    a.ptr.pp_double[1][1] = (double)(2);
    a.ptr.pp_double[1][2] = (double)(3);
    a.ptr.pp_double[1][3] = (double)(1);
    a.ptr.pp_double[2][1] = (double)(4);
    a.ptr.pp_double[2][2] = (double)(-5);
    a.ptr.pp_double[2][3] = (double)(8);
    a.ptr.pp_double[3][1] = (double)(99);
    a.ptr.pp_double[3][2] = (double)(3);
    a.ptr.pp_double[3][3] = (double)(1);
    hsnerrors = ae_fp_greater(ae_fabs(upperhessenberg1norm(&a, 1, 3, 1, 3, &x1, _state)-11, _state),threshold);
    
    /*
     * Testing MatrixVectorMultiply
     */
    ae_matrix_set_length(&a, 3+1, 5+1, _state);
    ae_vector_set_length(&x1, 3+1, _state);
    ae_vector_set_length(&x2, 2+1, _state);
    a.ptr.pp_double[2][3] = (double)(2);
    a.ptr.pp_double[2][4] = (double)(-1);
    a.ptr.pp_double[2][5] = (double)(-1);
    a.ptr.pp_double[3][3] = (double)(1);
    a.ptr.pp_double[3][4] = (double)(-2);
    a.ptr.pp_double[3][5] = (double)(2);
    x1.ptr.p_double[1] = (double)(1);
    x1.ptr.p_double[2] = (double)(2);
    x1.ptr.p_double[3] = (double)(1);
    x2.ptr.p_double[1] = (double)(-1);
    x2.ptr.p_double[2] = (double)(-1);
    matrixvectormultiply(&a, 2, 3, 3, 5, ae_false, &x1, 1, 3, 1.0, &x2, 1, 2, 1.0, _state);
    matrixvectormultiply(&a, 2, 3, 3, 5, ae_true, &x2, 1, 2, 1.0, &x1, 1, 3, 1.0, _state);
    e1 = ae_fabs(x1.ptr.p_double[1]+5, _state)+ae_fabs(x1.ptr.p_double[2]-8, _state)+ae_fabs(x1.ptr.p_double[3]+1, _state)+ae_fabs(x2.ptr.p_double[1]+2, _state)+ae_fabs(x2.ptr.p_double[2]+2, _state);
    x1.ptr.p_double[1] = (double)(1);
    x1.ptr.p_double[2] = (double)(2);
    x1.ptr.p_double[3] = (double)(1);
    x2.ptr.p_double[1] = (double)(-1);
    x2.ptr.p_double[2] = (double)(-1);
    matrixvectormultiply(&a, 2, 3, 3, 5, ae_false, &x1, 1, 3, 1.0, &x2, 1, 2, 0.0, _state);
    matrixvectormultiply(&a, 2, 3, 3, 5, ae_true, &x2, 1, 2, 1.0, &x1, 1, 3, 0.0, _state);
    e2 = ae_fabs(x1.ptr.p_double[1]+3, _state)+ae_fabs(x1.ptr.p_double[2]-3, _state)+ae_fabs(x1.ptr.p_double[3]+1, _state)+ae_fabs(x2.ptr.p_double[1]+1, _state)+ae_fabs(x2.ptr.p_double[2]+1, _state);
    mverrors = ae_fp_greater_eq(e1+e2,threshold);
    
    /*
     * testing inplace transpose
     */
    n = 10;
    ae_matrix_set_length(&a, n+1, n+1, _state);
    ae_matrix_set_length(&b, n+1, n+1, _state);
    ae_vector_set_length(&x1, n-1+1, _state);
    for(i=1; i<=n; i++)
    {
        for(j=1; j<=n; j++)
        {
            a.ptr.pp_double[i][j] = ae_randomreal(_state);
        }
    }
    passcount = 10000;
    was1 = ae_false;
    for(pass=1; pass<=passcount; pass++)
    {
        i1 = 1+ae_randominteger(n, _state);
        i2 = i1+ae_randominteger(n-i1+1, _state);
        j1 = 1+ae_randominteger(n-(i2-i1), _state);
        j2 = j1+(i2-i1);
        copymatrix(&a, i1, i2, j1, j2, &b, i1, i2, j1, j2, _state);
        inplacetranspose(&b, i1, i2, j1, j2, &x1, _state);
        for(i=i1; i<=i2; i++)
        {
            for(j=j1; j<=j2; j++)
            {
                if( ae_fp_neq(a.ptr.pp_double[i][j],b.ptr.pp_double[i1+(j-j1)][j1+(i-i1)]) )
                {
                    was1 = ae_true;
                }
            }
        }
    }
    iterrors = was1;
    
    /*
     * testing copy and transpose
     */
    n = 10;
    ae_matrix_set_length(&a, n+1, n+1, _state);
    ae_matrix_set_length(&b, n+1, n+1, _state);
    for(i=1; i<=n; i++)
    {
        for(j=1; j<=n; j++)
        {
            a.ptr.pp_double[i][j] = ae_randomreal(_state);
        }
    }
    passcount = 10000;
    was1 = ae_false;
    for(pass=1; pass<=passcount; pass++)
    {
        i1 = 1+ae_randominteger(n, _state);
        i2 = i1+ae_randominteger(n-i1+1, _state);
        j1 = 1+ae_randominteger(n, _state);
        j2 = j1+ae_randominteger(n-j1+1, _state);
        copyandtranspose(&a, i1, i2, j1, j2, &b, j1, j2, i1, i2, _state);
        for(i=i1; i<=i2; i++)
        {
            for(j=j1; j<=j2; j++)
            {
                if( ae_fp_neq(a.ptr.pp_double[i][j],b.ptr.pp_double[j][i]) )
                {
                    was1 = ae_true;
                }
            }
        }
    }
    cterrors = was1;
    
    /*
     * Testing MatrixMatrixMultiply
     */
    n = 10;
    ae_matrix_set_length(&a, 2*n+1, 2*n+1, _state);
    ae_matrix_set_length(&b, 2*n+1, 2*n+1, _state);
    ae_matrix_set_length(&c1, 2*n+1, 2*n+1, _state);
    ae_matrix_set_length(&c2, 2*n+1, 2*n+1, _state);
    ae_vector_set_length(&x1, n+1, _state);
    ae_vector_set_length(&x2, n+1, _state);
    for(i=1; i<=2*n; i++)
    {
        for(j=1; j<=2*n; j++)
        {
            a.ptr.pp_double[i][j] = ae_randomreal(_state);
            b.ptr.pp_double[i][j] = ae_randomreal(_state);
        }
    }
    passcount = 1000;
    was1 = ae_false;
    for(pass=1; pass<=passcount; pass++)
    {
        for(i=1; i<=2*n; i++)
        {
            for(j=1; j<=2*n; j++)
            {
                c1.ptr.pp_double[i][j] = 2.1*i+3.1*j;
                c2.ptr.pp_double[i][j] = c1.ptr.pp_double[i][j];
            }
        }
        l = 1+ae_randominteger(n, _state);
        k = 1+ae_randominteger(n, _state);
        r = 1+ae_randominteger(n, _state);
        i1 = 1+ae_randominteger(n, _state);
        j1 = 1+ae_randominteger(n, _state);
        i2 = 1+ae_randominteger(n, _state);
        j2 = 1+ae_randominteger(n, _state);
        i3 = 1+ae_randominteger(n, _state);
        j3 = 1+ae_randominteger(n, _state);
        trans1 = ae_fp_greater(ae_randomreal(_state),0.5);
        trans2 = ae_fp_greater(ae_randomreal(_state),0.5);
        if( trans1 )
        {
            col1 = l;
            row1 = k;
        }
        else
        {
            col1 = k;
            row1 = l;
        }
        if( trans2 )
        {
            col2 = k;
            row2 = r;
        }
        else
        {
            col2 = r;
            row2 = k;
        }
        scl1 = ae_randomreal(_state);
        scl2 = ae_randomreal(_state);
        matrixmatrixmultiply(&a, i1, i1+row1-1, j1, j1+col1-1, trans1, &b, i2, i2+row2-1, j2, j2+col2-1, trans2, scl1, &c1, i3, i3+l-1, j3, j3+r-1, scl2, &x1, _state);
        testblasunit_naivematrixmatrixmultiply(&a, i1, i1+row1-1, j1, j1+col1-1, trans1, &b, i2, i2+row2-1, j2, j2+col2-1, trans2, scl1, &c2, i3, i3+l-1, j3, j3+r-1, scl2, _state);
        err = (double)(0);
        for(i=1; i<=l; i++)
        {
            for(j=1; j<=r; j++)
            {
                err = ae_maxreal(err, ae_fabs(c1.ptr.pp_double[i3+i-1][j3+j-1]-c2.ptr.pp_double[i3+i-1][j3+j-1], _state), _state);
            }
        }
        if( ae_fp_greater(err,threshold) )
        {
            was1 = ae_true;
            break;
        }
    }
    mmerrors = was1;
    
    /*
     * report
     */
    waserrors = (((((n2errors||amaxerrors)||hsnerrors)||mverrors)||iterrors)||cterrors)||mmerrors;
    if( !silent )
    {
        printf("TESTING BLAS\n");
        printf("VectorNorm2:                             ");
        if( n2errors )
        {
            printf("FAILED\n");
        }
        else
        {
            printf("OK\n");
        }
        printf("AbsMax (vector/row/column):              ");
        if( amaxerrors )
        {
            printf("FAILED\n");
        }
        else
        {
            printf("OK\n");
        }
        printf("UpperHessenberg1Norm:                    ");
        if( hsnerrors )
        {
            printf("FAILED\n");
        }
        else
        {
            printf("OK\n");
        }
        printf("MatrixVectorMultiply:                    ");
        if( mverrors )
        {
            printf("FAILED\n");
        }
        else
        {
            printf("OK\n");
        }
        printf("InplaceTranspose:                        ");
        if( iterrors )
        {
            printf("FAILED\n");
        }
        else
        {
            printf("OK\n");
        }
        printf("CopyAndTranspose:                        ");
        if( cterrors )
        {
            printf("FAILED\n");
        }
        else
        {
            printf("OK\n");
        }
        printf("MatrixMatrixMultiply:                    ");
        if( mmerrors )
        {
            printf("FAILED\n");
        }
        else
        {
            printf("OK\n");
        }
        if( waserrors )
        {
            printf("TEST FAILED\n");
        }
        else
        {
            printf("TEST PASSED\n");
        }
        printf("\n\n");
    }
    result = !waserrors;
    ae_frame_leave(_state);
    return result;
}


/*************************************************************************
Single-threaded stub. HPC ALGLIB replaces it by multithreaded code.
*************************************************************************/
ae_bool _pexec_testblas(ae_bool silent, ae_state *_state)
{
    return testblas(silent, _state);
}


static void testblasunit_naivematrixmatrixmultiply(/* Real    */ ae_matrix* a,
     ae_int_t ai1,
     ae_int_t ai2,
     ae_int_t aj1,
     ae_int_t aj2,
     ae_bool transa,
     /* Real    */ ae_matrix* b,
     ae_int_t bi1,
     ae_int_t bi2,
     ae_int_t bj1,
     ae_int_t bj2,
     ae_bool transb,
     double alpha,
     /* Real    */ ae_matrix* c,
     ae_int_t ci1,
     ae_int_t ci2,
     ae_int_t cj1,
     ae_int_t cj2,
     double beta,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_int_t arows;
    ae_int_t acols;
    ae_int_t brows;
    ae_int_t bcols;
    ae_int_t i;
    ae_int_t j;
    ae_int_t k;
    ae_int_t l;
    ae_int_t r;
    double v;
    ae_vector x1;
    ae_vector x2;

    ae_frame_make(_state, &_frame_block);
    ae_vector_init(&x1, 0, DT_REAL, _state);
    ae_vector_init(&x2, 0, DT_REAL, _state);

    
    /*
     * Setup
     */
    if( !transa )
    {
        arows = ai2-ai1+1;
        acols = aj2-aj1+1;
    }
    else
    {
        arows = aj2-aj1+1;
        acols = ai2-ai1+1;
    }
    if( !transb )
    {
        brows = bi2-bi1+1;
        bcols = bj2-bj1+1;
    }
    else
    {
        brows = bj2-bj1+1;
        bcols = bi2-bi1+1;
    }
    ae_assert(acols==brows, "NaiveMatrixMatrixMultiply: incorrect matrix sizes!", _state);
    if( ((arows<=0||acols<=0)||brows<=0)||bcols<=0 )
    {
        ae_frame_leave(_state);
        return;
    }
    l = arows;
    r = bcols;
    k = acols;
    ae_vector_set_length(&x1, k+1, _state);
    ae_vector_set_length(&x2, k+1, _state);
    for(i=1; i<=l; i++)
    {
        for(j=1; j<=r; j++)
        {
            if( !transa )
            {
                if( !transb )
                {
                    v = ae_v_dotproduct(&b->ptr.pp_double[bi1][bj1+j-1], b->stride, &a->ptr.pp_double[ai1+i-1][aj1], 1, ae_v_len(bi1,bi2));
                }
                else
                {
                    v = ae_v_dotproduct(&b->ptr.pp_double[bi1+j-1][bj1], 1, &a->ptr.pp_double[ai1+i-1][aj1], 1, ae_v_len(bj1,bj2));
                }
            }
            else
            {
                if( !transb )
                {
                    v = ae_v_dotproduct(&b->ptr.pp_double[bi1][bj1+j-1], b->stride, &a->ptr.pp_double[ai1][aj1+i-1], a->stride, ae_v_len(bi1,bi2));
                }
                else
                {
                    v = ae_v_dotproduct(&b->ptr.pp_double[bi1+j-1][bj1], 1, &a->ptr.pp_double[ai1][aj1+i-1], a->stride, ae_v_len(bj1,bj2));
                }
            }
            if( ae_fp_eq(beta,(double)(0)) )
            {
                c->ptr.pp_double[ci1+i-1][cj1+j-1] = alpha*v;
            }
            else
            {
                c->ptr.pp_double[ci1+i-1][cj1+j-1] = beta*c->ptr.pp_double[ci1+i-1][cj1+j-1]+alpha*v;
            }
        }
    }
    ae_frame_leave(_state);
}



static ae_bool testclusteringunit_basicahctests(ae_state *_state);
static ae_bool testclusteringunit_advancedahctests(ae_state *_state);
static void testclusteringunit_kmeanssimpletest1(ae_int_t nvars,
     ae_int_t nc,
     ae_int_t passcount,
     ae_bool* converrors,
     ae_bool* othererrors,
     ae_bool* simpleerrors,
     ae_state *_state);
static void testclusteringunit_kmeansinfinitelooptest(ae_bool* othererrors,
     ae_state *_state);
static void testclusteringunit_kmeansrestartstest(ae_bool* converrors,
     ae_bool* restartserrors,
     ae_state *_state);
static double testclusteringunit_rnormal(ae_state *_state);
static void testclusteringunit_rsphere(/* Real    */ ae_matrix* xy,
     ae_int_t n,
     ae_int_t i,
     ae_state *_state);
static double testclusteringunit_distfunc(/* Real    */ ae_vector* x0,
     /* Real    */ ae_vector* x1,
     ae_int_t d,
     ae_int_t disttype,
     ae_state *_state);
static ae_bool testclusteringunit_errorsinmerges(/* Real    */ ae_matrix* d,
     ae_int_t npoints,
     ahcreport* rep,
     ae_int_t ahcalgo,
     ae_state *_state);





/*************************************************************************
Testing clustering
*************************************************************************/
ae_bool testclustering(ae_bool silent, ae_state *_state)
{
    ae_bool waserrors;
    ae_bool basicahcerrors;
    ae_bool ahcerrors;
    ae_bool kmeansconverrors;
    ae_bool kmeanssimpleerrors;
    ae_bool kmeansothererrors;
    ae_bool kmeansrestartserrors;
    ae_int_t passcount;
    ae_int_t nf;
    ae_int_t nc;
    ae_bool result;


    
    /*
     * AHC tests
     */
    basicahcerrors = testclusteringunit_basicahctests(_state);
    ahcerrors = testclusteringunit_advancedahctests(_state);
    
    /*
     * k-means tests
     */
    passcount = 10;
    kmeansconverrors = ae_false;
    kmeansothererrors = ae_false;
    kmeanssimpleerrors = ae_false;
    kmeansrestartserrors = ae_false;
    testclusteringunit_kmeansinfinitelooptest(&kmeansothererrors, _state);
    testclusteringunit_kmeansrestartstest(&kmeansconverrors, &kmeansrestartserrors, _state);
    for(nf=1; nf<=5; nf++)
    {
        for(nc=1; nc<=5; nc++)
        {
            testclusteringunit_kmeanssimpletest1(nf, nc, passcount, &kmeansconverrors, &kmeansothererrors, &kmeanssimpleerrors, _state);
        }
    }
    
    /*
     * Results
     */
    waserrors = ae_false;
    waserrors = waserrors||(basicahcerrors||ahcerrors);
    waserrors = waserrors||(((kmeansconverrors||kmeansothererrors)||kmeanssimpleerrors)||kmeansrestartserrors);
    if( !silent )
    {
        printf("TESTING CLUSTERING\n");
        printf("BASIC AHC TESTS:                    ");
        if( !basicahcerrors )
        {
            printf("OK\n");
        }
        else
        {
            printf("FAILED\n");
        }
        printf("GENERAL AHC TESTS:                  ");
        if( !ahcerrors )
        {
            printf("OK\n");
        }
        else
        {
            printf("FAILED\n");
        }
        printf("K-MEANS CONVERGENCE:                ");
        if( !kmeansconverrors )
        {
            printf("OK\n");
        }
        else
        {
            printf("FAILED\n");
        }
        printf("K-MEANS SIMPLE TASKS:               ");
        if( !kmeanssimpleerrors )
        {
            printf("OK\n");
        }
        else
        {
            printf("FAILED\n");
        }
        printf("K-MEANS OTHER PROPERTIES:           ");
        if( !kmeansothererrors )
        {
            printf("OK\n");
        }
        else
        {
            printf("FAILED\n");
        }
        printf("K-MEANS RESTARTS PROPERTIES:        ");
        if( !kmeansrestartserrors )
        {
            printf("OK\n");
        }
        else
        {
            printf("FAILED\n");
        }
        if( waserrors )
        {
            printf("TEST FAILED\n");
        }
        else
        {
            printf("TEST PASSED\n");
        }
        printf("\n\n");
    }
    result = !waserrors;
    return result;
}


/*************************************************************************
Single-threaded stub. HPC ALGLIB replaces it by multithreaded code.
*************************************************************************/
ae_bool _pexec_testclustering(ae_bool silent, ae_state *_state)
{
    return testclustering(silent, _state);
}


/*************************************************************************
Basic agglomerative hierarchical clustering tests:
returns True on failure, False on success.

Basic tests study algorithm behavior on simple,  hand-made  datasets  with
small number of points (1..10).
*************************************************************************/
static ae_bool testclusteringunit_basicahctests(ae_state *_state)
{
    ae_frame _frame_block;
    clusterizerstate s;
    ahcreport rep;
    ae_matrix xy;
    ae_matrix d;
    ae_matrix c;
    ae_bool berr;
    ae_int_t ahcalgo;
    ae_int_t i;
    ae_int_t j;
    ae_int_t npoints;
    ae_int_t k;
    ae_vector cidx;
    ae_vector cz;
    ae_vector cidx2;
    ae_vector cz2;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    _clusterizerstate_init(&s, _state);
    _ahcreport_init(&rep, _state);
    ae_matrix_init(&xy, 0, 0, DT_REAL, _state);
    ae_matrix_init(&d, 0, 0, DT_REAL, _state);
    ae_matrix_init(&c, 0, 0, DT_REAL, _state);
    ae_vector_init(&cidx, 0, DT_INT, _state);
    ae_vector_init(&cz, 0, DT_INT, _state);
    ae_vector_init(&cidx2, 0, DT_INT, _state);
    ae_vector_init(&cz2, 0, DT_INT, _state);

    result = ae_true;
    
    /*
     * Test on empty problem
     */
    clusterizercreate(&s, _state);
    clusterizerrunahc(&s, &rep, _state);
    if( rep.npoints!=0 )
    {
        ae_frame_leave(_state);
        return result;
    }
    
    /*
     * Test on problem with one point
     */
    ae_matrix_set_length(&xy, 1, 2, _state);
    xy.ptr.pp_double[0][0] = ae_randomreal(_state);
    xy.ptr.pp_double[0][1] = ae_randomreal(_state);
    clusterizercreate(&s, _state);
    clusterizersetpoints(&s, &xy, 1, 2, 0, _state);
    clusterizerrunahc(&s, &rep, _state);
    if( rep.npoints!=1 )
    {
        ae_frame_leave(_state);
        return result;
    }
    
    /*
     * Test on problem with two points
     */
    ae_matrix_set_length(&xy, 2, 2, _state);
    xy.ptr.pp_double[0][0] = ae_randomreal(_state);
    xy.ptr.pp_double[0][1] = ae_randomreal(_state);
    xy.ptr.pp_double[1][0] = ae_randomreal(_state);
    xy.ptr.pp_double[1][1] = ae_randomreal(_state);
    clusterizercreate(&s, _state);
    clusterizersetpoints(&s, &xy, 2, 2, 0, _state);
    clusterizerrunahc(&s, &rep, _state);
    if( (rep.npoints!=2||rep.z.rows!=1)||rep.z.cols!=2 )
    {
        ae_frame_leave(_state);
        return result;
    }
    if( rep.z.ptr.pp_int[0][0]!=0||rep.z.ptr.pp_int[0][1]!=1 )
    {
        ae_frame_leave(_state);
        return result;
    }
    
    /*
     * Test on specially designed problem which should have
     * following dendrogram:
     *
     *   ------
     *   |    |
     * ----  ----
     * |  |  |  |
     * 0  1  2  3
     *
     * ...with first merge performed on 0 and 1, second merge
     * performed on 2 and 3. Complete linkage is used.
     *
     * Additionally we test ClusterizerSeparatedByDist() on this
     * problem for different distances. Test is performed by
     * comparing function result with ClusterizerGetKClusters()
     * for known K.
     */
    ae_matrix_set_length(&xy, 4, 1, _state);
    xy.ptr.pp_double[0][0] = 0.0;
    xy.ptr.pp_double[1][0] = 1.0;
    xy.ptr.pp_double[2][0] = 3.0;
    xy.ptr.pp_double[3][0] = 4.1;
    clusterizercreate(&s, _state);
    clusterizersetpoints(&s, &xy, 4, 1, 0, _state);
    clusterizersetahcalgo(&s, 0, _state);
    clusterizerrunahc(&s, &rep, _state);
    if( (((rep.npoints!=4||rep.z.rows!=3)||rep.z.cols!=2)||rep.pz.rows!=3)||rep.pz.cols!=2 )
    {
        ae_frame_leave(_state);
        return result;
    }
    berr = ae_false;
    berr = (berr||rep.z.ptr.pp_int[0][0]!=0)||rep.z.ptr.pp_int[0][1]!=1;
    berr = (berr||rep.z.ptr.pp_int[1][0]!=2)||rep.z.ptr.pp_int[1][1]!=3;
    berr = (berr||rep.z.ptr.pp_int[2][0]!=4)||rep.z.ptr.pp_int[2][1]!=5;
    berr = (((berr||rep.p.ptr.p_int[0]!=0)||rep.p.ptr.p_int[1]!=1)||rep.p.ptr.p_int[2]!=2)||rep.p.ptr.p_int[3]!=3;
    berr = (berr||rep.pz.ptr.pp_int[0][0]!=0)||rep.pz.ptr.pp_int[0][1]!=1;
    berr = (berr||rep.pz.ptr.pp_int[1][0]!=2)||rep.pz.ptr.pp_int[1][1]!=3;
    berr = (berr||rep.pz.ptr.pp_int[2][0]!=4)||rep.pz.ptr.pp_int[2][1]!=5;
    berr = (((berr||rep.pm.ptr.pp_int[0][0]!=0)||rep.pm.ptr.pp_int[0][1]!=0)||rep.pm.ptr.pp_int[0][2]!=1)||rep.pm.ptr.pp_int[0][3]!=1;
    berr = (((berr||rep.pm.ptr.pp_int[1][0]!=2)||rep.pm.ptr.pp_int[1][1]!=2)||rep.pm.ptr.pp_int[1][2]!=3)||rep.pm.ptr.pp_int[1][3]!=3;
    berr = (((berr||rep.pm.ptr.pp_int[2][0]!=0)||rep.pm.ptr.pp_int[2][1]!=1)||rep.pm.ptr.pp_int[2][2]!=2)||rep.pm.ptr.pp_int[2][3]!=3;
    if( berr )
    {
        ae_frame_leave(_state);
        return result;
    }
    clusterizerseparatedbydist(&rep, 0.5, &k, &cidx, &cz, _state);
    clusterizergetkclusters(&rep, 4, &cidx2, &cz2, _state);
    if( k!=4 )
    {
        ae_frame_leave(_state);
        return result;
    }
    if( ((cidx.ptr.p_int[0]!=cidx2.ptr.p_int[0]||cidx.ptr.p_int[1]!=cidx2.ptr.p_int[1])||cidx.ptr.p_int[2]!=cidx2.ptr.p_int[2])||cidx.ptr.p_int[3]!=cidx2.ptr.p_int[3] )
    {
        ae_frame_leave(_state);
        return result;
    }
    if( ((cz.ptr.p_int[0]!=cz2.ptr.p_int[0]||cz.ptr.p_int[1]!=cz2.ptr.p_int[1])||cz.ptr.p_int[2]!=cz2.ptr.p_int[2])||cz.ptr.p_int[3]!=cz2.ptr.p_int[3] )
    {
        ae_frame_leave(_state);
        return result;
    }
    clusterizerseparatedbydist(&rep, 1.05, &k, &cidx, &cz, _state);
    clusterizergetkclusters(&rep, 3, &cidx2, &cz2, _state);
    if( k!=3 )
    {
        ae_frame_leave(_state);
        return result;
    }
    if( ((cidx.ptr.p_int[0]!=cidx2.ptr.p_int[0]||cidx.ptr.p_int[1]!=cidx2.ptr.p_int[1])||cidx.ptr.p_int[2]!=cidx2.ptr.p_int[2])||cidx.ptr.p_int[3]!=cidx2.ptr.p_int[3] )
    {
        ae_frame_leave(_state);
        return result;
    }
    if( (cz.ptr.p_int[0]!=cz2.ptr.p_int[0]||cz.ptr.p_int[1]!=cz2.ptr.p_int[1])||cz.ptr.p_int[2]!=cz2.ptr.p_int[2] )
    {
        ae_frame_leave(_state);
        return result;
    }
    clusterizerseparatedbydist(&rep, 1.15, &k, &cidx, &cz, _state);
    clusterizergetkclusters(&rep, 2, &cidx2, &cz2, _state);
    if( k!=2 )
    {
        ae_frame_leave(_state);
        return result;
    }
    if( ((cidx.ptr.p_int[0]!=cidx2.ptr.p_int[0]||cidx.ptr.p_int[1]!=cidx2.ptr.p_int[1])||cidx.ptr.p_int[2]!=cidx2.ptr.p_int[2])||cidx.ptr.p_int[3]!=cidx2.ptr.p_int[3] )
    {
        ae_frame_leave(_state);
        return result;
    }
    if( cz.ptr.p_int[0]!=cz2.ptr.p_int[0]||cz.ptr.p_int[1]!=cz2.ptr.p_int[1] )
    {
        ae_frame_leave(_state);
        return result;
    }
    
    /*
     * Test on specially designed problem with Pearson distance
     * which should have following dendrogram:
     *
     *   ------
     *   |    |
     * ----  ----
     * |  |  |  |
     * 0  1  2  3
     *
     * This problem is used to test ClusterizerSeparatedByDist().
     * The test is performed by comparing function result with
     * ClusterizerGetKClusters() for known K.
     *
     * NOTE:
     * * corr(a0,a1) = 0.866
     * * corr(a2,a3) = 0.990
     * * corr(a0/a1, a2/a3)<=0.5
     */
    ae_matrix_set_length(&xy, 4, 3, _state);
    xy.ptr.pp_double[0][0] = 0.3;
    xy.ptr.pp_double[0][1] = 0.5;
    xy.ptr.pp_double[0][2] = 0.3;
    xy.ptr.pp_double[1][0] = 0.3;
    xy.ptr.pp_double[1][1] = 0.5;
    xy.ptr.pp_double[1][2] = 0.4;
    xy.ptr.pp_double[2][0] = 0.1;
    xy.ptr.pp_double[2][1] = 0.5;
    xy.ptr.pp_double[2][2] = 0.9;
    xy.ptr.pp_double[3][0] = 0.1;
    xy.ptr.pp_double[3][1] = 0.4;
    xy.ptr.pp_double[3][2] = 0.9;
    clusterizercreate(&s, _state);
    clusterizersetpoints(&s, &xy, 4, 3, 10, _state);
    clusterizersetahcalgo(&s, 1, _state);
    clusterizerrunahc(&s, &rep, _state);
    clusterizerseparatedbycorr(&rep, 0.999, &k, &cidx, &cz, _state);
    clusterizergetkclusters(&rep, 4, &cidx2, &cz2, _state);
    if( k!=4 )
    {
        ae_frame_leave(_state);
        return result;
    }
    if( ((cidx.ptr.p_int[0]!=cidx2.ptr.p_int[0]||cidx.ptr.p_int[1]!=cidx2.ptr.p_int[1])||cidx.ptr.p_int[2]!=cidx2.ptr.p_int[2])||cidx.ptr.p_int[3]!=cidx2.ptr.p_int[3] )
    {
        ae_frame_leave(_state);
        return result;
    }
    if( ((cz.ptr.p_int[0]!=cz2.ptr.p_int[0]||cz.ptr.p_int[1]!=cz2.ptr.p_int[1])||cz.ptr.p_int[2]!=cz2.ptr.p_int[2])||cz.ptr.p_int[3]!=cz2.ptr.p_int[3] )
    {
        ae_frame_leave(_state);
        return result;
    }
    clusterizerseparatedbycorr(&rep, 0.900, &k, &cidx, &cz, _state);
    clusterizergetkclusters(&rep, 3, &cidx2, &cz2, _state);
    if( k!=3 )
    {
        ae_frame_leave(_state);
        return result;
    }
    if( ((cidx.ptr.p_int[0]!=cidx2.ptr.p_int[0]||cidx.ptr.p_int[1]!=cidx2.ptr.p_int[1])||cidx.ptr.p_int[2]!=cidx2.ptr.p_int[2])||cidx.ptr.p_int[3]!=cidx2.ptr.p_int[3] )
    {
        ae_frame_leave(_state);
        return result;
    }
    if( (cz.ptr.p_int[0]!=cz2.ptr.p_int[0]||cz.ptr.p_int[1]!=cz2.ptr.p_int[1])||cz.ptr.p_int[2]!=cz2.ptr.p_int[2] )
    {
        ae_frame_leave(_state);
        return result;
    }
    clusterizerseparatedbycorr(&rep, 0.600, &k, &cidx, &cz, _state);
    clusterizergetkclusters(&rep, 2, &cidx2, &cz2, _state);
    if( k!=2 )
    {
        ae_frame_leave(_state);
        return result;
    }
    if( ((cidx.ptr.p_int[0]!=cidx2.ptr.p_int[0]||cidx.ptr.p_int[1]!=cidx2.ptr.p_int[1])||cidx.ptr.p_int[2]!=cidx2.ptr.p_int[2])||cidx.ptr.p_int[3]!=cidx2.ptr.p_int[3] )
    {
        ae_frame_leave(_state);
        return result;
    }
    if( cz.ptr.p_int[0]!=cz2.ptr.p_int[0]||cz.ptr.p_int[1]!=cz2.ptr.p_int[1] )
    {
        ae_frame_leave(_state);
        return result;
    }
    
    /*
     * Single linkage vs. complete linkage
     */
    ae_matrix_set_length(&xy, 6, 1, _state);
    xy.ptr.pp_double[0][0] = 0.0;
    xy.ptr.pp_double[1][0] = 1.0;
    xy.ptr.pp_double[2][0] = 2.1;
    xy.ptr.pp_double[3][0] = 3.3;
    xy.ptr.pp_double[4][0] = 6.0;
    xy.ptr.pp_double[5][0] = 4.6;
    clusterizercreate(&s, _state);
    clusterizersetpoints(&s, &xy, 6, 1, 0, _state);
    clusterizersetahcalgo(&s, 0, _state);
    clusterizerrunahc(&s, &rep, _state);
    if( rep.npoints!=6||rep.p.cnt!=6 )
    {
        ae_frame_leave(_state);
        return result;
    }
    if( ((rep.z.rows!=5||rep.z.cols!=2)||rep.pz.rows!=5)||rep.pz.cols!=2 )
    {
        ae_frame_leave(_state);
        return result;
    }
    berr = ae_false;
    berr = berr||rep.p.ptr.p_int[0]!=2;
    berr = berr||rep.p.ptr.p_int[1]!=3;
    berr = berr||rep.p.ptr.p_int[2]!=4;
    berr = berr||rep.p.ptr.p_int[3]!=5;
    berr = berr||rep.p.ptr.p_int[4]!=0;
    berr = berr||rep.p.ptr.p_int[5]!=1;
    berr = (berr||rep.z.ptr.pp_int[0][0]!=0)||rep.z.ptr.pp_int[0][1]!=1;
    berr = (berr||rep.z.ptr.pp_int[1][0]!=2)||rep.z.ptr.pp_int[1][1]!=3;
    berr = (berr||rep.z.ptr.pp_int[2][0]!=4)||rep.z.ptr.pp_int[2][1]!=5;
    berr = (berr||rep.z.ptr.pp_int[3][0]!=6)||rep.z.ptr.pp_int[3][1]!=7;
    berr = (berr||rep.z.ptr.pp_int[4][0]!=8)||rep.z.ptr.pp_int[4][1]!=9;
    berr = (berr||rep.pz.ptr.pp_int[0][0]!=2)||rep.pz.ptr.pp_int[0][1]!=3;
    berr = (berr||rep.pz.ptr.pp_int[1][0]!=4)||rep.pz.ptr.pp_int[1][1]!=5;
    berr = (berr||rep.pz.ptr.pp_int[2][0]!=0)||rep.pz.ptr.pp_int[2][1]!=1;
    berr = (berr||rep.pz.ptr.pp_int[3][0]!=6)||rep.pz.ptr.pp_int[3][1]!=7;
    berr = (berr||rep.pz.ptr.pp_int[4][0]!=8)||rep.pz.ptr.pp_int[4][1]!=9;
    if( berr )
    {
        ae_frame_leave(_state);
        return result;
    }
    clusterizersetahcalgo(&s, 1, _state);
    clusterizerrunahc(&s, &rep, _state);
    if( (rep.npoints!=6||rep.z.rows!=5)||rep.z.cols!=2 )
    {
        ae_frame_leave(_state);
        return result;
    }
    berr = ae_false;
    berr = (berr||rep.z.ptr.pp_int[0][0]!=0)||rep.z.ptr.pp_int[0][1]!=1;
    berr = (berr||rep.z.ptr.pp_int[1][0]!=2)||rep.z.ptr.pp_int[1][1]!=6;
    berr = (berr||rep.z.ptr.pp_int[2][0]!=3)||rep.z.ptr.pp_int[2][1]!=7;
    berr = (berr||rep.z.ptr.pp_int[3][0]!=5)||rep.z.ptr.pp_int[3][1]!=8;
    berr = (berr||rep.z.ptr.pp_int[4][0]!=4)||rep.z.ptr.pp_int[4][1]!=9;
    if( berr )
    {
        ae_frame_leave(_state);
        return result;
    }
    
    /*
     * Test which differentiates complete linkage and average linkage from
     * single linkage:
     * * we have cluster C0={(-0.5), (0)},
     *   cluster C1={(19.0), (20.0), (21.0), (22.0), (23.0)},
     *   and point P between them - (10.0)
     * * we try three different strategies - single linkage, complete
     *   linkage, average linkage.
     * * any strategy will merge C0 first, then merge points of C1,
     *   and then merge P with C0 or C1 (depending on linkage type)
     * * we test that:
     *   a) C0 is merged first
     *   b) after 5 merges (including merge of C0), P is merged with C0 or C1
     *   c) P is merged with C1 when we have single linkage, with C0 otherwise
     */
    ae_matrix_set_length(&xy, 8, 1, _state);
    xy.ptr.pp_double[0][0] = -0.5;
    xy.ptr.pp_double[1][0] = 0.0;
    xy.ptr.pp_double[2][0] = 10.0;
    xy.ptr.pp_double[3][0] = 19.0;
    xy.ptr.pp_double[4][0] = 20.0;
    xy.ptr.pp_double[5][0] = 21.0;
    xy.ptr.pp_double[6][0] = 22.0;
    xy.ptr.pp_double[7][0] = 23.0;
    clusterizercreate(&s, _state);
    clusterizersetpoints(&s, &xy, 8, 1, 0, _state);
    for(ahcalgo=0; ahcalgo<=2; ahcalgo++)
    {
        clusterizersetahcalgo(&s, ahcalgo, _state);
        clusterizerrunahc(&s, &rep, _state);
        if( (rep.npoints!=8||rep.z.rows!=7)||rep.z.cols!=2 )
        {
            ae_frame_leave(_state);
            return result;
        }
        if( rep.z.ptr.pp_int[0][0]!=0||rep.z.ptr.pp_int[0][1]!=1 )
        {
            ae_frame_leave(_state);
            return result;
        }
        if( rep.z.ptr.pp_int[5][0]!=2&&rep.z.ptr.pp_int[5][1]!=2 )
        {
            ae_frame_leave(_state);
            return result;
        }
        if( rep.z.ptr.pp_int[5][0]!=2&&rep.z.ptr.pp_int[5][1]!=2 )
        {
            ae_frame_leave(_state);
            return result;
        }
        if( (ahcalgo==0||ahcalgo==2)&&(rep.z.ptr.pp_int[5][0]!=8&&rep.z.ptr.pp_int[5][1]!=8) )
        {
            ae_frame_leave(_state);
            return result;
        }
        if( ahcalgo==1&&(rep.z.ptr.pp_int[5][0]==8||rep.z.ptr.pp_int[5][1]==8) )
        {
            ae_frame_leave(_state);
            return result;
        }
    }
    
    /*
     * Test which differentiates single linkage and average linkage from
     * complete linkage:
     * * we have cluster C0={(-2.5), (-2.0)},
     *   cluster C1={(19.0), (20.0), (21.0), (22.0), (23.0)},
     *   and point P between them - (10.0)
     * * we try three different strategies - single linkage, complete
     *   linkage, average linkage.
     * * any strategy will merge C0 first, then merge points of C1,
     *   and then merge P with C0 or C1 (depending on linkage type)
     * * we test that:
     *   a) C0 is merged first
     *   b) after 5 merges (including merge of C0), P is merged with C0 or C1
     *   c) P is merged with C0 when we have complete linkage, with C1 otherwise
     */
    ae_matrix_set_length(&xy, 8, 1, _state);
    xy.ptr.pp_double[0][0] = -2.5;
    xy.ptr.pp_double[1][0] = -2.0;
    xy.ptr.pp_double[2][0] = 10.0;
    xy.ptr.pp_double[3][0] = 19.0;
    xy.ptr.pp_double[4][0] = 20.0;
    xy.ptr.pp_double[5][0] = 21.0;
    xy.ptr.pp_double[6][0] = 22.0;
    xy.ptr.pp_double[7][0] = 23.0;
    clusterizercreate(&s, _state);
    clusterizersetpoints(&s, &xy, 8, 1, 0, _state);
    for(ahcalgo=0; ahcalgo<=2; ahcalgo++)
    {
        clusterizersetahcalgo(&s, ahcalgo, _state);
        clusterizerrunahc(&s, &rep, _state);
        if( (rep.npoints!=8||rep.z.rows!=7)||rep.z.cols!=2 )
        {
            ae_frame_leave(_state);
            return result;
        }
        if( rep.z.ptr.pp_int[0][0]!=0||rep.z.ptr.pp_int[0][1]!=1 )
        {
            ae_frame_leave(_state);
            return result;
        }
        if( rep.z.ptr.pp_int[5][0]!=2&&rep.z.ptr.pp_int[5][1]!=2 )
        {
            ae_frame_leave(_state);
            return result;
        }
        if( rep.z.ptr.pp_int[5][0]!=2&&rep.z.ptr.pp_int[5][1]!=2 )
        {
            ae_frame_leave(_state);
            return result;
        }
        if( ahcalgo==0&&(rep.z.ptr.pp_int[5][0]!=8&&rep.z.ptr.pp_int[5][1]!=8) )
        {
            ae_frame_leave(_state);
            return result;
        }
        if( (ahcalgo==1||ahcalgo==2)&&(rep.z.ptr.pp_int[5][0]==8||rep.z.ptr.pp_int[5][1]==8) )
        {
            ae_frame_leave(_state);
            return result;
        }
    }
    
    /*
     * Test which differentiates weighred average linkage from unweighted average linkage:
     * * we have cluster C0={(0.0), (1.5), (2.5)},
     *   cluster C1={(7.5), (7.99)},
     *   and point P between them - (4.5)
     * * we try two different strategies - weighted average linkage and unweighted average linkage
     * * any strategy will merge C1 first, then merge points of C0,
     *   and then merge P with C0 or C1 (depending on linkage type)
     * * we test that:
     *   a) C1 is merged first, C0 is merged after that
     *   b) after first 3 merges P is merged with C0 or C1
     *   c) P is merged with C1 when we have weighted average linkage, with C0 otherwise
     */
    ae_matrix_set_length(&xy, 6, 1, _state);
    xy.ptr.pp_double[0][0] = 0.0;
    xy.ptr.pp_double[1][0] = 1.5;
    xy.ptr.pp_double[2][0] = 2.5;
    xy.ptr.pp_double[3][0] = 4.5;
    xy.ptr.pp_double[4][0] = 7.5;
    xy.ptr.pp_double[5][0] = 7.99;
    clusterizercreate(&s, _state);
    clusterizersetpoints(&s, &xy, 6, 1, 0, _state);
    for(ahcalgo=2; ahcalgo<=3; ahcalgo++)
    {
        clusterizersetahcalgo(&s, ahcalgo, _state);
        clusterizerrunahc(&s, &rep, _state);
        if( (rep.npoints!=6||rep.z.rows!=5)||rep.z.cols!=2 )
        {
            ae_frame_leave(_state);
            return result;
        }
        if( rep.z.ptr.pp_int[0][0]!=4||rep.z.ptr.pp_int[0][1]!=5 )
        {
            ae_frame_leave(_state);
            return result;
        }
        if( rep.z.ptr.pp_int[1][0]!=1||rep.z.ptr.pp_int[1][1]!=2 )
        {
            ae_frame_leave(_state);
            return result;
        }
        if( rep.z.ptr.pp_int[2][0]!=0||rep.z.ptr.pp_int[2][1]!=7 )
        {
            ae_frame_leave(_state);
            return result;
        }
        if( rep.z.ptr.pp_int[3][0]!=3 )
        {
            ae_frame_leave(_state);
            return result;
        }
        if( ahcalgo==2&&rep.z.ptr.pp_int[3][1]!=8 )
        {
            ae_frame_leave(_state);
            return result;
        }
        if( ahcalgo==3&&rep.z.ptr.pp_int[3][1]!=6 )
        {
            ae_frame_leave(_state);
            return result;
        }
    }
    
    /*
     * Ability to solve problems with zero distance matrix
     */
    npoints = 20;
    ae_matrix_set_length(&d, npoints, npoints, _state);
    for(i=0; i<=npoints-1; i++)
    {
        for(j=0; j<=npoints-1; j++)
        {
            d.ptr.pp_double[i][j] = 0.0;
        }
    }
    for(ahcalgo=0; ahcalgo<=3; ahcalgo++)
    {
        clusterizercreate(&s, _state);
        clusterizersetdistances(&s, &d, npoints, ae_true, _state);
        clusterizersetahcalgo(&s, ahcalgo, _state);
        clusterizerrunahc(&s, &rep, _state);
        if( (rep.npoints!=npoints||rep.z.rows!=npoints-1)||rep.z.cols!=2 )
        {
            ae_frame_leave(_state);
            return result;
        }
    }
    
    /*
     * Test GetKClusters()
     */
    ae_matrix_set_length(&xy, 8, 1, _state);
    xy.ptr.pp_double[0][0] = -2.5;
    xy.ptr.pp_double[1][0] = -2.0;
    xy.ptr.pp_double[2][0] = 10.0;
    xy.ptr.pp_double[3][0] = 19.0;
    xy.ptr.pp_double[4][0] = 20.0;
    xy.ptr.pp_double[5][0] = 21.0;
    xy.ptr.pp_double[6][0] = 22.0;
    xy.ptr.pp_double[7][0] = 23.0;
    clusterizercreate(&s, _state);
    clusterizersetpoints(&s, &xy, 8, 1, 0, _state);
    clusterizersetahcalgo(&s, 0, _state);
    clusterizerrunahc(&s, &rep, _state);
    clusterizergetkclusters(&rep, 3, &cidx, &cz, _state);
    if( ((((((cidx.ptr.p_int[0]!=1||cidx.ptr.p_int[1]!=1)||cidx.ptr.p_int[2]!=0)||cidx.ptr.p_int[3]!=2)||cidx.ptr.p_int[4]!=2)||cidx.ptr.p_int[5]!=2)||cidx.ptr.p_int[6]!=2)||cidx.ptr.p_int[7]!=2 )
    {
        ae_frame_leave(_state);
        return result;
    }
    if( (cz.ptr.p_int[0]!=2||cz.ptr.p_int[1]!=8)||cz.ptr.p_int[2]!=12 )
    {
        ae_frame_leave(_state);
        return result;
    }
    
    /*
     * Test is done
     */
    result = ae_false;
    ae_frame_leave(_state);
    return result;
}


/*************************************************************************
Advanced  agglomerative  hierarchical  clustering  tests : returns True on
failure, False on success.

Advanced testing subroutine perform several automatically generated tests.
*************************************************************************/
static ae_bool testclusteringunit_advancedahctests(ae_state *_state)
{
    ae_frame _frame_block;
    clusterizerstate s;
    ahcreport rep;
    ae_matrix xy;
    ae_matrix dm;
    ae_matrix dm2;
    ae_vector idx;
    ae_vector disttypes;
    ae_vector x0;
    ae_vector x1;
    ae_int_t d;
    ae_int_t n;
    ae_int_t npoints;
    ae_int_t ahcalgo;
    ae_int_t disttype;
    ae_int_t i;
    ae_int_t j;
    ae_int_t k;
    double v;
    ae_int_t t;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    _clusterizerstate_init(&s, _state);
    _ahcreport_init(&rep, _state);
    ae_matrix_init(&xy, 0, 0, DT_REAL, _state);
    ae_matrix_init(&dm, 0, 0, DT_REAL, _state);
    ae_matrix_init(&dm2, 0, 0, DT_REAL, _state);
    ae_vector_init(&idx, 0, DT_INT, _state);
    ae_vector_init(&disttypes, 0, DT_INT, _state);
    ae_vector_init(&x0, 0, DT_REAL, _state);
    ae_vector_init(&x1, 0, DT_REAL, _state);

    result = ae_false;
    
    /*
     * Test on D-dimensional problem:
     * * D = 2...5
     * * D clusters, each has N points;
     *   centers are located at x=(0 ... 1 ... 0);
     *   cluster radii are approximately 0.1
     * * single/complete/unweighted_average/weighted_average linkage are tested
     * * Euclidean distance is used, either:
     *   a) one given by distance matrix (ClusterizerSetDistances)
     *   b) one calculated from dataset (ClusterizerSetPoints)
     * * we have N*D points, and N*D-1 merges in total
     * * points are randomly rearranged after generation
     *
     * For all kinds of linkage we perform following test:
     * * for each point we remember index of its cluster
     *   (one which is determined during dataset generation)
     * * we clusterize points with ALGLIB capabilities
     * * we scan Rep.Z and perform first D*(N-1) merges
     * * for each merge we check that it merges points
     *   from same cluster;
     *
     * Additonally, we call ErrorsInMerges(). See function comments 
     * for more information about specific tests performed. This function
     * allows us to check that clusters are built exactly as specified by
     * definition of the clustering algorithm.
     */
    for(d=2; d<=5; d++)
    {
        for(ahcalgo=0; ahcalgo<=3; ahcalgo++)
        {
            n = ae_round(ae_pow((double)(3), (double)(ae_randominteger(3, _state)), _state), _state);
            npoints = d*n;
            
            /*
             * 1. generate dataset.
             * 2. fill Idx (array of cluster indexes):
             *    * first N*D elements store cluster indexes
             *    * next D*(N-1) elements are filled during merges
             * 3. build distance matrix DM
             */
            ae_matrix_set_length(&xy, n*d, d, _state);
            ae_vector_set_length(&idx, n*d+d*(n-1), _state);
            for(i=0; i<=n*d-1; i++)
            {
                for(j=0; j<=d-1; j++)
                {
                    xy.ptr.pp_double[i][j] = 0.2*ae_randomreal(_state)-0.1;
                }
                xy.ptr.pp_double[i][i%d] = xy.ptr.pp_double[i][i%d]+1.0;
                idx.ptr.p_int[i] = i%d;
            }
            for(i=0; i<=n*d-1; i++)
            {
                k = ae_randominteger(n*d, _state);
                if( k!=i )
                {
                    for(j=0; j<=d-1; j++)
                    {
                        v = xy.ptr.pp_double[i][j];
                        xy.ptr.pp_double[i][j] = xy.ptr.pp_double[k][j];
                        xy.ptr.pp_double[k][j] = v;
                    }
                    t = idx.ptr.p_int[k];
                    idx.ptr.p_int[k] = idx.ptr.p_int[i];
                    idx.ptr.p_int[i] = t;
                }
            }
            ae_matrix_set_length(&dm, npoints, npoints, _state);
            ae_vector_set_length(&x0, d, _state);
            ae_vector_set_length(&x1, d, _state);
            for(i=0; i<=npoints-1; i++)
            {
                for(j=0; j<=npoints-1; j++)
                {
                    ae_v_move(&x0.ptr.p_double[0], 1, &xy.ptr.pp_double[i][0], 1, ae_v_len(0,d-1));
                    ae_v_move(&x1.ptr.p_double[0], 1, &xy.ptr.pp_double[j][0], 1, ae_v_len(0,d-1));
                    dm.ptr.pp_double[i][j] = testclusteringunit_distfunc(&x0, &x1, d, 0, _state);
                }
            }
            
            /*
             * Clusterize with SetPoints()
             */
            clusterizercreate(&s, _state);
            clusterizersetpoints(&s, &xy, n*d, d, 0, _state);
            clusterizersetahcalgo(&s, ahcalgo, _state);
            clusterizerrunahc(&s, &rep, _state);
            
            /*
             * Tests:
             * * replay first D*(N-1) merges; these merges should take place
             *   within clusters, intercluster merges will be performed at the
             *   last stages of the processing.
             * * test with ErrorsInMerges()
             */
            if( rep.npoints!=npoints )
            {
                result = ae_true;
                ae_frame_leave(_state);
                return result;
            }
            for(i=0; i<=d*(n-1)-1; i++)
            {
                
                /*
                 * Check correctness of I-th row of Z
                 */
                if( (rep.z.ptr.pp_int[i][0]<0||rep.z.ptr.pp_int[i][0]>=rep.z.ptr.pp_int[i][1])||rep.z.ptr.pp_int[i][1]>=d*n+i )
                {
                    result = ae_true;
                    ae_frame_leave(_state);
                    return result;
                }
                
                /*
                 * Check that merge is performed within cluster
                 */
                if( idx.ptr.p_int[rep.z.ptr.pp_int[i][0]]!=idx.ptr.p_int[rep.z.ptr.pp_int[i][1]] )
                {
                    result = ae_true;
                    ae_frame_leave(_state);
                    return result;
                }
                
                /*
                 * Write new entry of Idx.
                 * Both points from the same cluster, so result of the merge
                 * belongs to the same cluster
                 */
                idx.ptr.p_int[n*d+i] = idx.ptr.p_int[rep.z.ptr.pp_int[i][1]];
            }
            if( (ahcalgo==0||ahcalgo==1)||ahcalgo==2 )
            {
                if( testclusteringunit_errorsinmerges(&dm, d*n, &rep, ahcalgo, _state) )
                {
                    result = ae_true;
                    ae_frame_leave(_state);
                    return result;
                }
            }
            
            /*
             * Clusterize one more time, now with distance matrix
             */
            clusterizercreate(&s, _state);
            clusterizersetdistances(&s, &dm, n*d, ae_fp_greater(ae_randomreal(_state),0.5), _state);
            clusterizersetahcalgo(&s, ahcalgo, _state);
            clusterizerrunahc(&s, &rep, _state);
            
            /*
             * Tests:
             * * replay first D*(N-1) merges; these merges should take place
             *   within clusters, intercluster merges will be performed at the
             *   last stages of the processing.
             * * test with ErrorsInMerges()
             */
            if( rep.npoints!=npoints )
            {
                result = ae_true;
                ae_frame_leave(_state);
                return result;
            }
            for(i=0; i<=d*(n-1)-1; i++)
            {
                
                /*
                 * Check correctness of I-th row of Z
                 */
                if( (rep.z.ptr.pp_int[i][0]<0||rep.z.ptr.pp_int[i][0]>=rep.z.ptr.pp_int[i][1])||rep.z.ptr.pp_int[i][1]>=d*n+i )
                {
                    result = ae_true;
                    ae_frame_leave(_state);
                    return result;
                }
                
                /*
                 * Check that merge is performed within cluster
                 */
                if( idx.ptr.p_int[rep.z.ptr.pp_int[i][0]]!=idx.ptr.p_int[rep.z.ptr.pp_int[i][1]] )
                {
                    result = ae_true;
                    ae_frame_leave(_state);
                    return result;
                }
                
                /*
                 * Write new entry of Idx.
                 * Both points from the same cluster, so result of the merge
                 * belongs to the same cluster
                 */
                idx.ptr.p_int[n*d+i] = idx.ptr.p_int[rep.z.ptr.pp_int[i][1]];
            }
            if( (ahcalgo==0||ahcalgo==1)||ahcalgo==2 )
            {
                if( testclusteringunit_errorsinmerges(&dm, d*n, &rep, ahcalgo, _state) )
                {
                    result = ae_true;
                    ae_frame_leave(_state);
                    return result;
                }
            }
        }
    }
    
    /*
     * Test on random D-dimensional problem:
     * * D = 2...5
     * * N=1..16 random points from unit hypercube
     * * single/complete/unweighted_average linkage are tested
     * * different distance functions are tested
     * * we call ErrorsInMerges() and we check distance matrix
     *   calculated by unit test against one returned by GetDistances()
     */
    ae_vector_set_length(&disttypes, 9, _state);
    disttypes.ptr.p_int[0] = 0;
    disttypes.ptr.p_int[1] = 1;
    disttypes.ptr.p_int[2] = 2;
    disttypes.ptr.p_int[3] = 10;
    disttypes.ptr.p_int[4] = 11;
    disttypes.ptr.p_int[5] = 12;
    disttypes.ptr.p_int[6] = 13;
    disttypes.ptr.p_int[7] = 20;
    disttypes.ptr.p_int[8] = 21;
    for(disttype=0; disttype<=disttypes.cnt-1; disttype++)
    {
        for(ahcalgo=0; ahcalgo<=2; ahcalgo++)
        {
            npoints = ae_round(ae_pow((double)(2), (double)(ae_randominteger(5, _state)), _state), _state);
            d = 2+ae_randominteger(4, _state);
            
            /*
             * Generate dataset and distance matrix
             */
            ae_matrix_set_length(&xy, npoints, d, _state);
            for(i=0; i<=npoints-1; i++)
            {
                for(j=0; j<=d-1; j++)
                {
                    xy.ptr.pp_double[i][j] = ae_randomreal(_state);
                }
            }
            ae_matrix_set_length(&dm, npoints, npoints, _state);
            ae_vector_set_length(&x0, d, _state);
            ae_vector_set_length(&x1, d, _state);
            for(i=0; i<=npoints-1; i++)
            {
                for(j=0; j<=npoints-1; j++)
                {
                    ae_v_move(&x0.ptr.p_double[0], 1, &xy.ptr.pp_double[i][0], 1, ae_v_len(0,d-1));
                    ae_v_move(&x1.ptr.p_double[0], 1, &xy.ptr.pp_double[j][0], 1, ae_v_len(0,d-1));
                    dm.ptr.pp_double[i][j] = testclusteringunit_distfunc(&x0, &x1, d, disttypes.ptr.p_int[disttype], _state);
                }
            }
            
            /*
             * Clusterize
             */
            clusterizercreate(&s, _state);
            clusterizersetpoints(&s, &xy, npoints, d, disttypes.ptr.p_int[disttype], _state);
            clusterizersetahcalgo(&s, ahcalgo, _state);
            clusterizerrunahc(&s, &rep, _state);
            
            /*
             * Test with ErrorsInMerges()
             */
            if( testclusteringunit_errorsinmerges(&dm, npoints, &rep, ahcalgo, _state) )
            {
                result = ae_true;
                ae_frame_leave(_state);
                return result;
            }
            
            /*
             * Test distance matrix
             */
            clusterizergetdistances(&xy, npoints, d, disttypes.ptr.p_int[disttype], &dm2, _state);
            for(i=0; i<=npoints-1; i++)
            {
                for(j=0; j<=npoints-1; j++)
                {
                    if( !ae_isfinite(dm2.ptr.pp_double[i][j], _state)||ae_fp_greater(ae_fabs(dm.ptr.pp_double[i][j]-dm2.ptr.pp_double[i][j], _state),1.0E5*ae_machineepsilon) )
                    {
                        result = ae_true;
                        ae_frame_leave(_state);
                        return result;
                    }
                }
            }
        }
    }
    ae_frame_leave(_state);
    return result;
}


/*************************************************************************
Simple test 1: ellipsoid in NF-dimensional space.
compare k-means centers with random centers
*************************************************************************/
static void testclusteringunit_kmeanssimpletest1(ae_int_t nvars,
     ae_int_t nc,
     ae_int_t passcount,
     ae_bool* converrors,
     ae_bool* othererrors,
     ae_bool* simpleerrors,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_int_t npoints;
    ae_int_t majoraxis;
    ae_matrix xy;
    ae_vector tmp;
    double v;
    ae_int_t i;
    ae_int_t j;
    ae_int_t pass;
    ae_int_t restarts;
    double ekmeans;
    double erandom;
    double dclosest;
    ae_int_t cclosest;
    clusterizerstate s;
    kmeansreport rep;

    ae_frame_make(_state, &_frame_block);
    ae_matrix_init(&xy, 0, 0, DT_REAL, _state);
    ae_vector_init(&tmp, 0, DT_REAL, _state);
    _clusterizerstate_init(&s, _state);
    _kmeansreport_init(&rep, _state);

    npoints = nc*100;
    restarts = 5;
    passcount = 10;
    ae_vector_set_length(&tmp, nvars-1+1, _state);
    for(pass=1; pass<=passcount; pass++)
    {
        
        /*
         * Fill
         */
        ae_matrix_set_length(&xy, npoints-1+1, nvars-1+1, _state);
        majoraxis = ae_randominteger(nvars, _state);
        for(i=0; i<=npoints-1; i++)
        {
            testclusteringunit_rsphere(&xy, nvars, i, _state);
            xy.ptr.pp_double[i][majoraxis] = nc*xy.ptr.pp_double[i][majoraxis];
        }
        
        /*
         * Test
         */
        clusterizercreate(&s, _state);
        clusterizersetpoints(&s, &xy, npoints, nvars, 2, _state);
        clusterizersetkmeanslimits(&s, restarts, 0, _state);
        clusterizerrunkmeans(&s, nc, &rep, _state);
        if( rep.terminationtype<=0 )
        {
            *converrors = ae_true;
            ae_frame_leave(_state);
            return;
        }
        
        /*
         * Test that XYC is correct mapping to cluster centers
         */
        for(i=0; i<=npoints-1; i++)
        {
            cclosest = -1;
            dclosest = ae_maxrealnumber;
            for(j=0; j<=nc-1; j++)
            {
                ae_v_move(&tmp.ptr.p_double[0], 1, &xy.ptr.pp_double[i][0], 1, ae_v_len(0,nvars-1));
                ae_v_sub(&tmp.ptr.p_double[0], 1, &rep.c.ptr.pp_double[j][0], 1, ae_v_len(0,nvars-1));
                v = ae_v_dotproduct(&tmp.ptr.p_double[0], 1, &tmp.ptr.p_double[0], 1, ae_v_len(0,nvars-1));
                if( ae_fp_less(v,dclosest) )
                {
                    cclosest = j;
                    dclosest = v;
                }
            }
            if( cclosest!=rep.cidx.ptr.p_int[i] )
            {
                *othererrors = ae_true;
                ae_frame_leave(_state);
                return;
            }
        }
        
        /*
         * Use first NC rows of XY as random centers
         * (XY is totally random, so it is as good as any other choice).
         *
         * Compare potential functions.
         */
        ekmeans = (double)(0);
        for(i=0; i<=npoints-1; i++)
        {
            ae_v_move(&tmp.ptr.p_double[0], 1, &xy.ptr.pp_double[i][0], 1, ae_v_len(0,nvars-1));
            ae_v_sub(&tmp.ptr.p_double[0], 1, &rep.c.ptr.pp_double[rep.cidx.ptr.p_int[i]][0], 1, ae_v_len(0,nvars-1));
            v = ae_v_dotproduct(&tmp.ptr.p_double[0], 1, &tmp.ptr.p_double[0], 1, ae_v_len(0,nvars-1));
            ekmeans = ekmeans+v;
        }
        erandom = (double)(0);
        for(i=0; i<=npoints-1; i++)
        {
            dclosest = ae_maxrealnumber;
            v = (double)(0);
            for(j=0; j<=nc-1; j++)
            {
                ae_v_move(&tmp.ptr.p_double[0], 1, &xy.ptr.pp_double[i][0], 1, ae_v_len(0,nvars-1));
                ae_v_sub(&tmp.ptr.p_double[0], 1, &xy.ptr.pp_double[j][0], 1, ae_v_len(0,nvars-1));
                v = ae_v_dotproduct(&tmp.ptr.p_double[0], 1, &tmp.ptr.p_double[0], 1, ae_v_len(0,nvars-1));
                if( ae_fp_less(v,dclosest) )
                {
                    dclosest = v;
                }
            }
            erandom = erandom+v;
        }
        if( ae_fp_less(erandom,ekmeans) )
        {
            *simpleerrors = ae_true;
            ae_frame_leave(_state);
            return;
        }
    }
    ae_frame_leave(_state);
}


/*************************************************************************
This test checks algorithm ability to handle degenerate problems without
causing infinite loop.
*************************************************************************/
static void testclusteringunit_kmeansinfinitelooptest(ae_bool* othererrors,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_int_t npoints;
    ae_int_t nfeatures;
    ae_int_t nclusters;
    ae_int_t restarts;
    ae_matrix xy;
    ae_int_t i;
    ae_int_t j;
    clusterizerstate s;
    kmeansreport rep;

    ae_frame_make(_state, &_frame_block);
    ae_matrix_init(&xy, 0, 0, DT_REAL, _state);
    _clusterizerstate_init(&s, _state);
    _kmeansreport_init(&rep, _state);

    
    /*
     * Problem 1: all points are same.
     *
     * For NClusters=1 we must get correct solution, for NClusters>1 we must get failure.
     */
    npoints = 100;
    nfeatures = 1;
    restarts = 5;
    ae_matrix_set_length(&xy, npoints, nfeatures, _state);
    for(j=0; j<=nfeatures-1; j++)
    {
        xy.ptr.pp_double[0][j] = ae_randomreal(_state);
    }
    for(i=1; i<=npoints-1; i++)
    {
        for(j=0; j<=nfeatures-1; j++)
        {
            xy.ptr.pp_double[i][j] = xy.ptr.pp_double[0][j];
        }
    }
    nclusters = 1;
    clusterizercreate(&s, _state);
    clusterizersetpoints(&s, &xy, npoints, nfeatures, 2, _state);
    clusterizersetkmeanslimits(&s, restarts, 0, _state);
    clusterizerrunkmeans(&s, nclusters, &rep, _state);
    *othererrors = *othererrors||rep.terminationtype<=0;
    for(i=0; i<=nfeatures-1; i++)
    {
        *othererrors = *othererrors||ae_fp_greater(ae_fabs(rep.c.ptr.pp_double[0][i]-xy.ptr.pp_double[0][i], _state),1000*ae_machineepsilon);
    }
    for(i=0; i<=npoints-1; i++)
    {
        *othererrors = *othererrors||rep.cidx.ptr.p_int[i]!=0;
    }
    nclusters = 5;
    clusterizerrunkmeans(&s, nclusters, &rep, _state);
    *othererrors = *othererrors||rep.terminationtype>0;
    
    /*
     * Problem 2: degenerate dataset (report by Andreas).
     */
    npoints = 57;
    nfeatures = 1;
    restarts = 1;
    nclusters = 4;
    ae_matrix_set_length(&xy, npoints, nfeatures, _state);
    xy.ptr.pp_double[0][0] = 12.244689632138986;
    xy.ptr.pp_double[1][0] = 12.244689632138982;
    xy.ptr.pp_double[2][0] = 12.244689632138986;
    xy.ptr.pp_double[3][0] = 12.244689632138982;
    xy.ptr.pp_double[4][0] = 12.244689632138986;
    xy.ptr.pp_double[5][0] = 12.244689632138986;
    xy.ptr.pp_double[6][0] = 12.244689632138986;
    xy.ptr.pp_double[7][0] = 12.244689632138986;
    xy.ptr.pp_double[8][0] = 12.244689632138986;
    xy.ptr.pp_double[9][0] = 12.244689632138986;
    xy.ptr.pp_double[10][0] = 12.244689632138989;
    xy.ptr.pp_double[11][0] = 12.244689632138984;
    xy.ptr.pp_double[12][0] = 12.244689632138986;
    xy.ptr.pp_double[13][0] = 12.244689632138986;
    xy.ptr.pp_double[14][0] = 12.244689632138989;
    xy.ptr.pp_double[15][0] = 12.244689632138986;
    xy.ptr.pp_double[16][0] = 12.244689632138986;
    xy.ptr.pp_double[17][0] = 12.244689632138986;
    xy.ptr.pp_double[18][0] = 12.244689632138986;
    xy.ptr.pp_double[19][0] = 12.244689632138989;
    xy.ptr.pp_double[20][0] = 12.244689632138972;
    xy.ptr.pp_double[21][0] = 12.244689632138986;
    xy.ptr.pp_double[22][0] = 12.244689632138986;
    xy.ptr.pp_double[23][0] = 12.244689632138986;
    xy.ptr.pp_double[24][0] = 12.244689632138984;
    xy.ptr.pp_double[25][0] = 12.244689632138982;
    xy.ptr.pp_double[26][0] = 12.244689632138986;
    xy.ptr.pp_double[27][0] = 12.244689632138986;
    xy.ptr.pp_double[28][0] = 12.244689632138986;
    xy.ptr.pp_double[29][0] = 12.244689632138986;
    xy.ptr.pp_double[30][0] = 12.244689632138986;
    xy.ptr.pp_double[31][0] = 12.244689632138986;
    xy.ptr.pp_double[32][0] = 12.244689632138986;
    xy.ptr.pp_double[33][0] = 12.244689632138986;
    xy.ptr.pp_double[34][0] = 12.244689632138986;
    xy.ptr.pp_double[35][0] = 12.244689632138982;
    xy.ptr.pp_double[36][0] = 12.244689632138989;
    xy.ptr.pp_double[37][0] = 12.244689632138986;
    xy.ptr.pp_double[38][0] = 12.244689632138986;
    xy.ptr.pp_double[39][0] = 12.244689632138986;
    xy.ptr.pp_double[40][0] = 12.244689632138986;
    xy.ptr.pp_double[41][0] = 12.244689632138986;
    xy.ptr.pp_double[42][0] = 12.244689632138986;
    xy.ptr.pp_double[43][0] = 12.244689632138986;
    xy.ptr.pp_double[44][0] = 12.244689632138986;
    xy.ptr.pp_double[45][0] = 12.244689632138986;
    xy.ptr.pp_double[46][0] = 12.244689632138986;
    xy.ptr.pp_double[47][0] = 12.244689632138986;
    xy.ptr.pp_double[48][0] = 12.244689632138986;
    xy.ptr.pp_double[49][0] = 12.244689632138986;
    xy.ptr.pp_double[50][0] = 12.244689632138984;
    xy.ptr.pp_double[51][0] = 12.244689632138986;
    xy.ptr.pp_double[52][0] = 12.244689632138986;
    xy.ptr.pp_double[53][0] = 12.244689632138986;
    xy.ptr.pp_double[54][0] = 12.244689632138986;
    xy.ptr.pp_double[55][0] = 12.244689632138986;
    xy.ptr.pp_double[56][0] = 12.244689632138986;
    clusterizercreate(&s, _state);
    clusterizersetpoints(&s, &xy, npoints, nfeatures, 2, _state);
    clusterizersetkmeanslimits(&s, restarts, 0, _state);
    clusterizerrunkmeans(&s, nclusters, &rep, _state);
    *othererrors = *othererrors||rep.terminationtype<=0;
    ae_frame_leave(_state);
}


/*************************************************************************
This non-deterministic test checks that Restarts>1 significantly  improves
quality of results.

Subroutine generates random task 3 unit balls in 2D, each with 20  points,
separated by 5 units wide gaps, and solves it  with  Restarts=1  and  with
Restarts=5. Potential functions are compared,  outcome  of  the  trial  is
either 0 or 1 (depending on what is better).

Sequence of 1000 such tasks is  solved.  If  Restarts>1  actually  improve
quality of solution, sum of outcome will be non-binomial.  If  it  doesn't
matter, it will be binomially distributed.

P.S. This test was added after report from Gianluca  Borello  who  noticed
error in the handling of multiple restarts.
*************************************************************************/
static void testclusteringunit_kmeansrestartstest(ae_bool* converrors,
     ae_bool* restartserrors,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_int_t npoints;
    ae_int_t nvars;
    ae_int_t nclusters;
    ae_int_t clustersize;
    ae_int_t restarts;
    ae_int_t passcount;
    double sigmathreshold;
    double p;
    double s;
    ae_matrix xy;
    ae_vector tmp;
    ae_int_t i;
    ae_int_t j;
    ae_int_t pass;
    double ea;
    double eb;
    double v;
    clusterizerstate state;
    kmeansreport rep1;
    kmeansreport rep2;

    ae_frame_make(_state, &_frame_block);
    ae_matrix_init(&xy, 0, 0, DT_REAL, _state);
    ae_vector_init(&tmp, 0, DT_REAL, _state);
    _clusterizerstate_init(&state, _state);
    _kmeansreport_init(&rep1, _state);
    _kmeansreport_init(&rep2, _state);

    restarts = 5;
    passcount = 1000;
    clustersize = 20;
    nclusters = 3;
    nvars = 2;
    npoints = nclusters*clustersize;
    sigmathreshold = (double)(5);
    ae_matrix_set_length(&xy, npoints, nvars, _state);
    ae_vector_set_length(&tmp, nvars, _state);
    p = (double)(0);
    for(pass=1; pass<=passcount; pass++)
    {
        
        /*
         * Fill
         */
        for(i=0; i<=npoints-1; i++)
        {
            testclusteringunit_rsphere(&xy, nvars, i, _state);
            for(j=0; j<=nvars-1; j++)
            {
                xy.ptr.pp_double[i][j] = xy.ptr.pp_double[i][j]+(double)i/(double)clustersize*5;
            }
        }
        clusterizercreate(&state, _state);
        clusterizersetpoints(&state, &xy, npoints, nvars, 2, _state);
        
        /*
         * Test: Restarts=1
         */
        clusterizersetkmeanslimits(&state, 1, 0, _state);
        clusterizerrunkmeans(&state, nclusters, &rep1, _state);
        if( rep1.terminationtype<=0 )
        {
            *converrors = ae_true;
            ae_frame_leave(_state);
            return;
        }
        ea = (double)(0);
        for(i=0; i<=npoints-1; i++)
        {
            ae_v_move(&tmp.ptr.p_double[0], 1, &xy.ptr.pp_double[i][0], 1, ae_v_len(0,nvars-1));
            ae_v_sub(&tmp.ptr.p_double[0], 1, &rep1.c.ptr.pp_double[rep1.cidx.ptr.p_int[i]][0], 1, ae_v_len(0,nvars-1));
            v = ae_v_dotproduct(&tmp.ptr.p_double[0], 1, &tmp.ptr.p_double[0], 1, ae_v_len(0,nvars-1));
            ea = ea+v;
        }
        
        /*
         * Test: Restarts>1
         */
        clusterizersetkmeanslimits(&state, restarts, 0, _state);
        clusterizerrunkmeans(&state, nclusters, &rep2, _state);
        if( rep2.terminationtype<=0 )
        {
            *converrors = ae_true;
            ae_frame_leave(_state);
            return;
        }
        eb = (double)(0);
        for(i=0; i<=npoints-1; i++)
        {
            ae_v_move(&tmp.ptr.p_double[0], 1, &xy.ptr.pp_double[i][0], 1, ae_v_len(0,nvars-1));
            ae_v_sub(&tmp.ptr.p_double[0], 1, &rep2.c.ptr.pp_double[rep2.cidx.ptr.p_int[i]][0], 1, ae_v_len(0,nvars-1));
            v = ae_v_dotproduct(&tmp.ptr.p_double[0], 1, &tmp.ptr.p_double[0], 1, ae_v_len(0,nvars-1));
            eb = eb+v;
        }
        
        /*
         * Calculate statistic.
         */
        if( ae_fp_less(ea,eb) )
        {
            p = p+1;
        }
        if( ae_fp_eq(ea,eb) )
        {
            p = p+0.5;
        }
    }
    
    /*
     * If Restarts doesn't influence quality of centers found, P must be
     * binomially distributed random value with mean 0.5*PassCount and
     * standard deviation Sqrt(PassCount/4).
     *
     * If Restarts do influence quality of solution, P must be significantly
     * lower than 0.5*PassCount.
     */
    s = (p-0.5*passcount)/ae_sqrt((double)passcount/(double)4, _state);
    *restartserrors = *restartserrors||ae_fp_greater(s,-sigmathreshold);
    ae_frame_leave(_state);
}


/*************************************************************************
Random normal number
*************************************************************************/
static double testclusteringunit_rnormal(ae_state *_state)
{
    double u;
    double v;
    double s;
    double x1;
    double x2;
    double result;


    for(;;)
    {
        u = 2*ae_randomreal(_state)-1;
        v = 2*ae_randomreal(_state)-1;
        s = ae_sqr(u, _state)+ae_sqr(v, _state);
        if( ae_fp_greater(s,(double)(0))&&ae_fp_less(s,(double)(1)) )
        {
            s = ae_sqrt(-2*ae_log(s, _state)/s, _state);
            x1 = u*s;
            x2 = v*s;
            break;
        }
    }
    result = x1;
    return result;
}


/*************************************************************************
Random point from sphere
*************************************************************************/
static void testclusteringunit_rsphere(/* Real    */ ae_matrix* xy,
     ae_int_t n,
     ae_int_t i,
     ae_state *_state)
{
    ae_int_t j;
    double v;


    for(j=0; j<=n-1; j++)
    {
        xy->ptr.pp_double[i][j] = testclusteringunit_rnormal(_state);
    }
    v = ae_v_dotproduct(&xy->ptr.pp_double[i][0], 1, &xy->ptr.pp_double[i][0], 1, ae_v_len(0,n-1));
    v = ae_randomreal(_state)/ae_sqrt(v, _state);
    ae_v_muld(&xy->ptr.pp_double[i][0], 1, ae_v_len(0,n-1), v);
}


/*************************************************************************
Distance function: distance between X0 and X1

X0, X1 - array[D], points
DistType - distance type
*************************************************************************/
static double testclusteringunit_distfunc(/* Real    */ ae_vector* x0,
     /* Real    */ ae_vector* x1,
     ae_int_t d,
     ae_int_t disttype,
     ae_state *_state)
{
    ae_int_t i;
    double s0;
    double s1;
    double result;


    ae_assert((((((((disttype==0||disttype==1)||disttype==2)||disttype==10)||disttype==11)||disttype==12)||disttype==13)||disttype==20)||disttype==21, "Assertion failed", _state);
    if( disttype==0 )
    {
        result = 0.0;
        for(i=0; i<=d-1; i++)
        {
            result = ae_maxreal(result, ae_fabs(x0->ptr.p_double[i]-x1->ptr.p_double[i], _state), _state);
        }
        return result;
    }
    if( disttype==1 )
    {
        result = 0.0;
        for(i=0; i<=d-1; i++)
        {
            result = result+ae_fabs(x0->ptr.p_double[i]-x1->ptr.p_double[i], _state);
        }
        return result;
    }
    if( disttype==2 )
    {
        result = 0.0;
        for(i=0; i<=d-1; i++)
        {
            result = result+ae_sqr(x0->ptr.p_double[i]-x1->ptr.p_double[i], _state);
        }
        result = ae_sqrt(result, _state);
        return result;
    }
    if( disttype==10 )
    {
        result = ae_maxreal(1-pearsoncorr2(x0, x1, d, _state), 0.0, _state);
        return result;
    }
    if( disttype==11 )
    {
        result = ae_maxreal(1-ae_fabs(pearsoncorr2(x0, x1, d, _state), _state), 0.0, _state);
        return result;
    }
    if( disttype==12||disttype==13 )
    {
        s0 = 0.0;
        s1 = 0.0;
        for(i=0; i<=d-1; i++)
        {
            s0 = s0+ae_sqr(x0->ptr.p_double[i], _state)/d;
            s1 = s1+ae_sqr(x1->ptr.p_double[i], _state)/d;
        }
        s0 = ae_sqrt(s0, _state);
        s1 = ae_sqrt(s1, _state);
        result = (double)(0);
        for(i=0; i<=d-1; i++)
        {
            result = result+x0->ptr.p_double[i]/s0*(x1->ptr.p_double[i]/s1)/d;
        }
        if( disttype==12 )
        {
            result = ae_maxreal(1-result, 0.0, _state);
        }
        else
        {
            result = ae_maxreal(1-ae_fabs(result, _state), 0.0, _state);
        }
        return result;
    }
    if( disttype==20 )
    {
        result = ae_maxreal(1-spearmancorr2(x0, x1, d, _state), 0.0, _state);
        return result;
    }
    if( disttype==21 )
    {
        result = ae_maxreal(1-ae_fabs(spearmancorr2(x0, x1, d, _state), _state), 0.0, _state);
        return result;
    }
    result = (double)(0);
    return result;
}


/*************************************************************************
This function replays merges and checks that:
* Rep.NPoints, Rep.Z, Rep.PZ and Rep.PM are consistent and correct
* Rep.MergeDist is consistent with distance between clusters being merged
* clusters with minimal distance are merged at each step
* GetKClusters() correctly unpacks clusters for each K

NOTE: this algorithm correctly handle ties, i.e. situations where several
      pairs  of  clusters  have  same intercluster distance, and we can't
      unambiguously choose clusters to merge.

INPUT PARAMETERS
    D           -   distance matrix, array[NPoints,NPoints], full matrix
                    is given (including both triangles and zeros on the
                    main diagonal)
    NPoints     -   dataset size
    Rep         -   clusterizer report
    AHCAlgo     -   AHC algorithm:
                    * 0 - complete linkage
                    * 1 - single linkage
                    * 2 - unweighted average linkage

This function returns True on failure, False on success.
*************************************************************************/
static ae_bool testclusteringunit_errorsinmerges(/* Real    */ ae_matrix* d,
     ae_int_t npoints,
     ahcreport* rep,
     ae_int_t ahcalgo,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_matrix dm;
    ae_matrix cm;
    ae_vector clusterheights;
    ae_vector b;
    ae_bool bflag;
    ae_int_t i;
    ae_int_t j;
    ae_int_t k;
    ae_int_t i0;
    ae_int_t i1;
    ae_int_t c0;
    ae_int_t c1;
    ae_int_t s0;
    ae_int_t s1;
    double v;
    ae_int_t t;
    ae_int_t mergeidx;
    ae_vector kidx;
    ae_vector kidxz;
    ae_int_t currentelement;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    ae_matrix_init(&dm, 0, 0, DT_REAL, _state);
    ae_matrix_init(&cm, 0, 0, DT_INT, _state);
    ae_vector_init(&clusterheights, 0, DT_INT, _state);
    ae_vector_init(&b, 0, DT_BOOL, _state);
    ae_vector_init(&kidx, 0, DT_INT, _state);
    ae_vector_init(&kidxz, 0, DT_INT, _state);

    result = ae_false;
    
    /*
     * Basic checks:
     * * sizes of arrays
     * * Rep.P is correct permutation
     * * Rep.Z contains correct cluster indexes
     * * Rep.PZ is consistent with Rep.P/Rep.Z
     * * Rep.PM contains consistent indexes
     * * GetKClusters() for K=NPoints
     */
    bflag = ae_false;
    bflag = bflag||rep->npoints!=npoints;
    bflag = (bflag||rep->z.rows!=npoints-1)||(npoints>1&&rep->z.cols!=2);
    bflag = (bflag||rep->pz.rows!=npoints-1)||(npoints>1&&rep->pz.cols!=2);
    bflag = (bflag||rep->pm.rows!=npoints-1)||(npoints>1&&rep->pm.cols!=6);
    bflag = bflag||rep->mergedist.cnt!=npoints-1;
    bflag = bflag||rep->p.cnt!=npoints;
    if( bflag )
    {
        result = ae_true;
        ae_frame_leave(_state);
        return result;
    }
    ae_vector_set_length(&b, npoints, _state);
    for(i=0; i<=npoints-1; i++)
    {
        b.ptr.p_bool[i] = ae_false;
    }
    for(i=0; i<=npoints-1; i++)
    {
        if( (rep->p.ptr.p_int[i]<0||rep->p.ptr.p_int[i]>=npoints)||b.ptr.p_bool[rep->p.ptr.p_int[i]] )
        {
            result = ae_true;
            ae_frame_leave(_state);
            return result;
        }
        b.ptr.p_bool[rep->p.ptr.p_int[i]] = ae_true;
    }
    for(i=0; i<=npoints-2; i++)
    {
        if( (rep->z.ptr.pp_int[i][0]<0||rep->z.ptr.pp_int[i][0]>=rep->z.ptr.pp_int[i][1])||rep->z.ptr.pp_int[i][1]>=npoints+i )
        {
            result = ae_true;
            ae_frame_leave(_state);
            return result;
        }
        if( (rep->pz.ptr.pp_int[i][0]<0||rep->pz.ptr.pp_int[i][0]>=rep->pz.ptr.pp_int[i][1])||rep->pz.ptr.pp_int[i][1]>=npoints+i )
        {
            result = ae_true;
            ae_frame_leave(_state);
            return result;
        }
    }
    for(i=0; i<=npoints-2; i++)
    {
        c0 = rep->z.ptr.pp_int[i][0];
        c1 = rep->z.ptr.pp_int[i][1];
        s0 = rep->pz.ptr.pp_int[i][0];
        s1 = rep->pz.ptr.pp_int[i][1];
        if( c0<npoints )
        {
            c0 = rep->p.ptr.p_int[c0];
        }
        if( c1<npoints )
        {
            c1 = rep->p.ptr.p_int[c1];
        }
        if( c0!=s0||c1!=s1 )
        {
            result = ae_true;
            ae_frame_leave(_state);
            return result;
        }
    }
    clusterizergetkclusters(rep, npoints, &kidx, &kidxz, _state);
    if( kidx.cnt!=npoints||kidxz.cnt!=npoints )
    {
        result = ae_true;
        ae_frame_leave(_state);
        return result;
    }
    for(i=0; i<=npoints-1; i++)
    {
        if( kidxz.ptr.p_int[i]!=i||kidx.ptr.p_int[i]!=i )
        {
            result = ae_true;
            ae_frame_leave(_state);
            return result;
        }
    }
    
    /*
     * Test description:
     * * we generate (2*NPoints-1)x(2*NPoints-1) matrix of distances DM and
     *   (2*NPoints-1)xNPoints matrix of clusters CM (I-th row contains indexes
     *   of elements which belong to I-th cluster, negative indexes denote
     *   empty cells). Leading N*N square of DM is just a distance matrix,
     *   other elements are filled by some large number M (used to mark empty
     *   elements).
     * * we replay all merges
     * * every time we merge clusters I and J into K, we:
     *   * check that distance between I and J is equal to the smallest
     *     element of DM (note: we account for rounding errors when we
     *     decide on that)
     *   * check that distance is consistent with Rep.MergeDist
     *   * then, we enumerate all elements in clusters being merged,
     *     and check that after permutation their indexes fall into range
     *     prescribed by Rep.PM
     *   * fill K-th column/row of D by distances to cluster K
     *   * merge I-th and J-th rows of CM and store result into K-th row
     *   * clear DM and CM: fill I-th and J-th column/row of DM by large
     *     number M, fill I-th and J-th row of CM by -1.
     */
    ae_matrix_set_length(&dm, 2*npoints-1, 2*npoints-1, _state);
    ae_matrix_set_length(&cm, 2*npoints-1, npoints, _state);
    for(i=0; i<=2*npoints-2; i++)
    {
        for(j=0; j<=2*npoints-2; j++)
        {
            if( i<npoints&&j<npoints )
            {
                dm.ptr.pp_double[i][j] = d->ptr.pp_double[i][j];
            }
            else
            {
                dm.ptr.pp_double[i][j] = ae_maxrealnumber;
            }
        }
    }
    for(i=0; i<=2*npoints-2; i++)
    {
        for(j=0; j<=npoints-1; j++)
        {
            cm.ptr.pp_int[i][j] = -1;
        }
    }
    for(i=0; i<=npoints-1; i++)
    {
        cm.ptr.pp_int[i][0] = i;
    }
    ae_vector_set_length(&clusterheights, 2*npoints-1, _state);
    for(i=0; i<=npoints-1; i++)
    {
        clusterheights.ptr.p_int[i] = 0;
    }
    for(mergeidx=0; mergeidx<=npoints-2; mergeidx++)
    {
        
        /*
         * Check that clusters with minimum distance are merged,
         * and that MergeDist is consistent with results.
         *
         * NOTE: we do not check for specific cluster indexes,
         *       because it is possible to have a tie. We just
         *       check that distance between clusters is a true
         *       minimum over all possible clusters.
         */
        v = ae_maxrealnumber;
        for(i=0; i<=2*npoints-2; i++)
        {
            for(j=0; j<=2*npoints-2; j++)
            {
                if( i!=j )
                {
                    v = ae_minreal(v, dm.ptr.pp_double[i][j], _state);
                }
            }
        }
        c0 = rep->z.ptr.pp_int[mergeidx][0];
        c1 = rep->z.ptr.pp_int[mergeidx][1];
        if( ae_fp_greater(dm.ptr.pp_double[c0][c1],v+10000*ae_machineepsilon) )
        {
            result = ae_true;
            ae_frame_leave(_state);
            return result;
        }
        if( ae_fp_greater(rep->mergedist.ptr.p_double[mergeidx],v+10000*ae_machineepsilon) )
        {
            result = ae_true;
            ae_frame_leave(_state);
            return result;
        }
        
        /*
         * Check that indexes of elements fall into range prescribed by Rep.PM,
         * and Rep.PM correctly described merge operation
         */
        s0 = 0;
        s1 = 0;
        for(j=0; j<=npoints-1; j++)
        {
            if( cm.ptr.pp_int[c0][j]>=0 )
            {
                if( rep->p.ptr.p_int[cm.ptr.pp_int[c0][j]]<rep->pm.ptr.pp_int[mergeidx][0]||rep->p.ptr.p_int[cm.ptr.pp_int[c0][j]]>rep->pm.ptr.pp_int[mergeidx][1] )
                {
                    
                    /*
                     * Element falls outside of range described by PM
                     */
                    result = ae_true;
                    ae_frame_leave(_state);
                    return result;
                }
                s0 = s0+1;
            }
            if( cm.ptr.pp_int[c1][j]>=0 )
            {
                s1 = s1+1;
                if( rep->p.ptr.p_int[cm.ptr.pp_int[c1][j]]<rep->pm.ptr.pp_int[mergeidx][2]||rep->p.ptr.p_int[cm.ptr.pp_int[c1][j]]>rep->pm.ptr.pp_int[mergeidx][3] )
                {
                    
                    /*
                     * Element falls outside of range described by PM
                     */
                    result = ae_true;
                    ae_frame_leave(_state);
                    return result;
                }
            }
        }
        if( (rep->pm.ptr.pp_int[mergeidx][1]-rep->pm.ptr.pp_int[mergeidx][0]!=s0-1||rep->pm.ptr.pp_int[mergeidx][3]-rep->pm.ptr.pp_int[mergeidx][2]!=s1-1)||rep->pm.ptr.pp_int[mergeidx][2]!=rep->pm.ptr.pp_int[mergeidx][1]+1 )
        {
            
            /*
             * Cluster size (as given by PM) is inconsistent with its actual size.
             */
            result = ae_true;
            ae_frame_leave(_state);
            return result;
        }
        if( rep->pm.ptr.pp_int[mergeidx][4]!=clusterheights.ptr.p_int[rep->z.ptr.pp_int[mergeidx][0]]||rep->pm.ptr.pp_int[mergeidx][5]!=clusterheights.ptr.p_int[rep->z.ptr.pp_int[mergeidx][1]] )
        {
            
            /*
             * Heights of subdendrograms as returned by PM are inconsistent with heights
             * calculated by us.
             */
            result = ae_true;
            ae_frame_leave(_state);
            return result;
        }
        
        /*
         * Update cluster heights
         */
        clusterheights.ptr.p_int[mergeidx+npoints] = ae_maxint(clusterheights.ptr.p_int[rep->z.ptr.pp_int[mergeidx][0]], clusterheights.ptr.p_int[rep->z.ptr.pp_int[mergeidx][1]], _state)+1;
        
        /*
         * Update CM
         */
        t = 0;
        for(j=0; j<=npoints-1; j++)
        {
            if( cm.ptr.pp_int[rep->z.ptr.pp_int[mergeidx][0]][j]>=0 )
            {
                cm.ptr.pp_int[npoints+mergeidx][t] = cm.ptr.pp_int[rep->z.ptr.pp_int[mergeidx][0]][j];
                cm.ptr.pp_int[rep->z.ptr.pp_int[mergeidx][0]][j] = -1;
                t = t+1;
            }
            if( cm.ptr.pp_int[rep->z.ptr.pp_int[mergeidx][1]][j]>=0 )
            {
                cm.ptr.pp_int[npoints+mergeidx][t] = cm.ptr.pp_int[rep->z.ptr.pp_int[mergeidx][1]][j];
                cm.ptr.pp_int[rep->z.ptr.pp_int[mergeidx][1]][j] = -1;
                t = t+1;
            }
        }
        
        /*
         * Update distance matrix D
         */
        for(i=0; i<=2*npoints-2; i++)
        {
            
            /*
             * "Remove" columns/rows corresponding to clusters being merged
             */
            dm.ptr.pp_double[i][rep->z.ptr.pp_int[mergeidx][0]] = ae_maxrealnumber;
            dm.ptr.pp_double[i][rep->z.ptr.pp_int[mergeidx][1]] = ae_maxrealnumber;
            dm.ptr.pp_double[rep->z.ptr.pp_int[mergeidx][0]][i] = ae_maxrealnumber;
            dm.ptr.pp_double[rep->z.ptr.pp_int[mergeidx][1]][i] = ae_maxrealnumber;
            
            /*
             * Calculate column/row corresponding to new cluster
             */
            if( i<npoints+mergeidx&&cm.ptr.pp_int[i][0]>=0 )
            {
                if( ahcalgo==0 )
                {
                    v = 0.0;
                }
                if( ahcalgo==1 )
                {
                    v = ae_maxrealnumber;
                }
                if( ahcalgo==2 )
                {
                    v = 0.0;
                    t = 0;
                }
                for(i0=0; i0<=npoints-1; i0++)
                {
                    for(i1=0; i1<=npoints-1; i1++)
                    {
                        if( cm.ptr.pp_int[i][i0]>=0&&cm.ptr.pp_int[npoints+mergeidx][i1]>=0 )
                        {
                            if( ahcalgo==0 )
                            {
                                v = ae_maxreal(v, d->ptr.pp_double[cm.ptr.pp_int[i][i0]][cm.ptr.pp_int[npoints+mergeidx][i1]], _state);
                            }
                            if( ahcalgo==1 )
                            {
                                v = ae_minreal(v, d->ptr.pp_double[cm.ptr.pp_int[i][i0]][cm.ptr.pp_int[npoints+mergeidx][i1]], _state);
                            }
                            if( ahcalgo==2 )
                            {
                                v = v+d->ptr.pp_double[cm.ptr.pp_int[i][i0]][cm.ptr.pp_int[npoints+mergeidx][i1]];
                                t = t+1;
                            }
                        }
                    }
                }
                if( ahcalgo==2 )
                {
                    v = v/t;
                }
                dm.ptr.pp_double[i][npoints+mergeidx] = v;
                dm.ptr.pp_double[npoints+mergeidx][i] = v;
            }
        }
        
        /*
         * Check that GetKClusters() correctly unpacks clusters for K=NPoints-(MergeIdx+1):
         * * check lengths of arays
         * * check consistency of CIdx/CZ parameters
         * * scan clusters (CZ parameter), for each cluster scan CM matrix which stores
         *   cluster elements (according to our replay of merges), for each element of
         *   the current cluster check that CIdx array correctly reflects its status.
         */
        k = npoints-(mergeidx+1);
        clusterizergetkclusters(rep, k, &kidx, &kidxz, _state);
        if( kidx.cnt!=npoints||kidxz.cnt!=k )
        {
            result = ae_true;
            ae_frame_leave(_state);
            return result;
        }
        for(i=0; i<=k-2; i++)
        {
            if( (kidxz.ptr.p_int[i]<0||kidxz.ptr.p_int[i]>=kidxz.ptr.p_int[i+1])||kidxz.ptr.p_int[i+1]>2*npoints-2 )
            {
                
                /*
                 * CZ is inconsistent
                 */
                result = ae_true;
                ae_frame_leave(_state);
                return result;
            }
        }
        for(i=0; i<=npoints-1; i++)
        {
            if( kidx.ptr.p_int[i]<0||kidx.ptr.p_int[i]>=k )
            {
                
                /*
                 * CIdx is inconsistent
                 */
                result = ae_true;
                ae_frame_leave(_state);
                return result;
            }
        }
        for(i=0; i<=k-1; i++)
        {
            for(j=0; j<=npoints-1; j++)
            {
                currentelement = cm.ptr.pp_int[kidxz.ptr.p_int[i]][j];
                if( currentelement>=0&&kidx.ptr.p_int[currentelement]!=i )
                {
                    
                    /*
                     * We've found element which belongs to I-th cluster (according to CM
                     * matrix, which reflects current status of agglomerative clustering),
                     * but this element does not belongs to I-th cluster according to
                     * results of ClusterizerGetKClusters()
                     */
                    result = ae_true;
                    ae_frame_leave(_state);
                    return result;
                }
            }
        }
    }
    ae_frame_leave(_state);
    return result;
}



static void testdforestunit_testprocessing(ae_bool* err, ae_state *_state);
static void testdforestunit_basictest1(ae_int_t nvars,
     ae_int_t nclasses,
     ae_int_t passcount,
     ae_bool* err,
     ae_state *_state);
static void testdforestunit_basictest2(ae_bool* err, ae_state *_state);
static void testdforestunit_basictest3(ae_bool* err, ae_state *_state);
static void testdforestunit_basictest4(ae_bool* err, ae_state *_state);
static void testdforestunit_basictest5(ae_bool* err, ae_state *_state);
static double testdforestunit_rnormal(ae_state *_state);
static void testdforestunit_rsphere(/* Real    */ ae_matrix* xy,
     ae_int_t n,
     ae_int_t i,
     ae_state *_state);
static void testdforestunit_unsetdf(decisionforest* df, ae_state *_state);





ae_bool testdforest(ae_bool silent, ae_state *_state)
{
    ae_int_t ncmax;
    ae_int_t nvmax;
    ae_int_t passcount;
    ae_int_t nvars;
    ae_int_t nclasses;
    ae_bool waserrors;
    ae_bool basicerrors;
    ae_bool procerrors;
    ae_bool result;


    
    /*
     * Primary settings
     */
    nvmax = 4;
    ncmax = 3;
    passcount = 10;
    basicerrors = ae_false;
    procerrors = ae_false;
    waserrors = ae_false;
    
    /*
     * Tests
     */
    testdforestunit_testprocessing(&procerrors, _state);
    for(nvars=1; nvars<=nvmax; nvars++)
    {
        for(nclasses=1; nclasses<=ncmax; nclasses++)
        {
            testdforestunit_basictest1(nvars, nclasses, passcount, &basicerrors, _state);
        }
    }
    testdforestunit_basictest2(&basicerrors, _state);
    testdforestunit_basictest3(&basicerrors, _state);
    testdforestunit_basictest4(&basicerrors, _state);
    testdforestunit_basictest5(&basicerrors, _state);
    
    /*
     * Final report
     */
    waserrors = basicerrors||procerrors;
    if( !silent )
    {
        printf("RANDOM FOREST TEST\n");
        printf("TOTAL RESULTS:                           ");
        if( !waserrors )
        {
            printf("OK\n");
        }
        else
        {
            printf("FAILED\n");
        }
        printf("* PROCESSING FUNCTIONS:                  ");
        if( !procerrors )
        {
            printf("OK\n");
        }
        else
        {
            printf("FAILED\n");
        }
        printf("* BASIC TESTS:                           ");
        if( !basicerrors )
        {
            printf("OK\n");
        }
        else
        {
            printf("FAILED\n");
        }
        if( waserrors )
        {
            printf("TEST SUMMARY: FAILED\n");
        }
        else
        {
            printf("TEST SUMMARY: PASSED\n");
        }
        printf("\n\n");
    }
    result = !waserrors;
    return result;
}


/*************************************************************************
Single-threaded stub. HPC ALGLIB replaces it by multithreaded code.
*************************************************************************/
ae_bool _pexec_testdforest(ae_bool silent, ae_state *_state)
{
    return testdforest(silent, _state);
}


/*************************************************************************
Processing functions test
*************************************************************************/
static void testdforestunit_testprocessing(ae_bool* err, ae_state *_state)
{
    ae_frame _frame_block;
    ae_int_t nvars;
    ae_int_t nclasses;
    ae_int_t nsample;
    ae_int_t ntrees;
    ae_int_t nfeatures;
    ae_int_t flags;
    decisionforest df1;
    decisionforest df2;
    ae_int_t npoints;
    ae_matrix xy;
    ae_int_t pass;
    ae_int_t passcount;
    ae_int_t i;
    ae_int_t j;
    ae_bool allsame;
    ae_int_t info;
    dfreport rep;
    ae_vector x1;
    ae_vector x2;
    ae_vector y1;
    ae_vector y2;
    double v;

    ae_frame_make(_state, &_frame_block);
    _decisionforest_init(&df1, _state);
    _decisionforest_init(&df2, _state);
    ae_matrix_init(&xy, 0, 0, DT_REAL, _state);
    _dfreport_init(&rep, _state);
    ae_vector_init(&x1, 0, DT_REAL, _state);
    ae_vector_init(&x2, 0, DT_REAL, _state);
    ae_vector_init(&y1, 0, DT_REAL, _state);
    ae_vector_init(&y2, 0, DT_REAL, _state);

    passcount = 100;
    
    /*
     * Main cycle
     */
    for(pass=1; pass<=passcount; pass++)
    {
        
        /*
         * initialize parameters
         */
        nvars = 1+ae_randominteger(5, _state);
        nclasses = 1+ae_randominteger(3, _state);
        ntrees = 1+ae_randominteger(4, _state);
        nfeatures = 1+ae_randominteger(nvars, _state);
        flags = 0;
        if( ae_fp_greater(ae_randomreal(_state),0.5) )
        {
            flags = flags+2;
        }
        
        /*
         * Initialize arrays and data
         */
        npoints = 10+ae_randominteger(50, _state);
        nsample = ae_maxint(10, ae_randominteger(npoints, _state), _state);
        ae_vector_set_length(&x1, nvars-1+1, _state);
        ae_vector_set_length(&x2, nvars-1+1, _state);
        ae_vector_set_length(&y1, nclasses-1+1, _state);
        ae_vector_set_length(&y2, nclasses-1+1, _state);
        ae_matrix_set_length(&xy, npoints-1+1, nvars+1, _state);
        for(i=0; i<=npoints-1; i++)
        {
            for(j=0; j<=nvars-1; j++)
            {
                if( j%2==0 )
                {
                    xy.ptr.pp_double[i][j] = 2*ae_randomreal(_state)-1;
                }
                else
                {
                    xy.ptr.pp_double[i][j] = (double)(ae_randominteger(2, _state));
                }
            }
            if( nclasses==1 )
            {
                xy.ptr.pp_double[i][nvars] = 2*ae_randomreal(_state)-1;
            }
            else
            {
                xy.ptr.pp_double[i][nvars] = (double)(ae_randominteger(nclasses, _state));
            }
        }
        
        /*
         * create forest
         */
        dfbuildinternal(&xy, npoints, nvars, nclasses, ntrees, nsample, nfeatures, flags, &info, &df1, &rep, _state);
        if( info<=0 )
        {
            *err = ae_true;
            ae_frame_leave(_state);
            return;
        }
        
        /*
         * Same inputs leads to same outputs
         */
        for(i=0; i<=nvars-1; i++)
        {
            x1.ptr.p_double[i] = 2*ae_randomreal(_state)-1;
            x2.ptr.p_double[i] = x1.ptr.p_double[i];
        }
        for(i=0; i<=nclasses-1; i++)
        {
            y1.ptr.p_double[i] = 2*ae_randomreal(_state)-1;
            y2.ptr.p_double[i] = 2*ae_randomreal(_state)-1;
        }
        dfprocess(&df1, &x1, &y1, _state);
        dfprocess(&df1, &x2, &y2, _state);
        allsame = ae_true;
        for(i=0; i<=nclasses-1; i++)
        {
            allsame = allsame&&ae_fp_eq(y1.ptr.p_double[i],y2.ptr.p_double[i]);
        }
        *err = *err||!allsame;
        
        /*
         * Same inputs on original forest leads to same outputs
         * on copy created using DFCopy
         */
        testdforestunit_unsetdf(&df2, _state);
        dfcopy(&df1, &df2, _state);
        for(i=0; i<=nvars-1; i++)
        {
            x1.ptr.p_double[i] = 2*ae_randomreal(_state)-1;
            x2.ptr.p_double[i] = x1.ptr.p_double[i];
        }
        for(i=0; i<=nclasses-1; i++)
        {
            y1.ptr.p_double[i] = 2*ae_randomreal(_state)-1;
            y2.ptr.p_double[i] = 2*ae_randomreal(_state)-1;
        }
        dfprocess(&df1, &x1, &y1, _state);
        dfprocess(&df2, &x2, &y2, _state);
        allsame = ae_true;
        for(i=0; i<=nclasses-1; i++)
        {
            allsame = allsame&&ae_fp_eq(y1.ptr.p_double[i],y2.ptr.p_double[i]);
        }
        *err = *err||!allsame;
        
        /*
         * Same inputs on original forest leads to same outputs
         * on copy created using DFSerialize
         */
        testdforestunit_unsetdf(&df2, _state);
        {
            /*
             * This code passes data structure through serializers
             * (serializes it to string and loads back)
             */
            ae_serializer _local_serializer;
            ae_int_t _local_ssize;
            ae_frame _local_frame_block;
            ae_dyn_block _local_dynamic_block;
            
            ae_frame_make(_state, &_local_frame_block);
            
            ae_serializer_init(&_local_serializer);
            ae_serializer_alloc_start(&_local_serializer);
            dfalloc(&_local_serializer, &df1, _state);
            _local_ssize = ae_serializer_get_alloc_size(&_local_serializer);
            ae_db_malloc(&_local_dynamic_block, _local_ssize+1, _state, ae_true);
            ae_serializer_sstart_str(&_local_serializer, (char*)_local_dynamic_block.ptr);
            dfserialize(&_local_serializer, &df1, _state);
            ae_serializer_stop(&_local_serializer);
            ae_serializer_clear(&_local_serializer);
            
            ae_serializer_init(&_local_serializer);
            ae_serializer_ustart_str(&_local_serializer, (char*)_local_dynamic_block.ptr);
            dfunserialize(&_local_serializer, &df2, _state);
            ae_serializer_stop(&_local_serializer);
            ae_serializer_clear(&_local_serializer);
            
            ae_frame_leave(_state);
        }
        for(i=0; i<=nvars-1; i++)
        {
            x1.ptr.p_double[i] = 2*ae_randomreal(_state)-1;
            x2.ptr.p_double[i] = x1.ptr.p_double[i];
        }
        for(i=0; i<=nclasses-1; i++)
        {
            y1.ptr.p_double[i] = 2*ae_randomreal(_state)-1;
            y2.ptr.p_double[i] = 2*ae_randomreal(_state)-1;
        }
        dfprocess(&df1, &x1, &y1, _state);
        dfprocess(&df2, &x2, &y2, _state);
        allsame = ae_true;
        for(i=0; i<=nclasses-1; i++)
        {
            allsame = allsame&&ae_fp_eq(y1.ptr.p_double[i],y2.ptr.p_double[i]);
        }
        *err = *err||!allsame;
        
        /*
         * Normalization properties
         */
        if( nclasses>1 )
        {
            for(i=0; i<=nvars-1; i++)
            {
                x1.ptr.p_double[i] = 2*ae_randomreal(_state)-1;
            }
            dfprocess(&df1, &x1, &y1, _state);
            v = (double)(0);
            for(i=0; i<=nclasses-1; i++)
            {
                v = v+y1.ptr.p_double[i];
                *err = *err||ae_fp_less(y1.ptr.p_double[i],(double)(0));
            }
            *err = *err||ae_fp_greater(ae_fabs(v-1, _state),1000*ae_machineepsilon);
        }
    }
    ae_frame_leave(_state);
}


/*************************************************************************
Basic test:  one-tree forest built using full sample must remember all the
training cases
*************************************************************************/
static void testdforestunit_basictest1(ae_int_t nvars,
     ae_int_t nclasses,
     ae_int_t passcount,
     ae_bool* err,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_int_t pass;
    ae_matrix xy;
    ae_int_t npoints;
    ae_int_t i;
    ae_int_t j;
    ae_int_t k;
    double s;
    ae_int_t info;
    decisionforest df;
    ae_vector x;
    ae_vector y;
    dfreport rep;
    ae_bool hassame;

    ae_frame_make(_state, &_frame_block);
    ae_matrix_init(&xy, 0, 0, DT_REAL, _state);
    _decisionforest_init(&df, _state);
    ae_vector_init(&x, 0, DT_REAL, _state);
    ae_vector_init(&y, 0, DT_REAL, _state);
    _dfreport_init(&rep, _state);

    if( nclasses==1 )
    {
        
        /*
         * only classification tasks
         */
        ae_frame_leave(_state);
        return;
    }
    for(pass=1; pass<=passcount; pass++)
    {
        
        /*
         * select number of points
         */
        if( pass<=3&&passcount>3 )
        {
            npoints = pass;
        }
        else
        {
            npoints = 100+ae_randominteger(100, _state);
        }
        
        /*
         * Prepare task
         */
        ae_matrix_set_length(&xy, npoints-1+1, nvars+1, _state);
        ae_vector_set_length(&x, nvars-1+1, _state);
        ae_vector_set_length(&y, nclasses-1+1, _state);
        for(i=0; i<=npoints-1; i++)
        {
            for(j=0; j<=nvars-1; j++)
            {
                xy.ptr.pp_double[i][j] = 2*ae_randomreal(_state)-1;
            }
            xy.ptr.pp_double[i][nvars] = (double)(ae_randominteger(nclasses, _state));
        }
        
        /*
         * Test
         */
        dfbuildinternal(&xy, npoints, nvars, nclasses, 1, npoints, 1, 1, &info, &df, &rep, _state);
        if( info<=0 )
        {
            *err = ae_true;
            ae_frame_leave(_state);
            return;
        }
        for(i=0; i<=npoints-1; i++)
        {
            ae_v_move(&x.ptr.p_double[0], 1, &xy.ptr.pp_double[i][0], 1, ae_v_len(0,nvars-1));
            dfprocess(&df, &x, &y, _state);
            s = (double)(0);
            for(j=0; j<=nclasses-1; j++)
            {
                if( ae_fp_less(y.ptr.p_double[j],(double)(0)) )
                {
                    *err = ae_true;
                    ae_frame_leave(_state);
                    return;
                }
                s = s+y.ptr.p_double[j];
            }
            if( ae_fp_greater(ae_fabs(s-1, _state),1000*ae_machineepsilon) )
            {
                *err = ae_true;
                ae_frame_leave(_state);
                return;
            }
            if( ae_fp_greater(ae_fabs(y.ptr.p_double[ae_round(xy.ptr.pp_double[i][nvars], _state)]-1, _state),1000*ae_machineepsilon) )
            {
                
                /*
                 * not an error if there exists such K,J that XY[K,J]=XY[I,J]
                 * (may be we just can't distinguish two tied values).
                 *
                 * definitely error otherwise.
                 */
                hassame = ae_false;
                for(k=0; k<=npoints-1; k++)
                {
                    if( k!=i )
                    {
                        for(j=0; j<=nvars-1; j++)
                        {
                            if( ae_fp_eq(xy.ptr.pp_double[k][j],xy.ptr.pp_double[i][j]) )
                            {
                                hassame = ae_true;
                            }
                        }
                    }
                }
                if( !hassame )
                {
                    *err = ae_true;
                    ae_frame_leave(_state);
                    return;
                }
            }
        }
    }
    ae_frame_leave(_state);
}


/*************************************************************************
Basic test:  tests generalization ability on a simple noisy classification
task:
* 0<x<1 - P(class=0)=1
* 1<x<2 - P(class=0)=2-x
* 2<x<3 - P(class=0)=0
*************************************************************************/
static void testdforestunit_basictest2(ae_bool* err, ae_state *_state)
{
    ae_frame _frame_block;
    ae_int_t pass;
    ae_int_t passcount;
    ae_matrix xy;
    ae_int_t npoints;
    ae_int_t ntrees;
    ae_int_t i;
    ae_int_t j;
    double s;
    ae_int_t info;
    decisionforest df;
    ae_vector x;
    ae_vector y;
    dfreport rep;

    ae_frame_make(_state, &_frame_block);
    ae_matrix_init(&xy, 0, 0, DT_REAL, _state);
    _decisionforest_init(&df, _state);
    ae_vector_init(&x, 0, DT_REAL, _state);
    ae_vector_init(&y, 0, DT_REAL, _state);
    _dfreport_init(&rep, _state);

    passcount = 1;
    for(pass=1; pass<=passcount; pass++)
    {
        
        /*
         * select npoints and ntrees
         */
        npoints = 3000;
        ntrees = 50;
        
        /*
         * Prepare task
         */
        ae_matrix_set_length(&xy, npoints-1+1, 1+1, _state);
        ae_vector_set_length(&x, 0+1, _state);
        ae_vector_set_length(&y, 1+1, _state);
        for(i=0; i<=npoints-1; i++)
        {
            xy.ptr.pp_double[i][0] = 3*ae_randomreal(_state);
            if( ae_fp_less_eq(xy.ptr.pp_double[i][0],(double)(1)) )
            {
                xy.ptr.pp_double[i][1] = (double)(0);
            }
            else
            {
                if( ae_fp_less_eq(xy.ptr.pp_double[i][0],(double)(2)) )
                {
                    if( ae_fp_less(ae_randomreal(_state),xy.ptr.pp_double[i][0]-1) )
                    {
                        xy.ptr.pp_double[i][1] = (double)(1);
                    }
                    else
                    {
                        xy.ptr.pp_double[i][1] = (double)(0);
                    }
                }
                else
                {
                    xy.ptr.pp_double[i][1] = (double)(1);
                }
            }
        }
        
        /*
         * Test
         */
        dfbuildinternal(&xy, npoints, 1, 2, ntrees, ae_round(0.05*npoints, _state), 1, 0, &info, &df, &rep, _state);
        if( info<=0 )
        {
            *err = ae_true;
            ae_frame_leave(_state);
            return;
        }
        x.ptr.p_double[0] = 0.0;
        while(ae_fp_less_eq(x.ptr.p_double[0],3.0))
        {
            dfprocess(&df, &x, &y, _state);
            
            /*
             * Test for basic properties
             */
            s = (double)(0);
            for(j=0; j<=1; j++)
            {
                if( ae_fp_less(y.ptr.p_double[j],(double)(0)) )
                {
                    *err = ae_true;
                    ae_frame_leave(_state);
                    return;
                }
                s = s+y.ptr.p_double[j];
            }
            if( ae_fp_greater(ae_fabs(s-1, _state),1000*ae_machineepsilon) )
            {
                *err = ae_true;
                ae_frame_leave(_state);
                return;
            }
            
            /*
             * test for good correlation with results
             */
            if( ae_fp_less(x.ptr.p_double[0],(double)(1)) )
            {
                *err = *err||ae_fp_less(y.ptr.p_double[0],0.8);
            }
            if( ae_fp_greater_eq(x.ptr.p_double[0],(double)(1))&&ae_fp_less_eq(x.ptr.p_double[0],(double)(2)) )
            {
                *err = *err||ae_fp_greater(ae_fabs(y.ptr.p_double[1]-(x.ptr.p_double[0]-1), _state),0.5);
            }
            if( ae_fp_greater(x.ptr.p_double[0],(double)(2)) )
            {
                *err = *err||ae_fp_less(y.ptr.p_double[1],0.8);
            }
            x.ptr.p_double[0] = x.ptr.p_double[0]+0.01;
        }
    }
    ae_frame_leave(_state);
}


/*************************************************************************
Basic test:  tests  generalization ability on a simple classification task
(no noise):
* |x|<1, |y|<1
* x^2+y^2<=0.25 - P(class=0)=1
* x^2+y^2>0.25  - P(class=0)=0
*************************************************************************/
static void testdforestunit_basictest3(ae_bool* err, ae_state *_state)
{
    ae_frame _frame_block;
    ae_int_t pass;
    ae_int_t passcount;
    ae_matrix xy;
    ae_int_t npoints;
    ae_int_t ntrees;
    ae_int_t i;
    ae_int_t j;
    ae_int_t k;
    double s;
    ae_int_t info;
    decisionforest df;
    ae_vector x;
    ae_vector y;
    dfreport rep;
    ae_int_t testgridsize;
    double r;

    ae_frame_make(_state, &_frame_block);
    ae_matrix_init(&xy, 0, 0, DT_REAL, _state);
    _decisionforest_init(&df, _state);
    ae_vector_init(&x, 0, DT_REAL, _state);
    ae_vector_init(&y, 0, DT_REAL, _state);
    _dfreport_init(&rep, _state);

    passcount = 1;
    testgridsize = 50;
    for(pass=1; pass<=passcount; pass++)
    {
        
        /*
         * select npoints and ntrees
         */
        npoints = 2000;
        ntrees = 100;
        
        /*
         * Prepare task
         */
        ae_matrix_set_length(&xy, npoints-1+1, 2+1, _state);
        ae_vector_set_length(&x, 1+1, _state);
        ae_vector_set_length(&y, 1+1, _state);
        for(i=0; i<=npoints-1; i++)
        {
            xy.ptr.pp_double[i][0] = 2*ae_randomreal(_state)-1;
            xy.ptr.pp_double[i][1] = 2*ae_randomreal(_state)-1;
            if( ae_fp_less_eq(ae_sqr(xy.ptr.pp_double[i][0], _state)+ae_sqr(xy.ptr.pp_double[i][1], _state),0.25) )
            {
                xy.ptr.pp_double[i][2] = (double)(0);
            }
            else
            {
                xy.ptr.pp_double[i][2] = (double)(1);
            }
        }
        
        /*
         * Test
         */
        dfbuildinternal(&xy, npoints, 2, 2, ntrees, ae_round(0.1*npoints, _state), 1, 0, &info, &df, &rep, _state);
        if( info<=0 )
        {
            *err = ae_true;
            ae_frame_leave(_state);
            return;
        }
        for(i=-testgridsize/2; i<=testgridsize/2; i++)
        {
            for(j=-testgridsize/2; j<=testgridsize/2; j++)
            {
                x.ptr.p_double[0] = (double)i/(double)(testgridsize/2);
                x.ptr.p_double[1] = (double)j/(double)(testgridsize/2);
                dfprocess(&df, &x, &y, _state);
                
                /*
                 * Test for basic properties
                 */
                s = (double)(0);
                for(k=0; k<=1; k++)
                {
                    if( ae_fp_less(y.ptr.p_double[k],(double)(0)) )
                    {
                        *err = ae_true;
                        ae_frame_leave(_state);
                        return;
                    }
                    s = s+y.ptr.p_double[k];
                }
                if( ae_fp_greater(ae_fabs(s-1, _state),1000*ae_machineepsilon) )
                {
                    *err = ae_true;
                    ae_frame_leave(_state);
                    return;
                }
                
                /*
                 * test for good correlation with results
                 */
                r = ae_sqrt(ae_sqr(x.ptr.p_double[0], _state)+ae_sqr(x.ptr.p_double[1], _state), _state);
                if( ae_fp_less(r,0.5*0.5) )
                {
                    *err = *err||ae_fp_less(y.ptr.p_double[0],0.6);
                }
                if( ae_fp_greater(r,0.5*1.5) )
                {
                    *err = *err||ae_fp_less(y.ptr.p_double[1],0.6);
                }
            }
        }
    }
    ae_frame_leave(_state);
}


/*************************************************************************
Basic test: simple regression task without noise:
* |x|<1, |y|<1
* F(x,y) = x^2+y
*************************************************************************/
static void testdforestunit_basictest4(ae_bool* err, ae_state *_state)
{
    ae_frame _frame_block;
    ae_int_t pass;
    ae_int_t passcount;
    ae_matrix xy;
    ae_int_t npoints;
    ae_int_t ntrees;
    ae_int_t ns;
    ae_int_t strongc;
    ae_int_t i;
    ae_int_t j;
    ae_int_t info;
    decisionforest df;
    decisionforest df2;
    ae_vector x;
    ae_vector y;
    dfreport rep;
    dfreport rep2;
    ae_int_t testgridsize;
    double maxerr;
    double maxerr2;
    double avgerr;
    double avgerr2;
    ae_int_t cnt;
    double ey;

    ae_frame_make(_state, &_frame_block);
    ae_matrix_init(&xy, 0, 0, DT_REAL, _state);
    _decisionforest_init(&df, _state);
    _decisionforest_init(&df2, _state);
    ae_vector_init(&x, 0, DT_REAL, _state);
    ae_vector_init(&y, 0, DT_REAL, _state);
    _dfreport_init(&rep, _state);
    _dfreport_init(&rep2, _state);

    passcount = 1;
    testgridsize = 50;
    for(pass=1; pass<=passcount; pass++)
    {
        
        /*
         * select npoints and ntrees
         */
        npoints = 5000;
        ntrees = 100;
        ns = ae_round(0.1*npoints, _state);
        strongc = 1;
        
        /*
         * Prepare task
         */
        ae_matrix_set_length(&xy, npoints-1+1, 2+1, _state);
        ae_vector_set_length(&x, 1+1, _state);
        ae_vector_set_length(&y, 0+1, _state);
        for(i=0; i<=npoints-1; i++)
        {
            xy.ptr.pp_double[i][0] = 2*ae_randomreal(_state)-1;
            xy.ptr.pp_double[i][1] = 2*ae_randomreal(_state)-1;
            xy.ptr.pp_double[i][2] = ae_sqr(xy.ptr.pp_double[i][0], _state)+xy.ptr.pp_double[i][1];
        }
        
        /*
         * Test
         */
        dfbuildinternal(&xy, npoints, 2, 1, ntrees, ns, 1, 0, &info, &df, &rep, _state);
        if( info<=0 )
        {
            *err = ae_true;
            ae_frame_leave(_state);
            return;
        }
        dfbuildinternal(&xy, npoints, 2, 1, ntrees, ns, 1, strongc, &info, &df2, &rep2, _state);
        if( info<=0 )
        {
            *err = ae_true;
            ae_frame_leave(_state);
            return;
        }
        maxerr = (double)(0);
        maxerr2 = (double)(0);
        avgerr = (double)(0);
        avgerr2 = (double)(0);
        cnt = 0;
        for(i=ae_round(-0.7*testgridsize/2, _state); i<=ae_round(0.7*testgridsize/2, _state); i++)
        {
            for(j=ae_round(-0.7*testgridsize/2, _state); j<=ae_round(0.7*testgridsize/2, _state); j++)
            {
                x.ptr.p_double[0] = (double)i/(double)(testgridsize/2);
                x.ptr.p_double[1] = (double)j/(double)(testgridsize/2);
                ey = ae_sqr(x.ptr.p_double[0], _state)+x.ptr.p_double[1];
                dfprocess(&df, &x, &y, _state);
                maxerr = ae_maxreal(maxerr, ae_fabs(y.ptr.p_double[0]-ey, _state), _state);
                avgerr = avgerr+ae_fabs(y.ptr.p_double[0]-ey, _state);
                dfprocess(&df2, &x, &y, _state);
                maxerr2 = ae_maxreal(maxerr2, ae_fabs(y.ptr.p_double[0]-ey, _state), _state);
                avgerr2 = avgerr2+ae_fabs(y.ptr.p_double[0]-ey, _state);
                cnt = cnt+1;
            }
        }
        avgerr = avgerr/cnt;
        avgerr2 = avgerr2/cnt;
        *err = *err||ae_fp_greater(maxerr,0.2);
        *err = *err||ae_fp_greater(maxerr2,0.2);
        *err = *err||ae_fp_greater(avgerr,0.1);
        *err = *err||ae_fp_greater(avgerr2,0.1);
    }
    ae_frame_leave(_state);
}


/*************************************************************************
Basic test: extended variable selection leads to better results.

Next task CAN be solved without EVS but it is very unlikely. With EVS
it can be easily and exactly solved.

Task matrix:
    1 0 0 0 ... 0   0
    0 1 0 0 ... 0   1
    0 0 1 0 ... 0   2
    0 0 0 1 ... 0   3
    0 0 0 0 ... 1   N-1
*************************************************************************/
static void testdforestunit_basictest5(ae_bool* err, ae_state *_state)
{
    ae_frame _frame_block;
    ae_matrix xy;
    ae_int_t nvars;
    ae_int_t npoints;
    ae_int_t nfeatures;
    ae_int_t nsample;
    ae_int_t ntrees;
    ae_int_t evs;
    ae_int_t i;
    ae_int_t j;
    ae_bool eflag;
    ae_int_t info;
    decisionforest df;
    ae_vector x;
    ae_vector y;
    dfreport rep;

    ae_frame_make(_state, &_frame_block);
    ae_matrix_init(&xy, 0, 0, DT_REAL, _state);
    _decisionforest_init(&df, _state);
    ae_vector_init(&x, 0, DT_REAL, _state);
    ae_vector_init(&y, 0, DT_REAL, _state);
    _dfreport_init(&rep, _state);

    
    /*
     * select npoints and ntrees
     */
    npoints = 50;
    nvars = npoints;
    ntrees = 1;
    nsample = npoints;
    evs = 2;
    nfeatures = 1;
    
    /*
     * Prepare task
     */
    ae_matrix_set_length(&xy, npoints-1+1, nvars+1, _state);
    ae_vector_set_length(&x, nvars-1+1, _state);
    ae_vector_set_length(&y, 0+1, _state);
    for(i=0; i<=npoints-1; i++)
    {
        for(j=0; j<=nvars-1; j++)
        {
            xy.ptr.pp_double[i][j] = (double)(0);
        }
        xy.ptr.pp_double[i][i] = (double)(1);
        xy.ptr.pp_double[i][nvars] = (double)(i);
    }
    
    /*
     * Without EVS
     */
    dfbuildinternal(&xy, npoints, nvars, 1, ntrees, nsample, nfeatures, 0, &info, &df, &rep, _state);
    if( info<=0 )
    {
        *err = ae_true;
        ae_frame_leave(_state);
        return;
    }
    eflag = ae_false;
    for(i=0; i<=npoints-1; i++)
    {
        ae_v_move(&x.ptr.p_double[0], 1, &xy.ptr.pp_double[i][0], 1, ae_v_len(0,nvars-1));
        dfprocess(&df, &x, &y, _state);
        if( ae_fp_greater(ae_fabs(y.ptr.p_double[0]-xy.ptr.pp_double[i][nvars], _state),1000*ae_machineepsilon) )
        {
            eflag = ae_true;
        }
    }
    if( !eflag )
    {
        *err = ae_true;
        ae_frame_leave(_state);
        return;
    }
    
    /*
     * With EVS
     */
    dfbuildinternal(&xy, npoints, nvars, 1, ntrees, nsample, nfeatures, evs, &info, &df, &rep, _state);
    if( info<=0 )
    {
        *err = ae_true;
        ae_frame_leave(_state);
        return;
    }
    eflag = ae_false;
    for(i=0; i<=npoints-1; i++)
    {
        ae_v_move(&x.ptr.p_double[0], 1, &xy.ptr.pp_double[i][0], 1, ae_v_len(0,nvars-1));
        dfprocess(&df, &x, &y, _state);
        if( ae_fp_greater(ae_fabs(y.ptr.p_double[0]-xy.ptr.pp_double[i][nvars], _state),1000*ae_machineepsilon) )
        {
            eflag = ae_true;
        }
    }
    if( eflag )
    {
        *err = ae_true;
        ae_frame_leave(_state);
        return;
    }
    ae_frame_leave(_state);
}


/*************************************************************************
Random normal number
*************************************************************************/
static double testdforestunit_rnormal(ae_state *_state)
{
    double u;
    double v;
    double s;
    double x1;
    double x2;
    double result;


    for(;;)
    {
        u = 2*ae_randomreal(_state)-1;
        v = 2*ae_randomreal(_state)-1;
        s = ae_sqr(u, _state)+ae_sqr(v, _state);
        if( ae_fp_greater(s,(double)(0))&&ae_fp_less(s,(double)(1)) )
        {
            s = ae_sqrt(-2*ae_log(s, _state)/s, _state);
            x1 = u*s;
            x2 = v*s;
            break;
        }
    }
    result = x1;
    return result;
}


/*************************************************************************
Random point from sphere
*************************************************************************/
static void testdforestunit_rsphere(/* Real    */ ae_matrix* xy,
     ae_int_t n,
     ae_int_t i,
     ae_state *_state)
{
    ae_int_t j;
    double v;


    for(j=0; j<=n-1; j++)
    {
        xy->ptr.pp_double[i][j] = testdforestunit_rnormal(_state);
    }
    v = ae_v_dotproduct(&xy->ptr.pp_double[i][0], 1, &xy->ptr.pp_double[i][0], 1, ae_v_len(0,n-1));
    v = ae_randomreal(_state)/ae_sqrt(v, _state);
    ae_v_muld(&xy->ptr.pp_double[i][0], 1, ae_v_len(0,n-1), v);
}


/*************************************************************************
Unsets DF
*************************************************************************/
static void testdforestunit_unsetdf(decisionforest* df, ae_state *_state)
{
    ae_frame _frame_block;
    ae_matrix xy;
    ae_int_t info;
    dfreport rep;

    ae_frame_make(_state, &_frame_block);
    ae_matrix_init(&xy, 0, 0, DT_REAL, _state);
    _dfreport_init(&rep, _state);

    ae_matrix_set_length(&xy, 0+1, 1+1, _state);
    xy.ptr.pp_double[0][0] = (double)(0);
    xy.ptr.pp_double[0][1] = (double)(0);
    dfbuildinternal(&xy, 1, 1, 1, 1, 1, 1, 0, &info, df, &rep, _state);
    ae_frame_leave(_state);
}








ae_bool testgammafunc(ae_bool silent, ae_state *_state)
{
    double threshold;
    double v;
    double s;
    ae_bool waserrors;
    ae_bool gammaerrors;
    ae_bool lngammaerrors;
    ae_bool result;


    gammaerrors = ae_false;
    lngammaerrors = ae_false;
    waserrors = ae_false;
    threshold = 100*ae_machineepsilon;
    
    /*
     *
     */
    gammaerrors = gammaerrors||ae_fp_greater(ae_fabs(gammafunction(0.5, _state)-ae_sqrt(ae_pi, _state), _state),threshold);
    gammaerrors = gammaerrors||ae_fp_greater(ae_fabs(gammafunction(1.5, _state)-0.5*ae_sqrt(ae_pi, _state), _state),threshold);
    v = lngamma(0.5, &s, _state);
    lngammaerrors = (lngammaerrors||ae_fp_greater(ae_fabs(v-ae_log(ae_sqrt(ae_pi, _state), _state), _state),threshold))||ae_fp_neq(s,(double)(1));
    v = lngamma(1.5, &s, _state);
    lngammaerrors = (lngammaerrors||ae_fp_greater(ae_fabs(v-ae_log(0.5*ae_sqrt(ae_pi, _state), _state), _state),threshold))||ae_fp_neq(s,(double)(1));
    
    /*
     * report
     */
    waserrors = gammaerrors||lngammaerrors;
    if( !silent )
    {
        printf("TESTING GAMMA FUNCTION\n");
        printf("GAMMA:                                   ");
        if( gammaerrors )
        {
            printf("FAILED\n");
        }
        else
        {
            printf("OK\n");
        }
        printf("LN GAMMA:                                ");
        if( lngammaerrors )
        {
            printf("FAILED\n");
        }
        else
        {
            printf("OK\n");
        }
        if( waserrors )
        {
            printf("TEST FAILED\n");
        }
        else
        {
            printf("TEST PASSED\n");
        }
        printf("\n\n");
    }
    
    /*
     * end
     */
    result = !waserrors;
    return result;
}


/*************************************************************************
Single-threaded stub. HPC ALGLIB replaces it by multithreaded code.
*************************************************************************/
ae_bool _pexec_testgammafunc(ae_bool silent, ae_state *_state)
{
    return testgammafunc(silent, _state);
}








ae_bool testhblas(ae_bool silent, ae_state *_state)
{
    ae_frame _frame_block;
    ae_matrix a;
    ae_matrix ua;
    ae_matrix la;
    ae_vector x;
    ae_vector y1;
    ae_vector y2;
    ae_vector y3;
    ae_int_t n;
    ae_int_t maxn;
    ae_int_t i;
    ae_int_t j;
    ae_int_t i1;
    ae_int_t i2;
    ae_bool waserrors;
    double mverr;
    double threshold;
    ae_complex alpha;
    ae_complex v;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    ae_matrix_init(&a, 0, 0, DT_COMPLEX, _state);
    ae_matrix_init(&ua, 0, 0, DT_COMPLEX, _state);
    ae_matrix_init(&la, 0, 0, DT_COMPLEX, _state);
    ae_vector_init(&x, 0, DT_COMPLEX, _state);
    ae_vector_init(&y1, 0, DT_COMPLEX, _state);
    ae_vector_init(&y2, 0, DT_COMPLEX, _state);
    ae_vector_init(&y3, 0, DT_COMPLEX, _state);

    mverr = (double)(0);
    waserrors = ae_false;
    maxn = 10;
    threshold = 1000*ae_machineepsilon;
    
    /*
     * Test MV
     */
    for(n=2; n<=maxn; n++)
    {
        ae_matrix_set_length(&a, n+1, n+1, _state);
        ae_matrix_set_length(&ua, n+1, n+1, _state);
        ae_matrix_set_length(&la, n+1, n+1, _state);
        ae_vector_set_length(&x, n+1, _state);
        ae_vector_set_length(&y1, n+1, _state);
        ae_vector_set_length(&y2, n+1, _state);
        ae_vector_set_length(&y3, n+1, _state);
        
        /*
         * fill A, UA, LA
         */
        for(i=1; i<=n; i++)
        {
            a.ptr.pp_complex[i][i].x = 2*ae_randomreal(_state)-1;
            a.ptr.pp_complex[i][i].y = (double)(0);
            for(j=i+1; j<=n; j++)
            {
                a.ptr.pp_complex[i][j].x = 2*ae_randomreal(_state)-1;
                a.ptr.pp_complex[i][j].y = 2*ae_randomreal(_state)-1;
                a.ptr.pp_complex[j][i] = ae_c_conj(a.ptr.pp_complex[i][j], _state);
            }
        }
        for(i=1; i<=n; i++)
        {
            for(j=1; j<=n; j++)
            {
                ua.ptr.pp_complex[i][j] = ae_complex_from_i(0);
            }
        }
        for(i=1; i<=n; i++)
        {
            for(j=i; j<=n; j++)
            {
                ua.ptr.pp_complex[i][j] = a.ptr.pp_complex[i][j];
            }
        }
        for(i=1; i<=n; i++)
        {
            for(j=1; j<=n; j++)
            {
                la.ptr.pp_complex[i][j] = ae_complex_from_i(0);
            }
        }
        for(i=1; i<=n; i++)
        {
            for(j=1; j<=i; j++)
            {
                la.ptr.pp_complex[i][j] = a.ptr.pp_complex[i][j];
            }
        }
        
        /*
         * test on different I1, I2
         */
        for(i1=1; i1<=n; i1++)
        {
            for(i2=i1; i2<=n; i2++)
            {
                
                /*
                 * Fill X, choose Alpha
                 */
                for(i=1; i<=i2-i1+1; i++)
                {
                    x.ptr.p_complex[i].x = 2*ae_randomreal(_state)-1;
                    x.ptr.p_complex[i].y = 2*ae_randomreal(_state)-1;
                }
                alpha.x = 2*ae_randomreal(_state)-1;
                alpha.y = 2*ae_randomreal(_state)-1;
                
                /*
                 * calculate A*x, UA*x, LA*x
                 */
                for(i=i1; i<=i2; i++)
                {
                    v = ae_v_cdotproduct(&a.ptr.pp_complex[i][i1], 1, "N", &x.ptr.p_complex[1], 1, "N", ae_v_len(i1,i2));
                    y1.ptr.p_complex[i-i1+1] = ae_c_mul(alpha,v);
                }
                hermitianmatrixvectormultiply(&ua, ae_true, i1, i2, &x, alpha, &y2, _state);
                hermitianmatrixvectormultiply(&la, ae_false, i1, i2, &x, alpha, &y3, _state);
                
                /*
                 * Calculate error
                 */
                ae_v_csub(&y2.ptr.p_complex[1], 1, &y1.ptr.p_complex[1], 1, "N", ae_v_len(1,i2-i1+1));
                v = ae_v_cdotproduct(&y2.ptr.p_complex[1], 1, "N", &y2.ptr.p_complex[1], 1, "Conj", ae_v_len(1,i2-i1+1));
                mverr = ae_maxreal(mverr, ae_sqrt(ae_c_abs(v, _state), _state), _state);
                ae_v_csub(&y3.ptr.p_complex[1], 1, &y1.ptr.p_complex[1], 1, "N", ae_v_len(1,i2-i1+1));
                v = ae_v_cdotproduct(&y3.ptr.p_complex[1], 1, "N", &y3.ptr.p_complex[1], 1, "Conj", ae_v_len(1,i2-i1+1));
                mverr = ae_maxreal(mverr, ae_sqrt(ae_c_abs(v, _state), _state), _state);
            }
        }
    }
    
    /*
     * report
     */
    waserrors = ae_fp_greater(mverr,threshold);
    if( !silent )
    {
        printf("TESTING HERMITIAN BLAS\n");
        printf("MV error:                                %5.3e\n",
            (double)(mverr));
        printf("Threshold:                               %5.3e\n",
            (double)(threshold));
        if( waserrors )
        {
            printf("TEST FAILED\n");
        }
        else
        {
            printf("TEST PASSED\n");
        }
        printf("\n\n");
    }
    result = !waserrors;
    ae_frame_leave(_state);
    return result;
}


/*************************************************************************
Single-threaded stub. HPC ALGLIB replaces it by multithreaded code.
*************************************************************************/
ae_bool _pexec_testhblas(ae_bool silent, ae_state *_state)
{
    return testhblas(silent, _state);
}








ae_bool testreflections(ae_bool silent, ae_state *_state)
{
    ae_frame _frame_block;
    ae_int_t i;
    ae_int_t j;
    ae_int_t n;
    ae_int_t m;
    ae_int_t maxmn;
    ae_vector x;
    ae_vector v;
    ae_vector work;
    ae_matrix h;
    ae_matrix a;
    ae_matrix b;
    ae_matrix c;
    double tmp;
    double beta;
    double tau;
    double err;
    double mer;
    double mel;
    double meg;
    ae_int_t pass;
    ae_int_t passcount;
    double threshold;
    ae_int_t tasktype;
    double xscale;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    ae_vector_init(&x, 0, DT_REAL, _state);
    ae_vector_init(&v, 0, DT_REAL, _state);
    ae_vector_init(&work, 0, DT_REAL, _state);
    ae_matrix_init(&h, 0, 0, DT_REAL, _state);
    ae_matrix_init(&a, 0, 0, DT_REAL, _state);
    ae_matrix_init(&b, 0, 0, DT_REAL, _state);
    ae_matrix_init(&c, 0, 0, DT_REAL, _state);

    passcount = 10;
    threshold = 100*ae_machineepsilon;
    mer = (double)(0);
    mel = (double)(0);
    meg = (double)(0);
    for(pass=1; pass<=passcount; pass++)
    {
        for(n=1; n<=10; n++)
        {
            for(m=1; m<=10; m++)
            {
                
                /*
                 * Task
                 */
                n = 1+ae_randominteger(10, _state);
                m = 1+ae_randominteger(10, _state);
                maxmn = ae_maxint(m, n, _state);
                
                /*
                 * Initialize
                 */
                ae_vector_set_length(&x, maxmn+1, _state);
                ae_vector_set_length(&v, maxmn+1, _state);
                ae_vector_set_length(&work, maxmn+1, _state);
                ae_matrix_set_length(&h, maxmn+1, maxmn+1, _state);
                ae_matrix_set_length(&a, maxmn+1, maxmn+1, _state);
                ae_matrix_set_length(&b, maxmn+1, maxmn+1, _state);
                ae_matrix_set_length(&c, maxmn+1, maxmn+1, _state);
                
                /*
                 * GenerateReflection, three tasks are possible:
                 * * random X
                 * * zero X
                 * * non-zero X[1], all other are zeros
                 * * random X, near underflow scale
                 * * random X, near overflow scale
                 */
                for(tasktype=0; tasktype<=4; tasktype++)
                {
                    xscale = (double)(1);
                    if( tasktype==0 )
                    {
                        for(i=1; i<=n; i++)
                        {
                            x.ptr.p_double[i] = 2*ae_randomreal(_state)-1;
                        }
                    }
                    if( tasktype==1 )
                    {
                        for(i=1; i<=n; i++)
                        {
                            x.ptr.p_double[i] = (double)(0);
                        }
                    }
                    if( tasktype==2 )
                    {
                        x.ptr.p_double[1] = 2*ae_randomreal(_state)-1;
                        for(i=2; i<=n; i++)
                        {
                            x.ptr.p_double[i] = (double)(0);
                        }
                    }
                    if( tasktype==3 )
                    {
                        for(i=1; i<=n; i++)
                        {
                            x.ptr.p_double[i] = (ae_randominteger(21, _state)-10)*ae_minrealnumber;
                        }
                        xscale = 10*ae_minrealnumber;
                    }
                    if( tasktype==4 )
                    {
                        for(i=1; i<=n; i++)
                        {
                            x.ptr.p_double[i] = (2*ae_randomreal(_state)-1)*ae_maxrealnumber;
                        }
                        xscale = ae_maxrealnumber;
                    }
                    ae_v_move(&v.ptr.p_double[1], 1, &x.ptr.p_double[1], 1, ae_v_len(1,n));
                    generatereflection(&v, n, &tau, _state);
                    beta = v.ptr.p_double[1];
                    v.ptr.p_double[1] = (double)(1);
                    for(i=1; i<=n; i++)
                    {
                        for(j=1; j<=n; j++)
                        {
                            if( i==j )
                            {
                                h.ptr.pp_double[i][j] = 1-tau*v.ptr.p_double[i]*v.ptr.p_double[j];
                            }
                            else
                            {
                                h.ptr.pp_double[i][j] = -tau*v.ptr.p_double[i]*v.ptr.p_double[j];
                            }
                        }
                    }
                    err = (double)(0);
                    for(i=1; i<=n; i++)
                    {
                        tmp = ae_v_dotproduct(&h.ptr.pp_double[i][1], 1, &x.ptr.p_double[1], 1, ae_v_len(1,n));
                        if( i==1 )
                        {
                            err = ae_maxreal(err, ae_fabs(tmp-beta, _state), _state);
                        }
                        else
                        {
                            err = ae_maxreal(err, ae_fabs(tmp, _state), _state);
                        }
                    }
                    meg = ae_maxreal(meg, err/xscale, _state);
                }
                
                /*
                 * ApplyReflectionFromTheLeft
                 */
                for(i=1; i<=m; i++)
                {
                    x.ptr.p_double[i] = 2*ae_randomreal(_state)-1;
                    v.ptr.p_double[i] = x.ptr.p_double[i];
                }
                for(i=1; i<=m; i++)
                {
                    for(j=1; j<=n; j++)
                    {
                        a.ptr.pp_double[i][j] = 2*ae_randomreal(_state)-1;
                        b.ptr.pp_double[i][j] = a.ptr.pp_double[i][j];
                    }
                }
                generatereflection(&v, m, &tau, _state);
                beta = v.ptr.p_double[1];
                v.ptr.p_double[1] = (double)(1);
                applyreflectionfromtheleft(&b, tau, &v, 1, m, 1, n, &work, _state);
                for(i=1; i<=m; i++)
                {
                    for(j=1; j<=m; j++)
                    {
                        if( i==j )
                        {
                            h.ptr.pp_double[i][j] = 1-tau*v.ptr.p_double[i]*v.ptr.p_double[j];
                        }
                        else
                        {
                            h.ptr.pp_double[i][j] = -tau*v.ptr.p_double[i]*v.ptr.p_double[j];
                        }
                    }
                }
                for(i=1; i<=m; i++)
                {
                    for(j=1; j<=n; j++)
                    {
                        tmp = ae_v_dotproduct(&h.ptr.pp_double[i][1], 1, &a.ptr.pp_double[1][j], a.stride, ae_v_len(1,m));
                        c.ptr.pp_double[i][j] = tmp;
                    }
                }
                err = (double)(0);
                for(i=1; i<=m; i++)
                {
                    for(j=1; j<=n; j++)
                    {
                        err = ae_maxreal(err, ae_fabs(b.ptr.pp_double[i][j]-c.ptr.pp_double[i][j], _state), _state);
                    }
                }
                mel = ae_maxreal(mel, err, _state);
                
                /*
                 * ApplyReflectionFromTheRight
                 */
                for(i=1; i<=n; i++)
                {
                    x.ptr.p_double[i] = 2*ae_randomreal(_state)-1;
                    v.ptr.p_double[i] = x.ptr.p_double[i];
                }
                for(i=1; i<=m; i++)
                {
                    for(j=1; j<=n; j++)
                    {
                        a.ptr.pp_double[i][j] = 2*ae_randomreal(_state)-1;
                        b.ptr.pp_double[i][j] = a.ptr.pp_double[i][j];
                    }
                }
                generatereflection(&v, n, &tau, _state);
                beta = v.ptr.p_double[1];
                v.ptr.p_double[1] = (double)(1);
                applyreflectionfromtheright(&b, tau, &v, 1, m, 1, n, &work, _state);
                for(i=1; i<=n; i++)
                {
                    for(j=1; j<=n; j++)
                    {
                        if( i==j )
                        {
                            h.ptr.pp_double[i][j] = 1-tau*v.ptr.p_double[i]*v.ptr.p_double[j];
                        }
                        else
                        {
                            h.ptr.pp_double[i][j] = -tau*v.ptr.p_double[i]*v.ptr.p_double[j];
                        }
                    }
                }
                for(i=1; i<=m; i++)
                {
                    for(j=1; j<=n; j++)
                    {
                        tmp = ae_v_dotproduct(&a.ptr.pp_double[i][1], 1, &h.ptr.pp_double[1][j], h.stride, ae_v_len(1,n));
                        c.ptr.pp_double[i][j] = tmp;
                    }
                }
                err = (double)(0);
                for(i=1; i<=m; i++)
                {
                    for(j=1; j<=n; j++)
                    {
                        err = ae_maxreal(err, ae_fabs(b.ptr.pp_double[i][j]-c.ptr.pp_double[i][j], _state), _state);
                    }
                }
                mer = ae_maxreal(mer, err, _state);
            }
        }
    }
    
    /*
     * Overflow crash test
     */
    ae_vector_set_length(&x, 10+1, _state);
    ae_vector_set_length(&v, 10+1, _state);
    for(i=1; i<=10; i++)
    {
        v.ptr.p_double[i] = ae_maxrealnumber*0.01*(2*ae_randomreal(_state)-1);
    }
    generatereflection(&v, 10, &tau, _state);
    result = (ae_fp_less_eq(meg,threshold)&&ae_fp_less_eq(mel,threshold))&&ae_fp_less_eq(mer,threshold);
    if( !silent )
    {
        printf("TESTING REFLECTIONS\n");
        printf("Pass count is %0d\n",
            (int)(passcount));
        printf("Generate     absolute error is       %5.3e\n",
            (double)(meg));
        printf("Apply(Left)  absolute error is       %5.3e\n",
            (double)(mel));
        printf("Apply(Right) absolute error is       %5.3e\n",
            (double)(mer));
        printf("Overflow crash test passed\n");
        if( result )
        {
            printf("TEST PASSED\n");
        }
        else
        {
            printf("TEST FAILED\n");
        }
    }
    ae_frame_leave(_state);
    return result;
}


/*************************************************************************
Single-threaded stub. HPC ALGLIB replaces it by multithreaded code.
*************************************************************************/
ae_bool _pexec_testreflections(ae_bool silent, ae_state *_state)
{
    return testreflections(silent, _state);
}








ae_bool testcreflections(ae_bool silent, ae_state *_state)
{
    ae_frame _frame_block;
    ae_int_t i;
    ae_int_t j;
    ae_int_t n;
    ae_int_t m;
    ae_int_t maxmn;
    ae_vector x;
    ae_vector v;
    ae_vector work;
    ae_matrix h;
    ae_matrix a;
    ae_matrix b;
    ae_matrix c;
    ae_complex tmp;
    ae_complex beta;
    ae_complex tau;
    double err;
    double mer;
    double mel;
    double meg;
    ae_int_t pass;
    ae_int_t passcount;
    ae_bool waserrors;
    double threshold;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    ae_vector_init(&x, 0, DT_COMPLEX, _state);
    ae_vector_init(&v, 0, DT_COMPLEX, _state);
    ae_vector_init(&work, 0, DT_COMPLEX, _state);
    ae_matrix_init(&h, 0, 0, DT_COMPLEX, _state);
    ae_matrix_init(&a, 0, 0, DT_COMPLEX, _state);
    ae_matrix_init(&b, 0, 0, DT_COMPLEX, _state);
    ae_matrix_init(&c, 0, 0, DT_COMPLEX, _state);

    threshold = 1000*ae_machineepsilon;
    passcount = 1000;
    mer = (double)(0);
    mel = (double)(0);
    meg = (double)(0);
    for(pass=1; pass<=passcount; pass++)
    {
        
        /*
         * Task
         */
        n = 1+ae_randominteger(10, _state);
        m = 1+ae_randominteger(10, _state);
        maxmn = ae_maxint(m, n, _state);
        
        /*
         * Initialize
         */
        ae_vector_set_length(&x, maxmn+1, _state);
        ae_vector_set_length(&v, maxmn+1, _state);
        ae_vector_set_length(&work, maxmn+1, _state);
        ae_matrix_set_length(&h, maxmn+1, maxmn+1, _state);
        ae_matrix_set_length(&a, maxmn+1, maxmn+1, _state);
        ae_matrix_set_length(&b, maxmn+1, maxmn+1, _state);
        ae_matrix_set_length(&c, maxmn+1, maxmn+1, _state);
        
        /*
         * GenerateReflection
         */
        for(i=1; i<=n; i++)
        {
            x.ptr.p_complex[i].x = 2*ae_randomreal(_state)-1;
            x.ptr.p_complex[i].y = 2*ae_randomreal(_state)-1;
            v.ptr.p_complex[i] = x.ptr.p_complex[i];
        }
        complexgeneratereflection(&v, n, &tau, _state);
        beta = v.ptr.p_complex[1];
        v.ptr.p_complex[1] = ae_complex_from_i(1);
        for(i=1; i<=n; i++)
        {
            for(j=1; j<=n; j++)
            {
                if( i==j )
                {
                    h.ptr.pp_complex[i][j] = ae_c_d_sub(1,ae_c_mul(ae_c_mul(tau,v.ptr.p_complex[i]),ae_c_conj(v.ptr.p_complex[j], _state)));
                }
                else
                {
                    h.ptr.pp_complex[i][j] = ae_c_neg(ae_c_mul(ae_c_mul(tau,v.ptr.p_complex[i]),ae_c_conj(v.ptr.p_complex[j], _state)));
                }
            }
        }
        err = (double)(0);
        for(i=1; i<=n; i++)
        {
            tmp = ae_v_cdotproduct(&h.ptr.pp_complex[1][i], h.stride, "Conj", &x.ptr.p_complex[1], 1, "N", ae_v_len(1,n));
            if( i==1 )
            {
                err = ae_maxreal(err, ae_c_abs(ae_c_sub(tmp,beta), _state), _state);
            }
            else
            {
                err = ae_maxreal(err, ae_c_abs(tmp, _state), _state);
            }
        }
        err = ae_maxreal(err, ae_fabs(beta.y, _state), _state);
        meg = ae_maxreal(meg, err, _state);
        
        /*
         * ApplyReflectionFromTheLeft
         */
        for(i=1; i<=m; i++)
        {
            x.ptr.p_complex[i].x = 2*ae_randomreal(_state)-1;
            x.ptr.p_complex[i].y = 2*ae_randomreal(_state)-1;
            v.ptr.p_complex[i] = x.ptr.p_complex[i];
        }
        for(i=1; i<=m; i++)
        {
            for(j=1; j<=n; j++)
            {
                a.ptr.pp_complex[i][j].x = 2*ae_randomreal(_state)-1;
                a.ptr.pp_complex[i][j].y = 2*ae_randomreal(_state)-1;
                b.ptr.pp_complex[i][j] = a.ptr.pp_complex[i][j];
            }
        }
        complexgeneratereflection(&v, m, &tau, _state);
        beta = v.ptr.p_complex[1];
        v.ptr.p_complex[1] = ae_complex_from_i(1);
        complexapplyreflectionfromtheleft(&b, tau, &v, 1, m, 1, n, &work, _state);
        for(i=1; i<=m; i++)
        {
            for(j=1; j<=m; j++)
            {
                if( i==j )
                {
                    h.ptr.pp_complex[i][j] = ae_c_d_sub(1,ae_c_mul(ae_c_mul(tau,v.ptr.p_complex[i]),ae_c_conj(v.ptr.p_complex[j], _state)));
                }
                else
                {
                    h.ptr.pp_complex[i][j] = ae_c_neg(ae_c_mul(ae_c_mul(tau,v.ptr.p_complex[i]),ae_c_conj(v.ptr.p_complex[j], _state)));
                }
            }
        }
        for(i=1; i<=m; i++)
        {
            for(j=1; j<=n; j++)
            {
                tmp = ae_v_cdotproduct(&h.ptr.pp_complex[i][1], 1, "N", &a.ptr.pp_complex[1][j], a.stride, "N", ae_v_len(1,m));
                c.ptr.pp_complex[i][j] = tmp;
            }
        }
        err = (double)(0);
        for(i=1; i<=m; i++)
        {
            for(j=1; j<=n; j++)
            {
                err = ae_maxreal(err, ae_c_abs(ae_c_sub(b.ptr.pp_complex[i][j],c.ptr.pp_complex[i][j]), _state), _state);
            }
        }
        mel = ae_maxreal(mel, err, _state);
        
        /*
         * ApplyReflectionFromTheRight
         */
        for(i=1; i<=n; i++)
        {
            x.ptr.p_complex[i] = ae_complex_from_d(2*ae_randomreal(_state)-1);
            v.ptr.p_complex[i] = x.ptr.p_complex[i];
        }
        for(i=1; i<=m; i++)
        {
            for(j=1; j<=n; j++)
            {
                a.ptr.pp_complex[i][j] = ae_complex_from_d(2*ae_randomreal(_state)-1);
                b.ptr.pp_complex[i][j] = a.ptr.pp_complex[i][j];
            }
        }
        complexgeneratereflection(&v, n, &tau, _state);
        beta = v.ptr.p_complex[1];
        v.ptr.p_complex[1] = ae_complex_from_i(1);
        complexapplyreflectionfromtheright(&b, tau, &v, 1, m, 1, n, &work, _state);
        for(i=1; i<=n; i++)
        {
            for(j=1; j<=n; j++)
            {
                if( i==j )
                {
                    h.ptr.pp_complex[i][j] = ae_c_d_sub(1,ae_c_mul(ae_c_mul(tau,v.ptr.p_complex[i]),ae_c_conj(v.ptr.p_complex[j], _state)));
                }
                else
                {
                    h.ptr.pp_complex[i][j] = ae_c_neg(ae_c_mul(ae_c_mul(tau,v.ptr.p_complex[i]),ae_c_conj(v.ptr.p_complex[j], _state)));
                }
            }
        }
        for(i=1; i<=m; i++)
        {
            for(j=1; j<=n; j++)
            {
                tmp = ae_v_cdotproduct(&a.ptr.pp_complex[i][1], 1, "N", &h.ptr.pp_complex[1][j], h.stride, "N", ae_v_len(1,n));
                c.ptr.pp_complex[i][j] = tmp;
            }
        }
        err = (double)(0);
        for(i=1; i<=m; i++)
        {
            for(j=1; j<=n; j++)
            {
                err = ae_maxreal(err, ae_c_abs(ae_c_sub(b.ptr.pp_complex[i][j],c.ptr.pp_complex[i][j]), _state), _state);
            }
        }
        mer = ae_maxreal(mer, err, _state);
    }
    
    /*
     * Overflow crash test
     */
    ae_vector_set_length(&x, 10+1, _state);
    ae_vector_set_length(&v, 10+1, _state);
    for(i=1; i<=10; i++)
    {
        v.ptr.p_complex[i] = ae_complex_from_d(ae_maxrealnumber*0.01*(2*ae_randomreal(_state)-1));
    }
    complexgeneratereflection(&v, 10, &tau, _state);
    
    /*
     * report
     */
    waserrors = (ae_fp_greater(meg,threshold)||ae_fp_greater(mel,threshold))||ae_fp_greater(mer,threshold);
    if( !silent )
    {
        printf("TESTING COMPLEX REFLECTIONS\n");
        printf("Generate error:                          %5.3e\n",
            (double)(meg));
        printf("Apply(L) error:                          %5.3e\n",
            (double)(mel));
        printf("Apply(R) error:                          %5.3e\n",
            (double)(mer));
        printf("Threshold:                               %5.3e\n",
            (double)(threshold));
        printf("Overflow crash test:                     PASSED\n");
        if( waserrors )
        {
            printf("TEST FAILED\n");
        }
        else
        {
            printf("TEST PASSED\n");
        }
        printf("\n\n");
    }
    result = !waserrors;
    ae_frame_leave(_state);
    return result;
}


/*************************************************************************
Single-threaded stub. HPC ALGLIB replaces it by multithreaded code.
*************************************************************************/
ae_bool _pexec_testcreflections(ae_bool silent, ae_state *_state)
{
    return testcreflections(silent, _state);
}








ae_bool testsblas(ae_bool silent, ae_state *_state)
{
    ae_frame _frame_block;
    ae_matrix a;
    ae_matrix ua;
    ae_matrix la;
    ae_vector x;
    ae_vector y1;
    ae_vector y2;
    ae_vector y3;
    ae_int_t n;
    ae_int_t maxn;
    ae_int_t i;
    ae_int_t j;
    ae_int_t i1;
    ae_int_t i2;
    ae_bool waserrors;
    double mverr;
    double threshold;
    double alpha;
    double v;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    ae_matrix_init(&a, 0, 0, DT_REAL, _state);
    ae_matrix_init(&ua, 0, 0, DT_REAL, _state);
    ae_matrix_init(&la, 0, 0, DT_REAL, _state);
    ae_vector_init(&x, 0, DT_REAL, _state);
    ae_vector_init(&y1, 0, DT_REAL, _state);
    ae_vector_init(&y2, 0, DT_REAL, _state);
    ae_vector_init(&y3, 0, DT_REAL, _state);

    mverr = (double)(0);
    waserrors = ae_false;
    maxn = 10;
    threshold = 1000*ae_machineepsilon;
    
    /*
     * Test MV
     */
    for(n=2; n<=maxn; n++)
    {
        ae_matrix_set_length(&a, n+1, n+1, _state);
        ae_matrix_set_length(&ua, n+1, n+1, _state);
        ae_matrix_set_length(&la, n+1, n+1, _state);
        ae_vector_set_length(&x, n+1, _state);
        ae_vector_set_length(&y1, n+1, _state);
        ae_vector_set_length(&y2, n+1, _state);
        ae_vector_set_length(&y3, n+1, _state);
        
        /*
         * fill A, UA, LA
         */
        for(i=1; i<=n; i++)
        {
            a.ptr.pp_double[i][i] = 2*ae_randomreal(_state)-1;
            for(j=i+1; j<=n; j++)
            {
                a.ptr.pp_double[i][j] = 2*ae_randomreal(_state)-1;
                a.ptr.pp_double[j][i] = a.ptr.pp_double[i][j];
            }
        }
        for(i=1; i<=n; i++)
        {
            for(j=1; j<=n; j++)
            {
                ua.ptr.pp_double[i][j] = (double)(0);
            }
        }
        for(i=1; i<=n; i++)
        {
            for(j=i; j<=n; j++)
            {
                ua.ptr.pp_double[i][j] = a.ptr.pp_double[i][j];
            }
        }
        for(i=1; i<=n; i++)
        {
            for(j=1; j<=n; j++)
            {
                la.ptr.pp_double[i][j] = (double)(0);
            }
        }
        for(i=1; i<=n; i++)
        {
            for(j=1; j<=i; j++)
            {
                la.ptr.pp_double[i][j] = a.ptr.pp_double[i][j];
            }
        }
        
        /*
         * test on different I1, I2
         */
        for(i1=1; i1<=n; i1++)
        {
            for(i2=i1; i2<=n; i2++)
            {
                
                /*
                 * Fill X, choose Alpha
                 */
                for(i=1; i<=i2-i1+1; i++)
                {
                    x.ptr.p_double[i] = 2*ae_randomreal(_state)-1;
                }
                alpha = 2*ae_randomreal(_state)-1;
                
                /*
                 * calculate A*x, UA*x, LA*x
                 */
                for(i=i1; i<=i2; i++)
                {
                    v = ae_v_dotproduct(&a.ptr.pp_double[i][i1], 1, &x.ptr.p_double[1], 1, ae_v_len(i1,i2));
                    y1.ptr.p_double[i-i1+1] = alpha*v;
                }
                symmetricmatrixvectormultiply(&ua, ae_true, i1, i2, &x, alpha, &y2, _state);
                symmetricmatrixvectormultiply(&la, ae_false, i1, i2, &x, alpha, &y3, _state);
                
                /*
                 * Calculate error
                 */
                ae_v_sub(&y2.ptr.p_double[1], 1, &y1.ptr.p_double[1], 1, ae_v_len(1,i2-i1+1));
                v = ae_v_dotproduct(&y2.ptr.p_double[1], 1, &y2.ptr.p_double[1], 1, ae_v_len(1,i2-i1+1));
                mverr = ae_maxreal(mverr, ae_sqrt(v, _state), _state);
                ae_v_sub(&y3.ptr.p_double[1], 1, &y1.ptr.p_double[1], 1, ae_v_len(1,i2-i1+1));
                v = ae_v_dotproduct(&y3.ptr.p_double[1], 1, &y3.ptr.p_double[1], 1, ae_v_len(1,i2-i1+1));
                mverr = ae_maxreal(mverr, ae_sqrt(v, _state), _state);
            }
        }
    }
    
    /*
     * report
     */
    waserrors = ae_fp_greater(mverr,threshold);
    if( !silent )
    {
        printf("TESTING SYMMETRIC BLAS\n");
        printf("MV error:                                %5.3e\n",
            (double)(mverr));
        printf("Threshold:                               %5.3e\n",
            (double)(threshold));
        if( waserrors )
        {
            printf("TEST FAILED\n");
        }
        else
        {
            printf("TEST PASSED\n");
        }
        printf("\n\n");
    }
    result = !waserrors;
    ae_frame_leave(_state);
    return result;
}


/*************************************************************************
Single-threaded stub. HPC ALGLIB replaces it by multithreaded code.
*************************************************************************/
ae_bool _pexec_testsblas(ae_bool silent, ae_state *_state)
{
    return testsblas(silent, _state);
}



static double testortfacunit_rmatrixdiff(/* Real    */ ae_matrix* a,
     /* Real    */ ae_matrix* b,
     ae_int_t m,
     ae_int_t n,
     ae_state *_state);
static void testortfacunit_rmatrixmakeacopy(/* Real    */ ae_matrix* a,
     ae_int_t m,
     ae_int_t n,
     /* Real    */ ae_matrix* b,
     ae_state *_state);
static void testortfacunit_cmatrixmakeacopy(/* Complex */ ae_matrix* a,
     ae_int_t m,
     ae_int_t n,
     /* Complex */ ae_matrix* b,
     ae_state *_state);
static void testortfacunit_rmatrixfillsparsea(/* Real    */ ae_matrix* a,
     ae_int_t m,
     ae_int_t n,
     double sparcity,
     ae_state *_state);
static void testortfacunit_cmatrixfillsparsea(/* Complex */ ae_matrix* a,
     ae_int_t m,
     ae_int_t n,
     double sparcity,
     ae_state *_state);
static void testortfacunit_internalmatrixmatrixmultiply(/* Real    */ ae_matrix* a,
     ae_int_t ai1,
     ae_int_t ai2,
     ae_int_t aj1,
     ae_int_t aj2,
     ae_bool transa,
     /* Real    */ ae_matrix* b,
     ae_int_t bi1,
     ae_int_t bi2,
     ae_int_t bj1,
     ae_int_t bj2,
     ae_bool transb,
     /* Real    */ ae_matrix* c,
     ae_int_t ci1,
     ae_int_t ci2,
     ae_int_t cj1,
     ae_int_t cj2,
     ae_state *_state);
static void testortfacunit_testrqrproblem(/* Real    */ ae_matrix* a,
     ae_int_t m,
     ae_int_t n,
     double threshold,
     ae_bool* qrerrors,
     ae_state *_state);
static void testortfacunit_testcqrproblem(/* Complex */ ae_matrix* a,
     ae_int_t m,
     ae_int_t n,
     double threshold,
     ae_bool* qrerrors,
     ae_state *_state);
static void testortfacunit_testrlqproblem(/* Real    */ ae_matrix* a,
     ae_int_t m,
     ae_int_t n,
     double threshold,
     ae_bool* lqerrors,
     ae_state *_state);
static void testortfacunit_testclqproblem(/* Complex */ ae_matrix* a,
     ae_int_t m,
     ae_int_t n,
     double threshold,
     ae_bool* lqerrors,
     ae_state *_state);
static void testortfacunit_testrbdproblem(/* Real    */ ae_matrix* a,
     ae_int_t m,
     ae_int_t n,
     double threshold,
     ae_bool* bderrors,
     ae_state *_state);
static void testortfacunit_testrhessproblem(/* Real    */ ae_matrix* a,
     ae_int_t n,
     double threshold,
     ae_bool* hesserrors,
     ae_state *_state);
static void testortfacunit_testrtdproblem(/* Real    */ ae_matrix* a,
     ae_int_t n,
     double threshold,
     ae_bool* tderrors,
     ae_state *_state);
static void testortfacunit_testctdproblem(/* Complex */ ae_matrix* a,
     ae_int_t n,
     double threshold,
     ae_bool* tderrors,
     ae_state *_state);





/*************************************************************************
Main unittest subroutine
*************************************************************************/
ae_bool testortfac(ae_bool silent, ae_state *_state)
{
    ae_frame _frame_block;
    ae_int_t maxmn;
    double threshold;
    ae_int_t passcount;
    ae_int_t mx;
    ae_matrix ra;
    ae_matrix ca;
    ae_int_t m;
    ae_int_t n;
    ae_int_t pass;
    ae_int_t i;
    ae_int_t j;
    ae_bool rqrerrors;
    ae_bool rlqerrors;
    ae_bool cqrerrors;
    ae_bool clqerrors;
    ae_bool rbderrors;
    ae_bool rhesserrors;
    ae_bool rtderrors;
    ae_bool ctderrors;
    ae_bool waserrors;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    ae_matrix_init(&ra, 0, 0, DT_REAL, _state);
    ae_matrix_init(&ca, 0, 0, DT_COMPLEX, _state);

    waserrors = ae_false;
    rqrerrors = ae_false;
    rlqerrors = ae_false;
    cqrerrors = ae_false;
    clqerrors = ae_false;
    rbderrors = ae_false;
    rhesserrors = ae_false;
    rtderrors = ae_false;
    ctderrors = ae_false;
    maxmn = 3*ablasblocksize(&ra, _state)+1;
    passcount = 1;
    threshold = 5*1000*ae_machineepsilon;
    
    /*
     * Different problems
     */
    for(mx=1; mx<=maxmn; mx++)
    {
        for(pass=1; pass<=passcount; pass++)
        {
            
            /*
             * Rectangular factorizations: QR, LQ, bidiagonal
             * Matrix types: zero, dense, sparse
             */
            n = 1+ae_randominteger(mx, _state);
            m = 1+ae_randominteger(mx, _state);
            if( ae_fp_greater(ae_randomreal(_state),0.5) )
            {
                n = mx;
            }
            else
            {
                m = mx;
            }
            ae_matrix_set_length(&ra, m, n, _state);
            ae_matrix_set_length(&ca, m, n, _state);
            for(i=0; i<=m-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    ra.ptr.pp_double[i][j] = (double)(0);
                    ca.ptr.pp_complex[i][j] = ae_complex_from_i(0);
                }
            }
            testortfacunit_testrqrproblem(&ra, m, n, threshold, &rqrerrors, _state);
            testortfacunit_testrlqproblem(&ra, m, n, threshold, &rlqerrors, _state);
            testortfacunit_testcqrproblem(&ca, m, n, threshold, &cqrerrors, _state);
            testortfacunit_testclqproblem(&ca, m, n, threshold, &clqerrors, _state);
            testortfacunit_testrbdproblem(&ra, m, n, threshold, &rbderrors, _state);
            for(i=0; i<=m-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    ra.ptr.pp_double[i][j] = 2*ae_randomreal(_state)-1;
                    ca.ptr.pp_complex[i][j].x = 2*ae_randomreal(_state)-1;
                    ca.ptr.pp_complex[i][j].y = 2*ae_randomreal(_state)-1;
                }
            }
            testortfacunit_testrqrproblem(&ra, m, n, threshold, &rqrerrors, _state);
            testortfacunit_testrlqproblem(&ra, m, n, threshold, &rlqerrors, _state);
            testortfacunit_testcqrproblem(&ca, m, n, threshold, &cqrerrors, _state);
            testortfacunit_testclqproblem(&ca, m, n, threshold, &clqerrors, _state);
            testortfacunit_testrbdproblem(&ra, m, n, threshold, &rbderrors, _state);
            testortfacunit_rmatrixfillsparsea(&ra, m, n, 0.95, _state);
            testortfacunit_cmatrixfillsparsea(&ca, m, n, 0.95, _state);
            testortfacunit_testrqrproblem(&ra, m, n, threshold, &rqrerrors, _state);
            testortfacunit_testrlqproblem(&ra, m, n, threshold, &rlqerrors, _state);
            testortfacunit_testcqrproblem(&ca, m, n, threshold, &cqrerrors, _state);
            testortfacunit_testclqproblem(&ca, m, n, threshold, &clqerrors, _state);
            testortfacunit_testrbdproblem(&ra, m, n, threshold, &rbderrors, _state);
            
            /*
             * Square factorizations: Hessenberg, tridiagonal
             * Matrix types: zero, dense, sparse
             */
            ae_matrix_set_length(&ra, mx, mx, _state);
            ae_matrix_set_length(&ca, mx, mx, _state);
            for(i=0; i<=mx-1; i++)
            {
                for(j=0; j<=mx-1; j++)
                {
                    ra.ptr.pp_double[i][j] = (double)(0);
                    ca.ptr.pp_complex[i][j] = ae_complex_from_i(0);
                }
            }
            testortfacunit_testrhessproblem(&ra, mx, threshold, &rhesserrors, _state);
            for(i=0; i<=mx-1; i++)
            {
                for(j=0; j<=mx-1; j++)
                {
                    ra.ptr.pp_double[i][j] = 2*ae_randomreal(_state)-1;
                    ca.ptr.pp_complex[i][j].x = 2*ae_randomreal(_state)-1;
                    ca.ptr.pp_complex[i][j].y = 2*ae_randomreal(_state)-1;
                }
            }
            testortfacunit_testrhessproblem(&ra, mx, threshold, &rhesserrors, _state);
            testortfacunit_rmatrixfillsparsea(&ra, mx, mx, 0.95, _state);
            testortfacunit_cmatrixfillsparsea(&ca, mx, mx, 0.95, _state);
            testortfacunit_testrhessproblem(&ra, mx, threshold, &rhesserrors, _state);
            
            /*
             * Symetric factorizations: tridiagonal
             * Matrix types: zero, dense, sparse
             */
            ae_matrix_set_length(&ra, mx, mx, _state);
            ae_matrix_set_length(&ca, mx, mx, _state);
            for(i=0; i<=mx-1; i++)
            {
                for(j=0; j<=mx-1; j++)
                {
                    ra.ptr.pp_double[i][j] = (double)(0);
                    ca.ptr.pp_complex[i][j] = ae_complex_from_i(0);
                }
            }
            testortfacunit_testrtdproblem(&ra, mx, threshold, &rtderrors, _state);
            testortfacunit_testctdproblem(&ca, mx, threshold, &ctderrors, _state);
            for(i=0; i<=mx-1; i++)
            {
                for(j=i; j<=mx-1; j++)
                {
                    ra.ptr.pp_double[i][j] = 2*ae_randomreal(_state)-1;
                    ca.ptr.pp_complex[i][j].x = 2*ae_randomreal(_state)-1;
                    ca.ptr.pp_complex[i][j].y = 2*ae_randomreal(_state)-1;
                    ra.ptr.pp_double[j][i] = ra.ptr.pp_double[i][j];
                    ca.ptr.pp_complex[j][i] = ae_c_conj(ca.ptr.pp_complex[i][j], _state);
                }
            }
            for(i=0; i<=mx-1; i++)
            {
                ca.ptr.pp_complex[i][i] = ae_complex_from_d(2*ae_randomreal(_state)-1);
            }
            testortfacunit_testrtdproblem(&ra, mx, threshold, &rtderrors, _state);
            testortfacunit_testctdproblem(&ca, mx, threshold, &ctderrors, _state);
            testortfacunit_rmatrixfillsparsea(&ra, mx, mx, 0.95, _state);
            testortfacunit_cmatrixfillsparsea(&ca, mx, mx, 0.95, _state);
            for(i=0; i<=mx-1; i++)
            {
                for(j=i; j<=mx-1; j++)
                {
                    ra.ptr.pp_double[j][i] = ra.ptr.pp_double[i][j];
                    ca.ptr.pp_complex[j][i] = ae_c_conj(ca.ptr.pp_complex[i][j], _state);
                }
            }
            for(i=0; i<=mx-1; i++)
            {
                ca.ptr.pp_complex[i][i] = ae_complex_from_d(2*ae_randomreal(_state)-1);
            }
            testortfacunit_testrtdproblem(&ra, mx, threshold, &rtderrors, _state);
            testortfacunit_testctdproblem(&ca, mx, threshold, &ctderrors, _state);
        }
    }
    
    /*
     * report
     */
    waserrors = ((((((rqrerrors||rlqerrors)||cqrerrors)||clqerrors)||rbderrors)||rhesserrors)||rtderrors)||ctderrors;
    if( !silent )
    {
        printf("TESTING ORTFAC UNIT\n");
        printf("RQR ERRORS:                              ");
        if( !rqrerrors )
        {
            printf("OK\n");
        }
        else
        {
            printf("FAILED\n");
        }
        printf("RLQ ERRORS:                              ");
        if( !rlqerrors )
        {
            printf("OK\n");
        }
        else
        {
            printf("FAILED\n");
        }
        printf("CQR ERRORS:                              ");
        if( !cqrerrors )
        {
            printf("OK\n");
        }
        else
        {
            printf("FAILED\n");
        }
        printf("CLQ ERRORS:                              ");
        if( !clqerrors )
        {
            printf("OK\n");
        }
        else
        {
            printf("FAILED\n");
        }
        printf("RBD ERRORS:                              ");
        if( !rbderrors )
        {
            printf("OK\n");
        }
        else
        {
            printf("FAILED\n");
        }
        printf("RHESS ERRORS:                            ");
        if( !rhesserrors )
        {
            printf("OK\n");
        }
        else
        {
            printf("FAILED\n");
        }
        printf("RTD ERRORS:                              ");
        if( !rtderrors )
        {
            printf("OK\n");
        }
        else
        {
            printf("FAILED\n");
        }
        printf("CTD ERRORS:                              ");
        if( !ctderrors )
        {
            printf("OK\n");
        }
        else
        {
            printf("FAILED\n");
        }
        if( waserrors )
        {
            printf("TEST FAILED\n");
        }
        else
        {
            printf("TEST PASSED\n");
        }
        printf("\n\n");
    }
    result = !waserrors;
    ae_frame_leave(_state);
    return result;
}


/*************************************************************************
Single-threaded stub. HPC ALGLIB replaces it by multithreaded code.
*************************************************************************/
ae_bool _pexec_testortfac(ae_bool silent, ae_state *_state)
{
    return testortfac(silent, _state);
}


/*************************************************************************
Diff
*************************************************************************/
static double testortfacunit_rmatrixdiff(/* Real    */ ae_matrix* a,
     /* Real    */ ae_matrix* b,
     ae_int_t m,
     ae_int_t n,
     ae_state *_state)
{
    ae_int_t i;
    ae_int_t j;
    double result;


    result = (double)(0);
    for(i=0; i<=m-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            result = ae_maxreal(result, ae_fabs(b->ptr.pp_double[i][j]-a->ptr.pp_double[i][j], _state), _state);
        }
    }
    return result;
}


/*************************************************************************
Copy
*************************************************************************/
static void testortfacunit_rmatrixmakeacopy(/* Real    */ ae_matrix* a,
     ae_int_t m,
     ae_int_t n,
     /* Real    */ ae_matrix* b,
     ae_state *_state)
{
    ae_int_t i;
    ae_int_t j;

    ae_matrix_clear(b);

    ae_matrix_set_length(b, m-1+1, n-1+1, _state);
    for(i=0; i<=m-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            b->ptr.pp_double[i][j] = a->ptr.pp_double[i][j];
        }
    }
}


/*************************************************************************
Copy
*************************************************************************/
static void testortfacunit_cmatrixmakeacopy(/* Complex */ ae_matrix* a,
     ae_int_t m,
     ae_int_t n,
     /* Complex */ ae_matrix* b,
     ae_state *_state)
{
    ae_int_t i;
    ae_int_t j;

    ae_matrix_clear(b);

    ae_matrix_set_length(b, m-1+1, n-1+1, _state);
    for(i=0; i<=m-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            b->ptr.pp_complex[i][j] = a->ptr.pp_complex[i][j];
        }
    }
}


/*************************************************************************
Sparse fill
*************************************************************************/
static void testortfacunit_rmatrixfillsparsea(/* Real    */ ae_matrix* a,
     ae_int_t m,
     ae_int_t n,
     double sparcity,
     ae_state *_state)
{
    ae_int_t i;
    ae_int_t j;


    for(i=0; i<=m-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            if( ae_fp_greater_eq(ae_randomreal(_state),sparcity) )
            {
                a->ptr.pp_double[i][j] = 2*ae_randomreal(_state)-1;
            }
            else
            {
                a->ptr.pp_double[i][j] = (double)(0);
            }
        }
    }
}


/*************************************************************************
Sparse fill
*************************************************************************/
static void testortfacunit_cmatrixfillsparsea(/* Complex */ ae_matrix* a,
     ae_int_t m,
     ae_int_t n,
     double sparcity,
     ae_state *_state)
{
    ae_int_t i;
    ae_int_t j;


    for(i=0; i<=m-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            if( ae_fp_greater_eq(ae_randomreal(_state),sparcity) )
            {
                a->ptr.pp_complex[i][j].x = 2*ae_randomreal(_state)-1;
                a->ptr.pp_complex[i][j].y = 2*ae_randomreal(_state)-1;
            }
            else
            {
                a->ptr.pp_complex[i][j] = ae_complex_from_i(0);
            }
        }
    }
}


/*************************************************************************
Matrix multiplication
*************************************************************************/
static void testortfacunit_internalmatrixmatrixmultiply(/* Real    */ ae_matrix* a,
     ae_int_t ai1,
     ae_int_t ai2,
     ae_int_t aj1,
     ae_int_t aj2,
     ae_bool transa,
     /* Real    */ ae_matrix* b,
     ae_int_t bi1,
     ae_int_t bi2,
     ae_int_t bj1,
     ae_int_t bj2,
     ae_bool transb,
     /* Real    */ ae_matrix* c,
     ae_int_t ci1,
     ae_int_t ci2,
     ae_int_t cj1,
     ae_int_t cj2,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_int_t arows;
    ae_int_t acols;
    ae_int_t brows;
    ae_int_t bcols;
    ae_int_t crows;
    ae_int_t ccols;
    ae_int_t i;
    ae_int_t j;
    ae_int_t k;
    ae_int_t l;
    ae_int_t r;
    double v;
    ae_vector work;
    double beta;
    double alpha;

    ae_frame_make(_state, &_frame_block);
    ae_vector_init(&work, 0, DT_REAL, _state);

    
    /*
     * Pre-setup
     */
    k = ae_maxint(ai2-ai1+1, aj2-aj1+1, _state);
    k = ae_maxint(k, bi2-bi1+1, _state);
    k = ae_maxint(k, bj2-bj1+1, _state);
    ae_vector_set_length(&work, k+1, _state);
    beta = (double)(0);
    alpha = (double)(1);
    
    /*
     * Setup
     */
    if( !transa )
    {
        arows = ai2-ai1+1;
        acols = aj2-aj1+1;
    }
    else
    {
        arows = aj2-aj1+1;
        acols = ai2-ai1+1;
    }
    if( !transb )
    {
        brows = bi2-bi1+1;
        bcols = bj2-bj1+1;
    }
    else
    {
        brows = bj2-bj1+1;
        bcols = bi2-bi1+1;
    }
    ae_assert(acols==brows, "MatrixMatrixMultiply: incorrect matrix sizes!", _state);
    if( ((arows<=0||acols<=0)||brows<=0)||bcols<=0 )
    {
        ae_frame_leave(_state);
        return;
    }
    crows = arows;
    ccols = bcols;
    
    /*
     * Test WORK
     */
    i = ae_maxint(arows, acols, _state);
    i = ae_maxint(brows, i, _state);
    i = ae_maxint(i, bcols, _state);
    work.ptr.p_double[1] = (double)(0);
    work.ptr.p_double[i] = (double)(0);
    
    /*
     * Prepare C
     */
    if( ae_fp_eq(beta,(double)(0)) )
    {
        for(i=ci1; i<=ci2; i++)
        {
            for(j=cj1; j<=cj2; j++)
            {
                c->ptr.pp_double[i][j] = (double)(0);
            }
        }
    }
    else
    {
        for(i=ci1; i<=ci2; i++)
        {
            ae_v_muld(&c->ptr.pp_double[i][cj1], 1, ae_v_len(cj1,cj2), beta);
        }
    }
    
    /*
     * A*B
     */
    if( !transa&&!transb )
    {
        for(l=ai1; l<=ai2; l++)
        {
            for(r=bi1; r<=bi2; r++)
            {
                v = alpha*a->ptr.pp_double[l][aj1+r-bi1];
                k = ci1+l-ai1;
                ae_v_addd(&c->ptr.pp_double[k][cj1], 1, &b->ptr.pp_double[r][bj1], 1, ae_v_len(cj1,cj2), v);
            }
        }
        ae_frame_leave(_state);
        return;
    }
    
    /*
     * A*B'
     */
    if( !transa&&transb )
    {
        if( arows*acols<brows*bcols )
        {
            for(r=bi1; r<=bi2; r++)
            {
                for(l=ai1; l<=ai2; l++)
                {
                    v = ae_v_dotproduct(&a->ptr.pp_double[l][aj1], 1, &b->ptr.pp_double[r][bj1], 1, ae_v_len(aj1,aj2));
                    c->ptr.pp_double[ci1+l-ai1][cj1+r-bi1] = c->ptr.pp_double[ci1+l-ai1][cj1+r-bi1]+alpha*v;
                }
            }
            ae_frame_leave(_state);
            return;
        }
        else
        {
            for(l=ai1; l<=ai2; l++)
            {
                for(r=bi1; r<=bi2; r++)
                {
                    v = ae_v_dotproduct(&a->ptr.pp_double[l][aj1], 1, &b->ptr.pp_double[r][bj1], 1, ae_v_len(aj1,aj2));
                    c->ptr.pp_double[ci1+l-ai1][cj1+r-bi1] = c->ptr.pp_double[ci1+l-ai1][cj1+r-bi1]+alpha*v;
                }
            }
            ae_frame_leave(_state);
            return;
        }
    }
    
    /*
     * A'*B
     */
    if( transa&&!transb )
    {
        for(l=aj1; l<=aj2; l++)
        {
            for(r=bi1; r<=bi2; r++)
            {
                v = alpha*a->ptr.pp_double[ai1+r-bi1][l];
                k = ci1+l-aj1;
                ae_v_addd(&c->ptr.pp_double[k][cj1], 1, &b->ptr.pp_double[r][bj1], 1, ae_v_len(cj1,cj2), v);
            }
        }
        ae_frame_leave(_state);
        return;
    }
    
    /*
     * A'*B'
     */
    if( transa&&transb )
    {
        if( arows*acols<brows*bcols )
        {
            for(r=bi1; r<=bi2; r++)
            {
                for(i=1; i<=crows; i++)
                {
                    work.ptr.p_double[i] = 0.0;
                }
                for(l=ai1; l<=ai2; l++)
                {
                    v = alpha*b->ptr.pp_double[r][bj1+l-ai1];
                    k = cj1+r-bi1;
                    ae_v_addd(&work.ptr.p_double[1], 1, &a->ptr.pp_double[l][aj1], 1, ae_v_len(1,crows), v);
                }
                ae_v_add(&c->ptr.pp_double[ci1][k], c->stride, &work.ptr.p_double[1], 1, ae_v_len(ci1,ci2));
            }
            ae_frame_leave(_state);
            return;
        }
        else
        {
            for(l=aj1; l<=aj2; l++)
            {
                k = ai2-ai1+1;
                ae_v_move(&work.ptr.p_double[1], 1, &a->ptr.pp_double[ai1][l], a->stride, ae_v_len(1,k));
                for(r=bi1; r<=bi2; r++)
                {
                    v = ae_v_dotproduct(&work.ptr.p_double[1], 1, &b->ptr.pp_double[r][bj1], 1, ae_v_len(1,k));
                    c->ptr.pp_double[ci1+l-aj1][cj1+r-bi1] = c->ptr.pp_double[ci1+l-aj1][cj1+r-bi1]+alpha*v;
                }
            }
            ae_frame_leave(_state);
            return;
        }
    }
    ae_frame_leave(_state);
}


/*************************************************************************
Problem testing
*************************************************************************/
static void testortfacunit_testrqrproblem(/* Real    */ ae_matrix* a,
     ae_int_t m,
     ae_int_t n,
     double threshold,
     ae_bool* qrerrors,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_int_t i;
    ae_int_t j;
    ae_int_t k;
    ae_matrix b;
    ae_vector taub;
    ae_matrix q;
    ae_matrix r;
    ae_matrix q2;
    double v;

    ae_frame_make(_state, &_frame_block);
    ae_matrix_init(&b, 0, 0, DT_REAL, _state);
    ae_vector_init(&taub, 0, DT_REAL, _state);
    ae_matrix_init(&q, 0, 0, DT_REAL, _state);
    ae_matrix_init(&r, 0, 0, DT_REAL, _state);
    ae_matrix_init(&q2, 0, 0, DT_REAL, _state);

    
    /*
     * Test decompose-and-unpack error
     */
    testortfacunit_rmatrixmakeacopy(a, m, n, &b, _state);
    rmatrixqr(&b, m, n, &taub, _state);
    rmatrixqrunpackq(&b, m, n, &taub, m, &q, _state);
    rmatrixqrunpackr(&b, m, n, &r, _state);
    for(i=0; i<=m-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            v = ae_v_dotproduct(&q.ptr.pp_double[i][0], 1, &r.ptr.pp_double[0][j], r.stride, ae_v_len(0,m-1));
            *qrerrors = *qrerrors||ae_fp_greater(ae_fabs(v-a->ptr.pp_double[i][j], _state),threshold);
        }
    }
    for(i=0; i<=m-1; i++)
    {
        for(j=0; j<=ae_minint(i, n-1, _state)-1; j++)
        {
            *qrerrors = *qrerrors||ae_fp_neq(r.ptr.pp_double[i][j],(double)(0));
        }
    }
    for(i=0; i<=m-1; i++)
    {
        for(j=0; j<=m-1; j++)
        {
            v = ae_v_dotproduct(&q.ptr.pp_double[i][0], 1, &q.ptr.pp_double[j][0], 1, ae_v_len(0,m-1));
            if( i==j )
            {
                v = v-1;
            }
            *qrerrors = *qrerrors||ae_fp_greater_eq(ae_fabs(v, _state),threshold);
        }
    }
    
    /*
     * Test for other errors
     */
    k = 1+ae_randominteger(m, _state);
    rmatrixqrunpackq(&b, m, n, &taub, k, &q2, _state);
    for(i=0; i<=m-1; i++)
    {
        for(j=0; j<=k-1; j++)
        {
            *qrerrors = *qrerrors||ae_fp_greater(ae_fabs(q2.ptr.pp_double[i][j]-q.ptr.pp_double[i][j], _state),10*ae_machineepsilon);
        }
    }
    ae_frame_leave(_state);
}


/*************************************************************************
Problem testing
*************************************************************************/
static void testortfacunit_testcqrproblem(/* Complex */ ae_matrix* a,
     ae_int_t m,
     ae_int_t n,
     double threshold,
     ae_bool* qrerrors,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_int_t i;
    ae_int_t j;
    ae_int_t k;
    ae_matrix b;
    ae_vector taub;
    ae_matrix q;
    ae_matrix r;
    ae_matrix q2;
    ae_complex v;

    ae_frame_make(_state, &_frame_block);
    ae_matrix_init(&b, 0, 0, DT_COMPLEX, _state);
    ae_vector_init(&taub, 0, DT_COMPLEX, _state);
    ae_matrix_init(&q, 0, 0, DT_COMPLEX, _state);
    ae_matrix_init(&r, 0, 0, DT_COMPLEX, _state);
    ae_matrix_init(&q2, 0, 0, DT_COMPLEX, _state);

    
    /*
     * Test decompose-and-unpack error
     */
    testortfacunit_cmatrixmakeacopy(a, m, n, &b, _state);
    cmatrixqr(&b, m, n, &taub, _state);
    cmatrixqrunpackq(&b, m, n, &taub, m, &q, _state);
    cmatrixqrunpackr(&b, m, n, &r, _state);
    for(i=0; i<=m-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            v = ae_v_cdotproduct(&q.ptr.pp_complex[i][0], 1, "N", &r.ptr.pp_complex[0][j], r.stride, "N", ae_v_len(0,m-1));
            *qrerrors = *qrerrors||ae_fp_greater(ae_c_abs(ae_c_sub(v,a->ptr.pp_complex[i][j]), _state),threshold);
        }
    }
    for(i=0; i<=m-1; i++)
    {
        for(j=0; j<=ae_minint(i, n-1, _state)-1; j++)
        {
            *qrerrors = *qrerrors||ae_c_neq_d(r.ptr.pp_complex[i][j],(double)(0));
        }
    }
    for(i=0; i<=m-1; i++)
    {
        for(j=0; j<=m-1; j++)
        {
            v = ae_v_cdotproduct(&q.ptr.pp_complex[i][0], 1, "N", &q.ptr.pp_complex[j][0], 1, "Conj", ae_v_len(0,m-1));
            if( i==j )
            {
                v = ae_c_sub_d(v,1);
            }
            *qrerrors = *qrerrors||ae_fp_greater_eq(ae_c_abs(v, _state),threshold);
        }
    }
    
    /*
     * Test for other errors
     */
    k = 1+ae_randominteger(m, _state);
    cmatrixqrunpackq(&b, m, n, &taub, k, &q2, _state);
    for(i=0; i<=m-1; i++)
    {
        for(j=0; j<=k-1; j++)
        {
            *qrerrors = *qrerrors||ae_fp_greater(ae_c_abs(ae_c_sub(q2.ptr.pp_complex[i][j],q.ptr.pp_complex[i][j]), _state),10*ae_machineepsilon);
        }
    }
    ae_frame_leave(_state);
}


/*************************************************************************
Problem testing
*************************************************************************/
static void testortfacunit_testrlqproblem(/* Real    */ ae_matrix* a,
     ae_int_t m,
     ae_int_t n,
     double threshold,
     ae_bool* lqerrors,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_int_t i;
    ae_int_t j;
    ae_int_t k;
    ae_matrix b;
    ae_vector taub;
    ae_matrix q;
    ae_matrix l;
    ae_matrix q2;
    double v;

    ae_frame_make(_state, &_frame_block);
    ae_matrix_init(&b, 0, 0, DT_REAL, _state);
    ae_vector_init(&taub, 0, DT_REAL, _state);
    ae_matrix_init(&q, 0, 0, DT_REAL, _state);
    ae_matrix_init(&l, 0, 0, DT_REAL, _state);
    ae_matrix_init(&q2, 0, 0, DT_REAL, _state);

    
    /*
     * Test decompose-and-unpack error
     */
    testortfacunit_rmatrixmakeacopy(a, m, n, &b, _state);
    rmatrixlq(&b, m, n, &taub, _state);
    rmatrixlqunpackq(&b, m, n, &taub, n, &q, _state);
    rmatrixlqunpackl(&b, m, n, &l, _state);
    for(i=0; i<=m-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            v = ae_v_dotproduct(&l.ptr.pp_double[i][0], 1, &q.ptr.pp_double[0][j], q.stride, ae_v_len(0,n-1));
            *lqerrors = *lqerrors||ae_fp_greater_eq(ae_fabs(v-a->ptr.pp_double[i][j], _state),threshold);
        }
    }
    for(i=0; i<=m-1; i++)
    {
        for(j=ae_minint(i, n-1, _state)+1; j<=n-1; j++)
        {
            *lqerrors = *lqerrors||ae_fp_neq(l.ptr.pp_double[i][j],(double)(0));
        }
    }
    for(i=0; i<=n-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            v = ae_v_dotproduct(&q.ptr.pp_double[i][0], 1, &q.ptr.pp_double[j][0], 1, ae_v_len(0,n-1));
            if( i==j )
            {
                v = v-1;
            }
            *lqerrors = *lqerrors||ae_fp_greater_eq(ae_fabs(v, _state),threshold);
        }
    }
    
    /*
     * Test for other errors
     */
    k = 1+ae_randominteger(n, _state);
    rmatrixlqunpackq(&b, m, n, &taub, k, &q2, _state);
    for(i=0; i<=k-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            *lqerrors = *lqerrors||ae_fp_greater(ae_fabs(q2.ptr.pp_double[i][j]-q.ptr.pp_double[i][j], _state),10*ae_machineepsilon);
        }
    }
    ae_frame_leave(_state);
}


/*************************************************************************
Problem testing
*************************************************************************/
static void testortfacunit_testclqproblem(/* Complex */ ae_matrix* a,
     ae_int_t m,
     ae_int_t n,
     double threshold,
     ae_bool* lqerrors,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_int_t i;
    ae_int_t j;
    ae_int_t k;
    ae_matrix b;
    ae_vector taub;
    ae_matrix q;
    ae_matrix l;
    ae_matrix q2;
    ae_complex v;

    ae_frame_make(_state, &_frame_block);
    ae_matrix_init(&b, 0, 0, DT_COMPLEX, _state);
    ae_vector_init(&taub, 0, DT_COMPLEX, _state);
    ae_matrix_init(&q, 0, 0, DT_COMPLEX, _state);
    ae_matrix_init(&l, 0, 0, DT_COMPLEX, _state);
    ae_matrix_init(&q2, 0, 0, DT_COMPLEX, _state);

    
    /*
     * Test decompose-and-unpack error
     */
    testortfacunit_cmatrixmakeacopy(a, m, n, &b, _state);
    cmatrixlq(&b, m, n, &taub, _state);
    cmatrixlqunpackq(&b, m, n, &taub, n, &q, _state);
    cmatrixlqunpackl(&b, m, n, &l, _state);
    for(i=0; i<=m-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            v = ae_v_cdotproduct(&l.ptr.pp_complex[i][0], 1, "N", &q.ptr.pp_complex[0][j], q.stride, "N", ae_v_len(0,n-1));
            *lqerrors = *lqerrors||ae_fp_greater_eq(ae_c_abs(ae_c_sub(v,a->ptr.pp_complex[i][j]), _state),threshold);
        }
    }
    for(i=0; i<=m-1; i++)
    {
        for(j=ae_minint(i, n-1, _state)+1; j<=n-1; j++)
        {
            *lqerrors = *lqerrors||ae_c_neq_d(l.ptr.pp_complex[i][j],(double)(0));
        }
    }
    for(i=0; i<=n-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            v = ae_v_cdotproduct(&q.ptr.pp_complex[i][0], 1, "N", &q.ptr.pp_complex[j][0], 1, "Conj", ae_v_len(0,n-1));
            if( i==j )
            {
                v = ae_c_sub_d(v,1);
            }
            *lqerrors = *lqerrors||ae_fp_greater_eq(ae_c_abs(v, _state),threshold);
        }
    }
    
    /*
     * Test for other errors
     */
    k = 1+ae_randominteger(n, _state);
    cmatrixlqunpackq(&b, m, n, &taub, k, &q2, _state);
    for(i=0; i<=k-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            *lqerrors = *lqerrors||ae_fp_greater(ae_c_abs(ae_c_sub(q2.ptr.pp_complex[i][j],q.ptr.pp_complex[i][j]), _state),10*ae_machineepsilon);
        }
    }
    ae_frame_leave(_state);
}


/*************************************************************************
Problem testing
*************************************************************************/
static void testortfacunit_testrbdproblem(/* Real    */ ae_matrix* a,
     ae_int_t m,
     ae_int_t n,
     double threshold,
     ae_bool* bderrors,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_int_t i;
    ae_int_t j;
    ae_int_t k;
    ae_matrix t;
    ae_matrix pt;
    ae_matrix q;
    ae_matrix r;
    ae_matrix bd;
    ae_matrix x;
    ae_matrix r1;
    ae_matrix r2;
    ae_vector taup;
    ae_vector tauq;
    ae_vector d;
    ae_vector e;
    ae_bool up;
    double v;
    ae_int_t mtsize;

    ae_frame_make(_state, &_frame_block);
    ae_matrix_init(&t, 0, 0, DT_REAL, _state);
    ae_matrix_init(&pt, 0, 0, DT_REAL, _state);
    ae_matrix_init(&q, 0, 0, DT_REAL, _state);
    ae_matrix_init(&r, 0, 0, DT_REAL, _state);
    ae_matrix_init(&bd, 0, 0, DT_REAL, _state);
    ae_matrix_init(&x, 0, 0, DT_REAL, _state);
    ae_matrix_init(&r1, 0, 0, DT_REAL, _state);
    ae_matrix_init(&r2, 0, 0, DT_REAL, _state);
    ae_vector_init(&taup, 0, DT_REAL, _state);
    ae_vector_init(&tauq, 0, DT_REAL, _state);
    ae_vector_init(&d, 0, DT_REAL, _state);
    ae_vector_init(&e, 0, DT_REAL, _state);

    
    /*
     * Bidiagonal decomposition error
     */
    testortfacunit_rmatrixmakeacopy(a, m, n, &t, _state);
    rmatrixbd(&t, m, n, &tauq, &taup, _state);
    rmatrixbdunpackq(&t, m, n, &tauq, m, &q, _state);
    rmatrixbdunpackpt(&t, m, n, &taup, n, &pt, _state);
    rmatrixbdunpackdiagonals(&t, m, n, &up, &d, &e, _state);
    ae_matrix_set_length(&bd, m, n, _state);
    for(i=0; i<=m-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            bd.ptr.pp_double[i][j] = (double)(0);
        }
    }
    for(i=0; i<=ae_minint(m, n, _state)-1; i++)
    {
        bd.ptr.pp_double[i][i] = d.ptr.p_double[i];
    }
    if( up )
    {
        for(i=0; i<=ae_minint(m, n, _state)-2; i++)
        {
            bd.ptr.pp_double[i][i+1] = e.ptr.p_double[i];
        }
    }
    else
    {
        for(i=0; i<=ae_minint(m, n, _state)-2; i++)
        {
            bd.ptr.pp_double[i+1][i] = e.ptr.p_double[i];
        }
    }
    ae_matrix_set_length(&r, m, n, _state);
    for(i=0; i<=m-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            v = ae_v_dotproduct(&q.ptr.pp_double[i][0], 1, &bd.ptr.pp_double[0][j], bd.stride, ae_v_len(0,m-1));
            r.ptr.pp_double[i][j] = v;
        }
    }
    for(i=0; i<=m-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            v = ae_v_dotproduct(&r.ptr.pp_double[i][0], 1, &pt.ptr.pp_double[0][j], pt.stride, ae_v_len(0,n-1));
            *bderrors = *bderrors||ae_fp_greater(ae_fabs(v-a->ptr.pp_double[i][j], _state),threshold);
        }
    }
    
    /*
     * Orthogonality test for Q/PT
     */
    for(i=0; i<=m-1; i++)
    {
        for(j=0; j<=m-1; j++)
        {
            v = ae_v_dotproduct(&q.ptr.pp_double[0][i], q.stride, &q.ptr.pp_double[0][j], q.stride, ae_v_len(0,m-1));
            if( i==j )
            {
                *bderrors = *bderrors||ae_fp_greater(ae_fabs(v-1, _state),threshold);
            }
            else
            {
                *bderrors = *bderrors||ae_fp_greater(ae_fabs(v, _state),threshold);
            }
        }
    }
    for(i=0; i<=n-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            v = ae_v_dotproduct(&pt.ptr.pp_double[i][0], 1, &pt.ptr.pp_double[j][0], 1, ae_v_len(0,n-1));
            if( i==j )
            {
                *bderrors = *bderrors||ae_fp_greater(ae_fabs(v-1, _state),threshold);
            }
            else
            {
                *bderrors = *bderrors||ae_fp_greater(ae_fabs(v, _state),threshold);
            }
        }
    }
    
    /*
     * Partial unpacking test
     */
    k = 1+ae_randominteger(m, _state);
    rmatrixbdunpackq(&t, m, n, &tauq, k, &r, _state);
    for(i=0; i<=m-1; i++)
    {
        for(j=0; j<=k-1; j++)
        {
            *bderrors = *bderrors||ae_fp_greater(ae_fabs(r.ptr.pp_double[i][j]-q.ptr.pp_double[i][j], _state),10*ae_machineepsilon);
        }
    }
    k = 1+ae_randominteger(n, _state);
    rmatrixbdunpackpt(&t, m, n, &taup, k, &r, _state);
    for(i=0; i<=k-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            *bderrors = *bderrors||ae_fp_neq(r.ptr.pp_double[i][j]-pt.ptr.pp_double[i][j],(double)(0));
        }
    }
    
    /*
     * Multiplication test
     */
    ae_matrix_set_length(&x, ae_maxint(m, n, _state)-1+1, ae_maxint(m, n, _state)-1+1, _state);
    ae_matrix_set_length(&r, ae_maxint(m, n, _state)-1+1, ae_maxint(m, n, _state)-1+1, _state);
    ae_matrix_set_length(&r1, ae_maxint(m, n, _state)-1+1, ae_maxint(m, n, _state)-1+1, _state);
    ae_matrix_set_length(&r2, ae_maxint(m, n, _state)-1+1, ae_maxint(m, n, _state)-1+1, _state);
    for(i=0; i<=ae_maxint(m, n, _state)-1; i++)
    {
        for(j=0; j<=ae_maxint(m, n, _state)-1; j++)
        {
            x.ptr.pp_double[i][j] = 2*ae_randomreal(_state)-1;
        }
    }
    mtsize = 1+ae_randominteger(ae_maxint(m, n, _state), _state);
    testortfacunit_rmatrixmakeacopy(&x, mtsize, m, &r, _state);
    testortfacunit_internalmatrixmatrixmultiply(&r, 0, mtsize-1, 0, m-1, ae_false, &q, 0, m-1, 0, m-1, ae_false, &r1, 0, mtsize-1, 0, m-1, _state);
    testortfacunit_rmatrixmakeacopy(&x, mtsize, m, &r2, _state);
    rmatrixbdmultiplybyq(&t, m, n, &tauq, &r2, mtsize, m, ae_true, ae_false, _state);
    *bderrors = *bderrors||ae_fp_greater(testortfacunit_rmatrixdiff(&r1, &r2, mtsize, m, _state),threshold);
    testortfacunit_rmatrixmakeacopy(&x, mtsize, m, &r, _state);
    testortfacunit_internalmatrixmatrixmultiply(&r, 0, mtsize-1, 0, m-1, ae_false, &q, 0, m-1, 0, m-1, ae_true, &r1, 0, mtsize-1, 0, m-1, _state);
    testortfacunit_rmatrixmakeacopy(&x, mtsize, m, &r2, _state);
    rmatrixbdmultiplybyq(&t, m, n, &tauq, &r2, mtsize, m, ae_true, ae_true, _state);
    *bderrors = *bderrors||ae_fp_greater(testortfacunit_rmatrixdiff(&r1, &r2, mtsize, m, _state),threshold);
    testortfacunit_rmatrixmakeacopy(&x, m, mtsize, &r, _state);
    testortfacunit_internalmatrixmatrixmultiply(&q, 0, m-1, 0, m-1, ae_false, &r, 0, m-1, 0, mtsize-1, ae_false, &r1, 0, m-1, 0, mtsize-1, _state);
    testortfacunit_rmatrixmakeacopy(&x, m, mtsize, &r2, _state);
    rmatrixbdmultiplybyq(&t, m, n, &tauq, &r2, m, mtsize, ae_false, ae_false, _state);
    *bderrors = *bderrors||ae_fp_greater(testortfacunit_rmatrixdiff(&r1, &r2, m, mtsize, _state),threshold);
    testortfacunit_rmatrixmakeacopy(&x, m, mtsize, &r, _state);
    testortfacunit_internalmatrixmatrixmultiply(&q, 0, m-1, 0, m-1, ae_true, &r, 0, m-1, 0, mtsize-1, ae_false, &r1, 0, m-1, 0, mtsize-1, _state);
    testortfacunit_rmatrixmakeacopy(&x, m, mtsize, &r2, _state);
    rmatrixbdmultiplybyq(&t, m, n, &tauq, &r2, m, mtsize, ae_false, ae_true, _state);
    *bderrors = *bderrors||ae_fp_greater(testortfacunit_rmatrixdiff(&r1, &r2, m, mtsize, _state),threshold);
    testortfacunit_rmatrixmakeacopy(&x, mtsize, n, &r, _state);
    testortfacunit_internalmatrixmatrixmultiply(&r, 0, mtsize-1, 0, n-1, ae_false, &pt, 0, n-1, 0, n-1, ae_true, &r1, 0, mtsize-1, 0, n-1, _state);
    testortfacunit_rmatrixmakeacopy(&x, mtsize, n, &r2, _state);
    rmatrixbdmultiplybyp(&t, m, n, &taup, &r2, mtsize, n, ae_true, ae_false, _state);
    *bderrors = *bderrors||ae_fp_greater(testortfacunit_rmatrixdiff(&r1, &r2, mtsize, n, _state),threshold);
    testortfacunit_rmatrixmakeacopy(&x, mtsize, n, &r, _state);
    testortfacunit_internalmatrixmatrixmultiply(&r, 0, mtsize-1, 0, n-1, ae_false, &pt, 0, n-1, 0, n-1, ae_false, &r1, 0, mtsize-1, 0, n-1, _state);
    testortfacunit_rmatrixmakeacopy(&x, mtsize, n, &r2, _state);
    rmatrixbdmultiplybyp(&t, m, n, &taup, &r2, mtsize, n, ae_true, ae_true, _state);
    *bderrors = *bderrors||ae_fp_greater(testortfacunit_rmatrixdiff(&r1, &r2, mtsize, n, _state),threshold);
    testortfacunit_rmatrixmakeacopy(&x, n, mtsize, &r, _state);
    testortfacunit_internalmatrixmatrixmultiply(&pt, 0, n-1, 0, n-1, ae_true, &r, 0, n-1, 0, mtsize-1, ae_false, &r1, 0, n-1, 0, mtsize-1, _state);
    testortfacunit_rmatrixmakeacopy(&x, n, mtsize, &r2, _state);
    rmatrixbdmultiplybyp(&t, m, n, &taup, &r2, n, mtsize, ae_false, ae_false, _state);
    *bderrors = *bderrors||ae_fp_greater(testortfacunit_rmatrixdiff(&r1, &r2, n, mtsize, _state),threshold);
    testortfacunit_rmatrixmakeacopy(&x, n, mtsize, &r, _state);
    testortfacunit_internalmatrixmatrixmultiply(&pt, 0, n-1, 0, n-1, ae_false, &r, 0, n-1, 0, mtsize-1, ae_false, &r1, 0, n-1, 0, mtsize-1, _state);
    testortfacunit_rmatrixmakeacopy(&x, n, mtsize, &r2, _state);
    rmatrixbdmultiplybyp(&t, m, n, &taup, &r2, n, mtsize, ae_false, ae_true, _state);
    *bderrors = *bderrors||ae_fp_greater(testortfacunit_rmatrixdiff(&r1, &r2, n, mtsize, _state),threshold);
    ae_frame_leave(_state);
}


/*************************************************************************
Problem testing
*************************************************************************/
static void testortfacunit_testrhessproblem(/* Real    */ ae_matrix* a,
     ae_int_t n,
     double threshold,
     ae_bool* hesserrors,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_matrix b;
    ae_matrix h;
    ae_matrix q;
    ae_matrix t1;
    ae_matrix t2;
    ae_vector tau;
    ae_int_t i;
    ae_int_t j;
    double v;

    ae_frame_make(_state, &_frame_block);
    ae_matrix_init(&b, 0, 0, DT_REAL, _state);
    ae_matrix_init(&h, 0, 0, DT_REAL, _state);
    ae_matrix_init(&q, 0, 0, DT_REAL, _state);
    ae_matrix_init(&t1, 0, 0, DT_REAL, _state);
    ae_matrix_init(&t2, 0, 0, DT_REAL, _state);
    ae_vector_init(&tau, 0, DT_REAL, _state);

    testortfacunit_rmatrixmakeacopy(a, n, n, &b, _state);
    
    /*
     * Decomposition
     */
    rmatrixhessenberg(&b, n, &tau, _state);
    rmatrixhessenbergunpackq(&b, n, &tau, &q, _state);
    rmatrixhessenbergunpackh(&b, n, &h, _state);
    
    /*
     * Matrix properties
     */
    for(i=0; i<=n-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            v = ae_v_dotproduct(&q.ptr.pp_double[0][i], q.stride, &q.ptr.pp_double[0][j], q.stride, ae_v_len(0,n-1));
            if( i==j )
            {
                v = v-1;
            }
            *hesserrors = *hesserrors||ae_fp_greater(ae_fabs(v, _state),threshold);
        }
    }
    for(i=0; i<=n-1; i++)
    {
        for(j=0; j<=i-2; j++)
        {
            *hesserrors = *hesserrors||ae_fp_neq(h.ptr.pp_double[i][j],(double)(0));
        }
    }
    
    /*
     * Decomposition error
     */
    ae_matrix_set_length(&t1, n, n, _state);
    ae_matrix_set_length(&t2, n, n, _state);
    testortfacunit_internalmatrixmatrixmultiply(&q, 0, n-1, 0, n-1, ae_false, &h, 0, n-1, 0, n-1, ae_false, &t1, 0, n-1, 0, n-1, _state);
    testortfacunit_internalmatrixmatrixmultiply(&t1, 0, n-1, 0, n-1, ae_false, &q, 0, n-1, 0, n-1, ae_true, &t2, 0, n-1, 0, n-1, _state);
    *hesserrors = *hesserrors||ae_fp_greater(testortfacunit_rmatrixdiff(&t2, a, n, n, _state),threshold);
    ae_frame_leave(_state);
}


/*************************************************************************
Tridiagonal tester
*************************************************************************/
static void testortfacunit_testrtdproblem(/* Real    */ ae_matrix* a,
     ae_int_t n,
     double threshold,
     ae_bool* tderrors,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_int_t i;
    ae_int_t j;
    ae_matrix ua;
    ae_matrix la;
    ae_matrix t;
    ae_matrix q;
    ae_matrix t2;
    ae_matrix t3;
    ae_vector tau;
    ae_vector d;
    ae_vector e;
    double v;

    ae_frame_make(_state, &_frame_block);
    ae_matrix_init(&ua, 0, 0, DT_REAL, _state);
    ae_matrix_init(&la, 0, 0, DT_REAL, _state);
    ae_matrix_init(&t, 0, 0, DT_REAL, _state);
    ae_matrix_init(&q, 0, 0, DT_REAL, _state);
    ae_matrix_init(&t2, 0, 0, DT_REAL, _state);
    ae_matrix_init(&t3, 0, 0, DT_REAL, _state);
    ae_vector_init(&tau, 0, DT_REAL, _state);
    ae_vector_init(&d, 0, DT_REAL, _state);
    ae_vector_init(&e, 0, DT_REAL, _state);

    ae_matrix_set_length(&ua, n-1+1, n-1+1, _state);
    ae_matrix_set_length(&la, n-1+1, n-1+1, _state);
    ae_matrix_set_length(&t, n-1+1, n-1+1, _state);
    ae_matrix_set_length(&q, n-1+1, n-1+1, _state);
    ae_matrix_set_length(&t2, n-1+1, n-1+1, _state);
    ae_matrix_set_length(&t3, n-1+1, n-1+1, _state);
    
    /*
     * fill
     */
    for(i=0; i<=n-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            ua.ptr.pp_double[i][j] = (double)(0);
        }
    }
    for(i=0; i<=n-1; i++)
    {
        for(j=i; j<=n-1; j++)
        {
            ua.ptr.pp_double[i][j] = a->ptr.pp_double[i][j];
        }
    }
    for(i=0; i<=n-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            la.ptr.pp_double[i][j] = (double)(0);
        }
    }
    for(i=0; i<=n-1; i++)
    {
        for(j=0; j<=i; j++)
        {
            la.ptr.pp_double[i][j] = a->ptr.pp_double[i][j];
        }
    }
    
    /*
     * Test 2tridiagonal: upper
     */
    smatrixtd(&ua, n, ae_true, &tau, &d, &e, _state);
    smatrixtdunpackq(&ua, n, ae_true, &tau, &q, _state);
    for(i=0; i<=n-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            t.ptr.pp_double[i][j] = (double)(0);
        }
    }
    for(i=0; i<=n-1; i++)
    {
        t.ptr.pp_double[i][i] = d.ptr.p_double[i];
    }
    for(i=0; i<=n-2; i++)
    {
        t.ptr.pp_double[i][i+1] = e.ptr.p_double[i];
        t.ptr.pp_double[i+1][i] = e.ptr.p_double[i];
    }
    for(i=0; i<=n-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            v = ae_v_dotproduct(&q.ptr.pp_double[0][i], q.stride, &a->ptr.pp_double[0][j], a->stride, ae_v_len(0,n-1));
            t2.ptr.pp_double[i][j] = v;
        }
    }
    for(i=0; i<=n-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            v = ae_v_dotproduct(&t2.ptr.pp_double[i][0], 1, &q.ptr.pp_double[0][j], q.stride, ae_v_len(0,n-1));
            t3.ptr.pp_double[i][j] = v;
        }
    }
    for(i=0; i<=n-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            *tderrors = *tderrors||ae_fp_greater(ae_fabs(t3.ptr.pp_double[i][j]-t.ptr.pp_double[i][j], _state),threshold);
        }
    }
    for(i=0; i<=n-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            v = ae_v_dotproduct(&q.ptr.pp_double[i][0], 1, &q.ptr.pp_double[j][0], 1, ae_v_len(0,n-1));
            if( i==j )
            {
                v = v-1;
            }
            *tderrors = *tderrors||ae_fp_greater(ae_fabs(v, _state),threshold);
        }
    }
    
    /*
     * Test 2tridiagonal: lower
     */
    smatrixtd(&la, n, ae_false, &tau, &d, &e, _state);
    smatrixtdunpackq(&la, n, ae_false, &tau, &q, _state);
    for(i=0; i<=n-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            t.ptr.pp_double[i][j] = (double)(0);
        }
    }
    for(i=0; i<=n-1; i++)
    {
        t.ptr.pp_double[i][i] = d.ptr.p_double[i];
    }
    for(i=0; i<=n-2; i++)
    {
        t.ptr.pp_double[i][i+1] = e.ptr.p_double[i];
        t.ptr.pp_double[i+1][i] = e.ptr.p_double[i];
    }
    for(i=0; i<=n-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            v = ae_v_dotproduct(&q.ptr.pp_double[0][i], q.stride, &a->ptr.pp_double[0][j], a->stride, ae_v_len(0,n-1));
            t2.ptr.pp_double[i][j] = v;
        }
    }
    for(i=0; i<=n-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            v = ae_v_dotproduct(&t2.ptr.pp_double[i][0], 1, &q.ptr.pp_double[0][j], q.stride, ae_v_len(0,n-1));
            t3.ptr.pp_double[i][j] = v;
        }
    }
    for(i=0; i<=n-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            *tderrors = *tderrors||ae_fp_greater(ae_fabs(t3.ptr.pp_double[i][j]-t.ptr.pp_double[i][j], _state),threshold);
        }
    }
    for(i=0; i<=n-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            v = ae_v_dotproduct(&q.ptr.pp_double[i][0], 1, &q.ptr.pp_double[j][0], 1, ae_v_len(0,n-1));
            if( i==j )
            {
                v = v-1;
            }
            *tderrors = *tderrors||ae_fp_greater(ae_fabs(v, _state),threshold);
        }
    }
    ae_frame_leave(_state);
}


/*************************************************************************
Hermitian problem tester
*************************************************************************/
static void testortfacunit_testctdproblem(/* Complex */ ae_matrix* a,
     ae_int_t n,
     double threshold,
     ae_bool* tderrors,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_int_t i;
    ae_int_t j;
    ae_matrix ua;
    ae_matrix la;
    ae_matrix t;
    ae_matrix q;
    ae_matrix t2;
    ae_matrix t3;
    ae_vector tau;
    ae_vector d;
    ae_vector e;
    ae_complex v;

    ae_frame_make(_state, &_frame_block);
    ae_matrix_init(&ua, 0, 0, DT_COMPLEX, _state);
    ae_matrix_init(&la, 0, 0, DT_COMPLEX, _state);
    ae_matrix_init(&t, 0, 0, DT_COMPLEX, _state);
    ae_matrix_init(&q, 0, 0, DT_COMPLEX, _state);
    ae_matrix_init(&t2, 0, 0, DT_COMPLEX, _state);
    ae_matrix_init(&t3, 0, 0, DT_COMPLEX, _state);
    ae_vector_init(&tau, 0, DT_COMPLEX, _state);
    ae_vector_init(&d, 0, DT_REAL, _state);
    ae_vector_init(&e, 0, DT_REAL, _state);

    ae_matrix_set_length(&ua, n-1+1, n-1+1, _state);
    ae_matrix_set_length(&la, n-1+1, n-1+1, _state);
    ae_matrix_set_length(&t, n-1+1, n-1+1, _state);
    ae_matrix_set_length(&q, n-1+1, n-1+1, _state);
    ae_matrix_set_length(&t2, n-1+1, n-1+1, _state);
    ae_matrix_set_length(&t3, n-1+1, n-1+1, _state);
    
    /*
     * fill
     */
    for(i=0; i<=n-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            ua.ptr.pp_complex[i][j] = ae_complex_from_i(0);
        }
    }
    for(i=0; i<=n-1; i++)
    {
        for(j=i; j<=n-1; j++)
        {
            ua.ptr.pp_complex[i][j] = a->ptr.pp_complex[i][j];
        }
    }
    for(i=0; i<=n-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            la.ptr.pp_complex[i][j] = ae_complex_from_i(0);
        }
    }
    for(i=0; i<=n-1; i++)
    {
        for(j=0; j<=i; j++)
        {
            la.ptr.pp_complex[i][j] = a->ptr.pp_complex[i][j];
        }
    }
    
    /*
     * Test 2tridiagonal: upper
     */
    hmatrixtd(&ua, n, ae_true, &tau, &d, &e, _state);
    hmatrixtdunpackq(&ua, n, ae_true, &tau, &q, _state);
    for(i=0; i<=n-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            t.ptr.pp_complex[i][j] = ae_complex_from_i(0);
        }
    }
    for(i=0; i<=n-1; i++)
    {
        t.ptr.pp_complex[i][i] = ae_complex_from_d(d.ptr.p_double[i]);
    }
    for(i=0; i<=n-2; i++)
    {
        t.ptr.pp_complex[i][i+1] = ae_complex_from_d(e.ptr.p_double[i]);
        t.ptr.pp_complex[i+1][i] = ae_complex_from_d(e.ptr.p_double[i]);
    }
    for(i=0; i<=n-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            v = ae_v_cdotproduct(&q.ptr.pp_complex[0][i], q.stride, "Conj", &a->ptr.pp_complex[0][j], a->stride, "N", ae_v_len(0,n-1));
            t2.ptr.pp_complex[i][j] = v;
        }
    }
    for(i=0; i<=n-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            v = ae_v_cdotproduct(&t2.ptr.pp_complex[i][0], 1, "N", &q.ptr.pp_complex[0][j], q.stride, "N", ae_v_len(0,n-1));
            t3.ptr.pp_complex[i][j] = v;
        }
    }
    for(i=0; i<=n-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            *tderrors = *tderrors||ae_fp_greater(ae_c_abs(ae_c_sub(t3.ptr.pp_complex[i][j],t.ptr.pp_complex[i][j]), _state),threshold);
        }
    }
    for(i=0; i<=n-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            v = ae_v_cdotproduct(&q.ptr.pp_complex[i][0], 1, "N", &q.ptr.pp_complex[j][0], 1, "Conj", ae_v_len(0,n-1));
            if( i==j )
            {
                v = ae_c_sub_d(v,1);
            }
            *tderrors = *tderrors||ae_fp_greater(ae_c_abs(v, _state),threshold);
        }
    }
    
    /*
     * Test 2tridiagonal: lower
     */
    hmatrixtd(&la, n, ae_false, &tau, &d, &e, _state);
    hmatrixtdunpackq(&la, n, ae_false, &tau, &q, _state);
    for(i=0; i<=n-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            t.ptr.pp_complex[i][j] = ae_complex_from_i(0);
        }
    }
    for(i=0; i<=n-1; i++)
    {
        t.ptr.pp_complex[i][i] = ae_complex_from_d(d.ptr.p_double[i]);
    }
    for(i=0; i<=n-2; i++)
    {
        t.ptr.pp_complex[i][i+1] = ae_complex_from_d(e.ptr.p_double[i]);
        t.ptr.pp_complex[i+1][i] = ae_complex_from_d(e.ptr.p_double[i]);
    }
    for(i=0; i<=n-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            v = ae_v_cdotproduct(&q.ptr.pp_complex[0][i], q.stride, "Conj", &a->ptr.pp_complex[0][j], a->stride, "N", ae_v_len(0,n-1));
            t2.ptr.pp_complex[i][j] = v;
        }
    }
    for(i=0; i<=n-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            v = ae_v_cdotproduct(&t2.ptr.pp_complex[i][0], 1, "N", &q.ptr.pp_complex[0][j], q.stride, "N", ae_v_len(0,n-1));
            t3.ptr.pp_complex[i][j] = v;
        }
    }
    for(i=0; i<=n-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            *tderrors = *tderrors||ae_fp_greater(ae_c_abs(ae_c_sub(t3.ptr.pp_complex[i][j],t.ptr.pp_complex[i][j]), _state),threshold);
        }
    }
    for(i=0; i<=n-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            v = ae_v_cdotproduct(&q.ptr.pp_complex[i][0], 1, "N", &q.ptr.pp_complex[j][0], 1, "Conj", ae_v_len(0,n-1));
            if( i==j )
            {
                v = ae_c_sub_d(v,1);
            }
            *tderrors = *tderrors||ae_fp_greater(ae_c_abs(v, _state),threshold);
        }
    }
    ae_frame_leave(_state);
}



static void testbdsvdunit_fillidentity(/* Real    */ ae_matrix* a,
     ae_int_t n,
     ae_state *_state);
static void testbdsvdunit_fillsparsede(/* Real    */ ae_vector* d,
     /* Real    */ ae_vector* e,
     ae_int_t n,
     double sparcity,
     ae_state *_state);
static void testbdsvdunit_getbdsvderror(/* Real    */ ae_vector* d,
     /* Real    */ ae_vector* e,
     ae_int_t n,
     ae_bool isupper,
     /* Real    */ ae_matrix* u,
     /* Real    */ ae_matrix* c,
     /* Real    */ ae_vector* w,
     /* Real    */ ae_matrix* vt,
     double* materr,
     double* orterr,
     ae_bool* wsorted,
     ae_state *_state);
static void testbdsvdunit_checksvdmultiplication(/* Real    */ ae_vector* d,
     /* Real    */ ae_vector* e,
     ae_int_t n,
     ae_bool isupper,
     /* Real    */ ae_matrix* u,
     /* Real    */ ae_matrix* c,
     /* Real    */ ae_vector* w,
     /* Real    */ ae_matrix* vt,
     double* err,
     ae_state *_state);
static void testbdsvdunit_testbdsvdproblem(/* Real    */ ae_vector* d,
     /* Real    */ ae_vector* e,
     ae_int_t n,
     double* materr,
     double* orterr,
     ae_bool* wsorted,
     ae_bool* wfailed,
     ae_int_t* failcount,
     ae_int_t* succcount,
     ae_state *_state);





/*************************************************************************
Testing bidiagonal SVD decomposition subroutine
*************************************************************************/
ae_bool testbdsvd(ae_bool silent, ae_state *_state)
{
    ae_frame _frame_block;
    ae_vector d;
    ae_vector e;
    ae_matrix mempty;
    ae_int_t n;
    ae_int_t maxn;
    ae_int_t i;
    ae_int_t pass;
    ae_bool waserrors;
    ae_bool wsorted;
    ae_bool wfailed;
    double materr;
    double orterr;
    double threshold;
    double failr;
    ae_int_t failcount;
    ae_int_t succcount;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    ae_vector_init(&d, 0, DT_REAL, _state);
    ae_vector_init(&e, 0, DT_REAL, _state);
    ae_matrix_init(&mempty, 0, 0, DT_REAL, _state);

    failcount = 0;
    succcount = 0;
    materr = (double)(0);
    orterr = (double)(0);
    wsorted = ae_true;
    wfailed = ae_false;
    waserrors = ae_false;
    maxn = 15;
    threshold = 5*100*ae_machineepsilon;
    ae_vector_set_length(&d, maxn-1+1, _state);
    ae_vector_set_length(&e, maxn-2+1, _state);
    
    /*
     * special case: zero divide matrix
     * unfixed LAPACK routine should fail on this problem
     */
    n = 7;
    d.ptr.p_double[0] = -6.96462904751731892700e-01;
    d.ptr.p_double[1] = 0.00000000000000000000e+00;
    d.ptr.p_double[2] = -5.73827770385971991400e-01;
    d.ptr.p_double[3] = -6.62562624399371191700e-01;
    d.ptr.p_double[4] = 5.82737148001782223600e-01;
    d.ptr.p_double[5] = 3.84825263580925003300e-01;
    d.ptr.p_double[6] = 9.84087420830525472200e-01;
    e.ptr.p_double[0] = -7.30307931760612871800e-02;
    e.ptr.p_double[1] = -2.30079042939542843800e-01;
    e.ptr.p_double[2] = -6.87824621739351216300e-01;
    e.ptr.p_double[3] = -1.77306437707837570600e-02;
    e.ptr.p_double[4] = 1.78285126526551632000e-15;
    e.ptr.p_double[5] = -4.89434737751289969400e-02;
    rmatrixbdsvd(&d, &e, n, ae_true, ae_false, &mempty, 0, &mempty, 0, &mempty, 0, _state);
    
    /*
     * zero matrix, several cases
     */
    for(i=0; i<=maxn-1; i++)
    {
        d.ptr.p_double[i] = (double)(0);
    }
    for(i=0; i<=maxn-2; i++)
    {
        e.ptr.p_double[i] = (double)(0);
    }
    for(n=1; n<=maxn; n++)
    {
        testbdsvdunit_testbdsvdproblem(&d, &e, n, &materr, &orterr, &wsorted, &wfailed, &failcount, &succcount, _state);
    }
    
    /*
     * Dense matrix
     */
    for(n=1; n<=maxn; n++)
    {
        for(pass=1; pass<=10; pass++)
        {
            for(i=0; i<=maxn-1; i++)
            {
                d.ptr.p_double[i] = 2*ae_randomreal(_state)-1;
            }
            for(i=0; i<=maxn-2; i++)
            {
                e.ptr.p_double[i] = 2*ae_randomreal(_state)-1;
            }
            testbdsvdunit_testbdsvdproblem(&d, &e, n, &materr, &orterr, &wsorted, &wfailed, &failcount, &succcount, _state);
        }
    }
    
    /*
     * Sparse matrices, very sparse matrices, incredible sparse matrices
     */
    for(n=1; n<=maxn; n++)
    {
        for(pass=1; pass<=10; pass++)
        {
            testbdsvdunit_fillsparsede(&d, &e, n, 0.5, _state);
            testbdsvdunit_testbdsvdproblem(&d, &e, n, &materr, &orterr, &wsorted, &wfailed, &failcount, &succcount, _state);
            testbdsvdunit_fillsparsede(&d, &e, n, 0.8, _state);
            testbdsvdunit_testbdsvdproblem(&d, &e, n, &materr, &orterr, &wsorted, &wfailed, &failcount, &succcount, _state);
            testbdsvdunit_fillsparsede(&d, &e, n, 0.9, _state);
            testbdsvdunit_testbdsvdproblem(&d, &e, n, &materr, &orterr, &wsorted, &wfailed, &failcount, &succcount, _state);
            testbdsvdunit_fillsparsede(&d, &e, n, 0.95, _state);
            testbdsvdunit_testbdsvdproblem(&d, &e, n, &materr, &orterr, &wsorted, &wfailed, &failcount, &succcount, _state);
        }
    }
    
    /*
     * report
     */
    failr = (double)failcount/(double)(succcount+failcount);
    waserrors = ((wfailed||ae_fp_greater(materr,threshold))||ae_fp_greater(orterr,threshold))||!wsorted;
    if( !silent )
    {
        printf("TESTING BIDIAGONAL SVD DECOMPOSITION\n");
        printf("SVD decomposition error:                 %5.3e\n",
            (double)(materr));
        printf("SVD orthogonality error:                 %5.3e\n",
            (double)(orterr));
        printf("Singular values order:                   ");
        if( wsorted )
        {
            printf("OK\n");
        }
        else
        {
            printf("FAILED\n");
        }
        printf("Always converged:                        ");
        if( !wfailed )
        {
            printf("YES\n");
        }
        else
        {
            printf("NO\n");
            printf("Fail ratio:                              %5.3f\n",
                (double)(failr));
        }
        printf("Threshold:                               %5.3e\n",
            (double)(threshold));
        if( waserrors )
        {
            printf("TEST FAILED\n");
        }
        else
        {
            printf("TEST PASSED\n");
        }
        printf("\n\n");
    }
    result = !waserrors;
    ae_frame_leave(_state);
    return result;
}


/*************************************************************************
Single-threaded stub. HPC ALGLIB replaces it by multithreaded code.
*************************************************************************/
ae_bool _pexec_testbdsvd(ae_bool silent, ae_state *_state)
{
    return testbdsvd(silent, _state);
}


static void testbdsvdunit_fillidentity(/* Real    */ ae_matrix* a,
     ae_int_t n,
     ae_state *_state)
{
    ae_int_t i;
    ae_int_t j;


    ae_matrix_set_length(a, n-1+1, n-1+1, _state);
    for(i=0; i<=n-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            if( i==j )
            {
                a->ptr.pp_double[i][j] = (double)(1);
            }
            else
            {
                a->ptr.pp_double[i][j] = (double)(0);
            }
        }
    }
}


static void testbdsvdunit_fillsparsede(/* Real    */ ae_vector* d,
     /* Real    */ ae_vector* e,
     ae_int_t n,
     double sparcity,
     ae_state *_state)
{
    ae_int_t i;


    ae_vector_set_length(d, n-1+1, _state);
    ae_vector_set_length(e, ae_maxint(0, n-2, _state)+1, _state);
    for(i=0; i<=n-1; i++)
    {
        if( ae_fp_greater_eq(ae_randomreal(_state),sparcity) )
        {
            d->ptr.p_double[i] = 2*ae_randomreal(_state)-1;
        }
        else
        {
            d->ptr.p_double[i] = (double)(0);
        }
    }
    for(i=0; i<=n-2; i++)
    {
        if( ae_fp_greater_eq(ae_randomreal(_state),sparcity) )
        {
            e->ptr.p_double[i] = 2*ae_randomreal(_state)-1;
        }
        else
        {
            e->ptr.p_double[i] = (double)(0);
        }
    }
}


static void testbdsvdunit_getbdsvderror(/* Real    */ ae_vector* d,
     /* Real    */ ae_vector* e,
     ae_int_t n,
     ae_bool isupper,
     /* Real    */ ae_matrix* u,
     /* Real    */ ae_matrix* c,
     /* Real    */ ae_vector* w,
     /* Real    */ ae_matrix* vt,
     double* materr,
     double* orterr,
     ae_bool* wsorted,
     ae_state *_state)
{
    ae_int_t i;
    ae_int_t j;
    ae_int_t k;
    double locerr;
    double sm;


    
    /*
     * decomposition error
     */
    locerr = (double)(0);
    for(i=0; i<=n-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            sm = (double)(0);
            for(k=0; k<=n-1; k++)
            {
                sm = sm+w->ptr.p_double[k]*u->ptr.pp_double[i][k]*vt->ptr.pp_double[k][j];
            }
            if( isupper )
            {
                if( i==j )
                {
                    locerr = ae_maxreal(locerr, ae_fabs(d->ptr.p_double[i]-sm, _state), _state);
                }
                else
                {
                    if( i==j-1 )
                    {
                        locerr = ae_maxreal(locerr, ae_fabs(e->ptr.p_double[i]-sm, _state), _state);
                    }
                    else
                    {
                        locerr = ae_maxreal(locerr, ae_fabs(sm, _state), _state);
                    }
                }
            }
            else
            {
                if( i==j )
                {
                    locerr = ae_maxreal(locerr, ae_fabs(d->ptr.p_double[i]-sm, _state), _state);
                }
                else
                {
                    if( i-1==j )
                    {
                        locerr = ae_maxreal(locerr, ae_fabs(e->ptr.p_double[j]-sm, _state), _state);
                    }
                    else
                    {
                        locerr = ae_maxreal(locerr, ae_fabs(sm, _state), _state);
                    }
                }
            }
        }
    }
    *materr = ae_maxreal(*materr, locerr, _state);
    
    /*
     * check for C = U'
     * we consider it as decomposition error
     */
    locerr = (double)(0);
    for(i=0; i<=n-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            locerr = ae_maxreal(locerr, ae_fabs(u->ptr.pp_double[i][j]-c->ptr.pp_double[j][i], _state), _state);
        }
    }
    *materr = ae_maxreal(*materr, locerr, _state);
    
    /*
     * orthogonality error
     */
    locerr = (double)(0);
    for(i=0; i<=n-1; i++)
    {
        for(j=i; j<=n-1; j++)
        {
            sm = ae_v_dotproduct(&u->ptr.pp_double[0][i], u->stride, &u->ptr.pp_double[0][j], u->stride, ae_v_len(0,n-1));
            if( i!=j )
            {
                locerr = ae_maxreal(locerr, ae_fabs(sm, _state), _state);
            }
            else
            {
                locerr = ae_maxreal(locerr, ae_fabs(sm-1, _state), _state);
            }
            sm = ae_v_dotproduct(&vt->ptr.pp_double[i][0], 1, &vt->ptr.pp_double[j][0], 1, ae_v_len(0,n-1));
            if( i!=j )
            {
                locerr = ae_maxreal(locerr, ae_fabs(sm, _state), _state);
            }
            else
            {
                locerr = ae_maxreal(locerr, ae_fabs(sm-1, _state), _state);
            }
        }
    }
    *orterr = ae_maxreal(*orterr, locerr, _state);
    
    /*
     * values order error
     */
    for(i=1; i<=n-1; i++)
    {
        if( ae_fp_greater(w->ptr.p_double[i],w->ptr.p_double[i-1]) )
        {
            *wsorted = ae_false;
        }
    }
}


static void testbdsvdunit_checksvdmultiplication(/* Real    */ ae_vector* d,
     /* Real    */ ae_vector* e,
     ae_int_t n,
     ae_bool isupper,
     /* Real    */ ae_matrix* u,
     /* Real    */ ae_matrix* c,
     /* Real    */ ae_vector* w,
     /* Real    */ ae_matrix* vt,
     double* err,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_int_t i;
    ae_int_t j;
    ae_vector wt;
    ae_matrix u2;
    ae_matrix c2;
    ae_matrix vt2;
    ae_matrix u1;
    ae_matrix c1;
    ae_matrix vt1;
    ae_int_t nru;
    ae_int_t ncc;
    ae_int_t ncvt;
    ae_int_t pass;
    hqrndstate rs;
    double v;

    ae_frame_make(_state, &_frame_block);
    ae_vector_init(&wt, 0, DT_REAL, _state);
    ae_matrix_init(&u2, 0, 0, DT_REAL, _state);
    ae_matrix_init(&c2, 0, 0, DT_REAL, _state);
    ae_matrix_init(&vt2, 0, 0, DT_REAL, _state);
    ae_matrix_init(&u1, 0, 0, DT_REAL, _state);
    ae_matrix_init(&c1, 0, 0, DT_REAL, _state);
    ae_matrix_init(&vt1, 0, 0, DT_REAL, _state);
    _hqrndstate_init(&rs, _state);

    hqrndrandomize(&rs, _state);
    ae_vector_set_length(&wt, n, _state);
    
    /*
     * Perform nonsquare SVD
     */
    for(pass=1; pass<=20; pass++)
    {
        
        /*
         * Problem size
         */
        nru = hqrnduniformi(&rs, 2*n, _state);
        ncc = hqrnduniformi(&rs, 2*n, _state);
        ncvt = hqrnduniformi(&rs, 2*n, _state);
        
        /*
         * Reference matrices (copy 1) and working matrices (copy 2)
         */
        for(i=0; i<=n-1; i++)
        {
            wt.ptr.p_double[i] = d->ptr.p_double[i];
        }
        if( nru>0 )
        {
            
            /*
             * init U1/U2
             */
            ae_matrix_set_length(&u1, nru, n, _state);
            ae_matrix_set_length(&u2, nru, n, _state);
            for(i=0; i<=u1.rows-1; i++)
            {
                for(j=0; j<=u1.cols-1; j++)
                {
                    u1.ptr.pp_double[i][j] = hqrnduniformr(&rs, _state)-0.5;
                    u2.ptr.pp_double[i][j] = u1.ptr.pp_double[i][j];
                }
            }
        }
        else
        {
            
            /*
             * Set U1/U2 to 1x1 matrices; working with 1x1 matrices allows
             * to test correctness of code which passes them to MKL.
             */
            ae_matrix_set_length(&u1, 1, 1, _state);
            ae_matrix_set_length(&u2, 1, 1, _state);
        }
        if( ncc>0 )
        {
            ae_matrix_set_length(&c1, n, ncc, _state);
            ae_matrix_set_length(&c2, n, ncc, _state);
            for(i=0; i<=c1.rows-1; i++)
            {
                for(j=0; j<=c1.cols-1; j++)
                {
                    c1.ptr.pp_double[i][j] = hqrnduniformr(&rs, _state)-0.5;
                    c2.ptr.pp_double[i][j] = c1.ptr.pp_double[i][j];
                }
            }
        }
        else
        {
            
            /*
             * Set C1/C1 to 1x1 matrices; working with 1x1 matrices allows
             * to test correctness of code which passes them to MKL.
             */
            ae_matrix_set_length(&c1, 1, 1, _state);
            ae_matrix_set_length(&c2, 1, 1, _state);
        }
        if( ncvt>0 )
        {
            ae_matrix_set_length(&vt1, n, ncvt, _state);
            ae_matrix_set_length(&vt2, n, ncvt, _state);
            for(i=0; i<=vt1.rows-1; i++)
            {
                for(j=0; j<=vt1.cols-1; j++)
                {
                    vt1.ptr.pp_double[i][j] = hqrnduniformr(&rs, _state)-0.5;
                    vt2.ptr.pp_double[i][j] = vt1.ptr.pp_double[i][j];
                }
            }
        }
        else
        {
            
            /*
             * Set VT1/VT1 to 1x1 matrices; working with 1x1 matrices allows
             * to test correctness of code which passes them to MKL.
             */
            ae_matrix_set_length(&vt1, 1, 1, _state);
            ae_matrix_set_length(&vt2, 1, 1, _state);
        }
        
        /*
         * SVD with non-square U/C/VT
         */
        if( !rmatrixbdsvd(&wt, e, n, isupper, ae_fp_greater(hqrnduniformr(&rs, _state),(double)(0)), &u2, nru, &c2, ncc, &vt2, ncvt, _state) )
        {
            *err = 1.0;
            ae_frame_leave(_state);
            return;
        }
        for(i=0; i<=nru-1; i++)
        {
            for(j=0; j<=u2.cols-1; j++)
            {
                v = ae_v_dotproduct(&u1.ptr.pp_double[i][0], 1, &u->ptr.pp_double[0][j], u->stride, ae_v_len(0,n-1));
                *err = ae_maxreal(*err, ae_fabs(v-u2.ptr.pp_double[i][j], _state), _state);
            }
        }
        for(i=0; i<=c2.rows-1; i++)
        {
            for(j=0; j<=ncc-1; j++)
            {
                v = ae_v_dotproduct(&c->ptr.pp_double[i][0], 1, &c1.ptr.pp_double[0][j], c1.stride, ae_v_len(0,n-1));
                *err = ae_maxreal(*err, ae_fabs(v-c2.ptr.pp_double[i][j], _state), _state);
            }
        }
        for(i=0; i<=vt2.rows-1; i++)
        {
            for(j=0; j<=ncvt-1; j++)
            {
                v = ae_v_dotproduct(&vt->ptr.pp_double[i][0], 1, &vt1.ptr.pp_double[0][j], vt1.stride, ae_v_len(0,n-1));
                *err = ae_maxreal(*err, ae_fabs(v-vt2.ptr.pp_double[i][j], _state), _state);
            }
        }
    }
    ae_frame_leave(_state);
}


static void testbdsvdunit_testbdsvdproblem(/* Real    */ ae_vector* d,
     /* Real    */ ae_vector* e,
     ae_int_t n,
     double* materr,
     double* orterr,
     ae_bool* wsorted,
     ae_bool* wfailed,
     ae_int_t* failcount,
     ae_int_t* succcount,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_matrix u;
    ae_matrix vt;
    ae_matrix c;
    ae_vector w;
    ae_int_t i;
    double mx;

    ae_frame_make(_state, &_frame_block);
    ae_matrix_init(&u, 0, 0, DT_REAL, _state);
    ae_matrix_init(&vt, 0, 0, DT_REAL, _state);
    ae_matrix_init(&c, 0, 0, DT_REAL, _state);
    ae_vector_init(&w, 0, DT_REAL, _state);

    mx = (double)(0);
    for(i=0; i<=n-1; i++)
    {
        if( ae_fp_greater(ae_fabs(d->ptr.p_double[i], _state),mx) )
        {
            mx = ae_fabs(d->ptr.p_double[i], _state);
        }
    }
    for(i=0; i<=n-2; i++)
    {
        if( ae_fp_greater(ae_fabs(e->ptr.p_double[i], _state),mx) )
        {
            mx = ae_fabs(e->ptr.p_double[i], _state);
        }
    }
    if( ae_fp_eq(mx,(double)(0)) )
    {
        mx = (double)(1);
    }
    
    /*
     * Upper BDSVD tests
     */
    ae_vector_set_length(&w, n-1+1, _state);
    testbdsvdunit_fillidentity(&u, n, _state);
    testbdsvdunit_fillidentity(&vt, n, _state);
    testbdsvdunit_fillidentity(&c, n, _state);
    for(i=0; i<=n-1; i++)
    {
        w.ptr.p_double[i] = d->ptr.p_double[i];
    }
    if( !rmatrixbdsvd(&w, e, n, ae_true, ae_false, &u, n, &c, n, &vt, n, _state) )
    {
        *failcount = *failcount+1;
        *wfailed = ae_true;
        ae_frame_leave(_state);
        return;
    }
    testbdsvdunit_getbdsvderror(d, e, n, ae_true, &u, &c, &w, &vt, materr, orterr, wsorted, _state);
    testbdsvdunit_checksvdmultiplication(d, e, n, ae_true, &u, &c, &w, &vt, materr, _state);
    testbdsvdunit_fillidentity(&u, n, _state);
    testbdsvdunit_fillidentity(&vt, n, _state);
    testbdsvdunit_fillidentity(&c, n, _state);
    for(i=0; i<=n-1; i++)
    {
        w.ptr.p_double[i] = d->ptr.p_double[i];
    }
    if( !rmatrixbdsvd(&w, e, n, ae_true, ae_true, &u, n, &c, n, &vt, n, _state) )
    {
        *failcount = *failcount+1;
        *wfailed = ae_true;
        ae_frame_leave(_state);
        return;
    }
    testbdsvdunit_getbdsvderror(d, e, n, ae_true, &u, &c, &w, &vt, materr, orterr, wsorted, _state);
    testbdsvdunit_checksvdmultiplication(d, e, n, ae_true, &u, &c, &w, &vt, materr, _state);
    
    /*
     * Lower BDSVD tests
     */
    ae_vector_set_length(&w, n-1+1, _state);
    testbdsvdunit_fillidentity(&u, n, _state);
    testbdsvdunit_fillidentity(&vt, n, _state);
    testbdsvdunit_fillidentity(&c, n, _state);
    for(i=0; i<=n-1; i++)
    {
        w.ptr.p_double[i] = d->ptr.p_double[i];
    }
    if( !rmatrixbdsvd(&w, e, n, ae_false, ae_false, &u, n, &c, n, &vt, n, _state) )
    {
        *failcount = *failcount+1;
        *wfailed = ae_true;
        ae_frame_leave(_state);
        return;
    }
    testbdsvdunit_getbdsvderror(d, e, n, ae_false, &u, &c, &w, &vt, materr, orterr, wsorted, _state);
    testbdsvdunit_checksvdmultiplication(d, e, n, ae_false, &u, &c, &w, &vt, materr, _state);
    testbdsvdunit_fillidentity(&u, n, _state);
    testbdsvdunit_fillidentity(&vt, n, _state);
    testbdsvdunit_fillidentity(&c, n, _state);
    for(i=0; i<=n-1; i++)
    {
        w.ptr.p_double[i] = d->ptr.p_double[i];
    }
    if( !rmatrixbdsvd(&w, e, n, ae_false, ae_true, &u, n, &c, n, &vt, n, _state) )
    {
        *failcount = *failcount+1;
        *wfailed = ae_true;
        ae_frame_leave(_state);
        return;
    }
    testbdsvdunit_getbdsvderror(d, e, n, ae_false, &u, &c, &w, &vt, materr, orterr, wsorted, _state);
    testbdsvdunit_checksvdmultiplication(d, e, n, ae_false, &u, &c, &w, &vt, materr, _state);
    
    /*
     * update counter
     */
    *succcount = *succcount+1;
    ae_frame_leave(_state);
}



static void testsvdunit_fillsparsea(/* Real    */ ae_matrix* a,
     ae_int_t m,
     ae_int_t n,
     double sparcity,
     ae_state *_state);
static void testsvdunit_getsvderror(/* Real    */ ae_matrix* a,
     ae_int_t m,
     ae_int_t n,
     /* Real    */ ae_matrix* u,
     /* Real    */ ae_vector* w,
     /* Real    */ ae_matrix* vt,
     double* materr,
     double* orterr,
     ae_bool* wsorted,
     ae_state *_state);
static void testsvdunit_testsvdproblem(/* Real    */ ae_matrix* a,
     ae_int_t m,
     ae_int_t n,
     double* materr,
     double* orterr,
     double* othererr,
     ae_bool* wsorted,
     ae_bool* wfailed,
     ae_int_t* failcount,
     ae_int_t* succcount,
     ae_state *_state);





/*************************************************************************
Testing SVD decomposition subroutine
*************************************************************************/
ae_bool testsvd(ae_bool silent, ae_state *_state)
{
    ae_frame _frame_block;
    ae_matrix a;
    ae_int_t m;
    ae_int_t n;
    ae_int_t maxmn;
    ae_int_t i;
    ae_int_t j;
    ae_int_t gpass;
    ae_int_t pass;
    ae_bool waserrors;
    ae_bool wsorted;
    ae_bool wfailed;
    double materr;
    double orterr;
    double othererr;
    double threshold;
    double failr;
    ae_int_t failcount;
    ae_int_t succcount;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    ae_matrix_init(&a, 0, 0, DT_REAL, _state);

    failcount = 0;
    succcount = 0;
    materr = (double)(0);
    orterr = (double)(0);
    othererr = (double)(0);
    wsorted = ae_true;
    wfailed = ae_false;
    waserrors = ae_false;
    maxmn = 30;
    threshold = 5*100*ae_machineepsilon;
    ae_matrix_set_length(&a, maxmn-1+1, maxmn-1+1, _state);
    
    /*
     * TODO: div by zero fail, convergence fail
     */
    for(gpass=1; gpass<=1; gpass++)
    {
        
        /*
         * zero matrix, several cases
         */
        for(i=0; i<=maxmn-1; i++)
        {
            for(j=0; j<=maxmn-1; j++)
            {
                a.ptr.pp_double[i][j] = (double)(0);
            }
        }
        for(i=1; i<=ae_minint(5, maxmn, _state); i++)
        {
            for(j=1; j<=ae_minint(5, maxmn, _state); j++)
            {
                testsvdunit_testsvdproblem(&a, i, j, &materr, &orterr, &othererr, &wsorted, &wfailed, &failcount, &succcount, _state);
            }
        }
        
        /*
         * Long dense matrix
         */
        for(i=0; i<=maxmn-1; i++)
        {
            for(j=0; j<=ae_minint(5, maxmn, _state)-1; j++)
            {
                a.ptr.pp_double[i][j] = 2*ae_randomreal(_state)-1;
            }
        }
        for(i=1; i<=maxmn; i++)
        {
            for(j=1; j<=ae_minint(5, maxmn, _state); j++)
            {
                testsvdunit_testsvdproblem(&a, i, j, &materr, &orterr, &othererr, &wsorted, &wfailed, &failcount, &succcount, _state);
            }
        }
        for(i=0; i<=ae_minint(5, maxmn, _state)-1; i++)
        {
            for(j=0; j<=maxmn-1; j++)
            {
                a.ptr.pp_double[i][j] = 2*ae_randomreal(_state)-1;
            }
        }
        for(i=1; i<=ae_minint(5, maxmn, _state); i++)
        {
            for(j=1; j<=maxmn; j++)
            {
                testsvdunit_testsvdproblem(&a, i, j, &materr, &orterr, &othererr, &wsorted, &wfailed, &failcount, &succcount, _state);
            }
        }
        
        /*
         * Dense matrices
         */
        for(m=1; m<=ae_minint(10, maxmn, _state); m++)
        {
            for(n=1; n<=ae_minint(10, maxmn, _state); n++)
            {
                for(i=0; i<=m-1; i++)
                {
                    for(j=0; j<=n-1; j++)
                    {
                        a.ptr.pp_double[i][j] = 2*ae_randomreal(_state)-1;
                    }
                }
                testsvdunit_testsvdproblem(&a, m, n, &materr, &orterr, &othererr, &wsorted, &wfailed, &failcount, &succcount, _state);
            }
        }
        
        /*
         * Sparse matrices, very sparse matrices, incredible sparse matrices
         */
        for(m=1; m<=10; m++)
        {
            for(n=1; n<=10; n++)
            {
                for(pass=1; pass<=2; pass++)
                {
                    testsvdunit_fillsparsea(&a, m, n, 0.8, _state);
                    testsvdunit_testsvdproblem(&a, m, n, &materr, &orterr, &othererr, &wsorted, &wfailed, &failcount, &succcount, _state);
                    testsvdunit_fillsparsea(&a, m, n, 0.9, _state);
                    testsvdunit_testsvdproblem(&a, m, n, &materr, &orterr, &othererr, &wsorted, &wfailed, &failcount, &succcount, _state);
                    testsvdunit_fillsparsea(&a, m, n, 0.95, _state);
                    testsvdunit_testsvdproblem(&a, m, n, &materr, &orterr, &othererr, &wsorted, &wfailed, &failcount, &succcount, _state);
                }
            }
        }
    }
    
    /*
     * report
     */
    failr = (double)failcount/(double)(succcount+failcount);
    waserrors = (((wfailed||ae_fp_greater(materr,threshold))||ae_fp_greater(orterr,threshold))||ae_fp_greater(othererr,threshold))||!wsorted;
    if( !silent )
    {
        printf("TESTING SVD DECOMPOSITION\n");
        printf("SVD decomposition error:                 %5.3e\n",
            (double)(materr));
        printf("SVD orthogonality error:                 %5.3e\n",
            (double)(orterr));
        printf("SVD with different parameters error:     %5.3e\n",
            (double)(othererr));
        printf("Singular values order:                   ");
        if( wsorted )
        {
            printf("OK\n");
        }
        else
        {
            printf("FAILED\n");
        }
        printf("Always converged:                        ");
        if( !wfailed )
        {
            printf("YES\n");
        }
        else
        {
            printf("NO\n");
            printf("Fail ratio:                              %5.3f\n",
                (double)(failr));
        }
        printf("Threshold:                               %5.3e\n",
            (double)(threshold));
        if( waserrors )
        {
            printf("TEST FAILED\n");
        }
        else
        {
            printf("TEST PASSED\n");
        }
        printf("\n\n");
    }
    result = !waserrors;
    ae_frame_leave(_state);
    return result;
}


/*************************************************************************
Single-threaded stub. HPC ALGLIB replaces it by multithreaded code.
*************************************************************************/
ae_bool _pexec_testsvd(ae_bool silent, ae_state *_state)
{
    return testsvd(silent, _state);
}


static void testsvdunit_fillsparsea(/* Real    */ ae_matrix* a,
     ae_int_t m,
     ae_int_t n,
     double sparcity,
     ae_state *_state)
{
    ae_int_t i;
    ae_int_t j;


    for(i=0; i<=m-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            if( ae_fp_greater_eq(ae_randomreal(_state),sparcity) )
            {
                a->ptr.pp_double[i][j] = 2*ae_randomreal(_state)-1;
            }
            else
            {
                a->ptr.pp_double[i][j] = (double)(0);
            }
        }
    }
}


static void testsvdunit_getsvderror(/* Real    */ ae_matrix* a,
     ae_int_t m,
     ae_int_t n,
     /* Real    */ ae_matrix* u,
     /* Real    */ ae_vector* w,
     /* Real    */ ae_matrix* vt,
     double* materr,
     double* orterr,
     ae_bool* wsorted,
     ae_state *_state)
{
    ae_int_t i;
    ae_int_t j;
    ae_int_t k;
    ae_int_t minmn;
    double locerr;
    double sm;


    minmn = ae_minint(m, n, _state);
    
    /*
     * decomposition error
     */
    locerr = (double)(0);
    for(i=0; i<=m-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            sm = (double)(0);
            for(k=0; k<=minmn-1; k++)
            {
                sm = sm+w->ptr.p_double[k]*u->ptr.pp_double[i][k]*vt->ptr.pp_double[k][j];
            }
            locerr = ae_maxreal(locerr, ae_fabs(a->ptr.pp_double[i][j]-sm, _state), _state);
        }
    }
    *materr = ae_maxreal(*materr, locerr, _state);
    
    /*
     * orthogonality error
     */
    locerr = (double)(0);
    for(i=0; i<=minmn-1; i++)
    {
        for(j=i; j<=minmn-1; j++)
        {
            sm = ae_v_dotproduct(&u->ptr.pp_double[0][i], u->stride, &u->ptr.pp_double[0][j], u->stride, ae_v_len(0,m-1));
            if( i!=j )
            {
                locerr = ae_maxreal(locerr, ae_fabs(sm, _state), _state);
            }
            else
            {
                locerr = ae_maxreal(locerr, ae_fabs(sm-1, _state), _state);
            }
            sm = ae_v_dotproduct(&vt->ptr.pp_double[i][0], 1, &vt->ptr.pp_double[j][0], 1, ae_v_len(0,n-1));
            if( i!=j )
            {
                locerr = ae_maxreal(locerr, ae_fabs(sm, _state), _state);
            }
            else
            {
                locerr = ae_maxreal(locerr, ae_fabs(sm-1, _state), _state);
            }
        }
    }
    *orterr = ae_maxreal(*orterr, locerr, _state);
    
    /*
     * values order error
     */
    for(i=1; i<=minmn-1; i++)
    {
        if( ae_fp_greater(w->ptr.p_double[i],w->ptr.p_double[i-1]) )
        {
            *wsorted = ae_false;
        }
    }
}


static void testsvdunit_testsvdproblem(/* Real    */ ae_matrix* a,
     ae_int_t m,
     ae_int_t n,
     double* materr,
     double* orterr,
     double* othererr,
     ae_bool* wsorted,
     ae_bool* wfailed,
     ae_int_t* failcount,
     ae_int_t* succcount,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_matrix u;
    ae_matrix vt;
    ae_matrix u2;
    ae_matrix vt2;
    ae_vector w;
    ae_vector w2;
    ae_int_t i;
    ae_int_t j;
    ae_int_t ujob;
    ae_int_t vtjob;
    ae_int_t memjob;
    ae_int_t ucheck;
    ae_int_t vtcheck;

    ae_frame_make(_state, &_frame_block);
    ae_matrix_init(&u, 0, 0, DT_REAL, _state);
    ae_matrix_init(&vt, 0, 0, DT_REAL, _state);
    ae_matrix_init(&u2, 0, 0, DT_REAL, _state);
    ae_matrix_init(&vt2, 0, 0, DT_REAL, _state);
    ae_vector_init(&w, 0, DT_REAL, _state);
    ae_vector_init(&w2, 0, DT_REAL, _state);

    
    /*
     * Main SVD test
     */
    if( !rmatrixsvd(a, m, n, 2, 2, 2, &w, &u, &vt, _state) )
    {
        *failcount = *failcount+1;
        *wfailed = ae_true;
        ae_frame_leave(_state);
        return;
    }
    testsvdunit_getsvderror(a, m, n, &u, &w, &vt, materr, orterr, wsorted, _state);
    
    /*
     * Additional SVD tests
     */
    for(ujob=0; ujob<=2; ujob++)
    {
        for(vtjob=0; vtjob<=2; vtjob++)
        {
            for(memjob=0; memjob<=2; memjob++)
            {
                if( !rmatrixsvd(a, m, n, ujob, vtjob, memjob, &w2, &u2, &vt2, _state) )
                {
                    *failcount = *failcount+1;
                    *wfailed = ae_true;
                    ae_frame_leave(_state);
                    return;
                }
                ucheck = 0;
                if( ujob==1 )
                {
                    ucheck = ae_minint(m, n, _state);
                }
                if( ujob==2 )
                {
                    ucheck = m;
                }
                vtcheck = 0;
                if( vtjob==1 )
                {
                    vtcheck = ae_minint(m, n, _state);
                }
                if( vtjob==2 )
                {
                    vtcheck = n;
                }
                for(i=0; i<=m-1; i++)
                {
                    for(j=0; j<=ucheck-1; j++)
                    {
                        *othererr = ae_maxreal(*othererr, ae_fabs(u.ptr.pp_double[i][j]-u2.ptr.pp_double[i][j], _state), _state);
                    }
                }
                for(i=0; i<=vtcheck-1; i++)
                {
                    for(j=0; j<=n-1; j++)
                    {
                        *othererr = ae_maxreal(*othererr, ae_fabs(vt.ptr.pp_double[i][j]-vt2.ptr.pp_double[i][j], _state), _state);
                    }
                }
                for(i=0; i<=ae_minint(m, n, _state)-1; i++)
                {
                    *othererr = ae_maxreal(*othererr, ae_fabs(w.ptr.p_double[i]-w2.ptr.p_double[i], _state), _state);
                }
            }
        }
    }
    
    /*
     * update counter
     */
    *succcount = *succcount+1;
    ae_frame_leave(_state);
}



static void testlinregunit_generaterandomtask(double xl,
     double xr,
     ae_bool randomx,
     double ymin,
     double ymax,
     double smin,
     double smax,
     ae_int_t n,
     /* Real    */ ae_matrix* xy,
     /* Real    */ ae_vector* s,
     ae_state *_state);
static void testlinregunit_generatetask(double a,
     double b,
     double xl,
     double xr,
     ae_bool randomx,
     double smin,
     double smax,
     ae_int_t n,
     /* Real    */ ae_matrix* xy,
     /* Real    */ ae_vector* s,
     ae_state *_state);
static void testlinregunit_filltaskwithy(double a,
     double b,
     ae_int_t n,
     /* Real    */ ae_matrix* xy,
     /* Real    */ ae_vector* s,
     ae_state *_state);
static double testlinregunit_generatenormal(double mean,
     double sigma,
     ae_state *_state);
static void testlinregunit_calculatemv(/* Real    */ ae_vector* x,
     ae_int_t n,
     double* mean,
     double* means,
     double* stddev,
     double* stddevs,
     ae_state *_state);
static void testlinregunit_unsetlr(linearmodel* lr, ae_state *_state);





ae_bool testlinreg(ae_bool silent, ae_state *_state)
{
    ae_frame _frame_block;
    double sigmathreshold;
    ae_int_t maxn;
    ae_int_t maxm;
    ae_int_t passcount;
    ae_int_t estpasscount;
    double threshold;
    ae_int_t n;
    ae_int_t i;
    ae_int_t j;
    ae_int_t k;
    ae_int_t tmpi;
    ae_int_t pass;
    ae_int_t epass;
    ae_int_t m;
    ae_int_t tasktype;
    ae_int_t modeltype;
    ae_int_t m1;
    ae_int_t m2;
    ae_int_t n1;
    ae_int_t n2;
    ae_int_t info;
    ae_int_t info2;
    ae_matrix xy;
    ae_matrix xy2;
    ae_vector s;
    ae_vector s2;
    ae_vector w2;
    ae_vector x;
    ae_vector ta;
    ae_vector tb;
    ae_vector tc;
    ae_vector xy0;
    ae_vector tmpweights;
    linearmodel w;
    linearmodel wt;
    linearmodel wt2;
    ae_vector x1;
    ae_vector x2;
    double y1;
    double y2;
    ae_bool allsame;
    double ea;
    double eb;
    double varatested;
    double varbtested;
    double a;
    double b;
    double vara;
    double varb;
    double a2;
    double b2;
    double covab;
    double corrab;
    double p;
    ae_int_t qcnt;
    ae_vector qtbl;
    ae_vector qvals;
    ae_vector qsigma;
    lrreport ar;
    lrreport ar2;
    double f;
    double fp;
    double fm;
    double v;
    double vv;
    double cvrmserror;
    double cvavgerror;
    double cvavgrelerror;
    double rmserror;
    double avgerror;
    double avgrelerror;
    ae_bool nondefect;
    double sinshift;
    double tasklevel;
    double noiselevel;
    double hstep;
    double sigma;
    double mean;
    double means;
    double stddev;
    double stddevs;
    ae_bool slcerrors;
    ae_bool slerrors;
    ae_bool grcoverrors;
    ae_bool gropterrors;
    ae_bool gresterrors;
    ae_bool grothererrors;
    ae_bool grconverrors;
    ae_bool waserrors;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    ae_matrix_init(&xy, 0, 0, DT_REAL, _state);
    ae_matrix_init(&xy2, 0, 0, DT_REAL, _state);
    ae_vector_init(&s, 0, DT_REAL, _state);
    ae_vector_init(&s2, 0, DT_REAL, _state);
    ae_vector_init(&w2, 0, DT_REAL, _state);
    ae_vector_init(&x, 0, DT_REAL, _state);
    ae_vector_init(&ta, 0, DT_REAL, _state);
    ae_vector_init(&tb, 0, DT_REAL, _state);
    ae_vector_init(&tc, 0, DT_REAL, _state);
    ae_vector_init(&xy0, 0, DT_REAL, _state);
    ae_vector_init(&tmpweights, 0, DT_REAL, _state);
    _linearmodel_init(&w, _state);
    _linearmodel_init(&wt, _state);
    _linearmodel_init(&wt2, _state);
    ae_vector_init(&x1, 0, DT_REAL, _state);
    ae_vector_init(&x2, 0, DT_REAL, _state);
    ae_vector_init(&qtbl, 0, DT_REAL, _state);
    ae_vector_init(&qvals, 0, DT_REAL, _state);
    ae_vector_init(&qsigma, 0, DT_REAL, _state);
    _lrreport_init(&ar, _state);
    _lrreport_init(&ar2, _state);

    
    /*
     * Primary settings
     */
    maxn = 40;
    maxm = 5;
    passcount = 3;
    estpasscount = 1000;
    sigmathreshold = (double)(7);
    threshold = 1000000*ae_machineepsilon;
    slerrors = ae_false;
    slcerrors = ae_false;
    grcoverrors = ae_false;
    gropterrors = ae_false;
    gresterrors = ae_false;
    grothererrors = ae_false;
    grconverrors = ae_false;
    waserrors = ae_false;
    
    /*
     * Quantiles table setup
     */
    qcnt = 5;
    ae_vector_set_length(&qtbl, qcnt-1+1, _state);
    ae_vector_set_length(&qvals, qcnt-1+1, _state);
    ae_vector_set_length(&qsigma, qcnt-1+1, _state);
    qtbl.ptr.p_double[0] = 0.5;
    qtbl.ptr.p_double[1] = 0.25;
    qtbl.ptr.p_double[2] = 0.10;
    qtbl.ptr.p_double[3] = 0.05;
    qtbl.ptr.p_double[4] = 0.025;
    for(i=0; i<=qcnt-1; i++)
    {
        qsigma.ptr.p_double[i] = ae_sqrt(qtbl.ptr.p_double[i]*(1-qtbl.ptr.p_double[i])/estpasscount, _state);
    }
    
    /*
     * Other setup
     */
    ae_vector_set_length(&ta, estpasscount-1+1, _state);
    ae_vector_set_length(&tb, estpasscount-1+1, _state);
    
    /*
     * Test straight line regression
     */
    for(n=2; n<=maxn; n++)
    {
        
        /*
         * Fail/pass test
         */
        testlinregunit_generaterandomtask((double)(-1), (double)(1), ae_false, (double)(-1), (double)(1), (double)(1), (double)(2), n, &xy, &s, _state);
        lrlines(&xy, &s, n, &info, &a, &b, &vara, &varb, &covab, &corrab, &p, _state);
        slcerrors = slcerrors||info!=1;
        testlinregunit_generaterandomtask((double)(1), (double)(1), ae_false, (double)(-1), (double)(1), (double)(1), (double)(2), n, &xy, &s, _state);
        lrlines(&xy, &s, n, &info, &a, &b, &vara, &varb, &covab, &corrab, &p, _state);
        slcerrors = slcerrors||info!=-3;
        testlinregunit_generaterandomtask((double)(-1), (double)(1), ae_false, (double)(-1), (double)(1), (double)(-1), (double)(-1), n, &xy, &s, _state);
        lrlines(&xy, &s, n, &info, &a, &b, &vara, &varb, &covab, &corrab, &p, _state);
        slcerrors = slcerrors||info!=-2;
        testlinregunit_generaterandomtask((double)(-1), (double)(1), ae_false, (double)(-1), (double)(1), (double)(2), (double)(1), 2, &xy, &s, _state);
        lrlines(&xy, &s, 1, &info, &a, &b, &vara, &varb, &covab, &corrab, &p, _state);
        slcerrors = slcerrors||info!=-1;
        
        /*
         * Multipass tests
         */
        for(pass=1; pass<=passcount; pass++)
        {
            
            /*
             * Test S variant against non-S variant
             */
            ea = 2*ae_randomreal(_state)-1;
            eb = 2*ae_randomreal(_state)-1;
            testlinregunit_generatetask(ea, eb, -5*ae_randomreal(_state), 5*ae_randomreal(_state), ae_fp_greater(ae_randomreal(_state),0.5), (double)(1), (double)(1), n, &xy, &s, _state);
            lrlines(&xy, &s, n, &info, &a, &b, &vara, &varb, &covab, &corrab, &p, _state);
            lrline(&xy, n, &info2, &a2, &b2, _state);
            if( info!=1||info2!=1 )
            {
                slcerrors = ae_true;
            }
            else
            {
                slerrors = (slerrors||ae_fp_greater(ae_fabs(a-a2, _state),threshold))||ae_fp_greater(ae_fabs(b-b2, _state),threshold);
            }
            
            /*
             * Test for A/B
             *
             * Generate task with exact, non-perturbed y[i],
             * then make non-zero s[i]
             */
            ea = 2*ae_randomreal(_state)-1;
            eb = 2*ae_randomreal(_state)-1;
            testlinregunit_generatetask(ea, eb, -5*ae_randomreal(_state), 5*ae_randomreal(_state), n>4, 0.0, 0.0, n, &xy, &s, _state);
            for(i=0; i<=n-1; i++)
            {
                s.ptr.p_double[i] = 1+ae_randomreal(_state);
            }
            lrlines(&xy, &s, n, &info, &a, &b, &vara, &varb, &covab, &corrab, &p, _state);
            if( info!=1 )
            {
                slcerrors = ae_true;
            }
            else
            {
                slerrors = (slerrors||ae_fp_greater(ae_fabs(a-ea, _state),0.001))||ae_fp_greater(ae_fabs(b-eb, _state),0.001);
            }
            
            /*
             * Test for VarA, VarB, P (P is being tested only for N>2)
             */
            for(i=0; i<=qcnt-1; i++)
            {
                qvals.ptr.p_double[i] = (double)(0);
            }
            ea = 2*ae_randomreal(_state)-1;
            eb = 2*ae_randomreal(_state)-1;
            testlinregunit_generatetask(ea, eb, -5*ae_randomreal(_state), 5*ae_randomreal(_state), n>4, 1.0, 2.0, n, &xy, &s, _state);
            lrlines(&xy, &s, n, &info, &a, &b, &vara, &varb, &covab, &corrab, &p, _state);
            if( info!=1 )
            {
                slcerrors = ae_true;
                continue;
            }
            varatested = vara;
            varbtested = varb;
            for(epass=0; epass<=estpasscount-1; epass++)
            {
                
                /*
                 * Generate
                 */
                testlinregunit_filltaskwithy(ea, eb, n, &xy, &s, _state);
                lrlines(&xy, &s, n, &info, &a, &b, &vara, &varb, &covab, &corrab, &p, _state);
                if( info!=1 )
                {
                    slcerrors = ae_true;
                    continue;
                }
                
                /*
                 * A, B, P
                 * (P is being tested for uniformity, additional p-tests are below)
                 */
                ta.ptr.p_double[epass] = a;
                tb.ptr.p_double[epass] = b;
                for(i=0; i<=qcnt-1; i++)
                {
                    if( ae_fp_less_eq(p,qtbl.ptr.p_double[i]) )
                    {
                        qvals.ptr.p_double[i] = qvals.ptr.p_double[i]+(double)1/(double)estpasscount;
                    }
                }
            }
            testlinregunit_calculatemv(&ta, estpasscount, &mean, &means, &stddev, &stddevs, _state);
            slerrors = slerrors||ae_fp_greater_eq(ae_fabs(mean-ea, _state)/means,sigmathreshold);
            slerrors = slerrors||ae_fp_greater_eq(ae_fabs(stddev-ae_sqrt(varatested, _state), _state)/stddevs,sigmathreshold);
            testlinregunit_calculatemv(&tb, estpasscount, &mean, &means, &stddev, &stddevs, _state);
            slerrors = slerrors||ae_fp_greater_eq(ae_fabs(mean-eb, _state)/means,sigmathreshold);
            slerrors = slerrors||ae_fp_greater_eq(ae_fabs(stddev-ae_sqrt(varbtested, _state), _state)/stddevs,sigmathreshold);
            if( n>2 )
            {
                for(i=0; i<=qcnt-1; i++)
                {
                    if( ae_fp_greater(ae_fabs(qtbl.ptr.p_double[i]-qvals.ptr.p_double[i], _state)/qsigma.ptr.p_double[i],sigmathreshold) )
                    {
                        slerrors = ae_true;
                    }
                }
            }
            
            /*
             * Additional tests for P: correlation with fit quality
             */
            if( n>2 )
            {
                testlinregunit_generatetask(ea, eb, -5*ae_randomreal(_state), 5*ae_randomreal(_state), ae_false, 0.0, 0.0, n, &xy, &s, _state);
                for(i=0; i<=n-1; i++)
                {
                    s.ptr.p_double[i] = 1+ae_randomreal(_state);
                }
                lrlines(&xy, &s, n, &info, &a, &b, &vara, &varb, &covab, &corrab, &p, _state);
                if( info!=1 )
                {
                    slcerrors = ae_true;
                    continue;
                }
                slerrors = slerrors||ae_fp_less(p,0.999);
                testlinregunit_generatetask((double)(0), (double)(0), -5*ae_randomreal(_state), 5*ae_randomreal(_state), ae_false, 1.0, 1.0, n, &xy, &s, _state);
                for(i=0; i<=n-1; i++)
                {
                    if( i%2==0 )
                    {
                        xy.ptr.pp_double[i][1] = 5.0;
                    }
                    else
                    {
                        xy.ptr.pp_double[i][1] = -5.0;
                    }
                }
                if( n%2!=0 )
                {
                    xy.ptr.pp_double[n-1][1] = (double)(0);
                }
                lrlines(&xy, &s, n, &info, &a, &b, &vara, &varb, &covab, &corrab, &p, _state);
                if( info!=1 )
                {
                    slcerrors = ae_true;
                    continue;
                }
                slerrors = slerrors||ae_fp_greater(p,0.001);
            }
        }
    }
    
    /*
     * General regression tests:
     */
    
    /*
     * Simple linear tests (small sample, optimum point, covariance)
     */
    for(n=3; n<=maxn; n++)
    {
        ae_vector_set_length(&s, n-1+1, _state);
        
        /*
         * Linear tests:
         * a. random points, sigmas
         * b. no sigmas
         */
        ae_matrix_set_length(&xy, n-1+1, 1+1, _state);
        for(i=0; i<=n-1; i++)
        {
            xy.ptr.pp_double[i][0] = 2*ae_randomreal(_state)-1;
            xy.ptr.pp_double[i][1] = 2*ae_randomreal(_state)-1;
            s.ptr.p_double[i] = 1+ae_randomreal(_state);
        }
        lrbuilds(&xy, &s, n, 1, &info, &wt, &ar, _state);
        if( info!=1 )
        {
            grconverrors = ae_true;
            continue;
        }
        lrunpack(&wt, &tmpweights, &tmpi, _state);
        lrlines(&xy, &s, n, &info2, &a, &b, &vara, &varb, &covab, &corrab, &p, _state);
        gropterrors = gropterrors||ae_fp_greater(ae_fabs(a-tmpweights.ptr.p_double[1], _state),threshold);
        gropterrors = gropterrors||ae_fp_greater(ae_fabs(b-tmpweights.ptr.p_double[0], _state),threshold);
        grcoverrors = grcoverrors||ae_fp_greater(ae_fabs(vara-ar.c.ptr.pp_double[1][1], _state),threshold);
        grcoverrors = grcoverrors||ae_fp_greater(ae_fabs(varb-ar.c.ptr.pp_double[0][0], _state),threshold);
        grcoverrors = grcoverrors||ae_fp_greater(ae_fabs(covab-ar.c.ptr.pp_double[1][0], _state),threshold);
        grcoverrors = grcoverrors||ae_fp_greater(ae_fabs(covab-ar.c.ptr.pp_double[0][1], _state),threshold);
        lrbuild(&xy, n, 1, &info, &wt, &ar, _state);
        if( info!=1 )
        {
            grconverrors = ae_true;
            continue;
        }
        lrunpack(&wt, &tmpweights, &tmpi, _state);
        lrline(&xy, n, &info2, &a, &b, _state);
        gropterrors = gropterrors||ae_fp_greater(ae_fabs(a-tmpweights.ptr.p_double[1], _state),threshold);
        gropterrors = gropterrors||ae_fp_greater(ae_fabs(b-tmpweights.ptr.p_double[0], _state),threshold);
    }
    
    /*
     * S covariance versus S-less covariance.
     * Slightly skewed task, large sample size.
     * Will S-less subroutine estimate covariance matrix good enough?
     */
    n = 1000+ae_randominteger(3000, _state);
    sigma = 0.1+ae_randomreal(_state)*1.9;
    ae_matrix_set_length(&xy, n-1+1, 1+1, _state);
    ae_vector_set_length(&s, n-1+1, _state);
    for(i=0; i<=n-1; i++)
    {
        xy.ptr.pp_double[i][0] = 1.5*ae_randomreal(_state)-0.5;
        xy.ptr.pp_double[i][1] = 1.2*xy.ptr.pp_double[i][0]-0.3+testlinregunit_generatenormal((double)(0), sigma, _state);
        s.ptr.p_double[i] = sigma;
    }
    lrbuild(&xy, n, 1, &info, &wt, &ar, _state);
    lrlines(&xy, &s, n, &info2, &a, &b, &vara, &varb, &covab, &corrab, &p, _state);
    if( info!=1||info2!=1 )
    {
        grconverrors = ae_true;
    }
    else
    {
        grcoverrors = grcoverrors||ae_fp_greater(ae_fabs(ae_log(ar.c.ptr.pp_double[0][0]/varb, _state), _state),ae_log(1.2, _state));
        grcoverrors = grcoverrors||ae_fp_greater(ae_fabs(ae_log(ar.c.ptr.pp_double[1][1]/vara, _state), _state),ae_log(1.2, _state));
        grcoverrors = grcoverrors||ae_fp_greater(ae_fabs(ae_log(ar.c.ptr.pp_double[0][1]/covab, _state), _state),ae_log(1.2, _state));
        grcoverrors = grcoverrors||ae_fp_greater(ae_fabs(ae_log(ar.c.ptr.pp_double[1][0]/covab, _state), _state),ae_log(1.2, _state));
    }
    
    /*
     * General tests:
     * * basis functions - up to cubic
     * * task types:
     * * data set is noisy sine half-period with random shift
     * * tests:
     *   unpacking/packing
     *   optimality
     *   error estimates
     * * tasks:
     *   0 = noised sine
     *   1 = degenerate task with 1-of-n encoded categorical variables
     *   2 = random task with large variation (for 1-type models)
     *   3 = random task with small variation (for 1-type models)
     *
     *   Additional tasks TODO
     *   specially designed task with defective vectors which leads to
     *   the failure of the fast CV formula.
     *
     */
    m1 = 0;
    m2 = -1;
    n1 = 0;
    n2 = -1;
    for(modeltype=0; modeltype<=1; modeltype++)
    {
        for(tasktype=0; tasktype<=3; tasktype++)
        {
            if( tasktype==0 )
            {
                m1 = 1;
                m2 = 3;
            }
            if( tasktype==1 )
            {
                m1 = 9;
                m2 = 9;
            }
            if( tasktype==2||tasktype==3 )
            {
                m1 = 9;
                m2 = 9;
            }
            for(m=m1; m<=m2; m++)
            {
                if( tasktype==0 )
                {
                    n1 = m+3;
                    n2 = m+20;
                }
                if( tasktype==1 )
                {
                    n1 = 70+ae_randominteger(70, _state);
                    n2 = n1;
                }
                if( tasktype==2||tasktype==3 )
                {
                    n1 = 100;
                    n2 = n1;
                }
                for(n=n1; n<=n2; n++)
                {
                    ae_matrix_set_length(&xy, n-1+1, m+1, _state);
                    ae_vector_set_length(&xy0, n-1+1, _state);
                    ae_vector_set_length(&s, n-1+1, _state);
                    hstep = 0.001;
                    noiselevel = 0.2;
                    
                    /*
                     * Prepare task
                     */
                    if( tasktype==0 )
                    {
                        for(i=0; i<=n-1; i++)
                        {
                            xy.ptr.pp_double[i][0] = 2*ae_randomreal(_state)-1;
                        }
                        for(i=0; i<=n-1; i++)
                        {
                            for(j=1; j<=m-1; j++)
                            {
                                xy.ptr.pp_double[i][j] = xy.ptr.pp_double[i][0]*xy.ptr.pp_double[i][j-1];
                            }
                        }
                        sinshift = ae_randomreal(_state)*ae_pi;
                        for(i=0; i<=n-1; i++)
                        {
                            xy0.ptr.p_double[i] = ae_sin(sinshift+ae_pi*0.5*(xy.ptr.pp_double[i][0]+1), _state);
                            xy.ptr.pp_double[i][m] = xy0.ptr.p_double[i]+noiselevel*testlinregunit_generatenormal((double)(0), (double)(1), _state);
                        }
                    }
                    if( tasktype==1 )
                    {
                        ae_assert(m==9, "Assertion failed", _state);
                        ae_vector_set_length(&ta, 8+1, _state);
                        ta.ptr.p_double[0] = (double)(1);
                        ta.ptr.p_double[1] = (double)(2);
                        ta.ptr.p_double[2] = (double)(3);
                        ta.ptr.p_double[3] = 0.25;
                        ta.ptr.p_double[4] = 0.5;
                        ta.ptr.p_double[5] = 0.75;
                        ta.ptr.p_double[6] = 0.06;
                        ta.ptr.p_double[7] = 0.12;
                        ta.ptr.p_double[8] = 0.18;
                        for(i=0; i<=n-1; i++)
                        {
                            for(j=0; j<=m-1; j++)
                            {
                                xy.ptr.pp_double[i][j] = (double)(0);
                            }
                            xy.ptr.pp_double[i][0+i%3] = (double)(1);
                            xy.ptr.pp_double[i][3+i/3%3] = (double)(1);
                            xy.ptr.pp_double[i][6+i/9%3] = (double)(1);
                            v = ae_v_dotproduct(&xy.ptr.pp_double[i][0], 1, &ta.ptr.p_double[0], 1, ae_v_len(0,8));
                            xy0.ptr.p_double[i] = v;
                            xy.ptr.pp_double[i][m] = v+noiselevel*testlinregunit_generatenormal((double)(0), (double)(1), _state);
                        }
                    }
                    if( tasktype==2||tasktype==3 )
                    {
                        ae_assert(m==9, "Assertion failed", _state);
                        ae_vector_set_length(&ta, 8+1, _state);
                        ta.ptr.p_double[0] = (double)(1);
                        ta.ptr.p_double[1] = (double)(-2);
                        ta.ptr.p_double[2] = (double)(3);
                        ta.ptr.p_double[3] = 0.25;
                        ta.ptr.p_double[4] = -0.5;
                        ta.ptr.p_double[5] = 0.75;
                        ta.ptr.p_double[6] = -0.06;
                        ta.ptr.p_double[7] = 0.12;
                        ta.ptr.p_double[8] = -0.18;
                        for(i=0; i<=n-1; i++)
                        {
                            for(j=0; j<=m-1; j++)
                            {
                                if( tasktype==2 )
                                {
                                    xy.ptr.pp_double[i][j] = 1+testlinregunit_generatenormal((double)(0), (double)(3), _state);
                                }
                                else
                                {
                                    xy.ptr.pp_double[i][j] = 1+testlinregunit_generatenormal((double)(0), 0.05, _state);
                                }
                            }
                            v = ae_v_dotproduct(&xy.ptr.pp_double[i][0], 1, &ta.ptr.p_double[0], 1, ae_v_len(0,8));
                            xy0.ptr.p_double[i] = v;
                            xy.ptr.pp_double[i][m] = v+noiselevel*testlinregunit_generatenormal((double)(0), (double)(1), _state);
                        }
                    }
                    for(i=0; i<=n-1; i++)
                    {
                        s.ptr.p_double[i] = 1+ae_randomreal(_state);
                    }
                    
                    /*
                     * Solve (using S-variant, non-S-variant is not tested)
                     */
                    if( modeltype==0 )
                    {
                        lrbuilds(&xy, &s, n, m, &info, &wt, &ar, _state);
                    }
                    else
                    {
                        lrbuildzs(&xy, &s, n, m, &info, &wt, &ar, _state);
                    }
                    if( info!=1 )
                    {
                        grconverrors = ae_true;
                        continue;
                    }
                    lrunpack(&wt, &tmpweights, &tmpi, _state);
                    
                    /*
                     * LRProcess test
                     */
                    ae_vector_set_length(&x, m-1+1, _state);
                    v = tmpweights.ptr.p_double[m];
                    for(i=0; i<=m-1; i++)
                    {
                        x.ptr.p_double[i] = 2*ae_randomreal(_state)-1;
                        v = v+tmpweights.ptr.p_double[i]*x.ptr.p_double[i];
                    }
                    grothererrors = grothererrors||ae_fp_greater(ae_fabs(v-lrprocess(&wt, &x, _state), _state)/ae_maxreal(ae_fabs(v, _state), (double)(1), _state),threshold);
                    
                    /*
                     * LRPack test
                     */
                    lrpack(&tmpweights, m, &wt2, _state);
                    ae_vector_set_length(&x, m-1+1, _state);
                    for(i=0; i<=m-1; i++)
                    {
                        x.ptr.p_double[i] = 2*ae_randomreal(_state)-1;
                    }
                    v = lrprocess(&wt, &x, _state);
                    grothererrors = grothererrors||ae_fp_greater(ae_fabs(v-lrprocess(&wt2, &x, _state), _state)/ae_fabs(v, _state),threshold);
                    
                    /*
                     * Optimality test
                     */
                    for(k=0; k<=m; k++)
                    {
                        if( modeltype==1&&k==m )
                        {
                            
                            /*
                             * 0-type models (with non-zero constant term)
                             * are tested for optimality of all coefficients.
                             *
                             * 1-type models (with zero constant term)
                             * are tested for optimality of non-constant terms only.
                             */
                            continue;
                        }
                        f = (double)(0);
                        fp = (double)(0);
                        fm = (double)(0);
                        for(i=0; i<=n-1; i++)
                        {
                            v = tmpweights.ptr.p_double[m];
                            for(j=0; j<=m-1; j++)
                            {
                                v = v+xy.ptr.pp_double[i][j]*tmpweights.ptr.p_double[j];
                            }
                            f = f+ae_sqr((v-xy.ptr.pp_double[i][m])/s.ptr.p_double[i], _state);
                            if( k<m )
                            {
                                vv = xy.ptr.pp_double[i][k];
                            }
                            else
                            {
                                vv = (double)(1);
                            }
                            fp = fp+ae_sqr((v+vv*hstep-xy.ptr.pp_double[i][m])/s.ptr.p_double[i], _state);
                            fm = fm+ae_sqr((v-vv*hstep-xy.ptr.pp_double[i][m])/s.ptr.p_double[i], _state);
                        }
                        gropterrors = (gropterrors||ae_fp_greater(f,fp))||ae_fp_greater(f,fm);
                    }
                    
                    /*
                     * Covariance matrix test:
                     * generate random vector, project coefficients on it,
                     * compare variance of projection with estimate provided
                     * by cov.matrix
                     */
                    ae_vector_set_length(&ta, estpasscount-1+1, _state);
                    ae_vector_set_length(&tb, m+1, _state);
                    ae_vector_set_length(&tc, m+1, _state);
                    ae_matrix_set_length(&xy2, n-1+1, m+1, _state);
                    for(i=0; i<=m; i++)
                    {
                        tb.ptr.p_double[i] = testlinregunit_generatenormal((double)(0), (double)(1), _state);
                    }
                    for(epass=0; epass<=estpasscount-1; epass++)
                    {
                        for(i=0; i<=n-1; i++)
                        {
                            ae_v_move(&xy2.ptr.pp_double[i][0], 1, &xy.ptr.pp_double[i][0], 1, ae_v_len(0,m-1));
                            xy2.ptr.pp_double[i][m] = xy0.ptr.p_double[i]+s.ptr.p_double[i]*testlinregunit_generatenormal((double)(0), (double)(1), _state);
                        }
                        if( modeltype==0 )
                        {
                            lrbuilds(&xy2, &s, n, m, &info, &wt, &ar2, _state);
                        }
                        else
                        {
                            lrbuildzs(&xy2, &s, n, m, &info, &wt, &ar2, _state);
                        }
                        if( info!=1 )
                        {
                            ta.ptr.p_double[epass] = (double)(0);
                            grconverrors = ae_true;
                            continue;
                        }
                        lrunpack(&wt, &w2, &tmpi, _state);
                        v = ae_v_dotproduct(&tb.ptr.p_double[0], 1, &w2.ptr.p_double[0], 1, ae_v_len(0,m));
                        ta.ptr.p_double[epass] = v;
                    }
                    testlinregunit_calculatemv(&ta, estpasscount, &mean, &means, &stddev, &stddevs, _state);
                    for(i=0; i<=m; i++)
                    {
                        v = ae_v_dotproduct(&tb.ptr.p_double[0], 1, &ar.c.ptr.pp_double[0][i], ar.c.stride, ae_v_len(0,m));
                        tc.ptr.p_double[i] = v;
                    }
                    v = ae_v_dotproduct(&tc.ptr.p_double[0], 1, &tb.ptr.p_double[0], 1, ae_v_len(0,m));
                    grcoverrors = grcoverrors||ae_fp_greater_eq(ae_fabs((ae_sqrt(v, _state)-stddev)/stddevs, _state),sigmathreshold);
                    
                    /*
                     * Test for the fast CV error:
                     * calculate CV error by definition (leaving out N
                     * points and recalculating solution).
                     *
                     * Test for the training set error
                     */
                    cvrmserror = (double)(0);
                    cvavgerror = (double)(0);
                    cvavgrelerror = (double)(0);
                    rmserror = (double)(0);
                    avgerror = (double)(0);
                    avgrelerror = (double)(0);
                    ae_matrix_set_length(&xy2, n-2+1, m+1, _state);
                    ae_vector_set_length(&s2, n-2+1, _state);
                    for(i=0; i<=n-2; i++)
                    {
                        ae_v_move(&xy2.ptr.pp_double[i][0], 1, &xy.ptr.pp_double[i+1][0], 1, ae_v_len(0,m));
                        s2.ptr.p_double[i] = s.ptr.p_double[i+1];
                    }
                    for(i=0; i<=n-1; i++)
                    {
                        
                        /*
                         * Trn
                         */
                        v = ae_v_dotproduct(&xy.ptr.pp_double[i][0], 1, &tmpweights.ptr.p_double[0], 1, ae_v_len(0,m-1));
                        v = v+tmpweights.ptr.p_double[m];
                        rmserror = rmserror+ae_sqr(v-xy.ptr.pp_double[i][m], _state);
                        avgerror = avgerror+ae_fabs(v-xy.ptr.pp_double[i][m], _state);
                        avgrelerror = avgrelerror+ae_fabs((v-xy.ptr.pp_double[i][m])/xy.ptr.pp_double[i][m], _state);
                        
                        /*
                         * CV: non-defect vectors only
                         */
                        nondefect = ae_true;
                        for(k=0; k<=ar.ncvdefects-1; k++)
                        {
                            if( ar.cvdefects.ptr.p_int[k]==i )
                            {
                                nondefect = ae_false;
                            }
                        }
                        if( nondefect )
                        {
                            if( modeltype==0 )
                            {
                                lrbuilds(&xy2, &s2, n-1, m, &info2, &wt, &ar2, _state);
                            }
                            else
                            {
                                lrbuildzs(&xy2, &s2, n-1, m, &info2, &wt, &ar2, _state);
                            }
                            if( info2!=1 )
                            {
                                grconverrors = ae_true;
                                continue;
                            }
                            lrunpack(&wt, &w2, &tmpi, _state);
                            v = ae_v_dotproduct(&xy.ptr.pp_double[i][0], 1, &w2.ptr.p_double[0], 1, ae_v_len(0,m-1));
                            v = v+w2.ptr.p_double[m];
                            cvrmserror = cvrmserror+ae_sqr(v-xy.ptr.pp_double[i][m], _state);
                            cvavgerror = cvavgerror+ae_fabs(v-xy.ptr.pp_double[i][m], _state);
                            cvavgrelerror = cvavgrelerror+ae_fabs((v-xy.ptr.pp_double[i][m])/xy.ptr.pp_double[i][m], _state);
                        }
                        
                        /*
                         * Next set
                         */
                        if( i!=n-1 )
                        {
                            ae_v_move(&xy2.ptr.pp_double[i][0], 1, &xy.ptr.pp_double[i][0], 1, ae_v_len(0,m));
                            s2.ptr.p_double[i] = s.ptr.p_double[i];
                        }
                    }
                    cvrmserror = ae_sqrt(cvrmserror/(n-ar.ncvdefects), _state);
                    cvavgerror = cvavgerror/(n-ar.ncvdefects);
                    cvavgrelerror = cvavgrelerror/(n-ar.ncvdefects);
                    rmserror = ae_sqrt(rmserror/n, _state);
                    avgerror = avgerror/n;
                    avgrelerror = avgrelerror/n;
                    gresterrors = gresterrors||ae_fp_greater(ae_fabs(ae_log(ar.cvrmserror/cvrmserror, _state), _state),ae_log(1+1.0E-5, _state));
                    gresterrors = gresterrors||ae_fp_greater(ae_fabs(ae_log(ar.cvavgerror/cvavgerror, _state), _state),ae_log(1+1.0E-5, _state));
                    gresterrors = gresterrors||ae_fp_greater(ae_fabs(ae_log(ar.cvavgrelerror/cvavgrelerror, _state), _state),ae_log(1+1.0E-5, _state));
                    gresterrors = gresterrors||ae_fp_greater(ae_fabs(ae_log(ar.rmserror/rmserror, _state), _state),ae_log(1+1.0E-5, _state));
                    gresterrors = gresterrors||ae_fp_greater(ae_fabs(ae_log(ar.avgerror/avgerror, _state), _state),ae_log(1+1.0E-5, _state));
                    gresterrors = gresterrors||ae_fp_greater(ae_fabs(ae_log(ar.avgrelerror/avgrelerror, _state), _state),ae_log(1+1.0E-5, _state));
                }
            }
        }
    }
    
    /*
     * Additional subroutines
     */
    for(pass=1; pass<=50; pass++)
    {
        n = 2;
        do
        {
            noiselevel = ae_randomreal(_state)+0.1;
            tasklevel = 2*ae_randomreal(_state)-1;
        }
        while(ae_fp_less_eq(ae_fabs(noiselevel-tasklevel, _state),0.05));
        ae_matrix_set_length(&xy, 3*n-1+1, 1+1, _state);
        for(i=0; i<=n-1; i++)
        {
            xy.ptr.pp_double[3*i+0][0] = (double)(i);
            xy.ptr.pp_double[3*i+1][0] = (double)(i);
            xy.ptr.pp_double[3*i+2][0] = (double)(i);
            xy.ptr.pp_double[3*i+0][1] = tasklevel-noiselevel;
            xy.ptr.pp_double[3*i+1][1] = tasklevel;
            xy.ptr.pp_double[3*i+2][1] = tasklevel+noiselevel;
        }
        lrbuild(&xy, 3*n, 1, &info, &wt, &ar, _state);
        if( info==1 )
        {
            lrunpack(&wt, &tmpweights, &tmpi, _state);
            v = lrrmserror(&wt, &xy, 3*n, _state);
            grothererrors = grothererrors||ae_fp_greater(ae_fabs(v-noiselevel*ae_sqrt((double)2/(double)3, _state), _state),threshold);
            v = lravgerror(&wt, &xy, 3*n, _state);
            grothererrors = grothererrors||ae_fp_greater(ae_fabs(v-noiselevel*((double)2/(double)3), _state),threshold);
            v = lravgrelerror(&wt, &xy, 3*n, _state);
            vv = (ae_fabs(noiselevel/(tasklevel-noiselevel), _state)+ae_fabs(noiselevel/(tasklevel+noiselevel), _state))/3;
            grothererrors = grothererrors||ae_fp_greater(ae_fabs(v-vv, _state),threshold*vv);
        }
        else
        {
            grothererrors = ae_true;
        }
        for(i=0; i<=n-1; i++)
        {
            xy.ptr.pp_double[3*i+0][0] = (double)(i);
            xy.ptr.pp_double[3*i+1][0] = (double)(i);
            xy.ptr.pp_double[3*i+2][0] = (double)(i);
            xy.ptr.pp_double[3*i+0][1] = -noiselevel;
            xy.ptr.pp_double[3*i+1][1] = (double)(0);
            xy.ptr.pp_double[3*i+2][1] = noiselevel;
        }
        lrbuild(&xy, 3*n, 1, &info, &wt, &ar, _state);
        if( info==1 )
        {
            lrunpack(&wt, &tmpweights, &tmpi, _state);
            v = lravgrelerror(&wt, &xy, 3*n, _state);
            grothererrors = grothererrors||ae_fp_greater(ae_fabs(v-1, _state),threshold);
        }
        else
        {
            grothererrors = ae_true;
        }
    }
    for(pass=1; pass<=10; pass++)
    {
        m = 1+ae_randominteger(5, _state);
        n = 10+ae_randominteger(10, _state);
        ae_matrix_set_length(&xy, n-1+1, m+1, _state);
        for(i=0; i<=n-1; i++)
        {
            for(j=0; j<=m; j++)
            {
                xy.ptr.pp_double[i][j] = 2*ae_randomreal(_state)-1;
            }
        }
        lrbuild(&xy, n, m, &info, &w, &ar, _state);
        if( info<0 )
        {
            grothererrors = ae_true;
            break;
        }
        ae_vector_set_length(&x1, m-1+1, _state);
        ae_vector_set_length(&x2, m-1+1, _state);
        
        /*
         * Same inputs on original leads to same outputs
         * on copy created using LRCopy
         */
        testlinregunit_unsetlr(&wt, _state);
        lrcopy(&w, &wt, _state);
        for(i=0; i<=m-1; i++)
        {
            x1.ptr.p_double[i] = 2*ae_randomreal(_state)-1;
            x2.ptr.p_double[i] = x1.ptr.p_double[i];
        }
        y1 = lrprocess(&w, &x1, _state);
        y2 = lrprocess(&wt, &x2, _state);
        allsame = ae_fp_eq(y1,y2);
        grothererrors = grothererrors||!allsame;
    }
    
    /*
     * TODO: Degenerate tests (when design matrix and right part are zero)
     */
    
    /*
     * Final report
     */
    waserrors = (((((slerrors||slcerrors)||gropterrors)||grcoverrors)||gresterrors)||grothererrors)||grconverrors;
    if( !silent )
    {
        printf("REGRESSION TEST\n");
        printf("STRAIGHT LINE REGRESSION:                ");
        if( !slerrors )
        {
            printf("OK\n");
        }
        else
        {
            printf("FAILED\n");
        }
        printf("STRAIGHT LINE REGRESSION CONVERGENCE:    ");
        if( !slcerrors )
        {
            printf("OK\n");
        }
        else
        {
            printf("FAILED\n");
        }
        printf("GENERAL LINEAR REGRESSION:               ");
        if( !((((gropterrors||grcoverrors)||gresterrors)||grothererrors)||grconverrors) )
        {
            printf("OK\n");
        }
        else
        {
            printf("FAILED\n");
        }
        printf("* OPTIMALITY:                            ");
        if( !gropterrors )
        {
            printf("OK\n");
        }
        else
        {
            printf("FAILED\n");
        }
        printf("* COV. MATRIX:                           ");
        if( !grcoverrors )
        {
            printf("OK\n");
        }
        else
        {
            printf("FAILED\n");
        }
        printf("* ERROR ESTIMATES:                       ");
        if( !gresterrors )
        {
            printf("OK\n");
        }
        else
        {
            printf("FAILED\n");
        }
        printf("* CONVERGENCE:                           ");
        if( !grconverrors )
        {
            printf("OK\n");
        }
        else
        {
            printf("FAILED\n");
        }
        printf("* OTHER SUBROUTINES:                     ");
        if( !grothererrors )
        {
            printf("OK\n");
        }
        else
        {
            printf("FAILED\n");
        }
        if( waserrors )
        {
            printf("TEST SUMMARY: FAILED\n");
        }
        else
        {
            printf("TEST SUMMARY: PASSED\n");
        }
        printf("\n\n");
    }
    result = !waserrors;
    ae_frame_leave(_state);
    return result;
}


/*************************************************************************
Single-threaded stub. HPC ALGLIB replaces it by multithreaded code.
*************************************************************************/
ae_bool _pexec_testlinreg(ae_bool silent, ae_state *_state)
{
    return testlinreg(silent, _state);
}


/*************************************************************************
Task generation. Meaningless task, just random numbers.
*************************************************************************/
static void testlinregunit_generaterandomtask(double xl,
     double xr,
     ae_bool randomx,
     double ymin,
     double ymax,
     double smin,
     double smax,
     ae_int_t n,
     /* Real    */ ae_matrix* xy,
     /* Real    */ ae_vector* s,
     ae_state *_state)
{
    ae_int_t i;


    ae_matrix_set_length(xy, n-1+1, 1+1, _state);
    ae_vector_set_length(s, n-1+1, _state);
    for(i=0; i<=n-1; i++)
    {
        if( randomx )
        {
            xy->ptr.pp_double[i][0] = xl+(xr-xl)*ae_randomreal(_state);
        }
        else
        {
            xy->ptr.pp_double[i][0] = xl+(xr-xl)*i/(n-1);
        }
        xy->ptr.pp_double[i][1] = ymin+(ymax-ymin)*ae_randomreal(_state);
        s->ptr.p_double[i] = smin+(smax-smin)*ae_randomreal(_state);
    }
}


/*************************************************************************
Task generation.
*************************************************************************/
static void testlinregunit_generatetask(double a,
     double b,
     double xl,
     double xr,
     ae_bool randomx,
     double smin,
     double smax,
     ae_int_t n,
     /* Real    */ ae_matrix* xy,
     /* Real    */ ae_vector* s,
     ae_state *_state)
{
    ae_int_t i;


    ae_matrix_set_length(xy, n-1+1, 1+1, _state);
    ae_vector_set_length(s, n-1+1, _state);
    for(i=0; i<=n-1; i++)
    {
        if( randomx )
        {
            xy->ptr.pp_double[i][0] = xl+(xr-xl)*ae_randomreal(_state);
        }
        else
        {
            xy->ptr.pp_double[i][0] = xl+(xr-xl)*i/(n-1);
        }
        s->ptr.p_double[i] = smin+(smax-smin)*ae_randomreal(_state);
        xy->ptr.pp_double[i][1] = a+b*xy->ptr.pp_double[i][0]+testlinregunit_generatenormal((double)(0), s->ptr.p_double[i], _state);
    }
}


/*************************************************************************
Task generation.
y[i] are filled based on A, B, X[I], S[I]
*************************************************************************/
static void testlinregunit_filltaskwithy(double a,
     double b,
     ae_int_t n,
     /* Real    */ ae_matrix* xy,
     /* Real    */ ae_vector* s,
     ae_state *_state)
{
    ae_int_t i;


    for(i=0; i<=n-1; i++)
    {
        xy->ptr.pp_double[i][1] = a+b*xy->ptr.pp_double[i][0]+testlinregunit_generatenormal((double)(0), s->ptr.p_double[i], _state);
    }
}


/*************************************************************************
Normal random numbers
*************************************************************************/
static double testlinregunit_generatenormal(double mean,
     double sigma,
     ae_state *_state)
{
    double u;
    double v;
    double sum;
    double result;


    result = mean;
    for(;;)
    {
        u = (2*ae_randominteger(2, _state)-1)*ae_randomreal(_state);
        v = (2*ae_randominteger(2, _state)-1)*ae_randomreal(_state);
        sum = u*u+v*v;
        if( ae_fp_less(sum,(double)(1))&&ae_fp_greater(sum,(double)(0)) )
        {
            sum = ae_sqrt(-2*ae_log(sum, _state)/sum, _state);
            result = sigma*u*sum+mean;
            return result;
        }
    }
    return result;
}


/*************************************************************************
Moments estimates and their errors
*************************************************************************/
static void testlinregunit_calculatemv(/* Real    */ ae_vector* x,
     ae_int_t n,
     double* mean,
     double* means,
     double* stddev,
     double* stddevs,
     ae_state *_state)
{
    ae_int_t i;
    double v1;
    double v2;
    double variance;

    *mean = 0;
    *means = 0;
    *stddev = 0;
    *stddevs = 0;

    *mean = (double)(0);
    *means = (double)(1);
    *stddev = (double)(0);
    *stddevs = (double)(1);
    variance = (double)(0);
    if( n<=1 )
    {
        return;
    }
    
    /*
     * Mean
     */
    for(i=0; i<=n-1; i++)
    {
        *mean = *mean+x->ptr.p_double[i];
    }
    *mean = *mean/n;
    
    /*
     * Variance (using corrected two-pass algorithm)
     */
    if( n!=1 )
    {
        v1 = (double)(0);
        for(i=0; i<=n-1; i++)
        {
            v1 = v1+ae_sqr(x->ptr.p_double[i]-(*mean), _state);
        }
        v2 = (double)(0);
        for(i=0; i<=n-1; i++)
        {
            v2 = v2+(x->ptr.p_double[i]-(*mean));
        }
        v2 = ae_sqr(v2, _state)/n;
        variance = (v1-v2)/(n-1);
        if( ae_fp_less(variance,(double)(0)) )
        {
            variance = (double)(0);
        }
        *stddev = ae_sqrt(variance, _state);
    }
    
    /*
     * Errors
     */
    *means = *stddev/ae_sqrt((double)(n), _state);
    *stddevs = *stddev*ae_sqrt((double)(2), _state)/ae_sqrt((double)(n-1), _state);
}


/*************************************************************************
Unsets LR
*************************************************************************/
static void testlinregunit_unsetlr(linearmodel* lr, ae_state *_state)
{
    ae_frame _frame_block;
    ae_matrix xy;
    ae_int_t info;
    lrreport rep;
    ae_int_t i;

    ae_frame_make(_state, &_frame_block);
    ae_matrix_init(&xy, 0, 0, DT_REAL, _state);
    _lrreport_init(&rep, _state);

    ae_matrix_set_length(&xy, 5+1, 1+1, _state);
    for(i=0; i<=5; i++)
    {
        xy.ptr.pp_double[i][0] = (double)(0);
        xy.ptr.pp_double[i][1] = (double)(0);
    }
    lrbuild(&xy, 6, 1, &info, lr, &rep, _state);
    ae_assert(info>0, "Assertion failed", _state);
    ae_frame_leave(_state);
}








ae_bool testfilters(ae_bool silent, ae_state *_state)
{
    ae_bool waserrors;
    ae_bool smaerrors;
    ae_bool emaerrors;
    ae_bool lrmaerrors;
    ae_bool result;


    smaerrors = testsma(ae_true, _state);
    emaerrors = testema(ae_true, _state);
    lrmaerrors = testlrma(ae_true, _state);
    
    /*
     * Final report
     */
    waserrors = (smaerrors||emaerrors)||lrmaerrors;
    if( !silent )
    {
        printf("FILTERS TEST\n");
        printf("* SMA:                                   ");
        if( !smaerrors )
        {
            printf("OK\n");
        }
        else
        {
            printf("FAILED\n");
        }
        printf("* EMA:                                   ");
        if( !emaerrors )
        {
            printf("OK\n");
        }
        else
        {
            printf("FAILED\n");
        }
        printf("* LRMA:                                  ");
        if( !lrmaerrors )
        {
            printf("OK\n");
        }
        else
        {
            printf("FAILED\n");
        }
        if( waserrors )
        {
            printf("TEST SUMMARY: FAILED\n");
        }
        else
        {
            printf("TEST SUMMARY: PASSED\n");
        }
        printf("\n\n");
    }
    result = !waserrors;
    return result;
}


/*************************************************************************
Single-threaded stub. HPC ALGLIB replaces it by multithreaded code.
*************************************************************************/
ae_bool _pexec_testfilters(ae_bool silent, ae_state *_state)
{
    return testfilters(silent, _state);
}


/*************************************************************************
This function tests SMA(k) filter. It returns True on error.

Additional IsSilent parameter controls detailed error reporting.
*************************************************************************/
ae_bool testsma(ae_bool issilent, ae_state *_state)
{
    ae_frame _frame_block;
    ae_vector x;
    ae_bool precomputederrors;
    ae_bool zerohandlingerrors;
    double threshold;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    ae_vector_init(&x, 0, DT_REAL, _state);

    threshold = 1000*ae_machineepsilon;
    if( !issilent )
    {
        printf("SMA(K) TEST\n");
    }
    
    /*
     * Test several pre-computed problems.
     *
     * NOTE: tests below rely on the fact that floating point
     *       additions and subtractions are exact when dealing
     *       with integer values.
     */
    precomputederrors = ae_false;
    ae_vector_set_length(&x, 1, _state);
    x.ptr.p_double[0] = (double)(7);
    filtersma(&x, 1, 1, _state);
    precomputederrors = precomputederrors||ae_fp_neq(x.ptr.p_double[0],(double)(7));
    ae_vector_set_length(&x, 3, _state);
    x.ptr.p_double[0] = (double)(7);
    x.ptr.p_double[1] = (double)(8);
    x.ptr.p_double[2] = (double)(9);
    filtersma(&x, 3, 1, _state);
    precomputederrors = ((precomputederrors||ae_fp_neq(x.ptr.p_double[0],(double)(7)))||ae_fp_neq(x.ptr.p_double[1],(double)(8)))||ae_fp_neq(x.ptr.p_double[2],(double)(9));
    filtersma(&x, 3, 2, _state);
    precomputederrors = ((precomputederrors||ae_fp_neq(x.ptr.p_double[0],(double)(7)))||ae_fp_neq(x.ptr.p_double[1],7.5))||ae_fp_neq(x.ptr.p_double[2],8.5);
    ae_vector_set_length(&x, 3, _state);
    x.ptr.p_double[0] = (double)(7);
    x.ptr.p_double[1] = (double)(8);
    x.ptr.p_double[2] = (double)(9);
    filtersma(&x, 3, 4, _state);
    precomputederrors = ((precomputederrors||ae_fp_neq(x.ptr.p_double[0],(double)(7)))||ae_fp_neq(x.ptr.p_double[1],7.5))||ae_fp_neq(x.ptr.p_double[2],(double)(8));
    
    /*
     * Test zero-handling:
     * a) when we have non-zero sequence (N1 elements) followed by zero sequence
     *    (N2 elements), then first N1+K-1 elements of the processed sequence are
     *    non-zero, but elements since (N1+K)th must be exactly zero.
     * b) similar property holds for zero sequence followed by non-zero one
     *
     * Naive implementation of SMA does not have such property.
     *
     * NOTE: it is important to initialize X with non-integer elements with long
     * binary mantissas, because this test tries to test behaviour in the presence
     * of roundoff errors, and it will be useless when used with integer inputs.
     */
    zerohandlingerrors = ae_false;
    ae_vector_set_length(&x, 10, _state);
    x.ptr.p_double[0] = ae_sqrt((double)(2), _state);
    x.ptr.p_double[1] = ae_sqrt((double)(3), _state);
    x.ptr.p_double[2] = ae_sqrt((double)(5), _state);
    x.ptr.p_double[3] = ae_sqrt((double)(6), _state);
    x.ptr.p_double[4] = ae_sqrt((double)(7), _state);
    x.ptr.p_double[5] = (double)(0);
    x.ptr.p_double[6] = (double)(0);
    x.ptr.p_double[7] = (double)(0);
    x.ptr.p_double[8] = (double)(0);
    x.ptr.p_double[9] = (double)(0);
    filtersma(&x, 10, 3, _state);
    zerohandlingerrors = zerohandlingerrors||ae_fp_greater(ae_fabs(x.ptr.p_double[0]-ae_sqrt((double)(2), _state), _state),threshold);
    zerohandlingerrors = zerohandlingerrors||ae_fp_greater(ae_fabs(x.ptr.p_double[1]-(ae_sqrt((double)(2), _state)+ae_sqrt((double)(3), _state))/2, _state),threshold);
    zerohandlingerrors = zerohandlingerrors||ae_fp_greater(ae_fabs(x.ptr.p_double[2]-(ae_sqrt((double)(2), _state)+ae_sqrt((double)(3), _state)+ae_sqrt((double)(5), _state))/3, _state),threshold);
    zerohandlingerrors = zerohandlingerrors||ae_fp_greater(ae_fabs(x.ptr.p_double[3]-(ae_sqrt((double)(3), _state)+ae_sqrt((double)(5), _state)+ae_sqrt((double)(6), _state))/3, _state),threshold);
    zerohandlingerrors = zerohandlingerrors||ae_fp_greater(ae_fabs(x.ptr.p_double[4]-(ae_sqrt((double)(5), _state)+ae_sqrt((double)(6), _state)+ae_sqrt((double)(7), _state))/3, _state),threshold);
    zerohandlingerrors = zerohandlingerrors||ae_fp_greater(ae_fabs(x.ptr.p_double[5]-(ae_sqrt((double)(6), _state)+ae_sqrt((double)(7), _state))/3, _state),threshold);
    zerohandlingerrors = zerohandlingerrors||ae_fp_greater(ae_fabs(x.ptr.p_double[6]-ae_sqrt((double)(7), _state)/3, _state),threshold);
    zerohandlingerrors = zerohandlingerrors||ae_fp_neq(x.ptr.p_double[7],(double)(0));
    zerohandlingerrors = zerohandlingerrors||ae_fp_neq(x.ptr.p_double[8],(double)(0));
    zerohandlingerrors = zerohandlingerrors||ae_fp_neq(x.ptr.p_double[9],(double)(0));
    x.ptr.p_double[0] = (double)(0);
    x.ptr.p_double[1] = (double)(0);
    x.ptr.p_double[2] = (double)(0);
    x.ptr.p_double[3] = (double)(0);
    x.ptr.p_double[4] = (double)(0);
    x.ptr.p_double[5] = ae_sqrt((double)(2), _state);
    x.ptr.p_double[6] = ae_sqrt((double)(3), _state);
    x.ptr.p_double[7] = ae_sqrt((double)(5), _state);
    x.ptr.p_double[8] = ae_sqrt((double)(6), _state);
    x.ptr.p_double[9] = ae_sqrt((double)(7), _state);
    filtersma(&x, 10, 3, _state);
    zerohandlingerrors = zerohandlingerrors||ae_fp_neq(x.ptr.p_double[0],(double)(0));
    zerohandlingerrors = zerohandlingerrors||ae_fp_neq(x.ptr.p_double[1],(double)(0));
    zerohandlingerrors = zerohandlingerrors||ae_fp_neq(x.ptr.p_double[2],(double)(0));
    zerohandlingerrors = zerohandlingerrors||ae_fp_neq(x.ptr.p_double[3],(double)(0));
    zerohandlingerrors = zerohandlingerrors||ae_fp_neq(x.ptr.p_double[4],(double)(0));
    zerohandlingerrors = zerohandlingerrors||ae_fp_greater(ae_fabs(x.ptr.p_double[5]-ae_sqrt((double)(2), _state)/3, _state),threshold);
    zerohandlingerrors = zerohandlingerrors||ae_fp_greater(ae_fabs(x.ptr.p_double[6]-(ae_sqrt((double)(2), _state)+ae_sqrt((double)(3), _state))/3, _state),threshold);
    zerohandlingerrors = zerohandlingerrors||ae_fp_greater(ae_fabs(x.ptr.p_double[7]-(ae_sqrt((double)(2), _state)+ae_sqrt((double)(3), _state)+ae_sqrt((double)(5), _state))/3, _state),threshold);
    zerohandlingerrors = zerohandlingerrors||ae_fp_greater(ae_fabs(x.ptr.p_double[8]-(ae_sqrt((double)(3), _state)+ae_sqrt((double)(5), _state)+ae_sqrt((double)(6), _state))/3, _state),threshold);
    zerohandlingerrors = zerohandlingerrors||ae_fp_greater(ae_fabs(x.ptr.p_double[9]-(ae_sqrt((double)(5), _state)+ae_sqrt((double)(6), _state)+ae_sqrt((double)(7), _state))/3, _state),threshold);
    
    /*
     * Final result
     */
    result = precomputederrors||zerohandlingerrors;
    ae_frame_leave(_state);
    return result;
}


/*************************************************************************
This function tests EMA(alpha) filter. It returns True on error.

Additional IsSilent parameter controls detailed error reporting.
*************************************************************************/
ae_bool testema(ae_bool issilent, ae_state *_state)
{
    ae_frame _frame_block;
    ae_vector x;
    ae_bool precomputederrors;
    double threshold;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    ae_vector_init(&x, 0, DT_REAL, _state);

    threshold = 1000*ae_machineepsilon;
    if( !issilent )
    {
        printf("EMA(alpha) TEST\n");
    }
    
    /*
     * Test several pre-computed problems.
     *
     * NOTE: tests below rely on the fact that floating point
     *       additions and subtractions are exact when dealing
     *       with integer values.
     */
    precomputederrors = ae_false;
    ae_vector_set_length(&x, 1, _state);
    x.ptr.p_double[0] = (double)(7);
    filterema(&x, 1, 1.0, _state);
    precomputederrors = precomputederrors||ae_fp_neq(x.ptr.p_double[0],(double)(7));
    filterema(&x, 1, 0.5, _state);
    precomputederrors = precomputederrors||ae_fp_neq(x.ptr.p_double[0],(double)(7));
    ae_vector_set_length(&x, 3, _state);
    x.ptr.p_double[0] = (double)(7);
    x.ptr.p_double[1] = (double)(8);
    x.ptr.p_double[2] = (double)(9);
    filterema(&x, 3, 1.0, _state);
    precomputederrors = ((precomputederrors||ae_fp_neq(x.ptr.p_double[0],(double)(7)))||ae_fp_neq(x.ptr.p_double[1],(double)(8)))||ae_fp_neq(x.ptr.p_double[2],(double)(9));
    filterema(&x, 3, 0.5, _state);
    precomputederrors = ((precomputederrors||ae_fp_neq(x.ptr.p_double[0],(double)(7)))||ae_fp_neq(x.ptr.p_double[1],7.5))||ae_fp_neq(x.ptr.p_double[2],8.25);
    
    /*
     * Final result
     */
    result = precomputederrors;
    ae_frame_leave(_state);
    return result;
}


/*************************************************************************
This function tests LRMA(k) filter. It returns True on error.

Additional IsSilent parameter controls detailed error reporting.
*************************************************************************/
ae_bool testlrma(ae_bool issilent, ae_state *_state)
{
    ae_frame _frame_block;
    ae_vector x;
    ae_bool precomputederrors;
    double threshold;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    ae_vector_init(&x, 0, DT_REAL, _state);

    threshold = 1000*ae_machineepsilon;
    if( !issilent )
    {
        printf("LRMA(K) TEST\n");
    }
    precomputederrors = ae_false;
    
    /*
     * First, check that filter does not changes points for K=1 or K=2
     */
    ae_vector_set_length(&x, 1, _state);
    x.ptr.p_double[0] = (double)(7);
    filterlrma(&x, 1, 1, _state);
    precomputederrors = precomputederrors||ae_fp_neq(x.ptr.p_double[0],(double)(7));
    ae_vector_set_length(&x, 6, _state);
    x.ptr.p_double[0] = (double)(7);
    x.ptr.p_double[1] = (double)(8);
    x.ptr.p_double[2] = (double)(9);
    x.ptr.p_double[3] = (double)(10);
    x.ptr.p_double[4] = (double)(11);
    x.ptr.p_double[5] = (double)(12);
    filterlrma(&x, 6, 1, _state);
    precomputederrors = (((((precomputederrors||ae_fp_neq(x.ptr.p_double[0],(double)(7)))||ae_fp_neq(x.ptr.p_double[1],(double)(8)))||ae_fp_neq(x.ptr.p_double[2],(double)(9)))||ae_fp_neq(x.ptr.p_double[3],(double)(10)))||ae_fp_neq(x.ptr.p_double[4],(double)(11)))||ae_fp_neq(x.ptr.p_double[5],(double)(12));
    filterlrma(&x, 6, 2, _state);
    precomputederrors = (((((precomputederrors||ae_fp_neq(x.ptr.p_double[0],(double)(7)))||ae_fp_neq(x.ptr.p_double[1],(double)(8)))||ae_fp_neq(x.ptr.p_double[2],(double)(9)))||ae_fp_neq(x.ptr.p_double[3],(double)(10)))||ae_fp_neq(x.ptr.p_double[4],(double)(11)))||ae_fp_neq(x.ptr.p_double[5],(double)(12));
    
    /*
     * Check several precomputed problems
     */
    ae_vector_set_length(&x, 6, _state);
    x.ptr.p_double[0] = (double)(7);
    x.ptr.p_double[1] = (double)(8);
    x.ptr.p_double[2] = (double)(9);
    x.ptr.p_double[3] = (double)(10);
    x.ptr.p_double[4] = (double)(11);
    x.ptr.p_double[5] = (double)(12);
    filterlrma(&x, 6, 3, _state);
    precomputederrors = precomputederrors||ae_fp_greater(ae_fabs(x.ptr.p_double[0]-7, _state),threshold);
    precomputederrors = precomputederrors||ae_fp_greater(ae_fabs(x.ptr.p_double[1]-8, _state),threshold);
    precomputederrors = precomputederrors||ae_fp_greater(ae_fabs(x.ptr.p_double[2]-9, _state),threshold);
    precomputederrors = precomputederrors||ae_fp_greater(ae_fabs(x.ptr.p_double[3]-10, _state),threshold);
    precomputederrors = precomputederrors||ae_fp_greater(ae_fabs(x.ptr.p_double[4]-11, _state),threshold);
    precomputederrors = precomputederrors||ae_fp_greater(ae_fabs(x.ptr.p_double[5]-12, _state),threshold);
    ae_vector_set_length(&x, 6, _state);
    x.ptr.p_double[0] = (double)(7);
    x.ptr.p_double[1] = (double)(8);
    x.ptr.p_double[2] = (double)(8);
    x.ptr.p_double[3] = (double)(9);
    x.ptr.p_double[4] = (double)(12);
    x.ptr.p_double[5] = (double)(12);
    filterlrma(&x, 6, 3, _state);
    precomputederrors = precomputederrors||ae_fp_greater(ae_fabs(x.ptr.p_double[0]-7.0000000000, _state),1.0E-5);
    precomputederrors = precomputederrors||ae_fp_greater(ae_fabs(x.ptr.p_double[1]-8.0000000000, _state),1.0E-5);
    precomputederrors = precomputederrors||ae_fp_greater(ae_fabs(x.ptr.p_double[2]-8.1666666667, _state),1.0E-5);
    precomputederrors = precomputederrors||ae_fp_greater(ae_fabs(x.ptr.p_double[3]-8.8333333333, _state),1.0E-5);
    precomputederrors = precomputederrors||ae_fp_greater(ae_fabs(x.ptr.p_double[4]-11.6666666667, _state),1.0E-5);
    precomputederrors = precomputederrors||ae_fp_greater(ae_fabs(x.ptr.p_double[5]-12.5000000000, _state),1.0E-5);
    
    /*
     * Final result
     */
    result = precomputederrors;
    ae_frame_leave(_state);
    return result;
}



static void testevdunit_rmatrixfillsparsea(/* Real    */ ae_matrix* a,
     ae_int_t m,
     ae_int_t n,
     double sparcity,
     ae_state *_state);
static void testevdunit_cmatrixfillsparsea(/* Complex */ ae_matrix* a,
     ae_int_t m,
     ae_int_t n,
     double sparcity,
     ae_state *_state);
static void testevdunit_rmatrixsymmetricsplit(/* Real    */ ae_matrix* a,
     ae_int_t n,
     /* Real    */ ae_matrix* al,
     /* Real    */ ae_matrix* au,
     ae_state *_state);
static void testevdunit_cmatrixhermitiansplit(/* Complex */ ae_matrix* a,
     ae_int_t n,
     /* Complex */ ae_matrix* al,
     /* Complex */ ae_matrix* au,
     ae_state *_state);
static void testevdunit_unset2d(/* Real    */ ae_matrix* a,
     ae_state *_state);
static void testevdunit_cunset2d(/* Complex */ ae_matrix* a,
     ae_state *_state);
static void testevdunit_unset1d(/* Real    */ ae_vector* a,
     ae_state *_state);
static void testevdunit_cunset1d(/* Complex */ ae_vector* a,
     ae_state *_state);
static double testevdunit_tdtestproduct(/* Real    */ ae_vector* d,
     /* Real    */ ae_vector* e,
     ae_int_t n,
     /* Real    */ ae_matrix* z,
     /* Real    */ ae_vector* lambdav,
     ae_state *_state);
static double testevdunit_testproduct(/* Real    */ ae_matrix* a,
     ae_int_t n,
     /* Real    */ ae_matrix* z,
     /* Real    */ ae_vector* lambdav,
     ae_state *_state);
static double testevdunit_testort(/* Real    */ ae_matrix* z,
     ae_int_t n,
     ae_state *_state);
static double testevdunit_testcproduct(/* Complex */ ae_matrix* a,
     ae_int_t n,
     /* Complex */ ae_matrix* z,
     /* Real    */ ae_vector* lambdav,
     ae_state *_state);
static double testevdunit_testcort(/* Complex */ ae_matrix* z,
     ae_int_t n,
     ae_state *_state);
static void testevdunit_testsevdproblem(/* Real    */ ae_matrix* a,
     /* Real    */ ae_matrix* al,
     /* Real    */ ae_matrix* au,
     ae_int_t n,
     double threshold,
     ae_bool* serrors,
     ae_int_t* failc,
     ae_int_t* runs,
     ae_state *_state);
static void testevdunit_testhevdproblem(/* Complex */ ae_matrix* a,
     /* Complex */ ae_matrix* al,
     /* Complex */ ae_matrix* au,
     ae_int_t n,
     double threshold,
     ae_bool* herrors,
     ae_int_t* failc,
     ae_int_t* runs,
     ae_state *_state);
static void testevdunit_testsevdbiproblem(/* Real    */ ae_matrix* afull,
     /* Real    */ ae_matrix* al,
     /* Real    */ ae_matrix* au,
     ae_int_t n,
     ae_bool distvals,
     double threshold,
     ae_bool* serrors,
     ae_int_t* failc,
     ae_int_t* runs,
     ae_state *_state);
static void testevdunit_testhevdbiproblem(/* Complex */ ae_matrix* afull,
     /* Complex */ ae_matrix* al,
     /* Complex */ ae_matrix* au,
     ae_int_t n,
     ae_bool distvals,
     double threshold,
     ae_bool* herrors,
     ae_int_t* failc,
     ae_int_t* runs,
     ae_state *_state);
static void testevdunit_testtdevdproblem(/* Real    */ ae_vector* d,
     /* Real    */ ae_vector* e,
     ae_int_t n,
     double threshold,
     ae_bool* tderrors,
     ae_state *_state);
static void testevdunit_testtdevdbiproblem(/* Real    */ ae_vector* d,
     /* Real    */ ae_vector* e,
     ae_int_t n,
     ae_bool distvals,
     double threshold,
     ae_bool* serrors,
     ae_int_t* failc,
     ae_int_t* runs,
     ae_state *_state);
static void testevdunit_testnsevdproblem(/* Real    */ ae_matrix* a,
     ae_int_t n,
     double threshold,
     ae_bool* nserrors,
     ae_state *_state);
static void testevdunit_testevdset(ae_int_t n,
     double threshold,
     double bithreshold,
     ae_int_t* failc,
     ae_int_t* runs,
     ae_bool* nserrors,
     ae_bool* serrors,
     ae_bool* herrors,
     ae_bool* tderrors,
     ae_bool* sbierrors,
     ae_bool* hbierrors,
     ae_bool* tdbierrors,
     ae_state *_state);





/*************************************************************************
Testing symmetric EVD subroutine
*************************************************************************/
ae_bool testevd(ae_bool silent, ae_state *_state)
{
    ae_frame _frame_block;
    ae_matrix ra;
    ae_int_t n;
    ae_int_t j;
    ae_int_t failc;
    ae_int_t runs;
    double failthreshold;
    double threshold;
    double bithreshold;
    ae_bool waserrors;
    ae_bool nserrors;
    ae_bool serrors;
    ae_bool herrors;
    ae_bool tderrors;
    ae_bool sbierrors;
    ae_bool hbierrors;
    ae_bool tdbierrors;
    ae_bool wfailed;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    ae_matrix_init(&ra, 0, 0, DT_REAL, _state);

    failthreshold = 0.005;
    threshold = 1.0E-8;
    bithreshold = 1.0E-6;
    nserrors = ae_false;
    serrors = ae_false;
    herrors = ae_false;
    tderrors = ae_false;
    sbierrors = ae_false;
    hbierrors = ae_false;
    tdbierrors = ae_false;
    failc = 0;
    runs = 0;
    
    /*
     * Test problems
     */
    for(n=1; n<=ablasblocksize(&ra, _state); n++)
    {
        testevdunit_testevdset(n, threshold, bithreshold, &failc, &runs, &nserrors, &serrors, &herrors, &tderrors, &sbierrors, &hbierrors, &tdbierrors, _state);
    }
    for(j=2; j<=3; j++)
    {
        for(n=j*ablasblocksize(&ra, _state)-1; n<=j*ablasblocksize(&ra, _state)+1; n++)
        {
            testevdunit_testevdset(n, threshold, bithreshold, &failc, &runs, &nserrors, &serrors, &herrors, &tderrors, &sbierrors, &hbierrors, &tdbierrors, _state);
        }
    }
    
    /*
     * report
     */
    wfailed = ae_fp_greater((double)failc/(double)runs,failthreshold);
    waserrors = ((((((nserrors||serrors)||herrors)||tderrors)||sbierrors)||hbierrors)||tdbierrors)||wfailed;
    if( !silent )
    {
        printf("TESTING EVD UNIT\n");
        printf("NS ERRORS:                               ");
        if( !nserrors )
        {
            printf("OK\n");
        }
        else
        {
            printf("FAILED\n");
        }
        printf("S ERRORS:                                ");
        if( !serrors )
        {
            printf("OK\n");
        }
        else
        {
            printf("FAILED\n");
        }
        printf("H ERRORS:                                ");
        if( !herrors )
        {
            printf("OK\n");
        }
        else
        {
            printf("FAILED\n");
        }
        printf("TD ERRORS:                               ");
        if( !tderrors )
        {
            printf("OK\n");
        }
        else
        {
            printf("FAILED\n");
        }
        printf("SBI ERRORS:                              ");
        if( !sbierrors )
        {
            printf("OK\n");
        }
        else
        {
            printf("FAILED\n");
        }
        printf("HBI ERRORS:                              ");
        if( !hbierrors )
        {
            printf("OK\n");
        }
        else
        {
            printf("FAILED\n");
        }
        printf("TDBI ERRORS:                             ");
        if( !tdbierrors )
        {
            printf("OK\n");
        }
        else
        {
            printf("FAILED\n");
        }
        printf("FAILURE THRESHOLD:                       ");
        if( !wfailed )
        {
            printf("OK\n");
        }
        else
        {
            printf("FAILED\n");
        }
        if( waserrors )
        {
            printf("TEST FAILED\n");
        }
        else
        {
            printf("TEST PASSED\n");
        }
        printf("\n\n");
    }
    result = !waserrors;
    ae_frame_leave(_state);
    return result;
}


/*************************************************************************
Single-threaded stub. HPC ALGLIB replaces it by multithreaded code.
*************************************************************************/
ae_bool _pexec_testevd(ae_bool silent, ae_state *_state)
{
    return testevd(silent, _state);
}


/*************************************************************************
Sparse fill
*************************************************************************/
static void testevdunit_rmatrixfillsparsea(/* Real    */ ae_matrix* a,
     ae_int_t m,
     ae_int_t n,
     double sparcity,
     ae_state *_state)
{
    ae_int_t i;
    ae_int_t j;


    for(i=0; i<=m-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            if( ae_fp_greater_eq(ae_randomreal(_state),sparcity) )
            {
                a->ptr.pp_double[i][j] = 2*ae_randomreal(_state)-1;
            }
            else
            {
                a->ptr.pp_double[i][j] = (double)(0);
            }
        }
    }
}


/*************************************************************************
Sparse fill
*************************************************************************/
static void testevdunit_cmatrixfillsparsea(/* Complex */ ae_matrix* a,
     ae_int_t m,
     ae_int_t n,
     double sparcity,
     ae_state *_state)
{
    ae_int_t i;
    ae_int_t j;


    for(i=0; i<=m-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            if( ae_fp_greater_eq(ae_randomreal(_state),sparcity) )
            {
                a->ptr.pp_complex[i][j].x = 2*ae_randomreal(_state)-1;
                a->ptr.pp_complex[i][j].y = 2*ae_randomreal(_state)-1;
            }
            else
            {
                a->ptr.pp_complex[i][j] = ae_complex_from_i(0);
            }
        }
    }
}


/*************************************************************************
Copies A to AL (lower half) and AU (upper half), filling unused parts by
random garbage.
*************************************************************************/
static void testevdunit_rmatrixsymmetricsplit(/* Real    */ ae_matrix* a,
     ae_int_t n,
     /* Real    */ ae_matrix* al,
     /* Real    */ ae_matrix* au,
     ae_state *_state)
{
    ae_int_t i;
    ae_int_t j;


    for(i=0; i<=n-1; i++)
    {
        for(j=i+1; j<=n-1; j++)
        {
            al->ptr.pp_double[i][j] = 2*ae_randomreal(_state)-1;
            al->ptr.pp_double[j][i] = a->ptr.pp_double[i][j];
            au->ptr.pp_double[i][j] = a->ptr.pp_double[i][j];
            au->ptr.pp_double[j][i] = 2*ae_randomreal(_state)-1;
        }
        al->ptr.pp_double[i][i] = a->ptr.pp_double[i][i];
        au->ptr.pp_double[i][i] = a->ptr.pp_double[i][i];
    }
}


/*************************************************************************
Copies A to AL (lower half) and AU (upper half), filling unused parts by
random garbage.
*************************************************************************/
static void testevdunit_cmatrixhermitiansplit(/* Complex */ ae_matrix* a,
     ae_int_t n,
     /* Complex */ ae_matrix* al,
     /* Complex */ ae_matrix* au,
     ae_state *_state)
{
    ae_int_t i;
    ae_int_t j;


    for(i=0; i<=n-1; i++)
    {
        for(j=i+1; j<=n-1; j++)
        {
            al->ptr.pp_complex[i][j] = ae_complex_from_d(2*ae_randomreal(_state)-1);
            al->ptr.pp_complex[j][i] = ae_c_conj(a->ptr.pp_complex[i][j], _state);
            au->ptr.pp_complex[i][j] = a->ptr.pp_complex[i][j];
            au->ptr.pp_complex[j][i] = ae_complex_from_d(2*ae_randomreal(_state)-1);
        }
        al->ptr.pp_complex[i][i] = a->ptr.pp_complex[i][i];
        au->ptr.pp_complex[i][i] = a->ptr.pp_complex[i][i];
    }
}


/*************************************************************************
Unsets 2D array.
*************************************************************************/
static void testevdunit_unset2d(/* Real    */ ae_matrix* a,
     ae_state *_state)
{

    ae_matrix_clear(a);

    if( a->rows*a->cols>0 )
    {
        ae_matrix_set_length(a, 1, 1, _state);
    }
}


/*************************************************************************
Unsets 2D array.
*************************************************************************/
static void testevdunit_cunset2d(/* Complex */ ae_matrix* a,
     ae_state *_state)
{


    ae_matrix_set_length(a, 0+1, 0+1, _state);
    a->ptr.pp_complex[0][0] = ae_complex_from_d(2*ae_randomreal(_state)-1);
}


/*************************************************************************
Unsets 1D array.
*************************************************************************/
static void testevdunit_unset1d(/* Real    */ ae_vector* a,
     ae_state *_state)
{

    ae_vector_clear(a);

    if( a->cnt>0 )
    {
        ae_vector_set_length(a, 1, _state);
    }
}


/*************************************************************************
Unsets 1D array.
*************************************************************************/
static void testevdunit_cunset1d(/* Complex */ ae_vector* a,
     ae_state *_state)
{


    ae_vector_set_length(a, 0+1, _state);
    a->ptr.p_complex[0] = ae_complex_from_d(2*ae_randomreal(_state)-1);
}


/*************************************************************************
Tests Z*Lambda*Z' against tridiag(D,E).
Returns relative error.
*************************************************************************/
static double testevdunit_tdtestproduct(/* Real    */ ae_vector* d,
     /* Real    */ ae_vector* e,
     ae_int_t n,
     /* Real    */ ae_matrix* z,
     /* Real    */ ae_vector* lambdav,
     ae_state *_state)
{
    ae_int_t i;
    ae_int_t j;
    ae_int_t k;
    double v;
    double mx;
    double result;


    result = (double)(0);
    for(i=0; i<=n-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            
            /*
             * Calculate V = A[i,j], A = Z*Lambda*Z'
             */
            v = (double)(0);
            for(k=0; k<=n-1; k++)
            {
                v = v+z->ptr.pp_double[i][k]*lambdav->ptr.p_double[k]*z->ptr.pp_double[j][k];
            }
            
            /*
             * Compare
             */
            if( ae_iabs(i-j, _state)==0 )
            {
                result = ae_maxreal(result, ae_fabs(v-d->ptr.p_double[i], _state), _state);
            }
            if( ae_iabs(i-j, _state)==1 )
            {
                result = ae_maxreal(result, ae_fabs(v-e->ptr.p_double[ae_minint(i, j, _state)], _state), _state);
            }
            if( ae_iabs(i-j, _state)>1 )
            {
                result = ae_maxreal(result, ae_fabs(v, _state), _state);
            }
        }
    }
    mx = (double)(0);
    for(i=0; i<=n-1; i++)
    {
        mx = ae_maxreal(mx, ae_fabs(d->ptr.p_double[i], _state), _state);
    }
    for(i=0; i<=n-2; i++)
    {
        mx = ae_maxreal(mx, ae_fabs(e->ptr.p_double[i], _state), _state);
    }
    if( ae_fp_eq(mx,(double)(0)) )
    {
        mx = (double)(1);
    }
    result = result/mx;
    return result;
}


/*************************************************************************
Tests Z*Lambda*Z' against A
Returns relative error.
*************************************************************************/
static double testevdunit_testproduct(/* Real    */ ae_matrix* a,
     ae_int_t n,
     /* Real    */ ae_matrix* z,
     /* Real    */ ae_vector* lambdav,
     ae_state *_state)
{
    ae_int_t i;
    ae_int_t j;
    ae_int_t k;
    double v;
    double mx;
    double result;


    result = (double)(0);
    for(i=0; i<=n-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            
            /*
             * Calculate V = A[i,j], A = Z*Lambda*Z'
             */
            v = (double)(0);
            for(k=0; k<=n-1; k++)
            {
                v = v+z->ptr.pp_double[i][k]*lambdav->ptr.p_double[k]*z->ptr.pp_double[j][k];
            }
            
            /*
             * Compare
             */
            result = ae_maxreal(result, ae_fabs(v-a->ptr.pp_double[i][j], _state), _state);
        }
    }
    mx = (double)(0);
    for(i=0; i<=n-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            mx = ae_maxreal(mx, ae_fabs(a->ptr.pp_double[i][j], _state), _state);
        }
    }
    if( ae_fp_eq(mx,(double)(0)) )
    {
        mx = (double)(1);
    }
    result = result/mx;
    return result;
}


/*************************************************************************
Tests Z*Z' against diag(1...1)
Returns absolute error.
*************************************************************************/
static double testevdunit_testort(/* Real    */ ae_matrix* z,
     ae_int_t n,
     ae_state *_state)
{
    ae_int_t i;
    ae_int_t j;
    double v;
    double result;


    result = (double)(0);
    for(i=0; i<=n-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            v = ae_v_dotproduct(&z->ptr.pp_double[0][i], z->stride, &z->ptr.pp_double[0][j], z->stride, ae_v_len(0,n-1));
            if( i==j )
            {
                v = v-1;
            }
            result = ae_maxreal(result, ae_fabs(v, _state), _state);
        }
    }
    return result;
}


/*************************************************************************
Tests Z*Lambda*Z' against A
Returns relative error.
*************************************************************************/
static double testevdunit_testcproduct(/* Complex */ ae_matrix* a,
     ae_int_t n,
     /* Complex */ ae_matrix* z,
     /* Real    */ ae_vector* lambdav,
     ae_state *_state)
{
    ae_int_t i;
    ae_int_t j;
    ae_int_t k;
    ae_complex v;
    double mx;
    double result;


    result = (double)(0);
    for(i=0; i<=n-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            
            /*
             * Calculate V = A[i,j], A = Z*Lambda*Z'
             */
            v = ae_complex_from_i(0);
            for(k=0; k<=n-1; k++)
            {
                v = ae_c_add(v,ae_c_mul(ae_c_mul_d(z->ptr.pp_complex[i][k],lambdav->ptr.p_double[k]),ae_c_conj(z->ptr.pp_complex[j][k], _state)));
            }
            
            /*
             * Compare
             */
            result = ae_maxreal(result, ae_c_abs(ae_c_sub(v,a->ptr.pp_complex[i][j]), _state), _state);
        }
    }
    mx = (double)(0);
    for(i=0; i<=n-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            mx = ae_maxreal(mx, ae_c_abs(a->ptr.pp_complex[i][j], _state), _state);
        }
    }
    if( ae_fp_eq(mx,(double)(0)) )
    {
        mx = (double)(1);
    }
    result = result/mx;
    return result;
}


/*************************************************************************
Tests Z*Z' against diag(1...1)
Returns absolute error.
*************************************************************************/
static double testevdunit_testcort(/* Complex */ ae_matrix* z,
     ae_int_t n,
     ae_state *_state)
{
    ae_int_t i;
    ae_int_t j;
    ae_complex v;
    double result;


    result = (double)(0);
    for(i=0; i<=n-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            v = ae_v_cdotproduct(&z->ptr.pp_complex[0][i], z->stride, "N", &z->ptr.pp_complex[0][j], z->stride, "Conj", ae_v_len(0,n-1));
            if( i==j )
            {
                v = ae_c_sub_d(v,1);
            }
            result = ae_maxreal(result, ae_c_abs(v, _state), _state);
        }
    }
    return result;
}


/*************************************************************************
Tests SEVD problem
*************************************************************************/
static void testevdunit_testsevdproblem(/* Real    */ ae_matrix* a,
     /* Real    */ ae_matrix* al,
     /* Real    */ ae_matrix* au,
     ae_int_t n,
     double threshold,
     ae_bool* serrors,
     ae_int_t* failc,
     ae_int_t* runs,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_vector lambdav;
    ae_vector lambdaref;
    ae_matrix z;
    ae_int_t i;

    ae_frame_make(_state, &_frame_block);
    ae_vector_init(&lambdav, 0, DT_REAL, _state);
    ae_vector_init(&lambdaref, 0, DT_REAL, _state);
    ae_matrix_init(&z, 0, 0, DT_REAL, _state);

    
    /*
     * Test simple EVD: values and full vectors, lower A
     */
    testevdunit_unset1d(&lambdaref, _state);
    testevdunit_unset2d(&z, _state);
    *runs = *runs+1;
    if( !smatrixevd(al, n, 1, ae_false, &lambdaref, &z, _state) )
    {
        *failc = *failc+1;
        ae_frame_leave(_state);
        return;
    }
    *serrors = *serrors||ae_fp_greater(testevdunit_testproduct(a, n, &z, &lambdaref, _state),threshold);
    *serrors = *serrors||ae_fp_greater(testevdunit_testort(&z, n, _state),threshold);
    for(i=0; i<=n-2; i++)
    {
        if( ae_fp_less(lambdaref.ptr.p_double[i+1],lambdaref.ptr.p_double[i]) )
        {
            *serrors = ae_true;
            ae_frame_leave(_state);
            return;
        }
    }
    
    /*
     * Test simple EVD: values and full vectors, upper A
     */
    testevdunit_unset1d(&lambdav, _state);
    testevdunit_unset2d(&z, _state);
    *runs = *runs+1;
    if( !smatrixevd(au, n, 1, ae_true, &lambdav, &z, _state) )
    {
        *failc = *failc+1;
        ae_frame_leave(_state);
        return;
    }
    *serrors = *serrors||ae_fp_greater(testevdunit_testproduct(a, n, &z, &lambdav, _state),threshold);
    *serrors = *serrors||ae_fp_greater(testevdunit_testort(&z, n, _state),threshold);
    for(i=0; i<=n-2; i++)
    {
        if( ae_fp_less(lambdav.ptr.p_double[i+1],lambdav.ptr.p_double[i]) )
        {
            *serrors = ae_true;
            ae_frame_leave(_state);
            return;
        }
    }
    
    /*
     * Test simple EVD: values only, lower A
     */
    testevdunit_unset1d(&lambdav, _state);
    testevdunit_unset2d(&z, _state);
    *runs = *runs+1;
    if( !smatrixevd(al, n, 0, ae_false, &lambdav, &z, _state) )
    {
        *failc = *failc+1;
        ae_frame_leave(_state);
        return;
    }
    for(i=0; i<=n-1; i++)
    {
        *serrors = *serrors||ae_fp_greater(ae_fabs(lambdav.ptr.p_double[i]-lambdaref.ptr.p_double[i], _state),threshold);
    }
    
    /*
     * Test simple EVD: values only, upper A
     */
    testevdunit_unset1d(&lambdav, _state);
    testevdunit_unset2d(&z, _state);
    *runs = *runs+1;
    if( !smatrixevd(au, n, 0, ae_true, &lambdav, &z, _state) )
    {
        *failc = *failc+1;
        ae_frame_leave(_state);
        return;
    }
    for(i=0; i<=n-1; i++)
    {
        *serrors = *serrors||ae_fp_greater(ae_fabs(lambdav.ptr.p_double[i]-lambdaref.ptr.p_double[i], _state),threshold);
    }
    ae_frame_leave(_state);
}


/*************************************************************************
Tests SEVD problem
*************************************************************************/
static void testevdunit_testhevdproblem(/* Complex */ ae_matrix* a,
     /* Complex */ ae_matrix* al,
     /* Complex */ ae_matrix* au,
     ae_int_t n,
     double threshold,
     ae_bool* herrors,
     ae_int_t* failc,
     ae_int_t* runs,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_vector lambdav;
    ae_vector lambdaref;
    ae_matrix z;
    ae_int_t i;

    ae_frame_make(_state, &_frame_block);
    ae_vector_init(&lambdav, 0, DT_REAL, _state);
    ae_vector_init(&lambdaref, 0, DT_REAL, _state);
    ae_matrix_init(&z, 0, 0, DT_COMPLEX, _state);

    
    /*
     * Test simple EVD: values and full vectors, lower A
     */
    testevdunit_unset1d(&lambdaref, _state);
    testevdunit_cunset2d(&z, _state);
    *runs = *runs+1;
    if( !hmatrixevd(al, n, 1, ae_false, &lambdaref, &z, _state) )
    {
        *failc = *failc+1;
        ae_frame_leave(_state);
        return;
    }
    *herrors = *herrors||ae_fp_greater(testevdunit_testcproduct(a, n, &z, &lambdaref, _state),threshold);
    *herrors = *herrors||ae_fp_greater(testevdunit_testcort(&z, n, _state),threshold);
    for(i=0; i<=n-2; i++)
    {
        if( ae_fp_less(lambdaref.ptr.p_double[i+1],lambdaref.ptr.p_double[i]) )
        {
            *herrors = ae_true;
            ae_frame_leave(_state);
            return;
        }
    }
    
    /*
     * Test simple EVD: values and full vectors, upper A
     */
    testevdunit_unset1d(&lambdav, _state);
    testevdunit_cunset2d(&z, _state);
    *runs = *runs+1;
    if( !hmatrixevd(au, n, 1, ae_true, &lambdav, &z, _state) )
    {
        *failc = *failc+1;
        ae_frame_leave(_state);
        return;
    }
    *herrors = *herrors||ae_fp_greater(testevdunit_testcproduct(a, n, &z, &lambdav, _state),threshold);
    *herrors = *herrors||ae_fp_greater(testevdunit_testcort(&z, n, _state),threshold);
    for(i=0; i<=n-2; i++)
    {
        if( ae_fp_less(lambdav.ptr.p_double[i+1],lambdav.ptr.p_double[i]) )
        {
            *herrors = ae_true;
            ae_frame_leave(_state);
            return;
        }
    }
    
    /*
     * Test simple EVD: values only, lower A
     */
    testevdunit_unset1d(&lambdav, _state);
    testevdunit_cunset2d(&z, _state);
    *runs = *runs+1;
    if( !hmatrixevd(al, n, 0, ae_false, &lambdav, &z, _state) )
    {
        *failc = *failc+1;
        ae_frame_leave(_state);
        return;
    }
    for(i=0; i<=n-1; i++)
    {
        *herrors = *herrors||ae_fp_greater(ae_fabs(lambdav.ptr.p_double[i]-lambdaref.ptr.p_double[i], _state),threshold);
    }
    
    /*
     * Test simple EVD: values only, upper A
     */
    testevdunit_unset1d(&lambdav, _state);
    testevdunit_cunset2d(&z, _state);
    *runs = *runs+1;
    if( !hmatrixevd(au, n, 0, ae_true, &lambdav, &z, _state) )
    {
        *failc = *failc+1;
        ae_frame_leave(_state);
        return;
    }
    for(i=0; i<=n-1; i++)
    {
        *herrors = *herrors||ae_fp_greater(ae_fabs(lambdav.ptr.p_double[i]-lambdaref.ptr.p_double[i], _state),threshold);
    }
    ae_frame_leave(_state);
}


/*************************************************************************
Tests EVD problem

DistVals    -   is True, when eigenvalues are distinct. Is False, when we
                are solving sparse task with  lots  of  zero  eigenvalues.
                In such cases some tests related to the  eigenvectors  are
                not performed.
*************************************************************************/
static void testevdunit_testsevdbiproblem(/* Real    */ ae_matrix* afull,
     /* Real    */ ae_matrix* al,
     /* Real    */ ae_matrix* au,
     ae_int_t n,
     ae_bool distvals,
     double threshold,
     ae_bool* serrors,
     ae_int_t* failc,
     ae_int_t* runs,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_vector lambdav;
    ae_vector lambdaref;
    ae_matrix z;
    ae_matrix zref;
    ae_matrix a1;
    ae_matrix a2;
    ae_matrix ar;
    ae_int_t i;
    ae_int_t j;
    ae_int_t k;
    ae_int_t m;
    ae_int_t i1;
    ae_int_t i2;
    double v;
    double a;
    double b;

    ae_frame_make(_state, &_frame_block);
    ae_vector_init(&lambdav, 0, DT_REAL, _state);
    ae_vector_init(&lambdaref, 0, DT_REAL, _state);
    ae_matrix_init(&z, 0, 0, DT_REAL, _state);
    ae_matrix_init(&zref, 0, 0, DT_REAL, _state);
    ae_matrix_init(&a1, 0, 0, DT_REAL, _state);
    ae_matrix_init(&a2, 0, 0, DT_REAL, _state);
    ae_matrix_init(&ar, 0, 0, DT_REAL, _state);

    ae_vector_set_length(&lambdaref, n-1+1, _state);
    ae_matrix_set_length(&zref, n-1+1, n-1+1, _state);
    ae_matrix_set_length(&a1, n-1+1, n-1+1, _state);
    ae_matrix_set_length(&a2, n-1+1, n-1+1, _state);
    
    /*
     * Reference EVD
     */
    *runs = *runs+1;
    if( !smatrixevd(afull, n, 1, ae_true, &lambdaref, &zref, _state) )
    {
        *failc = *failc+1;
        ae_frame_leave(_state);
        return;
    }
    
    /*
     * Select random interval boundaries.
     * If there are non-distinct eigenvalues at the boundaries,
     * we move indexes further until values splits. It is done to
     * avoid situations where we can't get definite answer.
     */
    i1 = ae_randominteger(n, _state);
    i2 = i1+ae_randominteger(n-i1, _state);
    while(i1>0)
    {
        if( ae_fp_greater(ae_fabs(lambdaref.ptr.p_double[i1-1]-lambdaref.ptr.p_double[i1], _state),10*threshold) )
        {
            break;
        }
        i1 = i1-1;
    }
    while(i2<n-1)
    {
        if( ae_fp_greater(ae_fabs(lambdaref.ptr.p_double[i2+1]-lambdaref.ptr.p_double[i2], _state),10*threshold) )
        {
            break;
        }
        i2 = i2+1;
    }
    
    /*
     * Select A, B
     */
    if( i1>0 )
    {
        a = 0.5*(lambdaref.ptr.p_double[i1]+lambdaref.ptr.p_double[i1-1]);
    }
    else
    {
        a = lambdaref.ptr.p_double[0]-1;
    }
    if( i2<n-1 )
    {
        b = 0.5*(lambdaref.ptr.p_double[i2]+lambdaref.ptr.p_double[i2+1]);
    }
    else
    {
        b = lambdaref.ptr.p_double[n-1]+1;
    }
    
    /*
     * Test interval, no vectors, lower A
     */
    testevdunit_unset1d(&lambdav, _state);
    testevdunit_unset2d(&z, _state);
    *runs = *runs+1;
    if( !smatrixevdr(al, n, 0, ae_false, a, b, &m, &lambdav, &z, _state) )
    {
        *failc = *failc+1;
        ae_frame_leave(_state);
        return;
    }
    if( m!=i2-i1+1 )
    {
        *failc = *failc+1;
        ae_frame_leave(_state);
        return;
    }
    for(k=0; k<=m-1; k++)
    {
        *serrors = *serrors||ae_fp_greater(ae_fabs(lambdav.ptr.p_double[k]-lambdaref.ptr.p_double[i1+k], _state),threshold);
    }
    
    /*
     * Test interval, no vectors, upper A
     */
    testevdunit_unset1d(&lambdav, _state);
    testevdunit_unset2d(&z, _state);
    *runs = *runs+1;
    if( !smatrixevdr(au, n, 0, ae_true, a, b, &m, &lambdav, &z, _state) )
    {
        *failc = *failc+1;
        ae_frame_leave(_state);
        return;
    }
    if( m!=i2-i1+1 )
    {
        *failc = *failc+1;
        ae_frame_leave(_state);
        return;
    }
    for(k=0; k<=m-1; k++)
    {
        *serrors = *serrors||ae_fp_greater(ae_fabs(lambdav.ptr.p_double[k]-lambdaref.ptr.p_double[i1+k], _state),threshold);
    }
    
    /*
     * Test indexes, no vectors, lower A
     */
    testevdunit_unset1d(&lambdav, _state);
    testevdunit_unset2d(&z, _state);
    *runs = *runs+1;
    if( !smatrixevdi(al, n, 0, ae_false, i1, i2, &lambdav, &z, _state) )
    {
        *failc = *failc+1;
        ae_frame_leave(_state);
        return;
    }
    m = i2-i1+1;
    for(k=0; k<=m-1; k++)
    {
        *serrors = *serrors||ae_fp_greater(ae_fabs(lambdav.ptr.p_double[k]-lambdaref.ptr.p_double[i1+k], _state),threshold);
    }
    
    /*
     * Test indexes, no vectors, upper A
     */
    testevdunit_unset1d(&lambdav, _state);
    testevdunit_unset2d(&z, _state);
    *runs = *runs+1;
    if( !smatrixevdi(au, n, 0, ae_true, i1, i2, &lambdav, &z, _state) )
    {
        *failc = *failc+1;
        ae_frame_leave(_state);
        return;
    }
    m = i2-i1+1;
    for(k=0; k<=m-1; k++)
    {
        *serrors = *serrors||ae_fp_greater(ae_fabs(lambdav.ptr.p_double[k]-lambdaref.ptr.p_double[i1+k], _state),threshold);
    }
    
    /*
     * Test interval, vectors, lower A
     */
    testevdunit_unset1d(&lambdav, _state);
    testevdunit_unset2d(&z, _state);
    *runs = *runs+1;
    if( !smatrixevdr(al, n, 1, ae_false, a, b, &m, &lambdav, &z, _state) )
    {
        *failc = *failc+1;
        ae_frame_leave(_state);
        return;
    }
    if( m!=i2-i1+1 )
    {
        *failc = *failc+1;
        ae_frame_leave(_state);
        return;
    }
    for(k=0; k<=m-1; k++)
    {
        *serrors = *serrors||ae_fp_greater(ae_fabs(lambdav.ptr.p_double[k]-lambdaref.ptr.p_double[i1+k], _state),threshold);
    }
    if( distvals )
    {
        
        /*
         * Distinct eigenvalues, test vectors
         */
        for(j=0; j<=m-1; j++)
        {
            v = ae_v_dotproduct(&z.ptr.pp_double[0][j], z.stride, &zref.ptr.pp_double[0][i1+j], zref.stride, ae_v_len(0,n-1));
            if( ae_fp_less(v,(double)(0)) )
            {
                ae_v_muld(&z.ptr.pp_double[0][j], z.stride, ae_v_len(0,n-1), -1);
            }
        }
        for(i=0; i<=n-1; i++)
        {
            for(j=0; j<=m-1; j++)
            {
                *serrors = *serrors||ae_fp_greater(ae_fabs(z.ptr.pp_double[i][j]-zref.ptr.pp_double[i][i1+j], _state),threshold);
            }
        }
    }
    
    /*
     * Test interval, vectors, upper A
     */
    testevdunit_unset1d(&lambdav, _state);
    testevdunit_unset2d(&z, _state);
    *runs = *runs+1;
    if( !smatrixevdr(au, n, 1, ae_true, a, b, &m, &lambdav, &z, _state) )
    {
        *failc = *failc+1;
        ae_frame_leave(_state);
        return;
    }
    if( m!=i2-i1+1 )
    {
        *failc = *failc+1;
        ae_frame_leave(_state);
        return;
    }
    for(k=0; k<=m-1; k++)
    {
        *serrors = *serrors||ae_fp_greater(ae_fabs(lambdav.ptr.p_double[k]-lambdaref.ptr.p_double[i1+k], _state),threshold);
    }
    if( distvals )
    {
        
        /*
         * Distinct eigenvalues, test vectors
         */
        for(j=0; j<=m-1; j++)
        {
            v = ae_v_dotproduct(&z.ptr.pp_double[0][j], z.stride, &zref.ptr.pp_double[0][i1+j], zref.stride, ae_v_len(0,n-1));
            if( ae_fp_less(v,(double)(0)) )
            {
                ae_v_muld(&z.ptr.pp_double[0][j], z.stride, ae_v_len(0,n-1), -1);
            }
        }
        for(i=0; i<=n-1; i++)
        {
            for(j=0; j<=m-1; j++)
            {
                *serrors = *serrors||ae_fp_greater(ae_fabs(z.ptr.pp_double[i][j]-zref.ptr.pp_double[i][i1+j], _state),threshold);
            }
        }
    }
    
    /*
     * Test indexes, vectors, lower A
     */
    testevdunit_unset1d(&lambdav, _state);
    testevdunit_unset2d(&z, _state);
    *runs = *runs+1;
    if( !smatrixevdi(al, n, 1, ae_false, i1, i2, &lambdav, &z, _state) )
    {
        *failc = *failc+1;
        ae_frame_leave(_state);
        return;
    }
    m = i2-i1+1;
    for(k=0; k<=m-1; k++)
    {
        *serrors = *serrors||ae_fp_greater(ae_fabs(lambdav.ptr.p_double[k]-lambdaref.ptr.p_double[i1+k], _state),threshold);
    }
    if( distvals )
    {
        
        /*
         * Distinct eigenvalues, test vectors
         */
        for(j=0; j<=m-1; j++)
        {
            v = ae_v_dotproduct(&z.ptr.pp_double[0][j], z.stride, &zref.ptr.pp_double[0][i1+j], zref.stride, ae_v_len(0,n-1));
            if( ae_fp_less(v,(double)(0)) )
            {
                ae_v_muld(&z.ptr.pp_double[0][j], z.stride, ae_v_len(0,n-1), -1);
            }
        }
        for(i=0; i<=n-1; i++)
        {
            for(j=0; j<=m-1; j++)
            {
                *serrors = *serrors||ae_fp_greater(ae_fabs(z.ptr.pp_double[i][j]-zref.ptr.pp_double[i][i1+j], _state),threshold);
            }
        }
    }
    
    /*
     * Test indexes, vectors, upper A
     */
    testevdunit_unset1d(&lambdav, _state);
    testevdunit_unset2d(&z, _state);
    *runs = *runs+1;
    if( !smatrixevdi(au, n, 1, ae_true, i1, i2, &lambdav, &z, _state) )
    {
        *failc = *failc+1;
        ae_frame_leave(_state);
        return;
    }
    m = i2-i1+1;
    for(k=0; k<=m-1; k++)
    {
        *serrors = *serrors||ae_fp_greater(ae_fabs(lambdav.ptr.p_double[k]-lambdaref.ptr.p_double[i1+k], _state),threshold);
    }
    if( distvals )
    {
        
        /*
         * Distinct eigenvalues, test vectors
         */
        for(j=0; j<=m-1; j++)
        {
            v = ae_v_dotproduct(&z.ptr.pp_double[0][j], z.stride, &zref.ptr.pp_double[0][i1+j], zref.stride, ae_v_len(0,n-1));
            if( ae_fp_less(v,(double)(0)) )
            {
                ae_v_muld(&z.ptr.pp_double[0][j], z.stride, ae_v_len(0,n-1), -1);
            }
        }
        for(i=0; i<=n-1; i++)
        {
            for(j=0; j<=m-1; j++)
            {
                *serrors = *serrors||ae_fp_greater(ae_fabs(z.ptr.pp_double[i][j]-zref.ptr.pp_double[i][i1+j], _state),threshold);
            }
        }
    }
    ae_frame_leave(_state);
}


/*************************************************************************
Tests EVD problem

DistVals    -   is True, when eigenvalues are distinct. Is False, when we
                are solving sparse task with  lots  of  zero  eigenvalues.
                In such cases some tests related to the  eigenvectors  are
                not performed.
*************************************************************************/
static void testevdunit_testhevdbiproblem(/* Complex */ ae_matrix* afull,
     /* Complex */ ae_matrix* al,
     /* Complex */ ae_matrix* au,
     ae_int_t n,
     ae_bool distvals,
     double threshold,
     ae_bool* herrors,
     ae_int_t* failc,
     ae_int_t* runs,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_vector lambdav;
    ae_vector lambdaref;
    ae_matrix z;
    ae_matrix zref;
    ae_matrix a1;
    ae_matrix a2;
    ae_matrix ar;
    ae_int_t i;
    ae_int_t j;
    ae_int_t k;
    ae_int_t m;
    ae_int_t i1;
    ae_int_t i2;
    ae_complex v;
    double a;
    double b;

    ae_frame_make(_state, &_frame_block);
    ae_vector_init(&lambdav, 0, DT_REAL, _state);
    ae_vector_init(&lambdaref, 0, DT_REAL, _state);
    ae_matrix_init(&z, 0, 0, DT_COMPLEX, _state);
    ae_matrix_init(&zref, 0, 0, DT_COMPLEX, _state);
    ae_matrix_init(&a1, 0, 0, DT_COMPLEX, _state);
    ae_matrix_init(&a2, 0, 0, DT_COMPLEX, _state);
    ae_matrix_init(&ar, 0, 0, DT_COMPLEX, _state);

    ae_vector_set_length(&lambdaref, n-1+1, _state);
    ae_matrix_set_length(&zref, n-1+1, n-1+1, _state);
    ae_matrix_set_length(&a1, n-1+1, n-1+1, _state);
    ae_matrix_set_length(&a2, n-1+1, n-1+1, _state);
    
    /*
     * Reference EVD
     */
    *runs = *runs+1;
    if( !hmatrixevd(afull, n, 1, ae_true, &lambdaref, &zref, _state) )
    {
        *failc = *failc+1;
        ae_frame_leave(_state);
        return;
    }
    
    /*
     * Select random interval boundaries.
     * If there are non-distinct eigenvalues at the boundaries,
     * we move indexes further until values splits. It is done to
     * avoid situations where we can't get definite answer.
     */
    i1 = ae_randominteger(n, _state);
    i2 = i1+ae_randominteger(n-i1, _state);
    while(i1>0)
    {
        if( ae_fp_greater(ae_fabs(lambdaref.ptr.p_double[i1-1]-lambdaref.ptr.p_double[i1], _state),10*threshold) )
        {
            break;
        }
        i1 = i1-1;
    }
    while(i2<n-1)
    {
        if( ae_fp_greater(ae_fabs(lambdaref.ptr.p_double[i2+1]-lambdaref.ptr.p_double[i2], _state),10*threshold) )
        {
            break;
        }
        i2 = i2+1;
    }
    
    /*
     * Select A, B
     */
    if( i1>0 )
    {
        a = 0.5*(lambdaref.ptr.p_double[i1]+lambdaref.ptr.p_double[i1-1]);
    }
    else
    {
        a = lambdaref.ptr.p_double[0]-1;
    }
    if( i2<n-1 )
    {
        b = 0.5*(lambdaref.ptr.p_double[i2]+lambdaref.ptr.p_double[i2+1]);
    }
    else
    {
        b = lambdaref.ptr.p_double[n-1]+1;
    }
    
    /*
     * Test interval, no vectors, lower A
     */
    testevdunit_unset1d(&lambdav, _state);
    testevdunit_cunset2d(&z, _state);
    *runs = *runs+1;
    if( !hmatrixevdr(al, n, 0, ae_false, a, b, &m, &lambdav, &z, _state) )
    {
        *failc = *failc+1;
        ae_frame_leave(_state);
        return;
    }
    if( m!=i2-i1+1 )
    {
        *failc = *failc+1;
        ae_frame_leave(_state);
        return;
    }
    for(k=0; k<=m-1; k++)
    {
        *herrors = *herrors||ae_fp_greater(ae_fabs(lambdav.ptr.p_double[k]-lambdaref.ptr.p_double[i1+k], _state),threshold);
    }
    
    /*
     * Test interval, no vectors, upper A
     */
    testevdunit_unset1d(&lambdav, _state);
    testevdunit_cunset2d(&z, _state);
    *runs = *runs+1;
    if( !hmatrixevdr(au, n, 0, ae_true, a, b, &m, &lambdav, &z, _state) )
    {
        *failc = *failc+1;
        ae_frame_leave(_state);
        return;
    }
    if( m!=i2-i1+1 )
    {
        *failc = *failc+1;
        ae_frame_leave(_state);
        return;
    }
    for(k=0; k<=m-1; k++)
    {
        *herrors = *herrors||ae_fp_greater(ae_fabs(lambdav.ptr.p_double[k]-lambdaref.ptr.p_double[i1+k], _state),threshold);
    }
    
    /*
     * Test indexes, no vectors, lower A
     */
    testevdunit_unset1d(&lambdav, _state);
    testevdunit_cunset2d(&z, _state);
    *runs = *runs+1;
    if( !hmatrixevdi(al, n, 0, ae_false, i1, i2, &lambdav, &z, _state) )
    {
        *failc = *failc+1;
        ae_frame_leave(_state);
        return;
    }
    m = i2-i1+1;
    for(k=0; k<=m-1; k++)
    {
        *herrors = *herrors||ae_fp_greater(ae_fabs(lambdav.ptr.p_double[k]-lambdaref.ptr.p_double[i1+k], _state),threshold);
    }
    
    /*
     * Test indexes, no vectors, upper A
     */
    testevdunit_unset1d(&lambdav, _state);
    testevdunit_cunset2d(&z, _state);
    *runs = *runs+1;
    if( !hmatrixevdi(au, n, 0, ae_true, i1, i2, &lambdav, &z, _state) )
    {
        *failc = *failc+1;
        ae_frame_leave(_state);
        return;
    }
    m = i2-i1+1;
    for(k=0; k<=m-1; k++)
    {
        *herrors = *herrors||ae_fp_greater(ae_fabs(lambdav.ptr.p_double[k]-lambdaref.ptr.p_double[i1+k], _state),threshold);
    }
    
    /*
     * Test interval, vectors, lower A
     */
    testevdunit_unset1d(&lambdav, _state);
    testevdunit_cunset2d(&z, _state);
    *runs = *runs+1;
    if( !hmatrixevdr(al, n, 1, ae_false, a, b, &m, &lambdav, &z, _state) )
    {
        *failc = *failc+1;
        ae_frame_leave(_state);
        return;
    }
    if( m!=i2-i1+1 )
    {
        *failc = *failc+1;
        ae_frame_leave(_state);
        return;
    }
    for(k=0; k<=m-1; k++)
    {
        *herrors = *herrors||ae_fp_greater(ae_fabs(lambdav.ptr.p_double[k]-lambdaref.ptr.p_double[i1+k], _state),threshold);
    }
    if( distvals )
    {
        
        /*
         * Distinct eigenvalues, test vectors
         */
        for(j=0; j<=m-1; j++)
        {
            v = ae_v_cdotproduct(&z.ptr.pp_complex[0][j], z.stride, "N", &zref.ptr.pp_complex[0][i1+j], zref.stride, "Conj", ae_v_len(0,n-1));
            v = ae_c_conj(ae_c_div_d(v,ae_c_abs(v, _state)), _state);
            ae_v_cmulc(&z.ptr.pp_complex[0][j], z.stride, ae_v_len(0,n-1), v);
        }
        for(i=0; i<=n-1; i++)
        {
            for(j=0; j<=m-1; j++)
            {
                *herrors = *herrors||ae_fp_greater(ae_c_abs(ae_c_sub(z.ptr.pp_complex[i][j],zref.ptr.pp_complex[i][i1+j]), _state),threshold);
            }
        }
    }
    
    /*
     * Test interval, vectors, upper A
     */
    testevdunit_unset1d(&lambdav, _state);
    testevdunit_cunset2d(&z, _state);
    *runs = *runs+1;
    if( !hmatrixevdr(au, n, 1, ae_true, a, b, &m, &lambdav, &z, _state) )
    {
        *failc = *failc+1;
        ae_frame_leave(_state);
        return;
    }
    if( m!=i2-i1+1 )
    {
        *failc = *failc+1;
        ae_frame_leave(_state);
        return;
    }
    for(k=0; k<=m-1; k++)
    {
        *herrors = *herrors||ae_fp_greater(ae_fabs(lambdav.ptr.p_double[k]-lambdaref.ptr.p_double[i1+k], _state),threshold);
    }
    if( distvals )
    {
        
        /*
         * Distinct eigenvalues, test vectors
         */
        for(j=0; j<=m-1; j++)
        {
            v = ae_v_cdotproduct(&z.ptr.pp_complex[0][j], z.stride, "N", &zref.ptr.pp_complex[0][i1+j], zref.stride, "Conj", ae_v_len(0,n-1));
            v = ae_c_conj(ae_c_div_d(v,ae_c_abs(v, _state)), _state);
            ae_v_cmulc(&z.ptr.pp_complex[0][j], z.stride, ae_v_len(0,n-1), v);
        }
        for(i=0; i<=n-1; i++)
        {
            for(j=0; j<=m-1; j++)
            {
                *herrors = *herrors||ae_fp_greater(ae_c_abs(ae_c_sub(z.ptr.pp_complex[i][j],zref.ptr.pp_complex[i][i1+j]), _state),threshold);
            }
        }
    }
    
    /*
     * Test indexes, vectors, lower A
     */
    testevdunit_unset1d(&lambdav, _state);
    testevdunit_cunset2d(&z, _state);
    *runs = *runs+1;
    if( !hmatrixevdi(al, n, 1, ae_false, i1, i2, &lambdav, &z, _state) )
    {
        *failc = *failc+1;
        ae_frame_leave(_state);
        return;
    }
    m = i2-i1+1;
    for(k=0; k<=m-1; k++)
    {
        *herrors = *herrors||ae_fp_greater(ae_fabs(lambdav.ptr.p_double[k]-lambdaref.ptr.p_double[i1+k], _state),threshold);
    }
    if( distvals )
    {
        
        /*
         * Distinct eigenvalues, test vectors
         */
        for(j=0; j<=m-1; j++)
        {
            v = ae_v_cdotproduct(&z.ptr.pp_complex[0][j], z.stride, "N", &zref.ptr.pp_complex[0][i1+j], zref.stride, "Conj", ae_v_len(0,n-1));
            v = ae_c_conj(ae_c_div_d(v,ae_c_abs(v, _state)), _state);
            ae_v_cmulc(&z.ptr.pp_complex[0][j], z.stride, ae_v_len(0,n-1), v);
        }
        for(i=0; i<=n-1; i++)
        {
            for(j=0; j<=m-1; j++)
            {
                *herrors = *herrors||ae_fp_greater(ae_c_abs(ae_c_sub(z.ptr.pp_complex[i][j],zref.ptr.pp_complex[i][i1+j]), _state),threshold);
            }
        }
    }
    
    /*
     * Test indexes, vectors, upper A
     */
    testevdunit_unset1d(&lambdav, _state);
    testevdunit_cunset2d(&z, _state);
    *runs = *runs+1;
    if( !hmatrixevdi(au, n, 1, ae_true, i1, i2, &lambdav, &z, _state) )
    {
        *failc = *failc+1;
        ae_frame_leave(_state);
        return;
    }
    m = i2-i1+1;
    for(k=0; k<=m-1; k++)
    {
        *herrors = *herrors||ae_fp_greater(ae_fabs(lambdav.ptr.p_double[k]-lambdaref.ptr.p_double[i1+k], _state),threshold);
    }
    if( distvals )
    {
        
        /*
         * Distinct eigenvalues, test vectors
         */
        for(j=0; j<=m-1; j++)
        {
            v = ae_v_cdotproduct(&z.ptr.pp_complex[0][j], z.stride, "N", &zref.ptr.pp_complex[0][i1+j], zref.stride, "Conj", ae_v_len(0,n-1));
            v = ae_c_conj(ae_c_div_d(v,ae_c_abs(v, _state)), _state);
            ae_v_cmulc(&z.ptr.pp_complex[0][j], z.stride, ae_v_len(0,n-1), v);
        }
        for(i=0; i<=n-1; i++)
        {
            for(j=0; j<=m-1; j++)
            {
                *herrors = *herrors||ae_fp_greater(ae_c_abs(ae_c_sub(z.ptr.pp_complex[i][j],zref.ptr.pp_complex[i][i1+j]), _state),threshold);
            }
        }
    }
    ae_frame_leave(_state);
}


/*************************************************************************
Tests EVD problem
*************************************************************************/
static void testevdunit_testtdevdproblem(/* Real    */ ae_vector* d,
     /* Real    */ ae_vector* e,
     ae_int_t n,
     double threshold,
     ae_bool* tderrors,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_vector lambdav;
    ae_vector ee;
    ae_vector lambda2;
    ae_matrix z;
    ae_matrix zref;
    ae_matrix a1;
    ae_matrix a2;
    ae_bool wsucc;
    ae_int_t i;
    ae_int_t j;
    double v;
    double worstseparation;
    double requiredseparation;
    double specialthreshold;

    ae_frame_make(_state, &_frame_block);
    ae_vector_init(&lambdav, 0, DT_REAL, _state);
    ae_vector_init(&ee, 0, DT_REAL, _state);
    ae_vector_init(&lambda2, 0, DT_REAL, _state);
    ae_matrix_init(&z, 0, 0, DT_REAL, _state);
    ae_matrix_init(&zref, 0, 0, DT_REAL, _state);
    ae_matrix_init(&a1, 0, 0, DT_REAL, _state);
    ae_matrix_init(&a2, 0, 0, DT_REAL, _state);

    ae_vector_set_length(&lambdav, n-1+1, _state);
    ae_vector_set_length(&lambda2, n-1+1, _state);
    ae_matrix_set_length(&zref, n-1+1, n-1+1, _state);
    ae_matrix_set_length(&a1, n-1+1, n-1+1, _state);
    ae_matrix_set_length(&a2, n-1+1, n-1+1, _state);
    if( n>1 )
    {
        ae_vector_set_length(&ee, n-2+1, _state);
    }
    
    /*
     * Test simple EVD: values and full vectors
     */
    for(i=0; i<=n-1; i++)
    {
        lambdav.ptr.p_double[i] = d->ptr.p_double[i];
    }
    for(i=0; i<=n-2; i++)
    {
        ee.ptr.p_double[i] = e->ptr.p_double[i];
    }
    testevdunit_unset2d(&z, _state);
    wsucc = smatrixtdevd(&lambdav, &ee, n, 2, &z, _state);
    if( !wsucc )
    {
        seterrorflag(tderrors, ae_true, _state);
        ae_frame_leave(_state);
        return;
    }
    seterrorflag(tderrors, ae_fp_greater(testevdunit_tdtestproduct(d, e, n, &z, &lambdav, _state),threshold), _state);
    seterrorflag(tderrors, ae_fp_greater(testevdunit_testort(&z, n, _state),threshold), _state);
    for(i=0; i<=n-2; i++)
    {
        if( ae_fp_less(lambdav.ptr.p_double[i+1],lambdav.ptr.p_double[i]) )
        {
            seterrorflag(tderrors, ae_true, _state);
            ae_frame_leave(_state);
            return;
        }
    }
    for(i=0; i<=n-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            zref.ptr.pp_double[i][j] = z.ptr.pp_double[i][j];
        }
    }
    
    /*
     * Test values only variant
     */
    for(i=0; i<=n-1; i++)
    {
        lambda2.ptr.p_double[i] = d->ptr.p_double[i];
    }
    for(i=0; i<=n-2; i++)
    {
        ee.ptr.p_double[i] = e->ptr.p_double[i];
    }
    testevdunit_unset2d(&z, _state);
    wsucc = smatrixtdevd(&lambda2, &ee, n, 0, &z, _state);
    if( !wsucc )
    {
        seterrorflag(tderrors, ae_true, _state);
        ae_frame_leave(_state);
        return;
    }
    for(i=0; i<=n-1; i++)
    {
        seterrorflag(tderrors, ae_fp_greater(ae_fabs(lambda2.ptr.p_double[i]-lambdav.ptr.p_double[i], _state),threshold), _state);
    }
    
    /*
     * Test multiplication variant
     */
    for(i=0; i<=n-1; i++)
    {
        lambda2.ptr.p_double[i] = d->ptr.p_double[i];
    }
    for(i=0; i<=n-2; i++)
    {
        ee.ptr.p_double[i] = e->ptr.p_double[i];
    }
    for(i=0; i<=n-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            a1.ptr.pp_double[i][j] = 2*ae_randomreal(_state)-1;
            a2.ptr.pp_double[i][j] = a1.ptr.pp_double[i][j];
        }
    }
    wsucc = smatrixtdevd(&lambda2, &ee, n, 1, &a1, _state);
    if( !wsucc )
    {
        seterrorflag(tderrors, ae_true, _state);
        ae_frame_leave(_state);
        return;
    }
    for(i=0; i<=n-1; i++)
    {
        seterrorflag(tderrors, ae_fp_greater(ae_fabs(lambda2.ptr.p_double[i]-lambdav.ptr.p_double[i], _state),threshold), _state);
    }
    for(i=0; i<=n-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            v = ae_v_dotproduct(&a2.ptr.pp_double[i][0], 1, &zref.ptr.pp_double[0][j], zref.stride, ae_v_len(0,n-1));
            
            /*
             * next line is a bit complicated because
             * depending on algorithm used we can get either
             * z or -z as eigenvector. so we compare result
             * with both A*ZRef and -A*ZRef
             */
            seterrorflag(tderrors, ae_fp_greater(ae_fabs(v-a1.ptr.pp_double[i][j], _state),threshold)&&ae_fp_greater(ae_fabs(v+a1.ptr.pp_double[i][j], _state),threshold), _state);
        }
    }
    
    /*
     * Test first row variant.
     *
     * NOTE: this test is special because ZNeeded=3 is ALGLIB-specific feature
     *       which is NOT supported by Intel MKL. Thus, MKL-capable version of
     *       ALGLIB will use different algorithms for ZNeeded=3 and for ZNeeded<3.
     *
     *       In most cases it is OK, but when problem happened to be degenerate
     *       (two close eigenvalues), Z computed by ALGLIB may be different from
     *       Z computed by MKL (up to arbitrary rotation), which will lead to
     *       failure of the test, because ZNeeded=2 is used as reference value
     *       for ZNeeded=3.
     *
     *       That's why this test is performed only for well-separated matrices,
     *       and with custom threshold.
     */
    requiredseparation = 1.0E-6;
    specialthreshold = 1.0E-6;
    worstseparation = ae_maxrealnumber;
    for(i=0; i<=n-2; i++)
    {
        worstseparation = ae_minreal(worstseparation, ae_fabs(lambdav.ptr.p_double[i+1]-lambdav.ptr.p_double[i], _state), _state);
    }
    if( ae_fp_greater(worstseparation,requiredseparation) )
    {
        for(i=0; i<=n-1; i++)
        {
            lambda2.ptr.p_double[i] = d->ptr.p_double[i];
        }
        for(i=0; i<=n-2; i++)
        {
            ee.ptr.p_double[i] = e->ptr.p_double[i];
        }
        testevdunit_unset2d(&z, _state);
        wsucc = smatrixtdevd(&lambda2, &ee, n, 3, &z, _state);
        if( !wsucc )
        {
            seterrorflag(tderrors, ae_true, _state);
            ae_frame_leave(_state);
            return;
        }
        for(i=0; i<=n-1; i++)
        {
            seterrorflag(tderrors, ae_fp_greater(ae_fabs(lambda2.ptr.p_double[i]-lambdav.ptr.p_double[i], _state),threshold), _state);
            
            /*
             * next line is a bit complicated because
             * depending on algorithm used we can get either
             * z or -z as eigenvector. so we compare result
             * with both z and -z
             */
            seterrorflag(tderrors, ae_fp_greater(ae_fabs(z.ptr.pp_double[0][i]-zref.ptr.pp_double[0][i], _state),specialthreshold)&&ae_fp_greater(ae_fabs(z.ptr.pp_double[0][i]+zref.ptr.pp_double[0][i], _state),specialthreshold), _state);
        }
    }
    ae_frame_leave(_state);
}


/*************************************************************************
Tests EVD problem

DistVals    -   is True, when eigenvalues are distinct. Is False, when we
                are solving sparse task with  lots  of  zero  eigenvalues.
                In such cases some tests related to the  eigenvectors  are
                not performed.
*************************************************************************/
static void testevdunit_testtdevdbiproblem(/* Real    */ ae_vector* d,
     /* Real    */ ae_vector* e,
     ae_int_t n,
     ae_bool distvals,
     double threshold,
     ae_bool* serrors,
     ae_int_t* failc,
     ae_int_t* runs,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_vector lambdav;
    ae_vector lambdaref;
    ae_matrix z;
    ae_matrix zref;
    ae_matrix a1;
    ae_matrix a2;
    ae_matrix ar;
    ae_int_t i;
    ae_int_t j;
    ae_int_t k;
    ae_int_t m;
    ae_int_t i1;
    ae_int_t i2;
    double v;
    double a;
    double b;

    ae_frame_make(_state, &_frame_block);
    ae_vector_init(&lambdav, 0, DT_REAL, _state);
    ae_vector_init(&lambdaref, 0, DT_REAL, _state);
    ae_matrix_init(&z, 0, 0, DT_REAL, _state);
    ae_matrix_init(&zref, 0, 0, DT_REAL, _state);
    ae_matrix_init(&a1, 0, 0, DT_REAL, _state);
    ae_matrix_init(&a2, 0, 0, DT_REAL, _state);
    ae_matrix_init(&ar, 0, 0, DT_REAL, _state);

    ae_vector_set_length(&lambdaref, n-1+1, _state);
    ae_matrix_set_length(&zref, n-1+1, n-1+1, _state);
    ae_matrix_set_length(&a1, n-1+1, n-1+1, _state);
    ae_matrix_set_length(&a2, n-1+1, n-1+1, _state);
    
    /*
     * Reference EVD
     */
    ae_vector_set_length(&lambdaref, n, _state);
    ae_v_move(&lambdaref.ptr.p_double[0], 1, &d->ptr.p_double[0], 1, ae_v_len(0,n-1));
    *runs = *runs+1;
    if( !smatrixtdevd(&lambdaref, e, n, 2, &zref, _state) )
    {
        *failc = *failc+1;
        ae_frame_leave(_state);
        return;
    }
    
    /*
     * Select random interval boundaries.
     * If there are non-distinct eigenvalues at the boundaries,
     * we move indexes further until values splits. It is done to
     * avoid situations where we can't get definite answer.
     */
    i1 = ae_randominteger(n, _state);
    i2 = i1+ae_randominteger(n-i1, _state);
    while(i1>0)
    {
        if( ae_fp_greater(ae_fabs(lambdaref.ptr.p_double[i1-1]-lambdaref.ptr.p_double[i1], _state),10*threshold) )
        {
            break;
        }
        i1 = i1-1;
    }
    while(i2<n-1)
    {
        if( ae_fp_greater(ae_fabs(lambdaref.ptr.p_double[i2+1]-lambdaref.ptr.p_double[i2], _state),10*threshold) )
        {
            break;
        }
        i2 = i2+1;
    }
    
    /*
     * Test different combinations
     */
    
    /*
     * Select A, B
     */
    if( i1>0 )
    {
        a = 0.5*(lambdaref.ptr.p_double[i1]+lambdaref.ptr.p_double[i1-1]);
    }
    else
    {
        a = lambdaref.ptr.p_double[0]-1;
    }
    if( i2<n-1 )
    {
        b = 0.5*(lambdaref.ptr.p_double[i2]+lambdaref.ptr.p_double[i2+1]);
    }
    else
    {
        b = lambdaref.ptr.p_double[n-1]+1;
    }
    
    /*
     * Test interval, no vectors
     */
    ae_vector_set_length(&lambdav, n-1+1, _state);
    for(i=0; i<=n-1; i++)
    {
        lambdav.ptr.p_double[i] = d->ptr.p_double[i];
    }
    *runs = *runs+1;
    if( !smatrixtdevdr(&lambdav, e, n, 0, a, b, &m, &z, _state) )
    {
        *failc = *failc+1;
        ae_frame_leave(_state);
        return;
    }
    if( m!=i2-i1+1 )
    {
        *failc = *failc+1;
        ae_frame_leave(_state);
        return;
    }
    for(k=0; k<=m-1; k++)
    {
        *serrors = *serrors||ae_fp_greater(ae_fabs(lambdav.ptr.p_double[k]-lambdaref.ptr.p_double[i1+k], _state),threshold);
    }
    
    /*
     * Test indexes, no vectors
     */
    ae_vector_set_length(&lambdav, n-1+1, _state);
    for(i=0; i<=n-1; i++)
    {
        lambdav.ptr.p_double[i] = d->ptr.p_double[i];
    }
    *runs = *runs+1;
    if( !smatrixtdevdi(&lambdav, e, n, 0, i1, i2, &z, _state) )
    {
        *failc = *failc+1;
        ae_frame_leave(_state);
        return;
    }
    m = i2-i1+1;
    for(k=0; k<=m-1; k++)
    {
        *serrors = *serrors||ae_fp_greater(ae_fabs(lambdav.ptr.p_double[k]-lambdaref.ptr.p_double[i1+k], _state),threshold);
    }
    
    /*
     * Test interval, transform vectors
     */
    ae_vector_set_length(&lambdav, n-1+1, _state);
    for(i=0; i<=n-1; i++)
    {
        lambdav.ptr.p_double[i] = d->ptr.p_double[i];
    }
    ae_matrix_set_length(&a1, n-1+1, n-1+1, _state);
    ae_matrix_set_length(&a2, n-1+1, n-1+1, _state);
    for(i=0; i<=n-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            a1.ptr.pp_double[i][j] = 2*ae_randomreal(_state)-1;
            a2.ptr.pp_double[i][j] = a1.ptr.pp_double[i][j];
        }
    }
    *runs = *runs+1;
    if( !smatrixtdevdr(&lambdav, e, n, 1, a, b, &m, &a1, _state) )
    {
        *failc = *failc+1;
        ae_frame_leave(_state);
        return;
    }
    if( m!=i2-i1+1 )
    {
        *failc = *failc+1;
        ae_frame_leave(_state);
        return;
    }
    for(k=0; k<=m-1; k++)
    {
        *serrors = *serrors||ae_fp_greater(ae_fabs(lambdav.ptr.p_double[k]-lambdaref.ptr.p_double[i1+k], _state),threshold);
    }
    if( distvals )
    {
        ae_matrix_set_length(&ar, n-1+1, m-1+1, _state);
        for(i=0; i<=n-1; i++)
        {
            for(j=0; j<=m-1; j++)
            {
                v = ae_v_dotproduct(&a2.ptr.pp_double[i][0], 1, &zref.ptr.pp_double[0][i1+j], zref.stride, ae_v_len(0,n-1));
                ar.ptr.pp_double[i][j] = v;
            }
        }
        for(j=0; j<=m-1; j++)
        {
            v = ae_v_dotproduct(&a1.ptr.pp_double[0][j], a1.stride, &ar.ptr.pp_double[0][j], ar.stride, ae_v_len(0,n-1));
            if( ae_fp_less(v,(double)(0)) )
            {
                ae_v_muld(&ar.ptr.pp_double[0][j], ar.stride, ae_v_len(0,n-1), -1);
            }
        }
        for(i=0; i<=n-1; i++)
        {
            for(j=0; j<=m-1; j++)
            {
                *serrors = *serrors||ae_fp_greater(ae_fabs(a1.ptr.pp_double[i][j]-ar.ptr.pp_double[i][j], _state),threshold);
            }
        }
    }
    
    /*
     * Test indexes, transform vectors
     */
    ae_vector_set_length(&lambdav, n-1+1, _state);
    for(i=0; i<=n-1; i++)
    {
        lambdav.ptr.p_double[i] = d->ptr.p_double[i];
    }
    ae_matrix_set_length(&a1, n-1+1, n-1+1, _state);
    ae_matrix_set_length(&a2, n-1+1, n-1+1, _state);
    for(i=0; i<=n-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            a1.ptr.pp_double[i][j] = 2*ae_randomreal(_state)-1;
            a2.ptr.pp_double[i][j] = a1.ptr.pp_double[i][j];
        }
    }
    *runs = *runs+1;
    if( !smatrixtdevdi(&lambdav, e, n, 1, i1, i2, &a1, _state) )
    {
        *failc = *failc+1;
        ae_frame_leave(_state);
        return;
    }
    m = i2-i1+1;
    for(k=0; k<=m-1; k++)
    {
        *serrors = *serrors||ae_fp_greater(ae_fabs(lambdav.ptr.p_double[k]-lambdaref.ptr.p_double[i1+k], _state),threshold);
    }
    if( distvals )
    {
        ae_matrix_set_length(&ar, n-1+1, m-1+1, _state);
        for(i=0; i<=n-1; i++)
        {
            for(j=0; j<=m-1; j++)
            {
                v = ae_v_dotproduct(&a2.ptr.pp_double[i][0], 1, &zref.ptr.pp_double[0][i1+j], zref.stride, ae_v_len(0,n-1));
                ar.ptr.pp_double[i][j] = v;
            }
        }
        for(j=0; j<=m-1; j++)
        {
            v = ae_v_dotproduct(&a1.ptr.pp_double[0][j], a1.stride, &ar.ptr.pp_double[0][j], ar.stride, ae_v_len(0,n-1));
            if( ae_fp_less(v,(double)(0)) )
            {
                ae_v_muld(&ar.ptr.pp_double[0][j], ar.stride, ae_v_len(0,n-1), -1);
            }
        }
        for(i=0; i<=n-1; i++)
        {
            for(j=0; j<=m-1; j++)
            {
                *serrors = *serrors||ae_fp_greater(ae_fabs(a1.ptr.pp_double[i][j]-ar.ptr.pp_double[i][j], _state),threshold);
            }
        }
    }
    
    /*
     * Test interval, do not transform vectors
     */
    ae_vector_set_length(&lambdav, n-1+1, _state);
    for(i=0; i<=n-1; i++)
    {
        lambdav.ptr.p_double[i] = d->ptr.p_double[i];
    }
    ae_matrix_set_length(&z, 0+1, 0+1, _state);
    *runs = *runs+1;
    if( !smatrixtdevdr(&lambdav, e, n, 2, a, b, &m, &z, _state) )
    {
        *failc = *failc+1;
        ae_frame_leave(_state);
        return;
    }
    if( m!=i2-i1+1 )
    {
        *failc = *failc+1;
        ae_frame_leave(_state);
        return;
    }
    for(k=0; k<=m-1; k++)
    {
        *serrors = *serrors||ae_fp_greater(ae_fabs(lambdav.ptr.p_double[k]-lambdaref.ptr.p_double[i1+k], _state),threshold);
    }
    if( distvals )
    {
        for(j=0; j<=m-1; j++)
        {
            v = ae_v_dotproduct(&z.ptr.pp_double[0][j], z.stride, &zref.ptr.pp_double[0][i1+j], zref.stride, ae_v_len(0,n-1));
            if( ae_fp_less(v,(double)(0)) )
            {
                ae_v_muld(&z.ptr.pp_double[0][j], z.stride, ae_v_len(0,n-1), -1);
            }
        }
        for(i=0; i<=n-1; i++)
        {
            for(j=0; j<=m-1; j++)
            {
                *serrors = *serrors||ae_fp_greater(ae_fabs(z.ptr.pp_double[i][j]-zref.ptr.pp_double[i][i1+j], _state),threshold);
            }
        }
    }
    
    /*
     * Test indexes, do not transform vectors
     */
    ae_vector_set_length(&lambdav, n-1+1, _state);
    for(i=0; i<=n-1; i++)
    {
        lambdav.ptr.p_double[i] = d->ptr.p_double[i];
    }
    ae_matrix_set_length(&z, 0+1, 0+1, _state);
    *runs = *runs+1;
    if( !smatrixtdevdi(&lambdav, e, n, 2, i1, i2, &z, _state) )
    {
        *failc = *failc+1;
        ae_frame_leave(_state);
        return;
    }
    m = i2-i1+1;
    for(k=0; k<=m-1; k++)
    {
        *serrors = *serrors||ae_fp_greater(ae_fabs(lambdav.ptr.p_double[k]-lambdaref.ptr.p_double[i1+k], _state),threshold);
    }
    if( distvals )
    {
        for(j=0; j<=m-1; j++)
        {
            v = ae_v_dotproduct(&z.ptr.pp_double[0][j], z.stride, &zref.ptr.pp_double[0][i1+j], zref.stride, ae_v_len(0,n-1));
            if( ae_fp_less(v,(double)(0)) )
            {
                ae_v_muld(&z.ptr.pp_double[0][j], z.stride, ae_v_len(0,n-1), -1);
            }
        }
        for(i=0; i<=n-1; i++)
        {
            for(j=0; j<=m-1; j++)
            {
                *serrors = *serrors||ae_fp_greater(ae_fabs(z.ptr.pp_double[i][j]-zref.ptr.pp_double[i][i1+j], _state),threshold);
            }
        }
    }
    ae_frame_leave(_state);
}


/*************************************************************************
Non-symmetric problem
*************************************************************************/
static void testevdunit_testnsevdproblem(/* Real    */ ae_matrix* a,
     ae_int_t n,
     double threshold,
     ae_bool* nserrors,
     ae_state *_state)
{
    ae_frame _frame_block;
    double mx;
    ae_int_t i;
    ae_int_t j;
    ae_int_t k;
    ae_int_t vjob;
    ae_bool needl;
    ae_bool needr;
    ae_vector wr0;
    ae_vector wi0;
    ae_vector wr1;
    ae_vector wi1;
    ae_vector wr0s;
    ae_vector wi0s;
    ae_vector wr1s;
    ae_vector wi1s;
    ae_matrix vl;
    ae_matrix vr;
    ae_vector vec1r;
    ae_vector vec1i;
    ae_vector vec2r;
    ae_vector vec2i;
    ae_vector vec3r;
    ae_vector vec3i;
    double curwr;
    double curwi;
    double vt;
    double tmp;
    double vnorm;

    ae_frame_make(_state, &_frame_block);
    ae_vector_init(&wr0, 0, DT_REAL, _state);
    ae_vector_init(&wi0, 0, DT_REAL, _state);
    ae_vector_init(&wr1, 0, DT_REAL, _state);
    ae_vector_init(&wi1, 0, DT_REAL, _state);
    ae_vector_init(&wr0s, 0, DT_REAL, _state);
    ae_vector_init(&wi0s, 0, DT_REAL, _state);
    ae_vector_init(&wr1s, 0, DT_REAL, _state);
    ae_vector_init(&wi1s, 0, DT_REAL, _state);
    ae_matrix_init(&vl, 0, 0, DT_REAL, _state);
    ae_matrix_init(&vr, 0, 0, DT_REAL, _state);
    ae_vector_init(&vec1r, 0, DT_REAL, _state);
    ae_vector_init(&vec1i, 0, DT_REAL, _state);
    ae_vector_init(&vec2r, 0, DT_REAL, _state);
    ae_vector_init(&vec2i, 0, DT_REAL, _state);
    ae_vector_init(&vec3r, 0, DT_REAL, _state);
    ae_vector_init(&vec3i, 0, DT_REAL, _state);

    ae_vector_set_length(&vec1r, n-1+1, _state);
    ae_vector_set_length(&vec2r, n-1+1, _state);
    ae_vector_set_length(&vec3r, n-1+1, _state);
    ae_vector_set_length(&vec1i, n-1+1, _state);
    ae_vector_set_length(&vec2i, n-1+1, _state);
    ae_vector_set_length(&vec3i, n-1+1, _state);
    ae_vector_set_length(&wr0s, n-1+1, _state);
    ae_vector_set_length(&wr1s, n-1+1, _state);
    ae_vector_set_length(&wi0s, n-1+1, _state);
    ae_vector_set_length(&wi1s, n-1+1, _state);
    mx = (double)(0);
    for(i=0; i<=n-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            if( ae_fp_greater(ae_fabs(a->ptr.pp_double[i][j], _state),mx) )
            {
                mx = ae_fabs(a->ptr.pp_double[i][j], _state);
            }
        }
    }
    if( ae_fp_eq(mx,(double)(0)) )
    {
        mx = (double)(1);
    }
    
    /*
     * Load values-only
     */
    if( !rmatrixevd(a, n, 0, &wr0, &wi0, &vl, &vr, _state) )
    {
        seterrorflag(nserrors, ae_true, _state);
        ae_frame_leave(_state);
        return;
    }
    
    /*
     * Test different jobs
     */
    for(vjob=1; vjob<=3; vjob++)
    {
        needr = vjob==1||vjob==3;
        needl = vjob==2||vjob==3;
        if( !rmatrixevd(a, n, vjob, &wr1, &wi1, &vl, &vr, _state) )
        {
            seterrorflag(nserrors, ae_true, _state);
            ae_frame_leave(_state);
            return;
        }
        
        /*
         * Test values:
         * 1. sort by real part
         * 2. test
         */
        ae_v_move(&wr0s.ptr.p_double[0], 1, &wr0.ptr.p_double[0], 1, ae_v_len(0,n-1));
        ae_v_move(&wi0s.ptr.p_double[0], 1, &wi0.ptr.p_double[0], 1, ae_v_len(0,n-1));
        for(i=0; i<=n-1; i++)
        {
            for(j=0; j<=n-2-i; j++)
            {
                if( ae_fp_greater(wr0s.ptr.p_double[j],wr0s.ptr.p_double[j+1]) )
                {
                    tmp = wr0s.ptr.p_double[j];
                    wr0s.ptr.p_double[j] = wr0s.ptr.p_double[j+1];
                    wr0s.ptr.p_double[j+1] = tmp;
                    tmp = wi0s.ptr.p_double[j];
                    wi0s.ptr.p_double[j] = wi0s.ptr.p_double[j+1];
                    wi0s.ptr.p_double[j+1] = tmp;
                }
            }
        }
        ae_v_move(&wr1s.ptr.p_double[0], 1, &wr1.ptr.p_double[0], 1, ae_v_len(0,n-1));
        ae_v_move(&wi1s.ptr.p_double[0], 1, &wi1.ptr.p_double[0], 1, ae_v_len(0,n-1));
        for(i=0; i<=n-1; i++)
        {
            for(j=0; j<=n-2-i; j++)
            {
                if( ae_fp_greater(wr1s.ptr.p_double[j],wr1s.ptr.p_double[j+1]) )
                {
                    tmp = wr1s.ptr.p_double[j];
                    wr1s.ptr.p_double[j] = wr1s.ptr.p_double[j+1];
                    wr1s.ptr.p_double[j+1] = tmp;
                    tmp = wi1s.ptr.p_double[j];
                    wi1s.ptr.p_double[j] = wi1s.ptr.p_double[j+1];
                    wi1s.ptr.p_double[j+1] = tmp;
                }
            }
        }
        for(i=0; i<=n-1; i++)
        {
            seterrorflag(nserrors, ae_fp_greater(ae_fabs(wr0s.ptr.p_double[i]-wr1s.ptr.p_double[i], _state),threshold), _state);
            seterrorflag(nserrors, ae_fp_greater(ae_fabs(wi0s.ptr.p_double[i]-wi1s.ptr.p_double[i], _state),threshold), _state);
        }
        
        /*
         * Test right vectors
         */
        if( needr )
        {
            k = 0;
            while(k<=n-1)
            {
                curwr = (double)(0);
                curwi = (double)(0);
                if( ae_fp_eq(wi1.ptr.p_double[k],(double)(0)) )
                {
                    ae_v_move(&vec1r.ptr.p_double[0], 1, &vr.ptr.pp_double[0][k], vr.stride, ae_v_len(0,n-1));
                    for(i=0; i<=n-1; i++)
                    {
                        vec1i.ptr.p_double[i] = (double)(0);
                    }
                    curwr = wr1.ptr.p_double[k];
                    curwi = (double)(0);
                }
                if( ae_fp_greater(wi1.ptr.p_double[k],(double)(0)) )
                {
                    ae_v_move(&vec1r.ptr.p_double[0], 1, &vr.ptr.pp_double[0][k], vr.stride, ae_v_len(0,n-1));
                    ae_v_move(&vec1i.ptr.p_double[0], 1, &vr.ptr.pp_double[0][k+1], vr.stride, ae_v_len(0,n-1));
                    curwr = wr1.ptr.p_double[k];
                    curwi = wi1.ptr.p_double[k];
                }
                if( ae_fp_less(wi1.ptr.p_double[k],(double)(0)) )
                {
                    ae_v_move(&vec1r.ptr.p_double[0], 1, &vr.ptr.pp_double[0][k-1], vr.stride, ae_v_len(0,n-1));
                    ae_v_moveneg(&vec1i.ptr.p_double[0], 1, &vr.ptr.pp_double[0][k], vr.stride, ae_v_len(0,n-1));
                    curwr = wr1.ptr.p_double[k];
                    curwi = wi1.ptr.p_double[k];
                }
                vnorm = 0.0;
                for(i=0; i<=n-1; i++)
                {
                    vt = ae_v_dotproduct(&a->ptr.pp_double[i][0], 1, &vec1r.ptr.p_double[0], 1, ae_v_len(0,n-1));
                    vec2r.ptr.p_double[i] = vt;
                    vt = ae_v_dotproduct(&a->ptr.pp_double[i][0], 1, &vec1i.ptr.p_double[0], 1, ae_v_len(0,n-1));
                    vec2i.ptr.p_double[i] = vt;
                    vnorm = vnorm+ae_sqr(vec1r.ptr.p_double[i], _state)+ae_sqr(vec1i.ptr.p_double[i], _state);
                }
                vnorm = ae_sqrt(vnorm, _state);
                ae_v_moved(&vec3r.ptr.p_double[0], 1, &vec1r.ptr.p_double[0], 1, ae_v_len(0,n-1), curwr);
                ae_v_subd(&vec3r.ptr.p_double[0], 1, &vec1i.ptr.p_double[0], 1, ae_v_len(0,n-1), curwi);
                ae_v_moved(&vec3i.ptr.p_double[0], 1, &vec1r.ptr.p_double[0], 1, ae_v_len(0,n-1), curwi);
                ae_v_addd(&vec3i.ptr.p_double[0], 1, &vec1i.ptr.p_double[0], 1, ae_v_len(0,n-1), curwr);
                seterrorflag(nserrors, ae_fp_less(vnorm,1.0E-3)||!ae_isfinite(vnorm, _state), _state);
                for(i=0; i<=n-1; i++)
                {
                    seterrorflag(nserrors, ae_fp_greater(ae_fabs(vec2r.ptr.p_double[i]-vec3r.ptr.p_double[i], _state),threshold), _state);
                    seterrorflag(nserrors, ae_fp_greater(ae_fabs(vec2i.ptr.p_double[i]-vec3i.ptr.p_double[i], _state),threshold), _state);
                }
                k = k+1;
            }
        }
        
        /*
         * Test left vectors
         */
        curwr = (double)(0);
        curwi = (double)(0);
        if( needl )
        {
            k = 0;
            while(k<=n-1)
            {
                if( ae_fp_eq(wi1.ptr.p_double[k],(double)(0)) )
                {
                    ae_v_move(&vec1r.ptr.p_double[0], 1, &vl.ptr.pp_double[0][k], vl.stride, ae_v_len(0,n-1));
                    for(i=0; i<=n-1; i++)
                    {
                        vec1i.ptr.p_double[i] = (double)(0);
                    }
                    curwr = wr1.ptr.p_double[k];
                    curwi = (double)(0);
                }
                if( ae_fp_greater(wi1.ptr.p_double[k],(double)(0)) )
                {
                    ae_v_move(&vec1r.ptr.p_double[0], 1, &vl.ptr.pp_double[0][k], vl.stride, ae_v_len(0,n-1));
                    ae_v_move(&vec1i.ptr.p_double[0], 1, &vl.ptr.pp_double[0][k+1], vl.stride, ae_v_len(0,n-1));
                    curwr = wr1.ptr.p_double[k];
                    curwi = wi1.ptr.p_double[k];
                }
                if( ae_fp_less(wi1.ptr.p_double[k],(double)(0)) )
                {
                    ae_v_move(&vec1r.ptr.p_double[0], 1, &vl.ptr.pp_double[0][k-1], vl.stride, ae_v_len(0,n-1));
                    ae_v_moveneg(&vec1i.ptr.p_double[0], 1, &vl.ptr.pp_double[0][k], vl.stride, ae_v_len(0,n-1));
                    curwr = wr1.ptr.p_double[k];
                    curwi = wi1.ptr.p_double[k];
                }
                vnorm = 0.0;
                for(j=0; j<=n-1; j++)
                {
                    vt = ae_v_dotproduct(&vec1r.ptr.p_double[0], 1, &a->ptr.pp_double[0][j], a->stride, ae_v_len(0,n-1));
                    vec2r.ptr.p_double[j] = vt;
                    vt = ae_v_dotproduct(&vec1i.ptr.p_double[0], 1, &a->ptr.pp_double[0][j], a->stride, ae_v_len(0,n-1));
                    vec2i.ptr.p_double[j] = -vt;
                    vnorm = vnorm+ae_sqr(vec1r.ptr.p_double[j], _state)+ae_sqr(vec1i.ptr.p_double[j], _state);
                }
                vnorm = ae_sqrt(vnorm, _state);
                ae_v_moved(&vec3r.ptr.p_double[0], 1, &vec1r.ptr.p_double[0], 1, ae_v_len(0,n-1), curwr);
                ae_v_addd(&vec3r.ptr.p_double[0], 1, &vec1i.ptr.p_double[0], 1, ae_v_len(0,n-1), curwi);
                ae_v_moved(&vec3i.ptr.p_double[0], 1, &vec1r.ptr.p_double[0], 1, ae_v_len(0,n-1), curwi);
                ae_v_addd(&vec3i.ptr.p_double[0], 1, &vec1i.ptr.p_double[0], 1, ae_v_len(0,n-1), -curwr);
                seterrorflag(nserrors, ae_fp_less(vnorm,1.0E-3)||!ae_isfinite(vnorm, _state), _state);
                for(i=0; i<=n-1; i++)
                {
                    seterrorflag(nserrors, ae_fp_greater(ae_fabs(vec2r.ptr.p_double[i]-vec3r.ptr.p_double[i], _state),threshold), _state);
                    seterrorflag(nserrors, ae_fp_greater(ae_fabs(vec2i.ptr.p_double[i]-vec3i.ptr.p_double[i], _state),threshold), _state);
                }
                k = k+1;
            }
        }
    }
    ae_frame_leave(_state);
}


/*************************************************************************
Testing EVD subroutines for one N

NOTES:
* BIThreshold is a threshold for bisection-and-inverse-iteration subroutines.
  special threshold is needed because these subroutines may have much more
  larger error than QR-based algorithms.
*************************************************************************/
static void testevdunit_testevdset(ae_int_t n,
     double threshold,
     double bithreshold,
     ae_int_t* failc,
     ae_int_t* runs,
     ae_bool* nserrors,
     ae_bool* serrors,
     ae_bool* herrors,
     ae_bool* tderrors,
     ae_bool* sbierrors,
     ae_bool* hbierrors,
     ae_bool* tdbierrors,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_matrix ra;
    ae_matrix ral;
    ae_matrix rau;
    ae_matrix ca;
    ae_matrix cal;
    ae_matrix cau;
    ae_vector d;
    ae_vector e;
    ae_int_t i;
    ae_int_t j;
    ae_int_t mkind;

    ae_frame_make(_state, &_frame_block);
    ae_matrix_init(&ra, 0, 0, DT_REAL, _state);
    ae_matrix_init(&ral, 0, 0, DT_REAL, _state);
    ae_matrix_init(&rau, 0, 0, DT_REAL, _state);
    ae_matrix_init(&ca, 0, 0, DT_COMPLEX, _state);
    ae_matrix_init(&cal, 0, 0, DT_COMPLEX, _state);
    ae_matrix_init(&cau, 0, 0, DT_COMPLEX, _state);
    ae_vector_init(&d, 0, DT_REAL, _state);
    ae_vector_init(&e, 0, DT_REAL, _state);

    
    /*
     * Test symmetric problems
     */
    ae_matrix_set_length(&ra, n, n, _state);
    ae_matrix_set_length(&ral, n, n, _state);
    ae_matrix_set_length(&rau, n, n, _state);
    ae_matrix_set_length(&ca, n, n, _state);
    ae_matrix_set_length(&cal, n, n, _state);
    ae_matrix_set_length(&cau, n, n, _state);
    
    /*
     * Zero matrices
     */
    for(i=0; i<=n-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            ra.ptr.pp_double[i][j] = (double)(0);
            ca.ptr.pp_complex[i][j] = ae_complex_from_i(0);
        }
    }
    testevdunit_rmatrixsymmetricsplit(&ra, n, &ral, &rau, _state);
    testevdunit_cmatrixhermitiansplit(&ca, n, &cal, &cau, _state);
    testevdunit_testsevdproblem(&ra, &ral, &rau, n, threshold, serrors, failc, runs, _state);
    testevdunit_testhevdproblem(&ca, &cal, &cau, n, threshold, herrors, failc, runs, _state);
    testevdunit_testsevdbiproblem(&ra, &ral, &rau, n, ae_false, bithreshold, sbierrors, failc, runs, _state);
    testevdunit_testhevdbiproblem(&ca, &cal, &cau, n, ae_false, bithreshold, hbierrors, failc, runs, _state);
    
    /*
     * Random matrix
     */
    for(i=0; i<=n-1; i++)
    {
        for(j=i+1; j<=n-1; j++)
        {
            ra.ptr.pp_double[i][j] = 2*ae_randomreal(_state)-1;
            ca.ptr.pp_complex[i][j].x = 2*ae_randomreal(_state)-1;
            ca.ptr.pp_complex[i][j].y = 2*ae_randomreal(_state)-1;
            ra.ptr.pp_double[j][i] = ra.ptr.pp_double[i][j];
            ca.ptr.pp_complex[j][i] = ae_c_conj(ca.ptr.pp_complex[i][j], _state);
        }
        ra.ptr.pp_double[i][i] = 2*ae_randomreal(_state)-1;
        ca.ptr.pp_complex[i][i] = ae_complex_from_d(2*ae_randomreal(_state)-1);
    }
    testevdunit_rmatrixsymmetricsplit(&ra, n, &ral, &rau, _state);
    testevdunit_cmatrixhermitiansplit(&ca, n, &cal, &cau, _state);
    testevdunit_testsevdproblem(&ra, &ral, &rau, n, threshold, serrors, failc, runs, _state);
    testevdunit_testhevdproblem(&ca, &cal, &cau, n, threshold, herrors, failc, runs, _state);
    
    /*
     * Random diagonally dominant matrix with distinct eigenvalues
     */
    for(i=0; i<=n-1; i++)
    {
        for(j=i+1; j<=n-1; j++)
        {
            ra.ptr.pp_double[i][j] = 0.1*(2*ae_randomreal(_state)-1)/n;
            ca.ptr.pp_complex[i][j].x = 0.1*(2*ae_randomreal(_state)-1)/n;
            ca.ptr.pp_complex[i][j].y = 0.1*(2*ae_randomreal(_state)-1)/n;
            ra.ptr.pp_double[j][i] = ra.ptr.pp_double[i][j];
            ca.ptr.pp_complex[j][i] = ae_c_conj(ca.ptr.pp_complex[i][j], _state);
        }
        ra.ptr.pp_double[i][i] = 0.1*(2*ae_randomreal(_state)-1)+i;
        ca.ptr.pp_complex[i][i] = ae_complex_from_d(0.1*(2*ae_randomreal(_state)-1)+i);
    }
    testevdunit_rmatrixsymmetricsplit(&ra, n, &ral, &rau, _state);
    testevdunit_cmatrixhermitiansplit(&ca, n, &cal, &cau, _state);
    testevdunit_testsevdproblem(&ra, &ral, &rau, n, threshold, serrors, failc, runs, _state);
    testevdunit_testhevdproblem(&ca, &cal, &cau, n, threshold, herrors, failc, runs, _state);
    testevdunit_testsevdbiproblem(&ra, &ral, &rau, n, ae_true, bithreshold, sbierrors, failc, runs, _state);
    testevdunit_testhevdbiproblem(&ca, &cal, &cau, n, ae_true, bithreshold, hbierrors, failc, runs, _state);
    
    /*
     * Sparse matrices
     */
    testevdunit_rmatrixfillsparsea(&ra, n, n, 0.995, _state);
    testevdunit_cmatrixfillsparsea(&ca, n, n, 0.995, _state);
    for(i=0; i<=n-1; i++)
    {
        for(j=i+1; j<=n-1; j++)
        {
            ra.ptr.pp_double[j][i] = ra.ptr.pp_double[i][j];
            ca.ptr.pp_complex[j][i] = ae_c_conj(ca.ptr.pp_complex[i][j], _state);
        }
        ca.ptr.pp_complex[i][i].y = (double)(0);
    }
    testevdunit_rmatrixsymmetricsplit(&ra, n, &ral, &rau, _state);
    testevdunit_cmatrixhermitiansplit(&ca, n, &cal, &cau, _state);
    testevdunit_testsevdproblem(&ra, &ral, &rau, n, threshold, serrors, failc, runs, _state);
    testevdunit_testhevdproblem(&ca, &cal, &cau, n, threshold, herrors, failc, runs, _state);
    testevdunit_testsevdbiproblem(&ra, &ral, &rau, n, ae_false, bithreshold, sbierrors, failc, runs, _state);
    testevdunit_testhevdbiproblem(&ca, &cal, &cau, n, ae_false, bithreshold, hbierrors, failc, runs, _state);
    
    /*
     * testing tridiagonal problems
     */
    for(mkind=0; mkind<=7; mkind++)
    {
        ae_vector_set_length(&d, n, _state);
        if( n>1 )
        {
            ae_vector_set_length(&e, n-1, _state);
        }
        if( mkind==0 )
        {
            
            /*
             * Zero matrix
             */
            for(i=0; i<=n-1; i++)
            {
                d.ptr.p_double[i] = (double)(0);
            }
            for(i=0; i<=n-2; i++)
            {
                e.ptr.p_double[i] = (double)(0);
            }
        }
        if( mkind==1 )
        {
            
            /*
             * Diagonal matrix
             */
            for(i=0; i<=n-1; i++)
            {
                d.ptr.p_double[i] = 2*ae_randomreal(_state)-1;
            }
            for(i=0; i<=n-2; i++)
            {
                e.ptr.p_double[i] = (double)(0);
            }
        }
        if( mkind==2 )
        {
            
            /*
             * Off-diagonal matrix
             */
            for(i=0; i<=n-1; i++)
            {
                d.ptr.p_double[i] = (double)(0);
            }
            for(i=0; i<=n-2; i++)
            {
                e.ptr.p_double[i] = 2*ae_randomreal(_state)-1;
            }
        }
        if( mkind==3 )
        {
            
            /*
             * Dense matrix with blocks
             */
            for(i=0; i<=n-1; i++)
            {
                d.ptr.p_double[i] = 2*ae_randomreal(_state)-1;
            }
            for(i=0; i<=n-2; i++)
            {
                e.ptr.p_double[i] = 2*ae_randomreal(_state)-1;
            }
            j = 1;
            i = 2;
            while(j<=n-2)
            {
                e.ptr.p_double[j] = (double)(0);
                j = j+i;
                i = i+1;
            }
        }
        if( mkind==4 )
        {
            
            /*
             * dense matrix
             */
            for(i=0; i<=n-1; i++)
            {
                d.ptr.p_double[i] = 2*ae_randomreal(_state)-1;
            }
            for(i=0; i<=n-2; i++)
            {
                e.ptr.p_double[i] = 2*ae_randomreal(_state)-1;
            }
        }
        if( mkind==5 )
        {
            
            /*
             * Diagonal matrix with distinct eigenvalues
             */
            for(i=0; i<=n-1; i++)
            {
                d.ptr.p_double[i] = 0.1*(2*ae_randomreal(_state)-1)+i;
            }
            for(i=0; i<=n-2; i++)
            {
                e.ptr.p_double[i] = (double)(0);
            }
        }
        if( mkind==6 )
        {
            
            /*
             * Off-diagonal matrix with distinct eigenvalues
             */
            for(i=0; i<=n-1; i++)
            {
                d.ptr.p_double[i] = (double)(0);
            }
            for(i=0; i<=n-2; i++)
            {
                e.ptr.p_double[i] = 0.1*(2*ae_randomreal(_state)-1)+i+1;
            }
        }
        if( mkind==7 )
        {
            
            /*
             * dense matrix with distinct eigenvalues
             */
            for(i=0; i<=n-1; i++)
            {
                d.ptr.p_double[i] = 0.1*(2*ae_randomreal(_state)-1)+i+1;
            }
            for(i=0; i<=n-2; i++)
            {
                e.ptr.p_double[i] = 0.1*(2*ae_randomreal(_state)-1);
            }
        }
        testevdunit_testtdevdproblem(&d, &e, n, threshold, tderrors, _state);
        testevdunit_testtdevdbiproblem(&d, &e, n, (mkind==5||mkind==6)||mkind==7, bithreshold, tdbierrors, failc, runs, _state);
    }
    
    /*
     * Test non-symmetric problems
     */
    
    /*
     * Test non-symmetric problems: zero, random, sparse matrices.
     */
    ae_matrix_set_length(&ra, n, n, _state);
    ae_matrix_set_length(&ca, n, n, _state);
    for(i=0; i<=n-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            ra.ptr.pp_double[i][j] = (double)(0);
            ca.ptr.pp_complex[i][j] = ae_complex_from_i(0);
        }
    }
    testevdunit_testnsevdproblem(&ra, n, threshold, nserrors, _state);
    for(i=0; i<=n-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            ra.ptr.pp_double[i][j] = 2*ae_randomreal(_state)-1;
            ca.ptr.pp_complex[i][j].x = 2*ae_randomreal(_state)-1;
            ca.ptr.pp_complex[i][j].y = 2*ae_randomreal(_state)-1;
        }
    }
    testevdunit_testnsevdproblem(&ra, n, threshold, nserrors, _state);
    testevdunit_rmatrixfillsparsea(&ra, n, n, 0.995, _state);
    testevdunit_cmatrixfillsparsea(&ca, n, n, 0.995, _state);
    testevdunit_testnsevdproblem(&ra, n, threshold, nserrors, _state);
    ae_frame_leave(_state);
}



static ae_int_t testmatgenunit_maxsvditerations = 60;
static void testmatgenunit_unset2d(/* Real    */ ae_matrix* a,
     ae_state *_state);
static void testmatgenunit_unset2dc(/* Complex */ ae_matrix* a,
     ae_state *_state);
static ae_bool testmatgenunit_isspd(/* Real    */ ae_matrix* a,
     ae_int_t n,
     ae_bool isupper,
     ae_state *_state);
static ae_bool testmatgenunit_ishpd(/* Complex */ ae_matrix* a,
     ae_int_t n,
     ae_state *_state);
static ae_bool testmatgenunit_testeult(ae_state *_state);
static double testmatgenunit_svdcond(/* Real    */ ae_matrix* a,
     ae_int_t n,
     ae_state *_state);
static ae_bool testmatgenunit_obsoletesvddecomposition(/* Real    */ ae_matrix* a,
     ae_int_t m,
     ae_int_t n,
     /* Real    */ ae_vector* w,
     /* Real    */ ae_matrix* v,
     ae_state *_state);
static double testmatgenunit_extsign(double a, double b, ae_state *_state);
static double testmatgenunit_mymax(double a, double b, ae_state *_state);
static double testmatgenunit_pythag(double a, double b, ae_state *_state);





ae_bool testmatgen(ae_bool silent, ae_state *_state)
{
    ae_frame _frame_block;
    ae_matrix a;
    ae_matrix b;
    ae_matrix u;
    ae_matrix v;
    ae_matrix ca;
    ae_matrix cb;
    ae_matrix r1;
    ae_matrix r2;
    ae_matrix c1;
    ae_matrix c2;
    ae_vector w;
    ae_int_t n;
    ae_int_t maxn;
    ae_int_t i;
    ae_int_t j;
    ae_int_t pass;
    ae_int_t passcount;
    ae_bool waserrors;
    double cond;
    double threshold;
    double vt;
    ae_complex ct;
    double minw;
    double maxw;
    ae_bool serr;
    ae_bool herr;
    ae_bool spderr;
    ae_bool hpderr;
    ae_bool rerr;
    ae_bool cerr;
    ae_bool eulerr;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    ae_matrix_init(&a, 0, 0, DT_REAL, _state);
    ae_matrix_init(&b, 0, 0, DT_REAL, _state);
    ae_matrix_init(&u, 0, 0, DT_REAL, _state);
    ae_matrix_init(&v, 0, 0, DT_REAL, _state);
    ae_matrix_init(&ca, 0, 0, DT_COMPLEX, _state);
    ae_matrix_init(&cb, 0, 0, DT_COMPLEX, _state);
    ae_matrix_init(&r1, 0, 0, DT_REAL, _state);
    ae_matrix_init(&r2, 0, 0, DT_REAL, _state);
    ae_matrix_init(&c1, 0, 0, DT_COMPLEX, _state);
    ae_matrix_init(&c2, 0, 0, DT_COMPLEX, _state);
    ae_vector_init(&w, 0, DT_REAL, _state);

    rerr = ae_false;
    cerr = ae_false;
    serr = ae_false;
    herr = ae_false;
    spderr = ae_false;
    hpderr = ae_false;
    eulerr = ae_false;
    waserrors = ae_false;
    maxn = 20;
    passcount = 15;
    threshold = 1000*ae_machineepsilon;
    
    /*
     * Testing orthogonal
     */
    for(n=1; n<=maxn; n++)
    {
        for(pass=1; pass<=passcount; pass++)
        {
            ae_matrix_set_length(&r1, n-1+1, 2*n-1+1, _state);
            ae_matrix_set_length(&r2, 2*n-1+1, n-1+1, _state);
            ae_matrix_set_length(&c1, n-1+1, 2*n-1+1, _state);
            ae_matrix_set_length(&c2, 2*n-1+1, n-1+1, _state);
            
            /*
             * Random orthogonal, real
             */
            testmatgenunit_unset2d(&a, _state);
            testmatgenunit_unset2d(&b, _state);
            rmatrixrndorthogonal(n, &a, _state);
            rmatrixrndorthogonal(n, &b, _state);
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    
                    /*
                     * orthogonality test
                     */
                    vt = ae_v_dotproduct(&a.ptr.pp_double[i][0], 1, &a.ptr.pp_double[j][0], 1, ae_v_len(0,n-1));
                    if( i==j )
                    {
                        rerr = rerr||ae_fp_greater(ae_fabs(vt-1, _state),threshold);
                    }
                    else
                    {
                        rerr = rerr||ae_fp_greater(ae_fabs(vt, _state),threshold);
                    }
                    vt = ae_v_dotproduct(&b.ptr.pp_double[i][0], 1, &b.ptr.pp_double[j][0], 1, ae_v_len(0,n-1));
                    if( i==j )
                    {
                        rerr = rerr||ae_fp_greater(ae_fabs(vt-1, _state),threshold);
                    }
                    else
                    {
                        rerr = rerr||ae_fp_greater(ae_fabs(vt, _state),threshold);
                    }
                    
                    /*
                     * test for difference in A and B
                     */
                    if( n>=2 )
                    {
                        rerr = rerr||ae_fp_eq(a.ptr.pp_double[i][j],b.ptr.pp_double[i][j]);
                    }
                }
            }
            
            /*
             * Random orthogonal, complex
             */
            testmatgenunit_unset2dc(&ca, _state);
            testmatgenunit_unset2dc(&cb, _state);
            cmatrixrndorthogonal(n, &ca, _state);
            cmatrixrndorthogonal(n, &cb, _state);
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    
                    /*
                     * orthogonality test
                     */
                    ct = ae_v_cdotproduct(&ca.ptr.pp_complex[i][0], 1, "N", &ca.ptr.pp_complex[j][0], 1, "Conj", ae_v_len(0,n-1));
                    if( i==j )
                    {
                        cerr = cerr||ae_fp_greater(ae_c_abs(ae_c_sub_d(ct,1), _state),threshold);
                    }
                    else
                    {
                        cerr = cerr||ae_fp_greater(ae_c_abs(ct, _state),threshold);
                    }
                    ct = ae_v_cdotproduct(&cb.ptr.pp_complex[i][0], 1, "N", &cb.ptr.pp_complex[j][0], 1, "Conj", ae_v_len(0,n-1));
                    if( i==j )
                    {
                        cerr = cerr||ae_fp_greater(ae_c_abs(ae_c_sub_d(ct,1), _state),threshold);
                    }
                    else
                    {
                        cerr = cerr||ae_fp_greater(ae_c_abs(ct, _state),threshold);
                    }
                    
                    /*
                     * test for difference in A and B
                     */
                    if( n>=2 )
                    {
                        cerr = cerr||ae_c_eq(ca.ptr.pp_complex[i][j],cb.ptr.pp_complex[i][j]);
                    }
                }
            }
            
            /*
             * From the right real tests:
             * 1. E*Q is orthogonal
             * 2. Q1<>Q2 (routine result is changing)
             * 3. (E E)'*Q = (Q' Q')' (correct handling of non-square matrices)
             */
            testmatgenunit_unset2d(&a, _state);
            testmatgenunit_unset2d(&b, _state);
            ae_matrix_set_length(&a, n-1+1, n-1+1, _state);
            ae_matrix_set_length(&b, n-1+1, n-1+1, _state);
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    a.ptr.pp_double[i][j] = (double)(0);
                    b.ptr.pp_double[i][j] = (double)(0);
                }
                a.ptr.pp_double[i][i] = (double)(1);
                b.ptr.pp_double[i][i] = (double)(1);
            }
            rmatrixrndorthogonalfromtheright(&a, n, n, _state);
            rmatrixrndorthogonalfromtheright(&b, n, n, _state);
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    
                    /*
                     * orthogonality test
                     */
                    vt = ae_v_dotproduct(&a.ptr.pp_double[i][0], 1, &a.ptr.pp_double[j][0], 1, ae_v_len(0,n-1));
                    if( i==j )
                    {
                        rerr = rerr||ae_fp_greater(ae_fabs(vt-1, _state),threshold);
                    }
                    else
                    {
                        rerr = rerr||ae_fp_greater(ae_fabs(vt, _state),threshold);
                    }
                    vt = ae_v_dotproduct(&b.ptr.pp_double[i][0], 1, &b.ptr.pp_double[j][0], 1, ae_v_len(0,n-1));
                    if( i==j )
                    {
                        rerr = rerr||ae_fp_greater(ae_fabs(vt-1, _state),threshold);
                    }
                    else
                    {
                        rerr = rerr||ae_fp_greater(ae_fabs(vt, _state),threshold);
                    }
                    
                    /*
                     * test for difference in A and B
                     */
                    if( n>=2 )
                    {
                        rerr = rerr||ae_fp_eq(a.ptr.pp_double[i][j],b.ptr.pp_double[i][j]);
                    }
                }
            }
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    r2.ptr.pp_double[i][j] = 2*ae_randomreal(_state)-1;
                    r2.ptr.pp_double[i+n][j] = r2.ptr.pp_double[i][j];
                }
            }
            rmatrixrndorthogonalfromtheright(&r2, 2*n, n, _state);
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    rerr = rerr||ae_fp_greater(ae_fabs(r2.ptr.pp_double[i+n][j]-r2.ptr.pp_double[i][j], _state),threshold);
                }
            }
            
            /*
             * From the left real tests:
             * 1. Q*E is orthogonal
             * 2. Q1<>Q2 (routine result is changing)
             * 3. Q*(E E) = (Q Q) (correct handling of non-square matrices)
             */
            testmatgenunit_unset2d(&a, _state);
            testmatgenunit_unset2d(&b, _state);
            ae_matrix_set_length(&a, n-1+1, n-1+1, _state);
            ae_matrix_set_length(&b, n-1+1, n-1+1, _state);
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    a.ptr.pp_double[i][j] = (double)(0);
                    b.ptr.pp_double[i][j] = (double)(0);
                }
                a.ptr.pp_double[i][i] = (double)(1);
                b.ptr.pp_double[i][i] = (double)(1);
            }
            rmatrixrndorthogonalfromtheleft(&a, n, n, _state);
            rmatrixrndorthogonalfromtheleft(&b, n, n, _state);
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    
                    /*
                     * orthogonality test
                     */
                    vt = ae_v_dotproduct(&a.ptr.pp_double[i][0], 1, &a.ptr.pp_double[j][0], 1, ae_v_len(0,n-1));
                    if( i==j )
                    {
                        rerr = rerr||ae_fp_greater(ae_fabs(vt-1, _state),threshold);
                    }
                    else
                    {
                        rerr = rerr||ae_fp_greater(ae_fabs(vt, _state),threshold);
                    }
                    vt = ae_v_dotproduct(&b.ptr.pp_double[i][0], 1, &b.ptr.pp_double[j][0], 1, ae_v_len(0,n-1));
                    if( i==j )
                    {
                        rerr = rerr||ae_fp_greater(ae_fabs(vt-1, _state),threshold);
                    }
                    else
                    {
                        rerr = rerr||ae_fp_greater(ae_fabs(vt, _state),threshold);
                    }
                    
                    /*
                     * test for difference in A and B
                     */
                    if( n>=2 )
                    {
                        rerr = rerr||ae_fp_eq(a.ptr.pp_double[i][j],b.ptr.pp_double[i][j]);
                    }
                }
            }
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    r1.ptr.pp_double[i][j] = 2*ae_randomreal(_state)-1;
                    r1.ptr.pp_double[i][j+n] = r1.ptr.pp_double[i][j];
                }
            }
            rmatrixrndorthogonalfromtheleft(&r1, n, 2*n, _state);
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    rerr = rerr||ae_fp_greater(ae_fabs(r1.ptr.pp_double[i][j]-r1.ptr.pp_double[i][j+n], _state),threshold);
                }
            }
            
            /*
             * From the right complex tests:
             * 1. E*Q is orthogonal
             * 2. Q1<>Q2 (routine result is changing)
             * 3. (E E)'*Q = (Q' Q')' (correct handling of non-square matrices)
             */
            testmatgenunit_unset2dc(&ca, _state);
            testmatgenunit_unset2dc(&cb, _state);
            ae_matrix_set_length(&ca, n-1+1, n-1+1, _state);
            ae_matrix_set_length(&cb, n-1+1, n-1+1, _state);
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    ca.ptr.pp_complex[i][j] = ae_complex_from_i(0);
                    cb.ptr.pp_complex[i][j] = ae_complex_from_i(0);
                }
                ca.ptr.pp_complex[i][i] = ae_complex_from_i(1);
                cb.ptr.pp_complex[i][i] = ae_complex_from_i(1);
            }
            cmatrixrndorthogonalfromtheright(&ca, n, n, _state);
            cmatrixrndorthogonalfromtheright(&cb, n, n, _state);
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    
                    /*
                     * orthogonality test
                     */
                    ct = ae_v_cdotproduct(&ca.ptr.pp_complex[i][0], 1, "N", &ca.ptr.pp_complex[j][0], 1, "Conj", ae_v_len(0,n-1));
                    if( i==j )
                    {
                        cerr = cerr||ae_fp_greater(ae_c_abs(ae_c_sub_d(ct,1), _state),threshold);
                    }
                    else
                    {
                        cerr = cerr||ae_fp_greater(ae_c_abs(ct, _state),threshold);
                    }
                    ct = ae_v_cdotproduct(&cb.ptr.pp_complex[i][0], 1, "N", &cb.ptr.pp_complex[j][0], 1, "Conj", ae_v_len(0,n-1));
                    if( i==j )
                    {
                        cerr = cerr||ae_fp_greater(ae_c_abs(ae_c_sub_d(ct,1), _state),threshold);
                    }
                    else
                    {
                        cerr = cerr||ae_fp_greater(ae_c_abs(ct, _state),threshold);
                    }
                    
                    /*
                     * test for difference in A and B
                     */
                    cerr = cerr||ae_c_eq(ca.ptr.pp_complex[i][j],cb.ptr.pp_complex[i][j]);
                }
            }
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    c2.ptr.pp_complex[i][j] = ae_complex_from_d(2*ae_randomreal(_state)-1);
                    c2.ptr.pp_complex[i+n][j] = c2.ptr.pp_complex[i][j];
                }
            }
            cmatrixrndorthogonalfromtheright(&c2, 2*n, n, _state);
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    cerr = cerr||ae_fp_greater(ae_c_abs(ae_c_sub(c2.ptr.pp_complex[i+n][j],c2.ptr.pp_complex[i][j]), _state),threshold);
                }
            }
            
            /*
             * From the left complex tests:
             * 1. Q*E is orthogonal
             * 2. Q1<>Q2 (routine result is changing)
             * 3. Q*(E E) = (Q Q) (correct handling of non-square matrices)
             */
            testmatgenunit_unset2dc(&ca, _state);
            testmatgenunit_unset2dc(&cb, _state);
            ae_matrix_set_length(&ca, n-1+1, n-1+1, _state);
            ae_matrix_set_length(&cb, n-1+1, n-1+1, _state);
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    ca.ptr.pp_complex[i][j] = ae_complex_from_i(0);
                    cb.ptr.pp_complex[i][j] = ae_complex_from_i(0);
                }
                ca.ptr.pp_complex[i][i] = ae_complex_from_i(1);
                cb.ptr.pp_complex[i][i] = ae_complex_from_i(1);
            }
            cmatrixrndorthogonalfromtheleft(&ca, n, n, _state);
            cmatrixrndorthogonalfromtheleft(&cb, n, n, _state);
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    
                    /*
                     * orthogonality test
                     */
                    ct = ae_v_cdotproduct(&ca.ptr.pp_complex[i][0], 1, "N", &ca.ptr.pp_complex[j][0], 1, "Conj", ae_v_len(0,n-1));
                    if( i==j )
                    {
                        cerr = cerr||ae_fp_greater(ae_c_abs(ae_c_sub_d(ct,1), _state),threshold);
                    }
                    else
                    {
                        cerr = cerr||ae_fp_greater(ae_c_abs(ct, _state),threshold);
                    }
                    ct = ae_v_cdotproduct(&cb.ptr.pp_complex[i][0], 1, "N", &cb.ptr.pp_complex[j][0], 1, "Conj", ae_v_len(0,n-1));
                    if( i==j )
                    {
                        cerr = cerr||ae_fp_greater(ae_c_abs(ae_c_sub_d(ct,1), _state),threshold);
                    }
                    else
                    {
                        cerr = cerr||ae_fp_greater(ae_c_abs(ct, _state),threshold);
                    }
                    
                    /*
                     * test for difference in A and B
                     */
                    cerr = cerr||ae_c_eq(ca.ptr.pp_complex[i][j],cb.ptr.pp_complex[i][j]);
                }
            }
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    c1.ptr.pp_complex[i][j] = ae_complex_from_d(2*ae_randomreal(_state)-1);
                    c1.ptr.pp_complex[i][j+n] = c1.ptr.pp_complex[i][j];
                }
            }
            cmatrixrndorthogonalfromtheleft(&c1, n, 2*n, _state);
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    cerr = cerr||ae_fp_greater(ae_c_abs(ae_c_sub(c1.ptr.pp_complex[i][j],c1.ptr.pp_complex[i][j+n]), _state),threshold);
                }
            }
        }
    }
    
    /*
     * Testing GCond
     */
    for(n=2; n<=maxn; n++)
    {
        for(pass=1; pass<=passcount; pass++)
        {
            
            /*
             * real test
             */
            testmatgenunit_unset2d(&a, _state);
            cond = ae_exp(ae_log((double)(1000), _state)*ae_randomreal(_state), _state);
            rmatrixrndcond(n, cond, &a, _state);
            ae_matrix_set_length(&b, n+1, n+1, _state);
            for(i=1; i<=n; i++)
            {
                for(j=1; j<=n; j++)
                {
                    b.ptr.pp_double[i][j] = a.ptr.pp_double[i-1][j-1];
                }
            }
            if( testmatgenunit_obsoletesvddecomposition(&b, n, n, &w, &v, _state) )
            {
                maxw = w.ptr.p_double[1];
                minw = w.ptr.p_double[1];
                for(i=2; i<=n; i++)
                {
                    if( ae_fp_greater(w.ptr.p_double[i],maxw) )
                    {
                        maxw = w.ptr.p_double[i];
                    }
                    if( ae_fp_less(w.ptr.p_double[i],minw) )
                    {
                        minw = w.ptr.p_double[i];
                    }
                }
                vt = maxw/minw/cond;
                if( ae_fp_greater(ae_fabs(ae_log(vt, _state), _state),ae_log(1+threshold, _state)) )
                {
                    rerr = ae_true;
                }
            }
        }
    }
    
    /*
     * Symmetric/SPD
     * N = 2 .. 30
     */
    for(n=2; n<=maxn; n++)
    {
        
        /*
         * SPD matrices
         */
        for(pass=1; pass<=passcount; pass++)
        {
            
            /*
             * Generate A
             */
            testmatgenunit_unset2d(&a, _state);
            cond = ae_exp(ae_log((double)(1000), _state)*ae_randomreal(_state), _state);
            spdmatrixrndcond(n, cond, &a, _state);
            
            /*
             * test condition number
             */
            spderr = spderr||ae_fp_greater(testmatgenunit_svdcond(&a, n, _state)/cond-1,threshold);
            
            /*
             * test SPD
             */
            spderr = spderr||!testmatgenunit_isspd(&a, n, ae_true, _state);
            
            /*
             * test that A is symmetic
             */
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    spderr = spderr||ae_fp_greater(ae_fabs(a.ptr.pp_double[i][j]-a.ptr.pp_double[j][i], _state),threshold);
                }
            }
            
            /*
             * test for difference between A and B (subsequent matrix)
             */
            testmatgenunit_unset2d(&b, _state);
            spdmatrixrndcond(n, cond, &b, _state);
            if( n>=2 )
            {
                for(i=0; i<=n-1; i++)
                {
                    for(j=0; j<=n-1; j++)
                    {
                        spderr = spderr||ae_fp_eq(a.ptr.pp_double[i][j],b.ptr.pp_double[i][j]);
                    }
                }
            }
        }
        
        /*
         * HPD matrices
         */
        for(pass=1; pass<=passcount; pass++)
        {
            
            /*
             * Generate A
             */
            testmatgenunit_unset2dc(&ca, _state);
            cond = ae_exp(ae_log((double)(1000), _state)*ae_randomreal(_state), _state);
            hpdmatrixrndcond(n, cond, &ca, _state);
            
            /*
             * test HPD
             */
            hpderr = hpderr||!testmatgenunit_ishpd(&ca, n, _state);
            
            /*
             * test that A is Hermitian
             */
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    hpderr = hpderr||ae_fp_greater(ae_c_abs(ae_c_sub(ca.ptr.pp_complex[i][j],ae_c_conj(ca.ptr.pp_complex[j][i], _state)), _state),threshold);
                }
            }
            
            /*
             * test for difference between A and B (subsequent matrix)
             */
            testmatgenunit_unset2dc(&cb, _state);
            hpdmatrixrndcond(n, cond, &cb, _state);
            if( n>=2 )
            {
                for(i=0; i<=n-1; i++)
                {
                    for(j=0; j<=n-1; j++)
                    {
                        hpderr = hpderr||ae_c_eq(ca.ptr.pp_complex[i][j],cb.ptr.pp_complex[i][j]);
                    }
                }
            }
        }
        
        /*
         * Symmetric matrices
         */
        for(pass=1; pass<=passcount; pass++)
        {
            
            /*
             * test condition number
             */
            testmatgenunit_unset2d(&a, _state);
            cond = ae_exp(ae_log((double)(1000), _state)*ae_randomreal(_state), _state);
            smatrixrndcond(n, cond, &a, _state);
            serr = serr||ae_fp_greater(testmatgenunit_svdcond(&a, n, _state)/cond-1,threshold);
            
            /*
             * test for difference between A and B
             */
            testmatgenunit_unset2d(&b, _state);
            smatrixrndcond(n, cond, &b, _state);
            if( n>=2 )
            {
                for(i=0; i<=n-1; i++)
                {
                    for(j=0; j<=n-1; j++)
                    {
                        serr = serr||ae_fp_eq(a.ptr.pp_double[i][j],b.ptr.pp_double[i][j]);
                    }
                }
            }
        }
        
        /*
         * Hermitian matrices
         */
        for(pass=1; pass<=passcount; pass++)
        {
            
            /*
             * Generate A
             */
            testmatgenunit_unset2dc(&ca, _state);
            cond = ae_exp(ae_log((double)(1000), _state)*ae_randomreal(_state), _state);
            hmatrixrndcond(n, cond, &ca, _state);
            
            /*
             * test that A is Hermitian
             */
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    herr = herr||ae_fp_greater(ae_c_abs(ae_c_sub(ca.ptr.pp_complex[i][j],ae_c_conj(ca.ptr.pp_complex[j][i], _state)), _state),threshold);
                }
            }
            
            /*
             * test for difference between A and B (subsequent matrix)
             */
            testmatgenunit_unset2dc(&cb, _state);
            hmatrixrndcond(n, cond, &cb, _state);
            if( n>=2 )
            {
                for(i=0; i<=n-1; i++)
                {
                    for(j=0; j<=n-1; j++)
                    {
                        herr = herr||ae_c_eq(ca.ptr.pp_complex[i][j],cb.ptr.pp_complex[i][j]);
                    }
                }
            }
        }
    }
    
    /*
     * Test for symmetric matrices
     */
    eulerr = testmatgenunit_testeult(_state);
    
    /*
     * report
     */
    waserrors = (((((rerr||cerr)||serr)||spderr)||herr)||hpderr)||eulerr;
    if( !silent )
    {
        printf("TESTING MATRIX GENERATOR\n");
        printf("REAL TEST:                               ");
        if( !rerr )
        {
            printf("OK\n");
        }
        else
        {
            printf("FAILED\n");
        }
        printf("COMPLEX TEST:                            ");
        if( !cerr )
        {
            printf("OK\n");
        }
        else
        {
            printf("FAILED\n");
        }
        printf("SYMMETRIC TEST:                          ");
        if( !serr )
        {
            printf("OK\n");
        }
        else
        {
            printf("FAILED\n");
        }
        printf("HERMITIAN TEST:                          ");
        if( !herr )
        {
            printf("OK\n");
        }
        else
        {
            printf("FAILED\n");
        }
        printf("SPD TEST:                                ");
        if( !spderr )
        {
            printf("OK\n");
        }
        else
        {
            printf("FAILED\n");
        }
        printf("HPD TEST:                                ");
        if( !hpderr )
        {
            printf("OK\n");
        }
        else
        {
            printf("FAILED\n");
        }
        printf("TEST FOR SYMMETRIC MATRICES:             ");
        if( !eulerr )
        {
            printf("OK\n");
        }
        else
        {
            printf("FAILED\n");
        }
        if( waserrors )
        {
            printf("TEST FAILED\n");
        }
        else
        {
            printf("TEST PASSED\n");
        }
        printf("\n\n");
    }
    result = !waserrors;
    ae_frame_leave(_state);
    return result;
}


/*************************************************************************
Single-threaded stub. HPC ALGLIB replaces it by multithreaded code.
*************************************************************************/
ae_bool _pexec_testmatgen(ae_bool silent, ae_state *_state)
{
    return testmatgen(silent, _state);
}


/*************************************************************************
Unsets 2D array.
*************************************************************************/
static void testmatgenunit_unset2d(/* Real    */ ae_matrix* a,
     ae_state *_state)
{


    ae_matrix_set_length(a, 0+1, 0+1, _state);
    a->ptr.pp_double[0][0] = 2*ae_randomreal(_state)-1;
}


/*************************************************************************
Unsets 2D array.
*************************************************************************/
static void testmatgenunit_unset2dc(/* Complex */ ae_matrix* a,
     ae_state *_state)
{


    ae_matrix_set_length(a, 0+1, 0+1, _state);
    a->ptr.pp_complex[0][0] = ae_complex_from_d(2*ae_randomreal(_state)-1);
}


/*************************************************************************
Test whether matrix is SPD
*************************************************************************/
static ae_bool testmatgenunit_isspd(/* Real    */ ae_matrix* a,
     ae_int_t n,
     ae_bool isupper,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_matrix _a;
    ae_int_t i;
    ae_int_t j;
    double ajj;
    double v;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    ae_matrix_init_copy(&_a, a, _state);
    a = &_a;

    
    /*
     *     Test the input parameters.
     */
    ae_assert(n>=0, "Error in SMatrixCholesky: incorrect function arguments", _state);
    
    /*
     *     Quick return if possible
     */
    result = ae_true;
    if( n<=0 )
    {
        ae_frame_leave(_state);
        return result;
    }
    if( isupper )
    {
        
        /*
         * Compute the Cholesky factorization A = U'*U.
         */
        for(j=0; j<=n-1; j++)
        {
            
            /*
             * Compute U(J,J) and test for non-positive-definiteness.
             */
            v = ae_v_dotproduct(&a->ptr.pp_double[0][j], a->stride, &a->ptr.pp_double[0][j], a->stride, ae_v_len(0,j-1));
            ajj = a->ptr.pp_double[j][j]-v;
            if( ae_fp_less_eq(ajj,(double)(0)) )
            {
                result = ae_false;
                ae_frame_leave(_state);
                return result;
            }
            ajj = ae_sqrt(ajj, _state);
            a->ptr.pp_double[j][j] = ajj;
            
            /*
             * Compute elements J+1:N of row J.
             */
            if( j<n-1 )
            {
                for(i=j+1; i<=n-1; i++)
                {
                    v = ae_v_dotproduct(&a->ptr.pp_double[0][i], a->stride, &a->ptr.pp_double[0][j], a->stride, ae_v_len(0,j-1));
                    a->ptr.pp_double[j][i] = a->ptr.pp_double[j][i]-v;
                }
                v = 1/ajj;
                ae_v_muld(&a->ptr.pp_double[j][j+1], 1, ae_v_len(j+1,n-1), v);
            }
        }
    }
    else
    {
        
        /*
         * Compute the Cholesky factorization A = L*L'.
         */
        for(j=0; j<=n-1; j++)
        {
            
            /*
             * Compute L(J,J) and test for non-positive-definiteness.
             */
            v = ae_v_dotproduct(&a->ptr.pp_double[j][0], 1, &a->ptr.pp_double[j][0], 1, ae_v_len(0,j-1));
            ajj = a->ptr.pp_double[j][j]-v;
            if( ae_fp_less_eq(ajj,(double)(0)) )
            {
                result = ae_false;
                ae_frame_leave(_state);
                return result;
            }
            ajj = ae_sqrt(ajj, _state);
            a->ptr.pp_double[j][j] = ajj;
            
            /*
             * Compute elements J+1:N of column J.
             */
            if( j<n-1 )
            {
                for(i=j+1; i<=n-1; i++)
                {
                    v = ae_v_dotproduct(&a->ptr.pp_double[i][0], 1, &a->ptr.pp_double[j][0], 1, ae_v_len(0,j-1));
                    a->ptr.pp_double[i][j] = a->ptr.pp_double[i][j]-v;
                }
                v = 1/ajj;
                ae_v_muld(&a->ptr.pp_double[j+1][j], a->stride, ae_v_len(j+1,n-1), v);
            }
        }
    }
    ae_frame_leave(_state);
    return result;
}


/*************************************************************************
Tests whether A is HPD
*************************************************************************/
static ae_bool testmatgenunit_ishpd(/* Complex */ ae_matrix* a,
     ae_int_t n,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_matrix _a;
    ae_int_t j;
    double ajj;
    ae_complex v;
    double r;
    ae_vector t;
    ae_vector t2;
    ae_vector t3;
    ae_int_t i;
    ae_matrix a1;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    ae_matrix_init_copy(&_a, a, _state);
    a = &_a;
    ae_vector_init(&t, 0, DT_COMPLEX, _state);
    ae_vector_init(&t2, 0, DT_COMPLEX, _state);
    ae_vector_init(&t3, 0, DT_COMPLEX, _state);
    ae_matrix_init(&a1, 0, 0, DT_COMPLEX, _state);

    ae_vector_set_length(&t, n-1+1, _state);
    ae_vector_set_length(&t2, n-1+1, _state);
    ae_vector_set_length(&t3, n-1+1, _state);
    result = ae_true;
    
    /*
     * Compute the Cholesky factorization A = U'*U.
     */
    for(j=0; j<=n-1; j++)
    {
        
        /*
         * Compute U(J,J) and test for non-positive-definiteness.
         */
        v = ae_v_cdotproduct(&a->ptr.pp_complex[0][j], a->stride, "Conj", &a->ptr.pp_complex[0][j], a->stride, "N", ae_v_len(0,j-1));
        ajj = ae_c_sub(a->ptr.pp_complex[j][j],v).x;
        if( ae_fp_less_eq(ajj,(double)(0)) )
        {
            a->ptr.pp_complex[j][j] = ae_complex_from_d(ajj);
            result = ae_false;
            ae_frame_leave(_state);
            return result;
        }
        ajj = ae_sqrt(ajj, _state);
        a->ptr.pp_complex[j][j] = ae_complex_from_d(ajj);
        
        /*
         * Compute elements J+1:N-1 of row J.
         */
        if( j<n-1 )
        {
            ae_v_cmove(&t2.ptr.p_complex[0], 1, &a->ptr.pp_complex[0][j], a->stride, "Conj", ae_v_len(0,j-1));
            ae_v_cmove(&t3.ptr.p_complex[j+1], 1, &a->ptr.pp_complex[j][j+1], 1, "N", ae_v_len(j+1,n-1));
            for(i=j+1; i<=n-1; i++)
            {
                v = ae_v_cdotproduct(&a->ptr.pp_complex[0][i], a->stride, "N", &t2.ptr.p_complex[0], 1, "N", ae_v_len(0,j-1));
                t3.ptr.p_complex[i] = ae_c_sub(t3.ptr.p_complex[i],v);
            }
            ae_v_cmove(&a->ptr.pp_complex[j][j+1], 1, &t3.ptr.p_complex[j+1], 1, "N", ae_v_len(j+1,n-1));
            r = 1/ajj;
            ae_v_cmuld(&a->ptr.pp_complex[j][j+1], 1, ae_v_len(j+1,n-1), r);
        }
    }
    ae_frame_leave(_state);
    return result;
}


/*************************************************************************
The function check, that upper triangle from symmetric matrix is equal to
lower triangle.
*************************************************************************/
static ae_bool testmatgenunit_testeult(ae_state *_state)
{
    ae_frame _frame_block;
    ae_matrix a;
    ae_matrix b;
    double c;
    double range;
    double eps;
    ae_int_t n;
    ae_int_t i;
    ae_int_t j;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    ae_matrix_init(&a, 0, 0, DT_REAL, _state);
    ae_matrix_init(&b, 0, 0, DT_COMPLEX, _state);

    eps = 2*ae_machineepsilon;
    range = 100*(2*ae_randomreal(_state)-1);
    for(n=1; n<=15; n++)
    {
        c = 900*ae_randomreal(_state)+100;
        
        /*
         * Generate symmetric matrix and check it
         */
        smatrixrndcond(n, c, &a, _state);
        for(i=0; i<=n-1; i++)
        {
            for(j=0; j<=n-1; j++)
            {
                if( ae_fp_greater(ae_fabs(a.ptr.pp_double[i][j]-a.ptr.pp_double[j][i], _state),eps) )
                {
                    result = ae_true;
                    ae_frame_leave(_state);
                    return result;
                }
            }
        }
        spdmatrixrndcond(n, c, &a, _state);
        for(i=0; i<=n-1; i++)
        {
            for(j=0; j<=n-1; j++)
            {
                if( ae_fp_greater(ae_fabs(a.ptr.pp_double[i][j]-a.ptr.pp_double[j][i], _state),eps) )
                {
                    result = ae_true;
                    ae_frame_leave(_state);
                    return result;
                }
            }
        }
        hmatrixrndcond(n, c, &b, _state);
        for(i=0; i<=n-1; i++)
        {
            for(j=0; j<=n-1; j++)
            {
                if( ae_fp_greater(ae_fabs(b.ptr.pp_complex[i][j].x-b.ptr.pp_complex[j][i].x, _state),eps)||ae_fp_greater(ae_fabs(b.ptr.pp_complex[i][j].y+b.ptr.pp_complex[j][i].y, _state),eps) )
                {
                    result = ae_true;
                    ae_frame_leave(_state);
                    return result;
                }
            }
        }
        hpdmatrixrndcond(n, c, &b, _state);
        for(i=0; i<=n-1; i++)
        {
            for(j=0; j<=n-1; j++)
            {
                if( ae_fp_greater(ae_fabs(b.ptr.pp_complex[i][j].x-b.ptr.pp_complex[j][i].x, _state),eps)||ae_fp_greater(ae_fabs(b.ptr.pp_complex[i][j].y+b.ptr.pp_complex[j][i].y, _state),eps) )
                {
                    result = ae_true;
                    ae_frame_leave(_state);
                    return result;
                }
            }
        }
        
        /*
         * Prepare symmetric matrix with real values
         */
        for(i=0; i<=n-1; i++)
        {
            for(j=i; j<=n-1; j++)
            {
                a.ptr.pp_double[i][j] = range*(2*ae_randomreal(_state)-1);
            }
        }
        for(i=0; i<=n-2; i++)
        {
            for(j=i+1; j<=n-1; j++)
            {
                a.ptr.pp_double[j][i] = a.ptr.pp_double[i][j];
            }
        }
        smatrixrndmultiply(&a, n, _state);
        for(i=0; i<=n-1; i++)
        {
            for(j=0; j<=n-1; j++)
            {
                if( ae_fp_greater(ae_fabs(a.ptr.pp_double[i][j]-a.ptr.pp_double[j][i], _state),eps) )
                {
                    result = ae_true;
                    ae_frame_leave(_state);
                    return result;
                }
            }
        }
        
        /*
         * Prepare symmetric matrix with complex values
         */
        for(i=0; i<=n-1; i++)
        {
            for(j=i; j<=n-1; j++)
            {
                b.ptr.pp_complex[i][j].x = range*(2*ae_randomreal(_state)-1);
                if( i!=j )
                {
                    b.ptr.pp_complex[i][j].y = range*(2*ae_randomreal(_state)-1);
                }
                else
                {
                    b.ptr.pp_complex[i][j].y = (double)(0);
                }
            }
        }
        for(i=0; i<=n-1; i++)
        {
            for(j=i+1; j<=n-1; j++)
            {
                b.ptr.pp_complex[i][j].x = b.ptr.pp_complex[j][i].x;
                b.ptr.pp_complex[i][j].y = -b.ptr.pp_complex[j][i].y;
            }
        }
        hmatrixrndmultiply(&b, n, _state);
        for(i=0; i<=n-1; i++)
        {
            b.ptr.pp_complex[i][i].y = (double)(0);
        }
        for(i=0; i<=n-1; i++)
        {
            for(j=0; j<=n-1; j++)
            {
                if( ae_fp_greater(ae_fabs(b.ptr.pp_complex[i][j].x-b.ptr.pp_complex[j][i].x, _state),eps)||ae_fp_greater(ae_fabs(b.ptr.pp_complex[i][j].y+b.ptr.pp_complex[j][i].y, _state),eps) )
                {
                    result = ae_true;
                    ae_frame_leave(_state);
                    return result;
                }
            }
        }
    }
    result = ae_false;
    ae_frame_leave(_state);
    return result;
}


/*************************************************************************
SVD condition number
*************************************************************************/
static double testmatgenunit_svdcond(/* Real    */ ae_matrix* a,
     ae_int_t n,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_matrix a1;
    ae_matrix v;
    ae_vector w;
    ae_int_t i;
    ae_int_t j;
    double minw;
    double maxw;
    double result;

    ae_frame_make(_state, &_frame_block);
    ae_matrix_init(&a1, 0, 0, DT_REAL, _state);
    ae_matrix_init(&v, 0, 0, DT_REAL, _state);
    ae_vector_init(&w, 0, DT_REAL, _state);

    ae_matrix_set_length(&a1, n+1, n+1, _state);
    for(i=1; i<=n; i++)
    {
        for(j=1; j<=n; j++)
        {
            a1.ptr.pp_double[i][j] = a->ptr.pp_double[i-1][j-1];
        }
    }
    if( !testmatgenunit_obsoletesvddecomposition(&a1, n, n, &w, &v, _state) )
    {
        result = (double)(0);
        ae_frame_leave(_state);
        return result;
    }
    minw = w.ptr.p_double[1];
    maxw = w.ptr.p_double[1];
    for(i=2; i<=n; i++)
    {
        if( ae_fp_less(w.ptr.p_double[i],minw) )
        {
            minw = w.ptr.p_double[i];
        }
        if( ae_fp_greater(w.ptr.p_double[i],maxw) )
        {
            maxw = w.ptr.p_double[i];
        }
    }
    result = maxw/minw;
    ae_frame_leave(_state);
    return result;
}


static ae_bool testmatgenunit_obsoletesvddecomposition(/* Real    */ ae_matrix* a,
     ae_int_t m,
     ae_int_t n,
     /* Real    */ ae_vector* w,
     /* Real    */ ae_matrix* v,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_int_t nm;
    ae_int_t minmn;
    ae_int_t l;
    ae_int_t k;
    ae_int_t j;
    ae_int_t jj;
    ae_int_t its;
    ae_int_t i;
    double z;
    double y;
    double x;
    double vscale;
    double s;
    double h;
    double g;
    double f;
    double c;
    double anorm;
    ae_vector rv1;
    ae_bool flag;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    ae_vector_clear(w);
    ae_matrix_clear(v);
    ae_vector_init(&rv1, 0, DT_REAL, _state);

    ae_vector_set_length(&rv1, n+1, _state);
    ae_vector_set_length(w, n+1, _state);
    ae_matrix_set_length(v, n+1, n+1, _state);
    result = ae_true;
    if( m<n )
    {
        minmn = m;
    }
    else
    {
        minmn = n;
    }
    g = 0.0;
    vscale = 0.0;
    anorm = 0.0;
    l = n;
    for(i=1; i<=n; i++)
    {
        l = i+1;
        rv1.ptr.p_double[i] = vscale*g;
        g = (double)(0);
        s = (double)(0);
        vscale = (double)(0);
        if( i<=m )
        {
            for(k=i; k<=m; k++)
            {
                vscale = vscale+ae_fabs(a->ptr.pp_double[k][i], _state);
            }
            if( ae_fp_neq(vscale,0.0) )
            {
                for(k=i; k<=m; k++)
                {
                    a->ptr.pp_double[k][i] = a->ptr.pp_double[k][i]/vscale;
                    s = s+a->ptr.pp_double[k][i]*a->ptr.pp_double[k][i];
                }
                f = a->ptr.pp_double[i][i];
                g = -testmatgenunit_extsign(ae_sqrt(s, _state), f, _state);
                h = f*g-s;
                a->ptr.pp_double[i][i] = f-g;
                if( i!=n )
                {
                    for(j=l; j<=n; j++)
                    {
                        s = 0.0;
                        for(k=i; k<=m; k++)
                        {
                            s = s+a->ptr.pp_double[k][i]*a->ptr.pp_double[k][j];
                        }
                        f = s/h;
                        for(k=i; k<=m; k++)
                        {
                            a->ptr.pp_double[k][j] = a->ptr.pp_double[k][j]+f*a->ptr.pp_double[k][i];
                        }
                    }
                }
                for(k=i; k<=m; k++)
                {
                    a->ptr.pp_double[k][i] = vscale*a->ptr.pp_double[k][i];
                }
            }
        }
        w->ptr.p_double[i] = vscale*g;
        g = 0.0;
        s = 0.0;
        vscale = 0.0;
        if( i<=m&&i!=n )
        {
            for(k=l; k<=n; k++)
            {
                vscale = vscale+ae_fabs(a->ptr.pp_double[i][k], _state);
            }
            if( ae_fp_neq(vscale,0.0) )
            {
                for(k=l; k<=n; k++)
                {
                    a->ptr.pp_double[i][k] = a->ptr.pp_double[i][k]/vscale;
                    s = s+a->ptr.pp_double[i][k]*a->ptr.pp_double[i][k];
                }
                f = a->ptr.pp_double[i][l];
                g = -testmatgenunit_extsign(ae_sqrt(s, _state), f, _state);
                h = f*g-s;
                a->ptr.pp_double[i][l] = f-g;
                for(k=l; k<=n; k++)
                {
                    rv1.ptr.p_double[k] = a->ptr.pp_double[i][k]/h;
                }
                if( i!=m )
                {
                    for(j=l; j<=m; j++)
                    {
                        s = 0.0;
                        for(k=l; k<=n; k++)
                        {
                            s = s+a->ptr.pp_double[j][k]*a->ptr.pp_double[i][k];
                        }
                        for(k=l; k<=n; k++)
                        {
                            a->ptr.pp_double[j][k] = a->ptr.pp_double[j][k]+s*rv1.ptr.p_double[k];
                        }
                    }
                }
                for(k=l; k<=n; k++)
                {
                    a->ptr.pp_double[i][k] = vscale*a->ptr.pp_double[i][k];
                }
            }
        }
        anorm = testmatgenunit_mymax(anorm, ae_fabs(w->ptr.p_double[i], _state)+ae_fabs(rv1.ptr.p_double[i], _state), _state);
    }
    for(i=n; i>=1; i--)
    {
        if( i<n )
        {
            if( ae_fp_neq(g,0.0) )
            {
                for(j=l; j<=n; j++)
                {
                    v->ptr.pp_double[j][i] = a->ptr.pp_double[i][j]/a->ptr.pp_double[i][l]/g;
                }
                for(j=l; j<=n; j++)
                {
                    s = 0.0;
                    for(k=l; k<=n; k++)
                    {
                        s = s+a->ptr.pp_double[i][k]*v->ptr.pp_double[k][j];
                    }
                    for(k=l; k<=n; k++)
                    {
                        v->ptr.pp_double[k][j] = v->ptr.pp_double[k][j]+s*v->ptr.pp_double[k][i];
                    }
                }
            }
            for(j=l; j<=n; j++)
            {
                v->ptr.pp_double[i][j] = 0.0;
                v->ptr.pp_double[j][i] = 0.0;
            }
        }
        v->ptr.pp_double[i][i] = 1.0;
        g = rv1.ptr.p_double[i];
        l = i;
    }
    for(i=minmn; i>=1; i--)
    {
        l = i+1;
        g = w->ptr.p_double[i];
        if( i<n )
        {
            for(j=l; j<=n; j++)
            {
                a->ptr.pp_double[i][j] = 0.0;
            }
        }
        if( ae_fp_neq(g,0.0) )
        {
            g = 1.0/g;
            if( i!=n )
            {
                for(j=l; j<=n; j++)
                {
                    s = 0.0;
                    for(k=l; k<=m; k++)
                    {
                        s = s+a->ptr.pp_double[k][i]*a->ptr.pp_double[k][j];
                    }
                    f = s/a->ptr.pp_double[i][i]*g;
                    for(k=i; k<=m; k++)
                    {
                        a->ptr.pp_double[k][j] = a->ptr.pp_double[k][j]+f*a->ptr.pp_double[k][i];
                    }
                }
            }
            for(j=i; j<=m; j++)
            {
                a->ptr.pp_double[j][i] = a->ptr.pp_double[j][i]*g;
            }
        }
        else
        {
            for(j=i; j<=m; j++)
            {
                a->ptr.pp_double[j][i] = 0.0;
            }
        }
        a->ptr.pp_double[i][i] = a->ptr.pp_double[i][i]+1.0;
    }
    nm = 0;
    for(k=n; k>=1; k--)
    {
        for(its=1; its<=testmatgenunit_maxsvditerations; its++)
        {
            flag = ae_true;
            for(l=k; l>=1; l--)
            {
                nm = l-1;
                if( ae_fp_eq(ae_fabs(rv1.ptr.p_double[l], _state)+anorm,anorm) )
                {
                    flag = ae_false;
                    break;
                }
                if( ae_fp_eq(ae_fabs(w->ptr.p_double[nm], _state)+anorm,anorm) )
                {
                    break;
                }
            }
            if( flag )
            {
                c = 0.0;
                s = 1.0;
                for(i=l; i<=k; i++)
                {
                    f = s*rv1.ptr.p_double[i];
                    if( ae_fp_neq(ae_fabs(f, _state)+anorm,anorm) )
                    {
                        g = w->ptr.p_double[i];
                        h = testmatgenunit_pythag(f, g, _state);
                        w->ptr.p_double[i] = h;
                        h = 1.0/h;
                        c = g*h;
                        s = -f*h;
                        for(j=1; j<=m; j++)
                        {
                            y = a->ptr.pp_double[j][nm];
                            z = a->ptr.pp_double[j][i];
                            a->ptr.pp_double[j][nm] = y*c+z*s;
                            a->ptr.pp_double[j][i] = -y*s+z*c;
                        }
                    }
                }
            }
            z = w->ptr.p_double[k];
            if( l==k )
            {
                if( ae_fp_less(z,0.0) )
                {
                    w->ptr.p_double[k] = -z;
                    for(j=1; j<=n; j++)
                    {
                        v->ptr.pp_double[j][k] = -v->ptr.pp_double[j][k];
                    }
                }
                break;
            }
            if( its==testmatgenunit_maxsvditerations )
            {
                result = ae_false;
                ae_frame_leave(_state);
                return result;
            }
            x = w->ptr.p_double[l];
            nm = k-1;
            y = w->ptr.p_double[nm];
            g = rv1.ptr.p_double[nm];
            h = rv1.ptr.p_double[k];
            f = ((y-z)*(y+z)+(g-h)*(g+h))/(2.0*h*y);
            g = testmatgenunit_pythag(f, (double)(1), _state);
            f = ((x-z)*(x+z)+h*(y/(f+testmatgenunit_extsign(g, f, _state))-h))/x;
            c = 1.0;
            s = 1.0;
            for(j=l; j<=nm; j++)
            {
                i = j+1;
                g = rv1.ptr.p_double[i];
                y = w->ptr.p_double[i];
                h = s*g;
                g = c*g;
                z = testmatgenunit_pythag(f, h, _state);
                rv1.ptr.p_double[j] = z;
                c = f/z;
                s = h/z;
                f = x*c+g*s;
                g = -x*s+g*c;
                h = y*s;
                y = y*c;
                for(jj=1; jj<=n; jj++)
                {
                    x = v->ptr.pp_double[jj][j];
                    z = v->ptr.pp_double[jj][i];
                    v->ptr.pp_double[jj][j] = x*c+z*s;
                    v->ptr.pp_double[jj][i] = -x*s+z*c;
                }
                z = testmatgenunit_pythag(f, h, _state);
                w->ptr.p_double[j] = z;
                if( ae_fp_neq(z,0.0) )
                {
                    z = 1.0/z;
                    c = f*z;
                    s = h*z;
                }
                f = c*g+s*y;
                x = -s*g+c*y;
                for(jj=1; jj<=m; jj++)
                {
                    y = a->ptr.pp_double[jj][j];
                    z = a->ptr.pp_double[jj][i];
                    a->ptr.pp_double[jj][j] = y*c+z*s;
                    a->ptr.pp_double[jj][i] = -y*s+z*c;
                }
            }
            rv1.ptr.p_double[l] = 0.0;
            rv1.ptr.p_double[k] = f;
            w->ptr.p_double[k] = x;
        }
    }
    ae_frame_leave(_state);
    return result;
}


static double testmatgenunit_extsign(double a, double b, ae_state *_state)
{
    double result;


    if( ae_fp_greater_eq(b,(double)(0)) )
    {
        result = ae_fabs(a, _state);
    }
    else
    {
        result = -ae_fabs(a, _state);
    }
    return result;
}


static double testmatgenunit_mymax(double a, double b, ae_state *_state)
{
    double result;


    if( ae_fp_greater(a,b) )
    {
        result = a;
    }
    else
    {
        result = b;
    }
    return result;
}


static double testmatgenunit_pythag(double a, double b, ae_state *_state)
{
    double result;


    if( ae_fp_less(ae_fabs(a, _state),ae_fabs(b, _state)) )
    {
        result = ae_fabs(b, _state)*ae_sqrt(1+ae_sqr(a/b, _state), _state);
    }
    else
    {
        result = ae_fabs(a, _state)*ae_sqrt(1+ae_sqr(b/a, _state), _state);
    }
    return result;
}



static void testsparseunit_initgenerator(ae_int_t m,
     ae_int_t n,
     ae_int_t matkind,
     ae_int_t triangle,
     sparsegenerator* g,
     ae_state *_state);
static ae_bool testsparseunit_generatenext(sparsegenerator* g,
     /* Real    */ ae_matrix* da,
     sparsematrix* sa,
     ae_state *_state);
static void testsparseunit_createrandom(ae_int_t m,
     ae_int_t n,
     ae_int_t pkind,
     ae_int_t ckind,
     ae_int_t p0,
     ae_int_t p1,
     /* Real    */ ae_matrix* da,
     sparsematrix* sa,
     ae_state *_state);
static ae_bool testsparseunit_enumeratetest(ae_state *_state);
static ae_bool testsparseunit_rewriteexistingtest(ae_state *_state);
static void testsparseunit_testgetrow(ae_bool* err, ae_state *_state);
static ae_bool testsparseunit_testconvertsm(ae_state *_state);
static ae_bool testsparseunit_testgcmatrixtype(ae_state *_state);





ae_bool testsparse(ae_bool silent, ae_state *_state)
{
    ae_bool waserrors;
    ae_bool basicerrors;
    ae_bool linearerrors;
    ae_bool basicrnderrors;
    ae_bool level2unsymmetricerrors;
    ae_bool level2symmetricerrors;
    ae_bool level2triangularerrors;
    ae_bool level3unsymmetricerrors;
    ae_bool level3symmetricerrors;
    ae_bool linearserrors;
    ae_bool linearmmerrors;
    ae_bool linearsmmerrors;
    ae_bool getrowerrors;
    ae_bool copyerrors;
    ae_bool basiccopyerrors;
    ae_bool enumerateerrors;
    ae_bool rewriteexistingerr;
    ae_bool skserrors;
    ae_bool result;


    getrowerrors = ae_false;
    skserrors = skstest(_state);
    basicerrors = basicfunctest(_state)||testsparseunit_testgcmatrixtype(_state);
    basicrnderrors = basicfuncrandomtest(_state);
    linearerrors = linearfunctionstest(_state);
    level2unsymmetricerrors = testlevel2unsymmetric(_state);
    level2symmetricerrors = testlevel2symmetric(_state);
    level2triangularerrors = testlevel2triangular(_state);
    level3unsymmetricerrors = testlevel3unsymmetric(_state);
    level3symmetricerrors = testlevel3symmetric(_state);
    linearserrors = linearfunctionsstest(_state);
    linearmmerrors = linearfunctionsmmtest(_state);
    linearsmmerrors = linearfunctionssmmtest(_state);
    copyerrors = copyfunctest(ae_true, _state)||testsparseunit_testconvertsm(_state);
    basiccopyerrors = basiccopyfunctest(ae_true, _state);
    enumerateerrors = testsparseunit_enumeratetest(_state);
    rewriteexistingerr = testsparseunit_rewriteexistingtest(_state);
    testsparseunit_testgetrow(&getrowerrors, _state);
    
    /*
     * report
     */
    waserrors = (((((((((((((((skserrors||getrowerrors)||basicerrors)||linearerrors)||basicrnderrors)||level2unsymmetricerrors)||level2symmetricerrors)||level2triangularerrors)||level3unsymmetricerrors)||level3symmetricerrors)||linearserrors)||linearmmerrors)||linearsmmerrors)||copyerrors)||basiccopyerrors)||enumerateerrors)||rewriteexistingerr;
    if( !silent )
    {
        printf("TESTING SPARSE\n");
        printf("STORAGE FORMATS:\n");
        printf("* SKS:                                   ");
        if( !skserrors )
        {
            printf("OK\n");
        }
        else
        {
            printf("FAILED\n");
        }
        printf("OPERATIONS:\n");
        printf("* GETROW:                                ");
        if( !getrowerrors )
        {
            printf("OK\n");
        }
        else
        {
            printf("FAILED\n");
        }
        printf("BLAS:\n");
        printf("* LEVEL 2 GENERAL:                       ");
        if( !level2unsymmetricerrors )
        {
            printf("OK\n");
        }
        else
        {
            printf("FAILED\n");
        }
        printf("* LEVEL 2 SYMMETRIC:                     ");
        if( !level2symmetricerrors )
        {
            printf("OK\n");
        }
        else
        {
            printf("FAILED\n");
        }
        printf("* LEVEL 2 TRIANGULAR:                    ");
        if( !level2triangularerrors )
        {
            printf("OK\n");
        }
        else
        {
            printf("FAILED\n");
        }
        printf("* LEVEL 3 GENERAL:                       ");
        if( !level3unsymmetricerrors )
        {
            printf("OK\n");
        }
        else
        {
            printf("FAILED\n");
        }
        printf("* LEVEL 3 SYMMETRIC:                     ");
        if( !level3symmetricerrors )
        {
            printf("OK\n");
        }
        else
        {
            printf("FAILED\n");
        }
        printf("BASIC TEST:                              ");
        if( !basicerrors )
        {
            printf("OK\n");
        }
        else
        {
            printf("FAILED\n");
        }
        printf("COPY TEST:                               ");
        if( !copyerrors )
        {
            printf("OK\n");
        }
        else
        {
            printf("FAILED\n");
        }
        printf("BASIC_COPY TEST:                         ");
        if( !basiccopyerrors )
        {
            printf("OK\n");
        }
        else
        {
            printf("FAILED\n");
        }
        printf("BASIC_RND TEST:                          ");
        if( !basicrnderrors )
        {
            printf("OK\n");
        }
        else
        {
            printf("FAILED\n");
        }
        printf("LINEAR TEST:                             ");
        if( !linearerrors )
        {
            printf("OK\n");
        }
        else
        {
            printf("FAILED\n");
        }
        printf("LINEAR TEST FOR SYMMETRIC MATRICES:      ");
        if( !linearserrors )
        {
            printf("OK\n");
        }
        else
        {
            printf("FAILED\n");
        }
        printf("LINEAR MxM TEST:                         ");
        if( !linearmmerrors )
        {
            printf("OK\n");
        }
        else
        {
            printf("FAILED\n");
        }
        printf("LINEAR MxM TEST FOR SYMMETRIC MATRICES:  ");
        if( !linearsmmerrors )
        {
            printf("OK\n");
        }
        else
        {
            printf("FAILED\n");
        }
        printf("ENUMERATE TEST:                          ");
        if( !enumerateerrors )
        {
            printf("OK\n");
        }
        else
        {
            printf("FAILED\n");
        }
        printf("REWRITE EXISTING TEST:                   ");
        if( !rewriteexistingerr )
        {
            printf("OK\n");
        }
        else
        {
            printf("FAILED\n");
        }
        if( waserrors )
        {
            printf("TEST FAILED\n");
        }
        else
        {
            printf("TEST PASSED\n");
        }
        printf("\n\n");
    }
    result = !waserrors;
    return result;
}


/*************************************************************************
Single-threaded stub. HPC ALGLIB replaces it by multithreaded code.
*************************************************************************/
ae_bool _pexec_testsparse(ae_bool silent, ae_state *_state)
{
    return testsparse(silent, _state);
}


/*************************************************************************
Function for testing basic SKS functional.
Returns True on errors, False on success.

  -- ALGLIB PROJECT --
     Copyright 16.01.1014 by Bochkanov Sergey
*************************************************************************/
ae_bool skstest(ae_state *_state)
{
    ae_frame _frame_block;
    sparsematrix s0;
    sparsematrix s1;
    sparsematrix s2;
    sparsematrix s3;
    sparsematrix s4;
    sparsematrix s5;
    sparsematrix s6;
    ae_int_t n;
    ae_int_t nz;
    double pnz;
    ae_int_t i;
    ae_int_t j;
    ae_int_t t0;
    ae_int_t t1;
    ae_matrix a;
    ae_matrix wasenumerated;
    ae_vector d;
    ae_vector u;
    hqrndstate rs;
    double v0;
    double v1;
    ae_int_t uppercnt;
    ae_int_t lowercnt;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    _sparsematrix_init(&s0, _state);
    _sparsematrix_init(&s1, _state);
    _sparsematrix_init(&s2, _state);
    _sparsematrix_init(&s3, _state);
    _sparsematrix_init(&s4, _state);
    _sparsematrix_init(&s5, _state);
    _sparsematrix_init(&s6, _state);
    ae_matrix_init(&a, 0, 0, DT_REAL, _state);
    ae_matrix_init(&wasenumerated, 0, 0, DT_BOOL, _state);
    ae_vector_init(&d, 0, DT_INT, _state);
    ae_vector_init(&u, 0, DT_INT, _state);
    _hqrndstate_init(&rs, _state);

    result = ae_false;
    hqrndrandomize(&rs, _state);
    for(n=1; n<=20; n++)
    {
        nz = n*n-n;
        for(;;)
        {
            
            /*
             * Generate N*N matrix where probability of non-diagonal element
             * being non-zero is PNZ. We also generate D and U - subdiagonal
             * and superdiagonal profile sizes.
             */
            if( n>1 )
            {
                pnz = (double)nz/(double)(n*n-n);
            }
            else
            {
                pnz = 1.0;
            }
            ae_vector_set_length(&d, n, _state);
            ae_vector_set_length(&u, n, _state);
            for(i=0; i<=n-1; i++)
            {
                d.ptr.p_int[i] = 0;
                u.ptr.p_int[i] = 0;
            }
            ae_matrix_set_length(&a, n, n, _state);
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    if( i==j||ae_fp_less_eq(hqrnduniformr(&rs, _state),pnz) )
                    {
                        a.ptr.pp_double[i][j] = hqrnduniformr(&rs, _state)-0.5;
                        if( j<i )
                        {
                            d.ptr.p_int[i] = ae_maxint(d.ptr.p_int[i], i-j, _state);
                        }
                        else
                        {
                            u.ptr.p_int[j] = ae_maxint(u.ptr.p_int[j], j-i, _state);
                        }
                    }
                    else
                    {
                        a.ptr.pp_double[i][j] = 0.0;
                    }
                }
            }
            uppercnt = 0;
            lowercnt = 0;
            for(i=0; i<=n-1; i++)
            {
                uppercnt = uppercnt+u.ptr.p_int[i];
                lowercnt = lowercnt+d.ptr.p_int[i];
            }
            
            /*
             * Create matrix in SKS storage format, fill with RewriteExisting() calls.
             * Convert to several different formats, check their contents with SparseGet().
             */
            sparsecreatesks(n, n, &d, &u, &s0, _state);
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    if( ae_fp_neq(a.ptr.pp_double[i][j],(double)(0)) )
                    {
                        seterrorflag(&result, !sparserewriteexisting(&s0, i, j, a.ptr.pp_double[i][j], _state), _state);
                    }
                }
            }
            sparsecopy(&s0, &s1, _state);
            sparseconverttocrs(&s1, _state);
            sparsecopytocrs(&s0, &s2, _state);
            sparsecopytocrsbuf(&s0, &s3, _state);
            sparsecopytohash(&s0, &s4, _state);
            sparsecopytohashbuf(&s0, &s5, _state);
            sparsecopy(&s0, &s6, _state);
            sparseconverttohash(&s6, _state);
            seterrorflag(&result, sparsegetnrows(&s0, _state)!=n, _state);
            seterrorflag(&result, sparsegetncols(&s0, _state)!=n, _state);
            seterrorflag(&result, sparsegetmatrixtype(&s0, _state)!=2, _state);
            seterrorflag(&result, !sparseissks(&s0, _state), _state);
            seterrorflag(&result, sparseiscrs(&s0, _state), _state);
            seterrorflag(&result, sparseishash(&s0, _state), _state);
            seterrorflag(&result, sparseissks(&s1, _state), _state);
            seterrorflag(&result, !sparseiscrs(&s1, _state), _state);
            seterrorflag(&result, sparseishash(&s1, _state), _state);
            for(i=0; i<=n-1; i++)
            {
                v1 = a.ptr.pp_double[i][i];
                v0 = sparsegetdiagonal(&s0, i, _state);
                seterrorflag(&result, ae_fp_neq(v0,v1), _state);
            }
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    v1 = a.ptr.pp_double[i][j];
                    v0 = sparseget(&s0, i, j, _state);
                    seterrorflag(&result, ae_fp_neq(v0,v1), _state);
                    v0 = sparseget(&s1, i, j, _state);
                    seterrorflag(&result, ae_fp_neq(v0,v1), _state);
                    v0 = sparseget(&s2, i, j, _state);
                    seterrorflag(&result, ae_fp_neq(v0,v1), _state);
                    v0 = sparseget(&s3, i, j, _state);
                    seterrorflag(&result, ae_fp_neq(v0,v1), _state);
                    v0 = sparseget(&s4, i, j, _state);
                    seterrorflag(&result, ae_fp_neq(v0,v1), _state);
                    v0 = sparseget(&s5, i, j, _state);
                    seterrorflag(&result, ae_fp_neq(v0,v1), _state);
                    v0 = sparseget(&s6, i, j, _state);
                    seterrorflag(&result, ae_fp_neq(v0,v1), _state);
                }
            }
            
            /*
             * Check enumeration capabilities:
             * * each element returned by SparseEnumerate() is returned only once
             * * each non-zero element of A was enumerated
             */
            ae_matrix_set_length(&wasenumerated, n, n, _state);
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    wasenumerated.ptr.pp_bool[i][j] = ae_false;
                }
            }
            t0 = 0;
            t1 = 0;
            while(sparseenumerate(&s0, &t0, &t1, &i, &j, &v0, _state))
            {
                seterrorflag(&result, wasenumerated.ptr.pp_bool[i][j], _state);
                wasenumerated.ptr.pp_bool[i][j] = ae_true;
            }
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    if( ae_fp_neq(a.ptr.pp_double[i][j],(double)(0)) )
                    {
                        seterrorflag(&result, !wasenumerated.ptr.pp_bool[i][j], _state);
                    }
                }
            }
            
            /*
             * Check UpperCnt()/LowerCnt()
             */
            seterrorflag(&result, sparsegetuppercount(&s0, _state)!=uppercnt, _state);
            seterrorflag(&result, sparsegetlowercount(&s0, _state)!=lowercnt, _state);
            
            /*
             * Check in-place transposition
             */
            sparsecopy(&s0, &s1, _state);
            sparsetransposesks(&s1, _state);
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    v0 = sparseget(&s0, i, j, _state);
                    v1 = sparseget(&s1, j, i, _state);
                    seterrorflag(&result, ae_fp_neq(v0,v1), _state);
                }
            }
            
            /*
             * One more check - matrix is initially created in some other format
             * (CRS or Hash) and converted to SKS later.
             */
            sparsecreate(n, n, 0, &s0, _state);
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    if( ae_fp_neq(a.ptr.pp_double[i][j],(double)(0)) )
                    {
                        sparseset(&s0, i, j, a.ptr.pp_double[i][j], _state);
                    }
                }
            }
            sparsecopy(&s0, &s1, _state);
            sparseconverttosks(&s1, _state);
            sparsecopytosks(&s0, &s2, _state);
            sparsecopytosksbuf(&s0, &s3, _state);
            seterrorflag(&result, !sparseissks(&s1, _state), _state);
            seterrorflag(&result, sparseiscrs(&s1, _state), _state);
            seterrorflag(&result, sparseishash(&s1, _state), _state);
            seterrorflag(&result, !sparseissks(&s2, _state), _state);
            seterrorflag(&result, sparseiscrs(&s2, _state), _state);
            seterrorflag(&result, sparseishash(&s2, _state), _state);
            seterrorflag(&result, !sparseissks(&s3, _state), _state);
            seterrorflag(&result, sparseiscrs(&s3, _state), _state);
            seterrorflag(&result, sparseishash(&s3, _state), _state);
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    v1 = a.ptr.pp_double[i][j];
                    v0 = sparseget(&s1, i, j, _state);
                    seterrorflag(&result, ae_fp_neq(v0,v1), _state);
                    v0 = sparseget(&s2, i, j, _state);
                    seterrorflag(&result, ae_fp_neq(v0,v1), _state);
                    v0 = sparseget(&s3, i, j, _state);
                    seterrorflag(&result, ae_fp_neq(v0,v1), _state);
                }
            }
            
            /*
             * Increase problem sparcity and try one more time. 
             * Stop after testing NZ=0.
             */
            if( nz==0 )
            {
                break;
            }
            nz = nz/2;
        }
    }
    ae_frame_leave(_state);
    return result;
}


/*************************************************************************
Function for testing basic functional

  -- ALGLIB PROJECT --
     Copyright 14.10.2011 by Bochkanov Sergey
*************************************************************************/
ae_bool basicfunctest(ae_state *_state)
{
    ae_frame _frame_block;
    sparsematrix s;
    ae_int_t n;
    ae_int_t m;
    ae_int_t i;
    ae_int_t j;
    ae_int_t i1;
    ae_int_t j1;
    ae_int_t uppercnt;
    ae_int_t lowercnt;
    ae_matrix a;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    _sparsematrix_init(&s, _state);
    ae_matrix_init(&a, 0, 0, DT_REAL, _state);

    n = 10;
    m = 10;
    result = ae_false;
    for(i=1; i<=m-1; i++)
    {
        for(j=1; j<=n-1; j++)
        {
            sparsecreate(i, j, 1, &s, _state);
            ae_matrix_set_length(&a, i, j, _state);
            
            /*
             * Checking for Matrix with hash table type
             */
            uppercnt = 0;
            lowercnt = 0;
            for(i1=0; i1<=i-1; i1++)
            {
                for(j1=0; j1<=j-1; j1++)
                {
                    if( j1>i1 )
                    {
                        inc(&uppercnt, _state);
                    }
                    if( j1<i1 )
                    {
                        inc(&lowercnt, _state);
                    }
                    a.ptr.pp_double[i1][j1] = i1+j1+(double)((i+j)*(m+n))/(double)2;
                    a.ptr.pp_double[i1][j1] = a.ptr.pp_double[i1][j1]+1;
                    sparseset(&s, i1, j1, i1+j1+(double)((i+j)*(m+n))/(double)2, _state);
                    sparseadd(&s, i1, j1, (double)(1), _state);
                    if( ae_fp_neq(a.ptr.pp_double[i1][j1],sparseget(&s, i1, j1, _state)) )
                    {
                        result = ae_true;
                        ae_frame_leave(_state);
                        return result;
                    }
                }
            }
            for(i1=0; i1<=ae_minint(i, j, _state)-1; i1++)
            {
                if( ae_fp_neq(a.ptr.pp_double[i1][i1],sparsegetdiagonal(&s, i1, _state)) )
                {
                    result = ae_true;
                    ae_frame_leave(_state);
                    return result;
                }
            }
            seterrorflag(&result, sparsegetuppercount(&s, _state)!=uppercnt, _state);
            seterrorflag(&result, sparsegetlowercount(&s, _state)!=lowercnt, _state);
            
            /*
             * Checking for Matrix with CRS type
             */
            sparseconverttocrs(&s, _state);
            for(i1=0; i1<=i-1; i1++)
            {
                for(j1=0; j1<=j-1; j1++)
                {
                    if( ae_fp_neq(a.ptr.pp_double[i1][j1],sparseget(&s, i1, j1, _state)) )
                    {
                        result = ae_true;
                        ae_frame_leave(_state);
                        return result;
                    }
                }
            }
            for(i1=0; i1<=ae_minint(i, j, _state)-1; i1++)
            {
                if( ae_fp_neq(a.ptr.pp_double[i1][i1],sparsegetdiagonal(&s, i1, _state)) )
                {
                    result = ae_true;
                    ae_frame_leave(_state);
                    return result;
                }
            }
            seterrorflag(&result, sparsegetuppercount(&s, _state)!=uppercnt, _state);
            seterrorflag(&result, sparsegetlowercount(&s, _state)!=lowercnt, _state);
        }
    }
    ae_frame_leave(_state);
    return result;
}


/*************************************************************************
Function for testing Level 2 unsymmetric linear algebra functions.
Additionally it tests SparseGet() for several matrix formats.
Returns True on failure.

  -- ALGLIB PROJECT --
     Copyright 20.01.2014 by Bochkanov Sergey
*************************************************************************/
ae_bool testlevel2unsymmetric(ae_state *_state)
{
    ae_frame _frame_block;
    ae_int_t m;
    ae_int_t n;
    ae_vector x0;
    ae_vector x1;
    ae_vector y0;
    ae_vector y1;
    ae_int_t i;
    ae_int_t j;
    ae_matrix a;
    sparsematrix s0;
    sparsematrix sa;
    double eps;
    double v;
    sparsegenerator g;
    hqrndstate rs;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    ae_vector_init(&x0, 0, DT_REAL, _state);
    ae_vector_init(&x1, 0, DT_REAL, _state);
    ae_vector_init(&y0, 0, DT_REAL, _state);
    ae_vector_init(&y1, 0, DT_REAL, _state);
    ae_matrix_init(&a, 0, 0, DT_REAL, _state);
    _sparsematrix_init(&s0, _state);
    _sparsematrix_init(&sa, _state);
    _sparsegenerator_init(&g, _state);
    _hqrndstate_init(&rs, _state);

    eps = 10000*ae_machineepsilon;
    result = ae_false;
    hqrndrandomize(&rs, _state);
    
    /*
     * Test linear algebra functions
     */
    for(m=1; m<=20; m++)
    {
        for(n=1; n<=20; n++)
        {
            testsparseunit_initgenerator(m, n, 0, 0, &g, _state);
            while(testsparseunit_generatenext(&g, &a, &sa, _state))
            {
                
                /*
                 * Convert SA to desired storage format:
                 * * to CRS if M<>N
                 * * with 50% probability to CRS or SKS, if M=N
                 */
                if( m!=n||ae_fp_less(hqrnduniformr(&rs, _state),0.5) )
                {
                    sparsecopytocrs(&sa, &s0, _state);
                }
                else
                {
                    sparsecopytosks(&sa, &s0, _state);
                }
                
                /*
                 * Test SparseGet() for SA and S0 against matrix returned in A
                 */
                for(i=0; i<=m-1; i++)
                {
                    for(j=0; j<=n-1; j++)
                    {
                        seterrorflag(&result, ae_fp_greater(ae_fabs(sparseget(&sa, i, j, _state)-a.ptr.pp_double[i][j], _state),eps), _state);
                        seterrorflag(&result, ae_fp_greater(ae_fabs(sparseget(&s0, i, j, _state)-a.ptr.pp_double[i][j], _state),eps), _state);
                    }
                }
                
                /*
                 * Test SparseMV
                 */
                ae_vector_set_length(&x0, n, _state);
                ae_vector_set_length(&x1, n, _state);
                for(j=0; j<=n-1; j++)
                {
                    x0.ptr.p_double[j] = hqrnduniformr(&rs, _state)-0.5;
                    x1.ptr.p_double[j] = x0.ptr.p_double[j];
                }
                sparsemv(&s0, &x0, &y0, _state);
                seterrorflag(&result, y0.cnt<m, _state);
                if( result )
                {
                    ae_frame_leave(_state);
                    return result;
                }
                for(i=0; i<=m-1; i++)
                {
                    v = ae_v_dotproduct(&a.ptr.pp_double[i][0], 1, &x1.ptr.p_double[0], 1, ae_v_len(0,n-1));
                    seterrorflag(&result, ae_fp_greater(ae_fabs(v-y0.ptr.p_double[i], _state),eps), _state);
                }
                
                /*
                 * Test SparseMTV
                 */
                ae_vector_set_length(&x0, m, _state);
                ae_vector_set_length(&x1, m, _state);
                for(j=0; j<=m-1; j++)
                {
                    x0.ptr.p_double[j] = hqrnduniformr(&rs, _state)-0.5;
                    x1.ptr.p_double[j] = x0.ptr.p_double[j];
                }
                sparsemtv(&s0, &x0, &y0, _state);
                seterrorflag(&result, y0.cnt<n, _state);
                if( result )
                {
                    ae_frame_leave(_state);
                    return result;
                }
                for(j=0; j<=n-1; j++)
                {
                    v = ae_v_dotproduct(&a.ptr.pp_double[0][j], a.stride, &x1.ptr.p_double[0], 1, ae_v_len(0,m-1));
                    seterrorflag(&result, ae_fp_greater(ae_fabs(v-y0.ptr.p_double[j], _state),eps), _state);
                }
                
                /*
                 * Test SparseMV2
                 */
                if( m==n )
                {
                    ae_vector_set_length(&x0, n, _state);
                    ae_vector_set_length(&x1, n, _state);
                    for(j=0; j<=n-1; j++)
                    {
                        x0.ptr.p_double[j] = hqrnduniformr(&rs, _state)-0.5;
                        x1.ptr.p_double[j] = x0.ptr.p_double[j];
                    }
                    sparsemv2(&s0, &x0, &y0, &y1, _state);
                    seterrorflag(&result, y0.cnt<n, _state);
                    seterrorflag(&result, y1.cnt<n, _state);
                    if( result )
                    {
                        ae_frame_leave(_state);
                        return result;
                    }
                    for(j=0; j<=n-1; j++)
                    {
                        v = ae_v_dotproduct(&a.ptr.pp_double[j][0], 1, &x1.ptr.p_double[0], 1, ae_v_len(0,n-1));
                        seterrorflag(&result, ae_fp_greater(ae_fabs(v-y0.ptr.p_double[j], _state),eps), _state);
                        v = ae_v_dotproduct(&a.ptr.pp_double[0][j], a.stride, &x1.ptr.p_double[0], 1, ae_v_len(0,n-1));
                        seterrorflag(&result, ae_fp_greater(ae_fabs(v-y1.ptr.p_double[j], _state),eps), _state);
                    }
                }
            }
        }
    }
    ae_frame_leave(_state);
    return result;
}


/*************************************************************************
Function for testing Level 3 unsymmetric linear algebra functions.
Additionally it tests SparseGet() for several matrix formats.
Returns True on failure.

  -- ALGLIB PROJECT --
     Copyright 20.01.2014 by Bochkanov Sergey
*************************************************************************/
ae_bool testlevel3unsymmetric(ae_state *_state)
{
    ae_frame _frame_block;
    ae_int_t m;
    ae_int_t n;
    ae_int_t k;
    ae_matrix x0;
    ae_matrix x1;
    ae_matrix y0;
    ae_matrix y1;
    ae_int_t i;
    ae_int_t j;
    ae_matrix a;
    sparsematrix s0;
    sparsematrix sa;
    double eps;
    double v;
    sparsegenerator g;
    hqrndstate rs;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    ae_matrix_init(&x0, 0, 0, DT_REAL, _state);
    ae_matrix_init(&x1, 0, 0, DT_REAL, _state);
    ae_matrix_init(&y0, 0, 0, DT_REAL, _state);
    ae_matrix_init(&y1, 0, 0, DT_REAL, _state);
    ae_matrix_init(&a, 0, 0, DT_REAL, _state);
    _sparsematrix_init(&s0, _state);
    _sparsematrix_init(&sa, _state);
    _sparsegenerator_init(&g, _state);
    _hqrndstate_init(&rs, _state);

    eps = 10000*ae_machineepsilon;
    result = ae_false;
    hqrndrandomize(&rs, _state);
    
    /*
     * Test linear algebra functions
     */
    for(m=1; m<=20; m++)
    {
        for(n=1; n<=20; n++)
        {
            testsparseunit_initgenerator(m, n, 0, 0, &g, _state);
            while(testsparseunit_generatenext(&g, &a, &sa, _state))
            {
                
                /*
                 * Choose matrix width K
                 */
                k = 1+hqrnduniformi(&rs, 20, _state);
                
                /*
                 * Convert SA to desired storage format:
                 * * to CRS if M<>N
                 * * with 50% probability to CRS or SKS, if M=N
                 */
                if( m!=n||ae_fp_less(hqrnduniformr(&rs, _state),0.5) )
                {
                    sparsecopytocrs(&sa, &s0, _state);
                }
                else
                {
                    sparsecopytosks(&sa, &s0, _state);
                }
                
                /*
                 * Test SparseGet() for SA and S0 against matrix returned in A
                 */
                for(i=0; i<=m-1; i++)
                {
                    for(j=0; j<=n-1; j++)
                    {
                        seterrorflag(&result, ae_fp_neq(sparseget(&sa, i, j, _state),a.ptr.pp_double[i][j]), _state);
                        seterrorflag(&result, ae_fp_neq(sparseget(&s0, i, j, _state),a.ptr.pp_double[i][j]), _state);
                    }
                }
                
                /*
                 * Test SparseMV
                 */
                ae_matrix_set_length(&x0, n, k, _state);
                ae_matrix_set_length(&x1, n, k, _state);
                for(i=0; i<=n-1; i++)
                {
                    for(j=0; j<=k-1; j++)
                    {
                        x0.ptr.pp_double[i][j] = hqrnduniformr(&rs, _state)-0.5;
                        x1.ptr.pp_double[i][j] = x0.ptr.pp_double[i][j];
                    }
                }
                sparsemm(&s0, &x0, k, &y0, _state);
                seterrorflag(&result, y0.rows<m, _state);
                seterrorflag(&result, y0.cols<k, _state);
                if( result )
                {
                    ae_frame_leave(_state);
                    return result;
                }
                for(i=0; i<=m-1; i++)
                {
                    for(j=0; j<=k-1; j++)
                    {
                        v = ae_v_dotproduct(&a.ptr.pp_double[i][0], 1, &x1.ptr.pp_double[0][j], x1.stride, ae_v_len(0,n-1));
                        seterrorflag(&result, ae_fp_greater(ae_fabs(v-y0.ptr.pp_double[i][j], _state),eps), _state);
                    }
                }
                
                /*
                 * Test SparseMTM
                 */
                ae_matrix_set_length(&x0, m, k, _state);
                ae_matrix_set_length(&x1, m, k, _state);
                for(i=0; i<=m-1; i++)
                {
                    for(j=0; j<=k-1; j++)
                    {
                        x0.ptr.pp_double[i][j] = hqrnduniformr(&rs, _state)-0.5;
                        x1.ptr.pp_double[i][j] = x0.ptr.pp_double[i][j];
                    }
                }
                sparsemtm(&s0, &x0, k, &y0, _state);
                seterrorflag(&result, y0.rows<n, _state);
                seterrorflag(&result, y0.cols<k, _state);
                if( result )
                {
                    ae_frame_leave(_state);
                    return result;
                }
                for(i=0; i<=n-1; i++)
                {
                    for(j=0; j<=k-1; j++)
                    {
                        v = ae_v_dotproduct(&a.ptr.pp_double[0][i], a.stride, &x1.ptr.pp_double[0][j], x1.stride, ae_v_len(0,m-1));
                        seterrorflag(&result, ae_fp_greater(ae_fabs(v-y0.ptr.pp_double[i][j], _state),eps), _state);
                    }
                }
                
                /*
                 * Test SparseMM2
                 */
                if( m==n )
                {
                    ae_matrix_set_length(&x0, n, k, _state);
                    ae_matrix_set_length(&x1, n, k, _state);
                    for(i=0; i<=n-1; i++)
                    {
                        for(j=0; j<=k-1; j++)
                        {
                            x0.ptr.pp_double[i][j] = hqrnduniformr(&rs, _state)-0.5;
                            x1.ptr.pp_double[i][j] = x0.ptr.pp_double[i][j];
                        }
                    }
                    sparsemm2(&s0, &x0, k, &y0, &y1, _state);
                    seterrorflag(&result, y0.rows<n, _state);
                    seterrorflag(&result, y0.cols<k, _state);
                    seterrorflag(&result, y1.rows<n, _state);
                    seterrorflag(&result, y1.cols<k, _state);
                    if( result )
                    {
                        ae_frame_leave(_state);
                        return result;
                    }
                    for(i=0; i<=n-1; i++)
                    {
                        for(j=0; j<=k-1; j++)
                        {
                            v = ae_v_dotproduct(&a.ptr.pp_double[i][0], 1, &x1.ptr.pp_double[0][j], x1.stride, ae_v_len(0,n-1));
                            seterrorflag(&result, ae_fp_greater(ae_fabs(v-y0.ptr.pp_double[i][j], _state),eps), _state);
                            v = ae_v_dotproduct(&a.ptr.pp_double[0][i], a.stride, &x1.ptr.pp_double[0][j], x1.stride, ae_v_len(0,n-1));
                            seterrorflag(&result, ae_fp_greater(ae_fabs(v-y1.ptr.pp_double[i][j], _state),eps), _state);
                        }
                    }
                }
            }
        }
    }
    ae_frame_leave(_state);
    return result;
}


/*************************************************************************
Function for testing Level 2 symmetric linear algebra functions.
Additionally it tests SparseGet() for several matrix formats.
Returns True on failure.

  -- ALGLIB PROJECT --
     Copyright 20.01.2014 by Bochkanov Sergey
*************************************************************************/
ae_bool testlevel2symmetric(ae_state *_state)
{
    ae_frame _frame_block;
    ae_int_t n;
    ae_vector x0;
    ae_vector x1;
    ae_vector y0;
    ae_vector y1;
    ae_int_t i;
    ae_int_t j;
    ae_matrix a;
    sparsematrix s0;
    sparsematrix s1;
    sparsematrix sa;
    double eps;
    double v;
    double va;
    double vb;
    sparsegenerator g;
    hqrndstate rs;
    ae_bool isupper;
    ae_int_t triangletype;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    ae_vector_init(&x0, 0, DT_REAL, _state);
    ae_vector_init(&x1, 0, DT_REAL, _state);
    ae_vector_init(&y0, 0, DT_REAL, _state);
    ae_vector_init(&y1, 0, DT_REAL, _state);
    ae_matrix_init(&a, 0, 0, DT_REAL, _state);
    _sparsematrix_init(&s0, _state);
    _sparsematrix_init(&s1, _state);
    _sparsematrix_init(&sa, _state);
    _sparsegenerator_init(&g, _state);
    _hqrndstate_init(&rs, _state);

    eps = 10000*ae_machineepsilon;
    result = ae_false;
    hqrndrandomize(&rs, _state);
    
    /*
     * Test linear algebra functions
     */
    for(n=1; n<=20; n++)
    {
        for(triangletype=-1; triangletype<=1; triangletype++)
        {
            if( triangletype==-1 )
            {
                isupper = ae_false;
            }
            if( triangletype==0 )
            {
                isupper = ae_fp_greater(hqrnduniformr(&rs, _state),0.5);
            }
            if( triangletype==1 )
            {
                isupper = ae_true;
            }
            testsparseunit_initgenerator(n, n, 0, triangletype, &g, _state);
            while(testsparseunit_generatenext(&g, &a, &sa, _state))
            {
                
                /*
                 * Convert SA to desired storage format:
                 * * S0 stores unmodified copy
                 * * S1 stores copy with unmodified triangle corresponding
                 *   to IsUpper and another triangle being spoiled by random
                 *   trash
                 */
                sparsecopytohash(&sa, &s1, _state);
                for(i=0; i<=n-1; i++)
                {
                    for(j=0; j<=n-1; j++)
                    {
                        if( (j<i&&isupper)||(j>i&&!isupper) )
                        {
                            sparseset(&s1, i, j, hqrnduniformr(&rs, _state), _state);
                        }
                    }
                }
                if( ae_fp_less(hqrnduniformr(&rs, _state),0.5) )
                {
                    sparsecopytocrs(&sa, &s0, _state);
                    sparseconverttocrs(&s1, _state);
                }
                else
                {
                    sparsecopytosks(&sa, &s0, _state);
                    sparseconverttosks(&s1, _state);
                }
                
                /*
                 * Test SparseGet() for SA and S0 against matrix returned in A
                 */
                for(i=0; i<=n-1; i++)
                {
                    for(j=0; j<=n-1; j++)
                    {
                        seterrorflag(&result, ae_fp_greater(ae_fabs(sparseget(&sa, i, j, _state)-a.ptr.pp_double[i][j], _state),eps), _state);
                        seterrorflag(&result, ae_fp_greater(ae_fabs(sparseget(&s0, i, j, _state)-a.ptr.pp_double[i][j], _state),eps), _state);
                        seterrorflag(&result, (j<i&&triangletype==1)&&ae_fp_neq(sparseget(&s0, i, j, _state),(double)(0)), _state);
                        seterrorflag(&result, (j>i&&triangletype==-1)&&ae_fp_neq(sparseget(&s0, i, j, _state),(double)(0)), _state);
                    }
                }
                
                /*
                 * Before we proceed with testing, update empty triangle of A
                 * with its copy from another part of the matrix.
                 */
                for(i=0; i<=n-1; i++)
                {
                    for(j=0; j<=n-1; j++)
                    {
                        if( (j<i&&isupper)||(j>i&&!isupper) )
                        {
                            a.ptr.pp_double[i][j] = a.ptr.pp_double[j][i];
                        }
                    }
                }
                
                /*
                 * Test SparseSMV
                 */
                ae_vector_set_length(&x0, n, _state);
                ae_vector_set_length(&x1, n, _state);
                for(j=0; j<=n-1; j++)
                {
                    x0.ptr.p_double[j] = hqrnduniformr(&rs, _state)-0.5;
                    x1.ptr.p_double[j] = x0.ptr.p_double[j];
                }
                sparsesmv(&s0, isupper, &x0, &y0, _state);
                seterrorflag(&result, y0.cnt<n, _state);
                if( result )
                {
                    ae_frame_leave(_state);
                    return result;
                }
                for(i=0; i<=n-1; i++)
                {
                    v = ae_v_dotproduct(&a.ptr.pp_double[i][0], 1, &x1.ptr.p_double[0], 1, ae_v_len(0,n-1));
                    seterrorflag(&result, ae_fp_greater(ae_fabs(v-y0.ptr.p_double[i], _state),eps), _state);
                }
                sparsesmv(&s1, isupper, &x0, &y1, _state);
                seterrorflag(&result, y1.cnt<n, _state);
                if( result )
                {
                    ae_frame_leave(_state);
                    return result;
                }
                for(i=0; i<=n-1; i++)
                {
                    v = ae_v_dotproduct(&a.ptr.pp_double[i][0], 1, &x1.ptr.p_double[0], 1, ae_v_len(0,n-1));
                    seterrorflag(&result, ae_fp_greater(ae_fabs(v-y1.ptr.p_double[i], _state),eps), _state);
                }
                
                /*
                 * Test SparseVSMV
                 */
                ae_vector_set_length(&x0, n, _state);
                ae_vector_set_length(&x1, n, _state);
                for(j=0; j<=n-1; j++)
                {
                    x0.ptr.p_double[j] = hqrnduniformr(&rs, _state)-0.5;
                    x1.ptr.p_double[j] = x0.ptr.p_double[j];
                }
                vb = 0.0;
                for(i=0; i<=n-1; i++)
                {
                    for(j=0; j<=n-1; j++)
                    {
                        vb = vb+x1.ptr.p_double[i]*a.ptr.pp_double[i][j]*x1.ptr.p_double[j];
                    }
                }
                va = sparsevsmv(&s0, isupper, &x0, _state);
                seterrorflag(&result, ae_fp_greater(ae_fabs(va-vb, _state),eps), _state);
                va = sparsevsmv(&s1, isupper, &x0, _state);
                seterrorflag(&result, ae_fp_greater(ae_fabs(va-vb, _state),eps), _state);
            }
        }
    }
    ae_frame_leave(_state);
    return result;
}


/*************************************************************************
Function for testing Level 2 symmetric linear algebra functions.
Additionally it tests SparseGet() for several matrix formats.
Returns True on failure.

  -- ALGLIB PROJECT --
     Copyright 14.10.2011 by Bochkanov Sergey
*************************************************************************/
ae_bool testlevel3symmetric(ae_state *_state)
{
    ae_frame _frame_block;
    ae_int_t n;
    ae_int_t k;
    ae_matrix x0;
    ae_matrix x1;
    ae_matrix y0;
    ae_matrix y1;
    ae_int_t i;
    ae_int_t j;
    ae_matrix a;
    sparsematrix s0;
    sparsematrix s1;
    sparsematrix sa;
    double eps;
    double v;
    sparsegenerator g;
    hqrndstate rs;
    ae_bool isupper;
    ae_int_t triangletype;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    ae_matrix_init(&x0, 0, 0, DT_REAL, _state);
    ae_matrix_init(&x1, 0, 0, DT_REAL, _state);
    ae_matrix_init(&y0, 0, 0, DT_REAL, _state);
    ae_matrix_init(&y1, 0, 0, DT_REAL, _state);
    ae_matrix_init(&a, 0, 0, DT_REAL, _state);
    _sparsematrix_init(&s0, _state);
    _sparsematrix_init(&s1, _state);
    _sparsematrix_init(&sa, _state);
    _sparsegenerator_init(&g, _state);
    _hqrndstate_init(&rs, _state);

    eps = 10000*ae_machineepsilon;
    result = ae_false;
    hqrndrandomize(&rs, _state);
    
    /*
     * Test linear algebra functions
     */
    for(n=1; n<=20; n++)
    {
        for(triangletype=-1; triangletype<=1; triangletype++)
        {
            if( triangletype==-1 )
            {
                isupper = ae_false;
            }
            if( triangletype==0 )
            {
                isupper = ae_fp_greater(hqrnduniformr(&rs, _state),0.5);
            }
            if( triangletype==1 )
            {
                isupper = ae_true;
            }
            testsparseunit_initgenerator(n, n, 0, triangletype, &g, _state);
            while(testsparseunit_generatenext(&g, &a, &sa, _state))
            {
                
                /*
                 * Choose matrix width K
                 */
                k = 1+hqrnduniformi(&rs, 20, _state);
                
                /*
                 * Convert SA to desired storage format:
                 * * S0 stores unmodified copy
                 * * S1 stores copy with unmodified triangle corresponding
                 *   to IsUpper and another triangle being spoiled by random
                 *   trash
                 */
                sparsecopytohash(&sa, &s1, _state);
                for(i=0; i<=n-1; i++)
                {
                    for(j=0; j<=n-1; j++)
                    {
                        if( (j<i&&isupper)||(j>i&&!isupper) )
                        {
                            sparseset(&s1, i, j, hqrnduniformr(&rs, _state), _state);
                        }
                    }
                }
                if( ae_fp_less(hqrnduniformr(&rs, _state),0.5) )
                {
                    sparsecopytocrs(&sa, &s0, _state);
                    sparseconverttocrs(&s1, _state);
                }
                else
                {
                    sparsecopytosks(&sa, &s0, _state);
                    sparseconverttosks(&s1, _state);
                }
                
                /*
                 * Test SparseGet() for SA and S0 against matrix returned in A
                 */
                for(i=0; i<=n-1; i++)
                {
                    for(j=0; j<=n-1; j++)
                    {
                        seterrorflag(&result, ae_fp_greater(ae_fabs(sparseget(&sa, i, j, _state)-a.ptr.pp_double[i][j], _state),eps), _state);
                        seterrorflag(&result, ae_fp_greater(ae_fabs(sparseget(&s0, i, j, _state)-a.ptr.pp_double[i][j], _state),eps), _state);
                        seterrorflag(&result, (j<i&&triangletype==1)&&ae_fp_neq(sparseget(&s0, i, j, _state),(double)(0)), _state);
                        seterrorflag(&result, (j>i&&triangletype==-1)&&ae_fp_neq(sparseget(&s0, i, j, _state),(double)(0)), _state);
                    }
                }
                
                /*
                 * Before we proceed with testing, update empty triangle of A
                 * with its copy from another part of the matrix.
                 */
                for(i=0; i<=n-1; i++)
                {
                    for(j=0; j<=n-1; j++)
                    {
                        if( (j<i&&isupper)||(j>i&&!isupper) )
                        {
                            a.ptr.pp_double[i][j] = a.ptr.pp_double[j][i];
                        }
                    }
                }
                
                /*
                 * Test SparseSMM
                 */
                ae_matrix_set_length(&x0, n, k, _state);
                ae_matrix_set_length(&x1, n, k, _state);
                for(i=0; i<=n-1; i++)
                {
                    for(j=0; j<=k-1; j++)
                    {
                        x0.ptr.pp_double[i][j] = hqrnduniformr(&rs, _state)-0.5;
                        x1.ptr.pp_double[i][j] = x0.ptr.pp_double[i][j];
                    }
                }
                sparsesmm(&s0, isupper, &x0, k, &y0, _state);
                seterrorflag(&result, y0.rows<n, _state);
                seterrorflag(&result, y0.cols<k, _state);
                if( result )
                {
                    ae_frame_leave(_state);
                    return result;
                }
                for(i=0; i<=n-1; i++)
                {
                    for(j=0; j<=k-1; j++)
                    {
                        v = ae_v_dotproduct(&a.ptr.pp_double[i][0], 1, &x1.ptr.pp_double[0][j], x1.stride, ae_v_len(0,n-1));
                        seterrorflag(&result, ae_fp_greater(ae_fabs(v-y0.ptr.pp_double[i][j], _state),eps), _state);
                    }
                }
            }
        }
    }
    ae_frame_leave(_state);
    return result;
}


/*************************************************************************
Function for testing Level 2 triangular linear algebra functions.
Returns True on failure.

  -- ALGLIB PROJECT --
     Copyright 20.01.2014 by Bochkanov Sergey
*************************************************************************/
ae_bool testlevel2triangular(ae_state *_state)
{
    ae_frame _frame_block;
    ae_int_t n;
    ae_vector x0;
    ae_vector x1;
    ae_vector y0;
    ae_vector y1;
    ae_vector ey;
    ae_int_t i;
    ae_int_t j;
    ae_int_t i1;
    ae_int_t j1;
    ae_matrix a;
    ae_matrix ea;
    sparsematrix s0;
    sparsematrix s1;
    sparsematrix sa;
    double eps;
    double v;
    sparsegenerator g;
    hqrndstate rs;
    ae_bool isupper;
    ae_bool isunit;
    ae_int_t optype;
    ae_int_t triangletype;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    ae_vector_init(&x0, 0, DT_REAL, _state);
    ae_vector_init(&x1, 0, DT_REAL, _state);
    ae_vector_init(&y0, 0, DT_REAL, _state);
    ae_vector_init(&y1, 0, DT_REAL, _state);
    ae_vector_init(&ey, 0, DT_REAL, _state);
    ae_matrix_init(&a, 0, 0, DT_REAL, _state);
    ae_matrix_init(&ea, 0, 0, DT_REAL, _state);
    _sparsematrix_init(&s0, _state);
    _sparsematrix_init(&s1, _state);
    _sparsematrix_init(&sa, _state);
    _sparsegenerator_init(&g, _state);
    _hqrndstate_init(&rs, _state);

    eps = 10000*ae_machineepsilon;
    result = ae_false;
    hqrndrandomize(&rs, _state);
    
    /*
     * Test sparseTRMV
     */
    for(n=1; n<=20; n++)
    {
        for(triangletype=-1; triangletype<=1; triangletype++)
        {
            if( triangletype==-1 )
            {
                isupper = ae_false;
            }
            if( triangletype==0 )
            {
                isupper = ae_fp_greater(hqrnduniformr(&rs, _state),0.5);
            }
            if( triangletype==1 )
            {
                isupper = ae_true;
            }
            testsparseunit_initgenerator(n, n, 0, triangletype, &g, _state);
            while(testsparseunit_generatenext(&g, &a, &sa, _state))
            {
                
                /*
                 * Settings (IsUpper was already set, handle the rest)
                 */
                isunit = ae_fp_less(hqrnduniformr(&rs, _state),0.5);
                optype = hqrnduniformi(&rs, 2, _state);
                
                /*
                 * Convert SA to desired storage format:
                 * * S0 stores unmodified copy
                 * * S1 stores copy with unmodified triangle corresponding
                 *   to IsUpper and another triangle being spoiled by random
                 *   trash
                 */
                sparsecopytohash(&sa, &s1, _state);
                for(i=0; i<=n-1; i++)
                {
                    for(j=0; j<=n-1; j++)
                    {
                        if( (j<i&&isupper)||(j>i&&!isupper) )
                        {
                            sparseset(&s1, i, j, hqrnduniformr(&rs, _state), _state);
                        }
                    }
                }
                if( ae_fp_less(hqrnduniformr(&rs, _state),0.5) )
                {
                    sparsecopytocrs(&sa, &s0, _state);
                    sparseconverttocrs(&s1, _state);
                }
                else
                {
                    sparsecopytosks(&sa, &s0, _state);
                    sparseconverttosks(&s1, _state);
                }
                
                /*
                 * Generate "effective A"
                 */
                ae_matrix_set_length(&ea, n, n, _state);
                for(i=0; i<=n-1; i++)
                {
                    for(j=0; j<=n-1; j++)
                    {
                        ea.ptr.pp_double[i][j] = (double)(0);
                    }
                }
                for(i=0; i<=n-1; i++)
                {
                    for(j=0; j<=n-1; j++)
                    {
                        if( (j>=i&&isupper)||(j<=i&&!isupper) )
                        {
                            i1 = i;
                            j1 = j;
                            if( optype==1 )
                            {
                                swapi(&i1, &j1, _state);
                            }
                            ea.ptr.pp_double[i1][j1] = a.ptr.pp_double[i][j];
                            if( isunit&&i1==j1 )
                            {
                                ea.ptr.pp_double[i1][j1] = 1.0;
                            }
                        }
                    }
                }
                
                /*
                 * Test SparseTRMV
                 */
                ae_vector_set_length(&x0, n, _state);
                ae_vector_set_length(&x1, n, _state);
                for(j=0; j<=n-1; j++)
                {
                    x0.ptr.p_double[j] = hqrnduniformr(&rs, _state)-0.5;
                    x1.ptr.p_double[j] = x0.ptr.p_double[j];
                }
                sparsetrmv(&s0, isupper, isunit, optype, &x0, &y0, _state);
                seterrorflag(&result, y0.cnt<n, _state);
                if( result )
                {
                    ae_frame_leave(_state);
                    return result;
                }
                for(i=0; i<=n-1; i++)
                {
                    v = ae_v_dotproduct(&ea.ptr.pp_double[i][0], 1, &x1.ptr.p_double[0], 1, ae_v_len(0,n-1));
                    seterrorflag(&result, ae_fp_greater(ae_fabs(v-y0.ptr.p_double[i], _state),eps), _state);
                }
                sparsetrmv(&s0, isupper, isunit, optype, &x0, &y1, _state);
                seterrorflag(&result, y1.cnt<n, _state);
                if( result )
                {
                    ae_frame_leave(_state);
                    return result;
                }
                for(i=0; i<=n-1; i++)
                {
                    v = ae_v_dotproduct(&ea.ptr.pp_double[i][0], 1, &x1.ptr.p_double[0], 1, ae_v_len(0,n-1));
                    seterrorflag(&result, ae_fp_greater(ae_fabs(v-y1.ptr.p_double[i], _state),eps), _state);
                }
            }
        }
    }
    
    /*
     * Test sparseTRSV
     */
    for(n=1; n<=20; n++)
    {
        for(triangletype=-1; triangletype<=1; triangletype++)
        {
            if( triangletype==-1 )
            {
                isupper = ae_false;
            }
            if( triangletype==0 )
            {
                isupper = ae_fp_greater(hqrnduniformr(&rs, _state),0.5);
            }
            if( triangletype==1 )
            {
                isupper = ae_true;
            }
            testsparseunit_initgenerator(n, n, 1, triangletype, &g, _state);
            while(testsparseunit_generatenext(&g, &a, &sa, _state))
            {
                
                /*
                 * Settings (IsUpper was already set, handle the rest)
                 */
                isunit = ae_fp_less(hqrnduniformr(&rs, _state),0.5);
                optype = hqrnduniformi(&rs, 2, _state);
                
                /*
                 * Convert SA to desired storage format:
                 * * S0 stores unmodified copy
                 * * S1 stores copy with unmodified triangle corresponding
                 *   to IsUpper and another triangle being spoiled by random
                 *   trash
                 */
                sparsecopytohash(&sa, &s1, _state);
                for(i=0; i<=n-1; i++)
                {
                    for(j=0; j<=n-1; j++)
                    {
                        if( (j<i&&isupper)||(j>i&&!isupper) )
                        {
                            sparseset(&s1, i, j, hqrnduniformr(&rs, _state), _state);
                        }
                    }
                }
                if( ae_fp_less(hqrnduniformr(&rs, _state),0.5) )
                {
                    sparsecopytocrs(&sa, &s0, _state);
                    sparseconverttocrs(&s1, _state);
                }
                else
                {
                    sparsecopytosks(&sa, &s0, _state);
                    sparseconverttosks(&s1, _state);
                }
                
                /*
                 * Generate "effective A" and EY = inv(EA)*x0
                 */
                ae_matrix_set_length(&ea, n, n, _state);
                for(i=0; i<=n-1; i++)
                {
                    for(j=0; j<=n-1; j++)
                    {
                        ea.ptr.pp_double[i][j] = (double)(0);
                    }
                }
                for(i=0; i<=n-1; i++)
                {
                    for(j=0; j<=n-1; j++)
                    {
                        if( (j>=i&&isupper)||(j<=i&&!isupper) )
                        {
                            i1 = i;
                            j1 = j;
                            if( optype==1 )
                            {
                                swapi(&i1, &j1, _state);
                            }
                            ea.ptr.pp_double[i1][j1] = a.ptr.pp_double[i][j];
                            if( isunit&&i1==j1 )
                            {
                                ea.ptr.pp_double[i1][j1] = 1.0;
                            }
                        }
                    }
                }
                ae_vector_set_length(&ey, n, _state);
                for(i=0; i<=n-1; i++)
                {
                    ey.ptr.p_double[i] = hqrnduniformr(&rs, _state)-0.5;
                }
                ae_vector_set_length(&x0, n, _state);
                ae_vector_set_length(&x1, n, _state);
                for(i=0; i<=n-1; i++)
                {
                    v = ae_v_dotproduct(&ea.ptr.pp_double[i][0], 1, &ey.ptr.p_double[0], 1, ae_v_len(0,n-1));
                    x0.ptr.p_double[i] = v;
                    x1.ptr.p_double[i] = v;
                }
                
                /*
                 * Test SparseTRSV
                 */
                sparsetrsv(&s0, isupper, isunit, optype, &x0, _state);
                seterrorflag(&result, x0.cnt<n, _state);
                if( result )
                {
                    ae_frame_leave(_state);
                    return result;
                }
                for(i=0; i<=n-1; i++)
                {
                    seterrorflag(&result, ae_fp_greater(ae_fabs(ey.ptr.p_double[i]-x0.ptr.p_double[i], _state),eps), _state);
                }
                sparsetrsv(&s1, isupper, isunit, optype, &x1, _state);
                seterrorflag(&result, x1.cnt<n, _state);
                if( result )
                {
                    ae_frame_leave(_state);
                    return result;
                }
                for(i=0; i<=n-1; i++)
                {
                    seterrorflag(&result, ae_fp_greater(ae_fabs(ey.ptr.p_double[i]-x1.ptr.p_double[i], _state),eps), _state);
                }
            }
        }
    }
    ae_frame_leave(_state);
    return result;
}


/*************************************************************************
Function for testing basic functional

  -- ALGLIB PROJECT --
     Copyright 14.10.2011 by Bochkanov Sergey
*************************************************************************/
ae_bool basicfuncrandomtest(ae_state *_state)
{
    ae_frame _frame_block;
    sparsematrix s;
    ae_int_t n;
    ae_int_t m;
    ae_int_t i;
    ae_int_t j;
    ae_int_t i1;
    ae_int_t j1;
    ae_matrix a;
    ae_int_t mfigure;
    ae_int_t temp;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    _sparsematrix_init(&s, _state);
    ae_matrix_init(&a, 0, 0, DT_REAL, _state);

    n = 20;
    m = 20;
    mfigure = 10;
    for(i=1; i<=m-1; i++)
    {
        for(j=1; j<=n-1; j++)
        {
            sparsecreate(i, j, 0, &s, _state);
            ae_matrix_set_length(&a, i, j, _state);
            
            /*
             * Checking for Matrix with hash table type
             */
            for(i1=0; i1<=i-1; i1++)
            {
                for(j1=0; j1<=j-1; j1++)
                {
                    temp = 2*ae_randominteger(mfigure, _state)-mfigure;
                    a.ptr.pp_double[i1][j1] = (double)(temp);
                    if( ae_randominteger(2, _state)==0 )
                    {
                        sparseset(&s, i1, j1, (double)(temp), _state);
                        sparseset(&s, i1, j1, (double)(temp), _state);
                    }
                    else
                    {
                        sparseadd(&s, i1, j1, (double)(temp), _state);
                        sparseadd(&s, i1, j1, (double)(0), _state);
                    }
                    if( ae_fp_neq(a.ptr.pp_double[i1][j1],sparseget(&s, i1, j1, _state)) )
                    {
                        result = ae_true;
                        ae_frame_leave(_state);
                        return result;
                    }
                }
            }
            
            /*
             * Nulling all elements
             */
            for(i1=0; i1<=i-1; i1++)
            {
                for(j1=0; j1<=j-1; j1++)
                {
                    if( ae_randominteger(2, _state)==0 )
                    {
                        sparseset(&s, i1, j1, (double)(0), _state);
                    }
                    else
                    {
                        sparseadd(&s, i1, j1, -1*sparseget(&s, i1, j1, _state), _state);
                    }
                }
            }
            
            /*
             * Again initialization of the matrix and check new values
             */
            for(i1=0; i1<=i-1; i1++)
            {
                for(j1=0; j1<=j-1; j1++)
                {
                    temp = 2*ae_randominteger(mfigure, _state)-mfigure;
                    a.ptr.pp_double[i1][j1] = (double)(temp);
                    if( ae_randominteger(2, _state)==0 )
                    {
                        sparseset(&s, i1, j1, (double)(temp), _state);
                    }
                    else
                    {
                        sparseadd(&s, i1, j1, (double)(temp), _state);
                    }
                    if( ae_fp_neq(a.ptr.pp_double[i1][j1],sparseget(&s, i1, j1, _state)) )
                    {
                        result = ae_true;
                        ae_frame_leave(_state);
                        return result;
                    }
                }
            }
            
            /*
             * Checking for Matrix with CRS type
             */
            sparseconverttocrs(&s, _state);
            for(i1=0; i1<=i-1; i1++)
            {
                for(j1=0; j1<=j-1; j1++)
                {
                    if( ae_fp_neq(a.ptr.pp_double[i1][j1],sparseget(&s, i1, j1, _state)) )
                    {
                        result = ae_true;
                        ae_frame_leave(_state);
                        return result;
                    }
                }
            }
        }
    }
    result = ae_false;
    ae_frame_leave(_state);
    return result;
}


/*************************************************************************
Function for testing multyplication matrix with vector

  -- ALGLIB PROJECT --
     Copyright 14.10.2011 by Bochkanov Sergey
*************************************************************************/
ae_bool linearfunctionstest(ae_state *_state)
{
    ae_frame _frame_block;
    sparsematrix s;
    ae_int_t n;
    ae_int_t m;
    ae_int_t i;
    ae_int_t j;
    ae_int_t i1;
    ae_int_t j1;
    double lb;
    double rb;
    ae_matrix a;
    ae_vector x0;
    ae_vector x1;
    ae_vector ty;
    ae_vector tyt;
    ae_vector y;
    ae_vector yt;
    ae_vector y0;
    ae_vector yt0;
    double eps;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    _sparsematrix_init(&s, _state);
    ae_matrix_init(&a, 0, 0, DT_REAL, _state);
    ae_vector_init(&x0, 0, DT_REAL, _state);
    ae_vector_init(&x1, 0, DT_REAL, _state);
    ae_vector_init(&ty, 0, DT_REAL, _state);
    ae_vector_init(&tyt, 0, DT_REAL, _state);
    ae_vector_init(&y, 0, DT_REAL, _state);
    ae_vector_init(&yt, 0, DT_REAL, _state);
    ae_vector_init(&y0, 0, DT_REAL, _state);
    ae_vector_init(&yt0, 0, DT_REAL, _state);

    
    /*
     * Accuracy
     */
    eps = 1000*ae_machineepsilon;
    
    /*
     * Size of the matrix (m*n)
     */
    n = 10;
    m = 10;
    
    /*
     * Left and right borders, limiting matrix values
     */
    lb = (double)(-10);
    rb = (double)(10);
    
    /*
     * Test linear algebra functions for:
     * a) sparse matrix converted to CRS from Hash-Table
     * b) sparse matrix initially created as CRS
     */
    for(i=1; i<=m-1; i++)
    {
        for(j=1; j<=n-1; j++)
        {
            
            /*
             * Prepare test problem
             */
            testsparseunit_createrandom(i, j, -1, -1, -1, -1, &a, &s, _state);
            
            /*
             * Initialize temporaries
             */
            ae_vector_set_length(&ty, i, _state);
            ae_vector_set_length(&tyt, j, _state);
            for(i1=0; i1<=i-1; i1++)
            {
                ty.ptr.p_double[i1] = (double)(0);
            }
            for(i1=0; i1<=j-1; i1++)
            {
                tyt.ptr.p_double[i1] = (double)(0);
            }
            ae_vector_set_length(&x0, j, _state);
            ae_vector_set_length(&x1, i, _state);
            for(i1=0; i1<=j-1; i1++)
            {
                x0.ptr.p_double[i1] = (rb-lb)*ae_randomreal(_state)+lb;
            }
            for(i1=0; i1<=i-1; i1++)
            {
                x1.ptr.p_double[i1] = (rb-lb)*ae_randomreal(_state)+lb;
            }
            
            /*
             * Consider two cases: square matrix, and non-square matrix
             */
            if( i!=j )
            {
                
                /*
                 * Searching true result
                 */
                for(i1=0; i1<=i-1; i1++)
                {
                    for(j1=0; j1<=j-1; j1++)
                    {
                        ty.ptr.p_double[i1] = ty.ptr.p_double[i1]+a.ptr.pp_double[i1][j1]*x0.ptr.p_double[j1];
                        tyt.ptr.p_double[j1] = tyt.ptr.p_double[j1]+a.ptr.pp_double[i1][j1]*x1.ptr.p_double[i1];
                    }
                }
                
                /*
                 * Multiplication
                 */
                sparsemv(&s, &x0, &y, _state);
                sparsemtv(&s, &x1, &yt, _state);
                
                /*
                 * Check for MV-result
                 */
                for(i1=0; i1<=i-1; i1++)
                {
                    if( ae_fp_greater_eq(ae_fabs(y.ptr.p_double[i1]-ty.ptr.p_double[i1], _state),eps) )
                    {
                        result = ae_true;
                        ae_frame_leave(_state);
                        return result;
                    }
                }
                
                /*
                 * Check for MTV-result
                 */
                for(i1=0; i1<=j-1; i1++)
                {
                    if( ae_fp_greater_eq(ae_fabs(yt.ptr.p_double[i1]-tyt.ptr.p_double[i1], _state),eps) )
                    {
                        result = ae_true;
                        ae_frame_leave(_state);
                        return result;
                    }
                }
            }
            else
            {
                
                /*
                 * Searching true result
                 */
                for(i1=0; i1<=i-1; i1++)
                {
                    for(j1=0; j1<=j-1; j1++)
                    {
                        ty.ptr.p_double[i1] = ty.ptr.p_double[i1]+a.ptr.pp_double[i1][j1]*x0.ptr.p_double[j1];
                        tyt.ptr.p_double[j1] = tyt.ptr.p_double[j1]+a.ptr.pp_double[i1][j1]*x0.ptr.p_double[i1];
                    }
                }
                sparsemv(&s, &x0, &y, _state);
                sparsemtv(&s, &x0, &yt, _state);
                sparsemv2(&s, &x0, &y0, &yt0, _state);
                
                /*
                 * Check for MV2-result
                 */
                for(i1=0; i1<=i-1; i1++)
                {
                    if( ae_fp_greater_eq(ae_fabs(y0.ptr.p_double[i1]-ty.ptr.p_double[i1], _state),eps)||ae_fp_greater_eq(ae_fabs(yt0.ptr.p_double[i1]-tyt.ptr.p_double[i1], _state),eps) )
                    {
                        result = ae_true;
                        ae_frame_leave(_state);
                        return result;
                    }
                }
                
                /*
                 * Check for MV- and MTV-result by help MV2
                 */
                for(i1=0; i1<=i-1; i1++)
                {
                    if( ae_fp_greater(ae_fabs(y0.ptr.p_double[i1]-y.ptr.p_double[i1], _state),eps)||ae_fp_greater(ae_fabs(yt0.ptr.p_double[i1]-yt.ptr.p_double[i1], _state),eps) )
                    {
                        result = ae_true;
                        ae_frame_leave(_state);
                        return result;
                    }
                }
            }
        }
    }
    result = ae_false;
    ae_frame_leave(_state);
    return result;
}


/*************************************************************************
Function for testing multyplication for simmetric matrix with vector

  -- ALGLIB PROJECT --
     Copyright 14.10.2011 by Bochkanov Sergey
*************************************************************************/
ae_bool linearfunctionsstest(ae_state *_state)
{
    ae_frame _frame_block;
    sparsematrix s;
    ae_int_t m;
    ae_int_t i;
    ae_int_t i1;
    ae_int_t j1;
    double lb;
    double rb;
    ae_matrix a;
    ae_vector x0;
    ae_vector x1;
    ae_vector ty;
    ae_vector tyt;
    ae_vector y;
    ae_vector yt;
    double eps;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    _sparsematrix_init(&s, _state);
    ae_matrix_init(&a, 0, 0, DT_REAL, _state);
    ae_vector_init(&x0, 0, DT_REAL, _state);
    ae_vector_init(&x1, 0, DT_REAL, _state);
    ae_vector_init(&ty, 0, DT_REAL, _state);
    ae_vector_init(&tyt, 0, DT_REAL, _state);
    ae_vector_init(&y, 0, DT_REAL, _state);
    ae_vector_init(&yt, 0, DT_REAL, _state);

    
    /*
     *Accuracy
     */
    eps = 1000*ae_machineepsilon;
    
    /*
     * Size of the matrix (m*m)
     */
    m = 10;
    
    /*
     * Left and right borders, limiting matrix values
     */
    lb = (double)(-10);
    rb = (double)(10);
    
    /*
     * Test linear algebra functions for:
     * a) sparse matrix converted to CRS from Hash-Table
     * b) sparse matrix initially created as CRS
     */
    for(i=1; i<=m-1; i++)
    {
        
        /*
         * Prepare test problem
         */
        testsparseunit_createrandom(i, i, -1, -1, -1, -1, &a, &s, _state);
        
        /*
         * Initialize temporaries
         */
        ae_vector_set_length(&ty, i, _state);
        ae_vector_set_length(&tyt, i, _state);
        ae_vector_set_length(&x0, i, _state);
        ae_vector_set_length(&x1, i, _state);
        for(i1=0; i1<=i-1; i1++)
        {
            ty.ptr.p_double[i1] = (double)(0);
            tyt.ptr.p_double[i1] = (double)(0);
            x0.ptr.p_double[i1] = (rb-lb)*ae_randomreal(_state)+lb;
            x1.ptr.p_double[i1] = (rb-lb)*ae_randomreal(_state)+lb;
        }
        
        /*
         * Searching true result for upper and lower triangles
         * of the matrix
         */
        for(i1=0; i1<=i-1; i1++)
        {
            for(j1=i1; j1<=i-1; j1++)
            {
                ty.ptr.p_double[i1] = ty.ptr.p_double[i1]+a.ptr.pp_double[i1][j1]*x0.ptr.p_double[j1];
                if( i1!=j1 )
                {
                    ty.ptr.p_double[j1] = ty.ptr.p_double[j1]+a.ptr.pp_double[i1][j1]*x0.ptr.p_double[i1];
                }
            }
        }
        for(i1=0; i1<=i-1; i1++)
        {
            for(j1=0; j1<=i1; j1++)
            {
                tyt.ptr.p_double[i1] = tyt.ptr.p_double[i1]+a.ptr.pp_double[i1][j1]*x1.ptr.p_double[j1];
                if( i1!=j1 )
                {
                    tyt.ptr.p_double[j1] = tyt.ptr.p_double[j1]+a.ptr.pp_double[i1][j1]*x1.ptr.p_double[i1];
                }
            }
        }
        
        /*
         * Multiplication
         */
        sparsesmv(&s, ae_true, &x0, &y, _state);
        sparsesmv(&s, ae_false, &x1, &yt, _state);
        
        /*
         * Check for SMV-result
         */
        for(i1=0; i1<=i-1; i1++)
        {
            if( ae_fp_greater_eq(ae_fabs(y.ptr.p_double[i1]-ty.ptr.p_double[i1], _state),eps)||ae_fp_greater_eq(ae_fabs(yt.ptr.p_double[i1]-tyt.ptr.p_double[i1], _state),eps) )
            {
                result = ae_true;
                ae_frame_leave(_state);
                return result;
            }
        }
    }
    result = ae_false;
    ae_frame_leave(_state);
    return result;
}


/*************************************************************************
Function for testing multyplication sparse matrix with nerrow dense matrix

  -- ALGLIB PROJECT --
     Copyright 14.10.2011 by Bochkanov Sergey
*************************************************************************/
ae_bool linearfunctionsmmtest(ae_state *_state)
{
    ae_frame _frame_block;
    sparsematrix s;
    ae_int_t n;
    ae_int_t m;
    ae_int_t kmax;
    ae_int_t i;
    ae_int_t j;
    ae_int_t k;
    ae_int_t i1;
    ae_int_t j1;
    ae_int_t k1;
    double lb;
    double rb;
    ae_matrix a;
    ae_matrix x0;
    ae_matrix x1;
    ae_matrix ty;
    ae_matrix tyt;
    ae_matrix y;
    ae_matrix yt;
    ae_matrix y0;
    ae_matrix yt0;
    double eps;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    _sparsematrix_init(&s, _state);
    ae_matrix_init(&a, 0, 0, DT_REAL, _state);
    ae_matrix_init(&x0, 0, 0, DT_REAL, _state);
    ae_matrix_init(&x1, 0, 0, DT_REAL, _state);
    ae_matrix_init(&ty, 0, 0, DT_REAL, _state);
    ae_matrix_init(&tyt, 0, 0, DT_REAL, _state);
    ae_matrix_init(&y, 0, 0, DT_REAL, _state);
    ae_matrix_init(&yt, 0, 0, DT_REAL, _state);
    ae_matrix_init(&y0, 0, 0, DT_REAL, _state);
    ae_matrix_init(&yt0, 0, 0, DT_REAL, _state);

    
    /*
     * Accuracy
     */
    eps = 1000*ae_machineepsilon;
    
    /*
     * Size of the matrix (m*n)
     */
    n = 32;
    m = 32;
    kmax = 32;
    
    /*
     * Left and right borders, limiting matrix values
     */
    lb = (double)(-10);
    rb = (double)(10);
    
    /*
     * Test linear algebra functions for:
     * a) sparse matrix converted to CRS from Hash-Table
     * b) sparse matrix initially created as CRS
     */
    for(i=1; i<=m-1; i++)
    {
        for(j=1; j<=n-1; j++)
        {
            
            /*
             * Prepare test problem
             */
            testsparseunit_createrandom(i, j, -1, -1, -1, -1, &a, &s, _state);
            ae_matrix_set_length(&x0, j, kmax, _state);
            ae_matrix_set_length(&x1, i, kmax, _state);
            for(i1=0; i1<=j-1; i1++)
            {
                for(j1=0; j1<=kmax-1; j1++)
                {
                    x0.ptr.pp_double[i1][j1] = (rb-lb)*ae_randomreal(_state)+lb;
                }
            }
            for(i1=0; i1<=i-1; i1++)
            {
                for(j1=0; j1<=kmax-1; j1++)
                {
                    x1.ptr.pp_double[i1][j1] = (rb-lb)*ae_randomreal(_state)+lb;
                }
            }
            ae_matrix_set_length(&ty, i, kmax, _state);
            ae_matrix_set_length(&tyt, j, kmax, _state);
            for(i1=0; i1<=i-1; i1++)
            {
                for(j1=0; j1<=kmax-1; j1++)
                {
                    ty.ptr.pp_double[i1][j1] = (double)(0);
                }
            }
            for(i1=0; i1<=j-1; i1++)
            {
                for(j1=0; j1<=kmax-1; j1++)
                {
                    tyt.ptr.pp_double[i1][j1] = (double)(0);
                }
            }
            if( i!=j )
            {
                for(i1=0; i1<=i-1; i1++)
                {
                    for(k1=0; k1<=kmax-1; k1++)
                    {
                        for(j1=0; j1<=j-1; j1++)
                        {
                            ty.ptr.pp_double[i1][k1] = ty.ptr.pp_double[i1][k1]+a.ptr.pp_double[i1][j1]*x0.ptr.pp_double[j1][k1];
                            tyt.ptr.pp_double[j1][k1] = tyt.ptr.pp_double[j1][k1]+a.ptr.pp_double[i1][j1]*x1.ptr.pp_double[i1][k1];
                        }
                    }
                }
            }
            else
            {
                for(i1=0; i1<=i-1; i1++)
                {
                    for(k1=0; k1<=kmax-1; k1++)
                    {
                        for(j1=0; j1<=j-1; j1++)
                        {
                            ty.ptr.pp_double[i1][k1] = ty.ptr.pp_double[i1][k1]+a.ptr.pp_double[i1][j1]*x0.ptr.pp_double[j1][k1];
                            tyt.ptr.pp_double[j1][k1] = tyt.ptr.pp_double[j1][k1]+a.ptr.pp_double[i1][j1]*x0.ptr.pp_double[i1][k1];
                        }
                    }
                }
            }
            for(k=1; k<=kmax; k++)
            {
                
                /*
                 * Consider two cases: square matrix, and non-square matrix
                 */
                if( i!=j )
                {
                    
                    /*
                     * Multiplication
                     */
                    sparsemm(&s, &x0, k, &y, _state);
                    sparsemtm(&s, &x1, k, &yt, _state);
                    
                    /*
                     * Check for MM-result
                     */
                    for(i1=0; i1<=i-1; i1++)
                    {
                        for(j1=0; j1<=k-1; j1++)
                        {
                            if( ae_fp_greater_eq(ae_fabs(y.ptr.pp_double[i1][j1]-ty.ptr.pp_double[i1][j1], _state),eps) )
                            {
                                result = ae_true;
                                ae_frame_leave(_state);
                                return result;
                            }
                        }
                    }
                    
                    /*
                     * Check for MTM-result
                     */
                    for(i1=0; i1<=j-1; i1++)
                    {
                        for(j1=0; j1<=k-1; j1++)
                        {
                            if( ae_fp_greater_eq(ae_fabs(yt.ptr.pp_double[i1][j1]-tyt.ptr.pp_double[i1][j1], _state),eps) )
                            {
                                result = ae_true;
                                ae_frame_leave(_state);
                                return result;
                            }
                        }
                    }
                }
                else
                {
                    sparsemm(&s, &x0, k, &y, _state);
                    sparsemtm(&s, &x0, k, &yt, _state);
                    sparsemm2(&s, &x0, k, &y0, &yt0, _state);
                    
                    /*
                     * Check for MM2-result
                     */
                    for(i1=0; i1<=i-1; i1++)
                    {
                        for(j1=0; j1<=k-1; j1++)
                        {
                            if( ae_fp_greater_eq(ae_fabs(y0.ptr.pp_double[i1][j1]-ty.ptr.pp_double[i1][j1], _state),eps)||ae_fp_greater_eq(ae_fabs(yt0.ptr.pp_double[i1][j1]-tyt.ptr.pp_double[i1][j1], _state),eps) )
                            {
                                result = ae_true;
                                ae_frame_leave(_state);
                                return result;
                            }
                        }
                    }
                    
                    /*
                     * Check for MV- and MTM-result by help MV2
                     */
                    for(i1=0; i1<=i-1; i1++)
                    {
                        for(j1=0; j1<=k-1; j1++)
                        {
                            if( ae_fp_greater(ae_fabs(y0.ptr.pp_double[i1][j1]-y.ptr.pp_double[i1][j1], _state),eps)||ae_fp_greater(ae_fabs(yt0.ptr.pp_double[i1][j1]-yt.ptr.pp_double[i1][j1], _state),eps) )
                            {
                                result = ae_true;
                                ae_frame_leave(_state);
                                return result;
                            }
                        }
                    }
                }
            }
        }
    }
    result = ae_false;
    ae_frame_leave(_state);
    return result;
}


/*************************************************************************
Function for testing multyplication for simmetric sparse matrix with narrow
dense matrix

  -- ALGLIB PROJECT --
     Copyright 14.10.2011 by Bochkanov Sergey
*************************************************************************/
ae_bool linearfunctionssmmtest(ae_state *_state)
{
    ae_frame _frame_block;
    sparsematrix s;
    ae_int_t m;
    ae_int_t k;
    ae_int_t i;
    ae_int_t j;
    ae_int_t i1;
    ae_int_t j1;
    ae_int_t k1;
    double lb;
    double rb;
    ae_matrix a;
    ae_matrix x0;
    ae_matrix x1;
    ae_matrix ty;
    ae_matrix tyt;
    ae_matrix y;
    ae_matrix yt;
    double eps;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    _sparsematrix_init(&s, _state);
    ae_matrix_init(&a, 0, 0, DT_REAL, _state);
    ae_matrix_init(&x0, 0, 0, DT_REAL, _state);
    ae_matrix_init(&x1, 0, 0, DT_REAL, _state);
    ae_matrix_init(&ty, 0, 0, DT_REAL, _state);
    ae_matrix_init(&tyt, 0, 0, DT_REAL, _state);
    ae_matrix_init(&y, 0, 0, DT_REAL, _state);
    ae_matrix_init(&yt, 0, 0, DT_REAL, _state);

    
    /*
     * Accuracy
     */
    eps = 1000*ae_machineepsilon;
    
    /*
     * Size of the matrix (m*m)
     */
    m = 32;
    k = 32;
    
    /*
     * Left and right borders, limiting matrix values
     */
    lb = (double)(-10);
    rb = (double)(10);
    
    /*
     * Test linear algebra functions for:
     * a) sparse matrix converted to CRS from Hash-Table
     * b) sparse matrix initially created as CRS
     */
    for(i=1; i<=m-1; i++)
    {
        for(j=1; j<=k-1; j++)
        {
            
            /*
             * Prepare test problem
             */
            testsparseunit_createrandom(i, i, -1, -1, -1, -1, &a, &s, _state);
            
            /*
             * Initialize temporaries
             */
            ae_matrix_set_length(&ty, i, j, _state);
            ae_matrix_set_length(&tyt, i, j, _state);
            ae_matrix_set_length(&x0, i, j, _state);
            ae_matrix_set_length(&x1, i, j, _state);
            for(i1=0; i1<=i-1; i1++)
            {
                for(j1=0; j1<=j-1; j1++)
                {
                    ty.ptr.pp_double[i1][j1] = (double)(0);
                    tyt.ptr.pp_double[i1][j1] = (double)(0);
                    x0.ptr.pp_double[i1][j1] = (rb-lb)*ae_randomreal(_state)+lb;
                    x1.ptr.pp_double[i1][j1] = (rb-lb)*ae_randomreal(_state)+lb;
                }
            }
            
            /*
             * Searching true result for upper and lower triangles
             * of the matrix
             */
            for(k1=0; k1<=j-1; k1++)
            {
                for(i1=0; i1<=i-1; i1++)
                {
                    for(j1=i1; j1<=i-1; j1++)
                    {
                        ty.ptr.pp_double[i1][k1] = ty.ptr.pp_double[i1][k1]+a.ptr.pp_double[i1][j1]*x0.ptr.pp_double[j1][k1];
                        if( i1!=j1 )
                        {
                            ty.ptr.pp_double[j1][k1] = ty.ptr.pp_double[j1][k1]+a.ptr.pp_double[i1][j1]*x0.ptr.pp_double[i1][k1];
                        }
                    }
                }
            }
            for(k1=0; k1<=j-1; k1++)
            {
                for(i1=0; i1<=i-1; i1++)
                {
                    for(j1=0; j1<=i1; j1++)
                    {
                        tyt.ptr.pp_double[i1][k1] = tyt.ptr.pp_double[i1][k1]+a.ptr.pp_double[i1][j1]*x1.ptr.pp_double[j1][k1];
                        if( i1!=j1 )
                        {
                            tyt.ptr.pp_double[j1][k1] = tyt.ptr.pp_double[j1][k1]+a.ptr.pp_double[i1][j1]*x1.ptr.pp_double[i1][k1];
                        }
                    }
                }
            }
            
            /*
             * Multiplication
             */
            sparsesmm(&s, ae_true, &x0, j, &y, _state);
            sparsesmm(&s, ae_false, &x1, j, &yt, _state);
            
            /*
             * Check for SMM-result
             */
            for(k1=0; k1<=j-1; k1++)
            {
                for(i1=0; i1<=i-1; i1++)
                {
                    if( ae_fp_greater_eq(ae_fabs(y.ptr.pp_double[i1][k1]-ty.ptr.pp_double[i1][k1], _state),eps)||ae_fp_greater_eq(ae_fabs(yt.ptr.pp_double[i1][k1]-tyt.ptr.pp_double[i1][k1], _state),eps) )
                    {
                        result = ae_true;
                        ae_frame_leave(_state);
                        return result;
                    }
                }
            }
        }
    }
    result = ae_false;
    ae_frame_leave(_state);
    return result;
}


/*************************************************************************
Function for basic test SparseCopy

  -- ALGLIB PROJECT --
     Copyright 14.10.2011 by Bochkanov Sergey
*************************************************************************/
ae_bool basiccopyfunctest(ae_bool silent, ae_state *_state)
{
    ae_frame _frame_block;
    sparsematrix s;
    sparsematrix ss;
    sparsematrix sss;
    ae_int_t n;
    ae_int_t m;
    ae_vector ner;
    ae_int_t i;
    ae_int_t j;
    ae_int_t i1;
    ae_int_t j1;
    ae_matrix a;
    double a0;
    double a1;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    _sparsematrix_init(&s, _state);
    _sparsematrix_init(&ss, _state);
    _sparsematrix_init(&sss, _state);
    ae_vector_init(&ner, 0, DT_INT, _state);
    ae_matrix_init(&a, 0, 0, DT_REAL, _state);

    n = 30;
    m = 30;
    for(i=1; i<=m-1; i++)
    {
        for(j=1; j<=n-1; j++)
        {
            sparsecreate(i, j, 1, &s, _state);
            ae_matrix_set_length(&a, i, j, _state);
            ae_vector_set_length(&ner, i, _state);
            for(i1=0; i1<=i-1; i1++)
            {
                if( i1<=j-3 )
                {
                    ner.ptr.p_int[i1] = 2;
                }
                else
                {
                    if( j-3<i1&&i1<=j-2 )
                    {
                        ner.ptr.p_int[i1] = 1;
                    }
                    else
                    {
                        ner.ptr.p_int[i1] = 0;
                    }
                }
            }
            sparsecreatecrs(i, j, &ner, &sss, _state);
            
            /*
             * Checking for Matrix with hash table type
             */
            for(i1=0; i1<=i-1; i1++)
            {
                for(j1=0; j1<=j-1; j1++)
                {
                    if( j1>i1&&j1<=i1+2 )
                    {
                        a.ptr.pp_double[i1][j1] = (double)(i1+j1+1);
                        sparseset(&s, i1, j1, a.ptr.pp_double[i1][j1], _state);
                        sparseadd(&s, i1, j1, (double)(0), _state);
                        sparseset(&sss, i1, j1, a.ptr.pp_double[i1][j1], _state);
                    }
                    else
                    {
                        a.ptr.pp_double[i1][j1] = (double)(0);
                        sparseset(&s, i1, j1, a.ptr.pp_double[i1][j1], _state);
                        sparseadd(&s, i1, j1, (double)(0), _state);
                    }
                    
                    /*
                     * Check for SparseCreate
                     */
                    sparsecopy(&s, &ss, _state);
                    a0 = sparseget(&s, i1, j1, _state);
                    a1 = sparseget(&ss, i1, j1, _state);
                    if( ae_fp_neq(a0,a1) )
                    {
                        if( !silent )
                        {
                            printf("BasicCopyFuncTest::Report::SparseGet\n");
                            printf("S::[%0d,%0d]=%0.5f\n",
                                (int)(i1),
                                (int)(j1),
                                (double)(a0));
                            printf("SS::[%0d,%0d]=%0.5f\n",
                                (int)(i1),
                                (int)(j1),
                                (double)(a1));
                            printf("          TEST FAILED.\n");
                        }
                        result = ae_true;
                        ae_frame_leave(_state);
                        return result;
                    }
                }
            }
            
            /*
             * Check for SparseCreateCRS
             */
            for(i1=0; i1<=i-1; i1++)
            {
                for(j1=0; j1<=j-1; j1++)
                {
                    sparsecopy(&sss, &ss, _state);
                    a0 = sparseget(&sss, i1, j1, _state);
                    a1 = sparseget(&ss, i1, j1, _state);
                    if( ae_fp_neq(a0,a1) )
                    {
                        if( !silent )
                        {
                            printf("BasicCopyFuncTest::Report::SparseGet\n");
                            printf("S::[%0d,%0d]=%0.5f\n",
                                (int)(i1),
                                (int)(j1),
                                (double)(a0));
                            printf("SS::[%0d,%0d]=%0.5f\n",
                                (int)(i1),
                                (int)(j1),
                                (double)(a1));
                            printf("          TEST FAILED.\n");
                        }
                        result = ae_true;
                        ae_frame_leave(_state);
                        return result;
                    }
                }
            }
            
            /*
             * Check for Matrix with CRS type
             */
            sparseconverttocrs(&s, _state);
            sparsecopy(&s, &ss, _state);
            for(i1=0; i1<=i-1; i1++)
            {
                for(j1=0; j1<=j-1; j1++)
                {
                    a0 = sparseget(&s, i1, j1, _state);
                    a1 = sparseget(&ss, i1, j1, _state);
                    if( ae_fp_neq(a0,a1) )
                    {
                        if( !silent )
                        {
                            printf("BasicCopyFuncTest::Report::SparseGet\n");
                            printf("S::[%0d,%0d]=%0.5f\n",
                                (int)(i1),
                                (int)(j1),
                                (double)(a0));
                            printf("SS::[%0d,%0d]=%0.5f\n",
                                (int)(i1),
                                (int)(j1),
                                (double)(a1));
                            printf("          TEST FAILED.\n");
                        }
                        result = ae_true;
                        ae_frame_leave(_state);
                        return result;
                    }
                }
            }
        }
    }
    if( !silent )
    {
        printf("          TEST IS PASSED.\n");
    }
    result = ae_false;
    ae_frame_leave(_state);
    return result;
}


/*************************************************************************
Function for testing SparseCopy

  -- ALGLIB PROJECT --
     Copyright 14.10.2011 by Bochkanov Sergey
*************************************************************************/
ae_bool copyfunctest(ae_bool silent, ae_state *_state)
{
    ae_frame _frame_block;
    sparsematrix s;
    sparsematrix ss;
    ae_int_t n;
    ae_int_t m;
    ae_int_t mtype;
    ae_int_t i;
    ae_int_t j;
    ae_int_t i1;
    ae_int_t j1;
    double lb;
    double rb;
    ae_matrix a;
    ae_vector x0;
    ae_vector x1;
    ae_vector ty;
    ae_vector tyt;
    ae_vector y;
    ae_vector yt;
    ae_vector y0;
    ae_vector yt0;
    ae_vector cpy;
    ae_vector cpyt;
    ae_vector cpy0;
    ae_vector cpyt0;
    double eps;
    double a0;
    double a1;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    _sparsematrix_init(&s, _state);
    _sparsematrix_init(&ss, _state);
    ae_matrix_init(&a, 0, 0, DT_REAL, _state);
    ae_vector_init(&x0, 0, DT_REAL, _state);
    ae_vector_init(&x1, 0, DT_REAL, _state);
    ae_vector_init(&ty, 0, DT_REAL, _state);
    ae_vector_init(&tyt, 0, DT_REAL, _state);
    ae_vector_init(&y, 0, DT_REAL, _state);
    ae_vector_init(&yt, 0, DT_REAL, _state);
    ae_vector_init(&y0, 0, DT_REAL, _state);
    ae_vector_init(&yt0, 0, DT_REAL, _state);
    ae_vector_init(&cpy, 0, DT_REAL, _state);
    ae_vector_init(&cpyt, 0, DT_REAL, _state);
    ae_vector_init(&cpy0, 0, DT_REAL, _state);
    ae_vector_init(&cpyt0, 0, DT_REAL, _state);

    
    /*
     * Accuracy
     */
    eps = 1000*ae_machineepsilon;
    
    /*
     * Size of the matrix (m*n)
     */
    n = 30;
    m = 30;
    
    /*
     * Left and right borders, limiting matrix values
     */
    lb = (double)(-10);
    rb = (double)(10);
    
    /*
     * Test linear algebra functions for:
     * a) sparse matrix converted to CRS from Hash-Table
     * b) sparse matrix initially created as CRS
     */
    for(i=1; i<=m-1; i++)
    {
        for(j=1; j<=n-1; j++)
        {
            for(mtype=0; mtype<=1; mtype++)
            {
                
                /*
                 * Prepare test problem
                 */
                testsparseunit_createrandom(i, j, -1, mtype, -1, -1, &a, &s, _state);
                sparsecopy(&s, &ss, _state);
                
                /*
                 * Initialize temporaries
                 */
                ae_vector_set_length(&ty, i, _state);
                ae_vector_set_length(&tyt, j, _state);
                for(i1=0; i1<=i-1; i1++)
                {
                    ty.ptr.p_double[i1] = (double)(0);
                }
                for(i1=0; i1<=j-1; i1++)
                {
                    tyt.ptr.p_double[i1] = (double)(0);
                }
                ae_vector_set_length(&x0, j, _state);
                ae_vector_set_length(&x1, i, _state);
                for(i1=0; i1<=j-1; i1++)
                {
                    x0.ptr.p_double[i1] = (rb-lb)*ae_randomreal(_state)+lb;
                }
                for(i1=0; i1<=i-1; i1++)
                {
                    x1.ptr.p_double[i1] = (rb-lb)*ae_randomreal(_state)+lb;
                }
                
                /*
                 * Consider two cases: square matrix, and non-square matrix
                 */
                if( i!=j )
                {
                    
                    /*
                     * Searching true result
                     */
                    for(i1=0; i1<=i-1; i1++)
                    {
                        for(j1=0; j1<=j-1; j1++)
                        {
                            ty.ptr.p_double[i1] = ty.ptr.p_double[i1]+a.ptr.pp_double[i1][j1]*x0.ptr.p_double[j1];
                            tyt.ptr.p_double[j1] = tyt.ptr.p_double[j1]+a.ptr.pp_double[i1][j1]*x1.ptr.p_double[i1];
                        }
                    }
                    
                    /*
                     * Multiplication
                     */
                    sparsemv(&s, &x0, &y, _state);
                    sparsemtv(&s, &x1, &yt, _state);
                    sparsemv(&ss, &x0, &cpy, _state);
                    sparsemtv(&ss, &x1, &cpyt, _state);
                    
                    /*
                     * Check for MV-result
                     */
                    for(i1=0; i1<=i-1; i1++)
                    {
                        if( (ae_fp_greater_eq(ae_fabs(y.ptr.p_double[i1]-ty.ptr.p_double[i1], _state),eps)||ae_fp_greater_eq(ae_fabs(cpy.ptr.p_double[i1]-ty.ptr.p_double[i1], _state),eps))||ae_fp_neq(cpy.ptr.p_double[i1]-y.ptr.p_double[i1],(double)(0)) )
                        {
                            if( !silent )
                            {
                                printf("CopyFuncTest::Report::RES_MV\n");
                                printf("Y[%0d]=%0.5f; tY[%0d]=%0.5f\n",
                                    (int)(i1),
                                    (double)(y.ptr.p_double[i1]),
                                    (int)(i1),
                                    (double)(ty.ptr.p_double[i1]));
                                printf("cpY[%0d]=%0.5f;\n",
                                    (int)(i1),
                                    (double)(cpy.ptr.p_double[i1]));
                                printf("          TEST FAILED.\n");
                            }
                            result = ae_true;
                            ae_frame_leave(_state);
                            return result;
                        }
                    }
                    
                    /*
                     * Check for MTV-result
                     */
                    for(i1=0; i1<=j-1; i1++)
                    {
                        if( (ae_fp_greater_eq(ae_fabs(yt.ptr.p_double[i1]-tyt.ptr.p_double[i1], _state),eps)||ae_fp_greater_eq(ae_fabs(cpyt.ptr.p_double[i1]-tyt.ptr.p_double[i1], _state),eps))||ae_fp_neq(cpyt.ptr.p_double[i1]-yt.ptr.p_double[i1],(double)(0)) )
                        {
                            if( !silent )
                            {
                                printf("CopyFuncTest::Report::RES_MTV\n");
                                printf("Yt[%0d]=%0.5f; tYt[%0d]=%0.5f\n",
                                    (int)(i1),
                                    (double)(yt.ptr.p_double[i1]),
                                    (int)(i1),
                                    (double)(tyt.ptr.p_double[i1]));
                                printf("cpYt[%0d]=%0.5f;\n",
                                    (int)(i1),
                                    (double)(cpyt.ptr.p_double[i1]));
                                printf("          TEST FAILED.\n");
                            }
                            result = ae_true;
                            ae_frame_leave(_state);
                            return result;
                        }
                    }
                    sparsecopy(&s, &ss, _state);
                    for(i1=0; i1<=i-1; i1++)
                    {
                        for(j1=0; j1<=j-1; j1++)
                        {
                            a0 = sparseget(&s, i1, j1, _state);
                            a1 = sparseget(&ss, i1, j1, _state);
                            if( ae_fp_neq(a0,a1) )
                            {
                                if( !silent )
                                {
                                    printf("CopyFuncTest::Report::SparseGet\n");
                                    printf("S::[%0d,%0d]=%0.5f\n",
                                        (int)(i1),
                                        (int)(j1),
                                        (double)(a0));
                                    printf("SS::[%0d,%0d]=%0.5f\n",
                                        (int)(i1),
                                        (int)(j1),
                                        (double)(a1));
                                    printf("          TEST FAILED.\n");
                                }
                                result = ae_true;
                                ae_frame_leave(_state);
                                return result;
                            }
                        }
                    }
                }
                else
                {
                    
                    /*
                     * Searching true result
                     */
                    for(i1=0; i1<=i-1; i1++)
                    {
                        for(j1=0; j1<=j-1; j1++)
                        {
                            ty.ptr.p_double[i1] = ty.ptr.p_double[i1]+a.ptr.pp_double[i1][j1]*x0.ptr.p_double[j1];
                            tyt.ptr.p_double[j1] = tyt.ptr.p_double[j1]+a.ptr.pp_double[i1][j1]*x0.ptr.p_double[i1];
                        }
                    }
                    
                    /*
                     * Multiplication
                     */
                    sparsemv(&s, &x0, &y, _state);
                    sparsemtv(&s, &x0, &yt, _state);
                    sparsemv2(&s, &x0, &y0, &yt0, _state);
                    sparsemv(&ss, &x0, &cpy, _state);
                    sparsemtv(&ss, &x0, &cpyt, _state);
                    sparsemv2(&ss, &x0, &cpy0, &cpyt0, _state);
                    
                    /*
                     * Check for MV2-result
                     */
                    for(i1=0; i1<=i-1; i1++)
                    {
                        if( ((((ae_fp_greater_eq(ae_fabs(y0.ptr.p_double[i1]-ty.ptr.p_double[i1], _state),eps)||ae_fp_greater_eq(ae_fabs(yt0.ptr.p_double[i1]-tyt.ptr.p_double[i1], _state),eps))||ae_fp_greater_eq(ae_fabs(cpy0.ptr.p_double[i1]-ty.ptr.p_double[i1], _state),eps))||ae_fp_greater_eq(ae_fabs(cpyt0.ptr.p_double[i1]-tyt.ptr.p_double[i1], _state),eps))||ae_fp_neq(cpy0.ptr.p_double[i1]-y0.ptr.p_double[i1],(double)(0)))||ae_fp_neq(cpyt0.ptr.p_double[i1]-yt0.ptr.p_double[i1],(double)(0)) )
                        {
                            if( !silent )
                            {
                                printf("CopyFuncTest::Report::RES_MV2\n");
                                printf("Y0[%0d]=%0.5f; tY[%0d]=%0.5f\n",
                                    (int)(i1),
                                    (double)(y0.ptr.p_double[i1]),
                                    (int)(i1),
                                    (double)(ty.ptr.p_double[i1]));
                                printf("Yt0[%0d]=%0.5f; tYt[%0d]=%0.5f\n",
                                    (int)(i1),
                                    (double)(yt0.ptr.p_double[i1]),
                                    (int)(i1),
                                    (double)(tyt.ptr.p_double[i1]));
                                printf("cpY0[%0d]=%0.5f;\n",
                                    (int)(i1),
                                    (double)(cpy0.ptr.p_double[i1]));
                                printf("cpYt0[%0d]=%0.5f;\n",
                                    (int)(i1),
                                    (double)(cpyt0.ptr.p_double[i1]));
                                printf("          TEST FAILED.\n");
                            }
                            result = ae_true;
                            ae_frame_leave(_state);
                            return result;
                        }
                    }
                    
                    /*
                     * Check for MV- and MTV-result by help MV2
                     */
                    for(i1=0; i1<=i-1; i1++)
                    {
                        if( ((ae_fp_greater(ae_fabs(y0.ptr.p_double[i1]-y.ptr.p_double[i1], _state),eps)||ae_fp_greater(ae_fabs(yt0.ptr.p_double[i1]-yt.ptr.p_double[i1], _state),eps))||ae_fp_greater(ae_fabs(cpy0.ptr.p_double[i1]-cpy.ptr.p_double[i1], _state),eps))||ae_fp_greater(ae_fabs(cpyt0.ptr.p_double[i1]-cpyt.ptr.p_double[i1], _state),eps) )
                        {
                            if( !silent )
                            {
                                printf("CopyFuncTest::Report::RES_MV_MVT\n");
                                printf("Y0[%0d]=%0.5f; Y[%0d]=%0.5f\n",
                                    (int)(i1),
                                    (double)(y0.ptr.p_double[i1]),
                                    (int)(i1),
                                    (double)(y.ptr.p_double[i1]));
                                printf("Yt0[%0d]=%0.5f; Yt[%0d]=%0.5f\n",
                                    (int)(i1),
                                    (double)(yt0.ptr.p_double[i1]),
                                    (int)(i1),
                                    (double)(yt.ptr.p_double[i1]));
                                printf("cpY0[%0d]=%0.5f; cpY[%0d]=%0.5f\n",
                                    (int)(i1),
                                    (double)(cpy0.ptr.p_double[i1]),
                                    (int)(i1),
                                    (double)(cpy.ptr.p_double[i1]));
                                printf("cpYt0[%0d]=%0.5f; cpYt[%0d]=%0.5f\n",
                                    (int)(i1),
                                    (double)(cpyt0.ptr.p_double[i1]),
                                    (int)(i1),
                                    (double)(cpyt.ptr.p_double[i1]));
                                printf("          TEST FAILED.\n");
                            }
                            result = ae_true;
                            ae_frame_leave(_state);
                            return result;
                        }
                    }
                    sparsecopy(&s, &ss, _state);
                    for(i1=0; i1<=i-1; i1++)
                    {
                        for(j1=0; j1<=j-1; j1++)
                        {
                            a0 = sparseget(&s, i1, j1, _state);
                            a1 = sparseget(&ss, i1, j1, _state);
                            if( ae_fp_neq(a0,a1) )
                            {
                                if( !silent )
                                {
                                    printf("CopyFuncTest::Report::SparseGet\n");
                                    printf("S::[%0d,%0d]=%0.5f\n",
                                        (int)(i1),
                                        (int)(j1),
                                        (double)(a0));
                                    printf("SS::[%0d,%0d]=%0.5f\n",
                                        (int)(i1),
                                        (int)(j1),
                                        (double)(a1));
                                    printf("          TEST FAILED.\n");
                                }
                                result = ae_true;
                                ae_frame_leave(_state);
                                return result;
                            }
                        }
                    }
                }
            }
        }
    }
    if( !silent )
    {
        printf("          TEST IS PASSED.\n");
    }
    result = ae_false;
    ae_frame_leave(_state);
    return result;
}


/*************************************************************************
This function initializes sparse matrix generator, which is used to generate
a set of matrices with sequentially increasing sparsity.

PARAMETERS:
    M, N        -   matrix size. If M=0, then matrix is square N*N.
                    N and M must be small enough to store N*M dense matrix.
    MatKind     -   matrix properties:
                    * 0     -   general sparse (no structure)
                    * 1     -   general sparse, but diagonal is always present and non-zero
                    * 2     -   diagonally dominant, SPD
    Triangle    -   triangle being returned:
                    * +1    -   upper triangle
                    * -1    -   lower triangle
                    *  0    -   full matrix is returned
                    
OUTPUT PARAMETERS:
    G           -   generator
    A           -   matrix A in dense format
    SA          -   matrix A in sparse format (hash-table storage)
*************************************************************************/
static void testsparseunit_initgenerator(ae_int_t m,
     ae_int_t n,
     ae_int_t matkind,
     ae_int_t triangle,
     sparsegenerator* g,
     ae_state *_state)
{

    _sparsegenerator_clear(g);

    g->n = n;
    g->m = m;
    g->matkind = matkind;
    g->triangle = triangle;
    hqrndrandomize(&g->rs, _state);
    ae_vector_set_length(&g->rcs.ia, 5+1, _state);
    ae_vector_set_length(&g->rcs.ra, 1+1, _state);
    g->rcs.stage = -1;
}


static ae_bool testsparseunit_generatenext(sparsegenerator* g,
     /* Real    */ ae_matrix* da,
     sparsematrix* sa,
     ae_state *_state)
{
    ae_int_t n;
    ae_int_t m;
    ae_int_t nz;
    ae_int_t nzd;
    double pnz;
    ae_int_t i;
    ae_int_t j;
    double v;
    ae_bool result;

    ae_matrix_clear(da);
    _sparsematrix_clear(sa);

    
    /*
     * Reverse communication preparations
     * I know it looks ugly, but it works the same way
     * anywhere from C++ to Python.
     *
     * This code initializes locals by:
     * * random values determined during code
     *   generation - on first subroutine call
     * * values from previous call - on subsequent calls
     */
    if( g->rcs.stage>=0 )
    {
        n = g->rcs.ia.ptr.p_int[0];
        m = g->rcs.ia.ptr.p_int[1];
        nz = g->rcs.ia.ptr.p_int[2];
        nzd = g->rcs.ia.ptr.p_int[3];
        i = g->rcs.ia.ptr.p_int[4];
        j = g->rcs.ia.ptr.p_int[5];
        pnz = g->rcs.ra.ptr.p_double[0];
        v = g->rcs.ra.ptr.p_double[1];
    }
    else
    {
        n = -983;
        m = -989;
        nz = -834;
        nzd = 900;
        i = -287;
        j = 364;
        pnz = 214;
        v = -338;
    }
    if( g->rcs.stage==0 )
    {
        goto lbl_0;
    }
    if( g->rcs.stage==1 )
    {
        goto lbl_1;
    }
    
    /*
     * Routine body
     */
    n = g->n;
    if( g->m==0 )
    {
        m = n;
    }
    else
    {
        m = g->m;
    }
    ae_assert(m>0&&n>0, "GenerateNext: incorrect N/M", _state);
    
    /*
     * Generate general sparse matrix
     */
    if( g->matkind!=0 )
    {
        goto lbl_2;
    }
    nz = n*m;
lbl_4:
    if( ae_false )
    {
        goto lbl_5;
    }
    
    /*
     * Generate dense N*N matrix where probability of element
     * being non-zero is PNZ.
     */
    pnz = (double)nz/(double)(n*m);
    ae_matrix_set_length(&g->bufa, m, n, _state);
    for(i=0; i<=m-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            if( ae_fp_less_eq(hqrnduniformr(&g->rs, _state),pnz) )
            {
                g->bufa.ptr.pp_double[i][j] = hqrnduniformr(&g->rs, _state)-0.5;
            }
            else
            {
                g->bufa.ptr.pp_double[i][j] = 0.0;
            }
        }
    }
    
    /*
     * Output matrix and RComm
     */
    ae_matrix_set_length(da, m, n, _state);
    sparsecreate(m, n, ae_round(pnz*m*n, _state), sa, _state);
    for(i=0; i<=m-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            if( (j<=i&&g->triangle<=0)||(j>=i&&g->triangle>=0) )
            {
                da->ptr.pp_double[i][j] = g->bufa.ptr.pp_double[i][j];
                sparseset(sa, i, j, g->bufa.ptr.pp_double[i][j], _state);
            }
            else
            {
                da->ptr.pp_double[i][j] = 0.0;
            }
        }
    }
    g->rcs.stage = 0;
    goto lbl_rcomm;
lbl_0:
    
    /*
     * Increase problem sparcity and try one more time. 
     * Stop after testing NZ=0.
     */
    if( nz==0 )
    {
        goto lbl_5;
    }
    nz = nz/2;
    goto lbl_4;
lbl_5:
    result = ae_false;
    return result;
lbl_2:
    
    /*
     * Generate general sparse matrix with non-zero diagonal
     */
    if( g->matkind!=1 )
    {
        goto lbl_6;
    }
    ae_assert(n==m, "GenerateNext: non-square matrix for MatKind=1", _state);
    nz = n*n-n;
lbl_8:
    if( ae_false )
    {
        goto lbl_9;
    }
    
    /*
     * Generate dense N*N matrix where probability of non-diagonal element
     * being non-zero is PNZ.
     */
    if( n>1 )
    {
        pnz = (double)nz/(double)(n*n-n);
    }
    else
    {
        pnz = (double)(1);
    }
    ae_matrix_set_length(&g->bufa, n, n, _state);
    for(i=0; i<=n-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            if( i==j )
            {
                do
                {
                    g->bufa.ptr.pp_double[i][i] = hqrnduniformr(&g->rs, _state)-0.5;
                }
                while(ae_fp_eq(g->bufa.ptr.pp_double[i][i],(double)(0)));
                g->bufa.ptr.pp_double[i][i] = g->bufa.ptr.pp_double[i][i]+1.5*ae_sign(g->bufa.ptr.pp_double[i][i], _state);
                continue;
            }
            if( ae_fp_less_eq(hqrnduniformr(&g->rs, _state),pnz) )
            {
                g->bufa.ptr.pp_double[i][j] = hqrnduniformr(&g->rs, _state)-0.5;
            }
            else
            {
                g->bufa.ptr.pp_double[i][j] = 0.0;
            }
        }
    }
    
    /*
     * Output matrix and RComm
     */
    ae_matrix_set_length(da, n, n, _state);
    sparsecreate(n, n, ae_round(pnz*(n*n-n)+n, _state), sa, _state);
    for(i=0; i<=n-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            if( (j<=i&&g->triangle<=0)||(j>=i&&g->triangle>=0) )
            {
                da->ptr.pp_double[i][j] = g->bufa.ptr.pp_double[i][j];
                sparseset(sa, i, j, g->bufa.ptr.pp_double[i][j], _state);
            }
            else
            {
                da->ptr.pp_double[i][j] = 0.0;
            }
        }
    }
    g->rcs.stage = 1;
    goto lbl_rcomm;
lbl_1:
    
    /*
     * Increase problem sparcity and try one more time. 
     * Stop after testing NZ=0.
     */
    if( nz==0 )
    {
        goto lbl_9;
    }
    nz = nz/2;
    goto lbl_8;
lbl_9:
    result = ae_false;
    return result;
lbl_6:
    ae_assert(ae_false, "Assertion failed", _state);
    result = ae_false;
    return result;
    
    /*
     * Saving state
     */
lbl_rcomm:
    result = ae_true;
    g->rcs.ia.ptr.p_int[0] = n;
    g->rcs.ia.ptr.p_int[1] = m;
    g->rcs.ia.ptr.p_int[2] = nz;
    g->rcs.ia.ptr.p_int[3] = nzd;
    g->rcs.ia.ptr.p_int[4] = i;
    g->rcs.ia.ptr.p_int[5] = j;
    g->rcs.ra.ptr.p_double[0] = pnz;
    g->rcs.ra.ptr.p_double[1] = v;
    return result;
}


/*************************************************************************
This function creates random sparse matrix with some prescribed pattern.

INPUT PARAMETERS:
    M       -   number of rows
    N       -   number of columns
    PKind   -   sparsity pattern:
                *-1 = pattern is chosen at random as well as P0/P1
                * 0 = matrix with up to P0 non-zero elements at random locations
                      (however, actual number of non-zero elements can be
                      less than P0, and in fact can be zero)
                * 1 = band matrix with P0 non-zero elements below diagonal
                      and P1 non-zero element above diagonal
                * 2 = matrix with random number of contiguous non-zero 
                      elements in the each row
    CKind   -   creation type:
                *-1 = CKind is chosen at random
                * 0 = matrix is created in Hash-Table format and converted
                      to CRS representation
                * 1 = matrix is created in CRS format

OUTPUT PARAMETERS:
    DA      -   dense representation of A, array[M,N]
    SA      -   sparse representation of A, in CRS format

  -- ALGLIB PROJECT --
     Copyright 31.10.2011 by Bochkanov Sergey
*************************************************************************/
static void testsparseunit_createrandom(ae_int_t m,
     ae_int_t n,
     ae_int_t pkind,
     ae_int_t ckind,
     ae_int_t p0,
     ae_int_t p1,
     /* Real    */ ae_matrix* da,
     sparsematrix* sa,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_int_t maxpkind;
    ae_int_t maxckind;
    ae_int_t i;
    ae_int_t j;
    ae_int_t k;
    double v;
    ae_vector c0;
    ae_vector c1;
    ae_vector rowsizes;

    ae_frame_make(_state, &_frame_block);
    ae_matrix_clear(da);
    _sparsematrix_clear(sa);
    ae_vector_init(&c0, 0, DT_INT, _state);
    ae_vector_init(&c1, 0, DT_INT, _state);
    ae_vector_init(&rowsizes, 0, DT_INT, _state);

    maxpkind = 2;
    maxckind = 1;
    ae_assert(m>=1, "CreateRandom: incorrect parameters", _state);
    ae_assert(n>=1, "CreateRandom: incorrect parameters", _state);
    ae_assert(pkind>=-1&&pkind<=maxpkind, "CreateRandom: incorrect parameters", _state);
    ae_assert(ckind>=-1&&ckind<=maxckind, "CreateRandom: incorrect parameters", _state);
    if( pkind==-1 )
    {
        pkind = ae_randominteger(maxpkind+1, _state);
        if( pkind==0 )
        {
            p0 = ae_randominteger(m*n, _state);
        }
        if( pkind==1 )
        {
            p0 = ae_randominteger(ae_minint(m, n, _state), _state);
            p1 = ae_randominteger(ae_minint(m, n, _state), _state);
        }
    }
    if( ckind==-1 )
    {
        ckind = ae_randominteger(maxckind+1, _state);
    }
    if( pkind==0 )
    {
        
        /*
         * Matrix with elements at random locations
         */
        ae_matrix_set_length(da, m, n, _state);
        for(i=0; i<=m-1; i++)
        {
            for(j=0; j<=n-1; j++)
            {
                da->ptr.pp_double[i][j] = (double)(0);
            }
        }
        if( ckind==0 )
        {
            
            /*
             * Create matrix in Hash format, convert to CRS
             */
            sparsecreate(m, n, 1, sa, _state);
            for(k=0; k<=p0-1; k++)
            {
                i = ae_randominteger(m, _state);
                j = ae_randominteger(n, _state);
                v = (double)(ae_randominteger(17, _state)-8)/(double)8;
                if( ae_fp_greater(ae_randomreal(_state),0.5) )
                {
                    da->ptr.pp_double[i][j] = v;
                    sparseset(sa, i, j, v, _state);
                }
                else
                {
                    da->ptr.pp_double[i][j] = da->ptr.pp_double[i][j]+v;
                    sparseadd(sa, i, j, v, _state);
                }
            }
            sparseconverttocrs(sa, _state);
            ae_frame_leave(_state);
            return;
        }
        if( ckind==1 )
        {
            
            /*
             * Create matrix in CRS format
             */
            for(k=0; k<=p0-1; k++)
            {
                i = ae_randominteger(m, _state);
                j = ae_randominteger(n, _state);
                v = (double)(ae_randominteger(17, _state)-8)/(double)8;
                da->ptr.pp_double[i][j] = v;
            }
            ae_vector_set_length(&rowsizes, m, _state);
            for(i=0; i<=m-1; i++)
            {
                rowsizes.ptr.p_int[i] = 0;
                for(j=0; j<=n-1; j++)
                {
                    if( ae_fp_neq(da->ptr.pp_double[i][j],(double)(0)) )
                    {
                        rowsizes.ptr.p_int[i] = rowsizes.ptr.p_int[i]+1;
                    }
                }
            }
            sparsecreatecrs(m, n, &rowsizes, sa, _state);
            for(i=0; i<=m-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    if( ae_fp_neq(da->ptr.pp_double[i][j],(double)(0)) )
                    {
                        sparseset(sa, i, j, da->ptr.pp_double[i][j], _state);
                    }
                }
            }
            ae_frame_leave(_state);
            return;
        }
        ae_assert(ae_false, "CreateRandom: internal error", _state);
    }
    if( pkind==1 )
    {
        
        /*
         * Band matrix
         */
        ae_matrix_set_length(da, m, n, _state);
        ae_vector_set_length(&rowsizes, m, _state);
        for(i=0; i<=m-1; i++)
        {
            for(j=0; j<=n-1; j++)
            {
                da->ptr.pp_double[i][j] = (double)(0);
            }
        }
        for(i=0; i<=m-1; i++)
        {
            for(j=ae_maxint(i-p0, 0, _state); j<=ae_minint(i+p1, n-1, _state); j++)
            {
                do
                {
                    da->ptr.pp_double[i][j] = (double)(ae_randominteger(17, _state)-8)/(double)8;
                }
                while(ae_fp_eq(da->ptr.pp_double[i][j],(double)(0)));
            }
            rowsizes.ptr.p_int[i] = ae_maxint(ae_minint(i+p1, n-1, _state)-ae_maxint(i-p0, 0, _state)+1, 0, _state);
        }
        if( ckind==0 )
        {
            sparsecreate(m, n, 1, sa, _state);
        }
        if( ckind==1 )
        {
            sparsecreatecrs(m, n, &rowsizes, sa, _state);
        }
        for(i=0; i<=m-1; i++)
        {
            for(j=0; j<=n-1; j++)
            {
                if( ae_fp_neq(da->ptr.pp_double[i][j],(double)(0)) )
                {
                    sparseset(sa, i, j, da->ptr.pp_double[i][j], _state);
                }
            }
        }
        sparseconverttocrs(sa, _state);
        ae_frame_leave(_state);
        return;
    }
    if( pkind==2 )
    {
        
        /*
         * Matrix with one contiguous sequence of non-zero elements per row
         */
        ae_matrix_set_length(da, m, n, _state);
        ae_vector_set_length(&rowsizes, m, _state);
        ae_vector_set_length(&c0, m, _state);
        ae_vector_set_length(&c1, m, _state);
        for(i=0; i<=m-1; i++)
        {
            for(j=0; j<=n-1; j++)
            {
                da->ptr.pp_double[i][j] = (double)(0);
            }
        }
        for(i=0; i<=m-1; i++)
        {
            c0.ptr.p_int[i] = ae_randominteger(n, _state);
            c1.ptr.p_int[i] = c0.ptr.p_int[i]+ae_randominteger(n-c0.ptr.p_int[i]+1, _state);
            rowsizes.ptr.p_int[i] = c1.ptr.p_int[i]-c0.ptr.p_int[i];
        }
        for(i=0; i<=m-1; i++)
        {
            for(j=c0.ptr.p_int[i]; j<=c1.ptr.p_int[i]-1; j++)
            {
                do
                {
                    da->ptr.pp_double[i][j] = (double)(ae_randominteger(17, _state)-8)/(double)8;
                }
                while(ae_fp_eq(da->ptr.pp_double[i][j],(double)(0)));
            }
        }
        if( ckind==0 )
        {
            sparsecreate(m, n, 1, sa, _state);
        }
        if( ckind==1 )
        {
            sparsecreatecrs(m, n, &rowsizes, sa, _state);
        }
        for(i=0; i<=m-1; i++)
        {
            for(j=0; j<=n-1; j++)
            {
                if( ae_fp_neq(da->ptr.pp_double[i][j],(double)(0)) )
                {
                    sparseset(sa, i, j, da->ptr.pp_double[i][j], _state);
                }
            }
        }
        sparseconverttocrs(sa, _state);
        ae_frame_leave(_state);
        return;
    }
    ae_frame_leave(_state);
}


/*************************************************************************
This function does test for SparseEnumerate function.

  -- ALGLIB PROJECT --
     Copyright 14.03.2012 by Bochkanov Sergey
*************************************************************************/
static ae_bool testsparseunit_enumeratetest(ae_state *_state)
{
    ae_frame _frame_block;
    sparsematrix spa;
    ae_matrix a;
    ae_matrix ta;
    ae_int_t m;
    ae_int_t n;
    double r;
    double v;
    ae_int_t ne;
    ae_int_t t0;
    ae_int_t t1;
    ae_int_t counter;
    ae_int_t c;
    ae_int_t hashcrs;
    ae_int_t i;
    ae_int_t j;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    _sparsematrix_init(&spa, _state);
    ae_matrix_init(&a, 0, 0, DT_REAL, _state);
    ae_matrix_init(&ta, 0, 0, DT_BOOL, _state);

    r = 10.5;
    for(m=1; m<=30; m++)
    {
        for(n=1; n<=30; n++)
        {
            ne = 0;
            
            /*
             * Create matrix with non-zero elements inside the region:
             * 0<=I<S.M and 0<=J<S.N
             */
            ae_matrix_set_length(&a, m, n, _state);
            ae_matrix_set_length(&ta, m, n, _state);
            for(i=0; i<=m-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    a.ptr.pp_double[i][j] = (double)(0);
                    ta.ptr.pp_bool[i][j] = ae_false;
                }
            }
            for(i=0; i<=m-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    c = ae_randominteger(2, _state);
                    if( c==0 )
                    {
                        a.ptr.pp_double[i][j] = (double)(0);
                    }
                    else
                    {
                        a.ptr.pp_double[i][j] = r*(2*ae_randomreal(_state)-1);
                        
                        /*
                         * Number of non-zero elements
                         */
                        ne = ne+1;
                    }
                }
            }
            for(hashcrs=0; hashcrs<=1; hashcrs++)
            {
                sparsecreate(m, n, m*n, &spa, _state);
                for(i=0; i<=m-1; i++)
                {
                    for(j=0; j<=n-1; j++)
                    {
                        sparseset(&spa, i, j, a.ptr.pp_double[i][j], _state);
                    }
                }
                if( hashcrs==1 )
                {
                    sparseconverttocrs(&spa, _state);
                }
                t0 = 0;
                t1 = 0;
                counter = 0;
                while(sparseenumerate(&spa, &t0, &t1, &i, &j, &v, _state))
                {
                    ta.ptr.pp_bool[i][j] = ae_true;
                    counter = counter+1;
                    if( ae_fp_neq(v,a.ptr.pp_double[i][j]) )
                    {
                        result = ae_true;
                        ae_frame_leave(_state);
                        return result;
                    }
                }
                
                /*
                 * Check that all non-zero elements was enumerated
                 */
                for(i=0; i<=m-1; i++)
                {
                    for(j=0; j<=n-1; j++)
                    {
                        if( ta.ptr.pp_bool[i][j]&&ae_fp_eq(a.ptr.pp_double[i][j],(double)(0)) )
                        {
                            result = ae_true;
                            ae_frame_leave(_state);
                            return result;
                        }
                    }
                }
                if( ne!=counter )
                {
                    result = ae_true;
                    ae_frame_leave(_state);
                    return result;
                }
            }
        }
    }
    result = ae_false;
    ae_frame_leave(_state);
    return result;
}


/*************************************************************************
This function does test for SparseRewriteExisting function.

  -- ALGLIB PROJECT --
     Copyright 14.03.2012 by Bochkanov Sergey
*************************************************************************/
static ae_bool testsparseunit_rewriteexistingtest(ae_state *_state)
{
    ae_frame _frame_block;
    sparsematrix spa;
    double spaval;
    ae_matrix a;
    ae_matrix ta;
    ae_int_t m;
    ae_int_t n;
    ae_int_t c;
    ae_int_t ne;
    ae_int_t nr;
    double r;
    double v;
    ae_int_t hashcrs;
    ae_int_t i;
    ae_int_t j;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    _sparsematrix_init(&spa, _state);
    ae_matrix_init(&a, 0, 0, DT_REAL, _state);
    ae_matrix_init(&ta, 0, 0, DT_BOOL, _state);

    r = 20.0;
    for(m=1; m<=30; m++)
    {
        for(n=1; n<=30; n++)
        {
            ae_matrix_set_length(&a, m, n, _state);
            ae_matrix_set_length(&ta, m, n, _state);
            for(hashcrs=0; hashcrs<=1; hashcrs++)
            {
                v = r*(2*ae_randomreal(_state)-1);
                
                /*
                 * Creating and filling of the matrix
                 */
                ne = 0;
                sparsecreate(m, n, m*n, &spa, _state);
                for(i=0; i<=m-1; i++)
                {
                    for(j=0; j<=n-1; j++)
                    {
                        c = ae_randominteger(2, _state);
                        if( c==0 )
                        {
                            a.ptr.pp_double[i][j] = (double)(0);
                        }
                        if( c==1 )
                        {
                            do
                            {
                                a.ptr.pp_double[i][j] = r*(2*ae_randomreal(_state)-1);
                            }
                            while(ae_fp_eq(a.ptr.pp_double[i][j],(double)(0)));
                            sparseset(&spa, i, j, a.ptr.pp_double[i][j], _state);
                            ne = ne+1;
                        }
                        ta.ptr.pp_bool[i][j] = ae_false;
                    }
                }
                if( hashcrs==1 )
                {
                    sparseconverttocrs(&spa, _state);
                }
                
                /*
                 * Rewrite some elements
                 */
                nr = 0;
                for(i=0; i<=m-1; i++)
                {
                    for(j=0; j<=n-1; j++)
                    {
                        c = ae_randominteger(2, _state);
                        if( c==1 )
                        {
                            ta.ptr.pp_bool[i][j] = sparserewriteexisting(&spa, i, j, v, _state);
                            if( ta.ptr.pp_bool[i][j] )
                            {
                                a.ptr.pp_double[i][j] = v;
                                nr = nr+1;
                            }
                        }
                    }
                }
                
                /*
                 * Now we have to be sure, that all changes had made correctly
                 */
                for(i=0; i<=m-1; i++)
                {
                    for(j=0; j<=n-1; j++)
                    {
                        if( ta.ptr.pp_bool[i][j] )
                        {
                            spaval = sparseget(&spa, i, j, _state);
                            nr = nr-1;
                            if( ae_fp_neq(spaval,v)||ae_fp_neq(spaval,a.ptr.pp_double[i][j]) )
                            {
                                result = ae_true;
                                ae_frame_leave(_state);
                                return result;
                            }
                        }
                    }
                }
                if( nr!=0 )
                {
                    result = ae_true;
                    ae_frame_leave(_state);
                    return result;
                }
                
                /*
                 * Rewrite all elements
                 */
                for(i=0; i<=m-1; i++)
                {
                    for(j=0; j<=n-1; j++)
                    {
                        ta.ptr.pp_bool[i][j] = sparserewriteexisting(&spa, i, j, v, _state);
                        if( ta.ptr.pp_bool[i][j] )
                        {
                            a.ptr.pp_double[i][j] = v;
                        }
                    }
                }
                for(i=0; i<=m-1; i++)
                {
                    for(j=0; j<=n-1; j++)
                    {
                        if( ta.ptr.pp_bool[i][j] )
                        {
                            ne = ne-1;
                        }
                    }
                }
                if( ne!=0 )
                {
                    result = ae_true;
                    ae_frame_leave(_state);
                    return result;
                }
                for(i=0; i<=m-1; i++)
                {
                    for(j=0; j<=n-1; j++)
                    {
                        spaval = sparseget(&spa, i, j, _state);
                        if( ta.ptr.pp_bool[i][j] )
                        {
                            if( ae_fp_neq(spaval,v)||ae_fp_neq(spaval,a.ptr.pp_double[i][j]) )
                            {
                                result = ae_true;
                                ae_frame_leave(_state);
                                return result;
                            }
                        }
                        else
                        {
                            if( ae_fp_neq(spaval,(double)(0))||ae_fp_neq(spaval,a.ptr.pp_double[i][j]) )
                            {
                                result = ae_true;
                                ae_frame_leave(_state);
                                return result;
                            }
                        }
                    }
                }
            }
        }
    }
    result = ae_false;
    ae_frame_leave(_state);
    return result;
}


/*************************************************************************
Test  for  SparseGetRow/GetCompressedRow  function.   It  creates  random
dense and sparse matrices;  then  get every  row from  sparse matrix  and
compares it with every row in dense matrix.

On failure sets error flag, on success leaves it unchanged.

  -- ALGLIB PROJECT --
     Copyright 23.07.2012 by Bochkanov Sergey
*************************************************************************/
static void testsparseunit_testgetrow(ae_bool* err, ae_state *_state)
{
    ae_frame _frame_block;
    sparsematrix s;
    ae_matrix a;
    ae_int_t m;
    ae_int_t n;
    ae_int_t msize;
    ae_int_t nsize;
    ae_int_t nz;
    ae_vector vals;
    ae_vector mrow;
    ae_vector colidx;
    ae_vector wasreturned;
    ae_int_t mtype;
    ae_int_t i;
    ae_int_t j;

    ae_frame_make(_state, &_frame_block);
    _sparsematrix_init(&s, _state);
    ae_matrix_init(&a, 0, 0, DT_REAL, _state);
    ae_vector_init(&vals, 0, DT_REAL, _state);
    ae_vector_init(&mrow, 0, DT_REAL, _state);
    ae_vector_init(&colidx, 0, DT_INT, _state);
    ae_vector_init(&wasreturned, 0, DT_BOOL, _state);

    msize = 15;
    nsize = 15;
    for(mtype=1; mtype<=2; mtype++)
    {
        for(m=1; m<=msize; m++)
        {
            for(n=1; n<=nsize; n++)
            {
                
                /*
                 * Skip nonrectangular SKS matrices - not supported
                 */
                if( mtype==2&&m!=n )
                {
                    continue;
                }
                
                /*
                 * Create "reference" and sparse matrices
                 */
                ae_matrix_set_length(&a, m, n, _state);
                sparsecreate(m, n, 1, &s, _state);
                for(i=0; i<=m-1; i++)
                {
                    for(j=0; j<=n-1; j++)
                    {
                        if( ae_randominteger(5, _state)==3 )
                        {
                            a.ptr.pp_double[i][j] = 2*ae_randomreal(_state)-1;
                            sparseset(&s, i, j, a.ptr.pp_double[i][j], _state);
                        }
                        else
                        {
                            a.ptr.pp_double[i][j] = (double)(0);
                        }
                    }
                }
                
                /*
                 * Choose matrix type to test
                 */
                if( mtype==1 )
                {
                    sparseconverttocrs(&s, _state);
                }
                else
                {
                    sparseconverttosks(&s, _state);
                }
                
                /*
                 * Test SparseGetRow()
                 */
                for(i=0; i<=m-1; i++)
                {
                    sparsegetrow(&s, i, &mrow, _state);
                    for(j=0; j<=n-1; j++)
                    {
                        if( ae_fp_neq(mrow.ptr.p_double[j],a.ptr.pp_double[i][j])||ae_fp_neq(mrow.ptr.p_double[j],sparseget(&s, i, j, _state)) )
                        {
                            seterrorflag(err, ae_true, _state);
                            ae_frame_leave(_state);
                            return;
                        }
                    }
                }
                
                /*
                 * Test SparseGetCompressedRow()
                 */
                ae_vector_set_length(&wasreturned, n, _state);
                for(i=0; i<=m-1; i++)
                {
                    sparsegetcompressedrow(&s, i, &colidx, &vals, &nz, _state);
                    if( nz<0||nz>n )
                    {
                        seterrorflag(err, ae_true, _state);
                        ae_frame_leave(_state);
                        return;
                    }
                    for(j=0; j<=n-1; j++)
                    {
                        wasreturned.ptr.p_bool[j] = ae_false;
                    }
                    for(j=0; j<=nz-1; j++)
                    {
                        if( colidx.ptr.p_int[j]<0||colidx.ptr.p_int[j]>n )
                        {
                            seterrorflag(err, ae_true, _state);
                            ae_frame_leave(_state);
                            return;
                        }
                        seterrorflag(err, j>0&&colidx.ptr.p_int[j]<=colidx.ptr.p_int[j-1], _state);
                        seterrorflag(err, ae_fp_neq(vals.ptr.p_double[j],a.ptr.pp_double[i][colidx.ptr.p_int[j]])||ae_fp_neq(vals.ptr.p_double[j],sparseget(&s, i, colidx.ptr.p_int[j], _state)), _state);
                        wasreturned.ptr.p_bool[colidx.ptr.p_int[j]] = ae_true;
                    }
                    for(j=0; j<=n-1; j++)
                    {
                        seterrorflag(err, ae_fp_neq(a.ptr.pp_double[i][j],(double)(0))&&!wasreturned.ptr.p_bool[j], _state);
                    }
                }
            }
        }
    }
    ae_frame_leave(_state);
}


/*************************************************************************
Test for SparseConvert functions(isn't tested ConvertToCRS function). The
function  create random  dense and sparse  matrices  in CRS  format. Then
convert  sparse matrix  to some  format  by CONVERT_TO/COPY_TO  functions,
then it does  some modification in matrices and compares that marices are
identical.

NOTE:
    Result of the function assigned to variable CopyErrors in unit test.

  -- ALGLIB PROJECT --
     Copyright 23.07.2012 by Bochkanov Sergey
*************************************************************************/
static ae_bool testsparseunit_testconvertsm(ae_state *_state)
{
    ae_frame _frame_block;
    sparsematrix s;
    sparsematrix cs;
    ae_matrix a;
    ae_int_t m;
    ae_int_t n;
    ae_int_t msize;
    ae_int_t nsize;
    ae_vector ner;
    double tmp;
    ae_int_t i;
    ae_int_t j;
    ae_int_t vartf;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    _sparsematrix_init(&s, _state);
    _sparsematrix_init(&cs, _state);
    ae_matrix_init(&a, 0, 0, DT_REAL, _state);
    ae_vector_init(&ner, 0, DT_INT, _state);

    msize = 15;
    nsize = 15;
    for(m=1; m<=msize; m++)
    {
        for(n=1; n<=nsize; n++)
        {
            for(vartf=0; vartf<=2; vartf++)
            {
                ae_matrix_set_length(&a, m, n, _state);
                ae_vector_set_length(&ner, m, _state);
                for(i=0; i<=m-1; i++)
                {
                    ner.ptr.p_int[i] = 0;
                    for(j=0; j<=n-1; j++)
                    {
                        if( ae_randominteger(5, _state)==3 )
                        {
                            ner.ptr.p_int[i] = ner.ptr.p_int[i]+1;
                            a.ptr.pp_double[i][j] = 2*ae_randomreal(_state)-1;
                        }
                        else
                        {
                            a.ptr.pp_double[i][j] = (double)(0);
                        }
                    }
                }
                
                /*
                 * Create sparse matrix
                 */
                sparsecreatecrs(m, n, &ner, &s, _state);
                for(i=0; i<=m-1; i++)
                {
                    for(j=0; j<=n-1; j++)
                    {
                        if( ae_fp_neq(a.ptr.pp_double[i][j],(double)(0)) )
                        {
                            a.ptr.pp_double[i][j] = 2*ae_randomreal(_state)-1;
                            sparseset(&s, i, j, a.ptr.pp_double[i][j], _state);
                        }
                    }
                }
                
                /*
                 * Set matrix type(we have to be sure that all formats
                 * converted correctly)
                 */
                i = ae_randominteger(2, _state);
                if( i==0 )
                {
                    sparseconverttohash(&s, _state);
                }
                if( i==1 )
                {
                    sparseconverttocrs(&s, _state);
                }
                
                /*
                 * Start test
                 */
                if( vartf==0 )
                {
                    sparseconverttohash(&s, _state);
                    sparsecopy(&s, &cs, _state);
                }
                if( vartf==1 )
                {
                    sparsecopytohash(&s, &cs, _state);
                }
                if( vartf==2 )
                {
                    sparsecopytocrs(&s, &cs, _state);
                }
                
                /*
                 * Change some elements in row
                 */
                if( vartf!=2 )
                {
                    for(i=0; i<=m-1; i++)
                    {
                        tmp = 2*ae_randomreal(_state)-1;
                        j = ae_randominteger(n, _state);
                        a.ptr.pp_double[i][j] = tmp;
                        sparseset(&cs, i, j, tmp, _state);
                        tmp = 2*ae_randomreal(_state)-1;
                        j = ae_randominteger(n, _state);
                        a.ptr.pp_double[i][j] = a.ptr.pp_double[i][j]+tmp;
                        sparseadd(&cs, i, j, tmp, _state);
                    }
                }
                
                /*
                 * Check that A is identical to S
                 */
                for(i=0; i<=m-1; i++)
                {
                    for(j=0; j<=n-1; j++)
                    {
                        if( ae_fp_neq(a.ptr.pp_double[i][j],sparseget(&cs, i, j, _state)) )
                        {
                            result = ae_true;
                            ae_frame_leave(_state);
                            return result;
                        }
                    }
                }
            }
        }
    }
    result = ae_false;
    ae_frame_leave(_state);
    return result;
}


/*************************************************************************
Test for  check/get  type functions.  The function  create sparse matrix,
converts it to desired type then check this type.

NOTE:
    Result of the function assigned to variable BasicErrors in unit test.

  -- ALGLIB PROJECT --
     Copyright 23.07.2012 by Bochkanov Sergey
*************************************************************************/
static ae_bool testsparseunit_testgcmatrixtype(ae_state *_state)
{
    ae_frame _frame_block;
    sparsematrix s;
    sparsematrix cs;
    ae_int_t m;
    ae_int_t n;
    ae_int_t msize;
    ae_int_t nsize;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    _sparsematrix_init(&s, _state);
    _sparsematrix_init(&cs, _state);

    msize = 5;
    nsize = 5;
    for(m=1; m<=msize; m++)
    {
        for(n=1; n<=nsize; n++)
        {
            sparsecreate(m, n, 1, &s, _state);
            sparseconverttocrs(&s, _state);
            if( (sparseishash(&s, _state)||!sparseiscrs(&s, _state))||sparsegetmatrixtype(&s, _state)!=1 )
            {
                result = ae_true;
                ae_frame_leave(_state);
                return result;
            }
            sparseconverttohash(&s, _state);
            if( (!sparseishash(&s, _state)||sparseiscrs(&s, _state))||sparsegetmatrixtype(&s, _state)!=0 )
            {
                result = ae_true;
                ae_frame_leave(_state);
                return result;
            }
            sparsecopytocrs(&s, &cs, _state);
            if( (sparseishash(&cs, _state)||!sparseiscrs(&cs, _state))||sparsegetmatrixtype(&cs, _state)!=1 )
            {
                result = ae_true;
                ae_frame_leave(_state);
                return result;
            }
            sparsecopytohash(&cs, &s, _state);
            if( (!sparseishash(&s, _state)||sparseiscrs(&s, _state))||sparsegetmatrixtype(&s, _state)!=0 )
            {
                result = ae_true;
                ae_frame_leave(_state);
                return result;
            }
        }
    }
    result = ae_false;
    ae_frame_leave(_state);
    return result;
}


void _sparsegenerator_init(void* _p, ae_state *_state)
{
    sparsegenerator *p = (sparsegenerator*)_p;
    ae_touch_ptr((void*)p);
    ae_matrix_init(&p->bufa, 0, 0, DT_REAL, _state);
    _hqrndstate_init(&p->rs, _state);
    _rcommstate_init(&p->rcs, _state);
}


void _sparsegenerator_init_copy(void* _dst, void* _src, ae_state *_state)
{
    sparsegenerator *dst = (sparsegenerator*)_dst;
    sparsegenerator *src = (sparsegenerator*)_src;
    dst->n = src->n;
    dst->m = src->m;
    dst->matkind = src->matkind;
    dst->triangle = src->triangle;
    ae_matrix_init_copy(&dst->bufa, &src->bufa, _state);
    _hqrndstate_init_copy(&dst->rs, &src->rs, _state);
    _rcommstate_init_copy(&dst->rcs, &src->rcs, _state);
}


void _sparsegenerator_clear(void* _p)
{
    sparsegenerator *p = (sparsegenerator*)_p;
    ae_touch_ptr((void*)p);
    ae_matrix_clear(&p->bufa);
    _hqrndstate_clear(&p->rs);
    _rcommstate_clear(&p->rcs);
}


void _sparsegenerator_destroy(void* _p)
{
    sparsegenerator *p = (sparsegenerator*)_p;
    ae_touch_ptr((void*)p);
    ae_matrix_destroy(&p->bufa);
    _hqrndstate_destroy(&p->rs);
    _rcommstate_destroy(&p->rcs);
}



static void testtrfacunit_testcluproblem(/* Complex */ ae_matrix* a,
     ae_int_t m,
     ae_int_t n,
     double threshold,
     ae_bool* err,
     ae_bool* properr,
     ae_state *_state);
static void testtrfacunit_testrluproblem(/* Real    */ ae_matrix* a,
     ae_int_t m,
     ae_int_t n,
     double threshold,
     ae_bool* err,
     ae_bool* properr,
     ae_state *_state);
static void testtrfacunit_testdensecholeskyupdates(ae_bool* spdupderrorflag,
     ae_state *_state);





ae_bool testtrfac(ae_bool silent, ae_state *_state)
{
    ae_frame _frame_block;
    ae_matrix ra;
    ae_matrix ral;
    ae_matrix rau;
    ae_matrix ca;
    ae_matrix cal;
    ae_matrix cau;
    ae_int_t m;
    ae_int_t n;
    ae_int_t mx;
    ae_int_t maxmn;
    ae_int_t largemn;
    ae_int_t i;
    ae_int_t j;
    ae_complex vc;
    double vr;
    ae_bool waserrors;
    ae_bool dspderr;
    ae_bool sspderr;
    ae_bool hpderr;
    ae_bool rerr;
    ae_bool cerr;
    ae_bool properr;
    ae_bool dspdupderr;
    double threshold;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    ae_matrix_init(&ra, 0, 0, DT_REAL, _state);
    ae_matrix_init(&ral, 0, 0, DT_REAL, _state);
    ae_matrix_init(&rau, 0, 0, DT_REAL, _state);
    ae_matrix_init(&ca, 0, 0, DT_COMPLEX, _state);
    ae_matrix_init(&cal, 0, 0, DT_COMPLEX, _state);
    ae_matrix_init(&cau, 0, 0, DT_COMPLEX, _state);

    rerr = ae_false;
    dspderr = ae_false;
    sspderr = ae_false;
    cerr = ae_false;
    hpderr = ae_false;
    properr = ae_false;
    dspdupderr = ae_false;
    waserrors = ae_false;
    maxmn = 4*ablasblocksize(&ra, _state)+1;
    largemn = 256;
    threshold = 1000*ae_machineepsilon*maxmn;
    
    /*
     * Sparse Cholesky
     */
    sspderr = sparserealcholeskytest(_state);
    
    /*
     * Cholesky updates
     */
    testtrfacunit_testdensecholeskyupdates(&dspdupderr, _state);
    
    /*
     * test LU:
     * * first, test on small-scale matrices
     * * then, perform several large-scale tests
     */
    for(mx=1; mx<=maxmn; mx++)
    {
        
        /*
         * Initialize N/M, both are <=MX,
         * at least one of them is exactly equal to MX
         */
        n = 1+ae_randominteger(mx, _state);
        m = 1+ae_randominteger(mx, _state);
        if( ae_fp_greater(ae_randomreal(_state),0.5) )
        {
            n = mx;
        }
        else
        {
            m = mx;
        }
        
        /*
         * First, test on zero matrix
         */
        ae_matrix_set_length(&ra, m, n, _state);
        ae_matrix_set_length(&ca, m, n, _state);
        for(i=0; i<=m-1; i++)
        {
            for(j=0; j<=n-1; j++)
            {
                ra.ptr.pp_double[i][j] = (double)(0);
                ca.ptr.pp_complex[i][j] = ae_complex_from_i(0);
            }
        }
        testtrfacunit_testcluproblem(&ca, m, n, threshold, &cerr, &properr, _state);
        testtrfacunit_testrluproblem(&ra, m, n, threshold, &rerr, &properr, _state);
        
        /*
         * Second, random matrix with moderate condition number
         */
        ae_matrix_set_length(&ra, m, n, _state);
        ae_matrix_set_length(&ca, m, n, _state);
        for(i=0; i<=m-1; i++)
        {
            for(j=0; j<=n-1; j++)
            {
                ra.ptr.pp_double[i][j] = (double)(0);
                ca.ptr.pp_complex[i][j] = ae_complex_from_i(0);
            }
        }
        for(i=0; i<=ae_minint(m, n, _state)-1; i++)
        {
            ra.ptr.pp_double[i][i] = 1+10*ae_randomreal(_state);
            ca.ptr.pp_complex[i][i] = ae_complex_from_d(1+10*ae_randomreal(_state));
        }
        cmatrixrndorthogonalfromtheleft(&ca, m, n, _state);
        cmatrixrndorthogonalfromtheright(&ca, m, n, _state);
        rmatrixrndorthogonalfromtheleft(&ra, m, n, _state);
        rmatrixrndorthogonalfromtheright(&ra, m, n, _state);
        testtrfacunit_testcluproblem(&ca, m, n, threshold, &cerr, &properr, _state);
        testtrfacunit_testrluproblem(&ra, m, n, threshold, &rerr, &properr, _state);
    }
    for(m=largemn-1; m<=largemn+1; m++)
    {
        for(n=largemn-1; n<=largemn+1; n++)
        {
            
            /*
             * Random matrix with moderate condition number
             */
            ae_matrix_set_length(&ra, m, n, _state);
            ae_matrix_set_length(&ca, m, n, _state);
            for(i=0; i<=m-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    ra.ptr.pp_double[i][j] = (double)(0);
                    ca.ptr.pp_complex[i][j] = ae_complex_from_i(0);
                }
            }
            for(i=0; i<=ae_minint(m, n, _state)-1; i++)
            {
                ra.ptr.pp_double[i][i] = 1+10*ae_randomreal(_state);
                ca.ptr.pp_complex[i][i] = ae_complex_from_d(1+10*ae_randomreal(_state));
            }
            cmatrixrndorthogonalfromtheleft(&ca, m, n, _state);
            cmatrixrndorthogonalfromtheright(&ca, m, n, _state);
            rmatrixrndorthogonalfromtheleft(&ra, m, n, _state);
            rmatrixrndorthogonalfromtheright(&ra, m, n, _state);
            testtrfacunit_testcluproblem(&ca, m, n, threshold, &cerr, &properr, _state);
            testtrfacunit_testrluproblem(&ra, m, n, threshold, &rerr, &properr, _state);
        }
    }
    
    /*
     * Test Cholesky
     */
    for(n=1; n<=maxmn; n++)
    {
        
        /*
         * Load CA (HPD matrix with low condition number),
         *      CAL and CAU - its lower and upper triangles
         */
        hpdmatrixrndcond(n, 1+50*ae_randomreal(_state), &ca, _state);
        ae_matrix_set_length(&cal, n, n, _state);
        ae_matrix_set_length(&cau, n, n, _state);
        for(i=0; i<=n-1; i++)
        {
            for(j=0; j<=n-1; j++)
            {
                cal.ptr.pp_complex[i][j] = ae_complex_from_i(i);
                cau.ptr.pp_complex[i][j] = ae_complex_from_i(j);
            }
        }
        for(i=0; i<=n-1; i++)
        {
            ae_v_cmove(&cal.ptr.pp_complex[i][0], 1, &ca.ptr.pp_complex[i][0], 1, "N", ae_v_len(0,i));
            ae_v_cmove(&cau.ptr.pp_complex[i][i], 1, &ca.ptr.pp_complex[i][i], 1, "N", ae_v_len(i,n-1));
        }
        
        /*
         * Test HPDMatrixCholesky:
         * 1. it must leave upper (lower) part unchanged
         * 2. max(A-L*L^H) must be small
         */
        if( hpdmatrixcholesky(&cal, n, ae_false, _state) )
        {
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    if( j>i )
                    {
                        hpderr = hpderr||ae_c_neq_d(cal.ptr.pp_complex[i][j],(double)(i));
                    }
                    else
                    {
                        vc = ae_v_cdotproduct(&cal.ptr.pp_complex[i][0], 1, "N", &cal.ptr.pp_complex[j][0], 1, "Conj", ae_v_len(0,j));
                        hpderr = hpderr||ae_fp_greater(ae_c_abs(ae_c_sub(ca.ptr.pp_complex[i][j],vc), _state),threshold);
                    }
                }
            }
        }
        else
        {
            hpderr = ae_true;
        }
        if( hpdmatrixcholesky(&cau, n, ae_true, _state) )
        {
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    if( j<i )
                    {
                        hpderr = hpderr||ae_c_neq_d(cau.ptr.pp_complex[i][j],(double)(j));
                    }
                    else
                    {
                        vc = ae_v_cdotproduct(&cau.ptr.pp_complex[0][i], cau.stride, "Conj", &cau.ptr.pp_complex[0][j], cau.stride, "N", ae_v_len(0,i));
                        hpderr = hpderr||ae_fp_greater(ae_c_abs(ae_c_sub(ca.ptr.pp_complex[i][j],vc), _state),threshold);
                    }
                }
            }
        }
        else
        {
            hpderr = ae_true;
        }
        
        /*
         * Load RA (SPD matrix with low condition number),
         *      RAL and RAU - its lower and upper triangles
         *
         * Test SPDMatrixCholesky:
         * 1. it must leave upper (lower) part unchanged
         * 2. max(A-L*L^H) must be small
         *
         * After testing SPDMatrixCholesky() we compare results
         * returned by SparseCholeskyX() against ones returned
         * by SPDMatrixCholesky().
         */
        spdmatrixrndcond(n, 1+50*ae_randomreal(_state), &ra, _state);
        ae_matrix_set_length(&ral, n, n, _state);
        ae_matrix_set_length(&rau, n, n, _state);
        for(i=0; i<=n-1; i++)
        {
            for(j=0; j<=n-1; j++)
            {
                ral.ptr.pp_double[i][j] = (double)(i);
                rau.ptr.pp_double[i][j] = (double)(j);
            }
        }
        for(i=0; i<=n-1; i++)
        {
            ae_v_move(&ral.ptr.pp_double[i][0], 1, &ra.ptr.pp_double[i][0], 1, ae_v_len(0,i));
            ae_v_move(&rau.ptr.pp_double[i][i], 1, &ra.ptr.pp_double[i][i], 1, ae_v_len(i,n-1));
        }
        if( spdmatrixcholesky(&ral, n, ae_false, _state) )
        {
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    if( j>i )
                    {
                        dspderr = dspderr||ae_fp_neq(ral.ptr.pp_double[i][j],(double)(i));
                    }
                    else
                    {
                        vr = ae_v_dotproduct(&ral.ptr.pp_double[i][0], 1, &ral.ptr.pp_double[j][0], 1, ae_v_len(0,j));
                        dspderr = dspderr||ae_fp_greater(ae_fabs(ra.ptr.pp_double[i][j]-vr, _state),threshold);
                    }
                }
            }
        }
        else
        {
            dspderr = ae_true;
        }
        if( spdmatrixcholesky(&rau, n, ae_true, _state) )
        {
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    if( j<i )
                    {
                        dspderr = dspderr||ae_fp_neq(rau.ptr.pp_double[i][j],(double)(j));
                    }
                    else
                    {
                        vr = ae_v_dotproduct(&rau.ptr.pp_double[0][i], rau.stride, &rau.ptr.pp_double[0][j], rau.stride, ae_v_len(0,i));
                        dspderr = dspderr||ae_fp_greater(ae_fabs(ra.ptr.pp_double[i][j]-vr, _state),threshold);
                    }
                }
            }
        }
        else
        {
            dspderr = ae_true;
        }
        
        /*
         * Check algorithms on negative definite matrices -
         * correct error code must be returned.
         */
        ae_matrix_set_length(&ra, n, n, _state);
        ae_matrix_set_length(&ca, n, n, _state);
        for(i=0; i<=n-1; i++)
        {
            for(j=0; j<=n-1; j++)
            {
                ra.ptr.pp_double[i][j] = 0.0;
                ca.ptr.pp_complex[i][j] = ae_complex_from_d(0.0);
            }
            ra.ptr.pp_double[i][i] = 1.0;
            ca.ptr.pp_complex[i][i] = ae_complex_from_d(1.0);
        }
        ra.ptr.pp_double[n/2][n/2] = -1.0;
        ca.ptr.pp_complex[n/2][n/2] = ae_complex_from_d(-1.0);
        seterrorflag(&dspderr, spdmatrixcholesky(&ra, n, ae_fp_greater(ae_randomreal(_state),0.5), _state), _state);
        seterrorflag(&hpderr, hpdmatrixcholesky(&ca, n, ae_fp_greater(ae_randomreal(_state),0.5), _state), _state);
    }
    
    /*
     * report
     */
    waserrors = (((((rerr||dspderr)||sspderr)||cerr)||hpderr)||properr)||dspdupderr;
    if( !silent )
    {
        printf("TESTING TRIANGULAR FACTORIZATIONS\n");
        printf("* REAL:                                  ");
        if( rerr )
        {
            printf("FAILED\n");
        }
        else
        {
            printf("OK\n");
        }
        printf("* SPD (dense)                            ");
        if( dspderr )
        {
            printf("FAILED\n");
        }
        else
        {
            printf("OK\n");
        }
        printf("* SPD (sparse)                           ");
        if( sspderr )
        {
            printf("FAILED\n");
        }
        else
        {
            printf("OK\n");
        }
        printf("* COMPLEX:                               ");
        if( cerr )
        {
            printf("FAILED\n");
        }
        else
        {
            printf("OK\n");
        }
        printf("* HPD:                                   ");
        if( hpderr )
        {
            printf("FAILED\n");
        }
        else
        {
            printf("OK\n");
        }
        printf("* OTHER PROPERTIES:                      ");
        if( properr )
        {
            printf("FAILED\n");
        }
        else
        {
            printf("OK\n");
        }
        printf("TESTING UPDATED FACTORIZATIONS\n");
        printf("* SPD (dense)                            ");
        if( dspdupderr )
        {
            printf("FAILED\n");
        }
        else
        {
            printf("OK\n");
        }
        if( waserrors )
        {
            printf("TEST FAILED\n");
        }
        else
        {
            printf("TEST PASSED\n");
        }
        printf("\n\n");
    }
    result = !waserrors;
    ae_frame_leave(_state);
    return result;
}


/*************************************************************************
Single-threaded stub. HPC ALGLIB replaces it by multithreaded code.
*************************************************************************/
ae_bool _pexec_testtrfac(ae_bool silent, ae_state *_state)
{
    return testtrfac(silent, _state);
}


/*************************************************************************
Function for testing sparse real Cholesky.
Returns True on errors, False on success.

  -- ALGLIB PROJECT --
     Copyright 16.01.1014 by Bochkanov Sergey
*************************************************************************/
ae_bool sparserealcholeskytest(ae_state *_state)
{
    ae_frame _frame_block;
    ae_int_t n;
    ae_int_t nz;
    double pnz;
    ae_matrix a;
    ae_matrix a1;
    ae_int_t i;
    ae_int_t j;
    ae_int_t k;
    double v;
    ae_int_t t0;
    ae_int_t t1;
    ae_bool isupper;
    double offscale;
    double tol;
    sparsematrix sa;
    sparsematrix sa1;
    sparsematrix sc;
    sparsebuffers sbuf;
    ae_vector p0;
    ae_vector p1;
    ae_vector b1;
    ae_int_t cfmt;
    ae_int_t cord;
    hqrndstate rs;
    ae_int_t maxfmt;
    ae_int_t maxord;
    ae_int_t minord;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    ae_matrix_init(&a, 0, 0, DT_REAL, _state);
    ae_matrix_init(&a1, 0, 0, DT_REAL, _state);
    _sparsematrix_init(&sa, _state);
    _sparsematrix_init(&sa1, _state);
    _sparsematrix_init(&sc, _state);
    _sparsebuffers_init(&sbuf, _state);
    ae_vector_init(&p0, 0, DT_INT, _state);
    ae_vector_init(&p1, 0, DT_INT, _state);
    ae_vector_init(&b1, 0, DT_BOOL, _state);
    _hqrndstate_init(&rs, _state);

    result = ae_false;
    hqrndrandomize(&rs, _state);
    
    /*
     * Settings
     */
    maxfmt = 2;
    maxord = 0;
    minord = -2;
    offscale = 1.0E-3;
    tol = 1.0E-8;
    
    /*
     * SparseCholeskyX test: performed for matrices
     * of all sizes in 1..20 and all sparcity percentages.
     */
    for(n=1; n<=20; n++)
    {
        nz = n*n-n;
        for(;;)
        {
            
            /*
             * Generate symmetric N*N matrix where probability of non-diagonal element
             * being non-zero is PNZ. Off-diagonal elements are set to very
             * small values, so positive definiteness is guaranteed.
             */
            if( n>1 )
            {
                pnz = (double)nz/(double)(n*n-n);
            }
            else
            {
                pnz = 1.0;
            }
            ae_matrix_set_length(&a, n, n, _state);
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=i; j++)
                {
                    if( i==j )
                    {
                        a.ptr.pp_double[i][i] = 1+hqrnduniformr(&rs, _state);
                        continue;
                    }
                    if( ae_fp_less_eq(hqrnduniformr(&rs, _state),pnz) )
                    {
                        a.ptr.pp_double[i][j] = offscale*(hqrnduniformr(&rs, _state)-0.5);
                        a.ptr.pp_double[j][i] = a.ptr.pp_double[i][j];
                    }
                    else
                    {
                        a.ptr.pp_double[i][j] = 0.0;
                        a.ptr.pp_double[j][i] = 0.0;
                    }
                }
            }
            
            /*
             * Problem statement
             */
            isupper = ae_fp_greater(ae_randomreal(_state),0.5);
            cfmt = ae_randominteger(maxfmt+1, _state);
            cord = ae_randominteger(maxord+1-minord, _state)+minord;
            
            /*
             * Create matrix is hash-based storage format, convert it to random storage format.
             */
            sparsecreate(n, n, 0, &sa, _state);
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    if( (j<=i&&!isupper)||(j>=i&&isupper) )
                    {
                        sparseset(&sa, i, j, a.ptr.pp_double[i][j], _state);
                    }
                }
            }
            sparseconvertto(&sa, hqrnduniformi(&rs, maxfmt+1, _state), _state);
            
            /*
             * Perform sparse Cholesky and make several tests:
             * * correctness of P0 and P1 (they are correct permutations and one is inverse of another)
             * * format of SC matches CFmt
             * * SC has correct size (exactly N*N)
             * * check that correct triangle is returned
             */
            if( !sparsecholeskyx(&sa, n, isupper, &p0, &p1, cord, ae_randominteger(3, _state), cfmt, &sbuf, &sc, _state) )
            {
                seterrorflag(&result, ae_true, _state);
                ae_frame_leave(_state);
                return result;
            }
            seterrorflag(&result, p0.cnt<n, _state);
            seterrorflag(&result, p1.cnt<n, _state);
            if( result )
            {
                ae_frame_leave(_state);
                return result;
            }
            ae_vector_set_length(&b1, n, _state);
            for(i=0; i<=n-1; i++)
            {
                b1.ptr.p_bool[i] = ae_false;
            }
            for(i=0; i<=n-1; i++)
            {
                seterrorflag(&result, p0.ptr.p_int[i]<0, _state);
                seterrorflag(&result, p1.ptr.p_int[i]<0, _state);
                seterrorflag(&result, p0.ptr.p_int[i]>=n, _state);
                seterrorflag(&result, p1.ptr.p_int[i]>=n, _state);
                if( result )
                {
                    ae_frame_leave(_state);
                    return result;
                }
                seterrorflag(&result, b1.ptr.p_bool[p0.ptr.p_int[i]], _state);
                b1.ptr.p_bool[p0.ptr.p_int[i]] = ae_true;
                seterrorflag(&result, p1.ptr.p_int[p0.ptr.p_int[i]]!=i, _state);
            }
            seterrorflag(&result, sparsegetmatrixtype(&sc, _state)!=cfmt, _state);
            seterrorflag(&result, sparsegetncols(&sc, _state)!=n, _state);
            seterrorflag(&result, sparsegetnrows(&sc, _state)!=n, _state);
            t0 = 0;
            t1 = 0;
            while(sparseenumerate(&sc, &t0, &t1, &i, &j, &v, _state))
            {
                seterrorflag(&result, j<i&&isupper, _state);
                seterrorflag(&result, j>i&&!isupper, _state);
            }
            
            /*
             * Now, test correctness of Cholesky decomposition itself.
             * We calculate U'*U (or L*L') and check at against permutation
             * of A given by P0.
             *
             * NOTE: we expect that only one triangle of SC is filled,
             *       and another one is exactly zero.
             */
            if( isupper )
            {
                for(i=0; i<=n-1; i++)
                {
                    for(j=0; j<=n-1; j++)
                    {
                        v = 0.0;
                        for(k=0; k<=n-1; k++)
                        {
                            v = v+sparseget(&sc, k, j, _state)*sparseget(&sc, k, i, _state);
                        }
                        seterrorflag(&result, ae_fp_greater(ae_fabs(a.ptr.pp_double[p0.ptr.p_int[i]][p0.ptr.p_int[j]]-v, _state),tol), _state);
                    }
                }
            }
            else
            {
                for(i=0; i<=n-1; i++)
                {
                    for(j=0; j<=n-1; j++)
                    {
                        v = 0.0;
                        for(k=0; k<=n-1; k++)
                        {
                            v = v+sparseget(&sc, j, k, _state)*sparseget(&sc, i, k, _state);
                        }
                        seterrorflag(&result, ae_fp_greater(ae_fabs(a.ptr.pp_double[p0.ptr.p_int[i]][p0.ptr.p_int[j]]-v, _state),tol), _state);
                    }
                }
            }
            
            /*
             * Increase problem sparcity and try one more time. 
             * Stop after testing NZ=0.
             */
            if( nz==0 )
            {
                break;
            }
            nz = nz/2;
        }
    }
    
    /*
     * SparseCholeskySkyline test: performed for matrices
     * of all sizes in 1..20 and all sparcity percentages.
     */
    for(n=1; n<=20; n++)
    {
        nz = n*n-n;
        for(;;)
        {
            
            /*
             * Choose IsUpper - main triangle to work with.
             *
             * Generate A - symmetric N*N matrix where probability of non-diagonal
             * element being non-zero is PNZ. Off-diagonal elements are set to
             * very small values, so positive definiteness is guaranteed. Full matrix
             * is generated.
             *
             * Additionally, we create A1 - same as A, but one of the triangles is
             * asymmetrically spoiled. If IsUpper is True, we spoil lower one, or vice versa.
             */
            isupper = ae_fp_greater(ae_randomreal(_state),0.5);
            if( n>1 )
            {
                pnz = (double)nz/(double)(n*n-n);
            }
            else
            {
                pnz = 1.0;
            }
            ae_matrix_set_length(&a, n, n, _state);
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=i; j++)
                {
                    if( i==j )
                    {
                        a.ptr.pp_double[i][i] = 1+hqrnduniformr(&rs, _state);
                        continue;
                    }
                    if( ae_fp_less_eq(hqrnduniformr(&rs, _state),pnz) )
                    {
                        a.ptr.pp_double[i][j] = offscale*(hqrnduniformr(&rs, _state)-0.5);
                        a.ptr.pp_double[j][i] = a.ptr.pp_double[i][j];
                    }
                    else
                    {
                        a.ptr.pp_double[i][j] = 0.0;
                        a.ptr.pp_double[j][i] = 0.0;
                    }
                }
            }
            ae_matrix_set_length(&a1, n, n, _state);
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    if( (j<=i&&!isupper)||(j>=i&&isupper) )
                    {
                        
                        /*
                         * Copy one triangle
                         */
                        a1.ptr.pp_double[i][j] = a.ptr.pp_double[i][j];
                    }
                    else
                    {
                        
                        /*
                         * Form another sparse pattern in different triangle.
                         */
                        if( ae_fp_less_eq(hqrnduniformr(&rs, _state),pnz) )
                        {
                            a1.ptr.pp_double[i][j] = offscale*(hqrnduniformr(&rs, _state)-0.5);
                        }
                        else
                        {
                            a1.ptr.pp_double[i][j] = 0.0;
                        }
                    }
                }
            }
            
            /*
             * Create copies of A and A1 in hash-based storage format.
             * Only one triangle of A is copied, but A1 is copied fully.
             * Convert them to SKS
             */
            sparsecreate(n, n, 0, &sa, _state);
            sparsecreate(n, n, 0, &sa1, _state);
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    if( (j<=i&&!isupper)||(j>=i&&isupper) )
                    {
                        sparseset(&sa, i, j, a.ptr.pp_double[i][j], _state);
                    }
                    sparseset(&sa1, i, j, a1.ptr.pp_double[i][j], _state);
                }
            }
            sparseconverttosks(&sa, _state);
            sparseconverttosks(&sa1, _state);
            
            /*
             * Call SparseCholeskySkyline() for SA and make several tests:
             * * check that it is still SKS
             * * check that it has correct size (exactly N*N)
             * * check that correct triangle is returned (and another one is unchanged - zero)
             * * check that it is correct Cholesky decomposition.
             *   We calculate U'*U (or L*L') and check at against A. We expect
             *   that only one triangle of SA is filled, and another one is
             *   exactly zero.
             */
            if( !sparsecholeskyskyline(&sa, n, isupper, _state) )
            {
                seterrorflag(&result, ae_true, _state);
                ae_frame_leave(_state);
                return result;
            }
            seterrorflag(&result, !sparseissks(&sa, _state), _state);
            seterrorflag(&result, sparsegetncols(&sa, _state)!=n, _state);
            seterrorflag(&result, sparsegetnrows(&sa, _state)!=n, _state);
            t0 = 0;
            t1 = 0;
            while(sparseenumerate(&sa, &t0, &t1, &i, &j, &v, _state))
            {
                seterrorflag(&result, j<i&&isupper, _state);
                seterrorflag(&result, j>i&&!isupper, _state);
            }
            if( isupper )
            {
                for(i=0; i<=n-1; i++)
                {
                    for(j=0; j<=n-1; j++)
                    {
                        v = 0.0;
                        for(k=0; k<=n-1; k++)
                        {
                            v = v+sparseget(&sa, k, j, _state)*sparseget(&sa, k, i, _state);
                        }
                        seterrorflag(&result, ae_fp_greater(ae_fabs(a.ptr.pp_double[i][j]-v, _state),tol), _state);
                    }
                }
            }
            else
            {
                for(i=0; i<=n-1; i++)
                {
                    for(j=0; j<=n-1; j++)
                    {
                        v = 0.0;
                        for(k=0; k<=n-1; k++)
                        {
                            v = v+sparseget(&sa, j, k, _state)*sparseget(&sa, i, k, _state);
                        }
                        seterrorflag(&result, ae_fp_greater(ae_fabs(a.ptr.pp_double[i][j]-v, _state),tol), _state);
                    }
                }
            }
            
            /*
             * Call SparseCholeskySkyline() for SA1 and make several tests:
             * * check that it is still SKS
             * * check that it has correct size (exactly N*N)
             * * check that factorized triangle matches contents of SA,
             *   and another triangle was unchanged (matches contents of A1).
             */
            if( !sparsecholeskyskyline(&sa1, n, isupper, _state) )
            {
                seterrorflag(&result, ae_true, _state);
                ae_frame_leave(_state);
                return result;
            }
            seterrorflag(&result, !sparseissks(&sa1, _state), _state);
            seterrorflag(&result, sparsegetncols(&sa1, _state)!=n, _state);
            seterrorflag(&result, sparsegetnrows(&sa1, _state)!=n, _state);
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    if( (j<=i&&!isupper)||(j>=i&&isupper) )
                    {
                        seterrorflag(&result, ae_fp_greater(ae_fabs(sparseget(&sa1, i, j, _state)-sparseget(&sa, i, j, _state), _state),10*ae_machineepsilon), _state);
                    }
                    else
                    {
                        seterrorflag(&result, ae_fp_greater(ae_fabs(sparseget(&sa1, i, j, _state)-a1.ptr.pp_double[i][j], _state),10*ae_machineepsilon), _state);
                    }
                }
            }
            
            /*
             * Increase problem sparcity and try one more time. 
             * Stop after testing NZ=0.
             */
            if( nz==0 )
            {
                break;
            }
            nz = nz/2;
        }
    }
    ae_frame_leave(_state);
    return result;
}


static void testtrfacunit_testcluproblem(/* Complex */ ae_matrix* a,
     ae_int_t m,
     ae_int_t n,
     double threshold,
     ae_bool* err,
     ae_bool* properr,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_matrix ca;
    ae_matrix cl;
    ae_matrix cu;
    ae_matrix ca2;
    ae_vector ct;
    ae_int_t i;
    ae_int_t j;
    ae_int_t minmn;
    ae_complex v;
    ae_vector p;

    ae_frame_make(_state, &_frame_block);
    ae_matrix_init(&ca, 0, 0, DT_COMPLEX, _state);
    ae_matrix_init(&cl, 0, 0, DT_COMPLEX, _state);
    ae_matrix_init(&cu, 0, 0, DT_COMPLEX, _state);
    ae_matrix_init(&ca2, 0, 0, DT_COMPLEX, _state);
    ae_vector_init(&ct, 0, DT_COMPLEX, _state);
    ae_vector_init(&p, 0, DT_INT, _state);

    minmn = ae_minint(m, n, _state);
    
    /*
     * PLU test
     */
    ae_matrix_set_length(&ca, m, n, _state);
    for(i=0; i<=m-1; i++)
    {
        ae_v_cmove(&ca.ptr.pp_complex[i][0], 1, &a->ptr.pp_complex[i][0], 1, "N", ae_v_len(0,n-1));
    }
    cmatrixplu(&ca, m, n, &p, _state);
    for(i=0; i<=minmn-1; i++)
    {
        if( p.ptr.p_int[i]<i||p.ptr.p_int[i]>=m )
        {
            *properr = ae_true;
            ae_frame_leave(_state);
            return;
        }
    }
    ae_matrix_set_length(&cl, m, minmn, _state);
    for(j=0; j<=minmn-1; j++)
    {
        for(i=0; i<=j-1; i++)
        {
            cl.ptr.pp_complex[i][j] = ae_complex_from_d(0.0);
        }
        cl.ptr.pp_complex[j][j] = ae_complex_from_d(1.0);
        for(i=j+1; i<=m-1; i++)
        {
            cl.ptr.pp_complex[i][j] = ca.ptr.pp_complex[i][j];
        }
    }
    ae_matrix_set_length(&cu, minmn, n, _state);
    for(i=0; i<=minmn-1; i++)
    {
        for(j=0; j<=i-1; j++)
        {
            cu.ptr.pp_complex[i][j] = ae_complex_from_d(0.0);
        }
        for(j=i; j<=n-1; j++)
        {
            cu.ptr.pp_complex[i][j] = ca.ptr.pp_complex[i][j];
        }
    }
    ae_matrix_set_length(&ca2, m, n, _state);
    for(i=0; i<=m-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            v = ae_v_cdotproduct(&cl.ptr.pp_complex[i][0], 1, "N", &cu.ptr.pp_complex[0][j], cu.stride, "N", ae_v_len(0,minmn-1));
            ca2.ptr.pp_complex[i][j] = v;
        }
    }
    ae_vector_set_length(&ct, n, _state);
    for(i=minmn-1; i>=0; i--)
    {
        if( i!=p.ptr.p_int[i] )
        {
            ae_v_cmove(&ct.ptr.p_complex[0], 1, &ca2.ptr.pp_complex[i][0], 1, "N", ae_v_len(0,n-1));
            ae_v_cmove(&ca2.ptr.pp_complex[i][0], 1, &ca2.ptr.pp_complex[p.ptr.p_int[i]][0], 1, "N", ae_v_len(0,n-1));
            ae_v_cmove(&ca2.ptr.pp_complex[p.ptr.p_int[i]][0], 1, &ct.ptr.p_complex[0], 1, "N", ae_v_len(0,n-1));
        }
    }
    for(i=0; i<=m-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            *err = *err||ae_fp_greater(ae_c_abs(ae_c_sub(a->ptr.pp_complex[i][j],ca2.ptr.pp_complex[i][j]), _state),threshold);
        }
    }
    
    /*
     * LUP test
     */
    ae_matrix_set_length(&ca, m, n, _state);
    for(i=0; i<=m-1; i++)
    {
        ae_v_cmove(&ca.ptr.pp_complex[i][0], 1, &a->ptr.pp_complex[i][0], 1, "N", ae_v_len(0,n-1));
    }
    cmatrixlup(&ca, m, n, &p, _state);
    for(i=0; i<=minmn-1; i++)
    {
        if( p.ptr.p_int[i]<i||p.ptr.p_int[i]>=n )
        {
            *properr = ae_true;
            ae_frame_leave(_state);
            return;
        }
    }
    ae_matrix_set_length(&cl, m, minmn, _state);
    for(j=0; j<=minmn-1; j++)
    {
        for(i=0; i<=j-1; i++)
        {
            cl.ptr.pp_complex[i][j] = ae_complex_from_d(0.0);
        }
        for(i=j; i<=m-1; i++)
        {
            cl.ptr.pp_complex[i][j] = ca.ptr.pp_complex[i][j];
        }
    }
    ae_matrix_set_length(&cu, minmn, n, _state);
    for(i=0; i<=minmn-1; i++)
    {
        for(j=0; j<=i-1; j++)
        {
            cu.ptr.pp_complex[i][j] = ae_complex_from_d(0.0);
        }
        cu.ptr.pp_complex[i][i] = ae_complex_from_d(1.0);
        for(j=i+1; j<=n-1; j++)
        {
            cu.ptr.pp_complex[i][j] = ca.ptr.pp_complex[i][j];
        }
    }
    ae_matrix_set_length(&ca2, m, n, _state);
    for(i=0; i<=m-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            v = ae_v_cdotproduct(&cl.ptr.pp_complex[i][0], 1, "N", &cu.ptr.pp_complex[0][j], cu.stride, "N", ae_v_len(0,minmn-1));
            ca2.ptr.pp_complex[i][j] = v;
        }
    }
    ae_vector_set_length(&ct, m, _state);
    for(i=minmn-1; i>=0; i--)
    {
        if( i!=p.ptr.p_int[i] )
        {
            ae_v_cmove(&ct.ptr.p_complex[0], 1, &ca2.ptr.pp_complex[0][i], ca2.stride, "N", ae_v_len(0,m-1));
            ae_v_cmove(&ca2.ptr.pp_complex[0][i], ca2.stride, &ca2.ptr.pp_complex[0][p.ptr.p_int[i]], ca2.stride, "N", ae_v_len(0,m-1));
            ae_v_cmove(&ca2.ptr.pp_complex[0][p.ptr.p_int[i]], ca2.stride, &ct.ptr.p_complex[0], 1, "N", ae_v_len(0,m-1));
        }
    }
    for(i=0; i<=m-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            *err = *err||ae_fp_greater(ae_c_abs(ae_c_sub(a->ptr.pp_complex[i][j],ca2.ptr.pp_complex[i][j]), _state),threshold);
        }
    }
    ae_frame_leave(_state);
}


static void testtrfacunit_testrluproblem(/* Real    */ ae_matrix* a,
     ae_int_t m,
     ae_int_t n,
     double threshold,
     ae_bool* err,
     ae_bool* properr,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_matrix ca;
    ae_matrix cl;
    ae_matrix cu;
    ae_matrix ca2;
    ae_vector ct;
    ae_int_t i;
    ae_int_t j;
    ae_int_t minmn;
    double v;
    ae_vector p;

    ae_frame_make(_state, &_frame_block);
    ae_matrix_init(&ca, 0, 0, DT_REAL, _state);
    ae_matrix_init(&cl, 0, 0, DT_REAL, _state);
    ae_matrix_init(&cu, 0, 0, DT_REAL, _state);
    ae_matrix_init(&ca2, 0, 0, DT_REAL, _state);
    ae_vector_init(&ct, 0, DT_REAL, _state);
    ae_vector_init(&p, 0, DT_INT, _state);

    minmn = ae_minint(m, n, _state);
    
    /*
     * PLU test
     */
    ae_matrix_set_length(&ca, m, n, _state);
    for(i=0; i<=m-1; i++)
    {
        ae_v_move(&ca.ptr.pp_double[i][0], 1, &a->ptr.pp_double[i][0], 1, ae_v_len(0,n-1));
    }
    rmatrixplu(&ca, m, n, &p, _state);
    for(i=0; i<=minmn-1; i++)
    {
        if( p.ptr.p_int[i]<i||p.ptr.p_int[i]>=m )
        {
            *properr = ae_true;
            ae_frame_leave(_state);
            return;
        }
    }
    ae_matrix_set_length(&cl, m, minmn, _state);
    for(j=0; j<=minmn-1; j++)
    {
        for(i=0; i<=j-1; i++)
        {
            cl.ptr.pp_double[i][j] = 0.0;
        }
        cl.ptr.pp_double[j][j] = 1.0;
        for(i=j+1; i<=m-1; i++)
        {
            cl.ptr.pp_double[i][j] = ca.ptr.pp_double[i][j];
        }
    }
    ae_matrix_set_length(&cu, minmn, n, _state);
    for(i=0; i<=minmn-1; i++)
    {
        for(j=0; j<=i-1; j++)
        {
            cu.ptr.pp_double[i][j] = 0.0;
        }
        for(j=i; j<=n-1; j++)
        {
            cu.ptr.pp_double[i][j] = ca.ptr.pp_double[i][j];
        }
    }
    ae_matrix_set_length(&ca2, m, n, _state);
    for(i=0; i<=m-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            v = ae_v_dotproduct(&cl.ptr.pp_double[i][0], 1, &cu.ptr.pp_double[0][j], cu.stride, ae_v_len(0,minmn-1));
            ca2.ptr.pp_double[i][j] = v;
        }
    }
    ae_vector_set_length(&ct, n, _state);
    for(i=minmn-1; i>=0; i--)
    {
        if( i!=p.ptr.p_int[i] )
        {
            ae_v_move(&ct.ptr.p_double[0], 1, &ca2.ptr.pp_double[i][0], 1, ae_v_len(0,n-1));
            ae_v_move(&ca2.ptr.pp_double[i][0], 1, &ca2.ptr.pp_double[p.ptr.p_int[i]][0], 1, ae_v_len(0,n-1));
            ae_v_move(&ca2.ptr.pp_double[p.ptr.p_int[i]][0], 1, &ct.ptr.p_double[0], 1, ae_v_len(0,n-1));
        }
    }
    for(i=0; i<=m-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            *err = *err||ae_fp_greater(ae_fabs(a->ptr.pp_double[i][j]-ca2.ptr.pp_double[i][j], _state),threshold);
        }
    }
    
    /*
     * LUP test
     */
    ae_matrix_set_length(&ca, m, n, _state);
    for(i=0; i<=m-1; i++)
    {
        ae_v_move(&ca.ptr.pp_double[i][0], 1, &a->ptr.pp_double[i][0], 1, ae_v_len(0,n-1));
    }
    rmatrixlup(&ca, m, n, &p, _state);
    for(i=0; i<=minmn-1; i++)
    {
        if( p.ptr.p_int[i]<i||p.ptr.p_int[i]>=n )
        {
            *properr = ae_true;
            ae_frame_leave(_state);
            return;
        }
    }
    ae_matrix_set_length(&cl, m, minmn, _state);
    for(j=0; j<=minmn-1; j++)
    {
        for(i=0; i<=j-1; i++)
        {
            cl.ptr.pp_double[i][j] = 0.0;
        }
        for(i=j; i<=m-1; i++)
        {
            cl.ptr.pp_double[i][j] = ca.ptr.pp_double[i][j];
        }
    }
    ae_matrix_set_length(&cu, minmn, n, _state);
    for(i=0; i<=minmn-1; i++)
    {
        for(j=0; j<=i-1; j++)
        {
            cu.ptr.pp_double[i][j] = 0.0;
        }
        cu.ptr.pp_double[i][i] = 1.0;
        for(j=i+1; j<=n-1; j++)
        {
            cu.ptr.pp_double[i][j] = ca.ptr.pp_double[i][j];
        }
    }
    ae_matrix_set_length(&ca2, m, n, _state);
    for(i=0; i<=m-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            v = ae_v_dotproduct(&cl.ptr.pp_double[i][0], 1, &cu.ptr.pp_double[0][j], cu.stride, ae_v_len(0,minmn-1));
            ca2.ptr.pp_double[i][j] = v;
        }
    }
    ae_vector_set_length(&ct, m, _state);
    for(i=minmn-1; i>=0; i--)
    {
        if( i!=p.ptr.p_int[i] )
        {
            ae_v_move(&ct.ptr.p_double[0], 1, &ca2.ptr.pp_double[0][i], ca2.stride, ae_v_len(0,m-1));
            ae_v_move(&ca2.ptr.pp_double[0][i], ca2.stride, &ca2.ptr.pp_double[0][p.ptr.p_int[i]], ca2.stride, ae_v_len(0,m-1));
            ae_v_move(&ca2.ptr.pp_double[0][p.ptr.p_int[i]], ca2.stride, &ct.ptr.p_double[0], 1, ae_v_len(0,m-1));
        }
    }
    for(i=0; i<=m-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            *err = *err||ae_fp_greater(ae_fabs(a->ptr.pp_double[i][j]-ca2.ptr.pp_double[i][j], _state),threshold);
        }
    }
    ae_frame_leave(_state);
}


/*************************************************************************
Function for testing dense Cholesky updates
Sets error flag to True on errors, does not change it on success.

  -- ALGLIB PROJECT --
     Copyright 16.01.1014 by Bochkanov Sergey
*************************************************************************/
static void testtrfacunit_testdensecholeskyupdates(ae_bool* spdupderrorflag,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_int_t n;
    double pfix;
    ae_matrix a0;
    ae_matrix a1;
    ae_vector u;
    ae_vector fix;
    ae_int_t i;
    ae_int_t j;
    ae_bool isupper;
    double tol;
    ae_vector bufr;
    hqrndstate rs;

    ae_frame_make(_state, &_frame_block);
    ae_matrix_init(&a0, 0, 0, DT_REAL, _state);
    ae_matrix_init(&a1, 0, 0, DT_REAL, _state);
    ae_vector_init(&u, 0, DT_REAL, _state);
    ae_vector_init(&fix, 0, DT_BOOL, _state);
    ae_vector_init(&bufr, 0, DT_REAL, _state);
    _hqrndstate_init(&rs, _state);

    hqrndrandomize(&rs, _state);
    
    /*
     * Settings
     */
    tol = 1.0E-8;
    
    /*
     * Test rank-1 updates
     *
     * For each matrix size in 1..30 select sparse update vector with probability of element
     * being non-zero equal to 1/2.
     */
    for(n=1; n<=30; n++)
    {
        
        /*
         * Generate two matrices A0=A1, fill one triangle with SPD matrix,
         * another one with trash. Prepare vector U.
         */
        isupper = ae_fp_less(hqrnduniformr(&rs, _state),0.5);
        spdmatrixrndcond(n, 1.0E4, &a0, _state);
        for(i=0; i<=n-1; i++)
        {
            for(j=0; j<=n-1; j++)
            {
                if( (j<i&&isupper)||(j>i&&!isupper) )
                {
                    a0.ptr.pp_double[i][j] = hqrnduniformr(&rs, _state)-0.5;
                }
            }
        }
        ae_matrix_set_length(&a1, n, n, _state);
        for(i=0; i<=n-1; i++)
        {
            for(j=0; j<=n-1; j++)
            {
                a1.ptr.pp_double[i][j] = a0.ptr.pp_double[i][j];
            }
        }
        ae_vector_set_length(&u, n, _state);
        for(i=0; i<=n-1; i++)
        {
            if( ae_fp_less_eq(hqrnduniformr(&rs, _state),0.5) )
            {
                u.ptr.p_double[i] = hqrnduniformr(&rs, _state)-0.5;
            }
            else
            {
                u.ptr.p_double[i] = (double)(0);
            }
        }
        
        /*
         * Factorize and compare:
         * * A0 is factorized as follows: first with full Cholesky, then
         *   we call SPDMatrixCholeskyUpdateAdd1
         * * A1 is transformed explicitly before factorization with full Cholesky
         *
         * We randomly test either SPDMatrixCholeskyUpdateFix() or its
         * buffered version, SPDMatrixCholeskyUpdateFixBuf()
         */
        seterrorflag(spdupderrorflag, !spdmatrixcholesky(&a0, n, isupper, _state), _state);
        if( *spdupderrorflag )
        {
            ae_frame_leave(_state);
            return;
        }
        if( ae_fp_less(hqrnduniformr(&rs, _state),0.5) )
        {
            spdmatrixcholeskyupdateadd1(&a0, n, isupper, &u, _state);
        }
        else
        {
            spdmatrixcholeskyupdateadd1buf(&a0, n, isupper, &u, &bufr, _state);
        }
        for(i=0; i<=n-1; i++)
        {
            for(j=0; j<=n-1; j++)
            {
                if( (j>=i&&isupper)||(j<=i&&!isupper) )
                {
                    a1.ptr.pp_double[i][j] = a1.ptr.pp_double[i][j]+u.ptr.p_double[i]*u.ptr.p_double[j];
                }
            }
        }
        seterrorflag(spdupderrorflag, !spdmatrixcholesky(&a1, n, isupper, _state), _state);
        if( *spdupderrorflag )
        {
            ae_frame_leave(_state);
            return;
        }
        for(i=0; i<=n-1; i++)
        {
            for(j=0; j<=n-1; j++)
            {
                seterrorflag(spdupderrorflag, ae_fp_greater(ae_fabs(a0.ptr.pp_double[i][j]-a1.ptr.pp_double[i][j], _state),tol), _state);
            }
        }
    }
    
    /*
     * Test variable fixing functions.
     *
     * For each matrix size in 1..30 select PFix - probability of each variable being fixed,
     * and perform test.
     */
    for(n=1; n<=30; n++)
    {
        
        /*
         * Generate two matrices A0=A1, fill one triangle with SPD matrix,
         * another one with trash. Prepare vector Fix.
         */
        pfix = (double)hqrnduniformi(&rs, n+1, _state)/(double)n;
        isupper = ae_fp_less(hqrnduniformr(&rs, _state),0.5);
        spdmatrixrndcond(n, 1.0E4, &a0, _state);
        for(i=0; i<=n-1; i++)
        {
            for(j=0; j<=n-1; j++)
            {
                if( (j<i&&isupper)||(j>i&&!isupper) )
                {
                    a0.ptr.pp_double[i][j] = hqrnduniformr(&rs, _state)-0.5;
                }
            }
        }
        ae_matrix_set_length(&a1, n, n, _state);
        for(i=0; i<=n-1; i++)
        {
            for(j=0; j<=n-1; j++)
            {
                a1.ptr.pp_double[i][j] = a0.ptr.pp_double[i][j];
            }
        }
        ae_vector_set_length(&fix, n, _state);
        for(i=0; i<=n-1; i++)
        {
            fix.ptr.p_bool[i] = ae_fp_less_eq(hqrnduniformr(&rs, _state),pfix);
        }
        
        /*
         * Factorize and compare:
         * * A0 is factorized as follows: first with full Cholesky, then
         *   variables are fixed with SPDMatrixCholeskyUpdateFix
         * * A1 is fixed explicitly before factorization with full Cholesky
         *
         * We randomly test either SPDMatrixCholeskyUpdateFix() or its
         * buffered version, SPDMatrixCholeskyUpdateFixBuf()
         */
        seterrorflag(spdupderrorflag, !spdmatrixcholesky(&a0, n, isupper, _state), _state);
        if( *spdupderrorflag )
        {
            ae_frame_leave(_state);
            return;
        }
        if( ae_fp_less(hqrnduniformr(&rs, _state),0.5) )
        {
            spdmatrixcholeskyupdatefixbuf(&a0, n, isupper, &fix, &bufr, _state);
        }
        else
        {
            spdmatrixcholeskyupdatefix(&a0, n, isupper, &fix, _state);
        }
        for(i=0; i<=n-1; i++)
        {
            for(j=0; j<=n-1; j++)
            {
                if( (j>=i&&isupper)||(j<=i&&!isupper) )
                {
                    if( fix.ptr.p_bool[i]||fix.ptr.p_bool[j] )
                    {
                        if( i==j )
                        {
                            a1.ptr.pp_double[i][j] = (double)(1);
                        }
                        else
                        {
                            a1.ptr.pp_double[i][j] = (double)(0);
                        }
                    }
                }
            }
        }
        seterrorflag(spdupderrorflag, !spdmatrixcholesky(&a1, n, isupper, _state), _state);
        if( *spdupderrorflag )
        {
            ae_frame_leave(_state);
            return;
        }
        for(i=0; i<=n-1; i++)
        {
            for(j=0; j<=n-1; j++)
            {
                seterrorflag(spdupderrorflag, ae_fp_greater(ae_fabs(a0.ptr.pp_double[i][j]-a1.ptr.pp_double[i][j], _state),tol), _state);
            }
        }
    }
    ae_frame_leave(_state);
}



static void testtrlinsolveunit_makeacopy(/* Real    */ ae_matrix* a,
     ae_int_t m,
     ae_int_t n,
     /* Real    */ ae_matrix* b,
     ae_state *_state);





/*************************************************************************
Main unittest subroutine
*************************************************************************/
ae_bool testtrlinsolve(ae_bool silent, ae_state *_state)
{
    ae_frame _frame_block;
    ae_int_t maxmn;
    ae_int_t passcount;
    double threshold;
    ae_matrix aeffective;
    ae_matrix aparam;
    ae_vector xe;
    ae_vector b;
    ae_int_t n;
    ae_int_t pass;
    ae_int_t i;
    ae_int_t j;
    ae_int_t cnts;
    ae_int_t cntu;
    ae_int_t cntt;
    ae_int_t cntm;
    ae_bool waserrors;
    ae_bool isupper;
    ae_bool istrans;
    ae_bool isunit;
    double v;
    double s;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    ae_matrix_init(&aeffective, 0, 0, DT_REAL, _state);
    ae_matrix_init(&aparam, 0, 0, DT_REAL, _state);
    ae_vector_init(&xe, 0, DT_REAL, _state);
    ae_vector_init(&b, 0, DT_REAL, _state);

    waserrors = ae_false;
    maxmn = 15;
    passcount = 15;
    threshold = 1000*ae_machineepsilon;
    
    /*
     * Different problems
     */
    for(n=1; n<=maxmn; n++)
    {
        ae_matrix_set_length(&aeffective, n-1+1, n-1+1, _state);
        ae_matrix_set_length(&aparam, n-1+1, n-1+1, _state);
        ae_vector_set_length(&xe, n-1+1, _state);
        ae_vector_set_length(&b, n-1+1, _state);
        for(pass=1; pass<=passcount; pass++)
        {
            for(cnts=0; cnts<=1; cnts++)
            {
                for(cntu=0; cntu<=1; cntu++)
                {
                    for(cntt=0; cntt<=1; cntt++)
                    {
                        for(cntm=0; cntm<=2; cntm++)
                        {
                            isupper = cnts==0;
                            isunit = cntu==0;
                            istrans = cntt==0;
                            
                            /*
                             * Skip meaningless combinations of parameters:
                             * (matrix is singular) AND (matrix is unit diagonal)
                             */
                            if( cntm==2&&isunit )
                            {
                                continue;
                            }
                            
                            /*
                             * Clear matrices
                             */
                            for(i=0; i<=n-1; i++)
                            {
                                for(j=0; j<=n-1; j++)
                                {
                                    aeffective.ptr.pp_double[i][j] = (double)(0);
                                    aparam.ptr.pp_double[i][j] = (double)(0);
                                }
                            }
                            
                            /*
                             * Prepare matrices
                             */
                            if( isupper )
                            {
                                for(i=0; i<=n-1; i++)
                                {
                                    for(j=i; j<=n-1; j++)
                                    {
                                        aeffective.ptr.pp_double[i][j] = 0.9*(2*ae_randomreal(_state)-1);
                                        aparam.ptr.pp_double[i][j] = aeffective.ptr.pp_double[i][j];
                                    }
                                    aeffective.ptr.pp_double[i][i] = (2*ae_randominteger(2, _state)-1)*(0.8+ae_randomreal(_state));
                                    aparam.ptr.pp_double[i][i] = aeffective.ptr.pp_double[i][i];
                                }
                            }
                            else
                            {
                                for(i=0; i<=n-1; i++)
                                {
                                    for(j=0; j<=i; j++)
                                    {
                                        aeffective.ptr.pp_double[i][j] = 0.9*(2*ae_randomreal(_state)-1);
                                        aparam.ptr.pp_double[i][j] = aeffective.ptr.pp_double[i][j];
                                    }
                                    aeffective.ptr.pp_double[i][i] = (2*ae_randominteger(2, _state)-1)*(0.8+ae_randomreal(_state));
                                    aparam.ptr.pp_double[i][i] = aeffective.ptr.pp_double[i][i];
                                }
                            }
                            if( isunit )
                            {
                                for(i=0; i<=n-1; i++)
                                {
                                    aeffective.ptr.pp_double[i][i] = (double)(1);
                                    aparam.ptr.pp_double[i][i] = (double)(0);
                                }
                            }
                            if( istrans )
                            {
                                if( isupper )
                                {
                                    for(i=0; i<=n-1; i++)
                                    {
                                        for(j=i+1; j<=n-1; j++)
                                        {
                                            aeffective.ptr.pp_double[j][i] = aeffective.ptr.pp_double[i][j];
                                            aeffective.ptr.pp_double[i][j] = (double)(0);
                                        }
                                    }
                                }
                                else
                                {
                                    for(i=0; i<=n-1; i++)
                                    {
                                        for(j=i+1; j<=n-1; j++)
                                        {
                                            aeffective.ptr.pp_double[i][j] = aeffective.ptr.pp_double[j][i];
                                            aeffective.ptr.pp_double[j][i] = (double)(0);
                                        }
                                    }
                                }
                            }
                            
                            /*
                             * Prepare task, solve, compare
                             */
                            for(i=0; i<=n-1; i++)
                            {
                                xe.ptr.p_double[i] = 2*ae_randomreal(_state)-1;
                            }
                            for(i=0; i<=n-1; i++)
                            {
                                v = ae_v_dotproduct(&aeffective.ptr.pp_double[i][0], 1, &xe.ptr.p_double[0], 1, ae_v_len(0,n-1));
                                b.ptr.p_double[i] = v;
                            }
                            rmatrixtrsafesolve(&aparam, n, &b, &s, isupper, istrans, isunit, _state);
                            ae_v_muld(&xe.ptr.p_double[0], 1, ae_v_len(0,n-1), s);
                            ae_v_sub(&xe.ptr.p_double[0], 1, &b.ptr.p_double[0], 1, ae_v_len(0,n-1));
                            v = ae_v_dotproduct(&xe.ptr.p_double[0], 1, &xe.ptr.p_double[0], 1, ae_v_len(0,n-1));
                            v = ae_sqrt(v, _state);
                            waserrors = waserrors||ae_fp_greater(v,threshold);
                        }
                    }
                }
            }
        }
    }
    
    /*
     * report
     */
    if( !silent )
    {
        printf("TESTING RMatrixTRSafeSolve\n");
        if( waserrors )
        {
            printf("TEST FAILED\n");
        }
        else
        {
            printf("TEST PASSED\n");
        }
        printf("\n\n");
    }
    result = !waserrors;
    ae_frame_leave(_state);
    return result;
}


/*************************************************************************
Single-threaded stub. HPC ALGLIB replaces it by multithreaded code.
*************************************************************************/
ae_bool _pexec_testtrlinsolve(ae_bool silent, ae_state *_state)
{
    return testtrlinsolve(silent, _state);
}


/*************************************************************************
Copy
*************************************************************************/
static void testtrlinsolveunit_makeacopy(/* Real    */ ae_matrix* a,
     ae_int_t m,
     ae_int_t n,
     /* Real    */ ae_matrix* b,
     ae_state *_state)
{
    ae_int_t i;
    ae_int_t j;

    ae_matrix_clear(b);

    ae_matrix_set_length(b, m-1+1, n-1+1, _state);
    for(i=0; i<=m-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            b->ptr.pp_double[i][j] = a->ptr.pp_double[i][j];
        }
    }
}



static void testsafesolveunit_rmatrixmakeacopy(/* Real    */ ae_matrix* a,
     ae_int_t m,
     ae_int_t n,
     /* Real    */ ae_matrix* b,
     ae_state *_state);
static void testsafesolveunit_cmatrixmakeacopy(/* Complex */ ae_matrix* a,
     ae_int_t m,
     ae_int_t n,
     /* Complex */ ae_matrix* b,
     ae_state *_state);





/*************************************************************************
Main unittest subroutine
*************************************************************************/
ae_bool testsafesolve(ae_bool silent, ae_state *_state)
{
    ae_frame _frame_block;
    ae_int_t maxmn;
    double threshold;
    ae_bool rerrors;
    ae_bool cerrors;
    ae_bool waserrors;
    ae_bool isupper;
    ae_int_t trans;
    ae_bool isunit;
    double scalea;
    double growth;
    ae_int_t i;
    ae_int_t j;
    ae_int_t n;
    ae_int_t j1;
    ae_int_t j2;
    ae_complex cv;
    ae_matrix ca;
    ae_matrix cea;
    ae_matrix ctmpa;
    ae_vector cxs;
    ae_vector cxe;
    double rv;
    ae_matrix ra;
    ae_matrix rea;
    ae_matrix rtmpa;
    ae_vector rxs;
    ae_vector rxe;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    ae_matrix_init(&ca, 0, 0, DT_COMPLEX, _state);
    ae_matrix_init(&cea, 0, 0, DT_COMPLEX, _state);
    ae_matrix_init(&ctmpa, 0, 0, DT_COMPLEX, _state);
    ae_vector_init(&cxs, 0, DT_COMPLEX, _state);
    ae_vector_init(&cxe, 0, DT_COMPLEX, _state);
    ae_matrix_init(&ra, 0, 0, DT_REAL, _state);
    ae_matrix_init(&rea, 0, 0, DT_REAL, _state);
    ae_matrix_init(&rtmpa, 0, 0, DT_REAL, _state);
    ae_vector_init(&rxs, 0, DT_REAL, _state);
    ae_vector_init(&rxe, 0, DT_REAL, _state);

    maxmn = 30;
    threshold = 100000*ae_machineepsilon;
    rerrors = ae_false;
    cerrors = ae_false;
    waserrors = ae_false;
    
    /*
     * Different problems: general tests
     */
    for(n=1; n<=maxmn; n++)
    {
        
        /*
         * test complex solver with well-conditioned matrix:
         * 1. generate A: fill off-diagonal elements with small values,
         *    diagonal elements are filled with larger values
         * 2. generate 'effective' A
         * 3. prepare task (exact X is stored in CXE, right part - in CXS),
         *    solve and compare CXS and CXE
         */
        isupper = ae_fp_greater(ae_randomreal(_state),0.5);
        trans = ae_randominteger(3, _state);
        isunit = ae_fp_greater(ae_randomreal(_state),0.5);
        scalea = ae_randomreal(_state)+0.5;
        ae_matrix_set_length(&ca, n, n, _state);
        for(i=0; i<=n-1; i++)
        {
            for(j=0; j<=n-1; j++)
            {
                if( i==j )
                {
                    ca.ptr.pp_complex[i][j].x = (2*ae_randominteger(2, _state)-1)*(5+ae_randomreal(_state));
                    ca.ptr.pp_complex[i][j].y = (2*ae_randominteger(2, _state)-1)*(5+ae_randomreal(_state));
                }
                else
                {
                    ca.ptr.pp_complex[i][j].x = 0.2*ae_randomreal(_state)-0.1;
                    ca.ptr.pp_complex[i][j].y = 0.2*ae_randomreal(_state)-0.1;
                }
            }
        }
        testsafesolveunit_cmatrixmakeacopy(&ca, n, n, &ctmpa, _state);
        for(i=0; i<=n-1; i++)
        {
            if( isupper )
            {
                j1 = 0;
                j2 = i-1;
            }
            else
            {
                j1 = i+1;
                j2 = n-1;
            }
            for(j=j1; j<=j2; j++)
            {
                ctmpa.ptr.pp_complex[i][j] = ae_complex_from_i(0);
            }
            if( isunit )
            {
                ctmpa.ptr.pp_complex[i][i] = ae_complex_from_i(1);
            }
        }
        ae_matrix_set_length(&cea, n, n, _state);
        for(i=0; i<=n-1; i++)
        {
            if( trans==0 )
            {
                ae_v_cmoved(&cea.ptr.pp_complex[i][0], 1, &ctmpa.ptr.pp_complex[i][0], 1, "N", ae_v_len(0,n-1), scalea);
            }
            if( trans==1 )
            {
                ae_v_cmoved(&cea.ptr.pp_complex[0][i], cea.stride, &ctmpa.ptr.pp_complex[i][0], 1, "N", ae_v_len(0,n-1), scalea);
            }
            if( trans==2 )
            {
                ae_v_cmoved(&cea.ptr.pp_complex[0][i], cea.stride, &ctmpa.ptr.pp_complex[i][0], 1, "Conj", ae_v_len(0,n-1), scalea);
            }
        }
        ae_vector_set_length(&cxe, n, _state);
        for(i=0; i<=n-1; i++)
        {
            cxe.ptr.p_complex[i].x = 2*ae_randomreal(_state)-1;
            cxe.ptr.p_complex[i].y = 2*ae_randomreal(_state)-1;
        }
        ae_vector_set_length(&cxs, n, _state);
        for(i=0; i<=n-1; i++)
        {
            cv = ae_v_cdotproduct(&cea.ptr.pp_complex[i][0], 1, "N", &cxe.ptr.p_complex[0], 1, "N", ae_v_len(0,n-1));
            cxs.ptr.p_complex[i] = cv;
        }
        if( cmatrixscaledtrsafesolve(&ca, scalea, n, &cxs, isupper, trans, isunit, ae_sqrt(ae_maxrealnumber, _state), _state) )
        {
            for(i=0; i<=n-1; i++)
            {
                cerrors = cerrors||ae_fp_greater(ae_c_abs(ae_c_sub(cxs.ptr.p_complex[i],cxe.ptr.p_complex[i]), _state),threshold);
            }
        }
        else
        {
            cerrors = ae_true;
        }
        
        /*
         * same with real
         */
        isupper = ae_fp_greater(ae_randomreal(_state),0.5);
        trans = ae_randominteger(2, _state);
        isunit = ae_fp_greater(ae_randomreal(_state),0.5);
        scalea = ae_randomreal(_state)+0.5;
        ae_matrix_set_length(&ra, n, n, _state);
        for(i=0; i<=n-1; i++)
        {
            for(j=0; j<=n-1; j++)
            {
                if( i==j )
                {
                    ra.ptr.pp_double[i][j] = (2*ae_randominteger(2, _state)-1)*(5+ae_randomreal(_state));
                }
                else
                {
                    ra.ptr.pp_double[i][j] = 0.2*ae_randomreal(_state)-0.1;
                }
            }
        }
        testsafesolveunit_rmatrixmakeacopy(&ra, n, n, &rtmpa, _state);
        for(i=0; i<=n-1; i++)
        {
            if( isupper )
            {
                j1 = 0;
                j2 = i-1;
            }
            else
            {
                j1 = i+1;
                j2 = n-1;
            }
            for(j=j1; j<=j2; j++)
            {
                rtmpa.ptr.pp_double[i][j] = (double)(0);
            }
            if( isunit )
            {
                rtmpa.ptr.pp_double[i][i] = (double)(1);
            }
        }
        ae_matrix_set_length(&rea, n, n, _state);
        for(i=0; i<=n-1; i++)
        {
            if( trans==0 )
            {
                ae_v_moved(&rea.ptr.pp_double[i][0], 1, &rtmpa.ptr.pp_double[i][0], 1, ae_v_len(0,n-1), scalea);
            }
            if( trans==1 )
            {
                ae_v_moved(&rea.ptr.pp_double[0][i], rea.stride, &rtmpa.ptr.pp_double[i][0], 1, ae_v_len(0,n-1), scalea);
            }
        }
        ae_vector_set_length(&rxe, n, _state);
        for(i=0; i<=n-1; i++)
        {
            rxe.ptr.p_double[i] = 2*ae_randomreal(_state)-1;
        }
        ae_vector_set_length(&rxs, n, _state);
        for(i=0; i<=n-1; i++)
        {
            rv = ae_v_dotproduct(&rea.ptr.pp_double[i][0], 1, &rxe.ptr.p_double[0], 1, ae_v_len(0,n-1));
            rxs.ptr.p_double[i] = rv;
        }
        if( rmatrixscaledtrsafesolve(&ra, scalea, n, &rxs, isupper, trans, isunit, ae_sqrt(ae_maxrealnumber, _state), _state) )
        {
            for(i=0; i<=n-1; i++)
            {
                rerrors = rerrors||ae_fp_greater(ae_fabs(rxs.ptr.p_double[i]-rxe.ptr.p_double[i], _state),threshold);
            }
        }
        else
        {
            rerrors = ae_true;
        }
    }
    
    /*
     * Special test with diagonal ill-conditioned matrix:
     * * ability to solve it when resulting growth is less than threshold
     * * ability to stop solve when resulting growth is greater than threshold
     *
     * A = diag(1, 1/growth)
     * b = (1, 0.5)
     */
    n = 2;
    growth = (double)(10);
    ae_matrix_set_length(&ca, n, n, _state);
    ca.ptr.pp_complex[0][0] = ae_complex_from_i(1);
    ca.ptr.pp_complex[0][1] = ae_complex_from_i(0);
    ca.ptr.pp_complex[1][0] = ae_complex_from_i(0);
    ca.ptr.pp_complex[1][1] = ae_complex_from_d(1/growth);
    ae_vector_set_length(&cxs, n, _state);
    cxs.ptr.p_complex[0] = ae_complex_from_d(1.0);
    cxs.ptr.p_complex[1] = ae_complex_from_d(0.5);
    cerrors = cerrors||!cmatrixscaledtrsafesolve(&ca, 1.0, n, &cxs, ae_fp_greater(ae_randomreal(_state),0.5), ae_randominteger(3, _state), ae_false, 1.05*ae_maxreal(ae_c_abs(cxs.ptr.p_complex[1], _state)*growth, 1.0, _state), _state);
    cerrors = cerrors||!cmatrixscaledtrsafesolve(&ca, 1.0, n, &cxs, ae_fp_greater(ae_randomreal(_state),0.5), ae_randominteger(3, _state), ae_false, 0.95*ae_maxreal(ae_c_abs(cxs.ptr.p_complex[1], _state)*growth, 1.0, _state), _state);
    ae_matrix_set_length(&ra, n, n, _state);
    ra.ptr.pp_double[0][0] = (double)(1);
    ra.ptr.pp_double[0][1] = (double)(0);
    ra.ptr.pp_double[1][0] = (double)(0);
    ra.ptr.pp_double[1][1] = 1/growth;
    ae_vector_set_length(&rxs, n, _state);
    rxs.ptr.p_double[0] = 1.0;
    rxs.ptr.p_double[1] = 0.5;
    rerrors = rerrors||!rmatrixscaledtrsafesolve(&ra, 1.0, n, &rxs, ae_fp_greater(ae_randomreal(_state),0.5), ae_randominteger(2, _state), ae_false, 1.05*ae_maxreal(ae_fabs(rxs.ptr.p_double[1], _state)*growth, 1.0, _state), _state);
    rerrors = rerrors||!rmatrixscaledtrsafesolve(&ra, 1.0, n, &rxs, ae_fp_greater(ae_randomreal(_state),0.5), ae_randominteger(2, _state), ae_false, 0.95*ae_maxreal(ae_fabs(rxs.ptr.p_double[1], _state)*growth, 1.0, _state), _state);
    
    /*
     * Special test with diagonal degenerate matrix:
     * * ability to solve it when resulting growth is less than threshold
     * * ability to stop solve when resulting growth is greater than threshold
     *
     * A = diag(1, 0)
     * b = (1, 0.5)
     */
    n = 2;
    ae_matrix_set_length(&ca, n, n, _state);
    ca.ptr.pp_complex[0][0] = ae_complex_from_i(1);
    ca.ptr.pp_complex[0][1] = ae_complex_from_i(0);
    ca.ptr.pp_complex[1][0] = ae_complex_from_i(0);
    ca.ptr.pp_complex[1][1] = ae_complex_from_i(0);
    ae_vector_set_length(&cxs, n, _state);
    cxs.ptr.p_complex[0] = ae_complex_from_d(1.0);
    cxs.ptr.p_complex[1] = ae_complex_from_d(0.5);
    cerrors = cerrors||cmatrixscaledtrsafesolve(&ca, 1.0, n, &cxs, ae_fp_greater(ae_randomreal(_state),0.5), ae_randominteger(3, _state), ae_false, ae_sqrt(ae_maxrealnumber, _state), _state);
    ae_matrix_set_length(&ra, n, n, _state);
    ra.ptr.pp_double[0][0] = (double)(1);
    ra.ptr.pp_double[0][1] = (double)(0);
    ra.ptr.pp_double[1][0] = (double)(0);
    ra.ptr.pp_double[1][1] = (double)(0);
    ae_vector_set_length(&rxs, n, _state);
    rxs.ptr.p_double[0] = 1.0;
    rxs.ptr.p_double[1] = 0.5;
    rerrors = rerrors||rmatrixscaledtrsafesolve(&ra, 1.0, n, &rxs, ae_fp_greater(ae_randomreal(_state),0.5), ae_randominteger(2, _state), ae_false, ae_sqrt(ae_maxrealnumber, _state), _state);
    
    /*
     * report
     */
    waserrors = rerrors||cerrors;
    if( !silent )
    {
        printf("TESTING SAFE TR SOLVER\n");
        printf("REAL:                                    ");
        if( !rerrors )
        {
            printf("OK\n");
        }
        else
        {
            printf("FAILED\n");
        }
        printf("COMPLEX:                                 ");
        if( !cerrors )
        {
            printf("OK\n");
        }
        else
        {
            printf("FAILED\n");
        }
        if( waserrors )
        {
            printf("TEST FAILED\n");
        }
        else
        {
            printf("TEST PASSED\n");
        }
        printf("\n\n");
    }
    result = !waserrors;
    ae_frame_leave(_state);
    return result;
}


/*************************************************************************
Single-threaded stub. HPC ALGLIB replaces it by multithreaded code.
*************************************************************************/
ae_bool _pexec_testsafesolve(ae_bool silent, ae_state *_state)
{
    return testsafesolve(silent, _state);
}


/*************************************************************************
Copy
*************************************************************************/
static void testsafesolveunit_rmatrixmakeacopy(/* Real    */ ae_matrix* a,
     ae_int_t m,
     ae_int_t n,
     /* Real    */ ae_matrix* b,
     ae_state *_state)
{
    ae_int_t i;
    ae_int_t j;

    ae_matrix_clear(b);

    ae_matrix_set_length(b, m-1+1, n-1+1, _state);
    for(i=0; i<=m-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            b->ptr.pp_double[i][j] = a->ptr.pp_double[i][j];
        }
    }
}


/*************************************************************************
Copy
*************************************************************************/
static void testsafesolveunit_cmatrixmakeacopy(/* Complex */ ae_matrix* a,
     ae_int_t m,
     ae_int_t n,
     /* Complex */ ae_matrix* b,
     ae_state *_state)
{
    ae_int_t i;
    ae_int_t j;

    ae_matrix_clear(b);

    ae_matrix_set_length(b, m-1+1, n-1+1, _state);
    for(i=0; i<=m-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            b->ptr.pp_complex[i][j] = a->ptr.pp_complex[i][j];
        }
    }
}



static double testrcondunit_threshold50 = 0.25;
static double testrcondunit_threshold90 = 0.10;
static void testrcondunit_rmatrixmakeacopy(/* Real    */ ae_matrix* a,
     ae_int_t m,
     ae_int_t n,
     /* Real    */ ae_matrix* b,
     ae_state *_state);
static void testrcondunit_rmatrixdrophalf(/* Real    */ ae_matrix* a,
     ae_int_t n,
     ae_bool droplower,
     ae_state *_state);
static void testrcondunit_cmatrixdrophalf(/* Complex */ ae_matrix* a,
     ae_int_t n,
     ae_bool droplower,
     ae_state *_state);
static void testrcondunit_rmatrixgenzero(/* Real    */ ae_matrix* a0,
     ae_int_t n,
     ae_state *_state);
static ae_bool testrcondunit_rmatrixinvmattr(/* Real    */ ae_matrix* a,
     ae_int_t n,
     ae_bool isupper,
     ae_bool isunittriangular,
     ae_state *_state);
static ae_bool testrcondunit_rmatrixinvmatlu(/* Real    */ ae_matrix* a,
     /* Integer */ ae_vector* pivots,
     ae_int_t n,
     ae_state *_state);
static ae_bool testrcondunit_rmatrixinvmat(/* Real    */ ae_matrix* a,
     ae_int_t n,
     ae_state *_state);
static void testrcondunit_rmatrixrefrcond(/* Real    */ ae_matrix* a,
     ae_int_t n,
     double* rc1,
     double* rcinf,
     ae_state *_state);
static void testrcondunit_cmatrixmakeacopy(/* Complex */ ae_matrix* a,
     ae_int_t m,
     ae_int_t n,
     /* Complex */ ae_matrix* b,
     ae_state *_state);
static void testrcondunit_cmatrixgenzero(/* Complex */ ae_matrix* a0,
     ae_int_t n,
     ae_state *_state);
static ae_bool testrcondunit_cmatrixinvmattr(/* Complex */ ae_matrix* a,
     ae_int_t n,
     ae_bool isupper,
     ae_bool isunittriangular,
     ae_state *_state);
static ae_bool testrcondunit_cmatrixinvmatlu(/* Complex */ ae_matrix* a,
     /* Integer */ ae_vector* pivots,
     ae_int_t n,
     ae_state *_state);
static ae_bool testrcondunit_cmatrixinvmat(/* Complex */ ae_matrix* a,
     ae_int_t n,
     ae_state *_state);
static void testrcondunit_cmatrixrefrcond(/* Complex */ ae_matrix* a,
     ae_int_t n,
     double* rc1,
     double* rcinf,
     ae_state *_state);
static ae_bool testrcondunit_testrmatrixtrrcond(ae_int_t maxn,
     ae_int_t passcount,
     ae_state *_state);
static ae_bool testrcondunit_testcmatrixtrrcond(ae_int_t maxn,
     ae_int_t passcount,
     ae_state *_state);
static ae_bool testrcondunit_testrmatrixrcond(ae_int_t maxn,
     ae_int_t passcount,
     ae_state *_state);
static ae_bool testrcondunit_testspdmatrixrcond(ae_int_t maxn,
     ae_int_t passcount,
     ae_state *_state);
static ae_bool testrcondunit_testcmatrixrcond(ae_int_t maxn,
     ae_int_t passcount,
     ae_state *_state);
static ae_bool testrcondunit_testhpdmatrixrcond(ae_int_t maxn,
     ae_int_t passcount,
     ae_state *_state);





ae_bool testrcond(ae_bool silent, ae_state *_state)
{
    ae_int_t maxn;
    ae_int_t passcount;
    ae_bool waserrors;
    ae_bool rtrerr;
    ae_bool ctrerr;
    ae_bool rerr;
    ae_bool cerr;
    ae_bool spderr;
    ae_bool hpderr;
    ae_bool result;


    maxn = 10;
    passcount = 100;
    
    /*
     * report
     */
    rtrerr = !testrcondunit_testrmatrixtrrcond(maxn, passcount, _state);
    ctrerr = !testrcondunit_testcmatrixtrrcond(maxn, passcount, _state);
    rerr = !testrcondunit_testrmatrixrcond(maxn, passcount, _state);
    cerr = !testrcondunit_testcmatrixrcond(maxn, passcount, _state);
    spderr = !testrcondunit_testspdmatrixrcond(maxn, passcount, _state);
    hpderr = !testrcondunit_testhpdmatrixrcond(maxn, passcount, _state);
    waserrors = ((((rtrerr||ctrerr)||rerr)||cerr)||spderr)||hpderr;
    if( !silent )
    {
        printf("TESTING RCOND\n");
        printf("REAL TRIANGULAR:                         ");
        if( !rtrerr )
        {
            printf("OK\n");
        }
        else
        {
            printf("FAILED\n");
        }
        printf("COMPLEX TRIANGULAR:                      ");
        if( !ctrerr )
        {
            printf("OK\n");
        }
        else
        {
            printf("FAILED\n");
        }
        printf("REAL:                                    ");
        if( !rerr )
        {
            printf("OK\n");
        }
        else
        {
            printf("FAILED\n");
        }
        printf("SPD:                                     ");
        if( !spderr )
        {
            printf("OK\n");
        }
        else
        {
            printf("FAILED\n");
        }
        printf("HPD:                                     ");
        if( !hpderr )
        {
            printf("OK\n");
        }
        else
        {
            printf("FAILED\n");
        }
        printf("COMPLEX:                                 ");
        if( !cerr )
        {
            printf("OK\n");
        }
        else
        {
            printf("FAILED\n");
        }
        if( waserrors )
        {
            printf("TEST FAILED\n");
        }
        else
        {
            printf("TEST PASSED\n");
        }
        printf("\n\n");
    }
    result = !waserrors;
    return result;
}


/*************************************************************************
Single-threaded stub. HPC ALGLIB replaces it by multithreaded code.
*************************************************************************/
ae_bool _pexec_testrcond(ae_bool silent, ae_state *_state)
{
    return testrcond(silent, _state);
}


/*************************************************************************
Copy
*************************************************************************/
static void testrcondunit_rmatrixmakeacopy(/* Real    */ ae_matrix* a,
     ae_int_t m,
     ae_int_t n,
     /* Real    */ ae_matrix* b,
     ae_state *_state)
{
    ae_int_t i;
    ae_int_t j;

    ae_matrix_clear(b);

    ae_matrix_set_length(b, m-1+1, n-1+1, _state);
    for(i=0; i<=m-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            b->ptr.pp_double[i][j] = a->ptr.pp_double[i][j];
        }
    }
}


/*************************************************************************
Drops upper or lower half of the matrix - fills it by special pattern
which may be used later to ensure that this part wasn't changed
*************************************************************************/
static void testrcondunit_rmatrixdrophalf(/* Real    */ ae_matrix* a,
     ae_int_t n,
     ae_bool droplower,
     ae_state *_state)
{
    ae_int_t i;
    ae_int_t j;


    for(i=0; i<=n-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            if( (droplower&&i>j)||(!droplower&&i<j) )
            {
                a->ptr.pp_double[i][j] = (double)(1+2*i+3*j);
            }
        }
    }
}


/*************************************************************************
Drops upper or lower half of the matrix - fills it by special pattern
which may be used later to ensure that this part wasn't changed
*************************************************************************/
static void testrcondunit_cmatrixdrophalf(/* Complex */ ae_matrix* a,
     ae_int_t n,
     ae_bool droplower,
     ae_state *_state)
{
    ae_int_t i;
    ae_int_t j;


    for(i=0; i<=n-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            if( (droplower&&i>j)||(!droplower&&i<j) )
            {
                a->ptr.pp_complex[i][j] = ae_complex_from_i(1+2*i+3*j);
            }
        }
    }
}


/*************************************************************************
Generate matrix with given condition number C (2-norm)
*************************************************************************/
static void testrcondunit_rmatrixgenzero(/* Real    */ ae_matrix* a0,
     ae_int_t n,
     ae_state *_state)
{
    ae_int_t i;
    ae_int_t j;


    ae_matrix_set_length(a0, n, n, _state);
    for(i=0; i<=n-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            a0->ptr.pp_double[i][j] = (double)(0);
        }
    }
}


/*************************************************************************
triangular inverse
*************************************************************************/
static ae_bool testrcondunit_rmatrixinvmattr(/* Real    */ ae_matrix* a,
     ae_int_t n,
     ae_bool isupper,
     ae_bool isunittriangular,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_bool nounit;
    ae_int_t i;
    ae_int_t j;
    double v;
    double ajj;
    ae_vector t;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    ae_vector_init(&t, 0, DT_REAL, _state);

    result = ae_true;
    ae_vector_set_length(&t, n-1+1, _state);
    
    /*
     * Test the input parameters.
     */
    nounit = !isunittriangular;
    if( isupper )
    {
        
        /*
         * Compute inverse of upper triangular matrix.
         */
        for(j=0; j<=n-1; j++)
        {
            if( nounit )
            {
                if( ae_fp_eq(a->ptr.pp_double[j][j],(double)(0)) )
                {
                    result = ae_false;
                    ae_frame_leave(_state);
                    return result;
                }
                a->ptr.pp_double[j][j] = 1/a->ptr.pp_double[j][j];
                ajj = -a->ptr.pp_double[j][j];
            }
            else
            {
                ajj = (double)(-1);
            }
            
            /*
             * Compute elements 1:j-1 of j-th column.
             */
            if( j>0 )
            {
                ae_v_move(&t.ptr.p_double[0], 1, &a->ptr.pp_double[0][j], a->stride, ae_v_len(0,j-1));
                for(i=0; i<=j-1; i++)
                {
                    if( i<j-1 )
                    {
                        v = ae_v_dotproduct(&a->ptr.pp_double[i][i+1], 1, &t.ptr.p_double[i+1], 1, ae_v_len(i+1,j-1));
                    }
                    else
                    {
                        v = (double)(0);
                    }
                    if( nounit )
                    {
                        a->ptr.pp_double[i][j] = v+a->ptr.pp_double[i][i]*t.ptr.p_double[i];
                    }
                    else
                    {
                        a->ptr.pp_double[i][j] = v+t.ptr.p_double[i];
                    }
                }
                ae_v_muld(&a->ptr.pp_double[0][j], a->stride, ae_v_len(0,j-1), ajj);
            }
        }
    }
    else
    {
        
        /*
         * Compute inverse of lower triangular matrix.
         */
        for(j=n-1; j>=0; j--)
        {
            if( nounit )
            {
                if( ae_fp_eq(a->ptr.pp_double[j][j],(double)(0)) )
                {
                    result = ae_false;
                    ae_frame_leave(_state);
                    return result;
                }
                a->ptr.pp_double[j][j] = 1/a->ptr.pp_double[j][j];
                ajj = -a->ptr.pp_double[j][j];
            }
            else
            {
                ajj = (double)(-1);
            }
            if( j<n-1 )
            {
                
                /*
                 * Compute elements j+1:n of j-th column.
                 */
                ae_v_move(&t.ptr.p_double[j+1], 1, &a->ptr.pp_double[j+1][j], a->stride, ae_v_len(j+1,n-1));
                for(i=j+1; i<=n-1; i++)
                {
                    if( i>j+1 )
                    {
                        v = ae_v_dotproduct(&a->ptr.pp_double[i][j+1], 1, &t.ptr.p_double[j+1], 1, ae_v_len(j+1,i-1));
                    }
                    else
                    {
                        v = (double)(0);
                    }
                    if( nounit )
                    {
                        a->ptr.pp_double[i][j] = v+a->ptr.pp_double[i][i]*t.ptr.p_double[i];
                    }
                    else
                    {
                        a->ptr.pp_double[i][j] = v+t.ptr.p_double[i];
                    }
                }
                ae_v_muld(&a->ptr.pp_double[j+1][j], a->stride, ae_v_len(j+1,n-1), ajj);
            }
        }
    }
    ae_frame_leave(_state);
    return result;
}


/*************************************************************************
LU inverse
*************************************************************************/
static ae_bool testrcondunit_rmatrixinvmatlu(/* Real    */ ae_matrix* a,
     /* Integer */ ae_vector* pivots,
     ae_int_t n,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_vector work;
    ae_int_t i;
    ae_int_t j;
    ae_int_t jp;
    double v;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    ae_vector_init(&work, 0, DT_REAL, _state);

    result = ae_true;
    
    /*
     * Quick return if possible
     */
    if( n==0 )
    {
        ae_frame_leave(_state);
        return result;
    }
    ae_vector_set_length(&work, n-1+1, _state);
    
    /*
     * Form inv(U)
     */
    if( !testrcondunit_rmatrixinvmattr(a, n, ae_true, ae_false, _state) )
    {
        result = ae_false;
        ae_frame_leave(_state);
        return result;
    }
    
    /*
     * Solve the equation inv(A)*L = inv(U) for inv(A).
     */
    for(j=n-1; j>=0; j--)
    {
        
        /*
         * Copy current column of L to WORK and replace with zeros.
         */
        for(i=j+1; i<=n-1; i++)
        {
            work.ptr.p_double[i] = a->ptr.pp_double[i][j];
            a->ptr.pp_double[i][j] = (double)(0);
        }
        
        /*
         * Compute current column of inv(A).
         */
        if( j<n-1 )
        {
            for(i=0; i<=n-1; i++)
            {
                v = ae_v_dotproduct(&a->ptr.pp_double[i][j+1], 1, &work.ptr.p_double[j+1], 1, ae_v_len(j+1,n-1));
                a->ptr.pp_double[i][j] = a->ptr.pp_double[i][j]-v;
            }
        }
    }
    
    /*
     * Apply column interchanges.
     */
    for(j=n-2; j>=0; j--)
    {
        jp = pivots->ptr.p_int[j];
        if( jp!=j )
        {
            ae_v_move(&work.ptr.p_double[0], 1, &a->ptr.pp_double[0][j], a->stride, ae_v_len(0,n-1));
            ae_v_move(&a->ptr.pp_double[0][j], a->stride, &a->ptr.pp_double[0][jp], a->stride, ae_v_len(0,n-1));
            ae_v_move(&a->ptr.pp_double[0][jp], a->stride, &work.ptr.p_double[0], 1, ae_v_len(0,n-1));
        }
    }
    ae_frame_leave(_state);
    return result;
}


/*************************************************************************
Matrix inverse
*************************************************************************/
static ae_bool testrcondunit_rmatrixinvmat(/* Real    */ ae_matrix* a,
     ae_int_t n,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_vector pivots;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    ae_vector_init(&pivots, 0, DT_INT, _state);

    rmatrixlu(a, n, n, &pivots, _state);
    result = testrcondunit_rmatrixinvmatlu(a, &pivots, n, _state);
    ae_frame_leave(_state);
    return result;
}


/*************************************************************************
reference RCond
*************************************************************************/
static void testrcondunit_rmatrixrefrcond(/* Real    */ ae_matrix* a,
     ae_int_t n,
     double* rc1,
     double* rcinf,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_matrix inva;
    double nrm1a;
    double nrminfa;
    double nrm1inva;
    double nrminfinva;
    double v;
    ae_int_t k;
    ae_int_t i;

    ae_frame_make(_state, &_frame_block);
    *rc1 = 0;
    *rcinf = 0;
    ae_matrix_init(&inva, 0, 0, DT_REAL, _state);

    
    /*
     * inv A
     */
    testrcondunit_rmatrixmakeacopy(a, n, n, &inva, _state);
    if( !testrcondunit_rmatrixinvmat(&inva, n, _state) )
    {
        *rc1 = (double)(0);
        *rcinf = (double)(0);
        ae_frame_leave(_state);
        return;
    }
    
    /*
     * norm A
     */
    nrm1a = (double)(0);
    nrminfa = (double)(0);
    for(k=0; k<=n-1; k++)
    {
        v = (double)(0);
        for(i=0; i<=n-1; i++)
        {
            v = v+ae_fabs(a->ptr.pp_double[i][k], _state);
        }
        nrm1a = ae_maxreal(nrm1a, v, _state);
        v = (double)(0);
        for(i=0; i<=n-1; i++)
        {
            v = v+ae_fabs(a->ptr.pp_double[k][i], _state);
        }
        nrminfa = ae_maxreal(nrminfa, v, _state);
    }
    
    /*
     * norm inv A
     */
    nrm1inva = (double)(0);
    nrminfinva = (double)(0);
    for(k=0; k<=n-1; k++)
    {
        v = (double)(0);
        for(i=0; i<=n-1; i++)
        {
            v = v+ae_fabs(inva.ptr.pp_double[i][k], _state);
        }
        nrm1inva = ae_maxreal(nrm1inva, v, _state);
        v = (double)(0);
        for(i=0; i<=n-1; i++)
        {
            v = v+ae_fabs(inva.ptr.pp_double[k][i], _state);
        }
        nrminfinva = ae_maxreal(nrminfinva, v, _state);
    }
    
    /*
     * result
     */
    *rc1 = nrm1inva*nrm1a;
    *rcinf = nrminfinva*nrminfa;
    ae_frame_leave(_state);
}


/*************************************************************************
Copy
*************************************************************************/
static void testrcondunit_cmatrixmakeacopy(/* Complex */ ae_matrix* a,
     ae_int_t m,
     ae_int_t n,
     /* Complex */ ae_matrix* b,
     ae_state *_state)
{
    ae_int_t i;
    ae_int_t j;

    ae_matrix_clear(b);

    ae_matrix_set_length(b, m-1+1, n-1+1, _state);
    for(i=0; i<=m-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            b->ptr.pp_complex[i][j] = a->ptr.pp_complex[i][j];
        }
    }
}


/*************************************************************************
Generate matrix with given condition number C (2-norm)
*************************************************************************/
static void testrcondunit_cmatrixgenzero(/* Complex */ ae_matrix* a0,
     ae_int_t n,
     ae_state *_state)
{
    ae_int_t i;
    ae_int_t j;


    ae_matrix_set_length(a0, n, n, _state);
    for(i=0; i<=n-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            a0->ptr.pp_complex[i][j] = ae_complex_from_i(0);
        }
    }
}


/*************************************************************************
triangular inverse
*************************************************************************/
static ae_bool testrcondunit_cmatrixinvmattr(/* Complex */ ae_matrix* a,
     ae_int_t n,
     ae_bool isupper,
     ae_bool isunittriangular,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_bool nounit;
    ae_int_t i;
    ae_int_t j;
    ae_complex v;
    ae_complex ajj;
    ae_vector t;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    ae_vector_init(&t, 0, DT_COMPLEX, _state);

    result = ae_true;
    ae_vector_set_length(&t, n-1+1, _state);
    
    /*
     * Test the input parameters.
     */
    nounit = !isunittriangular;
    if( isupper )
    {
        
        /*
         * Compute inverse of upper triangular matrix.
         */
        for(j=0; j<=n-1; j++)
        {
            if( nounit )
            {
                if( ae_c_eq_d(a->ptr.pp_complex[j][j],(double)(0)) )
                {
                    result = ae_false;
                    ae_frame_leave(_state);
                    return result;
                }
                a->ptr.pp_complex[j][j] = ae_c_d_div(1,a->ptr.pp_complex[j][j]);
                ajj = ae_c_neg(a->ptr.pp_complex[j][j]);
            }
            else
            {
                ajj = ae_complex_from_i(-1);
            }
            
            /*
             * Compute elements 1:j-1 of j-th column.
             */
            if( j>0 )
            {
                ae_v_cmove(&t.ptr.p_complex[0], 1, &a->ptr.pp_complex[0][j], a->stride, "N", ae_v_len(0,j-1));
                for(i=0; i<=j-1; i++)
                {
                    if( i<j-1 )
                    {
                        v = ae_v_cdotproduct(&a->ptr.pp_complex[i][i+1], 1, "N", &t.ptr.p_complex[i+1], 1, "N", ae_v_len(i+1,j-1));
                    }
                    else
                    {
                        v = ae_complex_from_i(0);
                    }
                    if( nounit )
                    {
                        a->ptr.pp_complex[i][j] = ae_c_add(v,ae_c_mul(a->ptr.pp_complex[i][i],t.ptr.p_complex[i]));
                    }
                    else
                    {
                        a->ptr.pp_complex[i][j] = ae_c_add(v,t.ptr.p_complex[i]);
                    }
                }
                ae_v_cmulc(&a->ptr.pp_complex[0][j], a->stride, ae_v_len(0,j-1), ajj);
            }
        }
    }
    else
    {
        
        /*
         * Compute inverse of lower triangular matrix.
         */
        for(j=n-1; j>=0; j--)
        {
            if( nounit )
            {
                if( ae_c_eq_d(a->ptr.pp_complex[j][j],(double)(0)) )
                {
                    result = ae_false;
                    ae_frame_leave(_state);
                    return result;
                }
                a->ptr.pp_complex[j][j] = ae_c_d_div(1,a->ptr.pp_complex[j][j]);
                ajj = ae_c_neg(a->ptr.pp_complex[j][j]);
            }
            else
            {
                ajj = ae_complex_from_i(-1);
            }
            if( j<n-1 )
            {
                
                /*
                 * Compute elements j+1:n of j-th column.
                 */
                ae_v_cmove(&t.ptr.p_complex[j+1], 1, &a->ptr.pp_complex[j+1][j], a->stride, "N", ae_v_len(j+1,n-1));
                for(i=j+1; i<=n-1; i++)
                {
                    if( i>j+1 )
                    {
                        v = ae_v_cdotproduct(&a->ptr.pp_complex[i][j+1], 1, "N", &t.ptr.p_complex[j+1], 1, "N", ae_v_len(j+1,i-1));
                    }
                    else
                    {
                        v = ae_complex_from_i(0);
                    }
                    if( nounit )
                    {
                        a->ptr.pp_complex[i][j] = ae_c_add(v,ae_c_mul(a->ptr.pp_complex[i][i],t.ptr.p_complex[i]));
                    }
                    else
                    {
                        a->ptr.pp_complex[i][j] = ae_c_add(v,t.ptr.p_complex[i]);
                    }
                }
                ae_v_cmulc(&a->ptr.pp_complex[j+1][j], a->stride, ae_v_len(j+1,n-1), ajj);
            }
        }
    }
    ae_frame_leave(_state);
    return result;
}


/*************************************************************************
LU inverse
*************************************************************************/
static ae_bool testrcondunit_cmatrixinvmatlu(/* Complex */ ae_matrix* a,
     /* Integer */ ae_vector* pivots,
     ae_int_t n,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_vector work;
    ae_int_t i;
    ae_int_t j;
    ae_int_t jp;
    ae_complex v;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    ae_vector_init(&work, 0, DT_COMPLEX, _state);

    result = ae_true;
    
    /*
     * Quick return if possible
     */
    if( n==0 )
    {
        ae_frame_leave(_state);
        return result;
    }
    ae_vector_set_length(&work, n-1+1, _state);
    
    /*
     * Form inv(U)
     */
    if( !testrcondunit_cmatrixinvmattr(a, n, ae_true, ae_false, _state) )
    {
        result = ae_false;
        ae_frame_leave(_state);
        return result;
    }
    
    /*
     * Solve the equation inv(A)*L = inv(U) for inv(A).
     */
    for(j=n-1; j>=0; j--)
    {
        
        /*
         * Copy current column of L to WORK and replace with zeros.
         */
        for(i=j+1; i<=n-1; i++)
        {
            work.ptr.p_complex[i] = a->ptr.pp_complex[i][j];
            a->ptr.pp_complex[i][j] = ae_complex_from_i(0);
        }
        
        /*
         * Compute current column of inv(A).
         */
        if( j<n-1 )
        {
            for(i=0; i<=n-1; i++)
            {
                v = ae_v_cdotproduct(&a->ptr.pp_complex[i][j+1], 1, "N", &work.ptr.p_complex[j+1], 1, "N", ae_v_len(j+1,n-1));
                a->ptr.pp_complex[i][j] = ae_c_sub(a->ptr.pp_complex[i][j],v);
            }
        }
    }
    
    /*
     * Apply column interchanges.
     */
    for(j=n-2; j>=0; j--)
    {
        jp = pivots->ptr.p_int[j];
        if( jp!=j )
        {
            ae_v_cmove(&work.ptr.p_complex[0], 1, &a->ptr.pp_complex[0][j], a->stride, "N", ae_v_len(0,n-1));
            ae_v_cmove(&a->ptr.pp_complex[0][j], a->stride, &a->ptr.pp_complex[0][jp], a->stride, "N", ae_v_len(0,n-1));
            ae_v_cmove(&a->ptr.pp_complex[0][jp], a->stride, &work.ptr.p_complex[0], 1, "N", ae_v_len(0,n-1));
        }
    }
    ae_frame_leave(_state);
    return result;
}


/*************************************************************************
Matrix inverse
*************************************************************************/
static ae_bool testrcondunit_cmatrixinvmat(/* Complex */ ae_matrix* a,
     ae_int_t n,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_vector pivots;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    ae_vector_init(&pivots, 0, DT_INT, _state);

    cmatrixlu(a, n, n, &pivots, _state);
    result = testrcondunit_cmatrixinvmatlu(a, &pivots, n, _state);
    ae_frame_leave(_state);
    return result;
}


/*************************************************************************
reference RCond
*************************************************************************/
static void testrcondunit_cmatrixrefrcond(/* Complex */ ae_matrix* a,
     ae_int_t n,
     double* rc1,
     double* rcinf,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_matrix inva;
    double nrm1a;
    double nrminfa;
    double nrm1inva;
    double nrminfinva;
    double v;
    ae_int_t k;
    ae_int_t i;

    ae_frame_make(_state, &_frame_block);
    *rc1 = 0;
    *rcinf = 0;
    ae_matrix_init(&inva, 0, 0, DT_COMPLEX, _state);

    
    /*
     * inv A
     */
    testrcondunit_cmatrixmakeacopy(a, n, n, &inva, _state);
    if( !testrcondunit_cmatrixinvmat(&inva, n, _state) )
    {
        *rc1 = (double)(0);
        *rcinf = (double)(0);
        ae_frame_leave(_state);
        return;
    }
    
    /*
     * norm A
     */
    nrm1a = (double)(0);
    nrminfa = (double)(0);
    for(k=0; k<=n-1; k++)
    {
        v = (double)(0);
        for(i=0; i<=n-1; i++)
        {
            v = v+ae_c_abs(a->ptr.pp_complex[i][k], _state);
        }
        nrm1a = ae_maxreal(nrm1a, v, _state);
        v = (double)(0);
        for(i=0; i<=n-1; i++)
        {
            v = v+ae_c_abs(a->ptr.pp_complex[k][i], _state);
        }
        nrminfa = ae_maxreal(nrminfa, v, _state);
    }
    
    /*
     * norm inv A
     */
    nrm1inva = (double)(0);
    nrminfinva = (double)(0);
    for(k=0; k<=n-1; k++)
    {
        v = (double)(0);
        for(i=0; i<=n-1; i++)
        {
            v = v+ae_c_abs(inva.ptr.pp_complex[i][k], _state);
        }
        nrm1inva = ae_maxreal(nrm1inva, v, _state);
        v = (double)(0);
        for(i=0; i<=n-1; i++)
        {
            v = v+ae_c_abs(inva.ptr.pp_complex[k][i], _state);
        }
        nrminfinva = ae_maxreal(nrminfinva, v, _state);
    }
    
    /*
     * result
     */
    *rc1 = nrm1inva*nrm1a;
    *rcinf = nrminfinva*nrminfa;
    ae_frame_leave(_state);
}


/*************************************************************************
Returns True for successful test, False - for failed test
*************************************************************************/
static ae_bool testrcondunit_testrmatrixtrrcond(ae_int_t maxn,
     ae_int_t passcount,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_matrix a;
    ae_matrix ea;
    ae_vector p;
    ae_int_t n;
    ae_int_t i;
    ae_int_t j;
    ae_int_t j1;
    ae_int_t j2;
    ae_int_t pass;
    ae_bool err50;
    ae_bool err90;
    ae_bool errspec;
    ae_bool errless;
    double erc1;
    double ercinf;
    ae_vector q50;
    ae_vector q90;
    double v;
    ae_bool isupper;
    ae_bool isunit;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    ae_matrix_init(&a, 0, 0, DT_REAL, _state);
    ae_matrix_init(&ea, 0, 0, DT_REAL, _state);
    ae_vector_init(&p, 0, DT_INT, _state);
    ae_vector_init(&q50, 0, DT_REAL, _state);
    ae_vector_init(&q90, 0, DT_REAL, _state);

    err50 = ae_false;
    err90 = ae_false;
    errless = ae_false;
    errspec = ae_false;
    ae_vector_set_length(&q50, 2, _state);
    ae_vector_set_length(&q90, 2, _state);
    for(n=1; n<=maxn; n++)
    {
        
        /*
         * special test for zero matrix
         */
        testrcondunit_rmatrixgenzero(&a, n, _state);
        errspec = errspec||ae_fp_neq(rmatrixtrrcond1(&a, n, ae_fp_greater(ae_randomreal(_state),0.5), ae_false, _state),(double)(0));
        errspec = errspec||ae_fp_neq(rmatrixtrrcondinf(&a, n, ae_fp_greater(ae_randomreal(_state),0.5), ae_false, _state),(double)(0));
        
        /*
         * general test
         */
        ae_matrix_set_length(&a, n, n, _state);
        for(i=0; i<=1; i++)
        {
            q50.ptr.p_double[i] = (double)(0);
            q90.ptr.p_double[i] = (double)(0);
        }
        for(pass=1; pass<=passcount; pass++)
        {
            isupper = ae_fp_greater(ae_randomreal(_state),0.5);
            isunit = ae_fp_greater(ae_randomreal(_state),0.5);
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    a.ptr.pp_double[i][j] = ae_randomreal(_state)-0.5;
                }
            }
            for(i=0; i<=n-1; i++)
            {
                a.ptr.pp_double[i][i] = 1+ae_randomreal(_state);
            }
            testrcondunit_rmatrixmakeacopy(&a, n, n, &ea, _state);
            for(i=0; i<=n-1; i++)
            {
                if( isupper )
                {
                    j1 = 0;
                    j2 = i-1;
                }
                else
                {
                    j1 = i+1;
                    j2 = n-1;
                }
                for(j=j1; j<=j2; j++)
                {
                    ea.ptr.pp_double[i][j] = (double)(0);
                }
                if( isunit )
                {
                    ea.ptr.pp_double[i][i] = (double)(1);
                }
            }
            testrcondunit_rmatrixrefrcond(&ea, n, &erc1, &ercinf, _state);
            
            /*
             * 1-norm
             */
            v = 1/rmatrixtrrcond1(&a, n, isupper, isunit, _state);
            if( ae_fp_greater_eq(v,testrcondunit_threshold50*erc1) )
            {
                q50.ptr.p_double[0] = q50.ptr.p_double[0]+(double)1/(double)passcount;
            }
            if( ae_fp_greater_eq(v,testrcondunit_threshold90*erc1) )
            {
                q90.ptr.p_double[0] = q90.ptr.p_double[0]+(double)1/(double)passcount;
            }
            errless = errless||ae_fp_greater(v,erc1*1.001);
            
            /*
             * Inf-norm
             */
            v = 1/rmatrixtrrcondinf(&a, n, isupper, isunit, _state);
            if( ae_fp_greater_eq(v,testrcondunit_threshold50*ercinf) )
            {
                q50.ptr.p_double[1] = q50.ptr.p_double[1]+(double)1/(double)passcount;
            }
            if( ae_fp_greater_eq(v,testrcondunit_threshold90*ercinf) )
            {
                q90.ptr.p_double[1] = q90.ptr.p_double[1]+(double)1/(double)passcount;
            }
            errless = errless||ae_fp_greater(v,ercinf*1.001);
        }
        for(i=0; i<=1; i++)
        {
            err50 = err50||ae_fp_less(q50.ptr.p_double[i],0.50);
            err90 = err90||ae_fp_less(q90.ptr.p_double[i],0.90);
        }
        
        /*
         * degenerate matrix test
         */
        if( n>=3 )
        {
            ae_matrix_set_length(&a, n, n, _state);
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    a.ptr.pp_double[i][j] = 0.0;
                }
            }
            a.ptr.pp_double[0][0] = (double)(1);
            a.ptr.pp_double[n-1][n-1] = (double)(1);
            errspec = errspec||ae_fp_neq(rmatrixtrrcond1(&a, n, ae_fp_greater(ae_randomreal(_state),0.5), ae_false, _state),(double)(0));
            errspec = errspec||ae_fp_neq(rmatrixtrrcondinf(&a, n, ae_fp_greater(ae_randomreal(_state),0.5), ae_false, _state),(double)(0));
        }
        
        /*
         * near-degenerate matrix test
         */
        if( n>=2 )
        {
            ae_matrix_set_length(&a, n, n, _state);
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    a.ptr.pp_double[i][j] = 0.0;
                }
            }
            for(i=0; i<=n-1; i++)
            {
                a.ptr.pp_double[i][i] = (double)(1);
            }
            i = ae_randominteger(n, _state);
            a.ptr.pp_double[i][i] = 0.1*ae_maxrealnumber;
            errspec = errspec||ae_fp_neq(rmatrixtrrcond1(&a, n, ae_fp_greater(ae_randomreal(_state),0.5), ae_false, _state),(double)(0));
            errspec = errspec||ae_fp_neq(rmatrixtrrcondinf(&a, n, ae_fp_greater(ae_randomreal(_state),0.5), ae_false, _state),(double)(0));
        }
    }
    
    /*
     * report
     */
    result = !(((err50||err90)||errless)||errspec);
    ae_frame_leave(_state);
    return result;
}


/*************************************************************************
Returns True for successful test, False - for failed test
*************************************************************************/
static ae_bool testrcondunit_testcmatrixtrrcond(ae_int_t maxn,
     ae_int_t passcount,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_matrix a;
    ae_matrix ea;
    ae_vector p;
    ae_int_t n;
    ae_int_t i;
    ae_int_t j;
    ae_int_t j1;
    ae_int_t j2;
    ae_int_t pass;
    ae_bool err50;
    ae_bool err90;
    ae_bool errspec;
    ae_bool errless;
    double erc1;
    double ercinf;
    ae_vector q50;
    ae_vector q90;
    double v;
    ae_bool isupper;
    ae_bool isunit;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    ae_matrix_init(&a, 0, 0, DT_COMPLEX, _state);
    ae_matrix_init(&ea, 0, 0, DT_COMPLEX, _state);
    ae_vector_init(&p, 0, DT_INT, _state);
    ae_vector_init(&q50, 0, DT_REAL, _state);
    ae_vector_init(&q90, 0, DT_REAL, _state);

    err50 = ae_false;
    err90 = ae_false;
    errless = ae_false;
    errspec = ae_false;
    ae_vector_set_length(&q50, 2, _state);
    ae_vector_set_length(&q90, 2, _state);
    for(n=1; n<=maxn; n++)
    {
        
        /*
         * special test for zero matrix
         */
        testrcondunit_cmatrixgenzero(&a, n, _state);
        errspec = errspec||ae_fp_neq(cmatrixtrrcond1(&a, n, ae_fp_greater(ae_randomreal(_state),0.5), ae_false, _state),(double)(0));
        errspec = errspec||ae_fp_neq(cmatrixtrrcondinf(&a, n, ae_fp_greater(ae_randomreal(_state),0.5), ae_false, _state),(double)(0));
        
        /*
         * general test
         */
        ae_matrix_set_length(&a, n, n, _state);
        for(i=0; i<=1; i++)
        {
            q50.ptr.p_double[i] = (double)(0);
            q90.ptr.p_double[i] = (double)(0);
        }
        for(pass=1; pass<=passcount; pass++)
        {
            isupper = ae_fp_greater(ae_randomreal(_state),0.5);
            isunit = ae_fp_greater(ae_randomreal(_state),0.5);
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    a.ptr.pp_complex[i][j].x = ae_randomreal(_state)-0.5;
                    a.ptr.pp_complex[i][j].y = ae_randomreal(_state)-0.5;
                }
            }
            for(i=0; i<=n-1; i++)
            {
                a.ptr.pp_complex[i][i].x = 1+ae_randomreal(_state);
                a.ptr.pp_complex[i][i].y = 1+ae_randomreal(_state);
            }
            testrcondunit_cmatrixmakeacopy(&a, n, n, &ea, _state);
            for(i=0; i<=n-1; i++)
            {
                if( isupper )
                {
                    j1 = 0;
                    j2 = i-1;
                }
                else
                {
                    j1 = i+1;
                    j2 = n-1;
                }
                for(j=j1; j<=j2; j++)
                {
                    ea.ptr.pp_complex[i][j] = ae_complex_from_i(0);
                }
                if( isunit )
                {
                    ea.ptr.pp_complex[i][i] = ae_complex_from_i(1);
                }
            }
            testrcondunit_cmatrixrefrcond(&ea, n, &erc1, &ercinf, _state);
            
            /*
             * 1-norm
             */
            v = 1/cmatrixtrrcond1(&a, n, isupper, isunit, _state);
            if( ae_fp_greater_eq(v,testrcondunit_threshold50*erc1) )
            {
                q50.ptr.p_double[0] = q50.ptr.p_double[0]+(double)1/(double)passcount;
            }
            if( ae_fp_greater_eq(v,testrcondunit_threshold90*erc1) )
            {
                q90.ptr.p_double[0] = q90.ptr.p_double[0]+(double)1/(double)passcount;
            }
            errless = errless||ae_fp_greater(v,erc1*1.001);
            
            /*
             * Inf-norm
             */
            v = 1/cmatrixtrrcondinf(&a, n, isupper, isunit, _state);
            if( ae_fp_greater_eq(v,testrcondunit_threshold50*ercinf) )
            {
                q50.ptr.p_double[1] = q50.ptr.p_double[1]+(double)1/(double)passcount;
            }
            if( ae_fp_greater_eq(v,testrcondunit_threshold90*ercinf) )
            {
                q90.ptr.p_double[1] = q90.ptr.p_double[1]+(double)1/(double)passcount;
            }
            errless = errless||ae_fp_greater(v,ercinf*1.001);
        }
        for(i=0; i<=1; i++)
        {
            err50 = err50||ae_fp_less(q50.ptr.p_double[i],0.50);
            err90 = err90||ae_fp_less(q90.ptr.p_double[i],0.90);
        }
        
        /*
         * degenerate matrix test
         */
        if( n>=3 )
        {
            ae_matrix_set_length(&a, n, n, _state);
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    a.ptr.pp_complex[i][j] = ae_complex_from_d(0.0);
                }
            }
            a.ptr.pp_complex[0][0] = ae_complex_from_i(1);
            a.ptr.pp_complex[n-1][n-1] = ae_complex_from_i(1);
            errspec = errspec||ae_fp_neq(cmatrixtrrcond1(&a, n, ae_fp_greater(ae_randomreal(_state),0.5), ae_false, _state),(double)(0));
            errspec = errspec||ae_fp_neq(cmatrixtrrcondinf(&a, n, ae_fp_greater(ae_randomreal(_state),0.5), ae_false, _state),(double)(0));
        }
        
        /*
         * near-degenerate matrix test
         */
        if( n>=2 )
        {
            ae_matrix_set_length(&a, n, n, _state);
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    a.ptr.pp_complex[i][j] = ae_complex_from_d(0.0);
                }
            }
            for(i=0; i<=n-1; i++)
            {
                a.ptr.pp_complex[i][i] = ae_complex_from_i(1);
            }
            i = ae_randominteger(n, _state);
            a.ptr.pp_complex[i][i] = ae_complex_from_d(0.1*ae_maxrealnumber);
            errspec = errspec||ae_fp_neq(cmatrixtrrcond1(&a, n, ae_fp_greater(ae_randomreal(_state),0.5), ae_false, _state),(double)(0));
            errspec = errspec||ae_fp_neq(cmatrixtrrcondinf(&a, n, ae_fp_greater(ae_randomreal(_state),0.5), ae_false, _state),(double)(0));
        }
    }
    
    /*
     * report
     */
    result = !(((err50||err90)||errless)||errspec);
    ae_frame_leave(_state);
    return result;
}


/*************************************************************************
Returns True for successful test, False - for failed test
*************************************************************************/
static ae_bool testrcondunit_testrmatrixrcond(ae_int_t maxn,
     ae_int_t passcount,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_matrix a;
    ae_matrix lua;
    ae_vector p;
    ae_int_t n;
    ae_int_t i;
    ae_int_t j;
    ae_int_t pass;
    ae_bool err50;
    ae_bool err90;
    ae_bool errspec;
    ae_bool errless;
    double erc1;
    double ercinf;
    ae_vector q50;
    ae_vector q90;
    double v;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    ae_matrix_init(&a, 0, 0, DT_REAL, _state);
    ae_matrix_init(&lua, 0, 0, DT_REAL, _state);
    ae_vector_init(&p, 0, DT_INT, _state);
    ae_vector_init(&q50, 0, DT_REAL, _state);
    ae_vector_init(&q90, 0, DT_REAL, _state);

    err50 = ae_false;
    err90 = ae_false;
    errless = ae_false;
    errspec = ae_false;
    ae_vector_set_length(&q50, 3+1, _state);
    ae_vector_set_length(&q90, 3+1, _state);
    for(n=1; n<=maxn; n++)
    {
        
        /*
         * special test for zero matrix
         */
        testrcondunit_rmatrixgenzero(&a, n, _state);
        testrcondunit_rmatrixmakeacopy(&a, n, n, &lua, _state);
        rmatrixlu(&lua, n, n, &p, _state);
        errspec = errspec||ae_fp_neq(rmatrixrcond1(&a, n, _state),(double)(0));
        errspec = errspec||ae_fp_neq(rmatrixrcondinf(&a, n, _state),(double)(0));
        errspec = errspec||ae_fp_neq(rmatrixlurcond1(&lua, n, _state),(double)(0));
        errspec = errspec||ae_fp_neq(rmatrixlurcondinf(&lua, n, _state),(double)(0));
        
        /*
         * general test
         */
        ae_matrix_set_length(&a, n-1+1, n-1+1, _state);
        for(i=0; i<=3; i++)
        {
            q50.ptr.p_double[i] = (double)(0);
            q90.ptr.p_double[i] = (double)(0);
        }
        for(pass=1; pass<=passcount; pass++)
        {
            rmatrixrndcond(n, ae_exp(ae_randomreal(_state)*ae_log((double)(1000), _state), _state), &a, _state);
            testrcondunit_rmatrixmakeacopy(&a, n, n, &lua, _state);
            rmatrixlu(&lua, n, n, &p, _state);
            testrcondunit_rmatrixrefrcond(&a, n, &erc1, &ercinf, _state);
            
            /*
             * 1-norm, normal
             */
            v = 1/rmatrixrcond1(&a, n, _state);
            if( ae_fp_greater_eq(v,testrcondunit_threshold50*erc1) )
            {
                q50.ptr.p_double[0] = q50.ptr.p_double[0]+(double)1/(double)passcount;
            }
            if( ae_fp_greater_eq(v,testrcondunit_threshold90*erc1) )
            {
                q90.ptr.p_double[0] = q90.ptr.p_double[0]+(double)1/(double)passcount;
            }
            errless = errless||ae_fp_greater(v,erc1*1.001);
            
            /*
             * 1-norm, LU
             */
            v = 1/rmatrixlurcond1(&lua, n, _state);
            if( ae_fp_greater_eq(v,testrcondunit_threshold50*erc1) )
            {
                q50.ptr.p_double[1] = q50.ptr.p_double[1]+(double)1/(double)passcount;
            }
            if( ae_fp_greater_eq(v,testrcondunit_threshold90*erc1) )
            {
                q90.ptr.p_double[1] = q90.ptr.p_double[1]+(double)1/(double)passcount;
            }
            errless = errless||ae_fp_greater(v,erc1*1.001);
            
            /*
             * Inf-norm, normal
             */
            v = 1/rmatrixrcondinf(&a, n, _state);
            if( ae_fp_greater_eq(v,testrcondunit_threshold50*ercinf) )
            {
                q50.ptr.p_double[2] = q50.ptr.p_double[2]+(double)1/(double)passcount;
            }
            if( ae_fp_greater_eq(v,testrcondunit_threshold90*ercinf) )
            {
                q90.ptr.p_double[2] = q90.ptr.p_double[2]+(double)1/(double)passcount;
            }
            errless = errless||ae_fp_greater(v,ercinf*1.001);
            
            /*
             * Inf-norm, LU
             */
            v = 1/rmatrixlurcondinf(&lua, n, _state);
            if( ae_fp_greater_eq(v,testrcondunit_threshold50*ercinf) )
            {
                q50.ptr.p_double[3] = q50.ptr.p_double[3]+(double)1/(double)passcount;
            }
            if( ae_fp_greater_eq(v,testrcondunit_threshold90*ercinf) )
            {
                q90.ptr.p_double[3] = q90.ptr.p_double[3]+(double)1/(double)passcount;
            }
            errless = errless||ae_fp_greater(v,ercinf*1.001);
        }
        for(i=0; i<=3; i++)
        {
            err50 = err50||ae_fp_less(q50.ptr.p_double[i],0.50);
            err90 = err90||ae_fp_less(q90.ptr.p_double[i],0.90);
        }
        
        /*
         * degenerate matrix test
         */
        if( n>=3 )
        {
            ae_matrix_set_length(&a, n, n, _state);
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    a.ptr.pp_double[i][j] = 0.0;
                }
            }
            a.ptr.pp_double[0][0] = (double)(1);
            a.ptr.pp_double[n-1][n-1] = (double)(1);
            errspec = errspec||ae_fp_neq(rmatrixrcond1(&a, n, _state),(double)(0));
            errspec = errspec||ae_fp_neq(rmatrixrcondinf(&a, n, _state),(double)(0));
            errspec = errspec||ae_fp_neq(rmatrixlurcond1(&a, n, _state),(double)(0));
            errspec = errspec||ae_fp_neq(rmatrixlurcondinf(&a, n, _state),(double)(0));
        }
        
        /*
         * near-degenerate matrix test
         */
        if( n>=2 )
        {
            ae_matrix_set_length(&a, n, n, _state);
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    a.ptr.pp_double[i][j] = 0.0;
                }
            }
            for(i=0; i<=n-1; i++)
            {
                a.ptr.pp_double[i][i] = (double)(1);
            }
            i = ae_randominteger(n, _state);
            a.ptr.pp_double[i][i] = 0.1*ae_maxrealnumber;
            errspec = errspec||ae_fp_neq(rmatrixrcond1(&a, n, _state),(double)(0));
            errspec = errspec||ae_fp_neq(rmatrixrcondinf(&a, n, _state),(double)(0));
            errspec = errspec||ae_fp_neq(rmatrixlurcond1(&a, n, _state),(double)(0));
            errspec = errspec||ae_fp_neq(rmatrixlurcondinf(&a, n, _state),(double)(0));
        }
    }
    
    /*
     * report
     */
    result = !(((err50||err90)||errless)||errspec);
    ae_frame_leave(_state);
    return result;
}


/*************************************************************************
Returns True for successful test, False - for failed test
*************************************************************************/
static ae_bool testrcondunit_testspdmatrixrcond(ae_int_t maxn,
     ae_int_t passcount,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_matrix a;
    ae_matrix cha;
    ae_vector p;
    ae_int_t n;
    ae_int_t i;
    ae_int_t j;
    ae_int_t pass;
    ae_bool err50;
    ae_bool err90;
    ae_bool errspec;
    ae_bool errless;
    ae_bool isupper;
    double erc1;
    double ercinf;
    ae_vector q50;
    ae_vector q90;
    double v;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    ae_matrix_init(&a, 0, 0, DT_REAL, _state);
    ae_matrix_init(&cha, 0, 0, DT_REAL, _state);
    ae_vector_init(&p, 0, DT_INT, _state);
    ae_vector_init(&q50, 0, DT_REAL, _state);
    ae_vector_init(&q90, 0, DT_REAL, _state);

    err50 = ae_false;
    err90 = ae_false;
    errless = ae_false;
    errspec = ae_false;
    ae_vector_set_length(&q50, 2, _state);
    ae_vector_set_length(&q90, 2, _state);
    for(n=1; n<=maxn; n++)
    {
        isupper = ae_fp_greater(ae_randomreal(_state),0.5);
        
        /*
         * general test
         */
        ae_matrix_set_length(&a, n, n, _state);
        for(i=0; i<=1; i++)
        {
            q50.ptr.p_double[i] = (double)(0);
            q90.ptr.p_double[i] = (double)(0);
        }
        for(pass=1; pass<=passcount; pass++)
        {
            spdmatrixrndcond(n, ae_exp(ae_randomreal(_state)*ae_log((double)(1000), _state), _state), &a, _state);
            testrcondunit_rmatrixrefrcond(&a, n, &erc1, &ercinf, _state);
            testrcondunit_rmatrixdrophalf(&a, n, isupper, _state);
            testrcondunit_rmatrixmakeacopy(&a, n, n, &cha, _state);
            spdmatrixcholesky(&cha, n, isupper, _state);
            
            /*
             * normal
             */
            v = 1/spdmatrixrcond(&a, n, isupper, _state);
            if( ae_fp_greater_eq(v,testrcondunit_threshold50*erc1) )
            {
                q50.ptr.p_double[0] = q50.ptr.p_double[0]+(double)1/(double)passcount;
            }
            if( ae_fp_greater_eq(v,testrcondunit_threshold90*erc1) )
            {
                q90.ptr.p_double[0] = q90.ptr.p_double[0]+(double)1/(double)passcount;
            }
            errless = errless||ae_fp_greater(v,erc1*1.001);
            
            /*
             * Cholesky
             */
            v = 1/spdmatrixcholeskyrcond(&cha, n, isupper, _state);
            if( ae_fp_greater_eq(v,testrcondunit_threshold50*erc1) )
            {
                q50.ptr.p_double[1] = q50.ptr.p_double[1]+(double)1/(double)passcount;
            }
            if( ae_fp_greater_eq(v,testrcondunit_threshold90*erc1) )
            {
                q90.ptr.p_double[1] = q90.ptr.p_double[1]+(double)1/(double)passcount;
            }
            errless = errless||ae_fp_greater(v,erc1*1.001);
        }
        for(i=0; i<=1; i++)
        {
            err50 = err50||ae_fp_less(q50.ptr.p_double[i],0.50);
            err90 = err90||ae_fp_less(q90.ptr.p_double[i],0.90);
        }
        
        /*
         * degenerate matrix test
         */
        if( n>=3 )
        {
            ae_matrix_set_length(&a, n, n, _state);
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    a.ptr.pp_double[i][j] = 0.0;
                }
            }
            a.ptr.pp_double[0][0] = (double)(1);
            a.ptr.pp_double[n-1][n-1] = (double)(1);
            errspec = errspec||ae_fp_neq(spdmatrixrcond(&a, n, isupper, _state),(double)(-1));
            errspec = errspec||ae_fp_neq(spdmatrixcholeskyrcond(&a, n, isupper, _state),(double)(0));
        }
        
        /*
         * near-degenerate matrix test
         */
        if( n>=2 )
        {
            ae_matrix_set_length(&a, n, n, _state);
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    a.ptr.pp_double[i][j] = 0.0;
                }
            }
            for(i=0; i<=n-1; i++)
            {
                a.ptr.pp_double[i][i] = (double)(1);
            }
            i = ae_randominteger(n, _state);
            a.ptr.pp_double[i][i] = 0.1*ae_maxrealnumber;
            errspec = errspec||ae_fp_neq(spdmatrixrcond(&a, n, isupper, _state),(double)(0));
            errspec = errspec||ae_fp_neq(spdmatrixcholeskyrcond(&a, n, isupper, _state),(double)(0));
        }
    }
    
    /*
     * report
     */
    result = !(((err50||err90)||errless)||errspec);
    ae_frame_leave(_state);
    return result;
}


/*************************************************************************
Returns True for successful test, False - for failed test
*************************************************************************/
static ae_bool testrcondunit_testcmatrixrcond(ae_int_t maxn,
     ae_int_t passcount,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_matrix a;
    ae_matrix lua;
    ae_vector p;
    ae_int_t n;
    ae_int_t i;
    ae_int_t j;
    ae_int_t pass;
    ae_bool err50;
    ae_bool err90;
    ae_bool errless;
    ae_bool errspec;
    double erc1;
    double ercinf;
    ae_vector q50;
    ae_vector q90;
    double v;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    ae_matrix_init(&a, 0, 0, DT_COMPLEX, _state);
    ae_matrix_init(&lua, 0, 0, DT_COMPLEX, _state);
    ae_vector_init(&p, 0, DT_INT, _state);
    ae_vector_init(&q50, 0, DT_REAL, _state);
    ae_vector_init(&q90, 0, DT_REAL, _state);

    ae_vector_set_length(&q50, 3+1, _state);
    ae_vector_set_length(&q90, 3+1, _state);
    err50 = ae_false;
    err90 = ae_false;
    errless = ae_false;
    errspec = ae_false;
    
    /*
     * process
     */
    for(n=1; n<=maxn; n++)
    {
        
        /*
         * special test for zero matrix
         */
        testrcondunit_cmatrixgenzero(&a, n, _state);
        testrcondunit_cmatrixmakeacopy(&a, n, n, &lua, _state);
        cmatrixlu(&lua, n, n, &p, _state);
        errspec = errspec||ae_fp_neq(cmatrixrcond1(&a, n, _state),(double)(0));
        errspec = errspec||ae_fp_neq(cmatrixrcondinf(&a, n, _state),(double)(0));
        errspec = errspec||ae_fp_neq(cmatrixlurcond1(&lua, n, _state),(double)(0));
        errspec = errspec||ae_fp_neq(cmatrixlurcondinf(&lua, n, _state),(double)(0));
        
        /*
         * general test
         */
        ae_matrix_set_length(&a, n-1+1, n-1+1, _state);
        for(i=0; i<=3; i++)
        {
            q50.ptr.p_double[i] = (double)(0);
            q90.ptr.p_double[i] = (double)(0);
        }
        for(pass=1; pass<=passcount; pass++)
        {
            cmatrixrndcond(n, ae_exp(ae_randomreal(_state)*ae_log((double)(1000), _state), _state), &a, _state);
            testrcondunit_cmatrixmakeacopy(&a, n, n, &lua, _state);
            cmatrixlu(&lua, n, n, &p, _state);
            testrcondunit_cmatrixrefrcond(&a, n, &erc1, &ercinf, _state);
            
            /*
             * 1-norm, normal
             */
            v = 1/cmatrixrcond1(&a, n, _state);
            if( ae_fp_greater_eq(v,testrcondunit_threshold50*erc1) )
            {
                q50.ptr.p_double[0] = q50.ptr.p_double[0]+(double)1/(double)passcount;
            }
            if( ae_fp_greater_eq(v,testrcondunit_threshold90*erc1) )
            {
                q90.ptr.p_double[0] = q90.ptr.p_double[0]+(double)1/(double)passcount;
            }
            errless = errless||ae_fp_greater(v,erc1*1.001);
            
            /*
             * 1-norm, LU
             */
            v = 1/cmatrixlurcond1(&lua, n, _state);
            if( ae_fp_greater_eq(v,testrcondunit_threshold50*erc1) )
            {
                q50.ptr.p_double[1] = q50.ptr.p_double[1]+(double)1/(double)passcount;
            }
            if( ae_fp_greater_eq(v,testrcondunit_threshold90*erc1) )
            {
                q90.ptr.p_double[1] = q90.ptr.p_double[1]+(double)1/(double)passcount;
            }
            errless = errless||ae_fp_greater(v,erc1*1.001);
            
            /*
             * Inf-norm, normal
             */
            v = 1/cmatrixrcondinf(&a, n, _state);
            if( ae_fp_greater_eq(v,testrcondunit_threshold50*ercinf) )
            {
                q50.ptr.p_double[2] = q50.ptr.p_double[2]+(double)1/(double)passcount;
            }
            if( ae_fp_greater_eq(v,testrcondunit_threshold90*ercinf) )
            {
                q90.ptr.p_double[2] = q90.ptr.p_double[2]+(double)1/(double)passcount;
            }
            errless = errless||ae_fp_greater(v,ercinf*1.001);
            
            /*
             * Inf-norm, LU
             */
            v = 1/cmatrixlurcondinf(&lua, n, _state);
            if( ae_fp_greater_eq(v,testrcondunit_threshold50*ercinf) )
            {
                q50.ptr.p_double[3] = q50.ptr.p_double[3]+(double)1/(double)passcount;
            }
            if( ae_fp_greater_eq(v,testrcondunit_threshold90*ercinf) )
            {
                q90.ptr.p_double[3] = q90.ptr.p_double[3]+(double)1/(double)passcount;
            }
            errless = errless||ae_fp_greater(v,ercinf*1.001);
        }
        for(i=0; i<=3; i++)
        {
            err50 = err50||ae_fp_less(q50.ptr.p_double[i],0.50);
            err90 = err90||ae_fp_less(q90.ptr.p_double[i],0.90);
        }
        
        /*
         * degenerate matrix test
         */
        if( n>=3 )
        {
            ae_matrix_set_length(&a, n, n, _state);
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    a.ptr.pp_complex[i][j] = ae_complex_from_d(0.0);
                }
            }
            a.ptr.pp_complex[0][0] = ae_complex_from_i(1);
            a.ptr.pp_complex[n-1][n-1] = ae_complex_from_i(1);
            errspec = errspec||ae_fp_neq(cmatrixrcond1(&a, n, _state),(double)(0));
            errspec = errspec||ae_fp_neq(cmatrixrcondinf(&a, n, _state),(double)(0));
            errspec = errspec||ae_fp_neq(cmatrixlurcond1(&a, n, _state),(double)(0));
            errspec = errspec||ae_fp_neq(cmatrixlurcondinf(&a, n, _state),(double)(0));
        }
        
        /*
         * near-degenerate matrix test
         */
        if( n>=2 )
        {
            ae_matrix_set_length(&a, n, n, _state);
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    a.ptr.pp_complex[i][j] = ae_complex_from_d(0.0);
                }
            }
            for(i=0; i<=n-1; i++)
            {
                a.ptr.pp_complex[i][i] = ae_complex_from_i(1);
            }
            i = ae_randominteger(n, _state);
            a.ptr.pp_complex[i][i] = ae_complex_from_d(0.1*ae_maxrealnumber);
            errspec = errspec||ae_fp_neq(cmatrixrcond1(&a, n, _state),(double)(0));
            errspec = errspec||ae_fp_neq(cmatrixrcondinf(&a, n, _state),(double)(0));
            errspec = errspec||ae_fp_neq(cmatrixlurcond1(&a, n, _state),(double)(0));
            errspec = errspec||ae_fp_neq(cmatrixlurcondinf(&a, n, _state),(double)(0));
        }
    }
    
    /*
     * report
     */
    result = !(((err50||err90)||errless)||errspec);
    ae_frame_leave(_state);
    return result;
}


/*************************************************************************
Returns True for successful test, False - for failed test
*************************************************************************/
static ae_bool testrcondunit_testhpdmatrixrcond(ae_int_t maxn,
     ae_int_t passcount,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_matrix a;
    ae_matrix cha;
    ae_vector p;
    ae_int_t n;
    ae_int_t i;
    ae_int_t j;
    ae_int_t pass;
    ae_bool err50;
    ae_bool err90;
    ae_bool errspec;
    ae_bool errless;
    ae_bool isupper;
    double erc1;
    double ercinf;
    ae_vector q50;
    ae_vector q90;
    double v;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    ae_matrix_init(&a, 0, 0, DT_COMPLEX, _state);
    ae_matrix_init(&cha, 0, 0, DT_COMPLEX, _state);
    ae_vector_init(&p, 0, DT_INT, _state);
    ae_vector_init(&q50, 0, DT_REAL, _state);
    ae_vector_init(&q90, 0, DT_REAL, _state);

    err50 = ae_false;
    err90 = ae_false;
    errless = ae_false;
    errspec = ae_false;
    ae_vector_set_length(&q50, 2, _state);
    ae_vector_set_length(&q90, 2, _state);
    for(n=1; n<=maxn; n++)
    {
        isupper = ae_fp_greater(ae_randomreal(_state),0.5);
        
        /*
         * general test
         */
        ae_matrix_set_length(&a, n, n, _state);
        for(i=0; i<=1; i++)
        {
            q50.ptr.p_double[i] = (double)(0);
            q90.ptr.p_double[i] = (double)(0);
        }
        for(pass=1; pass<=passcount; pass++)
        {
            hpdmatrixrndcond(n, ae_exp(ae_randomreal(_state)*ae_log((double)(1000), _state), _state), &a, _state);
            testrcondunit_cmatrixrefrcond(&a, n, &erc1, &ercinf, _state);
            testrcondunit_cmatrixdrophalf(&a, n, isupper, _state);
            testrcondunit_cmatrixmakeacopy(&a, n, n, &cha, _state);
            hpdmatrixcholesky(&cha, n, isupper, _state);
            
            /*
             * normal
             */
            v = 1/hpdmatrixrcond(&a, n, isupper, _state);
            if( ae_fp_greater_eq(v,testrcondunit_threshold50*erc1) )
            {
                q50.ptr.p_double[0] = q50.ptr.p_double[0]+(double)1/(double)passcount;
            }
            if( ae_fp_greater_eq(v,testrcondunit_threshold90*erc1) )
            {
                q90.ptr.p_double[0] = q90.ptr.p_double[0]+(double)1/(double)passcount;
            }
            errless = errless||ae_fp_greater(v,erc1*1.001);
            
            /*
             * Cholesky
             */
            v = 1/hpdmatrixcholeskyrcond(&cha, n, isupper, _state);
            if( ae_fp_greater_eq(v,testrcondunit_threshold50*erc1) )
            {
                q50.ptr.p_double[1] = q50.ptr.p_double[1]+(double)1/(double)passcount;
            }
            if( ae_fp_greater_eq(v,testrcondunit_threshold90*erc1) )
            {
                q90.ptr.p_double[1] = q90.ptr.p_double[1]+(double)1/(double)passcount;
            }
            errless = errless||ae_fp_greater(v,erc1*1.001);
        }
        for(i=0; i<=1; i++)
        {
            err50 = err50||ae_fp_less(q50.ptr.p_double[i],0.50);
            err90 = err90||ae_fp_less(q90.ptr.p_double[i],0.90);
        }
        
        /*
         * degenerate matrix test
         */
        if( n>=3 )
        {
            ae_matrix_set_length(&a, n, n, _state);
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    a.ptr.pp_complex[i][j] = ae_complex_from_d(0.0);
                }
            }
            a.ptr.pp_complex[0][0] = ae_complex_from_i(1);
            a.ptr.pp_complex[n-1][n-1] = ae_complex_from_i(1);
            errspec = errspec||ae_fp_neq(hpdmatrixrcond(&a, n, isupper, _state),(double)(-1));
            errspec = errspec||ae_fp_neq(hpdmatrixcholeskyrcond(&a, n, isupper, _state),(double)(0));
        }
        
        /*
         * near-degenerate matrix test
         */
        if( n>=2 )
        {
            ae_matrix_set_length(&a, n, n, _state);
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    a.ptr.pp_complex[i][j] = ae_complex_from_d(0.0);
                }
            }
            for(i=0; i<=n-1; i++)
            {
                a.ptr.pp_complex[i][i] = ae_complex_from_i(1);
            }
            i = ae_randominteger(n, _state);
            a.ptr.pp_complex[i][i] = ae_complex_from_d(0.1*ae_maxrealnumber);
            errspec = errspec||ae_fp_neq(hpdmatrixrcond(&a, n, isupper, _state),(double)(0));
            errspec = errspec||ae_fp_neq(hpdmatrixcholeskyrcond(&a, n, isupper, _state),(double)(0));
        }
    }
    
    /*
     * report
     */
    result = !(((err50||err90)||errless)||errspec);
    ae_frame_leave(_state);
    return result;
}



static void testmatinvunit_rmatrixmakeacopy(/* Real    */ ae_matrix* a,
     ae_int_t m,
     ae_int_t n,
     /* Real    */ ae_matrix* b,
     ae_state *_state);
static void testmatinvunit_cmatrixmakeacopy(/* Complex */ ae_matrix* a,
     ae_int_t m,
     ae_int_t n,
     /* Complex */ ae_matrix* b,
     ae_state *_state);
static ae_bool testmatinvunit_rmatrixcheckinverse(/* Real    */ ae_matrix* a,
     /* Real    */ ae_matrix* inva,
     ae_int_t n,
     double threshold,
     ae_int_t info,
     matinvreport* rep,
     ae_state *_state);
static ae_bool testmatinvunit_spdmatrixcheckinverse(/* Real    */ ae_matrix* a,
     /* Real    */ ae_matrix* inva,
     ae_bool isupper,
     ae_int_t n,
     double threshold,
     ae_int_t info,
     matinvreport* rep,
     ae_state *_state);
static ae_bool testmatinvunit_hpdmatrixcheckinverse(/* Complex */ ae_matrix* a,
     /* Complex */ ae_matrix* inva,
     ae_bool isupper,
     ae_int_t n,
     double threshold,
     ae_int_t info,
     matinvreport* rep,
     ae_state *_state);
static ae_bool testmatinvunit_rmatrixcheckinversesingular(/* Real    */ ae_matrix* inva,
     ae_int_t n,
     double threshold,
     ae_int_t info,
     matinvreport* rep,
     ae_state *_state);
static ae_bool testmatinvunit_cmatrixcheckinverse(/* Complex */ ae_matrix* a,
     /* Complex */ ae_matrix* inva,
     ae_int_t n,
     double threshold,
     ae_int_t info,
     matinvreport* rep,
     ae_state *_state);
static ae_bool testmatinvunit_cmatrixcheckinversesingular(/* Complex */ ae_matrix* inva,
     ae_int_t n,
     double threshold,
     ae_int_t info,
     matinvreport* rep,
     ae_state *_state);
static void testmatinvunit_rmatrixdrophalf(/* Real    */ ae_matrix* a,
     ae_int_t n,
     ae_bool droplower,
     ae_state *_state);
static void testmatinvunit_cmatrixdrophalf(/* Complex */ ae_matrix* a,
     ae_int_t n,
     ae_bool droplower,
     ae_state *_state);
static void testmatinvunit_testrtrinv(ae_int_t minn,
     ae_int_t maxn,
     ae_int_t passcount,
     double threshold,
     ae_bool* rtrerrors,
     ae_state *_state);
static void testmatinvunit_testctrinv(ae_int_t minn,
     ae_int_t maxn,
     ae_int_t passcount,
     double threshold,
     ae_bool* ctrerrors,
     ae_state *_state);
static void testmatinvunit_testrinv(ae_int_t minn,
     ae_int_t maxn,
     ae_int_t passcount,
     double threshold,
     ae_bool* rerrors,
     ae_state *_state);
static void testmatinvunit_testcinv(ae_int_t minn,
     ae_int_t maxn,
     ae_int_t passcount,
     double threshold,
     ae_bool* cerrors,
     ae_state *_state);
static void testmatinvunit_testspdinv(ae_int_t minn,
     ae_int_t maxn,
     ae_int_t passcount,
     double threshold,
     ae_bool* spderrors,
     ae_state *_state);
static void testmatinvunit_testhpdinv(ae_int_t minn,
     ae_int_t maxn,
     ae_int_t passcount,
     double threshold,
     ae_bool* hpderrors,
     ae_state *_state);
static void testmatinvunit_unset2d(/* Real    */ ae_matrix* x,
     ae_state *_state);
static void testmatinvunit_unset1d(/* Real    */ ae_vector* x,
     ae_state *_state);
static void testmatinvunit_cunset2d(/* Complex */ ae_matrix* x,
     ae_state *_state);
static void testmatinvunit_cunset1d(/* Complex */ ae_vector* x,
     ae_state *_state);
static void testmatinvunit_unsetrep(matinvreport* r, ae_state *_state);





/*************************************************************************
Test
*************************************************************************/
ae_bool testmatinv(ae_bool silent, ae_state *_state)
{
    ae_frame _frame_block;
    ae_int_t maxrn;
    ae_int_t maxcn;
    ae_int_t largen;
    ae_int_t passcount;
    double threshold;
    double rcondtol;
    ae_bool rtrerrors;
    ae_bool ctrerrors;
    ae_bool rerrors;
    ae_bool cerrors;
    ae_bool spderrors;
    ae_bool hpderrors;
    ae_bool waserrors;
    ae_matrix emptyra;
    ae_matrix emptyca;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    ae_matrix_init(&emptyra, 0, 0, DT_REAL, _state);
    ae_matrix_init(&emptyca, 0, 0, DT_REAL, _state);

    maxrn = 3*ablasblocksize(&emptyra, _state)+1;
    maxcn = 3*ablasblocksize(&emptyca, _state)+1;
    largen = 256;
    passcount = 1;
    threshold = 10000*ae_machineepsilon;
    rcondtol = 0.01;
    rtrerrors = ae_false;
    ctrerrors = ae_false;
    rerrors = ae_false;
    cerrors = ae_false;
    spderrors = ae_false;
    hpderrors = ae_false;
    testmatinvunit_testrtrinv(1, maxrn, passcount, threshold, &rtrerrors, _state);
    testmatinvunit_testctrinv(1, maxcn, passcount, threshold, &ctrerrors, _state);
    testmatinvunit_testrinv(1, maxrn, passcount, threshold, &rerrors, _state);
    testmatinvunit_testspdinv(1, maxrn, passcount, threshold, &spderrors, _state);
    testmatinvunit_testcinv(1, maxcn, passcount, threshold, &cerrors, _state);
    testmatinvunit_testhpdinv(1, maxcn, passcount, threshold, &hpderrors, _state);
    testmatinvunit_testrtrinv(largen, largen, passcount, threshold, &rtrerrors, _state);
    testmatinvunit_testctrinv(largen, largen, passcount, threshold, &ctrerrors, _state);
    testmatinvunit_testrinv(largen, largen, passcount, threshold, &rerrors, _state);
    testmatinvunit_testspdinv(largen, largen, passcount, threshold, &spderrors, _state);
    testmatinvunit_testcinv(largen, largen, passcount, threshold, &cerrors, _state);
    testmatinvunit_testhpdinv(largen, largen, passcount, threshold, &hpderrors, _state);
    waserrors = ((((rtrerrors||ctrerrors)||rerrors)||cerrors)||spderrors)||hpderrors;
    if( !silent )
    {
        printf("TESTING MATINV\n");
        printf("* REAL TRIANGULAR:                        ");
        if( rtrerrors )
        {
            printf("FAILED\n");
        }
        else
        {
            printf("OK\n");
        }
        printf("* COMPLEX TRIANGULAR:                     ");
        if( ctrerrors )
        {
            printf("FAILED\n");
        }
        else
        {
            printf("OK\n");
        }
        printf("* REAL:                                   ");
        if( rerrors )
        {
            printf("FAILED\n");
        }
        else
        {
            printf("OK\n");
        }
        printf("* COMPLEX:                                ");
        if( cerrors )
        {
            printf("FAILED\n");
        }
        else
        {
            printf("OK\n");
        }
        printf("* SPD:                                    ");
        if( spderrors )
        {
            printf("FAILED\n");
        }
        else
        {
            printf("OK\n");
        }
        printf("* HPD:                                    ");
        if( hpderrors )
        {
            printf("FAILED\n");
        }
        else
        {
            printf("OK\n");
        }
        if( waserrors )
        {
            printf("TEST FAILED\n");
        }
        else
        {
            printf("TEST PASSED\n");
        }
    }
    result = !waserrors;
    ae_frame_leave(_state);
    return result;
}


/*************************************************************************
Single-threaded stub. HPC ALGLIB replaces it by multithreaded code.
*************************************************************************/
ae_bool _pexec_testmatinv(ae_bool silent, ae_state *_state)
{
    return testmatinv(silent, _state);
}


/*************************************************************************
Copy
*************************************************************************/
static void testmatinvunit_rmatrixmakeacopy(/* Real    */ ae_matrix* a,
     ae_int_t m,
     ae_int_t n,
     /* Real    */ ae_matrix* b,
     ae_state *_state)
{
    ae_int_t i;
    ae_int_t j;

    ae_matrix_clear(b);

    ae_matrix_set_length(b, m-1+1, n-1+1, _state);
    for(i=0; i<=m-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            b->ptr.pp_double[i][j] = a->ptr.pp_double[i][j];
        }
    }
}


/*************************************************************************
Copy
*************************************************************************/
static void testmatinvunit_cmatrixmakeacopy(/* Complex */ ae_matrix* a,
     ae_int_t m,
     ae_int_t n,
     /* Complex */ ae_matrix* b,
     ae_state *_state)
{
    ae_int_t i;
    ae_int_t j;

    ae_matrix_clear(b);

    ae_matrix_set_length(b, m-1+1, n-1+1, _state);
    for(i=0; i<=m-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            b->ptr.pp_complex[i][j] = a->ptr.pp_complex[i][j];
        }
    }
}


/*************************************************************************
Checks whether inverse is correct
Returns True on success.
*************************************************************************/
static ae_bool testmatinvunit_rmatrixcheckinverse(/* Real    */ ae_matrix* a,
     /* Real    */ ae_matrix* inva,
     ae_int_t n,
     double threshold,
     ae_int_t info,
     matinvreport* rep,
     ae_state *_state)
{
    ae_int_t i;
    ae_int_t j;
    double v;
    ae_bool result;


    result = ae_true;
    if( info<=0 )
    {
        result = ae_false;
    }
    else
    {
        result = result&&!(ae_fp_less(rep->r1,100*ae_machineepsilon)||ae_fp_greater(rep->r1,1+1000*ae_machineepsilon));
        result = result&&!(ae_fp_less(rep->rinf,100*ae_machineepsilon)||ae_fp_greater(rep->rinf,1+1000*ae_machineepsilon));
        for(i=0; i<=n-1; i++)
        {
            for(j=0; j<=n-1; j++)
            {
                v = ae_v_dotproduct(&a->ptr.pp_double[i][0], 1, &inva->ptr.pp_double[0][j], inva->stride, ae_v_len(0,n-1));
                if( i==j )
                {
                    v = v-1;
                }
                result = result&&ae_fp_less_eq(ae_fabs(v, _state),threshold);
            }
        }
    }
    return result;
}


/*************************************************************************
Checks whether inverse is correct
Returns True on success.
*************************************************************************/
static ae_bool testmatinvunit_spdmatrixcheckinverse(/* Real    */ ae_matrix* a,
     /* Real    */ ae_matrix* inva,
     ae_bool isupper,
     ae_int_t n,
     double threshold,
     ae_int_t info,
     matinvreport* rep,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_matrix _a;
    ae_matrix _inva;
    ae_int_t i;
    ae_int_t j;
    double v;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    ae_matrix_init_copy(&_a, a, _state);
    a = &_a;
    ae_matrix_init_copy(&_inva, inva, _state);
    inva = &_inva;

    for(i=0; i<=n-2; i++)
    {
        if( isupper )
        {
            ae_v_move(&a->ptr.pp_double[i+1][i], a->stride, &a->ptr.pp_double[i][i+1], 1, ae_v_len(i+1,n-1));
            ae_v_move(&inva->ptr.pp_double[i+1][i], inva->stride, &inva->ptr.pp_double[i][i+1], 1, ae_v_len(i+1,n-1));
        }
        else
        {
            ae_v_move(&a->ptr.pp_double[i][i+1], 1, &a->ptr.pp_double[i+1][i], a->stride, ae_v_len(i+1,n-1));
            ae_v_move(&inva->ptr.pp_double[i][i+1], 1, &inva->ptr.pp_double[i+1][i], inva->stride, ae_v_len(i+1,n-1));
        }
    }
    result = ae_true;
    if( info<=0 )
    {
        result = ae_false;
    }
    else
    {
        result = result&&!(ae_fp_less(rep->r1,100*ae_machineepsilon)||ae_fp_greater(rep->r1,1+1000*ae_machineepsilon));
        result = result&&!(ae_fp_less(rep->rinf,100*ae_machineepsilon)||ae_fp_greater(rep->rinf,1+1000*ae_machineepsilon));
        for(i=0; i<=n-1; i++)
        {
            for(j=0; j<=n-1; j++)
            {
                v = ae_v_dotproduct(&a->ptr.pp_double[i][0], 1, &inva->ptr.pp_double[0][j], inva->stride, ae_v_len(0,n-1));
                if( i==j )
                {
                    v = v-1;
                }
                result = result&&ae_fp_less_eq(ae_fabs(v, _state),threshold);
            }
        }
    }
    ae_frame_leave(_state);
    return result;
}


/*************************************************************************
Checks whether inverse is correct
Returns True on success.
*************************************************************************/
static ae_bool testmatinvunit_hpdmatrixcheckinverse(/* Complex */ ae_matrix* a,
     /* Complex */ ae_matrix* inva,
     ae_bool isupper,
     ae_int_t n,
     double threshold,
     ae_int_t info,
     matinvreport* rep,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_matrix _a;
    ae_matrix _inva;
    ae_int_t i;
    ae_int_t j;
    ae_complex v;
    ae_bool result;

    ae_frame_make(_state, &_frame_block);
    ae_matrix_init_copy(&_a, a, _state);
    a = &_a;
    ae_matrix_init_copy(&_inva, inva, _state);
    inva = &_inva;

    for(i=0; i<=n-2; i++)
    {
        if( isupper )
        {
            ae_v_cmove(&a->ptr.pp_complex[i+1][i], a->stride, &a->ptr.pp_complex[i][i+1], 1, "Conj", ae_v_len(i+1,n-1));
            ae_v_cmove(&inva->ptr.pp_complex[i+1][i], inva->stride, &inva->ptr.pp_complex[i][i+1], 1, "Conj", ae_v_len(i+1,n-1));
        }
        else
        {
            ae_v_cmove(&a->ptr.pp_complex[i][i+1], 1, &a->ptr.pp_complex[i+1][i], a->stride, "Conj", ae_v_len(i+1,n-1));
            ae_v_cmove(&inva->ptr.pp_complex[i][i+1], 1, &inva->ptr.pp_complex[i+1][i], inva->stride, "Conj", ae_v_len(i+1,n-1));
        }
    }
    result = ae_true;
    if( info<=0 )
    {
        result = ae_false;
    }
    else
    {
        result = result&&!(ae_fp_less(rep->r1,100*ae_machineepsilon)||ae_fp_greater(rep->r1,1+1000*ae_machineepsilon));
        result = result&&!(ae_fp_less(rep->rinf,100*ae_machineepsilon)||ae_fp_greater(rep->rinf,1+1000*ae_machineepsilon));
        for(i=0; i<=n-1; i++)
        {
            for(j=0; j<=n-1; j++)
            {
                v = ae_v_cdotproduct(&a->ptr.pp_complex[i][0], 1, "N", &inva->ptr.pp_complex[0][j], inva->stride, "N", ae_v_len(0,n-1));
                if( i==j )
                {
                    v = ae_c_sub_d(v,1);
                }
                result = result&&ae_fp_less_eq(ae_c_abs(v, _state),threshold);
            }
        }
    }
    ae_frame_leave(_state);
    return result;
}


/*************************************************************************
Checks whether inversion result indicate singular matrix
Returns True on success.
*************************************************************************/
static ae_bool testmatinvunit_rmatrixcheckinversesingular(/* Real    */ ae_matrix* inva,
     ae_int_t n,
     double threshold,
     ae_int_t info,
     matinvreport* rep,
     ae_state *_state)
{
    ae_int_t i;
    ae_int_t j;
    ae_bool result;


    result = ae_true;
    if( info!=-3&&info!=1 )
    {
        result = ae_false;
    }
    else
    {
        result = result&&!(ae_fp_less(rep->r1,(double)(0))||ae_fp_greater(rep->r1,1000*ae_machineepsilon));
        result = result&&!(ae_fp_less(rep->rinf,(double)(0))||ae_fp_greater(rep->rinf,1000*ae_machineepsilon));
        if( info==-3 )
        {
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    result = result&&ae_fp_eq(inva->ptr.pp_double[i][j],(double)(0));
                }
            }
        }
    }
    return result;
}


/*************************************************************************
Checks whether inverse is correct
Returns True on success.
*************************************************************************/
static ae_bool testmatinvunit_cmatrixcheckinverse(/* Complex */ ae_matrix* a,
     /* Complex */ ae_matrix* inva,
     ae_int_t n,
     double threshold,
     ae_int_t info,
     matinvreport* rep,
     ae_state *_state)
{
    ae_int_t i;
    ae_int_t j;
    ae_complex v;
    ae_bool result;


    result = ae_true;
    if( info<=0 )
    {
        result = ae_false;
    }
    else
    {
        result = result&&!(ae_fp_less(rep->r1,100*ae_machineepsilon)||ae_fp_greater(rep->r1,1+1000*ae_machineepsilon));
        result = result&&!(ae_fp_less(rep->rinf,100*ae_machineepsilon)||ae_fp_greater(rep->rinf,1+1000*ae_machineepsilon));
        for(i=0; i<=n-1; i++)
        {
            for(j=0; j<=n-1; j++)
            {
                v = ae_v_cdotproduct(&a->ptr.pp_complex[i][0], 1, "N", &inva->ptr.pp_complex[0][j], inva->stride, "N", ae_v_len(0,n-1));
                if( i==j )
                {
                    v = ae_c_sub_d(v,1);
                }
                result = result&&ae_fp_less_eq(ae_c_abs(v, _state),threshold);
            }
        }
    }
    return result;
}


/*************************************************************************
Checks whether inversion result indicate singular matrix
Returns True on success.
*************************************************************************/
static ae_bool testmatinvunit_cmatrixcheckinversesingular(/* Complex */ ae_matrix* inva,
     ae_int_t n,
     double threshold,
     ae_int_t info,
     matinvreport* rep,
     ae_state *_state)
{
    ae_int_t i;
    ae_int_t j;
    ae_bool result;


    result = ae_true;
    if( info!=-3&&info!=1 )
    {
        result = ae_false;
    }
    else
    {
        result = result&&!(ae_fp_less(rep->r1,(double)(0))||ae_fp_greater(rep->r1,1000*ae_machineepsilon));
        result = result&&!(ae_fp_less(rep->rinf,(double)(0))||ae_fp_greater(rep->rinf,1000*ae_machineepsilon));
        if( info==-3 )
        {
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    result = result&&ae_c_eq_d(inva->ptr.pp_complex[i][j],(double)(0));
                }
            }
        }
    }
    return result;
}


/*************************************************************************
Drops upper or lower half of the matrix - fills it by special pattern
which may be used later to ensure that this part wasn't changed
*************************************************************************/
static void testmatinvunit_rmatrixdrophalf(/* Real    */ ae_matrix* a,
     ae_int_t n,
     ae_bool droplower,
     ae_state *_state)
{
    ae_int_t i;
    ae_int_t j;


    for(i=0; i<=n-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            if( (droplower&&i>j)||(!droplower&&i<j) )
            {
                a->ptr.pp_double[i][j] = (double)(1+2*i+3*j);
            }
        }
    }
}


/*************************************************************************
Drops upper or lower half of the matrix - fills it by special pattern
which may be used later to ensure that this part wasn't changed
*************************************************************************/
static void testmatinvunit_cmatrixdrophalf(/* Complex */ ae_matrix* a,
     ae_int_t n,
     ae_bool droplower,
     ae_state *_state)
{
    ae_int_t i;
    ae_int_t j;


    for(i=0; i<=n-1; i++)
    {
        for(j=0; j<=n-1; j++)
        {
            if( (droplower&&i>j)||(!droplower&&i<j) )
            {
                a->ptr.pp_complex[i][j] = ae_complex_from_i(1+2*i+3*j);
            }
        }
    }
}


/*************************************************************************
Real TR inverse
*************************************************************************/
static void testmatinvunit_testrtrinv(ae_int_t minn,
     ae_int_t maxn,
     ae_int_t passcount,
     double threshold,
     ae_bool* rtrerrors,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_matrix a;
    ae_matrix b;
    ae_int_t n;
    ae_int_t pass;
    ae_int_t i;
    ae_int_t j;
    ae_int_t task;
    ae_bool isupper;
    ae_bool isunit;
    double v;
    ae_bool waserrors;
    ae_int_t info;
    matinvreport rep;

    ae_frame_make(_state, &_frame_block);
    ae_matrix_init(&a, 0, 0, DT_REAL, _state);
    ae_matrix_init(&b, 0, 0, DT_REAL, _state);
    _matinvreport_init(&rep, _state);

    waserrors = ae_false;
    
    /*
     * Test
     */
    for(n=minn; n<=maxn; n++)
    {
        ae_matrix_set_length(&a, n, n, _state);
        ae_matrix_set_length(&b, n, n, _state);
        for(task=0; task<=3; task++)
        {
            for(pass=1; pass<=passcount; pass++)
            {
                
                /*
                 * Determine task
                 */
                isupper = task%2==0;
                isunit = task/2%2==0;
                
                /*
                 * Generate matrix
                 */
                for(i=0; i<=n-1; i++)
                {
                    for(j=0; j<=n-1; j++)
                    {
                        if( i==j )
                        {
                            a.ptr.pp_double[i][i] = 1+ae_randomreal(_state);
                        }
                        else
                        {
                            a.ptr.pp_double[i][j] = 0.2*ae_randomreal(_state)-0.1;
                        }
                        b.ptr.pp_double[i][j] = a.ptr.pp_double[i][j];
                    }
                }
                
                /*
                 * Inverse
                 */
                rmatrixtrinverse(&b, n, isupper, isunit, &info, &rep, _state);
                if( info<=0 )
                {
                    *rtrerrors = ae_true;
                    ae_frame_leave(_state);
                    return;
                }
                
                /*
                 * Structural test
                 */
                if( isunit )
                {
                    for(i=0; i<=n-1; i++)
                    {
                        *rtrerrors = *rtrerrors||ae_fp_neq(a.ptr.pp_double[i][i],b.ptr.pp_double[i][i]);
                    }
                }
                if( isupper )
                {
                    for(i=0; i<=n-1; i++)
                    {
                        for(j=0; j<=i-1; j++)
                        {
                            *rtrerrors = *rtrerrors||ae_fp_neq(a.ptr.pp_double[i][j],b.ptr.pp_double[i][j]);
                        }
                    }
                }
                else
                {
                    for(i=0; i<=n-1; i++)
                    {
                        for(j=i+1; j<=n-1; j++)
                        {
                            *rtrerrors = *rtrerrors||ae_fp_neq(a.ptr.pp_double[i][j],b.ptr.pp_double[i][j]);
                        }
                    }
                }
                
                /*
                 * Inverse test
                 */
                for(i=0; i<=n-1; i++)
                {
                    for(j=0; j<=n-1; j++)
                    {
                        if( (j<i&&isupper)||(j>i&&!isupper) )
                        {
                            a.ptr.pp_double[i][j] = (double)(0);
                            b.ptr.pp_double[i][j] = (double)(0);
                        }
                    }
                }
                if( isunit )
                {
                    for(i=0; i<=n-1; i++)
                    {
                        a.ptr.pp_double[i][i] = (double)(1);
                        b.ptr.pp_double[i][i] = (double)(1);
                    }
                }
                for(i=0; i<=n-1; i++)
                {
                    for(j=0; j<=n-1; j++)
                    {
                        v = ae_v_dotproduct(&a.ptr.pp_double[i][0], 1, &b.ptr.pp_double[0][j], b.stride, ae_v_len(0,n-1));
                        if( j!=i )
                        {
                            *rtrerrors = *rtrerrors||ae_fp_greater(ae_fabs(v, _state),threshold);
                        }
                        else
                        {
                            *rtrerrors = *rtrerrors||ae_fp_greater(ae_fabs(v-1, _state),threshold);
                        }
                    }
                }
            }
        }
    }
    ae_frame_leave(_state);
}


/*************************************************************************
Complex TR inverse
*************************************************************************/
static void testmatinvunit_testctrinv(ae_int_t minn,
     ae_int_t maxn,
     ae_int_t passcount,
     double threshold,
     ae_bool* ctrerrors,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_matrix a;
    ae_matrix b;
    ae_int_t n;
    ae_int_t pass;
    ae_int_t i;
    ae_int_t j;
    ae_int_t task;
    ae_bool isupper;
    ae_bool isunit;
    ae_complex v;
    ae_bool waserrors;
    ae_int_t info;
    matinvreport rep;

    ae_frame_make(_state, &_frame_block);
    ae_matrix_init(&a, 0, 0, DT_COMPLEX, _state);
    ae_matrix_init(&b, 0, 0, DT_COMPLEX, _state);
    _matinvreport_init(&rep, _state);

    waserrors = ae_false;
    
    /*
     * Test
     */
    for(n=minn; n<=maxn; n++)
    {
        ae_matrix_set_length(&a, n, n, _state);
        ae_matrix_set_length(&b, n, n, _state);
        for(task=0; task<=3; task++)
        {
            for(pass=1; pass<=passcount; pass++)
            {
                
                /*
                 * Determine task
                 */
                isupper = task%2==0;
                isunit = task/2%2==0;
                
                /*
                 * Generate matrix
                 */
                for(i=0; i<=n-1; i++)
                {
                    for(j=0; j<=n-1; j++)
                    {
                        if( i==j )
                        {
                            a.ptr.pp_complex[i][i].x = 1+ae_randomreal(_state);
                            a.ptr.pp_complex[i][i].y = 1+ae_randomreal(_state);
                        }
                        else
                        {
                            a.ptr.pp_complex[i][j].x = 0.2*ae_randomreal(_state)-0.1;
                            a.ptr.pp_complex[i][j].y = 0.2*ae_randomreal(_state)-0.1;
                        }
                        b.ptr.pp_complex[i][j] = a.ptr.pp_complex[i][j];
                    }
                }
                
                /*
                 * Inverse
                 */
                cmatrixtrinverse(&b, n, isupper, isunit, &info, &rep, _state);
                if( info<=0 )
                {
                    *ctrerrors = ae_true;
                    ae_frame_leave(_state);
                    return;
                }
                
                /*
                 * Structural test
                 */
                if( isunit )
                {
                    for(i=0; i<=n-1; i++)
                    {
                        *ctrerrors = *ctrerrors||ae_c_neq(a.ptr.pp_complex[i][i],b.ptr.pp_complex[i][i]);
                    }
                }
                if( isupper )
                {
                    for(i=0; i<=n-1; i++)
                    {
                        for(j=0; j<=i-1; j++)
                        {
                            *ctrerrors = *ctrerrors||ae_c_neq(a.ptr.pp_complex[i][j],b.ptr.pp_complex[i][j]);
                        }
                    }
                }
                else
                {
                    for(i=0; i<=n-1; i++)
                    {
                        for(j=i+1; j<=n-1; j++)
                        {
                            *ctrerrors = *ctrerrors||ae_c_neq(a.ptr.pp_complex[i][j],b.ptr.pp_complex[i][j]);
                        }
                    }
                }
                
                /*
                 * Inverse test
                 */
                for(i=0; i<=n-1; i++)
                {
                    for(j=0; j<=n-1; j++)
                    {
                        if( (j<i&&isupper)||(j>i&&!isupper) )
                        {
                            a.ptr.pp_complex[i][j] = ae_complex_from_i(0);
                            b.ptr.pp_complex[i][j] = ae_complex_from_i(0);
                        }
                    }
                }
                if( isunit )
                {
                    for(i=0; i<=n-1; i++)
                    {
                        a.ptr.pp_complex[i][i] = ae_complex_from_i(1);
                        b.ptr.pp_complex[i][i] = ae_complex_from_i(1);
                    }
                }
                for(i=0; i<=n-1; i++)
                {
                    for(j=0; j<=n-1; j++)
                    {
                        v = ae_v_cdotproduct(&a.ptr.pp_complex[i][0], 1, "N", &b.ptr.pp_complex[0][j], b.stride, "N", ae_v_len(0,n-1));
                        if( j!=i )
                        {
                            *ctrerrors = *ctrerrors||ae_fp_greater(ae_c_abs(v, _state),threshold);
                        }
                        else
                        {
                            *ctrerrors = *ctrerrors||ae_fp_greater(ae_c_abs(ae_c_sub_d(v,1), _state),threshold);
                        }
                    }
                }
            }
        }
    }
    ae_frame_leave(_state);
}


/*************************************************************************
Real test
*************************************************************************/
static void testmatinvunit_testrinv(ae_int_t minn,
     ae_int_t maxn,
     ae_int_t passcount,
     double threshold,
     ae_bool* rerrors,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_matrix a;
    ae_matrix lua;
    ae_matrix inva;
    ae_matrix invlua;
    ae_vector p;
    ae_int_t i;
    ae_int_t j;
    ae_int_t k;
    ae_int_t n;
    ae_int_t pass;
    ae_int_t taskkind;
    ae_int_t info;
    matinvreport rep;

    ae_frame_make(_state, &_frame_block);
    ae_matrix_init(&a, 0, 0, DT_REAL, _state);
    ae_matrix_init(&lua, 0, 0, DT_REAL, _state);
    ae_matrix_init(&inva, 0, 0, DT_REAL, _state);
    ae_matrix_init(&invlua, 0, 0, DT_REAL, _state);
    ae_vector_init(&p, 0, DT_INT, _state);
    _matinvreport_init(&rep, _state);

    
    /*
     * General square matrices:
     * * test general solvers
     * * test least squares solver
     */
    for(pass=1; pass<=passcount; pass++)
    {
        for(n=minn; n<=maxn; n++)
        {
            
            /*
             * ********************************************************
             * WELL CONDITIONED TASKS
             * ability to find correct solution is tested
             * ********************************************************
             *
             * 1. generate random well conditioned matrix A.
             * 2. generate random solution vector xe
             * 3. generate right part b=A*xe
             * 4. test different methods on original A
             */
            rmatrixrndcond(n, (double)(1000), &a, _state);
            testmatinvunit_rmatrixmakeacopy(&a, n, n, &lua, _state);
            rmatrixlu(&lua, n, n, &p, _state);
            testmatinvunit_rmatrixmakeacopy(&a, n, n, &inva, _state);
            testmatinvunit_rmatrixmakeacopy(&lua, n, n, &invlua, _state);
            info = 0;
            testmatinvunit_unsetrep(&rep, _state);
            rmatrixinverse(&inva, n, &info, &rep, _state);
            *rerrors = *rerrors||!testmatinvunit_rmatrixcheckinverse(&a, &inva, n, threshold, info, &rep, _state);
            info = 0;
            testmatinvunit_unsetrep(&rep, _state);
            rmatrixluinverse(&invlua, &p, n, &info, &rep, _state);
            *rerrors = *rerrors||!testmatinvunit_rmatrixcheckinverse(&a, &invlua, n, threshold, info, &rep, _state);
            
            /*
             * ********************************************************
             * EXACTLY SINGULAR MATRICES
             * ability to detect singularity is tested
             * ********************************************************
             *
             * 1. generate different types of singular matrices:
             *    * zero
             *    * with zero columns
             *    * with zero rows
             *    * with equal rows/columns
             * 2. test different methods
             */
            for(taskkind=0; taskkind<=4; taskkind++)
            {
                testmatinvunit_unset2d(&a, _state);
                if( taskkind==0 )
                {
                    
                    /*
                     * all zeros
                     */
                    ae_matrix_set_length(&a, n, n, _state);
                    for(i=0; i<=n-1; i++)
                    {
                        for(j=0; j<=n-1; j++)
                        {
                            a.ptr.pp_double[i][j] = (double)(0);
                        }
                    }
                }
                if( taskkind==1 )
                {
                    
                    /*
                     * there is zero column
                     */
                    ae_matrix_set_length(&a, n, n, _state);
                    for(i=0; i<=n-1; i++)
                    {
                        for(j=0; j<=n-1; j++)
                        {
                            a.ptr.pp_double[i][j] = 2*ae_randomreal(_state)-1;
                        }
                    }
                    k = ae_randominteger(n, _state);
                    ae_v_muld(&a.ptr.pp_double[0][k], a.stride, ae_v_len(0,n-1), 0);
                }
                if( taskkind==2 )
                {
                    
                    /*
                     * there is zero row
                     */
                    ae_matrix_set_length(&a, n, n, _state);
                    for(i=0; i<=n-1; i++)
                    {
                        for(j=0; j<=n-1; j++)
                        {
                            a.ptr.pp_double[i][j] = 2*ae_randomreal(_state)-1;
                        }
                    }
                    k = ae_randominteger(n, _state);
                    ae_v_muld(&a.ptr.pp_double[k][0], 1, ae_v_len(0,n-1), 0);
                }
                if( taskkind==3 )
                {
                    
                    /*
                     * equal columns
                     */
                    if( n<2 )
                    {
                        continue;
                    }
                    ae_matrix_set_length(&a, n, n, _state);
                    for(i=0; i<=n-1; i++)
                    {
                        for(j=0; j<=n-1; j++)
                        {
                            a.ptr.pp_double[i][j] = 2*ae_randomreal(_state)-1;
                        }
                    }
                    k = 1+ae_randominteger(n-1, _state);
                    ae_v_move(&a.ptr.pp_double[0][0], a.stride, &a.ptr.pp_double[0][k], a.stride, ae_v_len(0,n-1));
                }
                if( taskkind==4 )
                {
                    
                    /*
                     * equal rows
                     */
                    if( n<2 )
                    {
                        continue;
                    }
                    ae_matrix_set_length(&a, n, n, _state);
                    for(i=0; i<=n-1; i++)
                    {
                        for(j=0; j<=n-1; j++)
                        {
                            a.ptr.pp_double[i][j] = 2*ae_randomreal(_state)-1;
                        }
                    }
                    k = 1+ae_randominteger(n-1, _state);
                    ae_v_move(&a.ptr.pp_double[0][0], 1, &a.ptr.pp_double[k][0], 1, ae_v_len(0,n-1));
                }
                testmatinvunit_rmatrixmakeacopy(&a, n, n, &lua, _state);
                rmatrixlu(&lua, n, n, &p, _state);
                info = 0;
                testmatinvunit_unsetrep(&rep, _state);
                rmatrixinverse(&a, n, &info, &rep, _state);
                *rerrors = *rerrors||!testmatinvunit_rmatrixcheckinversesingular(&a, n, threshold, info, &rep, _state);
                info = 0;
                testmatinvunit_unsetrep(&rep, _state);
                rmatrixluinverse(&lua, &p, n, &info, &rep, _state);
                *rerrors = *rerrors||!testmatinvunit_rmatrixcheckinversesingular(&lua, n, threshold, info, &rep, _state);
            }
        }
    }
    ae_frame_leave(_state);
}


/*************************************************************************
Complex test
*************************************************************************/
static void testmatinvunit_testcinv(ae_int_t minn,
     ae_int_t maxn,
     ae_int_t passcount,
     double threshold,
     ae_bool* cerrors,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_matrix a;
    ae_matrix lua;
    ae_matrix inva;
    ae_matrix invlua;
    ae_vector p;
    ae_int_t i;
    ae_int_t j;
    ae_int_t k;
    ae_int_t n;
    ae_int_t pass;
    ae_int_t taskkind;
    ae_int_t info;
    matinvreport rep;

    ae_frame_make(_state, &_frame_block);
    ae_matrix_init(&a, 0, 0, DT_COMPLEX, _state);
    ae_matrix_init(&lua, 0, 0, DT_COMPLEX, _state);
    ae_matrix_init(&inva, 0, 0, DT_COMPLEX, _state);
    ae_matrix_init(&invlua, 0, 0, DT_COMPLEX, _state);
    ae_vector_init(&p, 0, DT_INT, _state);
    _matinvreport_init(&rep, _state);

    
    /*
     * General square matrices:
     * * test general solvers
     * * test least squares solver
     */
    for(pass=1; pass<=passcount; pass++)
    {
        for(n=minn; n<=maxn; n++)
        {
            
            /*
             * ********************************************************
             * WELL CONDITIONED TASKS
             * ability to find correct solution is tested
             * ********************************************************
             *
             * 1. generate random well conditioned matrix A.
             * 2. generate random solution vector xe
             * 3. generate right part b=A*xe
             * 4. test different methods on original A
             */
            cmatrixrndcond(n, (double)(1000), &a, _state);
            testmatinvunit_cmatrixmakeacopy(&a, n, n, &lua, _state);
            cmatrixlu(&lua, n, n, &p, _state);
            testmatinvunit_cmatrixmakeacopy(&a, n, n, &inva, _state);
            testmatinvunit_cmatrixmakeacopy(&lua, n, n, &invlua, _state);
            info = 0;
            testmatinvunit_unsetrep(&rep, _state);
            cmatrixinverse(&inva, n, &info, &rep, _state);
            *cerrors = *cerrors||!testmatinvunit_cmatrixcheckinverse(&a, &inva, n, threshold, info, &rep, _state);
            info = 0;
            testmatinvunit_unsetrep(&rep, _state);
            cmatrixluinverse(&invlua, &p, n, &info, &rep, _state);
            *cerrors = *cerrors||!testmatinvunit_cmatrixcheckinverse(&a, &invlua, n, threshold, info, &rep, _state);
            
            /*
             * ********************************************************
             * EXACTLY SINGULAR MATRICES
             * ability to detect singularity is tested
             * ********************************************************
             *
             * 1. generate different types of singular matrices:
             *    * zero
             *    * with zero columns
             *    * with zero rows
             *    * with equal rows/columns
             * 2. test different methods
             */
            for(taskkind=0; taskkind<=4; taskkind++)
            {
                testmatinvunit_cunset2d(&a, _state);
                if( taskkind==0 )
                {
                    
                    /*
                     * all zeros
                     */
                    ae_matrix_set_length(&a, n, n, _state);
                    for(i=0; i<=n-1; i++)
                    {
                        for(j=0; j<=n-1; j++)
                        {
                            a.ptr.pp_complex[i][j] = ae_complex_from_i(0);
                        }
                    }
                }
                if( taskkind==1 )
                {
                    
                    /*
                     * there is zero column
                     */
                    ae_matrix_set_length(&a, n, n, _state);
                    for(i=0; i<=n-1; i++)
                    {
                        for(j=0; j<=n-1; j++)
                        {
                            a.ptr.pp_complex[i][j].x = 2*ae_randomreal(_state)-1;
                            a.ptr.pp_complex[i][j].y = 2*ae_randomreal(_state)-1;
                        }
                    }
                    k = ae_randominteger(n, _state);
                    ae_v_cmuld(&a.ptr.pp_complex[0][k], a.stride, ae_v_len(0,n-1), 0);
                }
                if( taskkind==2 )
                {
                    
                    /*
                     * there is zero row
                     */
                    ae_matrix_set_length(&a, n, n, _state);
                    for(i=0; i<=n-1; i++)
                    {
                        for(j=0; j<=n-1; j++)
                        {
                            a.ptr.pp_complex[i][j].x = 2*ae_randomreal(_state)-1;
                            a.ptr.pp_complex[i][j].y = 2*ae_randomreal(_state)-1;
                        }
                    }
                    k = ae_randominteger(n, _state);
                    ae_v_cmuld(&a.ptr.pp_complex[k][0], 1, ae_v_len(0,n-1), 0);
                }
                if( taskkind==3 )
                {
                    
                    /*
                     * equal columns
                     */
                    if( n<2 )
                    {
                        continue;
                    }
                    ae_matrix_set_length(&a, n, n, _state);
                    for(i=0; i<=n-1; i++)
                    {
                        for(j=0; j<=n-1; j++)
                        {
                            a.ptr.pp_complex[i][j].x = 2*ae_randomreal(_state)-1;
                            a.ptr.pp_complex[i][j].y = 2*ae_randomreal(_state)-1;
                        }
                    }
                    k = 1+ae_randominteger(n-1, _state);
                    ae_v_cmove(&a.ptr.pp_complex[0][0], a.stride, &a.ptr.pp_complex[0][k], a.stride, "N", ae_v_len(0,n-1));
                }
                if( taskkind==4 )
                {
                    
                    /*
                     * equal rows
                     */
                    if( n<2 )
                    {
                        continue;
                    }
                    ae_matrix_set_length(&a, n, n, _state);
                    for(i=0; i<=n-1; i++)
                    {
                        for(j=0; j<=n-1; j++)
                        {
                            a.ptr.pp_complex[i][j].x = 2*ae_randomreal(_state)-1;
                            a.ptr.pp_complex[i][j].y = 2*ae_randomreal(_state)-1;
                        }
                    }
                    k = 1+ae_randominteger(n-1, _state);
                    ae_v_cmove(&a.ptr.pp_complex[0][0], 1, &a.ptr.pp_complex[k][0], 1, "N", ae_v_len(0,n-1));
                }
                testmatinvunit_cmatrixmakeacopy(&a, n, n, &lua, _state);
                cmatrixlu(&lua, n, n, &p, _state);
                info = 0;
                testmatinvunit_unsetrep(&rep, _state);
                cmatrixinverse(&a, n, &info, &rep, _state);
                *cerrors = *cerrors||!testmatinvunit_cmatrixcheckinversesingular(&a, n, threshold, info, &rep, _state);
                info = 0;
                testmatinvunit_unsetrep(&rep, _state);
                cmatrixluinverse(&lua, &p, n, &info, &rep, _state);
                *cerrors = *cerrors||!testmatinvunit_cmatrixcheckinversesingular(&lua, n, threshold, info, &rep, _state);
            }
        }
    }
    ae_frame_leave(_state);
}


/*************************************************************************
SPD test
*************************************************************************/
static void testmatinvunit_testspdinv(ae_int_t minn,
     ae_int_t maxn,
     ae_int_t passcount,
     double threshold,
     ae_bool* spderrors,
     ae_state *_state)
{
    ae_frame _frame_block;
    ae_matrix a;
    ae_matrix cha;
    ae_matrix inva;
    ae_matrix invcha;
    ae_bool isupper;
    ae_int_t i;
    ae_int_t j;
    ae_int_t k;
    ae_int_t n;
    ae_int_t pass;
    ae_int_t taskkind;
    ae_int_t info;
    matinvreport rep;

    ae_frame_make(_state, &_frame_block);
    ae_matrix_init(&a, 0, 0, DT_REAL, _state);
    ae_matrix_init(&cha, 0, 0, DT_REAL, _state);
    ae_matrix_init(&inva, 0, 0, DT_REAL, _state);
    ae_matrix_init(&invcha, 0, 0, DT_REAL, _state);
    _matinvreport_init(&rep, _state);

    
    /*
     * General square matrices:
     * * test general solvers
     * * test least squares solver
     */
    for(pass=1; pass<=passcount; pass++)
    {
        for(n=minn; n<=maxn; n++)
        {
            isupper = ae_fp_greater(ae_randomreal(_state),0.5);
            
            /*
             * ********************************************************
             * WELL CONDITIONED TASKS
             * ability to find correct solution is tested
             * ********************************************************
             *
             * 1. generate random well conditioned matrix A.
             * 2. generate random solution vector xe
             * 3. generate right part b=A*xe
             * 4. test different methods on original A
             */
            spdmatrixrndcond(n, (double)(1000), &a, _state);
            testmatinvunit_rmatrixdrophalf(&a, n, isupper, _state);
            testmatinvunit_rmatrixmakeacopy(&a, n, n, &cha, _state);
            if( !spdmatrixcholesky(&cha, n, isupper, _state) )
            {
                continue;
            }
            testmatinvunit_rmatrixmakeacopy(&a, n, n, &inva, _state);
            testmatinvunit_rmatrixmakeacopy(&cha, n, n, &invcha, _state);
            info = 0;
            testmatinvunit_unsetrep(&rep, _state);
 