;;; -*- Mode: Lisp; Syntax: Common-Lisp; Package: sds-api-csf -*-

;;; This file is autogenerated by the SDS API Generator.

(in-package :sds-api-csf)
(define-sds-module csf)

(def-sds-const CSF "csf")
(def-sds-const LOCATION "location")
(def-sds-const PACKAGE "package")
(def-sds-const INFO "info")
(def-sds-const CLASS "class")
(def-sds-const METHOD "method")
(def-sds-const WHERE "where")
(def-sds-const RETVAL "retval")
(def-sds-const ARG "arg")
(def-sds-const VARIABLE "variable")
(def-sds-const ENUM "enum")
(def-sds-const ENUMVAL "enumval")
(def-sds-const TYPESPEC "typespec")
(def-sds-const ACCESS "access")
(def-sds-const INHERIT "inherit")
(def-sds-const COMMENT "comment")
(def-sds-const DIRECTIVE "directive")
(def-sds-const TEXT "text")


(def-sds-class toplevel
   (language content )
  csf)

(def-sds-class package
   (id name location info content )
  package)

(def-sds-class class
   (id name location access parents info content )
  class)

(def-sds-class method
   (id name where access info retvals args content )
  method)

(def-sds-class variable
   (id name location access info )
  variable)

(def-sds-class enum
   (id name location access values )
  enum)

(def-sds-class enumval
   (name value )
  enumval)

(def-sds-class typespec
   (id name location access info )
  typespec)

(def-sds-class comment
   (location text )
  comment)

(def-sds-class directive
   (name value info location )
  directive)

(def-sds-class retval
   (info )
  retval)

(def-sds-class arg
   (info )
  arg)

(def-sds-class info
   (type value info )
  info)

(def-sds-class access
   (visibility scope )
  access)

(def-sds-class inherit
   (name info )
  inherit)

(def-sds-class where
   (what location )
  where)

(def-sds-class location
   (file startline startcol endline endcol position )
  location)

(defmethod initialize-instance :after ((obj csf-toplevel) &key)
  (add-attributes obj
     (STRING "language" language)
  )
  (add-subelements obj
     (PTRLIST "package" content)
     (PTRLIST "method" content)
     (PTRLIST "class" content)
     (PTRLIST "enum" content)
     (PTRLIST "variable" content)
     (PTRLIST "typespec" content)
     (PTRLIST "comment" content)
     (PTRLIST "directive" content)
  )
)

(defmethod initialize-instance :after ((obj csf-package) &key)
  (add-attributes obj
     (STRING "id" id)
     (STRING "name" name)
  )
  (add-subelements obj
     (PTR "location" location)
     (PTRLIST "info" info)
     (PTRLIST "package" content)
     (PTRLIST "method" content)
     (PTRLIST "class" content)
     (PTRLIST "enum" content)
     (PTRLIST "variable" content)
     (PTRLIST "typespec" content)
     (PTRLIST "comment" content)
     (PTRLIST "directive" content)
  )
)

(defmethod initialize-instance :after ((obj csf-class) &key)
  (add-attributes obj
     (STRING "id" id)
     (STRING "name" name)
  )
  (add-subelements obj
     (PTR "location" location)
     (PTR "access" access)
     (PTRLIST "inherit" parents)
     (PTRLIST "info" info)
     (PTRLIST "package" content)
     (PTRLIST "method" content)
     (PTRLIST "class" content)
     (PTRLIST "enum" content)
     (PTRLIST "variable" content)
     (PTRLIST "typespec" content)
     (PTRLIST "comment" content)
     (PTRLIST "directive" content)
  )
)

(defmethod initialize-instance :after ((obj csf-method) &key)
  (add-attributes obj
     (STRING "id" id)
     (STRING "name" name)
  )
  (add-subelements obj
     (PTRLIST "where" where)
     (PTR "access" access)
     (PTRLIST "info" info)
     (PTRLIST "retval" retvals)
     (PTRLIST "arg" args)
     (PTRLIST "package" content)
     (PTRLIST "method" content)
     (PTRLIST "class" content)
     (PTRLIST "enum" content)
     (PTRLIST "variable" content)
     (PTRLIST "typespec" content)
     (PTRLIST "comment" content)
     (PTRLIST "directive" content)
  )
)

(defmethod initialize-instance :after ((obj csf-variable) &key)
  (add-attributes obj
     (STRING "id" id)
     (STRING "name" name)
  )
  (add-subelements obj
     (PTR "location" location)
     (PTR "access" access)
     (PTRLIST "info" info)
  )
)

(defmethod initialize-instance :after ((obj csf-enum) &key)
  (add-attributes obj
     (STRING "id" id)
     (STRING "name" name)
  )
  (add-subelements obj
     (PTR "location" location)
     (PTR "access" access)
     (PTRLIST "enumval" values)
  )
)

(defmethod initialize-instance :after ((obj csf-enumval) &key)
  (add-attributes obj
     (STRING "name" name)
     (STRING "value" value)
  )
)

(defmethod initialize-instance :after ((obj csf-typespec) &key)
  (add-attributes obj
     (STRING "id" id)
     (STRING "name" name)
  )
  (add-subelements obj
     (PTR "location" location)
     (PTR "access" access)
     (PTRLIST "info" info)
  )
)

(defmethod initialize-instance :after ((obj csf-comment) &key)
  (add-subelements obj
     (PTR "location" location)
     (STRING "text" text)
  )
)

(defmethod initialize-instance :after ((obj csf-directive) &key)
  (add-attributes obj
     (STRING "name" name)
     (STRING "info" info)
     (STRING "value" value)
  )
  (add-subelements obj
     (PTR "location" location)
  )
)

(defmethod initialize-instance :after ((obj csf-retval) &key)
  (add-subelements obj
     (PTRLIST "info" info)
  )
)

(defmethod initialize-instance :after ((obj csf-arg) &key)
  (add-subelements obj
     (PTRLIST "info" info)
  )
)

(defmethod initialize-instance :after ((obj csf-info) &key)
  (add-attributes obj
     (STRING "type" type)
     (STRING "value" value)
     (STRING "info" info)
  )
)

(defmethod initialize-instance :after ((obj csf-access) &key)
  (add-attributes obj
     (STRING "visibility" visibility)
     (STRING "scope" scope)
  )
)

(defmethod initialize-instance :after ((obj csf-inherit) &key)
  (add-attributes obj
     (STRING "name" name)
  )
  (add-subelements obj
     (PTRLIST "info" info)
  )
)

(defmethod initialize-instance :after ((obj csf-where) &key)
  (add-attributes obj
     (STRING "what" what)
  )
  (add-subelements obj
     (PTR "location" location)
  )
)

(defmethod initialize-instance :after ((obj csf-location) &key)
  (add-attributes obj
     (STRING "file" file)
     (STRING "startline" startline)
     (STRING "startcol" startcol)
     (STRING "endline" endline)
     (STRING "endcol" endcol)
     (STRING "position" position)
  )
)


(create-obj-constructors (toplevel csf)
                         (package package)
                         (class class)
                         (method method)
                         (variable variable)
                         (enum enum)
                         (enumval enumval)
                         (typespec typespec)
                         (comment comment)
                         (directive directive)
                         (retval retval)
                         (arg arg)
                         (info info)
                         (access access)
                         (inherit inherit)
                         (where where)
                         (location location))

(eval-when (:compile-toplevel :load-toplevel :execute)
  (defclass csf-factory (xml-factory) ()))
(defun make-csf-factory ()  (make-instance 'csf-factory :name "csf factory"))

(defmethod produce-xml-object ((factory csf-factory) classname)
  (let ((fn (get-constructor classname))
        (retval nil))
    (if fn 
        (setf retval (apply fn '())) 
      (warn "No good value from ~a, asked for: ~a" (factory.name factory) classname))
    retval
    ))
