;;; -*- Mode: Lisp; Syntax: Common-Lisp; Package: APISPEC -*-

#|

DESC: apispec/api-cpp.lisp - the code for generating c++ APIs
Copyright (c) 1998-2000 - Stig Erik Sand

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

|#

(in-package :sds-api-apispec)

(defun cppify-word (word &optional class-name)
  "just forwards to JAVIFY-WORD"
  (javaify-word word class-name))

(defun get-cpp-function (retval func-signature body)
  (format nil "~A~%~A {~%~A~&}~2%"
	  retval func-signature body))

;; make me a generic later
(defmethod get-name-of-constant ((lang api-lang-cpp) const)
  (format nil "GENERATED_CONSTANT_~:@(~a~)" 
	  (cppify-word (if (typep const 'apispec-constant)
			   (car (apispec-constant.name const))
			 const))))

(defmethod get-name-of-class ((lang api-lang-cpp) api-name obj)
  (strcat api-name "_"  (cppify-word (car (apispec-class.name obj)) t)))

(defmethod get-the-actual-type ((lang api-lang-cpp) key)
  (cond
   ((string-equal key "string") "Sstring")
   ((string-equal key "stringlist") "Sarray<Sstring>")
   ((string-equal key "ptr") "XML_ParseablePtr")
   ((string-equal key "ptrlist") "Sarray<XML_ParseablePtr>")
   (t (warn "Unable to understand the type ~a" key))))

(defmethod output-declarations ((obj apispec-toplevel) (lang api-lang-cpp) stream some-name)
  (declare (ignore some-name))
  
  (let ((api-name (car (apispec-toplevel.name obj))))

    (format stream "#ifndef AUTOGENERATED_SDS_API_~a~%" api-name)    
    (format stream "#define AUTOGENERATED_SDS_API_~a~2%" api-name)    

    (format stream "/// This file is autogenerated by the SDS API Generator.~2%")

    (format stream "#include <abstract.H>~2%")
    
    (let ((classes (apispec-toplevel.classes obj)))
      (dolist (c classes)
	(output-declarations c lang stream api-name)))

    (format stream "~2&class ~a_Factory : public XML_Factory {~%" api-name)
    (format stream "public:~%")
    (format stream "   virtual XML_ParseablePtr create(const Sstring &theClass) const;~%")
    (format stream "};~2%")

    
    (format stream "#endif /* AUTOGENERATED_SDS_API_~a */~%" api-name)    
    ))

(defmethod output-declarations ((obj apispec-class) (lang api-lang-cpp) stream api-name)

  (let ((cl-name (get-name-of-class lang api-name obj)))
  
    (format stream "class ~a : public XML_Parseable {~%" cl-name)
    (format stream "public:~%")
    (format stream "   ~a();~%" cl-name)
    (format stream "   virtual ~~~a();~2%" cl-name)

    (format stream "   virtual XML_Parseable *copy() const;~%")
    (format stream "   virtual Sstring getElementName() const;~2%")
    
    (dolist (v (apispec-class.vars obj))
      (format stream "   ~a ~a;~%" 
	      (get-the-actual-type lang (car (apispec-var.type v)))
	      (cppify-word (car (apispec-var.name v)))))
    
    (format stream "};~2%")
    ))

  
(defmethod output-code ((obj apispec-toplevel) (lang api-lang-cpp) stream some-name)

  (declare (ignore some-name))
  
  (let ((api-name (car (apispec-toplevel.name obj))))

    (format stream "/// This file is autogenerated by the SDS API Generator.~2%")

    
    (let ((constants (apispec-toplevel.constants obj)))
      (dolist (c constants)
	(let ((value (car (apispec-constant.val c)))
	      (name (car (apispec-constant.name c)))
	      (const-name (get-name-of-constant lang c)))
	  (format stream "static const Sstring ~a(\"~a\");~%"
		  const-name
		  (if value value name)))))

    (format stream "~3%")
    
    (let ((classes (apispec-toplevel.classes obj)))
      (dolist (c classes)
	(output-code c lang stream api-name))

      ;; add factory stuff
      
      (format stream "XML_ParseablePtr~%")
      (format stream "~a_Factory::create(const Sstring &theClass) const {~2%" api-name)
      
      (format stream "   XML_ParseablePtr ptr = NULL;~2%")
      
      (format stream "   if (0 == 1) ;~%")
      
      (dolist (c classes)
	(let ((elmname (car (apispec-class.elmname c)))
	      (name (car (apispec-class.name c))))
	  (format stream "   else if (!theClass.cl_eq(~a)) ptr = new ~a();~%"
		  (get-name-of-constant lang (if elmname elmname name))
		  (get-name-of-class lang api-name c))))
      
      (format stream "   else {~%")
      (format stream "        PUT(\"Unknown class '\" << theClass << \"'\");~%")
      (format stream "   }~2%")
      (format stream "   return ptr;~%")
      (format stream "}~2%")
      
      )))

(defmethod output-code ((obj apispec-class) (lang api-lang-cpp) stream api-name)

  (let ((cl-name (get-name-of-class lang api-name obj))
	(elmname (car (apispec-class.elmname obj)))
	(name (car (apispec-class.name obj))))

    (format stream "~a::~a() : XML_Parseable() {~%" cl-name cl-name)

    (let ((attrs (apispec-class.attrs obj)))
      (when attrs
	(dolist (a attrs)
	  (format stream "  attrInfo += XML_AttrInfo(\"~a\", ATTR_~:@(~a~), PTR_TO(~a));~%"
		  (car (apispec-attr.name a))
		  (car (apispec-attr.type a))
		  (car (apispec-attr.var  a))))))

    (let ((attrs (apispec-class.subelems obj)))
      (when attrs
	(dolist (a attrs)
	  (format stream "  subelemInfo += XML_SubElemInfo(~a, SUBELEM_~:@(~a~), PTR_TO(~a));~%"
		  (get-name-of-constant lang (car (apispec-subelem.name a)))
		  (car (apispec-subelem.type a))
		  (car (apispec-subelem.var  a))))))

    (format stream "}~2%")


    (format stream "~a::~~~a() {~2%}~2%" cl-name cl-name)

    (write-string (get-cpp-function "XML_Parseable *"
				    (format nil "~a::copy() const" cl-name)
				    (format nil "   return new ~a(*this);~%" cl-name))
		  stream)
    
    (write-string (get-cpp-function "Sstring"
				    (format nil "~a::getElementName() const" cl-name)
				    (format nil "    return ~a;~%"
					    (get-name-of-constant lang
								  (if elmname
								      elmname
								    name))))
		  stream)
    ))

