from threading import Thread

import os
import time
import re
import datetime
import gtk
from gettext import gettext as _
class CheckAlarmThread(Thread):
	def __init__(self, status, main,StatusIcon,alarm_model, row, treesel, GUI, PREFIX, MainClass):
		Thread.__init__(self)
		self.setDaemon(True)
		self.MainClass = MainClass
		self.today = []
		self.CheckTodayAlarms()
		self.status = status
		self.cnt = 0
		self.Prefix = PREFIX
		self.MainWindowGlade = main
		self.GUI = GUI
		self.st = StatusIcon
		self.alarm_model = alarm_model
		self.row = row
		self.TreeSelection = treesel
		self.a = 0
		self.b = 0
		self.RefreshList = False
		self.Removed = False
		self.x = 0
	

	def run(self):
		self.CheckOldAlarms()
		while True:
		
			self.File = file(os.getenv("HOME") + "/.config/alarm-clock/lock", "w")
			self.File.write("%s/%s/%s %s:%s:%s" % (datetime.datetime.now().year, datetime.datetime.now().month, datetime.datetime.now().day, datetime.datetime.now().hour, datetime.datetime.now().minute, datetime.datetime.now().second))
			self.File.close()

			gtk.gdk.threads_enter()
			self.status.push(0, time.strftime(_("Current time: %c")))
			gtk.gdk.threads_leave()	
			Count = 0

			for tup in self.today:
				Count += 1
				if tup[0] == time.localtime().tm_hour and\
				tup[1] == time.localtime().tm_min and\
				time.localtime().tm_sec == 0:
					FileHandler = file(os.getenv("HOME")\
					+ "/.config/alarm-clock/alarms", 'r')
					AlarmContents = FileHandler.readlines()
					FileHandler.close()
					gtk.gdk.threads_enter()
					self.MainClass.UpdateList = False
					self.GUI().RunAlarm(eval(AlarmContents[tup[2]]), Count, self.RemoveOldAlarm,
					self.MainClass.LoadConfigFiles, self.MainClass.ChangeAlarmPrefs,
					self.ChangeUpdateList)

					if eval(AlarmContents[tup[2]])[2] == 0 and not eval(AlarmContents[tup[2]])[19]:
						self.RemoveOldAlarm(Count, True)
						self.MainClass.LoadConfigFiles()

					gtk.gdk.threads_leave()
					time.sleep(1)
					if not eval(AlarmContents[tup[2]])[19]:
						self.MainClass.UpdateList = True

			if time.localtime().tm_hour == 0 and time.localtime().tm_min == 0 and time.localtime().tm_sec < 1 and self.RefreshList == False:
				self.RefreshList = True

			if time.localtime().tm_hour == 0 and time.localtime().tm_min == 0 and time.localtime().tm_sec > 1 and self.RefreshList == True:
				self.RefreshList = False
			

			if self.RefreshList == True:
				gtk.gdk.threads_enter()
				self.MainClass.LoadConfigFiles()
				gtk.gdk.threads_leave()
				self.RefreshList = False

			time.sleep(1)

			self.CheckOldAlarms()
			gtk.gdk.threads_enter()
			self.CheckTodayBirthdays(self.st)
			gtk.gdk.threads_leave()
			self.CheckTodayAlarms()

	def ChangeUpdateList(self, Value):
		self.MainClass.UpdateList = Value

	def CheckOldAlarms(self, obj=None):
		if self.MainClass.UpdateList == False:
			return


		self.AlFile = file(os.getenv("HOME") + "/.config/alarm-clock/alarms", "r")


		self.x = self.x + 1
		if self.x == 4:
			if self.Removed == True:
				self.RefreshList = True
				self.Removed = False
			self.x = 0

		self.Data = self.AlFile.readlines()
		self.AlFile.close()
		self.Cnt = 0

		for line in self.Data:
			self.OldLine = eval(line)

			if self.OldLine[2] == 1:
				self.Cnt = self.Cnt + 1
				continue


			self.Date = self.OldLine[3]
			self.Time = self.OldLine[1]

			self.date_data = re.search('(\d+)/(\d+)/(\d+)', self.Date)
			self.oy = int(self.date_data.group(1))
			self.om = int(self.date_data.group(2)) + 1
			self.od = int(self.date_data.group(3))
			self.time_data = re.search('(\d+):(\d+)', self.Time)
			self.oh = int(self.time_data.group(1))
			self.omin = int(self.time_data.group(2))
			self.DateOld = datetime.datetime(self.oy,self.om,self.od,self.oh,self.omin,0)

			self.CurrentDate = datetime.datetime.today()

			self.Diff = self.CurrentDate - self.DateOld

			if self.Diff.days > 0:
				self.RemoveOldAlarm(self.Cnt)
				self.Cnt = self.Cnt + 1
				self.Removed = True
				self.MainClass.LoadConfigFiles()
				continue

			if self.Diff.days == 0:
				if self.Diff.seconds > 0:
					self.RemoveOldAlarm(self.Cnt)
					self.Cnt = self.Cnt + 1
					self.Removed = True
					self.MainClass.LoadConfigFiles()
					continue
		

			self.Cnt = self.Cnt + 1			


	def RemoveOldAlarm(self,no, nosave = False):
		self.row = no
		self.fbuf = file(os.getenv("HOME") + "/.config/alarm-clock/alarms", "r")
		self.lines = self.fbuf.readlines()
		self.new_lines = []
		self.counter = 0
		for line in self.lines:
			if self.counter == self.row:
				self.counter = self.counter + 1
				if not nosave == True:
					OldFile = file(os.getenv("HOME") + '/.config/alarm-clock/old-alarms', 'a')
					OldFile.write(line)
					OldFile.close()
				continue
			self.new_lines.append(line)
			self.counter = self.counter + 1

		self.fbuf.close()
		self.fbuf = file(os.getenv("HOME") + "/.config/alarm-clock/alarms", "w")
		self.fbuf.write("")
		self.fbuf.close()
		self.fbuf = file(os.getenv("HOME") + "/.config/alarm-clock/alarms", "a")
		for line in self.new_lines:
			self.fbuf.write(line)
		self.fbuf.close()

	def CheckTodayBirthdays(self, StatusIcon):
		self.BirthdaysNames = []
		self.BDay = False
		self.TodayDate = "%s/%s/%s" % (datetime.datetime.now().year, datetime.datetime.now().month - 1, datetime.datetime.now().day)

		try:
			self.bfile = file(os.getenv("HOME") + "/.config/alarm-clock/birthdays", "r")
		except:
			return

		self.lnn = self.bfile.readlines()

		for line in self.lnn:
			if self.TodayDate == eval(line)[0]:
				self.BirthdaysNames.append(eval(line)[1])
				self.BDay = True

		if self.BDay == True:
			self.Text = _("Birthday today! Remember to buy presents:\n")
			for name in self.BirthdaysNames:
				self.Text = self.Text + "\n" + name

			StatusIcon.set_tooltip(self.Text)
			StatusIcon.set_from_file(self.Prefix + '/scalable/alarm-caution.svg')
		else:
			StatusIcon.set_tooltip(_("Alarm Clock"))
			StatusIcon.set_from_file(self.Prefix + '/scalable/alarm-clock.svg')





	def CheckTodayAlarms(self):

		self.today = []
		self.f = file(os.getenv("HOME") + "/.config/alarm-clock/alarms")

		self.ln = self.f.readlines()

		self.f.close()

		self.t_min = time.localtime().tm_min
		self.t_hour = time.localtime().tm_hour
		self.t_day = time.localtime().tm_mday
		self.t_weekday = time.localtime().tm_wday
		self.t_month = time.localtime().tm_mon
		self.t_year = time.localtime().tm_year
		
		self.linenumber = 0
		for line in self.ln:
			self.buf = eval(line)
			self.date_data = re.search('(\d+)/(\d+)/(\d+)', self.buf[3])
			self.y = int(self.date_data.group(1))
			self.m = int(self.date_data.group(2)) + 1
			self.d = int(self.date_data.group(3))
			self.time_data = re.search('(\d+):(\d+)', self.buf[1])


			if self.buf[2] == 0:
				if self.y == self.t_year and self.m == self.t_month and self.d == self.t_day:
					self.tup = [int (self.time_data.group(1)), int (self.time_data.group(2)), self.linenumber]

					self.today.append(self.tup)
					


			else:
				self.Good = False
				self.weekdays = self.buf[4][0]
				self.months = self.buf[4][1]

				if self.weekdays[self.t_weekday] == True and self.months[self.t_month - 1] == True:
					self.Good = True

				for t in self.buf[5]:
					if t[0] == self.t_month and t[1] == self.t_day:		
						self.Good = False

				if self.Good == True:
					self.tup = [int (self.time_data.group(1)), int (self.time_data.group(2)), self.linenumber]
					self.today = self.today + [self.tup]

			self.linenumber = self.linenumber + 1


