from apport.hookutils import *

def mask_string (str):
    MASK = '##MASKED##'
    return str.group(1) + MASK

def mask_values(confinfo):
    """ strip personal/private information from the conf entries """
    pattrn = re.compile ('((username|password|tunnel_id) )(.*)$', re.IGNORECASE)
    newReport = ""
    for line in confinfo.splitlines():
        line = pattrn.sub (mask_string, line)
        newReport += line + '\n'
    return newReport

def add_info(report, ui=None):
	attach_file_if_exists(report, '/var/log/aiccu.log', key='var.log.aiccu.log')
	attach_file_if_exists(report, '/etc/aiccu.conf', key='etc.aiccu.conf')
	try:
		report['etc.aiccu.conf'] = mask_values(report['etc.aiccu.conf'])
	except KeyError:
		pass
	try:
		report['modified.conffile..etc.aiccu.conf'] = mask_values(report['modified.conffile..etc.aiccu.conf'])
	except KeyError:
		pass
