#include "DockView.h"
#include <math.h>

@implementation DockView

- (id) initWithFrame:(NSRect)frame
			modelMan:(id)model
{
	[self initWithFrame:frame];
	__modelMan = model;

	[self setFrame:frame];

	return self;
}

- (void) update
{
	/*
	NSArray *array = [_delegate allEventsDuringDate:_date
											andDate:[_date addTimeInterval:CEV_VIEWSECONDS]];

	id en,view;

	en = [[self subviews] objectEnumerator];
	while ((view = [en nextObject]))
	{
		[view removeFromSuperview];
	}

	CalendarEventModel *model;

	en = [array objectEnumerator];
	while ((model = [en nextObject]))
	{
		id cell = [[CalendarEventCell alloc] initWithOwner:self
													 model:model];
		[self addSubview:cell];
		AUTORELEASE(cell);
	}
	[self _adjustColumn];

	*/
}


/** overidden view methods **/
-(void) setFrame:(NSRect)f
{
	[super setFrame:f];
//	[self _frameChanged];
}
- (void) calendarEventModelManager:(CalendarEventModelManager *)man
					   didAddModel:(CalendarEventModel *)model
{
	[self setNeedsDisplay:YES];
}
- (void) calendarEventModelManager:(CalendarEventModelManager *)man
					didUpdateModel:(CalendarEventModel *)model
{
	[self setNeedsDisplay:YES];
}

- (void) drawRect:(NSRect)r
{
	NSCalendarDate *date,*day,*endDay;
	date = [NSCalendarDate date];
	NSMutableAttributedString *str;
	[[NSColor whiteColor] set];

	day = [NSCalendarDate dateWithYear:[date yearOfCommonEra]
								 month:[date monthOfYear]
								   day:[date dayOfMonth]
								  hour:0
								minute:0
								second:0
							  timeZone:[date timeZone]];
	endDay = [day addTimeInterval:3600*24];

	NSRectFill(NSMakeRect(3,3,55,55));

	id months[] = {@"January",@"February",@"March",@"April",@"May",@"June",@"July",@"August",@"September",@"October",@"November",@"December"};
	id days[] = {@"Sunday",@"Monday",@"Tuesday",@"Wednesday",@"Thursday",@"Friday",@"Saturday"};


	id num = @"";
	if ([[__modelMan allEventsDuringDate:date andDate:endDay] count] > 0)
	{
		num = [NSString stringWithFormat:@"(%d)",
		[[__modelMan allEventsDuringDate:date andDate:endDay] count]];
	}


	str = [[NSMutableAttributedString alloc]
		initWithString:[NSString stringWithFormat:@"%d%@",
	[date dayOfMonth],num]];
	AUTORELEASE(str);

	[str addAttribute:NSFontAttributeName
					value:[NSFont boldSystemFontOfSize:NSHeight(_bounds)/2.5]
					range:NSMakeRange(0,[str length]-[num length])];

	NSSize size = [str size];
	[str drawAtPoint:NSMakePoint(
			NSWidth(_bounds)/2 - size.width/2,
			NSHeight(_bounds)/2 - size.height/2
			)];

	str = [[NSMutableAttributedString alloc]
		initWithString:months[[date monthOfYear]-1]];
	AUTORELEASE(str);
	[str addAttribute:NSFontAttributeName
					value:[NSFont boldSystemFontOfSize:NSHeight(_bounds)/7]
					range:NSMakeRange(0,[str length])];

	size = [str size];
	[str drawAtPoint:NSMakePoint(
			NSWidth(_bounds)/2 - size.width/2,
			NSHeight(_bounds) - size.height
			)];

	str = [[NSMutableAttributedString alloc]
		initWithString:days[[date dayOfWeek]]];
	AUTORELEASE(str);
	[str addAttribute:NSFontAttributeName
					value:[NSFont boldSystemFontOfSize:NSHeight(_bounds)/7]
					range:NSMakeRange(0,[str length])];

	size = [str size];
	[str drawAtPoint:NSMakePoint(
			NSWidth(_bounds)/2 - size.width/2,
			0
			)];
}

@end
