/*******************************************************************************
 *  PROJECT: GNOME Colorscheme
 *
 *  AUTHOR: Jonathon Jongsma
 *
 *  Copyright (c) 2005 Jonathon Jongsma
 *
 *  License:
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the 
 *    Free Software Foundation, Inc., 59 Temple Place, Suite 330, 
 *    Boston, MA  02111-1307  USA
 *
 *******************************************************************************/

#ifndef __GCS_BOOKMARKLIST_H
#define __GCS_BOOKMARKLIST_H

#include <gtkmm/treeview.h>
#include <gtkmm/menu.h>
#include <gtkmm/uimanager.h>
#include <gtkmm/dialog.h>
#include <gtkmm/entry.h>
#include <gtkmm/label.h>

#include "core/gcs-color.h"
#include "core/gcs-palette.h"
#include "core/gcs-types.h"

namespace gcs
{
    namespace Widgets
    {
        class BookmarkList : public Gtk::TreeView
        {
            public:
                BookmarkList(Glib::ustring fname);
                void add(ColorPtr clr);
                void clear(void);
                ColorPtr get_color(void);
                bool empty(void);
                void remove_selected(void);
                gint count_selected(void);

                void save_to_disk(Glib::ustring = "");

            protected:
                Gtk::TreeModel::iterator get_selected_iter(void);

            private:
                // Performs some actions (e.g. saving to disk) when the list
                // gets changed, for example by a drag-and-drop reordering
                void on_list_changed(void) { save_to_disk(); }

                virtual bool on_button_press_event(GdkEventButton* event);
                void BookmarkList::on_action_rename(void);

                /*
                virtual void on_drop_drag_data_received(const
                        Glib::RefPtr<Gdk::DragContext>& context, int x, int y,
                        const Gtk::SelectionData& selection_data, guint info,
                        guint time);
                        */

                Glib::ustring m_file;
                Glib::RefPtr<Palette> m_refPalette;
                Glib::RefPtr<Gtk::UIManager> m_refUIManager;
                Gtk::Menu* m_popupMenu;

        };

    } // namespace Widgets


    namespace Dialogs
    {
        class RenameEntry : public Gtk::Dialog
        {
            public:
                RenameEntry(void);
                void set_name(Glib::ustring name);
                Glib::ustring get_name(void);

            private:
                Gtk::Label* pInstructions;
                Gtk::Entry* pEntry;
        };
    } // namespace Dialogs

} // namespace gcs

#endif // __GCS_BOOKMARKLIST_H
