/*******************************************************************************
 *  PROJECT: GNOME Colorscheme
 *
 *  AUTHOR: Jonathon Jongsma
 *
 *  Copyright (c) 2005 Jonathon Jongsma
 *
 *  License:
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the 
 *    Free Software Foundation, Inc., 59 Temple Place, Suite 330, 
 *    Boston, MA  02111-1307  USA
 *
 *******************************************************************************/

#ifndef __GCS_PALETTE_H
#define __GCS_PALETTE_H

#include <istream>
#include <utility>

#include <gtkmm/button.h>
#include <gtkmm/table.h>
#include <gtkmm/scrolledwindow.h>
#include <gtkmm/expander.h>
#include <gtkmm/liststore.h>
#include <glibmm/ustring.h>

#include "gcs-color.h"
#include "gcs-types.h"

namespace gcs
{
    class Palette : public Gtk::ListStore
    {
        public:
            bool set_from_file(Glib::ustring filename);
            bool set_from_string(Glib::ustring& palette_def);
            Glib::ustring get_name(void) const { return m_name; }
            gint size(void) { return children().size(); }
            Glib::ustring get_name(void) { return m_name; }
            gint get_columns(void) { return m_paletteColumns; }
            Gtk::TreeModel::Row operator[](gint idx) { return children()[idx]; }
            Gtk::TreeModel::Row add(ColorPtr clr, Glib::ustring name = Glib::ustring());
            // deletes all the colors
            void reset(void);

            ColorPtr get_color(int row_idx);
            tHexString get_hexstring(int row_idx);

            const Gtk::TreeModelColumn<ColorPtr>& get_color_column(void) { return m_modelColumns.m_colColor; }
            const Gtk::TreeModelColumn<Glib::ustring>& get_text_column(void) { return m_modelColumns.m_colText; }

            static Glib::RefPtr<Palette> create(Glib::ustring fname);

#ifdef UNIT_TEST
            friend class PaletteTests;
#endif

        protected:
            typedef std::pair<ColorPtr, Glib::ustring> color_def_t;

            Palette(Glib::ustring file);
            //~Palette();

            Gtk::TreeModel::Row append_color(ColorPtr clr, Glib::ustring name = Glib::ustring());
            bool parse_palette(std::istream& i);
            // only for parsing lines that actually define a color -- not
            // for header lines like "Name: xxx"
            static color_def_t parse_line(Glib::ustring palette_line);

            Glib::ustring m_name;
            gint m_paletteColumns;

            // store all of the colors in a ListStore
            class ModelColumns : public Gtk::TreeModel::ColumnRecord
            {
                public:
                    ModelColumns() { add(m_colColor); add(m_colText); }
                    Gtk::TreeModelColumn<ColorPtr> m_colColor;
                    Gtk::TreeModelColumn<tHexString> m_colText;
            };

            ModelColumns m_modelColumns;
    };

} // namespace gcs

#endif // __GCS_PALETTE_H
