dnl usage SVN_REPOSITORY_REVISION()
dnl
dnl checks the current repository revision
dnl and stores it in SVN_REVISION environment variable including
dnl AC_SUBST'ing.
dnl
dnl Output:
dnl   SVN_REVISION
dnl
AC_DEFUN(SVN_REPOSITORY_REVISION,[
AC_MSG_CHECKING([repository revision])
SVN_REVISION="`svnversion -n .`"
AC_SUBST(SVN_REVISION)
AC_MSG_RESULT($SVN_REVISION)
])


dnl Determine the version of the git repository
AC_DEFUN(GIT_REPOSITORY_REVISION,[
AC_PATH_PROG(GIT_PATH, [git], no)
if test "$GIT_PATH" != "no" ; then
    AC_MSG_CHECKING([git revision])
    GIT_REVISION="`$GIT_PATH describe`"
    AC_MSG_RESULT($GIT_REVISION)
fi
AC_DEFINE_UNQUOTED([GIT_REVISION], ["$GIT_REVISION"],
    [The revision of the current build])
])
