// ---------------------------------------------------------------------------
// - Libsps.cpp                                                              -
// - afnix:sps module - declaration & implementation                        -
// ---------------------------------------------------------------------------
// - This program is free software;  you can redistribute it  and/or  modify -
// - it provided that this copyright notice is kept intact.                  -
// -                                                                         -
// - This program  is  distributed in  the hope  that it will be useful, but -
// - without  any  warranty;  without  even   the   implied    warranty   of -
// - merchantability or fitness for a particular purpose.  In no event shall -
// - the copyright holder be liable for any  direct, indirect, incidental or -
// - special damages arising in any way out of the use of this software.     -
// ---------------------------------------------------------------------------
// - copyright (c) 1999-2011 amaury darsch                                   -
// ---------------------------------------------------------------------------

#include "Meta.hpp"
#include "Folio.hpp"
#include "Libsps.hpp"
#include "Predsps.hpp"
#include "Importer.hpp"
#include "Function.hpp"
#include "SpsCalls.hpp"

namespace afnix {

  // initialize the the afnix:sps module

  Object* init_afnix_sps (Interp* interp, Vector* argv) {
    // make sure we are not called from something crazy
    if (interp == nilp) return nilp;
    
    // create the afnix:sps nameset
    Nameset* aset = interp->mknset ("afnix");
    Nameset* nset = aset->mknset   ("sps");
 
    // bind all classes in the afnix:net nameset
    nset->symcst ("Cell",         new Meta (Cell::mknew));
    nset->symcst ("Xref",         new Meta (Xref::mknew));
    nset->symcst ("Index",        new Meta (Index::mknew));
    nset->symcst ("Sheet",        new Meta (Sheet::mknew));
    nset->symcst ("Folio",        new Meta (Folio::mknew));
    nset->symcst ("Record",       new Meta (Record::mknew));
    nset->symcst ("Sheeting",     new Meta (Sheeting::mknew));
    nset->symcst ("Recording",    new Meta (Recording::mknew));

    // bind all predicates in the afnix:sps nameset
    nset->symcst ("cell-p",       new Function (sps_celp));
    nset->symcst ("xref-p",       new Function (sps_xrfp));
    nset->symcst ("index-p",      new Function (sps_idxp));
    nset->symcst ("sheet-p",      new Function (sps_shtp));
    nset->symcst ("folio-p",      new Function (sps_folp));
    nset->symcst ("record-p",     new Function (sps_rcdp));
    nset->symcst ("persist-p",    new Function (sps_pstp));
    nset->symcst ("sheeting-p",   new Function (sps_simp));
    nset->symcst ("recording-p",  new Function (sps_rimp));
       
    // bind the standard functions
    nset->symcst ("read",         new Function (sps_read));

    // not used but needed
    return nilp;
  }
}

extern "C" {
  afnix::Object* dli_afnix_sps (afnix::Interp* interp, afnix::Vector* argv) {
    return init_afnix_sps (interp, argv);
  }
}
