# ---------------------------------------------------------------------------
# - CSM0051.als                                                             -
# - afnix:csm module test unit                                              -
# ---------------------------------------------------------------------------
# - This program is free software;  you can redistribute it  and/or  modify -
# - it provided that this copyright notice is kept intact.                  -
# -                                                                         -
# - This program  is  distributed in  the hope  that it will be useful, but -
# - without  any  warranty;  without  even   the   implied    warranty   of -
# - merchantability or fitness for a particular purpose.  In no event shall -
# - the copyright holder be liable for any  direct, indirect, incidental or -
# - special damages arising in any way out of the use of this software.     -
# ---------------------------------------------------------------------------
# - copyright (c) 1999-2011 amaury darsch                                   -
# ---------------------------------------------------------------------------

# @info   locos test unit
# @author amaury darsch

# get the module
interp:library "afnix-csm"

# create a nil locos
trans lco (afnix:csm:Locos)

# check predicate and representation
assert true  (afnix:csm:locos-p lco)
assert "Locos" (lco:repr)

# create an integer rco
const rco (afnix:csm:Rco "1" 1)

# check for empty
assert true  (lco:empty-p)
assert 0     (lco:length)
assert false (lco:exists-p rco)

# add the rco
lco:add rco
assert false (lco:empty-p)
assert 1     (lco:length)
assert true  (lco:exists-p rco)

# check accessor
assert true (== rco (lco:get 0))
# check index
assert 0    (lco:get-index rco)
