// ---------------------------------------------------------------------------
// - Locos.hpp                                                               -
// - afnix:csm module - local cloud object set class definition              -
// ---------------------------------------------------------------------------
// - This program is free software;  you can redistribute it  and/or  modify -
// - it provided that this copyright notice is kept intact.                  -
// -                                                                         -
// - This program  is  distributed in  the hope  that it will be useful, but -
// - without  any  warranty;  without  even   the   implied    warranty   of -
// - merchantability or fitness for a particular purpose.  In no event shall -
// - the copyright holder be liable for any  direct, indirect, incidental or -
// - special damages arising in any way out of the use of this software.     -
// ---------------------------------------------------------------------------
// - copyright (c) 1999-2011 amaury darsch                                   -
// ---------------------------------------------------------------------------

#ifndef  AFNIX_LOCOS_HPP
#define  AFNIX_LOCOS_HPP

#ifndef  AFNIX_SET_HPP
#include "Set.hpp"
#endif

#ifndef  AFNIX_RCO_HPP
#include "Rco.hpp"
#endif

namespace afnix {

  /// The Locos class is the local cloud object set. The class is designed
  /// to store registered cloud object (rco). The implementation is primarily
  /// designed to store a unique form of objects and provides the necessary
  /// mechanism to retrieve an object by registration id.
  /// @author amaury darsch

  class Locos : public virtual Object {
  protected:
    /// the object set
    Set d_cos;

  public:
    /// create an empty set
    Locos (void);

    /// @return the class name
    String repr (void) const;

    /// reset this locos
    virtual void reset (void);

    /// @return the number of rco in the locos
    virtual long length (void) const;

    /// @return true if the locos is empty
    virtual bool empty (void) const;

    /// @return true if an rco exists in the set
    virtual bool exists (const Rco& rco) const;

    /// get the rco index in the locos
    /// @param rco the rco to find
    virtual long getidx (const Rco& rco) const;

    /// add a rco in this locos
    /// @param rco the rco to add
    virtual void add (const Rco& rco);

    /// get a rco by index
    virtual Rco get (const long index) const;

  private:
    // make the copy constructor private
    Locos (const Locos&);
    // make the assignment operator private
    Locos& operator = (const Locos&);

  public:
    /// create a object in a generic way
    /// @param argv the argument vector
    static Object* mknew (Vector* argv);

    /// @return true if the given quark is defined
    bool isquark (const long quark, const bool hflg) const;

    /// apply this object with a set of arguments and a quark
    /// @param robj  the current runnable
    /// @param nset  the current nameset    
    /// @param quark the quark to apply these arguments
    /// @param argv  the arguments to apply
    Object* apply (Runnable* robj, Nameset* nset, const long quark,
		   Vector* argv);
  };
}

#endif
