#include "afflib.h"			
#include "afflib_i.h"			// grab the internal versions
#include "aimage.h"
#include "imager.h"
#include "ident.h"

void usage()
{
    printf("usage: ident <filename>\n");
    exit(0);
}

int main(int argc,char **argv)
{
    if(argc<2){
	usage();
    }
    ident id(argv[1]);
    if(id.get_params()){
	printf("Device parameters:\n");
	if(id.params.manufacturer) printf("manufacturer: %s\n",id.params.manufacturer);
	if(id.params.model) printf("model: %s\n",id.params.model);
	if(id.params.sn) printf("sn: %s\n",id.params.sn);
	if(id.params.firmware) printf("firmware: %s\n",id.params.firmware);
	if(id.params.cylinders>0) printf("cylinders: %d\n",id.params.cylinders);
	if(id.params.heads>0) printf("heads: %d\n",id.params.heads);
	if(id.params.sectors_per_track>0) printf("sectors_per_track: %d\n",id.params.sectors_per_track);
	if(id.params.human) printf("human: %s\n",id.params.human);
    }


    if(id.is_scsi()){
	printf("is_scsi   bus=%d tid=%d lun=%d pass=%d\n",
	       id.scsi.bus,id.scsi.tid,id.scsi.lun,id.scsi.pass);
    }
    if(id.is_ata()){
	printf("is_ata   dev=%d  primary=%d master=%d \n",
	       id.ata.dev,id.ata.primary,id.ata.master);
    }

    printf("\n\nSystem Info:\n");
    printf("MAC Addresses:\n%s",ident::mac_addresses());
    printf("Free space device: %qd\n",id.freebytes());
    return 0;
}
