/****************** Start of $RCSfile: zutils.h,v $  ****************
*
* $Source: /home/alb/afbackup/afbackup-3.5.1pl2/RCS/zutils.h,v $
* $Id: zutils.h,v 1.2 2004/07/08 20:34:47 alb Exp alb $
* $Date: 2004/07/08 20:34:47 $
* $Author: alb $
*
*
******* description ***********************************************
*
*
*
*******************************************************************/

#ifndef	__ZUTILS_H
#define	__ZUTILS_H	__ZUTILS_H

#ifdef	USE_ZLIB

#include <zlib.h>

#define	Z_UNINITIALIZED		0
#define	Z_INIT_FOR_INFLATE	1
#define	Z_INIT_FOR_DEFLATE	2

typedef	struct ZFile_s	{
  Int8		initialized;
  Int32		level;
  Int32		maxblock;
  int		fd;
  Flag		compr_done;
  Flag		file_exh;
  Int32		numblock;
  z_stream	z_stream;
  UChar		filebuf[0x2000];
} ZFile;

#define	ZFILE_INIT	{			\
			Z_UNINITIALIZED,	\
			(Int32) 0,		\
			(Int32) 0,		\
			(int) -1,		\
			NO,			\
			NO,			\
			(Int32) 0,		\
			}

#define	zfile_init(zf)	{ ZFile zfile_i = ZFILE_INIT;	\
			  memset(&(zfile_i.z_stream), 0, sizeof(z_stream)); \
			  memset(&(zfile_i.filebuf), 0, sizeof(zfile_i.filebuf)); \
			  memcpy((zf), &zfile_i, sizeof(zfile_i)); }

extern	Int32	reset_zfile(ZFile *);
extern	Int32	open_file_zip(ZFile *, int, Int32, Int32);
extern	Int32	open_file_unzip(ZFile *, int);
extern	Int32	read_file_zip(ZFile *, UChar *, Int32,
					Int32 (*)(int, UChar *, Int32));
extern	Int32	write_file_unzip(ZFile *, UChar *, Int32, Flag,
					Int32 (*)(int, UChar *, Int32));
extern	void	close_file_zip(ZFile *);

#endif	/* defined(USE_ZLIB) */

#endif	/* !defined(__ZUTILS_H) */
