/* aewm - An Exiguous Window Manager - vim:sw=4:ts=4:et
 *
 * Copyright 1998-2006 Decklin Foster <decklin@red-bean.com>. This
 * program is free software; please see LICENSE for details. */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <X11/Xlib.h>
#include <X11/Xatom.h>
#include "common.h"
#include "atom.h"

Display *dpy;
Window root;
Atom net_cur_desk, net_num_desktops;
unsigned long ndesks;

int send_xmessage(Window w, Atom a, unsigned long x)
{
    XClientMessageEvent e;

    e.type = ClientMessage;
    e.window = w;
    e.message_type = a;
    e.format = 32;
    e.data.l[0] = x;

    return XSendEvent(dpy, w, False, SubstructureNotifyMask, (XEvent *)&e);
}

unsigned long increment_desk(int inc)
{
    unsigned long cur_desk, desk;

    if (get_atoms(root, net_cur_desk, XA_CARDINAL, 0, &cur_desk, 1, NULL)) {
        desk = cur_desk + inc;
        while (desk < 0) desk += ndesks; /* ANSI can bite me */
        return desk % ndesks;
    } else {
        return 1;
    }
}

int main(int argc, char **argv)
{
    unsigned long desk;
    int i;

    if (argc < 2) {
        fprintf(stderr, "usage: aedesk [+-]<integer>|-n <integer>\n");
        exit(2);
    }

    dpy = XOpenDisplay(NULL);
    root = DefaultRootWindow(dpy);
    net_cur_desk = XInternAtom(dpy, "_NET_CURRENT_DESKTOP", False);
    net_num_desktops = XInternAtom(dpy, "_NET_NUMBER_OF_DESKTOPS", False);

    if (!dpy) {
        fprintf(stderr, "aedesk: can't open display %s\n", getenv("DISPLAY"));
        exit(1);
    }

    for (i = 1; i < argc; i++) {
        if ARG("setn", "n", 1) {
            desk = atol(argv[++i]);
            set_atoms(root, net_num_desktops, XA_CARDINAL, &desk, 1);
        } else {
            if (!get_atoms(root, net_num_desktops, XA_CARDINAL, 0,
                    &ndesks, 1, NULL)) {
                fprintf(stderr, "aedesk: _NET_NUMBER_OF_DESKTOPS unset\n");
                exit(1);
            }
            if (strchr("+-", argv[i][0]))
                desk = increment_desk(atol(argv[i]));
            else
                desk = atol(argv[i]);
            if (ndesks && desk >= ndesks)
                desk = ndesks - 1;
            send_xmessage(root, net_cur_desk, desk);
        }
    }

    XCloseDisplay(dpy);
    return 0;
}
