//
//	aegis - project change supervisor
//	Copyright (C) 1991-2004 Peter Miller;
//	All rights reserved.
//
//	This program is free software; you can redistribute it and/or modify
//	it under the terms of the GNU General Public License as published by
//	the Free Software Foundation; either version 2 of the License, or
//	(at your option) any later version.
//
//	This program is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//
//	You should have received a copy of the GNU General Public License
//	along with this program; if not, write to the Free Software
//	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.
//
// MANIFEST: wrappers around operating system functions
//

#include <ac/errno.h>
#include <ac/unistd.h>

#include <glue.h>
#include <os.h>
#include <sub.h>
#include <trace.h>


void
os_link(const nstring &from, const nstring &to)
{
    trace(("os_link(from = \"%s\", to = \"%s\")\n{\n",
	from.c_str(), to.c_str()));
    os_become_must_be_active();
    if (glue_link(from.c_str(), to.c_str()))
    {
	int errno_old = errno;
	sub_context_ty sc;
	sc.errno_setx(errno_old);
	sc.var_set_string("File_Name1", from);
	sc.var_set_string("File_Name2", to);
	sc.fatal_intl(i18n("link(\"$filename1\", \"$filename2\"): $errno"));
	// NOTREACHED
    }
    trace(("}\n"));
}


void
os_link(string_ty *from, string_ty *to)
{
    os_link(nstring(from), nstring(to));
}
