//
//	aegis - project change supervisor
//	Copyright (C) 2001, 2003, 2004 Peter Miller;
//	All rights reserved.
//
//	This program is free software; you can redistribute it and/or modify
//	it under the terms of the GNU General Public License as published by
//	the Free Software Foundation; either version 2 of the License, or
//	(at your option) any later version.
//
//	This program is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//
//	You should have received a copy of the GNU General Public License
//	along with this program; if not, write to the Free Software
//	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.
//
// MANIFEST: functions to manipulate symtab_iters
//

#include <error.h>
#include <symtab_iter.h>


symtab_iterator::symtab_iterator(const symtab_ty *arg) :
    stp(arg),
    rp(0),
    pos(0)
{
    assert(stp);
}


symtab_iterator::~symtab_iterator()
{
    stp = 0;
    pos = 0;
    rp = 0;
}


void
symtab_iterator::reset()
{
    rp = 0;
    pos = 0;
}


bool
symtab_iterator::next(string_ty **key_p, void **data_p)
{
    assert(key_p);
    assert(data_p);
    assert(stp);
    while (rp == 0)
    {
	if (pos >= stp->hash_modulus)
    	    return false;
	rp = stp->hash_table[pos];
	pos++;
    }
    assert(rp->key);
    *key_p = rp->key;
    assert(rp->data);
    *data_p = rp->data;
    rp = rp->overflow;
    return true;
}
