/*
   --------------------------------------------------------------
   File speelpenning.C of ADOL-C version 1.8.0    as of Dec/01/98
   --------------------------------------------------------------
   (old name: vectexam.C)

   Example: modified Speelpenning's product

   Last changes: 
     981201 olvo new headers
     980818 olvo some little changes in output design
     980806 olvo initialization seperated
     980715 olvo first version

   --------------------------------------------------------------
*/

/****************************************************************************/
/*                                                                 INCLUDES */
#include "adouble.h"
#include "interfaces.h"
#include "DRIVERS/drivers.h"
#include "myclock.h"


/****************************************************************************/
/*                                                                   MACROS */
#define abs(x) ((x >= 0) ? (x) : -(x))
#define maxabs(x,y) (((x)>abs(y)) ? (x) : abs(y))
#define TAG 1


/****************************************************************************/
/*                                                             MAIN PROGRAM */
int main() 
{ int n,i,it;
  int tape_stats[11];

/*--------------------------------------------------------------------------*/
                                                                   /* Input */
  fprintf(stdout,"SPEELPENNINGS PRODUCT Type 1 (ADOL-C Example)\n\n");
  fprintf(stdout,"number of independent variables = ?  \n");               
  scanf("%d",&n);
  int itu;
  fprintf(stdout,"number of evaluations = ?  \n");               
  scanf("%d",&itu);

/*--------------------------------------------------------------------------*/
  double yp;                     /* 0. time  (undifferentiated double code) */ 
  double *xp = new double[n];
  /* Init */
  for (i=0;i<n;i++)
    xp[i] = (i+1.0)/(2.0+i);

  double t00 = myclock(1);
  for (it=0; it<itu; it++)
  { yp = 1.0;
    for (i=0; i<n; i++)
      yp *= xp[i]; 
  }                        
  double t01 = myclock();

/*--------------------------------------------------------------------------*/
  double yout=0;                             /* 1. time (tracing ! no keep) */

  double t10 = myclock();
  trace_on(TAG);
  adouble* x;
  x = new adouble[n];
  adouble y;
  y = 1;
  for (i=0; i<n; i++)
  { x[i] <<= xp[i]; 
    y *= x[i];
  } 
  y >>= yout;
  delete [] x;
  trace_off();     
  double t11 = myclock();

  fprintf(stdout,"%le =? %le  function values should be the same \n",yout,yp);

/*--------------------------------------------------------------------------*/
  tapestats(TAG,tape_stats);                  /* Reading of tape statistics */

  fprintf(stdout,"\n    independents   %d\n",tape_stats[0]);
  fprintf(stdout,"    dependents     %d\n",tape_stats[1]);
  fprintf(stdout,"    operations     %d\n",tape_stats[5]);
  fprintf(stdout,"    buffer size    %d\n",tape_stats[4]);
  fprintf(stdout,"    maxlive        %d\n",tape_stats[2]);
  fprintf(stdout,"    valstack size  %d\n\n",tape_stats[3]);

/*--------------------------------------------------------------------------*/
  double **r = new double*[1];
  r[0] = new double[1];
  r[0][0] = yp;
  double err;
  double *z = new double[n];
  double *g = new double[n];
  double* h = new double[n];
  double *ind = new double[n];
    
/*--------------------------------------------------------------------------*/
  double t60 = myclock();                      /* 6. time (forward no keep) */
  for (it=0; it<itu; it++)
    forward(TAG,1,n,0,xp,*r);
  double t61 = myclock();
 
/*--------------------------------------------------------------------------*/
  double t20 = myclock();                         /* 2. time (forward+keep) */
  for (it=0; it<itu; it++)
    forward(TAG,1,n,1,xp,*r);
  double t21 = myclock();
 
/*--------------------------------------------------------------------------*/
  double t30 = myclock();                              /* 3. time (reverse) */
  for (it=0; it<itu; it++)
    reverse(TAG,1,n,0,1.0,g);        
  double t31 = myclock();

  err=0;
  for (i=0; i<n; i++) // Compare with deleted product
  { err = maxabs(err,xp[i]*g[i]/r[0][0] - 1.0);
    ind[i] = xp[i];
  }

  fprintf(stdout,"%le = maximum relative errors in gradient (fw+rv)\n",err);

/*--------------------------------------------------------------------------*/
  double t40 = myclock();                             /* 4. time (gradient) */
  for (it=0; it<itu; it++)
    gradient(TAG,n,ind,z);  //last argument lagrange is ommitted
  double t41 = myclock();

  err = 0;
  for (i=0; i<n; i++)  // Compare with previous numerical result 
    err =  maxabs(err,g[i]/z[i] - 1.0);
  
  fprintf(stdout,"%le = gradient error should be exactly zero \n",err);

/*--------------------------------------------------------------------------*/
  double *tan = new double[n];            /* 5. time (first row of Hessian) */
  for (i=1; i<n; i++) 
    tan[i] = 0.0 ;
  tan[0]=1.0; 

  double t50 = myclock();
  for (it=0; it<itu; it++)
    hess_vec(TAG,n,ind,tan,h);  // Computes Hessian times direction tan.
  double t51 = myclock();
    
  err = abs(h[0]);
  for (i=1; i<n; i++) //Compare with doubly deleted product
    err = maxabs(err,xp[0]*h[i]/g[i]-1.0);

  fprintf(stdout,"%le = maximum relative error in Hessian column \n",err);
 
/*--------------------------------------------------------------------------*/
  double h1n = h[n-1];                                /* Check for symmetry */
  tan[0]=0;
  tan[n-1]=1;
  hess_vec(TAG,n,ind,tan,h);   // Computes Hessian times direction tan.

  fprintf(stdout,
          "%le = %le (1,n) and (n,1) entry should be the same\n",h1n,h[0]);

/*--------------------------------------------------------------------------*/
                                                       /* output of results */
  if (t01-t00) 
  { double rtu = 1.0/(t01-t00);
    fprintf(stdout,"\n\n times for ");
    fprintf(stdout,"\n unitime          : \t%le  seconds",(t01-t00)/itu);
    fprintf(stdout,"\n tracing          : \t%le",(t11-t10)*rtu*itu);
    fprintf(stdout,"   units \t%le seconds",(t11-t10));
    fprintf(stdout,
            "\n----------------------------------------------------------");
    fprintf(stdout,"\n forward (no keep): \t%le",(t61-t60)*rtu);
    fprintf(stdout,"   units \t%le seconds",(t61-t60)/itu);
    fprintf(stdout,"\n forward + keep   : \t%le",(t21-t20)*rtu);
    fprintf(stdout,"   units \t%le seconds",(t21-t20)/itu);
    fprintf(stdout,"\n reverse          : \t%le",(t31-t30)*rtu);
    fprintf(stdout,"   units \t%le seconds",(t31-t30)/itu);
    fprintf(stdout,
            "\n----------------------------------------------------------");
    fprintf(stdout,"\n gradient         : \t%le",(t41-t40)*rtu);
    fprintf(stdout,"   units \t%le seconds",(t41-t40)/itu);
    fprintf(stdout,"\n hess*vec         : \t%le",(t51-t50)*rtu);
    fprintf(stdout,"   units \t%le seconds\n",(t51-t50)/itu);
  }
  else 
    fprintf(stdout,"\n-> zero timing due to small problem dimension \n");

  return 1;
}

