""" 
adesklets commands module 

===   2005-11-20 18:13:24   === 
Automatically generated by `setup.py protoize' from 
files `../prototypes' and `../enums'. 
15 constants and 154 functions successfully created. 

""" 
# Imports 
# 
from error_handler import ADESKLETSError 
import commands_handler 
import strings 

# Constants 
# 
TEXT_TO_RIGHT        =  0 
TEXT_TO_LEFT         =  1 
TEXT_TO_DOWN         =  2 
TEXT_TO_UP           =  3 
TEXT_TO_ANGLE        =  4 
OP_COPY              =  0 
OP_ADD               =  1 
OP_SUBSTRACT         =  2 
OP_RESHADE           =  3 
CHANNEL_RED          =  0 
CHANNEL_GREEN        =  1 
CHANNEL_BLUE         =  2 
CHANNEL_ALPHA        =  3 
WINDOW_UNMANAGED     =  0 
WINDOW_MANAGED       =  1 

# Functions 
# 
def time_gate(gate):
	"""
	Set a time gate

	double gate
	"""
	comm=commands_handler._Static_commands_handler() 
	print >> comm,   'time_gate',   gate 
	return comm.out()

def help(command=None):
	"""
	Display short help about a command

	[const char * command]
	"""
	comm=commands_handler._Static_commands_handler() 
	print >> comm,   'help',   strings.String(command) 
	return comm.out()

def ping():
	"""
	Ping the interpreter

	void
	"""
	comm=commands_handler._Static_commands_handler() 
	print >> comm,   'ping' 
	return comm.out()

def pause(delay=None):
	"""
	Freeze the interpreter for debugging

	[int delay]
	"""
	comm=commands_handler._Static_commands_handler() 
	print >> comm,   'pause',   strings.String(delay) 
	return comm.out()

def version():
	"""
	Get interpreter version

	void
	"""
	comm=commands_handler._Static_commands_handler() 
	print >> comm,   'version' 
	return comm.out()

def get_id():
	"""
	Get current applet identificator

	void
	"""
	comm=commands_handler._Static_commands_handler() 
	print >> comm,   'get_id' 
	return comm.out()

def history(filename=None):
	"""
	List/save commands history

	[const char * filename]
	"""
	comm=commands_handler._Static_commands_handler() 
	print >> comm,   'history',   strings.String(filename) 
	return comm.out()

def set(name=None, value=None):
	"""
	Set or unset a textual variable

	[const * char name, const * char value]
	"""
	comm=commands_handler._Static_commands_handler() 
	print >> comm,   'set',   strings.String(name), strings.String(value) 
	return comm.out()

def unset_all():
	"""
	Unset all defined textual variables

	void
	"""
	comm=commands_handler._Static_commands_handler() 
	print >> comm,   'unset_all' 
	return comm.out()

def echo(string):
	"""
	Echo a string

	const char * string
	"""
	comm=commands_handler._Static_commands_handler() 
	print >> comm,   'echo',   strings.String(string) 
	return comm.out()

def start_recording():
	"""
	Start recording a macro

	void
	"""
	comm=commands_handler._Static_commands_handler() 
	print >> comm,   'start_recording' 
	return comm.out()

def stop_recording():
	"""
	Stop recording the macro

	void
	"""
	comm=commands_handler._Static_commands_handler() 
	print >> comm,   'stop_recording' 
	return comm.out()

def play_get_abort_on_events():
	"""
	Get replays interuptable status

	void
	"""
	comm=commands_handler._Static_commands_handler() 
	print >> comm,   'play_get_abort_on_events' 
	return comm.out()

def play_set_abort_on_events(abort):
	"""
	Set replays to be interuptable

	bool abort
	"""
	comm=commands_handler._Static_commands_handler() 
	print >> comm,   'play_set_abort_on_events',   strings.String(abort) 
	return comm.out()

def play(beginning, end):
	"""
	Play a given macro

	int beginning, int end
	"""
	comm=commands_handler._Static_commands_handler() 
	print >> comm,   'play',   beginning, end 
	return comm.out()

def context_get_dither():
	"""
	Get context dither

	void
	"""
	comm=commands_handler._Static_commands_handler() 
	print >> comm,   'context_get_dither' 
	return comm.out()

def context_get_anti_alias():
	"""
	Get context anti alias

	void
	"""
	comm=commands_handler._Static_commands_handler() 
	print >> comm,   'context_get_anti_alias' 
	return comm.out()

def context_get_blend():
	"""
	Get context blending

	void
	"""
	comm=commands_handler._Static_commands_handler() 
	print >> comm,   'context_get_blend' 
	return comm.out()

def context_get_operation():
	"""
	Get context operation

	void
	"""
	comm=commands_handler._Static_commands_handler() 
	print >> comm,   'context_get_operation' 
	return comm.out()

def context_get_cliprect():
	"""
	Get clipping rectange

	void
	"""
	comm=commands_handler._Static_commands_handler() 
	print >> comm,   'context_get_cliprect' 
	return comm.out()

def context_get_image():
	"""
	Get context image

	void
	"""
	comm=commands_handler._Static_commands_handler() 
	print >> comm,   'context_get_image' 
	return comm.out()

def context_get_font():
	"""
	Get context font

	void
	"""
	comm=commands_handler._Static_commands_handler() 
	print >> comm,   'context_get_font' 
	return comm.out()

def context_get_color_range():
	"""
	Get context color range

	void
	"""
	comm=commands_handler._Static_commands_handler() 
	print >> comm,   'context_get_color_range' 
	return comm.out()

def context_get_color_modifier():
	"""
	Get context color modifier

	void
	"""
	comm=commands_handler._Static_commands_handler() 
	print >> comm,   'context_get_color_modifier' 
	return comm.out()

def context_get_filter():
	"""
	Get context filter

	void
	"""
	comm=commands_handler._Static_commands_handler() 
	print >> comm,   'context_get_filter' 
	return comm.out()

def context_get_color():
	"""
	Get context color

	void
	"""
	comm=commands_handler._Static_commands_handler() 
	print >> comm,   'context_get_color' 
	return comm.out()

def context_get_angle():
	"""
	Get context angle

	void
	"""
	comm=commands_handler._Static_commands_handler() 
	print >> comm,   'context_get_angle' 
	return comm.out()

def context_get_direction():
	"""
	Get context direction

	void
	"""
	comm=commands_handler._Static_commands_handler() 
	print >> comm,   'context_get_direction' 
	return comm.out()

def context_set_dither(dither):
	"""
	Set context dither

	bool dither
	"""
	comm=commands_handler._Static_commands_handler() 
	print >> comm,   'context_set_dither',   strings.String(dither) 
	return comm.out()

def context_set_anti_alias(anti_alias):
	"""
	Set context anti-alias

	bool anti_alias
	"""
	comm=commands_handler._Static_commands_handler() 
	print >> comm,   'context_set_anti_alias',   strings.String(anti_alias) 
	return comm.out()

def context_set_blend(blend):
	"""
	Set context blending

	bool blend
	"""
	comm=commands_handler._Static_commands_handler() 
	print >> comm,   'context_set_blend',   strings.String(blend) 
	return comm.out()

def context_set_operation(operation):
	"""
	Set context operation

	enum OPERATIONS operation
	"""
	comm=commands_handler._Static_commands_handler() 
	print >> comm,   'context_set_operation',   operation 
	return comm.out()

def context_set_cliprect(x, y, w, h):
	"""
	Set context clipping rectangle

	int x, int y, int w, int h
	"""
	comm=commands_handler._Static_commands_handler() 
	print >> comm,   'context_set_cliprect',   x, y, w, h 
	return comm.out()

def context_set_image(image):
	"""
	Set context image

	int image
	"""
	comm=commands_handler._Static_commands_handler() 
	print >> comm,   'context_set_image',   image 
	return comm.out()

def context_set_font(font=None):
	"""
	Set context font

	[int font]
	"""
	comm=commands_handler._Static_commands_handler() 
	print >> comm,   'context_set_font',   strings.String(font) 
	return comm.out()

def context_set_color_range(color_range=None):
	"""
	Set context color range

	[int color_range]
	"""
	comm=commands_handler._Static_commands_handler() 
	print >> comm,   'context_set_color_range',   strings.String(color_range) 
	return comm.out()

def context_set_color_modifier(color_modifier=None):
	"""
	Set context color modifier

	[int color_modifier]
	"""
	comm=commands_handler._Static_commands_handler() 
	print >> comm,   'context_set_color_modifier',   strings.String(color_modifier) 
	return comm.out()

def context_set_filter(filter=None):
	"""
	Set context filter

	[int filter]
	"""
	comm=commands_handler._Static_commands_handler() 
	print >> comm,   'context_set_filter',   strings.String(filter) 
	return comm.out()

def context_set_color(red, green, blue, alpha):
	"""
	Set context RGBA color

	int red, int green, int blue, int alpha
	"""
	comm=commands_handler._Static_commands_handler() 
	print >> comm,   'context_set_color',   red, green, blue, alpha 
	return comm.out()

def context_set_angle(angle):
	"""
	Set context angle

	double angle
	"""
	comm=commands_handler._Static_commands_handler() 
	print >> comm,   'context_set_angle',   angle 
	return comm.out()

def context_set_direction(direction):
	"""
	Set context direction

	enum DIRECTIONS direction
	"""
	comm=commands_handler._Static_commands_handler() 
	print >> comm,   'context_set_direction',   direction 
	return comm.out()

def add_color_to_color_range(distance_away):
	"""
	Add a color to a color range

	int distance_away
	"""
	comm=commands_handler._Static_commands_handler() 
	print >> comm,   'add_color_to_color_range',   distance_away 
	return comm.out()

def blend_image_onto_image(source_image, merge_alpha, source_x, source_y,
source_width, source_height, destination_x, destination_y, destination_width,
destination_height):
	"""
	Blend images together

	int source_image,char merge_alpha, int source_x,int source_y, int
	source_width,int source_height, int destination_x,int destination_y,
	int destination_width,int destination_height
	"""
	comm=commands_handler._Static_commands_handler() 
	print >> comm,   'blend_image_onto_image',   source_image, merge_alpha, source_x, source_y, source_width, source_height, destination_x, destination_y, destination_width, destination_height 
	return comm.out()

def blend_image_onto_image_at_angle(source_image, merge_alpha, source_x,
source_y, source_width, source_height, destination_x, destination_y, angle_x,
angle_y):
	"""
	Blend images together

	int source_image,char merge_alpha, int source_x,int source_y, int
	source_width,int source_height,int destination_x,int destination_y,
	int angle_x,int angle_y
	"""
	comm=commands_handler._Static_commands_handler() 
	print >> comm,   'blend_image_onto_image_at_angle',   source_image, merge_alpha, source_x, source_y, source_width, source_height, destination_x, destination_y, angle_x, angle_y 
	return comm.out()

def blend_image_onto_image_skewed(source_image, merge_alpha, source_x,
source_y, source_width, source_height, destination_x, destination_y,
h_angle_x, h_angle_y, v_angle_x, v_angle_y):
	"""
	Blend images together

	int source_image,char merge_alpha, int source_x,int source_y, int
	source_width,int source_height,int destination_x,int destination_y,
	int h_angle_x,int h_angle_y, int v_angle_x,int v_angle_y
	"""
	comm=commands_handler._Static_commands_handler() 
	print >> comm,   'blend_image_onto_image_skewed',   source_image, merge_alpha, source_x, source_y, source_width, source_height, destination_x, destination_y, h_angle_x, h_angle_y, v_angle_x, v_angle_y 
	return comm.out()

def apply_filter(script):
	"""
	Apply a dynamic filter

	const char * script
	"""
	comm=commands_handler._Static_commands_handler() 
	print >> comm,   'apply_filter',   strings.String(script) 
	return comm.out()

def get_text_size(text):
	"""
	Get size of text

	const char * text
	"""
	comm=commands_handler._Static_commands_handler() 
	print >> comm,   'get_text_size',   strings.String(text) 
	return comm.out()

def get_text_advance(text):
	"""
	Get advance of text

	const char * text
	"""
	comm=commands_handler._Static_commands_handler() 
	print >> comm,   'get_text_advance',   strings.String(text) 
	return comm.out()

def text_draw(x, y, text):
	"""
	Draw a text string

	int x, int y, const char *text
	"""
	comm=commands_handler._Static_commands_handler() 
	print >> comm,   'text_draw',   x, y, strings.String(text) 
	return comm.out()

def modify_color_modifier_gamma(gamma_value):
	"""
	Modify gamma correction

	double gamma_value
	"""
	comm=commands_handler._Static_commands_handler() 
	print >> comm,   'modify_color_modifier_gamma',   gamma_value 
	return comm.out()

def modify_color_modifier_brightness(brightness_value):
	"""
	Modify brightness

	double brightness_value
	"""
	comm=commands_handler._Static_commands_handler() 
	print >> comm,   'modify_color_modifier_brightness',   brightness_value 
	return comm.out()

def modify_color_modifier_contrast(contrast_value):
	"""
	Modify contrast

	double contrast_value
	"""
	comm=commands_handler._Static_commands_handler() 
	print >> comm,   'modify_color_modifier_contrast',   contrast_value 
	return comm.out()

def get_color_modifier_tables():
	"""
	Get tables for a color modifier

	void
	"""
	comm=commands_handler._Static_commands_handler() 
	print >> comm,   'get_color_modifier_tables' 
	return comm.out()

def set_color_modifier_tables(table):
	"""
	Set tables for a color modifier

	unsigned char * table
	"""
	comm=commands_handler._Static_commands_handler() 
	print >> comm,   'set_color_modifier_tables',   strings.String(table) 
	return comm.out()

def get_color_modifier_value(table, index):
	"""
	Get a value for a color modifier

	enum RGBA_TABLES table, int index
	"""
	comm=commands_handler._Static_commands_handler() 
	print >> comm,   'get_color_modifier_value',   table, index 
	return comm.out()

def set_color_modifier_value(table, index, value):
	"""
	Set a value for a color modifier

	enum RGBA_TABLES table, int index, int value
	"""
	comm=commands_handler._Static_commands_handler() 
	print >> comm,   'set_color_modifier_value',   table, index, value 
	return comm.out()

def apply_color_modifier():
	"""
	Apply a color modifier

	void
	"""
	comm=commands_handler._Static_commands_handler() 
	print >> comm,   'apply_color_modifier' 
	return comm.out()

def apply_color_modifier_to_rectangle(x, y, width, height):
	"""
	Apply a color modifier

	int x, int y, int width,int height
	"""
	comm=commands_handler._Static_commands_handler() 
	print >> comm,   'apply_color_modifier_to_rectangle',   x, y, width, height 
	return comm.out()

def load_image_without_cache(file):
	"""
	Load an image from disk bypassing the cache

	const char *file
	"""
	comm=commands_handler._Static_commands_handler() 
	print >> comm,   'load_image_without_cache',   strings.String(file) 
	return comm.out()

def load_image(file):
	"""
	Load an image from disk

	const char *file
	"""
	comm=commands_handler._Static_commands_handler() 
	print >> comm,   'load_image',   strings.String(file) 
	return comm.out()

def save_image(filename):
	"""
	Save an image to disk

	const char *filename
	"""
	comm=commands_handler._Static_commands_handler() 
	print >> comm,   'save_image',   strings.String(filename) 
	return comm.out()

def create_image(width, height):
	"""
	Create an image

	int width, int height
	"""
	comm=commands_handler._Static_commands_handler() 
	print >> comm,   'create_image',   width, height 
	return comm.out()

def create_image_using_data(width, height, data):
	"""
	Create an image from data

	int width, int height,unsigned int * data
	"""
	comm=commands_handler._Static_commands_handler() 
	print >> comm,   'create_image_using_data',   width, height, strings.String(data) 
	return comm.out()

def clone_image():
	"""
	Create a copy of an image

	void
	"""
	comm=commands_handler._Static_commands_handler() 
	print >> comm,   'clone_image' 
	return comm.out()

def free_image(image):
	"""
	Free an image

	int image
	"""
	comm=commands_handler._Static_commands_handler() 
	print >> comm,   'free_image',   image 
	return comm.out()

def load_font(font_name):
	"""
	Load a font

	const char *font_name
	"""
	comm=commands_handler._Static_commands_handler() 
	print >> comm,   'load_font',   strings.String(font_name) 
	return comm.out()

def free_font(font):
	"""
	Free a font

	int font
	"""
	comm=commands_handler._Static_commands_handler() 
	print >> comm,   'free_font',   font 
	return comm.out()

def list_fonts():
	"""
	List all fonts

	void
	"""
	comm=commands_handler._Static_commands_handler() 
	print >> comm,   'list_fonts' 
	return comm.out()

def list_font_path():
	"""
	List all fonts path

	void
	"""
	comm=commands_handler._Static_commands_handler() 
	print >> comm,   'list_font_path' 
	return comm.out()

def add_path_to_font_path(path):
	"""
	Add a font path

	const char *path
	"""
	comm=commands_handler._Static_commands_handler() 
	print >> comm,   'add_path_to_font_path',   strings.String(path) 
	return comm.out()

def remove_path_from_font_path(path):
	"""
	Remove a font path

	const char *path
	"""
	comm=commands_handler._Static_commands_handler() 
	print >> comm,   'remove_path_from_font_path',   strings.String(path) 
	return comm.out()

def create_color_range():
	"""
	Create a color range

	void
	"""
	comm=commands_handler._Static_commands_handler() 
	print >> comm,   'create_color_range' 
	return comm.out()

def free_color_range(color_range):
	"""
	Free a color range

	int color_range
	"""
	comm=commands_handler._Static_commands_handler() 
	print >> comm,   'free_color_range',   color_range 
	return comm.out()

def create_filter():
	"""
	Create a filter

	void
	"""
	comm=commands_handler._Static_commands_handler() 
	print >> comm,   'create_filter' 
	return comm.out()

def free_filter(filter):
	"""
	Free a filter

	int filter
	"""
	comm=commands_handler._Static_commands_handler() 
	print >> comm,   'free_filter',   filter 
	return comm.out()

def create_color_modifier():
	"""
	Create a color modifier

	void
	"""
	comm=commands_handler._Static_commands_handler() 
	print >> comm,   'create_color_modifier' 
	return comm.out()

def free_color_modifier(color_modifier):
	"""
	Free a color modifier

	int color_modifier
	"""
	comm=commands_handler._Static_commands_handler() 
	print >> comm,   'free_color_modifier',   color_modifier 
	return comm.out()

def polygon_new():
	"""
	Create a polygon

	void
	"""
	comm=commands_handler._Static_commands_handler() 
	print >> comm,   'polygon_new' 
	return comm.out()

def polygon_free(poly):
	"""
	Free a polygon

	int poly
	"""
	comm=commands_handler._Static_commands_handler() 
	print >> comm,   'polygon_free',   poly 
	return comm.out()

def polygon_add_point(poly, x, y):
	"""
	Add point to a polygon

	int poly, int x, int y
	"""
	comm=commands_handler._Static_commands_handler() 
	print >> comm,   'polygon_add_point',   poly, x, y 
	return comm.out()

def images_reset_all():
	"""
	Free all images and refresh foreground

	void
	"""
	comm=commands_handler._Static_commands_handler() 
	print >> comm,   'images_reset_all' 
	return comm.out()

def images_info():
	"""
	Get information on all images

	void
	"""
	comm=commands_handler._Static_commands_handler() 
	print >> comm,   'images_info' 
	return comm.out()

def fonts_reset_all():
	"""
	Free all fonts

	void
	"""
	comm=commands_handler._Static_commands_handler() 
	print >> comm,   'fonts_reset_all' 
	return comm.out()

def fonts_info():
	"""
	Get information on all fonts

	void
	"""
	comm=commands_handler._Static_commands_handler() 
	print >> comm,   'fonts_info' 
	return comm.out()

def color_ranges_reset_all():
	"""
	Free all color ranges

	void
	"""
	comm=commands_handler._Static_commands_handler() 
	print >> comm,   'color_ranges_reset_all' 
	return comm.out()

def color_ranges_info():
	"""
	Get information on all color ranges

	void
	"""
	comm=commands_handler._Static_commands_handler() 
	print >> comm,   'color_ranges_info' 
	return comm.out()

def color_modifiers_reset_all():
	"""
	Free all color modifiers

	void
	"""
	comm=commands_handler._Static_commands_handler() 
	print >> comm,   'color_modifiers_reset_all' 
	return comm.out()

def color_modifiers_info():
	"""
	Get information on all color modifiers

	void
	"""
	comm=commands_handler._Static_commands_handler() 
	print >> comm,   'color_modifiers_info' 
	return comm.out()

def filters_reset_all():
	"""
	Free all filters

	void
	"""
	comm=commands_handler._Static_commands_handler() 
	print >> comm,   'filters_reset_all' 
	return comm.out()

def filters_info():
	"""
	Get information on all filters

	void
	"""
	comm=commands_handler._Static_commands_handler() 
	print >> comm,   'filters_info' 
	return comm.out()

def polygons_reset_all():
	"""
	Free all polygons

	void
	"""
	comm=commands_handler._Static_commands_handler() 
	print >> comm,   'polygons_reset_all' 
	return comm.out()

def polygons_info():
	"""
	Get information on all polygons

	void
	"""
	comm=commands_handler._Static_commands_handler() 
	print >> comm,   'polygons_info' 
	return comm.out()

def image_has_alpha():
	"""
	Get alpha channel setting of an image

	void
	"""
	comm=commands_handler._Static_commands_handler() 
	print >> comm,   'image_has_alpha' 
	return comm.out()

def image_get_width():
	"""
	Get width of an image

	void
	"""
	comm=commands_handler._Static_commands_handler() 
	print >> comm,   'image_get_width' 
	return comm.out()

def image_get_height():
	"""
	Get height of an image

	void
	"""
	comm=commands_handler._Static_commands_handler() 
	print >> comm,   'image_get_height' 
	return comm.out()

def image_get_filename():
	"""
	Get filename of an image

	void
	"""
	comm=commands_handler._Static_commands_handler() 
	print >> comm,   'image_get_filename' 
	return comm.out()

def image_get_data():
	"""
	Get the data of an image

	void
	"""
	comm=commands_handler._Static_commands_handler() 
	print >> comm,   'image_get_data' 
	return comm.out()

def image_query_pixel(x, y):
	"""
	Query a pixel value

	int x, int y
	"""
	comm=commands_handler._Static_commands_handler() 
	print >> comm,   'image_query_pixel',   x, y 
	return comm.out()

def image_set_has_alpha(has_alpha):
	"""
	Set alpha channel of an image

	bool has_alpha
	"""
	comm=commands_handler._Static_commands_handler() 
	print >> comm,   'image_set_has_alpha',   strings.String(has_alpha) 
	return comm.out()

def image_set_changes_on_disk():
	"""
	Set image load time behavior

	void
	"""
	comm=commands_handler._Static_commands_handler() 
	print >> comm,   'image_set_changes_on_disk' 
	return comm.out()

def image_set_format(format):
	"""
	Set image format

	const char *format
	"""
	comm=commands_handler._Static_commands_handler() 
	print >> comm,   'image_set_format',   strings.String(format) 
	return comm.out()

def image_filter_recurse():
	"""

	void
	"""
	comm=commands_handler._Static_commands_handler() 
	print >> comm,   'image_filter_recurse' 
	return comm.out()

def image_draw_line(x1, y1, x2, y2, make_updates):
	"""
	Draw a line

	int x1, int y1, int x2, int y2,char make_updates
	"""
	comm=commands_handler._Static_commands_handler() 
	print >> comm,   'image_draw_line',   x1, y1, x2, y2, make_updates 
	return comm.out()

def image_draw_rectangle(x, y, width, height):
	"""
	Draw a rectangle

	int x, int y, int width, int height
	"""
	comm=commands_handler._Static_commands_handler() 
	print >> comm,   'image_draw_rectangle',   x, y, width, height 
	return comm.out()

def image_fill_rectangle(x, y, width, height):
	"""
	Draw a filled rectangle

	int x, int y, int width, int height
	"""
	comm=commands_handler._Static_commands_handler() 
	print >> comm,   'image_fill_rectangle',   x, y, width, height 
	return comm.out()

def image_fill_color_range_rectangle(x, y, width, height, angle):
	"""
	Draw a gradian filled rectange

	int x, int y, int width,int height, double angle
	"""
	comm=commands_handler._Static_commands_handler() 
	print >> comm,   'image_fill_color_range_rectangle',   x, y, width, height, angle 
	return comm.out()

def image_draw_ellipse(xc, yc, a, b):
	"""
	Draw an ellipse

	int xc, int yc, int a, int b
	"""
	comm=commands_handler._Static_commands_handler() 
	print >> comm,   'image_draw_ellipse',   xc, yc, a, b 
	return comm.out()

def image_fill_ellipse(xc, yc, a, b):
	"""
	Fill an ellipse

	int xc, int yc, int a, int b
	"""
	comm=commands_handler._Static_commands_handler() 
	print >> comm,   'image_fill_ellipse',   xc, yc, a, b 
	return comm.out()

def image_copy_alpha_to_image(image_source, x, y):
	"""
	Transfert alpha channel

	int image_source, int x,int y
	"""
	comm=commands_handler._Static_commands_handler() 
	print >> comm,   'image_copy_alpha_to_image',   image_source, x, y 
	return comm.out()

def image_copy_alpha_rectangle_to_image(image_source, x, y, width, height,
destination_x, destination_y):
	"""
	Transfert alpha channel

	int image_source,int x, int y, int width,int height,int
	destination_x,int destination_y
	"""
	comm=commands_handler._Static_commands_handler() 
	print >> comm,   'image_copy_alpha_rectangle_to_image',   image_source, x, y, width, height, destination_x, destination_y 
	return comm.out()

def image_draw_polygon(poly, closed):
	"""
	Draw a polygon onto image

	int poly, unsigned char closed
	"""
	comm=commands_handler._Static_commands_handler() 
	print >> comm,   'image_draw_polygon',   poly, closed 
	return comm.out()

def image_fill_polygon(poly):
	"""
	Fill a polygon onto image

	int poly
	"""
	comm=commands_handler._Static_commands_handler() 
	print >> comm,   'image_fill_polygon',   poly 
	return comm.out()

def image_flip_horizontal():
	"""
	Flip an image horizontally

	void
	"""
	comm=commands_handler._Static_commands_handler() 
	print >> comm,   'image_flip_horizontal' 
	return comm.out()

def image_flip_vertical():
	"""
	Flip an image vertically

	void
	"""
	comm=commands_handler._Static_commands_handler() 
	print >> comm,   'image_flip_vertical' 
	return comm.out()

def image_flip_diagonal():
	"""
	Flip an image diagonally

	void
	"""
	comm=commands_handler._Static_commands_handler() 
	print >> comm,   'image_flip_diagonal' 
	return comm.out()

def image_orientate(orientation):
	"""
	Orientate an image

	int orientation
	"""
	comm=commands_handler._Static_commands_handler() 
	print >> comm,   'image_orientate',   orientation 
	return comm.out()

def image_blur(radius):
	"""
	Blur an image

	int radius
	"""
	comm=commands_handler._Static_commands_handler() 
	print >> comm,   'image_blur',   radius 
	return comm.out()

def image_sharpen(radius):
	"""
	Sharpen an image

	int radius
	"""
	comm=commands_handler._Static_commands_handler() 
	print >> comm,   'image_sharpen',   radius 
	return comm.out()

def filter_set(xoff, yoff, a, r, g, b):
	"""
	Set filter

	int xoff, int yoff, int a, int r, int g, int b
	"""
	comm=commands_handler._Static_commands_handler() 
	print >> comm,   'filter_set',   xoff, yoff, a, r, g, b 
	return comm.out()

def filter_set_red(xoff, yoff, a, r, g, b):
	"""
	Set filter red channel

	int xoff, int yoff, int a, int r, int g, int b
	"""
	comm=commands_handler._Static_commands_handler() 
	print >> comm,   'filter_set_red',   xoff, yoff, a, r, g, b 
	return comm.out()

def filter_set_green(xoff, yoff, a, r, g, b):
	"""
	Set filter grean channel

	int xoff, int yoff, int a, int r, int g, int b
	"""
	comm=commands_handler._Static_commands_handler() 
	print >> comm,   'filter_set_green',   xoff, yoff, a, r, g, b 
	return comm.out()

def filter_set_blue(xoff, yoff, a, r, g, b):
	"""
	Set filter blue channel

	int xoff, int yoff, int a, int r, int g, int b
	"""
	comm=commands_handler._Static_commands_handler() 
	print >> comm,   'filter_set_blue',   xoff, yoff, a, r, g, b 
	return comm.out()

def filter_set_alpha(xoff, yoff, a, r, g, b):
	"""
	Set filter alpha channel

	int xoff, int yoff, int a, int r, int g, int b
	"""
	comm=commands_handler._Static_commands_handler() 
	print >> comm,   'filter_set_alpha',   xoff, yoff, a, r, g, b 
	return comm.out()

def filter_constants(a, r, g, b):
	"""
	Set filter constants

	int a, int r, int g, int b
	"""
	comm=commands_handler._Static_commands_handler() 
	print >> comm,   'filter_constants',   a, r, g, b 
	return comm.out()

def filter_divisors(a, r, g, b):
	"""
	Set filter divisors

	int a, int r, int g, int b
	"""
	comm=commands_handler._Static_commands_handler() 
	print >> comm,   'filter_divisors',   a, r, g, b 
	return comm.out()

def menu_fire(menu):
	"""
	Fire a given menu

	int menu
	"""
	comm=commands_handler._Static_commands_handler() 
	print >> comm,   'menu_fire',   menu 
	return comm.out()

def menu_reset_all():
	"""
	Reset all menus to initial state

	void
	"""
	comm=commands_handler._Static_commands_handler() 
	print >> comm,   'menu_reset_all' 
	return comm.out()

def menu_add_menu():
	"""
	Add a new menu

	void
	"""
	comm=commands_handler._Static_commands_handler() 
	print >> comm,   'menu_add_menu' 
	return comm.out()

def menu_add_submenu(submenu):
	"""
	Add a submenu to current menu

	const char * submenu
	"""
	comm=commands_handler._Static_commands_handler() 
	print >> comm,   'menu_add_submenu',   strings.String(submenu) 
	return comm.out()

def menu_add_item(add_item):
	"""
	Add an item to current menu

	const char * add_item
	"""
	comm=commands_handler._Static_commands_handler() 
	print >> comm,   'menu_add_item',   strings.String(add_item) 
	return comm.out()

def menu_add_separator():
	"""
	Add a separator to current menu

	void
	"""
	comm=commands_handler._Static_commands_handler() 
	print >> comm,   'menu_add_separator' 
	return comm.out()

def menu_end_submenu():
	"""
	End a submenu construction

	void
	"""
	comm=commands_handler._Static_commands_handler() 
	print >> comm,   'menu_end_submenu' 
	return comm.out()

def events_info():
	"""
	Get all caught events

	void
	"""
	comm=commands_handler._Static_commands_handler() 
	print >> comm,   'events_info' 
	return comm.out()

def events_get_echo():
	"""
	Get events echo status

	void
	"""
	comm=commands_handler._Static_commands_handler() 
	print >> comm,   'events_get_echo' 
	return comm.out()

def events_get_send_sigusr1():
	"""
	Get sending of SIGUSR1 to parent on event

	void
	"""
	comm=commands_handler._Static_commands_handler() 
	print >> comm,   'events_get_send_sigusr1' 
	return comm.out()

def window_reset(manager):
	"""
	Reset the window

	enum WINDOW_MANAGER manager
	"""
	comm=commands_handler._Static_commands_handler() 
	print >> comm,   'window_reset',   manager 
	return comm.out()

def window_show():
	"""
	Map the window on the screen

	void
	"""
	comm=commands_handler._Static_commands_handler() 
	print >> comm,   'window_show' 
	return comm.out()

def window_hide():
	"""
	Unmap the window from the screen

	void
	"""
	comm=commands_handler._Static_commands_handler() 
	print >> comm,   'window_hide' 
	return comm.out()

def window_resize(width, height):
	"""
	Resize the window

	int width, int height
	"""
	comm=commands_handler._Static_commands_handler() 
	print >> comm,   'window_resize',   width, height 
	return comm.out()

def window_get_transparency():
	"""
	Get automatic transparency

	void
	"""
	comm=commands_handler._Static_commands_handler() 
	print >> comm,   'window_get_transparency' 
	return comm.out()

def window_get_background_grab():
	"""
	Get automatic grab

	void
	"""
	comm=commands_handler._Static_commands_handler() 
	print >> comm,   'window_get_background_grab' 
	return comm.out()

def window_get_background_image():
	"""
	Get background image

	void
	"""
	comm=commands_handler._Static_commands_handler() 
	print >> comm,   'window_get_background_image' 
	return comm.out()

def window_get_managed_status():
	"""
	Get managed status

	void
	"""
	comm=commands_handler._Static_commands_handler() 
	print >> comm,   'window_get_managed_status' 
	return comm.out()

def window_set_transparency(transparency):
	"""
	Set automatic transparency

	bool transparency
	"""
	comm=commands_handler._Static_commands_handler() 
	print >> comm,   'window_set_transparency',   strings.String(transparency) 
	return comm.out()

def window_set_background_grab(grab):
	"""
	Set automatic grab

	bool grab
	"""
	comm=commands_handler._Static_commands_handler() 
	print >> comm,   'window_set_background_grab',   strings.String(grab) 
	return comm.out()

def window_set_background_image(image):
	"""
	Set background image

	int image
	"""
	comm=commands_handler._Static_commands_handler() 
	print >> comm,   'window_set_background_image',   image 
	return comm.out()

def screen_get_width():
	"""
	Get screen width

	void
	"""
	comm=commands_handler._Static_commands_handler() 
	print >> comm,   'screen_get_width' 
	return comm.out()

def screen_get_height():
	"""
	Get screen height

	void
	"""
	comm=commands_handler._Static_commands_handler() 
	print >> comm,   'screen_get_height' 
	return comm.out()

def screen_get_depth():
	"""
	Get screen depth

	void
	"""
	comm=commands_handler._Static_commands_handler() 
	print >> comm,   'screen_get_depth' 
	return comm.out()

def get_charset():
	"""
	Get input charset

	void
	"""
	comm=commands_handler._Static_commands_handler() 
	print >> comm,   'get_charset' 
	return comm.out()

def set_charset(charset):
	"""
	Set input charset

	const char * charset
	"""
	comm=commands_handler._Static_commands_handler() 
	print >> comm,   'set_charset',   strings.String(charset) 
	return comm.out()

def charset_status():
	"""
	Get charset capabilities

	void
	"""
	comm=commands_handler._Static_commands_handler() 
	print >> comm,   'charset_status' 
	return comm.out()

def x_status():
	"""
	Status of connection to X Window server

	void
	"""
	comm=commands_handler._Static_commands_handler() 
	print >> comm,   'x_status' 
	return comm.out()

def quit():
	"""
	Quit the program

	void
	"""
	comm=commands_handler._Static_commands_handler() 
	print >> comm,   'quit' 
	return comm.out()

