#   
# Module:     batch.pm  
# Date:       03/05/04  
# Version:    1.8  
# Edited by:  teon@teon.org  
# Description:  
#
#  This is a bach mode User Interface 
#  
# License:  
# 
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License Version 2 as
#  published by the Free Software Foundation.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
#  USA.
#
# This file is part of adduser-ng program.
#
# Copyright (C) 2003 Bartosz Oler <liar@bzimage.us>
# Copyright (C) 2003 Robert Olejnik <teon@teon.org>
#

package AddUser::UI::batch;

use strict;
use Term::ANSIColor qw(:constants);



sub new {
	my ($c, %args) = @_;
	my $class = ref($c) || $c;

	bless \%args, $class;
}

# init
# 
# Initialize UI
#
# {{{
sub init
{
	my $self = shift;
	$self->{opts} = {};

	$| = 1;

	&parse_argv($self);
}

# }}}

# end
# 
# Cleanup
#
# {{{
sub end
{
        # nothing to do for this UI
}

# }}}

# display($title, $msg)
#
# Display a message.
#
# {{{
sub display
{
        my ($self, $title, $msg) = @_;
}

# }}}

# display_getkey($title, $msg)
#
# Display a message.
#
# {{{
sub display_getkey
{
        my ($self, $title, $msg) = @_;
}

# }}}

# display_error($title, $msg)
#
# Display an error message.
#
# {{{
sub display_error
{
        my ($self, $title, $msg) = @_;
}

# }}}

# get_single($plugname, $optname, $short, $desc, $def, @answers)
#
# {{{
sub get_single {
	my ($self, $plugname, $optname, $short, $desc, $def, @answers) = @_;
	my $ans = $self->{opts}{$plugname}{$optname};

	return $ans ? $ans : $def;
}
# }}}

# get_long($plugin, $option, $synopsis, $description, $default)
#
# {{{
sub get_long {
	my ($self, $plugname, $optname, $short, $desc, $def) = @_;
	my $ans = $self->{opts}{$plugname}{$optname};

	return $ans ? $ans : $def;
}
# }}}

# get_password($plugin, $option, $synopsis, $description, $default)
#
# {{{
sub get_password {
	my ($self, $plugname, $optname, $short, $desc, $def) = @_;
	my $ans = $self->{opts}{$plugname}{$optname};


	return $ans ? $ans : $def;
}
# }}}

# parse_argv($self)
#
# Parse command line arguments.
#
# {{{
sub parse_argv
{
	my $self = shift;

	for my $opt (@{$self->{plugins_options}{argv}}) {
		my ($k, $v) = split(/\s*=\s*/, $opt);
		my ($plug, $var) = split(/\./, $k);
		$self->{opts}{$plug}{$var} = $v;
	}
}
# }}}

1;
