#
# $Id: s.example.pm 1.4 03/08/25 17:33:18+02:00 robert@zaron.debian.pl $
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License Version 2 as
#  published by the Free Software Foundation.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
#  USA.
#
# Description:
#     This is an example plugin, that has only one option. It's ment to be
#     helpfull for people, who want to write their own plugins for AddUser-ng.
#
# This file is part of adduser-ng program.
#
# Copyright (C) 2003 Bartosz Oler <liar@bzimage.us>
# Copyright (C) 2003 Robert Olejnik <robert@zaron.debian.pl>
#

# AddUser-ng's plugins, are generally perl modules, so they have their own
# package
package AddUser::plugins::example;

# it's always a good idea to use strict
use strict;
# this module, holds all addusers common methods, you always have to include
# it when writing new plugin
use AddUser::StdLib;

# this is the plugin's name. _HAS TO BE SAME AS PACKAGE AND FILENAME (without
# the '.pm')_
my $_PLUGIN = 'example';

# This is the plugin API version and has to be same as AddUser-NG API version.
my $_APIVERSION = 0x1;

# new
# ===
#
# new method, is used to:
# 
#    - get the AddUser's API availabe for plugin
#    - define plugins options
#    - set default values for options
#
# {{{

sub new {
        # get the API
	my ($c, %args) = @_;
	my $class = ref($c) || $c;

        # define plugins options:
        #
        # this plugin is an example, and has only one option (with no default
        # value)
	$args{opts} = {
                # option name   default value
                #     |           |
		'your_name'  =>  ''
        };

        # here, we're exporting this plugin APIVERSION (which has to be
        # compatible with AddUser-NG APIVERSION), and plugin name (for
        # debug/verbose purpuse)
        $args{APIVERSION} = $_APIVERSION;
        $args{NAME} = $_PLUGIN;

	bless \%args, $class;
}

# }}}




# configure
# =========
#
# This method is used to configure the plugin:
#
#    - get values for all options from the group config
#    - if there's now value for an option, user will be asked for it through
#      UI
#
# {{{

sub configure {
        # get the API
	my $self     = shift;
        # configuration file handle
        my $conf     = $self->{plugins_options}{GroupConfig};
        # UI handle
        my $ui       = $self->{plugins_options}{UI};
        # verbose variable (0 - be quiet, 1 - be verbose)
        my $verbose  = $self->{plugins_options}{verbose};
        # the keywords hash handle
        my $keywords = $self->{plugins_options}{keywords};
        # plugins documenation handle
	my $docs     = &get_documentation($self->{plugins_options}{documentation_dir}, $_PLUGIN);

	# Actually API is quite dirty, so you have to extend API with
	# reference to the documentation.
	$self->{plugins_options}{docs} = $docs->{options}{option};

        # if we're to be verbose, print the plugins description (it's not
        # required, but we always do this.
	$ui->display($_PLUGIN, $docs->{description}."\n") if $verbose;

        #
        # ok, the main part:
        #
        # This is a wrapper function, for the UI->get_long method.
        # The get_long method is used to get a string from user (if an
        # option isn't set in a group file)
        #
        # wrapper_getlong syntax:
        #
        # wrapper_getlong($API_HANDLE, $_PLUGIN, 'option_ame')
        #
	wrapper_getlong($self, $_PLUGIN, 'your_name');

        # ok, we've got the value, let's check if it's correct
        if($self->{opts}{'your_name'} eq "" or $self->{opts}{'your_name'} !~ /\w+(\s+\w+)?/) {
                # oh, we've got an error!
                # So, let's learn how to display errors :)
                #
                # display_error method in UI is used for notifying an user of
		# an error.
                # 
                # syntax: display_error("title", "error message")
                #
                $ui->display_error("example plugin ERROR!", "Are you sure that's your name: $self->{opts}{'your_name'} ??");
		return $ERRNO{'ERROR'};
        }

        # ok, configuration is ok :)
	return $ERRNO{'OK'};
}

# }}}


# execute
# =======
#
# This method is the main part, it is used for doing all the work that the
# plugin is supposed to do.
#
# The plugin is now configured, so we have all required information.
#
# {{{

sub execute {
        # get the API
	my $self     = shift;
        # configuration file handle
        my $conf     = $self->{plugins_options}{GroupConfig};
        # UI handle
        my $ui       = $self->{plugins_options}{UI};
        # verbose variable (0 - be quiet, 1 - be verbose)
        my $verbose  = $self->{plugins_options}{verbose};
        # the keywords, aren't needed
        # my $keywords = $self->{plugins_options}{keywords};
        # so as the documentation
        # my $docs     = &get_documentation($self->{plugins_options}{documentation_dir}, $_PLUGIN);

        # ok, we might as well get the option value :)
        my $your_name = "$self->{opts}{'your_name'}";

        # and the main ACTION:
        #
        # ...
        #
        # you can do whatever you want, BUT, all work here has to be
        # automatic! No user interferation is needed. Do what you have to and
        # exit quietly!

        # as it's an example, let's brake the rules and display something to
        # user, what else can i do in here with one option :)

        $ui->display_getkey("Some Title", "Great! Your name is: $your_name! Nice to meet you :D Now watch the cool thing happend when you hit ENTER ;>");

        # let's return ERROR, to call rollback
	return $ERRNO{'ERROR'};
}

# }}}


# rollback
# ========
#
# BUT, it something goes wrong during the _execute_ method  of any plugin (if
# it returns something else then $ERRNO{'OK'}), this method is called, to
# rollback the changes the plugin has done
#
# {{{

sub rollback {
        # same as in execute
	my $self    = shift;
        my $conf    = $self->{plugins_options}{GroupConfig};
        my $ui      = $self->{plugins_options}{UI};
        my $verbose = $self->{plugins_options}{verbose};

        my $your_name = "$self->{opts}{'your_name'}";
        
        # don't know what to do.. stupid example...
        # eeee.. ill use display :)
        $ui->display("UPS, rollback in this plugin ??", "I don't know how, but you: $your_name, made the impossible, and made AddUser-ng to call rollback for THIS plugin!!!?? :\\");
        
	return $ERRNO{'OK'};
}

# }}}

# this is the end... my only friend... the end
1;
