#
# $Id: s.NotifyJabber.pm 1.4 03/11/04 20:27:52+01:00 robert@zaron.debian.pl $
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License Version 2 as
#  published by the Free Software Foundation.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
#  USA.
#
# This file is part of adduser-ng program.
# 
# Copyright (C) 2003 Robert Olejnik <robert@zaron.debian.pl>
# Copyright (C) 2003 Bartosz Oler <liar@bzimage.us>
#

package AddUser::plugins::NotifyJabber;

use strict;
use AddUser::StdLib;
use Net::Jabber qw(Client);
use Sys::Hostname;

my $_PLUGIN = 'NotifyJabber';
my $_APIVERSION = 0x1;


# new {{{
sub new {
	my ($c, %args) = @_;
	my $class = ref($c) || $c;

	$args{opts} = {
			'server'   => '',
                        'username' => '',
			'password' => '',
			'send_to'  => ''
                        };

        $args{APIVERSION} = $_APIVERSION;
        $args{NAME} = $_PLUGIN;

	bless \%args, $class;
}

# }}}



# configure {{{
sub configure {
	my $self     = shift;
        my $conf     = $self->{plugins_options}{GroupConfig};
        my $ui       = $self->{plugins_options}{UI};
        my $verbose  = $self->{plugins_options}{verbose};
        my $keywords = $self->{plugins_options}{keywords};
	my $docs     = &get_documentation($self->{plugins_options}{documentation_dir}, $_PLUGIN);

        $self->{plugins_options}{docs} = $docs->{options}{option};
        $ui->display($_PLUGIN, $docs->{description}."\n") if $verbose;

 	wrapper_getlong($self, $_PLUGIN, 'server');

        while ($self->{opts}{'server'} eq "" or $self->{opts}{'server'} !~ /((\w+)\.(\w+))/ ) {
            $ui->display_error("NotifyJabber ERROR!", "Plese enter a correct value for 'server' option..");
	    $self->{opts}{'server'} = '';
	    wrapper_getlong($self, $_PLUGIN, 'server');
        }

       wrapper_getlong($self, $_PLUGIN, 'username');

        while ($self->{opts}{'username'} eq "") {
            $ui->display_error("NotifyJabber ERROR!", "Plese enter a correct value for 'username' option..");
	    wrapper_getlong($self, $_PLUGIN, 'username');
        }

        wrapper_getpassword($self, $_PLUGIN, 'password');

        while ($self->{opts}{'password'} eq "") {
            $ui->display_error("NotifyJabber ERROR!", "Plese enter a correct value for 'password' option..");
	    wrapper_getlong($self, $_PLUGIN, 'password');
        }

	wrapper_getlong($self, $_PLUGIN, 'send_to');

        while ($self->{opts}{'send_to'} eq "" or check_jid($self->{opts}{'send_to'})) {
	    
            $ui->display_error("NotifyJabber ERROR!", "Plese enter a correct value for 'send_to' option..");
	    $self->{opts}{'send_to'} = '';
	    wrapper_getlong($self, $_PLUGIN, 'send_to');
        }

	return $ERRNO{'OK'};
}
# }}}



# execute {{{
sub execute {
	my $self     = shift;
        my $conf     = $self->{plugins_options}{GroupConfig};
        my $ui       = $self->{plugins_options}{UI};
        my $verbose  = $self->{plugins_options}{verbose};
        my $keywords = $self->{plugins_options}{keywords};

	my $hostname = hostname();
	my $login = $self->{plugins_options}{login};
	my $group = $self->{plugins_options}{group};

	my $username = $self->{opts}{'username'};
	my $password = $self->{opts}{'password'};
	my $server   = $self->{opts}{'server'};
	my $send_to  = $self->{opts}{'send_to'};
	my $resource = 'AddUser-NG';

	my (@jids, $jid, $body, $msg);

	my $client = new Net::Jabber::Client();

	# connection
	$client->Connect(hostname => $server);

	# jabber message

	if ($client->Connected()) {
	    $ui->display("NotifyJabber VERBOSE", "We are connected to the server $server...") if $verbose;
	} else {
	    $ui->display_error("NotifyJabber ERROR", "Failed to connect to server: $server");
	    # as this plugin is not important, we don't care that there was an
	    # error here, we have to return OK so that the rollback wan't be
	    # called
	    return $ERRNO{'OK'};
	}

	my @result = $client->AuthSend(
				    username => $username,
				    password => $password,
				    resource => $resource
				);

	if ($result[0] ne "ok") {
	    $ui->display_error("NotifyJabber ERROR", "Authorization failed: $result[0] - $result[1]");
	    # as this plugin is not important, we don't care that there was an
	    # error here, we have to return OK so that the rollback wan't be
	    # called
	    return $ERRNO{'OK'};
	} else {
	    $ui->display("NotifyJabber VERBOSE", "We are authorized on server $server...") if $verbose;
	}

	$send_to =~ s/\s+//g;
	@jids = split(/\,/, $send_to);

	foreach $jid (@jids) {
	    
	    $ui->display("NotifyJabber VERBOSE", "Sending message to $jid") if $verbose;
	    $msg = new Net::Jabber::Message();

	    $body = "Successfuly added new user:\n\n\t+ login: $login\n\t+ group: $group\n\t+ host: $hostname";
	    $body .= "\n\n-- \n";
	    $body .= 'NotifyJabber for AddUser-NG, version: 1.4';
	    $body .= "\nCopyright (C) 2003 by AddUser-NG Development Team\n";

	    $msg->SetMessage(to => $jid, subject => 'New user has been added', body => $body );
	
	    $client->Send($msg);
	    # without waiting, not all messages would be send (depends on how fast is
	    # the maschene) so, it's a good idea to wait at least for a second
	    $client->Process(1);
	}

	$client->Disconnect();

	return $ERRNO{'OK'};
}
# }}}



# rollback {{{
sub rollback {
	#my $self    = shift;
	#my $conf    = $self->{plugins_options}{GroupConfig};
	#my $ui      = $self->{plugins_options}{UI};
	#my $verbose = $self->{plugins_options}{verbose};
    
	#
	# nothing to do here..
	#

	return $ERRNO{'OK'};
}
# }}}



# check_jid {{{
sub check_jid
{
    my $string = shift;
    
    $string =~ s/\s+//g;

    my (@jids) = split(/\,/, $string);

    foreach my $jid (@jids) {
	return 1 if ($jid !~ /(([a-zA-Z0-9-]+)\@([a-zA-Z0-9-]+)(\.[a-zA-Z0-9-]+)+)/);
    }

    return 0;
}

# }}}

1;

