; Documentation for the ACL2 Theorem Prover
; WARNING: GENERATED FILE, DO NOT HAND EDIT!
; The contents of this file are derived from ACL2 Community Book
; books/system/acl2-doc.lisp.

; ACL2 Version 6.4 -- A Computational Logic for Applicative Common Lisp
; Copyright (C) 2014, Regents of the University of Texas

; This version of ACL2 is a descendent of ACL2 Version 1.9, Copyright
; (C) 1997 Computational Logic, Inc.  See the documentation topic NOTE-2-0.

; This program is free software; you can redistribute it and/or modify
; it under the terms of the LICENSE file distributed with ACL2.

; This program is distributed in the hope that it will be useful,
; but WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
; LICENSE for more details.

; Here are the original authors of books/system/acl2-doc.lisp.
; Additional contributions may have been made to that file by members
; of the ACL2 community.

; Written by:  Matt Kaufmann               and J Strother Moore
; email:       Kaufmann@cs.utexas.edu      and Moore@cs.utexas.edu
; Department of Computer Science
; University of Texas at Austin
; Austin, TX 78701 U.S.A.

; WARNING: This file is generated from ACL2 Community Book
; books/system/acl2-doc.lisp.  To edit ACL2 documentation modify that
; file, not this one!  Instructions are just above the in-package form
; in that book.

(in-package "ACL2")

(defconst *acl2-system-documentation* '
((&ALLOW-OTHER-KEYS (POINTERS)
                    "See [macro-args].")
 (&BODY (POINTERS) "See [macro-args].")
 (&KEY (POINTERS) "See [macro-args].")
 (&OPTIONAL (POINTERS)
            "See [macro-args].")
 (&REST (POINTERS) "See [macro-args].")
 (&WHOLE (POINTERS) "See [macro-args].")
 (*
  (ACL2-BUILT-INS)
  "Multiplication macro

  * is really a macro that expands to calls of the function [binary-*].
  So for example

    (* x y 4 z)

  represents the same term as

    (binary-* x (binary-* y (binary-* 4 z))).

  See [binary-*].

  * is a Common Lisp function. See any Common Lisp documentation for
  more information.")
 (*STANDARD-CI*
  (IO)
  "An ACL2 character-based analogue of CLTL's *standard-input*

  The value of the ACL2 constant *standard-ci* is an open character
  input channel that is synonymous to Common Lisp's *standard-input*.

  ACL2 character input from *standard-ci* is actually obtained by
  reading [characters] from the stream named by Common Lisp's
  *standard-input*. That is, by changing the setting of
  *standard-input* in raw Common Lisp you can change the source from
  which ACL2 reads on the channel *standard-ci*. See [*standard-co*].")
 (*STANDARD-CO*
  (IO)
  "The ACL2 analogue of CLTL's *standard-output*

  The value of the ACL2 constant *standard-co* is an open character
  output channel that is synonymous to Common Lisp's
  *standard-output*.

  ACL2 character output to *standard-co* will go to the stream named by
  Common Lisp's *standard-output*. That is, by changing the setting
  of *standard-output* in raw Common Lisp you can change the actual
  destination of ACL2 output on the channel named by *standard-co*.
  Observe that this happens without changing the logical value of
  *standard-co* (which is some channel symbol). Changing the setting
  of *standard-output* in raw Common Lisp essentially just changes
  the map that relates ACL2 to the physical world of terminals,
  files, etc.

  To see the value of this observation, consider the following. Suppose
  you write an ACL2 function which does character output to the
  constant channel *standard-co*. During testing you see that the
  output actually goes to your terminal. Can you use the function to
  output to a file? Yes, if you are willing to do a little work in
  raw Common Lisp: open a stream to the file in question, set
  *standard-output* to that stream, call your ACL2 function, and then
  close the stream and restore *standard-output* to its nominal
  value. Similar observations can be made about the two ACL2 input
  channels, [*standard-oi*] and [*standard-ci*], which are analogues
  of *standard-input*.

  Another reason you might have for wanting to change the actual
  streams associated with [*standard-oi*] and *standard-co* is to
  drive the ACL2 top-level loop, [ld], on alternative input and
  output streams. This end can be accomplished easily within ACL2 by
  either calling [ld] on the desired channels or file names or by
  resetting the ACL2 [state] global variables '[standard-oi] and
  '[standard-co] which are used by [ld]. See [standard-oi] and see
  [standard-co].")
 (*STANDARD-OI*
  (IO)
  "An ACL2 object-based analogue of CLTL's *standard-input*

  The value of the ACL2 constant *standard-oi* is an open object input
  channel that is synonymous to Common Lisp's *standard-input*.

  ACL2 object input from *standard-oi* is actually obtained by reading
  from the stream named by Common Lisp's *standard-input*. That is,
  by changing the setting of *standard-input* in raw Common Lisp you
  can change the source from which ACL2 reads on the channel
  *standard-oi*. See [*standard-co*].")
 (*TERMINAL-MARKUP-TABLE*
  (LEGACY-DOCUMENTATION)
  "A [markup] table used for printing to the terminal

  The value of the ACL2 constant *terminal-markup-table* is an
  association list pairing [markup] keys with strings, to be used for
  printing to the terminal. See [markup] for a description of the
  ACL2 [markup] language.

  The entries in *terminal-markup-table* are of the form

    (key flag . fmt-string)

  where key is one of the [doc-string] tilde directives (see [markup]),
  flag is a Boolean as described below, and fmt-string is a string as
  expected by the ACL2 printing function [fmt]. The system arranges
  that for any arg, when an expression ~key[arg] is encountered by
  the [documentation] printer, [fmt] will print fmt-string in an
  association list, binding keys based on arg as follows.

    #\\p --- the `pointer'     ; only used if flag is t
    #\\s --- the print name version of the pointer, e.g., |abc| or ABC
    #\\c --- the parent file   ; only used if flag is t
    #\\t --- the displayed text
    #\\T --- uppercased displayed text

  The first three entries are used only when the flag associated with
  key is t, indicating that the argument arg of ~key is to be parsed
  as starting with a symbol; for example, ~key[foo bar] will bind #\\p
  to the symbol FOO.

  The discussion of the above association list for printing fmt-string
  applies when printing [documentation] to other than the terminal as
  well. Such tools exist for Texinfo and for HTML; see files
  doc/write-acl2-html.lisp and doc/write-acl2-texinfo.lisp
  distributed with ACL2.")
 (+
  (ACL2-BUILT-INS)
  "Addition macro

  + is really a macro that expands to calls of the function [binary-+].
  So for example

    (+ x y 4 z)

  represents the same term as

    (binary-+ x (binary-+ y (binary-+ 4 z))).

  See [binary-+].

  Macro: <+>

    (defmacro + (&rest rst)
              (if rst
                  (if (cdr rst)
                      (xxxjoin 'binary-+ rst)
                      (cons 'binary-+
                            (cons 0 (cons (car rst) nil))))
                  0))")
 (-
  (ACL2-BUILT-INS)
  "Macro for subtraction and negation

  See [binary-+] for addition and see [unary--] for negation.

  Note that - represents subtraction as follows:

    (- x y)

  represents the same term as

    (+ x (- y))

  which is really

    (binary-+ x (unary-- y)).

  Also note that - represents arithmetic negation as follows:

    (- x)

  expands to

    (unary-- x).

  Macro: <->

    (defmacro
         - (x &optional (y 'nil binary-casep))
         (if binary-casep
             (let ((y (if (and (consp y)
                               (eq (car y) 'quote)
                               (consp (cdr y))
                               (acl2-numberp (car (cdr y)))
                               (eq (cdr (cdr y)) nil))
                          (car (cdr y))
                          y)))
                  (if (acl2-numberp y)
                      (cons 'binary-+
                            (cons (unary-- y) (cons x nil)))
                      (cons 'binary-+
                            (cons x
                                  (cons (cons 'unary-- (cons y nil))
                                        nil)))))
             (let ((x (if (and (consp x)
                               (eq (car x) 'quote)
                               (consp (cdr x))
                               (acl2-numberp (car (cdr x)))
                               (eq (cdr (cdr x)) nil))
                          (car (cdr x))
                          x)))
                  (if (acl2-numberp x)
                      (unary-- x)
                      (cons 'unary-- (cons x nil))))))")
 (/
  (ACL2-BUILT-INS)
  "Macro for division and reciprocal

  See [binary-*] for multiplication and see [unary-/] for reciprocal.

  Note that / represents division as follows:

    (/ x y)

  represents the same term as

    (* x (/ y))

  which is really

    (binary-* x (unary-/ y)).

  Also note that / represents reciprocal as follows:

    (/ x)

  expands to

    (unary-/ x).

  / is a Common Lisp macro. See any Common Lisp documentation for more
  information.

  Macro: </>

    (defmacro / (x &optional (y 'nil binary-casep))
              (cond (binary-casep (list 'binary-* x (list 'unary-/ y)))
                    (t (list 'unary-/ x))))")
 (/=
  (ACL2-BUILT-INS)
  "Test inequality of two numbers

  (/= x y) is logically equivalent to (not (equal x y)).

  Unlike [equal], /= has a [guard] requiring both of its arguments to
  be numbers. Generally, /= is executed more efficiently than a
  combination of [not] and [equal].

  For a discussion of the various ways to test against 0, See
  [zero-test-idioms].

  /= is a Common Lisp function. See any Common Lisp documentation for
  more information.

  Function: </=>

    (defun /= (x y)
           (declare (xargs :guard (and (acl2-numberp x)
                                       (acl2-numberp y))))
           (not (equal x y)))")
 (1+
  (ACL2-BUILT-INS)
  "Increment by 1

  (1+ x) is the same as (+ 1 x). See [+].

  1+ is a Common Lisp function. See any Common Lisp documentation for
  more information.

  Macro: <1+>

    (defmacro 1+ (x) (list '+ 1 x))")
 (1-
  (ACL2-BUILT-INS)
  "Decrement by 1

  (1- x) is the same as (- x 1). See [-].

  1- is a Common Lisp function. See any Common Lisp documentation for
  more information.

  Macro: <1->

    (defmacro 1- (x) (list '- x 1))")
 (<
  (ACL2-BUILT-INS)
  "Less-than

  Completion Axiom (completion-of-<):

    (equal (< x y)
           (if (and (rationalp x)
                    (rationalp y))
               (< x y)
             (let ((x1 (if (acl2-numberp x) x 0))
                   (y1 (if (acl2-numberp y) y 0)))
               (or (< (realpart x1) (realpart y1))
                   (and (equal (realpart x1) (realpart y1))
                        (< (imagpart x1) (imagpart y1)))))))

  [Guard] for (< x y):

    (and (rationalp x) (rationalp y))

  Notice that like all arithmetic functions, < treats non-numeric
  inputs as 0.

  This function has the usual meaning on the rational numbers, but is
  extended to the complex rational numbers using the lexicographic
  order: first the real parts are compared, and if they are equal,
  then the imaginary parts are compared.")
 (<=
  (ACL2-BUILT-INS)
  "Less-than-or-equal test

  <= is a macro, and (<= x y) expands to the same thing as (not (< y
  x)). See [<].

  <= is a Common Lisp function. See any Common Lisp documentation for
  more information.

  Macro: <<=>

    (defmacro <= (x y) (list 'not (list '< y x)))")
 (=
  (ACL2-BUILT-INS)
  "Test equality of two numbers

  (= x y) is logically equivalent to (equal x y).

  Unlike [equal], = has a [guard] requiring both of its arguments to be
  numbers. Generally, = is executed more efficiently than [equal].

  For a discussion of the various ways to test against 0, See
  [zero-test-idioms].

  = is a Common Lisp function. See any Common Lisp documentation for
  more information.

  Function: <=>

    (defun = (x y)
           (declare (xargs :guard (and (acl2-numberp x)
                                       (acl2-numberp y))))
           (equal x y))")
 (>
  (ACL2-BUILT-INS)
  "Greater-than test

  > is a macro, and (> x y) expands to the same thing as (< y x). See
  [<].

  > is a Common Lisp function. See any Common Lisp documentation for
  more information.

  Macro: <>>

    (defmacro > (x y) (list '< y x))")
 (>=
  (ACL2-BUILT-INS)
  "Greater-than-or-equal test

  >= is a macro, and (>= x y) expands to the same thing as (not (< x
  y)). See [<].

  >= is a Common Lisp function. See any Common Lisp documentation for
  more information.

  Macro: <>=>

    (defmacro >= (x y) (list 'not (list '< x y)))")
 (@
  (ACL2-BUILT-INS)
  "Get the value of a global variable in [state]

    Examples:
    (+ (@ y) 1)
    (assign a (aset1 'ascii-map-array (@ a) 66 'Upper-case-B))

    General Form:
    (@ symbol)

  where symbol is any symbol to which you have [assign]ed a global
  value. This macro expands into (f-get-global 'symbol state), which
  retrieves the stored value of the symbol.

  The macro f-get-global is closely related to [@]: (@ var)
  macroexpands to (f-get-global 'var state).

  The macro [assign] makes it convenient to set the value of a symbol.
  The :[ubt] operation has no effect on the global-table of [state].
  Thus, you may use these globals to hang onto useful data structures
  even though you may undo back past where you computed and saved
  them.")
 (A!
  (LD)
  "To return to the top-level of ACL2's command loop

  When (a!) is evaluated inside of ACL2's command loop, the current
  computation is aborted and control returns to the top of the
  command loop, exactly as though the user had interrupted and
  aborted the current computation. (Note: Versions of ACL2 up to
  Version_3.4 provided `#.' for this purpose, but no longer; see
  [sharp-dot-reader].)

  If you are at an ACL2 prompt (as opposed to a raw Lisp break), then
  you may type :a! in place of (a!); see [keyword-commands].

  For a related feature that only pops up one level, see [p!].

  Logically speaking, (a!) = nil. But imagine that it is defined in
  such a way that it causes a stack overflow or other resource
  exhaustion when called.")
 (ABORT!
  (LD)
  "To return to the top-level of ACL2's command loop

  This is an alias for a!; see [a!]. For a related feature that only
  pops up one level, see [p!].")
 (ABOUT-ACL2
  (ACL2)
  "General information About ACL2

  This is ACL2 Version 6.4, [copyright] (C) 2014, Regents of the
  University of Texas, authored by Matt Kaufmann and J Strother
  Moore.

  See the ACL2 home page for additional information including
  tutorials, installation instructions, mailing lists, related
  publications, ACL2 workshops and seminars, acknowledgements, and
  other ACL2 releases.

  See [documentation] for how to access the ACL2 User's Manual.

  For statistics on ACL2 code size, see file doc/acl2-code-size.txt.


Subtopics

  [Acknowledgments]
      Some contributors to the well-being of ACL2

  [ACL2-help]
      The acl2-help mailing list

  [Bibliography]
      Reports about ACL2

  [Common-lisp]
      Relation to Common Lisp, including deviations from the spec

  [Copyright]
      ACL2 copyright, license, sponsorship

  [Version]
      ACL2 Version Number")
 (ABOUT_MODELS
  (PAGES_WRITTEN_ESPECIALLY_FOR_THE_TOURS)
  "About Models

  [{IMAGE}]

  ACL2 is used to construct mathematical models of computer hardware
  and software (i.e., ``digital systems'').

  {IMAGE}

  A mathematical model is a set of mathematical formulas used to
  predict the behavior of some artifact.

  The use of mathematical models allows faster and cheaper delivery of
  better systems.

  Models need not be complete or perfectly accurate to be useful to the
  trained engineer.

  Click [here] for more discussion of these assertions in an
  engineering context.

  [{IMAGE}]")
 (ABOUT_THE_ACL2_HOME_PAGE
  (PAGES_WRITTEN_ESPECIALLY_FOR_THE_TOURS)
  "About the ACL2 Home Page

  [{IMAGE}]

  The ACL2 Home Page is integrated into the ACL2 online documentation.
  Over 4 megabytes of hypertext is available here.

  The vast majority of the text is user-level documentation. For
  example, to find out about [rewrite] [{ICON}] rules you could click
  on the link. (If you do that, remember to use your browser's Back
  Button to come back here.)

  The tiny warning signs [{ICON}] mark links that lead out of the
  introductory-level material and into the user documentation. We
  advise against following such links upon your first reading of the
  documentation.

  At the end of the tours you will have a chance to revisit them
  quickly to explore alternative paths more fully.

  Finally, every page contains two icons at the bottom. The ACL2 icon
  leads you back to the ACL2 Home Page. The Index icon allows you to
  browse an alphabetical listing of all the topics in ACL2's online
  documentation. But both icons take you off the main route of the
  tour.

  [{IMAGE}]")
 (ABOUT_THE_ADMISSION_OF_RECURSIVE_DEFINITIONS
  (PAGES_WRITTEN_ESPECIALLY_FOR_THE_TOURS)
  "About the Admission of Recursive Definitions

  You can't just add any formula as an axiom or definition and expect
  the logic to stay sound! For example, if we were permitted to
  define (APP X Y) so that it was equal to (NOT (APP X Y)) then we
  could prove anything. The purported ``definition'' of APP must have
  several properties to be admitted to the logic as a new axiom.

  The key property a recursive definition must have is that the
  recursion terminate. This, along with some syntactic criteria,
  ensures us that there exists a function satisfying the definition.

  Termination must be proved before the definition is admitted. This is
  done in general by finding a measure of the arguments of the
  function and a well-founded relation such that the arguments ``get
  smaller'' every time a recursive branch is taken.

  For app the measure is the ``size'' of the first argument, x, as
  determined by the primitive function [ACL2-count] [{ICON}]. The
  well-founded relation used in this example is [o-p] [{ICON}], which
  is the standard ordering on the ordinals less than ``epsilon
  naught.'' These particular choices for app were made
  ``automatically'' by ACL2. But they are in fact determined by
  various ``default'' settings. The user of ACL2 can change the
  defaults or specify a ``hint'' to the [defun] [{ICON}] command to
  specify the measure and relation.

  You should now return to [the Walking Tour].")
 (ABOUT_THE_PROMPT
  (PAGES_WRITTEN_ESPECIALLY_FOR_THE_TOURS)
  "About the Prompt

  The string ``ACL2 !>'' is the ACL2 prompt.

  The prompt tells the user that an ACL2 [command] [{ICON}]is expected.
  In addition, the prompt tells us a little about the current state
  of the ACL2 command interpreter. We explain the prompt briefly
  below. But first we talk about the command interpreter.

  An ACL2 command is generally a Lisp expression to be evaluated. There
  are some unusual commands (such as :[q] [{ICON}] for quitting ACL2)
  which cause other behavior. But most commands are read, evaluated,
  and then have their results printed. Thus, we call the command
  interpreter a ``read-eval-print loop.'' The ACL2 command
  interpreter is named [ld] [{ICON}] (after Lisp's ``load'').

  When a command is read, all the symbols in it are converted to
  uppercase. Thus, typing (defun app ...) is the same as typing
  (DEFUN APP ...) or (defun App ...). There are ways to force
  lowercase case characters into symbols but we won't discuss them
  here. A consequence of Common Lisp's default uppercasing is that
  you'll see a general lack of concern over the case used when
  symbols are displayed in this documentation.

  In addition, symbols ``belong'' to ``packages'' which give the user a
  way to control namespaces. The prompt tells us which package is the
  default one, namely \"ACL2\". That means when we call car, for
  example, we are invoking the standard definition of that symbol. If
  the packager were \"JONES\" then car would refer to the definition of
  that symbol in that package (which may or may not be different
  depending on what symbols were imported into that package.

  A command like (defun app (x y) ...) causes ACL2 to evaluate the
  [defun] [{ICON}] function on app, (x y) and .... When that command
  is evaluated it prints some information to the terminal explaining
  the processing of the proposed definition. It returns the symbol
  APP as its value, which is printed by the command interpreter.
  (Actually, defun is not a function but a [macro] [{ICON}] which
  expands to a form that involves [state] [{ICON}], a necessary
  precondition to printing output to the terminal and to ``changing''
  the set of axioms. But we do not discuss this further here.)

  The defun command is an example of a special kind of command called
  an ``event.'' [Events] [{ICON}] are those commands that change the
  ``logical world'' by adding such things as axioms or theorems to
  ACL2's database. See [world] [{ICON}]. But not every command is an
  event command.

  A command like (app '(1 2 3) '(4 5 6 7)) is an example of a
  non-event. It is processed the same general way: the function app
  is applied to the indicated arguments and the result is printed.
  The function app does not print anything and does not change the
  ``world.''

  A third kind of command is one that display information about the
  current logical world or that ``roll back'' to previous versions of
  the world. Such commands are called ``[history]'' [{ICON}]
  commands.

  What does the ACL2 prompt tell us about the read-eval-print loop? The
  prompt ``ACL2 !>'' tells us that the command will be read with
  [current-package] [{ICON}] set to \"ACL2\", that guard checking (see
  [set-guard-checking] [{ICON}]) is on (``!''), and that we are at
  the top-level (there is only one ``>''). For more about the prompt,
  see [default-print-prompt] [{ICON}].

  You should now return to [the Walking Tour].")
 (ABOUT_TYPES
  (PAGES_WRITTEN_ESPECIALLY_FOR_THE_TOURS)
  "About Types

  The universe of ACL2 objects includes objects of many different
  types. For example, t is a ``symbol'' and 3 is an ``integer.''
  Roughly speaking the objects of ACL2 can be partitioned into the
  following types:

     [Numbers] 3, -22/7, #c(3
    5/2) [Characters] #\\A, #\\a,
    #\\Space [Strings] \"This is a
    string.\" [Symbols] 'abc,
    'smith::abc [Conses (or
    Ordered Pairs)] '((a . 1) (b . 2))

  When proving theorems it is important to know the types of object
  returned by a term. ACL2 uses a complicated heuristic algorithm,
  called [type-set] [{ICON}], to determine what types of objects a
  term may produce. The user can more or less program the type-set
  algorithm by proving [type-prescription] [{ICON}] rules.

  ACL2 is an ``untyped'' logic in the sense that the syntax is not
  typed: It is legal to apply a function symbol of n arguments to any
  n terms, regardless of the types of the argument terms. Thus, it is
  permitted to write such odd expressions as (+ t 3) which sums the
  symbol t and the integer 3. Common Lisp does not prohibit such
  expressions. We like untyped languages because they are simple to
  describe, though proving theorems about them can be awkward
  because, unless one is careful in the way one defines or states
  things, unusual cases (like (+ t 3)) can arise.

  To make theorem proving easier in ACL2, the axioms actually define a
  value for such terms. The value of (+ t 3) is 3; under the ACL2
  axioms, non-numeric arguments to + are treated as though they were
  0.

  You might immediately wonder about our claim that ACL2 is Common
  Lisp, since (+ t 3) is ``an error'' (and will sometimes even
  ``signal an error'') in Common Lisp. It is to handle this problem
  that ACL2 has guards. We will discuss guards later in the Walking
  Tour. However, many new users simply ignore the issue of guards
  entirely and that is what we recommend for now.

  You should now return to [the Walking Tour].")
 (ABS
  (ACL2-BUILT-INS)
  "The absolute value of a real number

  (Abs x) is -x if x is negative and is x otherwise.

  The [guard] for abs requires its argument to be a rational ([real],
  in ACL2(r)) number.

  Abs is a Common Lisp function. See any Common Lisp documentation for
  more information.

  From ``Common Lisp the Language'' page 205, we must not allow complex
  x as an argument to abs in ACL2, because if we did we would have to
  return a number that might be a floating point number and hence not
  an ACL2 object.

  Function: <abs>

    (defun abs (x)
           (declare (xargs :guard (real/rationalp x)))
           (if (minusp x) (- x) x))")
 (ACCUMULATED-PERSISTENCE
  (DEBUGGING)
  "To get statistics on which [rune]s are being tried

    Useful Forms:
    (accumulated-persistence t)              ; Activate statistics gathering.
    (accumulated-persistence :all)           ; As above, ``enhanced'' (see below)

    (show-accumulated-persistence :frames)   ; Display statistics ordered by
    (show-accumulated-persistence :tries)    ; frames built, times tried,
    (show-accumulated-persistence :ratio)    ; or their ratio.

    (accumulated-persistence nil)            ; Deactivate.

    Advanced forms:
    (show-accumulated-persistence :frames-s) ; The `s', `f', and `a' suffixes
    (show-accumulated-persistence :frames-f) ; stand for `success' (`useful'),
    (show-accumulated-persistence :frames-a) ; `failure' (`useless'), and `all',
    (show-accumulated-persistence :tries-s)  ; respectively.  The only effect of
    (show-accumulated-persistence :tries-f)  ; the `s' and `f' versions is to
    (show-accumulated-persistence :tries-a)  ; sort first by useful or useless
                                             ; applications, respectively (see
                                             ; below).  The `a' versions avoid
                                             ; showing the useful/useless
                                             ; breakdown.

    (show-accumulated-persistence :runes)    ; Just show runes alphabetically.

  Note: set-accumulated-persistence is equivalent to
  accumulated-persistence.

  See the end of this item for a discussion of ``enhanced statistics
  gathering,'' which can be useful for more fine-grained proof
  debugging.

  Generally speaking, the more ACL2 knows, the slower it runs. That is
  because the search space grows with the number of alternative
  rules. Often, the system tries to apply rules that you have
  forgotten were even there, if you knew about them in the first
  place! ``Accumulated-persistence'' is a statistic (originally
  developed for Nqthm) that helps you identify the rules that are
  causing ACL2's search space to explode.

  For other proof debugging utilities, see [break-rewrite] and see
  [dmr].

  Accumulated persistence tracking can be turned on or off. It is
  generally off. When on, proofs may take perhaps 50% more time than
  otherwise! But some useful numbers are collected. When it is turned
  on, by

    ACL2 !>(accumulated-persistence t)

  an accumulation site is initialized and henceforth data about which
  rules are being tried is accumulated into that site. That
  accumulated data can be displayed with
  show-accumulated-persistence, as described in detail below. When
  accumulated persistence is turned off, with
  (accumulated-persistence nil), the accumulation site is wiped out
  and the data in it is lost.

  The ``accumulated persistence'' of a [rune] is the number of [rune]s
  the system has attempted to apply (since accumulated persistence
  was last activated) while the given [rune] was being tried.

  Consider a :[rewrite] rule named [rune]. For simplicity, let us
  imagine that [rune] is tried only once in the period during which
  accumulated persistence is being monitored. Recall that to apply a
  rewrite rule we must match the left-hand side of the conclusion to
  some term we are trying to rewrite, establish the hypotheses of
  [rune] by rewriting, and, if successful, then rewrite the
  right-hand side of the conclusion. We say [rune] is ``being tried''
  from the time we have matched its left-hand side to the time we
  have either abandoned the attempt or finished rewriting its
  right-hand side. (By ``match'' we mean to include any loop-stopper
  requirement; see [loop-stopper].) During that period of time other
  rules might be tried, e.g., to establish the hypotheses. The rules
  tried while [rune] is being tried are ``billed'' to [rune] in the
  sense that they are being considered here only because of the
  demands of [rune]. Thus, if no other rules are tried during that
  period, the accumulated persistence of [rune] is 1 --- we ``bill''
  [rune] once for its own application attempt. If, on the other hand,
  we tried 10 rules on behalf of that application of [rune], then
  [rune]'s accumulated persistence would be 11.

  One way to envision accumulated persistence is to imagine that every
  time a [rune] is tried it is pushed onto a stack. The rules tried
  on behalf of a given application of a [rune] are thus pushed and
  popped on the stack above that [rune]. A lot of work might be done
  on its behalf --- the stack above the [rune] grows and shrinks
  repeatedly as the search continues for a way to use the [rune]. All
  the while, the [rune] itself ``persists'' in the stack, until we
  finish with the attempt to apply it, at which time we pop it off.
  The accumulated persistence of a [rune] application is thus the
  number of stack frames built while that [rune] was on the stack.

  Note that accumulated persistence is tallied whether or not the
  attempt to apply a [rune] is successful. Each of the rules tried on
  its behalf might have failed and the attempt to apply the [rune]
  might have also failed. The ACL2 proof script would make no mention
  of the [rune] or the rules tried on its behalf because they did not
  contribute to the proof. But time was spent pursuing the possible
  application of the [rune] and accumulated persistence is a measure
  of that time.

  A high accumulated persistence might come about in two extreme ways.
  One is that the rule causes a great deal of work every time it is
  tried. The other is that the rule is ``cheap'' but is tried very
  often. We therefore keep track of the number of times each rule is
  tried as well as its persistence. The ratio between the two is the
  average amount of work done on behalf of the rule each time it is
  tried.

  When the accumulated persistence totals are displayed by the function
  show-accumulated-persistence we sort them so that the most
  expensive [rune]s are shown first. We can sort according to one of
  three basic keys:

    :frames - the number of frames built on behalf of the rune
    :tries  - the number of times the rune was tried
    :ratio  - frames built per try

  The key simply determines the order in which the information is
  presented. If no argument is supplied to
  show-accumulated-persistence, :frames is used.

  The display breaks each total into ``useful'' and ``useless''
  subtotals. A ``useful'' rule try is one that is viewed as
  contributing to the progress of the proof, and the rest are
  ``useless'' rule applications. For example, if a :[rewrite] rule is
  tried but its hypotheses are not successfully relieved, then that
  rule application and all work done on behalf of those hypotheses is
  ``useless'' work. In general, an attempt to apply a [rune] is
  viewed as ``useful'' unless the attempt fails or the attempt is on
  the stack (as described above) for a [rune] application that
  ultimately fails. A large number of ``useless'' :frames or :tries
  along with correspondingly small ``useful'' counts may suggest
  [rune]s to consider disabling (see [disable] and see [in-theory]).
  Thus, here is a more complete list of the arguments that may be
  supplied to show-accumulated-persistence. Suffixes ``s'', ``f'',
  and ``a'' are intended to suggest ``success'' (``useful''),
  ``failure'' (``useless''), and ``all''.

    :frames     - sort by the number of frames built on behalf of the rune
       :frames-s -   as above, but sort by useful applications
       :frames-f -   as above, but sort by useless applications
       :frames-a -   as above, but inhibit display of ``useful'' and
                     ``useless'' subtotals
    :tries      - sort by the number of times the rune was tried
       :tries-s  -   as above, but sort by useful applications
       :tries-f  -   as above, but sort by useless applications
       :tries-a  -   as above, but inhibit display of ``useful'' and
                     ``useless'' subtotals
    :ratio      - sort by frames built per try
    :useless    - show only the runes tried whose tries were all ``useless''

  For a given line of the report, every frame credited to a ``useful''
  (respectively, ``useless'') rule application is considered
  ``useful'' (respectively, ``useless''). We illustrate with the
  following example.

    (progn
      (defstub hyp (x) t)
      (defstub concl (x) t)
      (defstub bad (x) t)
      (defstub good (x) t)
      (defaxiom good-ax
        (implies (good x) (hyp x)))
      (defaxiom bad-ax
        (implies (bad x) (hyp x)))
      (defaxiom hyp-implies-concl
        (implies (hyp x) (concl x)))
      )
    (accumulated-persistence t)
    (thm (implies (good x) (concl x)))
    (show-accumulated-persistence)

  To prove the [thm] form, ACL2 attempts to rewrite (concl x) to true
  by applying rule hyp-implies-concl. It then attempts to establish
  (hyp x) first by trying rule bad-ax, which fails, and second by
  trying rule good-ax, which succeeds. As expected, the report labels
  as ``useless'' the failure of the attempt to establish the
  hypothesis, (bad x).

    --------------------------------
          1        1 (    1.00) (:REWRITE BAD-AX)
          0        0    [useful]
          1        1    [useless]
    --------------------------------

  Now consider the top-level application of rule hyp-implies-concl.
  Even though the above report shows the application of bad-ax as
  ``useless'', note that this rule was applied on behalf of the
  successful (``useful'') application of hyp-implies-concl, and hence
  is incorporated into the ``useful'' line for hyp-implies-concl, as
  follows.

    --------------------------------
          3        1 (    3.00) (:REWRITE HYP-IMPLIES-CONCL)
          3        1    [useful]
          0        0    [useless]
    --------------------------------

  In summary: categorization of :frames as ``useful'' or ``useless'' is
  based on whether they support ``useful'' or ``useless'' :tries.

  Note that a [rune] with high accumulated persistence may not actually
  be the ``culprit.'' For example, suppose rune1 is reported to have
  a :ratio of 101, meaning that on the average a hundred and one
  frames were built each time rune1 was tried. Suppose rune2 has a
  :ratio of 100. It could be that the attempt to apply rune1 resulted
  in the attempted application of rune2 and no other [rune]. Thus, in
  some sense, rune1 is ``cheap'' and rune2 is the ``culprit'' even
  though it costs less than rune1.

  If a proof is aborted, then in general,
  [show-accumulated-persistence] will only display totals for runes
  whose attempted application is complete: that is, if the rewriter
  was in the process of relieving hypotheses for a rule, then
  information for that rule will not be included in the tally. We say
  ``in general'' because, as indicated near the top of the output
  from [show-accumulated-persistence] when such incomplete
  information is omitted, you can get this information by using
  argument :frames-a or :tries-a.

  There are other subtleties in how rune applications are tallied,
  documented elsewhere: see [accumulated-persistence-subtleties].

  We conclude with a discussion of ``enhanced'' statistics gathering,
  which is enabled by supplying accumulated-persistence the argument
  :ALL:

    (accumulated-persistence :all)

  At some additional performance expense (but probably well under a
  factor of 2 altogether), ACL2 then gathers additional statistics
  for individual hypotheses of rules as well as their conclusions. To
  understand how this works, suppose rn is a [rune]. Then we prepend
  the keyword :CONC to rn to form what we call its ``conclusion
  xrune'', and for its I-th hypothesis we prepend :HYP I to rn to
  form its I-th ``hypothesis xrune.'' Here, ``xrune'' is pronounced
  ``ex rune'', and is mnemonic for ``extended rune.'' For example, if
  (REWRITE FOO) is a [rune] then (:CONC REWRITE FOO) is its
  conclusion xrune, and (:HYP 2 REWRITE FOO) is a hypothesis xrune
  corresponding to the second hypothesis of the corresponding rewrite
  rule.

  With (accumulated-persistence :all), we instruct ACL2 to track not
  only runes but also xrunes. Then, (show-accumulated-persistence)
  will display information for all xrunes in a format that we
  consider to be ``raw'', in the sense that data for xrunes are
  displayed just as for runes. But a ``merged'' format is also
  available. Here is a summary of display commands, followed below by
  further discussion.

    (show-accumulated-persistence :frames t) ; t is optional, i.e., the default
       ; Display enhanced statistics sorted by frames, in a ``raw'' format.
    (show-accumulated-persistence :frames :merge)
       ; Display enhanced statistics sorted by frames, in a ``merged'' format.
    (show-accumulated-persistence :frames nil)
       ; Display regular statistics sorted by frames, without the enhancements.

    ; More generally, the descriptions just above apply for any legal first
    ; argument:

    (show-accumulated-persistence KEY t)
    (show-accumulated-persistence KEY :merge)
    (show-accumulated-persistence KEY nil)

    ; Note also these alternate forms, equivalent to the first of the two forms
    ; just above, i.e., the form with second argument of t:
    (show-accumulated-persistence KEY :raw)
    (show-accumulated-persistence KEY)

  There is a significant difference between how runes are tracked and
  how ACL2 tracks hypothesis and conclusion xrunes: unlike regular
  runes, these xrunes do not contribute to the accumulated :frames
  counts. Rather, they serve as accumulation sites without
  contributing their :tries to any accumulation. Consider for example
  the snippet below, taken from a report created with the :merge
  option (to be discussed further below), i.e., by evaluating the
  form (show-accumulated-persistence :frames :merge).

    :frames   :tries    :ratio  rune
    --------------------------------
        462      211 (    2.18) (:REWRITE PERM-MEM)
         13        6    [useful]
        449      205    [useless]
       .............................
        251       47 (    5.34) (:HYP 2 :REWRITE PERM-MEM)
          6        6    [useful]
        245       41    [useless]
       .............................
          0      211 (    0.00) (:HYP 1 :REWRITE PERM-MEM)
          0        6    [useful]
          0      205    [useless]
       .............................
          0        7 (    0.00) (:CONC :REWRITE PERM-MEM)
          0        6    [useful]
          0        1    [useless]
    --------------------------------

  Notice that while :tries are recorded for the xrune (:HYP 1 :REWRITE
  PERM-MEM), no :frames are recorded. This is because no stack frames
  were built for runes while this xrune was on the stack --- only for
  the xrune itself, which as we explained above is not accumulated
  into the total :frames counts. As it turns out, this lack of stack
  frames is explained by the fact that the rewrite rule PERM-MEM has
  a free variable in the first hypothesis.

    ACL2 !>:pe perm-mem
             18  (DEFTHM PERM-MEM
                         (IMPLIES (AND (PERM X Y) (MEM A X))
                                  (MEM A Y))
                         :RULE-CLASSES ((:REWRITE :MATCH-FREE :ONCE)))
    ACL2 !>

  The second hypothesis, however, does cause additional rewriting in
  order to rewrite it to true, resulting in 251 stack frames for
  runes. We see that the conclusion does not lead to creation of any
  rune stack frames, which might seem to suggest that only 251 stack
  frames for runes were created on behalf of this rule application
  --- yet, we see that 462 frames were actually created. The
  difference is the 211 frames created for the rewrite rule itself.
  Even if the total had been a bit more than 462, one need not be
  surprised, as there could be some work recorded during application
  of the rewrite rule, such as type-prescription reasoning, that is
  not done during rewriting of a hypothesis or the conclusion.

  Now suppose we have executed (accumulated-persistence :all) and
  attempted some proofs, and now we are ready to see statistics. The
  form (show-accumulated-persistence) displays statistics exactly as
  described above, treating these extra xrunes just as though they
  are runes; similarly for the form (show-accumulated-persistence
  KEY), for any legal KEY. A second optional argument may however be
  supplied to show-accumulated-persistence. The default for that
  second argument is t, and a second argument of :raw is treated the
  same as t; thus, these arguments provide the behavior just
  described, where data for xrunes are displayed just as for runes.
  You may restrict output to runes, ignoring hypothesis and
  conclusion xrunes, by giving a second argument of nil. (This gives
  the same behavior as if we had started with the command
  (accumulated-persistence t) instead of the command
  (accumulated-persistence :all).) Finally, you may give a second
  argument of :merge, in which case output will be sorted and
  displayed as though only runes were tracked (not the extra xrunes),
  but each data item for a non-rune xrune will be merged so that it
  is displayed in suitable order just below its corresponding rune,
  as in the PERM-MEM example displayed above.

  We close by mentioning two aspects of enhanced statistics display for
  :CONC xrunes that have potential to be confusing. First consider
  the following example.

      :frames   :tries    :ratio  rune
    --------------------------------
         14        4 (    3.50) (:REWRITE DEFAULT-+-2)
          0        0    [useful]
         14        4    [useless]
       .............................
         10        4 (    2.50) (:HYP 1 :REWRITE DEFAULT-+-2)
          0        0    [useful]
         10        4    [useless]
    --------------------------------

  It may be surprising that no data is displayed for the corresponding
  :CONC xrune. The explanation, however, is simple: the hypothesis
  never rewrote to true, so the conclusion was never rewritten. This
  is consistent with the marking as ``useless'' of all :frames and
  :tries for the rune and the hypothesis xrune. Note by the way, once
  again, that the hypothesis xrune does not contribute to any :frames
  count.

  Another reason not to see data displayed for a :CONC xrune is that if
  a rule has no hypotheses, then no such data is collected. This
  decision was made because in the case of no hypotheses, we expect
  it to be very rare that information for the :CONC xrune will add
  any useful insight.

  On a final note: (show-accumulated-persistence :runes) may be used
  simply to see a list of all [rune]s (or xrunes) displayed
  alphabetically.

  Users are encouraged to think about other meters we could install in
  ACL2 to help diagnose performance problems.


Subtopics

  [Accumulated-persistence-subtleties]
      Some subtle aspects of the counting done by
      [accumulated-persistence]

  [Dmr]
      Dynamically monitor rewrites and other prover activity")
 (ACCUMULATED-PERSISTENCE-SUBTLETIES
  (ACCUMULATED-PERSISTENCE)
  "Some subtle aspects of the counting done by [accumulated-persistence]

  In this topic we cover the overcounting of ``useful'' and of
  recursive [rune] application attempts, and we describe how
  ``useless'' [rune] application attempts can actually be critical
  for a proof's success.

  Overcounting of ``useful'' and of recursive rune application
  attempts. Not every [rune] application may be necessary for a
  proof's success. Consider for example:

    (thm (equal (car (cons a (cdr (cons b x))))
                a))

  Then show-accumulated-persistence will tell us that :[rewrite] rules
  car-cons and cdr-cons each had one useful application. However, the
  rule cdr-cons is used to simplify (cdr (cons b x)) to x, and this
  simplification is unecessary for the proof. Indeed, the proof
  succeeds even when preceded by the event: (in-theory (disable
  cdr-cons)). We thus see that a [rune] application labeled as
  ``useful'' may be simplifying a term that is not relevant to the
  proof.

  As of this writing, we consider every :[forward-chaining] rule
  application to be ``useful'', for simplicity of the implementation.
  Moreover, our counting of these rules is such that a single rule
  may be counted more than once.

  Next we show how recursive rule applications are overcounted.
  Consider the following example.

    (defun mem (a x)
      (if (atom x)
          nil
        (or (equal a (car x)) (mem a (cdr x)))))

  Now suppose we consider the sequence of theorems (mem a (list a)),
  (mem a (list 1 a)), (mem a (list 1 2 a)), (mem a (list 1 2 3 a)),
  and so on. We will see that the :frames reported for each increases
  quadratically, even though the :tries increases linearly; so in
  this case the :tries statistics are more appropriate. Each time the
  definition of mem is applied, a new stack frame is pushed (see
  [accumulated-persistence]), and all subsequent applications of that
  definition are accumulated into the :frames count for that stack
  frame. The final :frames count will be the sum of the counts for
  those individual frames, which form a linear sequence whose sum is
  therefore quadratic in the number of applications of the definition
  of mem.

  How ``useless'' attempts can be critical for a proof's success. The
  command (accumulated-persistence :useless)] will list rules that
  did not contribute directly to the proof (see
  [accumulated-persistence], in particular the discussion of
  ``useless'' there). However, a ``useless'' rule can on rare
  occasions be critical to the success of a proof. In the following
  example, we have a ``bad'' rule that can take the proof in the
  wrong direction, but a ``useless'' rule does a rewrite that
  prevents the succesful relieving of a hypothesis of the ``bad''
  rule. In summary:

    ; Assume p0.  We want to prove p1.

    ; Key rule:
    p0 -> p1 = t

    ; Bad rule that could ruin the proof:
    p3 -> p1 = p2

    ; But unfortunately, we know p3:
    p0 -> p3

    ; Important ``useless'' rule, preventing ``bad rule'' above from firing:
    p3 = p4

  The following event captures the rules described above.

    (encapsulate
     ((p0 (x) t)
      (p1 (x) t)
      (p2 (x) t)
      (p3 (x) t)
      (p4 (x) t))
     (local (defun p0 (x) x))
     (local (defun p1 (x) x))
     (local (defun p2 (x) x))
     (local (defun p3 (x) x))
     (local (defun p4 (x) x))

    ; Key rule:
     (defthm p0-implies-p1
       (implies (p0 x)
                (p1 x)))

    ; Bad rule that could ruin the proof:
     (defthm p3-implies-p1-is-p2
       (implies (p3 x)
                (equal (p1 x) (p2 x))))

    ; But unfortunately, we know p3:
     (defthm p0-implies-p3
       (implies (p0 x)
                (p3 x)))

    ; Important ``useless'' rule, preventing p3-implies-p1-is-p2 from firing:
     (defthm p3-is-p4
       (equal (p3 x) (p4 x))))

  Now we can see that p3-is-p4 is labeled as ``useless'', by evaluating
  these commands.

    (accumulated-persistence t)
    (thm (implies (p0 x) (p1 x)))
    (show-accumulated-persistence)

  If instead we first evaluate (in-theory (disable p3-is-p4)) before
  the thm above, then the proof fails, even though p3-is-p4 was
  labeled as ``useless''!

  Nevertheless, in general it is probably safe to disable rules
  reported as ``useless'' by (show-accumulated-persistence :useless),
  and doing so may speed up a proof considerably.

  Remark. The example above suggests a surprising fact: on rare
  occasions, a proof may fail when you give an :[in-theory] hint
  consisting of exactly the [rune]s reported in a proof that
  succeeds. For, imagine a rule R that is needed in part of the proof
  but is ``bad'' in a second part, and that some other, ``useless''
  rule prevents the application of R in that second part. The example
  above suggests that disabling this ``useless'' rule can allow the
  second application of R, thus preventing the proof.")
 (ACKNOWLEDGMENTS
  (ABOUT-ACL2)
  "Some contributors to the well-being of ACL2

  The development of ACL2 was initially made possible by funding from
  the U. S. Department of Defense, including ARPA and ONR. We thank
  all the organizations that have contributed support, including the
  following (in alphabetical order).

      o AMD, for providing significant time over several years for Matt
      Kaufmann to carry out ACL2 research, support, and development
      o Computational Logic, Inc. and its president, Don Good, where the
      first eight years of ACL2 development occurred
      o Centaur Technology
      o DARPA
      o Digital Equipment Corporation
      o EDS, which provided some time for Matt Kaufmann's ACL2 work
      1998-1999
      o ForrestHunt and, more generally, Warren A. Hunt, Jr. (see below)
      o IBM
      o NSF
      o ONR
      o Rockwell Collins
      o SRC
      o Sun Microsystems
      o University of Texas at Austin (in particular support to J Moore
      through the Admiral B. R. Inman Chair of Computing Theory)

  We are especially grateful to Warren A. Hunt, Jr. for his unrivaled
  efforts in securing support for the entire ACL2 research group at
  both Computational Logic, Inc., and the University of Texas at
  Austin. Without his efforts, we would have spent less time working
  on the system and fewer students would have been funded to apply
  it.

  ACL2 was started in August, 1989 by Boyer and Moore working together.
  They co-authored the first versions of axioms.lisp and basis.lisp,
  with Boyer taking the lead in the formalization of ``[state]'' and
  the most primitive [io] functions. Boyer also had a significant
  hand in the development of the early versions of the files
  interface-raw.lisp and translate.lisp. For several years, Moore
  alone was responsible for developing the ACL2 system code, though
  he consulted often with both Boyer and Kaufmann. In August, 1993,
  Kaufmann became jointly responsible with Moore for developing the
  system. Boyer has continued to provide valuable consulting on an
  informal basis.

  Bishop Brock was the heaviest early user of ACL2, and provided many
  suggestions for improvements. In particular, the :cases and
  :restrict [hints] were his idea; he developed an early version of
  congruence-based reasoning for Nqthm; and he helped in the
  development of some early [books] about arithmetic. In a
  demonstration of his courage and faith in us, he pushed for
  Computational Logic, Inc., to agree to the Motorola CAP contract --
  which required formalizing a commercial DSP in the untested ACL2 --
  and moved to Scottsdale, AZ, to do the work with the Motorola
  design team. His demonstration of ACL2's utility was an
  inspiration, even to those of us designing ACL2.

  John Cowles also helped in the development of some early [books]
  about arithmetic, and also provided valuable feedback and bug
  reports.

  Other early users of ACL2 at Computational Logic, Inc. helped
  influence its development. In particular, Warren Hunt helped with
  the port to Macintosh Common Lisp, and Art Flatau and Mike Smith
  provided useful general feedback.

  Mike Smith helped develop the Emacs portion of the implementation of
  proof trees.

  Bill Schelter made some enhancements to akcl (now gcl) that helped to
  enhance ACL2 performance in that Common Lisp implementation, and
  more generally, responded helpfully to our bug reports. Camm
  Maguire has since provided wonderful gcl support, and has created a
  Debian package for ACL2 built on GCL. We are also grateful to
  developers of other Common Lisp implementations.

  Kent Pitman helped in our interaction with the ANSI Common Lisp
  standardization committee, X3J13.

  John Cowles helped with the port to Windows (98) by answering
  questions and running tests.

  Ruben Gamboa created a modification of ACL2 to allow reasoning about
  the real numbers using non-standard analysis. His work has been
  incorporated into the ACL2 distribution; see [real].

  Rob Sumners has made numerous useful suggestions. In particular, he
  has designed and implemented improvements for [stobj]s and been key
  in our development of locally-bound stobjs; see [note-2-6].

  Robert Krug has designed and implemented many changes in the vicinity
  of the linear arithmetic package and its connection to type-set and
  rewrite. He was also instrumental in the development of
  [extended-metafunctions].

  Pete Manolios has made numerous useful suggestions. In particular,
  Pete helped us to organize the first workshop and was a wonderful
  equal partner with the two of us (Kaufmann and Moore) in producing
  the books that arose from that workshop. Pete and his student,
  Daron Vroon, provided the current implementation of [ordinals].

  Jared Davis and Sol Swords have our gratitude for starting the ACL2
  Books repository.

  We thank David L. Rager for contributing an initial version of the
  support for [parallelism] in an experimental extension of ACL2.

  Bob Boyer and Warren A. Hunt, Jr. developed a canonical
  representation for ACL2 data objects and a function memoization
  mechanism to facilitate reuse of previously computed results. We
  thank them for their extensive efforts for the corresponding
  experimental (as of 2008 and 2009) extension of ACL2; see
  [hons-and-memoization].

  We also thank the contributors to the ACL2 workshops for some
  suggested improvements and for the extensive collection of publicly
  distributed benchmark problems. And we thank participants at the
  ACL2 seminar at the University of Texas for useful feedback. More
  generally, we thank the ACL2 community for feedback, contributed
  [books] (see [community-books]), and their interest in the ACL2
  project.

  Regarding the documentation:

      Bill Young wrote significant portions of the original acl2-tutorial
      section of the ACL2 documentation, including what is now called
      [alternative-introduction]. This was an especially important
      task in the early years when there was no guide for how to use
      ACL2 and we are very grateful. He, Bishop Brock, Rich Cohen,
      and Noah Friedman read over considerable amounts of the
      documentation, and made many useful comments. Others,
      particularly Bill Bevier and John Cowles, have also made useful
      comments on the [documentation].

      Art Flatau helped develop the ACL2 [markup] language and translators
      from that language to Texinfo and HTML. Michael ``Bogo''
      Bogomolny created a search engine, beginning with Version 2.6,
      and for that purpose modified the HTML translator to create one
      file per topic (a good idea in any case).

      Laura Lawless provided many hours of help in marking up appropriate
      parts of the [documentation] in typewriter font.

      Noah Friedman developed an Emacs tool that helped us insert
      ``invisible links'' into the [documentation], which improve the
      usability of that documentation under HTML readers such as
      Mosaic.

      Richard Stallman contributed a texinfo patch, to be found in the file
      doc/texinfo.tex.")
 (ACL2
  NIL
  "ACL2 documentation (system only, not including the community books)

  This is the ACL2 documentation. For an \"acl2+books\" combined manual
  that includes both the ACL2 documentation and the ACL2 community
  books, see
  http://www.cs.utexas.edu/users/moore/acl2/v6-4/combined-manual/index.html.


Subtopics

  [About-ACL2]
      General information About ACL2

  [ACL2-tutorial]
      Tutorial introduction to ACL2

  [Bdd]
      Ordered binary decision diagrams with rewriting

  [Books]
      Books are files of ACL2 [events]---they are the main way to split up
      large ACL2 developments into separate modules.

  [Debugging]
      Tools for debugging failed or slow proofs, or misbehaving functions.

  [Documentation]
      ACL2 system (and books) documentation

  [Events]
      Functions that extend the logic

  [History]
      Functions that display or change history

  [Hons-and-memoization]
      Hash cons, function memoization, and applicative hash tables

  [Interfacing-tools]
      Libraries and tools for doing basic [file i/o], using raw [Common
      Lisp libraries], working with the [operating system], and
      interfacing with [other programs].

  [Macros]
      Macros allow you to extend the syntax of ACL2.

  [Miscellaneous]
      A miscellany of documented functions and concepts (often cited in
      more accessible [documentation])

  [Other]
      Other commonly used top-level functions

  [Parallelism]
      Experimental extension for parallel execution and proofs

  [Programming]
      Programming in ACL2

  [Proof-checker]
      An interactive tool for controlling ACL2's proof processes.

  [Real]
      ACL2(r) support for real numbers

  [Release-notes]
      Pointers to what has changed

  [Rule-classes]
      Adding rules to the database

  [Switches-parameters-and-modes]
      A variety of ways to modify the ACL2 environment

  [Theories]
      Sets of [rune]s to [enable]/[disable] in concert")
 (ACL2-AS-STANDALONE-PROGRAM
  (ACL2-TUTORIAL)
  "Calling ACL2 from another program

  ACL2 is intended for interactive use. It is generally unrealistic to
  expect it to prove theorems fully automatically; see [the-method],
  and see [introduction-to-the-theorem-prover] for a more detailed
  tutorial.

  Nevertheless, here we describe an approach for how to call the ACL2
  theorem prover noninteractively. These steps can of course be
  modified according to your needs. Here, we illustrate how to call
  ACL2 from another Lisp program (or an arbitrary program) to attempt
  to prove an arithmetic theorem.

  === STEP 1: ===

  Build a suitable ACL2 image by starting ACL2 and then executing the
  following forms. In particular, these define a macro, try-thm, that
  causes ACL2 to exit with with an exit status indicating success or
  failure of a proof attempt.

    (include-book \"arithmetic-5/top\" :dir :system)
    (defmacro try-thm (&rest args)
      `(mv-let (erp val state)
               (with-prover-time-limit 3 (thm ,@args))
               (declare (ignore val))
               (prog2$ (if erp (exit 1) (exit 0)) state))))
    (reset-prehistory) ; optional
    :q
    (save-exec \"arith-acl2\" \"Included arithmetic-4/top\")

  If you prefer, above you can replace 3 by some other number of
  seconds as a time limit for the prover. Also, you can replace

    (with-prover-time-limit 3 (thm ,@args))

  by

    (with-output :off :all (with-prover-time-limit 3 (thm ,@args)))

  if you want to turn off output. It may be best to leave the output
  on, instead eliminating it in the calling program (see Step 3
  below).

  === STEP 2: ===

  Try a little test. In that same directory try this:

    echo '(try-thm (equal x x))' | ./arith-acl2
    echo $?

  The exit status should be 0, indicating success. Now try this:

    echo '(try-thm (not (equal x x)))' | ./arith-acl2
    echo $?

  The exit status should be 1, indicating failure.

  === STEP 3: ===

  Create a shell script that automates Step 2, for example:

    #!/bin/sh
    (echo \"(try-thm $1)\" | ./arith-acl2) >& /dev/null
    exit $?

  === STEP 4: ===

  Try your script from a Lisp program, if you like. Here is how you can
  do it in SBCL, for example. (Different Lisps have different ways to
  do this, as summarized in function system-call in ACL2 source file
  acl2-init.lisp.)

    (defun provable? (x)
      (let ((status
             (process-exit-code
              (sb-ext:run-program \"./try-thm.sh\" (list (format nil \"~s\" x))
                                  :output t :search t))))
        (eql status 0)))

  Then here is a log:

    * (provable? '(equal x y))

    NIL
    * (provable? '(equal x x))

    T
    *

  Certainly refinements are possible -- for example the above doesn't
  distinguish between unprovable and ill-formed input. But it's a
  start.")
 (ACL2-BUILT-INS
  (PROGRAMMING)
  "Built-in ACL2 functions

  This [documentation] topic is a parent topic under which we include
  documentation for built-in functions, macros, and special forms
  that are typically used in programming. For others, including those
  typically used as top-level commands or those that create [events]
  ([defun], [defthm], and so on), documentation may be found as a
  subtopic of some other parent topic. We do not document some of the
  more obscure functions provided by ACL2 that do not correspond to
  functions of Common Lisp.

  See any documentation for Common Lisp for more details on many of
  these functions.


Subtopics

  [*]
      Multiplication macro

  [+]
      Addition macro

  [-]
      Macro for subtraction and negation

  [/]
      Macro for division and reciprocal

  [/=]
      Test inequality of two numbers

  [1+]
      Increment by 1

  [1-]
      Decrement by 1

  [<]
      Less-than

  [<=]
      Less-than-or-equal test

  [=]
      Test equality of two numbers

  [>]
      Greater-than test

  [>=]
      Greater-than-or-equal test

  [@]
      Get the value of a global variable in [state]

  [Abs]
      The absolute value of a real number

  [ACL2-count]
      A commonly used measure for justifying recursion

  [ACL2-number-listp]
      Recognizer for a true list of numbers

  [ACL2-numberp]
      Recognizer for numbers

  [Acons]
      Constructor for association lists

  [Add-to-set]
      Add a symbol to a list

  [Alistp]
      Recognizer for association lists

  [Allocate-fixnum-range]
      Set aside fixnums in GCL

  [Alpha-char-p]
      Recognizer for alphabetic characters

  [Alphorder]
      Total order on atoms

  [And]
      Conjunction

  [Append]
      [concatenate] zero or more lists

  [Aref1]
      Access the elements of a 1-dimensional array

  [Aref2]
      Access the elements of a 2-dimensional array

  [Array1p]
      Recognize a 1-dimensional array

  [Array2p]
      Recognize a 2-dimensional array

  [Aset1]
      Set the elements of a 1-dimensional array

  [Aset2]
      Set the elements of a 2-dimensional array

  [Ash]
      Arithmetic shift operation

  [Assert$]
      Cause a hard error if the given test is false

  [Assign]
      Assign to a global variable in [state]

  [Assoc]
      Look up key in association list

  [Assoc-keyword]
      Look up key in a [keyword-value-listp]

  [Assoc-string-equal]
      Look up key, a string, in association list

  [Atom]
      Recognizer for atoms

  [Atom-listp]
      Recognizer for a true list of [atom]s

  [Binary-*]
      Multiplication function

  [Binary-+]
      Addition function

  [Binary-append]
      [concatenate] two lists

  [Boole$]
      Perform a bit-wise logical operation on 2 two's complement integers

  [Boolean-listp]
      Recognizer for a true list of booleans

  [Booleanp]
      Recognizer for booleans

  [Break$]
      Cause an immediate Lisp break

  [Breaks]
      Common Lisp breaks

  [Butlast]
      All but a final segment of a list

  [Caaaar]
      [car] of the [caaar]

  [Caaadr]
      [car] of the [caadr]

  [Caaar]
      [car] of the [caar]

  [Caadar]
      [car] of the [cadar]

  [Caaddr]
      [car] of the [caddr]

  [Caadr]
      [car] of the [cadr]

  [Caar]
      [car] of the [car]

  [Cadaar]
      [car] of the [cdaar]

  [Cadadr]
      [car] of the [cdadr]

  [Cadar]
      [car] of the [cdar]

  [Caddar]
      [car] of the [cddar]

  [Cadddr]
      [car] of the [cdddr]

  [Caddr]
      [car] of the [cddr]

  [Cadr]
      [car] of the [cdr]

  [Canonical-pathname]
      The true absolute filename, with soft links resolved

  [Car]
      Returns the first element of a non-empty list, else nil

  [Case]
      Conditional based on if-then-else using [eql]

  [Case-match]
      Pattern matching or destructuring

  [Cdaaar]
      [cdr] of the [caaar]

  [Cdaadr]
      [cdr] of the [caadr]

  [Cdaar]
      [cdr] of the [caar]

  [Cdadar]
      [cdr] of the [cadar]

  [Cdaddr]
      [cdr] of the [caddr]

  [Cdadr]
      [cdr] of the [cadr]

  [Cdar]
      [cdr] of the [car]

  [Cddaar]
      [cdr] of the [cdaar]

  [Cddadr]
      [cdr] of the [cdadr]

  [Cddar]
      [cdr] of the [cdar]

  [Cdddar]
      [cdr] of the [cddar]

  [Cddddr]
      [cdr] of the [cdddr]

  [Cdddr]
      [cdr] of the [cddr]

  [Cddr]
      [cdr] of the [cdr]

  [Cdr]
      Returns the second element of a [cons] pair, else nil

  [Ceiling]
      Division returning an integer by truncating toward positive infinity

  [Char]
      The [nth] element (zero-based) of a string

  [Char-code]
      The numeric code for a given character

  [Char-downcase]
      Turn upper-case [characters] into lower-case [characters]

  [Char-equal]
      Character equality without regard to case

  [Char-upcase]
      Turn lower-case [characters] into upper-case [characters]

  [Char<]
      Less-than test for [characters]

  [Char<=]
      Less-than-or-equal test for [characters]

  [Char>]
      Greater-than test for [characters]

  [Char>=]
      Greater-than-or-equal test for [characters]

  [Character-alistp]
      Recognizer for association lists with characters as keys

  [Character-listp]
      Recognizer for a true list of characters

  [Characterp]
      Recognizer for [characters]

  [Characters]
      Characters in ACL2

  [Check-sum]
      Assigning ``often unique'' integers to files and objects

  [Code-char]
      The character corresponding to a given numeric code

  [Coerce]
      Coerce a character list to a string and a string to a list

  [Complex]
      Create an ACL2 number

  [Complex-rationalp]
      Recognizes complex rational numbers

  [Complex/complex-rationalp]
      Recognizer for complex numbers

  [Compress1]
      Remove irrelevant pairs from a 1-dimensional array

  [Compress2]
      Remove irrelevant pairs from a 2-dimensional array

  [Concatenate]
      Concatenate lists or strings together

  [Cond]
      Conditional based on if-then-else

  [Conjugate]
      Complex number conjugate

  [Cons]
      Pair and list constructor

  [Consp]
      Recognizer for [cons] pairs

  [Count]
      Count the number of occurrences of an item in a string or true-list

  [Cpu-core-count]
      The number of cpu cores

  [Cw]
      Print to the comment window

  [Cw!]
      Print to the comment window

  [Default]
      Return the :default from the [header] of a 1- or 2-dimensional array

  [Delete-assoc]
      Remove the first pair from an association list for a given key

  [Denominator]
      Divisor of a ratio in lowest terms

  [Digit-char-p]
      The number, if any, corresponding to a given character

  [Digit-to-char]
      Map a digit to a character

  [Dimensions]
      Return the :dimensions from the [header] of a 1- or 2-dimensional
      array

  [Ec-call]
      Execute a call in the ACL2 logic instead of raw Lisp

  [Eighth]
      Eighth member of the list

  [Endp]
      Recognizer for empty lists

  [Eq]
      Equality of symbols

  [Eql]
      Test equality (of two numbers, symbols, or [characters])

  [Eqlable-alistp]
      Recognizer for a true list of pairs whose [car]s are suitable for
      [eql]

  [Eqlable-listp]
      Recognizer for a true list of objects each suitable for [eql]

  [Eqlablep]
      The [guard] for the function [eql]

  [Equal]
      True equality

  [Er]
      Print an error message and ``cause an error''

  [Er-progn]
      Perform a sequence of state-changing ``error triples''

  [Error1]
      Print an error message and cause a ``soft error''

  [Evenp]
      Test whether an integer is even

  [Explode-atom]
      Convert any [atom] into a [character-listp] that contains its
      printed representation, rendering numbers in your choice of
      print base.

  [Explode-nonnegative-integer]
      The list of [characters] in the radix-r form of a number

  [Expt]
      Exponential function

  [F-get-global]
      Get the value of a global variable in [state]

  [F-put-global]
      Assign to a global variable in [state]

  [Fifth]
      Fifth member of the list

  [First]
      First member of the list

  [Fix]
      Coerce to a number

  [Fix-true-list]
      Coerce to a true list

  [Flet]
      Local binding of function symbols

  [Floor]
      Division returning an integer by truncating toward negative infinity

  [Flush-compress]
      Flush the under-the-hood array for the given name

  [Fms]
      :(str alist co-channel state evisc) => state

  [Fms!]
      :(str alist co-channel state evisc) => state

  [Fmt]
      Formatted printing

  [Fmt!]
      :(str alist co-channel state evisc) => state

  [Fmt-to-comment-window]
      Print to the comment window

  [Fmt1]
      :(str alist col co-channel state evisc) => (mv col state)

  [Fmt1!]
      :(str alist col channel state evisc) => (mv col state)

  [Fourth]
      Fourth member of the list

  [Getenv$]
      Read an environment variable

  [Getprop]
      Access fast property lists

  [Good-atom-listp]
      Recognizer for a true list of ``good'' [atom]s

  [Hard-error]
      Print an error message and stop execution

  [Header]
      Return the header of a 1- or 2-dimensional array

  [Identity]
      The identity function

  [If]
      If-then-else function

  [Iff]
      Logical ``if and only if''

  [Ifix]
      Coerce to an integer

  [Illegal]
      Print an error message and stop execution

  [Imagpart]
      Imaginary part of a complex number

  [Implies]
      Logical implication

  [Improper-consp]
      Recognizer for improper (non-null-terminated) non-empty lists

  [Int=]
      Test equality of two integers

  [Integer-length]
      Number of bits in two's complement integer representation

  [Integer-listp]
      Recognizer for a true list of integers

  [Integerp]
      Recognizer for whole numbers

  [Intern]
      Create a new symbol in a given package

  [Intern$]
      Create a new symbol in a given package

  [Intern-in-package-of-symbol]
      Create a symbol with a given name

  [Intersection$]
      Elements of one list that are not elements of another

  [Intersectp]
      Test whether two lists intersect

  [Io]
      Input/output facilities in ACL2

  [Keyword-value-listp]
      Recognizer for true lists whose even-position elements are keywords

  [Keywordp]
      Recognizer for keywords

  [Kwote]
      Quote an arbitrary object

  [Kwote-lst]
      Quote an arbitrary true list of objects

  [Last]
      The last [cons] (not element) of a list

  [Len]
      Length of a list

  [Length]
      Length of a string or proper list

  [Let]
      Binding of lexically scoped (local) variables

  [Let*]
      Binding of lexically scoped (local) variables

  [Lexorder]
      Total order on ACL2 objects

  [List]
      Build a list

  [List*]
      Build a list

  [Listp]
      Recognizer for (not necessarily proper) lists

  [Logand]
      Bitwise logical `and' of zero or more integers

  [Logandc1]
      Bitwise logical `and' of two ints, complementing the first

  [Logandc2]
      Bitwise logical `and' of two ints, complementing the second

  [Logbitp]
      The ith bit of an integer

  [Logcount]
      Number of ``on'' bits in a two's complement number

  [Logeqv]
      Bitwise logical equivalence of zero or more integers

  [Logior]
      Bitwise logical inclusive or of zero or more integers

  [Lognand]
      Bitwise logical `nand' of two integers

  [Lognor]
      Bitwise logical `nor' of two integers

  [Lognot]
      Bitwise not of a two's complement number

  [Logorc1]
      Bitwise logical inclusive or of two ints, complementing the first

  [Logorc2]
      Bitwise logical inclusive or of two ints, complementing the second

  [Logtest]
      Test if two integers share a `1' bit

  [Logxor]
      Bitwise logical exclusive or of zero or more integers

  [Lower-case-p]
      Recognizer for lower case characters

  [Make-character-list]
      [coerce] to a list of characters

  [Make-list]
      Make a list of a given size

  [Make-ord]
      A constructor for ordinals.

  [Max]
      The larger of two numbers

  [Maximum-length]
      Return the :maximum-length from the [header] of an array

  [Mbe]
      Attach code for execution

  [Mbe1]
      Attach code for execution

  [Mbt]
      Introduce a test not to be evaluated

  [Member]
      Membership predicate

  [Min]
      The smaller of two numbers

  [Minusp]
      Test whether a number is negative

  [Mod]
      Remainder using [floor]

  [Mod-expt]
      Exponential function

  [Msg]
      Construct a ``message'' suitable for the ~@ directive of [fmt]

  [Must-be-equal]
      Attach code for execution

  [Mv]
      Returning a multiple value

  [Mv-let]
      Calling multi-valued ACL2 functions

  [Mv-list]
      Converting multiple-valued result to a single-valued list

  [Mv-nth]
      The mv-nth element (zero-based) of a list

  [Mv?]
      Return one or more values

  [Mv?-let]
      Calling possibly multi-valued ACL2 functions

  [Nat-listp]
      Recognizer for a true list of natural numbers

  [Natp]
      A recognizer for the natural numbers

  [Nfix]
      Coerce to a natural number

  [Ninth]
      Ninth member of the list

  [No-duplicatesp]
      Check for duplicates in a list

  [Non-exec]
      Mark code as non-executable

  [Nonnegative-integer-quotient]
      Natural number division function

  [Not]
      Logical negation

  [Nth]
      The nth element (zero-based) of a list

  [Nthcdr]
      Final segment of a list

  [Null]
      Recognizer for the empty list

  [Numerator]
      Dividend of a ratio in lowest terms

  [O-finp]
      Recognizes if an ordinal is finite

  [O-first-coeff]
      Returns the first coefficient of an ordinal

  [O-first-expt]
      The first exponent of an ordinal

  [O-infp]
      Recognizes if an ordinal is infinite

  [O-p]
      A recognizer for the ordinals up to epsilon-0

  [O-rst]
      Returns the rest of an infinite ordinal

  [O<]
      The well-founded less-than relation on ordinals up to epsilon-0

  [O<=]
      The less-than-or-equal relation for the ordinals

  [O>]
      The greater-than relation for the ordinals

  [O>=]
      The greater-than-or-equal relation for the ordinals

  [Observation]
      Print an observation

  [Oddp]
      Test whether an integer is odd

  [Or]
      Disjunction

  [Oracle-apply]
      Call a function argument on the given list of arguments

  [Oracle-apply-raw]
      Call a function argument on the given list of arguments, no
      restrictions

  [Oracle-funcall]
      Call a function argument on the remaining arguments

  [Pairlis]
      See [pairlis$]

  [Pairlis$]
      Zipper together two lists

  [Pkg-imports]
      List of symbols imported into a given package

  [Pkg-witness]
      Return a specific symbol in the indicated package

  [Plusp]
      Test whether a number is positive

  [Position]
      Position of an item in a string or a list

  [Posp]
      A recognizer for the positive integers

  [Pprogn]
      Evaluate a sequence of forms that return [state]

  [Princ$]
      Print an atom

  [Printing-to-strings]
      Printing to strings instead of files or standard output

  [Prog2$]
      Execute two forms and return the value of the second one

  [Progn$]
      Execute a sequence of forms and return the value of the last one

  [Proofs-co]
      The proofs character output channel

  [Proper-consp]
      Recognizer for proper (null-terminated) non-empty lists

  [Pseudo-termp]
      A predicate for recognizing term-like s-expressions

  [Put-assoc]
      Modify an association list by associating a value with a key

  [Putprop]
      Update fast property lists

  [Quote]
      Create a constant

  [R-eqlable-alistp]
      Recognizer for a true list of pairs whose [cdr]s are suitable for
      [eql]

  [R-symbol-alistp]
      Recognizer for association lists with symbols as values

  [Random$]
      Obtain a random value

  [Rassoc]
      Look up value in association list

  [Rational-listp]
      Recognizer for a true list of rational numbers

  [Rationalp]
      Recognizer for rational numbers (ratios and integers)

  [Read-ACL2-oracle]
      Pop the oracle field of the state

  [Read-run-time]
      Read elapsed runtime

  [Real/rationalp]
      Recognizer for rational numbers (including real number in ACL2(r))

  [Realfix]
      Coerce to a real number

  [Realpart]
      Real part of a complex number

  [Rem]
      Remainder using [truncate]

  [Remove]
      Remove all occurrences

  [Remove-duplicates]
      Remove duplicates from a string or a list

  [Remove1]
      Remove first occurrences, testing using [eql]

  [Rest]
      Rest ([cdr]) of the list

  [Return-last]
      Return the last argument, perhaps with side effects

  [Revappend]
      Concatentate the [reverse] of one list to another

  [Reverse]
      Reverse a list or string

  [Rfix]
      Coerce to a rational number

  [Round]
      Division returning an integer by rounding off

  [Search]
      Search for a string or list in another string or list

  [Second]
      Second member of the list

  [Set-difference$]
      Elements of one list that are not elements of another

  [Setenv$]
      Set an environment variable

  [Seventh]
      Seventh member of the list

  [Signed-byte-p]
      Recognizer for signed integers that fit in a specified bit width

  [Signum]
      Indicator for positive, negative, or zero

  [Sixth]
      Sixth member of the list

  [Standard-char-listp]
      Recognizer for a true list of standard characters

  [Standard-char-p]
      Recognizer for standard characters

  [Standard-co]
      The character output channel to which [ld] prints

  [Standard-oi]
      The standard object input ``channel''

  [Standard-string-alistp]
      Recognizer for association lists with standard strings as keys

  [State-global-let*]
      Bind [state] global variables

  [String]
      [coerce] to a string

  [String-append]
      [concatenate] two strings

  [String-downcase]
      In a given string, turn upper-case [characters] into lower-case

  [String-equal]
      String equality without regard to case

  [String-listp]
      Recognizer for a true list of strings

  [String-upcase]
      In a given string, turn lower-case [characters] into upper-case

  [String<]
      Less-than test for strings

  [String<=]
      Less-than-or-equal test for strings

  [String>]
      Greater-than test for strings

  [String>=]
      Less-than-or-equal test for strings

  [Stringp]
      Recognizer for strings

  [Strip-cars]
      Collect up all first components of pairs in a list

  [Strip-cdrs]
      Collect up all second components of pairs in a list

  [Sublis]
      Substitute an alist into a tree

  [Subseq]
      Subsequence of a string or list

  [Subsetp]
      Test if every [member] of one list is a [member] of the other

  [Subst]
      A single substitution into a tree

  [Substitute]
      Substitute into a string or a list, using [eql] as test

  [Symbol-<]
      Less-than test for symbols

  [Symbol-alistp]
      Recognizer for association lists with symbols as keys

  [Symbol-listp]
      Recognizer for a true list of symbols

  [Symbol-name]
      The name of a symbol (a string)

  [Symbol-package-name]
      The name of the package of a symbol (a string)

  [Symbolp]
      Recognizer for symbols

  [Sys-call]
      Make a system call to the host operating system

  [Sys-call+]
      Make a system call to the host OS, returning status and output

  [Sys-call-status]
      Exit status from the preceding system call

  [Take]
      Initial segment of a list

  [Tenth]
      Tenth member of the list

  [Term-order]
      The ordering relation on terms used by ACL2

  [The]
      Run-time type check

  [Third]
      Third member of the list

  [Time$]
      Time an evaluation

  [True-list-listp]
      Recognizer for true (proper) lists of true lists

  [True-listp]
      Recognizer for proper (null-terminated) lists

  [Truncate]
      Division returning an integer by truncating toward 0

  [Unary--]
      Arithmetic negation function

  [Unary-/]
      Reciprocal function

  [Union$]
      Elements of one list that are not elements of another

  [Unsigned-byte-p]
      Recognizer for natural numbers that fit in a specified bit width

  [Update-nth]
      Modify a list by putting the given value at the given position

  [Upper-case-p]
      Recognizer for upper case characters

  [With-live-state]
      Allow a reference to state in raw Lisp

  [Xor]
      Logical ``exclusive or''

  [Zerop]
      Test an acl2-number against 0

  [Zip]
      Testing an ``integer'' against 0

  [Zp]
      Testing a ``natural'' against 0

  [Zpf]
      Testing a nonnegative fixnum against 0")
 (ACL2-COUNT
  (ACL2-BUILT-INS)
  "A commonly used measure for justifying recursion

  (Acl2-count x) returns a nonnegative integer that indicates the
  ``size'' of its argument x.

  All [characters] and symbols have acl2-count 0. The acl2-count of a
  string is the number of [characters] in it, i.e., its length. The
  acl2-count of a [cons] is one greater than the sum of the
  acl2-counts of the [car] and [cdr]. The acl2-count of an integer is
  its absolute value. The acl2-count of a rational is the sum of the
  acl2-counts of the numerator and denominator. The acl2-count of a
  complex rational is one greater than the sum of the acl2-counts of
  the real and imaginary parts.

  Function: <acl2-count>

    (defun acl2-count (x)
           (declare (xargs :guard t))
           (if (consp x)
               (+ 1 (acl2-count (car x))
                  (acl2-count (cdr x)))
               (if (rationalp x)
                   (if (integerp x)
                       (integer-abs x)
                       (+ (integer-abs (numerator x))
                          (denominator x)))
                   (if (complex/complex-rationalp x)
                       (+ 1 (acl2-count (realpart x))
                          (acl2-count (imagpart x)))
                       (if (stringp x) (length x) 0)))))")
 (ACL2-CUSTOMIZATION
  (SWITCHES-PARAMETERS-AND-MODES PROGRAMMING)
  "File of initial commands for ACL2 to run at [startup]

  ACL2 provides a mechanism to load automatically a so-called ``ACL2
  customization file,'' via [ld], the first time [lp] is called in an
  ACL2 session. ACL2 looks for this file as follows.

   1. If the host Lisp reads a non-empty value for the system's environment
      variable ACL2_CUSTOMIZATION, then that string value is used for
      the customization file name. In this case, if the file does not
      exist or if the string is \"NONE\" then there is no customization
      file. Notes:
        * If the customization file name is a relative pathname (see
          [pathname]), then the pathname is considered relative to
          the connected book directory (see [cbd]).
        * If this variable is not already defined, then its value is set to
          NONE when books are certified using [cert.pl] or other,
          legacy Make-based certification tools.

   2. Otherwise (empty environment variable value), file
      \"acl2-customization.lsp\" or \"acl2-customization.lisp\" on the
      connected book directory (see [cbd]), generally the current
      directory, is the customization file (in that order) if either
      exists.
   3. Otherwise file \"acl2-customization.lsp\" or \"acl2-customization.lisp\"
      on your home directory is the customization file (in that
      order), if either exists (except, this case is skipped on
      Windows operating systems.

  Except for the fact that this [ld] command is not typed explicitly by
  you, it is a standard [ld] command, with one exception: any
  settings of [ld] specials are remembered once this call of [ld] has
  completed. For example, suppose that you start your customization
  file with (set-ld-skip-proofsp t state), so that proofs are skipped
  as it is loaded with [ld]. Then the [ld] special [ld-skip-proofsp]
  will remain t after the [ld] has completed, causing proofs to be
  skipped in your ACL2 session, unless your customization file sets
  this variable back to nil, say with (set-ld-skip-proofsp nil
  state).

  If the customization file exists, it is loaded with [ld] using the
  usual default values for the [ld] specials (see [ld]). Thus, if an
  error is encountered, no subsequent forms in the file will be
  evaluated.

  To create a customization file it is recommended that you first give
  it a name other than \"acl2-customization.lsp\" or
  \"acl2-customization.lisp\" so that ACL2 does not try to include it
  prematurely when you next enter [lp]. Then, while in the
  uncustomized [lp], explicitly invoke [ld] on your evolving (but
  renamed) customization file until all forms are successfully
  evaluated. The same procedure is recommended if for some reason
  ACL2 cannot successfully evaluate all forms in your customization
  file: temporarily rename your customization file so that ACL2 does
  not try to [ld] it automatically and then debug the new file by
  explicit calls to [ld].

  WARNING! If you certify a book after the (automatic) loading of a
  customization file, the forms in that file will be part of the
  [portcullis] of the [books] you certify! That is, the forms in your
  customization file at certification time will be loaded whenever
  anybody uses the [books] you are certifying. Since customization
  files generally contain idiosyncratic [command]s, you may not want
  yours to be part of the [books] you create for others. Thus, if you
  have a customization file then you may want to invoke :[ubt] 1
  before certifying any [books]; alternatively, see [certify-book!]
  for automatic invocation of [ubt].

  On the other hand, if you wish to prevent undoing commands from the
  customization file, see [reset-prehistory].

  Finally, we note that except on Windows-based systems, if there is a
  file acl2-init.lsp in your home directory, then it will be loaded
  into raw Lisp when ACL2 is invoked.")
 (ACL2-DEFAULTS-TABLE
  (OTHER)
  "A [table] specifying certain defaults, e.g., the default [defun-mode]

    Example Forms:
    (table acl2-defaults-table :defun-mode) ; current default defun-mode
    (table acl2-defaults-table :defun-mode :program)
               ; set default defun-mode to :program

  See [table] for a discussion of tables in general. The legal keys for
  this [table] are shown below. They may be accessed and changed via
  the general mechanisms provided by [table]s. However, there are
  often more convenient ways to access and/or change the defaults.
  (See also the note below.)

    :defun-mode

  the default [defun-mode], which must be :[program] or :[logic]. See
  [defun-mode] for a general discussion of [defun-mode]s. The
  :[defun-mode] key may be conveniently set by keyword commands
  naming the new [defun-mode], :[program] and :[logic]. See [program]
  and see [logic].

    :enforce-redundancy

  if t, cause ACL2 to insist that most events are redundant (see
  [redundant-events]); if :warn, cause a warning instead of an error
  for such non-redundant events; else, nil. See
  [set-enforce-redundancy].

    :ignore-doc-string-error

  if t, cause ACL2 to ignore ill-formed [documentation] strings rather
  than causing an error; if :warn, cause a warning instead of an
  error in such cases; else, nil (the default). See
  [set-ignore-doc-string-error].

    :verify-guards-eagerness

  an integer between 0 and 2 indicating how eager the system is to
  verify the [guard]s of a [defun] event. See
  [set-verify-guards-eagerness].

    :compile-fns

  When this key's value is t, functions are compiled when they are
  [defun]'d; otherwise, the value is nil. (Except, this key's value
  is ignored when explicit compilation is suppressed; see
  [compilation].) To set the flag, see [set-compile-fns].

    :measure-function

  the default measure function used by [defun] when no :measure is
  supplied in [xargs]. The default measure function must be a
  function symbol of one argument. Let mfn be the default measure
  function and suppose no :measure is supplied with some recursive
  function definition. Then [defun] finds the first formal, var, that
  is tested along every branch and changed in each recursive call.
  The system then ``guesses'' that (mfn var) is the :measure for that
  [defun].

    :well-founded-relation

  the default well-founded relation used by [defun] when no
  :[well-founded-relation] is supplied in [xargs]. The default
  well-founded relation must be a function symbol, rel, of two
  arguments about which a :[well-founded-relation] rule has been
  proved. See [well-founded-relation].

    :bogus-defun-hints-ok

  When this key's value is t, ACL2 allows :hints for nonrecursive
  function definitions. Otherwise, the value is the nil (the default)
  or :warn (which makes the check but merely warns when the check
  fails). See [set-bogus-defun-hints-ok].

    :bogus-mutual-recursion-ok

  When this key's value is t, ACL2 skips the check that every function
  in a [mutual-recursion] (or [defuns]) ``clique'' calls at least one
  other function in that ``clique.'' Otherwise, the value is nil (the
  default) or :warn (which makes the check but merely warns when the
  check fails). See [set-bogus-mutual-recursion-ok].

    :irrelevant-formals-ok

  When this key's value is t, the check for irrelevant formals is
  bypassed; otherwise, the value is the keyword nil (the default) or
  :warn (which makes the check but merely warns when the check
  fails). See [irrelevant-formals] and see
  [set-irrelevant-formals-ok].

    :ignore-ok

  When this key's value is t, the check for ignored variables is
  bypassed; otherwise, the value is the keyword nil (the default) or
  :warn (which makes the check but merely warns when the check
  fails). See [set-ignore-ok].

    :bdd-constructors

  This key's value is a list of function symbols used to define the
  notion of ``BDD normal form.'' See [bdd-algorithm] and see [hints].

    :ttag

  This key's value, when non-nil, allows certain operations that extend
  the trusted code base beyond what is provided by ACL2. See
  [defttag]. See [defttag].

    :state-ok

  This key's value is either t or nil and indicates whether the user is
  aware of the syntactic restrictions on the variable symbol STATE.
  See [set-state-ok].

    :backchain-limit

  This key's value is a list of two ``numbers.'' Either ``number'' may
  optionally be nil, which is treated like positive infinity. The
  numbers control backchaining through hypotheses during type-set
  reasoning and rewriting. See [backchain-limit].

    :default-backchain-limit

  This key's value is a list of two ``numbers.'' Either ``number'' may
  optionally be nil, which is treated like positive infinity. The
  numbers are used respectively to set the backchain limit of a rule
  if one has not been specified. See [backchain-limit].

    :step-limit

  This key's value is either nil or a natural number not exceeding the
  value of *default-step-limit*. If the value is nil or the value of
  *default-step-limit*, there is no limit on the number of ``steps''
  that ACL2 counts during a proof: currently, the number of top-level
  rewriting calls. Otherwise, the value is the maximum number of such
  calls allowed during evaluation of any event. See
  [set-prover-step-limit].

    :rewrite-stack-limit

  This key's value is a nonnegative integer less than (expt 2 28). It
  is used to limit the depth of calls of ACL2 rewriter functions. See
  [rewrite-stack-limit].

    :let*-abstractionp

  This key affects how the system displays subgoals. The value is
  either t or nil. When t, let* expressions are introduced before
  printing to eliminate common subexpressions. The actual goal being
  worked on is unchanged.

    :nu-rewriter-mode

  This key's value is nil, t, or :literals. When the value is non-nil,
  the rewriter gives special treatment to expressions and functions
  defined in terms of [nth] and [update-nth]. See
  [set-nu-rewriter-mode].

    :case-split-limitations

  This key's value is a list of two ``numbers.'' Either ``number'' may
  optionally be nil, which is treated like positive infinity. The
  numbers control how the system handles case splits in the
  simplifier. See [set-case-split-limitations].

    :include-book-dir-alist

  This key's value is used by [include-book]'s :DIR argument to
  associate a directory with a keyword. An exception is the keyword
  :SYSTEM for the books/ directory; see [include-book], in particular
  the section on ``Books Directory.'' Also see [add-include-book-dir]
  and [add-include-book-dir!].

    :match-free-default

  This key's value is either :all, :once, or nil. See
  [set-match-free-default].

    :match-free-override

  This key's value is a list of runes. See [add-match-free-override].

    :match-free-override-nume

  This key's value is an integer used in the implementation of
  [add-match-free-override], so that only existing runes are affected
  by that event.

    :non-linearp

  This key's value is either t or nil and indicates whether the user
  wishes ACL2 to extend the linear arithmetic decision procedure to
  include non-linear reasoning. See [non-linear-arithmetic].

    :tau-auto-modep

  This key's value is either t or nil and indicates whether the user
  wishes ACL2 to look for opportunities to create :[tau-system] rules
  from all suitable defuns and from all suitable defthms (with
  non-nil :[rule-classes]). See [set-tau-auto-mode].

    :ruler-extenders

  This key's value may be a list of symbols, indicating those function
  symbols that are not to block the collection of rulers; see
  [defun]. Otherwise the value is :all to indicate all function
  symbols, i.e., so that no function symbol blocks the collection of
  rulers. If a list is specified (rather than :all), then it may
  contain the keyword :lambdas, which has the special role of
  specifying all lambda applications. No other keyword is permitted
  in the list. See [ruler-extenders].

    :memoize-ideal-okp

  This key is only legal in an experimental [hons] version (see
  [hons-and-memoization]). Its value must be either t, nil, or :warn.
  If the value is nil or not present, then it is illegal by default
  to [memoize] a :[logic] mode function that has not been
  [guard]-verified (see [verify-guards]), sometimes called an
  ``ideal-mode'' function. This illegality is the default because
  such calls of such functions in the ACL2 loop are generally
  evaluated in the logic (using so-called ``executable counterpart''
  definitions), rather than directly by executing calls of the
  corresponding (memoized) raw Lisp function. However, such a raw
  Lisp call can be made when the function is called by a :[program]
  mode function, so we allow you to override the default behavior by
  associating the value t or :warn with the key :memoize-ideal-okp,
  where with :warn you get a suitable warning. Note that you can also
  allow memoization of ideal-mode functions by supplying argument
  :ideal-okp to your memoization event (see [memoize]), in which case
  the value of :memoize-ideal-okp in the acl2-defaults-table is
  irrelevant.

  Note: Unlike all other [table]s, acl2-defaults-table can affect the
  soundness of the system. The [table] mechanism therefore enforces
  on it a restriction not imposed on other [table]s: when [table] is
  used to update the acl2-defaults-table, the key and value must be
  variable-free forms. Thus, while

    (table acl2-defaults-table :defun-mode :program),

    (table acl2-defaults-table :defun-mode ':program), and

    (table acl2-defaults-table :defun-mode (compute-mode *my-data*))

  are all examples of legal [events] (assuming compute-mode is a
  function of one non-[state] argument that produces a [defun-mode]
  as its single value),

    (table acl2-defaults-table :defun-mode (compute-mode (w state)))

  is not legal because the value form is [state]-sensitive.

  Consider for example the following three [events] which one might
  make into the text of a book.

    (in-package \"ACL2\")

    (table acl2-defaults-table
      :defun-mode
      (if (ld-skip-proofsp state) :logic :program))

    (defun crash-and-burn (x) (car x))

  The second event is illegal because its value form is
  [state]-sensitive. If it were not illegal, then it would set the
  :[defun-mode] to :[program] when the book was being certified but
  would set the [defun-mode] to :[logic] when the book was being
  loaded by [include-book]. That is because during certification,
  [ld-skip-proofsp] is nil (proof obligations are generated and
  proved), but during book inclusion [ld-skip-proofsp] is non-nil
  (those obligations are assumed to have been satisfied.) Thus, the
  above book, when loaded, would create a function in :[logic] mode
  that does not actually meet the conditions for such status.

  For similar reasons, [table] [events] affecting acl2-defaults-table
  are illegal within the scope of [local] forms. That is, the text

    (in-package \"ACL2\")

    (local (table acl2-defaults-table :defun-mode :program))

    (defun crash-and-burn (x) (car x))

  is illegal because acl2-defaults-table is changed locally. If this
  text were acceptable as a book, then when the book was certified,
  crash-and-burn would be processed in :[program] mode, but when the
  certified book was included later, crash-and-burn would have
  :[logic] mode because the [local] event would be skipped.

  The text

    (in-package \"ACL2\")

    (program) ;which is (table acl2-defaults-table :defun-mode :program)

    (defun crash-and-burn (x) (car x))

  is acceptable and defines crash-and-burn in :[program] mode, both
  during certification and subsequent inclusion.

  We conclude with an important observation about the relation between
  acl2-defaults-table and [include-book], [certify-book], and
  [encapsulate]. Including or certifying a book never has an effect
  on the acl2-defaults-table, nor does executing an [encapsulate]
  event; we always restore the value of this [table] as a final act.
  (Also see [include-book], see [encapsulate], and see
  [certify-book].) That is, no matter how a book fiddles with the
  acl2-defaults-table, its value immediately after including that
  book is the same as immediately before including that book. If you
  want to set the acl2-defaults-table in a way that persists, you
  need to do so using [command]s that are not inside [books]. It may
  be useful to set your favorite defaults in your
  [ACL2-customization] file; see [ACL2-customization].")
 (ACL2-DOC
  (DOCUMENTATION)
  "A custom Emacs browser for reading ACL2 [documentation]

  As discussed elsewhere (see [documentation]), the web-based
  acl2+books combined manual provides a way to browse the combined
  documentation for the ACL2 system and community books. This
  documentation can also be read at the terminal using the :[doc]
  command, though documentation for [books] will only be included for
  those books that have been included in the session. In this topic
  we describe how to browse the documentation using ACL2-Doc, a
  browser for reading ACL2 and books documentation inside Emacs.

  While ACL2-Doc is much like Emacs Info, it is a separate system that
  provides some additional functionality. In order to use ACL2-Doc,
  load the distributed file emacs/acl2-doc.el into Emacs. This will
  happen automatically if you load emacs/emacs-acl2.el, which will
  happen automatically if you put the following form in your ~/.emacs
  file, replacing DIR by a path to your ACL2 installation.

    (load \"DIR/emacs/emacs-acl2.el\")

  Then to start the browser at the top-level topic, either execute the
  Emacs command

    meta-x acl2-doc

  or else type:

    Control-t g

  By default you will browse the acl2+books combined manual, though if
  you are using an svn version between ACL2 releases then you may be
  queried; more on that below. You can enter the ACL2-Doc browser at
  a specific documentation topic as follows (in analogy to Emacs
  command Meta-.):

    Control-t .

  In each of the cases above, you will now be in a buffer called
  \"acl2-doc\", which will be displaying the top-level ACL2 topic in a
  special mode, the ACL2-Doc major mode. That mode provides the
  following key bindings; you can also see these by typing Control-h
  m while in that buffer.

    <Return>      acl2-doc-go!
    g             acl2-doc-go
    h             acl2-doc-help
    i             acl2-doc-index
    ,             acl2-doc-index-next
    l             acl2-doc-last
    n             acl2-doc-search-next
    q             acl2-doc-quit
    r             acl2-doc-return
    s             acl2-doc-search
    S             acl2-doc-re-search
    t             acl2-doc-top
    u             acl2-doc-up
    SPC           scroll-up
    TAB           acl2-doc-tab
    D             acl2-doc-rendered-combined-download
    H             acl2-doc-history
    I             acl2-doc-initialize

  You can see the documentation for each of these in the usual way,
  using Control-h k {key} or Control-h f {command}. Here is what you
  will find in each case if you do that.

    <Return>      acl2-doc-go!
       Go to the topic occurring at the cursor position.

    g             acl2-doc-go
       Go to the specified topic; performs completion.

    h             acl2-doc-help
       Go to the ACL2-DOC topic to read about how to use the ACL2-Doc browser.

    i             acl2-doc-index
       Go to the specified topic or else one containing it as a substring;
       performs completion.  If the empty string is supplied, then go to the
       index buffer.  Note that the index buffer is in ACL2-Doc mode; thus, in
       particular, you can type <RETURN> while standing on a topic in order to go
       directly to that topic.

    ,             acl2-doc-index-next
       Find the next topic containing, as a substring, the topic from the
       previous i command.

    l             acl2-doc-last
       Go to the last topic visited.

    n             acl2-doc-search-next
       Find the next occurrence for the most recent search or regular expression
       search.

    q             acl2-doc-quit
       Quit the ACL2-Doc browser.

    r             acl2-doc-return
       Return to the last topic visited, popping the stack of such topics.

    s             acl2-doc-search
       Search forward from the top of the manual for the input string.  If the
       search succeeds, then go to that topic with the cursor put immediately
       after the found text, with the topic name displayed in the minibuffer.

    S             acl2-doc-re-search
       Perform a regular expression search, forward from the top of the manual,
       for the input string.  If the search succeeds, then go to that topic with
       the cursor put immediately after the found text, with the topic name
       displayed in the minibuffer.

    t             acl2-doc-top
       Go to the top topic.

    u             acl2-doc-up
       Go to the parent of the current topic.

    SPC           scroll-up
       Scroll up (same as Control-v)

    TAB           acl2-doc-tab
       Visit the next link after the cursor on the current page, searching from
       the top if no link is below the cursor.

    D
       Download the acl2+books combined manual from the web; then restart the
       ACL2-Doc browser to view that manual.

    H             acl2-doc-history
       Visit a buffer that displays the names of all visited topics in order,
       newest at the bottom.  That buffer is in acl2-doc mode; thus the usual
       acl2-doc commands may be used.  In particular, you can visit a displayed
       topic name by putting your cursor on it and typing <RETURN>.

    I             acl2-doc-initialize
       Restart the ACL2-Doc browser, clearing its state.  With prefix argument,
       toggle between the ACL2 User's Manual (the default) and the acl2+books
       combined manual.  For the latter, it will be necessary first to create
       file books/system/doc/rendered-doc-combined.lsp; see :DOC acl2-doc.

  The Two Manuals

  ACL2-Doc can display the ACL2 User's Manual, which includes
  documentation for the ACL2 system but not for the community books.
  But by default, ACL2-Doc will display the acl2+books combined
  manual, which includes documentation for those books as well. To
  change which of these two manuals you display, just give a prefix
  argument to the \"I\" command, as indicated above.

  If you are using an svn version of ACL2 and the books, between
  releases, then you may need to download an extra file in order to
  browse the acl2+books combined manual. Most likely you will just
  answer y when queried about downloading the file when first using
  ACL2-Doc. If you want more details, see the last of the Notes
  below.

  Notes

    * You might find that when you attempt to follow some link, say,
      [some-name], you find yourself at the [broken-link] topic. If
      you are using the ACL2 User's Manual rather than the acl2+books
      combined manual, the reason might be that some-name is
      documented in a book, not in the ACL2 system. In that case, the
      broken-link page will show you where to find that book; but if
      you want to read the documentation for some-name in the
      ACL2-Doc browser, you can do so by switching to the acl2+books
      combined manual. See the I command, documented above.

    * Files with names ending in .acl2-doc will come up in ACL2-Doc mode.
      Thus, you may wish to save a file with that extension, for
      example bookmarks.acl2-doc, that contains your favorite
      bookmarks. You may wish to use the history command (H) to
      obtain a list of names of visited topics, in order to create an
      initial such file.

    * Many commands offer defaults, and many offer completion. The default
      is determined by cursor position: if the cursor is sitting on a
      letter of a documentation topic name, or on a space character
      immediately after it, then that name will be offered as the
      default.

    * Square brackets indicate documentation topic names, for example:
      [acl2-doc]. The square brackets are really there, for example
      when you are searching using \"s\", \"S\", or \"n\". However, for
      purposes of determining the default name (see above), the only
      effect of the enclosing square brackets is to extend the region
      in which the default is offered. For example, consider the
      string \"[acl2-doc]\": the default name of \"acl2-doc\" is offered
      if the cursor is on either square bracket. But links have some
      idiosyncrasies.

       1. Topic names, including links `[..]' to topic names, are printed
          relative to the ACL2 package. Especially in the case of the
          combined manual, you may therefore see links that include
          package prefixes. Here, for example, is a sentence from the
          documentation for [gl] in the acl2+books combined manual.

              We call these structures [gl::symbolic-objects].

          The \"gl\" package prefix allows commands to pick up
          \"gl::symbolic-objects\" as the name to use as a default, so
          that for example, hitting <Return> will take you to that
          topic. But when reading the sentence, for best results you
          should ignore package prefixes. So for example, you would
          read the sentence above as follows.

              We call these structures symbolic-objects.

       2. Topic names that originally contained spaces now have underscores in
          place of the spaces. So for example, the topic [cert.pl] in
          the acl2+books combined manual contains a link to the topic
          originally named as follows.

              1. Certifying Simple Books

          This link shows up in the ACL2-Doc browser (and in output from the
          :[doc] command at the terminal) as:
          [1._Certifying_Simple_Books]. When you see a potential link
          that does include whitespace, then it will not work,
          probably because the original markup specified English text
          that differs from the topic name. For example, consider the
          following passage from the documentation for [gl].

              GL requires ACL2(h) because it makes extensive use of
              [hons-and-memoization]. Some optional parts of GL also require
              [trust tags].

          The first link will take you to the topic, [hons-and-memoization].
          But the second link was actually written to be a link to
          the documentation for [defttag]. The <Return> command will
          not work on that second link; unfortunately, the
          alternative is to use the g command and specify defttag in
          the minibuffer.

      Of course, the web-based browser avoids these idiosyncrasies (see
      [xdoc::save]), hence may be more appropriate for those who have
      no particular preference for using Emacs to browse the
      documentation.

    * Searching using the \"s\" or \"S\" command is carried out by searching
      top-to-bottom in a hidden Emacs buffer that contains all of the
      documentation. The topics are listed in the following order
      according to topic name:

       1. All topics whose names reside in the \"ACL2\" package;
       2. All topics whose names reside in the \"ACL2-PC\" package; and, for the
          acl2+books combined manual,
       3. All other topics, sorted by [symbol-name] and then by
          [symbol-package-name].

    * You may be queried, regarding whether you want to browse the
      acl2+books combined manual, which is preferred, or the ACL2
      User's Manual, which omits documentation for the books. Both of
      these manuals are based on files that you will have if you are
      using a released version of ACL2 (after Version 6.3). But if
      you are using an svn version, then to use the acl2+books
      combined manual you will need an extra file. You can build this
      file yourself, as described below but you may prefer to
      download it: for example, when you start ACL2-Doc, you may be
      given the option of downloading the latest ``bleeding edge''
      copy from
      http://www.cs.utexas.edu/users/moore/acl2/manuals/current/rendered-doc-combined.lsp.gz
      and extracting into directory system/doc/ of your community
      books directory. Indeed, the system will do all this for you if
      you answer y to that query. Alternatively, you can insist on a
      download of a ``bleeding edge'' version by using the `D'
      command. However, if you prefer to browse the ACL2 User's
      Manual (without the books), you can put the following form into
      your ~/.emacs file, above the form that loads the code for
      ACL2-Doc (see above).

          (defvar *acl2-doc-top-default* 'TOP)

      If you prefer to build rendered-doc-combined.lsp yourself, you can
      do so as follows. For best results, use a directory separate
      from your regular ACL2 installation unless you already are
      using ACL2(h) (see [hons-and-memoization]). Specifically, this
      separation can avoid subsequent problems when trying to include
      [books] with ACL2 that were certified using ACL2(h)).

       1. Build ACL2(h):

              make large ACL2_HONS=h

       2. Build the manual, optionally supplying your \"make\" command with a
          \"-j\" argument. If \"acl2h\" invokes the ACL2(h) executable
          that you just built, then you may omit \"ACL2=acl2h\" below;
          otherwise replace \"acl2h\" by a full pathname for that
          executable.

              cd books
              make all USE_QUICKLISP=1 ACL2_BOOK_CERTS=centaur/doc.cert ACL2=acl2h

       3. Build the file books/system/doc/rendered-doc-combined.lsp as follows,
          still standing in the books directory, perhaps modifying
          \"ACL2=acl2h\" as discussed above.

              cd books
              make all USE_QUICKLISP=1 \\
                ACL2_BOOK_CERTS=system/doc/render-doc-combined.cert ACL2=acl2h")
 (ACL2-HELP
  (ABOUT-ACL2)
  "The acl2-help mailing list

  You can email questions about ACL2 usage to the acl2-help mailing
  list: acl2-help@utlists.utexas.edu. If you have more general
  questions about ACL2, for example, about projects completed using
  ACL2, you may prefer the acl2 mailing list,
  acl2@utlists.utexas.edu, which tends to have wider distribution.")
 (ACL2-NUMBER-LISTP
  (ACL2-BUILT-INS)
  "Recognizer for a true list of numbers

  The predicate acl2-number-listp tests whether its argument is a true
  list of numbers.

  Function: <acl2-number-listp>

    (defun acl2-number-listp (l)
           (declare (xargs :guard t))
           (cond ((atom l) (eq l nil))
                 (t (and (acl2-numberp (car l))
                         (acl2-number-listp (cdr l))))))")
 (ACL2-NUMBERP
  (ACL2-BUILT-INS)
  "Recognizer for numbers

  (acl2-numberp x) is true if and only if x is a number, i.e., a
  rational or complex rational number.")
 (ACL2-SEDAN
  (ACL2-TUTORIAL)
  "ACL2 Sedan interface

  Many successful ACL2 users run in an shell under Emacs; see [emacs].
  However, those not familiar with Emacs may prefer to start with an
  Eclipse-based interface initiallly developed by Peter Dillinger and
  Pete Manolios called the ACL2 Sedan or ``ACL2s''.

  ACL2 sessions in the ACL2 Sedan can utilize non-standard extensions
  and enhancements, especially geared toward new users, termination
  reasoning, and attaching rich user interfaces. These extensions are
  generally available as certifiable ACL2 books. (Some code
  originating from this project has been migrated to the ACL2
  community books, but only after it was quite stable.) Thanks to
  Peter Dillinger, Pete Manolios, Daron Vroon, and Harsh Raju
  Chamarthi for their work on the ACL2 Sedan and for making their
  books available to ACL2 users.")
 (ACL2-TUTORIAL
  (ACL2)
  "Tutorial introduction to ACL2

  To learn about ACL2, read at least the following two links.

    * [Industrial Applications of ACL2] (10 minutes) to help you understand
      what sophisticated users can do;
    * [A Flying Tour] (10 minutes) to get an overview of the system and
      what skills the user must have.

  If you want to learn how to use ACL2, we recommend that you read a
  selection of the materials referenced below, depending on your
  learning style, and do suggested exercises.

    * [A Walking Tour] (1 hour) provides an overview of the theorem prover.
    * The Try ACL2 web site provides interactive lessons to get you started
      using ACL2.
    * [Introduction to the Theorem Prover] (10-40 hours) provides
      instruction on how to interact with the system. Unlike the
      three documents above, this document expects you to think! It
      cites the necessary background pages on programming in ACL2 and
      on the logic and then instructs you in [the-method], which is
      how expert users use ACL2. It concludes with some challenge
      problems for the ACL2 beginner (including solutions) and an
      FAQ. Most users will spend several hours a day for several days
      working through this material.
    * The book Computer-Aided Reasoning: An Approach is worth a careful
      read, as you work exercises and learn [the-method].
    * [Annotated ACL2 Scripts and Demos] contains relatively elementary
      proof scripts that have been annotated to help train the
      newcomer.
    * Many files (``books'') in the ACL2 community books (see
      [community-books]) are extensively annotated.
    * An [Alternative Introduction] document, while largely subsumed by the
      [Introduction to the Theorem Prover] mentioned above, still
      might be useful because it covers much of the tutorial material
      in a different way.

  At this point you are probably ready to use ACL2 on your own small
  projects. A common mistake for beginners is to browse the
  documentation and then try to do something that is too big! Think
  of a very small project and then simplify it!

  Note that ACL2 has a very supportive user network. See the link to
  ``Mailing Lists'' on the ACL2 home page.

  The topics listed below are a hodge podge, developed over time.
  Although some of these are not mentioned above, you might find some
  to be useful as well.


Subtopics

  [ACL2-as-standalone-program]
      Calling ACL2 from another program

  [ACL2-sedan]
      ACL2 Sedan interface

  [Advanced-features]
      Some advanced features of ACL2

  [Alternative-introduction]
      Introduction to ACL2

  [Annotated-ACL2-scripts]
      Examples of ACL2 scripts

  [Emacs]
      Emacs support for ACL2

  [Interesting-applications]
      Some industrial examples of ACL2 use

  [Introduction-to-the-theorem-prover]
      How the theorem prover works -- level 0

  [Nqthm-to-ACL2]
      ACL2 analogues of Nqthm functions and commands

  [Pages_Written_Especially_for_the_Tours]
      Pages Written Especially for the Tours

  [Startup]
      How to start using ACL2; the ACL2 [command] loop

  [The-method]
      How to find proofs

  [Tidbits]
      Some basic hints for using ACL2

  [Tips]
      Some hints for using the ACL2 prover")
 (ACL2-USER
  (PROGRAMMING)
  "A package the ACL2 user may prefer

  This package imports the standard Common Lisp symbols that ACL2
  supports and also a few symbols from package \"ACL2\" that are
  commonly used when interacting with ACL2. You may prefer to select
  this as your current package so as to avoid colliding with ACL2
  system names.

  This package imports the symbols listed in
  *common-lisp-symbols-from-main-lisp-package*, which contains
  hundreds of CLTL function and macro names including those supported
  by ACL2 such as [cons], [car], and [cdr]. It also imports the
  symbols in *acl2-exports*, which contains a few symbols that are
  frequently used while interacting with the ACL2 system, such as
  [implies], [defthm], and [rewrite]. It imports nothing else.

  Thus, names such as [alistp], [member-equal], and [type-set], which
  are defined in the \"ACL2\" package are not present here. If you find
  yourself frequently colliding with names that are defined in \"ACL2\"
  you might consider selecting \"ACL2-USER\" as your current package
  (see [in-package]). If you select \"ACL2-USER\" as the current
  package, you may then simply type [member-equal] to refer to
  acl2-user::member-equal, which you may define as you see fit. Of
  course, should you desire to refer to the \"ACL2\" version of
  [member-equal], you will have to use the \"ACL2::\" prefix, e.g.,
  acl2::member-equal.

  If, while using \"ACL2-USER\" as the current package, you find that
  there are symbols from \"ACL2\" that you wish we had imported into it
  (because they are frequently used in interaction), please bring
  those symbols to our attention. For example, should
  [union-theories] and [universal-theory] be imported? Except for
  stabilizing on the ``frequently used'' names from \"ACL2\", we intend
  never to define a symbol whose [symbol-package-name] is
  \"ACL2-USER\".")
 (ACL2P-KEY-CHECKPOINTS
  (PARALLEL-PROOF)
  "Key checkpoints in ACL2(p)

  This [documentation] topic relates to the experimental extension of
  ACL2 supporting parallel execution and proof; see [parallelism].

  For printing output, the parallel version of the waterfall follows
  the precedent of [gag-mode]. The idea behind gag mode is to print
  only the subgoals most relevant to debugging a failed proof
  attempt. These subgoals are called 'key checkpoints' (see
  [set-gag-mode] for the definition of ``key'' and ``checkpoint''),
  and we restrict the default output mode for the parallel version of
  the waterfall to printing checkpoints similar to these key
  checkpoints.

  As of this writing, we are aware of exactly one discrepancy between
  gag mode's key checkpoints and the parallel version of the
  waterfall's checkpoints. This discrepancy occurs when using ``by''
  hints (see [hints]). As an example, take the following form, which
  attempts to prove a non-theorem:

    (thm (equal (append x y z) (append z (append y x)))
         :hints ((\"Subgoal *1/2'''\" :by nil)))

  With waterfall parallelism enabled, Subgoal *1/2'' will be printed as
  a key checkpoint. This is different from using [gag-mode] while
  running the serial version of the waterfall, which skips printing
  the subgoal as a checkpoint.

  For those familiar with the ACL2 waterfall, we note that that the
  parallel version of the waterfall prints key checkpoints that are
  unproved in the following sense: a subgoal is a key checkpoint if
  it leads, in the current call of the waterfall, to a goal that is
  pushed for induction.


Subtopics

  [Set-waterfall-printing]
      For ACL2(p): configuring the printing that occurs within the
      parallelized waterfall")
 (ACL2S (POINTERS) "See [ACL2-sedan].")
 (ACL2_AS_AN_INTERACTIVE_THEOREM_PROVER
  (PAGES_WRITTEN_ESPECIALLY_FOR_THE_TOURS)
  "ACL2 as an Interactive Theorem Prover

  The ACL2 theorem prover finds proofs in the ACL2 logic. It can be
  automatic. But most often the user must help it.

  {IMAGE}

  The user usually guides ACL2 by suggesting that it first prove key
  lemmas. Lemmas are just theorems used in the proofs of other
  theorems.")
 (ACL2_AS_AN_INTERACTIVE_THEOREM_PROVER_{CONT}
  (PAGES_WRITTEN_ESPECIALLY_FOR_THE_TOURS)
  "ACL2 as an Interactive Theorem Prover (cont)

  [{IMAGE}]

  When ACL2 proves a lemma, it is converted into one or more rules and
  stored in a database. The theorem prover is rule-driven. By proving
  lemmas you can configure ACL2 to behave in certain ways when it is
  trying to prove formulas in a certain problem domain. The expert
  user can make ACL2 do amazingly ``smart'' looking things.

  But it would be wrong to think that ACL2 knows the mathematical
  content of a formula just because it has proved it. What ACL2 knows
  --- all ACL2 knows --- is what is encoded in its rules. There are
  many types of rules (see [rule-classes] [{ICON}]).

  Many formulas can be effectively coded as rules. But by the same
  token, it is possible to encode a formula as a rule that is so
  ineffective it cannot even prove itself!

  The way a formula is stored as a rule is entirely up to the user.
  That is, you determine how ACL2 should use each formula that it
  proves.

  The most common kind of rule is the rewrite rule. It is so common
  that if you don't tell ACL2 how to store a formula, it stores it as
  a rewrite rule.

  [{IMAGE}]")
 (ACL2_CHARACTERS
  (PAGES_WRITTEN_ESPECIALLY_FOR_THE_TOURS)
  "ACL2 Characters

  ACL2 accepts 256 distinct characters, which are the characters
  obtained by applying the function [code-char] [{ICON}] to each
  integer from 0 to 255. Among these, Common Lisp designates certain
  ones as *standard-characters*, namely those of the form (code-char
  n) where n is from 33 to 126, together with #\\Newline and #\\Space.
  The actual standard characters may be viewed by evaluating the
  constant expression *standard-chars*.

  The standard character constants are written by writing a hash mark
  followed by a backslash (#\\) followed by the character.

  The function [characterp] [{ICON}] recognizes characters. For more
  details, See [characters] [{ICON}].")
 (ACL2_CONSES_OR_ORDERED_PAIRS
  (PAGES_WRITTEN_ESPECIALLY_FOR_THE_TOURS)
  "ACL2 Conses or Ordered Pairs

  The function [cons] [{ICON}] creates an ordered pair. [Car] [{ICON}]
  and [cdr] [{ICON}] return the first and second components,
  respectively, of an ordered pair. The function [consp] [{ICON}]
  recognizes ordered pairs.

  Ordered pairs are used to represent lists and trees. See any Common
  Lisp documentation for a discussion of how list constants are
  written and for the many list processing functions available. Also,
  see [programming] [{ICON}] where we list all the ACL2 primitive
  functions.

  Here are some examples of list constants to suggest their syntax.

    '(a . b)                ; a pair whose car is 'a and cdr is 'b
    '(a . nil)              ; a pair whose car is 'a and cdr is nil
    '(a)                    ; another way to write the same thing
    '(a b)                  ; a pair whose car is 'a and cdr is '(b)
    '(a b c)                ; a pair whose car is 'a and cdr is '(b c)
                            ;  i.e., a list of three symbols, a, b, and c.
    '((a . 1) (b . 2))      ; a list of two pairs

  It is useful to distinguish ``proper'' conses from ``improper'' ones,
  the former being those cons trees whose right-most branch
  terminates with nil. A ``true list'' (see [true-listp] [{ICON}]) is
  either nil or a proper cons. (A b c . 7) is an improper cons and
  hence not a true list.")
 (ACL2_IS_AN_UNTYPED_LANGUAGE
  (PAGES_WRITTEN_ESPECIALLY_FOR_THE_TOURS)
  "ACL2 is an Untyped Language

  The example

    ACL2 !>(app '(a b c) 27)
    (A B C . 27)

  illustrates the fact that ACL2's logic is untyped (click [here] for a
  brief discussion of the typed versus untyped nature of the logic).

  The definition of app makes no restriction of the arguments to lists.
  The definition says that if the first argument satisfies [endp]
  [{ICON}] then return the second argument. In this example, when app
  has recursed three times down the cdr of its first argument, '(a b
  c), it reaches the final nil, which satisfies endp, and so 27 is
  returned. It is naturally consed into the emerging list as the
  function returns from successive recursive calls (since cons does
  not require its arguments to be lists, either). The result is an
  ``improper'' list, (a b c . 27).

  You can think of (app x y) as building a binary tree by replacing the
  right-most tip of the tree x with the tree y.")
 (ACL2_STRINGS
  (PAGES_WRITTEN_ESPECIALLY_FOR_THE_TOURS)
  "ACL2 Strings

  Strings of ACL2 [characters] are written as sequences of characters
  delimited by ``double quotation marks'' (\"). To put a double
  quotation mark in a string (or, any other character such as
  backslash or newline that seems to cause problems), escape it by
  preceding it with a backslash (\\).

  The function [stringp] [{ICON}] recognizes strings and [char]
  [{ICON}] will fetch the nth character of a string. There are many
  other primitives for handling strings, such as [string<] [{ICON}]
  for comparing two strings lexicographically. We suggest you See
  [programming] [{ICON}] where we list all of the primitive ACL2
  functions. Alternatively, see any Common Lisp language
  documentation.")
 (ACL2_SYMBOLS
  (PAGES_WRITTEN_ESPECIALLY_FOR_THE_TOURS)
  "ACL2 Symbols

  Common Lisp's symbols are a data type representing words. They are
  frequently regarded as atomic objects in the sense that they are
  not frequently broken down into their constituents. Often the only
  important properties of symbols is that they are not numbers,
  characters, strings, or lists and that two symbols are not equal if
  they look different (!). Examples of symbols include PLUS and
  SMITH::ABC. All function and variable names in ACL2 are symbols.
  When symbols are used as constants they must be quoted, as in
  'PLUS.

  The symbol T is commonly used as the Boolean ``true.'' The symbol NIL
  is commonly used both as the Boolean ``false'' and as the ``empty
  list.'' Despite sometimes being called the ``empty list'' NIL is a
  symbol not an ``empty cons.'' Unlike other symbols, T and NIL may
  be used as constants without quoting them.

  Usually, symbols are written as sequences of alphanumeric characters
  other than those denoting numbers. Thus, A12, +1A and 1+ are
  symbols but +12 is a number. Roughly speaking, when symbols are
  read lower case characters are converted to upper case, so we
  frequently do not distinguish ABC from Abc or abc. Click [here] for
  information about case conversion when symbols are read. However,
  any character can be used in a symbol, but some characters must be
  ``escaped'' to allow the Lisp reader to parse the sequence as a
  symbol. For example, |Abc| is a symbol whose first character is
  capitalized and whose remaining characters are in lower case. |An
  odd duck| is a symbol containing two #\\Space characters. See any
  Common Lisp documentation for the syntactic rules for symbols.

  Technically, a symbol is a special kind of pair consisting of a
  package name (which is a string) and a symbol name (which is also a
  string). (See [symbol-package-name] [{ICON}] and see [symbol-name]
  [{ICON}].) The symbol SMITH::ABC is said to be in package \"SMITH\"
  and to have the symbol name \"ABC\". The symbol ABC in package
  \"SMITH\" is generally not equal to the symbol ABC in package
  \"JONES\". However, it is possible to ``import'' symbols from one
  package into another one, but in ACL2 this can only be done when
  the package is created. (See [defpkg] [{ICON}].) If the
  [current-package] [{ICON}] is \"SMITH\" then SMITH::ABC may be more
  briefly written as just ABC. [Intern] [{ICON}] ``creates'' a symbol
  of a given name in a given package.")
 (ACL2_SYSTEM_ARCHITECTURE
  (PAGES_WRITTEN_ESPECIALLY_FOR_THE_TOURS)
  "ACL2 System Architecture

  [{IMAGE}]

  {IMAGE}

  The user interacts with the theorem prover by giving it definitions,
  theorems and advice. Most often the advice is about how to store
  each proved theorem as a rule. Sometimes the advice is about how to
  prove a specific theorem.

  The database consists of all the rules ACL2 ``knows.'' It is possible
  to include in the database all of the rules in some certified file
  of other events. Such certified files are called [books] [{ICON}].

  Interesting proofs are usually built on top of many books, some of
  which are written especially for that problem domain and others of
  which are about oft-used domains, like arithmetic or list
  processing. ACL2's distribution includes many books written by
  users. See the ``books'' link under the Lemma Libraries and
  Utilities [{ICON}] link of the ACL2 home page.

  [{IMAGE}]")
 (ACONS
  (ACL2-BUILT-INS)
  "Constructor for association lists

  (Acons key datum alist) equals the result of consing the pair (cons
  key datum) to the front of the association list alist.

  (Acons key datum alist) has a [guard] of (alistp alist). Acons is a
  Common Lisp function. See any Common Lisp documentation for more
  information.

  Function: <acons>

    (defun acons (key datum alist)
           (declare (xargs :guard (alistp alist)))
           (cons (cons key datum) alist))")
 (ACTIVE-RUNEP
  (THEORIES)
  "Check that a [rune] exists and is [enable]d

    Example:
    (active-runep '(:rewrite left-to-right))

    General Form:
    (active-runep rune)

  where rune has the shape of a [rune]. This macro expands to an
  expression using the variables ens and state, and returns non-nil
  when the given rune exists and is [enable]d (according to the given
  ``enabled structure,'' ens, and the current logical [world] of the
  given [state]). See [theory-invariant] for how this macro can be of
  use.")
 (ADD-BINOP
  (SWITCHES-PARAMETERS-AND-MODES)
  "Associate a function name with a macro name

  The form (add-binop macro macro-fn) is an abbreviation for the form
  (add-macro-fn macro macro-fn t). See [add-macro-fn].")
 (ADD-CUSTOM-KEYWORD-HINT
  (EVENTS)
  "Add a new custom keyword hint

    Examples:
    (add-custom-keyword-hint :my-hint (my-hint-fn val ...))

    (add-custom-keyword-hint :my-hint
                             (my-hint-fn val ...)
                             :checker (my-hint-checker-fn val ...))

    General Form:
    (add-custom-keyword-hint :key term1 :checker term2)

  where :key is a [keywordp] not among the primitive keyword hints
  listed in *hint-keywords*, the :checker argument is optional, and
  term1 and (if supplied) term2 are terms with certain free-variable
  and signature restrictions described below. Henceforth, :key is
  treated as a custom keyword hint, e.g., the user can employ :key in
  hints to [defthm], such as:

    (defthm name ...
      :hints ((\"Subgoal *1/1'\" ... :key val ...))).

  Custom keyword hints are complicated. To use them you must understand
  [state], multiple values (e.g., [mv] and [mv-let]), ACL2's notion
  of error triples (see [programming-with-state]), how to generate
  ``soft'' errors with [er], how to use [fmt]-strings to control
  output, how to use computed hints (see [computed-hints]) and some
  aspects of ACL2's internal event processing. Furthermore, it is
  possible to implement a custom keyword hint that can make an event
  non-reproducible! So we recommend that these hints be developed by
  ACL2 experts. Basically the custom keyword feature allows the
  implementors and other experts to extend the hint facility without
  modifying the ACL2 sources.

  Term1 is called the ``generator'' term and term2 is called the
  ``checker'' term of the custom keyword hint :key. Together they
  specify the semantics of the new custom keyword hint :key. Roughly
  speaking, when a custom keyword hint is supplied by the user, as in

    (defthm name ...
      :hints ((\"Subgoal *1/1'\" ... :my-hint val ...))).

  the checker term is evaluated on val to check that val is of the
  expected shape. Provided val passes the check, the generator term
  is used to compute a standard hint. Like computed hints, the
  generator of a custom keyword hint is allowed to inspect the actual
  clause on which it is being fired. Indeed, it is allowed to inspect
  the entire list of hints (standard and custom) supplied for that
  clause. Thus, in the most general case, a custom keyword hint is
  just a very special kind of computed hint.

  The generator, term1, must have no free variables other than:

    (val keyword-alist
     id clause world stable-under-simplificationp
     hist pspv ctx state).

  Moreover, either term1 must evaluate to a single non-[stobj] value,
  or else it must be single-threaded in state and have the standard
  error-triple output signature, (mv * * state).

  The restrictions on the checker, term2, are that it be
  single-threaded in state, have the standard error-triple output
  signature, (mv * * state), and have no free variables other than:

    (val world ctx state).

  For examples, see the community books directory books/hints/, in
  particular basic-tests.lisp.

  To delete a previously added custom keyword hint, see
  [remove-custom-keyword-hint].

  The community book hints/merge-hint.lisp can be useful in writing
  custom keyword hints. See the examples near the of the file.

  Note: This is an event! It does not print the usual event summary but
  nevertheless changes the ACL2 logical [world] and is so recorded.")
 (ADD-DEFAULT-HINTS
  (SWITCHES-PARAMETERS-AND-MODES USING-COMPUTED-HINTS)
  "Add to the default hints

    Examples:
    (add-default-hints '((computed-hint-1 clause)
                         (computed-hint-2 clause
                                          stable-under-simplificationp)))
    (add-default-hints '((computed-hint-3 id clause world))
                       :at-end t)

  Note: This is an event! It does not print the usual event summary but
  nevertheless changes the ACL2 logical [world] and is so recorded.
  It is [local] to the book or [encapsulate] form in which it occurs
  (see [add-default-hints!] for a corresponding non-[local] event).

    General Forms:
    (add-default-hints lst)
    (add-default-hints lst :at-end flg)

  where lst is a list. Generally speaking, the elements of lst should
  be suitable for use as [computed-hints].

  This event is completely analogous to [set-default-hints], the
  difference being that add-default-hints appends the indicated hints
  to the front of the list of default hints, so that they are tried
  first --- or, if flg is supplied and evaluates to other than nil,
  at the end of the list, so that they are tried last --- rather than
  replacing the default hints with the indicated hints. Each new hint
  is thus considered after each existing hints when both are applied
  to the same goal. Also See [set-default-hints], see
  [remove-default-hints], and see [default-hints].

  Finally, note that the effects of set-default-hints,
  [add-default-hints], and [remove-default-hints] are [local] to the
  book in which they appear. Thus, users who include a book with such
  forms will not have their default hints affected by such forms. In
  order to export the effect of setting the default hints, use
  [set-default-hints!], [add-default-hints!], or
  [remove-default-hints!].

  For a related feature, which however is only for advanced system
  builders, see [override-hints].")
 (ADD-DEFAULT-HINTS!
  (SWITCHES-PARAMETERS-AND-MODES)
  "Add to the default hints non-[local]ly

  Please see [add-default-hints], which is the same as
  add-default-hints! except that the latter is not [local] to the
  [encapsulate] or the book in which it occurs. Probably
  [add-default-hints] is to be preferred unless you have a good
  reason for wanting to export the effect of this event outside the
  enclosing [encapsulate] or book.")
 (ADD-DIVE-INTO-MACRO
  (SWITCHES-PARAMETERS-AND-MODES)
  "Associate [proof-checker] diving function with macro name

    Examples:
    (add-dive-into-macro cat expand-address-cat)

  This feature is used so that the [proof-checker]'s DV command and
  numeric diving commands (e.g., 3) will dive properly into subterms.
  Please see [dive-into-macros-table].")
 (ADD-INCLUDE-BOOK-DIR
  (SWITCHES-PARAMETERS-AND-MODES)
  "Link keyword for :dir argument of [ld] and [include-book]

    Example Forms:

    ; For (include-book \"foo\" :dir :smith), prepend \"/u/smith/\" to \"foo\".
    (add-include-book-dir :smith \"/u/smith/\")

    ; For (include-book \"bar\" :dir :util), prepend absolute directory pathname
    ; corresponding to the relative pathname, \"utilities/\".
    (add-include-book-dir :util \"utilities\")

  Note: This is an event! It does not print the usual event summary but
  nevertheless changes the ACL2 logical [world] and is so recorded.
  It is [local] to the book or [encapsulate] form in which it occurs.
  See [add-include-book-dir!] for a corresponding non-[local] event.

    General Form:
    (add-include-book-dir kwd dir)

  where kwd is a [keywordp] and dir is a relative or absolute
  [pathname] for a directory. (If the final '/' is missing, ACL2 will
  add it for you.) The effect of this event is to modify the meaning
  of the :dir keyword argument of [include-book] or [ld] as indicated
  by the examples above, that is, by associating the indicated
  directory with the indicated keyword for purposes of the :dir
  argument. By the ``indicated directory'' we mean, in the case that
  the pathname is a relative pathname, the directory relative to the
  current connected book directory; see [cbd]. See
  [delete-include-book-dir] for how to undo this effect.

  For a keyword already associated with a directory string by a
  previous invocation of add-include-book-dir or
  [add-include-book-dir!], it is illegal to associate a different
  directory string until removing the existing association; see
  [delete-include-book-dir] (and see [delete-include-book-dir!] if
  the existing association was made by [add-include-book-dir!]. If
  however the new directory string is identical with the existing
  one, which was already assigned by add-include-book-dir, then the
  new call of add-include-book-dir will be redundant (see
  [redundant-events]).

  The keyword :system can never be redefined. It will always point to
  the absolute pathname of the system books directory, which by
  default is immediately under the directory where the ACL2
  executable was originally built (see [include-book], in particular
  the discussion there of ``books directory'').

  This macro is essentially a call (table acl2-defaults-table
  :include-book-dir-alist ...), and hence is [local] to any [books]
  and [encapsulate] [events] in which it occurs. See
  [ACL2-defaults-table]. Even if you invoke add-include-book-dir
  before certifying a book, so that this event is among the book's
  [portcullis] commands rather than in the book itself, nevertheless
  that add-include-book-dir event will not be visible after the book
  is included. If you want the effect to persist outside the book,
  see [add-include-book-dir!].

  It is actually illegal to update the [ACL2-defaults-table] directly
  with a new :include-book-dir-alist value; instead, use
  add-include-book-dir and delete-include-book-dir. This restriction
  allows ACL2 to function appropriately while including sub-books and
  in raw-mode (see [set-raw-mode]), where the associations of
  keywords to directories are stored outside the usual tables. Upon
  exit from raw-mode, all effects disappear that were made by
  add-include-book-dir, [add-include-book-dir!],
  [delete-include-book-dir], or [delete-include-book-dir!].")
 (ADD-INCLUDE-BOOK-DIR!
  (SWITCHES-PARAMETERS-AND-MODES)
  "Non-[local]ly link keyword for :dir argument of [ld] and
  [include-book]

  Please see [add-include-book-dir], which has completely analogous
  syntax and semantics, except that add-include-book-dir! is not
  [local] to the [encapsulate] or the book in which it occurs.
  Probably [add-include-book-dir] is to be preferred unless you have
  a good reason for wanting to export the effect of this event
  outside the enclosing [encapsulate] or book.

  Note: This is an event! It does not print the usual event summary but
  nevertheless changes the ACL2 logical [world] and is so recorded.

  This macro is essentially a [table] event that updates the table
  include-book-dir!-table, which associates keywords with absolute
  pathnames. However, as with [add-include-book-dir], direct table
  updates are disallowed; you must use add-include-book-dir! to add
  to the table and [delete-include-book-dir!] to remove from the
  table.

  It is illegal to call add-include-book-dir! in a [local] context. (If
  you are tempted to do that, consider using [add-include-book-dir]
  instead.) To understand this restriction, imagine a book that
  contains the following sequence of [events].

    (add-include-book-dir! :my-dir \"path/to/BAD/dir\")
    (local (delete-include-book-dir! :my-dir))
    (local (add-include-book-dir! :my-dir \"path/to/GOOD/dir\"))
    (include-book \"foo\" :dir :my-dir)
    (defthm f-def
      (equal (f x) x))

  During the first (proof) pass of [certify-book], the book
  path/to/GOOD/dir/foo.lisp will be included. But on the second pass,
  the book path/to/BAD/dir/foo.lisp will be included. Now imagine
  that the ``good'' version contains the event (defun f (x) x) but
  the ``bad'' version instead contains the event (defun f (x) (not
  x)). Then we can easily prove nil from the theorem f-def! Although
  it is likely that checksums will catch this error at [include-book]
  time, we prefer not to rely on checksums for soundness.")
 (ADD-INVISIBLE-FNS
  (SWITCHES-PARAMETERS-AND-MODES)
  "Make some unary functions invisible to the [loop-stopper] algorithm

    Examples:
    (add-invisible-fns binary-+ unary-- foo)
    (add-invisible-fns + unary-- foo)

  Each of the [events] above makes unary functions [unary--] and foo
  ``invisible'' for the purposes of applying permutative :[rewrite]
  rules to [binary-+] trees. Thus, arg and (unary-- arg) will be
  given the same weight and will be permuted so as to be adjacent.

    General Form:
    (add-invisible-fns top-fn unary-fn1 ... unary-fnk)

  where top-fn is a function symbol and the unary-fni are unary
  function symbols, or more generally, these are all macro aliases
  for function symbols (see [macro-aliases-table]).

  For more information see [invisible-fns-table]. Also see
  [set-invisible-fns-table], which explains how to set the entire
  table in a single event, and see [remove-invisible-fns].")
 (ADD-LD-KEYWORD-ALIAS (POINTERS)
                       "See [ld-keyword-aliases].")
 (ADD-LD-KEYWORD-ALIAS! (POINTERS)
                        "See [ld-keyword-aliases].")
 (ADD-MACRO-ALIAS
  (MACROS SWITCHES-PARAMETERS-AND-MODES)
  "Associate a function name with a macro name

    Example:
    (add-macro-alias append binary-append)

  This example associates the function symbol [binary-append] with the
  macro name [append]. As a result, the name [append] may be used as
  a runic designator (see [theories]) by the various theory
  functions. See [macro-aliases-table] for more details. Also see
  [add-macro-fn] for an extension of this utility that also affects
  printing.

    General Form:
    (add-macro-alias macro-name function-name)

  This is a convenient way to add an entry to [macro-aliases-table].
  See [macro-aliases-table] and also see [remove-macro-alias].")
 (ADD-MACRO-FN
  (MACROS SWITCHES-PARAMETERS-AND-MODES)
  "Associate a function name with a macro name

    Examples:
    (add-macro-fn append binary-append)
    (add-macro-fn append binary-append t)

  These examples each associate the function symbol [binary-append]
  with the macro name [append]. As a result, theory functions will
  understand that append refers to binary-append --- see
  [add-macro-alias] --- and moreover, proof output will be printed
  using append rather than binary-append. In the first case, (append
  x (append y z)) is printed rather than (append x y z). In the
  second case, right-associated arguments are printed flat: (append x
  y z). Such right-association is considered only for binary function
  symbols; otherwise the optional third argument is ignored.

    General Forms:
    (add-macro-fn macro-name function-name)
    (add-macro-fn macro-name function-name nil) ; same as above
    (add-macro-fn macro-name function-name t)

  This is a convenient way to add an entry to [macro-aliases-table] and
  at the same time extend the [untrans-table]. As suggested by the
  example above, calls of a function in this table will be printed as
  corresponding calls of macros, with right-associated arguments
  printed flat in the case of a binary function symbol if the
  optional third argument is t. In that case, for a binary function
  symbol fn associated with macro name mac, then a call (fn arg1 (fn
  arg2 (... (fn argk arg)))) will be displayed to the user as though
  the ``term'' were (mac arg1 arg2 ... argk arg). For a call (f a1
  ... ak) of a function symbol that is not binary, or the optional
  argument is not supplied as t, then the effect is simply to replace
  f by the corresponding macro symbol. See [add-macro-alias], which
  is invoked on the first two arguments. Also see
  [remove-macro-alias], see [untrans-table], and see
  [remove-macro-fn].")
 (ADD-MATCH-FREE-OVERRIDE
  (SWITCHES-PARAMETERS-AND-MODES)
  "Set :match-free value to :once or :all in existing rules

    Example Forms:
    (add-match-free-override :once t)
        ; Try only the first binding of free variables when relieving hypotheses
        ; of any rule of class :rewrite, :linear, or :forward-chaining.
    (add-match-free-override :all (:rewrite foo) (:rewrite bar))
        ; For rewrite rules foo and bar, try all bindings of free variables when
        ; relieving hypotheses.
    (add-match-free-override :clear)
        ; Restore :match-free to what was originally stored for each rule (either
        ; :all or :once).

  As described elsewhere (see [free-variables]), a [rewrite], [linear],
  or [forward-chaining] rule may have free variables in its
  hypotheses, and ACL2 can be directed either to try all bindings
  (``:all'') or just the first (``:once'') when relieving a
  hypothesis, as a basis for relieving subsequent hypotheses. This
  direction is generally provided by specifying either :match-free
  :once or :match-free :all in the :[rule-classes] of the rule, or by
  using the most recent [set-match-free-default] event. Also see
  [rule-classes].

  However, if a proof is going slowly, you may want to modify the
  behavior of some such rules so that they use only the first match
  for free variables in a hypothesis when relieving subsequent
  hypotheses, rather than backtracking and trying additional matches
  as necessary. (But note: add-match-free-override is not relevant
  for [type-prescription] rules.) The event (add-match-free-override
  :once t) has that effect. Or at the other extreme, perhaps you want
  to specify all rules as :all rules except for a some specific
  exceptions. Then you can execute (add-match-free-override :all t)
  followed by, say, (add-match-free-override :once (:rewrite foo)
  (:linear bar)).

    General Forms:
    (add-match-free-override :clear)
    (add-match-free-override flg t)
    (add-match-free-override flg rune1 rune2 ... runek)

  where flg is :once or :all and the runei are [rune]s. If :clear is
  specified then all rules will have the :all/:once behavior from
  when they were first stored. The second general form causes all
  [rewrite] [linear], and [forward-chaining] rules to have the
  behavior specified by flg (:all or :once). Finally, the last of
  these, where runes are specified, is additive in the sense that
  only the indicated rules are affected; all others keep the behavior
  they had just before this event was executed (possible because of
  earlier add-match-free-override events).

  At the conclusion of this event, ACL2 prints out the list of all
  :[linear], :[rewrite], and :[forward-chaining] runes whose rules
  contain free variables in hypotheses that are to be bound :once,
  except that if there are no overrides (value :clear was used), then
  :clear is printed.

  This event only affects rules that exist at the time it is executed.
  Future rules are not affected by the override.

  Note: This is an event! It does not print the usual event summary but
  nevertheless changes the ACL2 logical [world] and is so recorded.
  It uses the [ACL2-defaults-table], and hence its effect is [local]
  to the book or [encapsulate] form in which it occurs.

  Remarks

  Lists of the :[rewrite], :[linear], and :[forward-chaining] [rune]s
  whose behavior was originally :once or :all are returned by the
  following forms, respectively.

    (free-var-runes :once (w state))
    (free-var-runes :all  (w state))

  The form

    (match-free-override (w state))

  evaluates to a pair, whose [car] is a number used by ACL2 to
  determine whether a [rune] is sufficiently old to be affected by
  the override, and whose [cdr] is the list of [rune]s whose behavior
  is specified as :once by add-match-free-override; except, if no
  runes have been overridden, then the keyword :clear is returned.")
 (ADD-NTH-ALIAS
  (SWITCHES-PARAMETERS-AND-MODES)
  "Associate one symbol with another for printing of [nth]/[update-nth]
  terms

    Example:
    (add-nth-alias st0 st)

  This example associates the symbol st0 with the symbol st for
  purposes of printing certain terms of the form (nth n st0) and
  (update-nth n val st0).

    General Form:
    (add-nth-alias alias-name name)

  This is a convenient way to add an entry to [nth-aliases-table]. See
  [nth-aliases-table] and also see [remove-nth-alias].")
 (ADD-OVERRIDE-HINTS
  (SWITCHES-PARAMETERS-AND-MODES OVERRIDE-HINTS)
  "Add to the [override-hints]

  See [override-hints] for a discussion of override-hints. Here we
  describe how to extend the list of override-hints. Note that the
  effects of add-override-hints [events] are [local] to the [books]
  or encapsulate [events] in which they reside; see
  [add-override-hints!] to avoid that restriction. Also see
  [set-override-hints] to set a new list of override-hints to it,
  ignoring the present list rather than adding to it.

    General Forms:
    (add-override-hints form)
    (add-override-hints form :at-end t)
    (add-override-hints form :at-end nil) ; default for :at-end

  where form evaluates to a list of computed hint forms. The effect of
  this event is to extend the current list of [override-hints] by
  appending the result of that evaluation. The default is to append
  the evaluation result to the front of the current list of
  override-hints, but if :at-end t is specified, then the evaluation
  result is appended to the end of the current list.")
 (ADD-OVERRIDE-HINTS!
  (SWITCHES-PARAMETERS-AND-MODES OVERRIDE-HINTS)
  "Add non-[local]ly to the [override-hints]

  Add-override-hints! is the same as [add-override-hints], except that
  the former is not [local] to [books] or [encapsulate] [events] in
  which it occurs. See [add-override-hints]; also see
  [set-override-hints].")
 (ADD-RAW-ARITY
  (SET-RAW-MODE)
  "Add arity information for raw mode

  Technical note: This macro is a no-op, and is not necessary, when
  ACL2 is built with #-acl2-mv-as-values.

  Users of raw mode (see [set-raw-mode]) can use arbitrary raw Lisp
  functions that are not known inside the usual ACL2 loop. In such
  cases, ACL2 may not know how to display a multiple value returned
  by ACL2's [mv] macro. The following example should make this clear.

    ACL2 P>(defun foo (x y) (mv y x))
    FOO
    ACL2 P>(foo 3 4)

    Note: Unable to compute number of values returned by this evaluation
    because function FOO is not known in the ACL2 logical world.  Presumably
    it was defined in raw Lisp or in raw mode.  Returning the first (perhaps
    only) value for calls of FOO.
    4
    ACL2 P>(add-raw-arity foo 2)
     RAW-ARITY-ALIST
    ACL2 P>(foo 3 4)
    (4 3)
    ACL2 P>

  The first argument of add-raw-arity should be a symbol, representing
  the name of a function, macro, or special form, and the second
  argument should either be a non-negative integer (denoting the
  number of values returned by ACL2) or else the symbol :LAST,
  meaning that the number of values returned by the call is the
  number of values returned by the last argument.

  The current arity assignments can be seen by evaluating (@
  raw-arity-alist). See [remove-raw-arity] for how to undo a call of
  add-raw-arity.")
 (ADD-TO-SET
  (ACL2-BUILT-INS)
  "Add a symbol to a list

    General Forms:
    (add-to-set x lst)
    (add-to-set x lst :test 'eql)   ; same as above (eql as equality test)
    (add-to-set x lst :test 'eq)    ; same, but eq is equality test
    (add-to-set x lst :test 'equal) ; same, but equal is equality test

  For a symbol x and an object lst, (add-to-set-eq x lst) is the result
  of [cons]ing x on to the front of lst, unless x is already a
  [member] of lst, in which case the result is lst. The optional
  keyword, :TEST, has no effect logically, but provides the test
  (default [eql]) used for comparing x with successive elements of
  lst.

  The [guard] for a call of add-to-set depends on the test. In all
  cases, the second argument must satisfy [true-listp]. If the test
  is [eql], then either the first argument must be suitable for [eql]
  (see [eqlablep]) or the second argument must satisfy
  [eqlable-listp]. If the test is [eq], then either the first
  argument must be a symbol or the second argument must satisfy
  [symbol-listp].

  See [equality-variants] for a discussion of the relation between
  add-to-set and its variants:

      (add-to-set-eq x lst) is equivalent to (add-to-set x lst :test 'eq);

      (add-to-set-equal x lst) is equivalent to (add-to-set x lst :test
      'equal).

  In particular, reasoning about any of these primitives reduces to
  reasoning about the function add-to-set-equal.")
 (ADD-TO-SET-EQ (POINTERS)
                "See [add-to-set].")
 (ADD-TO-SET-EQL (POINTERS)
                 "See [add-to-set].")
 (ADD-TO-SET-EQUAL (POINTERS)
                   "See [add-to-set].")
 (ADVANCED-FEATURES
  (ACL2-TUTORIAL)
  "Some advanced features of ACL2

  Maybe you've been using ACL2 for awhile, and you wonder if there are
  lesser-known features that you might find useful. Then this topic
  is for you. We present below a ``laundry list'' of some such
  features, with brief descriptions and links to [documentation]
  topics.

  Although the list below is long, it is not intended to be complete,
  and indeed some topics have been deliberately excluded. Some have
  fallen out of use, perhaps for good reason, such as [nu-rewriter]
  and [obdd]. Others are already likely to be discovered when needed,
  such as [getenv$] and perhaps [double-rewrite]. Some topics are
  referenced by documentation for others in the list, such as [mbt],
  which is referenced by [mbe]. Some utilities such as [pstack] and
  [verbose-pstack] seem too low-level to be worthy of inclusion
  below.

  For an extensive introduction to using the prover, which may include
  some aspects new to you, see [introduction-to-the-theorem-prover].
  A shorter topic contains highlights for efficient prover usage: see
  [tips]. Also see [ACL2-sedan] for an extension of ACL2 (written by
  others), ACL2s, that includes an Eclipse-based interface, more
  powerful and automatic termination reasoning, and other features.

  We now move on to the list.

    ========================================
    Top-level commands and utilities:
    ========================================

      o See [a!] and see [p!] to abort or pop.

      o See [ACL2-customization] for initial commands to run at startup.

      o See [keyword-commands] for how keyword commands are processed.

      o See [ld] for many ways to control the top-level loop.

      o See [compilation] for a discussion of set-compiler-enabled and
      other compiler-related utilities.

      o For useful reader macros `#!', `#.', and `#u', see
      [sharp-bang-reader], see [sharp-dot-reader], and see
      [sharp-u-reader].

      o To save and use an ACL2 executable, see
      [ACL2-as-standalone-program] and see [save-exec].

      o For utilities related to timing, see [time$], see
      [with-prover-time-limit], see [with-prover-step-limit], and see
      [set-prover-step-limit].

      o To query and manage the database, see [history] (which discusses
      many useful utilities, such as :[pbt] and :[pl]), and see
      [dead-events].

      o See [add-include-book-dir] for linking keyword for :dir argument of
      [ld] and [include-book].

      o See [rebuild] for a fast way to load a file without waiting for
      proofs.

      o For parallel certification, see [books-certification] for use of
      the -j option of `make'; also see [provisional-certification].

    ========================================
    Some relatively less common events:
    ========================================

      o See [reset-prehistory] to reset the prehistory.

      o See [assert-event] to assert that a given form returns a non-nil
      value.

      o See [defattach] to execute constrained functions using
      corresponding attached functions.

      o See [defun-sk] to define a function whose body has an outermost
      quantifier.

      o See [defchoose] to define a Skolem (witnessing) function.

      o For efficiency consider using defconst-fast; see [defconst].

      o See [set-verify-guards-eagerness] to specify when [guard]
      verification is tried by default.

    ========================================
    Output and its control (see [io] for additional information):
    ========================================

      o See [with-output] to suppress or turn on specified output for an
      event.

      o See [evisc-table] for support for abbreviated output.

      o See [nth-aliases-table] for a table used to associate names for
      [nth]/[update-nth] printing.

      o See [output-to-file] to redirect output to a file.

      o See [print-control] to control ACL2 printing.

      o See [set-evisc-tuple] to control suppression of details when
      printing.

      o See [set-inhibit-output-lst] to control output by type.

      o See [set-iprint] to allow abbreviated output to be read back in.

      o See [set-print-base] to control the radix in which numbers are
      printed.

      o See [set-print-radix] to control whether the radix of a number is
      printed.

      o See [set-print-case] to control whether symbols are printed in
      upper case or in lower case.

    ========================================
    On proving termination for definitions:
    ========================================

      o See [ordinals] for a discussion of ordinals in ACL2.

      o See [ruler-extenders] for a control on ACL2's termination and
      induction analyses.

      o See [set-well-founded-relation] to set the default well-founded
      relation for termination analysis.

      o See [ACL2-sedan] for a related tool that provides extra automation
      for termination proofs.

    ========================================
    Proof debugging and output control:
    ========================================

      o See [accumulated-persistence] to get statistics on which runes are
      being tried.

      o See [add-macro-fn] and see [add-macro-alias] to associate a
      function name with a macro name.

      o See [break-rewrite] for how to monitor rewrite rules.

      o See [dmr] for dynamic monitoring of rewriting and other prover
      activity.

      o See [forward-chaining-reports] to see reports about the forward
      chaining process.

      o See [guard-debug] to generate markers to indicate sources of
      [guard] proof obligations.

      o See [proof-checker] for support for low-level interaction.

      o See [redo-flat] for redo on failure of a [progn], [encapsulate], or
      [certify-book].

      o See [set-gag-mode] and see [pso] to abbreviate or restore proof
      output.

      o See [set-inhibit-output-lst], see [set-inhibit-warnings], and see
      [set-inhibited-summary-types] to inhibit various types of
      output.

      o See [set-raw-proof-format] to make proof output display lists of
      [rune]s.

      o See [skip-proofs] to skip proofs for a given form.

    ========================================
    Program debugging:
    ========================================

      o See [break$] to cause an immediate Lisp break.

      o See [break-on-error] to break when encountering a hard or soft
      error caused by ACL2.

      o See [disassemble$] to disassemble a function.

      o See [print-gv] to print a form whose evaluation caused a guard
      violation.

      o See [profile] to turn on profiling for one function.

      o See [trace$] and see [open-trace-file] to [trace] function
      evaluations, possibly sending trace output to a file.

      o See [wet] to evaluate a form and print a subsequent error trace.

    ========================================
    Programming and evaluation idioms, support, utilities (also see [programming]
    for more utilities, e.g., [random$])
    ========================================

      o See [arrays] and See [defstobj] for introductions to ACL2 arrays
      and single-threaded objects (stobjs), respectively, each of
      which provides efficient destructive operations in an
      applicative setting. Also see [with-local-stobj] for a way to
      create local stobjs.

      o See [assert$] to cause a hard error if the given test is false.

      o See [canonical-pathname] to obtain the true absolute filename, with
      soft links resolved.

      o See [case-match] for a utility providing pattern matching and
      destructuring.

      o See [defpun] to define a tail-recursive function symbol.

      o See [ec-call] to execute a call in the ACL2 logic instead of raw
      Lisp.

      o See [er] to print an error message and ``cause an error''.

      o See [flet] to provide local binding of function symbols.

      o See [gc$] to invoke the garbage collector.

      o See [mbe] to attach code for execution.

      o See [mv-list] to convert a multiple-valued result to a
      single-valued list.

      o See [mv?] to return one or more values.

      o For non-executable code, see [defun-nx] and see [non-exec].

      o See [prog2$] and see [progn$] to execute two or more forms and
      return the value of the last one.

      o See [programming-with-state] for how to program using the von
      Neumannesque ACL2 [state] object.

      o See [top-level] to evaluate a top-level form as a function body.

      o See [with-guard-checking] to suppress or enable guard-checking for
      a form.

      o For ways to fake access to the state see [wormhole], see
      [with-local-state], see [cw], see [cw!], see
      [printing-to-strings], see [observation-cw], and (dangerous!)
      see [with-live-state].

    ========================================
    Connecting with the underlying host Lisp, and doing other evil:
    ========================================

      o See [defttag] to introduce a trust tag (ttag).

      o See [defmacro-last] to define a macro that returns its last
      argument, but with side effects.

      o See [progn!] to evaluate forms that are not necessarily [events].

      o See [return-last] to return the last argument, perhaps with side
      effects.

      o See [set-raw-mode] to enter or exit ``raw mode,'' a raw Lisp
      environment.

      o See [sys-call] to make a system call to the host operating system.

    ========================================
    Macros and related utilities:
    ========================================

      o See [defabbrev] for a convenient form of macro definition for
      simple expansions.

      o See [macro-args] for the formals list of a macro definition (see
      [defmacro]).

      o See [make-event] for a sort of extension of [defmacro] that allows
      access to the [state], by evaluating (expanding) a given form
      and then evaluate the result of that expansion.

      o See [trans], see [trans!], and see [trans1] to print the
      macroexpansion of a form.

    ========================================
    Experimental extensions:
    ========================================

      o See [hons-and-memoization] for ACL2(h); in particular, see
      [memoize] for efficient function memoization and see [profile]
      for profiling.

      o See [real] for ACL2(r), which supports the real numbers.

      o See [parallelism] for ACL2(p), which supports parallel evaluation
      and proof.

    ========================================
    Database control and query:
    ========================================

      o See [disabledp] to determine whether a given name or rune is
      disabled.

      o For redefinition support see [redef], see [redef!], see [redef+],
      see [redef-], and see [redefined-names].

      o See [table] for user-managed tables.

      o See [verify-guards-formula] to view a guard proof obligation
      without doing the proof.

    ========================================
    Prover control
    ========================================

      o For congruence-based reasoning see [defcong], see [congruence], see
      [equivalence], see [defequiv], and see [defrefinement].

      o For meta rules and clause processors see [meta], see
      [defevaluator], see [clause-processor], see
      [define-trusted-clause-processor] (for connecting with external
      tools, such as SAT solvers), and See [extended-metafunctions]
      (for [state] and context-sensitive metafunctions).

      o For theory control, see [theories] for detailed information, but in
      particular see [deftheory], see [theory-functions], see
      [in-arithmetic-theory] (and see [non-linear-arithmetic]), and
      see [theory-invariant].

      o See [hints] for a complete list of prover hints, including some of
      the more obscure ones such as :restrict, :[clause-processor],
      :nonlinearp, :backchain-limit-rw, :reorder, and :backtrack.
      Also see [hints-and-the-waterfall] for an explanation of how
      hints interact with the ACL2 proof process. For other topics
      related to hints, see [override-hints], see
      [add-custom-keyword-hint], see [default-hints], and see
      [computed-hints] and [using-computed-hints].

      o See [bind-free] to bind [free-variables] of a [rewrite] or [linear]
      rule.

      o See [case-split] for a utility like [force] that immediately splits
      the top-level goal on the indicated hypothesis.

      o See [case-split-limitations] for a way to the number of cases
      produced at once

      o See [default-backchain-limit] to specify the backchain limit for a
      rule.

      o See [force] for an identity function used to force a hypothesis.

      o See [otf-flg] for a way to push more than one initial subgoal for
      induction.

      o See [rule-classes] to add various kinds of rules to the database,
      including more unusual sorts such as :[built-in-clause] rules
      and :[induction] rules.

      o See [set-backchain-limit] to set the backchain-limit used by the
      type-set and rewriting mechanisms.

      o See [set-body] to set an alternate definition body for :expand
      [hints].

      o See [set-rewrite-stack-limit] to set the [rewrite] stack depth used
      by the rewriter.

      o See [syntaxp] to attach a heuristic filter on a :[rewrite],
      :[meta], or :[linear] rule.")
 (ALISTP
  (ACL2-BUILT-INS)
  "Recognizer for association lists

  (alistp x) is true if and only if x is a list of [cons] pairs.

  (alistp x) has a [guard] of t.

  Definition: <alistp>

    (table acl2-defaults-table :defun-mode :logic)")
 (ALLOCATE-FIXNUM-RANGE
  (ACL2-BUILT-INS)
  "Set aside fixnums in GCL

  (Allocate-fixnum-range fixnum-lo fixnum-hi) causes Gnu Common Lisp
  (GCL) to create a persistent table for the integers between
  fixnum-lo and fixnum-hi (both bounds inclusive). This table is
  referenced first when any integer is boxed and the existing box in
  the table is used if the integer is in bounds. This can speed up
  GCL considerably by avoiding wasteful fixnum boxing. Here,
  fixnum-lo and fixnum-hi should be fixnums. On 32-bit machines it
  would be good for them to be of type (signed-byte 30), with
  fixnum-lo <= fixnum-hi.

  When this function is executed in a Lisp implementation other than
  GCL, it has no side effect. This function always returns nil.")
 (ALPHA-CHAR-P
  (ACL2-BUILT-INS)
  "Recognizer for alphabetic characters

  (Alpha-char-p x) is true if and only if x is a alphabetic character,
  i.e., one of the [characters] #\\a, #\\b, ..., #\\z, #\\A, #\\B, ...,
  #\\Z.

  The [guard] for alpha-char-p requires its argument to be a character.

  Alpha-char-p is a Common Lisp function. See any Common Lisp
  documentation for more information.

  Function: <alpha-char-p>

    (defun alpha-char-p (x)
           (declare (xargs :guard (characterp x)))
           (and (member x
                        '(#\\a #\\b #\\c
                              #\\d #\\e #\\f #\\g #\\h #\\i #\\j #\\k #\\l #\\m
                              #\\n #\\o #\\p #\\q #\\r #\\s #\\t #\\u #\\v #\\w
                              #\\x #\\y #\\z #\\A #\\B #\\C #\\D #\\E #\\F #\\G
                              #\\H #\\I #\\J #\\K #\\L #\\M #\\N #\\O #\\P #\\Q
                              #\\R #\\S #\\T #\\U #\\V #\\W #\\X #\\Y #\\Z))
                t))")
 (ALPHORDER
  (ACL2-BUILT-INS)
  "Total order on atoms

  Alphorder is a non-strict total order, a ``less than or equal,'' on
  atoms. By ``non-strict total order'' we mean a function that always
  returns t or nil and satisfies the following properties.

      o Antisymmetry: XrY & YrX -> X=Y

      o Transitivity: XrY & YrZ -> XrZ

      o Trichotomy: XrY v YrX

  Also see [lexorder], which extends alphorder to all objects.

  (Alphorder x y) has a guard of (and (atom x) (atom y)).

  Within a single type: rationals are compared arithmetically, complex
  rationals are compared lexicographically, characters are compared
  via their char-codes, and strings and symbols are compared with
  alphabetic ordering. Across types, rationals come before complexes,
  complexes come before characters, characters before strings, and
  strings before symbols. We also allow for ``bad atoms,'' i.e.,
  atoms that are not legal Lisp objects but make sense in the ACL2
  logic; these come at the end, after symbols.

  Function: <alphorder>

    (defun alphorder (x y)
           (declare (xargs :guard (and (atom x) (atom y))))
           (cond ((real/rationalp x)
                  (cond ((real/rationalp y) (<= x y))
                        (t t)))
                 ((real/rationalp y) nil)
                 ((complex/complex-rationalp x)
                  (cond ((complex/complex-rationalp y)
                         (or (< (realpart x) (realpart y))
                             (and (= (realpart x) (realpart y))
                                  (<= (imagpart x) (imagpart y)))))
                        (t t)))
                 ((complex/complex-rationalp y) nil)
                 ((characterp x)
                  (cond ((characterp y)
                         (<= (char-code x) (char-code y)))
                        (t t)))
                 ((characterp y) nil)
                 ((stringp x)
                  (cond ((stringp y) (and (string<= x y) t))
                        (t t)))
                 ((stringp y) nil)
                 (t (cond ((symbolp x)
                           (cond ((symbolp y) (not (symbol-< y x)))
                                 (t t)))
                          ((symbolp y) nil)
                          (t (bad-atom<= x y))))))")
 (ALTERNATIVE-INTRODUCTION
  (ACL2-TUTORIAL)
  "Introduction to ACL2

  This section contains introductory material on ACL2 including what
  ACL2 is, how to get started using the system, how to read the
  output, and other introductory topics. It was written almost
  entirely by Bill Young of Computational Logic, Inc.

  You might also find CLI Technical Report 101 helpful, especially if
  you are familiar with Nqthm. If you would like more familiarity
  with Nqthm, we suggest CLI Technical Report 100.

  OVERVIEW

  ACL2 is an automated reasoning system developed (for the first 9
  years) at Computational Logic, Inc. and (from January, 1997) at the
  University of Texas at Austin. It is the successor to the Nqthm (or
  Boyer-Moore) logic and proof system and its Pc-Nqthm interactive
  enhancement. The acronym ACL2 actually stands for ``A Computational
  Logic for Applicative Common Lisp''. This title suggests several
  distinct but related aspects of ACL2.

  We assume that readers of the ACL2 [documentation] have at least a
  very slight familiarity with some Lisp-like language. We will
  address the issue of prerequisites further, in ``ABOUT THIS
  TUTORIAL'' below.

  As a logic, ACL2 is a formal system with rigorously defined syntax
  and semantics. In mathematical parlance, the ACL2 logic is a
  first-order logic of total recursive functions providing
  mathematical induction on the ordinals up to epsilon-0 and two
  extension principles: one for recursive definition and one for
  constrained introduction of new function symbols, here called
  encapsulation. The syntax of ACL2 is that of Common Lisp; ACL2
  specifications are ``also'' Common Lisp programs in a way that we
  will make clear later. In less formal language, the ACL2 logic is
  an integrated collection of rules for defining (or axiomatizing)
  recursive functions, stating properties of those functions, and
  rigorously establishing those properties. Each of these activities
  is mechanically supported.

  As a specification language, ACL2 supports modeling of systems of
  various kinds. An ACL2 function can equally be used to express
  purely formal relationships among mathematical entities, to
  describe algorithms, or to capture the intended behavior of digital
  systems. For digital systems, an ACL2 specification is a
  mathematical model that is intended to formalize relevant aspects
  of system behavior. Just as physics allows us to model the behavior
  of continuous physical systems, ACL2 allows us to model digital
  systems, including many with physical realizations such as computer
  hardware. As early as the 1930's Church, Kleene, Turing and others
  established that recursive functions provide an expressive
  formalism for modeling digital computation. Digital computation
  should be understood in a broad sense, covering a wide variety of
  activities including almost any systematic or algorithmic activity,
  or activity that can be reasonably approximated in that way. This
  ranges from the behavior of a digital circuit to the behavior of a
  programming language compiler to the behavior of a controller for a
  physical system (as long as the system can be adequately modeled
  discretely). All of these have been modeled using ACL2 or its
  predecessor Nqthm.

  ACL2 is a computational logic in at least three distinct senses.
  First, the theory of recursive functions is often considered the
  mathematics of computation. Church conjectured that any ``effective
  computation'' can be modeled as a recursive function. Thus, ACL2
  provides an expressive language for modeling digital systems.
  Second, many ACL2 specifications are executable. In fact, recursive
  functions written in ACL2 are Common Lisp functions that can be
  submitted to any compliant Common Lisp compiler and executed (in an
  environment where suitable ACL2-specific macros and functions are
  defined). Third, ACL2 is computational in the sense that
  calculation is heavily integrated into the reasoning process. Thus,
  an expression with explicit constant values but no free variables
  can be simplified by calculation rather than by complex logical
  manipulations.

  ACL2 is a powerful, automated theorem prover or proof checker. This
  means that a competent user can utilize the ACL2 system to discover
  proofs of theorems stated in the ACL2 logic or to check previously
  discovered proofs. The basic deductive steps in an ACL2-checked
  proof are often quite large, due to the sophisticated combination
  of decision procedures, conditional rewriting, mathematical and
  structural induction, propositional simplification, and complex
  heuristics to orchestrate the interactions of these capabilities.
  Unlike some automated proof systems, ACL2 does not produce a formal
  proof. However, we believe that if ACL2 certifies the
  ``theoremhood'' of a given conjecture, then such a formal proof
  exists and, therefore, the theorem is valid. The ultimate result of
  an ACL2 proof session is a collection of ``[events],'' possibly
  grouped into ``[books],'' that can be replayed in ACL2. Therefore,
  a proof can be independently validated by any ACL2 user.

  ACL2 may be used in purely automated mode in the shallow sense that
  conjectures are submitted to the prover and the user does not
  interact with the proof attempt (except possibly to stop it) until
  the proof succeeds or fails. However, any non-trivial proof attempt
  is actually interactive, since successful proof ``[events]''
  influence the subsequent behavior of the prover. For example,
  proving a lemma may introduce a rule that subsequently is used
  automatically by the prover. Thus, any realistic proof attempt,
  even in ``automatic'' mode, is really an interactive dialogue with
  the prover to craft a sequence of [events] building an appropriate
  theory and proof rules leading up to the proof of the desired
  result. Also, ACL2 supports annotating a theorem with ``[hints]''
  designed to guide the proof attempt. By supplying appropriate
  [hints], the user can suggest proof strategies that the prover
  would not discover automatically. There is a ``[proof-tree]''
  facility (see [proof-tree]) that allows the user to [monitor] the
  progress and structure of a proof attempt in real-time. Exploring
  failed proof attempts is actually where heavy-duty ACL2 users spend
  most of their time.

  ACL2 can also be used in a more explicitly interactive mode. The
  ``[proof-checker]'' subsystem of ACL2 allows exploration of a proof
  on a fairly low level including expanding calls of selected
  function symbols, invoking specific [rewrite] rules, and
  selectively navigating around the proof. This facility can be used
  to gain sufficient insight into the proof to construct an automatic
  version, or to generate a detailed interactive-style proof that can
  be replayed in batch mode.

  Because ACL2 is all of these things --- computational logic,
  specification language, [programming] system, and theorem prover
  --- it is more than the sum of its parts. The careful integration
  of these diverse aspects has produced a versatile automated
  reasoning system suitable for building highly reliable digital
  systems. In the remainder of this tutorial, we will illustrate some
  simple uses of this automated reasoning system.

  ABOUT THIS TUTORIAL

  ACL2 is a complex system with a vast array of features, bells and
  whistles. However, it is possible to perform productive work with
  the system using only a small portion of the available
  functionality. The goals of this tutorial are to:

      familiarize the new user with the most basic features of and modes of
      interaction with ACL2;

      familiarize her with the form of output of the system; and

      work through a graduated series of examples.

  The more knowledge the user brings to this system, the easier it will
  be to become proficient. On one extreme: the ideal user of ACL2 is
  an expert Common Lisp programmer, has deep understanding of
  automated reasoning, and is intimately familiar with the earlier
  Nqthm system. Such ideal users are unlikely to need this tutorial.
  However, without some background knowledge, the beginning user is
  likely to become extremely confused and frustrated by this system.
  We suggest that a new user of ACL2 should:

      (a) have a little familiarity with Lisp, including basic Lisp
      programming and prefix notation (a Lisp reference manual such
      as Guy Steele's ``Common Lisp: The Language'' is also helpful);

      (b) be convinced of the utility of formal modeling; and

      (c) be willing to gain familiarity with basic automated theorem
      proving topics such as rewriting and algebraic simplification.

  We will not assume any deep familiarity with Nqthm (the so-called
  ``Boyer-Moore Theorem Prover''), though the book ``A Computational
  Logic Handbook'' by Boyer and Moore (Academic Press, 1988) is an
  extremely useful reference for many of the topics required to
  become a competent ACL2 user. We'll refer to it as ACLH below.

  As we said in the introduction, ACL2 has various facets. For example,
  it can be used as a Common Lisp [programming] system to construct
  application programs. In fact, the ACL2 system itself is a large
  Common Lisp program constructed almost entirely within ACL2.
  Another use of ACL2 is as a specification and modeling tool. That
  is the aspect we will concentrate on in the remainder of this
  tutorial.

  GETTING STARTED

  This section is an abridged version of what's available elsewhere;
  feel free to see [startup] for more details.

  How you start ACL2 will be system dependent, but you'll probably type
  something like ``acl2'' at your operating system prompt. Consult
  your system administrator for details.

  When you start up ACL2, you'll probably find yourself inside the ACL2
  [command] loop, as indicated by the following [prompt].

    ACL2 !>

  If not, you should type (LP). See [lp], which has a lot more
  information about the ACL2 [command] loop.

  There are two ``modes'' for using ACL2, :[logic] and :[program]. When
  you begin ACL2, you will ordinarily be in the :[logic] mode. This
  means that any new function defined is not only executable but also
  is axiomatically defined in the ACL2 logic. (See [defun-mode] and
  see [default-defun-mode].) Roughly speaking, :[program] mode is
  available for using ACL2 as a [programming] language without some
  of the logical burdens necessary for formal reasoning. In this
  tutorial we will assume that we always remain in :[logic] mode and
  that our purpose is to write formal models of digital systems and
  to reason about them.

  Now, within the ACL2 [command] loop you can carry out various kinds
  of activities, including the folllowing. (We'll see examples later
  of many of these.)

      define new functions (see [defun]);

      execute functions on concrete data;

      pose and attempt to prove conjectures about previously defined
      functions (see [defthm]);

      query the ACL2 ``[world]'' or database (e.g., see [pe]); and

      numerous other things.

  In addition, there is extensive on-line [documentation], of which
  this tutorial introduction is a part.

  INTERACTING WITH ACL2

  The standard means of interacting with ACL2 is to submit a sequence
  of forms for processing by the ACL2 system. These forms are checked
  for syntactic and semantic acceptability and appropriately
  processed by the system. These forms can be typed directly at the
  ACL2 [prompt]. However, most successful ACL2 users prefer to do
  their work using the Emacs text editor, maintaining an Emacs
  ``working'' buffer in which forms are edited. Those forms are then
  copied to the ACL2 interaction buffer, which is often the \"*shell*\"
  buffer.

  In some cases, processing succeeds and makes some change to the ACL2
  ``logical [world],'' which affects the processing of subsequent
  forms. How can this processing fail? For example, a proposed
  theorem will be rejected unless all function symbols mentioned have
  been previously defined. Also the ability of ACL2 to discover the
  proof of a theorem may depend on the user previously having proved
  other theorems. Thus, the order in which forms are submitted to
  ACL2 is quite important. Maintaining forms in an appropriate order
  in your working buffer will be helpful for re-playing the proof
  later.

  One of the most common [events] in constructing a model is
  introducing new functions. New functions are usually introduced
  using the [defun] form; we'll encounter some exceptions later.
  Proposed function definitions are checked to make sure that they
  are syntactically and semantically acceptable (e.g., that all
  mentioned functions have been previously defined) and, for
  recursive functions, that their recursive calls terminate. A
  recursive function definition is guaranteed to terminate if there
  is some some ``measure'' of the arguments and a ``well-founded''
  ordering such that the arguments to the function get smaller in
  each recursive call. See [well-founded-relation].

  For example, suppose that we need a function that will append two
  lists together. (We already have one in the ACL2 [append] function;
  but suppose perversely that we decide to define our own.) Suppose
  we submit the following definition (you should do so as well and
  study the system output):

    (defun my-app (x y)
      (if (atom x)
          y
        (cons (car x) (my-app x y))))

  The system responds with the following message:

    ACL2 Error in ( DEFUN MY-APP ...):  No :MEASURE was supplied with
    the definition of MY-APP.  Our heuristics for guessing one have not
    made any suggestions.  No argument of the function is tested along
    every branch and occurs as a proper subterm at the same argument
    position in every recursive call.  You must specify a :MEASURE.  See
    :DOC defun.

  This means that the system could not find an expression involving the
  formal parameters x and y that decreases under some well-founded
  order in every recursive call (there is only one such call). It
  should be clear that there is no such measure in this case because
  the only recursive call doesn't change the arguments at all. The
  definition is obviously flawed; if it were accepted and executed it
  would loop forever. Notice that a definition that is rejected is
  not stored in the system database; there is no need to take any
  action to have it ``thrown away.'' Let's try again with the correct
  definition. The interaction now looks like (we're also putting in
  the ACL2 [prompt]; you don't type that):

    ACL2 !>(defun my-app (x y)
             (if (atom x)
                 y
               (cons (car x) (my-app (cdr x) y))))

    The admission of MY-APP is trivial, using the relation O<
    (which is known to be well-founded on the domain recognized by
    O-P) and the measure (ACL2-COUNT X).  We observe that the
    type of MY-APP is described by the theorem
    (OR (CONSP (MY-APP X Y)) (EQUAL (MY-APP X Y) Y)).
    We used primitive type reasoning.

    Summary
    Form:  ( DEFUN MY-APP ...)
    Rules: ((:FAKE-RUNE-FOR-TYPE-SET NIL))
    Warnings:  None
    Time:  0.07 seconds (prove: 0.00, print: 0.00, other: 0.07)
    MY-APP

  Notice that this time the function definition was accepted. We didn't
  have to supply a measure explicitly; the system inferred one from
  the form of the definition. On complex functions it may be
  necessary to supply a measure explicitly. (See [xargs].)

  The system output provides several pieces of information.

      The revised definition is acceptable. The system realized that there
      is a particular measure (namely, (acl2-count x)) and a
      well-founded relation (o<) under which the arguments of my-app
      get smaller in recursion. Actually, the theorem prover proved
      several theorems to admit my-app. The main one was that when
      (atom x) is false the acl2-count of (cdr x) is less than (in
      the o< sense) the acl2-count of x. [Acl2-count] is the most
      commonly used measure of the ``size`` of an ACL2 object. [o<]
      is the ordering relation on ordinals less than epsilon-0. On
      the natural numbers it is just ordinary ``<''.

      The observation printed about ``the type of MY-APP'' means that calls
      of the function my-app will always return a value that is
      either a [cons] pair or is equal to the second parameter.

      The summary provides information about which previously introduced
      definitions and lemmas were used in this proof, about some
      notable things to watch out for (the Warnings), and about how
      long this event took to process.

  Usually, it's not important to read this information. However, it is
  a good habit to scan it briefly to see if the type information is
  surprising to you or if there are Warnings. We'll see an example of
  them later.

  After a function is accepted, it is stored in the database and
  available for use in other function definitions or lemmas. To see
  the definition of any function use the :[pe] command (see [pe]).
  For example,

    ACL2 !>:pe my-app
     L       73:x(DEFUN MY-APP (X Y)
                        (IF (ATOM X)
                            Y (CONS (CAR X) (MY-APP (CDR X) Y))))

  This displays the definition along with some other relevant
  information. In this case, we know that this definition was
  processed in :[logic] mode (the ``L'') and was the 73rd [command]
  processed in the current session.

  We can also try out our newly defined function on some sample data.
  To do that, just submit a form to be evaluated to ACL2. For
  example,

    ACL2 !>(my-app '(0 1 2) '(3 4 5))
    (0 1 2 3 4 5)
    ACL2 !>(my-app nil nil)
    NIL
    ACL2 !>

  Now suppose we want to prove something about the function just
  introduced. We conjecture, for example, that the length of the
  [append] of two lists is the sum of their lengths. We can formulate
  this conjecture in the form of the following ACL2 [defthm] form.

    (defthm my-app-length
      (equal (len (my-app x y))
             (+ (len x) (len y))))

  First of all, how did we know about the functions len and [+], etc.?
  The answer to that is somewhat unsatisfying --- we know them from
  our past experience in using Common Lisp and ACL2. It's hard to
  know that a function such as len exists without first knowing some
  Common Lisp. If we'd guessed that the appropriate function was
  called [length] (say, from our knowledge of Lisp) and tried :pe
  length, we would have seen that [length] is defined in terms of
  len, and we could have explored from there. Luckily, you can write
  a lot of ACL2 functions without knowing too many of the primitive
  functions.

  Secondly, why don't we need some ``type'' hypotheses? Does it make
  sense to append things that are not lists? Well, yes. ACL2 and Lisp
  are both quite weakly typed. For example, inspection of the
  definition of my-app shows that if x is not a [cons] pair, then
  (my-app x y) always returns y, no matter what y is.

  Thirdly, would it matter if we rewrote the lemma with the equality
  reversed, as follows?

    (defthm my-app-length2
      (equal (+ (len x) (len y))
             (len (my-app x y)))).

  The two are logically equivalent, but...yes, it would make a big
  difference. Recall our remark that a lemma is not only a ``fact''
  to be proved; it also is used by the system to prove other later
  lemmas. The current lemma would be stored as a [rewrite] rule. (See
  [rule-classes].) For a [rewrite] rule, a conclusion of the form
  (EQUAL LHS RHS) means to replace instances of the LHS by the
  appropriate instance of the RHS. Presumably, it's better to
  [rewrite] (len (my-app x y)) to (+ (len x) (len y)) than the other
  way around. The reason is that the system ``knows'' more about [+]
  than it does about the new function symbol my-app.

  So let's see if we can prove this lemma. Submitting our preferred
  [defthm] to ACL2 (do it!), we get the following interaction:

              --------------------------------------------------
    ACL2 !>(defthm my-app-length
      (equal (len (my-app x y))
             (+ (len x) (len y))))

    Name the formula above *1.

    Perhaps we can prove *1 by induction.  Three induction schemes are
    suggested by this conjecture.  These merge into two derived
    induction schemes.  However, one of these is flawed and so we are
    left with one viable candidate.

    We will induct according to a scheme suggested by (LEN X), but
    modified to accommodate (MY-APP X Y).  If we let (:P X Y) denote *1
    above then the induction scheme we'll use is
    (AND (IMPLIES (NOT (CONSP X)) (:P X Y))
         (IMPLIES (AND (CONSP X) (:P (CDR X) Y))
                  (:P X Y))).
    This induction is justified by the same argument used to admit LEN,
    namely, the measure (ACL2-COUNT X) is decreasing according to the
    relation O< (which is known to be well-founded on the domain
    recognized by O-P).  When applied to the goal at hand the
    above induction scheme produces the following two nontautological
    subgoals.

    Subgoal *1/2
    (IMPLIES (NOT (CONSP X))
             (EQUAL (LEN (MY-APP X Y))
                    (+ (LEN X) (LEN Y)))).

    But simplification reduces this to T, using the :definitions of FIX,
    LEN and MY-APP, the :type-prescription rule LEN, the :rewrite rule
    UNICITY-OF-0 and primitive type reasoning.

    Subgoal *1/1
    (IMPLIES (AND (CONSP X)
                  (EQUAL (LEN (MY-APP (CDR X) Y))
                         (+ (LEN (CDR X)) (LEN Y))))
             (EQUAL (LEN (MY-APP X Y))
                    (+ (LEN X) (LEN Y)))).

    This simplifies, using the :definitions of LEN and MY-APP, primitive
    type reasoning and the :rewrite rules COMMUTATIVITY-OF-+ and
    CDR-CONS, to

    Subgoal *1/1'
    (IMPLIES (AND (CONSP X)
                  (EQUAL (LEN (MY-APP (CDR X) Y))
                         (+ (LEN Y) (LEN (CDR X)))))
             (EQUAL (+ 1 (LEN (MY-APP (CDR X) Y)))
                    (+ (LEN Y) 1 (LEN (CDR X))))).

    But simplification reduces this to T, using linear arithmetic,
    primitive type reasoning and the :type-prescription rule LEN.

    That completes the proof of *1.

    Q.E.D.

    Summary
    Form:  ( DEFTHM MY-APP-LENGTH ...)
    Rules: ((:REWRITE UNICITY-OF-0)
            (:DEFINITION FIX)
            (:REWRITE COMMUTATIVITY-OF-+)
            (:DEFINITION LEN)
            (:REWRITE CDR-CONS)
            (:DEFINITION MY-APP)
            (:TYPE-PRESCRIPTION LEN)
            (:FAKE-RUNE-FOR-TYPE-SET NIL)
            (:FAKE-RUNE-FOR-LINEAR NIL))
    Warnings:  None
    Time:  0.30 seconds (prove: 0.13, print: 0.05, other: 0.12)
     MY-APP-LENGTH
              --------------------------------------------------

  Wow, it worked! In brief, the system first tried to [rewrite] and
  simplify as much as possible. Nothing changed; we know that because
  it said ``Name the formula above *1.'' Whenever the system decides
  to name a formula in this way, we know that it has run out of
  techniques to use other than proof by induction.

  The induction performed by ACL2 is structural or ``Noetherian''
  induction. You don't need to know much about that except that it is
  induction based on the structure of some object. The heuristics
  infer the structure of the object from the way the object is
  recursively decomposed by the functions used in the conjecture. The
  heuristics of ACL2 are reasonably good at selecting an induction
  scheme in simple cases. It is possible to override the heuristic
  choice by providing an :induction hint (see [hints]). In the case
  of the theorem above, the system inducts on the structure of x as
  suggested by the decomposition of x in both (my-app x y) and (len
  x). In the base case, we assume that x is not a [consp]. In the
  inductive case, we assume that it is a [consp] and assume that the
  conjecture holds for (cdr x).

  There is a close connection between the analysis that goes on when a
  function like my-app is accepted and when we try to prove something
  inductively about it. That connection is spelled out well in Boyer
  and Moore's book ``A Computational Logic,'' if you'd like to look
  it up. But it's pretty intuitive. We accepted my-app because the
  ``size'' of the first argument x decreases in the recursive call.
  That tells us that when we need to prove something inductively
  about my-app, it's a good idea to try an induction on the size of
  the first argument. Of course, when you have a theorem involving
  several functions, it may be necessary to concoct a more
  complicated [induction] schema, taking several of them into
  account. That's what's meant by ``merging'' the induction schemas.

  The proof involves two cases: the base case, and the inductive case.
  You'll notice that the subgoal numbers go down rather than up, so
  you always know how many subgoals are left to process. The base
  case (Subgoal *1/2) is handled by opening up the function
  definitions, simplifying, doing a little rewriting, and performing
  some reasoning based on the types of the arguments. You'll often
  encounter references to system defined lemmas (like unicity-of-0).
  You can always look at those with :[pe]; but, in general, assume
  that there's a lot of simplification power under the hood that's
  not too important to understand fully.

  The inductive case (Subgoal *1/1) is also dispatched pretty easily.
  Here we assume the conjecture true for the [cdr] of the list and
  try to prove it for the entire list. Notice that the prover does
  some simplification and then prints out an updated version of the
  goal (Subgoal *1/1'). Examining these gives you a pretty good idea
  of what's going on in the proof.

  Sometimes one goal is split into a number of subgoals, as happened
  with the induction above. Sometimes after some initial processing
  the prover decides it needs to prove a subgoal by induction; this
  subgoal is given a name and pushed onto a stack of goals. Some
  steps, like generalization (see ACLH), are not necessarily validity
  preserving; that is, the system may adopt a false subgoal while
  trying to prove a true one. (Note that this is ok in the sense that
  it is not ``unsound.'' The system will fail in its attempt to
  establish the false subgoal and the main proof attempt will fail.)
  As you gain facility with using the prover, you'll get pretty good
  at recognizing what to look for when reading a proof script. The
  prover's [proof-tree] utility helps with monitoring an ongoing
  proof and jumping to designated locations in the proof (see
  [proof-tree]). See [tips] for a number of useful pointers on using
  the theorem prover effectively.

  When the prover has successfully proved all subgoals, the proof is
  finished. As with a [defun], a summary of the proof is printed.
  This was an extremely simple proof, needing no additional guidance.
  More realistic examples typically require the user to look
  carefully at the failed proof log to find ways to influence the
  prover to do better on its next attempt. This means either: proving
  some rules that will then be available to the prover, changing the
  global state in ways that will affect the proof, or providing some
  [hints] locally that will influence the prover's behavior. Proving
  this lemma (my-app-length) is an example of the first. Since this
  is a [rewrite] rule, whenever in a later proof an instance of the
  form (LEN (MY-APP X Y)) is encountered, it will be rewritten to the
  corresponding instance of (+ (LEN X) (LEN Y)). Disabling the rule
  by executing the [command]

    (in-theory (disable my-app-length)),

  is an example of a global change to the behavior of the prover since
  this [rewrite] will not be performed subsequently (unless the rule
  is again [enable]d). Finally, we can add a (local) [disable]
  ``hint'' to a [defthm], meaning to [disable] the lemma only in the
  proof of one or more subgoals. For example:

    (defthm my-app-length-commutativity
      (equal (len (my-app x y))
             (len (my-app y x)))
      :hints ((\"Goal\" :in-theory (disable my-app-length))))

  In this case, the hint supplied is a bad idea since the proof is much
  harder with the hint than without it. Try it both ways.

  By the way, to undo the previous event use :u (see [u]). To undo back
  to some earlier event use :ubt (see [ubt]). To view the current
  event use :pe :here. To list several [events] use :pbt (see [pbt]).

  Notice the form of the hint in the previous example (see [hints]). It
  specifies a goal to which the hint applies. \"Goal\" refers to the
  top-level goal of the theorem. Subgoals are given unique names as
  they are generated. It may be useful to suggest that a function
  symbol be [disable]d only for Subgoal 1.3.9, say, and a different
  function [enable]d only on Subgoal 5.2.8. Overuse of such [hints]
  often suggests a poor global proof strategy.

  We now recommend that you visit [documentation] on additional
  examples. See [annotated-ACL2-scripts].")
 (ANALYZING_COMMON_LISP_MODELS
  (PAGES_WRITTEN_ESPECIALLY_FOR_THE_TOURS)
  "Analyzing Common Lisp Models

  To analyze a model you must be able to reason about the operations
  and relations involved. Perhaps, for example, some aspect of the
  model depends upon the fact that the concatenation operation is
  associative.

  In any Common Lisp you can confirm that

    (app '(A B) (app '(C D) '(E F)))

  and

    (app (app '(A B) '(C D)) '(E F)))

  both evaluate to the same thing, (A B C D E F).

  But what distinguishes ACL2 (the logic) from applicative Common Lisp
  (the language) is that in ACL2 you can prove that the concatenation
  function app is associative when its arguments are true-lists,
  whereas in Common Lisp all you can do is test that proposition.

  That is, in ACL2 it makes sense to say that the following formula is
  a ``theorem.''

    Theorem Associativity of App
    (implies (and (true-listp a)
                  (true-listp b))
             (equal (app (app a b) c)
                    (app a (app b c))))

  Theorems about the properties of models are proved by symbolically
  manipulating the operations and relations involved. If the
  concatenation of sequences is involved in your model, then you may
  well need the theorem above in order to that your model has some
  particular property.")
 (AND
  (ACL2-BUILT-INS)
  "Conjunction

  And is the macro for conjunctions. And takes any number of arguments.
  And returns nil if one of the arguments is nil, but otherwise
  returns the last argument. If there are no arguments, and returns
  t.

  And is a Common Lisp macro. See any Common Lisp documentation for
  more information.

  Macro: <and>

    (defmacro and (&rest args) (and-macro args))

  Function: <and-macro>

    (defun and-macro (lst)
           (declare (xargs :guard t))
           (if (consp lst)
               (if (consp (cdr lst))
                   (list 'if
                         (car lst)
                         (and-macro (cdr lst))
                         nil)
                   (car lst))
               t))")
 (ANNOTATED-ACL2-SCRIPTS
  (ACL2-TUTORIAL)
  "Examples of ACL2 scripts

  Beginning users may find these annotated scripts useful. We suggest
  that you read these in the following order:

    [Tutorial1-Towers-of-Hanoi]
    [Tutorial2-Eights-Problem]
    [Tutorial3-Phonebook-Example]
    [Tutorial4-Defun-Sk-Example]
    [Tutorial5-Miscellaneous-Examples]

  The web page Brief ACL2 Tutorial contains a script that illustrates
  how it feels to use The Method to prove an unusual list reverse
  function correct. The screen shots of ACL2's proof output are
  outdated -- in the version shown, ACL2 does not print Key
  Checkpoints, but the concept of key checkpoint is clear in the
  discussion and the behavior of the user.

  See Polishing Proofs Tutorial for a tutorial on becoming successful
  at approaching a formalization and proof problem in ACL2. That
  tutorial, written by Shilpi Goel and Sandip Ray, has two parts: it
  illustrates how to guide the theorem prover to a successful proof,
  and it shows how to clean up the proof in order to facilitate
  maintenance and extension of the resulting book (see [books]).

  The ACL2 Demo Given at TPHOLs 2008 by Matt Kaufmann includes scripts
  and a gzipped tar file containing the entire contents of the demos.

  The sort equivalence demo is a collection of scripts illustrating
  both high-level strategy and lower-level tactics dealing with the
  functional equivalence of various list sorting algorithms. Start
  with the README on that directory. There is also a gzipped tar file
  with all of these scripts.

  When you feel you have read enough examples, you might want to try
  the following very simple example on your own. (See
  [solution-to-simple-example] for a solution, after you work on this
  example.) First define the notion of the ``fringe'' of a tree,
  where we identify trees simply as [cons] structures, with [atom]s
  at the leaves. For example:

    ACL2 !>(fringe '((a . b) c . d))
    (A B C D)

  Next, define the notion of a ``leaf'' of a tree, i.e., a predicate
  leaf-p that is true of an atom if and only if that atom appears at
  the tip of the tree. Define this notion without referencing the
  function fringe. Finally, prove the following theorem, whose proof
  may well be automatic (i.e., not require any lemmas).

    (defthm leaf-p-iff-member-fringe
      (iff (leaf-p atm x)
           (member-equal atm (fringe x))))


Subtopics

  [Solution-to-simple-example]
      Solution to a simple example

  [Tutorial1-towers-of-hanoi]
      The Towers of Hanoi Example

  [Tutorial2-eights-problem]
      The Eights Problem Example

  [Tutorial3-phonebook-example]
      A Phonebook Specification

  [Tutorial4-defun-sk-example]
      Example of quantified notions

  [Tutorial5-miscellaneous-examples]
      Miscellaneous ACL2 examples")
 (AN_EXAMPLE_COMMON_LISP_FUNCTION_DEFINITION
  (PAGES_WRITTEN_ESPECIALLY_FOR_THE_TOURS)
  "An Example Common Lisp Function Definition

  [{IMAGE}]

  Consider the binary trees x and y below.

  {IMAGE}

  In Lisp, x is written as the list '(A B) or, equivalently, as '(A B .
  NIL). Similarly, y may be written '(C D E). Suppose we wish to
  replace the right-most tip of x by the entire tree y. This is
  denoted (app x y), where app stands for ``append''.

  {IMAGE}

  We can define app with:

    (defun app (x y)                           ; Concatenate x and y.
      (declare (type (satisfies true-listp) x)); We expect x to end in NIL.
      (cond ((endp x) y)                       ; If x is empty, return y.
            (t (cons (car x)                   ; Else, copy first node
                     (app (cdr x) y)))))       ;  and recur into next.

  If you defined this function in some Common Lisp, then to run app on
  the x and y above you could then type

    (app '(A B) '(C D E))

  and Common Lisp will print the result (A B C D E).

  [{IMAGE}]")
 (AN_EXAMPLE_OF_ACL2_IN_USE
  (PAGES_WRITTEN_ESPECIALLY_FOR_THE_TOURS)
  "An Example of ACL2 in Use

  [{IMAGE}]

  To introduce you to ACL2 we will consider the app function discussed
  in the [Common Lisp] page, except we will omit for the moment the
  declare form, which in ACL2 is called a guard.

  Guards are arbitrary ACL2 terms that express the ``intended domain''
  of functions. In that sense, guards are akin to type signatures.
  However, Common Lisp and ACL2 are untyped programming languages:
  while the language supports several different data types and the
  types of objects can be determined by predicates at runtime, any
  type of object may be passed to any function. Thus, guards are
  ``extra-logical.'' Recognizing both the practical and intellectual
  value of knowing that your functions are applied to the kinds of
  objects you intend, ACL2 imposes guards on Common Lisp and provides
  a means of proving that functions are used as intended. But the
  story is necessarily complicated and we do not recommend it to the
  new user. Get used to the fact that any ACL2 function may be
  applied to any objects and program accordingly. Read about guards
  later.

  Here is the definition again

    (defun app (x y)
      (cond ((endp x) y)
            (t (cons (car x)
                     (app (cdr x) y)))))

  The next few stops along the Walking Tour will show you

     * how to use the ACL2 documentation, * what happens when the above
    definition is submitted to ACL2, * what happens when you evaluate calls of
    app, * what one simple theorem about app looks like, * how ACL2
    proves the theorem, and * how that theorem can be used in another proof.

  Along the way we will talk about the definitional principle, types,
  the ACL2 read-eval-print loop, and how the theorem prover works.

  When we complete this part of the tour we will return briefly to the
  notion of guards and revisit several of the topics above in that
  context.

  [{IMAGE}]")
 (APPEND
  (ACL2-BUILT-INS)
  "[concatenate] zero or more lists

  Append, which takes zero or more arguments, expects all the arguments
  except perhaps the last to be true (null-terminated) lists. It
  returns the result of concatenating all the elements of all the
  given lists into a single list. Actually, in ACL2 append is a macro
  that expands into calls of the binary function [binary-append] if
  there are at least two arguments; if there is just one argument
  then the expansion is that argument; and finally, (append) expands
  to nil.

  Append is a Common Lisp function. See any Common Lisp documentation
  for more information.

  Macro: <append>

    (defmacro append (&rest rst)
              (cond ((null rst) nil)
                    ((null (cdr rst)) (car rst))
                    (t (xxxjoin 'binary-append rst))))

  Function: <binary-append>

    (defun binary-append (x y)
           (declare (xargs :guard (true-listp x)))
           (cond ((endp x) y)
                 (t (cons (car x)
                          (binary-append (cdr x) y)))))")
 (APROPOS (POINTERS)
          "See [finding-documentation].")
 (ARCHITECTURE-OF-THE-PROVER
  (INTRODUCTION-TO-THE-THEOREM-PROVER)
  "A simple overview of how the prover works

  Six built-in proof techniques are used by ACL2 to decompose the goal
  formula into subgoals.

  simplification -- decision procedures and rewriting with previously
  proved rules, but actually including a host of other techniques
  under your control. Simplification is the only proof technique that
  can reduce a formula to 0 subgoals (i.e., prove it) rather than
  just transform it to other formulas. The predominant activity in
  most proofs is simplification. There are many ways you can affect
  what the simplifier does to your formulas. Good users spend most of
  their time thinking about how to control the simplifier.

  destructor elimination -- getting rid of ``destructor terms'' like
  (CAR X) and (CDR X) by replacing a variable, e.g., X, by a
  ``constructor'' term, e.g., (CONS A B). But you can tell ACL2 about
  new destructor/constructor combinations.

  cross-fertilization -- using an equivalence hypothesis by
  substituting one side for the other into the conclusion and then
  throwing the hypothesis away. This is a heuristic that helps use an
  inductive hypothesis and prepare for another induction.

  generalization -- replacing a term by a new variable and restricting
  the new variable to have some of the properties of the term. You
  can control the restrictions imposed on the new variable. This is a
  heuristic that prepares the goal for another induction.

  elimination of irrelevance -- throwing away unnecessary hypotheses.
  This is a heuristic that prepares the goal for another induction.

  induction -- selecting an induction scheme to prove a formula.
  Inductions are ``suggested'' by the recursive functions appearing
  in the formula. But you can control what inductions are suggested
  by terms.

  But you can add additional techniques, called clause processors.

  The various techniques are tried in turn, with simplification first
  and induction last. Each technique reports one of three outcomes:
  it found nothing to change (i.e., the technique doesn't apply to
  that subgoal), it decided to abort the proof attempt (typically
  because there is reason to believe the proof is failing), or it
  decomposed the goal into k subgoals.

  The last outcome has a special case: if k is 0 then the technique
  proved the goal. Whenever k is non-0, the process starts over again
  with simplification on each of the k subgoals. However, it saves up
  all the subgoals for which induction is the only proof technique
  left to try. That way you see how it performs on every base case
  and induction step of one induction before it launches into another
  induction.

  It runs until you or one of the proof techniques aborts the proof
  attempt or until all subgoals have been proved.

  Note that if simplification produces a subgoal, that subgoal is
  re-simplified. This process continues until the subgoal cannot be
  simplified further. Only then is the next proof technique is tried.
  Such suboals are said to be stable under simplification.

  While this is happening, the prover prints an English narrative
  describing the process. Basically, after each goal is printed, the
  system prints an English paragraph that names the next applicable
  proof technique, gives a brief description of what that technique
  does to the subgoal, and says how many new subgoals are produced.
  Then each subgoal is dealt with in turn.

  If the proof is successful, you could read this log as a proof of the
  conjecture. But output from successful proofs is generally never
  read because it is not important to The Method described in
  [introduction-to-the-theorem-prover].

  The output of an unsuccessful proof attempt concludes with some key
  checkpoints which usually bear looking at.")
 (AREF1
  (ARRAYS ACL2-BUILT-INS)
  "Access the elements of a 1-dimensional array

    Example Form:
    (aref1 'delta1 a (+ i k))

    General Form:
    (aref1 name alist index)

  where name is a symbol, alist is a 1-dimensional array and index is a
  legal index into alist. This function returns the value associated
  with index in alist, or else the default value of the array. See
  [arrays] for details.

  This function executes in virtually constant time if alist is in fact
  the ``semantic value'' associated with name (see [arrays]). When it
  is not, aref1 must do a linear search through alist. In that case
  the correct answer is returned but a slow array comment is printed
  to the comment window. See [slow-array-warning].

  Function: <aref1>

    (defun
         aref1 (name l n)
         (declare (xargs :guard (and (array1p name l)
                                     (integerp n)
                                     (>= n 0)
                                     (< n (car (dimensions name l))))))
         (let ((x (and (not (eq n :header)) (assoc n l))))
              (cond ((null x) (default name l))
                    (t (cdr x)))))")
 (AREF2
  (ARRAYS ACL2-BUILT-INS)
  "Access the elements of a 2-dimensional array

    Example Form:
    (aref2 'delta1 a i j)

    General Form:
    (aref2 name alist i j)

  where name is a symbol, alist is a 2-dimensional array and i and j
  are legal indices into alist. This function returns the value
  associated with (i . j) in alist, or else the default value of the
  array. See [arrays] for details.

  This function executes in virtually constant time if alist is in fact
  the ``semantic value'' associated with name (see [arrays]). When it
  is not, aref2 must do a linear search through alist. In that case
  the correct answer is returned but a slow array comment is printed
  to the comment window. See [slow-array-warning].

  Function: <aref2>

    (defun
         aref2 (name l i j)
         (declare (xargs :guard (and (array2p name l)
                                     (integerp i)
                                     (>= i 0)
                                     (< i (car (dimensions name l)))
                                     (integerp j)
                                     (>= j 0)
                                     (< j (cadr (dimensions name l))))))
         (let ((x (assoc2 i j l)))
              (cond ((null x) (default name l))
                    (t (cdr x)))))")
 (ARGS
  (DOCUMENTATION)
  "args, [guard], type, [constraint], etc., of a function symbol

    Example:
    :args assoc-eq

  Args takes one argument, a symbol which must be the name of a
  function or macro, and prints out the formal parameters, the
  [guard] expression, the output [signature], the deduced type, the
  [constraint] (if any), and whether [documentation] about the symbol
  is available via :[doc].")
 (ARRAY1P
  (ARRAYS ACL2-BUILT-INS)
  "Recognize a 1-dimensional array

    Example Form:
    (array1p 'delta1 a)

    General Form:
    (array1p name alist)

  where name and alist are arbitrary objects. This function returns t
  if alist is a 1-dimensional ACL2 array. Otherwise it returns nil.
  The function operates in constant time if alist is the semantic
  value of name. See [arrays].

  Function: <array1p>

    (defun
     array1p (name l)
     (declare (xargs :guard t))
     (and
      (symbolp name)
      (alistp l)
      (let
       ((header-keyword-list (cdr (assoc-eq :header l))))
       (and
        (keyword-value-listp header-keyword-list)
        (let
         ((dimensions
               (cadr (assoc-keyword :dimensions header-keyword-list)))
          (maximum-length
            (cadr (assoc-keyword :maximum-length header-keyword-list))))
         (and (true-listp dimensions)
              (equal (length dimensions) 1)
              (integerp (car dimensions))
              (integerp maximum-length)
              (< 0 (car dimensions))
              (< (car dimensions) maximum-length)
              (<= maximum-length
                  *maximum-positive-32-bit-integer*)
              (bounded-integer-alistp l (car dimensions))))))))")
 (ARRAY2P
  (ARRAYS ACL2-BUILT-INS)
  "Recognize a 2-dimensional array

    Example Form:
    (array2p 'delta1 a)

    General Form:
    (array2p name alist)

  where name and alist are arbitrary objects. This function returns t
  if alist is a 2-dimensional ACL2 array. Otherwise it returns nil.
  The function operates in constant time if alist is the semantic
  value of name. See [arrays].

  Function: <array2p>

    (defun
     array2p (name l)
     (declare (xargs :guard t))
     (and
      (symbolp name)
      (alistp l)
      (let
       ((header-keyword-list (cdr (assoc-eq :header l))))
       (and
        (keyword-value-listp header-keyword-list)
        (let
         ((dimensions
               (cadr (assoc-keyword :dimensions header-keyword-list)))
          (maximum-length
            (cadr (assoc-keyword :maximum-length header-keyword-list))))
         (and (true-listp dimensions)
              (equal (length dimensions) 2)
              (let ((d1 (car dimensions))
                    (d2 (cadr dimensions)))
                   (and (integerp d1)
                        (integerp d2)
                        (integerp maximum-length)
                        (< 0 d1)
                        (< 0 d2)
                        (< (* d1 d2) maximum-length)
                        (<= maximum-length
                            *maximum-positive-32-bit-integer*)
                        (bounded-integer-alistp2 l d1 d2)))))))))")
 (ARRAYS
  (PROGRAMMING)
  "An introduction to ACL2 arrays

  Below we begin a detailed presentation of ACL2 arrays. ACL2's
  single-threaded objects (see [stobj]) provide a similar
  functionality that is generally more efficient when there are
  updates (writes), but is also more restrictive.

  See [arrays-example] for a brief introduction illustrating the use of
  ACL2 arrays.

  ACL2 provides relatively efficient 1- and 2-dimensional arrays.
  Arrays are awkward to provide efficiently in an applicative
  language because the programmer rightly expects to be able to
  ``modify'' an array object with the effect of changing the behavior
  of the element accessing function on that object. This, of course,
  does not make any sense in an applicative setting. The element
  accessing function is, after all, a function, and its behavior on a
  given object is immutable. To ``modify'' an array object in an
  applicative setting we must actually produce a new array object.
  Arranging for this to be done efficiently is a challenge to the
  implementors of the language. In addition, the programmer
  accustomed to the von Neumann view of arrays must learn how to use
  immutable applicative arrays efficiently.

  In this note we explain 1-dimensional arrays. In particular, we
  explain briefly how to create, access, and ``modify'' them, how
  they are implemented, and how to program with them. 2-dimensional
  arrays are dealt with by analogy.

  The Logical Description of ACL2 Arrays

  An ACL2 1-dimensional array is an object that associates arbitrary
  objects with certain integers, called ``indices.'' Every array has
  a dimension, dim, which is a positive integer. The indices of an
  array are the consecutive integers from 0 through dim-1. To obtain
  the object associated with the index i in an array a, one uses
  (aref1 name a i). Name is a symbol that is irrelevant to the
  semantics of [aref1] but affects the speed with which it computes.
  We will talk more about array ``names'' later. To produce a new
  array object that is like a but which associates val with index i,
  one uses (aset1 name a i val).

  An ACL2 1-dimensional array is actually an alist. There is no special
  ACL2 function for creating arrays; they are generally built with
  the standard list processing functions [list] and [cons]. However,
  there is a special ACL2 function, called [compress1], for speeding
  up access to the elements of such an alist. We discuss [compress1]
  later.

  One element of the alist must be the ``header'' of the array. The
  [header] of a 1-dimensional array with dimension dim is of the
  form:

    (:HEADER :DIMENSIONS (dim)
             :MAXIMUM-LENGTH max
             :DEFAULT obj ; optional
             :NAME name   ; optional
             :ORDER order ; optional values are < (the default), >, or :none/nil
             ).

  Obj may be any object and is called the ``default value'' of the
  array. [Max] must be an integer greater than dim. Name must be a
  symbol. The :[default] and :name entries are optional; if
  :[default] is omitted, the default value is nil. The function
  [header], when given a name and a 1- or 2-dimensional array,
  returns the [header] of the array. The functions [dimensions],
  [maximum-length], and [default] are similar and return the
  corresponding fields of the [header] of the array. The role of the
  :[dimensions] field is obvious: it specifies the legal indices into
  the array. The roles played by the :[maximum-length] and :[default]
  fields are described below.

  Aside from the [header], the other elements of the alist must each be
  of the form (i . val), where i is an integer and 0 <= i < dim, and
  val is an arbitrary object.

  The :order field of the header is ignored for 2-dimensional arrays.
  For 1-dimensional arrays, it specifies the order of keys (i, above)
  when the array is compressed as with [compress1], as described
  below. An :order of :none or nil specifies no reordering of the
  alist by [compress1], and an order of > specifies reordering by
  [compress1] so that keys are in descending order. Otherwise, the
  alist is reordered by [compress1] so that keys are in ascending
  order.

  (Aref1 name a i) is [guard]ed so that name must be a symbol, a must
  be an array and i must be an index into a. The value of (aref1 name
  a i) is either (cdr (assoc i a)) or else is the default value of a,
  depending on whether there is a pair in a whose [car] is i. Note
  that name is irrelevant to the value of an [aref1] expression. You
  might :pe aref1 to see how simple the definition is.

  (Aset1 name a i val) is [guard]ed analogously to the [aref1]
  expression. The value of the [aset1] expression is essentially
  (cons (cons i val) a). Again, name is irrelevant. Note (aset1 name
  a i val) is an array, a', with the property that (aref1 name a' i)
  is val and, except for index i, all other indices into a' produce
  the same value as in a. Note also that if a is viewed as an alist
  (which it is) the pair ``binding'' i to its old value is in a' but
  ``covered up'' by the new pair. Thus, the length of an array grows
  by one when [aset1] is done.

  Because [aset1] covers old values with new ones, an array produced by
  a sequence of [aset1] calls may have many irrelevant pairs in it.
  The function [compress1] can remove these irrelevant pairs. Thus,
  (compress1 name a) returns an array that is equivalent (vis-a-vis
  [aref1]) to a but which may be shorter. For technical reasons, the
  alist returned by [compress1] may also list the pairs in a
  different order than listed in a.

  To prevent arrays from growing excessively long due to repeated
  [aset1] operations, [aset1] actually calls [compress1] on the new
  alist whenever the length of the new alist exceeds the
  :[maximum-length] entry, [max], in the [header] of the array. See
  the definition of [aset1] (for example by using :[pe]). This is
  primarily just a mechanism for freeing up [cons] space consumed
  while doing [aset1] operations. Note however that this [compress1]
  call is replaced by a hard error if the header specifies an :order
  of :none or nil.

  This completes the logical description of 1-dimensional arrays.
  2-dimensional arrays are analogous. The :[dimensions] entry of the
  [header] of a 2-dimensional array should be (dim1 dim2). A pair of
  indices, i and j, is legal iff 0 <= i < dim1 and 0 <= j < dim2. The
  :[maximum-length] must be greater than dim1*dim2. [Aref2], [aset2],
  and [compress2] are like their counterparts but take an additional
  index argument. Finally, the pairs in a 2-dimensional array are of
  the form ((i . j) . val).

  The Implementation of ACL2 Arrays

  Very informally speaking, the function [compress1] ``creates'' an
  ACL2 array that provides fast access, while the function [aref1]
  ``maintains'' fast access. We now describe this informal idea more
  carefully.

  [Aref1] is essentially [assoc]. If [aref1] were implemented naively
  the time taken to access an array element would be linear in the
  dimension of the array and the number of ``assignments'' to it (the
  number of [aset1] calls done to create the array from the initial
  alist). This is intolerable; arrays are ``supposed'' to provide
  constant-time access and change.

  The apparently irrelevant names associated with ACL2 arrays allow us
  to provide constant-time access and change when arrays are used in
  ``conventional'' ways. The implementation of arrays makes it clear
  what we mean by ``conventional.''

  Recall that array names are symbols. Behind the scenes, ACL2
  associates two objects with each ACL2 array name. The first object
  is called the ``semantic value'' of the name and is an alist. The
  second object is called the ``raw lisp array'' and is a Common Lisp
  array.

  When (compress1 name alist) builds a new alist, a', it sets the
  semantic value of name to that new alist. Furthermore, it creates a
  Common Lisp array and writes into it all of the index/value pairs
  of a', initializing unassigned indices with the default value. This
  array becomes the raw lisp array of name. [Compress1] then returns
  a', the semantic value, as its result, as required by the
  definition of [compress1].

  When (aref1 name a i) is invoked, [aref1] first determines whether
  the semantic value of name is a (i.e., is [eq] to the alist a). If
  so, [aref1] can determine the ith element of a by invoking Common
  Lisp's aref function on the raw lisp array associated with name.
  Note that no linear search of the alist a is required; the
  operation is done in constant time and involves retrieval of two
  global variables, an [eq] test and jump, and a raw lisp array
  access. In fact, an ACL2 array access of this sort is about 5 times
  slower than a C array access. On the other hand, if name has no
  semantic value or if it is different from a, then [aref1]
  determines the answer by linear search of a as suggested by the
  assoc-like definition of [aref1]. Thus, [aref1] always returns the
  axiomatically specified result. It returns in constant time if the
  array being accessed is the current semantic value of the name
  used. The ramifications of this are discussed after we deal with
  [aset1].

  When (aset1 name a i val) is invoked, [aset1] does two [cons]es to
  create the new array. Call that array a'. It will be returned as
  the answer. (In this discussion we ignore the case in which [aset1]
  does a [compress1].) However, before returning, [aset1] determines
  if name's semantic value is a. If so, it makes the new semantic
  value of name be a' and it smashes the raw lisp array of name with
  val at index i, before returning a' as the result. Thus, after
  doing an [aset1] and obtaining a new semantic value a', all
  [aref1]s on that new array will be fast. Any [aref1]s on the old
  semantic value, a, will be slow.

  To understand the performance implications of this design, consider
  the chronological sequence in which ACL2 (Common Lisp) evaluates
  expressions: basically inner-most first, left-to-right,
  call-by-value. An array use, such as (aref1 name a i), is ``fast''
  (constant-time) if the alist supplied, a, is the value returned by
  the most recently executed [compress1] or [aset1] on the name
  supplied. In the functional expression of ``conventional'' array
  processing, all uses of an array are fast.

  The :name field of the [header] of an array is completely irrelevant.
  Our convention is to store in that field the symbol we mean to use
  as the name of the raw lisp array. But no ACL2 function inspects
  :name and its primary value is that it allows the user, by
  inspecting the semantic value of the array --- the alist --- to
  recall the name of the raw array that probably holds that value. We
  say ``probably'' since there is no enforcement that the alist was
  compressed under the name in the [header] or that all asets used
  that name. Such enforcement would be inefficient.

  Some Programming Examples

  In the following examples we will use ACL2 ``global variables'' to
  hold several arrays. See [@], and see [assign].

  Let the [state] global variable a be the 1-dimensional compressed
  array of dimension 5 constructed below.

    ACL2 !>(assign a (compress1 'demo
                                '((:header :dimensions (5)
                                           :maximum-length 15
                                           :default uninitialized
                                           :name demo)
                                  (0 . zero))))

  Then (aref1 'demo (@ a) 0) is zero and (aref1 'demo (@ a) 1) is
  uninitialized.

  Now execute

    ACL2 !>(assign b (aset1 'demo (@ a) 1 'one))

  Then (aref1 'demo (@ b) 0) is zero and (aref1 'demo (@ b) 1) is one.

  All of the [aref1]s done so far have been ``fast.''

  Note that we now have two array objects, one in the global variable a
  and one in the global variable b. B was obtained by assigning to a.
  That assignment does not affect the alist a because this is an
  applicative language. Thus, (aref1 'demo (@ a) 1) must still be
  uninitialized. And if you execute that expression in ACL2 you will
  see that indeed it is. However, a rather ugly comment is printed,
  namely that this array access is ``slow.'' The reason it is slow is
  that the raw lisp array associated with the name demo is the array
  we are calling b. To access the elements of a, [aref1] must now do
  a linear search. Any reference to a as an array is now
  ``unconventional;'' in a conventional language like Ada or Common
  Lisp it would simply be impossible to refer to the value of the
  array before the assignment that produced our b.

  Now let us define a function that counts how many times a given
  object, x, occurs in an array. For simplicity, we will pass in the
  name and highest index of the array:

    ACL2 !>(defun cnt (name a i x)
             (declare (xargs :guard
                             (and (array1p name a)
                                  (integerp i)
                                  (>= i -1)
                                  (< i (car (dimensions name a))))
                             :mode :logic
                             :measure (nfix (+ 1 i))))
             (cond ((zp (1+ i)) 0) ; return 0 if i is at most -1
                   ((equal x (aref1 name a i))
                    (1+ (cnt name a (1- i) x)))
                   (t (cnt name a (1- i) x))))

  To determine how many times zero appears in (@ b) we can execute:

    ACL2 !>(cnt 'demo (@ b) 4 'zero)

  The answer is 1. How many times does uninitialized appear in (@ b)?

    ACL2 !>(cnt 'demo (@ b) 4 'uninitialized)

  The answer is 3, because positions 2, 3 and 4 of the array contain
  that default value.

  Now imagine that we want to assign 'two to index 2 and then count how
  many times the 2nd element of the array occurs in the array. This
  specification is actually ambiguous. In assigning to b we produce a
  new array, which we might call c. Do we mean to count the
  occurrences in c of the 2nd element of b or the 2nd element of c?
  That is, do we count the occurrences of uninitialized or the
  occurrences of two? If we mean the former the correct answer is 2
  (positions 3 and 4 are uninitialized in c); if we mean the latter,
  the correct answer is 1 (there is only one occurrence of two in c).

  Below are ACL2 renderings of the two meanings, which we call [former]
  and [latter]. (Warning: Our description of these examples, and of
  an example [fast former] that follows, assumes that only one of
  these three examples is actually executed; for example, they are
  not executed in sequence. See ``A Word of Warning'' below for more
  about this issue.)

    (cnt 'demo (aset1 'demo (@ b) 2 'two) 4 (aref1 'demo (@ b) 2))  ; [former]

    (let ((c (aset1 'demo (@ b) 2 'two)))                           ; [latter]
      (cnt 'demo c 4 (aref1 'demo c 2)))

  Note that in [former] we create c in the second argument of the call
  to cnt (although we do not give it a name) and then refer to b in
  the fourth argument. This is unconventional because the second
  reference to b in [former] is no longer the semantic value of demo.
  While ACL2 computes the correct answer, namely 2, the execution of
  the [aref1] expression in [former] is done slowly.

  A conventional rendering with the same meaning is

    (let ((x (aref1 'demo (@ b) 2)))                           ; [fast former]
      (cnt 'demo (aset1 'demo (@ b) 2 'two) 4 x))

  which fetches the 2nd element of b before creating c by assignment.
  It is important to understand that [former] and [fast former] mean
  exactly the same thing: both count the number of occurrences of
  uninitialized in c. Both are legal ACL2 and both compute the same
  answer, 2. Indeed, we can symbolically transform [fast former] into
  [former] merely by substituting the binding of x for x in the body
  of the [let]. But [fast former] can be evaluated faster than
  [former] because all of the references to demo use the then-current
  semantic value of demo, which is b in the first line and c
  throughout the execution of the cnt in the second line. [Fast
  former] is the preferred form, both because of its execution speed
  and its clarity. If you were writing in a conventional language you
  would have to write something like [fast former] because there is
  no way to refer to the 2nd element of the old value of b after
  smashing b unless it had been saved first.

  We turn now to [latter]. It is both clear and efficient. It creates c
  by assignment to b and then it fetches the 2nd element of c, two,
  and proceeds to count the number of occurrences in c. The answer is
  1. [Latter] is a good example of typical ACL2 array manipulation:
  after the assignment to b that creates c, c is used throughout.

  It takes a while to get used to this because most of us have grown
  accustomed to the peculiar semantics of arrays in conventional
  languages. For example, in raw lisp we might have written something
  like the following, treating b as a ``global variable'':

    (cnt 'demo (aset 'demo b 2 'two) 4 (aref 'demo b 2))

  which sort of resembles [former] but actually has the semantics of
  [latter] because the b from which aref fetches the 2nd element is
  not the same b used in the aset! The array b is destroyed by the
  aset and b henceforth refers to the array produced by the aset, as
  written more clearly in [latter].

  A Word of Warning: Users must exercise care when experimenting with
  [former], [latter] and [fast former]. Suppose you have just created
  b with the assignment shown above,

    ACL2 !>(assign b (aset1 'demo (@ a) 1 'one))

  If you then evaluate [former] in ACL2 it will complain that the
  [aref1] is slow and compute the answer, as discussed. Then suppose
  you evaluate [latter] in ACL2. From our discussion you might expect
  it to execute fast --- i.e., issue no complaint. But in fact you
  will find that it complains repeatedly. The problem is that the
  evaluation of [former] changed the semantic value of demo so that
  it is no longer b. To try the experiment correctly you must make b
  be the semantic value of demo again before the next example is
  evaluated. One way to do that is to execute

    ACL2 !>(assign b (compress1 'demo (@ b)))

  before each expression. Because of issues like this it is often hard
  to experiment with ACL2 arrays at the top-level. We find it easier
  to write functions that use arrays correctly and efficiently than
  to so use them interactively.

  This last assignment also illustrates a very common use of
  [compress1]. While it was introduced as a means of removing
  irrelevant pairs from an array built up by repeated assignments, it
  is actually most useful as a way of insuring fast access to the
  elements of an array.

  Many array processing tasks can be divided into two parts. During the
  first part the array is built. During the second part the array is
  used extensively but not modified. If your [programming] task can
  be so divided, it might be appropriate to construct the array
  entirely with list processing, thereby saving the cost of
  maintaining the semantic value of the name while few references are
  being made. Once the alist has stabilized, it might be worthwhile
  to treat it as an array by calling [compress1], thereby gaining
  constant time access to it.

  ACL2's theorem prover uses this technique in connection with its
  implementation of the notion of whether a [rune] is [disable]d or
  not. Associated with every [rune] is a unique integer index, called
  its ``nume.'' When each rule is stored, the corresponding nume is
  stored as a component of the rule. [Theories] are lists of [rune]s
  and membership in the ``current theory'' indicates that the
  corresponding rule is [enable]d. But these lists are very long and
  membership is a linear-time operation. So just before a proof
  begins we map the list of [rune]s in the current theory into an
  alist that pairs the corresponding numes with t. Then we compress
  this alist into an array. Thus, given a rule we can obtain its nume
  (because it is a component) and then determine in constant time
  whether it is [enable]d. The array is never modified during the
  proof, i.e., [aset1] is never used in this example. From the
  logical perspective this code looks quite odd: we have replaced a
  linear-time membership test with an apparently linear-time [assoc]
  after going to the trouble of mapping from a list of [rune]s to an
  alist of numes. But because the alist of numes is an array, the
  ``apparently linear-time [assoc]'' is more apparent than real; the
  operation is constant-time.


Subtopics

  [Aref1]
      Access the elements of a 1-dimensional array

  [Aref2]
      Access the elements of a 2-dimensional array

  [Array1p]
      Recognize a 1-dimensional array

  [Array2p]
      Recognize a 2-dimensional array

  [Arrays-example]
      An example illustrating ACL2 arrays

  [Aset1]
      Set the elements of a 1-dimensional array

  [Aset2]
      Set the elements of a 2-dimensional array

  [Compress1]
      Remove irrelevant pairs from a 1-dimensional array

  [Compress2]
      Remove irrelevant pairs from a 2-dimensional array

  [Default]
      Return the :default from the [header] of a 1- or 2-dimensional array

  [Dimensions]
      Return the :dimensions from the [header] of a 1- or 2-dimensional
      array

  [Flush-compress]
      Flush the under-the-hood array for the given name

  [Header]
      Return the header of a 1- or 2-dimensional array

  [Maximum-length]
      Return the :maximum-length from the [header] of an array

  [Slow-array-warning]
      A warning or error issued when [arrays] are used inefficiently")
 (ARRAYS-EXAMPLE
  (ARRAYS)
  "An example illustrating ACL2 arrays

  The example below illustrates the use of ACL2 arrays. It is not, of
  course, a substitute for the detailed explanations provided
  elsewhere (see [arrays], including subtopics).

    ACL2 !>(defun defarray (name size initial-element)
             (compress1 name
                        (cons (list :HEADER
                                    :DIMENSIONS (list size)
                                    :MAXIMUM-LENGTH (1+ size)
                                    :DEFAULT initial-element
                                    :NAME name)
                              nil)))

    Since DEFARRAY is non-recursive, its admission is trivial.  We observe
    that the type of DEFARRAY is described by the theorem
    (AND (CONSP (DEFARRAY NAME SIZE INITIAL-ELEMENT))
         (TRUE-LISTP (DEFARRAY NAME SIZE INITIAL-ELEMENT))).
    We used the :type-prescription rule COMPRESS1.

    Summary
    Form:  ( DEFUN DEFARRAY ...)
    Rules: ((:TYPE-PRESCRIPTION COMPRESS1))
    Warnings:  None
    Time:  0.02 seconds (prove: 0.00, print: 0.02, other: 0.00)
     DEFARRAY
    ACL2 !>(assign my-ar (defarray 'a1 5 17))
     ((:HEADER :DIMENSIONS (5)
               :MAXIMUM-LENGTH 6 :DEFAULT 17 :NAME A1))
    ACL2 !>(aref1 'a1 (@ my-ar) 3)
    17
    ACL2 !>(aref1 'a1 (@ my-ar) 8)

    ACL2 Error in TOP-LEVEL:  The guard for the function symbol AREF1,
    which is
    (AND (ARRAY1P NAME L) (INTEGERP N) (>= N 0) (< N (CAR (DIMENSIONS NAME L)))),
    is violated by the arguments in the call (AREF1 'A1 '(#) 8).

    ACL2 !>(assign my-ar (aset1 'a1 (@ my-ar) 3 'xxx))
     ((3 . XXX)
      (:HEADER :DIMENSIONS (5)
               :MAXIMUM-LENGTH 6 :DEFAULT 17 :NAME A1))
    ACL2 !>(aref1 'a1 (@ my-ar) 3)
    XXX
    ACL2 !>(aset1 'a1 (@ my-ar) 3 'yyy) ; BAD: (@ my-ar) now points to
                                        ;      an old copy of the array!
    ((3 . YYY)
     (3 . XXX)
     (:HEADER :DIMENSIONS (5)
              :MAXIMUM-LENGTH 6 :DEFAULT 17 :NAME A1))
    ACL2 !>(aref1 'a1 (@ my-ar) 3) ; Because of \"BAD\" above, the array
                                   ; access is done using assoc rather
                                   ; than Lisp aref, hence is slower;
                                   ; but the answer is still correct,
                                   ; reflecting the value in (@ my-ar),
                                   ; which was not changed above.

    **********************************************************
    Slow Array Access!  A call of AREF1 on an array named
    A1 is being executed slowly.  See :DOC slow-array-warning
    **********************************************************

    XXX
    ACL2 !>")
 (ASET1
  (ARRAYS ACL2-BUILT-INS)
  "Set the elements of a 1-dimensional array

    Example Form:
    (aset1 'delta1 a (+ i k) 27)

    General Form:
    (aset1 name alist index val)

  where name is a symbol, alist is a 1-dimensional array named name,
  index is a legal index into alist, and val is an arbitrary object.
  See [arrays] for details. Roughly speaking this function
  ``modifies'' alist so that the value associated with index is val.
  More precisely, it returns a new array, alist', of the same name
  and dimension as alist that, under [aref1], is everywhere equal to
  alist except at index where the result is val. That is, (aref1 name
  alist' i) is (aref1 name alist i) for all legal indices i except
  index, where (aref1 name alist' i) is val.

  In order to ``modify'' alist, aset1 [cons]es a new pair onto the
  front. If the length of the resulting alist exceeds the
  :[maximum-length] entry in the array [header], aset1 compresses the
  array as with [compress1].

  It is generally expected that the ``semantic value'' of name will be
  alist (see [arrays]). This function operates in virtually constant
  time whether this condition is true or not (unless the [compress1]
  operation is required). But the value returned by this function
  cannot be used efficiently by subsequent aset1 operations unless
  alist is the semantic value of name when aset1 is executed. Thus,
  if the condition is not true, aset1 prints a slow array warning to
  the comment window. See [slow-array-warning].

  Function: <aset1>

    (defun
         aset1 (name l n val)
         (declare (xargs :guard (and (array1p name l)
                                     (integerp n)
                                     (>= n 0)
                                     (< n (car (dimensions name l))))))
         (let ((l (cons (cons n val) l)))
              (cond ((> (length l) (maximum-length name l))
                     (compress1 name l))
                    (t l))))")
 (ASET2
  (ARRAYS ACL2-BUILT-INS)
  "Set the elements of a 2-dimensional array

    Example Form:
    (aset2 'delta1 a i j 27)

    General Form:
    (aset2 name alist i j val)

  where name is a symbol, alist is a 2-dimensional array named name, i
  and j are legal indices into alist, and val is an arbitrary object.
  See [arrays] for details. Roughly speaking this function
  ``modifies'' alist so that the value associated with (i . j) is
  val. More precisely, it returns a new array, alist', of the same
  name and dimension as alist that, under [aref2], is everywhere
  equal to alist except at (i . j) where the result is val. That is,
  (aref2 name alist' x y) is (aref2 name alist x y) for all legal
  indices x y except i and j where (aref2 name alist' i j) is val.

  In order to ``modify'' alist, aset2 [cons]es a new pair onto the
  front. If the length of the resulting alist exceeds the
  :[maximum-length] entry in the array [header], aset2 compresses the
  array as with [compress2].

  It is generally expected that the ``semantic value'' of name will be
  alist (see [arrays]). This function operates in virtually constant
  time whether this condition is true or not (unless the [compress2]
  operation is required). But the value returned by this function
  cannot be used efficiently by subsequent aset2 operations unless
  alist is the semantic value of name when aset2 is executed. Thus,
  if the condition is not true, aset2 prints a slow array warning to
  the comment window. See [slow-array-warning].

  Function: <aset2>

    (defun
         aset2 (name l i j val)
         (declare (xargs :guard (and (array2p name l)
                                     (integerp i)
                                     (>= i 0)
                                     (< i (car (dimensions name l)))
                                     (integerp j)
                                     (>= j 0)
                                     (< j (cadr (dimensions name l))))))
         (let ((l (cons (cons (cons i j) val) l)))
              (cond ((> (length l) (maximum-length name l))
                     (compress2 name l))
                    (t l))))")
 (ASH
  (ACL2-BUILT-INS)
  "Arithmetic shift operation

  (ash i c) is the result of taking the two's complement representation
  of the integer i and shifting it by c bits: shifting left and
  padding with c 0 bits if c is positive, shifting right and dropping
  (abs c) bits if c is negative, and simply returning i if c is 0.

  The [guard] for ash requires that its arguments are integers.

  Ash is a Common Lisp function. See any Common Lisp documentation for
  more information.

  Function: <ash>

    (defun ash (i c)
           (declare (xargs :guard (and (integerp i) (integerp c))))
           (floor (* (ifix i) (expt 2 c)) 1))")
 (ASSERT$
  (ACL2-BUILT-INS)
  "Cause a hard error if the given test is false

    General Form:
    (assert$ test form)

  where test returns a single value and form is arbitrary.
  Semantically, this call of assert$ is equivalent to form. However,
  it causes a hard error if the value of test is nil. That hard error
  invokes the function [illegal], which has a [guard] that is equal
  to nil; so if you use assert$ in code for which you verify guards,
  then a proof obligation will be that the occurrence of test is
  never nil.")
 (ASSERT-EVENT
  (EVENTS)
  "Assert that a given form returns a non-nil value

    Examples:
    (assert-event (equal (+ 3 4) 7))
    (assert-event (equal (+ 3 4) 7) :msg (msg \"Error: ~x0\" 'equal-check))
    (assert-event (equal (+ 3 4) 7) :on-skip-proofs t)

    General Forms:
    (assert-event form)
    (assert-event form :on-skip-proofs t)

  Assert-event takes a ground form, i.e., one with no free variables;
  [stobj]s are allowed but only a single non-[stobj] value can be
  returned. The form is then evaluated and if the result is nil, then
  a so-called hard error (see [er]) results. This evaluation is
  however not done if proofs are being skipped, as during
  [include-book] (also see [skip-proofs] and see [ld-skip-proofsp]),
  unless :on-skip-proofs t is supplied.

  Normally, if an assert-event call fails then a generic failure
  message is printed, showing the offending form. However, if keyword
  argument :msg is supplied, then the failure message is printed as
  with [fmt] argument ~@0; see [fmt]. In particular, :msg is
  typically a string or a call (msg str arg-0 arg-1 ... arg-k), where
  str is a string and each arg-i is the value to be associated with
  #\\i upon formatted printing (as with [fmt]) of the string str.

  This form may be put into a book to be certified (see [books]),
  because assert-event is a macro whose calls expand to calls of
  value-triple (see [embedded-event-form]). When certifying a book,
  guard-checking is off, as though (set-guard-checking nil) has been
  evaluated; see [set-guard-checking]. That, together with a ``safe
  mode,'' guarantees that assert-event forms are evaluated in the
  logic without guard violations while certifying a book.")
 (ASSIGN
  (ACL2-BUILT-INS)
  "Assign to a global variable in [state]

    Examples:
    (assign x (expt 2 10))
    (assign a (aset1 'ascii-map-array (@ a) 66 'Upper-case-B))

    General Form:
    (assign symbol term)

  where symbol is any symbol (with certain enforced exclusions to avoid
  overwriting ACL2 system ``globals'') and term is any ACL2 term that
  could be evaluated at the top-level. Assign evaluates the term,
  stores the result as the value of the given symbol in the
  global-table of [state], and returns the result. (Note: the actual
  implementation of the storage of this value is much more efficient
  than this discussion of the logic might suggest.) Assign is a macro
  that effectively expands to the more complicated but
  understandable:

    (pprogn (f-put-global 'symbol term state)
            (mv nil (f-get-global 'symbol state) state)).

  The macro f-put-global is closely related to [assign]: (assign var
  val) macroexpands to (f-put-global 'var val state).

  The macro [@] gives convenient access to the value of such globals.
  The :[ubt] operation has no effect on the global-table of [state].
  Thus, you may use these globals to hang onto useful data structures
  even though you may undo back past where you computed and saved
  them.")
 (ASSOC
  (ACL2-BUILT-INS)
  "Look up key in association list

    General Forms:
    (assoc x alist)
    (assoc x alist :test 'eql)   ; same as above (eql as equality test)
    (assoc x alist :test 'eq)    ; same, but eq is equality test
    (assoc x alist :test 'equal) ; same, but equal is equality test

  (Assoc x alist) is the first member of alist whose [car] is x, or nil
  if no such member exists. The optional keyword, :TEST, has no
  effect logically, but provides the test (default [eql]) used for
  comparing x with the [car]s of successive elements of alist.

  The [guard] for a call of assoc depends on the test. In all cases,
  the second argument must satisfy [alistp]. If the test is [eql],
  then either the first argument must be suitable for [eql] (see
  [eqlablep]) or the second argument must satisfy [eqlable-alistp].
  If the test is [eq], then either the first argument must be a
  symbol or the second argument must satisfy [symbol-alistp].

  See [equality-variants] for a discussion of the relation between
  assoc and its variants:

      (assoc-eq x alist) is equivalent to (assoc x alist :test 'eq);

      (assoc-equal x alist) is equivalent to (assoc x alist :test 'equal).

  In particular, reasoning about any of these primitives reduces to
  reasoning about the function assoc-equal.

  Assoc is defined by Common Lisp. See any Common Lisp documentation
  for more information.

  Function: <assoc-equal>

    (defun assoc-equal (x alist)
           (declare (xargs :guard (alistp alist)))
           (cond ((endp alist) nil)
                 ((equal x (car (car alist)))
                  (car alist))
                 (t (assoc-equal x (cdr alist)))))")
 (ASSOC-EQ (POINTERS) "See [assoc].")
 (ASSOC-EQUAL (POINTERS) "See [assoc].")
 (ASSOC-KEYWORD
  (ACL2-BUILT-INS)
  "Look up key in a [keyword-value-listp]

  If l is a list of even length of the form (k1 a1 k2 a2 ... kn an),
  where each ki is a keyword, then (assoc-keyword key l) is the first
  tail of l starting with key if key is some ki, and is nil
  otherwise.

  The [guard] for (assoc-keyword key l) is (keyword-value-listp l).

  Function: <assoc-keyword>

    (defun assoc-keyword (key l)
           (declare (xargs :guard (keyword-value-listp l)))
           (cond ((endp l) nil)
                 ((eq key (car l)) l)
                 (t (assoc-keyword key (cddr l)))))")
 (ASSOC-STRING-EQUAL
  (ACL2-BUILT-INS)
  "Look up key, a string, in association list

  (Assoc-string-equal x alist) is similar to [assoc-equal]. However,
  for string x and alist alist, the comparison of x with successive
  keys in alist is done using [string-equal] rather than [equal].

  The [guard] for assoc-string-equal requires that x is a string and
  alist is an alist.

  Function: <assoc-string-equal>

    (defun
        assoc-string-equal (str alist)
        (declare
             (xargs :guard (and (stringp str)
                                (standard-char-listp (coerce str 'list))
                                (standard-string-alistp alist))))
        (cond ((endp alist) nil)
              ((string-equal str (car (car alist)))
               (car alist))
              (t (assoc-string-equal str (cdr alist)))))")
 (ATOM
  (ACL2-BUILT-INS)
  "Recognizer for atoms

  (atom x) is true if and only if x is an atom, i.e., not a [cons]
  pair.

  Atom has a [guard] of t, and is a Common Lisp function. See any
  Common Lisp documentation for more information.

  Function: <atom>

    (defun atom (x) (declare (xargs :guard t)) (not (consp x)))")
 (ATOM-LISTP
  (ACL2-BUILT-INS)
  "Recognizer for a true list of [atom]s

  The predicate atom-listp tests whether its argument is a [true-listp]
  of [atom]s, i.e., of non-conses.

  Also see [good-atom-listp].

  Function: <atom-listp>

    (defun atom-listp (lst)
           (declare (xargs :guard t))
           (cond ((atom lst) (eq lst nil))
                 (t (and (atom (car lst))
                         (atom-listp (cdr lst))))))")
 (A_FLYING_TOUR_OF_ACL2
  (PAGES_WRITTEN_ESPECIALLY_FOR_THE_TOURS)
  "A Flying Tour of ACL2

  [{IMAGE}]

  On this tour you will learn a little about what ACL2 is for rather
  than how ACL2 works. At the top and bottom bottom of the ``page''
  there are ``flying tour'' icons. Click on either icon to go to the
  next page of the tour.

  The tour visits the following topics sequentially. But on your first
  reading, don't navigate through the tour by clicking on these
  links; they are shown as live links only so that later you can
  determine what you've visited. Instead, just use the flying tour
  icons.

    The Flight Plan
    * [This Documentation]
    * [What is ACL2?]
    * [Mathematical Logic]
    * [Mechanical Theorem Proving]
    * [Mathematical Models in General]
    * [Mathematical Models of Computing Machines]
         [Formalizing Models]
         [Running Models]
         [Symbolic Execution of Models]
         [Proving Theorems about Models]
    * Requirements of ACL2
         [The User's Skills]
         [Training]
         [Host System]

  On your first reading, don't explore other links you see in the tour.
  Some of them lead to the Walking Tour, which you can take
  coherently when you finish this tour. Others lead into the
  extensive hyptertext documentation and you are liable to get lost
  there unless you're trying to answer a specific question. We intend
  the tour to take about 10 minutes of your time.

  [{IMAGE}]")
 (A_SKETCH_OF_HOW_THE_REWRITER_WORKS
  (PAGES_WRITTEN_ESPECIALLY_FOR_THE_TOURS)
  "A Sketch of How the Rewriter Works

  Below we show the first target term, extracted from the current
  conjecture. Below it we show the associativity rule.

  {IMAGE}

  The variables of the rewrite rule are instantiated so that the
  left-hand side of the rule matches the target:

    variable          term from target
      a                     x1
      b                     x2
      c                     (app x3 x4)

  Then the target is replaced by the instantiated right-hand side of
  the rule.

  Sometimes rules have hypotheses. To make a long story short, if the
  rule has hypotheses, then after matching the left-hand side, the
  rewriter instantiates the hypotheses and rewrites them recursively.
  This is called backchaining. If they all rewrite to true, then the
  target is replaced as above.

  We discuss the rewriter in more detail in the extended introduction
  to how to use the theorem prover, see
  [introduction-to-the-theorem-prover], which we will recommend you
  work through after you have finished the two tours.")
 (A_TINY_WARNING_SIGN
  (PAGES_WRITTEN_ESPECIALLY_FOR_THE_TOURS)
  "A Tiny Warning Sign

  {IMAGE}

  This warning sign, which usually appears as ``{ICON}'', indicates
  that the link it marks takes you into ACL2's online documentation.

  The documentation is a vast graph of documented topics intended to
  help the user of ACL2 rather than the potential user. If you are
  exploring ACL2's home page to learn about the system, perhaps you
  should go back rather than follow the link marked with this sign.
  But you are welcome to explore the online documentation as well.
  Good luck.")
 (A_TRIVIAL_PROOF (PAGES_WRITTEN_ESPECIALLY_FOR_THE_TOURS)
                  "A Trivial Proof

  {IMAGE}")
 (A_TYPICAL_STATE
  (PAGES_WRITTEN_ESPECIALLY_FOR_THE_TOURS)
  "A Typical State

  [{IMAGE}]

  {IMAGE}

  Observe that the states in typical models talk about

    booleans    integers   vectors     records   caches
    bits        symbols    arrays      stacks    files
    characters  strings    sequences   tables    directories

  These objects are discrete rather than continuous; furthermore they
  are built incrementally or inductively by repeatedly using
  primitive operations to put together smaller pieces.

  The functions we need to manipulate these objects do things like
  concatenate, reverse, sort, search, count, etc.

  [{IMAGE}]")
 (A_WALKING_TOUR_OF_ACL2
  (PAGES_WRITTEN_ESPECIALLY_FOR_THE_TOURS)
  "A Walking Tour of ACL2

  [{IMAGE}]

  On this tour you will learn a little more about the ACL2 logic, the
  theorem prover, and the user interface.

  This time we will stick with really simple things, such as the
  associativity of list concatenation.

  We assume you have taken the Flying Tour but that you did not
  necessarily follow all the ``off-tour'' links because we encouraged
  you not to. With the Walking Tour we encourage you to visit
  off-tour links --- provided they are not marked with the tiny
  warning sign ([{ICON}]). But they are ``branches'' in the tour that
  lead to ``dead ends.'' When you reach a dead end, remember to use
  your browser's Back Button to return to the Walking Tour to
  continue.

  When you get to the end of the tour we'll give you a chance to repeat
  quickly both the Flying and the Walking Tours to visit any off-tour
  links still of interest.

  [{IMAGE}]")
 (BACKCHAIN-LIMIT
  (REWRITE META LINEAR TYPE-PRESCRIPTION)
  "Limiting the effort expended on relieving hypotheses

  Before ACL2 can apply a rule with hypotheses, it must establish that
  the hypotheses are true. (We ignore the relaxing of this
  requirement afforded by [case-split]s and [force]d hypotheses.)
  ACL2 typically establishes each hypothesis by backchaining ---
  instantiating the hypothesis and then rewriting it recursively.
  Here we describe how ACL2 allows the user to limit backchaining. At
  the end, below, we describe the function [backchain-limit].

  Each hypothesis of a [rewrite], [meta], [linear], or
  [type-prescription] rule is assigned a backchain-limit when the
  rule is stored. By default, this limit is nil, denoting infinity
  (no limit). However, the value used for the default may be set to a
  non-negative integer (or to nil) by the user; see
  [set-default-backchain-limit]. The default is overridden when a
  :backchain-limit-lst is supplied explicitly with the rule; see
  [rule-classes]. The number of recursive applications of
  backchaining starting with the hypothesis of a rule is limited to
  the backchain-limit associated with that hypothesis.

  Moreover, the user may set global backchain-limits that limit the
  total backchaining depth. See [set-backchain-limit]. One limit is
  for the use of [rewrite], [meta], and [linear] rules, while the
  other limit is for so-called ``[type-set] reasoning'', which uses
  rules of class [type-prescription] rules. The two limits operate
  independently. Below, we discuss the first kind of backchain
  limits, i.e., for other than [type-prescription] rules, except as
  otherwise indicated; but the mechanism for those rules is similar.

  Below we lay out the precise sense in which a global backchain-limit
  interacts with the backchain-limits of individual rules in order to
  limit backchaining. But first we note that when further
  backchaining is disallowed, ACL2 can still prove a hypothesis in a
  given context by using that contextual information. In fact,
  [type-set] reasoning may be used (except that a weaker version of
  it is used in the second case above, i.e., where we are already
  doing type-set reasoning). Thus, the relieving of hypotheses may be
  limited to the use of contextual information (without backchaining,
  i.e., without recursively rewriting hypotheses) by executing
  :set-backchain-limit 0.

  Recall that there are two sorts of backchain limits: those applied to
  hypotheses of individual rules, as assigned by their
  :[rule-classes] or else taken from the default (see
  [set-default-backchain-limit]); and the global limit, initially nil
  (no limit) but settable with :[set-backchain-limit]. Here is how
  these two types of limits interact to limit backchaining, i.e.,
  recursive rewriting of hypotheses. ACL2 maintains a current
  backchain limit, which is the limit on the depth of recursive calls
  to the rewriter, as well as a current backchain depth, which is
  initially 0 and is incremented each time ACL2 backchains (and is
  decremented when a backchain completes). When ACL2 begins to
  rewrite a literal (crudely, one of the ``top-level'' terms of the
  goal currently being worked on), it sets the current
  backchain-limit to the global value, which is initially nil but can
  be set using :[set-backchain-limit]. When ACL2 is preparing to
  relieve a hypothesis by backchaining (hence, after it has already
  tried type-set reasoning), it first makes sure that the current
  backchain limit is greater than the current backchain depth. If
  not, then it refuses to relieve that hypothesis. Otherwise, it
  increments the current backchain depth and calculates a new current
  backchain-limit by taking the minimum of two values: the existing
  current backchain-limit, and the sum of the current backchain depth
  and the backchain-limit associated with the hypothesis. Thus, ACL2
  only modifies the current backchain-limit if it is necessary to
  decrease that limit in order to respect the backchain limit
  associated with the hypothesis.

  We illustrate with the following examples.

    ; We stub out some functions so that we can reason about them.

    (defstub p0 (x) t)
    (defstub p1 (x) t)
    (defstub p2 (x) t)
    (defstub p3 (x) t)

    ; Initially, the default-backchain-limit is nil, or infinite.

    (defaxiom p2-implies-p1-limitless
      (implies (p2 x)
               (p1 x)))

    ; The following rule will have a backchain-limit of 0.

    (defaxiom p1-implies-p0-limit-0
      (implies (p1 x)
               (p0 x))
      :rule-classes ((:rewrite :backchain-limit-lst 0)))

    ; We have (p2 x) ==> (p1 x) ==> (p0 x).  We wish to establish that
    ; (p2 x) ==> (p0 x).  Normally, this would be no problem, but here
    ; we fail because ACL2 cannot establish (p0 x) by type-set reasoning
    ; alone.

    (thm
      (implies (p2 x)
               (p0 x)))

    ; We set the default-backchain-limit (for rewriting) to 1.

    :set-default-backchain-limit 1

    ; The following is more powerful than p1-implies-p0-limit-0
    ; because it can use rewrite rules to establish (p1 x).

    (defaxiom p1-implies-p0-limit-1
      (implies (p1 x)
               (p0 x)))

    ; This theorem will succeed:

    (thm
      (implies (p2 x)
               (p0 x)))

    ; We return the default-backchain-limit to its initial value.

    :set-default-backchain-limit nil

    ; Here is our last axiom.

    (defaxiom p3-implies-p2-limitless
      (implies (p3 x)
               (p2 x)))

    ; We now have (p3 x) ==> (p2 x) ==> (p1 x) ==> (p0 x).  However the
    ; rule p1-implies-p0-limit-1 has a backchain-limit of 1; hence we
    ; are not allowed to backchain far enough back to use
    ; p3-implies-p2-limitless.  We therefore lose.

    (defthm will-fail
      (implies (p3 x)
               (p0 x)))

  Finally, we remark that to see the current global backchain-limits,
  issue the following commands.

    (backchain-limit wrld :ts) ; backchain limit for type-set reasoning
    (backchain-limit wrld :rewrite) ; backchain limit for rewriting")
 (BACKCHAIN-LIMIT-RW (POINTERS)
                     "See [hints] for keyword :backchain-limit-rw.")
 (BACKTRACK (POINTERS)
            "See [hints] for keyword :backtrack.")
 (BDD
  (ACL2)
  "Ordered binary decision diagrams with rewriting

  Ordered binary decision diagrams (OBDDs, often simply called BDDs)
  are a technique, originally published by Randy Bryant, for the
  efficient simplification of Boolean expressions. In ACL2 we combine
  this technique with rewriting to handle arbitrary ACL2 terms that
  can represent not only Boolean values, but non-Boolean values as
  well. In particular, we provide a setting for deciding equality of
  bit vectors (lists of Boolean values).

  An introduction to BDDs for the automated reasoning community may be
  found in ``Introduction to the OBDD Algorithm for the ATP
  Community'' by J Moore, Journal of Automated Reasoning (1994), pp.
  33-45. (This paper also appears as Technical Report #84 from
  Computational Logic, Inc.)

  Further information about BDDs in ACL2 can be found in the subtopics
  of this [documentation] section. In particular, see
  [bdd-introduction] for a good starting place that provides a number
  of examples.

  See [hints] for a description of :bdd hints. For quick reference,
  here is an example; but only the :vars part of the hint is
  required, as explained in the documentation for [hints]. The values
  shown are the defaults.

    (:vars nil :bdd-constructors (cons) :prove t :literal :all)

  We suggest that you next visit the documentation topic
  [bdd-introduction].


Subtopics

  [Bdd-algorithm]
      Summary of the BDD algorithm in ACL2

  [Bdd-introduction]
      Examples illustrating the use of BDDs in ACL2

  [If*]
      For conditional rewriting with BDDs

  [Obdd]
      Ordered binary decision diagrams with rewriting

  [Show-bdd]
      Inspect failed BDD proof attempts")
 (BDD-ALGORITHM
  (BDD)
  "Summary of the BDD algorithm in ACL2

  The BDD algorithm in ACL2 uses a combination of manipulation of IF
  terms and unconditional rewriting. In this discussion we begin with
  some relevant mathematical theory. This is followed by a
  description of how ACL2 does BDDs, including concluding discussions
  of soundness, completeness, and efficiency.

  We recommend that you read the other documentation about BDDs in ACL2
  before reading the rather technical material that follows. See
  [bdd].

  Here is an outline of our presentation. Readers who want a user
  perspective, without undue mathematical theory, may wish to skip to
  Part (B), referring to Part (A) only on occasion if necessary.

  (A) Mathematical Considerations

      (A1) BDD term order

      (A2) BDD-constructors and BDD terms, and their connection with
      aborting the BDD algorithm

      (A3) Canonical BDD terms

      (A4) A theorem stating the equivalence of provable and syntactic
      equality for canonical BDD terms

  (B) Algorithmic Considerations

      (B1) BDD rules (rules used by the rewriting portion of the ACL2 BDD
      algorithm)

      (B2) Terms ``known to be Boolean''

      (B3) An ``IF-lifting'' operation used by the algorithm, as well as an
      iterative version of that operation

      (B4) The ACL2 BDD algorithm

      (B5) Soundness and Completeness of the ACL2 BDD algorithm

      (B6) Efficiency considerations

  (A) Mathematical Considerations

  (A1) BDD term order

  Our BDD algorithm creates a total ``BDD term order'' on ACL2 terms,
  on the fly. We use this order in our discussions below of
  IF-lifting and of canonical BDD terms, and in the algorithm's use
  of commutativity. The particular order is unimportant, except that
  we guarantee (for purposes of commutative functions) that constants
  are smaller in this order than non-constants.

  (A2) BDD-constructors (assumed to be '(cons)) and BDD terms

  We take as given a list of function symbols that we call the
  ``BDD-constructors.'' By default, the only BDD-constructor is
  [cons], although it is legal to specify any list of function
  symbols as the BDD-constructors, either by using the
  [ACL2-defaults-table] (see [ACL2-defaults-table]) or by supplying a
  :BDD-CONSTRUCTORS hint (see [hints]). Warning: this capability is
  largely untested and may produce undesirable results. Henceforth,
  except when explicitly stated to the contrary, we assume that
  BDD-constructors is '(cons).

  Roughly speaking, a [bdd] term is the sort of [term] produced by our
  BDD algorithm, namely a tree with all [cons] nodes lying above all
  non-CONS nodes. More formally, a [term] is said to be a [bdd] term
  if it contains no subterm of either of the following forms, where f
  is not CONS.

    (f ... (CONS ...) ...)

    (f ... 'x ...)  ; where (consp x) = t

  We will see that whenever the BDD algorithm attempts to create a
  [term] that is not a [bdd] term, it aborts instead. Thus, whenever
  the algorithm completes without aborting, it creates a [bdd] term.

  (A3) Canonical BDD terms

  We can strengthen the notion of ``BDD term'' to a notion of
  ``canonical BDD term'' by imposing the following additional
  requirements, for every subterm of the form (IF x y z):

      (a) x is a variable, and it precedes (in the BDD term order) every
      variable occurring in y or z;

      (b) y and z are syntactically distinct; and,

      (c) it is not the case that y is t and z is nil.

  We claim that it follows easily from our description of the BDD
  algorithm that every term it creates is a canonical BDD term,
  assuming that the variables occurring in all such terms are treated
  by the algorithm as being Boolean (see (B2) below) and that the
  terms contain no function symbols other than IF and CONS. Thus,
  under those assumptions the following theorem shows that the BDD
  algorithm never creates distinct terms that are provably equal, a
  property that is useful for completeness and efficiency (as we
  explain in (B5) and (B6) below).

  (A4) Provably equal canonical BDD terms are identical

  We believe that the following theorem and proof are routine
  extensions of a standard result and proof to terms that allow calls
  of CONS.

  Theorem. Suppose that t1 and t2 are canonical BDD terms that contain
  no function symbols other than IF and CONS. Also suppose that
  (EQUAL t1 t2) is a theorem. Then t1 and t2 are syntactically
  identical.

  Proof of theorem: By induction on the total number of symbols
  occurring in these two terms. First suppose that at least one term
  is a variable; without loss of generality let it be t1. We must
  prove that t2 is syntactically the same as t1. Now it is clearly
  consistent that (EQUAL t1 t2) is false if t2 is a call of CONS (to
  see this, simply let t1 be an value that is not a CONSP).
  Similarly, t2 cannot be a constant or a variable other than t1. The
  remaining possibility to rule out is that t2 is of the form (IF t3
  t4 t5), since by assumption its function symbol must be IF or CONS
  and we have already handled the latter case. Since t2 is canonical,
  we know that t3 is a variable. Since (EQUAL t1 t2) is provable,
  i.e.,

    (EQUAL t1 (if t3 t4 t5))

  is provable, it follows that we may substitute either t or nil for t3
  into this equality to obtain two new provable equalities. First,
  suppose that t1 and t3 are distinct variables. Then these
  substitutions show that t1 is provably equal to both t4 and t5
  (since t3 does not occur in t4 or t5 by property (a) above, as t2
  is canonical), and hence t4 and t5 are provably equal to each
  other, which implies by the inductive hypothesis that they are the
  same term --- and this contradicts the assumption that t2 is
  canonical (property (b)). Therefore t1 and t3 are the same
  variable, i.e., the equality displayed above is actually (EQUAL t1
  (if t1 t4 t5)). Substituting t and then nil for t1 into this
  provable equality lets us prove (EQUAL t t4) and (EQUAL nil t5),
  which by the inductive hypothesis implies that t4 is
  (syntactically) the term t and t5 is nil. That is, t2 is (IF t1 t
  nil), which contradicts the assumption that t2 is canonical
  (property (c)).

  Next, suppose that at least one term is a call of IF. Our first
  observation is that the other term is also a call of IF. For if the
  other is a call of CONS, then they cannot be provably equal,
  because the former has no function symbols other than IF and hence
  is Boolean when all its variables are assigned Boolean values.
  Also, if the other is a constant, then both branches of the IF term
  are provably equal to that constant and hence these branches are
  syntactically identical by the inductive hypothesis, contradicting
  property (b). Hence, we may assume for this case that both terms
  are calls of IF; let us write them as follows.

    t0:  (IF t1 t2 t3)
    u0:  (IF u1 u2 u3)

  Note that t1 and u1 are variables, by property (a) of canonical BDD
  terms. First we claim that t1 does not strictly precede u1 in the
  BDD term order. For suppose t1 does strictly precede u1. Then
  property (a) of canonical BDD terms guarantees that t1 does not
  occur in u0. Hence, an argument much like one used above shows that
  u0 is provably equal to both t2 (substituting t for t1) and t3
  (substituting nil for t1), and hence t2 and t3 are provably equal.
  That implies that they are identical terms, by the inductive
  hypothesis, which then contradicts property (b) for t0. Similarly,
  u1 does not strictly precede t1 in the BDD term order. Therefore,
  t1 and u1 are the same variable. By substituting t for this
  variable we see that t2 and u2 are provably equal, and hence they
  are equal by the inductive hypothesis. Similarly, by substituting
  nil for t1 (and u1) we see that t3 and u3 are provably, hence
  syntactically, equal.

  We have covered all cases in which at least one term is a variable or
  at least one term is a call of IF. If both terms are constants,
  then provable and syntactic equality are clearly equivalent.
  Finally, then, we may assume that one term is a call of CONS and
  the other is a constant or a call of CONS. The constant case is
  similar to the CONS case if the constant is a CONSP, so we omit it;
  while if the constant is not a CONSP then it is not provably equal
  to a call of CONS; in fact it is provably not equal!

  So, we are left with a final case, in which canonical BDD terms (CONS
  t1 t2) and (CONS u1 u2) are provably equal, and we want to show
  that t1 and u1 are syntactically equal as are t2 and u2. These
  conclusions are easy consequences of the inductive hypothesis,
  since the ACL2 axiom CONS-EQUAL (which you can inspect using :[pe])
  shows that equality of the given terms is equivalent to the
  conjunction of (EQUAL t1 t2) and (EQUAL u1 u2). Q.E.D.

  (B) Algorithmic Considerations

  (B1) BDD rules

  A rule of class :[rewrite] (see [rule-classes]) is said to be a
  ``[bdd] rewrite rule'' if and only if it satisfies the following
  criteria. (1) The rule is [enable]d. (2) Its [equivalence] relation
  is [equal]. (3) It has no hypotheses. (4) Its :[loop-stopper] field
  is nil, i.e., it is not a permutative rule. (5) All variables
  occurring in the rule occur in its left-hand side (i.e., there are
  no ``free variables''; see [rewrite]). A rule of class
  :[definition] (see [rule-classes]) is said to be a ``[bdd]
  definition rule'' if it satisfies all the criteria above (except
  (4), which does not apply), and moreover the top function symbol of
  the left-hand side was not recursively (or mutually recursively)
  defined. Technical point: Note that this additional criterion is
  independent of whether or not the indicated function symbol
  actually occurs in the right-hand side of the rule.

  Both BDD rewrite rules and BDD definition rules are said to be ``BDD
  rules.''

  (B2) Terms ''known to be Boolean''

  We apply the BDD algorithm in the context of a top-level goal to
  prove, namely, the goal at which the :BDD hint is attached. As we
  run the BDD algorithm, we allow ourselves to say that a set of
  [term]s is ``known to be Boolean'' if we can verify that the goal
  is provable from the assumption that at least one of the terms is
  not Boolean. Equivalently, we allow ourselves to say that a set of
  terms is ``known to be Boolean'' if we can verify that the original
  goal is provably equivalent to the assertion that if all terms in
  the set are Boolean, then the goal holds. The notion ``known to be
  Boolean'' is conservative in the sense that there are generally
  sets of terms for which the above equivalent criteria hold and yet
  the sets of terms are not noted as as being ``known to be
  Boolean.'' However, ACL2 uses a number of tricks, including
  [type-set] reasoning and analysis of the structure of the top-level
  goal, to attempt to establish that a sufficiently inclusive set of
  terms is known to be Boolean.

  From a practical standpoint, the algorithm determines a set of terms
  known to be Boolean; we allow ourselves to say that each term in
  this set is ``known to be Boolean.'' The algorithm assumes that
  these terms are indeed Boolean, and can make use of that
  assumption. For example, if t1 is known to be Boolean then the
  algorithm simplifies (IF t1 t nil) to t1; see (iv) in the
  discussion immediately below.

  (B3) IF-lifting and the IF-lifting-for-IF loop

  Suppose that one has a [term] of the form (f ... (IF test x y) ...),
  where f is a function symbol other than CONS. Then we say that
  ``IF-lifting'' test ``from'' this term produces the following term,
  which is provably equal to the given term.

    (if test
        (f ... x ...)  ; resulting true branch
        (f ... y ...)) ; resulting false branch

  Here, we replace each argument of f of the form (IF test .. ..), for
  the same test, in the same way. In this case we say that
  ``IF-lifting applies to'' the given term, ``yielding the test''
  test and with the ``resulting two branches'' displayed above.
  Whenever we apply IF-lifting, we do so for the available test that
  is least in the BDD term order (see (A1) above).

  We consider arguments v of f that are ``known to be Boolean'' (see
  above) to be replaced by (IF v t nil) for the purposes of
  IF-lifting, i.e., before IF-lifting is applied.

  There is one special case, however, for IF-lifting. Suppose that the
  given term is of the form (IF v y z) where v is a variable and is
  the test to be lifted out (i.e., it is least in the BDD term order
  among the potential tests). Moroever, suppose that neither y nor z
  is of the form (IF v W1 W2) for that same v. Then IF-lifting does
  not apply to the given term.

  We may now describe the IF-lifting-for-IF loop, which applies to
  terms of the form (IF test tbr fbr) where the algorithm has already
  produced test, tbr, and fbr. First, if test is nil then we return
  fbr, while if test is a non-nil constant or a call of CONS then we
  return tbr. Otherwise, we see if IF-lifting applies. If IF-lifting
  does not apply, then we return (IF test tbr fbr). Otherwise, we
  apply IF-lifting to obtain a term of the form (IF x y z), by
  lifting out the appropriate test. Now we recursively apply the
  IF-lifting-for-IF loop to the term (IF x y z), unless any of the
  following special cases apply.

      (i) If y and z are the same term, then return y.

      (ii) Otherwise, if x and z are the same term, then replace z by nil
      before recursively applying IF-lifting-for-IF.

      (iii) Otherwise, if x and y are the same term and y is known to be
      Boolean, then replace y by t before recursively applying
      IF-lifting-for-IF.

      (iv) If z is nil and either x and y are the same term or x is ``known
      to be Boolean'' and y is t, then return x.

  NOTE: When a variable x is known to be Boolean, it is easy to see
  that the form (IF x t nil) is always reduced to x by this
  algorithm.

  (B4) The ACL2 BDD algorithm

  We are now ready to present the BDD algorithm for ACL2. It is given
  an ACL2 [term], x, as well as an association list va that maps
  variables to terms, including all variables occurring in x. We
  maintain the invariant that whenever a variable is mapped by va to
  a term, that term has already been constructed by the algorithm,
  except: initially va maps every variable occurring in the top-level
  term to itself. The algorithm proceeds as follows. We implicitly
  ordain that whenever the BDD algorithm attempts to create a [term]
  that is not a [bdd] term (as defined above in (A2)), it aborts
  instead. Thus, whenever the algorithm completes without aborting,
  it creates a [bdd] term.

      If x is a variable, return the result of looking it up in va.

      If x is a constant, return x.

      If x is of the form (IF test tbr fbr), then first run the algorithm
      on test with the given va to obtain test'. If test' is nil,
      then return the result fbr' of running the algorithm on fbr
      with the given va. If test' is a constant other than nil, or is
      a call of CONS, then return the result tbr' of running the
      algorithm on tbr with the given va. If tbr is identical to fbr,
      return tbr. Otherwise, return the result of applying the
      IF-lifting-for-IF loop (described above) to the term (IF test'
      tbr' fbr').

      If x is of the form (IF* test tbr fbr), then compute the result
      exactly as though [if] were used rather than [if*], except that
      if test' is not a constant or a call of CONS (see paragraph
      above), then abort the BDD computation. Informally, the tests
      of [if*] terms are expected to ``resolve.'' NOTE: This
      description shows how [if*] can be used to implement
      conditional rewriting in the BDD algorithm.

      If x is a LAMBDA expression ((LAMBDA vars body) . args) (which often
      corresponds to a [let] term; see [let]), then first form an
      alist va' by binding each v in vars to the result of running
      the algorithm on the corresponding member of args, with the
      current alist va. Then, return the result of the algorithm on
      body in the alist va'.

      Otherwise, x is of the form (f x1 x2 ... xn), where f is a function
      symbol other than [if] or [if*]. In that case, let xi' be the
      result of running the algorithm on xi, for i from 1 to n, using
      the given alist va. First there are a few special cases. If f
      is [equal] then we return t if x1' is syntactically identical
      to x2' (where this test is very fast; see (B6) below); we
      return x1' if it is known to be Boolean and x2' is t; and
      similarly, we return x2' if it is known to be Boolean and x1'
      is t. Next, if each xi' is a constant and the
      :[executable-counterpart] of f is enabled, then the result is
      obtained by computation. Next, if f is [booleanp] and x1' is
      known to be Boolean, t is returned. Otherwise, we proceed as
      follows, first possibly swapping the arguments if they are out
      of (the BDD term) order and if f is known to be commutative
      (see below). If a BDD rewrite rule (as defined above) matches
      the term (f x1'... xn'), then the most recently stored such
      rule is applied. If there is no such match and f is a
      BDD-constructor, then we return (f x1'... xn'). Otherwise, if a
      BDD definition rule matches this term, then the most recently
      stored such rule (which will usually be the original definition
      for most users) is applied. If none of the above applies and
      neither does IF-lifting, then we return (f x1'... xn').
      Otherwise we apply IF-lifting to (f x1'... xn') to obtain a
      term (IF test tbr fbr); but we aren't done yet. Rather, we run
      the BDD algorithm (using the same alist) on tbr and fbr to
      obtain terms tbr' and fbr', and we return (IF test tbr' fbr')
      unless tbr' is syntactically identical to fbr', in which case
      we return tbr'.

  When is it the case that, as said above, ``f is known to be
  commutative''? This happens when an enabled rewrite rule is of the
  form (EQUAL (f X Y) (f Y X)). Regarding swapping the arguments in
  that case: recall that we may assume very little about the BDD term
  order, essentially only that we swap the two arguments when the
  second is a constant and the first is not, for example, in (+ x 1).
  Other than that situation, one cannot expect to predict accurately
  when the arguments of commutative operators will be swapped.

  (B5) Soundness and Completeness of the ACL2 BDD algorithm

  Roughly speaking, ``soundness'' means that the BDD algorithm should
  give correct answers, and ``completeness'' means that it should be
  powerful enough to prove all true facts. Let us make the soundness
  claim a little more precise, and then we'll address completeness
  under suitable hypotheses.

  Claim (Soundness). If the ACL2 BDD algorithm runs to completion on an
  input term t0, then it produces a result that is provably equal to
  t0.

  We leave the proof of this claim to the reader. The basic idea is
  simply to check that each step of the algorithm preserves the
  meaning of the term under the bindings in the given alist.

  Let us start our discussion of completeness by recalling the theorem
  proved above in (A4).

  Theorem. Suppose that t1 and t2 are canonical BDD terms that contain
  no function symbols other than IF and CONS. Also suppose that
  (EQUAL t1 t2) is a theorem. Then t1 and t2 are syntactically
  identical.

  Below we show how this theorem implies the following completeness
  property of the ACL2 BDD algorithm. We continue to assume that CONS
  is the only BDD-constructor.

  Claim (Completeness). Suppose that t1 and t2 are provably equal
  terms, under the assumption that all their variables are known to
  be Boolean. Assume further that under this same assumption,
  top-level runs of the ACL2 BDD algorithm on these terms return
  terms that contain only the function symbols IF and CONS. Then the
  algorithm returns the same term for both t1 and t2, and the
  algorithm reduces (EQUAL t1 t2) to t.

  Why is this claim true? First, notice that the second part of the
  conclusion follows immediately from the first, by definition of the
  algorithm. Next, notice that the terms u1 and u2 obtained by
  running the algorithm on t1 and t2, respectively, are provably
  equal to t1 and t2, respectively, by the Soundness Claim. It
  follows that u1 and u2 are provably equal to each other. Since
  these terms contain no function symbols other than IF or CONS, by
  hypothesis, the Claim now follows from the Theorem above together
  with the following lemma.

  Lemma. Suppose that the result of running the ACL2 BDD algorithm on a
  top-level term t0 is a term u0 that contains only the function
  symbols IF and CONS, where all variables of t0 are known to be
  Boolean. Then u0 is a canonical BDD term.

  Proof: left to the reader. Simply follow the definition of the
  algorithm, with a separate argument for the IF-lifting-for-IF loop.

  Finally, let us remark on the assumptions of the Completeness Claim
  above. The assumption that all variables are known to be Boolean is
  often true; in fact, the system uses the forward-chaining rule
  boolean-listp-forward (you can see it using :[pe]) to try to
  establish this assumption, if your theorem has a form such as the
  following.

    (let ((x (list x0 x1 ...))
          (y (list y0 y1 ...)))
      (implies (and (boolean-listp x)
                    (boolean-listp y))
               ...))

  Moreover, the :BDD hint can be used to force the prover to abort if
  it cannot check that the indicated variables are known to be
  Boolean; see [hints].

  Finally, consider the effect in practice of the assumption that the
  terms resulting from application of the algorithm contain calls of
  IF and CONS only. Typical use of BDDs in ACL2 takes place in a
  theory (see [theories]) in which all relevant non-recursive
  function symbols are enabled and all recursive function symbols
  possess enabled BDD rewrite rules that tell them how open up. For
  example, such a rule may say how to expand on a given function
  call's argument that has the form (CONS a x), while another may say
  how to expand when that argument is nil). (See for example the
  rules append-cons and append-nil in the documentation for [if*].)
  We leave it to future work to formulate a theorem that guarantees
  that the BDD algorithm produces terms containing calls only of IF
  and CONS assuming a suitably ``complete'' collection of rewrite
  rules.

  (B6) Efficiency considerations

  Following Bryant's algorithm, we use a graph representation of
  [term]s created by the BDD algorithm's computation. This
  representation enjoys some important properties.

      (Time efficiency) The test for syntactic equality of BDD terms is
      very fast.

      (Space efficiency) Equal BDD data structures are stored identically
      in memory.

  Implementation note. The representation actually uses a sort of hash
  table for BDD terms that is implemented as an ACL2 1-dimensional
  array. See [arrays]. In addition, we use a second such hash table
  to avoid recomputing the result of applying a function symbol to
  the result of running the algorithm on its arguments. We believe
  that these uses of hash tables are standard. They are also
  discussed in Moore's paper on BDDs; see [bdd] for the reference.")
 (BDD-INTRODUCTION
  (BDD)
  "Examples illustrating the use of BDDs in ACL2

  See [bdd] for a brief introduction to BDDs in ACL2 and for pointers
  to other documentation on BDDs in ACL2. Here, we illustrate the use
  of BDDs in ACL2 by way of some examples. For a further example, see
  [if*].

  Let us begin with a really simple example. (We will explain the :bdd
  hint (:vars nil) below.)

    ACL2 !>(thm (equal (if a b c) (if (not a) c b))
                :hints ((\"Goal\" :bdd (:vars nil)))) ; Prove with BDDs

    [Note:  A hint was supplied for our processing of the goal above.
    Thanks!]

    But simplification with BDDs (7 nodes) reduces this to T, using the
    :definitions EQUAL and NOT.

    Q.E.D.

    Summary
    Form:  ( THM ...)
    Rules: ((:DEFINITION EQUAL) (:DEFINITION NOT))
    Warnings:  None
    Time:  0.18 seconds (prove: 0.05, print: 0.02, other: 0.12)

    Proof succeeded.
    ACL2 !>

  The :bdd hint (:vars nil) indicates that BDDs are to be used on the
  indicated goal, and that any so-called ``variable ordering'' may be
  used: ACL2 may use a convenient order that is far from optimal. It
  is beyond the scope of the present documentation to address the
  issue of how the user may choose good variable orderings. Someday
  our implementation of BDDs may be improved to include
  heuristically-chosen variable orderings rather than rather random
  ones.

  Here is a more interesting example.

    (defun v-not (x)
    ; Complement every element of a list of Booleans.
      (if (consp x)
          (cons (not (car x)) (v-not (cdr x)))
        nil))

    ; Now we prove a rewrite rule that explains how to open up v-not on
    ; a consp.
    (defthm v-not-cons
      (equal (v-not (cons x y))
             (cons (not x) (v-not y))))

    ; Finally, we prove for 7-bit lists that v-not is self-inverting.
    (thm
     (let ((x (list x0 x1 x2 x3 x4 x5 x6)))
       (implies (boolean-listp x)
                (equal (v-not (v-not x)) x)))
     :hints ((\"Goal\" :bdd
                     ;; Note that this time we specify a variable order.
                     (:vars (x0 x1 x2 x3 x4 x5 x6)))))

  It turns out that the variable order doesn't seem to matter in this
  example; using several orders we found that 30 nodes were created,
  and the proof time was about 1/10 of a second on a (somewhat
  enhanced) Sparc 2. The same proof took about a minute and a half
  without any :bdd hint! This observation is a bit misleading
  perhaps, since the theorem for arbitrary x,

    (thm
     (implies (boolean-listp x)
              (equal (v-not (v-not x)) x)))

  only takes about 1.5 times as long as the :bdd proof for 7 bits,
  above! Nevertheless, BDDs can be very useful in reducing proof
  time, especially when there is no regular structure to facilitate
  proof by induction, or when the induction scheme is so complicated
  to construct that significant user effort is required to get the
  proof by induction to go through.

  Finally, consider the preceding example, with a :bdd hint of (say)
  (:vars nil), but with the rewrite rule v-not-cons above disabled.
  In that case, the proof fails, as we see below. That is because the
  BDD algorithm in ACL2 uses hypothesis-free :[rewrite] rules,
  :[executable-counterpart]s, and nonrecursive definitions, but it
  does not use recursive definitions.

  Notice that when we issue the (show-bdd) command, the system's
  response clearly shows that we need a rewrite rule for simplifying
  terms of the form (v-not (cons ...)).

    ACL2 !>(thm
            (let ((x (list x0 x1 x2 x3 x4 x5 x6)))
              (implies (boolean-listp x)
                       (equal (v-not (v-not x)) x)))
            :hints ((\"Goal\" :bdd (:vars nil)
                     :in-theory (disable v-not-cons))))

    [Note:  A hint was supplied for our processing of the goal above.
    Thanks!]

    ACL2 Error in ( THM ...):  Attempted to create V-NOT node during BDD
    processing with an argument that is a call of a bdd-constructor,
    which would produce a non-BDD term (as defined in :DOC
    bdd-algorithm).  See :DOC show-bdd.

    Summary
    Form:  ( THM ...)
    Rules: NIL
    Warnings:  None
    Time:  0.58 seconds (prove: 0.13, print: 0.00, other: 0.45)

    ******** FAILED ********  See :DOC failure  ******** FAILED ********
    ACL2 !>(show-bdd)

    BDD computation on Goal yielded 17 nodes.
    ==============================

    BDD computation was aborted on Goal, and hence there is no
    falsifying assignment that can be constructed.  Here is a backtrace
    of calls, starting with the top-level call and ending with the one
    that led to the abort.  See :DOC show-bdd.

    (LET ((X (LIST X0 X1 X2 X3 X4 X5 ...)))
         (IMPLIES (BOOLEAN-LISTP X)
                  (EQUAL (V-NOT (V-NOT X)) X)))
      alist: ((X6 X6) (X5 X5) (X4 X4) (X3 X3) (X2 X2) (X1 X1) (X0 X0))

    (EQUAL (V-NOT (V-NOT X)) X)
      alist: ((X (LIST X0 X1 X2 X3 X4 X5 ...)))

    (V-NOT (V-NOT X))
      alist: ((X (LIST X0 X1 X2 X3 X4 X5 ...)))

    (V-NOT X)
      alist: ((X (LIST X0 X1 X2 X3 X4 X5 ...)))
    ACL2 !>

  The term that has caused the BDD algorithm to abort is thus (V-NOT
  X), where X has the value (LIST X0 X1 X2 X3 X4 X5 ...), i.e., (CONS
  X0 (LIST X1 X2 X3 X4 X5 ...)). Thus, we see the utility of
  introducing a rewrite rule to simplify terms of the form (V-NOT
  (CONS ...)). The moral of this story is that if you get an error of
  the sort shown above, you may find it useful to execute the command
  (show-bdd) and use the result as advice that suggests the left hand
  side of a rewrite rule.

  Here is another sort of failed proof. In this version we have omitted
  the hypothesis that the input is a bit vector. Below we use
  show-bdd to see what went wrong, and use the resulting information
  to construct a counterexample. This failed proof corresponds to a
  slightly modified input theorem, in which x is bound to the
  4-element list (list x0 x1 x2 x3).

    ACL2 !>(thm
            (let ((x (list x0 x1 x2 x3)))
              (equal (v-not (v-not x)) x))
            :hints ((\"Goal\" :bdd
                     ;; This time we do not specify a variable order.
                     (:vars nil))))

    [Note:  A hint was supplied for our processing of the goal above.
    Thanks!]

    ACL2 Error in ( THM ...):  The :BDD hint for the current goal has
    successfully simplified this goal, but has failed to prove it.
    Consider using (SHOW-BDD) to suggest a counterexample; see :DOC
    show-bdd.

    Summary
    Form:  ( THM ...)
    Rules: NIL
    Warnings:  None
    Time:  0.18 seconds (prove: 0.07, print: 0.00, other: 0.12)

    ******** FAILED ********  See :DOC failure  ******** FAILED ********
    ACL2 !>(show-bdd)

    BDD computation on Goal yielded 73 nodes.
    ==============================

    Falsifying constraints:
    ((X0 \"Some non-nil value\")
     (X1 \"Some non-nil value\")
     (X2 \"Some non-nil value\")
     (X3 \"Some non-nil value\")
     ((EQUAL 'T X0) T)
     ((EQUAL 'T X1) T)
     ((EQUAL 'T X2) T)
     ((EQUAL 'T X3) NIL))

    ==============================

    Term obtained from BDD computation on Goal:

    (IF X0
        (IF X1
            (IF X2 (IF X3 (IF # # #) (IF X3 # #))
                (IF X2 'NIL (IF X3 # #)))
            (IF X1 'NIL
                (IF X2 (IF X3 # #) (IF X2 # #))))
        (IF X0 'NIL
            (IF X1 (IF X2 (IF X3 # #) (IF X2 # #))
                (IF X1 'NIL (IF X2 # #)))))

    ACL2 Query (:SHOW-BDD):  Print the term in full?  (N, Y, W or ?):
    n ; I've seen enough.  The assignment shown above suggests
      ; (though not conclusively) that if we bind x3 to a non-nil
      ; value other than T, and bind x0, x1, and x2 to t, then we
      ; this may give us a counterexample.
    ACL2 !>(let ((x0 t) (x1 t) (x2 t) (x3 7))
             (let ((x (list x0 x1 x2 x3)))
               ;; Let's use LIST instead of EQUAL to see how the two
               ;; lists differ.
               (list (v-not (v-not x)) x)))
    ((T T T T) (T T T 7))
    ACL2 !>

  See [if*] for another example.")
 (BIBLIOGRAPHY
  (ABOUT-ACL2)
  "Reports about ACL2

  The ACL2 home page includes a list of notes and reports about ACL2.")
 (BINARY-*
  (ACL2-BUILT-INS)
  "Multiplication function

  Completion Axiom (completion-of-*):

    (equal (binary-* x y)
           (if (acl2-numberp x)
               (if (acl2-numberp y)
                   (binary-* x y)
                 0)
             0))

  [Guard] for (binary-* x y):

    (and (acl2-numberp x) (acl2-numberp y))

  Notice that like all arithmetic functions, binary-* treats
  non-numeric inputs as 0.

  Calls of the macro [*] expand to calls of binary-*; see [*].")
 (BINARY-+
  (ACL2-BUILT-INS)
  "Addition function

  Completion Axiom (completion-of-+):

    (equal (binary-+ x y)
           (if (acl2-numberp x)
               (if (acl2-numberp y)
                   (binary-+ x y)
                 x)
             (if (acl2-numberp y)
                 y
               0)))

  [Guard] for (binary-+ x y):

    (and (acl2-numberp x) (acl2-numberp y))

  Notice that like all arithmetic functions, binary-+ treats
  non-numeric inputs as 0.

  Calls of the macro [+] expand to calls of binary-+; see [+].")
 (BINARY-APPEND
  (ACL2-BUILT-INS)
  "[concatenate] two lists

  This binary function implements [append], which is a macro in ACL2.
  See [append]

  The [guard] for binary-append requires the first argument to be a
  [true-listp].

  Function: <binary-append>

    (defun binary-append (x y)
           (declare (xargs :guard (true-listp x)))
           (cond ((endp x) y)
                 (t (cons (car x)
                          (binary-append (cdr x) y)))))")
 (BIND-FREE
  (MISCELLANEOUS REWRITE)
  "To bind free variables of a rewrite, definition, or linear rule

    Examples:
    (IMPLIES (AND (RATIONALP LHS)
                  (RATIONALP RHS)
                  (BIND-FREE (FIND-MATCH-IN-PLUS-NESTS LHS RHS) (X)))
             (EQUAL (EQUAL LHS RHS)
                    (EQUAL (+ (- X) LHS) (+ (- X) RHS))))

    (IMPLIES (AND (BIND-FREE
                    (FIND-RATIONAL-MATCH-IN-TIMES-NESTS LHS RHS MFC STATE)
                    (X))
                  (RATIONALP X)
                  (CASE-SPLIT (NOT (EQUAL X 0))))
             (EQUAL (< LHS RHS)
                    (IF (< 0 X)
                        (< (* (/ X) LHS) (* (/ X) RHS))
                       (< (* (/ X) RHS) (* (/ X) LHS)))))

  General Forms:

    (BIND-FREE term var-list)
    (BIND-FREE term t)
    (BIND-FREE term)

  A rule which uses a bind-free hypothesis has similarities to both a
  rule which uses a [syntaxp] hypothesis and to a :[meta] rule.
  Bind-free is like [syntaxp], in that it logically always returns t
  but may affect the application of a :[rewrite], :[definition], or
  :[linear] rule when it is called at the top-level of a hypothesis.
  It is like a :[meta] rule, in that it allows the user to perform
  transformations of terms under progammatic control.

  Note that a bind-free hypothesis does not, in general, deal with the
  meaning or semantics or values of the terms, but rather with their
  syntactic forms. Before attempting to write a rule which uses
  bind-free, the user should be familiar with [syntaxp] and the
  internal form that ACL2 uses for terms. This internal form is
  similar to what the user sees, but there are subtle and important
  differences. [Trans] can be used to view this internal form.

  Just as for a [syntaxp] hypothesis, there are two basic types of
  bind-free hypotheses. The simpler type of bind-free hypothesis may
  be used as the nth hypothesis in a :[rewrite], :[definition], or
  :[linear] rule whose :[corollary] is (implies (and hyp1 ... hypn
  ... hypk) (equiv lhs rhs)) provided term is a term, term contains
  at least one variable, and every variable occuring freely in term
  occurs freely in lhs or in some hypi, i<n. In addition, term must
  not use any stobjs. Later below we will describe the second type,
  an extended bind-free hypothesis, which may use [state]. Whether
  simple or extended, a bind-free hypothesis may return an alist that
  binds free variables, as explained below, or it may return a list
  of such alists. We focus on the first of these cases: return of a
  single binding alist. We conclude our discussion with a section
  that covers the other case: return of a list of alists.

  We begin our description of bind-free by examining the first example
  above in some detail.

  We wish to write a rule which will cancel ``like'' addends from both
  sides of an equality. Clearly, one could write a series of rules
  such as

    (DEFTHM THE-HARD-WAY-2-1
       (EQUAL (EQUAL (+ A X B)
                     (+ X C))
              (EQUAL (+ A B)
                     (FIX C))))

  with one rule for each combination of positions the matching addends
  might be found in (if one knew before-hand the maximum number of
  addends that would appear in a sum). But there is a better way. (In
  what follows, we assume the presence of an appropriate set of rules
  for simplifying sums.)

  Consider the following definitions and theorem:

    (DEFUN INTERSECTION-EQUAL (X Y)
      (COND ((ENDP X)
             NIL)
            ((MEMBER-EQUAL (CAR X) Y)
             (CONS (CAR X) (INTERSECTION-EQUAL (CDR X) Y)))
            (T
             (INTERSECTION-EQUAL (CDR X) Y))))

    (DEFUN PLUS-LEAVES (TERM)
      (IF (EQ (FN-SYMB TERM) 'BINARY-+)
          (CONS (FARGN TERM 1)
                (PLUS-LEAVES (FARGN TERM 2)))
        (LIST TERM)))

    (DEFUN FIND-MATCH-IN-PLUS-NESTS (LHS RHS)
      (IF (AND (EQ (FN-SYMB LHS) 'BINARY-+)
               (EQ (FN-SYMB RHS) 'BINARY-+))
          (LET ((COMMON-ADDENDS (INTERSECTION-EQUAL (PLUS-LEAVES LHS)
                                                    (PLUS-LEAVES RHS))))
            (IF COMMON-ADDENDS
                (LIST (CONS 'X (CAR COMMON-ADDENDS)))
              NIL))
        NIL))

    (DEFTHM CANCEL-MATCHING-ADDENDS-EQUAL
      (IMPLIES (AND (RATIONALP LHS)
                    (RATIONALP RHS)
                    (BIND-FREE (FIND-MATCH-IN-PLUS-NESTS LHS RHS) (X)))
               (EQUAL (EQUAL LHS RHS)
                      (EQUAL (+ (- X) LHS) (+ (- X) RHS)))))

  How is this rule applied to the following term?

    (equal (+ 3 (expt a n) (foo a c))
           (+ (bar b) (expt a n)))

  As mentioned above, the internal form of an ACL2 term is not always
  what one sees printed out by ACL2. In this case, by using :[trans]
  one can see that the term is stored internally as

    (equal (binary-+ '3
                     (binary-+ (expt a n) (foo a c)))
           (binary-+ (bar b) (expt a n))).

  When ACL2 attempts to apply cancel-matching-addends-equal to the term
  under discussion, it first forms a substitution that instantiates
  the left-hand side of the conclusion so that it is identical to the
  target term. This substitution is kept track of by the substitution
  alist:

    ((LHS . (binary-+ '3
                       (binary-+ (expt a n) (foo a c))))
     (RHS . (binary-+ (bar b) (expt a n)))).

  ACL2 then attempts to relieve the hypotheses in the order they were
  given. Ordinarily this means that we instantiate each hypothesis
  with our substitution and then attempt to rewrite the resulting
  instance to true. Thus, in order to relieve the first hypothesis,
  we rewrite:

    (RATIONALP (binary-+ '3
                          (binary-+ (expt a n) (foo a c)))).

  Let us assume that the first two hypotheses rewrite to t. How do we
  relieve the bind-free hypothesis? Just as for a [syntaxp]
  hypothesis, ACL2 evaluates (find-match-in-plus-nests lhs rhs) in an
  environment where lhs and rhs are instantiated as determined by the
  substitution. In this case we evaluate

    (FIND-MATCH-IN-PLUS-NESTS '(binary-+ '3
                                          (binary-+ (expt a n) (foo a c)))
                              '(binary-+ (bar b) (expt a n))).

  Observe that, just as in the case of a [syntaxp] hypothesis, we
  substitute the quotation of the variables bindings into the term to
  be evaluated. See [syntaxp] for the reasons for this. The result of
  this evaluation, ((X . (EXPT A N))), is then used to extend the
  substitution alist:

    ((X . (EXPT A N))
     (LHS . (binary-+ '3
                       (binary-+ (expt a n) (foo a c))))
     (RHS . (binary-+ (bar b) (expt a n)))),

  and this extended substitution determines
  cancel-matching-addends-equal's result:

    (EQUAL (+ (- X) LHS) (+ (- X) RHS))
    ==>
    (EQUAL (+ (- (EXPT A N)) 3 (EXPT A N) (FOO A C))
           (+ (- (EXPT A N)) (BAR B) (EXPT A N))).

  Question: What is the internal form of this result?
  Hint: Use :[trans].

  When this rule fires, it adds the negation of a common term to both
  sides of the equality by selecting a binding for the otherwise-free
  variable x, under programmatic control. Note that other mechanisms
  such as the binding of [free-variables] may also extend the
  substitution alist.

  Just as for a [syntaxp] test, a bind-free form signals failure by
  returning nil. However, while a [syntaxp] test signals success by
  returning true, a bind-free form signals success by returning an
  alist which is used to extend the current substitution alist.
  Because of this use of the alist, there are several restrictions on
  it --- in particular the alist must only bind variables, these
  variables must not be already bound by the substitution alist, and
  the variables must be bound to ACL2 terms. If term returns an alist
  and the alist meets these restrictions, we append the alist to the
  substitution alist and use the result as the new current
  substitution alist. This new current substitution alist is then
  used when we attempt to relieve the next hypothesis or, if there
  are no more, instantiate the right hand side of the rule.

  There is also a second, optional, var-list argument to a bind-free
  hypothesis. If provided, it must be either t or a list of
  variables. If it is not provided, it defaults to t. If it is a list
  of variables, this second argument is used to place a further
  restriction on the possible values of the alist to be returned by
  term: any variables bound in the alist must be present in the list
  of variables. We strongly recommend the use of this list of
  variables, as it allows some consistency checks to be performed at
  the time of the rule's admittance which are not possible otherwise.

  An extended bind-free hypothesis is similar to the simple type
  described above, but it uses two additional variables, mfc and
  state, which must not be bound by the left hand side or an earlier
  hypothesis of the rule. They must be the last two variables
  mentioned by term: first mfc, then state. These two variables give
  access to the functions mfc-xxx; see [extended-metafunctions]. As
  described there, mfc is bound to the so-called metafunction-context
  and state to ACL2's [state]. See [bind-free-examples] for examples
  of the use of these extended bind-free hypotheses.

  SECTION: Returning a list of alists.

  As promised above, we conclude with a discussion of the case that
  evaluation of the bind-free term produces a list of alists, x,
  rather than a single alist. In this case each member b of x is
  considered in turn, starting with the first and proceeding through
  the list. Each such b is handled exactly as discussed above, as
  though it were the result of evaluating the bind-free term. Thus,
  each b extends the current variable binding alist, and all
  remaining hypotheses are then relieved, as though b had been the
  value obtained by evaluating the bind-free term. As soon as one
  such b leads to successful relieving of all remaining hypotheses,
  the process of relieving hypotheses concludes, so no further
  members of x are considered.

  We illustrate with a simple pedagogical example. First introduce
  functions p1 and p2 such that a rewrite rule specifies that p2
  implies p1, but with a free variable.

    (defstub p1 (x) t)
    (defstub p2 (x y) t)

    (defaxiom p2-implies-p1
      (implies (p2 x y)
               (p1 x)))

  If we add the following axiom, then (p1 x) follows logically for all
  x.

    (defaxiom p2-instance
      (p2 v (cons v 4)))

  Unfortunately, evaluation of (thm (p1 a)) fails, because ACL2 fails
  to bind the free variable y in order to apply the rule p2-instance.

  Let's define a function that produces a list of alists, each binding
  the variable y. Of course, we know that only the middle one below
  is necessary in this simple example. In more complex examples, one
  might use heuristics to construct such a list of alists.

    (defun my-alists (x)
      (list (list (cons 'y (fcons-term* 'cons x ''3)))
            (list (cons 'y (fcons-term* 'cons x ''4)))
            (list (cons 'y (fcons-term* 'cons x ''5)))))

  The following rewrite rule uses bind-free to return a list of
  candidate alists binding y.

    (defthm p2-implies-p1-better
      (implies (and (bind-free (my-alists x)
                               (y)) ; the second argument, (y), is optional
                    (p2 x y))
               (p1 x)))

  Now the proof succeeds for (thm (p1 a)). Why? When ACL2 applies the
  rewrite rule p2-implies-p1-better, it evaluates my-alists, as we
  can see from the following [trace], to bind y in three different
  alists.

    ACL2 !>(thm (p1 a))
    1> (ACL2_*1*_ACL2::MY-ALISTS A)
    <1 (ACL2_*1*_ACL2::MY-ALISTS (((Y CONS A '3))
                                  ((Y CONS A '4))
                                  ((Y CONS A '5))))

    Q.E.D.

  The first alist, binding y to (cons a '3), fails to allow the
  hypothesis (p2 x y) to be proved. But the next binding of y, to
  (cons a '4), succeeds: then the current binding alist is ((x . a)
  (y . (cons a '4))), for which the hypothesis (p2 x y) rewrites to
  true using the rewrite rule p2-instance.


Subtopics

  [Bind-free-examples]
      Examples pertaining to [bind-free] hypotheses")
 (BIND-FREE-EXAMPLES
  (BIND-FREE)
  "Examples pertaining to [bind-free] hypotheses

  See [bind-free] for a basic discussion of the use of bind-free to
  control rewriting.

  Note that the examples below all illustrate the common case in which
  a bind-free hypothesis generates a binding alist. See [bind-free],
  in particular the final section, for a discussion of the case that
  instead a list of binding alists is generated.

  We give examples of the use of [bind-free] hypotheses from the
  perspective of a user interested in reasoning about arithmetic, but
  it should be clear that [bind-free] can be used for many other
  purposes also.

  EXAMPLE 1: Cancel a common factor.

    (defun bind-divisor (a b)

    ; If a and b are polynomials with a common factor c, we return a
    ; binding for x.  We could imagine writing get-factor to compute the
    ; gcd, or simply to return a single non-invertible factor.

      (let ((c (get-factor a b)))
        (and c (list (cons 'x c)))))

    (defthm cancel-factor
      ;; We use case-split here to ensure that, once we have selected
      ;; a binding for x, the rest of the hypotheses will be relieved.
      (implies (and (acl2-numberp a)
                    (acl2-numberp b)
                    (bind-free (bind-divisor a b) (x))
                    (case-split (not (equal x 0)))
                    (case-split (acl2-numberp x)))
               (iff (equal a b)
                    (equal (/ a x) (/ b x)))))

  EXAMPLE 2: Pull integer summand out of floor. Note: This example has
  an extended [bind-free] hypothesis, which uses the term
  (find-int-in-sum sum mfc state).

    (defun fl (x)
      ;; This function is defined, and used, in the IHS books.
      (floor x 1))

    (defun int-binding (term mfc state)
      ;; The call to mfc-ts returns the encoded type of term. ;
      ;; Thus, we are asking if term is known by type reasoning to ;
      ;; be an integer. ;
      (declare (xargs :stobjs (state) :mode :program))
      (if (ts-subsetp (mfc-ts term mfc state)
                      *ts-integer*)
          (list (cons 'int term))
        nil))

    (defun find-int-in-sum (sum mfc state)
      (declare (xargs :stobjs (state) :mode :program))
      (if (and (nvariablep sum)
               (not (fquotep sum))
               (eq (ffn-symb sum) 'binary-+))
          (or (int-binding (fargn sum 1) mfc state)
              (find-int-in-sum (fargn sum 2) mfc state))
        (int-binding sum mfc state)))

    ; Some additional work is required to prove the following.  So for
    ; purposes of illustration, we wrap skip-proofs around the defthm.

    (skip-proofs
     (defthm cancel-fl-int
      ;; The use of case-split is probably not needed, since we should
      ;; know that int is an integer by the way we selected it.  But this
      ;; is safer.
       (implies (and (acl2-numberp sum)
                     (bind-free (find-int-in-sum sum mfc state) (int))
                     (case-split (integerp int)))
                (equal (fl sum)
                       (+ int (fl (- sum int)))))
       :rule-classes ((:rewrite :match-free :all)))
    )

    ; Arithmetic libraries will have this sort of lemma.
    (defthm hack (equal (+ (- x) x y) (fix y)))

    (in-theory (disable fl))

    (thm (implies (and (integerp x) (acl2-numberp y))
                  (equal (fl (+ x y)) (+ x (fl y)))))

  EXAMPLE 3: Simplify terms such as (equal (+ a (* a b)) 0)

    (defun factors (product)
      ;; We return a list of all the factors of product.  We do not
      ;; require that product actually be a product.
      (if (eq (fn-symb product) 'BINARY-*)
          (cons (fargn product 1)
                (factors (fargn product 2)))
        (list product)))

    (defun make-product (factors)
      ;; Factors is assumed to be a list of ACL2 terms.  We return an
      ;; ACL2 term which is the product of all the ellements of the
      ;; list factors.
      (cond ((atom factors)
             ''1)
            ((null (cdr factors))
             (car factors))
            ((null (cddr factors))
             (list 'BINARY-* (car factors) (cadr factors)))
            (t
             (list 'BINARY-* (car factors) (make-product (cdr factors))))))

    (defun quotient (common-factors sum)
      ;; Common-factors is a list of ACL2 terms.   Sum is an ACL2 term each
      ;; of whose addends have common-factors as factors.  We return
      ;; (/ sum (make-product common-factors)).
      (if (eq (fn-symb sum) 'BINARY-+)
          (let ((first (make-product (set-difference-equal (factors (fargn sum 1))
                                                           common-factors))))
            (list 'BINARY-+ first (quotient common-factors (fargn sum 2))))
        (make-product (set-difference-equal (factors sum)
                                            common-factors))))

    (defun intersection-equal (x y)
      (cond ((endp x)
             nil)
            ((member-equal (car x) y)
             (cons (car x) (intersection-equal (cdr x) y)))
            (t
             (intersection-equal (cdr x) y))))

    (defun common-factors (factors sum)
      ;; Factors is a list of the factors common to all of the addends
      ;; examined so far.  On entry, factors is a list of the factors in
      ;; the first addend of the original sum, and sum is the rest of the
      ;; addends.  We sweep through sum, trying to find a set of factors
      ;; common to all the addends of sum.
      (declare (xargs :measure (acl2-count sum)))
      (cond ((null factors)
             nil)
            ((eq (fn-symb sum) 'BINARY-+)
             (common-factors (intersection-equal factors (factors (fargn sum 1)))
                             (fargn sum 2)))
            (t
             (intersection-equal factors (factors sum)))))

    (defun simplify-terms-such-as-a+ab-rel-0-fn (sum)
      ;; If we can find a set of factors common to all the addends of sum,
      ;; we return an alist binding common to the product of these common
      ;; factors and binding quotient to (/ sum common).
      (if (eq (fn-symb sum) 'BINARY-+)
          (let ((common-factors (common-factors (factors (fargn sum 1))
                                                (fargn sum 2))))
            (if common-factors
                (let ((common (make-product common-factors))
                      (quotient (quotient common-factors sum)))
                  (list (cons 'common common)
                        (cons 'quotient quotient)))
              nil))
        nil))

    (defthm simplify-terms-such-as-a+ab-=-0
      (implies (and (bind-free
                     (simplify-terms-such-as-a+ab-rel-0-fn sum)
                     (common quotient))
                    (case-split (acl2-numberp common))
                    (case-split (acl2-numberp quotient))
                    (case-split (equal sum
                                       (* common quotient))))
               (equal (equal sum 0)
                      (or (equal common 0)
                          (equal quotient 0)))))

    (thm (equal (equal (+ u (* u v)) 0)
          (or (equal u 0) (equal v -1))))")
 (BOOK-COMPILED-FILE
  (BOOKS)
  "Creating and loading of compiled and expansion files for [books]

  An effect of [compilation] is to speed up the execution of the
  functions defined in a book. Compilation can also remove tail
  recursion, thus avoiding stack overflows. The presence of compiled
  code for the functions in the book should not otherwise affect the
  performance of ACL2. See [guard] for a discussion; also See
  [compilation].

  By default, the [certify-book] command compiles the book that it
  certifies. see [certify-book] for how to control this behavior.

  By default, the [include-book] command loads the compiled file for
  the book. The details of how this loading works are subtle, and do
  not need to be understood by most users. The ACL2 source code
  contains an ``Essay on Hash Table Support for Compilation'' that
  explains such details for those interested. All that users should
  generally need to know about this is that the compiled file is
  always the result of compiling a so-called ``expansion file'',
  which contains certain additional code besides the book itself. The
  relevance to users of the expansion file is that it can be loaded
  if the compiled file is missing (except when :load-compiled-file t
  is specified by the [include-book] form), and its existence is
  required in order for [include-book] to create a book's compiled
  file, as described below.

  Most users can skip the remainder of this documentation topic, which
  addresses the uncommon activity of using [include-book] to compile
  books.

  Include-book can be made to compile a book by supplying its keyword
  argument :load-compiled-file the value :comp. However, a compiled
  file can only be produced if there is already an expansion file
  that is at least as recent as the book's [certificate]. Such a
  file, whose name happens to be the result of concatenating the
  string \"@expansion.lsp\" to the book name (without the \".lisp\"
  suffix), is created by [certify-book] when state global variable
  'save-expansion-file has a non-nil value. That will be the case if
  ACL2 started up when environment variable ACL2_SAVE_EXPANSION was t
  (or any value that is not the empty string and whose
  [string-upcase] is not \"NIL\"), until the time (if any) that
  'save-expansion-file is assigned a different value by the user. In
  most respects, the :comp setting is treated exactly the same as
  :warn; but after all events in the book are processed, the
  expansion file is compiled if a compiled file was not loaded, after
  which the resulting compiled file is loaded.

  One can thus, for example, compile books for several different host
  Lisps --- useful when installing ACL2 executables at the same site
  that are built on different host Lisps. A convenient way to do this
  in an environment that provides Gnu `make' is to certify the
  community books using the shell command ``make regression'' in the
  acl2-sources/ directory, after setting environment variable
  ACL2_SAVE_EXPANSION to t, and then moving to the books directory
  and executing the appropriate `make' commands to compile the books
  (targets fasl, o, and so on, according to the compiled file
  extension for the host Lisp).

  We conclude by saying more about the :load-compiled-file argument of
  [include-book]. We assume that [state] global 'compiler-enabled has
  a non-nil value; otherwise :load-compiled-file is always treated as
  nil.

  We do not consider raw mode below (see [set-raw-mode]), which
  presents a special case: ACL2 will attempt to load the book itself
  whenever it would otherwise load the expansion or compiled file,
  but cannot (either because the :load-compiled-file argument is nil,
  or for each of the expansion and compiled files, either it does not
  exist or it is out of date with respect to the .cert file).

  The :load-compiled-file argument is not recursive: calls of
  include-book that are inside the book supplied to include-book use
  their own :load-compiled-file arguments. However, those subsidiary
  include-book calls can nevertheless be sensitive to the
  :load-compiled-file arguments of enclosing include-book calls, as
  follows. If :load-compiled-file has value t, then every subsidiary
  include-book is required to load a compiled file. Moreover, if a
  book's compiled file or expansion file is loaded in raw Lisp, then
  an attempt will be made to load the compiled file or expansion file
  for any [include-book] form encountered during that load. If that
  attempt fails, then that load immediately aborts, as does its
  parent load, and so on up the chain. If, when going up the chain,
  an [include-book] is aborted for which keyword argument
  :load-compiled-file has value t, then an error occurs.

  When loading a book's compiled file or expansion file, FILE, it is
  possible to encounter an [include-book] form for a book that has no
  suitable compiled file or expansion file. In that case, the load of
  FILE is aborted at that point. Similarly, the load of FILE is
  aborted in the case that this include-book form has a suitable
  compiled file or expansion file whose load is itself aborted. Thus,
  whenever any include-book aborts, so do all of its parent
  include-books, up the chain. Such an abort causes an error when the
  include-book form specifies a :load-compiled-file value of t.")
 (BOOK-CONTENTS
  (BOOKS)
  "Restrictions on the forms inside [books]

    Example Book:

    ; This book defines my app function and the theorem that it is
    ; associative.  One irrelevant help lemma is proved first but
    ; it is local and so not seen by include-book.  I depend on the
    ; inferior book \"weird-list-primitives\" from which I get
    ; definitions of hd and tl.

    (in-package \"MY-PKG\")

    (include-book \"weird-list-primitives\")

    (defun app (x y) (if (consp x) (cons (hd x) (app (tl x) y)) y))

    (local
     (defthm help-lemma
       (implies (true-listp x) (equal (app x nil) x))))

    (defthm app-is-associative
      (equal (app (app a b) c) (app a (app b c))))

  The first form in a book must be (in-package \"pkg\") where \"pkg\" is
  some package name known to ACL2 whenever the book is certified. The
  rest of the forms in a book are embedded event forms, i.e.,
  [defun]s, [defthm]s, etc., some of which may be marked [local]. See
  [embedded-event-form]. The usual Common Lisp commenting conventions
  are provided. Note that since a book consists of embedded event
  forms, we can talk about the ``[local]'' and ``non-local'' [events]
  of a book.

  Because [in-package] is not an embedded event form, the only
  [in-package] in a book is the initial one. Because [defpkg] is not
  an embedded event form, a book can never contain a [defpkg] form.
  Because [include-book] is an embedded event form, [books] may
  contain references to other [books]. This makes [books] structured
  objects.

  When the forms in a book are read from the file, they are read with
  [current-package] set to the package named in the [in-package] form
  at the top of the file. The effect of this is that all symbols are
  [intern]ed in that package, except those whose packages are given
  explicitly with the ``::'' notation. For example, if a book begins
  with (in-package \"ACL2-X\") and then contains the form

    (defun fn (x)
      (acl2::list 'car x))

  then [defun], fn, x, and [car] are all [intern]ed in the \"ACL2-X\"
  package. I.e., it is as though the following form were read
  instead:

    (acl2-x::defun acl2-x::fn (acl2-x::x)
        (acl2::list 'acl2-x::car acl2-x::x)).

  Of course, acl2-x::defun would be the same symbol as acl2::defun if
  the \"ACL2-X\" package imported acl2::defun.

  If each book has its own unique package name and all the names
  defined within the book are in that package, then name clashes
  between [books] are completely avoided. This permits the
  construction of useful logical [world]s by the successive inclusion
  of many [books]. Although it is often too much trouble to manage
  several packages, their judicious use is a way to minimize name
  clashes. Often, a better way is to use local; see [local].

  How does [include-book] know the definitions of the packages used in
  a book, since [defpkg]s cannot be among the forms? More generally,
  how do we know that the forms in a book will be admissible in the
  host logical [world] of an [include-book]? See [certificate] for
  answers to these questions.")
 (BOOK-EXAMPLE
  (BOOKS)
  "How to create, certify, and use a simple book

  Suppose you have developed a sequence of admissible [events] which
  you want to turn into a book. We call this ``publishing'' the book.
  This note explains how to do that.

  A key idea of [books] is that they are ``incremental'' in the sense
  that when you include a book in a host logical [world], the [world]
  is incrementally extended by the results established in that book.
  This is allowed only if every name defined by the incoming book is
  either new or is already identically defined. See
  [redundant-events]. This is exactly the same problem faced by a
  programmer who wishes to provide a utility to other people: how can
  he make sure he doesn't create name conflicts? The solution, in
  Common Lisp, is also the same: use packages. While [books] and
  packages have a very tenuous formal connection (every book must
  start with an [in-package]), the creation of a book is intimately
  concerned with the package issue. Having motivated what would
  otherwise appear as an unnecessary fascination with packages below,
  we now proceed with a description of how to publish a book.

  Just to be concrete, let's suppose you have already gotten ACL2 to
  accept the following sequence of [command]s, starting in the ACL2
  initial [state].

    (defpkg \"ACL2-MY-BOOK\"
            (union-eq *common-lisp-symbols-from-main-lisp-package*
                      *acl2-exports*))
    (in-package \"ACL2-MY-BOOK\")
    (defun app (x y)
      (if (consp x) (cons (car x) (app (cdr x) y)) y))
    (defun rev (x)
      (if (consp x) (app (rev (cdr x)) (list (car x))) nil))
    (defthm rev-app-hack
      (equal (rev (app a (list x))) (cons x (rev a))))
    (defthm rev-rev
      (implies (acl2::true-listp x) (equal (rev (rev x)) x)))

  Observe that the first form above defines a package (which imports
  the symbols defined in CLTL such as [if] and [cons] and the symbols
  used to [command] ACL2 such as [defun] and [defthm]). The second
  form selects that package as the current one. All subsequent forms
  are read into that package. The remaining forms are just event
  forms: [defun]s and [defthm]s in this case.

  Typically you would have created a file with Emacs containing these
  forms and you will have submitted each of them interactively to
  ACL2 to confirm that they are all admissible. That interactive
  verification should start in ACL2's initial [world] --- although
  you might, of course, start your sequence of [events] with some
  [include-book]s to build a more elaborate [world].

  The first step towards publishing a book containing the results above
  is to create a file that starts with the [in-package] and then
  contains the rest of the forms. Let's call that file
  \"my-book.lisp\". The name is unimportant, except it must end with
  \".lisp\". If there are [events] that you do not wish to be available
  to the user of the book --- e.g., lemmas you proved on your way
  toward proving the main ones --- you may so mark them by enclosing
  them in [local] forms. See [local]. Let us suppose you wish to hide
  rev-app-hack above. You may also add standard Lisp comments to the
  file. The final content of \"my-book.lisp\" might be:

    ; This book contains my app and rev functions and the theorem
    ; that rev is its own inverse.

      (in-package \"ACL2-MY-BOOK\")
      (defun app (x y)
        (if (consp x) (cons (car x) (app (cdr x) y)) y))
      (defun rev (x)
        (if (consp x) (app (rev (cdr x)) (list (car x))) nil))

    ; The following hack is not exported.
      (local (defthm rev-app-hack
        (equal (rev (app a (list x))) (cons x (rev a)))))

      (defthm rev-rev
        (implies (acl2::true-listp x) (equal (rev (rev x)) x)))

  The file shown above is the book. By the time this note is done you
  will have seen how to certify that the book is correct, how to
  compile it, and how to use it in other host [world]s. Observe that
  the [defpkg] is not in the book. It cannot be: Common Lisp
  compilers disagree on how to treat new package definitions
  appearing in files to be compiled.

  Since a book is just a source file typed by the user, ACL2 provides a
  mechanism for checking that the [events] are all admissible and
  then marking the file as checked. This is called certification. To
  certify \"my-book.lisp\" you should first get into ACL2 with an
  initial [world]. Then, define the package needed by the book, by
  typing the following [defpkg] to the ACL2 [prompt]:

    ACL2 !>(defpkg \"ACL2-MY-BOOK\"
                   (union-eq *common-lisp-symbols-from-main-lisp-package*
                             *acl2-exports*))

  Then execute the [command]:

    ACL2 !>(certify-book \"my-book\" 1 t) ; the `t' is in fact the default

  Observe that you do not type the \".lisp\" part of the file name. For
  purposes of [books], the book's name is \"my-book\" and by the time
  all is said and done, there will be several extensions in addition
  to the \".lisp\" extension associated with it.

  The 1 tells [certify-book] that you acknowledge that there is one
  command in this ``certification [world]'' (namely the [defpkg]). To
  use the book, any prospective host [world] must be extended by the
  addition of whatever [command]s occurred before certification. It
  would be a pity to certify a book in a [world] containing junk
  because that junk will become the ``[portcullis]'' guarding
  entrance to the book. The t above tells [certify-book] that you
  wish to compile \"my-book.lisp\" also (but see [compilation] for an
  exception). [Certify-book] makes many checks but by far the most
  important and time-consuming one is that it ``proves'' every event
  in the file.

  When [certify-book] is done it will have created two new files. The
  first will be called \"my-book.cert\" and contains the
  ``[certificate]'' attesting to the admissibility of the [events] in
  \"my-book.lisp\". The [certificate] contains the [defpkg] and any
  other forms necessary to construct the certification [world]. It
  also contains various check sums used to help you keep track of
  which version of \"my-book.lisp\" was certified.

  The second file that may be created by [certify-book] is the compiled
  version of \"my-book.lisp\" and will have a name that is assigned by
  the host compiler (e.g., \"my-book.o\" in GCL, \"my-book.fasl\" in
  SBCL). [Certify-book] will also load this object file. When
  [certify-book] is done, you may throw away the logical [world] it
  created, for example by executing the [command] :u.

  To use the book later in any ACL2 session, just execute the event
  (include-book \"my-book\"). This will do the necessary [defpkg], load
  the non-[local] [events] in \"my-book.lisp\" and then may load the
  compiled code for the non-local functions defined in that file.
  Checks are made to ensure that the [certificate] file exists and
  describes the version of \"my-book.lisp\" that is read. The compiled
  code is loaded if and only if it exists and has a later write date
  than the source file (but see [compilation] for an exception).

  Since [include-book] is itself an event, you may put such forms into
  other [books]. Thus it is possible for the inclusion of a single
  book to lead to the inclusion of many others. The check sum
  information maintained in [certificate]s helps deal with the
  version control problem of the referenced [books]. I.e., if this
  version of \"my-book\" is used during the certification of
  \"your-book\", then the [certificate] for \"your-book\" includes the
  check sum of this version of \"my-book\". If a later (include-book
  \"your-book\") finds a version of \"my-book\" with a different check
  sum, an error is signalled. But check sums are not perfect and the
  insecurity of the host file system prevents ACL2 from guaranteeing
  the logical soundness of an [include-book] event, even for a book
  that appears to have a valid [certificate] (they can be forged,
  after all). (See [certificate] for further discussion.)

  This concludes the example of how to create, certify and use a book.
  If you wish, you could now review the [documentation] for
  book-related topics (see [books]) and browse through them. They'll
  probably make sense in this context. Alternatively, you could
  continue the ``guided tour'' through the rest of the
  [documentation] of [books]. See [book-name], following the pointer
  given at the conclusion.")
 (BOOK-MAKEFILES (POINTERS)
                 "See [books-certification].")
 (BOOK-NAME
  (BOOKS)
  "Conventions associated with book names

    Examples:
    \"list-processing\"
    \"/usr/home/smith/my-arith\"

  Book names are string constants that can be elaborated into file
  names. We elaborate book names by concatenating the ``connected
  book directory'' (see [cbd]) string on the left and some
  ``extension,'' such as \".lisp\", on the right. However, the
  connected book directory is not added if the book name itself
  already represents an absolute file name. Furthermore,
  [include-book] and [certify-book] temporarily reset the connected
  book directory to be the directory of the book being processed.
  This allows [include-book] forms to use file names without explicit
  mention of the enclosing book's directory. This in turn allows
  [books] (together with those that they include, using
  [include-book]) to be moved between directories while maintaining
  their certification and utility.

  You may wish to read elsewhere for details of ACL2 file name
  conventions (see [pathname]), for a discussion of the filename that
  is the result of the elaboration described here (see
  [full-book-name]), and for details of the concept of the connected
  book directory (see [cbd]). For details of how [include-book] (see
  [include-book]) and [certify-book] (see [certify-book]) use these
  concepts, see below.

  Often a book name is simply the familiar name of the file. (See
  [full-book-name] for discussion of the notions of ``directory
  string,'' ``familiar name,'' and ``extension''. These concepts are
  not on the guided tour through [books] and you should read them
  separately.) However, it is permitted for book names to include a
  directory or part of a directory name. Book names never include the
  extension, since ACL2 must routinely tack several different
  extensions onto the name during [include-book]. For example,
  [include-book] uses the \".lisp\", \".cert\" and possibly the \".o\" or
  \".lbin\" extensions of the book name.

  Book names are elaborated into full file names by [include-book] and
  [certify-book]. This elaboration is sensitive to the ``connected
  book directory.'' The connected book directory is an absolute
  filename string (see [pathname]) that is part of the ACL2 [state].
  (You may wish to see [cbd] and to see [set-cbd] --- note that these
  are not on the guided tour). If a book name is an absolute filename
  string, ACL2 elaborates it simply by appending the desired
  extension to the right. If a book name is a relative filename
  string, ACL2 appends the connected book directory on the left and
  the desired extension on the right.

  Note that it is possible that the book name includes some partial
  specification of the directory. For example, if the connected book
  directory is \"/usr/home/smith/\" then the book name
  \"project/task-1/arith\" is a book name that will be elaborated to

    \"/usr/home/smith/project/task-1/arith.lisp\".

  Observe that while the [events] in this \"arith\" book are being
  processed the connected book directory will temporarily be set to

    \"/usr/home/smith/project/task-1/\".

  Thus, if the book requires other [books], e.g.,

    (include-book \"naturals\")

  then it is not necessary to specify the directory on which they
  reside provided that directory is the same as the superior book.

  This inheritance of the connected book directory and its use to
  elaborate the names of inferior [books] makes it possible to move
  [books] and their inferiors to new directories, provided they
  maintain the same relative relationship. It is even possible to
  move with ease whole collections of [books] to different
  filesystems that use a different operating system than the one
  under which the original certification was performed.

  The \".cert\" extension of a book, if it exists, is presumed to contain
  the most recent [certificate] for the book. See [certificate] (or,
  if you are on the guided tour, wait until the tour gets there).

  See [book-contents] to continue the guided tour.")
 (BOOKDATA
  (BOOKS)
  "An optional tool for writing out small files with meta-data about the
  books that are being certified.

  ACL2 provides a primitive capability for writing out a file of data
  associated with a book. This information might be useful, for
  example, in building a database that allows you to search for name
  conflicts. If you use this capability and have ideas for enhancing
  it, please feel free to send them to the ACL2 developers.

  If the book has the name BK, then the output file is named
  BK__bookdata.out. That file is generated in the same directory as
  BK, by certifying BK when [state] global 'write-bookdata has a
  non-nil value, for example as follows.

    (assign write-bookdata t)
    (certify-book \"BK\" ...)

  The resulting file will contain a single form of the following shape,
  according to the description that follows below.

    (\"...BK.lisp\"
     :PKGS     port-pkgs
     :BOOKS    (port-book-val book-val)
     :CONSTS   (port-consts-val consts-val)
     :FNS      (port-fns-val fns-val)
     :LABELS   (port-labels-val labels-val)
     :MACROS   (port-macros-val macros-val)
     :STOBJS   (port-stobjs-val stobjs-val)
     :THEORIES (port-theories-val theories-val)
     :THMS     (port-thms-val thms-val))

  The values above are based on [events] introduced by including BK.
  For various values of xxx as described below, port-xxx-val is a
  list of values corresponding to [events] introduced in the
  certification [world] for BK (see [portcullis]), and xxx-val is a
  list of values corresponding to [events] introduced non-[local]ly
  by BK. These lists include only ``top-level'' events, not those
  that are introduced by a book included either in BK or its
  certification world.

  Port-pkgs is a list of names of packages introduced in the
  certification world (at the top level, not in an included book).
  Note that no packages are introduced in a book itself, so we don't
  include a ``pkgs'' result. Both port-book-val and book-val are
  lists of full book names (see [full-book-name]) of included books.
  For the other keywords :xxx, the lists port-xxx-val and xxx-val are
  actually association lists (see [alistp]) such that each key is a
  package name, which is associated with a list of [symbol-name]s for
  symbols in that package that are introduced for that keyword. For
  example, fns-val may be the alist

    ((\"ACL2\" \"F1\" \"F2\")
     (\"MY-PKG\" \"G1\" \"G2\"))

  if the function symbols introduced in the book are F1 and F2 in the
  \"ACL2\" package, as well as G1 and G2 in the \"MY-PKG\" package.

  We next explain what kinds of symbols are introduced for each keyword
  :xxx. Each such symbol would appear in the list port-xxx-val or
  xxx-val, depending respectively on whether the symbol is introduced
  at the top level of the certification world for BK or BK itself.

      o :CONSTS
      constant symbol introduced by defconst

      o :FNS
      function symbol: introduced by defun, defuns, or defchoose; or
      constrained (by an [encapsulate] event)

      o :LABELS
      symbol introduced by deflabel

      o :MACROS
      macro name introduced by defmacro

      o :STOBJS
      stobj name introduced by defstobj or defabsstobj

      o :THEORIES
      theory name introduced by deftheory

      o :THMS
      theorem name, which may be introduced by defthm or a macro call
      expanding to a call of defthm, such as see [defequiv] or
      defaxiom; but may be introduced by [defpkg], for example, with
      name \"MYPKG-PACKAGE\" if the package name is \"MYPKG\"

  Our hope is that people in the ACL2 community will generate and use
  this data to improve the ACL2 [community-books]. Here is an example
  illustrating how to generate bookdata files for those books as a
  byproduct of a regression run. Below, we write {DIR} as an
  abbreviation for the ACL2 sources directory, and assume that this
  command is run from that directory. Of course, you may wish to use
  make options like -j 8 and make variable settings like
  ACL2={DIR}/my-saved_acl2; see [books-certification] for details.

    make regression-fresh \\
    ACL2_CUSTOMIZATION={DIR}/acl2-customization-files/bookdata.lisp")
 (BOOKS
  (ACL2 NOTE1)
  "Books are files of ACL2 [events]---they are the main way to split up
  large ACL2 developments into separate modules.

  This [documentation] topic is about ACL2 source code files. However,
  there are also traditional, paper books published about ACL2 and
  its applications.

  You will almost surely want to organize your own ACL2 work into
  books. They facilitate reuse, allow you to reload proofs more
  quickly, allow you to rebuild parts of your proof in parallel, and
  so forth. You will also want to be aware of the many community
  books, which provide useful tools and lemmas to build upon. See
  [community-books] for more information, including how to
  contribute.


Introduction

  A book is a file of ACL2 forms. Books are prepared entirely by the
  user of the system, i.e., they are source files not object files.
  Some of the forms in a book are marked [local] and the others are
  considered ``non-local.''

  [Include-book] lets you load a book into any ACL2 [world]. A
  successful include-book extends the logic of the host [world] by
  adding just the non-local [events] in the book. Ordinarily, you
  might include a variety of books to load all of their definitions
  and rules.

  Successful book inclusion is consistency preserving, provided that
  the book itself is consistent, as discussed later. However,
  [include-book] assumes the [events] in a book are valid, so if you
  include a book that contains an inconsistency (e.g., an
  inadmissible definition) then the resulting theory is inconsistent!

  [Certify-book] lets you certify a book to guarantee that its
  successful inclusion is consistency preserving. During
  certification, both the [local] and non-local forms are processed.
  This lets you mark as [local] any [events] you need for
  certification, but that you want to hide from users of the
  book---e.g., the hacks, crocks, and kludges on the way to a good
  set of [rewrite] rules.

  Certification can also [compile] a book to speed up the execution of
  the functions defined within it. The desire to compile books is
  largely responsible for the restrictions we put on the forms
  allowed in books.

  Extensive [documentation] is available on the various aspects of
  books. We recommend that you read it all before using books. It has
  been written so as to make sense when read in a certain linear
  sequence, called the ``guided tour'', though in general you may
  browse through it randomly. If you are on the guided tour, you
  should next read [book-example].


Subtopics

  [Book-compiled-file]
      Creating and loading of compiled and expansion files for [books]

  [Book-contents]
      Restrictions on the forms inside [books]

  [Book-example]
      How to create, certify, and use a simple book

  [Book-name]
      Conventions associated with book names

  [Bookdata]
      An optional tool for writing out small files with meta-data about
      the books that are being certified.

  [Books-certification]
      Instructions for certifying the ACL2 [community-books].

  [Books-certification-classic]
      Classic ACL2 `make'-based certification of [books]

  [Cbd]
      Connected book directory string

  [Certificate]
      How a book is known to be admissible and where its [defpkg]s reside

  [Certify-book]
      How to produce a [certificate] for a book

  [Community-books]
      Libraries of ACL2 [books] developed by the ACL2 community.

  [Full-book-name]
      Book naming conventions assumed by ACL2

  [Include-book]
      Load the [events] in a file

  [Keep]
      How we know if [include-book] read the correct files

  [Pathname]
      Introduction to filename conventions in ACL2

  [Portcullis]
      The gate guarding the entrance to a certified book

  [Provisional-certification]
      Certify a book in stages for improved parallelism

  [Set-cbd]
      To set the connected book directory

  [Uncertified-books]
      Invalid [certificate]s and uncertified [books]")
 (BOOKS-CERTIFICATION
  (BOOKS)
  "Instructions for certifying the ACL2 [community-books].

  Starting in ACL2 6.4 we recommend using the new Community Books make
  system to certify the books. If you encounter problems using the
  new system (described below) or need some feature that is no longer
  available, please see [books-certification-alt] for alternate
  instructions. We have not changed how make regression works from
  the acl2-sources directory.


Prerequisites

  We assume that you have already downloaded and installed ACL2 as per
  the ACL2 installation instructions on the ACL2 home page.

  We assume you know the path to your ACL2 executable. Typically this
  is a script named saved_acl2 in your acl2-sources directory.

  We assume the ACL2 [community-books] are installed in the books/
  subdirectory of your ACL2 distribution, as is the case when you
  have followed the ACL2 installation instructions above.

  The instructions below are suitable for ACL2 and its experimental
  extensions, ACL2(p) and ACL2(h). If you are using ACL2(r), please
  instead see [books-certification-alt].


A Basic Build

  In previous versions of ACL2, building the Community Books could take
  several hours. Starting in ACL2 6.4, the default build has been
  made much faster by excluding many books by default.

  The new default make target, called basic, now certifies only the
  following, widely used books:

    * arithmetic
    * arithmetic-2
    * arithmetic-3
    * arithmetic-5
    * [ihs]
    * misc
    * tools
    * [std]
    * [str]
    * [xdoc]
    * data-structures

  To certify these books, you should be able to run make as follows.
  The -j 2 part of this command is suitable for a computer with two
  cores. If you have, e.g., a quad-core computer, you should probably
  use -j 4 instead, and so on.

    $ cd /path/to/acl2-sources/books
    $ make ACL2=/path/to/acl2-sources/saved_acl2 -j 2 basic

  If you configure your PATH so that you can launch ACL2 by typing
  acl2, then you may omit the ACL2=... part.


Certifying Additional Books

  We expect that most ACL2 users will want to certify at least the
  basic books described above. But what if you also need other books?

  One option is to do a full build (see below). But it is usually much
  faster to simply tell make to build the books you actually want to
  use.

  There are make targets corresponding to most directory names. For
  instance, to build the books under coi and rtl and cgen, you can
  run:

    $ cd /path/to/acl2-sources/books
    $ make ACL2=/path/to/acl2-sources/saved_acl2 coi rtl cgen -j 2

  For finer grained control, you can name individual books. For
  instance, if you want the rtl/rel9 library, you could run:

    $ cd /path/to/acl2-sources/books
    $ make ACL2=/path/to/acl2-sources/saved_acl2 rtl/rel9/lib/top.cert -j 2


A Full Build

  Building all of the books can take hours and is usually unnecessary,
  but is easy to do: just run make all, e.g.,

    $ cd /path/to/acl2-sources/books
    $ make ACL2=/path/to/acl2-sources/saved_acl2 -j 2 all

  This actually still skips a few books that are very slow. If you
  really need to certify absolutely everything, you can run make
  everything, but this will likely add hours to your build!


ACL2 Extensions and Additional Software

  Note that some books require experimental extensions of ACL2 (e.g., a
  book may work with ACL2(h) but not with ordinary ACL2). Other books
  require certain additional software.

  The build system will automatically determine which kind of ACL2 you
  are running (e.g., ACL2, ACL2(h), ACL2(p)) and, based on this, may
  prevent incompatible books from being certified. The output of make
  should explain which books are being excluded and why.

  Some books, especially [interfacing-tools] like [oslib] and the ACL2
  [bridge], require [quicklisp], a tool for installing Common Lisp
  libraries. Quicklisp does not work with all Lisps that can run
  ACL2, so you must explicitly enable it by setting USE_QUICKLISP=1
  in your make command. For instance:

    make ACL2=... USE_QUICKLISP=1 centaur/doc.cert -j 4

  Using Quicklisp should definitely work for CCL. We have not tested it
  with other Lisps, but it will likely work for SBCL and CMUCL, and
  will almost certainly not work for GCL.

  Some other books based on [satlink] and [gl] require a SAT solver,
  typically Glucose, to be installed; see
  [satlink::sat-solver-options] for installation options. The build
  system should automatically determine if Glucose is installed on
  your system, and will avoid trying to certify these books unless
  Glucose is present.


Cleaning Up

  If you want to delete generated files, you can run make clean to
  remove certificates, compiled files, and build logs.

  If you just want to remove the files in a particular subdirectory
  (and its subdirectories), you can go into that directory and then
  run the build/clean.pl script. This will delete, starting from your
  current directory, recursively, all certificates, logs, compiled
  files, etc.

  Note that make clean doesn't remove some files, e.g., [xdoc] manuals.
  To remove everything, try make moreclean.


Further Resources

  The new build system is largely based on [cert.pl]. There is
  considerable documentation about cert.pl, and we highly recommend
  using it to manage your own ACL2 projects.

  The main build script is books/GNUmakefile. There are considerable
  comments at the start of this file, and you can also inspect it to
  see what targets are available.

  Please feel absolutely free to contact the [ACL2-help] mailing list
  with any questions about building the community books.


Subtopics

  [Books-certification-alt]
      Alternate instructions for certifying the [community-books], from
      the perspective of the acl2-sources directory.")
 (BOOKS-CERTIFICATION-ALT
  (BOOKS-CERTIFICATION)
  "Alternate instructions for certifying the [community-books], from the
  perspective of the acl2-sources directory.

  For background on the ACL2 community books, see [community-books].
  Here we explain how to certify those books, or some of those books,
  with ACL2. We thank Bishop Brock, Jared Davis, and Sol Swords for
  their substantial contributions to this methodology. See
  books/GNUmakefile, in the community books, for more about ``Credits
  and History'', and for additional technical details not covered in
  this topic.

  For more information about installing ACL2, see the ACL2 installation
  instructions. For information about so-called ``classic ACL2
  `make'-based certification'', which provides support for certifying
  directories of books but may disappear in a future ACL2 release,
  see [books-certification-classic].

  The Basics

  We make the following assumptions.

    * Gnu `make' is available on your system via the `make' command (rather
      than some other flavor of `make'). (Execute `make --version to
      verify this.)
    * You have built or obtained an ACL2 executable.
    * The ACL2 [community-books] are installed in the books/ subdirectory
      of your ACL2 distribution, as is the case when you have
      followed the standard installation instructions.

  Note: All commands shown below are issued in the top-level (ACL2
  sources) directory of your ACL2 distribution.

  By default the ACL2 executable is file saved_acl2 in your ACL2
  sources directory, and you can issue the following command to the
  shell in order to do a ``regression run'' that certifies all of the
  community books using that executable.

    make regression

  Better yet, save a log file in case there are problems, for example
  as follows.

    (make regression) >& make-regression.log

  or perhaps better yet:

    (time nice make regression) >& make-regression.log

  For the sake of brevity, below we'll skip mentioning any of `time',
  `nice', or `>& make-regression.log'. But saving a log file, in
  particular, is useful in case you encounter problems to report.

  If you fetched the community books using svn, then you will have a
  directory books/workshops/ that is not necessary for certifying the
  other books. If you want to skip certification of the books under
  books/workshops/, use target `certify-books' instead of target
  `regression', for example as follows.

    (time nice make certify-books) >& make-certify-books.log

  Whether you use target `regression' or target `certify-books', then
  for each book foo.lisp whose certification is attempted, a file
  foo.cert.out in the same directory will contain the output from the
  book's certification attempt.

  A regression run may take a few hours, but if you have a
  multiprocessing computer, you can speed it up by certifying some
  books in parallel, by providing a value for `make' option -j. For
  example, if you have 8 hardware threads then you might want to
  issue the following command.

    make regression -j 8

  Specifying the ACL2 Executable

  If your ACL2 executable is not file saved_acl2 in the ACL2 sources
  directory, then you will need to specify that executable. You can
  do that by setting variable ACL2, either as an environment variable
  or, as displayed below, as a `make' variable. Either way, you will
  need to avoid relative pathnames. For example, the first two forms
  below are legal, but the third is not, assuming that my-acl2 is on
  your PATH in a Unix-like environment (e.g., linux or MacOS) and
  that my-saved_acl2 is just a pathname relative to your ACL2 sources
  directory, which is not on your path.

    make regression -j 8 ACL2=my-acl2
    make regression -j 8 ACL2=/u/smith/bin/acl2
    # The following only works if my-saved_acl2 is on your path (see above).
    make regression -j 8 ACL2=my-saved_acl2

  Cleaning

  You can delete files generated by book certification (including .cert
  files, .out files, compiled files, and more) by issuing the
  following command (again, in your ACL2 sources directory).

    make clean-books

  If you want to cause such deletion and then do a regression, simply
  replace the `regression' or `certify-books' target by
  `regression-fresh' or `certify-books-fresh', respectively, for
  example as follows. follows.

    make -j 4 regression-fresh
    make -j 4 certify-books-fresh

  If however you only want to clean up generated files residing under a
  given directory (or its subdirectories, and recursively), you can
  issue the following command while standing in that directory, where
  DIR is a pathname of your books directory.

    DIR/clean.pl

  For example, to clean up generated files under books/arithmetic, you
  could do the following.

    cd books/arithmetic
    ../clean.pl
    cd - # to return to the ACL2 sources directory, if you wish to do so

  Restricting to Specific Directories and Books

  You can specify which books you want certified by using any or all of
  the variables EXCLUDED_PREFIXES, ACL2_BOOK_CERTS, or
  ACL2_BOOK_DIRS. First, the set of desired .cert files is restricted
  to those that do not start with any string that is one of the words
  in the value of EXCLUDED_PREFIXES. Then ACL2_BOOK_CERTS and
  ACL2_BOOK_DIRS, if supplied, specify which books should be
  certified, as illustrated by the following example.

    make -j 8 regression-fresh \\
     ACL2_BOOK_DIRS=\"symbolic paco\" \\
     ACL2_BOOK_CERTS=\" \\
      workshops/2006/cowles-gamboa-euclid/Euclid/ed6a.cert \\
      workshops/2006/cowles-gamboa-euclid/Euclid/ed4bb.cert \\
      \"

  Then all book in directories symbolic and paco will be certified, as
  will the books workshops/2006/cowles-gamboa-euclid/Euclid/ed6a.lisp
  and workshops/2006/cowles-gamboa-euclid/Euclid/ed4bb.lisp. Note
  that all pathnames should be relative to your community books
  directory; in particular, they should not be absolute pathnames.
  Also notice the .cert extension used in files supplied for
  ACL2_BOOK_CERTS.

  Alternatively, you may wish to invoke books/cert.pl while standing in
  a directory under which you want to certify books. This will
  certify not only those books, but all supporting books --- even
  those not under the current directory --- that do not have
  up-to-date .cert files. The following is a simple command to invoke
  that will certify all books in the current directory, where if the
  books/ directory is not on your path, you will need to provide a
  suitable filename, e.g. ../../cert.pl or ~/acl2/books/cert.pl.

    cert.pl -j 4 *.lisp

  Here is a more complex command, which illustrates a way to certify
  books in subdirectories (as well as the current directory), the use
  of provisional certification (see [provisional-certification]), and
  `make'-level parallelism (in this case specifying four parallel
  processes).

    ACL2_PCERT=t cert.pl -j 4 `find . -name '*.lisp'`

  Note that with this approach, unlike classic ACL2 `make'-based
  certification (see [books-certification-classic], out-of-date .cert
  files that are not under the current directory will also be built.
  For documentation of cert.pl invoke:

    cert.pl -h

  See the top of cert.pl for authorship and copyright information.

  Finally, we give a brief summary of how to use so-called ``classic
  ACL2 `make'-based certification'' for community books; see
  [books-certification-classic] for details. Note that support for
  this approach might be eliminated in a future ACL2 release. We
  welcome comments from the ACL2 community about whether or not that
  would be a good thing to do. See the discussion above about
  ACL2_BOOK_DIRS for the ``modern'' way to accomplish the same thing.

  Many community book directories have a Makefile. If you modify books
  only in such a directory, you can recertify by standing in that
  directory and issuing a `make' command. This command can optionally
  specify an ACL2 executable as well as parallelism, for example as
  follows, where the first line (make clean) is optional.

    make clean
    (time nice make -j 8 ACL2=my-acl2)

  ACL2 Customization Files

  By default, your acl2-customization file (see [ACL2-customization])
  is ignored by all flavors of ``make regression''. However, you can
  specify the use of an acl2-customization file by setting the value
  of environment variable ACL2_CUSTOMIZATION to the empty string,
  indicating a default such file, or to the desired absolute
  pathname. For example:

    make regression ACL2_CUSTOMIZATION=''
    make regression ACL2_CUSTOMIZATION='~/acl2-customization.lisp'

  Regressions for Experimental Extensions of ACL2

  The instructions are unchanged if you are using ACL2(h) (see
  [hons-and-memoization]). However, note that the default executable
  (when ACL2 is not specified) remains saved_acl2 in your ACL2
  sources directory, not saved_acl2h as one might expect for
  ACL2(h)(p), respectively. So probably you'll want to supply
  ``ACL2=<your_acl2>'' explicitly with your `make' command.

  The comments above also pertain pertain to using ACL2(p) (see
  [parallel]); the default is saved_acl2 rather than saved_acl2p.
  However, we recommend that you use ACL2, not ACL2(p), for your
  regression. Then you can use ACL2(p) for your own proof
  developments. (The analogous comment applies to ACL2(hp), which
  combines capabilities of ACL2(h) and ACL2(p), i.e., we recommend
  that you use ACl2(h) for your regression in that case.) However, if
  you want to use ACL2(p) or ACL2(hp) for your regression, see
  [waterfall-parallelism-for-book-certification].

  If you intend to certify books in the nonstd subdirectory of the
  community books, you will want to use ACL2(r) (see [real]). In that
  case, substitute target regression-nonstd for target regression.
  The default executable (when ACL2 is not specified) will be file
  saved_acl2r in your ACL2 sources directory, rather than saved_acl2.

  Provisional Certification

  To use provisional certification (see [provisional-certification]),
  supply ACL2_PCERT=t with your `make' command. Here is an example.

    time nice make regression -j 4 ACL2_BOOK_DIRS=deduction ACL2_PCERT=t

  Miscellany

  Other control of the certification process may be found by perusing
  community books file books/make_cert. In particular, the INHIBIT
  variable may be set to a call of [set-inhibit-output-lst], for
  example as follows to obtain the output one would get by default in
  an (interactive) ACL2 session.

    time nice make regression -j 4 ACL2_BOOK_DIRS=arithmetic \\
      INHIBIT='(set-inhibit-output-lst proof-tree)'

  Troubleshooting

  If you run into problems, you can get help by joining the acl2-help
  email list (follow the link from the ACL2 home page) and sending a
  message to that list. Also consider trying another version of GNU
  `make'; for example, we have found that versions 3.81 and 3.82
  sometimes cause errors on Linux where version 3.80 does not. Note
  however that Version 3.80 does not print certain informational
  messages that are printed by later versions.")
 (BOOKS-CERTIFICATION-CLASSIC
  (BOOKS)
  "Classic ACL2 `make'-based certification of [books]

  This [documentation] topic explains an approach to certifying
  directories of books, which we call ``classic ACL2 `make'-based
  certification''.

  Warning: The capability described in this section might be replaced
  at any time by a capability based on corresponding support for
  community books (see [books-certification]). If you think that
  would be a hardship, please contact the ACL2 implementors.

  This topic discusses a way to certify a directory of books other than
  the ACL2 community books. See [books-certification] for how to
  certify the set of ACL2 community [books]. There is also a section
  in that [documentation] topic, ``Restricting to Specific
  Directories and Books'', that provides an alternative to classic
  ACL2 `make'-based certification (as discussed in the present topic)
  for certifying specified sets of books.

  We assume here a familiarity with Unix/Linux `make'. We also assume
  that you are using GNU `make' rather than some other flavor of
  `make'. And finally, we assume, as is typically the case by
  following the standard installation instructions, that you install
  the ACL2 community books in the books/ subdirectory of your ACL2
  distribution. We will refer below to that directory as BOOKS.

  In summary: to use `make' to certify [books] under a given directory,
  you may create a simple Makefile in that directory (as explained
  below) so that when you stand in that directory, you can submit the
  command, `make', to certify those books. If you have a
  multi-processor machine or the like, then you can use the `-j flag
  `make'-level parallelism by specifying the number of concurrent
  processes. For example:

    make -j 4

  For each book foo.lisp, a file foo.out in the same directory as
  foo.lisp will contain the output from the corresponding
  certification attempt. If you have previously executed such a
  command, then you might first want to delete [certificate] files
  and other generated files by executing the following command.

    make clean

  Note that when you run `make', then by default, the first error will
  cause the process to stop. You can use make -i to force `make' to
  ignore errors, thus continuing past them. Or, use make -k to keep
  going, but skipping certification for any book that includes
  another whose certification has failed.

  By default, your acl2-customization file (see [ACL2-customization])
  is ignored by such `make' commands. However, you can specify the
  use of an acl2-customization file by setting the value of
  environment variable ACL2_CUSTOMIZATION to the empty string,
  indicating a default such file, or to the desired absolute
  pathname. For example:

    make ACL2_CUSTOMIZATION=''
    make ACL2_CUSTOMIZATION='~/acl2-customization.lisp'

  We now discuss how to create makefiles to support `make' commands as
  discussed above.

  First we give five steps for creating a Makefile to support
  certification of a directory of books, without subdirectories. For
  examples of such Makefiles you can look in community book
  directories (which, however, might disappear in future versions of
  ACL2).

      1. Include the file Makefile-generic from the books/ subdirectory of
      your ACL2 sources directory, but first perhaps define the
      variable `ACL2'. Consider the following example.

        ACL2 ?= /Users/john_doe/acl2/acl2-sources/saved_acl2
        include /Users/john_doe/acl2/acl2-sources/books/Makefile-generic

      In this example, you can omit the first line, because the default
      ACL2 executable is file saved_acl2 in the directory immediately
      above the directory of the specified Makefile-generic file.
      Indeed, that is the common case. Note the use of ?= instead of
      = or :=, so that ACL2 can instead be defined by the environment
      or provided on the command line as part of the `make' command.

      2. (Optional; usually skipped.) Set the INHIBIT variable if you want
      to see more than the summary output. For example, if you want
      to see the same output as you would normally see at the
      terminal, put this line in your Makefile after the `include'
      lines.

        INHIBIT = (assign inhibit-output-lst (list (quote proof-tree)))

      For other values to use for INHIBIT, see [set-inhibit-output-lst] and
      see the original setting of INHIBIT in books/Makefile-generic.

      3. Specify the books to be certified. Normally, every file with
      extension .lisp will be a book that you want to certify, in
      which case you can skip this step. Otherwise, put a line in
      your Makefile after the ones above that specifies the books to
      be certified. The following example, from an old version of
      community books file books/finite-set-theory/osets/Makefile,
      should make this clear.

        BOOKS = computed-hints fast instance map membership outer primitives \\
                quantify set-order sets sort

      But better yet, use the extension .lsp for any Lisp or ACL2 files
      that are not to be certified, so that the definition of BOOKS
      can be omitted.

      4. Create .acl2 files for books that are to be certified in other
      than the initial ACL2 world (see [portcullis]). For example, if
      you look in community books file
      books/arithmetic/equalities.acl2 you will see [defpkg] forms
      followed by a [certify-book] command, because it was determined
      that [defpkg] forms were necessary in the certification world
      in order to certify the equalities book. In general, for each
      <book-name>.lisp whose certification requires a non-initial
      certification world, you will need a corresponding
      <book-name>.acl2 file that ends with the appropriate
      [certify-book] command.

      You also have the option of creating a file cert.acl2 that has a
      special role. When file <book-name>.lisp is certified, if there
      is no file <book-name>.acl2 but there is a file cert.acl2, then
      cert.acl2 will be used as <book-name>.acl2 would have been
      used, as described in the preceding paragraph, except that the
      appropriate [certify-book] command will be generated
      automatically. Thus, no certify-book command should occur in
      cert.acl2.

      It is actually allowed to put raw lisp forms in a .acl2 file
      (presumably preceded by :q or (value :q) and followed by (lp)).
      But this is not recommended; we make no guarantees about
      certification performed any time after raw Lisp has been
      entered in the ACL2 session.

      5. Generally, the next step is to include the following line after
      the `include' of Makefile-generic (see the first step above).

        -include Makefile-deps

      This will cause `make' to create and then include a file
      Makefile-deps that contains ``dependency'' lines needed by
      `make'. If those dependencies are somehow flawed, it may be
      because you have [include-book] forms that are not truly
      including books, for example in multi-line comments (#|..|#).
      These will be ignored if preceded by a semicolon (;), or if you
      add a line break after ``include-book.'' But instead of adding
      the `-include' line above, you can create dependency lines
      yourself by running the command

        make dependencies

      and pasting the result into the end of your Makefile, and editing as
      you see fit.

  This concludes the basic instructions for creating a Makefile in a
  directory including books. Here are some other capabilities offered
  by community books file books/Makefile-subdirs. Not included below
  is a discussion of how to increase parallelism by avoiding the need
  to certify included books before certifying a given book; see
  [provisional-certification].

  Subdirectory Support

  There is support for using `make' to certify books in subdirectories.
  Consider the following example.

    DIRS = pass1 bind-free floor-mod
    include ../Makefile-subdirs

  This indicates that we are to run `make' in subdirectories pass1/,
  bind-free/, and floor-mod/ of the current directory.

  You can combine this subdirectory support with the support already
  discussed for certifying books in the top-level directory. Here is
  an example, which as of this writing is in community books file
  books/arithmetic-3/Makefile contains the following lines.

    arith-top: top all
    all: top

    DIRS = pass1 bind-free floor-mod
    include ../Makefile-subdirs
    include ../Makefile-generic

    -include Makefile-deps

  The `top' target is defined in ../Makefile-subdirs to call `make' in
  each subdirectory specified in DIRS. We have set the default target
  in the example above to a new name, arith-top, that makes that top
  target before making the `all' target which, in turn, is the
  default target in any Makefile-generic, and is responsible for
  certifying books in the current directory as discussed in the five
  steps displayed above.

  Use Makefile-psubdirs instead of Makefile-subdirs if certification of
  a book in a subdirectory never depends on certification of a book
  in a different subdirectory, because then the -j option of `make'
  can allow subdirectories to be processed in parallel.

  Cleaning Up

  We note that there is a clean target. Thus,

    make clean

  will remove generated files including .cert, .out files, and compiled
  files.

  System Books

  An environment variable ACL2_SYSTEM_BOOKS is generally set
  automatically, so you can probably skip reading the following
  paragraph unless your attempt to certify books fails to locate
  those books properly.

  The environment variable ACL2_SYSTEM_BOOKS can be set to the
  top-level directory of the ACL2 community books. A Unix-style
  pathname, typically ending in books/ or books, is permissible. In
  most cases, your ACL2 executable is a small script in which you can
  set this environment variable just above the line on which the
  actual ACL2 image is invoked, for example:

    export ACL2_SYSTEM_BOOKS
    ACL2_SYSTEM_BOOKS=/home/acl2/v3-2/acl2-sources/books

  However, you can also set ACL2_SYSTEM_BOOKS as a `make' variable, by
  setting it in your Makefile before the first target definition,
  e.g.:

    ACL2_SYSTEM_BOOKS ?= /home/acl2/v3-2/acl2-sources/books

  Compilation Support

  The file books/Makefile-generic provides support for compiling books
  that are already certified (but see [compilation] for an
  exception). For example, suppose that you have certified books
  using GCL as the host Lisp, resulting in compiled files with the .o
  extension. Now suppose you would like to compile the books for
  Allegro Common Lisp, whose compiled files have the .fasl extension.
  The following command will work if you have included
  books/Makefile-generic in your Makefile.

    make fasl

  In general, the compiled file extension for a Lisp supported by ACL2
  will be a target name for building compiled files for all your
  books (after certifying the books, if not already up-to-date on
  certification).

  If you run into problems, you can get help by joining the acl2-help
  email list (follow the link from the ACL2 home page) and sending a
  message to that list. Also consider trying another version of GNU
  `make'; for example, we have found that versions 3.81 and 3.82
  sometimes cause errors on Linux where version 3.80 does not.")
 (BOOLE$
  (ACL2-BUILT-INS)
  "Perform a bit-wise logical operation on 2 two's complement integers

  When integers x and y are viewed in their two's complement
  representation, (boole$ op x y) returns the result of applying the
  bit-wise logical operation specified by op. The following table is
  adapted from documentation for the analogous Common Lisp function
  boole in the Common Lisp Hyperspec. Note that the values of op for
  boole$ are ACL2 constants, rather than corresponding values of op
  for the Common Lisp function boole.

    op               result
    -----------      ---------
    *boole-1*        x
    *boole-2*        y
    *boole-andc1*    and complement of x with y
    *boole-andc2*    and x with complement of y
    *boole-and*      and
    *boole-c1*       complement of x
    *boole-c2*       complement of y
    *boole-clr*      the constant 0 (all zero bits)
    *boole-eqv*      equivalence (exclusive nor)
    *boole-ior*      inclusive or
    *boole-nand*     not-and
    *boole-nor*      not-or
    *boole-orc1*     or complement of x with y
    *boole-orc2*     or x with complement of y
    *boole-set*      the constant -1 (all one bits)
    *boole-xor*      exclusive or

  The guard of boole$ specifies that op is the value of one of the
  constants above and that x and y are integers.

  See any Common Lisp documentation for analogous information about
  Common Lisp function boole.

  Function: <boole$>

    (defun boole$ (op i1 i2)
           (declare (type (integer 0 15) op)
                    (type integer i1 i2))
           (cond ((eql op *boole-1*) i1)
                 ((eql op *boole-2*) i2)
                 ((eql op *boole-and*) (logand i1 i2))
                 ((eql op *boole-andc1*)
                  (logandc1 i1 i2))
                 ((eql op *boole-andc2*)
                  (logandc2 i1 i2))
                 ((eql op *boole-c1*) (lognot i1))
                 ((eql op *boole-c2*) (lognot i2))
                 ((eql op *boole-clr*) 0)
                 ((eql op *boole-eqv*) (logeqv i1 i2))
                 ((eql op *boole-ior*) (logior i1 i2))
                 ((eql op *boole-nand*) (lognand i1 i2))
                 ((eql op *boole-nor*) (lognor i1 i2))
                 ((eql op *boole-orc1*) (logorc1 i1 i2))
                 ((eql op *boole-orc2*) (logorc2 i1 i2))
                 ((eql op *boole-set*) 1)
                 ((eql op *boole-xor*) (logxor i1 i2))
                 (t 0)))")
 (BOOLEAN-LISTP
  (ACL2-BUILT-INS)
  "Recognizer for a true list of booleans

  The predicate boolean-listp tests whether its argument is a
  [true-listp] of objects each or which satisfyies [booleanp], i.e.,
  is t or nil.

  Function: <boolean-listp>

    (defun boolean-listp (lst)
           (declare (xargs :guard t))
           (cond ((atom lst) (eq lst nil))
                 (t (and (or (eq (car lst) t) (eq (car lst) nil))
                         (boolean-listp (cdr lst))))))")
 (BOOLEANP
  (ACL2-BUILT-INS)
  "Recognizer for booleans

  (Booleanp x) is t if x is t or nil, and is nil otherwise.

  See [generalized-booleans] for a discussion of a potential soundness
  problem for ACL2 related to the question: Which Common Lisp
  functions are known to return Boolean values?

  Function: <booleanp>

    (defun booleanp (x)
           (declare (xargs :guard t))
           (if (eq x t) t (eq x nil)))")
 (BOUNDERS
  (TAU-SYSTEM)
  "Intervals, bounder functions, and bounder correctness

    Bounder Forms 1 and 2:
    (implies (and (tau-intervalp i1)
                  ...
                  (or (equal (tau-interval-dom i1) 'dom1-1)
                      ...)
                  ...
                  (in-tau-intervalp x1 i1)
                  ...)
             (and (tau-intervalp (bounder-fn i1 ...))
                  (in-tau-intervalp target
                                    (bounder-fn i1 ...))))

  where target is either (fn x1 ... y1 ...) or (mv-nth 'n (fn x1 ... y1
  ...)), depending on whether we are in the Form 1 or Form 2 case,
  respectively. However, the shape above is meant just as a reminder.
  Details are given below.

  This topic first explains the basic shape of Bounder Form 1. Then it
  illustrates Bounder Form 2. Finally, it deals briefly with proving
  bounder correctness theorems. The community book
  tau-bounders/elementary-bounders contains bounders for various
  elementary functions including [+], [*], [/], [floor], [mod],
  [logand], [lognot], [logior], [logorc1], [logeqv], [logxor], and
  [ash]. You might look at or include this book to see more example
  theorems, to see how proofs of such theorems are managed, and to
  experiment with their effects on proving theorems involving
  arithmetic over finite or half-finite intervals.

  A bounder correctness theorem establishes that bounder-fn is a
  ``bounder'' for the function fn. That means that when trying to
  compute a tau for a call of fn (or, in the case of Form 2, for the
  nth component of the multiple-value vector returned by a call of
  fn) the tau system can call bounder-fn on the intervals containing
  certain arguments of fn.

  Let us start with an example. Let fn be the addition function, +
  (actually, [binary-+]). Consider the target term (+ x y) and
  contemplate the question: if you know intervals containing x and y,
  say intx and inty respectively, what is an interval containing
  their sum? The answer is pretty easy to state in English: the
  domain of the answer interval is the less restrictive of the
  domains of intx and inty. The lower bound of the answer interval is
  the sum of the lower bounds of intx and inty, and the lower
  relation is the stronger of the lower relations of intx and inty.
  Analogous comments define the upper bound and relation of the
  answer interval. So for example, if x is an INTEGERP such that 0 <=
  x <= 10 and y is a RATIONALP such that 0 < y <= 20, then (+ x y) is
  a RATIONALP such that 0 < (+ x y) <= 30.

  Defining this precisely is more tedious than describing it in English
  because one must make precise the notions of ``less restrictive''
  domains, ``weaker'' relations, and the possibility that either or
  both of the bounds could be ``infinite.'' But we can easily imagine
  defining the function bounder-for-+ that returns the answer
  interval described, given intx and inty.

  Then the following Bounder Form 1 formula establishes the correctness
  of bounder-for-+ and allows the tau system to use it to produce
  bounds in the tau computed for +-expressions:

    (implies (and (tau-intervalp intx)
                  (tau-intervalp inty)
                  (in-tau-intervalp x intx)
                  (in-tau-intervalp y inty))
             (and (tau-intervalp (bounder-for-+ intx inty))
                  (in-tau-intervalp (+ x y)
                                    (bounder-for-+ intx inty))))

  For example, suppose we have a formula with the following hypotheses

    (and (integerp a)
         (<= 0 a)
         (<= a 10)
         (rationalp b)
         (< 0 b)
         (<= b 20))

  and suppose the tau system encounters the term (+ a b). When the term
  is enountered, the tau for a would include an INTEGERP interval
  such that 0 <= a <= 10 and the tau for b would include a RATIONALP
  interval such that 0 < b <= 20. In its most primitive
  configuration, the tau system would only know that the tau for (+ a
  b) includes the recognizer RATIONALP (and all that it is known to
  imply). But after the bounder theorem above is proved and available
  as a :tau-system rule the tau system would infer that (+ a b) was
  in the RATIONALP interval such that 0 < (+ a b) <= 30.

  Thus, by defining bounder functions and proving them correct the user
  can give the tau system the ability to compute the bounds on
  function calls as a function of the known bounds on their actuals.

  It is sometimes useful to restrict the domains of the intervals to be
  considered. For example, in bounding *-expressions it is
  simplifying to restrict one's attention to intervals over the
  integers or rationals (and thus exclude the complex rationals so
  one need not think about the getting negative bounds by multiplying
  two ``positive'' complex rationals or how to ``round up'' from
  complex bounds to the rationals required by our intervals).

  If we were to define bounder-for-* so that it works correctly to
  bound *-expressions, but only for integer or rational arguments,
  its correctness theorem would be:

    (implies (and (tau-intervalp intx)                             ; (a)
                  (tau-intervalp inty)
                  (or (equal (tau-interval-dom intx) 'INTEGERP)    ; (b)
                      (equal (tau-interval-dom intx) 'RATIONALP))
                  (or (equal (tau-interval-dom inty) 'INTEGERP)
                      (equal (tau-interval-dom inty) 'RATIONALP))
                  (in-tau-intervalp x intx)                        ; (c)
                  (in-tau-intervalp y inty))
             (and (tau-intervalp (bounder-for-* intx inty))       ; (d)
                  (in-tau-intervalp (* x y)                        ; (e)
                                    (bounder-for-* intx inty))))

  In this case, bounder-for-* would be applied to the intervals for x
  and y only if those intervals were over the integers or the
  rationals.

  The above theorem for bounder-for-* begins to suggest the general
  form of a bounder theorem and we will use it to explain the general
  form.

  The hypotheses of a bounder theorem must be a conjunction and the
  conjuncts must be partitionable into three parts, (a), (b), and
  (c). The conclusion, must be a conjunction, must contain at least
  two conjuncts, (d) and (e), and is allowed to contain others that
  are simply ignored for purposes of bounders. (See the note below
  about why we allow but ignore additional conjuncts in the
  conclusion.)

  Part (a) introduces some distinct ``interval variables,'' here called
  ``ivars,'' that are known to denote intervals; for the example
  above, the ivars are intx and inty. Each hypothesis in part (a) is
  of the form (TAU-INTERVALP ivar).

  Part (b) allows us to restrict the domains of some of the intervals.
  Each hypothesis in part (b) must be a disjunction and each of the
  disjuncts must be of the form (EQUAL (TAU-INTERVAL-DOM ivar) 'dom),
  where ivar is one of the interval variables and dom is one of
  INTEGERP, RATIONALP, ACL2-NUMBERP, or NIL. It is not necessary to
  restrict every interval variable. Indeed, part (b) may be empty, as
  in the theorem for bounder-for-+ above.

  Part (c) consists of a set of (IN-TAU-INTERVALP avar ivar) hypotheses
  where each avar is a variable and no two hypotheses in part (c) use
  the same avar or ivar. We call the set of all such avar the
  ``actual variables'' or ``avars.'' The avars and ivars must be
  distinct. Part (c) sets up a correspondence between the avars and
  the ivars, each avar is in an interval denoted by one ivar.

  Part (d) introduces the name of the bounder function, here
  bounder-for-*, and the order of its ivar arguments. We see that
  bounder-for-* takes two arguments and they correspond, in order, to
  the intervals containing x and y. Part (d) also establishes that
  the bounder function always returns an interval under hypotheses
  (a), (b), and (c). Note that it is sometimes useful to return the
  ``universal interval'' (one that contains everything) if you don't
  want to compute a better interval for some case; see
  [tau-intervalp] or [in-tau-intervalp].

  Part (e) introduces the name of the function being bounded, here *,
  and the order of its arguments. It establishes that the function
  being bounded really is bounded by the interval computed by the
  bounder function. In general, the function being bounded may take
  additional arguments. It is possible that the function being
  bounded takes some arguments that do not affect the bounds of its
  output.

  Thus, parts (c) and (e) together establish a mapping between the
  actuals of a call of the function being bounded and the intervals
  to be supplied to the bounder.

  The parts identified above may be presented in any order and the
  literals constituting those parts may be mingled. Thus, for
  example, here is another version of the theorem above that
  generates the same bounding information for the tau system. In this
  version, the hypotheses and conclusions are rearranged,
  bounder-for-* takes its arguments in the opposite order, and the
  theorem includes an additional conclusion.

    (implies (and (tau-intervalp intx)                             ; (a)
                  (or (equal (tau-interval-dom intx) 'INTEGERP)    ; (b)
                      (equal (tau-interval-dom intx) 'RATIONALP))
                  (in-tau-intervalp x intx)                        ; (c)

                  (tau-intervalp inty)                             ; (a)
                  (or (equal (tau-interval-dom inty) 'INTEGERP)    ; (b)
                      (equal (tau-interval-dom inty) 'RATIONALP))
                  (in-tau-intervalp y inty))
             (and (in-tau-intervalp (* x y)                        ; (e)
                                    (bounder-for-* inty intx))
                  (tau-intervalp (bounder-for-* inty intx))        ; (d)))

                  (or (equal (tau-interval-dom (bounder-for-* inty intx))
                             'INTEGERP)
                      (equal (tau-interval-dom (bounder-for-* inty intx))
                             'RATIONALP))

  Note on why bounder forms allow additional conjuncts in the
  conclusion: It is often the case that one creates bounders by
  composing other bounders. To prove compositional bounds correct one
  must often prove more than the mere correctness of the components.
  For example, one might need to prove that the domain of the new
  bounding interval is INTEGERP or otherwise restricted. We allow
  such ``unnecessary'' conclusions simply to save the user the burden
  of stating multiple theorems.

  An Illustration of Bounder Form 2: Suppose (quad i) is defined so
  that truncates the integer i to the largest multiple of 4 weakly
  below i and, additionally, returns the remainder. For example,
  (quad 26) returns (mv 24 2). Then here are bounders for each of its
  return values:

    (defun quad-bounds-0 (i)
      (cond ((and (tau-interval-lo i)
                  (<= 0 (tau-interval-lo i)))
             (make-tau-interval 'integerp nil 0 nil (tau-interval-hi i)))
            (t (make-tau-interval nil nil nil nil nil))))

    (defun quad-bounds-1 (i)
      (cond ((and (tau-interval-lo i)
                  (<= 0 (tau-interval-lo i)))
             (make-tau-interval 'integerp nil 0 nil 3))
            (t (make-tau-interval nil nil nil nil nil))))

  Note that the bounders assume i is an INTEGERP and return the
  universal interval when i is not a natural.

  As noted in the discussion below about how to prove bounder
  correctness theorems, proving these bounders correct will require
  an arithmetic book, e.g.,

    (include-book \"arithmetic-5/top\" :dir :system)

  Here then are two bounder correctness theorems of Form 2:

    (defthm quad-bounds-0-correct
      (implies (and (tau-intervalp i)
                    (equal (tau-interval-dom i) 'INTEGERP)
                    (in-tau-intervalp x i))
               (and (tau-intervalp (quad-bounds-0 i))
                    (in-tau-intervalp (mv-nth 0 (quad x))
                                      (quad-bounds-0 i))))
      :rule-classes :tau-system)

    (defthm quad-bounds-1-correct
      (implies (and (tau-intervalp i)
                    (equal (tau-interval-dom i) 'INTEGERP)
                    (in-tau-intervalp x i))
               (and (tau-intervalp (quad-bounds-1 i))
                    (in-tau-intervalp (mv-nth 1 (quad x)) (quad-bounds-1 i))))
      :rule-classes :tau-system)

  As noted above, if these bounders are to be used in constructing
  other bounders, we might include (in the first theorem) an
  additional concluding conjunct, such as

    (equal (tau-interval-dom (quad-bounds-0 i)) 'INTEGERP)

  so that we can keep quad-bounds-0 disabled to allow us to use
  quad-bounds-0-correct as a :rewrite or other rule and still relieve
  hypotheses about the domain of the interval it produces. These
  hypotheses would arise if some other verified bounder was called on
  the produced interval. In addition, as noted below, we might
  replace the :rule-classes above with

    :rule-classes
     ((:rewrite)
      (:forward-chaining :trigger-terms ((quad-bounds-0 i))))

  Since the theorem is being stored as some kind of rule and since it
  satisfies the Bounder Form 2 shape, it will additionally be stored
  as a :tau-system rule.

  Note on proving bounder theorems: Proving bounder theorems is just
  like proving any other arithmetic theorem and you will need
  whatever libraries are appropriate for the problem domain you are
  working in. Do not expect the tau system to be of much use in
  proving bounder theorems. A typical bounder theorem might require
  you to prove a subgoal like (< (fn x y) (g (tau-interval-hi int1)
  int2)). But tau deals with inequalities relating terms to
  constants, e.g., (< ... 16). A bounder theorem is a sort of
  ``metatheorem'' about how to construct bounded intervals from other
  bounded intervals. So when you undertake to define a bounder and
  prove it correct, go into the project with your eyes open!

  But bounder functions can be broadly divided into two classes, those
  defined in terms of arithmetic on the interval bounds and those
  defined in terms of other bounders. For example, given that

    (LOGXOR x y) = (LOGNOT (LOGEQV x y))

  an interval for bounding LOGXOR can be constructed by composing the
  constructions of intervals for LOGEQV and LOGNOT. So some bounder
  correctness proofs will involve direct manipulation of arithmetic
  inequalities and others might involve appeal to the correctness of
  other bounders, depending on how the new bounder is defined.

  Regardless of which style of bounder we are dealing with, we have
  found it useful to prove the basic theorems relating the tau
  interval accessors to [make-tau-interval], e.g.,

    (equal (tau-interval-dom (make-tau-interval dom lo-rel lo hi-rel hi)) dom)

  and then disable those functions to avoid seeing excessive cars and
  cdrs.

  When dealing with bounders defined in the direct, arithmetic style,
  we tend to keep [tau-intervalp] and [in-tau-intervalp] enabled so
  they unfold and expose the algebra.

  When dealing with bounders defined compositionally in terms of other
  verified bounders, we tend to keep [tau-intervalp] and
  [in-tau-intervalp] disabled so we can rely on the previously proved
  bounder theorems as rewrite and forward chaining rules.

  Note that this last remark means that when you prove bounder
  correctness theorems you should include corollaries that are useful
  :rewrite and possibly :forward-chaining rules if you anticipate
  using that bounder in more complex ones. We tend to trigger the
  forward chaining with the bounder expression itself, rather than
  one of the hypotheses. For example in the rule above for
  bounder-for-* we would include (:forward-chaining :trigger-terms
  ((tau-bounder-expt2 int2))) and let the in-tau-intervalp hypotheses
  select the free variables x and y.")
 (BREAK$
  (ACL2-BUILT-INS OTHER)
  "Cause an immediate Lisp break

  ACL2 users are generally advised to avoid breaking into raw Lisp.
  Advanced users may, on occasion, see the need to do so. Evaluating
  (break$) will have that effect. (Exception: break$ is disabled
  after evaluation of (set-debugger-enable :never); see
  [set-debugger-enable].) Break$ returns nil.

  Function: <break$>

    (defun break$ nil (declare (xargs :guard t)) nil)")
 (BREAK-LEMMA
  (BREAK-REWRITE)
  "A quick introduction to breaking rewrite rules in ACL2

    Example:
    :brr t                          ; if you haven't done that yet
    :monitor (:rewrite lemma12) t   ; to install a break point on the
                                    ; rule named (:rewrite lemma12)

  ACL2 does not support Nqthm's break-lemma but supports a very similar
  and more powerful break facility. Suppose some proof is failing;
  apparently some particular rule is not being used and you wish to
  learn why. Then you need the ACL2 [break-rewrite] facility. See
  [break-rewrite] and all of its associated :[doc] topics for
  details. The following basic steps are required.

  (1) To enable the ``break rewrite'' feature, you must first execute

    ACL2 !>:brr t

  at the top-level of ACL2. Equivalently, evaluate (brr t).
  [Break-rewrite] stays enabled until you disable it with (brr nil).
  When [break-rewrite] is enabled the ACL2 rewriter will run slower
  than normal but you will be able to [monitor] the attempts to apply
  specified rules.

  (2) Decide what [rune]s (see [rune]) you wish to [monitor]. For
  example, you might want to know why (:rewrite lemma12 . 2) is not
  being used in the attempted proof. That, by the way, is the name of
  the second rewrite rule generated from the event named lemma12.

  The command

    ACL2 !>:monitor (:rewrite lemma12 . 2) t

  will install an ``unconditional'' break point on that rule. The ``t''
  at the end of the command means it is unconditional, i.e., a break
  will occur every time the rule is tried. ACL2 supports conditional
  breaks also, in which case the t is replaced by an expression that
  evaluates to non-nil when you wish for a break to occur. See
  [monitor]. The above keyword command is, of course, equivalent to

    ACL2 !>(monitor '(:rewrite lemma12 . 2) t)

  which you may also type. You may install breaks on as many rules as
  you wish. You must use [monitor] on each rule. You may also change
  the break condition on a rule with [monitor]. Use [unmonitor] (see
  [unmonitor]) to remove a rule from the list of [monitor]ed rules.

  (3) Then try the proof again. When a [monitor]ed rule is tried by the
  rewriter you will enter an interactive break, called
  [break-rewrite]. See [break-rewrite] for a detailed description.
  Very simply, [break-rewrite] lets you inspect the context of the
  attempted application both before and after the attempt. When
  [break-rewrite] is entered it will print out the ``target'' term
  being rewritten. If you type :go [break-rewrite] will try the rule
  and then exit, telling you (a) whether the rule was applied, (b) if
  so, how the target was rewritten, and (c) if not, why the rule
  failed. There are many other commands. See [brr-commands].

  (4) When you have finished using the [break-rewrite] feature you
  should disable it to speed up the rewriter. You can disable it with

    ACL2 !>:brr nil

  The list of [monitor]ed rules and their break conditions persists but
  is ignored. If you enable [break-rewrite] later, the list of
  [monitor]ed rules will be displayed and will be used again by
  rewrite.

  You should disable the [break-rewrite] feature whenever you are not
  intending to use it, even if the list of [monitor]ed rules is
  empty, because the rewriter is slowed down as long as
  [break-rewrite] is enabled.

  If you get a stack overflow, see [cw-gstack].")
 (BREAK-ON-ERROR
  (TRACE)
  "Break when encountering a hard or soft error caused by ACL2

    General forms:
    (break-on-error t)    ; installs a trace causing a continuable error (break)
                          ;   when an error is invoked by ACL2.
    (break-on-error)      ; same as above
    (break-on-error :all) ; same as above, but even when inside the prover
    (break-on-error nil)  ; uninstall any above trace

  (Break-on-error) generates a suitable trace of error functions.
  Evaluate (trace$) after (break-on-error) if you want to see the
  specific trace forms (which you can modify and then submit directly
  to trace$, if you wish). This [trace] should cause entry to the
  Lisp debugger whenever ACL2 calls its error routines, except for
  certain errors when inside the theorem prover, and also at those
  times if option :all is supplied.

  NOTE: For technical reasons, you may see some error messages more
  than once.

  Finally, note that you are welcome to define your own version of
  break-on-error by modifying a copy of the source definition (search
  for ``(defmacro break-on-error'' in ACL2 source file
  other-events.lisp). Please feel free to send your version of
  break-on-error to the ACL2 implementors, for possible inclusion
  into ACL2.

  Break-on-error is implmented using ACL2 [trace$]. See [trace!] if you
  want an explanation of the ``TTAG NOTE'' that is printed.

  The argument, if supplied, is evaluated and must evaluate to t, nil,
  or :all.

  Also see [set-debugger-enable] for how to get raw-Lisp backtrace
  information when an error occurs as a result of break-on-error, or
  even of a raw Lisp error, by calling set-debugger-enable with
  argument :bt, :bt-break, or :break-bt. Note that for ACL2 errors
  (as opposed to raw Lisp errors), i.e. errors affected by
  break-on-error, all three of those keyword values are treated
  equivalently (and, all are ignored for non-ANSI GCL; see
  [set-debugger-enable]).")
 (BREAK-REWRITE
  (DEBUGGING)
  "The read-eval-print loop entered to [monitor] rewrite rules

  ACL2 allows the user to [monitor] the application of rewrite rules.
  When [monitor]ed rules are about to be tried by the rewriter, an
  interactive break occurs and the user is allowed to watch and, in a
  limited sense, control the attempt to apply the rule. This
  interactive loop, which is technically just a call of the standard
  top-level ACL2 read-eval-print loop, [ld], on a ``[wormhole]
  [state]'' (see [wormhole]), is called ``break-rewrite.'' While in
  break-rewrite, certain keyword commands are available for accessing
  information about the context in which the lemma is being tried.
  These keywords are called break-rewrite ``commands.''

  Also see [dmr] (Dynamically Monitor Rewrites) for a related utility,
  which allows you to watch progress of the rewriter in real time.

  To abort from inside break-rewrite at any time, execute

  For further information, see the related :[doc] topics listed below.

  As explained in the documentation for [monitor], it is possible to
  cause the ACL2 rewriter to [monitor] the attempted application of
  selected rules. When such a rule is about to be tried, the rewriter
  evaluates its break condition and if the result is non-nil,
  break-rewrite is entered.

  Break-rewrite permits the user to inspect the current [state] by
  evaluating break-rewrite commands. Type :[help] in break-rewrite to
  see what the break-rewrite commands are. However, break-rewrite is
  actually just a call of the general ACL2 read-eval-print loop,
  [ld], on a certain [state] and the break-rewrite commands are
  simply aliases provided by ld-keyword-aliases [table] (see
  [ld-keyword-aliases]). See [ld] for details about this
  read-eval-print loop. Thus, with a few exceptions, anything you can
  do at the ACL2 top-level can be done within break-rewrite. For
  example, you can evaluate arbitrary expressions, use the keyword
  command hack, access [documentation], print [events], and even
  define functions and prove theorems. However, the ``certain
  [state]'' upon which [ld] was called is a ``[wormhole] [state]''
  (see [wormhole]) because break-rewrite is not allowed to have any
  effect upon the behavior of rewrite. What this means, very roughly
  but understandably, is that break-rewrite operates on a copy of the
  [state] being used by rewrite and when break-rewrite exits the
  [wormhole] closes and the [state] ``produced'' by break-rewrite
  disappears. Thus, break-rewrite lets you query the state of the
  rewriter and even do experiments involving proofs, etc., but these
  experiments have no effect on the ongoing proof attempt. In
  particular:

  Note that the output from break-rewrite is sometimes abbreviated by
  default, such as for the term causing the break. This can be
  controlled by setting the :term evisc-tuple; see [set-evisc-tuple].
  (Another option: use iprinting. See [set-iprint].) But as noted
  above, if you use set-evisc-tuple from inside the break-rewrite
  [wormhole], its effect will disappear when you exit the break. So
  you might want to issue a set-evisc-tuple command from the top
  level, outside break-rewrite.

  When you first enter break-rewrite a simple herald is printed such
  as:

    (3 Breaking (:rewrite lemma12) on (delta a (+ 1 j)):

  The integer after the open parenthesis indicates the depth of nested
  break-rewrite calls. In this discussion we use 3 consistently for
  this integer. Unless you abort or somehow enter unbalanced
  parentheses into the script, the entire session at a given depth
  will be enclosed in balanced parentheses, making it easy to skip
  over them in Emacs.

  You then will see the break-rewrite [prompt]:

    3 ACL2 !>

  The leading integer is, again, the depth. Because breaks often occur
  recursively it is convenient always to know the level with which
  you are interacting.

  You may type arbitrary commands as in the top-level ACL2 loop. For
  example, you might type:

    3 ACL2 !>:help

  or

    3 ACL2 !>:pe lemma12

  More likely, upon entering break-rewrite you will determine the
  context of the attempted application. Here are some useful
  commands:

    3 ACL2 >:target           ; the term being rewritten
    3 ACL2 >:unify-subst      ; the unifying substitution
    3 ACL2 >:path             ; the stack of goals pursued by the rewriter
                              ; starting at the top-level clause being simplified
                              ; and ending with the current application

  At this point in the interaction the system has not yet tried to
  apply the [monitor]ed rule. That is, it has not tried to establish
  the hypotheses, considered the heuristic cost of backchaining,
  rewritten the right-hand side of the conclusion, etc. When you are
  ready for it to try the rule you can type one of several different
  ``proceed'' commands. The basic proceed commands are :ok, :go, and
  :eval.

    :ok

  exits break-rewrite without further interaction. When break-rewrite
  exits it prints ``3)'', closing the parenthesis that opened the
  level 3 interaction.

    :go

  exits break-rewrite without further interaction, but prints out the
  result of the application attempt, i.e., whether the application
  succeeded, if so, what the :target term was rewritten to, and if
  not why the rule was not applicable.

    :eval

  causes break-rewrite to attempt to apply the rule but interaction at
  this level of break-rewrite resumes when the attempt is complete.
  When control returns to this level of break-rewrite a message
  indicating the result of the application attempt (just as in :go)
  is printed, followed by the [prompt] for additional user input.

  Generally speaking, :ok and :go are used when the break in question
  is routine or uninteresting and :eval is used when the break is one
  that the user anticipates is causing trouble. For example, if you
  are trying to determine why a lemma isn't being applied to a given
  term and the :target of the current break-rewrite is the term in
  question, you would usually :eval the rule and if break-rewrite
  reports that the rule failed then you are in a position to
  determine why, for example by carefully inspecting the :type-alist
  of governing assumptions or why some hypothesis of the rule could
  not be established.

  It is often the case that when you are in break-rewrite you wish to
  change the set of [monitor]ed [rune]s. This can be done by using
  :[monitor] and :[unmonitor] as noted above. For example, you might
  want to [monitor] a certain rule, say hyp-reliever, just when it is
  being used while attempting to apply another rule, say main-lemma.
  Typically then you would [monitor] main-lemma at the ACL2
  top-level, start the proof-attempt, and then in the break-rewrite
  in which main-lemma is about to be tried, you would install a
  [monitor] on hyp-reliever. If during the ensuing :eval hyp-reliever
  is broken you will know it is being used under the attempt to apply
  main-lemma.

  However, once hyp-reliever is being [monitor]ed it will be
  [monitor]ed even after main-lemma has been tried. That is, if you
  let the proof attempt proceed then you may see many other breaks on
  hyp-reliever, breaks that are not ``under'' the attempt to apply
  main-lemma. One way to prevent this is to :eval the application of
  main-lemma and then :[unmonitor] hyp-reliever before exiting. But
  this case arises so often that ACL2 supports several additional
  ``flavors'' of proceed commands.

  :Ok!, :go!, and :eval! are just like their counterparts (:ok, :go,
  and :eval, respectively), except that while processing the rule
  that is currently broken no [rune]s are [monitor]ed. When
  consideration of the current rule is complete, the set of
  [monitor]ed [rune]s is restored to its original setting.

  :Ok$, :go$, and :eval$ are similar but take an additional argument
  which must be a list of [rune]s. An example usage of :eval$ is

    3 ACL2 !>:eval$ ((:rewrite hyp-reliever))

  These three commands temporarily install unconditional breaks on the
  [rune]s listed, proceed with the consideration of the currently
  broken rule, and then restore the set of [monitor]ed rules to its
  original setting.

  Thus, there are nine ways to proceed from the initial entry into
  break-rewrite although we often speak as though there are two, :ok
  and :eval, and leave the others implicit. We group :go with :ok
  because in all their flavors they exit break-rewrite without
  further interaction (at the current level). All the flavors of
  :eval require further interaction after the rule has been tried.

  To abort a proof attempt and return to the top-level of ACL2 you may
  at any time type (a!) followed by a carriage return. If you are not
  in a raw Lisp break, you may type :a! instead. The utility p! is
  completely analogous to a! except that it pops up only one [ld]
  level. If you have just entered the break-rewrite loop, this will
  pop you out of that loop, back to the proof. See [a!] and see [p!].

  We now address ourselves to the post-:eval interaction with
  break-rewrite. As noted, that interaction begins with
  break-rewrite's report on the results of applying the rule: whether
  it worked and either what it produced or why it failed. This
  information is also printed by certain keyword commands available
  after :eval, namely :wonp, :rewritten-rhs, and :failure-reason. In
  addition, by using [brr@] (see [brr@]) you can obtain this
  information in the form of ACL2 data objects. This allows the
  development of more sophisticated ``break conditions''; see
  [monitor] for examples. In this connection we point out the macro
  form (ok-if term). See [ok-if]. This command exits break-rewrite if
  term evaluates to non-nil and otherwise does not exit. Thus it is
  possible to define macros that provide other kinds of exits from
  break-rewrite. The only way to exit break-rewrite after :eval is
  :ok (or, equivalently, the use of [ok-if]).

  ACL2 users who wish to know more about break-rewrite so that they can
  develop more convenient ways to [monitor] rules are encouraged to
  speak to J Moore.

  The rest of this [documentation] discusses a few implementation
  details of break-rewrite and may not be interesting to the typical
  user.

  There is no ACL2 function named break-rewrite. It is an illusion
  created by appropriate calls to two functions named brkpt1 and
  brkpt2. As previously noted, break-rewrite is [ld] operating on a
  [wormhole] [state]. One might therefore wonder how break-rewrite
  can apply a rule and then communicate the results back to the
  rewriter running in the external [state]. The answer is that it
  cannot. Nothing can be communicated through a [wormhole]. In fact,
  brkpt1 and brkpt2 are each calls of [ld] running on [wormhole]
  [state]s. Brkpt1 implements the pre-:eval break-rewrite and brkpt2
  implements the post-:eval break-rewrite. The rewriter actually
  calls brkpt1 before attempting to apply a rule and calls brkpt2
  afterwards. In both cases, the rewriter passes into the [wormhole]
  the relevant information about the current context. Logically
  brkpt1 and brkpt2 are no-ops and [rewrite] ignores the nil they
  return. But while control is in them the execution of [rewrite] is
  suspended and cannot proceed until the break-rewrite interactions
  complete.

  This design causes a certain anomoly that might be troubling. Suppose
  that inside break-rewrite before :evaling a rule (i.e., in the
  brkpt1 [wormhole] [state]) you define some function, foo. Suppose
  then you :eval the rule and eventually control returns to
  break-rewrite (i.e., to brkpt2 on a [wormhole] [state] with the
  results of the application in it). You will discover that foo is no
  longer defined! That is because the [wormhole] [state] created
  during your pre-:eval interaction is lost when we exit the
  [wormhole] to resume the proof attempt. The post-:eval [wormhole]
  [state] is in fact identical to the initial pre-:eval [state]
  (except for the results of the application) because [rewrite] did
  not change the external [state] and both [wormhole] [state]s are
  copies of it. A similar issue occurs with the use of [trace]
  utilities: all effects of calling [trace$] and [untrace$] are
  erased when you proceed from a break in the break-rewrite loop.

  There is a lot more to know about break-rewrite, most of which is
  fairly easy to learn from looking at the code, since it is all
  expressed in ACL2. Feel free to ask questions of J Moore.


Subtopics

  [Break-lemma]
      A quick introduction to breaking rewrite rules in ACL2

  [Brr]
      To enable or disable the breaking of rewrite rules

  [Brr-commands]
      [Break-Rewrite] Commands

  [Brr@]
      To access context sensitive information within [break-rewrite]

  [Cw-gstack]
      Debug a rewriting loop or stack overflow

  [Dmr]
      Dynamically monitor rewrites and other prover activity

  [Monitor]
      To monitor the attempted application of a rule name

  [Monitored-runes]
      Print the [monitor]ed [rune]s and their break conditions

  [Ok-if]
      Conditional exit from break-rewrite

  [Unmonitor]
      To stop monitoring a rule name

  [Why-brr]
      An explanation of why ACL2 has an explicit [brr] mode")
 (BREAKS
  (ACL2-BUILT-INS)
  "Common Lisp breaks

    Example:
    Broken at PROVE.  Type :H for Help.
    >>:Q

    ACL2 !>

  You may interrupt the system by typing various control character
  sequences. The precise sequences are determined by the host Lisp
  and operating system environment. For example, in GCL and Allegro
  Common Lisp, a console interrupt is caused by typing ``ctrl-c''.
  If, however, the GCL or Allegro is running in an Emacs shell
  buffer, one must type ``ctrl-c ctrl-c''.

  If a break occurs, for example because of a bug in ACL2 or a user
  interrupt, the break will run a Common Lisp read-eval-print loop,
  not an ACL2 read-eval-print loop. This may not be obvious if the
  [prompt]s in the two loops are similar. Because you are typing to a
  Common Lisp evaluator, you must be careful. It is possible to
  damage your ACL2 state in irreparable ways by executing non-ACL2
  Common Lisp. It is even possible to disrupt and render inaccurate
  the interrupted evaluation of a simple ACL2 expression.

  For ACL2 built on most host Common Lisps, you will see the string
  [RAW LISP] in the [prompt] at a break, to emphasize that one is
  inside a break and hence should quit from the break. For some host
  Common Lisps, the top-level prompt also contains the string [RAW
  LISP]. See [prompt] for how to control printing of that string.

  The most reliable way to return to the ACL2 top level is by executing
  the following command: ([abort!])'). Appropriate cleanup will then
  be done, which should leave you in an appropriate state.

  However, you may be able to quit from the break in the normal Lisp
  manner (as with :q in GCL or CCL, :reset in Allegro CL, and q in
  CMU CL). If this attempt to quit is successful, it will return you
  to the innermost ACL2 read-eval-print loop, with appropriate
  cleanup performed first. Note that if you are within a [brr]
  environment when the break occurs, quitting from the break will
  only return you to that environment, not to the top of ACL2's
  read-eval-print loop.")
 (BROKEN-LINK
  (DOCUMENTATION)
  "Placeholder for link to documentation that resides in the community
  books

  You are looking at the ACL2 User's Manual, which contains
  [documentation] from the ACL2 sources but not from the ACL2
  community [books]. Perhaps you came to this page by following a
  link to a topic that is documented in a book, as shown in the table
  below. If so, then you may wish to go to a manual that includes
  documentation from the books. If you are using the ACL2-Doc Emacs
  browser, then see [ACL2-Doc], in particular the documentation of
  the ``I'' command for switching to the acl2+books combined manual;
  otherwise, view that combined manual:

  
  http://www.cs.utexas.edu/users/moore/acl2/v6-4/combined-manual/index.html

  We include the following table in case you find it to be helpful. It
  maps each topic name shown to the book in which it is documented.

      ((<< \"[books]/misc/total-order.lisp\")
       (oslib::argv \"[books]/oslib/logic-defs.lisp\")
       (arith-equivs \"[books]/centaur/misc/arith-equiv-defs.lisp\")
       (arithmetic \"[books]/centaur/doc.lisp\")
       (b* \"[books]/tools/bstar.lisp\")
       (bridge \"[books]/centaur/bridge/top.lisp\")
       (cert.pl \"[books]/build/doc.lisp\")
       (std::defaggregate \"[books]/std/util/defaggregate.lisp\")
       (defconsts \"[books]/std/util/defconsts.lisp\")
       (define \"[books]/std/util/define.lisp\")
       (gl \"[books]/centaur/gl/doc.lisp\")
       (hacker \"[books]/hacking/doc-section.lisp\")
       (ihs \"[books]/ihs/ihs-doc-topic.lisp\")
       (include-raw \"[books]/tools/include-raw.lisp\")
       (make-flag \"[books]/tools/flag.lisp\")
       (note-6-4-books \"[books]/centaur/relnotes.lisp\")
       (str::numbers \"[books]/str/top.lisp\")
       (oslib \"[books]/oslib/top.lisp\")
       (quicklisp \"[books]/centaur/quicklisp/top.lisp\")
       (satlink::sat-solver-options \"[books]/centaur/satlink/top.lisp\")
       (satlink \"[books]/centaur/satlink/top.lisp\")
       (xdoc::save \"[books]/xdoc/topics.lisp\")
       (set-max-mem \"[books]/centaur/misc/memory-mgmt-logic.lisp\")
       (std \"[books]/std/top.lisp\")
       (std/io \"[books]/std/io/top.lisp\")
       (str \"[books]/str/top.lisp\")
       (unsound-read \"[books]/std/io/unsound-read.lisp\")
       (untranslate-patterns \"[books]/misc/untranslate-patterns.lisp\")
       (with-raw-mode \"[books]/hacking/hacker.lisp\")
       (with-redef-allowed \"[books]/hacking/hacker.lisp\")
       (xdoc \"[books]/xdoc/topics.lisp\"))")
 (BRR
  (BREAK-REWRITE)
  "To enable or disable the breaking of rewrite rules

    Example:
    :brr t       ; enable
    :brr nil     ; disable

    General Form:
    (brr flg)

  where flg evaluates to t or nil. This function modifies [state] so
  that the attempted application of certain rewrite rules are
  ``broken.'' ``Brr'' stands for ``break-rewrite'' and can be thought
  of as a mode with two settings. The normal mode is ``disabled.''

  When brr mode is ``enabled'' the ACL2 rewriter monitors the attempts
  to apply certain rules and advises the user of those attempts by
  entering an interactive wormhole break. From within this break the
  user can watch selected application attempts. See [break-rewrite].
  The user can also interact with the system during brr breaks via
  [brr-commands].

  The rules monitored are selected by using the [monitor] and
  [unmonitor] commands. It is possible to break a rune
  ``conditionally'' in the sense that an interactive break will occur
  only if a specified predicate is true of the environment at the
  time of the attempted application. See [monitor] and see
  [unmonitor].

  Even if a non-empty set of rules has been selected, no breaks will
  occur unless brr mode is enabled. Thus, the first time in a session
  that you wish to monitor a rewrite rule, use :brr t to enable brr
  mode. Thereafter you may select runes to be monitored with
  [monitor] and [unmonitor] with the effect that whenever monitored
  rules are tried (and their break conditions are met) an interactive
  break will occur. Be advised that when brr mode is enabled the
  rewriter is somewhat slower than normal. Furthermore, that
  sluggishness persists even if no runes are monitored. You may
  regain normal performance --- regardless of what runes are
  monitored --- by disabling brr mode with :brr nil.

  Why isn't brr mode disabled automatically when no runes are
  monitored? More generally, why does ACL2 have brr mode at all? Why
  not just test whether there are monitored runes? If you care about
  the answers, see [why-brr].

  BRR Mode and Console Interrupts: If the system is operating in brr
  mode and you break into raw Lisp (as by causing a console interrupt
  or happening upon a signalled Lisp error; see [breaks]), you can
  return to the ACL2 top-level, outside any brr environment, by
  executing ([abort!])'). Otherwise, the normal way to quit from such
  a break (for example :q in GCL, :reset in Allegro CL, and q in CMU
  CL) will return to the innermost ACL2 read-eval-print loop, which
  may or may not be the top-level of your ACL2 session! In
  particular, if the break happens to occur while ACL2 is within the
  brr environment (in which it is preparing to read [brr-commands]),
  the abort will merely return to that brr environment. Upon exiting
  that environment, normal theorem proving is continued (and the brr
  environment may be entered again in response to subsequent
  monitored rule applications). Before returning to the brr
  environment, ACL2 ``cleans up'' from the interrupted brr
  processing. However, it is not possible (given the current
  implementation) to clean up perfectly. This may have two
  side-effects. First, the system may occasionally print the
  self-explanatory ``Cryptic BRR Message 1'' (or 2), informing you
  that the system has attempted to recover from an aborted brr
  environment. Second, it is possible that subsequent brr behavior in
  that proof will be erroneous because the cleanup was done
  incorrectly. The moral is that you should not trust what you learn
  from brr if you have interrupted and aborted brr processing during
  the proof. These issues do not affect the behavior or soundness of
  the theorem prover.")
 (BRR-COMMANDS
  (BREAK-REWRITE)
  "[Break-Rewrite] Commands

    :a!             abort to ACL2 top-level
    :p!             pop one level (exits a top-level break-rewrite loop)
    :target         term being rewritten
    :unify-subst    substitution making :lhs equal :target
    :hyps           hypotheses of the rule
    :hyp i          ith hypothesis of the rule
    :lhs            left-hand side of rule's conclusion
    :rhs            right-hand side of rule's conclusion
    :type-alist     type assumptions governing :target
    :initial-ttree  ttree before :eval (see [ttree])
    :ancestors      negations of backchaining hypotheses being pursued
    :wonp           indicates if application succeed (after :eval)
    :rewritten-rhs  rewritten :rhs (after :eval)
    :final-ttree    ttree after :eval (see [ttree])
    :failure-reason reason rule failed (after :eval)
    :path           rewrite's path from top clause to :target
    :frame i        ith frame in :path
    :top            top-most frame in :path
    :ok             exit break
    :go             exit break, printing result
    :eval           try rule and re-enter break afterwards
    :ok!            :ok but no recursive breaks
    :go!            :go but no recursive breaks
    :eval!          :eval but no recursive breaks
    :ok$ runes      :ok with runes monitored during recursion
    :go$ runes      :go with runes monitored during recursion
    :eval$ runes    :eval with runes monitored during recursion
    :help           this message
    :standard-help  :help message from ACL2 top-level

  [Break-rewrite] is just a call of the standard ACL2 read-eval-print
  loop, [ld], on a ``[wormhole]'' [state]. Thus, you may execute most
  commands you might normally execute at the top-level of ACL2.
  However, all [state] changes you cause from within [break-rewrite]
  are lost when you exit or :eval the rule. You cannot modify
  [stobj]s from within the break. See [break-rewrite] for more
  details and see [ld] for general information about the standard
  ACL2 read-eval-print loop.")
 (BRR@
  (BREAK-REWRITE)
  "To access context sensitive information within [break-rewrite]

    Example:
    (brr@ :target)      ; the term being rewritten
    (brr@ :unify-subst) ; the unifying substitution

    General Form:
    (brr@ :symbol)

  where :symbol is one of the following keywords. Those marked with *
  probably require an implementor's knowledge of the system to use
  effectively. They are supported but not well documented. More is
  said on this topic following the table.

    :symbol             (brr@ :symbol)
    -------             ---------------------

    :target             the term to be rewritten.  This term is an
                        instantiation of the left-hand side of the
                        conclusion of the rewrite-rule being broken.
                        This term is in translated form!  Thus, if
                        you are expecting (equal x nil) -- and your
                        expectation is almost right -- you will see
                        (equal x 'nil); similarly, instead of (cadr a)
                        you will see (car (cdr a)).  In translated
                        forms, all constants are quoted (even nil, t,
                        strings and numbers) and all macros are
                        expanded.

    :unify-subst        the substitution that, when applied to :target,
                        produces the left-hand side of the rule being
                        broken.  This substitution is an alist pairing
                        variable symbols to translated (!) terms.

    :wonp               t or nil indicating whether the rune was
                        successfully applied.  (brr@ :wonp) returns
                        nil if evaluated before :EVALing the rule.

    :rewritten-rhs      the result of successfully applying the rule
                        or else nil if (brr@ :wonp) is nil.  The result
                        of successfully applying the rule is always a
                        translated (!) term and is never nil.

    :failure-reason     some non-nil lisp object indicating why the rule
                        was not applied or else nil.  Before the rule is
                        :EVALed, (brr@ :failure-reason) is nil.  After
                        :EVALing the rule, (brr@ :failure-reason) is nil
                        if (brr@ :wonp) is t.  Rather than document the
                        various non-nil objects returned as the failure
                        reason, we encourage you simply to evaluate
                        (brr@ :failure-reason) in the contexts of interest.
                        Alternatively, study the ACL2 function tilde-@-
                        failure-reason-phrase.

    :lemma           *  the rewrite rule being broken.  For example,
                        (access rewrite-rule (brr@ :lemma) :lhs) will
                        return the left-hand side of the conclusion
                        of the rule.

    :type-alist      *  a display of the type-alist governing :target.
                        Elements on the displayed list are of the form
                        (term type), where term is a term and type
                        describes information about term assumed to hold
                        in the current context.  The type-alist may be
                        used to determine the current assumptions, e.g.,
                        whether A is a CONSP.

    :ancestors       *  a stack of frames indicating the backchain history
                        of the current context.  The theorem prover is in
                        the process of trying to establish each hypothesis
                        in this stack.  Thus, the negation of each hypothesis
                        can be assumed false.  Each frame also records the
                        rules on behalf of which this backchaining is being
                        done and the weight (function symbol count) of the
                        hypothesis.  All three items are involved in the
                        heuristic for preventing infinite backchaining.
                        Exception:  Some frames are ``binding hypotheses''
                        (equal var term) or (equiv var (double-rewrite term))
                        that bind variable var to the result of rewriting
                        term.

    :gstack          *  the current goal stack.  The gstack is maintained
                        by rewrite and is the data structure printed as the
                        current ``path.''  Thus, any information derivable
                        from the :path brr command is derivable from gstack.
                        For example, from gstack one might determine that
                        the current term is the second hypothesis of a
                        certain rewrite rule.

  In general brr@-expressions are used in break conditions, the
  expressions that determine whether interactive breaks occur when
  [monitor]ed [rune]s are applied. See [monitor]. For example, you
  might want to break only those attempts in which one particular
  term is being rewritten or only those attempts in which the binding
  for the variable a is known to be a [consp]. Such conditions can be
  expressed using ACL2 system functions and the information provided
  by brr@. Unfortunately, digging some of this information out of the
  internal data structures may be awkward or may, at least, require
  intimate knowledge of the system functions. But since conditional
  expressions may employ arbitrary functions and macros, we
  anticipate that a set of convenient primitives will gradually
  evolve within the ACL2 community. It is to encourage this evolution
  that brr@ provides access to the *'d data.")
 (BUILT-IN-CLAUSE
  (RULE-CLASSES)
  "To build a clause into the simplifier

  See [rule-classes] for a general discussion of rule classes,
  including how they are used to build rules from formulas and a
  discussion of the various keywords in a rule class description.

    Example:
    (defthm acl2-count-abl
      (and (implies (and (true-listp x)
                         (not (equal x nil)))
                    (< (acl2-count (abl x))
                       (acl2-count x)))
           (implies (and (true-listp x)
                         (not (equal nil x)))
                    (< (acl2-count (abl x))
                       (acl2-count x))))
      :rule-classes :built-in-clause)

  A :built-in-clause rule can be built from any formula other than
  propositional tautologies. Roughly speaking, the system uses the
  list of built-in clauses as the first method of proof when
  attacking a new goal. Any goal that is subsumed by a built in
  clause is proved ``silently.''

  ACL2 maintains a set of ``built-in'' clauses that are used to
  short-circuit certain theorem proving tasks. We discuss this at
  length below. When a theorem is given the rule class
  :built-in-clause ACL2 flattens the [implies] and [and] structure of
  the :[corollary] formula so as to obtain a set of formulas whose
  conjunction is equivalent to the given corollary. It then converts
  each of these to clausal form and adds each clause to the set of
  built-in clauses.

  The example above (regardless of the definition of abl) will build in
  two clauses,

    {(not (true-listp x))
     (equal x nil)
     (< (acl2-count (abl x)) (acl2-count x))}

  and

    {(not (true-listp x))
     (equal nil x)
     (< (acl2-count (abl x)) (acl2-count x))}.

  We now give more background.

  Recall that a clause is a set of terms, implicitly representing the
  disjunction of the terms. Clause c1 is ``subsumed'' by clause c2 if
  some instance of c2 is a subset c1.

  For example, let c1 be

    {(not (consp l))
     (equal a (car l))
     (< (acl2-count (cdr l)) (acl2-count l))}.

  Then c1 is subsumed by c2, shown below,

    {(not (consp x))
     ; second term omitted here
     (< (acl2-count (cdr x)) (acl2-count x))}

  because we can instantiate x in c2 with l to obtain a subset of c1.

  Observe that c1 is the clausal form of

    (implies (and (consp l)
                  (not (equal a (car l))))
             (< (acl2-count (cdr l)) (acl2-count l))),

  c2 is the clausal form of

    (implies (consp l)
             (< (acl2-count (cdr l)) (acl2-count l)))

  and the subsumption property just means that c1 follows trivially
  from c2 by instantiation.

  The set of built-in clauses is just a set of known theorems in
  clausal form. Any formula that is subsumed by a built-in clause is
  thus a theorem. If the set of built-in theorems is reasonably
  small, this little theorem prover is fast. ACL2 uses the ``built-in
  clause check'' in four places: (1) at the top of the iteration in
  the prover -- thus if a built-in clause is generated as a subgoal
  it will be recognized when that goal is considered, (2) within the
  simplifier so that no built-in clause is ever generated by
  simplification, (3) as a filter on the clauses generated to prove
  the termination of recursively [defun]'d functions and (4) as a
  filter on the clauses generated to verify the guards of a function.

  The latter two uses are the ones that most often motivate an
  extension to the set of built-in clauses. Frequently a given
  formalization problem requires the definition of many functions
  which require virtually identical termination and/or guard proofs.
  These proofs can be short-circuited by extending the set of
  built-in clauses to contain the most general forms of the clauses
  generated by the definitional schemes in use.

  The attentive user might have noticed that there are some recursive
  schemes, e.g., recursion by [cdr] after testing [consp], that ACL2
  just seems to ``know'' are ok, while for others it generates
  measure clauses to prove. Actually, it always generates measure
  clauses but then filters out any that pass the built-in clause
  check. When ACL2 is initialized, the clause justifying [cdr]
  recursion after a [consp] test is added to the set of built-in
  clauses. (That clause is c2 above.)

  Note that only a subsumption check is made; no rewriting or
  simplification is done. Thus, if we want the system to ``know''
  that [cdr] recursion is ok after a negative [atom] test (which, by
  the definition of [atom], is the same as a [consp] test), we have
  to build in a second clause. The subsumption algorithm does not
  ``know'' about commutative functions. Thus, for predictability, we
  have built in commuted versions of each clause involving
  commutative functions. For example, we build in both

    {(not (integerp x))
     (< 0 x)
     (= x 0)
     (< (acl2-count (+ -1 x)) (acl2-count x))}

  and the commuted version

    {(not (integerp x))
     (< 0 x)
     (= 0 x)
     (< (acl2-count (+ -1 x)) (acl2-count x))}

  so that the user need not worry whether to write (= x 0) or (= 0 x)
  in definitions.

  :built-in-clause rules added by the user can be enabled and disabled.")
 (BUTLAST
  (ACL2-BUILT-INS)
  "All but a final segment of a list

  (Butlast l n) is the list obtained by removing the last n elements
  from the true list l. The following is a theorem (though it takes
  some effort, including lemmas, to get ACL2 to prove it).

    (implies (and (integerp n)
                  (<= 0 n)
                  (true-listp l))
             (equal (length (butlast l n))
                    (if (< n (length l))
                        (- (length l) n)
                      0)))

  For related functions, see [take] and see [nthcdr].

  The [guard] for (butlast l n) requires that n is a nonnegative
  integer and lst is a true list.

  Butlast is a Common Lisp function. See any Common Lisp documentation
  for more information. Note: In Common Lisp the second argument of
  butlast is optional, but in ACL2 it is required.

  Function: <butlast>

    (defun butlast (lst n)
           (declare (xargs :guard (and (true-listp lst)
                                       (integerp n)
                                       (<= 0 n))))
           (let ((lng (len lst)) (n (nfix n)))
                (if (<= lng n)
                    nil (take (- lng n) lst))))")
 (BY (POINTERS)
     "See [hints] for keyword :by.")
 (CAAAAR
    (ACL2-BUILT-INS)
    "[car] of the [caaar]

  See any Common Lisp documentation for details.")
 (CAAADR
    (ACL2-BUILT-INS)
    "[car] of the [caadr]

  See any Common Lisp documentation for details.")
 (CAAAR
     (ACL2-BUILT-INS)
     "[car] of the [caar]

  See any Common Lisp documentation for details.")
 (CAADAR
    (ACL2-BUILT-INS)
    "[car] of the [cadar]

  See any Common Lisp documentation for details.")
 (CAADDR
    (ACL2-BUILT-INS)
    "[car] of the [caddr]

  See any Common Lisp documentation for details.")
 (CAADR
     (ACL2-BUILT-INS)
     "[car] of the [cadr]

  See any Common Lisp documentation for details.")
 (CAAR
      (ACL2-BUILT-INS)
      "[car] of the [car]

  See any Common Lisp documentation for details.")
 (CADAAR
    (ACL2-BUILT-INS)
    "[car] of the [cdaar]

  See any Common Lisp documentation for details.")
 (CADADR
    (ACL2-BUILT-INS)
    "[car] of the [cdadr]

  See any Common Lisp documentation for details.")
 (CADAR
     (ACL2-BUILT-INS)
     "[car] of the [cdar]

  See any Common Lisp documentation for details.")
 (CADDAR
    (ACL2-BUILT-INS)
    "[car] of the [cddar]

  See any Common Lisp documentation for details.")
 (CADDDR
    (ACL2-BUILT-INS)
    "[car] of the [cdddr]

  See any Common Lisp documentation for details.")
 (CADDR
     (ACL2-BUILT-INS)
     "[car] of the [cddr]

  See any Common Lisp documentation for details.")
 (CADR
      (ACL2-BUILT-INS)
      "[car] of the [cdr]

  See any Common Lisp documentation for details.")
 (CALLING-LD-IN-BAD-CONTEXTS
  (LD)
  "Errors caused by calling [ld] in inappropriate contexts

  The macro [ld] was designed to be called directly in the top-level
  ACL2 loop, although there may be a few occasions for calling it
  from functions. ACL2 cannot cope with invocations of [ld] during
  the process of loading a compiled file for a book, so this is an
  error.

  To see how that can happen, consider the following book, where file
  const.lsp contains the single form (defconst *foo* '(a b)).

    (in-package \"ACL2\")
    (defttag t)
    (progn! (ld \"const.lsp\"))

  An attempt to certify this book will cause an error, but that
  particular error can be avoided, as discussed below. If the book is
  certified, however, with production of a corresponding compiled
  file (which is the default behavior for [certify-book]), then any
  subsequent call of [include-book] that loads this compiled file
  will cause an error. Again, this error is necessary because of how
  ACL2 is designed; specifically, this [ld] call would interfere with
  tracking of constant definitions when loading the compiled file for
  the book.

  Because including such a book (with a compiled file) causes an error,
  then as a courtesy to the user, ACL2 arranges that the
  certification will fail (thus avoiding a surprise later when trying
  to include the book). The error in that case will look as follows.

    ACL2 Error in LD:  It is illegal to call LD in this context.  See DOC
    calling-ld-in-bad-contexts.

  If you really think it is OK to avoid this error, you can get around
  it by setting [state] global variable ld-okp to t: (assign ld-okp
  t). You can then certify the book in the example above, but you
  will still not be able to include it with a compiled file.")
 (CANONICAL-PATHNAME
  (ACL2-BUILT-INS)
  "The true absolute filename, with soft links resolved

  For the name fname of a file, the form (Canonical-pathname fname nil
  state) evaluates to a Unix-style absolute filename representing the
  same file as fname, but generally without any use of soft links in
  the name. (Below, we explain the qualifier ``generally''.) If
  however the file indicated by fname does not exist,
  (canonical-pathname fname nil state) is nil. Thus,
  canonical-pathname can be used as one would use the raw Lisp
  function probe-file.

  The specification of (Canonical-pathname fname dir-p state) when
  dir-p is not nil is simlar, except that if the specified file
  exists but is not a directory, then the result is nil.

  The function canonical-pathname has a guard of t, though the second
  argument must be the ACL2 [state]. This function is introduced with
  the following properties.

    (defthm canonical-pathname-is-idempotent
      (equal (canonical-pathname (canonical-pathname x dir-p state) dir-p state)
             (canonical-pathname x dir-p state)))
    (defthm canonical-pathname-type
      (or (equal (canonical-pathname x dir-p state) nil)
          (stringp (canonical-pathname x dir-p state)))
      :rule-classes :type-prescription)

  We use the qualifier ``generally'', above, because there is no
  guarantee that the filename will be canonical without soft links,
  though we expect this to be true in practice. ACL2 attempts to
  compute the desired result and then checks that the input and
  result have the same Common Lisp ``truename''. This check is
  expected to succeed, but if it fails then the input string is
  returned unchanged, and to be conservative, the value returned is
  nil in this case if dir-p is true.")
 (CAR
  (ACL2-BUILT-INS)
  "Returns the first element of a non-empty list, else nil

  Completion Axiom (completion-of-car):

    (equal (car x)
           (cond
            ((consp x)
             (car x))
            (t nil)))

  [Guard]:

    (or (consp x) (equal x nil))

  Notice that in the ACL2 logic, car returns nil for every [atom].")
 (CASE
  (ACL2-BUILT-INS)
  "Conditional based on if-then-else using [eql]

    Example Form:
    (case typ
      ((:character foo)
       (open file-name :direction :output))
      (bar (open-for-bar file-name))
      (otherwise
       (my-error \"Illegal.\")))

  is the same as

    (cond ((member typ '(:character foo))
           (open file-name :direction :output))
          ((eql typ 'bar)
           (open-for-bar file-name))
          (t (my-error \"Illegal.\")))

  which in turn is the same as

    (if (member typ '(:character foo))
        (open file-name :direction :output)
        (if (eql typ 'bar)
            (open-for-bar file-name)
            (my-error \"Illegal.\")))

  Notice the quotations that appear in the example above: '(:character
  foo) and 'bar.

    General Forms:
    (case expr
      (x1 val-1)
      ...
      (xk val-k)
      (otherwise val-k+1))

    (case expr
      (x1 val-1)
      ...
      (xk val-k)
      (t val-k+1))

    (case expr
      (x1 val-1)
      ...
      (xk val-k))

  where each xi is either [eqlablep] or a true list of [eqlablep]
  objects. The final otherwise or t case is optional.

  Case is defined in Common Lisp. See any Common Lisp documentation for
  more information.")
 (CASE-MATCH
  (ACL2-BUILT-INS)
  "Pattern matching or destructuring

    General Form:
    (case-match x
      (pat1 dcl1 body1)
      ...
      (patk dclk bodyk))

  where x is a variable symbol, the pati are structural patterns as
  described below, the dcli are optional [declare] forms and the
  bodyi are terms. Return the value(s) of the bodyi corresponding to
  the first pati matching x, or nil if none matches.

  Pattern Language:
  With the few special exceptions described below, matching requires
  that the [cons] structure of x be isomorphic to that of the
  pattern, down to the [atom]s in the pattern. Non-symbol [atom]s in
  the pattern match only themselves. Symbols in the pattern denote
  variables which match anything and which are bound by a successful
  match to the corresponding substructure of x. Variables that occur
  more than once must match the same ([equal]) structure in every
  occurrence.

    Exceptions:
    &               Matches anything and is not bound.  Repeated
                      occurrences of & in a pattern may match different
                      structures.
    nil, t, *sym*   These symbols cannot be bound and match only their
                      global values.
    !sym            where sym is a symbol that is already bound in the
                      context of the case-match, matches only the
                      current binding of sym.
    'obj            Matches only itself.

  Some examples are shown below.

  Below we show some sample patterns and examples of things they match
  and do not match.

    pattern       matches         non-matches
    (x y y)       (ABC 3 3)       (ABC 3 4)    ; 3 is not 4
    (fn x . rst)  (P (A I) B C)   (ABC)        ; NIL is not (x . rst)
                  (J (A I))                    ; rst matches nil
    ('fn (g x) 3) (FN (H 4) 3)    (GN (G X) 3) ; 'fn matches only itself
    (& t & !x)    ((A) T (B) (C))              ; provided x is '(C)

  Consider the two binary trees that contain three leaves. They might
  be described as (x . (y . z)) and ((x . y) . z), where x, y, and z
  are atomic. Suppose we wished to recognize those trees. The
  following case-match would do:

    (case-match tree
      ((x . (y . z))
       (and (atom x) (atom y) (atom z)))
      (((x . y) . z)
       (and (atom x) (atom y) (atom z))))

  Suppose we wished to recognize such trees where all three tips are
  identical. Suppose further we wish to return the tip if the tree is
  one of those recognized ones and to return the number 7 otherwise.

    (case-match tree
      ((x . (x . x))
       (if (atom x) x 7))
      (((x . x) . x)
       (if (atom x) x 7))
      (& 7))

  Note that case-match returns nil if no pati matches. Thus if we must
  return 7 in that case, we have to add as the final pattern the &,
  which always matches anything.")
 (CASE-SPLIT
  (MISCELLANEOUS REWRITE)
  "Like force but immediately splits the top-level goal on the
  hypothesis

  Case-split is an variant of [force], which has similar special
  treatment in hypotheses of rules for the same [rule-classes] as for
  force (see [force]). This treatment takes place for rule classes
  :[rewrite], :[linear], :[type-prescription], :[definition], :[meta]
  (actually in that case, the result of evaluating the hypothesis
  metafunction call), and :[forward-chaining].

  When a hypothesis of a conditional rule (of one of the classes listed
  above) has the form (case-split hyp) it is logically equivalent to
  hyp. However it affects the application of the rule generated as
  follows: if ACL2 attempts to apply the rule but cannot establish
  that the required instance of hyp holds in the current context, it
  considers the hypothesis true anyhow, but (assuming all hypotheses
  are seen to be true and the rule is applied) creates a subgoal in
  which that instance of hyp is assumed false. (There are exceptions,
  noted below.)

  For example, given the rule

    (defthm p1->p2
      (implies (case-split (p1 x))
               (p2 x)))

  then an attempt to prove

    (implies (p3 x) (p2 (car x)))

  can give rise to a single subgoal:

    (IMPLIES (AND (NOT (P1 (CAR X))) (P3 X))
             (P2 (CAR X))).

  Unlike [force], case-split does not delay the ``false case'' to a
  forcing round but tackles it more or less immediately.

  The special ``split'' treatment of case-split can be disabled by
  disabling forcing: see [force] for a discussion of disabling
  forcing, and also see [disable-forcing]. Finally, we should mention
  that the rewriter is never willing to split when there is an [if]
  term present in the goal being simplified. Since [and] terms and
  [or] terms are merely abbreviations for [if] terms, they also
  prevent splitting. Note that [if] terms are ultimately eliminated
  using the ordinary flow of the proof (but see
  [set-case-split-limitations]), so case-split will ultimately
  function as intended.

  When in the proof checker, case-split behaves like force.

  Function: <case-split>

    (defun case-split (x) (declare (xargs :guard t)) x)")
 (CASE-SPLIT-LIMITATIONS
  (MISCELLANEOUS)
  "A list of two ``numbers'' limiting the number of cases produced at
  once

    Examples:
    ACL2 !>(case-split-limitations (w state))
    (500 100)

  With the setting above, clausify will not try subsumption/replacement
  if more than 500 clauses are involved. Furthermore, the simplifier,
  as it sweeps over a clause, will inhibit further case splits when
  it has accumulated 100 subgoals. This inhibition is implemented by
  continuing to rewrite subsequent literals but not splitting out
  their cases. This can produce literals containing IFs.

  See [set-case-split-limitations] for a more general discussion.")
 (CASES (POINTERS)
        "See [hints] for keyword :cases.")
 (CBD
  (BOOKS)
  "Connected book directory string

    Example:
    ACL2 !>:cbd
    \"/usr/home/smith/\"

  The connected book directory is a nonempty string that specifies a
  directory as an absolute pathname. (See [pathname] for a discussion
  of file naming conventions.) When [include-book] is given a
  relative book name it elaborates it into a full book name,
  essentially by appending the connected book directory string to the
  left and \".lisp\" to the right. (For details, see [book-name] and
  also see [full-book-name].) Furthermore, [include-book] temporarily
  sets the connected book directory to the directory string of the
  resulting full book name so that references to inferior [books] in
  the same directory may omit the directory. See [set-cbd] for how to
  set the connected book directory string.

    General Form:
    (cbd)

  This is a macro that expands into a term involving the single free
  variable [state]. It returns the connected book directory string.

  The connected book directory (henceforth called the ``cbd'') is used
  by [include-book] to elaborate the supplied book name into a full
  book name (see [full-book-name]). For example, if the cbd is
  \"/usr/home/smith/\" then the elaboration of the [book-name]
  \"project/task-1/arith\" (to the \".lisp\" extension) is
  \"/usr/home/smith/project/task-1/arith.lisp\". That [full-book-name]
  is what [include-book] opens to read the source text for the book.

  The cbd may be changed using [set-cbd] (see [set-cbd]). Furthermore,
  during the processing of the [events] in a book, [include-book]
  sets the cbd to be the directory string of the [full-book-name] of
  the book. Thus, if the cbd is \"/usr/home/smith/\" then during the
  processing of [events] by

    (include-book \"project/task-1/arith\")

  the cbd will be set to \"/usr/home/smith/project/task-1/\". Note that
  if \"arith\" recursively includes a subbook, say \"naturals\", that
  resides on the same directory, the [include-book] event for it may
  omit the specification of that directory. For example, \"arith\"
  might contain the event

    (include-book \"naturals\").

  In general, suppose we have a superior book and several inferior
  [books] which are included by [events] in the superior book. Any
  inferior book residing on the same directory as the superior book
  may be referenced in the superior without specification of the
  directory.

  We call this a ``relative'' as opposed to ``absolute'' naming. The
  use of relative naming is preferred because it permits [books] (and
  their accompanying inferiors) to be moved between directories while
  maintaining their [certificate]s and utility. Certified [books]
  that reference inferiors by absolute file names are unusable (and
  rendered uncertified) if the inferiors are moved to new
  directories.

  Technical Note and a Challenge to Users:

  After elaborating the book name to a full book name, [include-book]
  opens a channel to the file to process the [events] in it. In some
  host Common Lisps, the actual file opened depends upon a notion of
  ``connected directory'' similar to our connected book directory.
  Our intention in always elaborating book names into absolute
  filename strings (see [pathname] for terminology) is to circumvent
  the sensitivity to the connected directory. But we may have
  insufficient control over this since the ultimate file naming
  conventions are determined by the host operating system rather than
  Common Lisp (though, we do check that the operating system
  ``appears'' to be one that we ``know'' about). Here is a question,
  which we'll pose assuming that we have an operating system that
  calls itself ``Unix.'' Suppose we have a file name, filename, that
  begins with a slash, e.g., \"/usr/home/smith/...\". Consider two
  successive invocations of CLTL's

    (open filename :direction :input)

  separated only by a change to the operating system's notion of
  connected directory. Must these two invocations produce streams to
  the same file? A candidate string might be something like
  \"/usr/home/smith/*/usr/local/src/foo.lisp\" which includes some
  operating system-specific special character to mean ``here insert
  the connected directory'' or, more generally, ``here make the name
  dependent on some non-ACL2 aspect of the host's state.'' If such
  ``tricky'' name strings beginning with a slash exist, then we have
  failed to isolate ACL2 adequately from the operating system's file
  naming conventions. Once upon a time, ACL2 did not insist that the
  cbd begin with a slash and that allowed the string \"foo.lisp\" to be
  tricky because if one were connected to \"/usr/home/smith/\" then
  with the empty cbd \"foo.lisp\" is a full book name that names the
  same file as \"/usr/home/smith/foo.lisp\". If the actual file one
  reads is determined by the operating system's state then it is
  possible for ACL2 to have two distinct ``full book names'' for the
  same file, the ``real'' name and the ``tricky'' name. This can
  cause ACL2 to include the same book twice, not recognizing the
  second one as redundant.")
 (CDAAAR
    (ACL2-BUILT-INS)
    "[cdr] of the [caaar]

  See any Common Lisp documentation for details.")
 (CDAADR
    (ACL2-BUILT-INS)
    "[cdr] of the [caadr]

  See any Common Lisp documentation for details.")
 (CDAAR
     (ACL2-BUILT-INS)
     "[cdr] of the [caar]

  See any Common Lisp documentation for details.")
 (CDADAR
    (ACL2-BUILT-INS)
    "[cdr] of the [cadar]

  See any Common Lisp documentation for details.")
 (CDADDR
    (ACL2-BUILT-INS)
    "[cdr] of the [caddr]

  See any Common Lisp documentation for details.")
 (CDADR
     (ACL2-BUILT-INS)
     "[cdr] of the [cadr]

  See any Common Lisp documentation for details.")
 (CDAR
      (ACL2-BUILT-INS)
      "[cdr] of the [car]

  See any Common Lisp documentation for details.")
 (CDDAAR
    (ACL2-BUILT-INS)
    "[cdr] of the [cdaar]

  See any Common Lisp documentation for details.")
 (CDDADR
    (ACL2-BUILT-INS)
    "[cdr] of the [cdadr]

  See any Common Lisp documentation for details.")
 (CDDAR
     (ACL2-BUILT-INS)
     "[cdr] of the [cdar]

  See any Common Lisp documentation for details.")
 (CDDDAR
    (ACL2-BUILT-INS)
    "[cdr] of the [cddar]

  See any Common Lisp documentation for details.")
 (CDDDDR
    (ACL2-BUILT-INS)
    "[cdr] of the [cdddr]

  See any Common Lisp documentation for details.")
 (CDDDR
     (ACL2-BUILT-INS)
     "[cdr] of the [cddr]

  See any Common Lisp documentation for details.")
 (CDDR
      (ACL2-BUILT-INS)
      "[cdr] of the [cdr]

  See any Common Lisp documentation for details.")
 (CDR
  (ACL2-BUILT-INS)
  "Returns the second element of a [cons] pair, else nil

  Completion Axiom (completion-of-cdr):

    (equal (cdr x)
           (cond
            ((consp x)
             (cdr x))
            (t nil)))

  [Guard]:

    (or (consp x) (equal x nil))

  Notice that in the ACL2 logic, cdr returns nil for every [atom].")
 (CEILING
  (ACL2-BUILT-INS)
  "Division returning an integer by truncating toward positive infinity

    Example Forms:
    ACL2 !>(ceiling 14 3)
    5
    ACL2 !>(ceiling -14 3)
    -4
    ACL2 !>(ceiling 14 -3)
    -4
    ACL2 !>(ceiling -14 -3)
    5
    ACL2 !>(ceiling -15 -3)
    5

  (Ceiling i j) is the result of taking the quotient of i and j and
  returning the smallest integer that is at least as great as that
  quotient. For example, the quotient of -14 by 3 is -4 2/3, and the
  smallest integer at least that great is -4.

  The [guard] for (ceiling i j) requires that i and j are rational
  ([real], in ACL2(r)) numbers and j is non-zero.

  Ceiling is a Common Lisp function. See any Common Lisp documentation
  for more information. However, note that unlike Common Lisp, the
  ACL2 ceiling function returns only a single value,

  Function: <ceiling>

    (defun ceiling (i j)
           (declare (xargs :guard (and (real/rationalp i)
                                       (real/rationalp j)
                                       (not (eql j 0)))))
           (let* ((q (* i (/ j)))
                  (n (numerator q))
                  (d (denominator q)))
                 (cond ((= d 1) n)
                       ((>= n 0)
                        (+ (nonnegative-integer-quotient n d)
                           1))
                       (t (- (nonnegative-integer-quotient (- n)
                                                           d))))))")
 (CERTIFICATE
  (BOOKS)
  "How a book is known to be admissible and where its [defpkg]s reside

  A book, say \"arith\", is said to have a ``certificate'' if there is a
  file named \"arith.cert\". Certificates are created by the function
  [certify-book] and inspected by [include-book]. Check sums are used
  to help ensure that certificates are legitimate and that the
  corresponding book has not been modified since certification. But
  because the file system is insecure and check sums are not perfect
  it is possible for the inclusion of a book to cause inconsistency
  even though the book carries an impeccable certificate.

  The certificate includes the version number of the certifying ACL2. A
  book is considered uncertified if it is included in an ACL2 with a
  different [version] number.

  The presence of a ``valid'' certificate file for a book attests to
  two things: all of the [events] of the book are admissible in a
  certain extension of the initial ACL2 logic, and the non-[local]
  [events] of the book are independent of the [local] ones (see
  [local-incompatibility]). In addition, the certificate contains the
  [command]s used to construct the [world] in which certification
  occurred. Among those [command]s, of course, are the [defpkg]s
  defining the packages used in the book. When a book is included
  into a host [world], that [world] is first extended by the
  [command]s listed in the certificate for the book. Unless that
  causes an error due to name conflicts, the extension ensures that
  all the packages used by the book are identically defined in the
  host [world].

  Security:

  Because the host file system is insecure, there is no way ACL2 can
  guarantee that the contents of a book remain the same as when its
  certificate was written. That is, between the time a book is
  certified and the time it is used, it may be modified. Furthermore,
  certificates can be counterfeited. Check sums (see [check-sum]) are
  used to help detect such problems. But check sums provide imperfect
  security: two different files can have the same check sum.

  Therefore, from the strictly logical point of view, one must consider
  even the inclusion of certified [books] as placing a burden on the
  user:

      The non-erroneous inclusion of a certified book is consistency
      preserving provided (a) the objects read by [include-book] from
      the certificate were the objects written there by a
      [certify-book] and (b) the forms read by [include-book] from
      the book itself are the forms read by the corresponding
      [certify-book].

  We say that a given execution of [include-book] is ``certified'' if a
  certificate file for the book is present and well-formed and the
  check sum information contained within it supports the conclusion
  that the [events] read by the [include-book] are the ones checked
  by [certify-book]. When an uncertified [include-book] occurs,
  warnings are printed or errors are caused. But even if no warning
  is printed, you must accept burdens (a) and (b) if you use [books].
  These burdens are easier to live with if you protect your [books]
  so that other users cannot write to them, you abstain from running
  concurrent ACL2 jobs, and you abstain from counterfeiting
  certificates. But even on a single user uniprocessor, you can shoot
  yourself in the foot by using the ACL2 [io] primitives to fabricate
  an inconsistent book and the corresponding certificate.

  Note that part (a) of the burden described above implies, in
  particular, that there are no guarantees when a certificate is
  copied. When [books] are renamed (as by copying them), it is
  recommended that their certificates be removed and the [books] be
  recertified. The expectation is that recertification will go
  through without a hitch if relative [pathname]s are used. See
  [pathname], which is not on the guided tour.

  Certificates essentially contain two parts, a [portcullis] and a
  [keep]. There is a third part, an expansion-alist, in order to
  record expansions if [make-event] has been used, but the user need
  not be concerned with that level of detail.

  See [portcullis] to continue the guided tour through [books].")
 (CERTIFY-BOOK
  (BOOKS PROGRAMMING OTHER)
  "How to produce a [certificate] for a book

    Examples:
    (certify-book \"my-arith\")          ; certify in a world with 0 commands
    (certify-book \"my-arith\" 3)        ; ... in a world with 3 commands
    (certify-book \"my-arith\" ?)        ; ... in a world without checking the
                                         ;     number of commands
    (certify-book \"my-arith\" 0 nil)    ; ... without compilation
    (certify-book \"my-arith\" 0 t)      ; ... with compilation (default)
    (certify-book \"my-arith\" 0 t :ttags (foo))
                                         ; ... allowing trust tag (ttag) foo
    (certify-book \"my-arith\" 0 t :ttags :all)
                                         ; ... allowing all trust tags (ttags)
    (certify-book \"my-arith\" t)        ; ... from world of old certificate
    (certify-book \"my-arith\" 0 nil :acl2x t)
                                         ; ... writing or reading a .acl2x file

    General Form:
    (certify-book book-name
                  k                           ; [default 0]
                  compile-flg                 ; [default t]
                  :defaxioms-okp t/nil        ; [default nil]
                  :skip-proofs-okp t/nil      ; [default nil]
                  :ttags ttags                ; [default nil]
                  :acl2x t/nil                ; [default nil]
                  :ttagsx ttags               ; [default nil]
                  :write-port t/nil           ; [default t]
                  :pcert pcert                ; [default nil]
                  )

  where book-name is a book name (see [book-name]), k is used to
  indicate your approval of the ``certification [world],'' and
  compile-flg can control whether the book is to be compiled. The
  defaults for compile-flg, skip-proofs-okp, acl2x, write-port, and
  pcert can be affected by environment variables. All of these
  arguments are described in detail below, except for :pcert. (We
  assume below that the value of :pcert is nil (and environment
  variable ACL2_PCERT_ARG is unset or the empty string). For a
  discussion of this argument, see [provisional-certification].)

  Certification occurs in some logical [world], called the
  ``certification [world].'' That [world] must contain the [defpkg]s
  needed to read and execute the forms in the book. The [command]s
  necessary to recreate that [world] from the ACL2 initial [world]
  are called the ``[portcullis] commands,'' and will be copied into
  the [certificate] created for the book. Those [command]s will be
  re-executed whenever the book is included, to ensure that the
  appropriate packages (and all other names used in the certification
  [world]) are correctly defined. The certified book will be more
  often usable if the certification [world] is kept to a minimal
  extension of the ACL2 initial [world] (for example, to prevent name
  clashes with functions defined in other books). Thus, before you
  call certify-book for the first time on a book, you may wish to get
  into the initial ACL2 [world] (e.g., with :ubt 1 or just starting a
  new version of ACL2), [defpkg] the desired packages, and then
  invoke certify-book.

  The k argument to certify-book must be either a nonnegative integer
  or else one of the symbols t or ? in any package. If k is an
  integer, then it must be the number of [command]s that have been
  executed after the initial ACL2 [world] to create the [world] in
  which certify-book was called. One way to obtain this number is by
  doing :pbt :start to see all the [command]s back to the first one.

  If k is t (or any symbol whose [symbol-name] is \"T\"), it means that
  certify-book should use the same [world] used in the last
  certification of this book. K may have such a value only if you
  call certify-book in the initial ACL2 [world] and there is a
  [certificate] on file for the book being certified. (Of course, the
  [certificate] is probably invalid.) In this case, certify-book
  reads the old [certificate] to obtain the [portcullis] [command]s
  and executes them to recreate the certification [world].

  Finally, k may be ? (or any symbol whose [symbol-name] is \"?\"), in
  which case there is no check made on the certification world. That
  is, if k is such a value then no action related to the preceding
  two paragraphs is performed, which can be a nice convenience but at
  the cost of eliminating a potentially valuable check that the
  certification [world] may be as expected.

  We next describe the meaning of compile-flg and how it defaults. If
  explicit compilation has been suppressed by (set-compiler-enabled
  nil state), then compile-flg is coerced to nil; see [compilation].
  Otherwise compile-flg may be given the value of t (or :all, which
  is equivalent to t except during provisional certification; see
  [provisional-certification]), indicating that the book is to be
  compiled, or else nil. (Note that compilation initially creates a
  compiled file with a temporary file name, and then moves that
  temporary file to the final compiled file name obtained by adding a
  suitable extension to the book name. Thus, a compiled file will
  appear atomically in its intended location.) Finally, suppose that
  compile-flg is not supplied (or is :default). If environment
  variable ACL2_COMPILE_FLG is defined and not the empty string, then
  its value should be T, NIL, or ALL after converting to upper case,
  in which case compile-flg is considered to have value t, nil, or
  :all (respectively). Otherwise compile-flg defaults to t. Note that
  the value :all is equivalent to t except for during the Convert
  procedure of provisional certification; see
  [provisional-certification].

  Two keyword arguments, :defaxioms-okp and :skip-proofs-okp, determine
  how the system handles the inclusion of [defaxiom] events and
  [skip-proofs] events, respectively, in the book. The value t allows
  such events, but prints a warning message. The value nil causes an
  error if such an event is found. Nil is the default unless keyword
  argument :acl2x t is provided and state global 'write-acl2x is a
  cons (see [set-write-ACL2x]), in which case the default is t.

  The keyword argument :ttags may normally be omitted. A few
  constructs, used for example if you are building your own system
  based on ACL2, may require it. See [defttag] for an explanation of
  this argument.

  When book B is certified with value t (the default) for keyword
  argument :write-port, a file B.port is written by certification
  process. This file contains all of the [portcullis] [command]s for
  B, i.e., all user commands present in the ACL2 logical [world] at
  the time certify-book is called. if B.lisp later becomes
  uncertified, say because [events] from that file or an included
  book have been edited, then (include-book \"B\") will consult B.port
  to evaluate forms in that file before evaluating the events in
  B.lisp. On the other hand, B.port is ignored when including B if B
  is certified.

  If you use [guard]s, please note certify-book is executed as though
  (set-guard-checking nil) has been evaluated; see
  [set-guard-checking]. If you want guards checked, consider using ld
  instead, or in addition; see [ld].

  For a general discussion of books, see [books]. Certify-book is akin
  to what we have historically called a ``proveall'': all the forms
  in the book are ``proved'' to guarantee their admissibility. More
  precisely, certify-book (1) reads the forms in the book, confirming
  that the appropriate packages are defined in the certification
  [world]; (2) does the full admissibility checks on each form
  (proving termination of recursive functions, proving theorems,
  etc.), checking as it goes that each form is an embedded event form
  (see [embedded-event-form]); (3) rolls the [world] back to the
  initial certification [world] and does an [include-book] of the
  book to check for [local] incompatibilities (see
  [local-incompatibility]); (4) writes a [certificate] recording not
  only that the book was certified but also recording the [command]s
  necessary to recreate the certification [world] (so the appropriate
  packages can be defined when the book is included in other
  [world]s) and the check sums of all the [books] involved (see
  [certificate]); (5) compiles the book if so directed (and then
  loads the object file in that case). The result of executing a
  certify-book [command] is the creation of a single new event, which
  is actually an [include-book] event. If you don't want its included
  [events] in your present [world], simply execute :[ubt] :here
  afterwards.

  A utility is provided to assist in debugging failures of
  certify-book; see [redo-flat].)

  Certify-book requires that the default [defun-mode] (see
  [default-defun-mode]) be :[logic] when certification is attempted.
  If the mode is not :[logic], an error is signalled.

  An error will occur if certify-book has to deal with any uncertified
  book other than the one on which it was called. For example, if the
  book being certified includes another book, that subbook must
  already have been certified.

  If you have a certified book that has remained unchanged for some
  time you might well not remember the appropriate [defpkg]s for it,
  though they are stored in the [certificate] file and (by default)
  also in the .port file. If you begin to change the book, don't
  throw away its [certificate] file just because it has become
  invalid! It is an important historical document until the book is
  re-certified. More important, don't throw away the .port file, as
  it will provide the [portcullis] commands when including the book
  as an uncertified book; see [include-book].

  When certify-book is directed to produce a compiled file, it calls
  the Common Lisp function compile-file on the original source file.
  This creates a compiled file with an extension known to ACL2, e.g.,
  if the book is named \"my-book\" then the source file is
  \"my-book.lisp\" and the compiled file under GCL will be \"my-book.o\"
  while under SBCL it will be \"my-book.fasl\". The compiled file is
  then loaded. When [include-book] is used later on \"my-book\" it will
  automatically load the compiled file, provided the compiled file
  has a later write date than the source file. The only effect of
  such [compilation] and loading is that the functions defined in the
  book execute faster. See [guard] for a discussion of the issues,
  and if you want more details about [books] and compilation, see
  [book-compiled-file].

  When certify-book is directed not to produce a compiled file, it will
  delete any existing compiled file for the book, so as not to
  mislead [include-book] into loading the now outdated compiled file.
  Otherwise, certify-book will create a temporary ``expansion file''
  to compile, obtained by appending the string \"@expansion.lsp\" to
  the end of the book name. Remark: Users may ignore that file, which
  is automatically deleted unless [state] global variable
  'save-expansion-file has been set, presumably by a system
  developer, to a non-nil value; see [book-compiled-file] for more
  information about hit issue, including the role of environment
  variable ACL2_SAVE_EXPANSION.

  After execution of a certify-book form, the value of
  [ACL2-defaults-table] is restored to what it was immediately before
  that certify-book form was executed. See [ACL2-defaults-table].

  Those who use the relatively advanced features of trust tags (see
  [defttag]) and [make-event] may wish to know how to create a
  [certificate] file that avoids dependence on trust tags that are
  used only during [make-event] expansion. For this, including
  documentation of the :acl2x and :ttagsx keyword arguments for
  certify-book, see [set-write-ACL2x].

  This completes the tour through the [documentation] of [books].


Subtopics

  [Certify-book!]
      A variant of [certify-book]")
 (CERTIFY-BOOK!
  (CERTIFY-BOOK)
  "A variant of [certify-book]

    Examples:
    (certify-book! \"my-arith\" 3)     ;Certify in a world with 3
                                       ; commands, starting in a world
                                       ; with at least 3 commands.
    (certify-book! \"my-arith\")       ;Certify in the initial world.

    General Form:
    (certify-book! book-name k compile-flg)

  where book-name is a book name (see [book-name]), k is a nonnegative
  integer used to indicate the ``certification [world],'' and
  compile-flg indicates whether you wish to compile the (functions in
  the) book.

  This [command] is identical to [certify-book], except that the second
  argument k may not be t in certify-book! and if k exceeds the
  current [command] number, then an appropriate [ubt!] will be
  executed first. See [certify-book] and see [ubt!].")
 (CERTIFYING-BOOKS (POINTERS)
                   "See [books-certification].")
 (CHAR
  (ACL2-BUILT-INS)
  "The [nth] element (zero-based) of a string

  (Char s n) is the nth element of s, zero-based. If n is greater than
  or equal to the length of s, then char returns nil.

  (Char s n) has a [guard] that n is a non-negative integer and s is a
  [stringp].

  Char is a Common Lisp function. See any Common Lisp documentation for
  more information.

  Function: <char>

    (defun char (s n)
           (declare (xargs :guard (and (stringp s)
                                       (integerp n)
                                       (>= n 0)
                                       (< n (length s)))))
           (nth n (coerce s 'list)))")
 (CHAR-CODE
  (ACL2-BUILT-INS)
  "The numeric code for a given character

  Completion Axiom (completion-of-char-code):

    (equal (char-code x)
           (if (characterp x)
               (char-code x)
             0))

  [Guard] for (char-code x):

    (characterp x)

  This function maps all non-characters to 0.")
 (CHAR-DOWNCASE
  (ACL2-BUILT-INS)
  "Turn upper-case [characters] into lower-case [characters]

  (Char-downcase x) is equal to #\\a when x is #\\A, #\\b when x is #\\B,
  ..., and #\\z when x is #\\Z, and is x for any other character.

  The [guard] for char-downcase requires its argument to be a standard
  character (see [standard-char-p]).

  Char-downcase is a Common Lisp function. See any Common Lisp
  documentation for more information.

  Function: <char-downcase>

    (defun char-downcase (x)
           (declare (xargs :guard (and (characterp x)
                                       (standard-char-p x))))
           (let ((pair (assoc x
                              '((#\\A . #\\a)
                                (#\\B . #\\b)
                                (#\\C . #\\c)
                                (#\\D . #\\d)
                                (#\\E . #\\e)
                                (#\\F . #\\f)
                                (#\\G . #\\g)
                                (#\\H . #\\h)
                                (#\\I . #\\i)
                                (#\\J . #\\j)
                                (#\\K . #\\k)
                                (#\\L . #\\l)
                                (#\\M . #\\m)
                                (#\\N . #\\n)
                                (#\\O . #\\o)
                                (#\\P . #\\p)
                                (#\\Q . #\\q)
                                (#\\R . #\\r)
                                (#\\S . #\\s)
                                (#\\T . #\\t)
                                (#\\U . #\\u)
                                (#\\V . #\\v)
                                (#\\W . #\\w)
                                (#\\X . #\\x)
                                (#\\Y . #\\y)
                                (#\\Z . #\\z)))))
                (cond (pair (cdr pair))
                      ((characterp x) x)
                      (t (code-char 0)))))")
 (CHAR-EQUAL
  (ACL2-BUILT-INS)
  "Character equality without regard to case

  For [characters] x and y, (char-equal x y) is true if and only if x
  and y are the same except perhaps for their case.

  The [guard] on char-equal requires that its arguments are both
  standard [characters] (see [standard-char-p]).

  Char-equal is a Common Lisp function. See any Common Lisp
  documentation for more information.

  Function: <char-equal>

    (defun char-equal (x y)
           (declare (xargs :guard (and (characterp x)
                                       (standard-char-p x)
                                       (characterp y)
                                       (standard-char-p y))))
           (eql (char-downcase x)
                (char-downcase y)))")
 (CHAR-UPCASE
  (ACL2-BUILT-INS)
  "Turn lower-case [characters] into upper-case [characters]

  (Char-upcase x) is equal to #\\A when x is #\\a, #\\B when x is #\\b,
  ..., and #\\Z when x is #\\z, and is x for any other character.

  The [guard] for char-upcase requires its argument to be a standard
  character (see [standard-char-p]).

  Char-upcase is a Common Lisp function. See any Common Lisp
  documentation for more information.

  Function: <char-upcase>

    (defun char-upcase (x)
           (declare (xargs :guard (and (characterp x)
                                       (standard-char-p x))))
           (let ((pair (assoc x
                              '((#\\a . #\\A)
                                (#\\b . #\\B)
                                (#\\c . #\\C)
                                (#\\d . #\\D)
                                (#\\e . #\\E)
                                (#\\f . #\\F)
                                (#\\g . #\\G)
                                (#\\h . #\\H)
                                (#\\i . #\\I)
                                (#\\j . #\\J)
                                (#\\k . #\\K)
                                (#\\l . #\\L)
                                (#\\m . #\\M)
                                (#\\n . #\\N)
                                (#\\o . #\\O)
                                (#\\p . #\\P)
                                (#\\q . #\\Q)
                                (#\\r . #\\R)
                                (#\\s . #\\S)
                                (#\\t . #\\T)
                                (#\\u . #\\U)
                                (#\\v . #\\V)
                                (#\\w . #\\W)
                                (#\\x . #\\X)
                                (#\\y . #\\Y)
                                (#\\z . #\\Z)))))
                (cond (pair (cdr pair))
                      ((characterp x) x)
                      (t (code-char 0)))))")
 (CHAR<
  (ACL2-BUILT-INS)
  "Less-than test for [characters]

  (char< x y) is true if and only if the character code of x is less
  than that of y. See [char-code].

  The [guard] for char< specifies that its arguments are [characters].

  Char< is a Common Lisp function. See any Common Lisp documentation
  for more information.

  Function: <char<>

    (defun char< (x y)
           (declare (xargs :guard (and (characterp x) (characterp y))))
           (< (char-code x) (char-code y)))")
 (CHAR<=
  (ACL2-BUILT-INS)
  "Less-than-or-equal test for [characters]

  (char<= x y) is true if and only if the character code of x is less
  than or equal to that of y. See [char-code].

  The [guard] for char<= specifies that its arguments are [characters].

  Char<= is a Common Lisp function. See any Common Lisp documentation
  for more information.

  Function: <char<=>

    (defun char<= (x y)
           (declare (xargs :guard (and (characterp x) (characterp y))))
           (<= (char-code x) (char-code y)))")
 (CHAR>
  (ACL2-BUILT-INS)
  "Greater-than test for [characters]

  (char> x y) is true if and only if the character code of x is greater
  than that of y. See [char-code].

  The [guard] for char> specifies that its arguments are [characters].

  Char> is a Common Lisp function. See any Common Lisp documentation
  for more information.

  Function: <char>>

    (defun char> (x y)
           (declare (xargs :guard (and (characterp x) (characterp y))))
           (> (char-code x) (char-code y)))")
 (CHAR>=
  (ACL2-BUILT-INS)
  "Greater-than-or-equal test for [characters]

  (char>= x y) is true if and only if the character code of x is
  greater than or equal to that of y. See [char-code].

  The [guard] for char>= specifies that its arguments are [characters].

  Char>= is a Common Lisp function. See any Common Lisp documentation
  for more information.

  Function: <char>=>

    (defun char>= (x y)
           (declare (xargs :guard (and (characterp x) (characterp y))))
           (>= (char-code x) (char-code y)))")
 (CHARACTER-ALISTP
  (ACL2-BUILT-INS)
  "Recognizer for association lists with characters as keys

  (Character-alistp x) is true if and only if x is a list of pairs of
  the form (cons key val) where key is a [characterp].

  Function: <character-alistp>

    (defun character-alistp (x)
           (declare (xargs :guard t))
           (cond ((atom x) (eq x nil))
                 (t (and (consp (car x))
                         (characterp (car (car x)))
                         (character-alistp (cdr x))))))")
 (CHARACTER-ENCODING
  (IO)
  "How bytes are parsed into characters

  When the Common Lisp reader comes across bytes in a file or at the
  terminal, they are parsed into characters. The simplest case is
  when each byte that is read is a standard character (see
  [standard-char-p]). It is actually quite common that each byte that
  is read corresponds to a single character. The parsing of bytes
  into characters is based on a character encoding, that is, a
  mapping that associates one or more bytes with each legal
  character.

  In order to help guarantee the portability of files (including
  [books]), ACL2 installs a common character encoding for reading
  files, often known as iso-8859-1 or latin-1. For some host Lisps
  this character encoding is also used for reading from the terminal;
  but, sadly, this may not hold for all host Lisps, and may not even
  be possible for some of them.

  The use of the above encoding could in principle cause problems if
  one's editor produces files using an encoding other than
  iso-8859-1, at least if one uses non-standard characters. In
  particular, the default Emacs buffer encoding may be utf-8. If your
  file has non-standard characters, then in Emacs you can evaluate
  the form

    (setq save-buffer-coding-system 'iso-8859-1)

  before saving the buffer into a file. This will happen automatically
  for users who load distributed file emacs/emacs-acl2.el into their
  Emacs sessions.

  For an example of character encodings in action, see the community
  book books/misc/character-encoding-test.lisp.")
 (CHARACTER-LISTP
  (ACL2-BUILT-INS)
  "Recognizer for a true list of characters

  The predicate character-listp tests whether its argument is a true
  list of [characters].

  Function: <character-listp>

    (defun character-listp (l)
           (declare (xargs :guard t))
           (cond ((atom l) (equal l nil))
                 (t (and (characterp (car l))
                         (character-listp (cdr l))))))")
 (CHARACTERP
  (ACL2-BUILT-INS)
  "Recognizer for [characters]

  (characterp x) is true if and only if x is a character.")
 (CHARACTERS
  (ACL2-BUILT-INS)
  "Characters in ACL2

  ACL2 accepts 256 distinct characters, which are the characters
  obtained by applying the function [code-char] to each integer from
  0 to 255. Among these, Common Lisp designates certain ones as
  standard characters, namely those of the form (code-char n) where n
  is from 33 to 126, together with #\\Newline and #\\Space. The actual
  standard characters may be viewed by evaluating the [defconst]
  *standard-chars*.

  To be more precise, Common Lisp does not specify the precise
  relationship between [code-char] and the standard characters.
  However, we check that the underlying Common Lisp implementation
  uses a particular relationship that extends the usual ASCII coding
  of characters. We also check that Space, Tab, Newline, Page, and
  Rubout correspond to characters with respective [char-code]s 32, 9,
  10, 12, and 127.

  [Code-char] has an inverse, [char-code]. Thus, when [char-code] is
  applied to an ACL2 character, c, it returns a number n between 0
  and 255 inclusive such that (code-char n) = c.

  The preceding paragraph implies that there is only one ACL2 character
  with a given character code. CLTL allows for ``attributes'' for
  characters, which could allow distinct characters with the same
  code, but ACL2 does not allow this.

  The Character Reader

  ACL2 supports the `#\\' notation for characters provided by Common
  Lisp, with some restrictions. First of all, for every character c,
  the notation

    #\\c

  may be used to denote the character object c. That is, the user may
  type in this notation and ACL2 will read it as denoting the
  character object c. In this case, the character immediately
  following c must be one of the following ``terminating
  characters'': a Tab, a Newline, a Page character, a space, or one
  of the characters:

    \"  '  (  )  ;  `  ,

  Other than the notation above, ACL2 accepts alternate notation for
  five characters.

    #\\Space
    #\\Tab
    #\\Newline
    #\\Page
    #\\Rubout

  Again, in each of these cases the next character must be from among
  the set of ``terminating characters'' described in the
  single-character case. Our implementation is consistent with
  IS0-8859, even though we don't provide #\\ syntax for entering
  characters other than that described above.

  Finally, we note that it is our intention that any object printed by
  ACL2's top-level-loop may be read back into ACL2. Please notify the
  implementors if you find a counterexample to this claim.")
 (CHECK-SUM
  (ACL2-BUILT-INS)
  "Assigning ``often unique'' integers to files and objects

  A ``check sum'' is an integer in some fixed range computed from the
  printed representation of an object, e.g., the sum, modulo 2**32,
  of the ascii codes of all the [characters] in the printed
  representation.

  Ideally, you would like the check sum of an object to be uniquely
  associated with that object, like a fingerprint. It could then be
  used as a convenient way to recognize the object in the future: you
  could remember the check sum (which is relatively small) and when
  an object is presented to you and alleged to be the special one you
  could compute its check sum and see if indeed it was. Alas, there
  are many more objects than check sums (after all, each check sum is
  an object, and then there's t). So you try to design a check sum
  algorithm that maps similar looking objects far apart, in the hopes
  that corruptions and counterfeits --- which appear to be similar to
  the object --- have different check sums. Nevertheless, the best
  you can do is a many-to-one map. If an object with a different
  check sum is presented, you can be positive it is not the special
  object. But if an object with the same check sum is presented, you
  have no grounds for positive identification.

  The basic check sum algorithm in ACL2 is called check-sum-obj, which
  computes the check sum of an ACL2 object. Roughly speaking, we scan
  the print representation of the object and, for each character
  encountered, we multiply the ascii code of the character times its
  position in the stream (modulo a certain prime) and then add
  (modulo a certain prime) that into the running sum. This is
  inaccurate in many senses (for example, we don't always use the
  ascii code and we see numbers as though they were printed in base
  127) but indicates the basic idea.

  ACL2 uses check sums to increase security in the [books] mechanism;
  see [certificate].")
 (CHECKPOINT-FORCED-GOALS
  (PROOF-TREE)
  "Cause forcing goals to be checkpointed in proof trees

    Example forms:
    (checkpoint-forced-goals t)
    (checkpoint-forced-goals nil)

  Also see [proof-tree].

  By default, goals are not marked as checkpoints by a proof tree
  display (as described elsewhere; see [proof-tree]) merely because
  they [force] some hypotheses, thus possibly contributing to a
  forcing round. However, some users may want such behavior, which
  will occur once the command (checkpoint-forced-goals t) has been
  executed. To return to the default behavior, use the command
  (checkpoint-forced-goals nil).")
 (CLAUSE-IDENTIFIER
  (GOAL-SPEC)
  "The internal form of a [goal-spec]

  To each goal-spec, str, there corresponds a clause-identifier
  produced by (parse-clause-id str). For example,

    (parse-clause-id \"[2]Subgoal *4.5.6/7.8.9'''\")

  returns ((2 4 5 6) (7 8 9) . 3).

  The function string-for-tilde-@-clause-id-phrase inverts
  parse-clause-id in the sense that given a clause identifier it
  returns the corresponding goal-spec.

  As noted in the documentation for [goal-spec], each clause printed in
  the theorem prover's proof attempt is identified by a name. When
  these names are represented as strings they are called ``goal
  specs.'' Such strings are used to specify where in the proof
  attempt a given hint is to be applied. The function parse-clause-id
  converts goal-specs into clause identifiers, which are cons-trees
  containing natural numbers.

  Examples of goal-specs and their corresponding clause identifiers are
  shown below.

                 parse-clause-id
                       -->

    \"Goal\"                       ((0) NIL . 0)
    \"Subgoal 3.2.1'\"             ((0) (3 2 1) . 1)
    \"[2]Subgoal *4.5.6/7.8.9'''\" ((2 4 5 6) (7 8 9) . 3)

                       <--
          string-for-tilde-@-clause-id-phrase

  The caar of a clause id specifies the forcing round, the cdar
  specifies the goal being proved by induction, the cadr specifies
  the particular subgoal, and the cddr is the number of primes in
  that subgoal.

  Internally, the system maintains clause ids, not goal-specs. The
  system prints clause ids in the form shown by goal-specs. When a
  goal-spec is used in a hint, it is parsed (before the proof attempt
  begins) into a clause id. During the proof attempt, the system
  watches for the clause id and uses the corresponding hint when the
  id arises. (Because of the expense of creating and garbage
  collecting a lot of strings, this design is more efficient than the
  alternative.)")
 (CLAUSE-PROCESSOR
  (RULE-CLASSES)
  "Make or apply a :clause-processor rule (goal-level simplifier)

  See [rule-classes] for a general discussion of rule classes,
  including how they are used to build rules from formulas and a
  discussion of the various keywords in a rule class description.

  We will introduce clause-processor rules by way of the following
  example. But note that the clause-processor utility is more general
  than this example may suggest; for example, the second argument of
  evl0 in the hypothesis need not be the same as its second argument
  in the conclusion.

    ; Example (which we'll return to, below):
    (defthm correctness-of-note-fact-clause-processor
      (implies (and (pseudo-term-listp cl)
                    (alistp a)
                    (evl0 (conjoin-clauses
                           (note-fact-clause-processor cl term))
                          a))
               (evl0 (disjoin cl) a))
      :rule-classes :clause-processor)

  Also see [define-trusted-clause-processor] for documentation of an
  analogous utility that does not require the clause-processor to be
  proved correct. But please read the present documentation before
  reading about that utility. Both utilities designate functions
  ``clause-processors''. Such functions must be executable --- hence
  not constrained by virtue of being introduced in the [signature] of
  an [encapsulate] --- and must respect [stobj] and output arity
  restrictions. For example, something like (car (mv ...)) is
  illegal; also see [signature].

  We begin this documentation with an introduction, focusing on the
  example above, and then conclude with a detailed general discussion
  of clause-processor rules. You might find it most useful simply to
  look at the examples in community books directory
  books/clause-processors/; see file Readme.lsp in that directory.

  INTRODUCTION

  A :clause-processor rule installs a simplifier at the level of goals,
  where a goal is represented as a clause: a list of [term]s that is
  implicitly viewed as a disjunction (the application of [or]). For
  example, if ACL2 prints a goal in the form (implies (and p q) r),
  then the clause might be the one-element list containing the
  internal representation of this term --- (implies (if p q 'nil) r)
  --- but more likely, the corresponding clause is ((not p) (not q)
  r). Note that the members of a clause are translated terms; see
  [term]. For example, they do not contain calls of the macro AND,
  and constants are quoted.

  Note that clause-processor simplifiers are similar to metafunctions,
  and similar efficiency considerations apply. See [meta], in
  particular the discussion on how to ``make a metafunction maximally
  efficient.''

  Unlike rules of class :[meta], rules of class :clause-processor must
  be applied by explicit :clause-processor [hints]; they are not
  applied automatically (unless by way of computed hints; see
  [computed-hints]). But :clause-processor rules can be useful in
  situations for which it is more convenient to code a simplifier
  that manipulates the entire goal clause rather than individual
  subterms of terms in the clause.

  We begin with a simple illustrative example: a clause-processor that
  assumes an alleged fact (named term in the example) and creates a
  separate goal to prove that fact. We can extend the hypotheses of
  the current goal (named cl in the example) with a term by adding
  the negation of that term to the clause (disjunctive)
  representation of that goal. So the following returns a list of two
  clauses: the result of adding term as a hypothesis to the input
  clause, as just described, and a second clause consisting only of
  that term. This list of two clauses can be viewed as the
  conjunction of the first clause and the second clause (where again,
  each clause is viewed as a disjunction).

    (defun note-fact-clause-processor (cl term)
      (declare (xargs :guard t)) ; optional, for better efficiency
      (list (cons (list 'not term)
                  cl)
            (list term)))

  As with :[meta] rules, we need to introduce a suitable evaluator; see
  [defevaluator] if you want details. Since we expect to reason about
  the function [not], because of its role in
  note-fact-clause-processor as defined above, we include NOT in the
  set of functions known to this evaluator. We also include IF, as is
  often a good idea.

    (defevaluator evl0 evl0-list
      ((not x) (if x y z)))

  ACL2 can now prove the following theorem automatically. (This is the
  example displayed at the outset of this [documentation] topic.) Of
  course, :clause-processor rules about clause-processor functions
  less trivial than note-fact-clause-processor may require lemmas to
  be proved first! The function disjoin takes a clause and returns
  its disjunction (the result of applying [or] to its members), and
  conjoin-clauses applies disjoin to every element of a given list of
  clauses and then conjoins (applies AND) to the corresponding list
  of resulting terms.

    (defthm correctness-of-note-fact-clause-processor
      (implies (and (pseudo-term-listp cl)
                    (alistp a)
                    (evl0 (conjoin-clauses
                           (note-fact-clause-processor cl term))
                          a))
               (evl0 (disjoin cl) a))
      :rule-classes :clause-processor)

  Now let us submit a silly but illustrative example theorem to ACL2,
  to show how a corresponding :clause-processor hint is applied. The
  hint says to apply the clause-processor function,
  note-fact-clause-processor, to the current goal clause and a ``user
  hint'' as the second argument of that function, in this case (equal
  a a). Thus, a specific variable, clause, is always bound to the
  current goal clause for the evaluation of the :clause-processor
  hint, to produce a list of clauses. Since two subgoals are created
  below, we know that this list contained two clauses. Indeed, these
  are the clauses returned when note-fact-clause-processor is applied
  to two arguments: the current clause, which is the one-element list
  ((equal (car (cons x y)) x)), and the user hint, (equal a a).

    ACL2 !>(thm (equal (car (cons x y))
                       x)
                :hints
                ((\"Goal\"
                  :clause-processor
                  (note-fact-clause-processor clause '(equal a a)))))

    [Note:  A hint was supplied for our processing of the goal above.
    Thanks!]

    We now apply the verified :CLAUSE-PROCESSOR function NOTE-FACT-CLAUSE-
    PROCESSOR to produce two new subgoals.

    Subgoal 2
    (IMPLIES (EQUAL A A)
             (EQUAL (CAR (CONS X Y)) X)).

    But we reduce the conjecture to T, by the :executable-counterpart of
    IF and the simple :rewrite rule CAR-CONS.

    Subgoal 1
    (EQUAL A A).

    But we reduce the conjecture to T, by primitive type reasoning.

    Q.E.D.

    Summary
    Form:  ( THM ...)
    Rules: ((:EXECUTABLE-COUNTERPART IF)
            (:EXECUTABLE-COUNTERPART NOT)
            (:FAKE-RUNE-FOR-TYPE-SET NIL)
            (:REWRITE CAR-CONS))
    Warnings:  None
    Time:  0.00 seconds (prove: 0.00, print: 0.00, other: 0.00)

    Proof succeeded.
    ACL2 !>

  That concludes our introduction to clause-processor rules and hints.
  We turn now to detailed documentation.

  DETAILED DOCUMENTATION

  The [signature] of a clause-processor function, CL-PROC, must have
  one of the following forms. Here, each st_i is a [stobj] (possibly
  state) while the other parameters and results are not stobjs (see
  [stobj]). Note that there need not be input stobjs in [3] --- i.e.,
  k can be 0 --- and even if there are, there need not be output
  stobjs.

    [1]  ((CL-PROC cl) => cl-list)

    [2]  ((CL-PROC cl hint) => cl-list)

    [3]  ((CL-PROC cl hint st_1 ... st_k) => (mv erp cl-list st_i1 ... st_in))

  In [3], we think of the first component of the result as an error
  flag. Indeed, a proof will instantly abort if that error flag is
  not nil.

  We next discuss the legal forms of :clause-processor rules, followed
  below by a discussion of :clause-processor [hints]. In the
  discussion below, we use lower-case names to represent specific
  symbols, for example implies, and we use upper-case names to
  represent more arbitrary pieces of syntax (which we will describe),
  for example, CL.

  If a :[rule-classes] specification includes :clause-processor, then
  the corresponding term must have the following form. (Additional
  ``meta-extract'' hypotheses, not shown or discussed below, may be
  included as desired in order to use facts from the logical [world]
  to help prove the rule; see [meta-extract] for explanation of this
  advanced feature.)

    ; General Form (omitting possible meta-extract hypotheses)
    (implies (and (pseudo-term-listp CL)
                  (alistp A)
                  (EVL (conjoin-clauses <CL-LIST>)
                        B))
             (EVL (disjoin CL) A))

  Here EVL is a known evaluator; CL and A are distinct non-stobj
  variables; and <CL-LIST> is an expression representing the clauses
  returned by the clause-processor function CL-PROC, whose form
  depends on the [signature] of that function, as follows. Typically
  B is A, but it can be any term (useful when generalization is
  occurring; see the example ``Test generalizing alist'' in community
  book books/clause-processors/basic-examples.lisp). For cases [1]
  and [2] above, <CL-LIST> is of the form (CL-PROC CL) or (CL-PROC CL
  HINT), respectively, where in the latter case HINT is a non-stobj
  variable distinct from the variables CL and A. For case [3],
  <CL-LIST> is of the form

    (clauses-result (CL-PROC CL HINT st_1 ... st_k))

  where the st_i are the specific stobj names mentioned in [3].
  Logically, clauses-result returns the [cadr] if the [car] is NIL,
  and otherwise (for the error case) returns a list containing the
  empty (false) clause. So in the non-error case, clauses-result
  picks out the second result, denoted cl-list in [3] above, and in
  the error case the implication above trivially holds.

  In the above theorem, we are asked to prove (EVL (disjoin CL) A)
  assuming that the conjunction of all clauses produced by the clause
  processor evaluates to a non-nil value under some alist B. In fact,
  we can choose B so as to allow us to assume evaluations of the
  generated clauses over many different alists. This technique is
  discussed in the community book
  books/clause-processors/multi-env-trick.lisp, which introduces some
  macros that may be helpful in accomplishing proofs of this type.

  The clause-processor function, CL, must have a guard that ACL2 can
  trivially prove from the hypotheses that the first argument of CL
  is known to be a pseudo-term-listp and any [stobj] arguments are
  assumed to satisfy their stobj predicates.

  Next we specify the legal forms for :clause-processor [hints]. These
  depend on the signature as described in [1] through [3] above.
  Below, as above, CL-PROC is the clause-processor function, and
  references to ``clause'' refer to that exact variable (not, for
  example, to cl). In each of the three cases, the forms shown for
  that case are equivalent; in particular, the :function syntax is
  simply a convenience for the final form in each case.

  Signature [1], ((cl-proc cl) => cl-list):

    :clause-processor CL-PROC
    :clause-processor (:function CL-PROC)
    :clause-processor (CL-PROC clause)

  or any term macroexpanding to (CL-PROC clause).

  Signature [2], ((cl-proc cl hint) => cl-list):

    :clause-processor (:function CL-PROC :hint HINT)
    :clause-processor (CL-PROC clause HINT)

  or any term macroexpanding to (CL-PROC clause HINT), where HINT is
  any term with at most CLAUSE free.

  Signature [3], ((CL-PROC cl hint ...) => (mv erp cl-list ...))

    :clause-processor (:function CL-PROC :hint HINT)
    :clause-processor (CL-PROC clause HINT st_1 ... st_k)

  or any term macroexpanding to (CL-PROC clause HINT st_1 ... st_k),
  where HINT is any term with at most CLAUSE free.

  A :clause-processor hint causes the proof to abort if the result
  returned by evaluating the suitable CL-PROC call, as above, is not
  a list of clauses, i.e., a list of (translated) [term] lists. The
  proof also aborts if in case [3] the first (erp) value returned is
  not nil, in which case erp is used for printing an error message as
  follows: if it is a string, then that string is printed; but if it
  is a non-empty true list whose first element is a string, then it
  is printed as though by (fmt ~@0 (list (cons #\\0 erp)) ...) (see
  [fmt]). Otherwise, a non-nil erp value causes a generic error
  message to be printed.

  If there is no error as above, but the CL-PROC call returns clause
  list whose single element is equal to the input clause, then the
  hint is ignored since we are left with the goal with which we
  started. In that case, the other prover processes are then applied
  as usual.

  You can see all current :clause-processor rules by issuing the
  following command: (print-clause-processor-rules).

  The following paper discusses ACL2 clause-processors at a high level
  suitable for a non-ACL2 audience:

      M. Kaufmann, J S. Moore, S. Ray, and E. Reeber, ``Integrating
      External Deduction Tools with ACL2.'' Journal of Applied Logic
      (Special Issue: Empirically Successful Computerized Reasoning),
      Volume 7, Issue 1, March 2009, pp. 3--25. Also published online
      (DOI 10.1016/j.jal.2007.07.002). Preliminary version in:
      Proceedings of the 6th International Workshop on the
      Implementation of Logics (IWIL 2006) (C. Benzmueller, B.
      Fischer, and G. Sutcliffe, editors), CEUR Workshop Proceedings
      Vol. 212, Phnom Penh, Cambodia, pp. 7-26, November 2006.")
 (CLEAR-HASH-TABLES
  (HONS-AND-MEMOIZATION)
  "Deprecated feature

  This [documentation] topic relates to the experimental extension of
  ACL2 supporting hash cons, fast alists, and memoization; see
  [hons-and-memoization].

  Deprecated. Calls [clear-memoize-tables] and then [hons-clear] or
  [hons-wash], whichever makes sense for the underlying Common Lisp.

  Function: <clear-hash-tables>

    (defun clear-hash-tables nil (declare (xargs :guard t)) nil)")
 (CLEAR-MEMOIZE-STATISTICS
  (HONS-AND-MEMOIZATION)
  "Clears all profiling info displayed by ([memoize-summary])')

  This [documentation] topic relates to the experimental extension of
  ACL2 supporting hash cons, fast alists, and memoization; see
  [hons-and-memoization].

  Logically, this function just returns nil. It clears all profiling
  info displayed by ([memoize-summary])')

  Function: <clear-memoize-statistics>

    (defun clear-memoize-statistics nil (declare (xargs :guard t)) nil)")
 (CLEAR-MEMOIZE-TABLE
  (HONS-AND-MEMOIZATION)
  "Forget values remembered for the given function

  This [documentation] topic relates to the experimental extension of
  ACL2 supporting hash cons, fast alists, and memoization; see
  [hons-and-memoization].

  This function returns its argument, fn, unchanged. The values
  memoized for fn are forgotten.

  Function: <clear-memoize-table>

    (defun clear-memoize-table (fn) (declare (xargs :guard t)) fn)")
 (CLEAR-MEMOIZE-TABLES
  (HONS-AND-MEMOIZATION)
  "Forget values remembered for all the memoized functions

  This [documentation] topic relates to the experimental extension of
  ACL2 supporting hash cons, fast alists, and memoization; see
  [hons-and-memoization].

  Clear-memoize-tables is a logical no-op. All memoized values are
  forgotten. It returns nil, invoking [clear-memoize-table] for each
  memoized function.

  Function: <clear-memoize-tables>

    (defun clear-memoize-tables nil (declare (xargs :guard t)) nil)")
 (CLOSE-INPUT-CHANNEL (POINTERS)
                      "See [io].")
 (CLOSE-OUTPUT-CHANNEL (POINTERS)
                       "See [io].")
 (CLOSE-TRACE-FILE
  (TRACE)
  "Stop redirecting trace output to a file

    General Form:
    (close-trace-file) ; trace output is no longer redirected to a file

  Output from [trace$] normally goes to the screen, or more precisely,
  [standard-co]. It can be redirected to a file; see
  [open-trace-file]. Use close-trace-file to redirect trace output to
  [standard-co].")
 (CODE-CHAR
  (ACL2-BUILT-INS)
  "The character corresponding to a given numeric code

  Completion Axiom (completion-of-code-char):

    (equal (code-char x)
           (if (and (integerp x)
                    (>= x 0)
                    (< x 256))
               (code-char x)
             (code-char 0)))

  [Guard] for (code-char x):

    (and (integerp x)
         (>= x 0)
         (< x 256))

  ACL2 supports 8-bit [characters]. Inputs not between 0 and 255 are
  treated as 0.")
 (COERCE
  (ACL2-BUILT-INS)
  "Coerce a character list to a string and a string to a list

  Completion Axiom (completion-of-coerce):

    (equal (coerce x y)
           (cond
            ((equal y 'list)
             (if (stringp x)
                 (coerce x 'list)
               nil))
            (t
             (coerce (make-character-list x) 'string))))

  [Guard] for (coerce x y):

    (if (equal y 'list)
        (stringp x)
      (if (equal y 'string)
          (character-listp x)
        nil))

  Also see community book books/misc/fast-coerce.lisp, contributed by
  Jared Davis, for a version of coerce that may be faster for Common
  Lisp implementations other than CCL 1.3 or later, if the second
  argument is 'list (for coercing a string to a list).")
 (COMMAND
  (MISCELLANEOUS)
  "Forms you type at the top-level, but...

  ...the word ``command'' usually refers to a top-level form whose
  evaluation produces a new logical [world].

    Typical commands are:
    (defun foo (x) (cons x x))
    (defthm consp-foo (consp (foo x)))
    (defrec pair (hd . tl) nil)

  The first two forms are examples of commands that are in fact
  primitive [events]. See [events]. Defrec, on the other hand, is a
  macro that expands into a [progn] of several primitive [events]. In
  general, a [world] extending command generates one or more
  [events].

  Both [events] and commands leave landmarks on the [world] that enable
  us to determine how the given [world] was created from the previous
  one. Most of your interactions will occur at the command level,
  i.e., you type commands, you print previous commands, and you undo
  back through commands. Commands are denoted by command descriptors.
  See [command-descriptor].")
 (COMMAND-DESCRIPTOR
  (MISCELLANEOUS)
  "An object describing a particular [command] typed by the user

    Examples:

    :max      ; the command most recently typed by the user
    :x        ; synonymous with :max
    (:x -1)   ; the command before the most recent one
    (:x -2)   ; the command before that
    :x-2      ; synonymous with (:x -2)
    5         ; the fifth command typed by the user
    1         ; the first command typed by the user
    0         ; the last command of the system initialization
    -1        ; the next-to-last initialization command
    :min      ; the first command of the initialization
    :start    ; the last command of the initial ACL2 logical world
    fn        ; the command that introduced the logical name fn
    (:search (defmacro foo-bar))
              ; the first command encountered in a search from :max to
              ; 0 that either contains defmacro and foo-bar in the
              ; command form or contains defmacro and foo-bar in some
              ; event within its block.

  The recorded [history] of your interactions with the top-level ACL2
  [command] loop is marked by the [command]s you typed that changed
  the logical [world]. Each such [command] generated one or more
  [events], since the only way for you to change the logical [world]
  is to execute an event function. See [command] and see [events]. We
  divide [history] into ``[command] blocks,'' grouping together each
  [world] changing [command] and its [events]. A ``[command]
  descriptor'' is an object that can be used to describe a particular
  [command] in the [history] of the ongoing session.

  Each [command] is assigned a unique integer called its ``[command]
  number'' which indicates the [command]'s position in the
  chronological ordering of all of the [command]s ever executed in
  this session (including those executed to initialize the system).
  We assign the number 1 to the first [command] you type to ACL2. We
  assign 2 to the second and so on. The non-positive integers are
  assigned to ``prehistoric'' [command]s, i.e., the [command]s used
  to initialize the ACL2 system: 0 is the last [command] of the
  initialization, -1 is the one before that, etc.

  The legal [command] descriptors are described below. We use n to
  denote any integer, sym to denote any logical name (see
  [logical-name]), and cd to denote, recursively, any [command]
  descriptor.

     command                   command
    descriptor                described

    :max   -- the most recently executed command (i.e., the one with
              the largest command number)
    :x     -- synonymous with :max
    :x-k   -- synonymous with (:x -k), if k is an integer and k>0
    :min   -- the earliest command (i.e., the one with the smallest
              command number and hence the first command of the system
              initialization)
    :start -- the last command when ACL2 starts up
    n      -- command number n  (If n is not in the
              range :min<=n<=:max, n is replaced by the nearest of :min
              and :max.)
    sym    -- the command that introduced the logical name sym
    (cd n) -- the command whose number is n plus the command number of
              the command described by cd
    (:search pat cd1 cd2)
              In this command descriptor, pat must be either an atom or
              a true list of atoms and cd1 and cd2 must be command
              descriptors.  We search the interval from cd1 through cd2
              for the first command that matches pat.  Note that if cd1
              occurs chronologically after cd2, the search is
              ``backwards'' through history while if cd1 occurs
              chronologically before cd2, the search is ``forwards''.  A
              backwards search will find the most recent match; a
              forward search will find the chronologically earliest
              match.  A command matches pat if either the command form
              itself or one of the events in the block contains pat (or
              all of the atoms in pat if pat is a list).
    (:search pat)
              the command found by (:search pat :max 0), i.e., the most
              recent command matching pat that was part of the user's
              session, not part of the system initialization.")
 (COMMAND-LINE
  (INTERFACING-TOOLS)
  "Handling of command-line arguments when ACL2 is invoked

  You may provide command-line arguments when invoking ACL2, which are
  passed to the host Lisp. For more information on this topic, along
  with a discussion of how to save an ACL2 executable that avoids
  passing command-line arguments to the host Lisp, see [save-exec].


Subtopics

  [Save-exec]
      Save an executable image and a wrapper script")
 (COMMON-LISP
  (ABOUT-ACL2)
  "Relation to Common Lisp, including deviations from the spec

  ACL2 is a logic, a theorem prover, and a programming language based
  on Common Lisp. A connection with Common Lisp is established with
  guards (see [guard]).

  However, here we document potential deviations from Common Lisp
  semantics even in the presence of verified guards. Our view is that
  these deviations are extremely unlikely to manifest; indeed, as of
  this writing we are unaware of any cases in which these issues
  arise in practice. However, we feel obligated to acknowledge their
  possibility, which could result in surprises during evaluation or
  even proof.

  The Common Lisp spec allows certain predicates to return what it
  calls ``generalized Booleans,'' which are really arbitrary values
  that are to be viewed as either nil or non-nil. However, in ACL2
  these functions are assumed to return nil or t. For details,see
  [generalized-booleans].

  The execution of forms with :[program] mode functions can result in
  calls of functions on arguments that do not satisfy their [guard]s.
  In practice, this simply causes hard Lisp errors. But in principle
  one could imagine a damaged Lisp image that operates incorrectly.
  See [defun-mode-caveat].

  The Common Lisp spec, specifically Section 3.2.2.3 of the Common Lisp
  HyperSpec, allows for undefined results when a function is
  ``multiply defined'' in a compiled file. ACL2 allows redundant
  [defun]s in a book, and in general [books] are compiled by
  certify-book (but see [certify-book] and see [compilation] for how
  to control such compilation). Moreover, ACL2 provides a
  redefinition capability (see [ld-redefinition-action] and see
  [redef]), and the above section also allows for undefined results
  when a function is defined in a compiled file and then redefined,
  presumably (for example) because of inlining.


Subtopics

  [Defun-mode-caveat]
      Potential soundness issue for functions with [defun-mode] :[program]

  [Generalized-booleans]
      Potential soundness issues related to ACL2 predicates")
 (COMMON_LISP
  (PAGES_WRITTEN_ESPECIALLY_FOR_THE_TOURS)
  "Common Lisp

  [{IMAGE}]

  {IMAGE}

  The logic of ACL2 is based on Common Lisp.

  Common Lisp is the standard list processing programming language. It
  is documented in: Guy L. Steele, Common Lisp The Language, Digital
  Press, 12 Crosby Drive, Bedford, MA 01730, 1990. See also
  http://www.cs.cmu.edu/Web/Groups/AI/html/cltl/cltl2.html.

  ACL2 formalizes only a subset of Common Lisp. It includes such
  familiar Lisp functions as cons, car and cdr for creating and
  manipulating list structures, various arithmetic primitives such as
  +, *, expt and <=, and intern and symbol-name for creating and
  manipulating symbols. Control primitives include cond, case and if,
  as well as function call, including recursion. New functions are
  defined with defun and macros with defmacro. See [programming]
  [{ICON}] for a list of the Common Lisp primitives supported by
  ACL2.

  ACL2 supports five of Common Lisp's datatypes:

  * the precisely represented, unbounded numbers (integers, rationals,
  and the complex numbers with rational components, called the
  ``complex rationals'' here),

  * the characters with ASCII codes between 0 and 255

  * strings of such characters

  * symbols (including packages)

  * conses

  ACL2 is a very small subset of full Common Lisp. ACL2 does not
  include the Common Lisp Object System (CLOS), higher order
  functions, circular structures, and other aspects of Common Lisp
  that are non-applicative. Roughly speaking, a language is
  applicative if it follows the rules of function application. For
  example, f(x) must be equal to f(x), which means, among other
  things, that the value of f must not be affected by ``global
  variables'' and the object x must not change over time.

  [{IMAGE}]")
 (COMMON_LISP_AS_A_MODELING_LANGUAGE
  (PAGES_WRITTEN_ESPECIALLY_FOR_THE_TOURS)
  "Common Lisp as a Modeling Language

  {IMAGE}

  In ACL2 we have adopted Common Lisp as the basis of our modeling
  language. If you have already read our brief note on Common Lisp
  and recall the example of app, please proceed. Otherwise click
  [here] for an exceedingly brief introduction to Common Lisp and
  then come back here.

  In Common Lisp it is very easy to write systems of formulas that
  manipulate discrete, inductively constructed data objects. In
  building a model you might need to formalize the notion of
  sequences and define such operations as concatenation, length,
  whether one is a permutation of the other, etc. It is easy to do
  this in Common Lisp. Furthermore, if you have a Common Lisp
  ``theory of sequences'' you can run the operations and relations
  you define. That is, you can execute the functions on concrete data
  to see what results your formulas produce.

  If you define the function app as shown above and then type

    (app '(A B) '(C D E))

  in any Common Lisp, the answer will be computed and will be (A B C D
  E).

  The executable nature of Common Lisp and thus of ACL2 is very handy
  when producing models.

  But executability is not enough for a modeling language because the
  purpose of models is to permit analysis.

  Click [here] to continue.")
 (COMMUNITY-BOOKS
  (BOOKS)
  "Libraries of ACL2 [books] developed by the ACL2 community.

  ACL2 [books] are files of ACL2 [events] like definitions and
  theorems.

  The ACL2 Community Books are the canonical set of open-source books
  for ACL2, developed since the early 1990s by members of the ACL2
  community. They include libraries for reasoning in many domains,
  macro libraries for more quickly writing and documenting code,
  interfacing tools for connecting ACL2 to other systems,
  productivity tools for better proof automation and debugging, and
  specialty libraries for areas like hardware verification.

  From the ACL2 Books web site you can:

    * Download the Community Books;
    * Learn how to contribute books to the ACL2 community; and
    * Obtain updates between ACL2 releases.

  Once you have downloaded the Community Books, you should typically:

    * Extract them into the books/ subdirectory of your ACL2 installation,
      and
    * Certify them by following the instructions in [books-certification].")
 (COMP
  (EVENTS PROGRAMMING)
  "Compile some ACL2 functions

  NOTE: Comp is a no-op if explicit compilation is suppressed; see
  [compilation]. The documentation here assumes that this is not the
  case.

    Examples:
    :comp t          ; compile all uncompiled ACL2 functions
    (comp t)         ; same as above, but can be put into a book
    (comp :exec)     ; compile all uncompiled logic (``*1*'') definitions
    :comp foo        ; compile the defined function foo
    :comp (:raw foo) ; compile the raw Lisp version of the defined function foo
                       but not the corresponding logic definition
    :comp (foo bar)  ; compile the defined functions foo and bar
    :comp (foo (:raw bar))  ; compile the defined functions foo and bar, but for
                            ; bar do not compile the corresponding logic definition

    General Form:
    :comp specifier
    where specifier is one of the following:

      t                     compile all user-defined ACL2 functions that are
                              currently uncompiled (redefined built-in functions
                              are not recompiled)
      :exec                 same as t, except that only logic versions are
                              compiled (see below), not raw Lisp definitions
      :raw                  same as t, except that only raw Lisp definitions are
                              compiled, not logic version (see below)
      (name-1 ... name-k)   a non-empty list of names of functions defined by
                              DEFUN in ACL2, except that each name-i can be of
                              the form (:raw sym) or (:exec sym), where sym is
                            the name of such a function
      name                  same as (name)

  When you define a function in ACL2, you are really causing two
  definitions to be made ``under the hood'' in Common Lisp: the
  definition is submitted explicitly to raw Lisp, but so is a
  corresponding ``logic definition''. If guards have not been
  verified, then only the logic definition will be evaluated; see
  [guards-and-evaluation], in particular the section titled ``Guards
  and evaluation V: efficiency issues''.

  Thus, if you are not verifying [guard]s and you want the benefit of
  Lisp compilation for speed and space efficiency, then you may want
  to place the form (comp :exec) in your [books].

  Generally it is not necessary to place the form (comp t), or the form
  (comp :raw), in a book, because [certify-book] compiles the raw
  Lisp definitions anyhow, by default. But you may wish to put (comp
  t) or (comp fn1 fn2 ... fnk) in a book when such a form precedes
  expensive calls of functions, for example for proofs involving
  calls of functions on large constants, or to support
  computationally expensive macroexpansion.

  As suggested by the examples above, if a function specifier is of the
  form (:raw fn), then fn will be compiled in raw Common Lisp but its
  corresponding logic definition will not be compiled; and for (:exec
  fn), it's the other way around.

  The use of :comp may create various files whose names start with
  ``TMP*'', but it then deletes them. If you want to save these
  files, evaluate (assign keep-tmp-files t).

  Also see [set-compile-fns] for a way to compile each function as it
  is defined. But note that set-compile-fns is ignored during
  [include-book].

  Note that if functions are traced (see [trace$]), then comp will
  first untrace the functions that are to be compiled, then will do
  the compile(s), and finally will re-trace the functions that it
  untraced (using their original trace specs). In particular, if you
  have traced a function and then you compile it using :comp, the
  resulting traced function will be compiled as well unless you
  specified :compile nil in your trace spec; and after you untrace
  the function it will definitely run compiled.

  We conclude with a technical remark only for those who use trust tags
  to write raw Lisp code. :Comp generally creates files to compile
  unless it is given a single function to compile. Those files
  contain the ACL2 definitions of all functions to compile, omitting
  those in the lists obtained by evaluating the forms (@
  logic-fns-with-raw-code) and (@ program-fns-with-raw-code). :Comp
  skips compilation for functions that are already compiled, as is
  typically the case when you redefine functions in raw Lisp using
  [include-raw]. But if you define interpreted (as opposed to
  compiled) functions with raw Lisp code, say by using trust tags
  (see [defttag]) and [progn!], then you are advised to add all such
  symbols to one of the lists stored in the two [state] globals
  above: to logic-fns-with-raw-code if the function symbol is in
  :[logic] mode, else to program-fns-with-raw-code. Then, instead of
  the corresponding ACL2 definition (without raw Lisp code) being
  written to a file, the function symbol will be passed directly to
  the Lisp compile function. Note that the above two state globals
  are both untouchable, so you may need to deal with that before
  modifying them, for example as follows (also see
  [remove-untouchable]).

    (defttag t)
    (state-global-let*
     ((temp-touchable-vars t set-temp-touchable-vars))
     (progn! (f-put-global 'logic-fns-with-raw-code
                           (cons 'my-fn (@ logic-fns-with-raw-code))
                           state)))


Subtopics

  [Comp-gcl]
      Compile some ACL2 functions leaving .c and .h files")
 (COMP-GCL
  (COMP PROGRAMMING)
  "Compile some ACL2 functions leaving .c and .h files

  Comp-gcl is for use by experts who want to examine the results of GCL
  compilation, and it may only be used with ACL2 implementations
  built on top of GCL. It takes exactly the same arguments as [comp],
  and has the same basic functionality (see [comp]), but has two
  additional effects. First, files \"TMP.lisp\" and \"TMP1.lisp\" are
  always created, even when a single function is specified. Second,
  comp-gcl always leaves files \"TMP.c\", \"TMP.h\", \"TMP1.c\", and
  \"TMP1.h\" when compilation is complete.")
 (COMPILATION
  (PROGRAMMING)
  "Compiling ACL2 functions

  ACL2 has several mechanisms to speed up the evaluation of function
  calls by compiling functions: see [comp], see [set-compile-fns],
  and see [certify-book]. The intention is that compilation never
  changes the value returned by a function call, though it could
  cause the call to succeed rather than fail, for example by avoiding
  a stack overflow.

  The [state] global variable 'compiler-enabled is set automatically
  when the system is built, and may depend on the underlying Lisp
  implementation. (In order to disable the compiler at build time,
  which will defeat the speed-up but usually be pretty harmless when
  the host Lisp is CCL or SBCL, see the discussion of
  ACL2_COMPILER_DISABLED in distributed file GNUmakefile.) The value
  of 'compiler-enabled, as returned by (@ compiler-enabled), can be
  t, :books, or nil. If the value is nil, then [include-book] and
  [certify-book] coerce their arguments :load-compile-file and
  compile-flg arguments (respectively) to nil. Otherwise, the value
  is :books or t and there is no such coercion; but if the value is
  not t, then [comp] and [set-compile-fns] are no-ops, which is
  probably desirable for Lisps such as CCL and SBCL that compile
  on-the-fly even when the compiler is not explicitly invoked.

  However, you may have reason to want to change the above (default)
  behavior. To enable compilation by default for [certify-book] and
  [include-book] but not for [comp] or [set-compile-fns]:

    (set-compiler-enabled :books state)

  To enable compilation not only as above but also for [comp] and
  [set-compile-fns]:

    (set-compiler-enabled t state)

  To suppress compilation and loading of compiled files by
  [include-book] (for example, if you get a raw Lisp error such as
  ``Wrong FASL version''):

    (set-compiler-enabled nil state)

  See [book-compiled-file] for more discussion about compilation and
  [books].")
 (COMPILING-ACL2P
  (PARALLELISM)
  "Compiling ACL2(p)

  This [documentation] topic relates to the experimental extension of
  ACL2 supporting parallel execution and proof; see [parallelism].
  See [parallelism-tutorial] for an introduction to parallel
  programming in ACL2.

  You can build an experimental version of ACL2 that supports parallel
  execution in the following host Common Lisp implementations:

      * CCL (OpenMCL)

      * Lispworks 6.0

      * SBCL with threads (feature :sb-thread)

  The command below will compile ACL2 to support parallel execution,
  including parallel execution during proofs. Any non-empty string
  may be used in place of t, and the value of LISP (shown here as
  ccl) is any Lisp executable on which one can build ACL2(p) (see
  [parallelism]).

    make ACL2_PAR=t LISP=ccl

  So for example, to make an executable image and also documentation
  (which will appear in subdirectories doc/EMACS and doc/HTML), using
  the Lisp executable ccl:

    make large DOC ACL2_PAR=t LISP=ccl")
 (COMPLEX
  (ACL2-BUILT-INS)
  "Create an ACL2 number

    Examples:
    (complex x 3) ; x + 3i, where i is the principal square root of -1
    (complex x y) ; x + yi
    (complex x 0) ; same as x, for rational numbers x

  The function complex takes two rational number arguments and returns
  an ACL2 number. This number will be of type (complex rational) [as
  defined in the Common Lisp language], except that if the second
  argument is zero, then complex returns its first argument. The
  function [complex-rationalp] is a recognizer for complex rational
  numbers, i.e. for ACL2 numbers that are not rational numbers.

  The reader macro #C (which is the same as #c) provides a convenient
  way for typing in complex numbers. For explicit rational numbers x
  and y, #C(x y) is read to the same value as (complex x y).

  The functions [realpart] and [imagpart] return the real and imaginary
  parts (respectively) of a complex (possibly rational) number. So
  for example, (realpart #C(3 4)) = 3, (imagpart #C(3 4)) = 4,
  (realpart 3/4) = 3/4, and (imagpart 3/4) = 0.

  The following built-in axiom may be useful for reasoning about
  complex numbers.

    (defaxiom complex-definition
      (implies (and (real/rationalp x)
                    (real/rationalp y))
               (equal (complex x y)
                      (+ x (* #c(0 1) y))))
      :rule-classes nil)

  A completion axiom that shows what complex returns on arguments
  violating its [guard] (which says that both arguments are rational
  numbers) is the following, named completion-of-complex.

    (equal (complex x y)
           (complex (if (rationalp x) x 0)
                    (if (rationalp y) y 0)))")
 (COMPLEX-RATIONALP
  (ACL2-BUILT-INS)
  "Recognizes complex rational numbers

    Examples:
    (complex-rationalp 3)       ; nil, as 3 is rational, not complex rational
    (complex-rationalp #c(3 0)) ; nil, since #c(3 0) is the same as 3
    (complex-rationalp t)       ; nil
    (complex-rationalp #c(3 1)) ; t, as #c(3 1) is the complex number 3 + i

  See [complex] for more about complex rationals in ACL2.")
 (COMPLEX/COMPLEX-RATIONALP
  (ACL2-BUILT-INS)
  "Recognizer for complex numbers

  For most ACL2 users, this is a macro abbreviating complex-rationalp;
  see [complex-rationalp]. In ACL2(r) (see [real]), a complex number
  x may have irrational real and imaginary parts. This macro
  abbreviates the predicate complexp in ACL2(r), which holds for such
  x. Most ACL2 users can ignore this macro and use
  [complex-rationalp] instead. Some community books use
  complex/complex-rationalp so that they are suitable for ACL2(r) as
  well.")
 (COMPOUND-RECOGNIZER
  (RULE-CLASSES)
  "Make a rule used by the typing mechanism

  See [rule-classes] for a general discussion of rule classes,
  including how they are used to build rules from formulas and a
  discussion of the various keywords in a rule class description.

    Examples:
    (defthm alistp-implies-true-listp-compound-recognizer
      (implies (alistp x)                 ; When (alistp x) is assumed true, add
               (true-listp x))            ; the additional hypothesis that x is
      :rule-classes :compound-recognizer) ; of primitive type true-listp.

    (defthm natp-compound-recognizer      ; See discussion below.
      (equal (natp x)
             (and (integerp x)
                  (<= 0 x)))
      :rule-classes :compound-recognizer)

  Before presenting the General Forms, we start with a motivating
  example: the second [defthm] form above, which provides a nice
  example of a :compound-recognizer rule that is built into ACL2. To
  see how this rule might be useful, consider the following
  (admittedly very simple) [events].

    (defun triple (x)
      (* 3 x))

    (defthm triple-preserves-integerp
      (implies (integerp x)
               (integerp (triple x))))

    (in-theory (disable triple natp))

  If the above :compound-recognizer rule is disabled, then the
  following trivial theorem fails as shown; we explain below.

    (thm (implies (natp x)
                  (integerp (triple x)))
      :hints ((\"Goal\" :in-theory (disable natp-compound-recognizer))))

  The problem is that when ACL2 tries to rewrite the term (integerp
  (triple x)) using the :[rewrite] rule triple-preserves-integerp, it
  needs to rewrite the hypothesis (integerp x) to t, but instead what
  is known is (natp x). If we remove the hint, then the proof
  succeeds because the above :compound-recognizer rule tells ACL2
  that when assuming (natp x) to be true, it should actually assume
  both (integerp x) and (<= 0 x) to be true.

    General Forms:
    (implies (fn x) concl)               ; (1)
    (implies (not (fn x)) concl)         ; (2)
    (and (implies (fn x) concl1)         ; (3)
         (implies (not (fn x)) concl2))
    (if (fn x) concl1 concl2)            ; (4)
    (iff (fn x) concl)                   ; (5)
    (equal (fn x) concl)                 ; (6)

  where fn is a Boolean valued function of one argument, x is a
  variable symbol, and the system can deduce some restriction on the
  primitive type of x from the assumption that concl holds. The last
  restriction is vague but one way to understand it is to weaken it a
  little to ``and concl is a non-tautological conjunction or
  disjunction of the primitive type recognizers listed below.''

  The primitive ACL2 types and a suitable primitive recognizing
  expression for each are listed below.

    type                suitable primitive recognizer

    zero                (equal x 0)
    negative integers   (and (integerp x) (< x 0))
    positive integers   (and (integerp x) (> x 0))
    negative ratio      (and (rationalp x)
                             (not (integerp x))
                             (< x 0))
    positive ratio      (and (rationalp x)
                             (not (integerp x))
                             (> x 0))
    complex rational    (complex-rationalp x)
    nil                 (equal x nil)
    t                   (equal x t)
    other symbols       (and (symbolp x)
                             (not (equal x nil))
                             (not (equal x t)))
    proper conses       (and (consp x)
                             (true-listp x))
    improper conses     (and (consp x)
                             (not (true-listp x)))
    strings             (stringp x)
    characters          (characterp x)

  Thus, a suitable concl to recognize the naturals would be (or (equal
  x 0) (and (integerp x) (> x 0))) but it turns out that we also
  permit (and (integerp x) (>= x 0)). Similarly, the true-lists could
  be specified by

    (or (equal x nil) (and (consp x) (true-listp x)))

  but we in fact allow (true-listp x). When time permits we will
  document more fully what is allowed or implement a macro that
  permits direct specification of the desired type in terms of the
  primitives.

  There are essentially four forms of :compound-recognizer rules, as
  the forms labeled (3) and (4) above are equivalent, as are those
  labeled (5) and (6). We explain how such rules are used by
  considering the individual forms.

  Consider form (1), (implies (fn x) concl). The effect of such a rule
  is that when the rewriter assumes (fn x) true, as it would while
  diving through (if (fn x) xxx ...) to rewrite xxx, it restricts the
  type of x as specified by concl. For example, if concl is the term
  (integerp x), then when rewriting xxx, x will be assumed to be an
  integer. However, when assuming (fn x) false, as necessary in (if
  (fn x) ... xxx), the rule permits no additional assumptions about
  the type of x. For example, if fn is primep, i.e., the predicate
  that recognizes prime numbers, then (implies (primep x) (and
  (integerp x) (>= x 0))) is a compound recognizer rule of the first
  form. When (primep x) is assumed true, the rewriter gains the
  additional information that x is a natural number. When (primep x)
  is assumed false, no additional information is gained --- since x
  may be a non-prime natural or may not even be a natural.

  Form (2) is the symmetric case, when assuming (fn x) false permits
  type restrictions on x but assuming (fn x) true permits no such
  restrictions. For example, if we defined exprp to be the recognizer
  for well-formed expressions for some language in which all symbols,
  numbers, character objects and strings were well-formed --- e.g.,
  the well-formedness rules only put restrictions on expressions
  represented by [consp]s --- then the theorem (implies (not (exprp
  x)) (consp x)) is a rule of the second form. Assuming (exprp x)
  true tells us nothing about the type of x; assuming it false tells
  us x is a [consp].

  Forms (3) and (4), which are really equivalent, address themselves to
  the case where one type may be deduced from (fn x) and a generally
  unrelated type may be deduced from its negation. If we modified the
  expression recognizer above so that character objects are illegal,
  then rules of the forms (3) and (4) are

    (and (implies (exprp x) (not (characterp x)))
         (implies (not (exprp x)) (or (consp x) (characterp x)))).
    (if (exprp x)
        (not (characterp x))
      (or (consp x) (characterp x)))

  Finally, rules of forms (5) and (6) address the case where fn
  recognizes all and only the objects whose type is described. In
  these cases, fn is really just a new name for some ``compound
  recognizers.'' The classic example is (booleanp x), which is just a
  handy combination of two primitive types:

    (iff (booleanp x) (or (equal x t) (equal x nil))).

  Often it is best to disable fn after proving that it is a compound
  recognizer, since otherwise the term (fn x) will be expanded and
  thus disappear.

  Every time you prove a new compound recognizer rule about fn it
  overrides all previously proved compound recognizer rules about fn.
  Thus, if you want to establish the type implied by (fn x) and you
  want to establish the type implied by (not (fn x)), you must prove
  a compound recognizer rule of the third, fourth, fifth, or sixth
  forms. Proving a rule of the first form followed by one of the
  second only leaves the second fact in the database.

  Compound recognizer rules can be disabled with the effect that older
  rules about fn, if any, are exposed.

  If you prove more than one compound recognizer rule for a function,
  you may see a warning message to the effect that the new rule is
  not as ``restrictive'' as the old. That is, the new rules do not
  give the rewriter strictly more type information than it already
  had. The new rule is stored anyway, overriding the old, if enabled.
  You may be playing subtle games with enabling or rewriting. But two
  other interpretations are more likely, we think. One is that you
  have forgotten about an earlier rule and should merely print it out
  to make sure it says what you intend, and then discard your new
  rule. The other is that you meant to give the system more
  information and the system has simply been unable to extract the
  intended type information from the term you placed in the
  conclusion of the new rule. Given our lack of specificity in saying
  how type information is extracted from rules, you can hardly blame
  yourself for this problem. Sorry. If you suspect you've been burned
  this way, you should rephrase the new rule in terms of the
  primitive recognizing expressions above and see if the warning is
  still given. It would also be helpful to let us see your example so
  we can consider it as we redesign this stuff.

  Compound recognizer rules are similar to :[forward-chaining] rules in
  that the system deduces new information from the act of assuming
  something true or false. If a compound recognizer rule were stored
  as a forward chaining rule it would have essentially the same
  effect as described, when it has any effect at all. The important
  point is that :[forward-chaining] rules, because of their more
  general and expensive form, are used ``at the top level'' of the
  simplification process: we forward chain from assumptions in the
  goal being proved. But compound recognizer rules are built in at
  the bottom-most level of the simplifier, where type reasoning is
  done.

  All that said, compound recognizer rules are a rather fancy,
  specialized mechanism. It may be more appropriate to create
  :[forward-chaining] rules instead of :compound-recognizer rules.")
 (COMPRESS1
  (ARRAYS ACL2-BUILT-INS)
  "Remove irrelevant pairs from a 1-dimensional array

    Example Form:
    (compress1 'delta1 a)

    General Form:
    (compress1 name alist)

  where name is a symbol and alist is a 1-dimensional array, generally
  named name. See [arrays] for details. Logically speaking, this
  function removes irrelevant pairs from alist, possibly shortening
  it. The function returns a new array, alist', with the same
  [header] (including name and dimension) as alist, that, under
  [aref1], is everywhere equal to alist. That is, (aref1 name alist'
  i) is (aref1 name alist i), for all legal indices i. Alist' may be
  shorter than alist and the non-irrelevant pairs may occur in a
  different order than in alist.

  Practically speaking, this function plays an important role in the
  efficient implementation of [aref1]. In addition to creating the
  new array, alist', compress1 makes that array the ``semantic
  value'' of name and allocates a raw lisp array to name. For each
  legal index, i, that raw lisp array contains (aref1 name alist' i)
  in slot i. Thus, subsequent [aref1] operations can be executed in
  virtually constant time provided they are given name and the alist'
  returned by the most recently executed compress1 or [aset1] on
  name. See [arrays].

  In general, compress1 returns an alist whose [cdr] is an association
  list whose keys are nonnegative integers in ascending order.
  However, if the [header] specifies an :order of > then the keys
  will occur in descending order, and if the :order is :none or nil
  then the keys will not be sorted, i.e., compress1 is logically the
  identity function (though it still attaches an array under the
  hood). Note however that a [compress1] call is replaced by a hard
  error if the header specifies an :order of :none or nil and the
  array's length exceeds the [maximum-length] field of its [header].

  Function: <compress1>

    (defun
     compress1 (name l)
     (declare (xargs :guard (array1p name l)))
     (case
      (array-order (header name l))
      (< (cons (header name l)
               (compress11 name l 0 (car (dimensions name l))
                           (default name l))))
      (> (cons (header name l)
               (reverse (compress11 name l 0 (car (dimensions name l))
                                    (default name l)))))
      (t
       (prog2$
        (and
         (> (length l) (maximum-length name l))
         (hard-error
          'compress1
          \"Attempted to compress a one-dimensional array named ~
                            ~x0 whose header specifies :ORDER ~x1 and whose ~
                            length, ~x2, exceeds its maximum-length, ~x3.\"
          (list (cons #\\0 name)
                (cons #\\1 nil)
                (cons #\\2 (length l))
                (cons #\\3 (maximum-length name l)))))
        l))))")
 (COMPRESS2
  (ARRAYS ACL2-BUILT-INS)
  "Remove irrelevant pairs from a 2-dimensional array

    Example Form:
    (compress2 'delta1 a)

    General Form:
    (compress2 name alist)

  where name is a symbol and alist is a 2-dimensional array, generally
  named name. See [arrays] for details. Logically speaking, this
  function removes irrelevant pairs from alist, possibly shortening
  it. The function returns a new array, alist', with the same
  [header] (including name and dimension) as alist, that, under
  [aref2], is everywhere equal to alist. That is, (aref2 name alist'
  i j) is (aref2 name alist i j), for all legal indices i and j.
  Alist' may be shorter than alist and the non-irrelevant pairs may
  occur in a different order in alist' than in alist.

  Practically speaking, this function plays an important role in the
  efficient implementation of [aref2]. In addition to creating the
  new array, alist', compress2 makes that array the ``semantic
  value'' of name and allocates a raw lisp array to name. For all
  legal indices, i and j, that raw lisp array contains (aref2 name
  alist' i j) in slot i,j. Thus, subsequent [aref2] operations can be
  executed in virtually constant time provided they are given name
  and the alist' returned by the most recently executed compress2 or
  [aset2] on name. See [arrays].

  Function: <compress2>

    (defun compress2 (name l)
           (declare (xargs :guard (array2p name l)))
           (cons (header name l)
                 (compress21 name l 0 (car (dimensions name l))
                             (cadr (dimensions name l))
                             (default name l))))")
 (COMPUTED-HINTS
  (MISCELLANEOUS)
  "Computing advice to the theorem proving process

    General Form of :hints:
    (hint1 hint2 ... hintk)

  Each element, hinti, must be either a common hint or a computed hint.

  A common hint is of the form

    (goal-spec :key1 val1 ... :keyn valn)

  where goal-spec is as specified in [goal-spec] and each :keyi and
  vali is as specified in [hints]. Among the ``common hints'' we
  include both the primitive hints and user-defined custom keyword
  hints (see [custom-keyword-hints]).

  A computed hint may be a function symbol, fn, of three, four or seven
  arguments. Otherwise, a computed hint is a term with the following
  properties:

  (a) the only free variables allowed in the term are ID, CLAUSE,
  WORLD, STABLE-UNDER-SIMPLIFICATIONP, HIST, PSPV, CTX, and [state];

  (b) the output signature of the term is either (MV * * STATE), which
  is to be treated as an error triple (see below), or is *, denoting
  a single non-[stobj] value; and

  (c) in the former case of (b) above, the term is single-threaded in
  [state].

  If a computed hint is a function symbol fn, whose arity n is
  therefore three, four, or seven, then it is treated as the term
  resulting from applying that fn to the first n variables shown in
  (a) above. Notice that it must then return a single non-[stobj]
  value, not an error triple, since state is not one of the first
  seven variables shown in (a).

  Note: Error triples are an ACL2 idiom for implementing ``errors'';
  see [error-triples]. If a computation returns (mv erp val state) in
  a context in which ACL2 is respecting the error triple convention
  (see [ld-error-triples] and see [ld-error-action]), then an error
  is deemed to have occurred if erp is non-nil. The computation is
  expected to have printed an appropriate error message to [state]
  and further computation is aborted. On the other hand, if a
  computation returns an error triple in which erp is nil, then
  ``value'' of the computation is taken to be the second component,
  val, of the triple (along with the possibly modified [state]), and
  computation continues. For more information about programming with
  error triples, see [programming-with-state].

  The function symbol cases are treated as abbreviations of the term
  (fn ID CLAUSE WORLD), (fn ID CLAUSE WORLD
  STABLE-UNDER-SIMPLIFICATIONP), or (fn ID CLAUSE WORLD
  STABLE-UNDER-SIMPLIFICATIONP HIST PSPV CTX) as appropriate for the
  arity of fn. (Note that this tells you which argument of fn is
  which.) Moreover, in these cases the value returned must be a
  single ordinary (non-[stobj]) value, not an error triple. In the
  discussion below we assume all computed hints are of the term form.
  Indeed, we almost assume all computed hints are of the 3 and 4
  argument forms. We only comment briefly on the 7 argument form in
  [using-computed-hints-8].

  The semantics of a computed hint term is as follows. On every
  subgoal, the term is evaluated in an environment in which the
  variables mentioned in (a) above are bound to context-sensitive
  values explained below. Either the computed hint signals an error,
  in which the proof attempt aborts, or else it returns a value, val
  and a new state, [state]. Any changes to those parts of [state]
  that affect logical soundness are undone; more specifically, the
  values of symbols (sometimes called ``state global variables'') in
  the list *protected-system-state-globals* in the global table of
  the state (see [state]) are restored when changed during
  evaluation. The value, val, of a non-erroneous computed hint
  calculation is either nil, which means the computed hint did not
  apply to the subgoal in question, or it is an alternating list of
  :keyi vali pairs as specified in [hints]. With one exception, those
  new hints are applied to the given subgoal as though the user had
  typed them explicitly.

  The exception is that the first keyword in the returned val is
  allowed to be :COMPUTED-HINT-REPLACEMENT. Its value should be nil,
  t, or a list of terms. If this keyword is not present, the default
  value of nil is provided. We explain :COMPUTED-HINT-REPLACEMENT
  below.

  The evaluation of a hint term is done with guard checking turned off
  (see [set-guard-checking]); e.g., the form (car 23) in a computed
  hint returns nil as per the axioms.

  When a non-nil value is returned, the keyword/value pairs (other than
  the optional :COMPUTED-HINT-REPLACEMENT) are used as the hint for
  the subgoal in question. Thus, your job as the programmer of
  computed hints is either to cause an error, typically by invoking
  [er], or to return a non-erroneous value triple whose value is the
  list of keys and values you would have typed had you supplied a
  common hint for the subgoal. (In particular, any theory expressions
  in it are evaluated with respect to the global current-theory, not
  whatever theory is active at the subgoal in question.) If the
  generated list of keywords and values is illegal, an error will be
  signaled and the proof attempt will be aborted.

  The purpose of the :COMPUTED-HINT-REPLACEMENT keyword and its value,
  chr, is to change the list of hints. If chr is nil, then the hint
  which was applied is removed from the list of hints that is passed
  down to the children of the subgoal in question. This is the
  default. If chr is t, then the hint is left in the list of hints.
  This means that the same hint may act on the children of the
  subgoal. Otherwise, chr must be a list of terms, each of which is
  treated as a computed hint. The hint which was applied is deleted
  from the list of hints and the hints in chr are added to the list
  of hints passed to the children of the subgoal. The ability to
  compute new hints and pass them down allows strange and wonderful
  behavior.

  For these purposes, the goals produced by induction and the top-level
  goals of forcing rounds are not considered children; all original
  hints are available to them.

  Only the first hint applicable to a goal, as specified in the
  user-supplied list of :hints followed by the [default-hints-table],
  will be applied to that goal. (For an advanced exception, see
  [override-hints].)

  It remains only to describe the bindings of the free variables.

  Suppose the theorem prover is working on some clause, clause, named
  by some [goal-spec], e.g., \"Subgoal *1/2'''\" in some logical world,
  world. Corresponding to the printed goal-spec is an internal data
  structure called a ``clause identifier'' id. See
  [clause-identifier].

  In the case of a common hint, the hint applies if the goal-spec of
  the hint is the same as the goal-spec of the clause in question.

  In the case of a computed hint, the variable ID is bound to the
  clause id, the variable CLAUSE is bound to the (translated form of
  the) clause, and the variable WORLD is bound to the current ACL2
  world. The variable STABLE-UNDER-SIMPLIFICATIONP is bound to t or
  nil. It is bound to t only if the clause is known to be stable
  under simplification. That is, the simplifier has been applied to
  the clause and did not change it. Such a clause is sometimes known
  as a ``simplification checkpoint.'' It is frequently useful to
  inject hints (e.g., to enable a rule or provide a :use hint) only
  when the goal in question has stabilized. If a hint is provided,
  the processing of the clause starts over with simplification.

  As for CTX and [state], they are provided so that you can pass them
  to the [er] macro to print error messages. We recommend not writing
  computed hints that otherwise change [state]!

  The remaining variables, HIST and PSPV are not documented yet. Only
  users familiar with the internals of ACL2 are likely to need them
  or understand their values.

  For some instruction about how to use computed hints, see
  [using-computed-hints].")
 (CONCATENATE
  (ACL2-BUILT-INS)
  "Concatenate lists or strings together

    Examples:
    (concatenate 'string \"ab\" \"cd\" \"ef\")     ; equals \"abcdef\"
    (concatenate 'string \"ab\")               ; equals \"ab\"
    (concatenate 'list '(a b) '(c d) '(e f)) ; equals '(a b c d e f)
    (concatenate 'list)                      ; equals nil

    General Form:
    (concatenate result-type x1 x2 ... xn)

  where n >= 0 and either: result-type is '[string] and each xi is a
  string; or result-type is '[list] and each xi is a true list.
  Concatenate simply concatenates its arguments to form the result
  string or list. Also see [append] and see [string-append]. (The
  latter immediately generates a call to concatenate when applied to
  strings.)

  Note: We do *not* try to comply with the Lisp language's insistence
  that concatenate copies its arguments. Not only are we in an
  applicative setting, where this issue shouldn't matter for the
  logic, but also we do not actually modify the underlying lisp
  implementation of concatenate; we merely provide a definition for
  it.

  Concatenate is a Common Lisp function. See any Common Lisp
  documentation for more information.

  Macro: <concatenate>

    (defmacro
        concatenate
        (result-type &rest sequences)
        (declare
             (xargs :guard (member-equal result-type '('string 'list))))
        (cond ((equal result-type ''string)
               (cond ((and sequences (cdr sequences)
                           (null (cddr sequences)))
                      (list 'string-append
                            (car sequences)
                            (cadr sequences)))
                     (t (list 'string-append-lst
                              (cons 'list sequences)))))
              ((endp sequences) nil)
              (t (cons 'append
                       (append sequences (list nil))))))")
 (COND
  (ACL2-BUILT-INS)
  "Conditional based on if-then-else

  Cond is the construct for IF, THEN, ELSE IF, ... The test is against
  nil. The argument list for cond is a list of ``clauses'', each of
  which is a list. In ACL2, clauses must have length 1 or 2.

  Cond is a Common Lisp macro. See any Common Lisp documentation for
  more information.

  Macro: <cond>

    (defmacro cond (&rest clauses)
              (declare (xargs :guard (cond-clausesp clauses)))
              (cond-macro clauses))

  Function: <cond-macro>

    (defun cond-macro (clauses)
           (declare (xargs :guard (cond-clausesp clauses)))
           (if (consp clauses)
               (if (and (eq (car (car clauses)) t)
                        (eq (cdr clauses) nil))
                   (if (cdr (car clauses))
                       (car (cdr (car clauses)))
                       (car (car clauses)))
                   (if (cdr (car clauses))
                       (list 'if
                             (car (car clauses))
                             (car (cdr (car clauses)))
                             (cond-macro (cdr clauses)))
                       (list 'or
                             (car (car clauses))
                             (cond-macro (cdr clauses)))))
               nil))")
 (CONGRUENCE
  (RULE-CLASSES)
  "The relations to maintain while simplifying arguments

  See [rule-classes] for a general discussion of rule classes and how
  they are used to build rules from formulas. An example :[corollary]
  formula from which a :congruence rule might be built is:

    Example:
    (defthm set-equal-implies-iff-memb-2
      (implies (set-equal x y)
               (iff (memb e x) (memb e y)))
      :rule-classes :congruence)

  Also see [defcong] and see [equivalence].

  NOTE: This topic discusses so-called ``classic'' congruence rules. A
  more general class of rules, so-called ``patterned'' congruence
  rules, is supported. We discuss only classic congruence rules
  below; for a discussion of patterned congruence rules, first read
  the present topic and then see [patterned-congruence].

    General Form:
    (implies (equiv1 xk xk-equiv)
             (equiv2 (fn x1... xk       ...xn)
                     (fn x1... xk-equiv ...xn)))

  where equiv1 and equiv2 are known equivalence relations, fn is an
  n-ary function symbol other than if, and the xi and xk-equiv are
  all distinct variables. The effect of such a rule is to record that
  the equiv2-equivalence of fn-expressions can be maintained if,
  while rewriting the kth argument position, equiv1-equivalence is
  maintained. See [equivalence] for a general discussion of the
  issues. We say that equiv2, above, is the ``outside equivalence''
  in the rule and equiv1 is the ``inside equivalence for the kth
  argument.''

  The macro form (defcong equiv1 equiv2 (fn x1 ... x1) k) is an
  abbreviation for a [defthm] of rule-class :congruence that attempts
  to establish that equiv2 is maintained by maintaining equiv1 in
  fn's kth argument. The [defcong] macro automatically generates the
  general formula shown above. See [defcong].

  The memb example above tells us that (memb e x) is propositionally
  equivalent to (memb e y), provided x and y are set-equal. The
  outside equivalence is [iff] and the inside equivalence for the
  second argument is set-equal. If we see a memb expression in a
  propositional context, e.g., as a literal of a clause or test of an
  [if] (but not, for example, as an argument to [cons]), we can
  rewrite its second argument maintaining set-equality. For example,
  a rule stating the commutativity of [append] (modulo set-equality)
  could be applied in this context. Since equality is a refinement of
  all equivalence relations, all equality rules are always available.
  See [refinement].

  All known :congruence rules about a given outside equivalence and fn
  can be used independently. That is, consider two :congruence rules
  with the same outside equivalence, equiv, and about the same
  function fn. Suppose one says that equiv1 is the inside equivalence
  for the first argument and the other says equiv2 is the inside
  equivalence for the second argument. Then (fn a b) is equiv (fn a'
  b') provided a is equiv1 to a' and b is equiv2 to b'. This is an
  easy consequence of the transitivity of equiv. It permits you to
  think independently about the inside equivalences.

  Furthermore, it is possible that more than one inside equivalence for
  a given argument slot will maintain a given outside equivalence.
  For example, (length a) is equal to (length a') if a and a' are
  related either by list-equal or by [string-equal]. You may prove
  two (or more) :congruence rules for the same slot of a function.
  The result is that the system uses a new, ``generated'' equivalence
  relation for that slot with the result that rules of both (or all)
  kinds are available while rewriting.

  :Congruence rules can be disabled. For example, if you have two
  different inside equivalences for a given argument position and you
  find that the :[rewrite] rules for one are unexpectedly preventing
  the application of the desired rule, you can disable the rule that
  introduced the unwanted inside equivalence.

  Remark on Replacing IFF by EQUAL. You may encounter a warning
  suggesting that a congruence rule ``can be strengthened by
  replacing the second equivalence relation, IFF, by EQUAL.'' Suppose
  for example that this warning occurs when you submit the following
  rule:

    (defcong equiv1 iff (fn x y) 2)

  which is shorthand for the following:

    (defthm equiv1-implies-iff-fn-2
           (implies (equiv1 y y-equiv)
                    (iff (fn x y) (fn x y-equiv)))
           :rule-classes (:congruence))

  The warning is telling you that ACL2 was able to deduce that fn
  always returns a Boolean, and hence a trivial but useful
  consequence is obtained by replacing [iff] by [equal] ---

    (defcong equiv1 equal (fn x y) 2)

  --- which is shorthand for the following:

    (defthm equiv1-implies-equal-fn-2
           (implies (equiv1 y y-equiv)
                    (equal (fn x y) (fn x y-equiv)))
           :rule-classes (:congruence))

  If you have difficulty proving the latter directly, you can derive it
  from the former by giving a suitable hint, minimally as follows.

    (defcong equiv1 equal (fn x y) 2
      :hints ((\"Goal\"
               :use equiv1-implies-iff-fn-2
               :in-theory
               (union-theories '((:type-prescription fn))
                               (theory 'minimal-theory)))))

  By heeding this warning, you may avoid unnecessary [double-rewrite]
  warnings later. We now explain why, but see [double-rewrite] for
  relevant background material.

  For example, suppose you have proved the ``iff'' version of the
  congruence rule above, and later you submit the following rewrite
  rule.

    (defthm equal-list-perm
      (implies (equiv1 x y)
               (fn x y)))

  Since fn is known to return a Boolean, ACL2 performs an optimization
  that stores this rule as though it were the following.

    (defthm equal-list-perm
      (implies (equiv1 x y)
               (equal (fn x y) t)))

  Thus, if ACL2's rewriter sees a term (fn a b) in a context where the
  equivalence relation [iff] is not being maintained, then it cannot
  use rule equiv1-implies-iff-fn-2, so it rewrites argument a without
  the benefit of knowing that it suffices to maintain equiv1; and
  then it caches the result. When ACL2 subsequently attempts to
  relieve the hypothesis (equiv1 x y), it will rewrite x simply by
  returning the rewritten value of a from the result cache. This is
  unfortunate if a could have been rewritten more completely under
  maintainance of the equivalence relation equiv1 --- which is legal
  in the hypothesis since a is an argument of equiv1, which is an
  [equivalence] relation. The user who observes the warning from rule
  equiv1-implies-iff-fn-2, and replaces it with
  equiv1-implies-equal-fn-2, will avoid this unfortunate case.")
 (CONJUGATE
  (ACL2-BUILT-INS)
  "Complex number conjugate

  Conjugate takes an ACL2 number as an argument, and returns its
  complex conjugate (i.e., the result of negating its imaginary
  part.).

  Conjugate is a Common Lisp function. See any Common Lisp
  documentation for more information.

  Function: <conjugate>

    (defun conjugate (x)
           (declare (xargs :guard (acl2-numberp x)))
           (if (complex/complex-rationalp x)
               (complex (realpart x) (- (imagpart x)))
               x))")
 (CONS
  (ACL2-BUILT-INS)
  "Pair and list constructor

  (cons x y) is a pair whose first component is x and second component
  is y. If y is a list, then (cons x y) is a list that has an
  additional element x on the front.")
 (CONS-SUBTREES
  (HONS-AND-MEMOIZATION)
  "(cons-subtrees x nil) builds a fast alist that associates each
  subtree of X with T, without duplication.

  This [documentation] topic relates to the experimental extension of
  ACL2 supporting hash cons, fast alists, and memoization; see
  [hons-and-memoization].

  Function: <cons-subtrees>

    (defun
         cons-subtrees (x al)
         (declare (xargs :guard t))
         (cond ((atom x) al)
               ((hons-get x al) al)
               (t (cons-subtrees (car x)
                                 (cons-subtrees (cdr x)
                                                (hons-acons x t al))))))")
 (CONSERVATIVITY-OF-DEFCHOOSE
  (DEFCHOOSE)
  "Proof of conservativity of [defchoose]

  This documentation topic provides underlying theory. It is of
  theoretical interest only; it has no relationship to the effective
  use of ACL2.

  The argument below for the conservativity of [defchoose] replaces the
  terse and somewhat misleading reference to a forcing argument in
  Appendix B of the paper by ACL2 authors Kaufmann and Moore,
  ``Structured Theory Development for a Mechanized Logic'' (Journal
  of Automated Reasoning 26, no. 2 (2001), pp. 161-203).

  Our basic idea is to to take a (countable) first-order structure for
  ACL2, M, together with a function symbol, f, introduced by
  [defchoose], and find a way to expand M with an interpretation of f
  (without changing the universe of M) so that e0-induction continues
  to hold in the expansion. A remark at the end of this documentation
  topic shows why care is necessary. A concept called ``forcing'',
  originally introduced by Paul Cohen for set theory, has long since
  been adapted by logicians (in a simplified form) to model theory.
  This simplified model-theoretic forcing provides the means for
  making our careful expansion.

  The forcing argument presented below is intended to be completely
  self-contained for those familiar with basic first-order logic and
  ACL2. No background in forcing (model-theoretic or otherwise) is
  expected, though we do expect a rudimentary background in
  first-order logic and familiarity with the following.

  Preliminaries. We write s[p<-p0] to denote the result of extending or
  modifying the assignment s by binding p to p0. Now let A be a
  subset of the universe U of a first-order structure M. A is said to
  be ``first-order definable with parameters'' in M if for some
  formula phi, variable x, and assignment s binding the free
  variables of phi except perhaps for x, A = {a \\in U: M |=
  phi[s[x<-a]]. Note that we are writing ``\\in'' to denote set
  membership. Finally, we indicate the end of a proof (or of a
  theorem statement, when the proof is omitted) with the symbol
  ``-|''.

  We gratefully acknowledge very helpful feedback from John Cowles, who
  found several errors in a draft of this note and suggested the
  exercises. We also thank Ruben Gamboa for helpful feedback, and we
  thank Jim Schmerl for an observation that led us directly to this
  proof in the first place.

  We are given a consistent first-order theory T, extending the ACL2
  ground-zero theory, that satisfies the e0-induction scheme. We wish
  to show that the extension of T by the following arbitrary
  defchoose event is conservative, where g is a new function symbol.

    (defchoose g <bound-vars> <free-vars> <body>)

  Note that by ``the extension of T'' here we mean the extension of T
  by not only the new defchoose axiom displayed just below, but also
  the addition of e0-induction axioms for formulas in the language
  with the new defchoose function symbol, g.

    <body> -> (LET <free-vars> = g(<bound-vars>) in <body>)

  By definition of conservativity, since proofs are finite, it clearly
  suffices to consider an arbitrary finite subset of T. Then by the
  completeness, soundness, and downward Lowenheim-Skolem theorems of
  first-order logic, it suffices to show that an arbitrary countable
  model of T can be expanded (i.e., by interpreting the new symbol g
  without changing the universe of the model) to a model of the
  corresponding defchoose axiom above, in which all e0-induction
  axioms hold in the language of that model.

  Below, we will carry out a so-called forcing construction, which
  allows us to expand any countable model M of T to a model M[G] that
  satisfies e0-induction and also satisfies the above axiom generated
  from the above defchoose event. The ideas in this argument are
  standard in model theory; no novelty is claimed here.

  Fix a countable model M of a theory T that satisfies e0-induction and
  extends the ACL2 ground-zero theory. Also fix the above defchoose
  axiom, where g is not in the language of T.

  We start by defining a partial order P as follows. Let Nb and Nf be
  the lengths of <bound-vars> and <free-vars>, respectively. P
  consists of all fn in M such that the following formula is true in
  M. Roughly speaking, it says that fn is a finite function
  witnessing the above requirement for g.

    alistp(fn) &
    no-duplicatesp-equal(strip-cars(fn)) &
    (forall <bound-vars>, <free-vars> .
       (member-equal(cons(<bound-vars>,<free-vars>), fn) ->
        (length(<bound-vars>) = Nb &
         length(<free-vars>)  = Nf &
         ((exists <free-vars> . <body>) -> <body>))))

  P is ordered by subset, i.e., we say that p2 extends p1 if p1 is a
  subset (not necessarily proper) of p2 (more precisely, M |=
  subsetp-equal(p1,p2)).

  Remark. The original argument in Appendix B of the aforementioned
  paper can essentially be salvaged, as we now show. The key
  observation is that the particular choice of P is nearly irrelevant
  for the argument that follows below. In particular, we can instead
  define P to consist of finite one-one functions with domain
  contained in the set of natural numbers. More precisely, consider
  the following definitions.

    (defun function-p (fn)
      (declare (xargs :guard t))
      (and (alistp fn)
           (no-duplicatesp-equal (strip-cars fn))))

    (defun nat-listp (l)
      (declare (xargs :guard t))
      (cond ((atom l)
             (eq l nil))
            (t (and (natp (car l))
                    (nat-listp (cdr l))))))

    (defun nat-function-p (x)
      (and (function-p x)
           (nat-listp (strip-cars x))))

  and define inverse as follows.

    (defun inverse (fn)
      (declare (xargs :guard (alistp fn)))
      (if (endp fn)
          nil
        (cons (cons (cdar fn) (caar fn))
              (inverse (cdr fn)))))

  Then P may instead be defined to consist of those fn for which
  nat-function-p(fn) & function-p(inverse(fn)). With this alternate
  definition of P, the argument below then goes through virtually
  unchanged, and we get an expansion M[G] of M in which there is a
  definable enumeration of the universe. The conservativity of
  defchoose then follows easily because the function being introduced
  can be defined explicitly using that enumeration (namely, always
  pick the least witness in the sense of the enumeration).

  End of Remark.

  Next we present the relevant forcing concepts from model theory.

  A dense subset of P is a subset D of P such that for every p \\in P,
  there is d \\in D such that d extends p. A subset G of P is generic
  with respect to a collection Ds of dense subsets of P, also written
  ``G is Ds-generic,'' if G is closed under subset (if p2 \\in G and
  p2 extends p1 then p1 \\in G), G is pairwise compatible (the
  union-equal of any two elements of G is in G), and every set in Ds
  has non-empty intersection with G.

  For p \\in P, we say that a subset D of P is dense beyond p if for all
  p1 extending p there exists p2 extending p1 such that p2 \\in D.
  This notion makes sense even for D not a subset of P if we treat
  elements of D not in P as nil.

  Proposition 1. For any partial order P and countable collection Ds of
  dense subsets of P, there is a Ds-generic subset of P.

  Proof. Let Ds = {D0,D1,D2,...}. Define a sequence <p_0,p_1,...> such
  that for all i, p_i \\in Di and p_(i+1) extends p_i. Let G = {p \\in
  P: for some i, pi extends p}. Then G is Ds-generic. -|

  Note that P is first-order definable (with parameters) in M. Let Df
  be the set of dense subsets of P that are first-order definable
  (with parameters) in M. A standard argument shows there are only
  countably many first-order definitions with parameters in a
  countable model M --- for example, we can Goedel number all terms
  and then all formulas --- hence, Df is countable.

  By Proposition 1, let G be Df-generic. Notice that for any list x of
  length Nb in M, the set of elements f of P for which x is in the
  domain of f is dense and first-order definable. We may thus define
  a function g0 as follows: g0(x_1,...,x_Nb) = y if there is some
  element of G containing the pair ((x_1 ... x_Nb) . y). It is easy
  to see that g0 is a total function on M. Let L be the language of T
  and let L[g] be the union of L with a set containing a single new
  function symbol, g. Let M[G] be the expansion of M to L[g] obtained
  by interpreting g to be g0 (see also Proposition 5 below).

  So now we have fixed M, P, Df, G, and g0, where G is Df-generic.

  Proposition 2. Let Df be the set of dense subsets of P that are
  first-order definable (with parameters) in M. Suppose that p \\in G
  and D \\in Df. Then for some q \\in G extending p, q \\in D.

  Proof. Let D0 be the set of p' \\in D that either extend p or have no
  extension in D that extends p. We leave it as a straightforward
  exercise to show that D0 is dense, and D0 is clearly first-order
  definable (with parameters) in M. So by genericity of G, we may
  pick q \\in D0 such that q \\in G. Thus q \\in D. By definition of
  generic, some extension q1 of both p and q belongs to G. Pick q2
  \\in D extending q1; thus q has an extension in D that extends p
  (namely, q2), so by definition of D0, q extends p. -|

  Definition of forcing. Let phi(x1,...,xk) be a first-order formula in
  L[g] and let p \\in P. We define a formula of L, denoted ``p ||-
  phi'' (``p forces phi''), by recursion on phi (in the metatheory)
  as follows. (Here, we view ``or'' and ``forall'' as abbreviations.)

      If phi is atomic, then let phi'(A) be the result of replacing,
      inside-out, each subterm of the form g(x_1,...,x_Nb) with the
      term (cdr (assoc-equal (list x_1 ... x_Nb) A)), where A is
      neither p nor a variable occurring in phi. Then p ||- phi is
      defined as follows: ``The set {A \\in P: A extends p and
      phi'(A)} is dense beyond p''. That is, p ||- phi is the
      following formula:

        (forall p1 \\in P extending p)
         (exists p2 \\in P extending p1) phi'(p2).

      p ||- ~phi is: (forall p' \\in P extending p) ~(p' ||- phi)

      p ||- phi_1 & phi_2 is: (p ||- phi_1) & (p ||- phi_2)

      p ||- (exists x) phi is: (exists x) (p ||- phi)

  We will need the following definition later.

  Definition. p ||-w phi (p weakly forces phi) is an abbreviation for p
  ||- ~~phi.

  The following exercises were suggested by John Cowles as a means for
  gaining familiarity with the definition of forcing.

  Exercise 1. Consider the formula (phi_1 OR phi_2) as an abbreviation
  for ~(~phi_1 & ~phi_2), Show that p ||- (phi_1 OR phi_2) is
  equivalent to the following.

    (forall p' \\in P extending p) (exists p'' \\in P extending p')
     ((p'' ||- phi_1) OR (p'' ||- phi_2))

  Exercise 2. Consider the formula (forall x)phi as an abbreviation for
  ~(exists x)~phi, Show that p ||- (forall x)phi is equivalent to the
  following.

    (forall x)
     (forall p1 \\in P extending p)
      (exists p2 \\in P extending p1) (p2 ||- phi).

  Exercise 3. Prove that p ||-w phi is equivalent to the following.

    (forall p' \\in P extending p)
     (exists p'' \\in P extending p') (p'' ||- phi).

  Exercise 4. Let phi be a formula of L[g]. Prove: M |= (p ||-
  phi)[s[p<-p0]] implies M |= (p ||-w phi)[s[p<-p0]].

  Exercise 5. Let phi be a formula of L[g]. Prove: M |= (p ||-
  ~phi)[s[p<-p0]] iff M |= (p ||-w ~phi)[s[p<-p0]].

  [End of exercises.]

  The definition of forcing stipulates how to view ``p ||-
  phi(x1,...,xk)'' as a new formula theta(p,x1,...,xk). That is,
  ``||-'' transforms formulas, so for any first-order formula phi,
  ``p ||- phi'' is just another first-order formula. That observation
  shows that a formula such as ((p ||- phi) OR (p ||- ~phi)) is
  really just another first-order formula. The following proposition
  thus follows easily.

  Proposition 3. For any formula phi of L[g], {p0: M |= ((p ||- phi) OR
  (p ||- ~phi))[s[p<-p0]]]} is a dense subset of P, which (since it
  is first-order definable with parameters in M) intersects G. -|

  The following proposition is easily proved by a structural induction
  on phi, and is left to the reader.

  Proposition 4. Let phi be a formula of L[g]. Suppose p0 in P, p1 in
  P,
  M |= (p ||- phi)[s[p<-p0]] and p1 extends p0. Then
  M |= (p ||- phi)[s[p<-p1]]. -|

  We will also need the following.

  Proposition 5. The following is dense for any finite set S of
  Nb-tuples: {p \\in P: for some <x_1 ... x_Nb> \\in S, (list x_1 ...
  x_Nb) \\in strip-cars(p)}. Thus, the function g0 is a total
  function. -|

  The next lemma tells us that the sentences true in M[G] are those
  that are forced by an element of G.

  Truth Lemma. Let phi be a formula in L[g], let s be an assignment to
  the free variables of phi, and let p be a variable not in the
  domain of s. Then M[G] |= phi[s] iff for some p0 \\in G, M |= (p ||-
  phi)[s[p<-p0]].

  Proof. The proof is by induction on the structure of phi. First
  suppose phi is atomic. Let D* be the set of elements p0 \\in P such
  that every assoc-equal evaluation from the definition of forcing
  phi returns a pair when A is bound to p0. (Intuitively, this means
  that p0 is a sufficiently large approximation from any G containing
  p0 to make sense of phi in M[G].) We make the following claim.

    (*)   For all p0 \\in G such that p0 \\in D*,
          M[G] |= phi[s] iff M |= (p ||- phi)[s[p<-p0]].

  To prove the claim, fix p0 in both G and D*, and recall the function
  g0 constructed from G in the definition of M[G]. Suppose that t_1,
  ..., t_Nb are terms and g(t_1, ..., t_Nb) is a subterm of phi. Then
  s assigns a value in M to each of the t_i. Let a_i be the value
  assigned by s to t_i. Then g0(a_1, ..., a_Nb) = (cdr (assoc-equal
  (list a_1 ... a_Nb) p0)), as the assoc-equal is a pair (since p0
  \\in D*) and has the indicated value (because p0 \\in G). It follows
  by the definition of formula phi' in the definition of forcing:

    M[G] |= phi[s]  iff  M |= phi'(p)[s[p<-p0]]

  Moreover, because p0 \\in D* it is clear that this holds if p0 is
  replaced by an arbitrary extension of p0. Then (*) easily follows.

  By Proposition 5, D* is dense, so there is some p0 in the
  intersection of D* and G. The forward direction of the conclusion
  then follows by (*). The reverse direction is clear from (*) by
  application of Proposition 2 to D* and Proposition 4.

  Next, suppose M[G] |= ~phi[x]. Then it is not the case that M[G] |=
  phi, so by the inductive hypothesis, there is no p0 \\in G for which
  M |= (p ||- phi)[s[p<-p0]]. By Proposition 3, there is p0 \\in G for
  which M |= (p ||- ~phi)[s[p<-p0]]. For the other direction, suppose
  it is not the case that M[G] |= ~phi[s]. So M[G] |= phi[s], and by
  the inductive hypothesis, there is p0 \\in G for which M |= (p ||-
  phi)[s[p<-p0]]. It follows that there is no p1 \\in G for which M |=
  (p ||- ~phi)[s[p<-p1]], since from such p1 we can find a common
  extension p2 of p0 and p1 (since G is generic), and since p2
  extends p0 then by Proposition 4, M |= (p ||- phi)[s[p<-p2]],
  contradicting (by definition of forcing) M |= (p ||-
  ~phi)[s[p<-p1]] since p2 extends p1.

  The case (phi_1 & phi_2) follows easily from the inductive
  hypothesis. For the forward direction, apply Proposition 4 and the
  observation that by genericity, if p0 \\in G and p1 \\in G then p0
  and p1 they have a common extension in G.

  Finally, the case (exists x) phi follows trivially from the inductive
  hypothesis. -|

  Truth Lemma Corollary. The Truth Lemma holds with ||-w replacing ||-.

  Proof. This is clear by applying the Truth Lemma to ~~phi. -|

  Here is our main theorem. Recall that all first-order theories in our
  ACL2 context satisfy the e0-induction scheme.

  Theorem. M[G] satisfies e0-induction.

  Proof. We consider an arbitrary instance of e0-induction in L[g],
  stated using a strict well-founded relation <| and a formula phi.
  We write phi(y) to indicate that y may be among the free variables
  of phi, and phi(y<-x) to denote the result of substituting x for y
  in phi.

    theta(y):   (forall y) [((forall x <| y) phi(y<-x)) -> phi(y)]
             -> (forall y) phi(y)

  Our goal is to prove that theta holds in M[G].

  Below, we abuse notation by leaving assignments implicit and by
  writing ``p ||- phi(y0)'' to signify that the formula (p ||-
  phi(y)) is true in M under the extension of the explicit assignment
  that binds y to y0. We believe that the intended meaning will be
  clear.

  Consider the following set D.

    D = {p \\in P: either p ||-w phi(y0) for all y0,
                  or else
                  for some y0, p ||- ~phi(y0) and
                               for all y1 <| y0 p ||-w phi(y1)}.

  The set D is clearly first-order definable (with parameters) in M. We
  claim that D is a dense subset of P. For suppose p0 \\in P; we find
  p1 \\in D extending p0, as follows. If p0 ||-w phi(y0) for all y0,
  then we may take p1 to be p0. Otherwise, by definition of ||-w and
  ||-, there is some y0 such that for some extension p0' of p0, p0'
  ||- ~phi(y0). Pick a <|-minimal such y0, and correspondingly pick
  p1 so that p1 extends p0 and p1 ||- ~phi(y0). In order to show that
  p1 \\in D, it remains to show that for all y1 <| y0, p1 ||-w
  phi(y1), i.e., there is no q extending p1 such that q ||- ~phi(y1).
  This is indeed the case since otherwise q and y1 would contradict
  the <|-minimality of y0.

  Applying the genericity of G and just-proved density of D, pick p0
  \\in G such that p0 \\in D. If p0 ||-w phi(y0) for all y0, then by
  the Truth Lemma Corollary, M[G] |= phi(y0) for all y0, and thus
  M[G] |= theta. Otherwise, since p0 \\in D we may choose y0 such that
  p0 ||- ~phi(y0) and for all y1 <| y0, p0 ||-w phi(y1). By the Truth
  Lemma and its corollary, since p0 \\in G we have:

    (1)   M[G] |= ~phi(y0).
    (2)   For all y1 <| y0, M[G] |= phi(y1).

  It follows that the antecedent of theta is false in M[G], as
  witnessed by y = y0; thus M[G] |= theta. -|

  Remark. We close by returning, as promised above, to the question of
  why so much care is necessary in constructing an expansion of M. We
  assume familiarity here with the notion of a ``non-standard''
  natural number of M, i.e., one that is greater than the
  interpretation of any term that has the form (+ 1 1 1 ... 1). Here
  is a very simple example that illustrates the need for some care.
  Consider the following event, which introduces a function foo with
  the following property: for all x, if natp(x) then natp(foo(x)).

    (defchoose foo (y) (x)
      (implies (natp x) (natp y)))

  Certainly we can build a model of the above property from a model M
  of the ground-zero theory, by interpreting foo so that for all x
  for which M satisfies natp(x), foo(x) is also a natp in M. But
  suppose we start with a non-standard model M of the ground-zero
  theory, and we happen to define foo(x) to be 1 for all non-standard
  natural numbers x and 0 for all other x. The resulting expansion of
  M will not satisfy the e0-induction scheme or even the ordinary
  natural number induction scheme: foo(0)=0 holds in that expansion
  as does the implication foo(n)=0 => foo(n+1)=0 for every natural
  number n of M, standard or not; and yet foo(k)=0 fails for every
  non-standard natural number k of M.")
 (CONSP
  (ACL2-BUILT-INS)
  "Recognizer for [cons] pairs

  (consp x) is true if and only if x is a [cons] pair.")
 (CONSTRAINT
  (MISCELLANEOUS)
  "Restrictions on certain functions introduced in [encapsulate]
  [events]

  Suppose that a given theorem, thm, is to be functionally instantiated
  using a given functional substitution, alist. (See
  [lemma-instance], or for an example, see
  [functional-instantiation-example].) What is the set of proof
  obligations generated? It is the set obtained by applying alist to
  all terms, tm, such that (a) tm mentions some function symbol in
  the domain of alist, and (b) either (i) tm arises from the
  ``constraint'' on a function symbol ancestral in thm or in some
  [defaxiom] or (ii) tm is the body of a [defaxiom]. Here, a function
  symbol is ``ancestral'' in thm if either it occurs in thm, or it
  occurs in the definition of some function symbol that occurs in
  thm, and so on.

  The remainder of this note explains what we mean by ``constraint'' in
  the words above.

  In a certain sense, function symbols are introduced in essentially
  two ways. The most common way is to use [defun] (or when there is
  mutual recursion, [mutual-recursion] or [defuns]). There is also a
  mechanism for introducing ``witness functions''; see [defchoose].
  The documentation for these [events] describes the axioms they
  introduce, which we will call here their ``definitional axioms.''
  These definitional axioms are generally the constraints on the
  function symbols that these axioms introduce.

  However, when a function symbol is introduced in the scope of an
  [encapsulate] event, its constraints may differ from the
  definitional axioms introduced for it. For example, suppose that a
  function's definition is [local] to the [encapsulate]; that is,
  suppose the function is introduced in the [signature] of the
  [encapsulate]. Then its constraints include, at the least, those
  non-[local] theorems and definitions in the [encapsulate] that
  mention the function symbol.

  Actually, it will follow from the discussion below that if the
  [signature] is empty for an [encapsulate], then the constraint on
  each of its new function symbols is exactly the definitional axiom
  introduced for it. Intuitively, we view such encapsulates just as
  we view [include-book] [events]. But the general case, where the
  [signature] is not empty, is more complicated.

  In the discussion that follows we describe in detail exactly which
  constraints are associated with which function symbols that are
  introduced in the scope of an [encapsulate] event. In order to
  simplify the exposition we make two cuts at it. In the first cut we
  present an over-simplified explanation that nevertheless captures
  the main ideas. In the second cut we complete our explanation by
  explaining how we view certain [events] as being ``lifted'' out of
  the [encapsulate], resulting in a possibly smaller [encapsulate],
  which becomes the target of the algorithm described in the first
  cut.

  At the end of this note we present an example showing why a more
  naive approach is unsound.

  Finally, before we start our ``first cut,'' we note that any
  information you want ``exported'' outside an [encapsulate] event
  must be there as an explicit definition or theorem. For example,
  even if a function foo has output type (mv t t) in its [signature],
  the system will not know (true-listp (foo x)) merely on account of
  this information. Thus, if you are using functions like foo
  (constrained [mv] functions), then you may find it useful to prove
  (inside the encapsulate, to be exported) a :[type-prescription]
  rule for the constrained function, for example, the
  :[type-prescription] rule (true-listp (foo x)).

  First cut at constraint-assigning algorithm. Quite simply, the
  formulas introduced in the scope of an [encapsulate] are conjoined,
  and each function symbol introduced by the [encapsulate] is
  assigned that conjunction as its constraint.

  Clearly this is a rather severe algorithm. Let us consider two
  possible optimizations in an informal manner before presenting our
  second cut.

  Consider the (rather artificial) event below. The function before1
  does not refer at all, even indirectly, to the locally-introduced
  function sig-fn, so it is unfortunate to saddle it with constraints
  about sig-fn.

    (encapsulate
     (((sig-fn *) => *))

     (defun before1 (x)
       (if (consp x)
           (before1 (cdr x))
         x))

     (local (defun sig-fn (x) (cons x x)))

     (defthm sig-fn-prop
       (consp (sig-fn x)))
     )

  We would like to imagine moving the definition of before1 to just in
  front of this [encapsulate], as follows.

    (defun before1 (x)
      (if (consp x)
          (before1 (cdr x))
        x))

    (encapsulate
     (((sig-fn *) => *))

     (local (defun sig-fn (x) (cons x x)))

     (defthm sig-fn-prop
       (consp (sig-fn x)))
     )

  Thus, we will only assign the constraint (consp (sig-fn x)), from the
  theorem sig-fn-prop, to the function sig-fn, not to the function
  before1.

  More generally, suppose an event in an [encapsulate] event does not
  mention any function symbol in the [signature] of the
  [encapsulate], nor any function symbol that mentions any such
  function symbol, and so on. (We might say that no function symbol
  from the [signature] is an ``ancestor'' of any function symbol
  occurring in the event.) Then we imagine moving the event, so that
  it appears in front of the [encapsulate]. We don't actually move
  it, but we pretend we do when it comes time to assign constraints.
  Thus, such definitions only introduce definitional axioms as the
  constraints on the function symbols being defined. In the example
  above, the event sig-fn-prop introduces no constraints on function
  before1.

  Once this first optimization is performed, we have in mind a set of
  ``constrained functions.'' These are the functions introduced in
  the [encapsulate] that would remain after moving some of them in
  front, as indicated above. Consider the collection of all formulas
  introduced by the [encapsulate], except the definitional axioms,
  that mention these constrained functions. So for example, in the
  event below, no such formula mentions the function symbol after1.

    (encapsulate
     (((sig-fn *) => *))

     (local (defun sig-fn (x) (cons x x)))

     (defthm sig-fn-prop
       (consp (sig-fn x)))

     (defun after1 (x)
       (sig-fn x))
     )

  We can see that there is really no harm in imagining that we move the
  definition of after1 out of the [encapsulate], to just after the
  [encapsulate].

  Many subtle aspects of this rearrangement process have been omitted.
  For example, suppose the function fn uses sig-fn, the latter being
  a function in the signature of the encapsulation. Suppose a formula
  about fn is proved in the encapsulation. Then from the discussion
  above fn is among the constrained functions of the encapsulate: it
  cannot be moved before the encapsulate and it cannot be moved after
  the encapsulation. But why is fn constrained? The reason is that
  the theorem proved about fn may impose or express constraints on
  sig-fn. That is, the theorem proved about fn may depend upon
  properties of the witness used for sig-fn. Here is a simple
  example:

    (encapsulate
     (((sig-fn *) => *))

     (local (defun sig-fn (x) (declare (ignore x)) 0))

     (defun fn (lst)
       (if (endp lst)
           t
           (and (integerp (sig-fn (car lst)))
                (fn (cdr lst)))))

     (defthm fn-always-true
       (fn lst)))

  In this example, there are no [defthm] events that mention sig-fn
  explicitly. One might therefore conclude that it is completely
  unconstrained. But the witness we chose for it always returns an
  integer. The function fn uses sig-fn and we prove that fn always
  returns true. Of course, the proof of this theorem depends upon the
  properties of the witness for sig-fn, even though those properties
  were not explicitly ``called out'' in theorems proved about sig-fn.
  It would be unsound to move fn-always-true after the encapsulate.
  It would also be unsound to constrain sig-fn to satisfy just
  fn-always-true without including in the constraint the relation
  between sig-fn and fn. Hence both sig-fn and fn are constrained by
  this encapsulation and the constraint imposed on each is the same
  and states the relation between the two as characterized by the
  equation defining fn as well as the property that fn always returns
  true. Suppose, later, one proved a theorem about sig-fn and wished
  to functionally instantiate it. Then one must also functionally
  instantiate fn, even if it is not involved in the theorem, because
  it is only through fn that sig-fn inherits its constrained
  properties.

  This is a pathological example that illustrate a trap into which one
  may easily fall: rather than identify the key properties of the
  constrained function the user has foreshadowed its intended
  application and constrained those notions. Clearly, the user
  wishing to introduce the sig-fn above would be well-advised to use
  the following instead:

    (encapsulate
     (((sig-fn *) => *))
     (local (defun sig-fn (x) (declare (ignore x)) 0))
     (defthm integerp-sig-fn
       (integerp (sig-fn x))))

    (defun fn (lst)
      (if (endp lst)
          t
        (and (integerp (sig-fn (car lst)))
             (fn (cdr lst)))))

    (defthm fn-always-true
       (fn lst)))

  Note that sig-fn is constrained merely to be an integer. It is the
  only constrained function. Now fn is introduced after the
  encapsulation, as a simple function that uses sig-fn. We prove that
  fn always returns true, but this fact does not constrain sig-fn.
  Future uses of sig-fn do not have to consider fn at all.

  Sometimes it is necessary to introduce a function such as fn within
  the encapsulate merely to state the key properties of the undefined
  function sig-fn. But that is unusual and the user should understand
  that both functions are being constrained.

  Another subtle aspect of encapsulation that has been brushed over so
  far has to do with exactly how functions defined within the
  encapsulation use the signature functions. For example, above we
  say ``Consider the collection of all formulas introduced by the
  encapsulate, except the definitional axioms, that mention these
  constrained functions.'' We seem to suggest that a definitional
  axiom which mentions a constrained function can be moved out of the
  encapsulation and considered part of the ``post-encapsulation''
  extension of the logical [world], if the defined function is not
  used in any non-definitional formula proved in the encapsulation.
  For example, in the encapsulation above that constrained sig-fn and
  introduced fn within the encapsulation, fn was constrained because
  we proved the formula fn-always-true within the encapsulation. Had
  we not proved fn-always-true within the encapsulation, fn could
  have been moved after the encapsulation. But this suggests an
  unsound rule because whether such a function can be moved after the
  encapsulate depend on whether its admission used properties of the
  witnesses! In particular, we say a function is ``subversive'' if
  any of its governing tests or the actuals in any recursive call
  involve a function in which the signature functions are ancestral.
  See [subversive-recursions].

  (Aside: The definition of fn in the first enapsulation above that
  defines fn, i.e., the encapsulation with fn-always-true inside, is
  subversive because the call of the macro [and] expands to a call of
  IF that governs a recursive call of fn, in this case:

    (defun fn (lst)
      (if (endp lst)
          t
          (if (integerp (sig-fn (car lst)))
              (fn (cdr lst))
            nil))).

  If we switch the order of conjuncts in fn, then the definition of fn
  is no longer subversive, but it still ``infects'' the constraint
  generated for the encapsulation, hence for sig-fn, because
  fn-always-true blocks the definition of fn from being moved back
  (to after the encapsulation). If we both switch the order of
  conjuncts and drop fn-always-true from the encapsulation, then the
  definition of fn is in essence moved back to after the
  encapsulation, and the constraint for sig-fn no longer includes the
  definition of fn. End of aside.)

  Another aspect we have not discussed is what happens to nested
  encapsulations when each introduces constrained functions. We say
  an encapsulate event is ``trivial'' if it introduces no constrained
  functions, i.e., if its signatures is nil. Trivial encapsulations
  are just a way to wrap up a collection of events into a single
  event.

  From the foregoing discussion we see we are interested in exactly how
  we can ``rearrange'' the events in a non-trivial encapsulation --
  moving some ``before'' the encapsulation and others ``after'' the
  encapsulation. We are also interested in which functions introduced
  by the encapsulation are ``constrained'' and what the
  ``constraints'' on each are. We may summarize the observations
  above as follows, after which we conclude with a more elaborate
  example.

  Second cut at constraint-assigning algorithm. First, we focus only on
  non-trivial encapsulations that neither contain nor are contained
  in non-trivial encapsulations. (Nested non-trivial encapsulations
  are not rearranged at all: do not put anything in such a nest
  unless you mean for it to become part of the constraints
  generated.) Second, in what follows we only consider the non-local
  events of such an encapsulate, assuming that they satisfy the
  restriction of using no locally defined function symbols other than
  the signature functions. Given such an encapsulate event, move, to
  just in front of it and in the same order, all definitions and
  theorems for which none of the signature functions is ancestral.
  Now collect up all formulas (theorems) introduced in the
  [encapsulate] other than definitional axioms. Add to this set any
  of those definitional equations that is either subversive or
  defines a function used in a formula in the set. The conjunction of
  the resulting set of formulas is called the ``constraint'' and the
  set of all the signature functions of the encapsulate together with
  all function symbols defined in the encapsulate and mentioned in
  the constraint is called the ``constrained functions.'' Assign the
  constraint to each of the constrained functions. Move, to just
  after the encapsulate, the definitions of all function symbols
  defined in the encapsulate that have been omitted from the
  constraint.

  Implementation note. In the implementation we do not actually move
  [events], but we create constraints that pretend that we did.

  Here is an example illustrating our constraint-assigning algorithm.
  It builds on the preceding examples.

    (encapsulate
     (((sig-fn *) => *))

     (defun before1 (x)
       (if (consp x)
           (before1 (cdr x))
         x))

     (local (defun sig-fn (x) (cons x x)))

     (defthm sig-fn-prop
       (consp (sig-fn x)))

     (defun during (x)
       (if (consp x)
           x
         (cons (car (sig-fn x))
               17)))

     (defun before2 (x)
       (before1 x))

     (defthm before2-prop
       (atom (before2 x)))

     (defthm during-prop
       (implies (and (atom x)
                     (before2 x))
                (equal (car (during x))
                       (car (sig-fn x)))))

     (defun after1 (x)
       (sig-fn x))

     (defchoose after2 (x) (u)
       (and (< u x) (during x)))
     )

  Only the functions sig-fn and during receive extra constraints. The
  functions before1 and before2 are viewed as moving in front of the
  [encapsulate], as is the theorem before2-prop. The functions after1
  and after2 are viewed as being moved past the [encapsulate]. The
  implementation reports the following.

    In addition to SIG-FN, we export AFTER2, AFTER1, BEFORE2, DURING and
    BEFORE1.

    The following constraint is associated with both of the functions DURING and
    SIG-FN:

    (AND (EQUAL (DURING X)
                (IF (CONSP X)
                    X (CONS (CAR (SIG-FN X)) 17)))
         (CONSP (SIG-FN X))
         (IMPLIES (AND (ATOM X) (BEFORE2 X))
                  (EQUAL (CAR (DURING X))
                         (CAR (SIG-FN X)))))

  Notice that the formula (consp (during x)) is not a conjunct of the
  constraint. During the first pass of the encapsulate, this formula
  is stored as a :[type-prescription] rule deduced during the
  definition of the function during. However, the rule is not
  exported because of a rather subtle soundness issue. (If you are
  interested in details, see the comments in source function
  putprop-type-prescription-lst.)

  We conclude by asking (and to a certain extent, answering) the
  following question: Isn't there an approach to assigning
  constraints that avoids over-constraining more simply than our
  ``second cut'' above? Perhaps it seems that given an [encapsulate],
  we should simply assign to each locally defined function the
  theorems exported about that function. If we adopted that simple
  approach the events below would be admissible.

    (encapsulate
     (((foo *) => *))
     (local (defun foo (x) x))
     (defun bar (x)
       (foo x))
     (defthm bar-prop
       (equal (bar x) x)
       :rule-classes nil))

    (defthm foo-id
      (equal (foo x) x)
      :hints ((\"Goal\" :use bar-prop)))

    ; The following event is not admissible in ACL2.

    (defthm ouch!
      nil
      :rule-classes nil
      :hints
      ((\"Goal\" :use
        ((:functional-instance foo-id
                               (foo (lambda (x) (cons x x))))))))

  Under the simple approach we have in mind, bar is constrained to
  satisfy both its definition and bar-prop because bar mentions a
  function declared in the signature list of the encapsulation. In
  fact, bar is so-constrained in the ACL2 semantics of encapsulation
  and the first two events above (the encapsulate and the consequence
  that foo must be the identity function) are actually admissible.
  But under the simple approach to assigning constraints, foo is
  unconstrained because no theorem about it is exported. Under that
  approach, ouch! is provable because foo can be instantiated in
  foo-id to a function other than the identity function.

  It's tempting to think we can fix this by including definitions, not
  just theorems, in constraints. But consider the following slightly
  more elaborate example. The problem is that we need to include as a
  constraint on foo not only the definition of bar, which mentions
  foo explicitly, but also abc, which has foo as an ancestor.

    (encapsulate
     (((foo *) => *))
     (local (defun foo (x) x))
     (local (defthm foo-prop
              (equal (foo x) x)))
     (defun bar (x)
       (foo x))
     (defun abc (x)
       (bar x))
     (defthm abc-prop
       (equal (abc x) x)
       :rule-classes nil))

    (defthm foo-id
      (equal (foo x) x)
      :hints ((\"Goal\" :use abc-prop)))

    ; The following event is not admissible in ACL2.

    (defthm ouch!
      nil
      :rule-classes nil
      :hints
      ((\"Goal\" :use
        ((:functional-instance foo-id
                               (foo (lambda (x) (cons x x)))
                               (bar (lambda (x) (cons x x))))))))")
 (CONVERSION
  (PAGES_WRITTEN_ESPECIALLY_FOR_THE_TOURS)
  "Conversion to Uppercase

  When symbols are read by Common Lisp they are converted to upper
  case. Note carefully that this remark applies to the characters in
  symbols. The characters in strings are not converted upper case.

  To type a symbol containing lower case characters you can enclose the
  symbol in vertical bars, as in |AbC| or you can put a ``backslash''
  before each lower case character you wish to preserve, as in A\\bC.
  |AbC| and A\\bC are two different ways of writing the same symbol
  (just like 2/4 and 1/2 are two different ways of writing the same
  rational and 123 and 0123 are two different ways to write the same
  natural number). The symbol has three characters in its name, the
  middle one of which is a lower case b.")
 (COPYRIGHT
  (ABOUT-ACL2)
  "ACL2 copyright, license, sponsorship

  This topic provides information about copyright, license, authorship,
  and sponsorship of the ACL2 system. For information about copyright
  and authorship of [documentation], see [documentation-copyright],
  which notes that there are many documentation authors.

  ACL2 Version 6.4 --- A Computational Logic for Applicative Common
  Lisp

  Copyright (C) 2014, Regents of the University of Texas

  This version of ACL2 is a descendent of ACL2 Version 1.9, Copyright
  (C) 1997 Computational Logic, Inc. See the documentation topic
  NOTE-2-0.

  This program is free software; you can redistribute it and/or modify
  it under the terms of the LICENSE file distributed with ACL2.

  This program is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
  LICENSE for more details.

  Written by: Matt Kaufmann and J Strother Moore
  email: Kaufmann@cs.utexas.edu and Moore@cs.utexas.edu
  Department of Computer Science
  University of Texas at Austin
  Austin, TX 78712 U.S.A.

  Please also see [acknowledgments].


Subtopics

  [Documentation-copyright]
      Copyright and authorship of documentation")
 (COROLLARY
  (MISCELLANEOUS)
  "The corollary formula of a [rune]

  This is a low-level system function at the present time. See [pr] and
  see [pr!] instead. Also see [rule-classes] for the use of the
  symbol :corollary in specifying a rule class.")
 (CORROBORATING_MODELS
  (PAGES_WRITTEN_ESPECIALLY_FOR_THE_TOURS)
  "Corroborating Models

  [{IMAGE}]

  After producing a model, it must be corroborated against reality. The
  Falling Body Model has been corroborated by a vast number of
  experiments in which the time and distance were measured and
  compared according to the formula. In general all models must be
  corroborated by experiment.

  The Falling Body Model can be derived from deeper models, namely
  Newton's laws of motion and the assertion that, over the limited
  distances concerned, graviation exerts a constant acceleration on
  the object. When the model in question can be derived from other
  models, it is the other models that are being corroborated by our
  experiments.

  Because nature is not formal, we cannot prove that our models of it
  are correct. All we can do is test our models against nature's
  behavior.

  Such testing often exposes restrictions on the applicability of our
  models. For example, the Falling Body Model is inaccurate if air
  resistance is significant. Thus, we learn not to use that model to
  predict how long it takes a feather to fall from a 200 foot tower
  in the earth's atmosphere.

  In addition, attempts at corroboration might reveal that the model is
  actually incorrect. Careful measurements might expose the fact that
  the gravitational force increases as the body falls closer to
  earth. Very careful measurements might reveal relativistic effects.
  Technically, the familiar Falling Body Model is just wrong, even
  under excessive restrictions such as ``in a perfect vacuum'' and
  ``over small distances.'' But it is an incredibly useful model
  nonetheless.

  There are several morals here.

  Models need not be complete to be useful.

  Models need not be perfectly accurate to be useful.

  The user of a model must understand its limitations.

  [{IMAGE}]")
 (COUNT
  (ACL2-BUILT-INS)
  "Count the number of occurrences of an item in a string or true-list

    Example Forms:
    (count #\\D \"DabcDefcDe\")                 ; = 3
    (count #\\D \"DabcDefcDe\" :start 1)        ; = 2
    (count #\\D \"DabcDefcDe\" :start 1 :end 5) ; = 1
    (count #\\D \"DabcDefcDe\" :start 1 :end 4) ; = 0
    (count #\\z \"DabcDefcDe\")                 ; = 0
    (count '(a b) '(17 (a b) 23 (a b) (c d)))   ; = 2

    General Form:
    (count item sequence &key start end)

  (Count item sequence) returns the number of times item occurs in
  sequence. The [guard] for calls of count (which is actually a macro
  in ACL2) specifies that sequence is a string or a true-list, and
  that start, which defaults to 0, and end, which defaults to the
  length of sequence, are valid indices into sequence.

  See any Common Lisp documentation for more information about count,
  which is a Common Lisp utility. At this time ACL2 does not support
  keyword arguments for count other than :start and :end; we may add
  support for the :from-end keyword upon request.

  Macro: <count>

    (defmacro count
              (item sequence &key (start '0) end)
              (cons 'count-fn
                    (cons item
                          (cons sequence
                                (cons start (cons end 'nil))))))")
 (CPU-CORE-COUNT
  (ACL2-BUILT-INS)
  "The number of cpu cores

  This [documentation] topic relates to the experimental extension of
  ACL2 supporting parallel execution and proof; see [parallelism].

  Unless the ACL2 executable supports parallel execution (see
  [parallelism]), this function returns (mv 1 state). Otherwise:

  (Cpu-core-count state) returns (mv core-count state), where
  core-count is the number of cpu cores if ACL2 can get that
  information from the underlying Common Lisp implementation.
  Otherwise an error occurs, unless global 'cpu-core-count is
  assigned to a positive integer value (see [assign]), in which case
  that value is returned as the core-count.

    Example:
    (cpu-core-count state) ==> (mv 4 state)

  Definition: <cpu-core-count>

    (encapsulate
     nil
     (local (defthm true-listp-nthcdr
                    (implies (true-listp x)
                             (true-listp (nthcdr n x)))))
     (defun
        count-fn (item sequence start end)
        (declare
             (xargs :guard (and (if (true-listp sequence)
                                    t (stringp sequence))
                                (natp start)
                                (or (null end)
                                    (and (natp end)
                                         (<= end (length sequence)))))))
        (let ((end (or end (length sequence))))
             (cond ((<= end start) 0)
                   ((stringp sequence)
                    (count-stringp item sequence start end))
                   (t (count-listp item (nthcdr start sequence)
                                   (- end start)))))))")
 (CURRENT-PACKAGE
  (MISCELLANEOUS)
  "The package used for reading and printing

  Current-package is an [ld] special (see [ld]). The accessor is
  (current-package state) and the updater is (set-current-package val
  state), or more conventionally, (in-package val). The value of
  current-package is actually the string that names the package.
  (Common Lisp's ``package'' objects do not exist in ACL2.) The
  current package must be known to ACL2, i.e., it must be one of the
  initial packages or a package defined with [defpkg] by the user.

  When printing symbols, the package prefix is displayed if it is not
  the current-package and may be optionally displayed otherwise.
  Thus, if current-package is \"ACL2\" then the symbol 'ACL2::SYMB may
  be printed as SYMB or ACL2::SYMB, while 'MY-PKG::SYMB must be
  printed as MY-PKG::SYMB. But if current-package is \"MY-PKG\" then
  the former symbol must be printed as ACL2::SYMB while the latter
  may be printed as SYMB.

  In Common Lisp, current-package also affects how objects are read
  from character streams. Roughly speaking, read and print are
  inverses if the current-package is fixed, so reading from a stream
  produced by printing an object must produce an equal object.

  In ACL2, the situation is more complicated because we never read
  objects from character streams, we only read them from object
  ``streams'' (channels). Logically speaking, the objects in such a
  channel are fixed regardless of the setting of current-package.
  However, our host file systems do not support the idea of Lisp
  object files and instead only support character files. So when you
  open an object input channel to a given (character file) we must
  somehow convert it to a list of ACL2 objects. This is done by a
  deus ex machina (``a person or thing that appears or is introduced
  suddenly and unexpectedly and provides a contrived solution to an
  apparently insoluble difficulty,'' Webster's Ninth New Collegiate
  Dictionary). Roughly speaking, the deus ex machina determines what
  sequence of calls to read-object will occur in the future and what
  the current-package will be during each of those calls, and then
  produces a channel containing the sequence of objects produced by
  an analogous sequence of Common Lisp reads with *current-package*
  bound appropriately for each.

  A simple rule suffices to make sane file [io] possible: before you
  read an object from an object channel to a file created by printing
  to a character channel, make sure the current-package at read-time
  is the same as it was at print-time.")
 (CURRENT-THEORY
  (THEORIES THEORY-FUNCTIONS)
  "Currently [enable]d rules as of logical name

    Examples:
    (current-theory :here)
    (current-theory 'lemma3)

  See [logical-name].

    General Form:
    (current-theory logical-name)

  Returns the current theory as it existed immediately after the
  introduction of [logical-name] provided it is evaluated in an
  environment in which the variable symbol WORLD is bound to the
  current ACL2 logical world, (w state). Thus,

    ACL2 !>(current-theory :here)

  will cause an (unbound variable) error while

    ACL2 !>(let ((world (w state))) (current-theory :here))

  will return the current theory in world.

  See [theories] and see [logical-name] for a discussion of theories in
  general and why the commonly used ``theory functions'' such as
  current-theory are really macros that expand into terms involving
  the variable world.

  The theory returned by current-theory is in fact the theory selected
  by the [in-theory] event most recently preceding logical name,
  extended by the rules introduced up through [logical-name].

  You may experience a fencepost problem in deciding which logical name
  to use. [Deflabel] can always be used to mark unambiguously for
  future reference a particular point in the development of your
  theory. The order of [events] in the vicinity of an [encapsulate]
  is confusing. See [encapsulate].

  This ``function'' is actually a macro that expands to a term
  mentioning the single free variable [world]. When theory
  expressions are evaluated by [in-theory] or the :[in-theory] hint,
  [world] is bound to the current ACL2 [world].")
 (CUSTOM-KEYWORD-HINTS
  (HINTS)
  "User-defined hints

  See [add-custom-keyword-hint] for a discussion of how advanced users
  can define their own hint keywords. For examples, see the community
  books directory books/hints/, in particular basic-tests.lisp.


Subtopics

  [Show-custom-keyword-hint-expansion]
      Print out custom keyword hints when they are expanded")
 (CW
  (ACL2-BUILT-INS)
  "Print to the comment window

  Example:

    (cw \"The goal is ~p0 and the alist is ~x1.~%\"
        (untranslate term t nil)
        unify-subst)

  Logically, this expression is equivalent to nil. However, it has the
  effect of first printing to the so-called ``comment window'' the
  [fmt] string as indicated. Thus, cw is like fmt (see [fmt]) except
  in three important ways. First, it is a macro whose calls expand to
  calls of a :[logic] mode function. Second, it neither takes nor
  returns the ACL2 [state]; logically cw simply returns nil, although
  it prints to a comment window that just happens to share the
  terminal screen with the standard character output [*standard-co*].
  Third, its fmt args are positional references, so that for example

    (cw \"Answers: ~p0 and ~p1\" ans1 ans2)

  prints in the same manner as:

    (fmt \"Answers: ~p0 and ~p1\"
         (list (cons #\\0 ans1) (cons #\\1 ans2))
         *standard-co* state nil)

  Typically, calls of cw are embedded in [prog2$] forms, e.g.,

    (prog2$ (cw ...)
            (mv a b c))

  which has the side-effect of printing to the comment window and
  logically returning (mv a b c).

    General Form:
    (cw fmt-string arg1 arg2 ... argn)

  where n is between 0 and 9 (inclusive). The macro uses
  [fmt-to-comment-window], passing it the column 0 and [evisc-tuple]
  nil, after assembling the appropriate alist binding the [fmt] vars
  #\\0 through #\\9; see [fmt]. If you want

    (a) more than 10 vars,
    (b) vars other than the digit chars,
    (c) a different column, or
    (d) a different evisc-tuple,

  then call [fmt-to-comment-window] instead.

  Also see [cw!], which is useful if you want to be able to read the
  printed forms back in.

  Finally, we discuss another way to create formatted output that also
  avoids the need to pass in the ACL2 [state]. The idea is to use
  wormholes; see [wormhole]. Below is a function you can write, along
  with some calls, providing an illustration of this approach.

    (defun my-fmt-to-comment-window (str alist)
      (wormhole 'my-fmt-to-comment-window
                '(lambda (whs) whs)
                (list str alist)
                '(pprogn
                  (fms (car (@ wormhole-input))
                       (cadr (@ wormhole-input))
                       *standard-co*
                       state
                       nil)
                  (value :q))
                :ld-verbose nil
                :ld-error-action :return ; harmless return on error
                :ld-prompt nil))

    ; A non-erroneous call:
    (my-fmt-to-comment-window \"Here is ~x0 for your inspection~%\"
                              (list (cons #\\0 'foo)))

    ; An error inside the fmt string (unbound fmt var); note that even
    ; with the error, the wormhole is exited.
    (my-fmt-to-comment-window \"Here is ~x1 for your inspection~%\"
                              (list (cons #\\0 'foo)))

    ; A guard violation in the binding; note that even with the error,
    ; the wormhole is exited.
    (my-fmt-to-comment-window \"Here is ~x0 for your inspection~%\"
                              (list (cons #\\0 (car 'foo))))")
 (CW!
  (ACL2-BUILT-INS)
  "Print to the comment window

  This is the same as [cw], except that [cw] inserts backslash (\\)
  characters when forced to print past the right margin, in order to
  make the output a bit clearer in that case. Use cw! instead if you
  want to be able to read the forms back in.")
 (CW-GSTACK
  (BREAK-REWRITE DEBUGGING)
  "Debug a rewriting loop or stack overflow

    Example Forms:
    (cw-gstack)
    (cw-gstack :frames 10)       ; show only the top 10 frames
    (cw-gstack :frames '(1 10))  ; same as above:  show only frames 1 through 10
    (cw-gstack :frames '(10 20)) ; show only frames 10 through 20
    (cw-gstack :evisc-tuple (evisc-tuple 3 4 nil nil))
                                 ; print with print-level 3 and print-length 4
    (cw-gstack :evisc-tuple nil) ; print using default ``evisceration'',
                                 ;   essentially the same as just above
    (cw-gstack :evisc-tuple '(nil 3 4 (hide)))
                                 ; same as just above

    General Form:
    (cw-gstack :frames frames :evisc-tuple evisc-tuple)

  where :frames and :evisc-tuple are optional, but if they are
  supplied, their values are evaluated. The value of frames should be
  either a natural number or a list of two natural numbers, the first
  less than the second; and the value of evisc-tuple should be an
  evisc-tuple (see [evisc-tuple]). If :evisc-tuple is omitted, then
  substructures deeper than 3 are replaced by ``#'' and those longer
  than 4 are replaced by ``...'', and terms of the form (hide ...)
  are printed as <hidden>. Also see [set-iprint] for an alternative
  to printing ``#'' and ``...''.

  Stack overflows may occur, perhaps caused by looping rewrite rules.
  In some Lisps, stack overflows may manifest themselves as
  segmentation faults, causing the entire ACL2 image to crash.
  Finding looping rewrite rules can be tricky, especially if you are
  using books supplied by other people. (However, see
  [set-rewrite-stack-limit] for a way to avoid stack overflows caused
  by rewriter loops.)

  Normally, a stack overflow will cause the printing of an error
  message that suggests how to proceed. Just follow those
  instructions, and you will generally be able to see what is causing
  the loop.

  Suggestion: Once you have found the loop and fixed it, you should
  execute the ACL2 command :[brr] nil, so that you don't slow down
  subsequent proof attempts.")
 (DEAD-EVENTS
  (OTHER)
  "Using proof supporters to identify dead code and unused theorems

  Below, when we talk about ``an event A'', we mean an event whose name
  is A.

  When event A is used in a proof performed to admit event B that you
  submit to ACL2, we say that A is a ``proof-supporter'' of B. ACL2
  stores an association list such that for every event B with at
  least one proof-supporter, B is associated with a list of all of
  its proof-supporters, sorted by [symbol-<]. The following form
  evaluates to that alist, which is called the
  ``proof-supporters-alist''.

    (global-val 'proof-supporters-alist (w state))

  By ``used in a proof'' above, we mean: applied as a rule or supplied
  explicitly via [hints] of type :use, :by, or :clause-processor.
  That is, the [events] ``used in a proof'' for admitting an event E
  are those listed in the summary printed at the conclusion of
  admitting E.

  Note that if proofs are skipped when admitting event E, say because
  the last admission of E was done by [include-book] (or
  certify-book, which ends with an [include-book]), then there will
  be no entry in that alist for E. (An exception is made however for
  [encapsulate] [events], where proof-supporters are remembered from
  the first pass; see below.) So if you want the
  proof-supporters-alist to include supporters for events in a book,
  use [ld] rather than [include-book] or [certify-book] to process
  the events in that book. If however you are interested in the
  proof-supporters FROM a book that support a later event, then it is
  fine to include that book.

  The case for [encapsulate] is slightly tricky. Consider an example of
  the following form.

    A ; event preceding the encapsulate
    (encapsulate
     ()
     B
     (local C) ; uses A and B in a proof
     D ; uses C in a proof
     )

  At the conclusion of this [encapsulate] event, the
  proof-supporters-alist associates D with A and B, but not C (which
  has disappeared, since it is [local]).

  Note that this sort of ``transitive closure'' operation is only
  performed when necessary due to the disappearance of [local]
  [events]. For example, if we replace (local C) above by just C,
  then D is associated in the proof-supporters-alist only with C, not
  with A or B. If you want the transitive closure of the relation
  computed by the proof-supporters-alist, you have to compute it
  yourself. (This was a deliberate design decision, in order to avoid
  slowing down event processing.) However, there is help available on
  how to do such a computation:

  A community book, books/misc/dead-events.lisp, does such a transitive
  closure, and moreover uses that information to find ``dead events''
  relative to a list of ``desired'' events. For example, suppose you
  use [ld] to process the events, with proofs, in a book intended to
  prove theorems MAIN-1 and MAIN-2. (Remember, [certify-book] will
  not save such information.) Suppose furthermore that the book
  begins with some [include-book] forms followed by (deflabel
  book-start). You could evaluate this form:

    (dead-events '(main-1 main-2) :start 'book-start)

  The result is a list of events that you probably can delete from the
  book without causing any proofs to fail. See the dead-events.lisp
  book for further documentation.

  You might also find the code in the above book to be helpful for
  writing your own utilities based on the proof-supporters-alist.")
 (DEALING-WITH-KEY-COMBINATIONS-OF-FUNCTION-SYMBOLS
  (INTRODUCTION-TO-THE-THEOREM-PROVER)
  "How to get rid of key combinations of function symbols

  Suppose REV reverses a list, MEMBER checks that its first argument is
  an element of its second, and SQUARES-PLUS-3P is some complicated
  predicate. Suppose you're proving some Main Theorem that involves
  those concepts and the theorem prover presents you with the
  following hideous formula as a key checkpoint. What action should
  you take?

  Hint: Don't read the formula ``for sense,'' i.e., don't try to
  understand what this formula is saying! Just look at every subterm
  involving a nest of two function symbols and ask if you know
  something about those two symbols that allows you to simplify that
  one subterm.

    (IMPLIES (AND (CONSP X)
                  (MEMBER (+ 3 (* I I)) (REV X))
                  (LIST-OF-INTEGERS X)
                  (INTEGERP I)
                  (<= 0 I)
                  (INTEGERP K)
                  (<= 0 K)
                  (< I K)
                  (SQUARES-PLUS-3P K X)
                  (NOT (EQUAL (CAR X) (+ 3 (* I I))))
                  (NOT (MEMBER (+ 3 (* I I)) X)))
             (SQUARES-PLUS-3P K (REV X)))?

  The experienced ACL2 user will stop reading at the second hypothesis!

    (MEMBER (+ 3 (* I I)) (REV X))

  The combination of MEMBER and REV can be simplified. The question
  ``is e a member of (REV x)'' can be answered by asking ``is e a
  member of x''. The two questions are equivalent. This insight comes
  from your intuition about the semantics of REV -- it just reorders
  the elements but doesn't add or delete any. The second question is
  simpler since it doesn't mention REV, so this is a good
  transformation to make. And the theorem that they are equivalent is
  simpler than the key checkpoint above because it involves fewer
  functions and smaller expressions.

  You might formalize this insight as

    (equal (member e (rev x))
           (member e x))

  But this conjecture is not a theorem, because (member e x) returns
  the cdr of x that begins with e, not just a Boolean (t or nil)
  indicating whether e is an element of x. The location of the first
  e in (rev x) is generally different than the location in x. So when
  we say the two questions are ``equivalent'' we don't mean they are
  equal. We mean that they're propositionally equivalent: both nil or
  both non-nil. This sense of equivalence is called ``if and only
  if'' and is checked by the function iff.

  So our intuitive insight can be phrased as this theorem:

    (iff (member e (rev x))
         (member e x))

  Suggesting that this formulation of the insight is ``obvious'' begs
  many questions. Mathematically, we could have avoided iff and just
  written two implications:

    (and (implies (member e x) (member e (rev x)))
         (implies (member e (rev x)) (member e x))).

  or

    (and (implies (member e x) (member e (rev x)))
         (implies (not (member e x))  (not (member e (rev x))))).

  Or we could have used iff but ``oriented'' it the other way:

    (iff (member e x)
         (member e (rev x)))

  We choose to write

    (iff (member e (rev x))
         (member e x))

  because of our knowledge of how ACL2 turns formulas into rules!

  We deal with this at greater length later. But just to drive the
  point home, if we issue the command:

    (defthm member-rev
      (iff (member e (rev x))
           (member e x)))

  ACL2 will build in a rule that causes every propositional occurrence
  of (MEMBER e (REV x)) to be replaced by (MEMBER e x). (By
  ``propositional occurrence'' we mean an occurrence in which the
  value is tested, as by IF or the propositional connectives.
  Remember, one might use member to determine the location of an
  element too.)

  Note carefully: if you do not tell ACL2 how to make a rule from a
  theorem, it makes a rewrite rule. Rewrite rules always replace
  instances of the left-hand side by the corresponding instances of
  the right-hand side. That is, when interpreted as a rewrite rule,
  (iffalpha beta)') makes ACL2 replace alpha by beta.

  Probably the biggest mistake new users make is forgetting that every
  theorem they prove creates a very specific rule. You must remember
  that you are programming ACL2 with these rules. Being careless in
  your statement of theorems is tantamount to being careless in your
  programming. What you get is a mess.

  Had we proved the same equivalence, but with the iff commuted, we
  would be giving ACL2 bad advice. We would be telling it ``replace
  instances of (MEMBER e x) by the corresponding instances of (MEMBER
  e (REV x))''! If ACL2 had that rule and ever tried to simplify any
  member expression, e.g., (MEMBER A B), it would get into an
  infinite loop, e.g., producing the following sequence of
  transformations:

    (MEMBER A B)
    (MEMBER A (REV B))
    (MEMBER A (REV (REV B)))
    ...

  until it eventually exhausted some resource.

  Recall that we entertained the idea of phrasing our insight about
  member and rev with implications rather than iff. Generally
  speaking, implications produce weaker rules -- rules that apply
  less often. We discuss that later.

  Now suppose we've proved member-rev, oriented so as to rewrite
  (member e (rev x)) to (member e x), and built it in as a rewrite
  rule. Then suppose we repeated the attempt to prove our Main
  Theorem. This time, when the prover is processing the hideous Key
  Checkpoint printed above, our new lemma, member-rev, will hit it.
  It will transform the formula to:

    (IMPLIES (AND (CONSP X)
                  (MEMBER (+ 3 (* I I)) X)   ; <-- the hyp has simplified
                  (LIST-OF-INTEGERS X)
                  (INTEGERP I)
                  (<= 0 I)
                  (INTEGERP K)
                  (<= 0 K)
                  (< I K)
                  (SQUARES-PLUS-3P K X)
                  (NOT (EQUAL (CAR X) (+ 3 (* I I))))
                  (NOT (MEMBER (+ 3 (* I I)) X)))
             (SQUARES-PLUS-3P K (REV X)))?

  and then that will collapse to T, since the IMPLIES has contradictory
  hypotheses (note the last hypothesis above).

  By proving member-rev we proved the hideous checkpoint. We never had
  to look at the rest of the formula or think about why it is a
  theorem. Furthermore, attacking the main theorem again, from
  scratch, with member-rev in the database, may eliminate other
  checkpoints that came up the last time we tried to prove our main
  goal. So we recommend addressing one checkpoint at a time.

  This example illustrates that purely local thinking -- looking for
  simplifiable combinations of function symbols -- can sometimes lead
  to proofs and should always be your first reaction to a key
  checkpoint: what local fact do you know that would clean up the
  formula? Don't think about deep questions like ``why is this
  true?'' until you can't see any way to make it simpler.

  It is important to train yourself to see combinations of function
  symbols and to create strong rules for eliminating them. We will
  give you opportunities to practice this later in the tutorial.

  If you have been reading the tutorial introduction to the theorem
  prover, use your browser's Back Button now to return to
  [introduction-to-key-checkpoints].")
 (DEALING-WITH-TAU-PROBLEMS
  (INTRODUCTION-TO-THE-TAU-SYSTEM)
  "Some advice on dealing with problems caused by the tau system

  For background on the tau system, see
  [introduction-to-the-tau-system]. The two most common problems
  caused by the tau system have to do with the system's interaction
  with ``legacy'' proof scripts. Such scripts may suffer because they
  were not designed to exploit tau reasoning and which may configure
  the tau database in quite incomplete and arbitrary ways. The two
  most common problems we have seen are (a) significant slow downs in
  a few proofs and (b) failed proof attempts due to hints being
  misapplied because the tau system caused subgoals to be renumbered.

  We discuss the rather limited means of dealing with these problems
  here. In [future-work-related-to-the-tau-system] we list some major
  inadequacies of the tau system.

  If the tau system contributes to a proof, the [rune]
  (:[executable-counterpart] tau-system) will be listed among the
  Rules in the Summary. However, merely by being attempted the tau
  system can slow down proofs in which it makes no contribution.

  The most brutal and fool-proof way to isolate a proof from the tau
  system is to disable the entire system. This can be done globally
  by

    (in-theory (disable (tau-system)))  ; (:executable-counterpart tau-system)

  or locally with a subgoal specific hint:

    ...
    :hints ((\"...subgoal id...\" :in-theory (disable (tau-system))))

  Conducting a proof with and without the participation of the tau
  system can help you determine whether tau reasoning is helping or
  hurting.

  Dealing with Slowdowns

  The [time-tracker] utility was added to allow users to investigate
  whether excessive amounts of time are being spent in a given
  function. It was then used to annotate the code for the tau system
  as described in [time-tracker-tau]. The result is that if
  ``excessive'' time is spent in tau reasoning, messages to that
  effect will be printed to the proof log. The question is: aside
  from disabling the tau system how can the proof be sped up?

  There are two common causes of slowdown in the tau system. The first
  stems from the system's use of :[executable-counterpart]s to
  determine whether a constant has a given tau. Recall that a tau is
  a conjunction of monadic predicates. To determine whether some
  constant satisfies the tau, the predicates are executed. If you
  have a hard-to-compute predicate this can be very slow. The most
  typical such predicates in ACL2 applications are those that check
  invariants, e.g., that recognize ``good states'' or ``well-formed
  data.'' These are often written inefficiently because they are
  intended only for used in theorems and, before the tau system was
  added, they may have never been applied to constants. The most
  common constants tau predicates are applied to are 0, T, and NIL,
  although different models may stress other constants. To understand
  why NIL for example is frequently tested, if the test of an
  IF-expression is computed to have tau s then the next question we
  ask is ``does nil satisfy s?''

  You may determine whether the tau system is spending time executing
  tau predicates by observing the rewriter --- see [dmr] --- or by
  interrupting the system and getting a backtrace (see
  [set-debugger-enable]).

  If excessive time is being spent in a tau predicate, a draconian
  solution is to disable the :[executable-counterpart] of that
  predicate, for example in either of these equivalent ways. The tau
  system does not execute disabled :[executable-counterpart]s.

    (in-theory (disable (:executable-counterpart foo)))
    (in-theory (disable (foo)))

  In either case above, you may prefer to provide local :[in-theory]
  :[hints] rather than :in-theory [events].

  Disabling the executable counterpart of expensive tau predicates will
  weaken the tau system, probably only negligibly, because it can no
  longer run the predicates to determine whether they admits given
  constants.

  A more sophisticated solution is to make the tau system record values
  of the :[logic]-mode function in question, so that the system will
  look up the necessary values rather than running the function every
  time the question arises. It will look up recorded values whether
  the executable counterpart of the tau predicate is enabled or
  disabled. Here is an example of a lemma that can provide such a
  solution. See the discussion of the Eval form of :[tau-system]
  rules.

    (defthm lemma
      (and (foo 0)
           (foo 17)
           (foo t)
           (not (foo '(a b c))))
      :rule-classes :tau-system)

  It might be difficult to determine which constants are being
  repeatedly tested, although tracing ([trace$]) suspected tau
  predicates will show what they are being called on.

  At the moment there are no better user-level tools to discover this.
  However, some users may wish to consider the following hack: In the
  ACL2 source file tau.lisp, immediately after the definition of the
  system function ev-fncall-w-tau-recog, there is a comment which
  contains some raw Lisp code that can be used to investigate whether
  tau's use of evaluation on constants is causing a problem and to
  determine which constants are involved.

  The second main cause of slowdowns by the tau system is that the
  system contains ``too many'' conjunctive rules (see the Conjunctive
  form in [tau-system]). Unfortunately, we have no tools for either
  identifying the problem or addressing it! That said, let us tell
  you what we do know!

  Conjunctive rules are used to ``complete'' each tau as it is built.
  Referring to the weekdayp example in [tau-system], if a tau is
  constructed that recognizes weekdays but not MON, TUE, THU, or FRI,
  it is completed by adding that the tau recognizes (only) WED. This
  means that when we construct a tau we scan all known conjunctive
  rules and see whether all but one of the literals of any
  conjunctive rule are present. This can be expensive. To mitigate
  this expense, the tau system caches the computation on a per proof
  basis (the cache is cleared after every proof).

  To learn what conjunctive rules there are in your system, evaluate

    (assoc 'tau-conjunctive-rules (tau-database (w state)))

  Perhaps by sending the implementors that list, we can think of ways
  to index the conjunctive rules to save time.

  Dealing with Misapplied Hints

  The second common problem caused by the tau system in legacy proof
  scripts is that it can cause subgoals to be renumbered and thus
  cause hints to be missed. The only ways to address this problem is
  either to disable the tau system (locally or globally by disabling
  (:executable-counterpart tau-system)) or change the legacy hints to
  use the new subgoal names.")
 (DEBUGGING
  (TOP ACL2)
  "Tools for debugging failed or slow proofs, or misbehaving functions.


Subtopics

  [Accumulated-persistence]
      To get statistics on which [rune]s are being tried

  [Break-rewrite]
      The read-eval-print loop entered to [monitor] rewrite rules

  [Cw-gstack]
      Debug a rewriting loop or stack overflow

  [Disassemble$]
      Disassemble a function

  [Dmr]
      Dynamically monitor rewrites and other prover activity

  [Failed-forcing]
      How to deal with a proof [failure] in a forcing round

  [Forward-chaining-reports]
      To see reports about the forward chaining process

  [Guard-debug]
      Generate markers to indicate sources of guard proof obligations

  [Print-gv]
      Print a form whose evaluation caused a guard violation

  [Proof-checker]
      An interactive tool for controlling ACL2's proof processes.

  [Proof-tree]
      Proof tree displays

  [Pstack]
      Seeing what the prover is up to

  [Splitter]
      Reporting of rules whose application may have caused case splits

  [Time-tracker]
      Display time spent during specified evaluation

  [Trace]
      Tracing functions in ACL2

  [Walkabout]
      Explore an ACL2 cons tree")
 (DECLARE
  (PROGRAMMING)
  "Declarations

    Examples:
    (declare (ignore x y z))
    (declare (ignorable x y z)
             (type integer i j k)
             (type (satisfies integerp) m1 m2))
    (declare (xargs :guard (and (integerp i)
                                (<= 0 i))
                    :guard-hints ((\"Goal\" :use (:instance lemma3
                                                  (x (+ i j)))))))

    General Form:
    (declare d1 ... dn)
    where, in ACL2, each di is of one of the following forms:

      (ignore v1 ... vn) -- where each vi is a variable introduced in
      the immediately superior lexical environment.  These variables must not
      occur free in the scope of the declaration.

      (ignorable v1 ... vn) -- where each vi is a variable introduced in
      the immediately superior lexical environment.  These variables need not
      occur free in the scope of the declaration.  This declaration can be useful
      for inhibiting compiler warnings.

      (type type-spec v1 ... vn) -- where each vi is a variable introduced in the
      immediately superior lexical environment and type-spec is a type specifier
      (as described in the documentation for [type-spec]).

      (xargs :key1 val1 ... :keyn valn) -- where the legal values of the keyi's
      and their respective vali's are described in the documentation for
      [xargs].  Xargs declarations are only allowed at the top level of
      definitions (defun and defmacro, as shown below).

      (optimize ...) -- for example, (optimize (safety 3)).  This is allowed
      only at the top level of [defun] forms.  See any Common Lisp
      documentation for more information.

  Declarations in ACL2 may occur only where dcl occurs below:

    (DEFUN name args doc-string dcl ... dcl body)
    (DEFMACRO name args doc-string dcl ... dcl body)
    (LET ((v1 t1) ...) dcl ... dcl body)
    (MV-LET (v1 ...) term dcl ... dcl body)
    (FLET ((name args dcl ... dcl body)
           ...))

  Of course, if a form macroexpands into one of these (as [let*]
  expands into nested [let]s and our er-let* expands into nested
  [mv-let]s) then declarations are permitted as handled by the macros
  involved.

  Declare is defined in Common Lisp. See any Common Lisp documentation
  for more information.


Subtopics

  [Type-spec]
      Type specifiers in declarations")
 (DECLARE-STOBJS
  (STOBJ)
  "Declaring a formal parameter name to be a single-threaded object

  When a [defun] uses one of its formals as a single-threaded object
  ([stobj]), the defun must include a declaration that the formal is
  to be so used. An exception is the formal ``[state],'' which if not
  declared as explained below, may still be used provided an
  appropriate global ``declaration'' is issued: see [set-state-ok].

  If the formal in question is counters then an appropriate declaration
  is

    (declare (xargs :stobjs counters))

  or, more generally,

    (declare (xargs :stobjs (... counters ...)))

  where all the single-threaded formals are listed.

  For such a declaration to be legal it must be the case that all the
  names have previously been defined as single-threaded objects with
  [defstobj].

  When an argument is declared to be single-threaded the guard of the
  function is augmented by conjoining to it the condition that the
  argument satisfy the recognizer for the single-threaded object.
  Furthermore, the syntactic checks done to enforce the legal use of
  single-threaded objects are also sufficient to allow these guard
  conjuncts to be automatically proved.

  The obvious question arises: Why does ACL2 insist that you declare
  stobj names before using them in defuns if you can only declare
  names that have already been defined with defstobj? What would go
  wrong if a formal were treated as a single-threaded object if and
  only if it had already been so defined?

  Suppose that one user, say Jones, creates a book in which counters is
  defined as a single-threaded object. Suppose another user, Smith,
  creates a book in which counters is used as an ordinary formal
  parameter. Finally, suppose a third user, Brown, wishes to use both
  books. If Brown includes Jones' book first and then Smith's, then
  Smith's function treats counters as single-threaded. But if Brown
  includes Smith's book first, the argument is treated as ordinary.

  ACL2 insists on the declaration to ensure that the definition is
  processed the same way no matter what the context.")
 (DEFABBREV
  (MACROS EVENTS)
  "A convenient form of macro definition for simple expansions

    Examples:
    (defabbrev snoc (x y) (append y (list x)))
    (defabbrev sq (x) (declare (type (signed-byte 8) x)) (* x x))

    General Form:
    (defabbrev name (v1 ... vn) doc-string decl1 ... declk body)

  where name is a new function symbol, the vi are distinct variable
  symbols, and body is a term. The decli, if supplied, should be
  legal declare forms; see [declare]. Doc-string is an optional
  [documentation] string; see [doc-string].

  Roughly speaking, the defabbrev event is akin to defining f so that
  (f v1 ... vn) = body. But rather than do this by adding a new
  axiom, defabbrev defines f to be a macro so that (f a1 ... an)
  expands to body, with the ``formals,'' vi, replaced by the
  ``actuals,'' ai.

  For example, if snoc is defined as shown in the first example above,
  then (snoc (+ i j) temp) is just an abbreviation for

    (append temp (list (+ i j))).

  In order to generate efficiently executable Lisp code, the macro that
  defabbrev introduces uses a [let] to bind the ``formals'' to the
  ``actuals.'' Consider the second example above. Logically speaking,
  (sq (ack i j)) is an abbreviation for (* (ack i j) (ack i j)). But
  in fact the macro for sq introduced by defabbrev actually arranges
  for (sq (ack i j)) to expand to:

    (let ((x (ack i j)))
      (* x x))

  which executes more efficiently than (* (ack i j) (ack i j)).

  In the theorem prover, the let above expands to

    ((lambda (x) (* x x)) (ack i j))

  and thence to (* (ack i j) (ack i j)).

  It is important to note that the term in body should not contain a
  call of name --- i.e., defabbrev should not be used in place of
  defun when the function is recursive. ACL2 will not complain when
  the defabbrev form is processed, but instead ACL2 will more than
  likely go into an infinite loop during macroexpansion of any form
  that has a call of name.

  It is also important to note that the parameters of any call of a
  macro defined by defabbrev will, as is the case for the parameters
  of a function call, be evaluated before the body is evaluated,
  since this is the evaluation order of [let]. This may lead to some
  errors or unexpected inefficiencies during evaluation if the body
  contains any conditionally evaluted forms like cond, case, or if.
  Consider the following example.

    (defabbrev foo (x y)
      (if (test x) (bar y) nil))

  Notice a typical one-step expansion of a call of foo (see [trans1]):

    ACL2 !>:trans1 (foo expr1 expr2)
     (LET ((X EXPR1) (Y EXPR2))
          (IF (TEST X) (BAR Y) NIL))
    ACL2 !>

  Now imagine that expr2 is a complicated expression whose evaluation
  is intended only when the predicate test holds of expr1. The
  expansion above suggests that expr2 will always be evaluated by the
  call (foo expr1 expr2), which may be inefficient (since perhaps we
  only need that value when test is true of expr1). The evaluation of
  expr2 may even cause an error, for example in :[program] mode if
  the expression expr2 has been constructed in a manner that could
  cause a guard violation unless test holds of expr1.")
 (DEFABSSTOBJ
  (EVENTS STOBJ)
  "Define a new abstract single-threaded object

  We assume familiarity with single-threaded objects; see [stobj] and
  see [defstobj]. The event defabsstobj defines a so-called
  ``abstract stobj'', a notion we introduce briefly now and then
  explain in more depth below.

  The evaluation of a [defstobj] event produces logical definitions for
  several functions: a recognizer, which characterizes the [stobj] in
  terms of lists; a creator, which produces an initial suitable list
  structure; and field accessors and updators, defined in terms of
  [nth] and [update-nth]. Defabsstobj provides a way to define
  alternate definitions for ``stobj primitives'' for a corresponding
  single-threaded object. These stobj primitives include a
  recognizer, a creator, and other ``exported'' functions. In
  essence, defabsstobj establishes interface functions, or
  ``exports'', on a new stobj that is a copy of an indicated
  ``concrete'' stobj that already exists.

  We begin below with an introduction to abstract [stobj]s. We then
  explain the [defabsstobj] event by way of an example. We conclude
  by giving summary documentation for the defabsstobj event.

  For another introduction to abstract stobjs, see the paper ``Abstract
  Stobjs and Their Application to ISA Modeling'' by Shilpi Goel,
  Warren A. Hunt, Jr., and Matt Kaufmann, in the proceedings of ACL2
  Workshop 2013.

  INTRODUCTION

  We start with a brief review of [stobj]s and some potential problems
  with them, followed by an introduction to abstract stobjs and how
  they can avoid these problems. Prior experience with stobjs will
  probably help the reader to absorb the ideas below.

  Recall that single-threaded objects, or [stobj]s, provide a way for
  ACL2 users to stay within the ACL2 logic, where every data object
  is an atom or a [cons] of data objects, while obtaining the
  benefits of fast evaluation through destructive updates. Consider
  for example this very simple event.

    (defstobj st fld)

  This event introduces a recognizer, stp, and a creator, create-st,
  for a data structure consisting of a single field accessed and
  updated by functions fld and update-fld, respectively. Each of
  these four primitive functions has both a logical definition, which
  is used when the prover reasons about the function, and an
  executable definition, which is used in raw Lisp. In the logic, stp
  recognizes objects that have the requisite fields. In raw Lisp,
  there is a ``live stobj'', which is an array object whose fields
  correspond to those specified by the [defstobj] event, implemented
  as Lisp arrays.

  Here are the logical definition and the executable definition,
  respectively, that are introduced for the field accessor, fld,
  introduced above. Notice that since a stobj is represented in raw
  Lisp using an array, the raw Lisp accessor uses a raw Lisp array
  accessor, svref. (You can see all the logical and executable
  definitions by evaluating the form (trace$ defstobj-axiomatic-defs
  defstobj-raw-defs) before evaluating the [defstobj] form.)

    ; logical definition
    (defun fld (st)
      (declare (xargs :guard (stp st)
                      :verify-guards t))
      (nth 0 st))

    ; executable (raw Lisp) definition
    (defun fld (st)
      (svref st 0))

  Sophisticated programming with stobjs can provide efficient
  implementations of algorithms, but may require the preservation of
  a complex invariant. One can, of course, define a function to
  implement such an invariant after introducing the stobj, as
  follows.

    ; Introduce a stobj.
    (defstobj st fld1 ... fldk)

    ; Define an invariant on that stobj.
    (defun good-stp (st)
      (declare (xargs :stobjs st))
      ...)

    ; Define some basic functions that update the stobj and preserve the
    ; invariant.
    (defun update-st (... st ...)
      (declare (xargs :stobjs st
                      :guard (and (good-stp st) ...)))
      ...)
    ...

    ; Prove that the invariant is indeed preserved by those basic functions.
    (defthm good-stp-update-st
      (implies (and (good-stp st)
                    ...)
               (good-stp (update-st ... st ...))))
    ...

    ; Implement algorithms built on the basic functions.
    (defun foo (... st ...)
      (declare (xargs :stobjs st
                      :guard (and (good-stp st) ...)))
      ... (update-st ... st ...) ...)

    ; Prove invariance theorems about these algorithms.
    (defthm good-stp-foo
      (implies (and (good-stp st)
                    ...)
               (good-stp (foo ... st ...))))
    ...

    ; Prove other properties of these algorithms.
    (defthm foo-is-correct
      (implies (and (good-stp st)
                    ...)
               (some-property (foo ... st ...))))
    ...

  But there are at least two potential difficulties in using stobjs as
  described above.

      1. When foo is executed on concrete data in the ACL2 loop, the guard
      check may be expensive because (good-stp st) is expensive.

      2. Reasoning about foo (using rules like foo-is-correct above)
      involves proving hypotheses of invariance theorems, which may
      be complicated for the user to manage or slow for the theorem
      prover.

  The defabsstobj event offers an opportunity to address these issues.
  It introduces a new stobj, which we call an ``abstract stobj'',
  which is associated with a corresponding ``concrete stobj''
  introduced by an earlier [defstobj] event. The defabsstobj event
  specifies a logical (:LOGIC) and an executable (:EXEC) definition
  for each primitive operation, or ``stobj primitive'', involving
  that stobj. As is the case for [defstobj], the logical definition
  is what ACL2 reasons about, and is appropriate to apply to an ACL2
  object satisfying the logical definition of the recognizer function
  for the stobj. The executable definition is applied in raw Lisp to
  a live stobj, which is an array object associated with the given
  stobj name.

  We can picture a sequence of updates to corresponding abstract and
  concrete stobjs as follows. Initially in this picture, st$a0 and
  st$c0 are a corresponding abstract and concrete stobj
  (respectively). Then an update, u1, is applied with :LOGIC and
  :EXEC functions u$a1 and u$c1, respectively. The resulting abstract
  and concrete stobj, st$a1 and st$c1, correspond as before. Then a
  second update, u2, is applied with :LOGIC and :EXEC functions u$a2
  and u$c2, respectively --- again preserving the correspondence. And
  so on.

    Abstract               u$a1       u$a2       u$a3
    (:logic)         st$a0  --> st$a1  --> st$a2  -->   ...

                       ^          ^          ^               ^
    Correspondence     |          |          |          ...  |
                       v          v          v               v

                           u$c1       u$c2       u$c3
    Concrete         st$c0  --> st$c1  --> st$c2  -->   ...
    (:exec)

  We conclude this introduction with some remarks about implementation.
  Consider an abstract stobj st with corresponding concrete stobj
  st$c. The live stobjs for st and st$c have the same structure, but
  are distinct arrays. Indeed, the raw Lisp creator function for st$c
  is called to create a new initial live stobj for st. As we will see
  below, reads and writes in raw Lisp to the live stobj for st are
  ultimately performed using the primitive accessors and updaters
  defined for st$c. One might think of the live stobjs for st and
  st$c as being congruent stobjs (see [defstobj]), except that the
  stobjs themselves are not congruent: the stobj primitives
  introduced for st may be applied to st but not arbitrary field
  updaters of st$c, for example. As one might expect, the :EXEC
  function for an exported function is applied to the live stobj for
  st in raw Lisp.

  EXAMPLE

  We present examples, with detailed comments intended to explain
  abstract stobjs, in two community books:
  books/misc/defabsstobj-example-1.lisp and
  books/misc/defabsstobj-example-2.lisp. In this section we outline
  the first of these. We suggest that after you finish this
  [documentation] topic, you read through those two books.

  Here is the first of two closely related defabsstobj [events] from
  the book defabsstobj-example-1.lisp, but in expanded form. We will
  show the abbreviated form later, which omits most of data in the
  form that is immediately below. Thus most of the information shown
  here is default information. We believe that the comments below
  explain most or all of what you need to know in order to start
  using defabsstobj, and that you will learn the remainder when you
  see error messages. For example, we do not say in the comments
  below that every :LOGIC and :EXEC function must be
  [guard]-verified, but that is indeed a requirement.

    (defabsstobj st ; The new abstract stobj is named st.

    ; The concrete stobj corresponding to st is st$c:

      :concrete st$c

    ; The recognizer for the new abstract stobj is stp, which is defined to be
    ; st$ap in the logic, and is executed on the live stobj in raw Lisp using
    ; st$cp.

      :recognizer (stp :logic st$ap :exec st$cp)

    ; The initial stobj is defined as create-st (a function of no arguments),
    ; which is defined logically as create-st$a, though create-st$c is invoked to
    ; create the initial live stobj for st.  The :correspondence and :preserved
    ; keywords refer to proof obligations, discussed below.

      :creator (create-st :logic create-st$a :exec create-st$c
                          :correspondence create-st{correspondence}
                          :preserved create-st{preserved})

    ; Proof obligations are generated that involve a correspondence between the
    ; new abstract stobj and corresponding concrete stobj.  The function
    ; st$corr, which need not be executable (see :DOC defun-nx), takes two
    ; arguments, a concrete stobj and an abstract stobj.  This function symbol is
    ; used in the statements of the proof obligations.

      :corr-fn st$corr

    ; In this example we have four exports.  In each case a new function is
    ; introduced that has the same signature as its :EXEC function, except that
    ; st$c is replaced by st.  The :LOGIC and :EXEC functions are as specified,
    ; and the other keywords refer to proof obligations that we discuss below.

      :exports ((lookup :logic lookup$a
                        :exec mem$ci
                        :correspondence lookup{correspondence}
                        :guard-thm lookup{guard-thm})
                (update :logic update$a
                        :exec update-mem$ci
                        :correspondence update{correspondence}
                        :preserved update{preserved}
                        :guard-thm update{guard-thm})
                (misc :logic misc$a
                      :exec misc$c
                      :correspondence misc{correspondence})
                (update-misc :logic update-misc$a
                             :exec update-misc$c
                             :correspondence update-misc{correspondence}
                             :preserved update-misc{preserved}))
      :doc nil)

  Note that all stobj primitives (recognizer, creator, and exported
  functions) are defined in the ACL2 loop in terms of their :LOGIC
  functions and in raw Lisp in terms of their :EXEC functions. In the
  ACL2 loop, a [defun] form defines a function, while in raw Lisp, a
  [defmacro] form defines a macro (for efficiency). We first
  illustrate how that works for the recognizer. (You can see all the
  logical and executable definitions by evaluating the form (trace$
  defabsstobj-axiomatic-defs defabsstobj-raw-defs) before evaluating
  the [defstobj] form.)

    ; In the ACL2 loop:
    (defun stp (st)
      (declare (xargs :guard 't))
      (st$ap st))

    ; In raw Lisp:
    (defmacro stp (&rest args) (cons 'st$cp args))

  The definitions are made similarly for exported functions, with
  [guard]s derived from their :LOGIC functions as follows. Consider
  the exported function update in our example. Its :LOGIC function,
  update$a, has formals (k val st$a) and the following guard.

    (and (and (integerp k) (<= 0 k) (<= k 49))
         (and (integerp val) (<= 0 val))
         (st$ap st$a)
         (mem$c-entryp val))

  The formals of update are obtained by starting with the formals of
  its :EXEC function, update-mem$ci --- which are (i v st$c) --- and
  replacing the concrete stobj name st$c by the new stobj name st.
  The formals of update are thus (i v st). The guard for update is
  obtained in two steps. The first step is to substitute the formals
  of update for the formals of update$a in the guard for update$a, to
  obtain the following.

    (and (and (integerp i) (<= 0 i) (<= i 49))
         (and (integerp v) (<= 0 v))
         (st$ap st)
         (mem$c-entryp v))

  The second step is to replace, for each new stobj primitive p, the
  :LOGIC function for p by p itself. The only :LOGIC function
  occurring in the formula just above is st$ap, which is the :LOGIC
  funcction for stp. The guard for update is thus as follows.

    (and (and (integerp i) (<= 0 i) (<= i 49))
         (and (integerp v) (<= 0 v))
         (stp st)
         (mem$c-entryp v))

  We turn now to the proof obligations, as promised above. There are
  three types: :CORRESPONDENCE, :PRESERVED, and :GUARD-THM. All
  required lemmas may be printed simply by defining the necessary
  :LOGIC and :EXEC functions and then submitting the defabsstobj
  event. (To advanced users: also see [defabsstobj-missing-events]
  for a utility that returns the required formulas in translated
  form.) Although the defabsstobj event will fail if the required
  lemmas have not been proved, first it will print the [defthm] forms
  that must be admitted in order to complete submission of the
  defabsstobj event. (Note that although the those theorems are
  stated exactly in the form expected by the system, you are welcome
  to supply whatever :[rule-classes] you prefer, even though the
  system creates :rule-classes nil by default.)

  The detailed theory explaining the need for these lemmas may be found
  in a comment in ACL2 source file other-events.lisp, in a comment
  entitled ``Essay on the Correctness of Abstract Stobjs''. Here, we
  give an informal sense of the importance of these lemmas as we
  present examples of them. Fundamental is the notion of evaluation
  in the logic versus evaluation using live stobjs, where one
  imagines tracking the current value of each abstract stobj during
  each of these two evaluations.

  We start with the :CORRESPONDENCE lemmas. These guarantee that
  evaluation in the logic agrees with evaluation using live stobjs,
  in the sense that the only difference is between a logical stobj
  and a live stobj, where the two correspond in the sense of the
  function specified by :CORR-FN. We start with the :CREATOR function
  where the statement is quite simple, stating that the :CORR-FN
  holds initially.

    (defthm create-st{correspondence}
      (st$corr (create-st$c) (create-st$a)))

  For the exported functions, there are essentially two cases. If an
  exported function returns other than the new abstract stobj, then
  the theorem asserts the equality of the results of applying the
  :LOGIC and :EXEC functions for the exported function. Hypotheses
  include the :CORR-FN correspondence followed by the [guard] for the
  :LOGIC function, which is stated in terms of the formal parameters
  of the :EXEC function except using the abstract stobj (here, st) in
  place of the concrete stobj (here, st$c). The conclusion uses the
  :EXEC formals, modified in the call of the :LOGIC function (here,
  lookup$a) to use the abstract stobj, as in the hypotheses.

    (defthm lookup{correspondence}
      (implies (and (st$corr st$c st)
                    (integerp i) (<= 0 i) (<= i 49)
                    (st$ap st))
               (equal (mem$ci i st$c)
                      (lookup$a i st)))
      :rule-classes nil)

  By contrast, if the exported function returns the new abstract stobj,
  then the conclusion uses the correspondence function insted of
  EQUAL, as in the following.

    (defthm update{correspondence}
      (implies (and (st$corr st$c st)
                    (integerp i) (<= 0 i) (<= i 49)
                    (integerp v) (<= 0 v)
                    (st$ap st)
                    (mem$c-entryp v))
               (st$corr (update-mem$ci i v st$c)
                        (update$a i v st)))
      :rule-classes nil)

  For exported functions that return multiple values, such conclusions
  are conjoined together over the returned values.

  The :PRESERVED lemmas guarantee that updates to the abstract stobj
  preserve its recognizer. The fact that every exported function has
  this property provides justification for an optimization performed
  by ACL2 during generation of proof obligations for [guard]
  verification, by assuming that the recognizer always holds. The
  :PRESERVED lemma for the :CREATOR shows that the recognizer holds
  initially.

    (defthm create-st{preserved}
      (st$ap (create-st$a)))

  Here is a typical such lemma, for the exported function update. Note
  that there is no such lemma for lookup, since lookup does not
  return st.

    (defthm update{preserved}
      (implies (and (integerp i) (<= 0 i) (<= i 49)
                    (integerp v) (<= 0 v)
                    (st$ap st)
                    (mem$c-entryp v))
               (st$ap (update$a i v st))))

  Finally, we consider the :GUARD-THM lemmas. These serve to guarantee
  that the [guard] holds for each call of an :EXEC function. During
  guard verification, logical definitions are used; in particular,
  since each exported function is defined in the logic as the
  corresponding call of its :LOGIC function, guard verification shows
  that each call of the :LOGIC function for an exported function
  satisfies that function's guard. But why is this true for raw Lisp
  evaluation using live stobjs, where the :EXEC function is called
  for an exported function? The :GUARD-THM lemmas provide the answer,
  as they state that if the :LOGIC function's guard holds, then the
  :EXEC function's guard holds. Here is an example. Note that the
  hypotheses come from the correspondence of the concrete and
  abstract function as guaranteed by the :CORR function, together
  with the guard of the :LOGIC function; and the conclusion comes
  from the guard of the :EXEC function.

    (defthm lookup{guard-thm}
      (implies (and (st$corr st$c c)
                    (integerp i)
                    (<= 0 i)
                    (<= i 49)
                    (st$ap st))
               (and (integerp i)
                    (<= 0 i)
                    (< i (mem$c-length st$c))))
      :rule-classes nil)

  We conclude this EXAMPLE section by showing a short form for the
  defabsstobj form displayed above.

    (defabsstobj st
      :exports ((lookup :exec mem$ci)
                (update :exec update-mem$ci)
                misc update-misc))

  SUMMARY DOCUMENTATION

  The General Form is as shown below, where the order of keywords is
  unimportant. Duplicate keywords are discouraged; while permitted,
  only the first (leftmost) occurrence of a given keyword is used.
  Only the :exports keyword is required.

    (defabsstobj st
      :concrete concrete
      :recognizer recognizer
      :creator creator
      :corr-fn corr-fn
      :congruent-to congruent-to
      :protect-default protect-default
      :exports (e1 ... ek)
      :doc doc)

  The keyword argument :EXPORTS must be supplied, and missing or nil
  keyword arguments have defaults as indicated below. All arguments
  must satisfy the conditions below.

  Before we describe the arguments, we define a notion of a ``function
  spec'' and its ``completion''. A function spec is either a symbol
  or else a list of the form

    (fn :kwd1 val1 ... :kwdn valn),

  that is, a symbol followed by a [keyword-value-listp]. We view the
  case of a symbol, s, as the function spec (s), with no keywords.
  There must be no duplicate keywords. In each case that we expect a
  function spec, the context provides a set of valid keywords for
  that function spec; it is an error to provide any other keyword in
  the function spec. Each function spec is interpreted as its
  ``completion'', obtained by extending the function spec with a
  default value for each valid keyword as indicated below. With that
  interpretation, the ``exported function'' of a function spec is its
  car, and that function symbol and each keyword value must be a
  guard-verified function symbol; and moreover, the :EXEC function
  must not include the new abstract stobj name, st, among its
  formals.

  We are ready to describe the arguments of defabsstobj.

      St is a symbol, which names the new abstract stobj.

      Concrete is the name of an existing stobj that is not an abstract
      stobj, i.e., was introduced with [defstobj] (not
      [defabsstobj]).

      Recognizer is a function spec (for the recognizer function). The
      valid keywords are :LOGIC and :EXEC. The default for recognizer
      is obtained by adding the suffix \"P\" to name. The default value
      for :LOGIC is formed by adding the suffix \"$AP\" to recognizer;
      for :EXEC, by adding the suffix \"$CP\". The :EXEC function must
      be the recognizer for the specified :CONCRETE stobj.

      Creator is a function spec (for the creator function). The valid
      keywords are :LOGIC and :EXEC. The default for creator is
      obtained by adding the prefix \"CREATE-\" to name. The default
      value for :LOGIC is formed by adding the suffix \"$A\" to
      creator; for :EXEC, by adding the suffix \"$C\". The :CREATOR
      function must be the creator for the specified :CONCRETE stobj,
      as ACL2 checks that the :CREATOR function takes no arguments
      and returns the :CONCRETE stobj.

      Corr-fn is a known function symbol that takes two arguments (for the
      correspondence theorems). The default for corr-fn is obtained
      by adding the suffix \"$CORR\" to name.

      Congruent-to should either be nil (the default) or the name of an
      abstract stobj previously introduced (by [defabsstobj]). In the
      latter case, the current and previous abstract stobj should
      have the same concrete stobj (not merely congruent concrete
      stobjs), and their :EXPORTS fields should have the same length
      and also correspond, as follows: the ith export of each should
      have the same :LOGIC and :EXEC symbols. See [defstobj] for more
      about congruent stobjs. Note that if two names are congruent,
      then they are either both ordinary stobjs or both abstract
      stobjs.

      Protect-default should either be nil (the default) or t. It provides
      the value of keyword :PROTECT for each member of exports that
      does not explicitly specify :PROTECT. See the discussion of
      exports below.

      An important aspect of the congruent-to parameter is that if it is
      not nil, then the checks for lemmas --- {CORRESPONDENCE},
      {GUARD-THM}, and {PRESERVED} --- are omitted. Thus, the values
      of keyword :CORR-FN, and the values of keywords
      :CORRESPONDENCE, :GUARD-THM, and :PRESERVED in each export (as
      we discuss next), are irrelevant; they are not inferred and
      they need not be supplied.

      The value of :EXPORTS is a non-empty true list. Each ei is a function
      spec (for an exported function). The valid keywords are :LOGIC,
      :EXEC, :CORRESPONDENCE, and :GUARD-THM, :PROTECT, and also
      :PRESERVED if and only if the specified :EXEC function returns
      the :CONCRETE stobj. The default values for all of these
      keywords except :PROTECT are obtained by respectively adding
      the suffix \"$A\" \"$C\", \"{CORRESPONDENCE}\", \"{GUARD-THM}\", or
      \"{PRESERVED}\". For :PROTECT, the default is nil unless the
      defabsstobj event specifies :PROTECT-DEFAULT t.

      Doc, if non-nil, is a [documentation] string (see [doc-string]).

  Not shown is the keyword, :MISSING; the effect of :missing t is to
  turn the call of defabsstobj into a corresponding call of
  [defabsstobj-missing-events].

  Note that a defabsstobj event will fail if the required lemmas ---
  that is, those for valid keywords :CORRESPONDENCE, :GUARD-THM, and
  :PRESERVED --- have not been proved, unless proofs are being
  skipped. The exemption when skipping proofs allows the supporting
  lemmas to be [local] to [books] and [encapsulate] [events]. If the
  [ld] special [ld-skip-proofsp] is t, then the missing [events] are
  printed with a warning before the defabsstobj event is admitted;
  but if ld-skip-proofsp is the symbol INCLUDE-BOOK, then that
  warning is omitted. (Also see [skip-proofs] and see
  [ld-skip-proofsp].) If however proofs are not being skipped, then
  the defabsstobj event will fail after printing the missing events.
  Advanced users may wish to see [defabsstobj-missing-events] for a
  utility that returns a data structure containing the missing
  lemmas.

  Let st be an abstract stobj with corresponding concrete stobj st$c.
  let f be an exported function for st and let f$a and f$c be the
  corresponding :LOGIC and :EXEC functions, respectively. The formals
  of f are obtained by taking the formals of f$c and replacing st$c
  by st. The [guard] for f is derived as follows from the guard of
  f$a. First, the formals of f$a are replaced by the formals of f in
  the guard of f$a, to obtain a term we denote here as guard-pre. Now
  for each exported function symbol g of st with corresponding :LOGIC
  function g$a, form a functional substitution by consing g$a with g.
  Finally, apply that functional substitution to guard-pre; the
  result is the guard of f. That guard must satisfy the usual
  conditions of a guard: thus, it must return a single non-[stobj]
  value and satisfy normal syntactic restrictions, including
  single-threadedness in its handling of stobjs.

  Remark. Because of how guards are created for exported functions, and
  in particular because :LOGIC functions are replaced as discussed
  above, a good discipline is to define :LOGIC functions that are not
  intended for general use, but are intended only for use as :LOGIC
  functions of corresponding stobj primitives. For example, suppose
  that you use length as the :LOGIC function for some stobj
  primitive, f (as opposed to using your own function, say,
  foo-length or foo$a). Then every call of length will be replaced by
  f when creating the guard of a stobj primitive from the guard of
  its :LOGIC function. This might not be what you intended if you
  were using length in that guard simply to compute the length of an
  ordinary list.

  There are a few additional restrictions, as follows.

      All exported function names must be new (unless redefinition is on;
      see [ld-redefinition-action]), and there must be no duplicates
      among them.

      The :CONCRETE stobj name must be a formal parameter of the :EXEC fn
      of every function spec, except for the :CREATOR function spec.
      Also the input signatures of the :LOGIC and :EXEC function for
      a function spec must agree, except perhaps at the position of
      that :CONCRETE formal.

      For function specs other than the :CREATOR function spec, the output
      signatures of the :LOGIC and :EXEC functions must have the same
      length and must agree, except perhaps at position p_out of the
      :CONCRETE stobj in the :EXEC function's output. If p_in is the
      position of the :CONCRETE stobj in the :EXEC function's
      formals, then the :LOGIC function's output at position p_out
      should match the :LOGIC function's formal at position p_in.

      The :PROTECT keyword is something that you should ignore unless you
      get an error message about it, pertaining to modifying the
      concrete stobj non-atomically. In that case, you can eliminate
      the error by providing :PROTECT t in the function spec, or by
      providing defabsstobj keyword argument :PROTECT-DEFAULT t at
      the top level. The above explanation is probably all you need
      to know about :PROTECT, but just below is a more complete
      explanation for those who desire it. Further information is
      also available if you need it; see [set-absstobj-debug], and
      see the example uses of these keywords in community book
      books/misc/defabsstobj-example-2.lisp.

  For those who are interested, here is a more detailed discussion of
  :PROTECT and :PROTECT-DEFAULT, as promised above. It applies to any
  function spec for an export (hence not to the :CREATOR function
  spec). If the :EXEC function is a stobj primitive, then clearly the
  following property holds: any execution of a call of that function
  can only update the concrete stobj at most once --- i.e.,
  modification of the concrete stobj is atomic. ACL2 can deduce this
  property not only for stobj primitives but for many other functions
  as well. However, if ACL2 cannot deduce this property, then it will
  cause an error saying that the :EXEC function ``appears capable of
  modifying the concrete stobj, <stobj_name>, non-atomically.'' That
  message also explains how to eliminate this error: provide :PROTECT
  t for the function spec. Alternatively, all function specs without
  an explicit :PROTECT keyword can be implicitly supplied :PROTECT t
  by supplying the value t for the :PROTECT-DEFAULT keyword parameter
  of the defabsstobj event. However, beware that when :PROTECT is t,
  the generated raw Lisp code runs slightly less efficiently ---
  though perhaps with negligible efficiency loss if the :EXEC
  function is not trivial. Community books
  books/misc/defabsstobj-example-3.lisp and
  books/misc/defabsstobj-example-4.lisp provide related information.

  We conclude with some remarks.

  Unlike [defstobj], there is no :renaming argument. Instead, the
  scheme described above provides a flexible way to assign names.

  Those who use the experimental extension ACL2(h), which includes
  function memoization (see [memoize]), may be aware that the memo
  table for a function is flushed whenever it is the case that one of
  its stobj inputs is updated. In fact, such flushing happens even
  when a stobj that is congruent to one of its stobj inputs is
  updated. For that purpose, an abstract stobj is considered to be
  congruent to its corresponding concrete stobj.")
 (DEFABSSTOBJ-MISSING-EVENTS
  (EVENTS)
  "Obtain the [events] needed to admit a [defabsstobj] event

  We assume familiarity with [defabsstobj]. Defabsstobj-missing-events
  is a macro is for advanced users (who, for example, understand the
  role of the translate and untranslate functions), who want
  programmatic access to the [defthm] events required to admit a
  specific defabsstobj event.

  This macro has the same syntax as [defabsstobj] --- to use it, just
  replace a call of [defabsstobj] by a call of
  defabsstobj-missing-events on the same arguments. The result is an
  error triple (mv erp val state). If erp is nil, then val is the
  list of all objects (name formula . old-formula), where a [defthm]
  event named name remains to be admitted whose translated formula is
  formula, and where old-formula is nil unless the indicated event
  already exists (hence with a different formula), in which case
  old-formula is the existing translated formula.

  To build a [defthm] event from the above value, val, we suggest
  evaluating a form like (untranslate formula t (w state)).")
 (DEFATTACH
  (EVENTS)
  "Execute constrained functions using corresponding attached functions

  This [documentation] topic is organized into the following sections:

  Introductory example.
  Syntax and semantics of defattach.
  Three primary uses of defattach.
  Miscellaneous remarks, with discussion of possible user errors.

  Please see [encapsulate] if you intend to use defattach but are not
  already familiar with the use of encapsulate to introduce
  constrained functions.

  See community book books/misc/defattach-example.lisp for a small
  example. it illustrates how defattach may be used to build
  something like ``higher-order'' programs, in which constrained
  functions may be refined to different executable functions. More
  uses of defattach may be found in the ACL2 source code,
  specifically, file boot-strap-pass-2.lisp.

  The argument :skip-checks t enables easy experimentation with
  defattach, by permitting use of :[program] mode functions and the
  skipping of semantic checks. Also permitted is :skip-checks nil
  (the default) and :skip-checks :cycles, which turns off only the
  update of the extended ancestor relation (see below) and hence the
  check for cycles in this relation; see below. We do not make any
  logical claims when the value of :skip-checks is non-nil; indeed, a
  trust tag is required in this case (see [defttag]). Remark for
  those who use the experimental HONS extension (see
  [hons-and-memoization]): the interaction of memoization and
  attachments is not tracked for attachments introduced with a
  non-nil value of :skip-checks. For more discussion of :skip-checks
  t, see [defproxy]; we do not discuss :skip-checks further, here.

  Introductory example.

  We begin with a short log illustrating the use of defattach. Notice
  that after evaluating the event (defattach f g), a call of the
  constrained function f is evaluated by instead calling g on the
  arguments.

    ACL2 !>(encapsulate
            ((f (x) t :guard (true-listp x)))
            (local (defun f (x) x))
            (defthm f-property
              (implies (consp x) (consp (f x)))))
    [... output omitted ...]
     T
    ACL2 !>(defun g (x)
             (declare (xargs :guard (or (consp x) (null x))))
             (cons 17 (car x)))
    [... output omitted ...]
     G
    ACL2 !>(f '(3 4)) ; undefined function error

    ACL2 Error in TOP-LEVEL:  ACL2 cannot ev the call of undefined function
    F on argument list:

    ((3 4))

    To debug see :DOC print-gv, see :DOC trace, and see :DOC wet.

    ACL2 !>(defattach f g)
    [... output omitted ...]
     :ATTACHMENTS-RECORDED
    ACL2 !>(f '(3 4)) ; f is evaluated using g
    (17 . 3)
    ACL2 !>(trace$ f g)
     ((F) (G))
    ACL2 !>(f '(3 4)) ; f is evaluated using g
    1> (ACL2_*1*_ACL2::F (3 4))
      2> (ACL2_*1*_ACL2::G (3 4))
        3> (G (3 4))
        <3 (G (17 . 3))
      <2 (ACL2_*1*_ACL2::G (17 . 3))
    <1 (ACL2_*1*_ACL2::F (17 . 3))
    (17 . 3)
    ACL2 !>(defattach f nil) ; unattach f (remove its attachment)
    [... output omitted ...]
     :ATTACHMENTS-RECORDED
    ACL2 !>(f '(3 4)) ; undefined function error once again
    1> (ACL2_*1*_ACL2::F (3 4))

    ACL2 Error in TOP-LEVEL:  ACL2 cannot ev the call of undefined function
    F on argument list:

    ((3 4))

    To debug see :DOC print-gv, see :DOC trace, and see :DOC wet.

    ACL2 !>

  Syntax and semantics of defattach.

  The log above shows that the event (defattach f g) allows g to be
  used for evaluating calls of f. From a logical perspective, the
  evaluation takes place in the addition to the current session of an
  ``attachment equation'' axiom (universally quantified over all x)
  for each defattach event:

    (equal (f x) (g x)) ;;; attachment equation axiom for (defattach f g)

  Below we explain defattach in some detail. But it is important to
  keep in mind that evaluation with the attachment equations takes
  place in an extension of the logical theory of the session. ACL2
  guarantees that this so-called ``evaluation theory'' remains
  consistent, assuming the absence of [defaxiom] [events] from the
  user. This guarantee is a consequence of a more general guarantee:
  an ACL2 logical [world] exists in which (loosely speaking) the
  attachment equation for (defattach f g), as (defun f (...) (g
  ...)), takes the place of the original defining event for f, for
  each defattach event. This more general guarantee holds even if
  there are [defaxiom] events, though as explained below, no function
  symbol that syntactically supports a defaxiom formula is allowed to
  get an attachment. A deeper discussion of the logical issues is
  available (but not intended to be read by most users) in a long
  comment in the ACL2 source code labeled ``Essay on Defattach.''

    Example Forms:
    (defattach f g)   ; call g in place of calling constrained function f
    (defattach (f g)) ; same as just above
    (defattach (f g :hints ((\"Goal\" :in-theory (enable foo)))))
                      ; equivalent to first form above, except with hints for the
                      ; proof that the guard of f implies the guard of g
    (defattach (f g :hints ((\"Goal\" :in-theory (enable foo)))
                    :otf-flg t))
                      ; as above, except with an :otf-flg of t for the proof that
                      ; the guard of f implies the guard of g
    (defattach (f g)
               :hints ((\"Goal\" :use my-thm)))
                      ; equivalent to first form above, except with hints for the
                      ; proof that the constraints on f hold for g
    (defattach (f g)
               :hints ((\"Goal\" :use my-thm))
               :otf-flg t)
                      ; as above, except with an :otf-flg of t for the proof that
                      ; the constraints on f hold for g
    (defattach (f g)
               (h j)) ; Attach g to f and attach j to h
    (defattach (f g :attach nil)
               (h j)) ; Same as just above, including the same proof obligations,
                      ; except for one difference: because of :attach nil, calls
                      ; of f will not be evaluated, i.e., there will be no
                      ; executable attachment of g to f
    (defattach (f nil)
               (h j)) ; Attach j to h and unattach f
    (defattach (f g :hints ((\"Goal\" :in-theory (enable foo))))
               (h j :hints ((\"Goal\" :in-theory (enable bar))))
               :hints ((\"Goal\" :use my-thm)))
                      ; Attach g to f and attach j to h, with hints:
                      ; - For proving that the guard of f implies the guard of g,
                      ;   enable foo;
                      ; - For proving that the guard of h implies the guard of j,
                      ;   enable bar; and
                      ; - For proving that the constraints on f and h hold for
                      ;   g and j (respectively), use theorem my-thm.

    (defattach f nil)   ; remove the attachment of f, if any (e.g., g above)
    (defattach (f nil)) ; same as just above

    General Forms:
    (defattach f g)   ; single attach or, if g is nil, unattach
    (defattach (f1 g1 :kwd val ...)
               ...
               (fk gk :kwd' val' ...)
               :kwd'' val'' ...)

  where each indicated keyword-value pair is optional and each keyword
  is one of :ATTACH, :HINTS, :OTF-FLG, or :INSTRUCTIONS. The value of
  each :ATTACH keyword is either t or nil, with default t except that
  the value of :ATTACH at the ``top level,'' after each entry (fi gi
  ...), is the default for each :ATTACH keyword supplied in such an
  entry. We discuss the :ATTACH keyword later in this [documentation]
  topic. The associated values for the other keywords have the usual
  meanings for the proof obligations described below: the guard proof
  obligation for keywords within each (fi gi ...) entry, and the
  constraint proof obligation for keywords at the top level. No
  keyword may occur twice in the same context, i.e., within the same
  (fi gi ...) entry or at the top level; and :INSTRUCTIONS may not
  occur in the same context with :HINTS or :OTF-FLG.

  The first General Form above is simply an abbreviation for the form
  (defattach (f g)), which is an instance of the second General Form
  above. For the second General Form we say that gi is ``attached
  to'' fi (by the defattach event) if gi is not nil, and otherwise we
  say that fi is ``unattached'' (by the defattach event). It is also
  convenient to refer to <fi,gi> as an ``attachment pair'' (of the
  event) if gi is not nil. We may refer to the set of fi as the
  ``attachment nest'' of each fi.

  We start with a brief introduction to the first General Form in the
  case that g is not nil. This form arranges that during evaluation,
  with exceptions noted below, every call of the constrained function
  symbol f will in essence be replaced by a call of the function
  symbol g on the same arguments. We may then refer to g as the
  ``attachment of'' f, or say that ``g is attached to f.'' Notable
  exceptions, where we do not use attachments during evaluation, are
  for macroexpansion, evaluation of [defconst] and [defpkg] terms,
  evaluation during [table] events, some [stobj] operations including
  all [updates], and especially evaluation of ground terms (terms
  without free variables) during proofs. However, even for these
  cases we allow the use of attachments in the first argument of
  [prog2$] and, more generally, the next-to-last (i.e., second)
  argument of [return-last] when its first argument is not of the
  form 'm for some macro, m.

  To see why attachments are disallowed during evaluation of ground
  terms during proofs (except for the [prog2$] and [return-last]
  cases mentioned above), consider the following example.

    (defstub f (x) t)
    (defun g (x) (+ 3 x))
    (defattach f g)

  If the form (f 2) is submitted at the ACL2 prompt, the result will be
  5 because the attachment g of f is called on the argument, 2.
  However, during a proof the term (f 2) will not be simplified to 5,
  since that would be unsound, as there are no axioms about f that
  would justify such a simplification.

  For the case that g is nil in the first General Form above, the
  result is the removal of the existing attachment to f, if any.
  After this removal, calls of f will once again cause errors saying
  that ``ACL2 cannot ev the call of undefined function f ...''. In
  this case not only is the previous attachment to f removed;
  moreover, for every function symbol f' in the attachment nest of f
  in the defattach event that introduced the existing attachment to
  f, then f' is unattached. (An example near the end of this
  [documentation] topic shows why this unattachment needs to be
  done.) Such removal takes place before the current defattach is
  processed, but is restored if the new event fails to be admitted.

  We focus henceforth on the second General Form. There must be at
  least one attachment, i.e., i must be at least 1. All keywords are
  optional; their role is described below. The fi must be distinct
  constrained function symbols, that is, function symbols all
  introduced in [signature]s of [encapsulate] [events] (or macros
  such as [defstub] that generate [encapsulate] events). Each non-nil
  gi is a :[logic]-mode function symbol that has had its guards
  verified, with the same [signature] as fi (though formal parameters
  for fi and gi may have different names). (Note: The macro
  defattach!, defined in community book books/misc/defattach-bang,
  avoids this restriction.) This event generates proof obligations
  and an ordering check, both described below. The effect of this
  event is first to remove any existing attachments for all the
  function symbols fi, as described above for the first General Form,
  and then to attach each gi to fi.

  Proof obligations must be checked before making attachments. For this
  discussion we assume that each gi is non-nil (otherwise first
  remove all attachment pairs <fi,gi> for which gi is nil). Let s be
  the functional substitution mapping each fi to gi. For any term u,
  we write u\\s for the result of applying s to u; that is, u\\s is the
  ``functional instance'' obtained by replacing each fi by gi in u.
  Let G_fi and G_gi be the guards of fi and gi, respectively. Let
  G_fi' be the result of replacing each formal of fi by the
  corresponding formal of gi in G_fi. ACL2 first proves, for each i
  (in order), the formula (implies G_fi' G_gi)\\s. If this sequence of
  proofs succeeds, then the remaining formula to prove is the
  functional instance C\\s of the conjunction C of the constraints on
  the symbols fi; see [constraint]. This last proof obligation is
  thus similar to the one generated by functional instantiation (see
  [constraint]). As with functional instantiation, ACL2 stores the
  fact that such proofs have been done so that they are avoided in
  future events (see [lemma-instance]). Thus, you will likely avoid
  some proofs with the sequence

    (defattach f g)
    (defattach f nil)
    (defattach f g)
    (defattach f nil)
    ...

  rather than the sequence:

    (defattach f g)
    :u
    (defattach f g)
    :u
    ...

  It remains to describe an ordering check. We begin with the following
  motivating example.

    (defstub f (x) t) ; constrained function with no constraints
    (defun g (x) (declare (xargs :guard t)) (not (f x)))
    (defattach f g) ; ILLEGAL!

  Were the above defattach event to succeed, the evaluation theory
  (discussed above) would be inconsistent: (f x) equals (g x) by the
  new attachment equation, which in turn equals (not (f x)) by
  definition of g. The evaluation would therefore be meaningless.
  Also, from a practical perspective, there would be an infinite loop
  resulting from any call of f.

  We consider a function symbol g to be an ``extended immediate
  ancestor of'' a function symbol f if either of the following two
  criteria is met: (a) g occurs in the formula that introduces f
  (i.e., definition body or constraint) and g is introduced by an
  event different from (earlier than) the event introducing f; or (b)
  g is attached to f. For a proposed defattach event, we check that
  this relation has no cycles, where for condition (b) we include all
  attachment pairs that would result, including those remaining from
  earlier defattach events.

  Of course, a special case is that no function symbol may be attached
  to itself. Similarly, no function symbol may be attached to any of
  its ``siblings'' --- function symbols introduced by the same event
  --- as siblings are considered equivalent for purposes of the
  acyclicity check.

  Three primary uses of defattach.

  We anticipate three uses of defattach:

  (1) Constrained function execution

  (2) Sound modification of the ACL2 system

  (3) Program refinement

  We discuss these in turn.

  (1) The example at the beginning of this [documentation] illustrates
  constrained function execution.

  (2) ACL2 is written essentially in itself. Thus, there is an
  opportunity to attaching to system functions. For example,
  encapsulated function too-many-ifs-post-rewrite, in the ACL2 source
  code, receives an attachment of too-many-ifs-post-rewrite-builtin,
  which implements a heuristic used in the rewriter. To find all such
  examples, search the source code for the string `-builtin'.

  Over time, we expect to continue replacing ACL2 source code in a
  similar manner. We invite the ACL2 community to assist in this
  ``open architecture'' enterprise; feel free to email the ACL2
  implementors if you are interested in such activity.

  (3) Recall that for an attachment pair <f,g>, a proof obligation is
  (speaking informally) that g satisfies the constraint on f. Yet
  more informally speaking, g is ``more defined'' than f; we can
  think of g as ``refining'' f. With these informal notions as
  motivation, we can view defattach as providing refinement though
  the following formal observation: the evaluation theory extends the
  theory of the ACL2 session, specifically by the addition of all
  attachment equations. For the logic-inclined, it may be useful to
  think model-theoretically: The class of models of the evaluation
  theory is non-empty but is a subset of the class of models of the
  current session theory.

  Miscellaneous remarks, with discussion of possible user errors.

  We conclude with remarks on some details.

  A defattach event is never redundant (see [redundant-events]); in
  that sense it is analogous to [in-theory].

  As mentioned above, the use of attachments is disabled for evaluation
  of ground terms during proofs. However, attachments can be used on
  code during the proof process, essentially when the ``program
  refinement'' is on theorem prover code rather than on functions we
  are reasoning about. The attachment to too-many-ifs-post-rewrite
  described above provides one example of such attachments. Meta
  functions and clause-processor functions can also have attachments,
  with the restriction that no common ancestor with the evaluator can
  have an attachment; see [evaluator-restrictions].

  For an attachment pair <f,g>, evaluation of f never consults the
  [guard] of f. Rather, control passes to g, whose guard is checked
  if necessary. The proof obligation related to guards, as described
  above, guarantees that any legal call of f is also a legal call of
  g. Thus for guard-verified code that results in calls of f in raw
  Lisp, it is sound to replace these calls with corresponding calls
  of g.

  Defattach events are illegal inside any [encapsulate] event with a
  non-empty [signature] unless they are [local] to the [encapsulate].

  We next discuss a restriction based on a notion of a function symbol
  syntactically supporting an event. Function symbol f is ancestral
  in event E if either f occurs in E, or (recursively) f occurs in an
  event E' that introduces some function symbol g that is ancestral
  in E. We require that no function symbol ancestral in the formula
  of a [defaxiom] event may have an attachment. Theoretical reasons
  are discussed in comments in the ACL2 source code, but here we give
  a little example showing the need for some such restriction:
  without it, we show how to prove nil!

    (defn g1 () 1)
    (defn g2 () 2)
    (defstub f1 () t)
    (defstub f2 () t)
    (defund p (x)
      (declare (ignore x))
      t)
    (defevaluator evl evl-list
      ((p x)))
    (defaxiom f1-is-f2
      (equal (f1) (f2)))
    (defun meta-fn (x)
      (cond ((equal (f1) (f2))
             x)
            (t *nil*)))
    (defthm bad-meta-rule
      (equal (evl x a)
             (evl (meta-fn x) a))
      :rule-classes ((:meta :trigger-fns (p))))
    (defattach f1 g1)
    (defattach f2 g2)
    (defthm contradiction
      nil
      :hints ((\"Goal\" :use ((:instance (:theorem (not (p x)))
                                       (x t)))))
      :rule-classes nil)

  To see all attachments: (all-attachments (w state)). (Note that
  attachments introduced with a non-nil value of :skip-checks will be
  omitted from this list.)

  Next we discuss the :ATTACH keyword. There is rarely if ever a reason
  to specify :ATTACH T, but the following (admittedly contrived)
  example shows why it may be necessary to specify :ATTACH NIL. First
  we introduce three new function symbols.

    (defstub f (x) t)

    (defun g (x)
      (f x))

    (encapsulate ((h (x) t))
      (local (defun h (x) (g x)))
      (defthm h-prop
        (equal (h x) (g x))))

  Now suppose we want to attach the function [ACL2-numberp] to both f
  and h.

    (defattach (f acl2-numberp) (h acl2-numberp))

  Such an attempt fails, because the following constraint is generated
  but is not a theorem: (EQUAL (ACL2-NUMBERP X) (G X)). Clearly we
  also need to attach to g as well.

    (defattach (f acl2-numberp) (h acl2-numberp) (g acl2-numberp))

  But this fails for a different reason, as explained by the error
  message:

    ACL2 Error in ( DEFATTACH (F ACL2-NUMBERP) ...):  It is illegal to
    attach to function symbol G, because it was introduced with DEFUN.
    See :DOC defattach.

  That is: logically, we need to attach acl2-numberp to g, but we
  cannot actually attach to g because it was introduced with [defun],
  not with [encapsulate]. So we specify :ATTACH NIL for the
  attachment to g, saying that no actual attachment should be made to
  the code for g, even though for logical purposes we should consider
  that g has been given the indicated attachment.

    (defattach (f acl2-numberp) (h acl2-numberp) (g acl2-numberp :attach nil))

  Finally, we can check that f, g, and h execute as expected.

    ACL2 !>(assert-event (and (f 3)
                       (not (f t))
                       (g 3)
                       (not (g t))
                       (h 3)
                       (not (h t))))
     :PASSED
    ACL2 !>

  We conclude with an example promised above, showing why it is
  necessary in general to unattach all function symbols in an
  existing attachment nest when unattaching any one of those function
  symbols. Consider the following example.

    (defstub f1 () t)
    (encapsulate ((f2 () t))
      (local (defun f2 () (f1)))
      (defthm f2=f1 (equal (f2) (f1))))
    (encapsulate ((f3 () t))
      (local (defun f3 () (f1)))
      (defthm f3=f1 (equal (f3) (f1))))
    (defun four () (declare (xargs :guard t)) 4)
    (defun five () (declare (xargs :guard t)) 5)
    (defattach (f1 four) (f2 four))
    (defattach (f1 five) (f3 five))

  The second defattach replaces erases the existing attachment pair
  <f1,four> before installing the new attachment pairs <f1,five> and
  <f3,five>. After the second defattach, both (f1) and (f3) evaluate
  to 5. Now suppose that the attachment pair <f2,four> were not
  erased. Then we would have (f1) evaluating to 5 and (f2) evaluating
  to 4, contradicting the constraint f2=f1. The evaluation theory
  would thus be inconsistent, and at a more concrete level, the user
  might well be surprised by evaluation results if the code were
  written with the assumption specified in the constraint f2=f1.")
 (DEFAULT
  (ARRAYS ACL2-BUILT-INS)
  "Return the :default from the [header] of a 1- or 2-dimensional array

    Example Form:
    (default 'delta1 a)

    General Form:
    (default name alist)

  where name is an arbitrary object and alist is a 1- or 2-dimensional
  array. This function returns the contents of the :default field of
  the [header] of alist. When [aref1] or [aref2] is used to obtain a
  value for an index (or index pair) not bound in alist, the default
  value is returned instead. Thus, the array alist may be thought of
  as having been initialized with the default value. default operates
  in virtually constant time if alist is the semantic value of name.
  See [arrays].

  Function: <default>

    (defun
         default (name l)
         (declare (xargs :guard (or (array1p name l) (array2p name l))))
         (cadr (assoc-keyword :default (cdr (header name l)))))")
 (DEFAULT-BACKCHAIN-LIMIT
  (MISCELLANEOUS)
  "Specifying the backchain limit for a rule

  See [backchain-limit].

  The initial value is (nil nil). To inspect the current value (as
  explained elsewhere; see [backchain-limit]):

    (default-backchain-limit wrld :ts) ; for type-set reasoning
    (default-backchain-limit wrld :rewrite) ; for rewriting")
 (DEFAULT-DEFUN-MODE
  (MISCELLANEOUS)
  "The default [defun-mode] of [defun]'d functions

  When a [defun] is processed and no :mode xarg is supplied, the
  function default-defun-mode is used. To find the default
  [defun-mode] of the current ACL2 [world], type (default-defun-mode
  (w state)). See [defun-mode] for a discussion of [defun-mode]s. To
  change the default [defun-mode] of the ACL2 [world], type one of
  the keywords :[program] or :[logic].

  The default ACL2 [prompt] displays the current default [defun-mode]
  by showing the character p for :[program] mode, and omitting it for
  :[logic] mode; see [default-print-prompt]. The default [defun-mode]
  may be changed using the keyword [command]s :[program] and
  :[logic], which are equivalent to the [command]s (program) and
  (logic). Each of these names is documented separately: see
  [program] and see [logic]. The default [defun-mode] is stored in
  the [table] [ACL2-defaults-table] and hence may also be changed by
  a [table] [command]. See [table] and also see
  [ACL2-defaults-table]. Both mode-changing [command]s are [events].

  While [events] that change the default [defun-mode] are permitted
  within an [encapsulate] or the text of a book, their effects are
  [local] in scope to the duration of the encapsulation or inclusion.
  For example, if the default [defun-mode] is :[logic] and a book is
  included that contains the event (program), then subsequent
  [events] within the book are processed with the default
  [defun-mode] :[program]; but when the [include-book] event
  completes, the default [defun-mode] will still be :[logic].
  [Command]s that change the default [defun-mode] are not permitted
  inside [local] forms.")
 (DEFAULT-HINTS
  (HINTS)
  "A list of hints added to every proof attempt

    Examples:
    ACL2 !>(default-hints (w state))
    ((computed-hint-1 clause)
     (computed-hint-2 clause stable-under-simplificationp))

  The value returned by this function is added to the right of the
  :[hints] argument of every [defthm] and [thm] command, and to hints
  provided to [defun]s as well (:hints, :guard-hints, and (for
  ACL2(r)) :std-hints).

  See [set-default-hints] for a more general discussion. Advanced users
  only: see [override-hints] for an advanced variant of default hints
  that are not superseded by :[hints] arguments.")
 (DEFAULT-HINTS-TABLE
  (SWITCHES-PARAMETERS-AND-MODES)
  "A [table] used to provide [hints] for proofs

  Please see [set-default-hints], see [add-default-hints], and see
  [remove-default-hints] for how to use this table. For completeness,
  we mention here that under the hood, these events all update the
  default-hints-table by updating its key, t, for example as follows.

    (table default-hints-table t
           '((computed-hint-1 clause)
             (computed-hint-2 clause
                              stable-under-simplificationp)))

  The use of default hints is explained elsewhere; see
  [set-default-hints].

  Advanced users only: see [override-hints] for an advanced variant of
  default hints.")
 (DEFAULT-PRINT-PROMPT
  (LD)
  "The default [prompt] printed by [ld]

    Example prompt:
    ACL2 p!s>

  The [prompt] printed by ACL2 displays the current package, followed
  by a space, followed by zero or more of the three [characters] as
  specified below, followed by the character [>] printed one or more
  times, reflecting the number of recursive calls of [ld]. The three
  [characters] in the middle are as follows:

    p     ; when (default-defun-mode (w state)) is :program
    !     ; when guard checking is on
    s     ; when (ld-skip-proofsp state) is t

  See [default-defun-mode], see [set-guard-checking], and see
  [ld-skip-proofsp].

  Also see [ld-prompt] to see how to install your own [prompt].

  Here are some examples with ld-skip-proofsp nil.

    ACL2 !>    ; logic mode with guard checking on
    ACL2 >     ; logic mode with guard checking off
    ACL2 p!>   ; program mode with guard checking on
    ACL2 p>    ; program mode with guard checking off

  Here are some examples with [default-defun-mode] of :[logic].

    ACL2 >     ; guard checking off, ld-skip-proofsp nil
    ACL2 s>    ; guard checking off, ld-skip-proofsp t
    ACL2 !>    ; guard checking on, ld-skip-proofsp nil
    ACL2 !s>   ; guard checking on, ld-skip-proofsp t

  Finally, here is the prompt in raw mode (see [set-raw-mode]),
  regardless of the settings above:

    ACL2 P>")
 (DEFAULT-RULER-EXTENDERS
  (MISCELLANEOUS)
  "The default [ruler-extenders] for [defun]'d functions

  When a [defun] is processed and no :ruler-extenders xarg is supplied,
  the function default-ruler-extenders is used to obtain the current
  ruler-extenders; see [ruler-extenders]. To find the default
  [ruler-extenders] of the current ACL2 [world], type
  (default-ruler-extenders (w state)).

  While [events] that change the default [ruler-extenders] are
  permitted within an [encapsulate] or the text of a book, their
  effects are [local] in scope to the duration of the encapsulation
  or inclusion. See [default-defun-mode] for an analogous discussion
  for defun-modes.")
 (DEFAULT-TOTAL-PARALLELISM-WORK-LIMIT
  (PARALLEL-PROOF)
  "For ACL2(p): returns the default value for global
  total-parallelism-work-limit

  See [set-total-parallelism-work-limit].")
 (DEFAULT-VERIFY-GUARDS-EAGERNESS (POINTERS)
                                  "See [set-verify-guards-eagerness].")
 (DEFAXIOM
  (EVENTS)
  "Add an axiom

  WARNING: We strongly recommend that you not add axioms. If at all
  possible you should use [defun] or [mutual-recursion] to define new
  concepts recursively or use [encapsulate] to constrain them
  constructively. If your goal is to defer a proof by using a
  top-down style, consider using [skip-proofs]; see the discussion on
  ``Top-Down Proof'' in Section B.1.2 of ``Computer-Aided Reasoning:
  An Approach.'' Adding new axioms frequently renders the logic
  inconsistent.

    Example:
    (defaxiom sbar (equal t nil)
              :rule-classes nil
              :doc \":Doc-Section ...\")

    General Form:
    (defaxiom name term
             :rule-classes rule-classes
             :doc          doc-string)

  where name is a new symbolic name (see [name]), term is a term
  intended to be a new axiom, and [rule-classes] and [doc-string] are
  as described in the corresponding [documentation] topics . The two
  keyword arguments are optional. If :[rule-classes] is not supplied,
  the list (:rewrite) is used; if you wish the axiom to generate no
  rules, specify :[rule-classes] nil.")
 (DEFCHOOSE
  (EVENTS)
  "Define a Skolem (witnessing) function

    Examples:
    (defchoose choose-x-for-p1-and-p2 (x) (y z)
      (and (p1 x y z)
           (p2 x y z)))

    (defchoose choose-x-for-p1-and-p2 x (y z) ; equivalent to the above
      (and (p1 x y z)
           (p2 x y z)))

    ; The following is as above, but strengthens the axiom added to pick a sort
    ; of canonical witness, as described below.
    (defchoose choose-x-for-p1-and-p2 x (y z)
      (and (p1 x y z)
           (p2 x y z))
      :strengthen t)

    (defchoose choose-x-and-y-for-p1-and-p2 (x y) (z)
      (and (p1 x y z)
           (p2 x y z)))

    General Form:
    (defchoose fn
               (bound-var1 ... bound-varn)
               (free-var1 ... free-vark)
               body
               :doc doc-string
               :strengthen b),

  where fn is the symbol you wish to define and is a new symbolic name
  (see [name]), (bound-var1 ... bound-varn) is a list of distinct
  `bound' variables (see below), (free-var1 ... free-vark) is the
  list of formal parameters of fn and is disjoint from the bound
  variables, and body is a term. The use of lambda-list keywords
  (such as &optional) is not allowed. The [documentation] string
  argument, :doc doc-string, is optional; for a description of the
  form of doc-string see [doc-string]. The :strengthen keyword
  argument is optional; if supplied, it must be t or nil.

  The system treats fn very much as though it were declared in the
  [signature] of an [encapsulate] event, with a single axiom exported
  as described below. If you supply a :use hint (see [hints]), :use
  fn, it will refer to that axiom. No rule (of class :[rewrite] or
  otherwise; see [rule-classes]) is created for fn.

  Defchoose is only executed in [defun-mode] :[logic]; see
  [defun-mode]. Also see [defun-sk].

  In the most common case, where there is only one bound variable, it
  is permissible to omit the enclosing parentheses on that variable.
  The effect is the same whether or not those parentheses are
  omitted. We describe this case first, where there is only one bound
  variable, and then address the other case. Both cases are discussed
  assuming :strengthen is nil, which is the default. We deal with the
  case :strengthen t at the end.

  The effect of the form

    (defchoose fn bound-var (free-var1 ... free-vark)
      body)

  is to introduce a new function symbol, fn, with formal parameters
  (free-var1 ... free-vark). Now consider the following axiom, which
  states that fn picks a value of bound-var so that the body will be
  true, if such a value exists:

    (1)   (implies body
                   (let ((bound-var (fn free-var1 ... free-vark)))
                     body))

  This axiom is ``clearly conservative'' under the conditions expressed
  above: the function fn simply picks out a ``witnessing'' value of
  bound-var if there is one. For a rigorous statement and proof of
  this conservativity claim, see [conservativity-of-defchoose].

  Next consider the case that there is more than one bound variable,
  i.e., there is more than one bound-var in the following.

    (defchoose fn
               (bound-var1 ... bound-varn)
               (free-var1 ... free-vark)
               body)

  Then fn returns a multiple value with n components, and formula (1)
  above is expressed using [mv-let] as follows:

    (implies body
             (mv-let (bound-var1 ... bound-varn)
                     (fn free-var1 ... free-vark)
                     body))

  We now discuss the case that :strengthen t is supplied. For
  simplicity we return to our simplest case, with defchoose applied
  to function fn, a single free variable y, and a single bound
  variable bound-var. The idea is that if we pick the ``smallest''
  witnessing bound-var for two different free variables y and y1,
  then either those two witnesses are the same, or else one is less
  than the other, in which case the smaller one is a witness for its
  free variable but not for the other. (See comments in source
  function defchoose-constraint-extra for more details.) Below, body1
  is the result of replacing y by y1 in body.

    (2)   (or (equal (fn y) (fn y1))
              (let ((bound-var (fn y)))
                (and body
                     (not body1)))
              (let ((bound-var (fn y1)))
                (and body1
                     (not body))))

  An important application of this additional axiom is to be able to
  define a ``fixing'' function that picks a canonical representative
  of each equivalence class, for a given equivalence relation. The
  following events illustrate this point.

    (encapsulate
     ((equiv (x y) t))
     (local (defun equiv (x y) (equal x y)))
     (defequiv equiv))

    (defchoose efix (x) (y)
      (equiv x y)
      :strengthen t)

    (defthm equiv-implies-equal-efix-1
      (implies (equiv y y1)
               (equal (efix y) (efix y1)))
      :hints ((\"Goal\" :use efix))
      :rule-classes (:congruence))

    (defthm efix-fixes
      (equiv (efix x) x)
      :hints ((\"Goal\" :use ((:instance efix (y x))))))

  If there is more than one bound variable, then (2) is modified in
  complete analogy to (1) to use [mv-let] in place of [let].

  Comment for logicians: As we point out in the documentation for
  [defun-sk], defchoose is ``appropriate,'' by which we mean that it
  is conservative, even in the presence of epsilon-0 induction. For a
  proof, See [conservativity-of-defchoose].


Subtopics

  [Conservativity-of-defchoose]
      Proof of conservativity of [defchoose]")
 (DEFCONG
  (EVENTS)
  "Prove [congruence] rule

  Defcong is used to prove that one [equivalence] relation preserves
  another in a given argument position of a given function.

    Example:
    (defcong set-equal iff (memb x y) 2)

    is an abbreviation for

    (defthm set-equal-implies-iff-memb-2
      (implies (set-equal y y-equiv)
               (iff (memb x y) (memb x y-equiv)))
      :rule-classes (:congruence))

  See [congruence] and also see [equivalence].

  NOTE: defcong may only be used to create classic [congruence] rules,
  not [patterned-congruence] rules.

    General Form:
    (defcong equiv1 equiv2 term k
      :rule-classes rule-classes
      :instructions instructions
      :hints hints
      :otf-flg otf-flg
      :event-name event-name
      :doc doc)

  where equiv1 and equiv2 are known [equivalence] relations; term is a
  call of a function fn, other than if, on the correct number of
  distinct variable arguments, (fn x1 ... xn); k is a positive
  integer less than or equal to the arity of fn; and other arguments
  are as specified in the documentation for [defthm]. The defcong
  macro expands into a call of [defthm]. The name of the [defthm]
  event is equiv1-implies-equiv2-fn-k unless an :event-name keyword
  argument is supplied for the name. The term of the theorem is

    (implies (equiv1 xk yk)
             (equiv2 (fn x1... xk ...xn)
                     (fn x1... yk ...xn))).

  The rule-class :[congruence] is added to the [rule-classes]
  specified, if it is not already there. All other arguments to the
  generated [defthm] form are as specified by the keyword arguments
  above.")
 (DEFCONST
  (EVENTS PROGRAMMING)
  "Define a constant

    Examples:
    (defconst *digits* '(0 1 2 3 4 5 6 7 8 9))
    (defconst *n-digits* (the unsigned-byte (length *digits*)))

    General Form:
    (defconst name term doc-string)

  where name is a symbol beginning and ending with the character *,
  term is a variable-free term that is evaluated to determine the
  value of the constant, and [doc-string] is an optional
  [documentation] string (see [doc-string]).

  When a constant symbol is used as a [term], ACL2 replaces it by its
  value; see [term].

  Note that defconst uses a ``safe mode'' to evaluate its form, in
  order to avoids soundness issues but with an efficiency penalty
  (perhaps increasing the evaluation time by several hundred
  percent). If efficiency is a concern, or if for some reason you
  need the form to be evaluated without safe mode (e.g., you are an
  advanced system hacker using trust tags to traffic in raw Lisp
  code), consider using [defconsts] instead. Also see
  [using-tables-efficiently] for an analogous issue with [table]
  events.

  It may be of interest to note that defconst is implemented at the
  lisp level using defparameter, as opposed to defconstant.
  (Implementation note: this is important for proper support of
  undoing and redefinition.)

  We close with a technical remark, perhaps of interest only to users
  of ACL2(h), the experimental extension of ACL2 that supports hash
  cons, function memoization, and hash-table-based ``fast alists'';
  see [hons-and-memoization]. For an event of the form (defconst *C*
  (quote OBJ)), i.e., (defconst *C* 'OBJ), then the value associated
  with *C* is OBJ; that is, the value of *C* is [eq] to the actual
  object OBJ occurring in the defconst form. So for example, if
  [make-event] is used to generate such a defconst event, as it is in
  the two books mentioned above, and OBJ is a fast alist (using
  ACL2(h)), then the value of *C* is a fast alist. This guarantee
  disappears if the term in the defconst form is not a quoted object,
  i.e., if it is not of the form (quote OBJ).")
 (DEFDOC
  (EVENTS)
  "Add a [documentation] topic

    Examples:
    (defdoc interp-section
       \":Doc-Section ...\")

    General Form:
    (defdoc name doc-string)

  where name is a symbol or string to be documented and [doc-string] is
  a [documentation] string (see [doc-string]). This event adds the
  [documentation] string for symbol name to the :[doc] database. It
  may also be used to change the [documentation] for name if name
  already has [documentation]. The difference between this event and
  [deflabel] is that, unlike [deflabel] (but like [table]), it does
  not mark the current [history] with the name. But like [deflabel],
  defdoc [events] are never considered redundant (see
  [redundant-events]).

  See [deflabel] for a means of attaching a [documentation] string to a
  name that marks the current [history] with that name. We now
  elaborate further on how defdoc may be useful in place of
  [deflabel].

  It is usually sufficient to use [deflabel] when you might be tempted
  to use defdoc. However, unlike [deflabel], defdoc does not mark the
  current [history] with name. Thus, defdoc is useful for introducing
  the [documentation] for a [defun] or [deftheory] event, for
  example, several [events] before the function or theory is actually
  defined.

  For example, suppose you want to define a theory (using [deftheory]).
  You need to prove the lemmas in that theory before executing the
  [deftheory] event. However, it is quite natural to define a
  :Doc-Section (see [doc-string]) whose name is the name of the
  theory to be defined, and put the [documentation] for that theory's
  lemmas into that :Doc-Section. Defdoc is ideal for this purpose,
  since it can be used to introduce the :Doc-Section, followed by the
  lemmas referring to that :Doc-Section, and finally concluded with a
  [deftheory] event of the same name. If [deflabel] were used instead
  of defdoc, for example, then the [deftheory] event would be
  disallowed because the name is already in use by the [deflabel]
  event.

  We also imagine that some users will want to use defdoc to insert the
  [documentation] for a function under development. This defdoc event
  would be followed by definitions of all the subroutines of that
  function, followed in turn by the function definition itself.

  Any time defdoc is used to attach [documentation] to an
  already-documented name, the name must not be attached to a new
  :Doc-Section. We make this requirement as a way of avoiding loops
  in the [documentation] tree. When [documentation] is redefined, a
  warning will be printed to the terminal.")
 (DEFEQUIV
  (EVENTS)
  "Prove that a function is an [equivalence] relation

    Example:
    (defequiv set-equal)

    is an abbreviation for
    (defthm set-equal-is-an-equivalence
      (and (booleanp (set-equal x y))
           (set-equal x x)
           (implies (set-equal x y) (set-equal y x))
           (implies (and (set-equal x y)
                         (set-equal y z))
                    (set-equal x z)))
      :rule-classes (:equivalence))

  See [equivalence].

    General Form:
    (defequiv fn
      :rule-classes rule-classes
      :instructions instructions
      :hints hints
      :otf-flg otf-flg
      :event-name event-name
      :doc doc)

  where fn is a function symbol of arity 2, event-name, if supplied, is
  a symbol, and all other arguments are as specified in the
  documentation for [defthm]. The defequiv macro expands into a call
  of defthm. The name of the defthm is fn-is-an-equivalence, unless
  event-name is supplied, in which case event-name is the name used.
  The term generated for the defthm event states that fn is Boolean,
  reflexive, symmetric, and transitive. The rule-class :equivalence
  is added to the [rule-classes] specified, if it is not already
  there. All other arguments to the generated defthm form are as
  specified by the other keyword arguments above.")
 (DEFEVALUATOR
  (EVENTS)
  "Introduce an evaluator function

    Example:
    (defevaluator evl evl-list
      ((length x) (member-equal x y)))

  See [meta].

    General Form:
    (defevaluator ev ev-list
       ((g1 x1 ... xn_1)
        ...
        (gk x1 ... xn_k))

  where ev and ev-list are new function symbols and g1, ..., gk are old
  function symbols with the indicated number of formals, i.e., each
  gi has n_i formals.

  This function provides a convenient way to constrain ev and ev-list
  to be mutually-recursive evaluator functions for the symbols g1,
  ..., gk. Roughly speaking, an evaluator function for a fixed,
  finite set of function symbols is a restriction of the universal
  evaluator to terms composed of variables, constants, lambda
  expressions, and applications of the given functions. However,
  evaluator functions are constrained rather than defined, so that
  the proof that a given metafunction is correct vis-a-vis a
  particular evaluator function can be lifted (by functional
  instantiation) to a proof that it is correct for any larger
  evaluator function. See [meta] for a discussion of metafunctions.

  Defevaluator executes an [encapsulate] after generating the
  appropriate [defun] and [defthm] events. Perhaps the easiest way to
  understand what defevaluator does is to execute the keyword command

    :trans1 (defevaluator evl evl-list ((length x) (member-equal x y)))

  and inspect the output. This trick is also useful in the rare case
  that the event fails because a hint is needed. In that case, the
  output of :[trans1] can be edited by adding hints, then submitted
  directly.

  Formally, ev is said to be an ``evaluator function for g1, ..., gk,
  with mutually-recursive counterpart ev-list'' iff ev and ev-list
  are constrained functions satisfying just the [constraint]s
  discussed below.

  Ev and ev-list must satisfy [constraint]s (0)-(4) and (k):

    (0) How to ev an arbitrary function application:
        (implies (and (consp x)
                      (syntaxp (not (equal a ''nil)))
                      (not (equal (car x) 'quote)))
                 (equal (ev x a)
                        (ev (cons (car x)
                                  (kwote-lst (ev-list (cdr x) a)))
                            nil)))

    (1) How to ev a variable symbol:
        (implies (symbolp x)
                 (equal (ev x a) (and x (cdr (assoc-equal x a)))))

    (2) How to ev a constant:
        (implies (and (consp x)
                      (equal (car x) 'quote))
                 (equal (ev x a) (cadr x)))

    (3) How to ev a lambda application:
        (implies (and (consp x)
                      (consp (car x)))
                 (equal (ev x a)
                        (ev (caddar x)
                            (pairlis$ (cadar x)
                                      (ev-list (cdr x) a)))))

    (4) How to ev an argument list:
        (implies (consp x-lst)
                 (equal (ev-list x-lst a)
                        (cons (ev (car x-lst) a)
                              (ev-list (cdr x-lst) a))))
        (implies (not (consp x-lst))
                 (equal (ev-list x-lst a)
                        nil))

    (k) For each i from 1 to k, how to ev an application of gi,
        where gi is a function symbol of n arguments:
        (implies (and (consp x)
                      (equal (car x) 'gi))
                 (equal (ev x a)
                        (gi (ev x1 a)
                            ...
                            (ev xn a)))),
        where xi is the (cad...dr x) expression equivalent to (nth i x).

  Defevaluator defines suitable witnesses for ev and ev-list, proves
  the theorems about them, and constrains ev and ev-list
  appropriately. We expect defevaluator to work without assistance
  from you, though the proofs do take some time and generate a lot of
  output. The proofs are done in the context of a fixed theory,
  namely the value of the constant *defevaluator-form-base-theory*.

  (Aside: (3) above may seem surprising, since the bindings of a are
  not included in the environment that is used to evaluate the lambda
  body, (caddar x). However, ACL2 lambda expressions are all closed:
  in (lambda (v1 ... vn) body), the only free variables in body are
  among the vi. See [term].)")
 (DEFEXEC
  (EVENTS MBE)
  "Attach a terminating executable function to a definition

  Suppose you define a function (fn x) with a [guard] of (good-input-p
  x), and you know that when the guard holds, the measure decreases
  on each recursive call. Unfortunately, the definitional principle
  (see [defun]) ignores the guard. For example, if the definition has
  the form

    (defun fn (x)
      (declare (xargs :guard (good-input-p x)))
      (if (not-done-yet x)
          (... (fn (destr x)) ...)
        ...))

  then in order to admit this definition, ACL2 must prove the
  appropriate formula asserting that (destr x) is ``smaller than'' x
  under the assumption (not-done-yet x) but without the assumption
  (good-input-p x), even if (not-done-yet x) is true. In essence, it
  may be necessary to submit instead the following definition.

    (defun fn (x)
      (declare (xargs :guard (good-input-p x)))
      (if (good-input-p x)
          (if (not-done-yet x)
              (... (fn (destr x)) ...)
            ...)
        nil)

  But it is unfortunate that when calls of fn are evaluated, for
  example when fn is applied to an explicit constant during a proof,
  then a call of good-input-p must now be evaluated on each recursive
  call.

  Fortunately, defexec provides a way to keep the execution efficient.
  For the example above we could use the following form.

    (defexec fn (x)
      (declare (xargs :guard (good-input-p x)))
      (mbe :logic (if (good-input-p x)
                      (if (not-done-yet x)
                          (... (fn (destr x)) ...)
                        ...)
                    nil)
           :exec  (if (not-done-yet x)
                      (... (fn (destr x)) ...)
                    ...)))

  Here ``[mbe]'' stands for ``must be equal'' and, roughly speaking,
  its call above is logically equal to the :logic form but is
  evaluated using the :exec form when the guard holds. See [mbe]. The
  effect is thus to define fn as shown in the [defun] form above, but
  to cause execution of fn using the :exec body. The use of defexec
  instead of [defun] in the example above causes a termination proof
  to be performed, in order to guarantee that evaluation always
  theoretically terminates, even when using the :exec form for
  evaluation.

    Example:

    ; Some of the keyword arguments in the declarations below are irrelevant or
    ; unnecessary, but they serve to illustrate their use.

    (defexec f (x)
      (declare (xargs :measure (+ 15 (acl2-count x))
                      :ruler-extenders :basic
                      :hints ((\"Goal\" :in-theory (disable nth)))
                      :guard-hints ((\"Goal\" :in-theory (disable last)))
                      :guard (and (integerp x) (<= 0 x) (< x 25)))
               (exec-xargs
                      :test (and (integerp x) (<= 0 x))
                      :default-value 'undef ; defaults to nil
                      :measure (nfix x)
                      :ruler-extenders :basic
                      :well-founded-relation o<))
      (mbe :logic (if (zp x)
                      1
                    (* x (f (- x 1))))
           :exec  (if (= x 0)
                      1
                    (* x (f (- x 1))))))

  The above example macroexpands to the following.

    (ENCAPSULATE ()
     (LOCAL
      (ENCAPSULATE ()
       (SET-IGNORE-OK T)
       (SET-IRRELEVANT-FORMALS-OK T)
       (LOCAL (DEFUN F (X)
                (DECLARE
                 (XARGS :VERIFY-GUARDS NIL
                        :HINTS ((\"Goal\" :IN-THEORY (DISABLE NTH)))
                        :MEASURE (NFIX X)
                        :RULER-EXTENDERS :BASIC
                        :WELL-FOUNDED-RELATION O<))
                (IF (AND (INTEGERP X) (<= 0 X))
                    (IF (= X 0) 1 (* X (F (- X 1))))
                    'UNDEF)))
       (LOCAL (DEFTHM F-GUARD-IMPLIES-TEST
                (IMPLIES (AND (INTEGERP X) (<= 0 X) (< X 25))
                         (AND (INTEGERP X) (<= 0 X)))
                :RULE-CLASSES NIL))))
     (DEFUN F (X)
       (DECLARE (XARGS :MEASURE (+ 15 (ACL2-COUNT X))
                       :RULER-EXTENDERS :BASIC
                       :HINTS ((\"Goal\" :IN-THEORY (DISABLE NTH)))
                       :GUARD-HINTS ((\"Goal\" :IN-THEORY (DISABLE LAST)))
                       :GUARD (AND (INTEGERP X) (<= 0 X) (< X 25))))
       (MBE :LOGIC
            (IF (ZP X) 1 (* X (F (- X 1))))
            :EXEC
            (IF (= X 0) 1 (* X (F (- X 1)))))))

  Notice that in the example above, the :[hints] in the [local]
  definition of F are inherited from the :hints in the [xargs] of the
  defexec form. We discuss such inheritance below.

  CAVEAT: Termination is not considered for calls of [mbe] under the
  top-level call. Moreover, the :exec part of an [mbe] call under the
  :logic part of any superior mbe call is completely ignored.

    General Form:
    (defexec fn (var1 ... varn) doc-string dcl ... dcl
      (mbe :LOGIC logic-body
           :EXEC  exec-body))

  where the syntax is identical to the syntax of [defun] where the body
  is a call of mbe, with the exceptions described below. Thus, fn is
  the symbol you wish to define and is a new symbolic name and (var1
  ... varn) is its list of formal parameters (see [name]). The first
  exception is that at least one dcl (i.e., [declare] form) must
  specify a :guard, guard. The second exception is that one of the
  dcls is allowed to contain an element of the form (exec-xargs ...).
  The exec-xargs form, if present, must specify a non-empty
  [keyword-value-listp] each of whose keys is one of :test,
  :default-value, or one of the standard [xargs] keys of :measure,
  :ruler-extenders, :well-founded-relation, :hints, or :stobjs. Any
  of these five standard xargs keys that is present in an xargs of
  some dcl but is not specified in the (possibly nonexistent)
  exec-xargs form is considered to be specified in the exec-xargs
  form, as illustrated in the example above for :hints. (So for
  example, if you want :hints in the final, non-local definition but
  not in the local definition, then specify the :hints in the xargs
  but specify :hints nil in the exec-xargs.) If :test is specified
  and not nil, let test be its value; otherwise let test default to
  guard. If :default-value is specified, let default-value be its
  value; else default-value is nil. Default-value should have the
  same [signature] as exec-body; otherwise the defexec form will fail
  to be admitted.

  The above General Form's macroexpansion is of the form (PROGN encap
  final-def), where encap and final-def are as follows. Final-def is
  simply the result of removing the exec-xargs declaration (if any)
  from its [declare] form, and is the result of evaluating the given
  defexec form, since encap is of the following form.

    ; encap
    (ENCAPSULATE ()
      (set-ignore-ok t)             ; harmless for proving termination
      (set-irrelevant-formals-ok t) ; harmless for proving termination
      (local local-def)
      (local local-thm))

  The purpose of encap is to ensure the the executable version of name
  terminates on all arguments. Thus, local-def and local-thm are as
  follows, where the xargs of the [declare] form are the result of
  adding :VERIFY-GUARDS NIL to the result of removing the :test and
  (optional) :default-value from the exec-xargs.

    ; local-def
    (DEFUN fn formals
      (DECLARE (XARGS :VERIFY-GUARDS NIL ...))
      (IF test
          exec-body
        default-value))

    ; local-thm
    (DEFTHM fn-EXEC-GUARD-HOLDS
      (IMPLIES guard test)
      :RULE-CLASSES NIL)

  We claim that if the above local-def and local-thm are admitted, then
  all evaluations of calls of fn terminate. The concern is that the
  use of [mbe] in final-def allows for the use of exec-body for a
  call of fn, as well as for subsequent recursive calls, when guard
  holds and assuming that the guards have been verified for
  final-def. However, by local-thm we can conclude in this case that
  test holds, in which case the call of fn may be viewed as a call of
  the version of fn defined in local-def. Moreover, since guards have
  been verified for final-def, then guards hold for subsequent
  evaluation of exec-body, and in particular for recursive calls of
  fn, which can thus continue to be viewed as calls using local=def.")
 (DEFINE-PC-HELP
  (PROOF-CHECKER)
  "Define a macro command whose purpose is to print something

    Example:
    (define-pc-help pp ()
      (if (goals t)
          (io? proof-checker nil state
               (state-stack)
               (fms0 \"~|~y0~|\"
                     (list (cons #0
                                 (fetch-term (conc t)
                                             (current-addr t))))))
        (print-all-goals-proved-message state)))

    General Form:
    (define-pc-help name args &rest body)

  This defines a macro command named name, as explained further below.
  The body should (after removing optional declarations) be a form
  that returns state as its single value. Typically, it will just
  print something.

  What (define-pc-help name args &rest body) really does is to create a
  call of define-pc-macro that defines name to take arguments args,
  to have the declarations indicated by all but the last form in
  body, and to have a body that (via pprogn) first executes the form
  in the last element of body and then returns a call to the command
  skip (which will return (mv nil t state)).")
 (DEFINE-PC-MACRO
  (PROOF-CHECKER)
  "Define a proof-checker macro command

    Example:
    (define-pc-macro ib (&optional term)
      (value
       (if term
           `(then (induct ,term) bash)
         `(then induct bash))))

  The example above captures a common paradigm: one attempts to prove
  the current goal by inducting and then simplifying the resulting
  goals. (see [proof-checker-commands] for documentation of the
  command then, which is itself a pc-macro command, and commands
  induct and bash.) Rather than issuing (then induct bash), or worse
  yet issuing induct and then issuing bash for each resulting goals,
  the above definition of ib would let you issue ib and get the same
  effect.

    General Form:
    (define-pc-macro cmd args doc-string dcl ... dcl body)

  where cmd is the name of the pc-macro than you want to define, args
  is its list of formal parameters. Args may include lambda-list
  keywords &optional and &rest; see [macro-args], but note that here,
  args may not include &key or &whole.

  The value of body should be an error triple (see [error-triples]), of
  the form (mv erp xxx state) for some erp and xxx. If erp is nil,
  then xxx is handed off to the proof-checker's instruction
  interpreter. Otherwise, evaluation typically halts. We may write
  more on the full story later if there is interest in reading it.")
 (DEFINE-PC-META
  (PROOF-CHECKER)
  "Define a proof-checker meta command

  Built-in proof-checker meta commands include undo and restore, and
  others (lisp, exit, and sequence); see [proof-checker-commands].
  The advanced proof-checker user can define these as well. See ACL2
  source file proof-checker-b.lisp for examples, and contact the ACL2
  implementors if those examples do not provide sufficient
  documentation.")
 (DEFINE-TRUSTED-CLAUSE-PROCESSOR
  (EVENTS)
  "Define a trusted (unverified) goal-level simplifier

  This [documentation] assumes familiarity with :clause-processor
  rules; see [clause-processor]. Briefly put, a clause-processor is a
  user-defined function that takes as input the ACL2 representation
  of a goal --- a clause --- and returns a list of goals (i.e., a
  list of clauses). A :clause-processor rule is a way to inform ACL2
  that a clause-processor has been proved correct and now may be
  specified in :clause-processor [hints].

  Here we describe a utility, define-trusted-clause-processor, that
  provides another way to inform ACL2 that a function is to be
  considered a clause-processor that can be specified in a
  :clause-processor hint. You can find examples of correct and
  incorrect use of this utility in community book
  books/clause-processors/basic-examples.

  Consider the simple example already presented for :clause-processor
  rules (again, see [clause-processor]), for a simple
  clause-processor named note-fact-clause-processor. Instead of
  introducing an evaluator and proving a correctness theorem with
  :rule-classes :clause-processor, we can simply inform ACL2 that we
  trust the function note-fact-clause-processor to serve as a
  clause-processor.

    (define-trusted-clause-processor
      note-fact-clause-processor
      nil
      :ttag my-ttag)

  A non-nil :ttag argument generates a [defttag] event in order to
  acknowledge the dependence of the ACL2 session on the (unproved)
  correctness of this clause-processor. That argument can be omitted
  if there is currently an active trust tag. See [defttag]. Because
  we are trusting this clause-processor, rather than having proved it
  correct, we refer to it as a ``trusted'' clause-processor to
  contrast with a proved-correct, or ``verified'', clause-processor.

  Now that the event displayed above has established
  note-fact-clause-processor as a (trusted) clause-processor, we can
  use it in a :clause-processor hint, for example as follows. Notice
  that the output is identical to that for the corresponding example
  presented for the verified case (see [clause-processor]), except
  that the word ``verified'' has been replaced by the word
  ``trusted''.

    ACL2 !>(thm (equal (car (cons x y))
                       x)
                :hints
                ((\"Goal\"
                  :clause-processor
                  (note-fact-clause-processor clause '(equal a a)))))

    [Note:  A hint was supplied for our processing of the goal above.
    Thanks!]

    We now apply the trusted :CLAUSE-PROCESSOR function NOTE-FACT-CLAUSE-
    PROCESSOR to produce two new subgoals.

    Subgoal 2
    (IMPLIES (EQUAL A A)
             (EQUAL (CAR (CONS X Y)) X)).

    But we reduce the conjecture to T, by the :executable-counterpart of
    IF and the simple :rewrite rule CAR-CONS.

    Subgoal 1
    (EQUAL A A).

    But we reduce the conjecture to T, by primitive type reasoning.

    Q.E.D.

    Summary
    Form:  ( THM ...)
    Rules: ((:EXECUTABLE-COUNTERPART IF)
            (:EXECUTABLE-COUNTERPART NOT)
            (:FAKE-RUNE-FOR-TYPE-SET NIL)
            (:REWRITE CAR-CONS))
    Warnings:  None
    Time:  0.00 seconds (prove: 0.00, print: 0.00, other: 0.00)

    Proof succeeded.
    ACL2 !>

  Indeed, if one runs this example first and subsequently verifies the
  clause-processor, one will see the word ``trusted'' change to
  ``verified''.

  The general form is as follows.

    (define-trusted-clause-processor
      cl-proc           ;;; clause-processor function
      supporters        ;;; see below
      &key
      label             ;;; optional, but required if doc is non-nil
      doc               ;;; optional
      ttag              ;;; discussed above
      partial-theory    ;;; optional encapsulate event
      )

  If a :label LAB is supplied, then a subsidiary [deflabel] event will
  be generated with name LAB, which will enable you to to undo this
  define-trusted-clause-processor event using: :[ubt] LAB. If you
  supply a :label then you may supply a :doc argument to use with
  that generated [deflabel] event. We discussed the :ttag argument
  above. The entire form is considered redundant (skipped) if it is
  identical to one already executed in the current ACL2 world; but if
  it is not redundant, then cl-proc must not already have been
  similarly designated as a trusted clause-processor.

  Note that cl-proc may be defined either in :program-mode or
  :logic-mode.

  The supporters argument should be a true list of function symbols in
  the current ACL2 world. It is important that this list include
  user-defined functions whose definitions support the correctness of
  the clause-processor function. Otherwise, [local] definitions of
  those missing supporters can render the use of this
  clause-processor unsound, as discussed in the paper referenced at
  the end of the [clause-processor] documentation topic. Moreover,
  ACL2 assumes for dependent clause-processors (discussed below) that
  every function symbol constrained by the ``promised encapsulate''
  of that event is either among those supporters or ancestral in one
  of them (i.e. a supporter of a supporter, a supporter of one of
  those, etc.).

  Dependent clause-processors and promised encapsulates: The
  :partial-theory argument

  Suppose you want to introduce a clause-processor to reason about a
  complex hardware simulator that is implemented outside ACL2. Sawada
  and Reeber had just such a problem, as reported in their FMCAD 2006
  paper. Indeed, they used [sys-call] to implement a :[program]-mode
  function in ACL2 that can invoke that simulator. In principle one
  could code the simulator directly in ACL2; but it would be a
  tremendous amount of work that has no practical purpose, given the
  interface to the external simulator. So: In what sense can we have
  a clause-processor that proves properties about a simulator when
  that simulator is not fully axiomatized in ACL2? Our answer, in a
  nutshell, is this: The above :partial-theory argument provides a
  way to write merely some of the [constraint]s on the external tool
  (or even no constraints at all), with the understanding that such
  constraints are present implicitly in a stronger ``promised''
  encapsulate, for example by exporting the full definition.

  If a trusted clause-processor is introduced with a :partial-theory
  argument, we call it a ``dependent'' clause-processor, because its
  correctness is dependent on the constraints implicitly introduced
  by the :partial-theory encapsulate form. The implicit constraints
  should logically imply the constraints actually introduced by the
  explicit encapsulate, but they should also be sufficient to justify
  every possible invocation of the clause-processor in a
  :clause-processor hint. The user of a
  define-trusted-clause-processor form is making a guarantee --- or,
  is relying on a guarantee provided by the writer of that form ---
  that in principle, there exists a so-called ``promised
  encapsulate'': an encapsulate form with the same [signature] as the
  :partial-theory encapsulate form associated with the trusted
  clause-processor, but whose constraints introduced are the
  aforementioned implicit constraints.

  There are several additional requirements on a :partial-theory
  argument. First, it must be an [encapsulate] event with non-empty
  [signature]. Moreover, the functions introduced by that event must
  be exactly those specified in the signature, and no more. And
  further still, the define-trusted-clause-processor form cannot be
  executed inside any [encapsulate] form with non-empty [signature];
  we can think of this situation as attempting to associate more than
  one encapsulate with the functions introduced in the inner
  encapsulate.

  The :partial-theory event will (in essence) be executed as part of
  the evaluation of the define-trusted-clause-processor form. Again,
  a critical obligation rests on the user who provides a
  :partial-theory: there must exist (in principle at least) a
  corresponding promised encapsulate form with the same [signature]
  that could logically be admitted, whenever the above
  define-trusted-clause-processor form is evaluated successfully,
  that justifies the designation of cl-proc as a clause-processor.
  See also the paper mentioned above for more about promised
  encapsulates. A key consequence is that the [constraint]s are
  unknown for the functions introduced in (the signature of) a
  :partial-theory [encapsulate] form. Thus, functional instantiation
  (see [functional-instantiation-example]) is disabled for function
  in the signature of a :partial-theory form.

  A remark on the underlying implementation

  You can see all of the current trusted clause-processors by issuing
  the command (table trusted-clause-processor-table). Those that are
  dependent clause-processors will be associated in the resulting
  association list with a pair whose car is the list of supporters
  and whose cdr is t, i.e., with (supporters . t); the others will be
  associated just with (supporters).

  Thus, define-trusted-clause-processor is actually a macro that
  generates (among other things) a table event for a table named
  trusted-clause-processor-table; see [table]. You are invited to use
  :[trans1] to see expansions of calls of this macro.

  A technique for using raw Lisp to define a trusted clause-processor

  The following code is intended to give an idea for how one might
  define the ``guts'' of a trusted clause-processor in raw Lisp. The
  idea is to stub out functions, such as acl2-my-prove below, that
  you want to define in raw Lisp; and then, load a raw Lisp file to
  overwrite any such function with the real code. But then we make
  any such overwritten function untouchable. (This last step is
  important because otherwise, one can prove nil using a
  :functional-instance :use hint, by exploiting the fact that this
  function has executable code for which there is no corresponding
  definitional axiom.)

    (defstub acl2-my-prove (term hint) t)

    (program)

    (defttag :my-cl-proc)

    (progn

    ; We wrap everything here in a single progn, so that the entire form is
    ; atomic.  That's important because we want the use of push-untouchable to
    ; prevent anything besides my-clause-processor from calling acl2-my-prove.

      (progn!

       (set-raw-mode-on state)

       (load \"my-hint-raw.lsp\") ; defines my-prove in raw Lisp

       (defun acl2-my-prove (term hint)
         (my-prove term hint)))

      (defun my-clause-processor (cl hint)
        (declare (xargs :guard (pseudo-term-listp cl)
                        :mode :program))
        (if (acl2-my-prove (disjoin cl) hint)
            (disjoin-clause-segments-to-clause
             (pairlis$ (hint-to-termlist hint) nil)
             cl)
          (prog2$ (cw \"~|~%NOTE: Unable to prove goal with ~
                      my-clause-processor and indicated hint.~|\")
                  (list cl))))

      (push-untouchable acl2-my-prove t)
      )")
 (DEFINITION
  (RULE-CLASSES)
  "Make a rule that acts like a function definition

  See [rule-classes] for a general discussion of rule classes and how
  they are used to build rules from formulas. An example :[corollary]
  formula from which a :definition rule might be built is:

    Examples:
    (defthm open-len-twice
      (implies (true-listp x)
               (equal (len x)
                      (if (null x)
                          0
                        (if (null (cdr x))
                            1
                          (+ 2 (len (cddr x)))))))
      :rule-classes :definition)

    ; Same as above, with :controller-alist made explicit:
    (defthm open-len-twice
      (implies (true-listp x)
               (equal (len x)
                      (if (null x)
                          0
                        (if (null (cdr x))
                            1
                          (+ 2 (len (cddr x)))))))
      :rule-classes ((:definition :controller-alist ((len t)))))

    General Form:
    (implies hyp (equiv (fn a1 ... an) body))

  where equiv is an equivalence relation and fn is a function symbol
  other than [if], [hide], [force] or [case-split]. Such rules allow
  ``alternative'' definitions of fn to be proved as theorems but used
  as definitions. These rules are not true ``definitions'' in the
  sense that they (a) cannot introduce new function symbols and (b)
  do not have to be terminating recursion schemes. They are just
  conditional rewrite rules that are controlled the same way we
  control recursive definitions. We call these ``definition rules''
  or ``generalized definitions''.

  Consider the general form above. Generalized definitions are stored
  among the :[rewrite] rules for the function ``defined,'' fn above,
  but the procedure for applying them is a little different. During
  rewriting, instances of (fn a1 ... an) are replaced by
  corresponding instances of body provided the hyps can be
  established as for a :[rewrite] rule and the result of rewriting
  body satisfies the criteria for function expansion. There are two
  primary criteria, either of which permits expansion. The first is
  that the ``recursive'' calls of fn in the rewritten body have
  arguments that already occur in the goal conjecture. The second is
  that the ``controlling'' arguments to fn are simpler in the
  rewritten body.

  The notions of ``recursive call'' and ``controllers'' are complicated
  by the provisions for mutually recursive definitions. Consider a
  ``clique'' of mutually recursive definitions. Then a ``recursive
  call'' is a call to any function defined in the clique and an
  argument is a ``controller'' if it is involved in the measure that
  decreases in all recursive calls. These notions are precisely
  defined by the definitional principle and do not necessarily make
  sense in the context of generalized definitional equations as
  implemented here.

  But because the heuristics governing the use of generalized
  definitions require these notions, it is generally up to the user
  to specify which calls in body are to be considered recursive and
  what the controlling arguments are. This information is specified
  in the :clique and :controller-alist fields of the :definition rule
  class.

  The :clique field is the list of function symbols to be considered
  recursive calls of fn. In the case of a non-recursive definition,
  the :clique field is empty; in a singly recursive definition, it
  should consist of the singleton list containing fn; otherwise it
  should be a list of all of the functions in the mutually recursive
  clique with this definition of fn.

  If the :clique field is not provided it defaults to nil if fn does
  not occur as a function symbol in body and it defaults to the
  singleton list containing fn otherwise. Thus, :clique must be
  supplied by the user only when the generalized definition rule is
  to be treated as one of several in a mutually recursive clique.

  The :controller-alist is an alist that maps each function symbol in
  the :clique to a mask specifying which arguments are considered
  controllers. The mask for a given member of the clique, fn, must be
  a list of t's and nil's of length equal to the arity of fn. A t
  should be in each argument position that is considered a
  ``controller'' of the recursion. For a function admitted under the
  principle of definition, an argument controls the recursion if it
  is one of the arguments measured in the termination argument for
  the function. But in generalized definition rules, the user is free
  to designate any subset of the arguments as controllers. Failure to
  choose wisely may result in the ``infinite expansion'' of
  definitional rules but cannot render ACL2 unsound since the rule
  being misused is a theorem.

  If the :controller-alist is omitted it can sometimes be defaulted
  automatically by the system. If the :clique is nil, the
  :controller-alist defaults to nil. If the :clique is a singleton
  containing fn, the :controller-alist defaults to the controller
  alist computed by (defun fn args body). (The user can obtain some
  control over this analysis by setting the default ruler-extenders;
  see [ruler-extenders].) If the :clique contains more than one
  function, the user must supply the :controller-alist specifying the
  controllers for each function in the clique. This is necessary
  since the system cannot determine and thus cannot analyze the other
  definitional equations to be included in the clique.

  For example, suppose fn1 and fn2 have been defined one way and it is
  desired to make ``alternative'' mutually recursive definitions
  available to the rewriter. Then one would prove two theorems and
  store each as a :definition rule. These two theorems would exhibit
  equations ``defining'' fn1 and fn2 in terms of each other. No
  provision is here made for exhibiting these two equations as a
  system of equations. One is proved and then the other. It just so
  happens that the user intends them to be treated as mutually
  recursive definitions. To achieve this end, both :definition rules
  should specify the :clique (fn1 fn2) and should specify a suitable
  :controller-alist. If, for example, the new definition of fn1 is
  controlled by its first argument and the new definition of fn2 is
  controlled by its second and third (and they each take three
  arguments) then a suitable :controller-alist would be ((fn1 t nil
  nil) (fn2 nil t t)). The order of the pairs in the alist is
  unimportant, but there must be a pair for each function in the
  clique.

  Inappropriate heuristic advice via :clique and :controller-alist can
  cause ``infinite expansion'' of generalized definitions, but cannot
  render ACL2 unsound.

  Note that the actual definition of fn1 has the runic name
  (:definition fn1). The runic name of the alternative definition is
  (:definition lemma), where lemma is the name given to the event
  that created the generalized :definition rule. This allows theories
  to switch between various ``definitions'' of the functions.

  By default, a :definition rule establishes the so-called ``body'' of
  a function. The body is used by :expand [hints], and it is also
  used heuristically by the theorem prover's preprocessing (the
  initial simplification using ``simple'' rules that is controlled by
  the preprocess symbol in :do-not [hints]), induction analysis, and
  the determination for when to warn about non-recursive functions in
  rules. The body is also used by some heuristics involving whether a
  function is recursively defined, and by the expand, x, and x-dumb
  commands of the [proof-checker].

  See [rule-classes] for a discussion of the optional field
  :install-body of :definition rules, which controls whether a
  :definition rule is used as described in the paragraph above. Note
  that even if :install-body nil is supplied, the rewriter will still
  rewrite with the :definition rule; in that case, ACL2 just won't
  install a new body for the top function symbol of the left-hand
  side of the rule, which for example affects the application of
  :expand hints as described in the preceding paragraph. Also see
  [set-body] and see [show-bodies] for how to change the body of a
  function symbol.

  Note only that if you prove a definition rule for function foo, say,
  foo-new-def, you will need to refer to that definition as
  foo-new-def or as (:DEFINITION foo-new-def). That is because a
  :definition rule does not change the meaning of the symbol foo for
  :use [hints], nor does it change the meaning of the symbol foo in
  theory expressions; see [theories], in particular the discussion
  there of runic designators. Similarly :[pe] foo and :[pf] foo will
  still show the original definition of foo.

  The definitional principle, [defun], actually adds :definition rules.
  Thus the handling of generalized definitions is exactly the same as
  for ``real'' definitions because no distinction is made in the
  implementation. Suppose (fn x y) is [defun]'d to be body. Note that
  [defun] (or [defuns] or [mutual-recursion]) can compute the clique
  for fn from the syntactic presentation and it can compute the
  controllers from the termination analysis. Provided the definition
  is admissible, [defun] adds the :definition rule (equal (fn x y)
  body).


Subtopics

  [Set-body]
      Set the definition body

  [Show-bodies]
      Show the potential definition bodies")
 (DEFLABEL
  (EVENTS)
  "Build a landmark and/or add a [documentation] topic

    Examples:
    (deflabel interp-section
       :doc
       \":Doc-Section ...\")

    General Form:
    (deflabel name :doc doc-string)

  where name is a new symbolic name (see [name]) and [doc-string] is an
  optional [documentation] string (see [doc-string]). This event adds
  the [documentation] string for symbol name to the :[doc] database.
  By virtue of the fact that deflabel is an event, it also marks the
  current [history] with the name. Thus, even undocumented labels are
  convenient as landmarks in a proof development. For example, you
  may wish to undo back through some label or compute a theory
  expression (see [theories]) in terms of some labels. Deflabel
  [events] are never considered redundant. See [redundant-events].

  See [defdoc] for a means of attaching a [documentation] string to a
  name without marking the current [history] with that name.")
 (DEFLOCK
  (PARALLEL-PROGRAMMING)
  "Define a wrapper macro that provides mutual exclusion in ACL2(p)

  This [documentation] topic relates to the experimental extension of
  ACL2 supporting parallel evaluation and proof; see [parallelism].

    Example Form:
    (deflock *my-lock*)

    General Form:
    (deflock *symbol*)

  where *symbol* is a symbol whose first and last characters are both
  the character #\\*.

  A call of this macro generates a definition of another macro, named
  with-<modified-lock-symbol>, where <modified-lock-symbol> is the
  given symbol with the leading and trailing * characters removed.
  This newly defined macro will guarantee mutually exclusive
  execution when called in the body of the raw Lisp definition of a
  function, as is typically the case for [guard]-verified functions,
  for :[program] mode functions, and for calls of macro [top-level].
  (See [guard-evaluation-table] for details of how raw Lisp code
  might not be invoked when guard-checking (see [set-guard-checking])
  has value :none or :all.)

  To see how mutual exclusion is guaranteed, consider the raw Lisp code
  generated for the macro, with-<modified-lock-symbol>, that is
  introduced by a call of deflock. This code uses a lock (with the
  given *symbol* as its name), which guarantees that for any two
  forms that are each in the scope of a call of
  with-<modified-lock-symbol>, the forms do not execute concurrently.

  Note that a call of deflock expands into the application of progn to
  two events, as illustrated below.

    ACL2 !>:trans1 (deflock *my-cw-lock*)
     (PROGN (TABLE LOCK-TABLE '*MY-CW-LOCK* T)
            (DEFMACRO WITH-MY-CW-LOCK (&REST ARGS)
                      (LIST* 'WITH-LOCK '*MY-CW-LOCK* ARGS)))
    ACL2 !>

  Thus, deflock forms are legal embedded event forms (see
  [embedded-event-form]) for [books] as well as [encapsulate] and
  [progn] [events].

  The following log shows a lock in action. Recall that locks work as
  expected in [guard]-verified and :[program] mode functions; they do
  not, however, work in :[logic] mode functions that have not been
  guard-verified, as illustrated below.

    ACL2 !>(deflock *my-cw-lock*)
    [[.. output omitted ..]]
     WITH-MY-CW-LOCK
    ACL2 !>(defun foo (n)
             (declare (xargs :guard (natp n) :verify-guards nil))
             (plet ((x1 (with-my-cw-lock (cw \"~x0\" (make-list n))))
                    (x2 (with-my-cw-lock (cw \"~x0\" (make-list n)))))
                   (and (null x1) (null x2))))
    [[.. output omitted ..]]
     FOO
    ACL2 !>(foo 20)
    (NIL NIL NIL NIL( NIL NIL NIL NIL NIL NILNIL  NIL NILNIL  NIL NILNIL
         NIL NILNIL NIL  NIL NILNIL  NIL NIL
    NIL      NILNIL  NIL NILNIL )
    NIL NIL NIL NIL NIL NIL NIL NIL)
    T
    ACL2 !>(verify-guards foo)
    [[.. output omitted ..]]
     FOO
    ACL2 !>(foo 20)
    (NIL NIL NIL NIL NIL NIL NIL NIL NIL NIL
         NIL NIL NIL NIL NIL NIL NIL NIL NIL NIL)
    (NIL NIL NIL NIL NIL NIL NIL NIL NIL NIL
         NIL NIL NIL NIL NIL NIL NIL NIL NIL NIL)
    T
    ACL2 !>")
 (DEFMACRO
  (MACROS EVENTS)
  "Define a macro

    Example Defmacros:
    (defmacro xor (x y)
      (list 'if x (list 'not y) y))

    (defmacro git (sym key)
      (list 'getprop sym key nil
            '(quote current-acl2-world)
            '(w state)))

    (defmacro one-of (x &rest rst)
      (declare (xargs :guard (symbol-listp rst)))
      (cond ((null rst) nil)
            (t (list 'or
                     (list 'eq x (list 'quote (car rst)))
                     (list* 'one-of x (cdr rst))))))

    Example Expansions:
    term                    macroexpansion

    (xor a b)              (if a (not b) b)
    (xor a (foo b))        (if a (not (foo b)) (foo b))

    (git 'car 'lemmas)     (getprop 'car 'lemmas nil
                                    'current-acl2-world
                                    (w state))

    (one-of x a b c)       (or (eq x 'a)
                               (or (eq x 'b)
                                   (or (eq x 'c) nil)))

    (one-of x 1 2 3)       ill-formed (guard violation)

    General Form:
    (defmacro name macro-args doc-string dcl ... dcl body)

  where name is a new symbolic name (see [name]), macro-args specifies
  the formal parameters of the macro, and body is a term. The formal
  parameters can be specified in a much more general way than is
  allowed by ACL2 [defun] [events]; see [macro-args] for a
  description of keyword (&key) and optional (&optional) parameters
  as well as other so-called ``lambda-list keywords'', &rest and
  &whole. [Doc-string] is an optional [documentation] string; see
  [doc-string]. Each dcl is an optional declaration (see [declare])
  except that the only [xargs] keyword permitted by defmacro is
  :[guard].

  For compute-intensive applications see the community book
  misc/defmac.lisp, which can speed up macroexpansion by introducing
  an auxiliary defun. For more information, evaluate the form
  (include-book \"misc/defmac\" :dir :system) and then evaluate :doc
  defmac.

  Macroexpansion occurs when a form is read in, i.e., before the
  evaluation or proof of that form is undertaken. To experiment with
  macroexpansion, see [trans]. When a form whose [car] is name arises
  as the form is read in, the arguments are bound as described in
  CLTL pp. 60 and 145, the [guard] is checked, and then the body is
  evaluated. The result is used in place of the original form.

  In ACL2, macros do not have access to the ACL2 state, [state]. (If
  [state] or any user-defined stobj (see [stobj]) is a macro
  argument, it is treated as an ordinary variable, bound at
  macro-expansion time to a piece of syntax.) This is in part a
  reflection of CLTL, p. 143, ``More generally, an implementation of
  Common Lisp has great latitude in deciding exactly when to expand
  macro calls with a program. ... Macros should be written in such a
  way as to depend as little as possible on the execution environment
  to produce a correct expansion.'' In ACL2, the product of
  macroexpansion is independent of the current environment and is
  determined entirely by the macro body and the functions and
  constants it references. It is possible, however, to define macros
  that produce expansions that refer to [state] or other
  single-threaded objects (see [stobj]) or variables not among the
  macro's arguments. See the git example above. For a related utility
  that does have access to the ACL2 [state], see [make-event].")
 (DEFMACRO-LAST
  (EVENTS)
  "Define a macro that returns its last argument, but with side effects

  This is an advanced feature that requires a trust tag. For
  explanation, including an example, see [return-last].")
 (DEFN (EVENTS)
       "Definition with [guard] t

  Defn is [defun] with [guard] t.")
 (DEFND
  (EVENTS)
  "[disable]d definition with [guard] t

  Defnd is [defund] with [guard] t.")
 (DEFPKG
  (EVENTS PROGRAMMING)
  "Define a new symbol package

    Example:
    (defpkg \"MY-PKG\"
            (union-eq *acl2-exports*
                      *common-lisp-symbols-from-main-lisp-package*))

    General Form:
    (defpkg \"name\" term doc-string)

  where \"name\" is a non-empty string consisting of standard characters
  (see [standard-char-p]), none of which is lower case, that names
  the package to be created; term is a variable-free expression that
  evaluates to a list of symbols, where no two distinct symbols in
  the list may have the same [symbol-name], to be imported into the
  newly created package; and [doc-string] is an optional
  [documentation] string; see [doc-string]. The name of the new
  package must be ``new'': the host lisp must not contain any package
  of that name. There are two exceptions to this newness rule,
  discussed at the end of this documentation.

  (There is actually an additional argument, book-path, that is used
  for error reporting but has no logical content. Users should
  generally ignore this argument, as well as the rest of this
  sentence: a book-path will be specified for [defpkg] events added
  by ACL2 to the [portcullis] of a book's [certificate]; see
  [hidden-death-package].)

  Defpkg forms can be entered at the top-level of the ACL2 [command]
  loop. They should not occur in [books] (see [certify-book]).

  After a successful defpkg it is possible to ``intern'' a string into
  the package using [intern-in-package-of-symbol]. The result is a
  symbol that is in the indicated package, provided the imports allow
  it. For example, suppose 'my-pkg::abc is a symbol whose
  [symbol-package-name] is \"MY-PKG\". Suppose further that the imports
  specified in the defpkg for \"MY-PKG\" do not include a symbol whose
  [symbol-name] is \"XYZ\". Then

    (intern-in-package-of-symbol \"XYZ\" 'my-pkg::abc)

  returns a symbol whose [symbol-name] is \"XYZ\" and whose
  [symbol-package-name] is \"MY-PKG\". On the other hand, if the
  imports to the defpkg does include a symbol with the name \"XYZ\",
  say in the package \"LISP\", then

    (intern-in-package-of-symbol \"XYZ\" 'my-pkg::abc)

  returns that symbol (which is uniquely determined by the restriction
  on the imports list above). See [intern-in-package-of-symbol].

  Upon admission of a defpkg event, the function pkg-imports is
  extended to compute a list of all symbols imported into the given
  package, without duplicates.

  Defpkg is the only means by which an ACL2 user can create a new
  package or specify what it imports. That is, ACL2 does not support
  the Common Lisp functions make-package or import. Currently, ACL2
  does not support exporting at all.

  The Common Lisp function [intern] is weakly supported by ACL2; see
  [intern]. A more general form of that function is also provided:
  see [intern$].

  We now explain the two exceptions to the newness rule for package
  names. The careful experimenter will note that if a package is
  created with a defpkg that is subsequently undone, the host lisp
  system will contain the created package even after the undo.
  Because ACL2 hangs onto [world]s after they have been undone, e.g.,
  to implement :[oops] but, more importantly, to implement error
  recovery, we cannot actually destroy a package upon undoing it.
  Thus, the first exception to the newness rule is that name is
  allowed to be the name of an existing package if that package was
  created by an undone defpkg and the newly proposed set of imports
  is identical to the old one. See
  [package-reincarnation-import-restrictions]. This exception does
  not violate the spirit of the newness rule, since one is
  disinclined to believe in the existence of undone packages. The
  second exception is that name is allowed to be the name of an
  existing package if the package was created by a defpkg with
  identical set of imports. That is, it is permissible to execute
  ``redundant'' defpkg [command]s. The redundancy test is based on
  the values of the two import forms (comparing them after sorting
  and removing duplicates), not on the forms themselves.

  Finally, we explain why we require the package name to contain
  standard characters, none of which is lower case. We have seen at
  least one implementation that handled lower-case package names
  incorrectly. Since we see no need for lower-case characters in
  package names, which can lead to confusion anyhow (note for example
  that foo::bar is a symbol whose [symbol-package-name] is \"FOO\", not
  \"foo\"), we simply disallow them. Since the notion of ``lower case''
  is only well-specified in Common Lisp for standard characters, we
  restrict to these.

  NOTE: Also see [managing-ACL2-packages] for contributed documentation
  on managing ACL2 packages.


Subtopics

  [Hidden-death-package]
      Handling [defpkg] [events] that are [local]

  [Hidden-defpkg]
      Handling defpkg events that are local

  [Managing-ACL2-packages]
      User-contributed documentation on packages

  [Package-reincarnation-import-restrictions]
      Re-defining undone [defpkg]s")
 (DEFPROXY
  (EVENTS)
  "Define a non-executable :[program]-mode function for attachment

  This event is provided for those who want to experiment with
  [defattach] using :[program] mode functions, and without proof
  obligations or constraints on cycles in the extended ancestors
  graph; see [defattach]. If you merely want to define a stub or a
  non-executable function, see [defstub] or see [defun-nx],
  respectively.

  See community book books/misc/defproxy-test.lisp for an extended (but
  simple) example.

    Example Forms:
    (defproxy subr1 (* *) => *)
    (defproxy add-hash (* * hashtable) => (mv * hashtable))

    General Form:
    (defproxy name args-sig => output-sig)

  where name is a new function symbol and (name . args-sig) =>
  output-sig) is a signature; see [signature].

  The macro defproxy provides a convenient way to introduce a
  ``proxy'': a :program mode function that can be given attachments
  for execution (see [defattach]), assuming that there is an active
  trust tag (see [defttag]). Thus, a defproxy calls expands to a
  [defun] form with the following [xargs] [declare] form:
  :non-executable :program. Note that [verify-termination] is not
  permitted for such a function. However, it is permitted to put the
  proxy function into :[logic] mode by use of an [encapsulate] event;
  indeed, this is the way to ``upgrade'' an attachment so that the
  normal checks are performed and no trust tag is necessary.

  In order to take advantage of a [defproxy] form, one provides a
  subsequent defattach form to attach an executable function to the
  defproxy-introduced function. When :skip-checks t is provided in a
  [defattach] form, the usual checks for defattach [events] are
  skipped, including proof obligations and the check that the
  extended ancestor relation has no cycles (see [defattach]). There
  must be an active trust tag (see [defttag]) in order to use
  :skip-checks t. In that case the use of :skip-checks t is
  permitted; but note that its use is in fact required if a
  :[program] mode function is involved, and even if a :[logic] mode
  function is involved that has not been [guard]-verified.

  The following log shows a simple use of defproxy.

    ACL2 !>(defproxy foo-stub (*) => *)

    Summary
    Form:  ( DEFUN FOO-STUB ...)
    Rules: NIL
    Time:  0.01 seconds (prove: 0.00, print: 0.00, other: 0.01)
     FOO-STUB
    ACL2 !>(foo-stub '(3 4 5))

    ACL2 Error in TOP-LEVEL:  ACL2 cannot ev the call of undefined function
    FOO-STUB on argument list:

    ((3 4 5))

    To debug see :DOC print-gv, see :DOC trace, and see :DOC wet.

    ACL2 !>(defun foo-impl (x)
             (declare (xargs :mode :program
                             :guard (or (consp x) (eq x nil))))
             (car x))

    Summary
    Form:  ( DEFUN FOO-IMPL ...)
    Rules: NIL
    Time:  0.00 seconds (prove: 0.00, print: 0.00, other: 0.00)
     FOO-IMPL
    ACL2 !>(defttag t)

    TTAG NOTE: Adding ttag :T from the top level loop.
     T
    ACL2 !>(defattach (foo-stub foo-impl) :skip-checks t)

    Summary
    Form:  ( DEFATTACH (FOO-STUB FOO-IMPL) ...)
    Rules: NIL
    Time:  0.00 seconds (prove: 0.00, print: 0.00, other: 0.00)
     :ATTACHMENTS-RECORDED
    ACL2 !>(foo-stub '(3 4 5))
    3
    ACL2 !>

  One can replace this attachment with one that uses :[logic] mode
  functions and does not skip checks. The idea is to reintroduce the
  proxy function using an [encapsulate] form, which does not require
  redefinition (see [ld-redefinition-action]) to be enabled, and
  either to put the attachment into :[logic] mode with the [guard]
  verified, as we do in the example below, or else to attach to a
  different [guard]-verified :[logic] mode function.

    ACL2 !>(defattach (foo-stub nil) :skip-checks t) ; remove attachment

    Summary
    Form:  ( DEFATTACH (FOO-STUB NIL) ...)
    Rules: NIL
    Time:  0.00 seconds (prove: 0.00, print: 0.00, other: 0.00)
     :ATTACHMENTS-RECORDED
    ACL2 !>(encapsulate
            ((foo-stub (x) t :guard (true-listp x)))
            (local (defun foo-stub (x) (cdr x)))
            (defthm foo-stub-reduces-acl2-count
              (implies (consp x)
                       (< (acl2-count (foo-stub x))
                          (acl2-count x)))))

    [[ ... output omitted here ... ]]

    The following constraint is associated with the function FOO-STUB:

    (IMPLIES (CONSP X) (< (ACL2-COUNT (FOO-STUB X)) (ACL2-COUNT X)))

    Summary
    Form:  ( ENCAPSULATE ((FOO-STUB ...) ...) ...)
    Rules: NIL
    Warnings:  Non-rec
    Time:  0.02 seconds (prove: 0.01, print: 0.00, other: 0.01)
     T
    ACL2 !>(verify-termination foo-impl)

    Since FOO-IMPL is non-recursive, its admission is trivial.  We could
    deduce no constraints on the type of FOO-IMPL.

    Computing the guard conjecture for FOO-IMPL....

    The guard conjecture for FOO-IMPL is trivial to prove.  FOO-IMPL is
    compliant with Common Lisp.

    Summary
    Form:  ( DEFUN FOO-IMPL ...)
    Rules: NIL
    Time:  0.00 seconds (prove: 0.00, print: 0.00, other: 0.00)

    Summary
    Form:  ( MAKE-EVENT (VERIFY-TERMINATION-FN ...))
    Rules: NIL
    Time:  0.01 seconds (prove: 0.00, print: 0.00, other: 0.01)
     FOO-IMPL
    ACL2 !>(defttag nil) ; optional
     NIL
    ACL2 !>(defattach (foo-stub foo-impl))

    The guard proof obligation is

    (IMPLIES (TRUE-LISTP X)
             (OR (CONSP X) (EQ X NIL))).

    But we reduce the conjecture to T, by primitive type reasoning.

    Q.E.D.

    This concludes the guard proof.

    We now prove that the attachment satisfies the required constraint.
    The goal to prove is

    (IMPLIES (CONSP X)
             (< (ACL2-COUNT (FOO-IMPL X))
                (ACL2-COUNT X))).

    [[ ... output omitted here ... ]]

    Q.E.D.

    Summary
    Form:  ( DEFATTACH (FOO-STUB FOO-IMPL))
    Rules: ((:DEFINITION ACL2-COUNT)
            (:DEFINITION FOO-IMPL)
            (:ELIM CAR-CDR-ELIM)
            (:FAKE-RUNE-FOR-LINEAR NIL)
            (:FAKE-RUNE-FOR-TYPE-SET NIL)
            (:REWRITE CAR-CONS)
            (:REWRITE CDR-CONS)
            (:TYPE-PRESCRIPTION ACL2-COUNT))
    Time:  0.02 seconds (prove: 0.01, print: 0.01, other: 0.00)
     :ATTACHMENTS-RECORDED
    ACL2 !>

  We close with some remarks on the checking of [guard]s in the case
  that [defattach] has been called with keyword argument :skip-checks
  t. We illustrate with examples, where we assume an attachment pair
  (f . g) created by an event (defattach ... (f g) ... :skip-checks t
  ...). A good model for the treatment of :skip-checks t is dependent
  on whether f was introduced with defproxy or with [encapsulate]:
  for defproxy, the normal guard-related checks are treated as
  skipped, while for [encapsulate], they are assumed to hold.

  First suppose that f was introduced using defproxy, and consider the
  following example.

    (defproxy f (*) => *)
    (defun g (x) (car x)) ; not guard-verified; implicit guard of t is too weak
    (defttag t) ; trust tag needed for :skip-checks t
    (defattach (f g) :skip-checks t)

  If we try to evaluate the form (f 3) in ACL2, then the top-level
  so-called ``executable counterpart'' (i.e., the logically-defined
  funcction, also known as the ``*1*'' function) of f is invoked. It
  calls the executable counterpart of g, which calls the executable
  counterpart of [car], which in turn checks the [guard] of [car] and
  causes a guard violation error (unless we first turn off
  guard-checking; see [set-guard-checking]).

    ACL2 !>(trace$ f g)
     ((F) (G))
    ACL2 !>(f 3)
    1> (ACL2_*1*_ACL2::F 3)
      2> (ACL2_*1*_ACL2::G 3)

    ACL2 Error in TOP-LEVEL:  The guard for the function call (CAR X),
    which is (OR (CONSP X) (EQUAL X NIL)), is violated by the arguments
    in the call (CAR 3).  To debug see :DOC print-gv, see :DOC trace, and
    see :DOC wet.  See :DOC set-guard-checking for information about suppressing
    this check with (set-guard-checking :none), as recommended for new
    users.

    ACL2 !>

  Little changes if we modify the example above by strengtheing the
  guard of g.

    (defproxy f (*) => *)
    (defun g (x)
      (declare (xargs :guard (consp x)))
      (car x))
    (defttag t) ; trust tag needed for :skip-checks t
    (defattach (f g) :skip-checks t)

  The result of evaluating (f 3) is as before, except that this time
  the guard violation occurs at the time that g is called.

    ACL2 !>(trace$ f g)
     ((F) (G))
    ACL2 !>(f 3)
    1> (ACL2_*1*_ACL2::F 3)
      2> (ACL2_*1*_ACL2::G 3)

    ACL2 Error in TOP-LEVEL:  The guard for the function call (G X), which
    is (CONSP X), is violated by the arguments in the call (G 3).  To debug
    see :DOC print-gv, see :DOC trace, and see :DOC wet.  See :DOC set-
    guard-checking for information about suppressing this check with (set-
    guard-checking :none), as recommended for new users.

    ACL2 !>

  Now consider a slight variation of the example just above, in which f
  is introduced using [encapsulate] instead of using defproxy.

    (encapsulate ( ((f *) => *) )
                 (local (defun f (x) x)))
    (defun g (x)
      (declare (xargs :guard (consp x)))
      (car x))
    (defttag t) ; trust tag needed for :skip-checks t
    (defattach (f g) :skip-checks t)

  Since f was introduced by [encapsulate] instead of by defproxy, ACL2
  assumes that the usual guard properties hold. In particular, it
  assumes that (informally speaking) the guard of f implies the guard
  of g; see [defattach] for details. So in this case, ACL2 proceeds
  under that assumption even though it's actually false, and the
  result is a raw Lisp error.

    ACL2 !>(trace$ f g)
     ((F) (G))
    ACL2 !>(f 3)
    1> (ACL2_*1*_ACL2::F 3)
      2> (G 3)

    ***********************************************
    ************ ABORTING from raw Lisp ***********
    Error:  Attempt to take the car of 3 which is not listp.
    ***********************************************

    If you didn't cause an explicit interrupt (Control-C),
    then the root cause may be call of a :program mode
    function that has the wrong guard specified, or even no
    guard specified (i.e., an implicit guard of t).
    See :DOC guards.

    To enable breaks into the debugger (also see :DOC acl2-customization):
    (SET-DEBUGGER-ENABLE T)
    ACL2 !>

  If you replace g by its definition in the first example of this
  series, i.e. with a guard (implicitly) of t, you will see the same
  error, this time because the [defattach] event assumed that g was
  guard-verified.")
 (DEFPUN
  (EVENTS)
  "Define a tail-recursive function symbol

  Defpun is a macro developed by Pete Manolios and J Moore that allows
  tail-recursive definitions. It is defined in community book
  books/misc/defpun.lisp, so to use it, execute the following event.

    (include-book \"misc/defpun\" :dir :system)

  Details of defpun are provided by Manolios and Moore in the ``Partial
  Functions in ACL2'' published with the ACL2 2000 workshop. Also see
  Partial Functions in ACL2.

  A variant, defp, has been developed by Matt Kaufmann to allow more
  general forms of tail recursion. If defpun doesn't work for you,
  try defp by first executing the following event.

    (include-book \"misc/defp\" :dir :system)

  Sandip Ray has contributed a variant of defpun, defpun-exec, that
  supports executability. See community book
  books/defexec/defpun-exec/defpun-exec.lisp:

    (include-book \"defexec/defpun-exec/defpun-exec\" :dir :system)

  He has also contributed community book
  books/misc/misc2/defpun-exec-domain-example.lisp, for functions
  that are uniquely defined in a particular domain.")
 (DEFREFINEMENT
  (EVENTS)
  "Prove that equiv1 refines equiv2

    Example:
    (defrefinement equiv1 equiv2)

    is an abbreviation for
    (defthm equiv1-refines-equiv2
      (implies (equiv1 x y) (equiv2 x y))
      :rule-classes (:refinement))

  See [refinement].

    General Form:
    (defrefinement equiv1 equiv2
      :rule-classes rule-classes
      :instructions instructions
      :hints hints
      :otf-flg otf-flg
      :event-name event-name
      :doc doc)

  where equiv1 and equiv2 are known [equivalence] relations,
  event-name, if supplied, is a symbol and all other arguments are as
  specified in the documentation for [defthm]. The defrefinement
  macro expands into a call of defthm. The name supplied is
  equiv1-refines-equiv2, unless event-name is supplied, in which case
  it is used as the name. The term supplied states that equiv1
  refines equiv2. The rule-class :refinement is added to the
  rule-classes specified, if it is not already there. All other
  arguments to the generated defthm form are as specified by the
  other keyword arguments above.")
 (DEFSTOBJ
  (EVENTS STOBJ)
  "Define a new single-threaded object

  Note: Novices are advised to avoid defstobj, perhaps instead using
  community books [std::defaggregate] or
  books/data-structures/structures.lisp. At the least, consider using
  ([set-verify-guards-eagerness] 0) to avoid [guard] verification. On
  the other hand, after you learn to use defstobj, see [defabsstobj]
  for another way to introduce single-threaded objects.

    Example:
    (defconst *mem-size* 10) ; for use of *mem-size* just below
    (defstobj st
              (reg :type (array (unsigned-byte 31) (8))
                   :initially 0)
              (p-c :type (unsigned-byte 31)
                   :initially 555)
              halt                  ; = (halt :type t :initially nil)
              (mem :type (array (unsigned-byte 31) (*mem-size*))
                   :initially 0 :resizable t))

    General Form:
    (defstobj name
              (field1 :type type1 :initially val1 :resizable b1)
              ...
              (fieldk :type typek :initially valk :resizable bk)
              :renaming alist
              :doc doc-string
              :inline flg
              :congruent-to old-stobj-name)

  where name is a new symbol, each fieldi is a symbol, each typei is
  either a type-indicator (a [type-spec] or [stobj] name) or of the
  form (ARRAY type-indicator max), each vali is an object satisfying
  typei, and each bi is t or nil. Each pair :initially vali and
  :resizable bi may be omitted; more on this below. The :renaming
  alist argument is optional and allows the user to override the
  default function names introduced by this event. The [doc-string]
  is also optional. The :inline flg Boolean argument is also optional
  and declares to ACL2 that the generated access and update functions
  for the stobj should be implemented as macros under the hood (which
  has the effect of inlining the function calls). The optional
  :congruent-to old-stobj-name argument specifies an existing stobj
  with exactly the same structure, and is discussed below. We
  describe further restrictions on the fieldi, typei, vali, and on
  alist below. We recommend that you read about single-threaded
  objects (stobjs) in ACL2 before proceeding; see [stobj].

  The effect of this event is to introduce a new single-threaded object
  (i.e., a ``[stobj]''), named name, and the associated recognizers,
  creator, accessors, updaters, constants, and, for fields of ARRAY
  type, length and resize functions.

  The Single-Threaded Object Introduced

  The defstobj event effectively introduces a new global variable,
  named name, which has as its initial logical value a list of k
  elements, where k is the number of ``field descriptors'' provided.
  The elements are listed in the same order in which the field
  descriptors appear. If the :type of a field is (ARRAY
  type-indicator (max)) then max is a non-negative integer or a
  symbol introduced by [defconst]) whose value is a non-negative
  integer, and the corresponding element of the stobj is initially of
  length specified by max.

  Whether the value :type is of the form (ARRAY type-indicator (max))
  or, otherwise, just type-indicator, then type-indicator is
  typically a type-spec; see [type-spec]. However, type-indicator can
  also be the name of a stobj that was previously introduced (by
  defstobj or [defabsstobj]). We ignore this ``nested stobj'' case
  below; see [nested-stobjs] for a discussion of stobjs within
  stobjs.

  The keyword value :initially val specifies the initial value of a
  field, except for the case of a :type (ARRAY type-indicator (max)),
  in which case val is the initial value of the corresponding array.

  Note that the actual representation of the stobj in the underlying
  Lisp may be quite different; see [stobj-example-2]. For the moment
  we focus entirely on the logical aspects of the object.

  In addition, the defstobj event introduces functions for recognizing
  and creating the stobj and for recognizing, accessing, and updating
  its fields. For fields of ARRAY type, length and resize functions
  are also introduced. Constants are introduced that correspond to
  the accessor functions.

  Restrictions on the Field Descriptions in Defstobj

  Each field descriptor is of the form:

    (fieldi :TYPE typei :INITIALLY vali)

  Note that the type and initial value are given in ``keyword
  argument'' format and may be given in either order. The typei and
  vali ``arguments'' are not evaluated. If omitted, the type defaults
  to t (unrestricted) and the initial value defaults to nil.

  Each typei must be either a [type-spec] or else a list of the form
  (ARRAY type-spec (max)). (Again, we are ignoring the case of nested
  stobjs, discussed elsewhere; see [nested-stobjs].) The latter forms
  are said to be ``array types.'' Examples of legal typei are:

    (INTEGER 0 31)
    (SIGNED-BYTE 31)
    (ARRAY (SIGNED-BYTE 31) (16))
    (ARRAY (SIGNED-BYTE 31) (*c*)) ; where *c* has a non-negative integer value

  The typei describes the objects which are expected to occupy the
  given field. Those objects in fieldi should satisfy typei. We are
  more precise below about what we mean by ``expected.'' We first
  present the restrictions on typei and vali.

  Non-Array Types

  When typei is a [type-spec] it restricts the contents, x, of fieldi
  according to the ``meaning'' formula given in the table for
  [type-spec]. For example, the first typei above restricts the field
  to be an integer between 0 and 31, inclusive. The second restricts
  the field to be an integer between -2^30 and (2^30)-1, inclusive.

  The initial value, vali, of a field description may be any ACL2
  object but must satisfy typei. Note that vali is not a form to be
  evaluated but an object. A form that evaluates to vali could be
  written 'vali, but defstobj does not expect you to write the quote
  mark. For example, the field description

    (days-off :initially (saturday sunday))

  describes a field named days-off whose initial value is the list
  consisting of the two symbols SATURDAY and SUNDAY. In particular,
  the initial value is NOT obtained by applying the function saturday
  to the variable sunday! Had we written

    (days-off :initially '(saturday sunday))

  it would be equivalent to writing

    (days-off :initially (quote (saturday sunday)))

  which would initialize the field to a list of length two, whose first
  element is the symbol quote and whose second element is a list
  containing the symbols saturday and sunday.

  Array Types

  When typei is of the form (ARRAY type-spec (max)), the field is
  supposed to be a list of items, initially of length specified by
  max, each of which satisfies the indicated type-spec. Max must be a
  non-negative integer or a defined constant evaluating to a
  non-negative integer. Thus, each of

    (ARRAY (SIGNED-BYTE 31) (16))
    (ARRAY (SIGNED-BYTE 31) (*c*)) ; given previous event (defconst *c* 16)

  restricts the field to be a list of integers, initially of length 16,
  where each integer in the list is a (SIGNED-BYTE 31). We sometimes
  call such a list an ``array'' (because it is represented as an
  array in the underlying Common Lisp). The elements of an array
  field are indexed by position, starting at 0. Thus, the maximum
  legal index of an array field one less than is specified by max.
  Note that the value of max must be less than the Common Lisp
  constant array-dimension-limit, and also (though this presumably
  follows) less than the Common Lisp constant array-total-size-limit.

  Note also that the ARRAY type requires that the max be enclosed in
  parentheses. This makes ACL2's notation consistent with the Common
  Lisp convention of describing the (multi-)dimensionality of arrays.
  But ACL2 currently supports only single dimensional arrays in
  stobjs.

  For array fields, the initial value vali must be an object satisfying
  the [type-spec] of the ARRAY description. The initial value of the
  field is a list of max repetitions of vali.

  Array fields can be ``resized,'' that is, their lengths can be
  changed, if :resizable t is supplied as shown in the example and
  General Form above. The new length must satisfy the same
  restriction as does max, as described above. Each array field in a
  defstobj event gives rise to a length function, which gives the
  length of the field, and a resize function, which modifies the
  length of the field if :resizable t was supplied with the field
  when the defstobj was introduced and otherwise causes an error. If
  :resizable t was supplied and the resize function specifies a new
  length k, then: if k is less than the existing array length, the
  array is shortened simply by dropping elements with index at least
  k; otherwise, the array is extended to length k by mapping the new
  indices to the initial value (supplied by :initially, else default
  nil).

  Array resizing is relatively slow, so we recommend using it somewhat
  sparingly.

  The Default Function Names

  To recap, in

    (defstobj name
              (field1 :type type1 :initially val1)
              ...
              (fieldk :type typek :initially valk)
              :renaming alist
              :doc doc-string
              :inline inline-flag)

  name must be a new symbol, each fieldi must be a symbol, each typei
  must be a [type-spec] or (ARRAY type-spec (max)), and each vali
  must be an object satisfying typei.

  Roughly speaking, for each fieldi, a defstobj introduces a recognizer
  function, an accessor function, and an updater function. The
  accessor function, for example, takes the stobj and returns the
  indicated component; the updater takes a new component value and
  the stobj and return a new stobj with the component replaced by the
  new value. But that summary is inaccurate for array fields.

  The accessor function for an array field does not take the stobj and
  return the indicated component array, which is a list of length
  specified by max. Instead, it takes an additional index argument
  and returns the indicated element of the array component.
  Similarly, the updater function for an array field takes an index,
  a new value, and the stobj, and returns a new stobj with the
  indicated element replaced by the new value.

  These functions --- the recognizer, accessor, and updater, and also
  length and resize functions in the case of array fields --- have
  ``default names.'' The default names depend on the field name,
  fieldi, and on whether the field is an array field or not. For
  clarity, suppose fieldi is named c. The default names are shown
  below in calls, which also indicate the arities of the functions.
  In the expressions, we use x as the object to be recognized by
  field recognizers, i as an array index, v as the ``new value'' to
  be installed by an updater, and name as the single-threaded object.

                     non-array field        array field
    recognizer         (cP x)                (cP x)
    accessor           (c name)              (cI i name)
    updater            (UPDATE-c v name)     (UPDATE-cI i v name)
    length                                   (c-LENGTH name)
    resize                                   (RESIZE-c k name)

  Finally, a recognizer and a creator for the entire single-threaded
  object are introduced. The creator returns the initial stobj, but
  may only be used in limited contexts; see [with-local-stobj]. If
  the single-threaded object is named name, then the default names
  and arities are as shown below.

    top recognizer     (nameP x)
    creator            (CREATE-name)

  For example, the event

    (DEFSTOBJ $S
      (X :TYPE INTEGER :INITIALLY 0)
      (A :TYPE (ARRAY (INTEGER 0 9) (3)) :INITIALLY 9))

  introduces a stobj named $S. The stobj has two fields, X and A. The A
  field is an array. The X field contains an integer and is initially
  0. The A field contains a list of integers, each between 0 and 9,
  inclusively. Initially, each of the three elements of the A field
  is 9.

  This event introduces the following sequence of definitions:

    (DEFUN XP (X) ...)               ; recognizer for X field
    (DEFUN AP (X) ...)               ; recognizer of A field
    (DEFUN $SP ($S) ...)             ; top-level recognizer for stobj $S
    (DEFUN CREATE-$S () ...)         ; creator for stobj $S
    (DEFUN X ($S) ...)               ; accessor for X field
    (DEFUN UPDATE-X (V $S) ...)      ; updater for X field
    (DEFUN A-LENGTH ($S) ...)        ; length of A field
    (DEFUN RESIZE-A (K $S) ...)      ; resizer for A field
    (DEFUN AI (I $S) ...)            ; accessor for A field at index I
    (DEFUN UPDATE-AI (I V $S) ...)   ; updater for A field at index I

  Avoiding the Default Function Names

  If you do not like the default names listed above you may use the
  optional :renaming alist to substitute names of your own choosing.
  Each element of alist should be of the form (fn1 fn2), where fn1 is
  a default name and fn2 is your choice for that name.

  For example

    (DEFSTOBJ $S
      (X :TYPE INTEGER :INITIALLY 0)
      (A :TYPE (ARRAY (INTEGER 0 9) (3)) :INITIALLY 9)
      :renaming ((X XACCESSOR) (CREATE-$S MAKE$S)))

  introduces the following definitions

    (DEFUN XP (X) ...)               ; recognizer for X field
    (DEFUN AP (X) ...)               ; recognizer of A field
    (DEFUN $SP ($S) ...)             ; top-level recognizer for stobj $S
    (DEFUN MAKE$S () ...)            ; creator for stobj $S
    (DEFUN XACCESSOR ($S) ...)       ; accessor for X field
    (DEFUN UPDATE-X (V $S) ...)      ; updater for X field
    (DEFUN A-LENGTH ($S) ...)        ; length of A field
    (DEFUN RESIZE-A (K $S) ...)      ; resizer for A field
    (DEFUN AI (I $S) ...)            ; accessor for A field at index I
    (DEFUN UPDATE-AI (I V $S) ...)   ; updater for A field at index I

  Note that even though the renaming alist substitutes ``XACCESSOR''
  for ``X'' the updater for the X field is still called ``UPDATE-X.''
  That is because the renaming is applied to the default function
  names, not to the field descriptors in the event.

  Use of the :renaming alist may be necessary to avoid name clashes
  between the default names and and pre-existing function symbols.

  Constants

  Defstobj events also introduce constant definitions (see [defconst]).
  One constant is introduced for each accessor function by prefixing
  and suffixing a `*' character on the function name. The value of
  that constant is the position of the field being accessed. For
  example, if the accessor functions are a, b, and c, in that order,
  then the following constant definitions are introduced.

    (defconst *a* 0)
    (defconst *b* 1)
    (defconst *c* 2)

  These constants are used for certain calls of [nth] and [update-nth]
  that are displayed to the user in proof output. For example, for
  stobj st with accessor functions a, b, and c, in that order, the
  term (nth '2 st) would be printed during a proof as (nth *c* st).
  Also see [term], in particular the discussion there of untranslated
  terms, and see [nth-aliases-table].

  Inspecting the Effects of a Defstobj

  Because the stobj functions are introduced as ``sub-events'' of the
  defstobj the history commands :[pe] and :[pc] will not print the
  definitions of these functions but will print the superior defstobj
  event. To see the definitions of these functions use the history
  command :[pcb!].

  To see an s-expression containing the definitions what constitute the
  raw Lisp implementation of the event, evaluate the form

    (nth 4 (global-val 'cltl-command (w state)))

  immediately after the defstobj event has been processed.

  A defstobj is considered redundant only if the name, field
  descriptors, renaming alist, and inline flag are identical to a
  previously executed defstobj. Note that a redundant defstobj does
  not reset the [stobj] fields to their initial values.

  Inlining and Performance

  The :inline keyword argument controls whether or not accessor,
  updater, and length functions are inlined (as macros under the
  hood, in raw Lisp). If :inline t is provided then these are
  inlined; otherwise they are not. The advantage of inlining is
  potentially better performance; there have been contrived examples,
  doing essentially nothing except accessing and updating array
  fields, where inlining reduced the time by a factor of 10 or more;
  and inlining has sped up realistic examples by a factor of at least
  2. Inlining may get within a factor of 2 of C execution times for
  such contrived examples, and within a few percent of C execution
  times on realistic examples.

  A drawback to inlining is that redefinition may not work as expected,
  much as redefinition may not work as expected for macros: defined
  functions that call a macro, or inlined stobj function, will not
  see a subsequent redefinition of the macro or inlined function.
  Another drawback to inlining is that because inlined functions are
  implemented as macros in raw Lisp, tracing (see [trace$]) will not
  show their calls. These drawbacks are avoided by default, but the
  user who is not concerned about them is advised to specify :inline
  t.

  Specifying Congruent Stobjs

  Two stobjs are may be considered to be ``congruent'' if they have the
  same structure, that is, their defstobj events are identical when
  ignoring field names. In particular, every stobj is congruent to
  itself. In order to tell ACL2 that a new stobj st2 is indeed to be
  considered as congruent to an existing stobj st1, the defstobj
  event introducing st2 is given the keyword argument :congruent-to
  st1. Congruence is an equivalence relation: when you specify a new
  stobj to be congruent to an old one, you are also specifying that
  the new stobj is congruent to all other stobjs that are congruent
  to the old one. Thus, continuing the example above, if you specify
  that st3 is :congruent-to st2, then st1, st2, and st3 will all be
  congruent to each other.

  When two stobjs are congruent, ACL2 allows you to substitute one for
  another in a function call. Any number of stobjs may be replaced
  with congruent stobjs in the call, provided no two get replaced
  with the same stobj. The return values are correspondingly
  modified: if stobj st1 is replaced by st2 at an argument position,
  and if st1 is returned in the output [signature] of the function,
  then st2 is returned in place of st1.

  The following example illustrates congruent stobjs. For more examples
  of how to take advantage of congruent stobjs, and also of how to
  misuse them, see community book
  books/misc/congruent-stobjs-test.lisp.

    (defstobj st1 fld1)
    (defstobj st2 fld2 :congruent-to st1)
    (defstobj st3 fld3 :congruent-to st2) ; equivalently, :congruent-to st1
    (defun f (st1 st2 st3)
      (declare (xargs :stobjs (st1 st2 st3)))
      (list (fld2 st1) (fld3 st2) (fld1 st3)))
    (update-fld1 1 st1)
    (update-fld1 2 st2) ; notice use of update-fld1 on st2
    (update-fld1 3 st3) ; notice use of update-fld1 on st3
    (assert-event (equal (f st3 st2 st1) '(3 2 1)))

  The following example shows an error that occurs when stobj arguments
  are repeated, i.e., at least two stobj arguments (in this case,
  three) get replaced by the same stobj.

    ACL2 !>(f st1 st1 st1)

    ACL2 Error in TOP-LEVEL:  The form ST1 is being used, as an argument
    to a call of F, where the single-threaded object ST2 was expected,
    even though these are congruent stobjs.  See :DOC defstobj, in particular
    the discussion of congruent stobjs.  Note:  this error occurred in
    the context (F ST1 ST1 ST1).

    ACL2 !>")
 (DEFSTUB
  (EVENTS)
  "Stub-out a function symbol

    Examples:
    ACL2 !>(defstub subr1 (* * state) => (mv * state))
    ACL2 !>(defstub add-hash (* * hashtable) => hashtable)

    General Forms:
    (defstub name args-sig => output-sig)
    (defstub name args-sig => output-sig :doc doc-string)

  Name is a new function symbol and (name . args-sig) => output-sig) is
  a [signature]. If the optional [doc-string] is supplied it should
  be a documentation string. See also the ``Old Style'' heading
  below.

  Defstub macro expands into an [encapsulate] event (see
  [encapsulate]). Thus, no axioms are available about name but it may
  be used wherever a function of the given signature is permitted.
  Exception: if output-sig is of the form (mv ...), then a
  :[type-prescription] rule is introduced stating that name returns a
  value satisfying [true-listp].

  Old Style:

    Old Style General Form:
    (defstub name formals output)
    (defstub name formals output :doc doc-string)

  where name is a new function symbol, formals is its list of formal
  parameters, and output is either a symbol (indicating that the
  function returns one result) or a term of the form (mv s1 ... sn),
  where each si is a symbol (indicating that the function returns n
  results). Whether and where the symbol [state] occurs in formals
  and output indicates how the function handles [state]. It should be
  the case that (name formals output) is in fact a signature (see
  [signature]).

  Note that with the old style notation it is impossible to stub-out a
  function that uses any single-threaded object other than state. The
  old style is preserved for compatibility with earlier versions of
  ACL2.")
 (DEFTHEORY
  (EVENTS THEORIES)
  "Define a theory (to [enable] or [disable] a set of rules)

    Example:
    (deftheory interp-theory
               (set-difference-theories
                 (universal-theory :here)
                 (universal-theory 'interp-section)))

    General Form:
    (deftheory name term :doc doc-string)

  where name is a new symbolic name (see [name]), term is a term that
  when evaluated will produce a theory (see [theories]), and
  [doc-string] is an optional [documentation] string (see
  [doc-string]). Except for the variable [world], term must contain
  no free variables. Term is evaluated with [world] bound to the
  current world (see [world]) and the resulting theory is then
  converted to a runic theory (see [theories]) and associated with
  name. Henceforth, this runic theory is returned as the value of the
  theory expression (theory name).

  The value returned is the length of the resulting theory. For
  example, in the following, the theory associated with 'FOO has 54
  [rune]s:

    ACL2 !>(deftheory foo (union-theories '(binary-append)
                                          (theory 'minimal-theory)))

    Summary
    Form:  ( DEFTHEORY FOO ...)
    Rules: NIL
    Warnings:  None
    Time:  0.00 seconds (prove: 0.00, print: 0.00, other: 0.00)
     54
    ACL2 !>

  Note that the theory being defined depends on the context. For
  example, consider the following (contrived) example book.

    (in-package \"ACL2\")
    (defund foo (x) (consp x)) ; defund disables foo
    (local (in-theory (enable foo)))
    (deftheory my-theory (current-theory :here))
    (in-theory (disable foo))
    (defthm foo-property
      (implies (consp x)
               (foo x))
      :hints ((\"Goal\" :in-theory (enable my-theory))))

  At the time foo-property is proved admissible during book
  certification (see [certify-book]), the [local] [in-theory] event
  has previously been evaluated, so the [definition] of foo is
  [enable]d. Thus, the :in-theory hint on foo-property will [enable]
  foo, and the theorem proves. HOWEVER, when the book is later
  included (see [include-book]), the [local] event is skipped, so the
  definition of foo is [disable]d at the time the [theory] my-theory
  is defined. Hence, unlike the case for the admissibility pass of
  the book's certification, that theory does not include the
  definition of foo when the book is included.

  There is, however, a way to ensure that a [theory] defined in a book
  is the same at [include-book] time as it was during the
  admissibility pass of the book's certification; see
  [deftheory-static].")
 (DEFTHEORY-STATIC
  (EVENTS THEORIES)
  "Define a `static' theory (to [enable] or [disable] a set of rules)

  This macro provides a variant of [deftheory], such that the resulting
  theory is the same at [include-book] time as it was at
  [certify-book] time.

  We assume that the reader is familiar with [theories]; see
  [deftheory]. We begin here by illustrating how deftheory-static
  differs from [deftheory]. Suppose for example that the following
  events are the first two events in a book, where that book is
  certified in the initial ACL2 [world] (see [ground-zero]).

    (deftheory my-theory
      (current-theory :here))
    (deftheory-static my-static-theory
      (current-theory :here))

  Now suppose we include that book after executing the following event.

    (in-theory (disable car-cons))

  Suppose that later we execute (in-theory (theory 'my-theory)). Then
  the rule car-cons will be disabled, because it was disabled at the
  time the expression (current-theory :here) was evaluated when
  processing the deftheory of my-theory while including the book.
  However, if we execute (in-theory (theory 'my-static-theory)), then
  the rule car-cons will be enabled, because the value of the theory
  my-static-theory was saved at the time the book was certified.

    General Form:
    (deftheory-static name term :doc doc-string)

  The arguments are handled the same as for [deftheory]. Thus, name is
  a new symbolic name (see [name]), term is a term that when
  evaluated will produce a theory (see [theories]), and [doc-string]
  is an optional [documentation] string (see [doc-string]). Except
  for the variable [world], term must contain no free variables. Term
  is evaluated with [world] bound to the current world (see [world])
  and the resulting theory is then converted to a runic theory (see
  [theories]) and associated with name. Henceforth, this runic theory
  is returned as the value of the theory expression (theory name).

  As for [deftheory], the value returned is the length of the resulting
  theory.

  We conclude with an optional discussion about the implementation of
  deftheory-static, for those familiar with [make-event]. The
  following macroexpansion of the deftheory-static form above shows
  how this works (see [trans1]).

    ACL2 !>:trans1 (deftheory-static my-static-theory
                     (current-theory :here))
     (MAKE-EVENT (LET ((WORLD (W STATE)))
                      (LIST 'DEFTHEORY
                            'MY-STATIC-THEORY
                            (LIST 'QUOTE (CURRENT-THEORY :HERE)))))
    ACL2 !>

  The idea is that upon evaluation of this make-event form, the first
  step is to evaluate the indicated [let] expression to obtain a form
  (deftheory my-theory '(...)), where ``(...)'' is a list of all
  [rune]s in current theory. If this form is in a book being
  certified, then the resulting deftheory form is stored in the
  book's certificate, and is used when the book is included later.")
 (DEFTHM
  (EVENTS)
  "Prove and name a theorem

    Examples:
    (defthm assoc-of-app
            (equal (app (app a b) c)
                   (app a (app b c))))

  The following nonsensical example illustrates all the optional
  arguments but is illegal because not all combinations are
  permitted. See [hints] for a complete list of [hints].

    (defthm main
            (implies (hyps x y z) (concl x y z))
           :rule-classes (:REWRITE :GENERALIZE)
           :instructions (induct prove promote (dive 1) x
                                 (dive 2) = top (drop 2) prove)
           :hints ((\"Goal\"
                    :do-not '(generalize fertilize)
                    :in-theory (set-difference-theories
                                 (current-theory :here)
                                 '(assoc))
                    :induct (and (nth n a) (nth n b))
                    :use ((:instance assoc-of-append
                                     (x a) (y b) (z c))
                          (:functional-instance
                            (:instance p-f (x a) (y b))
                            (p consp)
                            (f assoc)))))
           :otf-flg t
           :doc \"#0[one-liner/example/details]\")

    General Form:
    (defthm name term
            :rule-classes rule-classes
            :instructions instructions
            :hints        hints
            :otf-flg      otf-flg
            :doc          doc-string)

  where name is a new symbolic name (see [name]), term is a term
  alleged to be a theorem, and [rule-classes], [instructions],
  [hints], [otf-flg] and [doc-string] are as described in their
  respective [documentation]. The five keyword arguments above are
  all optional, however you may not supply both :[instructions] and
  :[hints], since one drives the proof checker and the other drives
  the theorem prover. If :[rule-classes] is not specified, the list
  (:rewrite) is used; if you wish the theorem to generate no rules,
  specify :[rule-classes] nil.

  When ACL2 processes a defthm event, it first tries to prove the
  [term] using the indicated hints (see [hints]) or [instructions]
  (see [proof-checker]). If it is successful, it stores the rules
  described by the rule-classes (see [rule-classes]), proving the
  necessary corollaries.


Subtopics

  [Otf-flg]
      Allow more than one initial subgoal to be pushed for induction")
 (DEFTHMD
  (EVENTS)
  "Prove and name a theorem and then disable it

  Use defthmd instead of [defthm] when you want to disable a theorem
  immediately after proving it. This macro has been provided for
  users who prefer working in a mode where theorems are only enabled
  when explicitly directed by :[in-theory]. Specifically, the form

    (defthmd NAME TERM ...)

  expands to:

    (progn
      (defthmd NAME TERM ...)
      (with-output
       :off summary
       (in-theory (disable NAME)))
      (value-triple '(:defthmd NAME))).

  Note that defthmd commands are never redundant (see
  [redundant-events]). Even if the defthm event is redundant, then
  the [in-theory] event will still be executed.

  The summary for the [in-theory] event is suppressed. See [defthm] for
  documentation of defthm.")
 (DEFTTAG
  (INTERFACING-TOOLS EVENTS)
  "Introduce a trust tag (ttag)

  Introduction. This event is intended for advanced users who, in
  essence, want to build extensions of ACL2. The typical intended use
  is to create [books] that extend the functionality of ACL2 in ways
  not allowed without a so-called ``active trust tag''. A trust tag
  thus represents a contract: The writer of such a book is
  guaranteeing that the book extends ACL2 in a ``correct'' way as
  defined by the writer of the book. The writer of the book will
  often have a small section of the book in the scope of an active
  trust tag that can be inspected by potential users of that book:

    <initial part of book, which does not use trust tags>
    (defttag :some-ttag) ; install :some-ttag as an active trust tag
    <various code that requires an active trust tag>
    (defttag nil)        ; remove active trust tag
    <initial part of book, which does not use trust tags>

  Why might trust tags be needed? The evaluation of certain functions
  can introduce bugs and even unsoundness, but can be useful in
  restricted ways that avoid such issues. For example, [sys-call] can
  be used in an unsafe way, for example to overwrite files, or worse;
  see [sys-call] for a frightening example from Bob Boyer. The
  following example shows that the function [sys-call] is restricted
  by default, but can be called after installing an active trust tag.

    ACL2 !>(sys-call \"pwd\" nil)

    ACL2 Error in TOP-LEVEL:  The SYS-CALL function cannot be called unless
    a trust tag is in effect.  See :DOC defttag.

    ACL2 !>(defttag t) ; Install :T as an active trust tag.

    TTAG NOTE: Adding ttag :T from the top level loop.
     T
    ACL2 !>(sys-call \"pwd\" nil) ; print the current directory and return NIL
    /u/kaufmann
    NIL
    ACL2 !>(defttag nil) ; Remove the active trust tag (using value NIL).
     NIL
    ACL2 !>(sys-call \"pwd\" nil) ; Now we get the error again:

    ACL2 Error in TOP-LEVEL:  The SYS-CALL function cannot be called unless
    a trust tag is in effect.  See :DOC defttag.

    ACL2 !>

  Of course, using [sys-call] with the Linux command pwd is not likely
  to cause any soundness problems! So suppose we want to create a
  function that prints the working directory. We might put the
  following [events] into a book that is to be certified.

    (in-package \"ACL2\")
    (defttag :pwd-ttag)
    (defun print-working-dir ()
      (declare (xargs :mode :program))
      (sys-call \"pwd\" nil))
    (defttag nil) ; optional (books end with this implicitly)

  We can certify this book with a specification that :pwd-ttag is a
  legal trust tag:

    (certify-book \"pwd\" 0 t :ttags (:pwd-ttag))

  One can now use this book by executing [include-book] with keyword
  parameter :ttags (:pwd-ttag) and then calling function
  print-working-dir:

    (include-book \"pwd\" :ttags (:pwd-ttag))
    (print-working-dir) ; working directory is printed to terminal

  Detailed documentation.

    General Forms:
    (defttag tag-name)
    (defttag tag-name :doc doc-string)

  where tag-name is a symbol. The :doc doc-string argument is optional;
  if supplied, then it must be a valid [documentation] string (see
  [doc-string]), and the defttag call will generate a corresponding
  [defdoc] event for tag-name. (For the rest of this discussion we
  ignore the :doc argument.)

  Note however that (other than the :doc argument), if tag-name is not
  nil then it is converted to a ``corresponding [keyword]'': a symbol
  in the \"KEYWORD\" package with the same [symbol-name] as tag-name.
  Thus, for example, (defttag foo) is equivalent to (defttag :foo).
  Moreover, a non-nil symbol with a [symbol-name] of \"NIL\" is illegal
  for trust tags; thus, for example, (defttag :nil) is illegal.

  This event introduces or removes a so-called active trust tag (or
  ``ttag'', pronounced ``tee tag''). An active ttag is a [keyword]
  symbol that is associated with potentially unsafe evaluation. For
  example, calls of [sys-call] are illegal unless there is an active
  trust tag. An active trust tag can be installed using a defttag
  event. If one introduces an active ttag and then writes definitions
  that calls [sys-call], presumably in a defensibly ``safe'' way,
  then responsibility for those calls is attributed to that ttag.
  This attribution (or blame!) is at the level of [books]; a book's
  [certificate] contains a list of ttags that are active in that
  book, or in a book that is included (possibly [local]ly), or in a
  book included in a book that is included (either inclusion being
  potentially [local]), and so on. We explain all this in more detail
  below.

  (Defttag :tag-name) is essentially equivalent to

    (table acl2-defaults-table :ttag :tag-name)

  and hence is [local] to any [books] and [encapsulate] [events] in
  which it occurs; see [ACL2-defaults-table]. We say more about the
  scope of defttag forms below.

  Note: This is an event! It does not print the usual event summary but
  nevertheless executes the above [table] event and hence changes the
  ACL2 logical [world], and is so recorded. Although no event summary
  is printed, it is important to note that the ``TTAG NOTE'',
  discussed below, is always printed for a non-nil :tag-name (unless
  deferred; see [set-deferred-ttag-notes]).

  Active ttags. Suppose tag-name is a non-nil symbol. Then (defttag
  :tag-name) sets :tag-name to be the (unique) ``active ttag.'' There
  must be an active ttag in order for there to be any mention of
  certain function and macro symbols, including [sys-call]; evaluate
  the form (strip-cars *ttag-fns-and-macros*) to see the full list of
  such symbols. On the other hand, (defttag nil) removes the active
  ttag, if any; there is then no active ttag. The scope of a defttag
  form in a book being certified or included is limited to subsequent
  forms in the same book before the next defttag (if any) in that
  book. Similarly, if a defttag form is evaluated in the top-level
  loop, then its effect is limited to subsequent forms in the
  top-level loop before the next defttag in the top-level loop (if
  any). Moreoever, [certify-book] is illegal when a ttag is active;
  of course, in such a circumstance one can execute (defttag nil) in
  order to allow book certification.

  Ttag notes and the ``certifier.'' When a defttag is executed with an
  argument other than nil, output is printed, starting on a fresh
  line with: TTAG NOTE. For example:

    ACL2 !>(defttag :foo)

    TTAG NOTE: Adding ttag :FOO from the top level loop.
     :FOO
    ACL2 !>

  If the defttag occurs in an included book, the message looks like
  this.

    TTAG NOTE (for included book): Adding ttag :FOO from file /u/smith/acl2/my-book.lisp.

  The ``TTAG NOTE'' message is always printed on a single line. The
  intention is that one can search the standard output for all such
  notes in order to find all defttag events. In a sense, defttag
  events can allow you to define your own system on top of ACL2 (for
  example, see [progn!]). So in order for someone else (who we might
  call the ``certifier'') to be confident that your collection of
  [books] is meaningful, that certifier should certify all the
  user-supplied books from scratch and check either that no :ttags
  were supplied to [certify-book], or else look for every TTAG NOTE
  in the standard output in order to locate all defttag [events] with
  non-nil tag name. In this way, the certifier can in principle
  decide whether to be satisfied that those defttag events did not
  allow inappropriate forms in the user-supplied books.

  In order to eliminate much of the output from TTAG NOTEs, see
  [set-deferred-ttag-notes]. Note however that the resulting security
  is somewhat less; therefore, a TTAG NOTE is printed when invoking
  set-deferred-ttag-notes to defer printing of ttag notes.

  Allowed ttags when certifying and including books. A defttag form may
  not be evaluated unless its argument is a so-called ``allowed''
  ttag. All ttags are allowed in the interactive top-level loop.
  However, during [certify-book] and [include-book], the set of
  allowed ttags is restricted according to the :ttags keyword
  argument. If this argument is omitted then no ttag is allowed, so a
  defttag call will fail during book certification or inclusion in
  this case. This restriction applies even to defttag forms already
  evaluated in the so-called certification [world] at the time
  [certify-book] is called. But note that (defttag nil) is always
  legal.

  A :ttags argument of [certify-book] and [include-book] can have value
  :all, indicating that every ttag is allowed, i.e., no restriction
  is being placed on the arguments, just as in the interactive
  top-level loop. In the case of include-book, an omitted :ttags
  argument or an argument of :default is treated as :all, except that
  warnings will occur when the book's [certificate] includes ttags;
  but for certify-book, an omitted ttags argument is treated as nil.
  Otherwise, if the :ttags argument is supplied but not :all, then
  its value is a true list of ttag specifications, each having one of
  the following forms, where sym is a non-nil symbol which is treated
  as the corresponding [keyword].

      (1) :sym

      (2) (:sym)

      (3) (:sym x1 x2 ... xk), where k > 0 and each xi is a string, except
      that one xi may be nil.

  In Case (1), (defttag :sym) is allowed to occur in at most one book
  or else in the top-level loop (i.e., the certification world for a
  book under certification or a book being included). Case (2) allows
  (defttag :sym) to occur in an unlimited number of books. For case
  (3) the xi specify where (defttag :sym) may occur, as follows. The
  case that xi is nil refers to the top-level loop, while all other
  xi are filenames, where the \".lisp\" extension is optional and
  relative pathnames are considered to be relative to the connected
  book directory (see [cbd]). Note that the restrictions on (defttag
  :sym) apply equally to any equivalent for based on the notion of
  ``corresponding keyword'' discussed above, e.g., (defttag
  acl2::sym).

  An error message, as shown below, illustrates how ACL2 enforcess the
  notion of allowed ttags. Suppose that you call [certify-book] with
  argument :ttags (:foo), where you have already executed (defttag
  :foo) in the certification world (i.e., before calling
  [certify-book]). Then ACL2 immediately associates the ttag :foo
  with nil, where again, nil refers to the top-level loop. If ACL2
  then encounters (defttag foo) inside that book, you will get the
  following error (using the full book name for the book, as shown):

    ACL2 Error in ( TABLE ACL2-DEFAULTS-TABLE ...):  The ttag :FOO associated
    with file /u/smith/work/my-book.lisp is not among the set of ttags permitted
    in the current context, specified as follows:
      ((:FOO NIL)).
    See :DOC defttag.

  In general the structure displayed by the error message, which is
  ((:FOO NIL)) in this case, represents the currently allowed ttags
  with elements as discussed in (1) through (3) above. In this case,
  that list's unique element is (:FOO NIL), meaning that ttag :FOO is
  only allowed at the top level (as represented by NIL).

  Associating ttags with books and with the top-level loop. When a book
  is certified, each form (defttag tag) that is encountered for
  non-nil tag in that book or an included book is recorded in the
  generated [certificate], which associates the keyword corresponding
  to tag with the [full-book-name] of the book containing that
  deftag. If such a defttag form is encountered outside a book, hence
  in the [portcullis] of the book being certified or one of its
  included books, then that keyword is associated with nil in the
  generated [certificate]. Note that the notion of ``included book''
  here applies to the recursive notion of a book either included
  directly in the book being certified or else included in such a
  book, where we account even for [local]ly included books.

  For examples of ways to take advantage of ttags, see [hacker],
  [include-raw], [quicklisp], and more generally [interfacing-tools].
  See also [ttags-seen], [progn!], [remove-untouchable],
  [set-raw-mode], and [sys-call].")
 (DEFUN
  (EVENTS PROGRAMMING)
  "Define a function symbol

    Examples:
    (defun app (x y)
      (if (consp x)
          (cons (car x) (app (cdr x) y))
          y))

    (defun fact (n)
      (declare (xargs :guard (and (integerp n)
                                  (>= n 0))))
      (if (zp n)
          1
          (* n (fact (1- n)))))

    General Form:
    (defun fn (var1 ... varn) doc-string dcl ... dcl body),

  where fn is the symbol you wish to define and is a new symbolic name
  (see [name]), (var1 ... varn) is its list of formal parameters (see
  [name]), and body is its body. The definitional axiom is logically
  admissible provided certain restrictions are met. These are
  sketched below.

  Note that ACL2 does not support the use of lambda-list keywords (such
  as &optional) in the formals list of functions. We do support some
  such keywords in macros and often you can achieve the desired
  syntax by defining a macro in addition to the general version of
  your function. See [defmacro]. The [documentation] string,
  [doc-string], is optional; for a description of its form, see
  [doc-string].

  The declarations (see [declare]), dcl, are also optional. If more
  than one dcl form appears, they are effectively grouped together as
  one. Perhaps the most commonly used ACL2 specific declaration is of
  the form (declare (xargs :guard g :measure m)). This declaration in
  the defun of some function fn has the effect of making the
  ``[guard]'' for fn be the term g and the ``measure'' be the term m.
  The notion of ``measure'' is crucial to ACL2's definitional
  principle. The notion of ``guard'' is not, and is discussed
  elsewhere; see [verify-guards] and see
  [set-verify-guards-eagerness]. Note that the :measure is ignored in
  :[program] mode; see [defun-mode].

  We now briefly discuss the ACL2 definitional principle, using the
  following definition form which is offered as a more or less
  generic example.

    (defun fn (x y)
      (declare (xargs :guard (g x y)
                      :measure (m x y)))
      (if (test x y)
          (stop x y)
        (step (fn (d x) y))))

  Note that in our generic example, fn has just two arguments, x and y,
  the [guard] and measure terms involve both of them, and the body is
  a simple case split on (test x y) leading to a ``non-recursive''
  branch, (stop x y), and a ``recursive'' branch. In the recursive
  branch, fn is called after ``decrementing'' x to (d x) and some
  step function is applied to the result. Of course, this generic
  example is quite specific in form but is intended to illustrate the
  more general case.

  Provided this definition is admissible under the logic, as outlined
  below, it adds the following axiom to the logic.

    Defining Axiom:
    (fn x y)
      =
    (if (test x y)
        (stop x y)
      (step (fn (d x) y)))

  Note that the [guard] of fn has no bearing on this logical axiom.

  This defining axiom is actually implemented in the ACL2 system by a
  :[definition] rule, namely

    (equal (fn x y)
           (if (test a b)
               (stop a b)
             (step (fn (d a) b)))).

  See [definition] for a discussion of how definition rules are
  applied. Roughly speaking, the rule causes certain instances of (fn
  x y) to be replaced by the corresponding instances of the body
  above. This is called ``opening up'' (fn x y). The instances of (fn
  x y) opened are chosen primarily by heuristics which determine that
  the recursive calls of fn in the opened body (after simplification)
  are more desirable than the unopened call of fn.

  This discussion has assumed that the definition of fn was admissible.
  Exactly what does that mean? First, fn must be a previously
  unaxiomatized function symbol (however, see
  [ld-redefinition-action]). Second, the formal parameters must be
  distinct variable names. Third, the [guard], measure, and body
  should all be terms and should mention no free variables except the
  formal parameters. Thus, for example, body may not contain
  references to ``global'' or ``special'' variables; ACL2 constants
  or additional formals should be used instead.

  The final conditions on admissibility concern the termination of the
  recursion. Roughly put, all applications of fn must terminate. In
  particular, there must exist a binary relation, rel, and some unary
  predicate mp such that rel is well-founded on objects satisfying
  mp, the measure term m must always produce something satisfying mp,
  and the measure term must decrease according to rel in each
  recursive call, under the hypothesis that all the tests governing
  the call are satisfied. By the meaning of well-foundedness, we know
  there are no infinitely descending chains of successively
  rel-smaller mp-objects. Thus, the recursion must terminate.

  The only primitive well-founded relation in ACL2 is [o<] (see [o<]),
  which is known to be well-founded on the [o-p]s (see [o-p]). For
  the proof of well-foundedness, see [proof-of-well-foundedness].
  However it is possible to add new well-founded relations. For
  details, see [well-founded-relation]. We discuss later how to
  specify which well-founded relation is selected by defun and in the
  present discussion we assume, without loss of generality, that it
  is [o<] on the [o-p]s.

  For example, for our generic definition of fn above, with measure
  term (m x y), two theorems must be proved. The first establishes
  that m produces an ordinal:

    (o-p (m x y)).

  The second shows that m decreases in the (only) recursive call of fn:

    (implies (not (test x y))
             (o< (m (d x) y) (m x y))).

  Observe that in the latter formula we must show that the ``m-size''
  of (d x) and y is ``smaller than'' the m-size of x and y, provided
  the test, (test x y), in the body fails, thus leading to the
  recursive call (fn (d x) y).

  See [o<] for a discussion of this notion of ``smaller than.'' It
  should be noted that the most commonly used ordinals are the
  natural numbers and that on natural numbers, [o<] is just the
  familiar ``less than'' relation ([<]). Thus, it is very common to
  use a measure m that returns a nonnegative integer, for then (o-p
  (m x y)) becomes a simple conjecture about the type of m and the
  second formula above becomes a conjecture about the less-than
  relationship of nonnegative integer arithmetic.

  The most commonly used measure function is [ACL2-count], which
  computes a nonnegative integer size for all ACL2 objects. See
  [ACL2-count].

  Probably the most common recursive scheme in Lisp [programming] is
  when some formal is supposed to be a list and in the recursive call
  it is replaced by its [cdr]. For example, (test x y) might be
  simply (atom x) and (d x) might be (cdr x). In that case,
  (acl2-count x) is a suitable measure because the [ACL2-count] of a
  [cons] is strictly larger than the [ACL2-count]s of its [car] and
  [cdr]. Thus, ``recursion by [car]'' and ``recursion by [cdr]'' are
  trivially admitted if [ACL2-count] is used as the measure and the
  definition protects every recursive call by a test insuring that
  the decremented argument is a [consp]. Similarly, ``recursion by
  [1-]'' in which a positive integer formal is decremented by one in
  recursion, is also trivially admissible. See [built-in-clause] to
  extend the class of trivially admissible recursive schemes.

  We now turn to the question of which well-founded relation defun
  uses. It should first be observed that defun must actually select
  both a relation (e.g., [o<]) and a domain predicate (e.g., [o-p])
  on which that relation is known to be well-founded. But, as noted
  elsewhere (see [well-founded-relation]), every known well-founded
  relation has a unique domain predicate associated with it and so it
  suffices to identify simply the relation here.

  The [xargs] field of a [declare] permits the explicit specification
  of any known well-founded relation with the keyword
  :[well-founded-relation]. An example is given below. If the [xargs]
  for a defun specifies a well-founded relation, that relation and
  its associated domain predicate are used in generating the
  termination conditions for the definition.

  If no :[well-founded-relation] is specified, defun uses the
  :[well-founded-relation] specified in the [ACL2-defaults-table].
  See [set-well-founded-relation] to see how to set the default
  well-founded relation (and, implicitly, its domain predicate). The
  initial default well-founded relation is [o<] (with domain
  predicate [o-p]).

  This completes the brief sketch of the ACL2 definitional principle.
  Optionally, see [ruler-extenders] for a more detailed discussion of
  the termination analysis and resulting proof obligations for
  admissibility, as well as a discussion of the relation to how ACL2
  stores induction schemes.

  On very rare occasions ACL2 will seem to \"hang\" when processing a
  definition, especially if there are many subexpressions of the body
  whose function symbol is [if] (or which macroexpand to such an
  expression). In those cases you may wish to supply the following to
  [xargs]: :normalize nil. This is an advanced feature that turns off
  ACL2's usual propagation upward of if tests.

  The following example illustrates all of the available declarations
  and most hint keywords, but is completely nonsensical. For
  documentation, see [xargs] and see [hints].

    (defun example (x y z a b c i j)
      (declare (ignore a b c)
               (type integer i j)
               (xargs :guard (symbolp x)
                      :measure (- i j)
                      :ruler-extenders :basic
                      :well-founded-relation my-wfr
                      :hints ((\"Goal\"
                               :do-not-induct t
                               :do-not '(generalize fertilize)
                               :expand ((assoc x a) (member y z))
                               :restrict ((<-trans ((x x) (y (foo x)))))
                               :hands-off (length binary-append)
                               :in-theory (set-difference-theories
                                            (current-theory :here)
                                            '(assoc))
                               :induct (and (nth n a) (nth n b))
                               :use ((:instance assoc-of-append
                                                (x a) (y b) (z c))
                                     (:functional-instance
                                       (:instance p-f (x a) (y b))
                                       (p consp)
                                       (f assoc)))))
                      :guard-hints ((\"Subgoal *1/3'\"
                                     :use ((:instance assoc-of-append
                                                      (x a) (y b) (z c)))))
                      :mode :logic
                      :normalize nil
                      :verify-guards nil
                      :non-executable t
                      :otf-flg t))
      (example-body x y z i j))


Subtopics

  [Defun-inline]
      Define a potentially inlined function symbol and associated macro

  [Defun-mode]
      Determines whether a function definition is a logical act

  [Defun-notinline]
      Define a not-to-be-inlined function symbol and associated macro

  [Defun-nx]
      Define a non-executable function symbol

  [Defund]
      Define a function symbol and then disable it

  [Defund-inline]
      Define a potentially disabled, inlined function symbol and
      associated macro

  [Defund-notinline]
      Define a disabled, not-to-be-inlined function symbol and associated
      macro

  [Mutual-recursion]
      Define some mutually recursive functions

  [Xargs]
      Extra arguments, for example to give [hints] to [defun]")
 (DEFUN-INLINE
  (DEFUN EVENTS)
  "Define a potentially inlined function symbol and associated macro

  You may be able to improve performance by replacing an event (defun f
  ...) with a corresponding event (defun-inline f ...), in order to
  encourage the host Lisp compiler to inline calls of f.

    Example Form:
    (defun-inline lng (x)
      (declare (xargs :guard (true-listp x)))
      (if (endp x) 0 (1+ (lng (cdr x)))))

    General Form:
    (defun-inline fn (var1 ... varn) doc-string dcl ... dcl body)

  satisfying the same requirements as in the General Form for [defun].
  The effect is to define a macro fn and a function fn$inline (i.e.,
  a symbol in the same package as fn but whose [symbol-name] has the
  suffix \"$INLINE\", such that each call of fn expands to a call of
  the function symbol fn$inline on the same arguments. If doc-string
  is supplied, then it is associated with fn, not with fn$inline.
  Moreover, [table] [events] are generated that allow the use of fn
  in [theory] expressions to represent fn$inline and that cause any
  untranslated (user-level) call of fn$inline to be printed as the
  corresponding call of fn.

  A form (defun-inline f ...) actually defines a function named
  f$inline and a corresponding macro named f whose calls expand to
  calls of f$inline, while providing the illusion that there is just
  the ``function'' f. For example, the Example Form above
  macroexpands in one step to the following form.

    (progn (defmacro lng (non-stobj-var0)
             (list 'lng$inline non-stobj-var0))
           (add-macro-fn lng lng$inline)
           (defun lng$inline (x)
             (declare (xargs :guard (true-listp x)))
             (if (endp x) 0 (1+ (lng (cdr x))))))

  Note that the above call of [add-macro-fn] generates the
  aforementioned two table events (see [add-macro-fn]), which provide
  the illusion that we are just defining a function lng, as you can
  see in the following log: lng appears rather than lng$inline.

    ACL2 !>(set-gag-mode nil)
    <state>
    ACL2 !>(thm (equal (lng (append x y))
                       (+ (lng x) (lng y)))
                :hints ((\"Goal\" :in-theory (enable lng))))

    [.. output omitted ..]

    Subgoal *1/2
    (IMPLIES (AND (NOT (ENDP X))
                  (EQUAL (LNG (APPEND (CDR X) Y))
                         (+ (LNG (CDR X)) (LNG Y))))
             (EQUAL (LNG (APPEND X Y))
                    (+ (LNG X) (LNG Y)))).

    [.. output omitted ..]

  Under the hood, ACL2 arranges that every function symbol with suffix
  \"$INLINE\" is presented to the compiler as one whose calls we would
  prefer to inline. Technically: the Common Lisp form (declaim
  (inline f$inline)) is generated for a function symbol f$inline
  before that symbol's definition is submitted. However, the Common
  Lisp spec explicitly avoids requiring that the compiler respect
  this declaim form. Fortunately, Common Lisp implementations often
  do respect it.

  Also see [defund-inline], see [defun-notinline], and see
  [defund-notinline].

  Remarks.

  (1) None of these macros (including defun-inline) is supported for
  use inside a [mutual-recursion].

  (2) Every function symbol defined in ACL2 whose [symbol-name] has the
  suffix \"$INLINE\" is proclaimed to be inline; similarly for
  \"$NOTINLINE\" and notinline.

  (3) No special treatment for inlining (or notinlining) is given for
  function symbols locally defined by [flet], with two exceptions:
  when explicitly declared inline or notinline by the flet form, and
  for symbols discussed in (1) and (2) above that, at some point in
  the current ACL2 session, were defined as function symbols in ACL2
  (even if not currently defined because of undoing or being
  [local]).

  (4) The function symbol actually being defined by (defun-inline foo
  ...) is foo$inline. As mentioned above, one can be oblivious to
  this fact when writing [theory] expressions or perusing prover
  output. However, for other purposes (for example, [verify-guards]
  and [defabsstobj] :exports) you will need to supply the name of the
  function symbol rather than the name of the macro; e.g., for the
  above form (defun-inline foo ...), you may subsequently issue the
  event (verify-guards foo$inline) but not (verify-guards foo).

  (5) Obscure Remark. Suppose that you certify a book with compilation
  (the default) in one host Lisp, saving the expansion file. Suppose
  that you then compile in another host Lisp by using [include-book]
  with argument :load-compiled-file :comp. Then in subsequent
  sessions, including that book with the second host Lisp will not
  result in any inline or notinline behavior for functions defined in
  the book. This may be fixed in a future release if someone
  complains.")
 (DEFUN-MODE
  (DEFUN SWITCHES-PARAMETERS-AND-MODES)
  "Determines whether a function definition is a logical act

  Two ``[defun-mode]s'' are supported, :[program] and :[logic]. Roughly
  speaking, :[program] mode allows you to prototype a function for
  execution without any proof burdens, while :[logic] mode allows you
  to add a new definitional axiom to the logic. The system comes up
  in :[logic] mode. Execution of functions whose [defun-mode] is
  :[program] may render ACL2 unsound! See [defun-mode-caveat].

  Note that calls of [local] and of many [events] are skipped in
  :program mode; see [program].

  When you define a function in the ACL2 logic, that function can be
  run on concrete data. But it is also possible to reason deductively
  about the function because each definition extends the underlying
  logic with a definitional axiom. To ensure that the logic is sound
  after the addition of this axiom, certain restrictions have to be
  met, namely that the recursion terminates. This can be quite
  challenging.

  Because ACL2 is a [programming] language, you often may wish simply
  to program in ACL2. For example, you may wish to define your system
  and test it, without any logical burden. Or, you may wish to define
  ``utility'' functions --- functions that are executed to help
  manage the task of building your system but functions whose logical
  properties are of no immediate concern. Such functions might be
  used to generate test data or help interpret the results of tests.
  They might create files or explore the ACL2 database. The
  termination arguments for such functions are an unnecessary burden
  provided no axioms about the functions are ever used in deductions.

  Thus, ACL2 introduces the idea of the ``[defun-mode]'' of a function.
  The :mode keyword of [defun]'s [declare] xarg allows you to specify
  the [defun-mode] of a given definition. If no :mode keyword is
  supplied, the default [defun-mode] is used; see
  [default-defun-mode].

  There are two [defun-mode]s, each of which is written as a keyword:

  :[program] --- logically undefined but executable outside deductive
  contexts.

  :[logic] --- axiomatically defined as per the ACL2 definitional
  principle.

  It is possible to change the [defun-mode] of a function from
  :[program] to :[logic]. We discuss this below.

  We think of functions having :[program] mode as ``dangerous''
  functions, while functions having :[logic] mode are ``safe.'' The
  only requirement enforced on :[program] mode functions is the
  syntactic one: each definition must be well-formed ACL2. Naively
  speaking, if a :[program] mode function fails to terminate then no
  harm is done because no axiom is added (so inconsistency is
  avoided) and some invocations of the function may simply never
  return. This simplistic justification of :[program] mode execution
  is faulty because it ignores the damage that might be caused by
  ``mis-guarded'' functions. See [defun-mode-caveat].

  We therefore implicitly describe an imagined implementation of
  [defun-mode]s that is safe and, we think, effective. But please see
  [defun-mode-caveat].

  The default [defun-mode] is :[logic]. This means that when you
  [defun] a function the system will try to prove termination. If you
  wish to introduce a function of a different [defun-mode] use the
  :mode [xargs] keyword. Below we show fact introduced as a function
  in :[program] mode.

    (defun fact (n)
      (declare (xargs :mode :program))
      (if (or (not (integerp n)) (= n 0))
          1
        (* n (fact (1- n)))))

  No axiom is added to the logic as a result of this definition. By
  introducing fact in :[program] mode we avoid the burden of a
  termination proof, while still having the option of executing the
  function. For example, you can type

    ACL2 !>(fact 3)

  and get the answer 6. If you type (fact -1) you will get a hard lisp
  error due to ``infinite recursion.''

  However, the ACL2 theorem prover knows no axioms about fact. In
  particular, if the term (fact 3) arises in a proof, the theorem
  prover is unable to deduce that it is 6. From the perspective of
  the theorem prover it is as though fact were an undefined function
  symbol of arity 1. Thus, modulo certain important issues (see
  [defun-mode-caveat]), the introduction of this function in
  :[program] mode does not imperil the soundness of the system ---
  despite the fact that the termination argument for fact was omitted
  --- because nothing of interest can be proved about fact. Indeed,
  we do not allow fact to be used in logical contexts such as
  conjectures submitted for proof.

  It is possible to convert a function from :[program] mode to :[logic]
  mode at the cost of proving that it is admissible. This can be done
  by invoking

    (verify-termination fact)

  which is equivalent to submitting the [defun] of fact, again, but in
  :[logic] mode.

    (defun fact (n)
      (declare (xargs :mode :logic))
      (if (or (not (integerp n)) (= n 0))
          1
        (* n (fact (1- n)))))

  This particular event will fail because the termination argument
  requires that n be nonnegative. A repaired [defun], for example
  with [=] replaced by [<=], will succeed, and an axiom about fact
  will henceforth be available.

  Technically, [verify-termination] submits a redefinition of the
  :[program] mode function. This is permitted, even when
  [ld-redefinition-action] is nil, because the new definition is
  identical to the old (except for its :mode and, possibly, other
  non-logical properties).

  See [guard] for a discussion of how to restrict the execution of
  functions. [Guard]s may be ``verified'' for functions in :[logic]
  mode; see [verify-guards].")
 (DEFUN-MODE-CAVEAT
  (COMMON-LISP)
  "Potential soundness issue for functions with [defun-mode] :[program]

  Technically speaking, in the current implementation, the execution of
  functions having [defun-mode] :[program] may damage the ACL2 system
  in a way that renders it unsound. In practice, we have never seen
  this happen; so, the explanations below can be viewed as extremely
  paranoid. Nevertheless, here we document this concern, even if it
  should be taken with more than a grain of salt.

  See [defun-mode] for a discussion of [defun-mode]s. That discussion
  describes an imagined implementation that is slightly different
  from this one. This note explains that the current implementation
  is open to unsoundness.

  For discussion of a different soundness issue that is also related to
  function execution, see [generalized-booleans].

  The execution of a function having [defun-mode] :[program] may
  violate Common Lisp [guard]s on the subroutines used. (This may be
  true even for calls of a function on arguments that satisfy its
  [guard], because ACL2 has not verified that its [guard] is
  sufficient to protect its subroutines.) When a [guard] is violated
  at runtime all bets are off. That is, no guarantees are made either
  about the answer being ``right'' or about the continued rationality
  of the ACL2 system itself.

  For example, suppose you make the following [defun]:

    (defun crash (i)
      (declare (xargs :mode :program :guard (integerp i)))
      (car i))

  Note that the declared guard does not in fact adequately protect the
  subroutines in the body of crash; indeed, satisfying the guard to
  crash will guarantee that the [car] expression is in violation of
  its guard. Because this function is admitted in :[program]-mode, no
  checks are made concerning the suitability of the guard.
  Furthermore, in the current ACL2 implementation, crash is executed
  directly in Common Lisp. Thus if you call crash on an argument
  satisfying its guard you will cause an erroneous computation to
  take place.

    ACL2 !>(crash 7)

    Error: Caught fatal error [memory may be damaged]
    ...

  There is no telling how much damage is done by this errant
  computation. In some lisps your ACL2 job may actually crash back to
  the operating system. In other lisps you may be able to recover
  from the ``hard error'' and resume ACL2 in a damaged but apparently
  functional image.

  THUS, HAVING A FUNCTION WITH [defun-mode] :[program] IN YOUR SYSTEM
  ABSOLVES US, THE ACL2 IMPLEMENTORS, FROM RESPONSIBILITY FOR THE
  SOUNDNESS OF OUR SYSTEM.

  Furthermore

  ACL2 DOES NOT YET PROVIDE ANY MEANS OF REGAINING ASSURANCES OF
  SOUNDNESS AFTER THE INTRODUCTION OF A FUNCTION IN :[program] MODE,
  EVEN IF IT IS ULTIMATELY CONVERTED TO :[logic] MODE (since its
  execution could have damaged the system in a way that makes it
  possible to verify its termination and [guard]s unsoundly).

  Finally,

  THE VAST MAJORITY OF ACL2 SYSTEM CODE IS IN :[program] MODE AND SO
  ALL BETS ARE OFF FROM BEFORE YOU START!

  This hopeless state of current affairs will change, we think. We
  think we have defined our functions ``correctly'' in the sense that
  they can be converted, without ``essential'' modification, to
  :[logic] mode. We think it very unlikely that a mis-guarded
  function in :[program] mode (whether ours or yours) will cause
  unsoundness without some sort of hard lisp error accompanying it.
  We think that ultimately we can make it possible to execute your
  functions (interpretively) without risk to the system, even when
  some have :[program] mode. In that imagined implementation, code
  using functions having :[program] mode would run more slowly, but
  safely. These functions could be introduced into the logic ex post
  facto, whereupon the code's execution would speed up because Common
  Lisp would be allowed to execute it directly. We therefore ask that
  you simply pretend that this is that imagined implementation,
  introduce functions in :[program] mode, use them as convenient and
  perhaps ultimately introduce some of them in :[logic] mode and
  prove their properties. If you use the system this way we can
  develop (or dismiss) this style of formal system development. BUT
  BE ON THE LOOKOUT FOR SCREWUPS DUE TO DAMAGE CAUSED BY THE
  EXECUTION OF YOUR FUNCTIONS HAVING :[program] MODE!")
 (DEFUN-NOTINLINE
  (DEFUN EVENTS)
  "Define a not-to-be-inlined function symbol and associated macro

  See [defun-inline] for an analogous utility that supports inlining.
  The present utility is probably far less useful; it tells the
  compiler not to inline calls of the function being defined. Also
  see [defund-notinline] for a variant of this event that disables
  the newly-defined function symbol.

  Under the hood, (defun-inline f ...) and (defun-notinline f ...)
  cause evaluation of Common Lisp forms (declaim (inline f$inline))
  and (declaim (notinline f$notinline)), respectively. According to
  the Common Lisp spec, the compiler need not respect the first of
  these (for inline), but it must respect the second of these (for
  notinline). Fortunately, Common Lisp implementations often do
  respect the first of these as well.")
 (DEFUN-NX
  (DEFUN EVENTS)
  "Define a non-executable function symbol

    Example:

    (set-state-ok t)
    (defun-nx foo (x state)
      (mv-let (a b c)
              (cons x state)
              (list a b c b a)))
    ; Note ``ill-formed'' call of foo just below.
    (defun bar (state y)
      (foo state y))

  The macro defun-nx introduces definitions using the [defun] macro,
  always in :[logic] mode, such that the calls of the resulting
  function cannot be evaluated. Such a definition is admitted without
  enforcing syntactic restrictions for executability, in particular
  for single-threadedness (see [stobj]) and multiple-values passing
  (see [mv] and see [mv-let]). After such a definition is admitted,
  the usual syntactic rules for [state] and user-defined [stobj]s are
  relaxed for calls of the function it defines. Also see [non-exec]
  for a way to designate subterms of function bodies, or subterms of
  code to be executed at the top level, as non-executable.

  The syntax of defun-nx is identical to that of [defun]. A form

    (defun-nx name (x1 ... xk) ... body)

  expands to the following form.

    (defun name (x1 ... xk)
      (declare (xargs :non-executable t :mode :logic))
      ...
      (prog2$ (throw-nonexec-error 'name (list x1 ... xk))
              body))

  Note that because of the insertion of the above call of
  throw-nonexec-error, no formal is ignored when using defun-nx.

  During proofs, the error is silent; it is ``caught'' by the proof
  mechanism and generally results in the introduction of a call of
  [hide] during a proof. If an error message is produced by
  evaluating a call of the function on a list of arguments that
  includes state or user-defined [stobj]s, these arguments will be
  shown as symbols such as |<state>| in the error message. In the
  case of a user-defined stobj bound by [with-local-stobj] or
  [stobj-let], the symbol printed will include the suffix {instance},
  for example, |<st>{instance}|.

  It is harmless to include :non-executable t in your own [xargs]
  [declare] form; defun-nx will still lay down its own such
  declaration, but ACL2 can tolerate the duplication.

  Note that defund-nx is also available. It has an effect identical to
  that of defun-nx except that as with [defund], it leaves the
  function disabled.

  If you use guards (see [guard]), please be aware that even though
  syntactic restrictions are relaxed for defun-nx, guard verification
  proceeds exactly as for [defun]. If you want ACL2 to skip a form
  for purposes of generating guard proof obligations, use the macro
  [non-exec], which generates a call of throw-nonexec-error that
  differs somewhat from the one displayed above. See [non-exec].

  See [defun] for documentation of defun.")
 (DEFUN-SK
  (EVENTS)
  "Define a function whose body has an outermost quantifier

    Examples:
    (defun-sk exists-x-p0-and-q0 (y z)
      (exists x
              (and (p0 x y z)
                   (q0 x y z))))

    (defun-sk exists-x-p0-and-q0 (y z) ; equivalent to the above
      (exists (x)
              (and (p0 x y z)
                   (q0 x y z))))

    (defun-sk forall-x-y-p0-and-q0 (z)
      (forall (x y)
              (and (p0 x y z)
                   (q0 x y z)))
      :strengthen t)

    General Form:
    (defun-sk fn (var1 ... varn) body
      &key rewrite doc quant-ok skolem-name thm-name witness-dcls strengthen)

  where fn is the symbol you wish to define and is a new symbolic name
  (see [name]), (var1 ... varn) is its list of formal parameters (see
  [name]), and body is its body, which must be quantified as
  described below. The &key argument [doc] is an optional
  [documentation] string to be associated with fn; for a description
  of its form, see [doc-string]. In the case that n is 1, the list
  (var1) may be replaced by simply var1. The other arguments are
  explained below.

  For a simple example, see [defun-sk-example]. For a more elaborate
  example, see [Tutorial4-Defun-Sk-Example]. See
  [quantifier-tutorial] for a careful beginner's introduction that
  takes you through typical kinds of quantifier-based reasoning in
  ACL2. Also see [quantifiers] for an example illustrating how the
  use of recursion, rather than explicit quantification with
  defun-sk, may be preferable.

  Below we describe the defun-sk event precisely. First, let us
  consider the examples above. The first example, again, is:

    (defun-sk exists-x-p0-and-q0 (y z)
      (exists x
              (and (p0 x y z)
                   (q0 x y z))))

  It is intended to represent the predicate with formal parameters y
  and z that holds when for some x, (and (p0 x y z) (q0 x y z))
  holds. In fact defun-sk is a macro that adds the following two
  [events], as shown just below. The first event guarantees that if
  this new predicate holds of y and z, then the term shown,
  (exists-x-p0-and-q0-witness y z), is an example of the x that is
  therefore supposed to exist. (Intuitively, we are axiomatizing
  exists-x-p0-and-q0-witness to pick a witness if there is one. We
  comment below on the use of [defun-nx]; for now, consider defun-nx
  to be [defun].) Conversely, the second event below guarantees that
  if there is any x for which the term in question holds, then the
  new predicate does indeed hold of y and z.

    (defun-nx exists-x-p0-and-q0 (y z)
      (let ((x (exists-x-p0-and-q0-witness y z)))
        (and (p0 x y z) (q0 x y z))))
    (defthm exists-x-p0-and-q0-suff
      (implies (and (p0 x y z) (q0 x y z))
               (exists-x-p0-and-q0 y z)))

  Now let us look at the third example from the introduction above:

    (defun-sk forall-x-y-p0-and-q0 (z)
      (forall (x y)
              (and (p0 x y z)
                   (q0 x y z))))

  The intention is to introduce a new predicate (forall-x-y-p0-and-q0
  z) which states that the indicated conjunction holds of all x and
  all y together with the given z. This time, the axioms introduced
  are as shown below. The first event guarantees that if the
  application of function forall-x-y-p0-and-q0-witness to z picks out
  values x and y for which the given term (and (p0 x y z) (q0 x y z))
  holds, then the new predicate forall-x-y-p0-and-q0 holds of z.
  Conversely, the (contrapositive of) the second axiom guarantees
  that if the new predicate holds of z, then the given term holds for
  all choices of x and y (and that same z).

    (defun-nx forall-x-y-p0-and-q0 (z)
      (mv-let (x y)
              (forall-x-y-p0-and-q0-witness z)
              (and (p0 x y z) (q0 x y z))))
    (defthm forall-x-y-p0-and-q0-necc
      (implies (not (and (p0 x y z) (q0 x y z)))
               (not (forall-x-y-p0-and-q0 z))))

  The examples above suggest the critical property of defun-sk: it
  indeed does introduce the quantified notions that it claims to
  introduce.

  Notice that the [defthm] event just above, forall-x-y-p0-and-q0-necc,
  may not be of optimal form as a rewrite rule. Users sometimes find
  that when the quantifier is forall, it is useful to state this rule
  in a form where the new quantified predicate is a hypothesis
  instead. In this case that form would be as follows:

    (defthm forall-x-y-p0-and-q0-necc
      (implies (forall-x-y-p0-and-q0 z)
               (and (p0 x y z) (q0 x y z))))

  ACL2 will turn this into one :[rewrite] rule for each conjunct, (p0 x
  y z) and (q0 x y z), with hypothesis (forall-x-y-p0-and-q0 z) in
  each case. In order to get this effect, use :rewrite :direct, in
  this case as follows.

    (defun-sk forall-x-y-p0-and-q0 (z)
      (forall (x y)
              (and (p0 x y z)
                   (q0 x y z)))
      :rewrite :direct)

  We now turn to a detailed description of defun-sk, starting with a
  discussion of its arguments as shown in the \"General Form\" above.

  The third argument, body, must be of the form

    (Q bound-vars term)

  where: Q is the symbol [forall] or [exists] (in the \"ACL2\" package),
  bound-vars is a variable or true list of variables disjoint from
  (var1 ... varn) and not including [state], and term is a term. The
  case that bound-vars is a single variable v is treated exactly the
  same as the case that bound-vars is (v).

  The result of this event is to introduce a ``Skolem function,'' whose
  name is the keyword argument skolem-name if that is supplied, and
  otherwise is the result of modifying fn by suffixing \"-WITNESS\" to
  its name. The following definition and one of the following two
  theorems (as indicated) are introduced for skolem-name and fn in
  the case that bound-vars (see above) is a single variable v. The
  name of the [defthm] event may be supplied as the value of the
  keyword argument :thm-name; if it is not supplied, then it is the
  result of modifying fn by suffixing \"-SUFF\" to its name in the case
  that the quantifier is [exists], and \"-NECC\" in the case that the
  quantifier is [forall].

    (defun-nx fn (var1 ... varn)
      (let ((v (skolem-name var1 ... varn)))
        term))

    (defthm fn-suff ;in case the quantifier is EXISTS
      (implies term
               (fn var1 ... varn)))

    (defthm fn-necc ;in case the quantifier is FORALL
      (implies (not term)
               (not (fn var1 ... varn))))

  In the forall case, however, the keyword pair :rewrite :direct may be
  supplied after the body of the defun-sk form, in which case the
  contrapositive of the above form is used instead:

    (defthm fn-necc ;in case the quantifier is FORALL
      (implies (fn var1 ... varn)
               term))

  This is often a better choice for the \"-NECC\" rule, provided ACL2 can
  parse term as a :[rewrite] rule. A second possible value of the
  :rewrite argument of defun-sk is :default, which gives the same
  behavior as when :rewrite is omitted. Otherwise, the value of
  :rewrite should be the term to use as the body of the fn-necc
  theorem shown above; ACL2 will attempt to do the requisite proof in
  this case. If that term is weaker than the default, the properties
  introduced by defun-sk may of course be weaker than they would be
  otherwise. Finally, note that the :rewrite keyword argument for
  defun-sk only makes sense if the quantifier is forall; it is thus
  illegal if the quantifier is exists. Enough said about :rewrite!

  In the case that bound-vars is a list of at least two variables, say
  (bv1 ... bvk), the definition above (with no keywords) is the
  following instead, but the theorem remains unchanged.

    (defun-nx fn (var1 ... varn)
      (mv-let (bv1 ... bvk)
              (skolem-name var1 ... varn)
              term))

  In order to emphasize that the last element of the list, body, is a
  term, defun-sk checks that the symbols [forall] and [exists] do not
  appear anywhere in it. However, on rare occasions one might
  deliberately choose to violate this convention, presumably because
  [forall] or [exists] is being used as a variable or because a macro
  call will be eliminating ``calls of'' [forall] and [exists]. In
  these cases, the keyword argument quant-ok may be supplied a
  non-nil value. Then defun-sk will permit [forall] and [exists] in
  the body, but it will still cause an error if there is a real
  attempt to use these symbols as quantifiers.

  The use of [defun-nx] above, rather than [defun], disables certain
  checks that are required for evaluation, in particular the
  single-threaded use of [stobj]s. However, there is a price: calls
  of these defined functions cannot be evaluated; see [defun-nx].
  Normally that is not a problem, since these notions involve
  quantifiers. But you are welcome to replace this [declare] form
  with your own, as follows: if you supply a list of declare forms to
  keyword argument :witness-dcls, these will become the declare forms
  in the generated [defun]. Note that if your value of witness-dcls
  does not contain the form (declare (xargs :non-executable t)), then
  the appropriate wrapper for non-executable functions will not be
  added automatically, i.e., [defun] will be used in place of
  defun-nx. Note also that if [guard] verification is attempted, then
  it will likely fail with an error message complaining that ``guard
  verification may depend on local properties.'' In that case, you
  may wish to delay guard verification, as in the following example.

    (encapsulate
     ()
     (defun-sk foo (x)
       (exists n (and (integerp n)
                      (< n x)))
       :witness-dcls ((declare (xargs :guard (integerp x)
                                      :verify-guards nil))))
     (verify-guards foo))

  Defun-sk is a macro implemented using [defchoose]. Hence, it should
  only be executed in [defun-mode] :[logic]; see [defun-mode] and see
  [defchoose]. Advanced feature: If argument :strengthen t is passed
  to defun-sk, then :strengthen t will generate the extra constraint
  that that is generated for the corresponding defchoose event; see
  [defchoose]. You can use the command :[pcb!] to see the event
  generated by a call of the defun-sk macro.

  If you find that the rewrite rules introduced with a particular use
  of defun-sk are not ideal, even when using the :rewrite keyword
  discussed above (in the forall case), then at least two reasonable
  courses of action are available for you. Perhaps the best option is
  to prove the [rewrite] rules you want. If you see a pattern for
  creating rewrite rules from your defun-sk events, you might want to
  write a macro that executes a defun-sk followed by one or more
  [defthm] events. Another option is to write your own variant of the
  defun-sk macro, say, my-defun-sk, for example by modifying a copy
  of the definition of defun-sk from the ACL2 sources.

  If you want to represent nested quantifiers, you can use more than
  one defun-sk event. For example, in order to represent

    (forall x (exists y (p x y z)))

  you can use defun-sk twice, for example as follows.

    (defun-sk exists-y-p (x z)
      (exists y (p x y z)))

    (defun-sk forall-x-exists-y-p (z)
      (forall x (exists-y-p x z)))

  Some distracting and unimportant warnings are inhibited during
  defun-sk.

  Note for ACL2(r) users (see [real]): In ACL2(r), the keyword
  :CLASSICALP is also supported. Its legal values are t (the default)
  and nil, and it determines whether or not (respectively) ACL2(r)
  will consider fn to be a classical function. It must be the case
  that the value is t (perhaps implicitly, by default) if and only if
  body is classical.

  Note that this way of implementing quantifiers is not a new idea.
  Hilbert was certainly aware of it 60 years ago! Also see
  [conservativity-of-defchoose] for a technical argument that
  justifies the logical conservativity of the [defchoose] event in
  the sense of the paper by Kaufmann and Moore entitled ``Structured
  Theory Development for a Mechanized Logic'' (Journal of Automated
  Reasoning 26, no. 2 (2001), pp. 161-203).


Subtopics

  [Defun-sk-example]
      A simple example using [defun-sk]

  [Exists]
      Existential quantifier

  [Forall]
      Universal quantifier

  [Quantifier-tutorial]
      A Beginner's Guide to Reasoning about Quantification in ACL2

  [Quantifiers]
      Issues about quantification in ACL2")
 (DEFUN-SK-EXAMPLE
  (DEFUN-SK)
  "A simple example using [defun-sk]

  For a more through, systematic beginner's introduction to
  quantification in ACL2, see [quantifier-tutorial].

  The following example illustrates how to do proofs about functions
  defined with [defun-sk]. The events below can be put into a
  certifiable book (see [books]). The example is contrived and rather
  silly, in that it shows how to prove that a quantified notion
  implies itself, where the antecedent and conclusion are defined
  with different [defun-sk] events. But it illustrates the formulas
  that are generated by [defun-sk], and how to use them. Thanks to
  Julien Schmaltz for presenting this example as a challenge.

    (in-package \"ACL2\")

    (encapsulate
     (((p *) => *)
      ((expr *) => *))

     (local (defun p (x) x))
     (local (defun expr (x) x)))

    (defun-sk forall-expr1 (x)
      (forall (y) (implies (p x) (expr y))))

    (defun-sk forall-expr2 (x)
      (forall (y) (implies (p x) (expr y)))))

    ; We want to prove the theorem my-theorem below.  What axioms are there that
    ; can help us?  If you submit the command

    ; :pcb! forall-expr1

    ; then you will see the following two key events.  (They are completely
    ; analogous of course for FORALL-EXPR2.)

    ;   (DEFUN FORALL-EXPR1 (X)
    ;     (LET ((Y (FORALL-EXPR1-WITNESS X)))
    ;          (IMPLIES (P X) (EXPR Y))))
    ;
    ;   (DEFTHM FORALL-EXPR1-NECC
    ;     (IMPLIES (NOT (IMPLIES (P X) (EXPR Y)))
    ;              (NOT (FORALL-EXPR1 X)))
    ;     :HINTS
    ;     ((\"Goal\" :USE FORALL-EXPR1-WITNESS)))

    ; We see that the latter has value when FORALL-EXPR1 occurs negated in a
    ; conclusion, or (therefore) positively in a hypothesis.  A good rule to
    ; remember is that the former has value in the opposite circumstance: negated
    ; in a hypothesis or positively in a conclusion.

    ; In our theorem, FORALL-EXPR2 occurs positively in the conclusion, so its
    ; definition should be of use.  We therefore leave its definition enabled,
    ; and disable the definition of FORALL-EXPR1.

    ;   (thm
    ;     (implies (and (p x) (forall-expr1 x))
    ;              (forall-expr2 x))
    ;     :hints ((\"Goal\" :in-theory (disable forall-expr1))))
    ;
    ;   ; which yields this unproved subgoal:
    ;
    ;   (IMPLIES (AND (P X) (FORALL-EXPR1 X))
    ;            (EXPR (FORALL-EXPR2-WITNESS X)))

    ; Now we can see how to use FORALL-EXPR1-NECC to complete the proof, by
    ; binding y to (FORALL-EXPR2-WITNESS X).

    ; We use defthmd below so that the following doesn't interfere with the
    ; second proof, in my-theorem-again that follows.
    (defthmd my-theorem
      (implies (and (p x) (forall-expr1 x))
               (forall-expr2 x))
      :hints ((\"Goal\"
               :use ((:instance forall-expr1-necc
                                (x x)
                                (y (forall-expr2-witness x)))))))

    ; The following illustrates a more advanced technique to consider in such
    ; cases.  If we disable forall-expr1, then we can similarly succeed by having
    ; FORALL-EXPR1-NECC applied as a :rewrite rule, with an appropriate hint in how
    ; to instantiate its free variable.  See :doc hints.

    (defthm my-theorem-again
      (implies (and (P x) (forall-expr1 x))
               (forall-expr2 x))
      :hints ((\"Goal\"
               :in-theory (disable forall-expr1)
               :restrict ((forall-expr1-necc
                           ((y (forall-expr2-witness x))))))))")
 (DEFUND
  (DEFUN EVENTS)
  "Define a function symbol and then disable it

  Use defund instead of [defun] when you want to disable a function
  immediately after its definition in :[logic] mode. This macro has
  been provided for users who prefer working in a mode where
  functions are only enabled when explicitly directed by
  :[in-theory]. Specifically, the form

    (defund NAME FORMALS ...)

  expands to:

    (progn
      (defun NAME FORMALS ...)
      (with-output
       :off summary
       (in-theory (disable NAME)))
      (value-triple '(:defund NAME))).

  Only the :[definition] rule (and, for recursively defined functions,
  the :[induction] rule) for the function are disabled. In
  particular, defund does not disable either the :[type-prescription]
  or the :[executable-counterpart] rule. Also, the summary for the
  [in-theory] event is suppressed.

  If the function is defined in :[program] mode, either because the
  [default-defun-mode] is :[program] or because :mode :program has
  been specified in an [xargs] form of a [declare] form, then no
  [in-theory] event is executed. (More precisely, [in-theory] events
  are ignored when the [default-defun-mode] is :[program], and if
  :mode :program is specified then defund does not generate an
  [in-theory] event.)

  Note that defund commands are never redundant (see
  [redundant-events]) when the [default-defun-mode] is :[logic],
  because the [in-theory] event will always be executed.

  See [defun] for documentation of defun.")
 (DEFUND-INLINE
  (DEFUN EVENTS)
  "Define a potentially disabled, inlined function symbol and associated
  macro

  Defund-inline is a variant of [defun-inline], the difference being
  that defund-inline disables the newly-defined function symbol. See
  [defun-inline].")
 (DEFUND-NOTINLINE
  (DEFUN EVENTS)
  "Define a disabled, not-to-be-inlined function symbol and associated
  macro

  Defund-notinline is a variant of [defun-notinline], the difference
  being that defund-notinline disables the newly-defined function
  symbol. See [defun-notinline].")
 (DEFUNS
  (MUTUAL-RECURSION)
  "An alternative to [mutual-recursion]

    Example:
    (DEFUNS
     (evenlp (x)
       (if (consp x) (oddlp (cdr x)) t))
     (oddlp (x)
       (if (consp x) (evenlp (cdr x)) nil)))

    General Form:
    (DEFUNS defuns-tuple1 ... defuns-tuplen)

  is equivalent to

    (MUTUAL-RECURSION
      (DEFUN . defuns-tuple1)
      ...
      (DEFUN . defuns-tuplen))

  In fact, defuns is the more primitive of the two and
  [mutual-recursion] is just a macro that expands to a call of
  [defun] after stripping off the [defun] at the [car] of each
  argument to [mutual-recursion]. We provide and use
  [mutual-recursion] rather than defuns because by leaving the
  [defun]s in place, [mutual-recursion] forms can be processed by the
  Emacs tags program. See [mutual-recursion].")
 (DELETE-ASSOC
  (ACL2-BUILT-INS)
  "Remove the first pair from an association list for a given key

    General Forms:
    (delete-assoc key alist)
    (delete-assoc key alist :test 'eql)   ; same as above (eql as equality test)
    (delete-assoc key alist :test 'eq)    ; same, but eq is equality test
    (delete-assoc key alist :test 'equal) ; same, but equal is equality test

  (Delete-assoc key alist) returns an alist that is the same as the
  list alist, except that the first pair in alist with a [car] of key
  is deleted, if there is one; otherwise alist is returned. Note that
  the order of the elements of alist is unchanged (though one may be
  deleted).

  The [guard] for a call of delete-assoc depends on the test. In all
  cases, the second argument must satisfy [alistp]. If the test is
  [eql], then either the first argument must be suitable for [eql]
  (see [eqlablep]) or the second argument must satisfy
  [eqlable-alistp]. If the test is [eq], then either the first
  argument must be a symbol or the second argument must satisfy
  [symbol-alistp].

  See [equality-variants] for a discussion of the relation between
  delete-assoc and its variants:

      (delete-assoc-eq key alist) is equivalent to (delete-assoc key alist
      :test 'eq);

      (delete-assoc-equal key alist) is equivalent to (delete-assoc key
      alist :test 'equal).

  In particular, reasoning about any of these primitives reduces to
  reasoning about the function delete-assoc-equal.

  Function: <delete-assoc-equal>

    (defun delete-assoc-equal (key alist)
           (declare (xargs :guard (alistp alist)))
           (cond ((endp alist) nil)
                 ((equal key (caar alist)) (cdr alist))
                 (t (cons (car alist)
                          (delete-assoc-equal key (cdr alist))))))")
 (DELETE-ASSOC-EQ (POINTERS)
                  "See [delete-assoc].")
 (DELETE-ASSOC-EQUAL (POINTERS)
                     "See [delete-assoc].")
 (DELETE-INCLUDE-BOOK-DIR
  (SWITCHES-PARAMETERS-AND-MODES)
  "Unlink keyword for :dir argument of [ld] and [include-book]

    Example Forms:
    ; Remove association of a directory with :smith for include-book and ld:
    (delete-include-book-dir :smith)

    General Form:
    (delete-include-book-dir kwd)

  where kwd is a [keywordp]. The effect of this event is to modify the
  meaning of the :dir keyword argument of [include-book] and [ld] as
  indicated by the example above, namely by removing association of a
  directory with the indicated keyword for purposes of the :dir
  argument of [include-book] and [ld]. See [add-include-book-dir] for
  how to associate a new directory with a keyword.

  Note: This is an event! It does not print the usual event summary but
  nevertheless changes the ACL2 logical [world] and is so recorded.

  This macro is [local] to any [books] and [encapsulate] [events] in
  which it occurs; see [add-include-book-dir] for a discussion of
  this aspect of both macros. For non-local associations of keywords
  with directories, see [add-include-book-dir!] and
  [delete-include-book-dir!]. Note that delete-include-book-dir may
  only be used to remove keywords added by calls of
  [add-include-book-dir], and [delete-include-book-dir!] may only be
  used to remove keywords added by calls of [add-include-book-dir!]")
 (DELETE-INCLUDE-BOOK-DIR!
  (SWITCHES-PARAMETERS-AND-MODES)
  "Non-[local]ly unlink keyword for :dir argument of [ld] and
  [include-book]

  Please see [delete-include-book-dir], which has completely analogous
  syntax and semantics, but is used for removing associations
  previously placed by [add-include-book-dir]. By contrast,
  delete-include-book-dir! removes associations previously placed by
  [add-include-book-dir!].

  Note: This is an event! It does not print the usual event summary but
  nevertheless changes the ACL2 logical [world] and is so recorded.

  This macro is essentially a [table] event that updates the table
  include-book-dir!-table, which associates keywords with absolute
  pathnames. However, as with [delete-include-book-dir], direct table
  updates are disallowed; you must use delete-include-book-dir! to
  remove from the table and [add-include-book-dir!] to add to the
  table.

  It is illegal to call delete-include-book-dir! in a [local] context.
  For an explanation, see [add-include-book-dir!].")
 (DENOMINATOR
  (ACL2-BUILT-INS)
  "Divisor of a ratio in lowest terms

  Completion Axiom (completion-of-denominator):

    (equal (denominator x)
           (if (rationalp x)
               (denominator x)
             1))

  [Guard] for (denominator x):

    (rationalp x)")
 (DIGIT-CHAR-P
  (ACL2-BUILT-INS)
  "The number, if any, corresponding to a given character

  (digit-char-p ch) is the integer corresponding to the character ch in
  base 10. For example, (digit-char-p #\\3) is equal to the integer 3.
  More generally, an optional second argument specifies the radix
  (default 10, as indicated above).

  The [guard] for digit-char-p (more precisely, for the function
  our-digit-char-p that calls of this macro expand to) requires its
  second argument to be an integer between 2 and 36, inclusive, and
  its first argument to be a character.

  Digit-char-p is a Common Lisp function, though it is implemented in
  the ACL2 logic as an ACL2 macro. See any Common Lisp documentation
  for more information.

  Macro: <digit-char-p>

    (defmacro digit-char-p (ch &optional (radix '10))
              (cons 'our-digit-char-p
                    (cons ch (cons radix 'nil))))

  Function: <our-digit-char-p>

    (defun our-digit-char-p (ch radix)
           (declare (xargs :guard (and (characterp ch)
                                       (integerp radix)
                                       (<= 2 radix)
                                       (<= radix 36))))
           (let ((l (assoc ch
                           '((#\\0 . 0)
                             (#\\1 . 1)
                             (#\\2 . 2)
                             (#\\3 . 3)
                             (#\\4 . 4)
                             (#\\5 . 5)
                             (#\\6 . 6)
                             (#\\7 . 7)
                             (#\\8 . 8)
                             (#\\9 . 9)
                             (#\\a . 10)
                             (#\\b . 11)
                             (#\\c . 12)
                             (#\\d . 13)
                             (#\\e . 14)
                             (#\\f . 15)
                             (#\\g . 16)
                             (#\\h . 17)
                             (#\\i . 18)
                             (#\\j . 19)
                             (#\\k . 20)
                             (#\\l . 21)
                             (#\\m . 22)
                             (#\\n . 23)
                             (#\\o . 24)
                             (#\\p . 25)
                             (#\\q . 26)
                             (#\\r . 27)
                             (#\\s . 28)
                             (#\\t . 29)
                             (#\\u . 30)
                             (#\\v . 31)
                             (#\\w . 32)
                             (#\\x . 33)
                             (#\\y . 34)
                             (#\\z . 35)
                             (#\\A . 10)
                             (#\\B . 11)
                             (#\\C . 12)
                             (#\\D . 13)
                             (#\\E . 14)
                             (#\\F . 15)
                             (#\\G . 16)
                             (#\\H . 17)
                             (#\\I . 18)
                             (#\\J . 19)
                             (#\\K . 20)
                             (#\\L . 21)
                             (#\\M . 22)
                             (#\\N . 23)
                             (#\\O . 24)
                             (#\\P . 25)
                             (#\\Q . 26)
                             (#\\R . 27)
                             (#\\S . 28)
                             (#\\T . 29)
                             (#\\U . 30)
                             (#\\V . 31)
                             (#\\W . 32)
                             (#\\X . 33)
                             (#\\Y . 34)
                             (#\\Z . 35)))))
                (cond ((and l (< (cdr l) radix)) (cdr l))
                      (t nil))))")
 (DIGIT-TO-CHAR
  (ACL2-BUILT-INS)
  "Map a digit to a character

    Example:
    ACL2 !>(digit-to-char 8)
    #\\8

  For an integer n from 0 to 15, (digit-to-char n) is the character
  corresponding to n in hex notation, using uppercase letters for
  digits exceeding 9. If n is in the appropriate range, that result
  is of course also the binary, octal, and decimal digit.

  The [guard] for digit-to-char requires its argument to be an integer
  between 0 and 15, inclusive.

  Function: <digit-to-char>

    (defun
         digit-to-char (n)
         (declare (xargs :guard (and (integerp n) (<= 0 n) (<= n 15))))
         (case n (1 #\\1)
               (2 #\\2)
               (3 #\\3)
               (4 #\\4)
               (5 #\\5)
               (6 #\\6)
               (7 #\\7)
               (8 #\\8)
               (9 #\\9)
               (10 #\\A)
               (11 #\\B)
               (12 #\\C)
               (13 #\\D)
               (14 #\\E)
               (15 #\\F)
               (otherwise #\\0)))")
 (DIMENSIONS
  (ARRAYS ACL2-BUILT-INS)
  "Return the :dimensions from the [header] of a 1- or 2-dimensional
  array

    Example Form:
    (dimensions 'delta1 a)

    General Form:
    (dimensions name alist)

  where name is arbitrary and alist is a 1- or 2-dimensional array.
  This function returns the dimensions list of the array alist. That
  list will either be of the form (dim1) or (dim1 dim2), depending on
  whether alist is a 1- or 2-dimensional array. Dim1 and dim2 will be
  integers and each exceed by 1 the maximum legal corresponding
  index. Thus, if dimensions returns, say, '(100) for an array a
  named 'delta1, then (aref1 'delta1 a 99) is legal but (aref1
  'delta1 a 100) violates the [guard]s on [aref1]. Dimensions
  operates in virtually constant time if alist is the semantic value
  of name. See [arrays].

  Function: <dimensions>

    (defun
         dimensions (name l)
         (declare (xargs :guard (or (array1p name l) (array2p name l))))
         (cadr (assoc-keyword :dimensions (cdr (header name l)))))")
 (DISABLE
  (THEORIES THEORY-FUNCTIONS)
  "Deletes names from current theory

    Example:
    (disable fact (fact) associativity-of-app)

    General Form:
    (disable name1 name2 ... namek)

  where each namei is a runic designator; see [theories]. The result is
  the theory that contains all the names in the current theory except
  those listed. Note that this is merely a function that returns a
  theory. The result is generally a very long list of [rune]s and you
  will probably regret printing it.

  The standard way to ``disable'' a fixed set of names, is as follows;
  see [hints] and see [in-theory].

    :in-theory (disable name1 name2 ... namek)    ; in a hint
    (in-theory (disable name1 name2 ... namek))   ; as an event
    (local ; often desirable, to avoid exporting from the current context
     (in-theory (disable name1 name2 ... namek)))

  Note that all the names are implicitly quoted. If you wish to disable
  a computed list of names, lst, use the theory expression
  (set-difference-theories (current-theory :here) lst).")
 (DISABLE-FORCING
  (FORCE EVENTS SWITCHES-PARAMETERS-AND-MODES)
  "To disallow forced case-splits

    General Form:
    ACL2 !>:disable-forcing   ; disallow forced case splits

  See [force] and see [case-split] for a discussion of forced case
  splits, which are inhibited by this command.

  Disable-forcing is actually a macro that [disable]s the executable
  counterpart of the function symbol force; see [force]. When you
  want to use [hints] to turn off forced case splits, use a form such
  as one of the following (these are equivalent).

    :in-theory (disable (:executable-counterpart force))
    :in-theory (disable (force))

  The following example shows how this works. First evaluate these
  forms.

    (defstub f1 (x) t)
    (defstub f2 (x) t)
    (defaxiom ax (implies (case-split (f2 x)) (f1 x)))
    (thm (f1 x))

  You will see the application of the rule, ax, in the proof of the
  [thm] call above. However, if you first evaluate (disable-forcing),
  then there will be no application of ax. To restore forced case
  splitting, see [enable-forcing].")
 (DISABLE-IMMEDIATE-FORCE-MODEP
  (FORCE EVENTS SWITCHES-PARAMETERS-AND-MODES)
  "[force]d hypotheses are not attacked immediately

    General Form:
    ACL2 !>:disable-immediate-force-modep

  This event causes ACL2 to delay [force]d hypotheses to the next
  forcing round, rather than attacking them immediately. See
  [immediate-force-modep]. Or for more basic information, first see
  [force] for a discussion of [force]d case splits.

  Disable-immediate-force-modep is a macro that [disable]s the
  executable counterpart of the function symbol
  [immediate-force-modep]. When you want to [disable] this mode in
  [hints], use a form such as one of the following (these are
  equivalent).

    :in-theory (disable (:executable-counterpart immediate-force-modep))
    :in-theory (disable (immediate-force-modep))")
 (DISABLEDP
  (MISCELLANEOUS)
  "Determine whether a given name or rune is disabled

    Examples:

    :disabledp foo   ; returns a list of all disabled runes whose base
                     ; symbol is foo (see [rune])
    (disabledp 'foo) ; same as above (i.e., :disabledp foo)
    :disabledp (:rewrite bar . 1) ; returns t if the indicated rune is
                                  ; disabled, else nil
    (disabledp (:rewrite bar . 1)); same as immediately above

  Also see [pr], which gives much more information about the rules
  associated with a given event.

  Disabledp takes one argument, an event name (see [events]) other than
  nil or a [rune]. In the former case it returns the list of disabled
  runes associated with that name, in the sense that the rune's
  ``base symbol'' is that name (see [rune]) or, if the event named is
  a [defmacro] event, then the list of disabled runes associated with
  the function corresponding to that macro name, if any (see
  [macro-aliases-table]). In the latter case, where the argument is a
  [rune], disabledp returns t if the rune is disabled, and nil
  otherwise.")
 (DISASSEMBLE$
  (DEBUGGING PROGRAMMING)
  "Disassemble a function

  The macro disassemble$ provides a convenient interface to the
  underlying disassemble utility of the host Common Lisp
  implementation, which prints assembly code for a given function
  symbol at the terminal. It works by including the community book
  books/misc/disassemble.lisp, which defines the supporting function
  disassemble$-fn, and then by calling that function. Note that the
  arguments to disassemble$ are evaluated. Also note that
  disassemble$ is intended as a top-level utility for the ACL2 loop,
  not to be called in code; for such a purpose, include the above
  book and call disassemble$-fn directly.

    Example Forms:

    (disassemble$ 'foo)
    (disassemble$ 'foo :recompile t)

    General Forms:
    (disassemble$ form)
    (disassemble$ form :recompile flg)

  where form evaluates to a function symbol and flg evaluates to any
  value. If flg is nil, then the existing definition of that function
  symbol is disassembled. But if flg is supplied and has a value
  other than nil or :default, and if that function symbol is defined
  in the ACL2 loop (not merely in raw Lisp; for example, see
  [set-raw-mode]), then the disassembly will be based on a
  recompilation of that ACL2 definition. Normally this recompilation
  is not necessary, but for some host Lisps, it may be useful; in
  particular, for CCL the above book arranges that source code
  information is saved, so that the output is annotated with such
  information. When recompilation takes place, the previous
  definition is restored after disassembly is complete. Finally, if
  flg is omitted or has the value :default --- i.e., in the default
  case --- then recompilation may take place or not, depending on the
  host Lisp. The values of (@ host-lisp) for which recompilation
  takes place by default may be found by looking at the above book,
  or by including it and evaluating the constant
  *host-lisps-that-recompile-by-default*. As of this writing, CCL is
  the only such Lisp (because that is the one for which we can obtain
  source annotation in the output by recompiling).")
 (DIVE-INTO-MACROS-TABLE
  (SWITCHES-PARAMETERS-AND-MODES)
  "Right-associated function information for the [proof-checker]

    Examples:
    ACL2 !>(dive-into-macros-table (w state))
    ((CAT . EXPAND-ADDRESS-CAT)
     (LXOR . EXPAND-ADDRESS-LXOR)

  This table associates macro names with functions used by the
  [proof-checker]'s DV and numeric diving commands (e.g., 3) in order
  to dive properly into subterms. See [proof-checker], in particular
  the documentation for DV.

  This table can be extended easily. See [add-dive-into-macro] and also
  see [remove-dive-into-macro].

  The symbol associated with a macro should be a function symbol taking
  four arguments, in this order:

    * car-addr
          the first number in the list given to the [proof-checker]'s DV
          command

    * raw-term
          the untranslated term into which we will dive

    * term
          the translated term into which we will dive

    * wrld
          the current ACL2 logical [world]

  The function will normally return a list of positive integers,
  representing the (one-based) address for diving into term that
  corresponds to the single-address dive into raw-term by
  car-address. However, it can return (cons str alist), where str is
  a string suitable for [fmt] and args is the corresponding alist for
  [fmt].

  Referring to the example above, expand-address-cat would be such a
  function, which will be called on raw-term values that are calls of
  cat. See the community book books/misc/rtl-untranslate.lisp for the
  definition of such a function.

  See [table] for a general discussion of tables.")
 (DMR
  (DEBUGGING BREAK-REWRITE ACCUMULATED-PERSISTENCE)
  "Dynamically monitor rewrites and other prover activity

  In addition to utilities that allow you to set breakpoints or print
  rewriting information to the screen --- see [break-rewrite] ---
  ACL2 provides a utility for watching the activity of the rewriter
  and some other proof processes, in real time. This utility is
  called ``dmr'', which is an acronym for ``dynamically monitor
  rewrites''. The utility comes in two parts: an ACL2 component that
  frequently updates a file (the ``dmr file'') containing the
  relevant information, and an Emacs component that frequently
  updates the an Emacs buffer (the ``dmr buffer'') with the contents
  of that file. Other editors could, in principle, be programmed to
  display that file; anyone developing such a capability is invited
  to contribute it to the ACL2 community.

  The dmr utility can be extremely helpful for expensive proofs,
  especially when ACL2 is not providing any output to the terminal.
  The [break-rewrite] and [accumulated-persistence] utilities may be
  a bit easier to use, so you might want to try those first. But the
  dmr utility can be a very helpful debugging aide, as it can
  visually give you a sense of where ACL2 is spending its time.

  The Emacs portion of this utility is already loaded if you load the
  distributed Emacs file emacs/emacs-acl2.el. Otherwise, invoke the
  following Emacs command, say by typing Control-X Control-E after
  the right parenthesis, where DIR is the directory of your ACL2
  distribution.

    (load \"<DIR>/emacs/monitor.el\") ; absolute pathnames might work best

  You only need to do that once. Then each time you want to observe the
  rewriter in action, invoke the following to see it displayed in a
  buffer, which we call the ``dmr buffer'':

    Control-t 1

  But first you will need to enable monitoring at the ACL2 level:

    (dmr-start)

  Monitoring has some cost. So if you have started it, then at some
  point you may want to turn it off when not using it. Any time the
  dmr buffer (generally called \"acl2-dmr-<user_name>\") is not
  visible, Emacs monitoring is turned off. You can also turn off
  Emacs monitoring explicitly, with:

    Control-t 2

  At the ACL2 level you can disable monitoring as follows:

    (dmr-stop)

  Interpreting the dmr buffer display.

  We explain the dmr buffer display by way of the following example. It
  is a snapshot of a dmr buffer taken from one of the community
  books,
  books/workshops/2004/legato/support/proof-by-generalization-mult.lisp.

     0. (DEFTHM . WP-ZCOEF-G-MULTIPLIES)
     1. SIMPLIFY-CLAUSE
       2. Rewriting (to simplify) the atom of literal 18; argument(s) 1
       4. Rewriting (to simplify) the expansion; argument(s) 3|2
       7. Applying (:DEFINITION WP-ZCOEF-G)
    *  8. Rewriting (to simplify) the rewritten body; argument(s) 2|1|2|2
    *  13. Applying (:REWRITE MOD-ZERO . 2)
    *    14. Rewriting (to establish) the atom of hypothesis 4
    *    15. Applying (:META META-INTEGERP-CORRECT)

  Each line indicates an ACL2 activity that leads to the activity shown
  on the line just below it. Moreover, lines are sometimes collapsed
  to make the display more compact. Consider for example the first
  few lines. Above, we are proving a theorem named
  WP-ZCOEF-G-MULTIPLIES. Lines 1 and 2 show the clause simplification
  process invokes the rewriter on the 18th literal. (Recall that a
  clause is a disjunction of literals; for example the clause {(NOT
  A), (NOT B), C} would be displayed as (IMPLIES (AND A B) C).) This
  18th literal mentioned on line 2 is a function call (f arg1 ...),
  and ``argument(s) 1'' indicates that the rewriter, which works
  inside-out, is considering the first argument (``arg1''). Thus the
  display could instead have shown the following.

    2. Rewriting (to simplify) the atom of literal 18
    3. Rewriting (to simplify) the first argument
    4. Rewriting (to simplify) the expansion; argument(s) 3|2

  But it saved space to combine lines 2 and 3. Line 4 suggests that the
  above arg1 is a function call that has been opened up because of an
  :expand hint or, perhaps, an expansion directed explicitly by the
  prover (as can happen during induction). The annotation
  ``argument(s) 3|2'' then indicates that the rewriter is diving into
  the third argument of the expansion, and then into the second
  argument of that. Let us call the result term7 (since it is the one
  to be considered on line 7).

  Now consider the next two lines:

       7. Applying (:DEFINITION WP-ZCOEF-G)
    *  8. Rewriting (to simplify) the rewritten body; argument(s) 2|1|2|2

  Line 7 is saying that term7 (defined above) is modified by applying
  the definition of WP-ZCOEF-G to it. Line 8 then says that the body
  of this definition has been rewritten (with its formals bound to
  the actuals from term7) and the rewriter is diving into the
  subterms of that rewritten body, as indicated. Notice also that
  line 8 is the first line marked with an asterisk (``*'') in the
  margin. This line is the first that is different from what was
  shown the previous time the display was updated (about 1/10 second
  earlier, by default). When a line is marked with an asterisk, so
  are all the lines below it; so the lines without an asterisk are
  those that have been stable since the last display. In this example
  we may see line 7 marked without an asterisk for a while, which
  suggests that the rule (:DEFINITION WP-ZCOEF-G) is expensive. (Also
  see [accumulated-persistence].) In general, a line that persists
  for awhile without a leading asterisk can suggest why the proof is
  taking a long time.

  Finally, note the indentation of line 14 relative to line 13. Extra
  indentation occurs when an attempt is being made to relieve a
  hypothesis (i.e., rewrite it to t). In particular, rewrites that
  will be incorporated directly into a (top-level) literal are all
  indented just two spaces, starting with the first rewrite directly
  under a process such as SIMPLIFY-CLAUSE (shown line 1 above). If
  the indentation is at least the value of raw Lisp variable
  *dmr-indent-max* (by default, 20), then indenttion is restricted to
  that column, but ACL2 prints {n} where n is the column that would
  have been used for indentation if there were no maximum.

  You can move the cursor around in the dmr buffer even while it is
  being updated. But emacs will attempt to keep the cursor no later
  than the first asterisk (``*'') in the margin. Thus, you can move
  the cursor around in the stable part of the display, and emacs will
  keep the cursor in that stable part.

  WARNING: Things could go terribly wrong if the same user runs two
  different ACL2 sessions with dmr active, because the same file will
  be written by two different ACL2 processes.

  WARNING: For dmr to work, emacs and ACL2 need to be run on the same
  machine because the file used to communicate between ACL2 and emacs
  is under /tmp. Except, you can probably hack around that
  restriction by changing *dmr-file-name* in ACL2 (in raw Lisp) and
  correspondingly in Emacs file monitor.el.

  More generally, advanced users are welcome to search for the string

    User-settable dmr variables

  in ACL2 files interface-raw.lisp and emacs/monitor.el in order to
  customize their dmr environments.

  In order to update the dmr file with the latest stack information,
  interrupt ACL2 and then evaluate: (dmr-flush). In order to support
  resumption of the interrupted proof (assuming your host Common Lisp
  supports resumption), evaluation of (dmr-start) will automatically
  enable the debugger if it is not already enabled and not fully
  disabled with value :never (see [set-debugger-enable]). If such
  automatic enabling takes place, then (dmr-stop) will restore the
  old setting of the debugger unless, after (dmr-start) enables the
  debugger but before (dmr-stop) is called, you call
  [set-debugger-enable] (or more precisely: function
  set-debugger-enable-fn is called).

  Note for users of the experimental extension ACL2(p) (see
  [parallelism]): when waterfall-parallelism has been set to a
  non-nil value (see [set-waterfall-parallelism]), statistics about
  parallel execution are printed instead of the usual information.")
 (DO-NOT (POINTERS)
         "See [hints] for keyword :do-not.")
 (DO-NOT-INDUCT (POINTERS)
                "See [hints] for keyword :do-not-induct.")
 (DOC
  (DOCUMENTATION)
  "[Documentation] at the terminal

  The :doc command may be used at the ACL2 prompt to access the ACL2
  system [documentation]. Usually it may also access documentation
  defined in books. However, most users will probably access the ACL2
  documentation in other ways; see [documentation]. In particular,
  consider using the acl2+books combined manual at the following
  location on the web, for topics documented in the ACL2 community
  [books] or in the ACL2 system (where the latter are rearranged):

  
  http://www.cs.utexas.edu/users/moore/acl2/v6-4/combined-manual/index.html

  Alternatively, consider using the ACL2-doc Emacs browser; see
  [ACL2-doc].

    Examples:
    ACL2 !>:doc DEFTHM          ; print documentation of DEFTHM
    ACL2 !>:doc logical-name    ; print documentation of LOGICAL-NAME

    General Form:
    ACL2>:doc name")
 (DOC!
  (LEGACY-DOCUMENTATION)
  "All the [documentation] for a name (type :doc! name)

  NOTE: The :doc! command only makes sense at the terminal.

    Examples:
    ACL2 !>:doc! defthm
    ACL2 !>:doc! certificate

  This command is like :doc name followed by :[more!]. It prints all
  the [documentation] of name.")
 (DOC-STRING
  (LEGACY-DOCUMENTATION)
  "Formatted [documentation] strings

    Examples:
    \":Doc-Section name
    one-liner~/notes~/details\"

    \":Doc-Section name
    one-liner~/
    notes~/
    details~/
    :cite old-name1
    :cited-by old-name2\"

  Use (get-doc-string 'name state) to see other examples.

  [Documentation] strings not beginning with ``:Doc-Section'' (case is
  irrelevant) are ignored. See [markup] for how to supply formatting
  information (such as fonts and displayed text) in [documentation]
  strings.

  ACL2 attaches special importance to [documentation] strings beginning
  with the header ``:Doc-Section'' (or any variant thereof obtained
  by changing case). Any [documentation] string that does not begin
  with such a header is considered unformatted and is ignored. For
  the rest of this discussion, we use the phrase ``[documentation]
  string'' as though it read ``formatted [documentation] string.''

  [Documentation] strings are always processed in the context of some
  symbol, name, being defined. (Indeed, if an event defines no
  symbol, e.g., [verify-guards] or [in-theory], then it is not
  permitted to have a formatted [documentation] string.) The string
  will be associated with name in the ``[documentation] database.''
  The database is divided into ``sections'' and each section is named
  by a symbol. Among the sections are [events], [documentation],
  [history], [other], and [miscellaneous]. A complete list of the
  sections may be obtained by typing :docs * at the terminal. You can
  create new sections. The main purpose of sections is simply to
  partition the large set of names into smaller subsets whose
  contents can be enumerated separately. The idea is that the user
  may remember (or recognize) the relevant section name and then read
  its contents to find interesting items.

  Within a section are ``[documentation] tuples'' which associate with
  each documented name its [documentation] string and a list of
  related documented names, called the ``related names'' of the name.
  When :[doc] prints the [documentation] for name, it always lists
  the related names.

  When a formatted [documentation] string is submitted with the
  defining event of some name, the section name and an initial set of
  related names are parsed from the string. In addition, the
  formatted string contains various ``levels'' of detail that are
  printed out at different times. Finally, it is possible for a
  string to cause the newly documented name to be added to the
  related names of any previously documented name. Thus, as new names
  are introduced they can be grouped with old ones.

  The general form of an ACL2 formatted [documentation] string is

    \":DOC-SECTION <section-name>
      <one-liner>~/
      <notes>~/
      <details>~/
      :CITE <n1>
      ...
      :CITE <nn>
      :CITED-BY <m1>
      ...
      :CITED-BY <mm>\"

  Before we explain this, let it be noted that (get-doc-string name
  state) will return the [documentation] string associated with name
  in the [documentation] database. You may want to call
  get-doc-string on '[pe] and '[union-theories] just to see some
  concrete [documentation] strings. This [documentation] string,
  which is rather long, is under 'doc-string.

  A formatted [documentation] string has five parts: the header and
  section-name (terminating in the first #\\Newline), the <one-liner>,
  <notes>, and <details> (each terminating in a tilde-slash (``~/'')
  pair), and a citation part. These five parts are parsed into six
  components. <section-name> is read as the name of a symbol,
  section-name. <one-liner>, <notes>, and <details> are arbitrary
  sequences of [characters] (ignoring initial white space and not
  including the tilde-slash pairs which terminate them). The <ni> are
  read as symbols and assembled into a list called the ``cite''
  symbols. The <mi> are read as symbols and assembled into a list
  called the ``cited-by'' symbols. See the warning below regarding
  the hackish nature of our symbol reader.

  Section-name must either be a previously documented symbol or else be
  name, the symbol being documented. To open a new section of the
  database, named section-name, you should define the logical name
  section-name (as by [deflabel] or any other event; also see
  [defdoc]) and attach to it a [documentation] string for section
  section-name. You might wish to print out the [documentation]
  string we use for some of our section names, e.g., (get-doc-string
  'events state). By forcing section names to be documented symbols,
  we permit sections themselves to have one line descriptions and
  discussions, presented by the standard [documentation] facilities
  like the facilities :[doc] and :[more-doc] that may be used at the
  terminal.

  Each of the ni's and mi's must be previously documented symbols.

  Both <one-liner> and <details> must be non-empty, i.e., must contain
  some non-whitespace [characters]. <notes> may be empty. The :cites
  and :cited-bys pairs may be intermingled and may be separated by
  either newlines or spaces. The citation part may be empty. When the
  citation part is empty, the tilde-slash pair terminating the
  <details> part may be omitted. Thus, the simplest form of a
  formatted [documentation] string is:

    \":Doc-Section <section-name>
     <one-liner>~/~/
     <details>\"

  Since white space at the front of <one-liner>, <notes> and <details>
  is ignored, we often precede those parts by #\\Newlines to make the
  strings easier to read in our source files. We also typically
  indent all of the text in the string by starting each line with a
  few spaces. (The Emacs commands for formatting Lisp get confused if
  you have arbitrary [characters] on the left margin.) We assume that
  every line in <one-liner>, <notes>, and <details> starts with at
  least as many spaces as <one-liner> does, i.e., we assume they are
  all indented the same amount (or more). Let d be the number of
  spaces separating <one-liner> from the #\\Newline preceding it. When
  the various parts are printed, we ``de-indent'' by stripping out
  the first d spaces following each #\\Newline.

  However, we find that when [documentation] is printed flush against
  the left margin it is difficult to distinguish the [documentation]
  text from previous output. We therefore prefix each line we print
  by a special pad of [characters]. By default, this pad is ``|'' so
  that [documentation] text has a vertical bar running down the left
  margin. But the pad is just the value of the global variable
  doc-prefix and you may [assign] it any string you wish.

  To add such a string to the database under the symbol name we make a
  new entry in the section-name section of the database. The entry
  associates name with the string and uses the string's cites list as
  the initial value of the related names field. In addition, we add
  name to the related names field of each of the names listed in the
  string's cited-by list. We also add name to the related names field
  of its section-name. Observe that the cites list in a string is
  only the initial value of the related names of the names. Future
  [documentation] strings may add to it via :cited-by or
  :Doc-Section. Indeed, this is generally the case. We discuss this
  further below.

  When a brief description of name is required (as by :docs **), name
  and <one-liner> are printed. <one-liner> is usually printed
  starting in column 15 (however see [print-doc-start-column]).
  Despite its name, <one-liner> need not be one line. It usually is
  one line, however.

  When you type :[doc] name at the terminal, the first response will be
  to print name and <one-liner>. Then :[doc] prints <notes>, if any.
  Then, if name is the name of a section, it prints the <one-liner>s
  for each of its related names. For example, try :doc events. If
  name is not a section name but does have some related names, they
  are merely listed but not explained. Try :doc theory-functions.
  :more-doc name prints <details>.

  Our style is to let each new concept add itself to the related names
  of old concepts. To do otherwise increases the chances that
  [documentation] gets outdated because one often forgets to update
  supposedly complete lists of the relevant topics when new topics
  are invented. For example, :doc theory-functions lists each
  available theory function. But get-doc-string of
  '[theory-functions] just shows a few examples and has an empty
  cites list. From where do we get the names of the theory functions
  listed by :[doc]? The answer is that each theory function has its
  own [documentation] string and those strings each specify :cited-by
  [theory-functions]. See for example get-doc-string of
  '[union-theories]. So by the time the entire system is assembled,
  the related names of '[theory-functions] contains all the
  (documented) theory functions. This makes it easy to add new theory
  functions without changing the general discussion in
  '[theory-functions].

  When an event or [command] form is printed, as by :[pe] or :[pc],
  that contains a formatted [documentation] string, we do not print
  the actual [documentation] string (since they are usually large and
  distracting). Instead we print the string:

    \"Documentation available via :doc\"

  inviting you to use :[doc] and :[more-doc] (or get-doc-string) if you
  wish to see the [documentation] at the terminal.

  Warning on Reading Symbols from Strings: When we read a symbol, such
  as the section-symbol, from a [documentation] string, we use a
  quick and dirty imitation of the much more powerful CLTL read
  program. In particular, we scan past any whitespace, collect all
  the [characters] we see until we get to more whitespace or the end
  of the string, convert the [characters] to upper case, make a
  string out of them, and [intern] that string. Thus, if you typed
  \":Doc-Section 123 ...\" we would read the 123 as the symbol |123|.
  Observe that special [characters], such as parentheses and escape
  [characters], are not afforded their usual reverence by our hack.
  Furthermore, the question arises: in which package do we [intern]
  the symbol? The answer is, usually, the package containing the name
  being defined. I.e., if you are documenting my-pkg::name and you
  attach a [documentation] string that begins \":Doc-Section: Machines
  ...\" then the section-symbol will be my-pkg::machines. We recognize
  two special cases. If the first character read is a colon, we use
  the keyword package. If the first five [characters] read are acl2::
  then we [intern] in the \"ACL2\" package. Our own section names,
  e.g., [events], are in the \"ACL2\" package.

  In a related area, when you ask for the [documentation] of a name,
  e.g., when you type :doc name at the terminal, that name is read
  with the full ACL2 reader, not the hack just described. That name
  is read into the current package. Thus, if you are operating
  [in-package] \"MY-PKG\" and type :doc events, what is read is
  my-pkg::events. The database may not contain an entry for this
  symbol. Before reporting that no [documentation] exists, we try
  acl2::events.

  One last note: [defpkg] permits a formatted [documentation] string,
  which is associated in the database with the name of the package.
  But the name of the package is a string, not a symbol. It is
  permitted to access the [documentation] of a string (i.e., package
  name). But there are no facilities for getting such a [stringp]
  name into the related names of another name nor of making such
  [stringp] names be section names. That is because we always read
  symbols from strings and never read strings from strings. I.e., if
  you did write \"Doc-Section \\\"MY-PKG\\\" ...\" it would read in as a
  weird symbol.")
 (DOCS
  (LEGACY-DOCUMENTATION)
  "Available [documentation] topics (by section)

  NOTE: The :docs command only makes sense at the terminal.

  When the :docs command is given a [stringp] argument it searches the
  text produced by :[doc] and :[more-doc] and lists all the
  documented topics whose text contains the given string. For
  purposes of this string matching we ignore distinctions of case and
  the amount and kind (but not presence) of white space. We also
  treat hyphen as whitespace.

  However, the following examples show how :docs can be used on other
  than string patterns.

    Examples:
    ACL2 !>:docs *           ; lists documentation sections
    ACL2 !>:docs **          ; lists all documented topics within all sections
    ACL2 !>:docs events      ; lists all topics in section EVENTS
    ACL2 !>:docs \"compil\"    ; lists topics ``apropos''

  The database of formatted [documentation] strings is structured into
  sections. Within a section are topics. Each topic has a one-liner,
  some notes, and some detailed discussions. The :docs command
  provides a view of the entire database.

  :docs takes one argument, as described below:

    arg               effect

    *                 list all section headings in the database
    **                list all section headings and all topics within
                      each section
    name              list all topics in the section named name (where
                      name is some symbol other than * and **).  This
                      is always the same as :doc name.
    pattern           list all topics whose :doc or :more-doc text
                      mentions the string pattern.  For purposes of this
                      string matching we ignore distinctions of case and
                      the amount and kind (but not presence) of white
                      space.  We also treat hyphen as whitespace.")
 (DOCUMENTATION
  (ACL2)
  "ACL2 system (and books) documentation

  Here, we explain documentation for ACL2 and its community books.

  If you are using a release copy of ACL2, then we recommend that you
  use a web browser to view the acl2+books combined manual. You can
  view it on the web here:

  
  http://www.cs.utexas.edu/users/moore/acl2/v6-4/combined-manual/index.html

  From that page, you also have the option of downloading a local copy
  of that manual (click on the ``down arrow'' icon at the top-right
  of that page) or of building a local copy (see the (@see xdoc)
  topic).

  Emacs users may prefer to read documentation inside a custom
  ``ACL2-Doc'' Emacs browser. See [ACL2-doc].

  The ACL2 User's Manual is distributed with ACL2. It contains ACL2
  system documentation but unlike the acl2+books combined manual, it
  does not contain documentation from the books. A web-based copy is
  included with the ACL2 distribution in directory doc/manual/, and
  you can easily get to it by opening file doc/home-page.html in your
  browser.

  You can also read documentation at the terminal, for the ACL2 system
  and for documentation from any books that have been loaded into
  your session, by typing :[doc] followed by the topic name, for
  example

    :doc rewrite

  or

    (doc 'rewrite)

  ACL2 users are welcome to contribute to the ACL2 system
  documentation. See community book books/system/doc/acl2-doc.lisp.

  The ACL2 system documentation includes topics not only for names of
  functions, macros, and constants, but also names of certain
  important ideas. For example, see [rewrite] and see [meta] to learn
  about :[rewrite] rules and :[meta] rules, respectively. See [hints]
  to learn about the structure of the :[hints] argument to the
  prover.

  If you want documentation on an ACL2 function or macro that is not
  documented, there are still several alternatives.

    ACL2 !>:args fn

  will print the arguments and some other relevant information about
  the named function or macro. This information is all gleaned from
  the definition and hence this is a definitive way to determine if
  fn is defined as a function or macro.

  You might also want to type:

    ACL2 !>:pc fn

  which will print the [command] that introduced fn. You should see
  [command-descriptor] for details on the kinds of input you can give
  the :[pc] command.


Subtopics

  [ACL2-doc]
      A custom Emacs browser for reading ACL2 [documentation]

  [Args]
      args, [guard], type, [constraint], etc., of a function symbol

  [Broken-link]
      Placeholder for link to documentation that resides in the community
      books

  [Doc]
      [Documentation] at the terminal

  [Documentation-copyright]
      Copyright and authorship of documentation

  [Finding-documentation]
      Searching the documentation

  [Legacy-documentation]
      Parent section for the legacy \"documentation\" topic (likely to be
      deleted soon)

  [Pointers]
      Links pointing to relevant documentation topics")
 (DOCUMENTATION-COPYRIGHT
  (COPYRIGHT DOCUMENTATION)
  "Copyright and authorship of documentation

  There are two manuals associated with ACL2: the ACL2 User's Manual
  and the acl2+books combined manual. See [documentation]. The former
  is distributed with ACL2, you can reach many links into it from the
  ACL2 home page. The latter may be preferred for routine browsing,
  since it extends the ACL2 User's Manual with documentation obtained
  from the [community-books].

  The ACL2 User's Manual is copyrighted under the terms of the LICENSE
  file distributed with ACL2. Its original authors are the ACL2
  authors, but it is now defined in an ACL2 community book,
  books/system/doc/acl2-doc.lisp, so that members of the ACL2
  community may contribute to it.

  The acl2+books combined manual is a mechanically generated mashup
  derived from both the ACL2 User's Manual and the [community-books].
  The combined manual thus has contributions from many authors. At
  the top of each topic, in a line under the topic name, you will
  generally find either ``ACL2 Sources'' or the name of a Community
  Book. In the former case, the text is from the ACL2 User's Manual
  and is authored, copyrighted, and licensed as per the ACL2
  [copyright]. When a book is named, the content was extracted from
  that book which may be inspected for authorship, copyright, and
  license terms.

  There are two standard tools for browsing these manuals, other than
  using the :[doc] command at the terminal.

    * The ACL2 [Xdoc] Fancy Viewer. This tool, written by Jared Davis, is
      included with the web-based version of each manual. Information
      on copyright and licensing are provided in its LICENSE file.
    * The [ACL2-doc] Emacs browser. This tool, authored by Matt Kaufmann
      and J Strother Moore, is distributed with ACL2 and is licensed
      under the terms of the LICENSE file distributed with ACL2.")
 (DOUBLE-REWRITE
  (MISCELLANEOUS REWRITE)
  "Cause a term to be rewritten twice

  Logically, double-rewrite is the [identity] function: (double-rewrite
  x) is equal to x. However, the ACL2 rewriter treats calls of
  double-rewrite in the following special manner. When it encounters
  a term (double-rewrite u), it first rewrites u in the current
  context, and then the rewriter rewrites the result.

  Such double-rewriting is rarely necessary, but it can be useful when
  rewriting under non-trivial equivalence relations (see
  [equivalence]). The following example will illustrate the issue.

    ; Define an equivalence relation.
    (defun my-equiv (x y)
      (equal x y))
    (defequiv my-equiv)

    ; Define a unary function whose argument is preserved by my-equiv.
    (defun foo (x)
      (declare (ignore x))
      t)
    (defcong my-equiv equal (foo x) 1)

    ; Define some other unary functions.
    (defun g (x) x)
    (defun h1 (x) x)
    (defun h2 (x) x)

    ; Prove some lemmas and then disable the functions above.
    (defthm lemma-1
      (my-equiv (h1 x) (h2 x)))
    (defthm lemma-2
      (foo (h2 x)))
    (defthm lemma-3
      (implies (foo x)
               (equal (g x) x)))
    (in-theory (union-theories (theory 'minimal-theory)
                               '(lemma-1 lemma-2 lemma-3
                                 my-equiv-implies-equal-foo-1)))

    ; Attempt to prove a simple theorem that follows ``obviously'' from the
    ; events above.
    (thm (equal (g (h1 a)) (h1 a)))

  We might expect the proof of this final thm to succeed by the
  following reasoning. It is immediate from lemma-3 provided we can
  establish (foo (h1 a)). By the defcong event above, we know that
  (foo (h1 a)) equals (foo (h2 a)) provided (my-equiv (h1 a) (h2 a));
  but this is immediate from lemma-1. And finally, (foo (h2 a)) is
  true by lemma-2.

  Unfortunately, the proof fails. But fortunately, ACL2 gives the
  following useful warning when lemma-3 is submitted:

    ACL2 Warning [Double-rewrite] in ( DEFTHM LEMMA-3 ...):  In the :REWRITE
    rule generated from LEMMA-3, equivalence relation MY-EQUIV is maintained
    at one problematic occurrence of variable X in hypothesis (FOO X),
    but not at any binding occurrence of X.  Consider replacing that occurrence
    of X in this hypothesis with (DOUBLE-REWRITE X).  See :doc double-
    rewrite for more information on this issue.

  We can follow the warning's advice by changing lemma-3 to the
  following.

    (defthm lemma-3
      (implies (foo (double-rewrite x))
               (equal (g x) x)))

  With this change, the proof succeeds for the final thm above.

  In practice, it should suffice for users to follow the advice given
  in the ``Double-rewrite'' warnings, by adding calls of
  double-rewrite around certain variable occurrences. But this can
  cause inefficiency in large proof efforts. For that reason, and for
  completeness, it seems prudent to explain more carefully what is
  going on; and that is what we do for the remainder of this
  [documentation] topic. Optionally, also see the paper ``Double
  Rewriting for Equivalential Reasoning in ACL2'' by Matt Kaufmann
  and J Strother Moore, in the proceedings of the 2006 ACL2 Workshop
  (paper is published in ACM Digital Library,
  http://portal.acm.org/toc.cfm?id=1217975).

  Suggesting congruence rules.

  Sometimes the best way to respond to a ``Double-rewrite'' warning may
  be to prove a congruence rule. Consider for example this rule.

    (defthm insert-sort-is-id
      (perm (insert-sort x) x))

  Assuming that perm has been identified as an [equivalence] relation
  (see [defequiv]), we will get the following warning.

    ACL2 Warning [Double-rewrite] in ( DEFTHM INSERT-SORT-IS-ID ...):
    In a :REWRITE rule generated from INSERT-SORT-IS-ID, equivalence relation
    PERM is maintained at one problematic occurrence of variable X in the
    right-hand side, but not at any binding occurrence of X.  Consider
    replacing that occurrence of X in the right-hand side with
    (DOUBLE-REWRITE X).  See :doc double-rewrite for more information on
    this issue.

  The problem is that the second occurrence of x (the right-hand side
  of the rule insert-sort-is-id) is in a context where perm is to be
  maintained, yet in this example, the argument x of insert-sort on
  the left-hand side of that rule is in a context where perm will not
  be maintained. This can lead one to consider the possibility that
  perm could be maintained in that left-hand side occurrence of x,
  and if so, to prove the following congruence rule.

    (defcong perm perm (insert-sort x) 1)

  This will eliminate the above warning for insert-sort-is-id. More
  important, this [defcong] event would probably be useful, since it
  would allow rewrite rules with equivalence relation perm to operate
  on the first argument of any call of insert-sort whose context
  calls for maintaining perm.

  Details on double-rewrite.

  The reader who wants these details may first wish to see
  [equivalence] for relevant review.

  The ACL2 rewriter takes a number of contextual arguments, including
  the generated equivalence relation being maintained (see
  [congruence]) and an association list that maps variables to terms.
  We call the latter alist the unify-subst because it is produced by
  unifying (actually matching) a pattern against a current term; let
  us explain this point by returning to the example above. Consider
  what happens when the rewriter is given the top-level goal of the
  thm above.

    (equal (g (h1 a)) (h1 a))

  This rewrite is performed with the empty alist (unify-subst), and is
  begun by rewriting the first argument (in that same empty
  unify-subst):

    (g (h1 a))

  Note that the only equivalence relation being maintained at this
  point is equal. Now, the rewriter notices that the left-hand side
  of lemma-3, which is (g x), matches (g (h1 a)). The rewriter thus
  creates a unify-subst binding x to (h1 a): ((x . (h1 a))). It now
  attempts to rewrite the hypothesis of lemma-3 to t under this
  unify-subst.

  Consider what happens now if the hypothesis of lemma-3 is (foo x). To
  rewrite this hypothesis under a unify-subst of ((x . (h1 a))), it
  will first rewrite x under this unify-subst. The key observation
  here is that this rewrite takes place simply by returning the value
  of x in the unify-subst, namely (h1 a). No further rewriting is
  done! The efficiency of the ACL2 rewriter depends on such caching
  of previous rewriting results.

  But suppose that, instead, the hypothesis of lemma-3 is (foo
  (double-rewrite x)). As before, the rewriter dives to the first
  argument of this call of foo. But this time the rewriter sees the
  call (double-rewrite x), which it handles as follows. First, x is
  rewritten as before, yielding (h1 a). But now, because of the call
  of double-rewrite, the rewriter takes (h1 a) and rewrites it under
  the empty unify-subst. What's more, because of the defcong event
  above, this rewrite takes place in a context where it suffices to
  maintain the equivalence relation my-equiv. This allows for the
  application of lemma-1, hence (h1 a) is rewritten (under
  unify-subst = nil) to (h2 a). Popping back up, the rewriter will
  now rewrite the call of foo to t using lemma-2.

  The example above explains how the rewriter treats calls of
  double-rewrite, but it may leave the unfortunate impression that
  the user needs to consider each :[rewrite] or :[linear] rule
  carefully, just in case a call of double-rewrite may be
  appropriate. Fortunately, ACL2 provides a ``[Double-rewrite]''
  warning to inform the user of just this sort of situation. If you
  don't see this warning when you submit a (:[rewrite] or :[linear])
  rule, then the issue described here shouldn't come up for that
  rule. Such warnings may appear for hypotheses or right-hand side of
  a :[rewrite] rule, and for hypotheses or full conclusion (as
  opposed to just the trigger term) of a :[linear] rule.

  If you do see a ``[Double-rewrite]'' warning, then should you add the
  indicated call(s) of double-rewrite? At the time of writing this
  [documentation], the answer is not clear. Early experiments with
  double rewriting suggested that it may be too expensive to call
  double-rewrite in every instance where a warning indicates that
  there could be an advantage to doing so. And at the time of this
  writing, the ACL2 regression suite has about 1900 such warnings
  (but note that books were developed before double-rewrite or the
  ``[Double-rewrite]'' warning were implemented), which suggests that
  one can often do fine just ignoring such warnings. However, it
  seems advisable to go ahead and add the calls of double-rewrite
  indicated by the warnings unless you run across efficiency problems
  caused by doing so. Of course, if you decide to ignore all such
  warnings you can execute the event:
  ([set-inhibit-warnings] \"Double-rewrite\").

  Finally, we note that it is generally not necessary to call
  double-rewrite in order to get its effect in the following case,
  where the discussion above might have led one to consider a call of
  double-rewrite: a hypothesis is a variable, or more generally, we
  are considering a variable occurrence that is a branch of the
  top-level IF structure of a hypothesis. The automatic handling of
  this case, by a form of double rewriting, was instituted in ACL2
  Version_2.9 and remains in place with the introduction of
  double-rewrite. Here is a simple illustrative example. Notice that
  foo-holds applies to prove the final [thm] below, even without a
  call of double-rewrite in the hypothesis of foo-holds, and that
  there is no ``[Double-rewrite]'' warning when submitting foo-holds.

    (encapsulate
     (((foo *) => *)
      ((bar *) => *))

     (local (defun foo (x) (declare (ignore x)) t))
     (local (defun bar (x) (declare (ignore x)) t))

     (defthm foo-holds
       (implies x
                (equal (foo x) t)))
     (defthm bar-holds-propositionally
       (iff (bar x) t)))

    (thm (foo (bar y)))")
 (DYNAMICALLY-MONITOR-REWRITES (POINTERS)
                               "See [dmr].")
 (E/D
  (THEORIES THEORY-FUNCTIONS)
  "Enable/disable rules

  The macro e/d creates theory expressions for use in [in-theory] hints
  and events. It provides a convenient way to [enable] and [disable]
  simultaneously, without having to write arcane theory expressions.

    Examples:
    (e/d (lemma1 lemma2))          ; equivalent to (enable lemma1 lemma2)
    (e/d () (lemma))               ; equivalent to (disable lemma)
    (e/d (lemma1) (lemma2 lemma3)) ; Enable lemma1 then disable lemma2, lemma3.
    (e/d () (lemma1) (lemma2))     ; Disable lemma1 then enable lemma2.

    General Form:
    (e/d enables-0 disables-0 ... enables-n disables-n)

  where each enables-i and disables-i is a list of runic designators;
  see [theories], see [enable], and see [disable].

  The e/d macro takes any number of lists suitable for the [enable] and
  [disable] macros, and creates a theory that is equal to
  (current-theory :here) after executing the following commands.

  (in-theory (enable . enables-0)) (in-theory (disable . disables-0))
  [etc.] (in-theory (enable . enables-n)) (in-theory (disable .
  disables-n))")
 (EARLY-TERMINATION
  (PARALLEL-PROGRAMMING)
  "Early termination for [pand] and [por].

  This [documentation] topic relates to the experimental extension of
  ACL2 supporting parallel execution and proof; see [parallelism].

  The evaluation of (and expr1 expr2) returns nil if expr1 evaluates to
  nil, avoiding the evaluation of expr2. More generally, the
  evaluation of (and expr1 expr2 ... exprk) terminates with a return
  value of nil as soon as any expri evaluates to nil --- no exprj is
  evaluated in this case for j > i. This so-called ``lazy
  evaluation'' of [and] terms can thus save some computation; roughly
  speaking, the smaller the i, the more computation is saved.

  If the above call of [and] is replaced by its parallel version,
  [pand], then there can be even more opportunity for skipping work.
  The arguments to [pand] can be evaluated in parallel, in which case
  the first such evaluation that returns with a value of nil, if any,
  causes the remaining such evaluations to abort.

  Consider the following functions that compute whether a tree is valid
  (see [granularity] for a discussion of the granularity form).

    (defun valid-tip (x)
      (declare (xargs :guard t))
      (or (eq x 'A)
          (eq x 'T)
          (eq x 'C)
          (eq x 'G)))

    (defun pvalid-tree (x depth)
      (declare (xargs :guard (natp depth)))
      (if (atom x)
          (valid-tip x)
        (pand (declare (granularity (< depth 10)))
              (pvalid-tree (car x) (1+ depth))
              (pvalid-tree (cdr x) (1+ depth)))))

  We would like to stop execution as soon as any tip is found to be
  invalid. So, when computing the conjunction of terms by using
  [pand], once one of those terms evaluates to nil, the computations
  for the other terms are aborted and the [pand] call returns nil. By
  using [pand], we can in principle attain a speedup factor greater
  than the number of available cores.

  The concept of early termination also applies to [por], except that
  early termination occurs when an argument evaluates to non-nil.")
 (EC-CALL
  (ACL2-BUILT-INS)
  "Execute a call in the ACL2 logic instead of raw Lisp

  The name ``ec-call'' represents ``executable-counterpart call.'' This
  utility is intended for users who are familiar with guards. See
  [guard] for a general discussion of guards.

  Logically, ec-call behaves like the identity macro; during proofs,
  (ec-call TERM) is typically replaced quickly by TERM during a proof
  attempt. However, ec-call causes function calls to be evaluated in
  the ACL2 logic rather than raw Lisp, as explained below.

    General Form:
    (ec-call (fn term1 ... termk))

  where fn is a known function symbol other than those in the list that
  is the value of the constant *ec-call-bad-ops*. In particular, fn
  is not a macro. Semantically, (ec-call (fn term1 ... termk)) equals
  (fn term1 ... termk). However, this use of ec-call has two effects.

      (1) [Guard] verification generates no proof obligations from the
      guard of fn for this call. Indeed, guards need not have been
      verified for fn.

      (2) During evaluation, after the arguments of fn are evaluated as
      usual, the executable counterpart of fn is called, rather than
      fn as defined in raw Lisp. That is, the call of fn is made on
      its evaluated arguments as though this call is being made in
      the ACL2 top-level loop, rather than in raw Lisp. In
      particular, the [guard] of fn is checked, at least by default
      (see [set-guard-checking]).

  Note that in the term (ec-call (fn term1 ... termk))', only the
  indicated call of fn is made in the logic; each termi is evaluated
  in the normal manner. If you want an entire term evaluated in the
  logic, wrap ec-call around each function call in the term (other
  than calls of if and ec-call).

  Technical Remark (probably best ignored). During evaluation of a call
  of [defconst] or [defpkg] in raw Lisp, a form (ec-call (fn term1
  ... termk)) is treated as (fn term1 ... termk), that is, without
  calling the executable counterpart of fn. This situation occurs
  when loading a compiled file (or expansion file) on behalf of an
  [include-book] event. The reason is technical: executable
  counterparts are defined below a book's events in the book's
  compiled file. End of Technical Remark.

  Here is a small example. We define foo recursively but with guard
  verification inhibited on the recursive call, which is to be
  evaluated in the ACL2 logic.

    ACL2 !>(defun foo (x y)
            (declare (xargs :guard (consp y)))
            (if (consp x)
                (cons (car x) (ec-call (foo (cdr x) (cdr y))))
              (car y)))

    The admission of FOO is trivial, using the relation O< (which is known
    to be well-founded on the domain recognized by O-P) and the measure
    (ACL2-COUNT X).  We could deduce no constraints on the type of FOO.

    Computing the guard conjecture for FOO....

    The guard conjecture for FOO is trivial to prove.  FOO is compliant
    with Common Lisp.

    Summary
    Form:  ( DEFUN FOO ...)
    Rules: NIL
    Warnings:  None
    Time:  0.00 seconds (prove: 0.00, print: 0.00, other: 0.00)
     FOO
    ACL2 !>(foo '(2 3 4 5) '(6 7))

    ACL2 Error in TOP-LEVEL:  The guard for the function call (FOO X Y),
    which is (CONSP Y), is violated by the arguments in the call
    (FOO '(4 5) NIL).  To debug see :DOC print-gv, see :DOC trace, and
    see :DOC wet.  See :DOC set-guard-checking for information about suppressing
    this check with (set-guard-checking :none), as recommended for new
    users.

    ACL2 !>

  The error above arises because eventually, foo recurs down to a value
  of parameter y that violates the guard. This is clear from tracing
  (see [trace$] and see [trace]). Each call of the executable
  counterpart of foo (the so-called ``*1*'' function for foo) checks
  the guard and then invokes the raw Lisp version of foo. The raw
  Lisp version calls the executable counterpart on the recursive
  call. When the guard check fails we get a violation.

    ACL2 !>(trace$ foo)
     ((FOO))
    ACL2 !>(foo '(2 3 4 5) '(6 7))
    1> (ACL2_*1*_ACL2::FOO (2 3 4 5) (6 7))
      2> (FOO (2 3 4 5) (6 7))
        3> (ACL2_*1*_ACL2::FOO (3 4 5) (7))
          4> (FOO (3 4 5) (7))
            5> (ACL2_*1*_ACL2::FOO (4 5) NIL)

    ACL2 Error in TOP-LEVEL:  The guard for the function call (FOO X Y),
    which is (CONSP Y), is violated by the arguments in the call
    (FOO '(4 5) NIL).  To debug see :DOC print-gv, see :DOC trace, and
    see :DOC wet.  See :DOC set-guard-checking for information about suppressing
    this check with (set-guard-checking :none), as recommended for new
    users.

    ACL2 !>

  If we turn off guard errors then we can see the trace as above, but
  where we avoid calling the raw Lisp function when the guard fails
  to hold.

    ACL2 !>:set-guard-checking nil

    Masking guard violations but still checking guards except for self-
    recursive calls.  To avoid guard checking entirely, :SET-GUARD-CHECKING
    :NONE.  See :DOC set-guard-checking.

    ACL2 >(foo '(2 3 4 5) '(6 7))
    1> (ACL2_*1*_ACL2::FOO (2 3 4 5) (6 7))
      2> (FOO (2 3 4 5) (6 7))
        3> (ACL2_*1*_ACL2::FOO (3 4 5) (7))
          4> (FOO (3 4 5) (7))
            5> (ACL2_*1*_ACL2::FOO (4 5) NIL)
              6> (ACL2_*1*_ACL2::FOO (5) NIL)
                7> (ACL2_*1*_ACL2::FOO NIL NIL)
                <7 (ACL2_*1*_ACL2::FOO NIL)
              <6 (ACL2_*1*_ACL2::FOO (5))
            <5 (ACL2_*1*_ACL2::FOO (4 5))
          <4 (FOO (3 4 5))
        <3 (ACL2_*1*_ACL2::FOO (3 4 5))
      <2 (FOO (2 3 4 5))
    <1 (ACL2_*1*_ACL2::FOO (2 3 4 5))
    (2 3 4 5)
    ACL2 >")
 (EIGHTH
  (ACL2-BUILT-INS)
  "Eighth member of the list

  See any Common Lisp documentation for details.")
 (ELIM
  (RULE-CLASSES)
  "Make a destructor elimination rule

  See [rule-classes] for a general discussion of rule classes,
  including how they are used to build rules from formulas and a
  discussion of the various keywords in a rule class description.

  The following example of an :elim rule is an important one, and is
  built into ACL2.

    (defaxiom car-cdr-elim
      (implies (consp x)
               (equal (cons (car x) (cdr x)) x))
      :rule-classes :elim)

  The class of :elim rules is fundamentally quite different from the
  more common class of :[rewrite] rules. Briefly put, a :rewrite rule
  replaces instances of its left-hand side with corresponding
  instances of its right-hand side. But an :elim rule, on the other
  hand, has the effect of generalizing so-called ``destructor''
  function applications to variables. In essence, applicability of a
  :rewrite rule is based on matching its left-hand side, while
  applicability of an :elim rule is based on the presence of at least
  one destructor term.

  For example, a conjecture about (car x) and (cdr x) can be replaced
  by a conjecture about new variables x1 and x2, as shown in the
  following example. (Run the command :mini-proveall and search for
  CAR-CDR-ELIM to see the full proof containing this excerpt.)

    Subgoal *1/1'
    (IMPLIES (AND (CONSP X)
                  (TRUE-LISTP (REV (CDR X))))
             (TRUE-LISTP (APP (REV (CDR X)) (LIST (CAR X))))).

    The destructor terms (CAR X) and (CDR X) can be eliminated by using
    CAR-CDR-ELIM to replace X by (CONS X1 X2), (CAR X) by X1 and (CDR X)
    by X2.  This produces the following goal.

    Subgoal *1/1''
    (IMPLIES (AND (CONSP (CONS X1 X2))
                  (TRUE-LISTP (REV X2)))
             (TRUE-LISTP (APP (REV X2) (LIST X1)))).

    This simplifies, using primitive type reasoning, to

    Subgoal *1/1'''
    (IMPLIES (TRUE-LISTP (REV X2))
             (TRUE-LISTP (APP (REV X2) (LIST X1)))).

  The resulting conjecture is often simpler and hence more amenable to
  proof.

  The application of an :elim rule thus replaces a variable by a term
  that contains applications of so-called ``destructor'' functions to
  that variable. The example above is typical: the variable x is
  replaced by the term (cons (car x) (cdr x)), which applies a
  so-called ``constructor'' function, [cons], to applications (car x)
  and (cdr x) of destructor functions [car] and [cdr] to that same
  variable, x. But that is only part of the story. ACL2 then
  generalizes the destructor applications (car x) and (cdr x) to new
  variables x1 and x2, respectively, and ultimately the result is a
  simpler conjecture.

  More generally, the application of an :elim rule replaces a variable
  by a term containing applications of destructors; there need not be
  a clear-cut notion of ``constructor.'' But the situation described
  above is typical, and we will focus on it, giving full details when
  we introduce the ``General Form'' below.

  Notice that the situation can be complicated a bit by a rule's
  hypotheses. For example, the replacement specified by the rule
  car-cdr-elim (shown near the beginning of this discussion) is only
  valid if the variable being replaced is a cons structure. Thus,
  when ACL2 applies car-cdr-elim to replace a variable v, it will
  split into two cases: one case in which (consp v) is true, in which
  v is replaced by (cons (car v) (cdr v)) and then (car v) and (cdr
  v) are generalized to new variables; and one case in which (consp
  v) is false. In practice, (consp v) is often provable, perhaps even
  literally present as a hypotheses; then of course there is no need
  to introduce the second case. That is why there is no such second
  case in the example above.

  You might find :elim rules to be useful whenever you have in mind a
  data type that can be built up from its fields with a
  ``constructor'' function and whose fields can be accessed by
  corresponding ``destructor'' functions. So for example, if you have
  a ``house'' data structure that represents a house in terms of its
  address, price, and color, you might have a rule like the
  following.

    Example:
    (implies (house-p x)
             (equal (make-house (address x)
                                (price x)
                                (color x))
                    x))

  The application of such a rule is entirely analogous to the
  application of the rule car-cdr-elim discussed above. We discuss
  such rules and their application more carefully below.

    General Form:
    (implies hyp (equiv lhs x))

  where equiv is a known equivalence relation (see [defequiv]); x is a
  variable symbol; and lhs contains one or more terms (called
  ``destructor terms'') of the form (fn v1 ... vn), where fn is a
  function symbol and the vi are distinct variable symbols, v1, ...,
  vn include all the variable symbols in the formula, no fn occurs in
  lhs in more than one destructor term, and all occurrences of x in
  lhs are inside destructor terms.

  To use an :elim rule, the theorem prover waits until a conjecture has
  been maximally simplified. It then searches for an instance of some
  destructor term (fn v1 ... vn) in the conjecture, where the
  instance for x is some variable symbol, vi, and every occurrence of
  vi outside the destructor terms is in an equiv-hittable position.
  If such an instance is found, then the theorem prover instantiates
  the :elim formula as indicated by the destructor term matched;
  splits the conjecture into two goals, according to whether the
  instantiated hypothesis, hyp, holds; and in the case that it does
  hold, generalizes all the instantiated destructor terms in the
  conjecture to new variables and then replaces vi in the conjecture
  by the generalized instantiated lhs. An occurrence of vi is
  ``equiv-hittable'' if sufficient congruence rules (see [defcong])
  have been proved to establish that the propositional value of the
  clause is not altered by replacing that occurrence of vi by some
  equiv-equivalent term.

  If an :elim rule is not applied when you think it should have been,
  and the rule uses an equivalence relation, equiv, other than equal,
  it is most likely that there is an occurrence of the variable that
  is not equiv-hittable. Easy occurrences to overlook are those in
  the governing hypotheses. If you see an unjustified occurrence of
  the variable, you must prove the appropriate congruence rule to
  allow the :elim to fire.

  Further examples of how ACL2 :elim rules are used may be found in the
  corresponding discussion of ``Elimation of Destructors'' for Nqthm,
  in Section 10.4 of A Computational Logic Handbook.")
 (EMACS
  (ACL2-TUTORIAL)
  "Emacs support for ACL2

  Many successful ACL2 users run in an shell under the Emacs editor. If
  you do so, then you may wish to load the distributed file
  emacs/emacs-acl2.el. The file begins with considerable comments
  describing what it offers. It is intended to work both with GNU
  Emacs and XEmacs.

  In particular, the above file provides the ACL2-Doc browser, a
  convenient tool for viewing, in Emacs, documentation for both the
  ACL2 system and the documented community books. See [ACL2-Doc].

  If you are not comfortable with Emacs, you may prefer to use an
  Eclipse-based interface; see [ACL2-sedan].")
 (EMBEDDED-EVENT-FORM
  (MISCELLANEOUS)
  "Forms that may be embedded in other [events]

    Examples:
    (defun hd (x) (if (consp x) (car x) 0))
    (local (defthm lemma23 ...))
    (progn (defun fn1 ...)
           (local (defun fn2 ...))
           ...)

    General Form:
    An embedded event form is a term, x, such that:

    * x is a call of an event function other than [defpkg] (see [events]
      for a listing of the event functions);
    * x is of the form ([local] x1) where x1 is an embedded event form;
    * x is of the form ([skip-proofs] x1) where x1 is an embedded event
      form;
    * x is of the form ([make-event] &), where & is any term whose
      expansion is an embedded event (see [make-event]);
    * x is of the form ([with-output] ... x1), ([with-prover-step-limit]
      ... x1 ...), or ([with-prover-time-limit] ... x1), where x1 is
      an embedded event form;
    * x is a call of [encapsulate], [progn], [progn!], or [include-book];
    * x macroexpands to one of the forms above; or
    * [intended only for the implementation] x is (RECORD-EXPANSION x1 x2),
      where x1 and x2 are embedded event forms.

  However, we add the following restrictions for [local] contexts.

    * An embedded event form may not set the [ACL2-defaults-table] when in
      the context of [local]. Thus for example, the form

          (local (table acl2-defaults-table :defun-mode :program))

      is not an embedded event form, nor is the form (local (program)),
      since the latter sets the [ACL2-defaults-table] implicitly. An
      example at the end of the discussion below illustrates why
      there is this restriction.
    * A call of [defaxiom] is illegal in the context of [local]. Without
      this restriction, one could locally assert a strong axiom like
      (equal t nil) and then non-locally prove that formula, leaving
      you in an ACL2 logical [world] in which it appears that the
      formula is actually provable without such an axiom.
    * A call of [add-include-book-dir!] or [delete-include-book-dir!] is
      illegal in the context of [local]. For an explanation, see
      [add-include-book-dir!].

  Only embedded event forms are allowed in a book after its initial
  [in-package] form. See [books]. However, you may find that
  [make-event] allows you to get the effect you want for a form that
  is not an embedded event form. For example, you can put the
  following into a book, which assigns the value 17 to [state] global
  variable x:

    (make-event (er-progn (assign x 17)
                          (value '(value-triple nil)))
                :check-expansion t)

  When an embedded event is executed while [ld-skip-proofsp] is
  '[include-book], those parts of it inside [local] forms are
  ignored. Thus,

    (progn (defun f1 () 1)
           (local (defun f2 () 2))
           (defun f3 () 3))

  will define f1, f2, and f3 when [ld-skip-proofsp] is nil or t, but
  will define only f1 and f3 when [ld-skip-proofsp] is
  '[include-book].

  Discussion:

  [Encapsulate], [progn], and [include-book] place restrictions on the
  kinds of forms that may be processed. These restrictions ensure
  that the non-local [events] are indeed admissible provided that the
  sequence of [local] and non-local [events] is admissible when
  proofs are done, i.e., when ld-skip-proofs is nil. But [progn!]
  places no such restrictions, hence is potentially dangerous and
  should be avoided unless you understand the ramifications; so it is
  illegal unless there is an active trust tag (see [defttag]).

  [Local] permits the hiding of an event or group of [events] in the
  sense that [local] [events] are processed when we are trying to
  establish the admissibility of a sequence of [events] embedded in
  [encapsulate] forms or in [books], but are ignored when we are
  constructing the [world] produced by assuming that sequence. Thus,
  for example, a particularly ugly and inefficient :[rewrite] rule
  might be made [local] to an [encapsulate] that ``exports'' a
  desirable theorem whose proof requires the ugly lemma.

  To see why we can't allow just anything as an embedded event,
  consider allowing the form

    (if (ld-skip-proofsp state)
        (defun foo () 2)
        (defun foo () 1))

  followed by

    (defthm foo-is-1 (equal (foo) 1)).

  When we process the [events] with [ld-skip-proofsp] is nil, the
  second [defun] is executed and the [defthm] succeeds. But when we
  process the [events] with [ld-skip-proofsp] '[include-book], the
  second [defun] is executed, so that foo no longer has the same
  definition it did when we proved foo-is-1. Thus, an invalid formula
  is assumed when we process the [defthm] while skipping proofs.
  Thus, the first form above is not a legal embedded event form.

  If you encounter a situation where these restrictions seem to prevent
  you from doing what you want to do, then you may find make-event to
  be helpful. See [make-event].

  [Defpkg] is not allowed because it affects how things are read after
  it is executed. But all the forms embedded in an event are read
  before any are executed. That is,

    (encapsulate nil
                 (defpkg \"MY-PKG\" nil)
                 (defun foo () 'my-pkg::bar))

  makes no sense since my-pkg::bar must have been read before the
  [defpkg] for \"MY-PKG\" was executed.

  Finally, let us elaborate on the restriction mentioned earlier
  related to the [ACL2-defaults-table]. Consider the following form.

    (encapsulate
     ()
     (local (program))
     (defun foo (x)
       (if (equal 0 x)
           0
         (1+ (foo (- x))))))

  See [local-incompatibility] for a discussion of how [encapsulate]
  processes event forms. Briefly, on the first pass through the
  [events] the definition of foo will be accepted in [defun] mode
  :[program], and hence accepted. But on the second pass the form
  (local (program)) is skipped because it is marked as [local], and
  hence foo is accepted in [defun] mode :[logic]. Yet, no proof has
  been performed in order to admit foo, and in fact, it is not hard
  to prove a contradiction from this definition!")
 (ENABLE
  (THEORIES THEORY-FUNCTIONS)
  "Adds names to current theory

    Example:
    (enable fact (fact) associativity-of-app)

    General Form:
    (enable name1 name2 ... namek)

  where each namei is a runic designator; see [theories]. The result is
  the theory that contains all the names in the current theory plus
  those listed. Note that this is merely a function that returns a
  theory. The result is generally a very long list of [rune]s and you
  will probably regret printing it.

  The standard way to ``enable'' a fixed set of names, is as follows;
  see [hints] and see [in-theory].

    :in-theory (enable name1 name2 ... namek)  ; in a hint
    (in-theory (enable name1 name2 ... namek)) ; as an event
    (local ; often desirable, to avoid exporting from the current context
     (in-theory (enable name1 name2 ... namek)))

  Note that all the names are implicitly quoted. If you wish to enable
  a computed list of names, lst, use the theory expression
  (union-theories (current-theory :here) lst).")
 (ENABLE-FORCING
  (FORCE EVENTS SWITCHES-PARAMETERS-AND-MODES)
  "To allow forced case splits

    General Form:
    ACL2 !>:enable-forcing    ; allowed forced case splits

  See [force] and see [case-split] for a discussion of forced case
  splits, which are turned back on by this command. See
  [disable-forcing] for an example showing how to turn off forced
  case splits.

  Enable-forcing is actually a macro that [enable]s the executable
  counterpart of the function symbol force; see [force]. When you
  want to use [hints] to turn on forced case splits, use a form such
  as one of the following (these are equivalent).

    :in-theory (enable (:executable-counterpart force))
    :in-theory (enable (force))")
 (ENABLE-IMMEDIATE-FORCE-MODEP
  (FORCE EVENTS SWITCHES-PARAMETERS-AND-MODES)
  "[force]d hypotheses are attacked immediately

    General Form:
    ACL2 !>:enable-immediate-force-modep

  This event causes ACL2 to attack [force]d hypotheses immediately
  instead of delaying them to the next forcing round. See
  [immediate-force-modep]. Or for more basic information, first see
  [force] for a discussion of [force]d case splits.

  Enable-immediate-force-modep is a macro that [enable]s the executable
  counterpart of the function symbol [immediate-force-modep]. When
  you want to [enable] this mode in [hints], use a form such as one
  of the following (these are equivalent).

    :in-theory (enable (:executable-counterpart immediate-force-modep))
    :in-theory (enable (immediate-force-modep))")
 (ENCAPSULATE
  (EVENTS)
  "Hide some [events] and/or constrain some functions

  Encapsulate provides a way to execute a sequence of [events] and then
  hide some of the resulting effects. There are two kinds of
  encapsulations: ``trivial'' and ``non-trivial''. We discuss these
  briefly before providing detailed [documentation].

  A trivial encapsulation is an event of the following form.

    (encapsulate
     () ; nil here indicates \"trivial\"
     <event-1>
     ...
     <event-k>)

  We use the term ``sub-events'' to refer to <event-1> through
  <event-k>. Each sub-event <event-i> may be ``[local]'', that is, of
  the form (local <event-i'>); the other sub-events are called
  ``non-local''. When this encapsulate form is submitted to ACL2, it
  is processed in two passes. On the first pass, each sub-event is
  processed in sequence; admission of the encapsulate fails if any
  <event-i> fails to be admitted. Then a second pass is made after
  rolling back the logical [world] to what it was just before
  executing the encapsulate form. In the second pass, only the
  non-[local] forms <event-i> are evaluated, again in order, and
  proofs are skipped.

  For example, the following trivial encapsulation exports a single
  event, member-equal-reverse. The lemma member-revappend is used (as
  a [rewrite] rule) to prove member-equal-reverse on the first pass,
  but since member-revappend is [local], it is ignored on the second
  (final) pass.

    (encapsulate
     ()

     (local
      (defthm member-revappend
        (iff (member-equal a (revappend x y))
             (or (member-equal a x)
                 (member-equal a y)))
        :hints ((\"Goal\" :induct (revappend x y)))))

     (defthm member-equal-reverse
       (iff (member-equal a (reverse x))
            (member-equal a x))))

  Of course, one might prefer to prove these [events] at the top level,
  rather than within an encapsulation; but the point here is to
  illustrate that you can have [local] [events] that do not become
  part of the logical [world]. (Such a capability is also provided at
  the level of [books]; in particular, see [include-book].)

  On the other hand, non-trivial encapsulations provide a way to
  introduce axioms about new function symbols, without introducing
  inconsistency and without introducing complete definitions. The
  following example illustrates how that works.

    (encapsulate

    ; The following list has a single signature, introducing a function foo of
    ; one argument that returns one value.  (The list is non-empty, so we call
    ; this a \"non-trivial\" encapsulation.)
     ( ((foo *) => *) )

    ; Introduce a ``witness'' (example) for foo, marked as local so that
    ; it is not exported:
     (local (defun foo (x) x))

    ; Introduce a non-local property to be exported:
     (defthm foo-preserves-consp
       (implies (consp x)
                (consp (foo x))))
    )

  The form above introduces a new function symbol, foo, with the
  indicated property and no definition. In fact, the output from ACL2
  concludes as follows.

    The following constraint is associated with the function FOO:

    (IMPLIES (CONSP X) (CONSP (FOO X)))

  To understand this example, we consider how non-trivial
  encapsulations are processed. The same two passes are made as for
  trivial encapsulations, and the ([local]) definition of foo is
  ignored on the second pass, and hence does not appear in the
  resulting ACL2 logical [world]. But before the second pass, each
  [signature] is stored in the [world]. Thus, when the theorem
  foo-preserves-consp is encountered in the second pass, foo is a
  known function symbol with the indicated signature.

  We turn now to more complete documentation. But discussion of
  redundancy for encapsulate events may be found elsewhere; see
  [redundant-encapsulate].

    Other Examples:
    (encapsulate (((an-element *) => *))

    ; The list of signatures above could also be written
    ;            ((an-element (lst) t))

      (local (defun an-element (lst)
               (if (consp lst) (car lst) nil)))
      (local (defthm member-equal-car
                (implies (and lst (true-listp lst))
                         (member-equal (car lst) lst))))
      (defthm thm1
         (implies (null lst) (null (an-element lst))))
      (defthm thm2
         (implies (and (true-listp lst)
                       (not (null lst)))
                  (member-equal (an-element lst) lst))))

    (encapsulate
     () ; empty signature: no constrained functions indicated

     (local (defthm hack
              (implies (and (syntaxp (quotep x))
                            (syntaxp (quotep y)))
                       (equal (+ x y z)
                              (+ (+ x y) z)))))

     (defthm nthcdr-add1-conditional
       (implies (not (zp (1+ n)))
                (equal (nthcdr (1+ n) x)
                       (nthcdr n (cdr x))))))

    General Form:
    (encapsulate (signature ... signature)
      ev1
      ...
      evn)

  where each [signature] is a well-formed signature, each signature
  describes a different function symbol, and each evi is an embedded
  event form (See [embedded-event-form]). Also see [signature], in
  particular for a discussion of how a signature can assign a [guard]
  to a function symbol. There must be at least one evi. The evi
  inside [local] special forms are called ``local'' [events] below.
  [Events] that are not [local] are sometimes said to be ``exported''
  by the encapsulation. We make the further restriction that no
  [defaxiom] event may be introduced in the scope of an encapsulate
  (not even by encapsulate or [include-book] events that are among
  the evi). Furthermore, no non-[local] [include-book] event is
  permitted in the scope of any encapsulate with a non-empty list of
  signatures.

  To be well-formed, an encapsulate event must have the properties that
  each event in the body (including the [local] ones) can be
  successfully executed in sequence and that in the resulting theory,
  each function mentioned among the [signature]s was introduced via a
  [local] event and has the [signature] listed. (A utility is
  provided to assist in debugging failures of such execution; see
  [redo-flat].) In addition, the body may contain no ``local
  incompatibilities'' which, roughly stated, means that the [events]
  that are not [local] must not syntactically require symbols defined
  by [local] [events], except for the functions listed in the
  [signature]s. See [local-incompatibility]. Finally, no non-[local]
  recursive definition in the body may involve in its suggested
  induction scheme any function symbol listed among the [signature]s.
  See [subversive-recursions].

  Observe that if the [signature]s list is empty, the resulting
  ``trivial'' encapsulate may still be useful for deriving theorems
  to be exported whose proofs require lemmas you prefer to hide
  (i.e., made [local]). Whether trivial or not (i.e., whether the
  signature is empty or not), encapsulate exports the results of
  evaluating its non-[local] [events], but its [local] [events] are
  ignored for the resulting logical [world].

  The result of a non-trivial encapsulate event is an extension of the
  logic in which, roughly speaking, the functions listed in the
  [signature]s are constrained to have the [signature]s listed and to
  satisfy the non-[local] theorems proved about them. In fact, other
  functions introduced in the encapsulate event may be considered to
  have ``[constraint]s'' as well. (See [constraint] for details,
  which are only relevant to functional instantiation.) Since the
  [constraint]s were all theorems in the ``ephemeral'' or ``local''
  theory, we are assured that the extension produced by encapsulate
  is sound. In essence, the [local] definitions of the constrained
  functions are just ``witness functions'' that establish the
  consistency of the [constraint]s. Because those definitions are
  [local], they are not present in the theory produced by
  encapsulation. After a non-trivial encapsulate event is admitted,
  theorems about the constrained function symbols may then be proved
  --- theorems whose proofs necessarily employ only the
  [constraint]s. Thus, those theorems may be later functionally
  instantiated, as with the :functional-instance lemma instance (see
  [lemma-instance]), to derive analogous theorems about different
  functions, provided the constraints (see [constraint]) can be
  proved about the new functions.

  The [default-defun-mode] for the first event in an encapsulation is
  the default [defun-mode] ``outside'' the encapsulation. But since
  [events] changing the [defun-mode] are permitted within the body of
  an encapsulate, the default [defun-mode] may be changed. However,
  [defun-mode] changes occurring within the body of the encapsulate
  are not exported. In particular, the [ACL2-defaults-table] after an
  encapsulate is always the same as it was before the encapsulate,
  even though the encapsulate body might contain [defun-mode]
  changing [events], :[program] and :[logic]. See [defun-mode]. More
  generally, after execution of an encapsulate event, the value of
  [ACL2-defaults-table] is restored to what it was immediately before
  that event was executed. See [ACL2-defaults-table].

  We make some remarks on [guard]s and evaluation. Calls of functions
  introduced in the [signature]s list cannot be evaluated in the ACL2
  read-eval-print loop. See [defattach] for a way to overcome this
  limitation. Moreover, any :[guard] supplied in the signature is
  automatically associated in the [world] with its corresponding
  function symbol, with no requirement other than that the guard is a
  legal term all of whose function symbols are in :[logic] mode with
  their [guard]s verified. In particular, there need not be any
  relationship between a guard in a signature and the guard in a
  local witness function. Finally, note that for functions introduced
  non-[local]ly inside a non-trivial encapsulate event, [guard]
  verification is illegal unless ACL2 determines that the proof
  obligations hold outside the [encapsulate] event as well.

    (encapsulate
     ((f (x) t))
     (local (defun f (x) (declare (xargs :guard t)) (consp x)))
     ;; ERROR!
     (defun g (x)
       (declare (xargs :guard (f x)))
       (car x)))

  The order of the [events] in the vicinity of an encapsulate is
  confusing. We discuss it in some detail here because when logical
  names are being used with theory functions to compute sets of
  rules, it is sometimes important to know the order in which
  [events] were executed. (See [logical-name] and see
  [theory-functions].) What, for example, is the set of function
  names extant in the middle of an encapsulation?

  If the most recent event is previous and then you execute an
  encapsulate constraining an-element with two non-[local] [events]
  in its body, thm1 and thm2, then the order of the [events] after
  the encapsulation is (reading chronologically forward): previous,
  thm1, thm2, an-element (the encapsulate itself). Actually, between
  previous and thm1 certain extensions were made to the [world] by
  the superior encapsulate, to permit an-element to be used as a
  function symbol in thm1.

  Remark for ACL2(r) (see [real]). For ACL2(r), [encapsulate] can be
  used to introduce classical and non-classical functions, as
  determined by the signatures; see [signature]. Those marked as
  classical (respectively non-classical) must have classical
  (respectively, non-classical) [local] witness functions. A related
  requirement applies to functional instantiation; see
  [lemma-instance].


Subtopics

  [Redundant-encapsulate]
      Redundancy of [encapsulate] [events]")
 (ENDP
  (ACL2-BUILT-INS)
  "Recognizer for empty lists

  In the ACL2 logic, (endp x) is the same as (atom x). See [atom].

  Unlike [atom], the [guard] for endp requires that x is a [cons] pair
  or is nil. Thus, endp is typically used as a termination test for
  functions that recur on a [true-listp] argument. See [guard] for
  general information about [guard]s.

  Endp is a Common Lisp function. See any Common Lisp documentation for
  more information.

  Function: <endp>

    (defun endp (x)
           (declare (xargs :guard (or (consp x) (eq x nil))))
           (atom x))")
 (ENTER-BOOT-STRAP-MODE
  (MISCELLANEOUS)
  "The first millisecond of the Big Bang

  ACL2 functions, e.g., [if], that show enter-boot-strap-mode as their
  defining [command] are in fact primitives. It is impossible for the
  system to display defining axioms about these symbols.

  Enter-boot-strap-mode is a Common Lisp function but not an ACL2
  function. It magically creates from nil an ACL2 property list
  [world] that lets us start the boot-strapping process. That is,
  once enter-boot-strap-mode has created its [world], it is possible
  to process the [defconst]s, [defun]s, and [defaxiom]s, necessary to
  bring up the rest of the system. Before that [world] is created,
  the attempt by ACL2 even to translate a [defun] form, say, would
  produce an error because [defun] is undefined.

  Several ACL2 functions show enter-boot-strap-mode as their defining
  [command]. Among them are [if], [cons], [car], and [cdr]. These
  functions are characterized by axioms rather than definitional
  equations --- axioms that in most cases are built into our code and
  hence do not have any explicit representation among the rules and
  formulas in the system.")
 (EQ
  (ACL2-BUILT-INS)
  "Equality of symbols

  Eq is the function for determining whether two objects are identical
  (i.e., have the exact same store address in the current von Neumann
  implementation of Common Lisp). It is the same as [equal] in the
  ACL2 logic.

  Eq is a Common Lisp function. In order to ensure conformance with
  Common Lisp, the ACL2 [guard] on eq requires at least one of the
  arguments to eq to be a symbol. Common Lisp guarantees that if x is
  a symbol, then x is eq to y if and only if x is [equal] to y. Thus,
  the ACL2 user should think of eq as nothing besides a fast means
  for checking [equal] when one argument is known to be a symbol. In
  particular, it is possible that an eq test will not even require
  the cost of a function call but will be as fast as a single machine
  instruction.

  Function: <eq>

    (defun eq (x y)
           (declare (xargs :guard (if (symbolp x) t (symbolp y))))
           (equal x y))")
 (EQL
  (ACL2-BUILT-INS)
  "Test equality (of two numbers, symbols, or [characters])

  (eql x y) is logically equivalent to (equal x y).

  Unlike [equal], eql has a [guard] requiring at least one of its
  arguments to be a number, a symbol, or a character. Generally, eql
  is executed more efficiently than [equal].

  For a discussion of the various ways to test against 0, See
  [zero-test-idioms].

  Eql is a Common Lisp function. See any Common Lisp documentation for
  more information.

  Function: <eql>

    (defun eql (x y)
           (declare (xargs :guard (or (eqlablep x) (eqlablep y))))
           (equal x y))")
 (EQLABLE-ALISTP
  (ACL2-BUILT-INS)
  "Recognizer for a true list of pairs whose [car]s are suitable for
  [eql]

  The predicate eqlable-alistp tests whether its argument is a
  [true-listp] of [consp] objects whose [car]s all satisfy
  [eqlablep].

  Function: <eqlable-alistp>

    (defun eqlable-alistp (x)
           (declare (xargs :guard t))
           (cond ((atom x) (equal x nil))
                 (t (and (consp (car x))
                         (eqlablep (car (car x)))
                         (eqlable-alistp (cdr x))))))")
 (EQLABLE-LISTP
  (ACL2-BUILT-INS)
  "Recognizer for a true list of objects each suitable for [eql]

  The predicate eqlable-listp tests whether its argument is a
  [true-listp] of objects satisfying [eqlablep].

  Function: <eqlable-listp>

    (defun eqlable-listp (l)
           (declare (xargs :guard t))
           (if (consp l)
               (and (eqlablep (car l))
                    (eqlable-listp (cdr l)))
               (equal l nil)))")
 (EQLABLEP
  (ACL2-BUILT-INS)
  "The [guard] for the function [eql]

  The predicate eqlablep tests whether its argument is suitable for
  [eql], at least one of whose arguments must satisfy this predicate
  in Common Lisp. (Eqlablep x) is true if and only if its argument is
  a number, a symbol, or a character.

  Function: <eqlablep>

    (defun eqlablep (x)
           (declare (xargs :guard t))
           (or (acl2-numberp x)
               (symbolp x)
               (characterp x)))")
 (EQUAL
  (ACL2-BUILT-INS)
  "True equality

  (equal x y) is equal to t or nil, according to whether or not x and y
  are the same value.

  For a discussion of the various idioms for testing against 0, See
  [zero-test-idioms].")
 (EQUALITY-VARIANTS
  (PROGRAMMING)
  "Versions of a function using different equality tests

  The ACL2 environment includes not only a logic but also a programming
  language, which is based on Common Lisp. Execution efficiency may
  be increased by using fast equality tests: [eq] for symbols and
  [eql] for numbers, symbols, and characters (see [eqlablep]).
  Several list-processing functions built into ACL2 thus have three
  variants, depending on whether the equality function used is [eq],
  [eql], or [equal]; a list is provided below. ACL2 has taken
  measures to ensure that one can reason about a single logical
  function even when one uses these different variants.

  Consider for example the case of list membership. Common Lisp
  provides a utility for this purposes, [member], which can take a
  :TEST keyword argument, default [eql]. So for example, one might
  write

    (member a x :TEST 'eq)

  if either a is a symbol or x is a list of symbols, so that the
  fastest equality test ([eq]) may be used when comparing a to
  successive elements of the list, x. One might elsewhere write
  (member b (foo y)), which is equivalent to (member b (foo y) :TEST
  'eql), for example if b is a number. If one wants to reason about
  both (member a x :TEST 'eq) and (member b y), it might be helpful
  for both calls of member to be the same logically, even though
  Common Lisp will execute them differently (using [eq] or [eql],
  respectively). ACL2 arranges that in fact, both references to
  [member] generate calls of [member-equal] in the theorem prover.

  In fact, since [member] can take the optional :TEST keyword argument,
  then in ACl2 it must be defined as a macro, not a function (see
  [defun]). ACL2 arranges that a call of member generates a
  corresponding call of the function [member-equal], regardless of
  the value of TEST, in a manner that produces [member-equal] in
  prover output. More generally, you can expect ACL2 to treat your
  use of [member] as though you had written [member-equal], for
  example in the way it stores [rewrite] rules and other kinds of
  rules as well (see [rule-classes]). We say little here about how
  this is all arranged by ACL2, other than to mention that [mbe] is
  utilized (so, you might see mention in proof logs) of the function
  [return-last] that implements [mbe]. Such details, which involve a
  notion of ``macro alias'' and probably can be ignored by most
  users, may be found elsewhere; see [equality-variants-details].

  As a convenience to the user, the macro member-eq is provided that
  expands to a corresponding call of member with :TEST 'eq, as
  follows.

    ACL2 !>:trans1 (member-eq (foo x) (bar y))
     (MEMBER (FOO X) (BAR Y) :TEST 'EQ)
    ACL2 !>

  For efficiency we recommend using the -equal equality variant, for
  example [member-equal] or ([member] ... :TEST 'equal), in certain
  contexts: [defmacro], [defpkg], [defconst], and [value-triple]
  forms. However, the implementation of equality variants has been
  designed so that when defining a function, one may choose freely in
  a definition an equality variant of primitive F, to get efficient
  execution but where subsequent reasoning is about F-equal. For
  details about the above recommendation and for a discussion of the
  implementation, see [equality-variants-details].

  The following alphabetical list includes all primitives that have
  equality variants. Each macro F listed below takes an optional
  :TEST keyword argument of 'eq, 'eql, or 'equal, where 'eql is the
  default. For each such F, a function F-equal is defined such that
  for logical purposes (in particular theorem proving), each call of
  F expands to a corresponding call of F-equal. For convenience, a
  macro F-eq is also defined, so that a call of F-eq expands to a
  corresponding call of F with :TEST 'eq.

    [add-to-set]
    [assoc]
    [delete-assoc]
    [intersection$] ; (see Note below)
    [intersectp]
    [member]
    [no-duplicatesp]
    position-ac
    [position]
    [put-assoc]
    [rassoc]
    [remove-duplicates]
    [remove1]
    [remove]
    [set-difference$] ; (see Note below)
    [subsetp]
    [union$] ; (see Note below)

  Note: Three of the macros above have names ending with the character,
  `$': [intersection$], [set-difference$], and [union$]. In each case
  there is a corresponding Common Lisp primitive without the trailing
  `$': intersection, set-difference, and union. However, Common Lisp
  does not specify the order of elements in the list returned by
  those primitives, so ACL2 has its own. Nevertheless, the only use
  of the trailing `$' is to distinguish the primitives; associated
  functions and macros, for example union-eq and intersection-equal,
  do not include the `$' character in their names.


Subtopics

  [Equality-variants-details]
      Details about [equality-variants]")
 (EQUALITY-VARIANTS-DETAILS
  (EQUALITY-VARIANTS)
  "Details about [equality-variants]

  Here we present details about equality variants, none of which is
  likely to be important to the majority of ACL2 users. Please see
  [equality-variants] for relevant background.

  We begin by presenting [events] that implement the equality variants
  for [member], as these illustrate the events introduced for all
  macros having equality variants. The definition of [member], just
  below, calls the macro let-mbe, which in turn is just an
  abbreviation for a combination of [let] and [mbe].

    (defmacro let-mbe (bindings &key logic exec)
      `(let ,bindings
         (mbe :logic ,logic
              :exec ,exec)))

  This use of [let] arranges that each argument of a call of member is
  evaluated only once.

    (defmacro member (x l &key (test ''eql))
      (declare (xargs :guard (or (equal test ''eq)
                                 (equal test ''eql)
                                 (equal test ''equal))))
      (cond
       ((equal test ''eq)
        `(let-mbe ((x ,x) (l ,l))
                  :logic (member-equal x l)
                  :exec  (member-eq-exec x l)))
       ((equal test ''eql)
        `(let-mbe ((x ,x) (l ,l))
                  :logic (member-equal x l)
                  :exec  (member-eql-exec x l)))
       (t ; (equal test 'equal)
        `(member-equal ,x ,l))))

  Inspection of the definition above shows that every call of [member]
  expands to one that is logically equivalent to the corresponding
  call of [member-equal], which is defined as follows.

    (defun member-equal (x lst)
      (declare (xargs :guard (true-listp lst)))
      (cond ((endp lst) nil)
            ((equal x (car lst)) lst)
            (t (member-equal x (cdr lst)))))

  The following two definitions model equality variants of [member] for
  tests [eq] and [eql], respectively.

    (defun member-eq-exec (x lst)
      (declare (xargs :guard (if (symbolp x)
                                 (true-listp lst)
                               (symbol-listp lst))))
      (cond ((endp lst) nil)
            ((eq x (car lst)) lst)
            (t (member-eq-exec x (cdr lst)))))

    (defun member-eql-exec (x lst)
      (declare (xargs :guard (if (eqlablep x)
                                 (true-listp lst)
                               (eqlable-listp lst))))
      (cond ((endp lst) nil)
            ((eql x (car lst)) lst)
            (t (member-eql-exec x (cdr lst)))))

  At this point the user can write (member x y) or (member-equal x y)
  to call equality variants of member with test eql or equal,
  respectively. We thus provide the following macro for the eq
  variant.

    (defmacro member-eq (x lst)
      `(member ,x ,lst :test 'eq))

  [Guard] proof obligations generated by calls of member will include
  those based on its use of mbe, and are supported by the following
  two lemmas.

    (defthm member-eq-exec-is-member-equal
      (equal (member-eq-exec x l)
             (member-equal x l)))

    (defthm member-eql-exec-is-member-equal
      (equal (member-eql-exec x l)
             (member-equal x l)))

  Finally, the following two events arrange that in certain contexts
  such as [theories] (including the use of [in-theory] in [events]
  and [hints]), [member-eq] and [member] are treated as references to
  [member-equal].

    (add-macro-alias member-eq member-equal)
    (add-macro-alias member member-equal)

  Note however that these events do not affect printing of calls during
  proofs: calls of member and member-eq will be macroexpanded away,
  leaving you with calls of member-equal that are displayed in proof
  output. For a way to change this behavior, see [add-macro-fn].

  We conclude this topic by exploring the following recommendation made
  in the [documentation] for [equality-variants].

      For efficiency we recommend using the -equal equality variant, for
      example [member-equal] or ([member] ... :TEST 'equal), in
      certain contexts: [defmacro], [defpkg], [defconst], and
      [value-triple] forms.

  ACL2 relies on the underlying Common Lisp for evaluation. It also
  processes events in the ACL2 logic. In order to guarantee
  consistency of its logical and Common Lisp evaluations, ACL2 uses a
  ``safe mode'' to avoid ill-guarded calls. In particular, consider
  the use of [mbe] in execution of a call of an equality variant of a
  primitive, F, other than its F-equal variant. The [mbe] call
  discussed above requires a connection to be established between the
  :logic and :exec forms. For example, if F is called with :TEST 'eql
  (either explicitly or as the default), then ACL2 will call both
  F-eql-exec and F-equal, and check that the two results are equal.

  The following partial log illustrates the point above. We define a
  macro that calls [member], and when a call of this macro is
  expanded during processing of a subsequent definition, we see that
  two membership functions are called on the same arguments.

    ACL2 !>(defmacro mac (lst)
             (list 'quote (and (true-listp lst)
                               (member 'c lst :test 'eq))))

    Summary
    Form:  ( DEFMACRO MAC ...)
    Rules: NIL
    Time:  0.01 seconds (prove: 0.00, print: 0.00, other: 0.01)
     MAC
    ACL2 !>(trace$ member-equal member-eq-exec)
     ((MEMBER-EQUAL) (MEMBER-EQ-EXEC))
    ACL2 !>(defun f () (mac (a b c d)))
    1> (ACL2_*1*_ACL2::MEMBER-EQ-EXEC C (A B C D))
      2> (MEMBER-EQ-EXEC C (A B C D))
      <2 (MEMBER-EQ-EXEC (C D))
    <1 (ACL2_*1*_ACL2::MEMBER-EQ-EXEC (C D))
    1> (ACL2_*1*_ACL2::MEMBER-EQUAL C (A B C D))
      2> (MEMBER-EQUAL C (A B C D))
      <2 (MEMBER-EQUAL (C D))
    <1 (ACL2_*1*_ACL2::MEMBER-EQUAL (C D))

    Since F is non-recursive, its admission is trivial.

  If performance is an issue then we can avoid such a problem, for
  example as follows. In a fresh session, let us define a suitable
  wrapper for calling [member] with :TEST 'eq. This time, the trace
  in our partial log shows that we have avoided calling two
  membership functions.

    ACL2 !>(defun mem-eq (x lst)
             (declare (xargs :guard (if (symbolp x)
                                        (true-listp lst)
                                      (symbol-listp lst))))
             (member x lst :test 'eq))
    [[ ... output omitted here ... ]]
     MEM-EQ
    ACL2 !>(defmacro mac (lst)
             (list 'quote (and (true-listp lst)
                               (mem-eq 'c lst))))

    Summary
    Form:  ( DEFMACRO MAC ...)
    Rules: NIL
    Time:  0.00 seconds (prove: 0.00, print: 0.00, other: 0.00)
     MAC
    ACL2 !>(trace$ member-equal member-eq-exec mem-eq)
     ((MEMBER-EQUAL)
      (MEMBER-EQ-EXEC)
      (MEM-EQ))
    ACL2 !>(defun f () (mac (a b c d)))
    1> (ACL2_*1*_ACL2::MEM-EQ C (A B C D))
      2> (MEM-EQ C (A B C D))
      <2 (MEM-EQ (C D))
    <1 (ACL2_*1*_ACL2::MEM-EQ (C D))

    Since F is non-recursive, its admission is trivial.")
 (EQUIVALENCE
  (RULE-CLASSES)
  "Mark a relation as an equivalence relation

  See [rule-classes] for a general discussion of rule classes,
  including how they are used to build rules from formulas and a
  discussion of the various keywords in a rule class description.

    Example:
    (defthm r-equal-is-an-equivalence ; assumes that r-equal has been defined
      (and (booleanp (r-equal x y))
           (r-equal x x)
           (implies (r-equal x y) (r-equal y x))
           (implies (and (r-equal x y)
                         (r-equal y z))
                    (r-equ