(in-package "ACL2")

; Courtesy of Bob Boyer:

(value-triple (clear-memoize-tables))

(value-triple (clear-hash-tables))

(defun fib (x)
  (declare (xargs :guard (and (integerp x)
                              (<= 0 x))))
  (mbe
   :logic 
   (cond ((zp x) 0)
         ((= x 1) 1)
         (t (+ (fib (- x 1)) (fib (- x 2)))))
   :exec
   (if (< x 2)
       x
     (+ (fib (- x 1)) (fib (- x 2))))))

#+hons
(memoize 'fib)

#+hons
(defthm fib-test
  (equal (integer-length (fib 100)) 69))

(defun tree-depth (x)
  (declare (xargs :guard t))
  (if (atom x)
      0
    (1+ (max (tree-depth (car x))
             (tree-depth (cdr x))))))

(defun build-tree (n)
  (declare (xargs :guard t))
  (if (posp n)
      (hons (build-tree (1- n)) (build-tree (1- n)))
    nil))

#+hons
(memoize 'build-tree)

#+hons
(memoize 'tree-depth)

#+hons
(defthm build-tree-test
  (equal (tree-depth (build-tree 1000)) 1000))
