; The macro assert!, defined and illustrated below, allows for assertions
; within an ACL2 book, as requested by David Rager.

(in-package "ACL2")

(defun assert!-body (assertion form)
  `(let ((assertion ,assertion))
     (er-progn
      (if assertion
          (value nil)
        (er soft 'assert!
            "Assertion failed:~%~x0"
            ',assertion))
      (value ',(or form '(value-triple nil))))))

(defmacro assert! (&whole whole-form
                          assertion &optional form)
  (list 'make-event (assert!-body assertion form)
        :on-behalf-of whole-form))

(assert! (equal 3 3)
         (defun assert-test1 (x) x))

; Check that above defun was evaluated.
(value-triple (or (equal (assert-test1 3) 3)
                  (er hard 'top-level
                      "Failed to evaluate (assert-test1 3) to 3.")))

(include-book "eval")

(must-fail
 (assert! (equal 3 4)
          (defun assert-test2 (x) x)))

; Check that above defun was not evaluated.
(defun assert-test2 (x)
  (cons x x))

; Simple test with no second argument:
(assert! (equal (append '(a b c) '(d e f))
                '(a b c d e f)))

; Check failure of assertion when condition is false:
(must-fail
 (assert! (equal (append '(a b c) '(d e f))
                 '(a b))))

; The following requires that this book be certified in the initial
; certification world.  It also succeeds at include-book time even if we
; include the book after executing another command, because assert! uses
; make-event with :check-expansion nil.  See assert-include.lisp.
(assert! (equal (access-command-tuple-form
                 (cddr (car (scan-to-command (w state)))))
                '(exit-boot-strap-mode)))
