(in-package "ACL2")

(include-book "fl2")
(include-book "fp2")
(local (include-book "../../../ordinals/ordinals-without-arithmetic"))
(include-book "../../../ordinals/e0-ordinal")

(defun expo-measure (x)
;  (declare (xargs :guard (and (real/rationalp x) (not (equal x 0)))))
  (cond ((not (rationalp x)) 0)
	((< x 0) (o^ (omega) 2)) ; changed for v2-8 from '(2 . 0)
	((< x 1) (o+ (omega) (fl (/ x)))) ; changed for v2-8 from (cons 1 (fl (/ x)))
	(t (fl x))))

(local (in-theory (enable natp))) ; added for v2-8

(defun expo (x)
  (declare (xargs; :guard (real/rationalp x)
                  :measure (expo-measure x)))
  (cond ((or (not (rationalp x)) (= x 0)) 0)
	((< x 0) (expo (- x)))
	((< x 1) (1- (expo (* 2 x))))
	((< x 2) 0)
	(t (1+ (expo (/ x 2))))))
