;;;***************************************************************
;;;An ACL2 Library of Floating Point Arithmetic

;;;Advanced Micro Devices, Inc.
;;;June, 2001
;;;***************************************************************

(in-package "ACL2")

(local (include-book "../support/top"))

(include-book "round")


;;;**********************************************************************
;;;                     THREE-INPUT ADDITION
;;;**********************************************************************

(defthm add-3
    (implies (and (natp x)
		  (natp y)
		  (natp z))
	     (= (+ x y z)
		(+ (logxor x (logxor y z))
		   (* 2 (logior (logand x y)
				(logior (logand x z)
					(logand y z)))))))
  :rule-classes ())

(defthm add-2
    (implies (and (natp x) (natp y))
	     (equal (+ x y)
		    (+ (logxor x y)
		       (* 2 (logand x y)))))
  :rule-classes ())



;;;**********************************************************************
;;;                    TRAILING ONE PREDICTION
;;;**********************************************************************

(defthm top-thm-1
    (implies (and (natp n)
		  (natp k)
		  (< k n)
		  (bvecp a n)
		  (bvecp b n))
	     (iff (= (bits (+ a b 1) k 0)
		     0)
		  (= (bits (comp1 (logxor a b) n) k 0)
		     0)))
  :rule-classes ())

(defun sigm (a b c n)
  (if (= c 0)
      (comp1 (logxor a b) n)
    (logxor a b)))

(defun kap (a b c)
  (if (= c 0)
      (* 2 (logior a b))
    (* 2 (logand a b))))

(defun tau (a b c n)
  (comp1 (logxor (sigm a b c n) (kap a b c)) (1+ n)))

(in-theory (disable tau))

(defthm bvecp-sigm
    (implies (and (natp n)
		  (bvecp a n)
		  (bvecp b n))
	     (bvecp (sigm a b c n) n))
  :rule-classes ())

(defthm bvecp-kap
    (implies (and (natp n)
		  (bvecp a n)
		  (bvecp b n))
	     (bvecp (kap a b n) (1+ n)))
    :rule-classes ())

(defthm bvecp-tau
    (implies (and (natp n)
		  (bvecp a n)
		  (bvecp b n))
	     (bvecp (tau a b c n) (1+ n)))
    :rule-classes ())

(defthm top-thm-2
    (implies (and (natp n)
		  (bvecp a n)
		  (bvecp b n)
		  (natp k)
		  (< k n)
		  (or (= c 0) (= c 1)))
	     (iff (= (bits (+ a b c) k 0) 0)
		  (= (bits (tau a b c n) k 0) 0)))
  :rule-classes ())


;;;**********************************************************************
;;;                  LEADING ONE PREDICTION
;;;**********************************************************************

(defthm lop-thm-1
    (implies (and (integerp a)
		  (> a 0)
		  (integerp b)
		  (> b 0)
		  (= e (expo a))
		  (< (expo b) e)
		  (= lambda
		     (logior (* 2 (mod a (expt 2 e)))
			     (comp1 (* 2 b) (1+ e)))))
	     (or (= (expo (- a b)) (expo lambda))
		 (= (expo (- a b)) (1- (expo lambda)))))
  :rule-classes ())

(defun lamt (a b e)
  (logxor a (comp1 b (1+ e))))

(defun lamg (a b e)
  (logand a (comp1 b (1+ e))))

(defun lamz (a b e)
  (comp1 (logior a (comp1 b (1+ e))) (1+ e)))

(defun lam1 (a b e)
  (logand (bits (lamt a b e) e 2) 
	  (logand (bits (lamg a b e) (1- e) 1)
		  (comp1 (bits (lamz a b e) (- e 2) 0) (1- e)))))

(defun lam2 (a b e)
  (logand (comp1 (bits (lamt a b e) e 2) (1- e))
	  (logand (bits (lamz a b e) (1- e) 1)
		  (comp1 (bits (lamz a b e) (- e 2) 0) (1- e)))))

(defun lam3 (a b e)
  (logand (bits (lamt a b e) e 2) 
	  (logand (bits (lamz a b e) (1- e) 1)
		  (comp1 (bits (lamg a b e) (- e 2) 0) (1- e)))))

(defun lam4 (a b e)
  (logand (comp1 (bits (lamt a b e) e 2) (1- e))
	  (logand (bits (lamg a b e) (1- e) 1)
		  (comp1 (bits (lamg a b e) (- e 2) 0) (1- e)))))

(defun lam0 (a b e)
  (logior (lam1 a b e)
	  (logior (lam2 a b e)
		  (logior (lam3 a b e)
			  (lam4 a b e)))))

(defun lamb (a b e)
  (+ (* 2 (lam0 a b e))
     (comp1 (bitn (lamt a b e) 0) 1)))

(defthm lop-thm-2
    (implies (and (integerp a)
		  (> a 0)
		  (integerp b)
		  (> b 0)
		  (not (= a b))
		  (= e (expo a))
		  (= e (expo b))
		  (> e 1))
	     (and (not (= (lamb a b e) 0))
		  (or (= (expo (- a b)) (expo (lamb a b e)))
		      (= (expo (- a b)) (1- (expo (lamb a b e)))))))
  :rule-classes ())
