<?php
/*******************************************************************************
** Basic Analysis and Security Engine (BASE)
** Copyright (C) 2004 BASE Project Team
** Copyright (C) 2000 Carnegie Mellon University
**
** (see the file 'base_main.php' for license details)
**
** Project Leads: Kevin Johnson <kjohnson@secureideas.net>, Joel Esler <joelesler@users.sourceforge.net>
** Built upon work by Roman Danyliw <rdd@cert.org>, <roman@danyliw.com>
**
** Purpose: This file is the third step in the setup program
********************************************************************************
** Authors:
********************************************************************************
** Kevin Johnson <kjohnson@secureideas.net
**
********************************************************************************
*/
session_start();

include("../includes/base_setup.inc.php");

if (file_exists('../base_conf.php'))
	die ("If you wish to re-run the setup routine, please either move OR delete your previous base_conf file first.");

$errorMsg = '';

if (@$_GET['action'] == "check")
{
   // form was submitted do the checks!
   if ($_POST['useuserauth'] == "on" && ($_POST['usrlogin'] == "" || $_POST['usrpasswd'] == "" || $_POST['usrname'] == ""))
   {
      $errorMsg = "You must fill in all of the fields or uncheck \"Use Authentication System\"!";
      $error = 1;
   } else {
      $_SESSION['useuserauth'] = ($_POST['useuserauth'] == "on") ? 1 : 0;
      $_SESSION['usrlogin'] = $_POST['usrlogin'];
      $_SESSION['usrpasswd'] = $_POST['usrpasswd'];
      $_SESSION['usrname'] = $_POST['usrname'];
   }
   
   if ($error != 1)
   {
      header("Location: setup4.php");
   }

}

?>
<!doctype html public "-//w3c//dtd html 4.0 transitional//en">
<!-- Basic Analysis and Security Engine (BASE) -->
<HTML>

<HEAD>
  <META HTTP-EQUIV="pragma" CONTENT="no-cache">
  <TITLE>Basic Analysis and Security Engine (BASE)</TITLE>
  <LINK rel="stylesheet" type="text/css" HREF="../styles/base_style.css">
</HEAD>
<BODY>
<TABLE WIDTH="100%" BORDER=0 CELLSPACING=0 CELLPADDING=5>
    <TR>
      <TD class="mainheader"> &nbsp </TD>
      <TD class="mainheadertitle">
         Basic Analysis and Security Engine (BASE) Setup Program
      </TD>
    </TR>
</TABLE>
<br>
<P>
<?php echo("<div class='errorMsg' align='center'>".$errorMsg."</div>"); ?>
<form action=setup3.php?action=check method="POST">
<center><table width="50%" border=1 class ="query">
<tr><td colspan=2 align="center" class="setupTitle">Step 3 of 5</td><tr>
<tr><td colspan=2 align="center">&nbsp;</td></tr>
<tr><td colspan=2 align="center"><INPUT TYPE=CHECKBOX NAME="useuserauth">Use Authentication System [<a href="#" onClick="javascript:window.open('../help/base_setup_help.php#useauth','helpscreen','width=300,height=300');">?</a>]</td></tr>
<tr><td class="setupKey">Admin User Name:</td><td class="setupValue"><input type="text" name="usrlogin"></td></tr>
<tr><td class="setupKey">Password:</td><td class="setupValue"><input type="text" name="usrpasswd"></td></tr>
<tr><td class="setupKey">Full Name:</td><td class="setupValue"><input type="text" name="usrname"></td></tr>
<tr><td colspan=2 align="center"><input type="submit"></td></tr>
</table></form>
</BODY>
</HTML>
