<?php
/*******************************************************************************
** Basic Analysis and Security Engine (BASE)
** Copyright (C) 2004 BASE Project Team
** Copyright (C) 2000 Carnegie Mellon University
**
** (see the file 'base_main.php' for license details)
**
** Project Leads: Kevin Johnson <kjohnson@secureideas.net>, Joel Esler <joelesler@users.sourceforge.net>
** Built upon work by Roman Danyliw <rdd@cert.org>, <roman@danyliw.com>
**
** Purpose: This file is the second step in the setup program
********************************************************************************
** Authors:
********************************************************************************
** Kevin Johnson <kjohnson@secureideas.net
**
********************************************************************************
*/
session_start();

include("../includes/base_setup.inc.php");
include($_SESSION['adodbpath']."/adodb.inc.php");

if (file_exists('../base_conf.php'))
	die ("If you wish to re-run the setup routine, please either move OR delete your previous base_conf file first.");

$errorMsg = '';

if (@$_GET['action'] == "check")
{
   // form was submitted do the checks!
   $db = NewADOConnection($_POST['dbtype']);
   $dbconnect = $db->Connect( ( ( $_POST['dbport'] == "") ? $_POST['dbhost'] : ($_POST['dbhost'].":".$_POST['dbport']) ),
                               $_POST['dbusername'], $_POST['dbpasswd'], $_POST['dbname']);
   if ( !$dbconnect )
   {
      $errorMsg = $errorMsg . "Database connection failed!<br>Please try again!";
      $error = 1;
   } else {
      
         $_SESSION['dbtype'] = $_POST['dbtype'];
         $_SESSION['dbhost'] = $_POST['dbhost'];
         $_SESSION['dbport'] = $_POST['dbport'];
         $_SESSION['dbname'] = $_POST['dbname'];
         $_SESSION['dbusername'] = $_POST['dbusername'];
         $_SESSION['dbpasswd'] = $_POST['dbpasswd'];
   }

   if (@$_POST['usearchive'] == "on")
   {
      $dbconnect = $db->Connect( ( ( $_POST['arcdbport'] == "") ? $_POST['arcdbhost'] : ($_POST['arcdbhost'].":".$_POST['arcdbport']) ),
                                  $_POST['arcdbusername'], $_POST['arcdbpasswd'], $_POST['arcdbname']);
      if ( !$dbconnect )
      {
         $errorMsg = $errorMsg . "Archive Database connection failed!<br>Please try again!";
         $error = 1;
      } else {
      
         $_SESSION['arcdbexists'] = 1;
	 $_SESSION['arcdbhost'] = $_POST['arcdbhost'];
         $_SESSION['arcdbport'] = $_POST['arcdbport'];
         $_SESSION['arcdbname'] = $_POST['arcdbname'];
         $_SESSION['arcdbusername'] = $_POST['arcdbusername'];
         $_SESSION['arcdbpasswd'] = $_POST['arcdbpasswd'];
      }
   }
   if ($error != 1)
   {
      header("Location: setup3.php");
   } else {
      echo $errorMsg;
   }

}

?>
<!doctype html public "-//w3c//dtd html 4.0 transitional//en">
<!-- Basic Analysis and Security Engine (BASE) -->
<HTML>

<HEAD>
  <META HTTP-EQUIV="pragma" CONTENT="no-cache">
  <TITLE>Basic Analysis and Security Engine (BASE)</TITLE>
  <LINK rel="stylesheet" type="text/css" HREF="../styles/base_style.css">
</HEAD>
<BODY>
<TABLE WIDTH="100%" BORDER=0 CELLSPACING=0 CELLPADDING=5>
    <TR>
      <TD class="mainheader"> &nbsp </TD>
      <TD class="mainheadertitle">
         Basic Analysis and Security Engine (BASE) Setup Program
      </TD>
    </TR>
</TABLE>
<br>
<P>
<?php echo("<div class='errorMsg' align='center'>".$errorMsg."</div>"); ?>
<form action=setup2.php?action=check method="POST">
<center><table width="50%" border=1 class ="query">
<tr><td colspan=2 align="center" class="setupTitle">Step 2 of 5</td><tr>
<tr><td class="setupKey" width="50%">Pick a Database type:</td><td class="setupValue"><select name="dbtype">
<option value="mysql">MySQL
<option value="postgres">PostGRES
<option value="mssql">Microsoft SQL Server
<option value="oci8">Oracle
</select>[<a href="#" onClick="javascript:window.open('../help/base_setup_help.php#dbtype','helpscreen','width=300,height=300');">?</a>]</td</tr>
<tr><td colspan=2 align="center">&nbsp;</td></tr>
<tr><td class="setupKey">Database Name:</td><td class="setupValue"><input type="text" name="dbname"></td></tr>
<tr><td class="setupKey">Database Host:</td><td class="setupValue"><input type="text" name="dbhost"></td></tr>
<tr><td class="setupKey">Database Port:<br>Leave blank for default!</td><td class="setupValue"><input type="text" name="dbport"></td></tr>
<tr><td class="setupKey">Database User Name:</td><td class="setupValue"><input type="text" name="dbusername"></td></tr>
<tr><td class="setupKey">Database Password:</td><td class="setupValue"><input type="text" name="dbpasswd"></td></tr>
<tr><td colspan=2 align="center">&nbsp;</td></tr>
<tr><td colspan=2 align="center"><INPUT TYPE=CHECKBOX NAME="usearchive">Use Archive Database[<a href="#" onClick="javascript:window.open('../help/base_setup_help.php#usearchive','helpscreen','width=300,height=300');">?</a>]</td></tr>
<tr><td class="setupKey">Archive Database Name:</td><td class="setupValue"><input type="text" name="arcdbname"></td></tr>
<tr><td class="setupKey">Archive Database Host:</td><td class="setupValue"><input type="text" name="arcdbhost"></td></tr>
<tr><td class="setupKey">Archive Database Port:<br>Leave blank for default!</td><td class="setupValue"><input type="text" name="arcdbport"></td></tr>
<tr><td class="setupKey">Archive Database User Name:</td><td class="setupValue"><input type="text" name="arcdbusername"></td></tr>
<tr><td class="setupKey">Archive Database Password:</td><td class="setupValue"><input type="text" name="arcdbpasswd"></td></tr>
<tr><td colspan=2 align="center"><input type="submit"></td></tr>
</table></form>
</BODY>
</HTML>
