<?php
/*******************************************************************************
** Basic Analysis and Security Engine (BASE)
** Copyright (C) 2004 BASE Project Team
** Copyright (C) 2000 Carnegie Mellon University
**
** (see the file 'base_main.php' for license details)
**
** Project Lead: Kevin Johnson <kjohnson@secureideas.net>
** Built upon work by Roman Danyliw <rdd@cert.org>, <roman@danyliw.com>
**
** Purpose: debugging and logging routines   
********************************************************************************
** Authors:
********************************************************************************
** Kevin Johnson <kjohnson@secureideas.net
**
********************************************************************************
*/
/** The below check is to make sure that the conf file has been loaded before this one....
 **  This should prevent someone from accessing the page directly. -- Kevin
 **/
defined( '_BASE_INC' ) or die( 'Accessing this file directly is not allowed.' );

function ErrorMessage ($message, $color = "#FF0000")
{
   echo '<FONT COLOR="'.$color.'">'.$message.'</FONT><br>';

}

function returnErrorMessage ($message)
{
   $error = '<FONT COLOR="#FF0000">'.$message.'</FONT><br>';   
   return $error;
}

function FatalError ($message)
{
   echo '<FONT COLOR="#FF0000"><B>'._ERRBASEFATAL.'</B> '.$message.'</FONT>';
   die();  
}

function PrintServerInformation()
{
   echo '';
}

function PrintPageHeader()
{
     GLOBAL $DBtype, $ADODB_vers;

   $tmp = session_encode();   

   if ( isset($_SERVER['HTTP_REFERER']) )
      $http_referer = $_SERVER['HTTP_REFERER'];
   else
      $http_referer = "";
  
   if ( isset($_SERVER['HTTP_USER_AGENT']) )
      $http_user_agent = $_SERVER['HTTP_USER_AGENT'];
   else
      $http_user_agent = "";

   if ( isset($_SERVER['SERVER_SOFTWARE']) )
      $server_software = $_SERVER['SERVER_SOFTWARE'];
   else
      $server_software = "";

   echo "<PRE>
         <B>URL:</B> '".$_SERVER["PHP_SELF"]."' (<B>referred by:</B> '".$http_referer."')
         <B>PARAMETERS:</B> '".$_SERVER["QUERY_STRING"]."
         <B>CLIENT:</B> ".$http_user_agent."
         <B>SERVER:</B> ".$server_software."
         <B>SERVER HW:</B> ".php_uname()."
         <B>DATABASE TYPE:</B> $DBtype  <B>DB ABSTRACTION VERSION:</B> $ADODB_vers
         <B>PHP VERSION:</B> ".phpversion()."  <B>PHP API:</B> ".php_sapi_name()."
         <B>BASE VERSION:</B> ".$GLOBALS['BASE_VERSION']."
         <B>SESSION ID:</B> ".session_id()."( ".strlen($tmp)." bytes )
         </PRE>"; 
}

function PrintHTTPPost()
{
   echo "<BR><B>HTTP POST Variables</B><PRE>";
   print_r($_POST);
   echo "</PRE>";
}

?>
