//This file is part of AcetoneISO. Copyright 2006,2007,2008,2009 Marco Di Antonio and Fabrizio Di Marco (acetoneiso@gmail.com)
//
//    AcetoneISO is free software: you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation, either version 3 of the License, or
//    (at your option) any later version.
//
//    AcetoneISO is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with AcetoneISO.  If not, see <http://www.gnu.org/licenses/>.
void acetoneiso::vidgeneric() {

QDir bin("/usr/bin");
QFile rar;
QDir::setCurrent( bin.path() );
rar.setFileName("mencoder");
if (!rar.exists()) {  
 QMessageBox::critical(this, "AcetoneISO",tr("Unable to find") + " mencoder " + tr("in /usr/bin.\nPlease install it and be sure it's linked to /usr/bin folder.") );
return;
}  

QDir Home = QDir::home();
QString open;
open = QFileDialog::getOpenFileName(this,tr("Select Video"), Home.path() , tr("Video Files (*.avi *.mpg *.mpeg *.mov *.wmv *.flv *.asf *.rm )"));
if ( !open.isNull() ) {
   QString fileName = QFileDialog::getSaveFileName(this, tr("AcetoneISO::Save Video file"),
						          Home.path() + "/AcetoneISO_Video",
								       tr("Video (*.avi)"));
   if ( !fileName.isNull() ) {
      bool ok;
      int i = QInputDialog::getInteger(this, tr("AcetoneISO::Fixed Quant"),tr("Please insert the Fixed Quant number.\nLowering the number will result in a higher quality video."), 7, 2, 13, 1, &ok);
      if (!ok) {
         return;
        }
      else {
         QString quant;
         quant = QString::number(i).prepend("fixed_quant=" );
         QString file;
         file = fileName.append(".avi" );
	 
	 showProgressDisplay();   
	 VIdgen = new QProcess();
	 VIdgen->setReadChannel(QProcess::StandardOutput);
	 VIdgen->setProcessChannelMode(QProcess::MergedChannels);	
 	//connection to update the display
 	connect(VIdgen, SIGNAL(readyReadStandardOutput()), SLOT(updateProgressDisplay_vidgen() )); 
	connect( VIdgen, SIGNAL(finished(int, QProcess::ExitStatus)), this, SLOT(printOutvidgen(int, QProcess::ExitStatus)));	 
         VIdgen->start("mencoder",QStringList()  << open << "-ovc" << "xvid" << "-oac" << "mp3lame" << "-xvidencopts" << quant << "-o" << file  );
         
        }
       }
  }
}
//konsole --noclose -e mencoder "$OPENFILE" -ovc xvid -oac mp3lame -xvidencopts fixed_quant=7 -o "$OUT"
void acetoneiso::flvavi() {
  
QDir bin("/usr/bin");
QFile rar;
QDir::setCurrent( bin.path() );
rar.setFileName("mencoder");
if (!rar.exists()) {  
 QMessageBox::critical(this, "AcetoneISO",tr("Unable to find") + " mencoder " + tr("in /usr/bin.\nPlease install it and be sure it's linked to /usr/bin folder.") );
return;
}    
  
QDir Home = QDir::home();
QString open;
open = QFileDialog::getOpenFileName(this,tr("Select FLV Video"), Home.path() , tr("Video Files (*.flv )"));
if ( !open.isNull() ) {
   QString fileName = QFileDialog::getSaveFileName(this, tr("AcetoneISO::Save Video file"),
						      Home.path() + "/AcetoneISO_flv_2_avi",
							               tr("Video (*.avi)"));
   if ( !fileName.isNull() ) {
      QString file;
      file = fileName.append(".avi" );
      
      
      
	 showProgressDisplay();   
	 FLv = new QProcess();
	 FLv->setReadChannel(QProcess::StandardOutput);
	 FLv->setProcessChannelMode(QProcess::MergedChannels);	
 	//connection to update the display
 	connect(FLv, SIGNAL(readyReadStandardOutput()), SLOT(updateProgressDisplay_flv() )); 
	connect(FLv, SIGNAL(finished(int, QProcess::ExitStatus)), this, SLOT(printOutflv(int, QProcess::ExitStatus)));	      
      FLv->start("mencoder",QStringList()  << "-ovc" << "lavc" << "-lavcopts" << "vcodec=mpeg4:vbitrate=1000:mbd=2:v4mv:autoaspect" << "-vf" << "pp=lb" << "-oac" << "mp3lame" << "-lameopts" << "cbr:preset=128" << open << "-o" << file  );

     }
   }
}
//  mencoder -ovc lavc -lavcopts vcodec=mpeg4:vbitrate=1000:mbd=2:v4mv:autoaspect -vf pp=lb -oac mp3lame -lameopts cbr:preset=128 /home/bullet/Desktop/a.flv -o "/home/bullet/Desktop/testing.avi"


void acetoneiso::rip() {
  
QDir bins("/usr/bin");
QFile rar;
QDir::setCurrent( bins.path() );
rar.setFileName("mencoder");
if (!rar.exists()) {  
 QMessageBox::critical(this, "AcetoneISO",tr("Unable to find") + " mencoder " + tr("in /usr/bin.\nPlease install it and be sure it's linked to /usr/bin folder.") );
return;
}    
  
QMessageBox::information(this, "AcetoneISO",tr("Please be sure the DVD disc is inserted in device and then press OK."));

QMessageBox msgBox;
msgBox.setText(tr("Choose if you want the audio to be in mp3 format or if\nit should be the same of the dvd (for example dolby 5.1)"));
QPushButton *connectButton = msgBox.addButton(tr("Mp3"), QMessageBox::ActionRole);
QPushButton *connectButton2 = msgBox.addButton(tr("Original Audio"), QMessageBox::ActionRole);
//msgBox.setStandardButtons(QMessageBox::("ISO File") | QMessageBox::("CD/DVD"));
msgBox.exec();
 if (msgBox.clickedButton() == connectButton) {
   ripdvd_audiotype = "mp3lame";
 }
 if (msgBox.clickedButton() == connectButton2) {
    ripdvd_audiotype = "copy";
 }

QDir bin("/usr/bin");
QDir::setCurrent( bin.path() );

 showProgressDisplay();   
	 RIp = new QProcess();
	 RIp->setReadChannel(QProcess::StandardOutput);
	 RIp->setProcessChannelMode(QProcess::MergedChannels);	
 	//connection to update the display
 	connect(RIp, SIGNAL(readyReadStandardOutput()), SLOT(updateProgressDisplay_RIp() )); 
	connect(RIp, SIGNAL(finished(int, QProcess::ExitStatus)), this, SLOT(printOutrip(int, QProcess::ExitStatus)));	 

RIp->start("mencoder",QStringList() <<  "dvd://" << "-oac" << ripdvd_audiotype << "-ovc" << "xvid" << "-xvidencopts" << "pass=1" << "-o" << "/dev/null" );

}

void acetoneiso::printOutrip(int, QProcess::ExitStatus)
{
	QMainWindow::showNormal();
	restore_all_button_processes(); //riabilita tutti i bottoni disattivati
	pushButton_6->setEnabled(true);
int valore_uscita = RIp->exitCode();
if(valore_uscita == 0) {
   QMessageBox::information(this, "AcetoneISO",tr("Encoding Pass 1 has succesfully finished.\nPass 2 will be done now. Please choose the bitrate in the next dialog and then choose where to save the video."));
   bool ok;
   int i = QInputDialog::getInteger(this, tr("AcetoneISO::Bitrate"),tr("Please insert Bitrate. Higher bitrate means more quality but will generate a bigger file."), 896, 384, 4096, 128, &ok);
   if (!ok) {
      return;
     }
       QString file;
       file = QString::number(i).prepend("pass=2:bitrate=" );
       QDir Home = QDir::home();
       QString fileName = QFileDialog::getSaveFileName(this, tr("AcetoneISO::Save Video file"),
						      Home.path() + "/AcetoneISO_Rip_DVD_Video",
							                   tr("Video (*.avi)"));
       if ( fileName.isNull() ) {
	return; 
       }

 showProgressDisplay();   
	 RIp2 = new QProcess();
	 RIp2->setReadChannel(QProcess::StandardOutput);
	 RIp2->setProcessChannelMode(QProcess::MergedChannels);	
 	//connection to update the display
 	connect(RIp2, SIGNAL(readyReadStandardOutput()), SLOT(updateProgressDisplay_RIp2() )); 
	connect(RIp2, SIGNAL(finished(int, QProcess::ExitStatus)), this, SLOT(printOutrip2(int, QProcess::ExitStatus)));	

    RIp2->start("mencoder",QStringList()  << "dvd://" << "-oac" << ripdvd_audiotype << "-ovc" << "xvid" << "-xvidencopts" << file << "-o" << fileName  );
        
         
        
  }
else {
   QMessageBox::critical(this, "AcetoneISO","Process Error Code: " + QString::number(valore_uscita) );
}
}

void acetoneiso::printOutrip2(int, QProcess::ExitStatus)
{
  	QMainWindow::showNormal();
	restore_all_button_processes(); //riabilita tutti i bottoni disattivati
	pushButton_6->setEnabled(true);
int valore_uscita = RIp2->exitCode();
if(valore_uscita == 0)
   QMessageBox::information(this, "AcetoneISO",tr("Process Succesfully Finished!"));
else
   QMessageBox::critical(this, "AcetoneISO","Process Error Code: " + QString::number(valore_uscita) );
}
/*


konsole -e mencoder dvd:// -oac mp3lame -ovc xvid -xvidencopts pass=1 -o /dev/null

konsole --noclose -e mencoder dvd:// -oac mp3lame -ovc xvid -xvidencopts pass=2:bitrate=800 -o "$OUT"

*/



