// -*- C++ -*-
//=============================================================================
/**
 *  @file   Safe_InputCDR.h
 *
 *  Safe_InputCDR.h,v 1.4 2004/04/22 08:31:35 jwillemsen Exp
 *
 *  @author Huang-Ming Huang <hh1@cse.wustl.edu>
 */
//=============================================================================
#ifndef SAFE_INPUTCDR_H
#define SAFE_INPUTCDR_H
#include /**/ "ace/pre.h"

#include "ftrtevent_export.h"
#include "tao/CDR.h"

class TAO_FtRtEvent_Export Safe_InputCDR : public TAO_InputCDR
{
public:
  /**
   * Create an input stream from an arbitrary buffer.
   *
   * This contructor will work no matter the buffer is aligned properly
   * or not. If the buffer is not properly aligned, it will make a copy
   * of the buffer.
   */
  Safe_InputCDR(const char* buf, int size);
};

#if defined(__ACE_INLINE__)
#include "Safe_InputCDR.inl"
#endif /* __ACE_INLINE__ */

#include /**/ "ace/post.h"
#endif
