!{\src2tex{textfont=tt}}
!!****f* ABINIT/pawpuinit
!! NAME
!! pawpuinit
!!
!! FUNCTION
!! Initialize some starting values of several arrays used in
!! PAW+U calculations
!!
!!
!! A-define useful indices for LDA+U
!! B-Compute overlap between atomic wavefunction
!! C-Compute matrix elements of coulomb interaction (see PRB vol.52 5467)
!!    (angular part computed from Gaunt coefficients)
!!
!! COPYRIGHT
!! Copyright (C) 1998-2007 ABINIT group (BA, FJ)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~ABINIT/Infos/copyright
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~ABINIT/Infos/contributors.
!!
!! INPUTS
!!  jpawu(ntypat)= value of J
!!  llpawu(ntypat)= value of l on which LDA+U applies
!!  indlmn(6,i,ntypat)=array giving l,m,n,lm,ln,spin for i=lmn (for a given atom type)
!!  lmnmax=max. number of (l,m,n) components over all type of psps
!!  ntypat=number of types of atoms in unit cell.
!!  pawang <type(pawang_type)>=paw angular mesh and related data
!!     %lmax=Maximum value of angular momentum l+1
!!     %gntselect((2*l_max-1)**2,l_max**2,l_max**2)=
!!                     selection rules for Gaunt coefficients
!!  pawrad(ntypat) <type(pawrad_type)>=paw radial mesh and related data
!!  pawtab(ntypat) <type(pawtab_type)>=paw tabulated starting data:
!!  upawu(ntypat)= value of U
!!  usepawu= 0 if no LDA+U; 1 if LDA+U   
!!
!! OUTPUT
!!  pawtab <type(pawtab_type)>=paw tabulated data read at start:
!!     %ij_proj=nproj*(nproju+1)/2
!!     %jpawu= value of J
!!     %klmntomn(4,lmn2_size) = Array giving im, jm ,in, and jn for each klmn=(ilmn,jlmn)
!!     %lnproju(nproj)= value of ln for projectors on which paw+u acts.
!!     %nproju=number of projectors for orbitals on which paw+u acts.
!!     %phiphjint(pawtabitypat%ij_proj)=Integral of Phi(:,i)*Phi(:,j) for correlated orbitals.
!!     %upawu= value of U
!!     %usepawu=0 if no LDA+U; 1 if LDA+U 
!!     %vee(2*lpawu+1,:,:,:)=matrix of the screened interaction for correlated orbitals
!!
!! PARENTS
!!      gstate
!!
!! CHILDREN
!!      leave_new,simp_gen,wrtout
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

 subroutine pawpuinit(jpawu,llpawu,indlmn,lmnmax,ntypat,pawang,pawrad,pawtab,upawu,usepawu)

 use defs_basis
 use defs_datatypes

!This section has been created automatically by the script Abilint (TD). Do not modify these by hand.
#ifdef HAVE_FORTRAN_INTERFACES
 use interfaces_01manage_mpi
 use interfaces_11util
#endif
!End of the abilint section

 implicit none

!Arguments ---------------------------------------------
! pawang, pawrad and pawtab are defined for a given itypat in this
! routine
!scalars
 integer,intent(in) :: lmnmax,ntypat,usepawu
 type(pawang_type),intent(in) :: pawang
!arrays
 integer,intent(in) :: indlmn(6,lmnmax,ntypat),llpawu(ntypat)
 real(dp),intent(in) :: jpawu(ntypat),upawu(ntypat)
 type(pawrad_type),intent(in) :: pawrad(ntypat)
 type(pawtab_type),intent(inout) :: pawtab(ntypat)

!Local variables ---------------------------------------
!scalars
 integer :: icount,il,ilmn,isela,iselb,itemp,itypat,iu,j0lmn,jl,jlmn,ju,klm0u
 integer :: klma,klmb,klmn,kyc,lkyc,lmkyc,lmn_size,lmpawu,lpawu,m1,m11,m2,m21
 integer :: m3,m31,m4,m41,mesh_size,mkyc,mpawpu
 real(dp) :: ak,f4of2,f6of2,int1,int2
 character(len=500) :: message
!arrays
 integer :: indlmn_(6,lmnmax)
 real(dp),allocatable :: ff(:),fk(:)

! *************************************************************************

 write(message, '(a)' ) " "
 call wrtout(ab_out,message,'COLL')
 call wrtout(06,  message,'COLL')
 write(message, '(a)' ) " "
 call wrtout(ab_out,message,'COLL')
 call wrtout(06,  message,'COLL')
 write(message, '(a)' ) "******************************************"
 call wrtout(ab_out,message,'COLL')
 call wrtout(06,  message,'COLL')
 if(usepawu==1) then
  write(message, '(a)' ) " LDA+U Method used: FLL"
 else if(usepawu==2) then
  write(message, '(a)' ) " LDA+U Method used: AMF"
 end if
 call wrtout(ab_out,message,'COLL')
 call wrtout(06,  message,'COLL')
 write(message, '(a)' ) "******************************************"
 call wrtout(ab_out,message,'COLL')
 call wrtout(06,  message,'COLL')

 do itypat=1,ntypat
  indlmn_(:,:)=indlmn(:,:,itypat)
  lmn_size=pawtab(itypat)%lmn_size
  pawtab(itypat)%lpawu=llpawu(itypat)
  lpawu=llpawu(itypat)
  if(pawtab(itypat)%lpawu==-1) pawtab(itypat)%usepawu=0
  if(pawtab(itypat)%lpawu/=-1) pawtab(itypat)%usepawu=usepawu
  if(lpawu/=-1) then
   pawtab(itypat)%upawu=upawu(itypat)
   pawtab(itypat)%jpawu=jpawu(itypat)
! compute number of projectors for LDA+U
!   if (associated(pawtab(itypat)%vee)) deallocate(pawtab(itypat)%vee)
!   allocate(pawtab(itypat)%vee(2*lpawu+1,2*lpawu+1,2*lpawu+1,2*lpawu+1))
   icount=0
   do ilmn=1,lmn_size
    if(indlmn(1,ilmn,itypat)==lpawu) then
     icount=icount+1
    end if
   end do
   pawtab(itypat)%nproju=icount/(2*lpawu+1)
   if(pawtab(itypat)%nproju*(2*lpawu+1)/=icount)  then
     write(message, '(a,a,a,a,a,a)' ) ch10,&
&      ' pawinit : ERROR -',ch10,&
&      '  PAW+U: Error on the number of projectors ',ch10,&
&      '  Action : contact the abinit group.'
      call wrtout(ab_out,message,'COLL');call wrtout(06,  message,'COLL')
      call leave_new('COLL')
   end if  
   write(6,*)"pawpuinit: for species, nproju=",pawtab(itypat)%nproju,itypat
!   if (associated(pawtab(itypat)%lnproju)) deallocate(pawtab(itypat)%lnproju)
   allocate(pawtab(itypat)%lnproju(pawtab(itypat)%nproju))
   pawtab(itypat)%ij_proj=pawtab(itypat)%nproju*(pawtab(itypat)%nproju+1)/2
!   if (associated(pawtab(itypat)%phiphjint)) deallocate(pawtab(itypat)%phiphjint)
   allocate(pawtab(itypat)%phiphjint(pawtab(itypat)%ij_proj))

!==================================================
!  A-define useful indexes for LDA+U
! -------------------------------------
   icount=0
   do ilmn=1,lmn_size
    if(indlmn_(1,ilmn)==lpawu) then
     icount=icount+1
     itemp=(icount-1)/(2*lpawu+1)
     if (itemp*(2*lpawu+1)==icount-1) then
      pawtab(itypat)%lnproju(itemp+1)=indlmn_(5,ilmn)
     end if
    end if
   end do
 
   do jlmn=1,lmn_size
    jl= indlmn_(1,jlmn)
    j0lmn=jlmn*(jlmn-1)/2
    do ilmn=1,jlmn
     il= indlmn_(1,ilmn)
     klmn=j0lmn+ilmn
      pawtab(itypat)%klmntomn(1,klmn)=indlmn_(2,ilmn)+il+1
      pawtab(itypat)%klmntomn(2,klmn)=indlmn_(2,jlmn)+jl+1
      pawtab(itypat)%klmntomn(3,klmn)=indlmn_(3,ilmn)
       pawtab(itypat)%klmntomn(4,klmn)=indlmn_(3,jlmn)
    end do
   end do

!   B-overlap between atomic wavefunction
!   -------------------------------------
!   radial mesh only in the sphere 
   mesh_size=pawrad(itypat)%mesh_size
   allocate(ff(mesh_size))
   icount=0
   do ju=1,pawtab(itypat)%nproju
    do iu=1,ju
    icount=icount+1
     ff(1:mesh_size)=pawtab(itypat)%phi (1:mesh_size,pawtab(itypat)%lnproju(1))&
&                          *pawtab(itypat)%phi (1:mesh_size,pawtab(itypat)%lnproju(iu))
     call simp_gen(int1,ff,pawrad(itypat))
     ff(1:mesh_size)=pawtab(itypat)%phi (1:mesh_size,pawtab(itypat)%lnproju(1))&
&                          *pawtab(itypat)%phi (1:mesh_size,pawtab(itypat)%lnproju(ju))
     call simp_gen(int2,ff,pawrad(itypat))
     pawtab(itypat)%phiphjint(icount)=int1*int2
    end do
   end do
   if(pawtab(itypat)%ij_proj/=icount)  then
    write(message, '(a,a,a,a,a,a)' ) ch10,&
&     ' pawinit : ERROR -',ch10,&
&     '  PAW+U: Error in the loop for calculating phiphjint ',ch10,&
&     '  Action : contact the abinit group.'
    call wrtout(ab_out,message,'COLL');call wrtout(06,  message,'COLL')
    call leave_new('COLL')
   end if
   deallocate(ff)
 
!  C-Matrix elements of coulomb interaction (see PRB vol.52 5467)
!  --------------------------------------------------------------
!     1. angular part computed from Gaunt coefficients
!     ------------------------------------------------
!       a. compute F(k)
!       ---------------------------------------------
   allocate(fk(lpawu+1))
   fk(1)=pawtab(itypat)%upawu
   if(lpawu==2) then
    f4of2=0.625_dp
    fk(2)=pawtab(itypat)%jpawu*14._dp/(One+f4of2)
    fk(3)=fk(2)*f4of2
   else if(lpawu==3) then
    f4of2=0.6681_dp
    f6of2=0.4943_dp
    fk(2)=pawtab(itypat)%jpawu*6435._dp/(286._dp+195._dp*f4of2+250._dp*f6of2)
    fk(3)=fk(2)*f4of2
    fk(4)=fk(2)*f6of2
   else 
    write(message, '(a,a,i3,a,a)' ) ch10,&
&   ' pawpuinit :  STOP - lpawu=',lpawu,ch10,&
&   ' lpawu not equal to 2 or 3  is not allowed'
    call wrtout(6,message,'COLL')
    call leave_new('COLL')
   end if
!        b. Compute ak and vee.
!        ---------------------------------------------
   pawtab(itypat)%vee=zero
   lmpawu=(lpawu-1)**2+2*(lpawu-1)+1  ! number of m value below correlated orbitals
   klm0u=lmpawu*(lmpawu+1)/2          ! value of klmn just below correlated orbitals
!--------- 4 loops for interaction matrix
   do m1=-lpawu,lpawu
    m11=m1+lpawu+1
    do m2=-lpawu,m1
     m21=m2+lpawu+1
!   klma= number of pair before correlated orbitals +
!   number of pair for m1 lower than correlated orbitals
!   (m1+lpawu+1)*(lpawu-1) + number of pairs for correlated orbitals
!   before (m1,m2) + number of pair for m2 lower than current value
     klma=klm0u+m11*lmpawu+(m11-1)*m11/2+m21
     do m3=-lpawu,lpawu
      m31=m3+lpawu+1
      do m4=-lpawu,m3
       m41=m4+lpawu+1
       klmb=klm0u+m31*lmpawu+(m31-1)*m31/2+m41
!--------- loop on k=1,2,3 (4 if f orbitals)
       do kyc=1,2*lpawu+1,2
        lkyc=kyc-1
        lmkyc=(lkyc+1)*(lkyc)+1
        ak=zero
        do mkyc=-lkyc,lkyc,1
         isela=pawang%gntselect(lmkyc+mkyc,klma)
         iselb=pawang%gntselect(lmkyc+mkyc,klmb)
         if (isela>0.and.iselb>0) ak=ak +pawang%realgnt(isela)*pawang%realgnt(iselb)
        end do
!----- end loop on k=1,2,3 (4 if f orbitals)
        ak=ak/(two*dfloat(lkyc)+one)
        pawtab(itypat)%vee(m11,m31,m21,m41)=ak*fk(lkyc/2+1)+pawtab(itypat)%vee(m11,m31,m21,m41)
       end do  !kyc
        pawtab(itypat)%vee(m11,m31,m21,m41)=pawtab(itypat)%vee(m11,m31,m21,m41)*four_pi
        pawtab(itypat)%vee(m21,m31,m11,m41)=pawtab(itypat)%vee(m11,m31,m21,m41)
        pawtab(itypat)%vee(m11,m41,m21,m31)=pawtab(itypat)%vee(m11,m31,m21,m41)
        pawtab(itypat)%vee(m21,m41,m11,m31)=pawtab(itypat)%vee(m11,m31,m21,m41)
!        write(6,*) m1,m2,m3,m4,pawtab(itypat)%vee(m11,m31,m21,m41)
      end do
     end do
    end do
   end do
   deallocate(fk)
!---- end  4 loops for interaction matrix
  end if
 end do !end loop on typat
 end subroutine pawpuinit
!!***
