import SCons.Defaults
import SCons.Tool
import SCons.Util
cplusplus=__import__('c++', globals(), locals(), [])
def smart_link(source, target, env, for_signature):
    if cplusplus.iscplusplus(source):
        return '$CXX'
    return '$CC'
def generate(env):
    SCons.Tool.createSharedLibBuilder(env)
    SCons.Tool.createProgBuilder(env)
    env['SHLINK']     ='$LINK'
    env['SHLINKFLAGS']=SCons.Util.CLVar('$LINKFLAGS -shared')
    env['SHLINKCOM']  ='$SHLINK $SHLINKFLAGS -o $TARGET $SOURCES $_LIBDIRFLAGS $_LIBFLAGS'
    env['SMARTLINK']  =smart_link
    env['LINK']       ="$SMARTLINK"
    env['LINKFLAGS']  =SCons.Util.CLVar('')
    env['LINKCOM']    ='$LINK $LINKFLAGS -o $TARGET $SOURCES $_LIBDIRFLAGS $_LIBFLAGS'
    env['LIBDIRPREFIX']='-L'
    env['LIBDIRSUFFIX']=''
    env['_LIBFLAGS']='${_stripixes(LIBLINKPREFIX, LIBS, LIBLINKSUFFIX, LIBPREFIX, LIBSUFFIX, __env__)}'
    env['LIBLINKPREFIX']='-l'
    env['LIBLINKSUFFIX']=''
def exists(env):
    return None
