build-indep:

common_pkg = $(stub)-common
common_dir = $(CURDIR)/debian/$(common_pkg)
firm_dir = $(common_dir)/lib/firmware

install-firmware:
	dh_testdir
	dh_testroot
	dh_clean -k -p$(common_pkg)

	install -d $(firm_dir)

	cp -a ubuntu-firmware/zd1211 $(firm_dir)/
	cp -a ubuntu-firmware/acx $(firm_dir)/
	for i in ubuntu-firmware/*/[[:lower:]]*; do \
	  case $${i##*/} in \
	    zd121*) ;; \
	    *) test -f "$$i" && cp $$i "$(firm_dir)/${i##*/}";; \
	  esac; \
	done


install-indep: install-firmware

binary-indep: install-indep
	dh_testdir
	dh_testroot

	install -D -m 755 debian/lrm-manager debian/linux-restricted-modules-common/sbin/lrm-manager
	install -D -m 644 debian/linux-restricted-modules-common.default \
		debian/linux-restricted-modules-common/etc/default/linux-restricted-modules-common
	# This is only installed as an empty file to correct upgrades
	install -D -m 644 debian/linux-restricted-modules-common.modprobe \
		debian/linux-restricted-modules-common/etc/modprobe.d/lrm-video

	dh_installchangelogs -i
	dh_installdocs -i
	dh_installinit -p linux-restricted-modules-common --no-start -- start 7 S . start 1 0 6 .
	dh_compress -i
	dh_fixperms -i
	dh_installdeb -i
	dh_gencontrol -i
	dh_md5sums -i
	dh_builddeb -i
