/*
 *  XNap
 *
 *  A pure java file sharing client.
 *
 *  See AUTHORS for copyright information.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package xnap.util;

import xnap.XNap;

/**
 * Represents a state of <code>FiniteStateMachine</code>.
 *
 * @see xnap.util.FiniteStateMachine
 */
public class State
{

    //--- Constant(s) ---

    /**
     * Operation has not started, yet.
     */
    public static final State NOT_STARTED = new State("");
    
    /**
     * Connect is in progress.
     */
    public static final State CONNECTING = new State(XNap.tr("connecting") 
						     + "...");
    
    /**
     * Object has been locally queued.
     */
    public static final State LOCALLY_QUEUED = new State(XNap.tr("locally queued"));

    /**
     * Download in progress.
     */
    public static final State DOWNLOADING = new State(XNap.tr("downloading")
						      + "...");
    
    /**
     * Upload in progress.
     */
    public static final State UPLOADING	= new State(XNap.tr("uploading")
						    + "...");

    /**
     * Operation was successful.
     */
    public static final State SUCCESS = new State(XNap.tr("success"));

    /**
     * Operation has failed.
     */
    public static final State FAILED = new State(XNap.tr("failed"));

    /**
     * Operation has been aborted.
     */
    public static final State ABORTED = new State(XNap.tr("aborted"));
    
    /**
     * An abort is in progress.
     */
    public static final State ABORTING = new State(XNap.tr("aborting")
						   + "...");

    /**
     * Search is in progress.
     */
    public static final State SEARCHING
	= new State(XNap.tr("searching") + "...");

    /**
     * Waiting for something.
     */
    public static final State WAITING = new State(XNap.tr("waiting") + "...");

    /**
     * Object was deleted.
     */
    public static final State DELETED = new State(XNap.tr("deleted"));

    /**
     * An unrecoverable error has occured.
     */
    public static final State ERROR = new State(XNap.tr("error"));

    //--- Data field(s) ---

    private String description;

    //--- Constructor(s) ---

    public State(String description)
    {
	setDescription(description);
    }

    public State()
    {
    }

    //--- Method(s) ---

    /**
     * Returns a short description for this state. Usually used to inform the
     * user.
     */
    public String getDescription()
    {
	return description;
    }

    /**
     * Sets a new description.
     */
    public void setDescription(String newValue)
    {
	description = newValue;
    }

    public String toString()
    {
	return description;
    }

}
