/*
 *  XNap
 *
 *  A pure java file sharing client.
 *
 *  See AUTHORS for copyright information.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package xnap.util;

/**
 * These methods should be moved to the SearchFilter class in the 2.3-pre1 
 * release (or whenever all old reposiotries are converted). 
 * And SearchFilter.Data needs to be moved SearchFilterData.
 */
public class SearchFilterHelper {

    //--- Constant(s) ---
    
    //--- Data field(s) ---

    //--- Constructor(s) ---

    //--- Method(s) ---

    /**
     * @return index of bitrate in array <code>SearchFilter.BITRATES</code>.
     */
    public static int getIndexFromBitrate(int bitrate) 
    {
	for (int i = 0; i < SearchFilter.BITRATES.length; i++) {
	    if (bitrate == SearchFilter.getBitrateFromIndex(i)) {
		return i;
	    }
	}
	return 0;
    }

    /**
     * Looks in mediatype arrays for a matching extension. If none is found
     * mediatype @see SearchFilter.MEDIA_ANYTHING is
     * returned. <code>ext</code> is compared ignoring the case.
     */
    public static int getMediatypeFromExtension(String ext)
    {
	for (int i = 0; i < SearchFilter.mediaTypes.length; i++) {
	    if (SearchFilterHelper.occursIn(SearchFilter.mediaTypes[i], ext)) {
		/* correct mediaTypes is shifted by one, see
                   SearchFilter.MEDIA_* */
		return i + 1;
	    }
	}
	return SearchFilter.MEDIA_ANYTHING;
    }

    /**
     * Compares extension to all elements in array and returns true if it
     * finds one match, otherwise false.
     * @param array array of possible file extensions.
     * @param ext the searchresult's file extension.
     *
     * The exact same method can also be found in @see SearchFilter, but had
     * to be copied here in order to be declared static whithout breaking the
     * whole serialization stuff.
     */
    public static boolean occursIn(String[] array, String ext)
    {
	for (int i = 0; i < array.length; i++) {
	    //Debug.log(array[i] + "?" + ext);
	    if (array[i].equalsIgnoreCase(ext)) {
		return true;
	    }
	}
	return false;
    }

    public static String toString(SearchFilter sf)
    {
	StringBuffer sb = new StringBuffer();
	sb.append("search for " + sf.getSearchText());
	if (sf.getBitrateCompare() != SearchFilter.COMPARE_NOT_ACTIVE){
	    sb.append(", bitrate " 
		      + SearchFilter.COMPARES[sf.getBitrateCompare()] + " " 
		      + sf.getBitrate());
	}
	if (sf.getFilesizeCompare() != SearchFilter.COMPARE_NOT_ACTIVE) {
	    sb.append(", filesize " 
		      + SearchFilter.COMPARES[sf.getFilesizeCompare()] + " " 
		      + sf.getFilesize());
	}
	if (sf.getMediaType() != SearchFilter.MEDIA_ANYTHING) {
	    sb.append(", media type " + SearchFilter.media[sf.getMediaType()]);
	}

	return sb.toString();
    }

    public static SearchFilter.Data convert(SearchFilterData d)
    {
	SearchFilter f = new SearchFilter(d.searchText, d.bitrateCompare,
					  d.bitrate, d.filesizeCompare,
					  d.filesize, d.mediaType);
	return f.getData();
    }

    public static SearchFilterData convert(SearchFilter.Data d)
    {
	SearchFilter f = new SearchFilter(d);
	return new SearchFilterData(f.getSearchText(), f.getBitrateCompare(),
				    f.getBitrate(), f.getFilesizeCompare(),
				    f.getFilesize(), f.getMediaType());
    }

}
