/*
 *  XNap
 *
 *  A pure java file sharing client.
 *
 *  See AUTHORS for copyright information.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package xnap.util;

import xnap.cmdl.*;
import xnap.net.*;
import xnap.net.event.ChannelEvent;
import xnap.net.event.ChannelListener;
import xnap.net.event.ChannelSupport;
import xnap.plugin.PluginManager;
import xnap.util.*;

import gnu.getopt.Getopt;
import java.io.IOException;
import java.util.*;

/**
 * Manages a list of channels.
 */
public class ChatManager
{

    //--- Constant(s) ---

    //--- Data field(s) ---

    private static ChatManager singleton = new ChatManager();
    private static Console console = Console.getInstance();
    private static Preferences prefs = Preferences.getInstance();

    protected ChannelSupport cs = new ChannelSupport(this);
    protected EventVector channels = new EventVector();
    protected EventVector chatServers = new EventVector();

    //--- Constructor(s) ---

    private ChatManager()
    {
    }

    //--- Method(s) ---

    public static synchronized ChatManager getInstance()
    {
	return singleton;
    }

    /**
     * FIX: Channels are never removed.
     */
    public void addChannel(IChannel c)
    {
	//if (!channels.contains(c)) {
	    channels.add(c);
	    Notifier.getInstance().channelAdded(c);
	    //}
    }

    public void addServer(IChatServer c)
    {
	if (!chatServers.contains(c)) {
	    chatServers.add(c);

	    // auto join channels
	    String[] channels = prefs.getAutoJoinChannelsArray();
	    for (int i = 0; i < channels.length; i++) {
		try {
		    IChannel channel = c.create(channels[i]);
		    channel.join();
		}
		catch (IOException e) {
		}
	    }
	}
    }

    public EventVector getChannels()
    {
	return channels;
    }

    /**
     * Adds a listener for the private channel.
     */
    public void addChannelListener(ChannelListener l)
    {
	cs.addChannelListener(l);
    }

    public EventVector getChatServers()
    {
	return chatServers;
    }  

    public void globalMessageReceived(String message)
    {
	cs.fireMessageReceived(message, ChannelEvent.MESSAGE_TYPE_INFO);
    }
    
    public void removeChannel(IChannel c)
    {
	c.close();
	channels.remove(c);
    }
    
    /**
     * Removes a listener from the private channel.
     */
    public void removeChannelListener(ChannelListener l)
    {
	cs.removeChannelListener(l);
    }

    public void removeServer(IChatServer c)
    {
	chatServers.remove(c);
    }

    public boolean isAutoJoinChannel(IChannel c)
    {
	String[] channels = prefs.getAutoJoinChannelsArray();
	return Arrays.asList(channels).contains(c.getName().toLowerCase());
    }

}


