/*
 *  Java Napster version x.yz (for current version number as well as for
 *  additional information see version.txt)
 *
 *  Previous versions of this program were written by Florian Student
 *  and Michael Ransburg available at www.weblicity.de/jnapster and
 *  http://www.tux.org/~daneel/content/projects/10.shtml respectively.
 *
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package xnap.plugin.nap.net;

import xnap.net.IBrowse;
import xnap.net.IChannel;
import xnap.net.IUser;
import xnap.plugin.nap.net.msg.MessageHandler;
import xnap.plugin.nap.net.msg.client.AddHotlistEntryMessage;
import xnap.plugin.nap.net.msg.client.RemoveHotlistEntryMessage;
import xnap.user.UserData2;
import xnap.util.EventVector;

public class GlobalUser extends AbstractNapUser {

    //--- Constant(s) ---

    //--- Data field(s) ---

    protected UserData2 data;
    private ServerVector servers = new ServerVector();
    private int queuedCount = 0;

    //--- Constructor(s) ---

    /**
     * @see xnap.plugin.nap.net.User
     * @see xnap.plugin.nap.util.NapPreferences
     */
    public GlobalUser(String name, boolean temporary)
    {
	super(temporary);

	data = new UserData2(GlobalUser.class.getName(), name);
    }

    /**
     * @see xnap.user.UserManager
     */
    public GlobalUser(UserData2 data)
    {
	super(false);

	this.data = data;
    }

    //--- Method(s) ---

    public IBrowse getBrowse()
    {
	return (servers.size() > 0) ? new xnap.plugin.nap.net.Browse(this) : null;
    }

    public UserData2 getData()
    {
	return data;
    }

    public synchronized int getQueuedCount()
    {
	return queuedCount;
    }

    public IChannel getPrivateChannel()
    {
	return null;
    }

    public ServerVector getServers()
    {
	return servers;
    }

    public synchronized void incQueuedCount(int newValue)
    {
	queuedCount = getQueuedCount() + newValue;
    }

    public void setTemporary(boolean newValue)
    {
	if (newValue != isTemporary()) {
	    if (newValue) {
		MessageHandler.send(new RemoveHotlistEntryMessage(getName()));
	    }
	    else {
		MessageHandler.send(new AddHotlistEntryMessage(getName()));
	    }
	}

	super.setTemporary(newValue);
    }

    public String toString() 
    {
	return getName();
    }


    public class ServerVector extends EventVector
    {
	
	public void add(Server server) 
	{
	    super.add(server);
	}
	
    }

}
