/*
 *  XNap
 *
 *  A pure java file sharing client.
 *
 *  See AUTHORS for copyright information.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

package xnap.plugin.nap.net;

import java.io.InputStream;
import java.io.IOException;
import java.net.Socket;

public class BrowseSocket extends IncomingSocket {

    //--- Data Field(s) ---
    
    public String nick;

    //--- Constructor(s) ---

    public BrowseSocket(Socket socket, InputStream in) throws IOException
    {
	super(socket, in);

	byte data[] = new byte[2048];
	in.mark(2048);
	int i = in.read(data);
	if (i > 0) {
	    nick = new String(data, 0, i);
	    int j = nick.indexOf("\n");
	    if (j == -1) {
		throw new IOException("empty nick");
	    }
	    nick = nick.substring(0, j).trim();
	    
	    in.reset();
	    in.skip(j + 1);

	    logger.info("direct browse response from: " + nick);
	}
	else {
	    throw new IOException("invalid request");
	}
    }

    public BrowseSocket(String nick)
    {
	this.nick = nick;
    }

    //--- Method(s) ---

    public boolean equals(Object obj)
    {
	if (obj != null) {
	    if (obj instanceof BrowseSocket) {
		BrowseSocket b = (BrowseSocket)obj;
		return nick.equals(b.nick);
	    }
	}

	return false;
    }
}


