/*
 *  Java Napster version x.yz (for current version number as well as for
 *  additional information see version.txt)
 *
 *  Previous versions of this program were written by Florian Student
 *  and Michael Ransburg available at www.weblicity.de/jnapster and
 *  http://www.tux.org/~daneel/content/projects/10.shtml respectively.
 *
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package xnap.plugin.gnutella.util;

import xnap.plugin.gnutella.net.*;
import xnap.util.Debug;

import java.io.*;
import java.util.*;

public class ServentFile {

    //--- Data Field(s) ---

    private BufferedReader in = null;
    private BufferedWriter out = null;
    private String filename;
    private String response = "";

    //--- Constructor(s) ---
	
    public ServentFile(String filename)
    {
	this.filename = filename;
    }

    //--- Method(s) ---
    
    public boolean openReader()
    {
	Debug.log("ServentFile: opening " + filename);

	try {
	    in = new BufferedReader(new FileReader(filename));
	}
	catch(FileNotFoundException fnf) {
	    response = "Could not find servent file " + filename;
	    return false;
	}
	catch(IOException io) {
	    response = "Could not read servent file " + filename;
	    return false;
	}

	return true;
    }


    public boolean openWriter()
    {
	try {
	    out = new BufferedWriter(new FileWriter(filename, false));
	} 
	catch(FileNotFoundException e) {
	    response = "Invalid directory " + filename;
	    Debug.log(response);
	    return false;
	} 
	catch(IOException e) {
	    response = "Could not write servent file " + filename;
	    Debug.log(response);
	    return false;
	}

	Debug.log("ServentFile: writing " + filename);
	
	return true;
    }

    public void close()
    {
	try {
	    if (in != null)
		in.close();

	    if (out != null)
		out.close();
	}	    
	catch (IOException e) {
	    Debug.log(e);
	}
    }

    public String getResponse()
    {
	return response;
    }

    public Servent readServent() {
	String line;
	try {
	    while ((line = in.readLine()) != null) {
		StringTokenizer t = new StringTokenizer(line, " :");

		if (t.countTokens() < 2)
		    continue;
		
		String ip = t.nextToken();
		int port;
		try {
		    port = Integer.parseInt(t.nextToken());
		} catch (NumberFormatException e) {
		    continue;
		}

		return new Servent(ip, port);
	    }
	} catch (IOException e) {
	    Debug.log(e);
	}

        return null;
    }

    public void writeServent(Servent s)
    {
	try {
	    out.write(s.toString());
	    out.newLine();
	}
	catch (IOException e) {
	    Debug.log(e);
	}
    }

}
