/*
 * 03/31/2001
 *
 * Message.java
 * Copyright (C) 2001 Frederik Zimmer
 * tristian@users.sourceforge.net
 * http://sourceforge.net/projects/ziga/
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package xnap.plugin.gnutella.net;

import java.io.IOException;
import xnap.plugin.gnutella.io.DataOutputStream;
import java.io.*;


public class Message 
{
    //--- Data Field(s) ---
    
    protected DescriptorHeader header;
    
    public Message(byte payloadDescriptor, int payloadLength) 
    {
	this(new GUID(), payloadDescriptor, payloadLength);
    }
    
    public Message(GUID messageID, byte payloadDescriptor, int payloadLength) 
    {
	header = new DescriptorHeader(messageID, payloadDescriptor, 
				      payloadLength);
    }
    
    public Message(DescriptorHeader header) 
    {
	this.header = header;
    }
    
    public void write(DataOutputStream out) 
	throws IOException 
    {
	header.write(out);
    }
    
    public GUID getMessageID()
    {
	return header.messageID;
    }
    
    public byte getPayloadDescriptor()
    {
	return header.payloadDescriptor;
    }
    
    public byte getTTL()
    {
	return header.ttl;
    }
    
    public void setTTL(byte ttl)
    {
	header.ttl = ttl;
    }
    
    public byte getHops()
    {
	return header.hops;
    }
    
    public void decrementTTL()
    {
	header.decrementTTL();
    }
    
    public int getPayloadLength()
    {
	return header.payloadLength;
    }
}
