/*
 * 08/30/2001
 *
 * LineWriter.java
 * Copyright (C) 2001 Frederik Zimmer
 * tristian@users.sourceforge.net
 * http://sourceforge.net/projects/ziga/
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package xnap.plugin.gnutella.net;

import java.io.*;

/**
 *
 * @version 0.1 09/18/2001
 * @author Frederik Zimmer
 */

public class LineWriter extends FilterOutputStream 
{
    public static final int LF_STYLE = 0;
    public static final int CR_STYLE = 1;
    public static final int CRLF_STYLE = 2;
    private int style;
	
    public LineWriter(OutputStream out) {
	super(out);
	style = CRLF_STYLE;
    }
	
    public LineWriter(OutputStream out, int style) {
	super(out);
	this.style = style;
	if (style < 0 || style > 2) {
	    throw new IllegalArgumentException();
	}
    }
	
    public void print(String line) throws IOException {
	write(line.getBytes());
    }
	
    public void println() throws IOException {
	switch (style) {
	case CRLF_STYLE:
	    write(13);
	    write(10);
	    break;
	case CR_STYLE:
	    write(13);
	    break;
	case LF_STYLE:
	    write(10);
	    break;
	}
    }
	
    public void println(String line) throws IOException {
	write(line.getBytes());
	println();
    }
}
