/*
 *  XNap
 *
 *  A pure java file sharing client.
 *
 *  See AUTHORS for copyright information.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package xnap.plugin.gnutella;

import xnap.gui.*;
import xnap.plugin.gnutella.gui.*;
import xnap.plugin.*;
import xnap.util.*;

import java.awt.event.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;

public class GUIPlugin extends Plugin implements IGUIPlugin
{
    
    //--- Data Field(s) ---
    
    private JMenu menu = null;
    private ConnectionsPanel cPanel;
    private StatusPanel statusPanel;
    
    //--- Constructor(s) ---

    //--- Method(s) ---

    public void start()
    {
	cPanel = new ConnectionsPanel();

	menu = new JMenu("Gnutella");
	JMenuItem jmi = new JMenuItem("Dummy Button");
	menu.add(jmi);

	statusPanel = new StatusPanel(this);

	super.start();
    }

    public void stop()
    {
	super.stop();
    }

    public void closeApp()
    {
    }

    public Icon getIcon()
    {
	return XNapFrame.getBigIcon("socket.png");
    }

    public JMenu getMenu()
    {
	return menu;
    }

    public JComponent getPanel()
    {
	return cPanel;
    }

    public AbstractPreferencesPanel getPrefsPanel()
    {
	return new PreferencesPanel();
    }

    public AbstractPreferencesPanel getWizardPanel()
    {
	return null;
    }
    
    public JComponent getStatusPanel()
    {
	return statusPanel;
    }
}
