/*
 *  Java Napster version x.yz (for current version number as well as for
 *  additional information see version.txt)
 *
 *  Previous versions of this program were written by Florian Student
 *  and Michael Ransburg available at www.weblicity.de/jnapster and
 *  http://www.tux.org/~daneel/content/projects/10.shtml respectively.
 *
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package xnap.plugin.gift.net;

import xnap.net.AbstractCommunication;

import xnap.plugin.gift.net.lexer.Command;
import xnap.plugin.gift.net.lexer.StreamLexer;

import xnap.util.Debug;
import xnap.util.SearchManager;

import java.io.BufferedReader;
import java.io.IOException;

import java.net.Socket;

import java.util.Enumeration;
import java.util.Vector;


public class Stats extends AbstractCommunication {
    //--- Constant(s) ---
    public static final int STATUS_NOT_STARTED = 0;
    public static final int STATUS_CONNECTED = 1;
    public static final int STATUS_FAILED = 2;
    public static final int STATUS_FINISHED = 3;
    private static String[] STATUS_MSGS = { "", "Connected", "Failed", "Finished" };

    //--- Data field(s) ---
    private Socket socket;
    private BufferedReader in;
    private String host;
    private int port;
    private StreamLexer lexer;

    //--- Constructor(s) ---
    public Stats(String host, int port) {
        this.host = host;
        this.port = port;
    }

    // --- Method(s) ---
    protected String getStatusMsg(int index) {
        return STATUS_MSGS[index];
    }

    public void connect() {
        System.out.println("connect");

        try {
            socket = new Socket(host, port);
        } catch (IOException e) {
            setStatus(STATUS_FAILED, "giFT daemon not running");

            return;
        }

        setStatus(STATUS_CONNECTED);
        //SearchManager.getInstance().availability(1);

        try {
            lexer = new StreamLexer(socket.getInputStream());
        	//socket.getOutputStream().write(ProtocolHelper.getStats());
            socket.getOutputStream().write(ProtocolHelper.getStats());

            // read giFT version
            //  in.readLine();
        } catch (IOException e) {
            Debug.log("giFT IO Error: " + e);
            setStatus(STATUS_FAILED);
        }
    }

    public Vector getResults() {
        Vector data = new Vector();
        Command command = null;
        long timeout = -1; //-1 to disable
        try {
            while (((command = lexer.parse()) == null) || (--timeout == 0)) {
            }

            if (command == null) {
                setStatus(STATUS_FAILED);
            }
        } catch (IOException e) {
            setStatus(STATUS_FAILED);
        }

        if (status == STATUS_FAILED) {
            return null;
        }

        Debug.log("giFT result: " + command);
        System.out.println("result " + command);

/*        Enumeration subCommands = command.getSubCommands();

        while (subCommands.hasMoreElements()) {
            Command proto = command.getSubCommand((String) subCommands.nextElement());
            
            String size = proto.getKey("size") + " "+proto.getKeyModifier("size");

            long count = -1;
            long users = -1;

            try {
                count = Long.parseLong((String) proto.getKey("files"));
            } catch (NumberFormatException e) {
            }

            try {
                users = Long.parseLong((String) proto.getKey("users"));
            } catch (NumberFormatException e) {
            }

            Object[] o = {
                new String(proto.getCommand()), new Long(count), size,
                new Long(users)
            };
            data.add(o);
        }*/

        setStatus(STATUS_FINISHED, "connected");

        return data;
    }

    public void close() {
        System.out.println("close");

        try {
            socket.close();
        } catch (IOException e) {
        }
    }
}
